﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#ifndef MALLOC_TEST_HELPER_FUNCS
#define MALLOC_TEST_HELPER_FUNCS 1

#include <stdint.h>

void print_malloc_info();

// Recursively print the binary version of an integer number
void print_binary(int number);
void print_binary_uint64(uint64_t number);

void print_ptr_info(char* allocated_mem_ptr);
//void print_chunk_info(struct chunk* chunk_ptr);
void print_chunk_info(void* void_chunk_ptr, bool print_minimum);

// Call this to easily check if 'ptr' is null and display an error if it is.
// Returns true if 'ptr' is null, returns false if 'ptr' is *not* null
bool null_ptr_error(void* ptr, const char* ptr_var_name,
                    const char* filename, int line_num);
#define ERROR_IF_NULL(ptr, ptr_name) \
    (null_ptr_error(ptr, ptr_name, __FILE__, __LINE__))

// Freelist functions
int num_freelist_chunks();
bool is_ptr_in_freelist(struct chunk* chunk_to_find);
void walk_free_list();

#endif // MALLOC_TEST_HELPER_FUNCS
