﻿/*******************************************************************************

  This file contains a series of tests for fopen()

*******************************************************************************/

#include "ntd_extended_test.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>  // for definition of mkdir


static void test_pread()
{
    FILE *file;
    unsigned int buffer_size=17;
    char *pread_buffer = malloc(sizeof(char)*buffer_size);
    const char *filename;
    size_t count;
    int result;
    filename = HOST_FILENAME("pread.c_test.txt");

    DELETE_IF_EXISTS(filename);

    file = FOPEN_TEST(filename, "w");
    count = fwrite("abcdefghijklmnop\0", sizeof(char), buffer_size, file);
    TESTCASE_MESSAGE(count == 17, "fwrite(\"abcdefghijklmnop\", 1, 17, file) failed count = %d", count);
    result = fclose(file);
    TESTCASE_MESSAGE(result == 0, "fclose(%x) failed result = %d", file, result);

    file = FOPEN_TEST(filename, "r");
    if (file) {

        result = pread(fileno(file), pread_buffer, 17, 0);
        TESTCASE_MESSAGE(result == 17, "pread( fd, pread_buffer, 17, 0) failed result = %d", result);
        TESTCASE_STRINGS_MATCH(pread_buffer, "abcdefghijklmnop");
        memset(pread_buffer, '\0', buffer_size);

        result = pread(fileno(file), pread_buffer, 15, 2);
        TESTCASE_MESSAGE(result == 15, "pread( fd, pread_buffer, 15, 2) failed result = %d", result);
        TESTCASE_STRINGS_MATCH(pread_buffer, "cdefghijklmnop");
        memset(pread_buffer, '\0', buffer_size);

        result = pread(fileno(file), pread_buffer, 17, 0);
        TESTCASE_MESSAGE(result == 17, "pread( fd, pread_buffer, 16, 0) failed result = %d", result);
        TESTCASE_STRINGS_MATCH(pread_buffer, "abcdefghijklmnop");
        memset(pread_buffer, '\0', buffer_size);

        result = pread(fileno(file), pread_buffer, 7, 10);
        TESTCASE_MESSAGE(result == 7, "pread( fd, pread_buffer, 16, 0) failed result = %d", result);
        TESTCASE_STRINGS_MATCH(pread_buffer, "klmnop");
        memset(pread_buffer, '\0', buffer_size);

        result = pread(fileno(file), pread_buffer, 2, 15);
        TESTCASE_MESSAGE(result == 2, "pread( fd, pread_buffer, 16, 0) failed result = %d", result);
        TESTCASE_STRINGS_MATCH(pread_buffer, "p");
        memset(pread_buffer, '\0', buffer_size);

        result = pread(fileno(file), pread_buffer, 17, 0);
        TESTCASE_MESSAGE(result == 17, "pread( fd, pread_buffer, 16, 0) failed result = %d", result);
        TESTCASE_STRINGS_MATCH(pread_buffer, "abcdefghijklmnop");
        memset(pread_buffer, '\0', buffer_size);

        result = pread(fileno(file), pread_buffer, 1, 18);
        TESTCASE_MESSAGE(result == 0, "pread( fd, pread_buffer, 16, 0) failed result = %d", result);
        memset(pread_buffer, '\0', buffer_size);

        result = pread(fileno(file), pread_buffer, 15, 2);
        TESTCASE_MESSAGE(result == 15, "pread( fd, pread_buffer, 16, 0) failed result = %d", result);
        TESTCASE_STRINGS_MATCH(pread_buffer, "cdefghijklmnop");
        memset(pread_buffer, '\0', buffer_size);

        result = pread(fileno(file), pread_buffer, 17, 0);
        TESTCASE_MESSAGE(result == 17, "pread( fd, pread_buffer, 16, 0) failed result = %d", result);
        TESTCASE_STRINGS_MATCH(pread_buffer, "abcdefghijklmnop");
        memset(pread_buffer, '\0', buffer_size);

        free(pread_buffer);
        result = FCLOSE_DELETE_TEST(file, filename);
    }
}


static void test_pwrite()
{
    FILE *file;
    const char *filename = HOST_FILENAME("pwrite.c_test.txt");
    char *fread_buffer;
    size_t pwrite_ret_val;
    int result;

    CREATE_FILE_TEST(filename, "test_pwrite\n");

    file = FOPEN_TEST(filename, "w");
    pwrite_ret_val = pwrite(fileno(file), "1234567890\0", 11, 0);
    TESTCASE_MESSAGE(pwrite_ret_val == 11, "pwrite(fd,\"1234567890\", 11, 0) returned %d\n", pwrite_ret_val);
    FCLOSE_TEST(file, filename);
    file = FOPEN_TEST(filename, "r");
    FREAD_FILE_TEST(&fread_buffer, file);
    TESTCASE_STRINGS_MATCH(fread_buffer, "1234567890");
    FCLOSE_TEST(file, filename);
    free(fread_buffer);

    file = FOPEN_TEST(filename, "w");
    pwrite_ret_val = pwrite(fileno(file), "1234567890\0", 11, 0);
    TESTCASE_MESSAGE(pwrite_ret_val == 11, "pwrite(fd,\"1234567890\", 11, 0) returned %d\n", pwrite_ret_val);
    pwrite_ret_val = pwrite(fileno(file), "3333\0", 4, 2);
    TESTCASE_MESSAGE(pwrite_ret_val == 4, "pwrite(fd,\"3333\", 4, 2) returned %d\n", pwrite_ret_val);
    FCLOSE_TEST(file, filename);
    file = FOPEN_TEST(filename, "r");
    FREAD_FILE_TEST(&fread_buffer, file);
    TESTCASE_STRINGS_MATCH(fread_buffer, "1233337890");
    FCLOSE_TEST(file, filename);
    free(fread_buffer);

    file = FOPEN_TEST(filename, "w");
    pwrite_ret_val = pwrite(fileno(file), "1234567890\0", 11, 0);
    TESTCASE_MESSAGE(pwrite_ret_val == 11, "pwrite(fd,\"1234567890\", 11, 0) returned %d\n", pwrite_ret_val);
    pwrite_ret_val = pwrite(fileno(file), "3333\0", 4, 2);
    TESTCASE_MESSAGE(pwrite_ret_val == 4, "pwrite(fd,\"3333\", 4, 2) returned %d\n", pwrite_ret_val);
    pwrite_ret_val = pwrite(fileno(file), "abc\0", 3, 6);
    TESTCASE_MESSAGE(pwrite_ret_val == 3, "pwrite(fd,\"abc\", 3, 6) returned %d\n", pwrite_ret_val);
    FCLOSE_TEST(file, filename);
    file = FOPEN_TEST(filename, "r");
    FREAD_FILE_TEST(&fread_buffer, file);
    TESTCASE_STRINGS_MATCH(fread_buffer, "123333abc0");
    FCLOSE_TEST(file, filename);
    free(fread_buffer);

    file = FOPEN_TEST(filename, "w");
    pwrite_ret_val = pwrite(fileno(file), "1234567890\0", 11, 0);
    TESTCASE_MESSAGE(pwrite_ret_val == 11, "pwrite(fd,\"1234567890\", 11, 0) returned %d\n", pwrite_ret_val);
    pwrite_ret_val = pwrite(fileno(file), "3333\0", 4, 2);
    TESTCASE_MESSAGE(pwrite_ret_val == 4, "pwrite(fd,\"3333\", 4, 2) returned %d\n", pwrite_ret_val);
    pwrite_ret_val = pwrite(fileno(file), "abc\0", 3, 6);
    TESTCASE_MESSAGE(pwrite_ret_val == 3, "pwrite(fd,\"abc\", 3, 6) returned %d\n", pwrite_ret_val);
    pwrite_ret_val = pwrite(fileno(file), "1234567890\0", 11, 0);
    TESTCASE_MESSAGE(pwrite_ret_val == 11, "pwrite(fd,\"1234567890\", 11, 0) returned %d\n", pwrite_ret_val);
    FCLOSE_TEST(file, filename);
    file = FOPEN_TEST(filename, "r");
    FREAD_FILE_TEST(&fread_buffer, file);
    TESTCASE_STRINGS_MATCH(fread_buffer, "1234567890");
    free(fread_buffer);

    FCLOSE_DELETE_TEST(file, filename);
}

int ntd_extended_pread(void)
{
    FILE *file;
    #if __NX__
    const char *filename = HOST_FILENAME("pread_file.txt");
    #else
    const char *filename = "pread_file.txt";
    #endif

    NTD_TEST_GROUP_START("pread", 2);

    file = fopen(filename, "w");

    if (file != NULL) {

        test_pread();
        test_pwrite();
        FCLOSE_DELETE_TEST(file, filename);
    }

    return NTD_TEST_GROUP_END("pread", 2);
}
