﻿#include "ntd-test-libc.h"
#include <stdint.h>
#include <stdio.h>
#include "mtest.h"

static struct l_l t[] = {
#if LDBL_MANT_DIG == 53
#include "crlibm/log1p.h"
#include "sanity/log1p.h"
#include "special/log1p.h"
/* use checkexceptall to match the behavior of log1p */
#define CHECKEXCEPT(e1, e2, r) t_checkexceptall(e1, e2, r)
#define ESTRS_CUSTOM(e,p) ESTRS_ALL(e,p)

#elif LDBL_MANT_DIG == 64
#include "sanity/log1pl.h"
#include "special/log1pl.h"
#define CHECKEXCEPT(e1, e2, r) t_checkexcept(e1, e2, r)
#define ESTRS_CUSTOM(e,p) ESTRS(e,p)

#else
/* no tests for 128-bit long double? */
#define CHECKEXCEPT(e1, e2, r) t_checkexcept(e1, e2, r)
#define ESTRS_CUSTOM(e,p) ESTRS(e,p)

#endif
};

int testlog1pl(void)
{
    #pragma STDC FENV_ACCESS ON
    long double y;
    float d;
    int e, i, err = 0;
    struct l_l *p;

    for (i = 0; i < sizeof t/sizeof *t; i++) {
        p = t + i;

        if (p->r < 0)
            continue;
        fesetround(p->r);
        feclearexcept(FE_ALL_EXCEPT);
        y = log1pl(p->x);
        e = fetestexcept(INEXACT|INVALID|DIVBYZERO|UNDERFLOW|OVERFLOW);

        int passed = CHECKEXCEPT(e, p->e, p->r);
        char *msg = NULL;
        asprintf(&msg,"bad fp exception: %s log1pl(%La)=%La, %s",
            rstr(p->r), p->x, p->y, ESTRS_CUSTOM(e,p));
        if (p->expect_failure) {
            NTD_TESTCASE_KNOWN_FAILURE(p->fail_msg, passed, p->file, p->line, msg);
        } else {
            if (!passed) err++;
            NTD_TESTCASE(passed, p->file, p->line, msg);
        }
        free(msg);
        d = ulperrl(y, p->y, p->dy);
        if (!checkulp(d, p->r)) {
            printf("%s:%d: %s log1pl(%La) want %La got %La ulperr %.3f = %a + %a\n",
                short_path(p->file), p->line, rstr(p->r), p->x, p->y, y, d, d-p->dy, p->dy);
            err++;
        }
    }
    return !!err;
}
