﻿// cos.testdata
// copyright (C) 2005 Ch. Q. Lauter, F. de Dinechin and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RN,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RU,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RU,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RD,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RD,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RZ,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RZ,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RN,               0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm positive
T(RN,              -0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm negative
T(RU,               0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm positive
T(RU,              -0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm negative
T(RD,               0x1p-1074,    0x1.fffffffffffffp-1,         -0x1p+0, INEXACT) // smallest denorm positive
T(RD,              -0x1p-1074,    0x1.fffffffffffffp-1,         -0x1p+0, INEXACT) // smallest denorm negative
T(RZ,               0x1p-1074,    0x1.fffffffffffffp-1,         -0x1p+0, INEXACT) // smallest denorm positive
T(RZ,              -0x1p-1074,    0x1.fffffffffffffp-1,         -0x1p+0, INEXACT) // smallest denorm negative
T(RN,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RN,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RU,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RU,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RD,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RD,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RZ,                     inf,                     nan,          0x0p+0, INVALID) // +inf
T(RZ,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
// Various bad cases either provided by Evgeny Gvozdev, or found during debugging
T(RD,    0x1.921fb54c42d18p+2,    0x1.fffffffffffffp-1,       -0x1.8p-1, INEXACT)
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RN,    0x1.7ab1847e2d065p-1,    0x1.7a38c00984008p-1,          0x1p-1, INEXACT) // 7.396356014273918200174762205279e-01
T(RZ,    0x1.a321dc823bc29p-1,    0x1.5dd07b09b8937p-1,         -0x1p+0, INEXACT) // 8.186177166916240866001430731558e-01
T(RZ,    0x1.be14312af321bp-1,     0x1.49a9a1c19cb1p-1, -0x1.d60b08p-51, INEXACT) // 8.712478032044289610880127838755e-01
T(RN,    0x1.ec7ae5cb5c876p-1,    0x1.24daf0cbbde6fp-1,         -0x1p-1, INEXACT) // 9.618751345390268436830183418351e-01
T(RZ,   0x1.35a49e8e83c61p-10,    0x1.ffffe8979323ap-1,         -0x1p+0, INEXACT) // 1.181194474728440796731931961006e-03
T(RZ,   0x1.3ee7fa9e7d93ep-10,    0x1.ffffe72bade5dp-1,         -0x1p+0, INEXACT) // 1.216530486656333242406757833010e-03
T(RZ,   0x1.407b2bb6875aap-10,    0x1.ffffe6ecbdabbp-1,  -0x1.4879bp-51, INEXACT) // 1.222538512258489976775033269973e-03
T(RN,   0x1.6a4c38abdcbacp-10,    0x1.ffffdff445e62p-1,          0x1p-1, INEXACT) // 1.382056197112939248394791746932e-03
T(RN,   0x1.6ea868bda0dbcp-10,    0x1.ffffdf2da0b55p-1,          0x1p-1, INEXACT) // 1.398688691012547023750922647878e-03
T(RZ,   0x1.e3249e85ed948p-10,    0x1.ffffc702cdd7fp-1,         -0x1p+0, INEXACT) // 1.843044448361990175766500499321e-03
T(RZ,    0x1.09e76d0393f4p-11,    0x1.fffffbaf3c3dep-1,         -0x1p+0, INEXACT) // 5.071716445374865878115144823823e-04
T(RN,   0x1.2312bee38106dp-11,    0x1.fffffad43184ep-1,          0x1p-1, INEXACT) // 5.551781181911803969911134437609e-04
T(RN,    0x1.402e502aeacbp-12,    0x1.fffffe6f8c2f6p-1,         -0x1p-1, INEXACT) // 3.053483111965056215342251277889e-04
T(RZ,   0x1.be82a2af95bb1p-12,    0x1.fffffcf5348f4p-1, -0x1.ecc5d4p-52, INEXACT) // 4.258254002470997418884623986202e-04
T(RZ,   0x1.ff6bd2afd78a4p-12,    0x1.fffffc025060cp-1,         -0x1p+0, INEXACT) // 4.877292476431849353041281247556e-04
T(RN,   0x1.9c7325a9582b2p-13,    0x1.ffffff59df4adp-1,          0x1p-1, INEXACT) // 1.966713873953383436878061818476e-04
T(RN,   0x1.347167982efaap-14,    0x1.ffffffe8c5eecp-1,         -0x1p-1, INEXACT) // 7.353853868868770481993790699704e-05
T(RN,   0x1.e85412599a00ep-14,    0x1.ffffffc5c7f5ep-1,         -0x1p-1, INEXACT) // 1.164265644547637045241178510580e-04
T(RZ,   0x1.59dd111c289acp-14,    0x1.ffffffe2cba68p-1,         -0x1p+0, INEXACT) // 8.246029432482673794321814675357e-05
T(RZ,   0x1.88b1cbeef002fp-14,    0x1.ffffffda59f03p-1,         -0x1p+0, INEXACT) // 9.362566900872401479734991047721e-05
T(RZ,   0x1.a13d0112ffd7fp-14,    0x1.ffffffd57f833p-1,         -0x1p+0, INEXACT) // 9.947736207037946620009710718691e-05
T(RZ,    0x1.21c16dc65a4fp-15,    0x1.fffffffae026cp-1,         -0x1p+0, INEXACT) // 3.454155698785234523268128370432e-05
T(RN,   0x1.34363b3a0a6e9p-15,    0x1.fffffffa33b5dp-1,         -0x1p-1, INEXACT) // 3.674171462393438183273788877337e-05
T(RN,   0x1.30b781e0842ffp-16,    0x1.fffffffe954bap-1,         -0x1p-1, INEXACT) // 1.816253814196626758885842745084e-05
T(RN,   0x1.b6a903a100607p-16,    0x1.fffffffd10594p-1,          0x1p-1, INEXACT) // 2.614618609087483321030097316306e-05
T(RZ,   0x1.c4fe5706cc7b8p-16,    0x1.fffffffcde6cdp-1,         -0x1p+0, INEXACT) // 2.700051757215774536451113885249e-05
T(RZ,   0x1.cbae9d882ec5ap-16,    0x1.fffffffcc6946p-1, -0x1.92ff5ap-52, INEXACT) // 2.739918775838640036890750395493e-05
T(RZ,    0x1.2000000003ccp-17,       0x1.ffffffffafp-1,  -0x1.37642p-56, INEXACT) // 8.583068847682596112791397757746e-06
T(RZ,   0x1.3800000004d3dp-17,      0x1.ffffffffa0fp-1,  -0x1.f75c2p-56, INEXACT) // 9.298324584994434264932118561209e-06
T(RN,   0x1.48e6a8a73f91ep-17,     0x1.ffffffff965cp-1,         -0x1p-1, INEXACT) // 9.802013961831902878881969676250e-06
T(RN,   0x1.649cc398d94b9p-17,    0x1.ffffffff83cefp-1,          0x1p-1, INEXACT) // 1.062787650747198363321028430351e-05
T(RZ,   0x1.68000000076a7p-17,      0x1.ffffffff817p-1, -0x1.28f738p-54, INEXACT) // 1.072883605962176975154569874560e-05
T(RZ,   0x1.980000000acb9p-17,      0x1.ffffffff5d7p-1, -0x1.3aa568p-53, INEXACT) // 1.215934753425459401165748679619e-05
T(RZ,   0x1.abc4c4dfa860ep-17,    0x1.ffffffff4d4d7p-1,         -0x1p+0, INEXACT) // 1.274849859040068657234888449548e-05
T(RZ,   0x1.b00000000cd08p-17,      0x1.ffffffff49cp-1, -0x1.bb5e18p-53, INEXACT) // 1.287460327157329313067096743239e-05
T(RN,   0x1.bc26e050f58bap-17,    0x1.ffffffff3f5a5p-1,          0x1p-1, INEXACT) // 1.323675692958510154259750557504e-05
T(RZ,    0x1.e00000001194p-17,       0x1.ffffffff1fp-1, -0x1.a1231cp-52, INEXACT) // 1.430511474621572274440461924883e-05
T(RZ,   0x1.0c016ecd59cf6p-18,    0x1.ffffffffee76cp-1,         -0x1p+0, INEXACT) // 3.993594601104551370502303286880e-06
T(RN,   0x1.1aa629d3661f8p-18,    0x1.ffffffffec7eep-1,          0x1p-1, INEXACT) // 4.211799438457324875045156842290e-06
T(RZ,    0x1.2000000000f3p-18,      0x1.ffffffffebcp-1,    -0x1.376p-62, INEXACT) // 4.291534423831418264098924719718e-06
T(RN,   0x1.6d97e60102b3dp-18,    0x1.ffffffffdf5e6p-1,          0x1p-1, INEXACT) // 5.447765489395234280508174135038e-06
T(RZ,   0x1.8a3c15689adbep-18,    0x1.ffffffffda0e2p-1,         -0x1p+0, INEXACT) // 5.874554837785799256129164180873e-06
T(RZ,   0x1.a7e2693b54bb2p-18,    0x1.ffffffffd4221p-1,         -0x1p+0, INEXACT) // 6.316370043296420090065020069847e-06
T(RN,   0x1.b94c74703d951p-18,    0x1.ffffffffd0748p-1,          0x1p-1, INEXACT) // 6.575862343752230788180516279917e-06
T(RN,   0x1.e3fc2a4c86766p-18,    0x1.ffffffffc6cffp-1,          0x1p-1, INEXACT) // 7.211938804841050440290993461812e-06
T(RZ,   0x1.18b4ccf0fd0a5p-19,    0x1.fffffffffb30cp-1,         -0x1p+0, INEXACT) // 2.091424555756144434975766013829e-06
T(RN,   0x1.38a17a50ca203p-19,    0x1.fffffffffa08dp-1,         -0x1p-1, INEXACT) // 2.329280768615739579573608794560e-06
T(RN,   0x1.e5e52205d72fcp-19,     0x1.fffffffff197p-1,         -0x1p-1, INEXACT) // 3.620200234628866356868630294041e-06
T(RN,   0x1.42550643e9932p-19,    0x1.fffffffff9a89p-1,         -0x1p-1, INEXACT) // 2.401561490078485938389016990380e-06
T(RZ,    0x1.1e0d7f3a1c0cbp-2,    0x1.ec27091e2fc1fp-1,         -0x1p+0, INEXACT) // 2.793483618943468083095638121449e-01
T(RZ,   0x1.0b4859e99cd17p-20,    0x1.fffffffffee8fp-1, -0x1.404f18p-53, INEXACT) // 9.957053585224630604409495546192e-07
T(RN,   0x1.150e52ce7b42fp-20,    0x1.fffffffffed42p-1,         -0x1p-1, INEXACT) // 1.032113846495594818895662724001e-06
T(RZ,   0x1.836185e74727ap-20,    0x1.fffffffffdb5cp-1,         -0x1p+0, INEXACT) // 1.443106492810641490080270435414e-06
T(RZ,   0x1.27e451bb94505p-21,    0x1.ffffffffffaa8p-1, -0x1.2a878ap-52, INEXACT) // 5.511415603431213918180311440997e-07
T(RZ,   0x1.458d455549c72p-21,    0x1.ffffffffff987p-1,         -0x1p+0, INEXACT) // 6.063875540905033397067825165494e-07
T(RN,   0x1.51c1df061030bp-21,    0x1.ffffffffff909p-1,         -0x1p-1, INEXACT) // 6.291220138247280893364888308683e-07
T(RN,   0x1.5e5c1cd6c4e6fp-22,    0x1.ffffffffffe21p-1,          0x1p-1, INEXACT) // 3.262980049916846440382701185351e-07
T(RN,   0x1.226f24f6b2a4ap-22,    0x1.ffffffffffeb7p-1,          0x1p-1, INEXACT) // 2.704878875713259399698692488079e-07
T(RZ,   0x1.83a63a3bad1c4p-22,    0x1.ffffffffffdb5p-1, -0x1.224204p-51, INEXACT) // 3.610265684004361381060363780926e-07
T(RZ,   0x1.38b79579d3ebep-22,    0x1.ffffffffffe82p-1, -0x1.03f168p-51, INEXACT) // 2.912405175818820700012266693146e-07
T(RZ,   0x1.f5e67fdcbdf94p-22,    0x1.ffffffffffc27p-1,         -0x1p+0, INEXACT) // 4.674311620401818969202560952181e-07
T(RZ,   0x1.aed02cdd310a3p-22,    0x1.ffffffffffd2ap-1,         -0x1p+0, INEXACT) // 4.012260442327365394473467474085e-07
T(RZ,   0x1.8000000000024p-22,     0x1.ffffffffffdcp-1,          0x0p+0, INEXACT) // 3.576278686523456558241313221758e-07
T(RN,   0x1.08d8dd3b1d9adp-23,    0x1.fffffffffffbcp-1,          0x1p-1, INEXACT) // 1.233290535006438121490773352287e-07
T(RZ,   0x1.58a68a4a8d9f5p-24,    0x1.fffffffffffe2p-1,         -0x1p+0, INEXACT) // 8.024520884654679172876711639242e-08
T(RZ,   0x1.6a09e667f3bcdp-25,    0x1.ffffffffffff8p-1,  -0x1.a1659p-54, INEXACT) // 4.214684851089403466804688747939e-08
T(RN,   0x1.8a85c24f7065ap-25,    0x1.ffffffffffff7p-1,          0x1p-1, INEXACT) // 4.592846336192620472798129162631e-08
T(RN,    0x1.7efa9b716ba22p-3,    0x1.f712e83ee2341p-1,          0x1p-1, INEXACT) // 1.870014327991649794036277398845e-01
T(RN,     0x1.c41fbfbfb58cp-3,    0x1.f392f2f14fe8ap-1,         -0x1p-1, INEXACT) // 2.207636814479823073043007752858e-01
T(RZ,    0x1.dbfbe258b6554p-3,    0x1.f23be534ba3e8p-1, -0x1.86f804p-51, INEXACT) // 2.324140246699167855481960032193e-01
T(RZ,    0x1.e6ab2bfa47082p-3,    0x1.f19ca8485a48bp-1,         -0x1p+0, INEXACT) // 2.376311717752095931111000481906e-01
T(RN,    0x1.f3db49626230bp-3,    0x1.f0d355147c9c7p-1,          0x1p-1, INEXACT) // 2.440705998563078293894790249396e-01
T(RN,    0x1.270df70e010f7p-4,    0x1.feac1473536efp-1,          0x1p-1, INEXACT) // 7.203480249160408577235870097866e-02
T(RZ,    0x1.537ddbb22c2c8p-4,    0x1.fe3e0b6565725p-1,         -0x1p+0, INEXACT) // 8.288369959587804647327402562951e-02
T(RZ,    0x1.da9043ddcd3cbp-4,    0x1.fc914144152e7p-1,         -0x1p+0, INEXACT) // 1.158602381736521386157434676534e-01
T(RN,    0x1.47712d7f8ed7ep-5,    0x1.ff974efc7c51bp-1,         -0x1p-1, INEXACT) // 3.997095953351513519802296059424e-02
T(RN,    0x1.746e7f6dcc3b2p-5,     0x1.ff7891a460a7p-1,          0x1p-1, INEXACT) // 4.546284569222026894497190596667e-02
T(RN,    0x1.83f386688e80ap-5,    0x1.ff6d0c7c15d14p-1,          0x1p-1, INEXACT) // 4.735733272214311118109009157706e-02
T(RN,    0x1.d8841807373cdp-5,    0x1.ff2605a21996bp-1,         -0x1p-1, INEXACT) // 5.768017476086804290469345346537e-02
T(RN,    0x1.fcbf79e95562cp-5,    0x1.ff0352ac72d04p-1,         -0x1p-1, INEXACT) // 6.210302172500478667949153077643e-02
T(RZ,    0x1.f70ad89ccacf9p-5,    0x1.ff08f4f87ec0ap-1, -0x1.82856ap-52, INEXACT) // 6.140653903124788232092967632525e-02
T(RZ,    0x1.46ead4473a3b4p-6,      0x1.ffe5e889fb1p-1, -0x1.e95c6cp-51, INEXACT) // 1.995344858451959801914910030973e-02
T(RZ,    0x1.20f7532e0b167p-6,    0x1.ffeb9d4c004e8p-1,         -0x1p+0, INEXACT) // 1.763709185631636908175856603975e-02
T(RZ,    0x1.97ccd3d2c438fp-6,    0x1.ffd766ba870a8p-1,         -0x1p+0, INEXACT) // 2.489014325971400029557933919477e-02
T(RN,    0x1.674e568fe6b7fp-6,    0x1.ffe07b85dcd77p-1,          0x1p-1, INEXACT) // 2.193029836017101538714335617897e-02
T(RN,    0x1.d52bda7ff9918p-6,    0x1.ffca435548761p-1,          0x1p-1, INEXACT) // 2.863594377404252155905339805031e-02
T(RZ,    0x1.e317f35d42416p-6,    0x1.ffc706d85e0aep-1, -0x1.4b1a5ep-52, INEXACT) // 2.948569074672854201102367710519e-02
T(RN,    0x1.f849414ea93b6p-6,    0x1.ffc1eb38d4d06p-1,          0x1p-1, INEXACT) // 3.077918412840904144323062041622e-02
T(RZ,    0x1.0709306843987p-7,    0x1.fffbc6f1f5441p-1,         -0x1p+0, INEXACT) // 8.027218471877940395020623043365e-03
T(RN,    0x1.0066bbcf2cf68p-7,    0x1.fffbfccad4182p-1,         -0x1p-1, INEXACT) // 7.824746803045193321857198043290e-03
T(RZ,    0x1.76937c1e708e6p-7,    0x1.fff76fb90dfebp-1, -0x1.cd5f8cp-52, INEXACT) // 1.143115578168303267392325039964e-02
T(RN,    0x1.92e4fbb59f545p-7,    0x1.fff617b860a78p-1,          0x1p-1, INEXACT) // 1.229536333561987750118138507105e-02
T(RN,    0x1.f8e9aa64e5dbfp-7,    0x1.fff070b09c4c3p-1,         -0x1p-1, INEXACT) // 1.540871448541636205831206751782e-02
T(RN,    0x1.8367c95eea78cp-8,    0x1.fffdb5bd7af94p-1,          0x1p-1, INEXACT) // 5.911337530884252372542775333386e-03
T(RZ,    0x1.9e3cd27d785edp-8,    0x1.fffd61b7cafedp-1,         -0x1p+0, INEXACT) // 6.320763959111169900950688571584e-03
T(RZ,    0x1.b71f0304dd6e3p-8,    0x1.fffd0ec558935p-1,         -0x1p+0, INEXACT) // 6.700456845342125759834583931251e-03
T(RN,    0x1.0bd74777db82bp-9,    0x1.ffffb9f15091cp-1,          0x1p-1, INEXACT) // 2.043464159149817934574278055493e-03
T(RZ,    0x1.444111b54c1fdp-9,    0x1.ffff9952d2174p-1,         -0x1p+0, INEXACT) // 2.473863040585165627011088318454e-03
T(RZ,    0x1.d91f204aae981p-9,    0x1.ffff25670d46ep-1, -0x1.87009cp-52, INEXACT) // 3.609631244527012217809813776626e-03
T(RN,    0x1.ea37742cba939p-9,    0x1.ffff1551fcbdfp-1,         -0x1p-1, INEXACT) // 3.740055972561464898290539693448e-03
T(RZ,    0x1.ca5da9bcfecfdp-9,    0x1.ffff32d33c4ccp-1,         -0x1p+0, INEXACT) // 3.497054071429083008798466281064e-03
T(RZ,    0x1.2cc8b29df4504p+0,    0x1.8adaf19d8d783p-2, -0x1.106facp-52, INEXACT) // 1.174937404215882885694099968532e+00
T(RN,    0x1.3aca9ac4d718dp+0,    0x1.5697e515c2dc5p-2,          0x1p-1, INEXACT) // 1.229654000336356078904032074206e+00
T(RZ,    0x1.91cd53c9bae94p+0,   0x1.4985e46fadf11p-10,         -0x1p+0, INEXACT) // 1.569539295912282916845015279250e+00
T(RZ,    0x1.91bc97a4f70e3p+0,   0x1.8c7673475c8e6p-10, -0x1.023798p-43, INEXACT) // 1.569283941054032238682225397497e+00
T(RZ,    0x1.91b7076d1bcd1p+0,   0x1.a2b750f0faf15p-10,  -0x1.59813p-44, INEXACT) // 1.569199051034775971302792640927e+00
T(RN,    0x1.91a8a158a03b6p+0,   0x1.dc4f9d5d4c1fep-10,         -0x1p-1, INEXACT) // 1.568979343545135574089499641559e+00
T(RZ,    0x1.91f17e2f3f6b3p+0,   0x1.71b8a619179ffp-11, -0x1.dcf54ep-41, INEXACT) // 1.570091139350023423659763466276e+00
T(RZ,    0x1.91ede62c9b993p+0,   0x1.8e78bab627239p-11, -0x1.242604p-40, INEXACT) // 1.570036302462175070715488800488e+00
T(RZ,    0x1.920d87452c177p+0,   0x1.22dff12d0ae5dp-12, -0x1.ab9b52p-39, INEXACT) // 1.570518926990272623456235123740e+00
T(RZ,    0x1.920af77282acdp+0,   0x1.4bdd1ba558258p-12, -0x1.6d1bf6p-42, INEXACT) // 1.570479836899426162588611077808e+00
T(RZ,    0x1.92002eb7bf957p+0,   0x1.f868c6ed610bap-12,  -0x1.ec69ap-40, INEXACT) // 1.570315284595911853315897133143e+00
T(RN,    0x1.92043c14deffap+0,   0x1.b792f5651cd78p-12,         -0x1p-1, INEXACT) // 1.570377116294365382742626024992e+00
T(RN,    0x1.92051947bf4afp+0,   0x1.a9bfc77426e71p-12,          0x1p-1, INEXACT) // 1.570390300766387303710303058324e+00
T(RN,    0x1.9204e7a19772ap+0,   0x1.acda29ed594dep-12,          0x1p-1, INEXACT) // 1.570387341452667673280529925250e+00
T(RN,    0x1.9200be1558a34p+0,   0x1.ef72ed6d9a17fp-12,         -0x1p-1, INEXACT) // 1.570323829852566355214094073744e+00
T(RZ,    0x1.9214efc8959fep+0,   0x1.58af758c2b495p-13,         -0x1p+0, INEXACT) // 1.570631967993562749796865318785e+00
T(RN,    0x1.921ac630beb67p+0,   0x1.3bc4e101c3f5ep-14,          0x1p-1, INEXACT) // 1.570721041584613564268124719092e+00
T(RN,    0x1.92198d6cecf01p+0,   0x1.89f5d56ea520ap-14,          0x1p-1, INEXACT) // 1.570702399342678967641973031277e+00
T(RN,    0x1.921d98d1f894ap+0,   0x1.0e39251da97bbp-15,         -0x1p-1, INEXACT) // 1.570764113676505591143950368860e+00
T(RZ,    0x1.921c1a5d7961bp+0,   0x1.cd7364b402a7bp-15,         -0x1p+0, INEXACT) // 1.570741317578159934598147629004e+00
T(RZ,    0x1.921e8a5657618p+0,   0x1.2aedeb6fc07aep-16,         -0x1p+0, INEXACT) // 1.570778509215761786776965891477e+00
T(RZ,    0x1.921e885775e93p+0,   0x1.2ceccce80f1c5p-16, -0x1.e69cdap-36, INEXACT) // 1.570778390267069779540065610490e+00
T(RN,    0x1.921df05ebaa4dp+0,   0x1.c4e5882bc82a6p-16,          0x1p-1, INEXACT) // 1.570769332053390643366697076999e+00
T(RN,      0x1.921f1dd8244p+0,   0x1.2ed83d22f72a5p-17,         -0x1p-1, INEXACT) // 1.570787301320024198503233492374e+00
T(RZ,    0x1.921eba69d4d32p+0,    0x1.f5b4dbfc7889p-17, -0x1.818f6ap-34, INEXACT) // 1.570781374776583749763858577353e+00
T(RZ,    0x1.921f659344a13p+0,   0x1.3ec3f8c14c802p-18,         -0x1p+0, INEXACT) // 1.570791576818582724328621225141e+00
T(RN,    0x1.921f6683ed63bp+0,   0x1.3b0155b74cae5p-18,          0x1p-1, INEXACT) // 1.570791632851423313965710804041e+00
T(RN,    0x1.921f443fe706cp+0,   0x1.c4116f2b02f6fp-18,          0x1p-1, INEXACT) // 1.570789590455230033683164947433e+00
T(RN,    0x1.921f553a4a418p+0,   0x1.8027e24008a35p-18,         -0x1p-1, INEXACT) // 1.570790602427456050804721598979e+00
T(RN,    0x1.921f90f808b59p+0,   0x1.2261d0dfa2534p-19,          0x1p-1, INEXACT) // 1.570794163279705779601158610603e+00
T(RN,    0x1.921f7fd4f3035p+0,   0x1.ab7a7e71a031bp-19,          0x1p-1, INEXACT) // 1.570793141831939410124618916598e+00
T(RZ,    0x1.921f7e878ae7ap+0,   0x1.b5e5bf4f1ff61p-19,         -0x1p+0, INEXACT) // 1.570793064204649258641666165204e+00
T(RZ,    0x1.921fa3c8beacap+0,   0x1.17b8424e4660fp-20, -0x1.a3bd0cp-33, INEXACT) // 1.570795284757581899981460082927e+00
T(RZ,    0x1.921f9f478f5e8p+0,   0x1.5fcb37304629ep-20, -0x1.73a1e2p-31, INEXACT) // 1.570795016260825960330294037703e+00
T(RN,    0x1.921f985c8f828p+0,    0x1.ce7b34f0459dp-20,         -0x1p-1, INEXACT) // 1.570794603917883947019618062768e+00
T(RZ,    0x1.921f9bc9c98fap+0,   0x1.97a7941e45ec5p-20, -0x1.b641cep-31, INEXACT) // 1.570794808163155753533146707923e+00
T(RN,    0x1.921f987bf24f9p+0,   0x1.cc85081f45a03p-20,         -0x1p-1, INEXACT) // 1.570794611225492909412082553899e+00
T(RZ,    0x1.921f970a5bf1cp+0,   0x1.e39e6dfc4578ep-20,         -0x1p+0, INEXACT) // 1.570794525174227906916257779812e+00
T(RZ,    0x1.921fad0c156b7p+0,   0x1.0705acc28d259p-21,         -0x1p+0, INEXACT) // 1.570795836877932449837658168690e+00
T(RZ,    0x1.921fab5451c89p+0,   0x1.3dfe211e8d1ccp-21, -0x1.4b6b6ap-32, INEXACT) // 1.570795734487349770702735440864e+00
T(RZ,    0x1.921fa6554a212p+0,   0x1.dddf160c8cebcp-21,         -0x1p+0, INEXACT) // 1.570795436689995216994475413230e+00
T(RN,    0x1.921fa76ea4be4p+0,    0x1.bab3c2688cfap-21,         -0x1p-1, INEXACT) // 1.570795502197818827028186206007e+00
T(RZ,    0x1.921fb0aedb52ep+0,   0x1.2559dfa91a5e5p-22,         -0x1p+0, INEXACT) // 1.570796053590423735357717305305e+00
T(RN,    0x1.921fad6c4e79ap+0,   0x1.f5fd15f91a4e4p-22,         -0x1p-1, INEXACT) // 1.570795859281565842735517435358e+00
T(RN,    0x1.921fb198c85a6p+0,   0x1.d5bd3b9234c0ap-23,         -0x1p-1, INEXACT) // 1.570796108055540596382115836604e+00
T(RZ,    0x1.921fb1766a171p+0,   0x1.e6ec5d3a34c02p-23,         -0x1p+0, INEXACT) // 1.570796100053567068144388940709e+00
T(RZ,    0x1.921fb1a9b7edep+0,   0x1.cd4571d234c0ep-23, -0x1.e00356p-28, INEXACT) // 1.570796111998724153835382821853e+00
T(RZ,    0x1.921fb499054c1p+0,    0x1.567b0ae8d313p-25, -0x1.865a74p-28, INEXACT) // 1.570796286924903251147611626948e+00
T(RZ,    0x1.921fb47ae0e5ap+0,   0x1.92c3d7c8d312ep-25,         -0x1p+0, INEXACT) // 1.570796279906878201160225216881e+00
T(RN,    0x1.921fb46eb3a6fp+0,   0x1.ab1e5528d312fp-25,   0x1.fffffep-2, INEXACT) // 1.570796277071760504995268092898e+00
T(RZ,    0x1.89ccbe0674699p+0,    0x1.0a52e3bba98acp-5, -0x1.43d964p-46, INEXACT) // 1.538280369354117604885345826915e+00
T(RZ,    0x1.88f40cb3236afp+0,    0x1.2565012b2f012p-5,         -0x1p+0, INEXACT) // 1.534973901495884751611242791114e+00
T(RN,    0x1.8847ac1e3f81bp+0,     0x1.3aed45b12a5bp-5,         -0x1p-1, INEXACT) // 1.532343633065017085570502786140e+00
T(RN,    0x1.87e58ed56fa1bp+0,    0x1.472e853800748p-5,         -0x1p-1, INEXACT) // 1.530846526249326045032717047434e+00
T(RN,    0x1.86e3d395f75fep+0,    0x1.675ead4bb44b8p-5,          0x1p-1, INEXACT) // 1.526913856613986819610317979823e+00
T(RN,    0x1.85fc23c095f2ep+0,    0x1.844cedb206922p-5,         -0x1p-1, INEXACT) // 1.523378595846178296113748729113e+00
T(RN,    0x1.861d6f90fe9e2p+0,    0x1.8024a2f57eed6p-5,          0x1p-1, INEXACT) // 1.523886654757568681617385664140e+00
T(RZ,    0x1.84cf37edbbc02p+0,    0x1.a9de804936403p-5, -0x1.788652p-49, INEXACT) // 1.518786902943020766798554177512e+00
T(RZ,    0x1.8ce548d46da0fp+0,    0x1.4e95279f75384p-6,         -0x1p+0, INEXACT) // 1.550373603689539470096292461676e+00
T(RN,    0x1.8bdf5b7c27853p+0,    0x1.900c4439907fbp-6,         -0x1p-1, INEXACT) // 1.546376912890555344048948427371e+00
T(RZ,    0x1.8ab621e9ad23dp+0,    0x1.da53deaa5d73dp-6,         -0x1p+0, INEXACT) // 1.541841620969662374207587163255e+00
T(RN,     0x1.8fb061c22c6cp+0,    0x1.37a88d177d453p-7,         -0x1p-1, INEXACT) // 1.561285123735089541696652304381e+00
T(RN,    0x1.8f53456ccfb1ap+0,    0x1.6636182131c56p-7,         -0x1p-1, INEXACT) // 1.559864367547282970605238006101e+00
T(RN,    0x1.8e2b3271b5fdfp+0,    0x1.fa3c416651dcep-7,         -0x1p-1, INEXACT) // 1.555346634637309710669228479674e+00
T(RN,    0x1.911c0c628eaf7p+0,     0x1.03a8b52e4e55p-8,         -0x1p-1, INEXACT) // 1.566834234296661909624504005478e+00
T(RZ,    0x1.91189d33cffadp+0,    0x1.0717e222c12d8p-8,         -0x1p+0, INEXACT) // 1.566781830930249030942036370107e+00
T(RZ,    0x1.90e24804d0ed1p+0,    0x1.3d6cee1b1b304p-8,         -0x1p+0, INEXACT) // 1.565952778983888515895728232863e+00
T(RZ,    0x1.9074a1733c4acp+0,    0x1.ab130aec8d018p-8,         -0x1p+0, INEXACT) // 1.564279642709418105539498355938e+00
T(RN,    0x1.906f4763e05c6p+0,    0x1.b06d12bdf8b0fp-8,         -0x1p-1, INEXACT) // 1.564197980770005269590683383285e+00
T(RN,    0x1.90673feba88e7p+0,    0x1.b8747f4a8c2cbp-8,          0x1p-1, INEXACT) // 1.564075465234560757821213883290e+00
T(RN,    0x1.90478d1364a7ap+0,    0x1.d827252e56e05p-8,         -0x1p-1, INEXACT) // 1.563591782793678053309349706979e+00
T(RN,    0x1.913876ea9b44bp+0,    0x1.ce7c746a4d26dp-9,         -0x1p-1, INEXACT) // 1.567267830159169816894859650347e+00
T(RN,    0x1.913a51d76485ap+0,    0x1.cac69c5834524p-9,          0x1p-1, INEXACT) // 1.567296137891864393765217755572e+00
// The following are Sun's value distributed with libmcr 0.9
T(RN, -0x1.d5e5bd8ca1e92p+400,    0x1.9016558d46e77p-1,  -0x1.ff9d74p-2, INEXACT)
T(RZ,  0x1.e24efc8420203p+477,   -0x1.1edf41cc6461bp-3,   0x1.ff9604p-1, INEXACT)
T(RU,  0x1.e24efc8420203p+477,   -0x1.1edf41cc6461bp-3,   0x1.ff9604p-1, INEXACT)
T(RD,  0x1.e24efc8420203p+477,   -0x1.1edf41cc6461cp-3, -0x1.a7ed44p-11, INEXACT)
T(RZ,  -0x1.0173ca751e69bp+67,    0x1.ecdc28e6d729dp-1,  -0x1.ffee8ep-1, INEXACT)
T(RD,  -0x1.0173ca751e69bp+67,    0x1.ecdc28e6d729dp-1,  -0x1.ffee8ep-1, INEXACT)
T(RU,  -0x1.0173ca751e69bp+67,    0x1.ecdc28e6d729ep-1,  0x1.1726a8p-13, INEXACT)
T(RZ,  0x1.97b0248843af2p+466,    0x1.1e6b4ac16e5e9p-1, -0x1.b2133ep-11, INEXACT)
T(RD,  0x1.97b0248843af2p+466,    0x1.1e6b4ac16e5e9p-1, -0x1.b2133ep-11, INEXACT)
T(RU,  0x1.97b0248843af2p+466,    0x1.1e6b4ac16e5eap-1,   0x1.ff937cp-1, INEXACT)
T(RZ, -0x1.7ac9fc489b335p+757,   -0x1.ffff4e55501acp-1,   0x1.fffd32p-1, INEXACT)
T(RU, -0x1.7ac9fc489b335p+757,   -0x1.ffff4e55501acp-1,   0x1.fffd32p-1, INEXACT)
T(RD, -0x1.7ac9fc489b335p+757,   -0x1.ffff4e55501adp-1, -0x1.675feep-16, INEXACT)
T(RZ,   -0x1.e2d0add5684ap+16,   -0x1.14f348fed47b6p-1,   0x1.ffb502p-1, INEXACT)
T(RU,   -0x1.e2d0add5684ap+16,   -0x1.14f348fed47b6p-1,   0x1.ffb502p-1, INEXACT)
T(RD,   -0x1.e2d0add5684ap+16,   -0x1.14f348fed47b7p-1, -0x1.2bfbf8p-11, INEXACT)
T(RN, -0x1.95719fa268ca4p+140,   -0x1.ffad6162dcfb8p-1,  -0x1.ff4eaep-2, INEXACT)
T(RN,  0x1.e69eaca271c97p+796,    0x1.128f6b1cb2f69p-1,  -0x1.ff5cd2p-2, INEXACT)
T(RZ, -0x1.300e16676983bp+542,   -0x1.e36c8cb47de6cp-1,  0x1.b2c2d8p-13, INEXACT)
T(RU, -0x1.300e16676983bp+542,   -0x1.e36c8cb47de6cp-1,  0x1.b2c2d8p-13, INEXACT)
T(RD, -0x1.300e16676983bp+542,   -0x1.e36c8cb47de6dp-1,  -0x1.ffe4d4p-1, INEXACT)
T(RZ,  0x1.f615f37dc0e05p+737,   -0x1.a17b456c2ce2bp-1,   0x1.ffd552p-1, INEXACT)
T(RU,  0x1.f615f37dc0e05p+737,   -0x1.a17b456c2ce2bp-1,   0x1.ffd552p-1, INEXACT)
T(RD,  0x1.f615f37dc0e05p+737,   -0x1.a17b456c2ce2cp-1, -0x1.5576f6p-12, INEXACT)
T(RZ,  0x1.99590b66df6b3p+967,   -0x1.68500f06cbfeep-1,  0x1.bbec3cp-11, INEXACT)
T(RU,  0x1.99590b66df6b3p+967,   -0x1.68500f06cbfeep-1,  0x1.bbec3cp-11, INEXACT)
T(RD,  0x1.99590b66df6b3p+967,   -0x1.68500f06cbfefp-1,  -0x1.ff9104p-1, INEXACT)
T(RZ, -0x1.e3a8809caaf2dp+541,   -0x1.e6988d01f2914p-1,    0x1.be52p-13, INEXACT)
T(RU, -0x1.e3a8809caaf2dp+541,   -0x1.e6988d01f2914p-1,    0x1.be52p-13, INEXACT)
T(RD, -0x1.e3a8809caaf2dp+541,   -0x1.e6988d01f2915p-1,  -0x1.ffe41ap-1, INEXACT)
T(RZ, -0x1.5324e8bf259f2p+948,   -0x1.e4029516a1379p-1,  0x1.4b486cp-11, INEXACT)
T(RU, -0x1.5324e8bf259f2p+948,   -0x1.e4029516a1379p-1,  0x1.4b486cp-11, INEXACT)
T(RD, -0x1.5324e8bf259f2p+948,   -0x1.e4029516a137ap-1,  -0x1.ffad2ep-1, INEXACT)
T(RZ,  0x1.d00593c2db6d3p+511,    0x1.0139501e6b59fp-2, -0x1.1551f2p-13, INEXACT)
T(RD,  0x1.d00593c2db6d3p+511,    0x1.0139501e6b59fp-2, -0x1.1551f2p-13, INEXACT)
T(RU,  0x1.d00593c2db6d3p+511,     0x1.0139501e6b5ap-2,   0x1.ffeeaap-1, INEXACT)
T(RZ,  0x1.7b85e8a43d3f7p+755,   -0x1.0f67b0d419029p-2,  0x1.d8223cp-11, INEXACT)
T(RU,  0x1.7b85e8a43d3f7p+755,   -0x1.0f67b0d419029p-2,  0x1.d8223cp-11, INEXACT)
T(RD,  0x1.7b85e8a43d3f7p+755,   -0x1.0f67b0d41902ap-2,  -0x1.ff89f8p-1, INEXACT)
T(RN,  0x1.50a47329c015dp+104,   -0x1.f0c6ea8fece75p-1,  -0x1.ff1ae4p-2, INEXACT)
T(RZ,  0x1.837aba47d4443p+830,    0x1.dd170a9de9bdfp-1, -0x1.97ceccp-12, INEXACT)
T(RD,  0x1.837aba47d4443p+830,    0x1.dd170a9de9bdfp-1, -0x1.97ceccp-12, INEXACT)
T(RU,  0x1.837aba47d4443p+830,     0x1.dd170a9de9bep-1,   0x1.ffcd06p-1, INEXACT)
T(RZ,   0x1.8b4ab1e350accp+41,   -0x1.d7fc11116e097p-1,    0x1.ff86bp-1, INEXACT)
T(RU,   0x1.8b4ab1e350accp+41,   -0x1.d7fc11116e097p-1,    0x1.ff86bp-1, INEXACT)
T(RD,   0x1.8b4ab1e350accp+41,   -0x1.d7fc11116e098p-1, -0x1.e53e02p-11, INEXACT)
T(RZ,   -0x1.959244c821d4p+31,   -0x1.fc8140ee33193p-1,   0x1.51d32p-11, INEXACT)
T(RU,   -0x1.959244c821d4p+31,   -0x1.fc8140ee33193p-1,   0x1.51d32p-11, INEXACT)
T(RD,   -0x1.959244c821d4p+31,   -0x1.fc8140ee33194p-1,  -0x1.ffab8cp-1, INEXACT)
T(RN,   0x1.4416c6409973p+946,    0x1.a4026000908c5p-2,  -0x1.ffb19ep-2, INEXACT)
T(RN,   -0x1.df36137e00d3ep+9,   -0x1.f1b9028971dedp-1,  -0x1.ff778cp-2, INEXACT)
T(RZ,   0x1.49b48357afadp+842,   -0x1.ddd7a863b0175p-1,  0x1.d9c676p-11, INEXACT)
T(RU,   0x1.49b48357afadp+842,   -0x1.ddd7a863b0175p-1,  0x1.d9c676p-11, INEXACT)
T(RD,   0x1.49b48357afadp+842,   -0x1.ddd7a863b0176p-1,  -0x1.ff898ep-1, INEXACT)
T(RN, -0x1.bcd5339389b41p+971,    0x1.2baf869a00fbbp-3,  -0x1.ff383ap-2, INEXACT)
T(RZ,  0x1.fc58dc10e9381p+610,   -0x1.399f584dc3bc2p-1,   0x1.ff98a6p-1, INEXACT)
T(RU,  0x1.fc58dc10e9381p+610,   -0x1.399f584dc3bc2p-1,   0x1.ff98a6p-1, INEXACT)
T(RD,  0x1.fc58dc10e9381p+610,   -0x1.399f584dc3bc3p-1, -0x1.9d67f6p-11, INEXACT)
T(RN, -0x1.3839ab7965ce5p+692,   -0x1.6096c1cfff33bp-2,  -0x1.ff1bf2p-2, INEXACT)
T(RZ,  0x1.f0cfc23d23b66p+884,   -0x1.cdb8d14965eaap-1,   0x1.fff6ccp-1, INEXACT)
T(RU,  0x1.f0cfc23d23b66p+884,   -0x1.cdb8d14965eaap-1,   0x1.fff6ccp-1, INEXACT)
T(RD,  0x1.f0cfc23d23b66p+884,   -0x1.cdb8d14965eabp-1, -0x1.266b18p-14, INEXACT)
T(RZ, -0x1.93acce9016507p+864,    0x1.feb8093058333p-1, -0x1.3d025ep-11, INEXACT)
T(RD, -0x1.93acce9016507p+864,    0x1.feb8093058333p-1, -0x1.3d025ep-11, INEXACT)
T(RU, -0x1.93acce9016507p+864,    0x1.feb8093058334p-1,    0x1.ffb0cp-1, INEXACT)
T(RZ, -0x1.30795fb2ef882p+820,    -0x1.ac7e110767e1p-1,   0x1.ff8d0ap-1, INEXACT)
T(RU, -0x1.30795fb2ef882p+820,    -0x1.ac7e110767e1p-1,   0x1.ff8d0ap-1, INEXACT)
T(RD, -0x1.30795fb2ef882p+820,   -0x1.ac7e110767e11p-1, -0x1.cbd482p-11, INEXACT)
T(RN, -0x1.1c87d9f8b9ba7p+449,   -0x1.a75ff01c3bbf3p-3,  -0x1.ff58c2p-2, INEXACT)
T(RN, -0x1.a909ad9dbf2dfp+463,   -0x1.df65e32256c39p-1,  -0x1.ff20c2p-2, INEXACT)
T(RN,   0x1.0159874131ecp+854,   -0x1.fba33bc3b0cdbp-2,  -0x1.ffcdacp-2, INEXACT)
T(RN, 0x1.0c26237394e86p+1017,    0x1.ed7ae97b73ca5p-1,  -0x1.fff7ecp-2, INEXACT)
T(RN,  0x1.6b75ca8abf662p+343,   -0x1.ffcad059ce8ffp-3,  -0x1.ffe0c2p-2, INEXACT)
T(RN, -0x1.e9796a8be088ap+462,    0x1.d6f7f1a32f5bep-1,  -0x1.ff7004p-2, INEXACT)
T(RN,   0x1.21faf23f81a61p+39,    -0x1.f56d1e022691p-1,  -0x1.fffc12p-2, INEXACT)
T(RN, -0x1.8f818bd1cf823p+800,   -0x1.ffe17f43773e6p-1,  -0x1.ff5932p-2, INEXACT)
T(RN,  0x1.d55914097e1fep+331,   -0x1.ffd6029b8577ap-1,  -0x1.ff7ad6p-2, INEXACT)
T(RN,  0x1.710cbe29ed1dbp+674,   -0x1.ed46bb483f26cp-1,  -0x1.ffb40cp-2, INEXACT)
T(RN, -0x1.2920763d6e6fep+926,   -0x1.5955a3b42f73bp-1,  -0x1.ff1deap-2, INEXACT)
T(RN, -0x1.f80651a0d392bp+548,    0x1.cab05c4367b0ep-2,  -0x1.ff7bb8p-2, INEXACT)
T(RZ, -0x1.ced46e39dc1eap+142,   -0x1.e8874797174cep-1,  0x1.d5dbe4p-12, INEXACT)
T(RU, -0x1.ced46e39dc1eap+142,   -0x1.e8874797174cep-1,  0x1.d5dbe4p-12, INEXACT)
T(RD, -0x1.ced46e39dc1eap+142,   -0x1.e8874797174cfp-1,  -0x1.ffc544p-1, INEXACT)
T(RN,  0x1.2ae8277a5bbb6p+462,   -0x1.f42660e329bfdp-1,  -0x1.fff378p-2, INEXACT)
T(RZ,  0x1.e0406810c24fap+212,   -0x1.b67c96054072bp-2,   0x1.ffc7c4p-1, INEXACT)
T(RU,  0x1.e0406810c24fap+212,   -0x1.b67c96054072bp-2,   0x1.ffc7c4p-1, INEXACT)
T(RD,  0x1.e0406810c24fap+212,   -0x1.b67c96054072cp-2,  -0x1.c1e76p-12, INEXACT)
T(RN,  0x1.1a71bf9eb44f4p+790,   -0x1.afe45833bedf4p-3,  -0x1.ffa12ap-2, INEXACT)
T(RN, -0x1.1cd692ce774c5p+634,    0x1.af9f58888b2ddp-1,  -0x1.ff99f8p-2, INEXACT)
T(RZ,  0x1.3113dde158857p+645,    0x1.fe0f0f8883526p-1, -0x1.b5f026p-12, INEXACT)
T(RD,  0x1.3113dde158857p+645,    0x1.fe0f0f8883526p-1, -0x1.b5f026p-12, INEXACT)
T(RU,  0x1.3113dde158857p+645,    0x1.fe0f0f8883527p-1,   0x1.ffc942p-1, INEXACT)
T(RZ,   0x1.8174c6167647fp+14,    0x1.4c145814a7dd6p-3, -0x1.58521ep-12, INEXACT)
T(RD,   0x1.8174c6167647fp+14,    0x1.4c145814a7dd6p-3, -0x1.58521ep-12, INEXACT)
T(RU,   0x1.8174c6167647fp+14,    0x1.4c145814a7dd7p-3,   0x1.ffd4f6p-1, INEXACT)
T(RZ,  0x1.c7dffa524fc1cp+563,   -0x1.23909e0feaaedp-2,  0x1.008cd2p-12, INEXACT)
T(RU,  0x1.c7dffa524fc1cp+563,   -0x1.23909e0feaaedp-2,  0x1.008cd2p-12, INEXACT)
T(RD,  0x1.c7dffa524fc1cp+563,   -0x1.23909e0feaaeep-2,  -0x1.ffdfeep-1, INEXACT)
T(RZ,  0x1.1fdf717146294p+455,    0x1.d73ab8846ab36p-1, -0x1.d555fap-15, INEXACT)
T(RD,  0x1.1fdf717146294p+455,    0x1.d73ab8846ab36p-1, -0x1.d555fap-15, INEXACT)
T(RU,  0x1.1fdf717146294p+455,    0x1.d73ab8846ab37p-1,   0x1.fff8aap-1, INEXACT)
T(RN,  0x1.1e90919c9a0cdp+157,    0x1.eaca8dfce418cp-3,  -0x1.ffa1aep-2, INEXACT)
T(RZ,  0x1.218656ef99cd4p+684,    0x1.5567c79f4e057p-2, -0x1.166fe6p-12, INEXACT)
T(RD,  0x1.218656ef99cd4p+684,    0x1.5567c79f4e057p-2, -0x1.166fe6p-12, INEXACT)
T(RU,  0x1.218656ef99cd4p+684,    0x1.5567c79f4e058p-2,   0x1.ffdd32p-1, INEXACT)
T(RN, -0x1.41cc01945425fp+600,   -0x1.2aacbd86a4848p-3,  -0x1.ffb60ep-2, INEXACT)
T(RZ,  0x1.c9a86dece0e51p+206,   -0x1.b48ca9750c505p-2,   0x1.fff27ep-1, INEXACT)
T(RU,  0x1.c9a86dece0e51p+206,   -0x1.b48ca9750c505p-2,   0x1.fff27ep-1, INEXACT)
T(RD,  0x1.c9a86dece0e51p+206,   -0x1.b48ca9750c506p-2, -0x1.b046cap-14, INEXACT)
T(RZ, -0x1.657f1fb9f6308p+412,    0x1.8c3165405fca3p-2, -0x1.8f2ca8p-12, INEXACT)
T(RD, -0x1.657f1fb9f6308p+412,    0x1.8c3165405fca3p-2, -0x1.8f2ca8p-12, INEXACT)
T(RU, -0x1.657f1fb9f6308p+412,    0x1.8c3165405fca4p-2,   0x1.ffce1ap-1, INEXACT)
T(RZ,   0x1.e69f4157cad0cp+12,    0x1.dc6f9c12db1c9p-2, -0x1.c76b8cp-13, INEXACT)
T(RD,   0x1.e69f4157cad0cp+12,    0x1.dc6f9c12db1c9p-2, -0x1.c76b8cp-13, INEXACT)
T(RU,   0x1.e69f4157cad0cp+12,    0x1.dc6f9c12db1cap-2,   0x1.ffe38ap-1, INEXACT)
T(RZ,   0x1.86e001ccd2646p+87,   -0x1.5ecb7699719bep-1,    0x1.ffe77p-1, INEXACT)
T(RU,   0x1.86e001ccd2646p+87,   -0x1.5ecb7699719bep-1,    0x1.ffe77p-1, INEXACT)
T(RD,   0x1.86e001ccd2646p+87,   -0x1.5ecb7699719bfp-1, -0x1.8901e8p-13, INEXACT)
T(RZ, -0x1.61239f12bfc67p+571,   -0x1.e81013830d358p-1,   0x1.fff882p-1, INEXACT)
T(RU, -0x1.61239f12bfc67p+571,   -0x1.e81013830d358p-1,   0x1.fff882p-1, INEXACT)
T(RD, -0x1.61239f12bfc67p+571,   -0x1.e81013830d359p-1, -0x1.dfbdd2p-15, INEXACT)
T(RZ, -0x1.5d85b4c5f77eep+533,   -0x1.70fcd66a23ae1p-2,   0x1.ffd0e2p-1, INEXACT)
T(RU, -0x1.5d85b4c5f77eep+533,   -0x1.70fcd66a23ae1p-2,   0x1.ffd0e2p-1, INEXACT)
T(RD, -0x1.5d85b4c5f77eep+533,   -0x1.70fcd66a23ae2p-2, -0x1.78f4d2p-12, INEXACT)
T(RN,  0x1.c2833ee391c8fp+417,   -0x1.9d65d0664cc43p-2,  -0x1.ffccbap-2, INEXACT)
T(RZ, -0x1.f1127b1cf3869p+924,     0x1.62637e5c5a75p-2,   -0x1.ffc9ep-1, INEXACT)
T(RD, -0x1.f1127b1cf3869p+924,     0x1.62637e5c5a75p-2,   -0x1.ffc9ep-1, INEXACT)
T(RU, -0x1.f1127b1cf3869p+924,    0x1.62637e5c5a751p-2,  0x1.b0feb6p-12, INEXACT)
T(RZ,  -0x1.7e55f3d78781p+709,    0x1.11904a8b1c8c3p-2,  -0x1.ffca5ep-1, INEXACT)
T(RD,  -0x1.7e55f3d78781p+709,    0x1.11904a8b1c8c3p-2,  -0x1.ffca5ep-1, INEXACT)
T(RU,  -0x1.7e55f3d78781p+709,    0x1.11904a8b1c8c4p-2,  0x1.ad133cp-12, INEXACT)
T(RZ, -0x1.c14bd07bb0d04p+359,   -0x1.fd7245739ec95p-1,   0x1.ffda9cp-1, INEXACT)
T(RU, -0x1.c14bd07bb0d04p+359,   -0x1.fd7245739ec95p-1,   0x1.ffda9cp-1, INEXACT)
T(RD, -0x1.c14bd07bb0d04p+359,   -0x1.fd7245739ec96p-1, -0x1.2b1e4ap-12, INEXACT)
T(RZ,   0x1.4f85f09e38325p+50,    0x1.931d5873614c4p-1,   -0x1.fff01p-1, INEXACT)
T(RD,   0x1.4f85f09e38325p+50,    0x1.931d5873614c4p-1,   -0x1.fff01p-1, INEXACT)
T(RU,   0x1.4f85f09e38325p+50,    0x1.931d5873614c5p-1,  0x1.fde09ep-14, INEXACT)
T(RZ, -0x1.bddf0a934b98cp+595,   -0x1.99e4311485e97p-1,   0x1.ffef72p-1, INEXACT)
T(RU, -0x1.bddf0a934b98cp+595,   -0x1.99e4311485e97p-1,   0x1.ffef72p-1, INEXACT)
T(RD, -0x1.bddf0a934b98cp+595,   -0x1.99e4311485e98p-1, -0x1.08d8dep-13, INEXACT)
T(RZ,   0x1.bf39208c3079p+703,    0x1.e621b36a48019p-1, -0x1.472676p-12, INEXACT)
T(RD,   0x1.bf39208c3079p+703,    0x1.e621b36a48019p-1, -0x1.472676p-12, INEXACT)
T(RU,   0x1.bf39208c3079p+703,    0x1.e621b36a4801ap-1,   0x1.ffd71cp-1, INEXACT)
T(RZ, -0x1.78e0a139726e8p+721,   -0x1.21a9fb479497dp-1,  0x1.716428p-12, INEXACT)
T(RU, -0x1.78e0a139726e8p+721,   -0x1.21a9fb479497dp-1,  0x1.716428p-12, INEXACT)
T(RD, -0x1.78e0a139726e8p+721,   -0x1.21a9fb479497ep-1,  -0x1.ffd1d4p-1, INEXACT)
T(RN, -0x1.8f2950651395dp+664,    0x1.ffbb74328d3a6p-1,  -0x1.ffef8ep-2, INEXACT)
T(RN, -0x1.01fb4f3f775ecp+837,   -0x1.ffd7ef9c9668dp-1,  -0x1.ffe05cp-2, INEXACT)
T(RN,  0x1.d6e8d71f7111dp+589,   -0x1.1cf2ad90874adp-2,  -0x1.ffb01ep-2, INEXACT)
T(RN, -0x1.c03f701b77ae2p+515,    -0x1.fbbe739ed69fp-1,  -0x1.ffa204p-2, INEXACT)
T(RN,  0x1.d765821f23626p+619,    0x1.73240d6e1b1d1p-1,  -0x1.fff0b8p-2, INEXACT)
T(RN,  0x1.7b6efa6145a3dp+228,   -0x1.79ad168aa0ac1p-1,  -0x1.ffea0ep-2, INEXACT)
T(RN,  0x1.e49b7bd07ac8ap+161,   -0x1.e71e05551639dp-1,  -0x1.ffdb5cp-2, INEXACT)
T(RN,  0x1.3d8538505fe02p+144,   -0x1.fed1435efa7d2p-1,  -0x1.ff89c4p-2, INEXACT)
T(RN, -0x1.198aca71532cap+512,    0x1.1959aa25db04dp-1,  -0x1.ffa1c8p-2, INEXACT)
T(RN,  0x1.629c124f9167cp+695,   -0x1.d15000b496342p-3,  -0x1.ffa78ap-2, INEXACT)
T(RN, -0x1.3c5bd7f3db3a1p+821,    0x1.6f914007faafdp-1,  -0x1.ffdec8p-2, INEXACT)
T(RN, -0x1.5c2b5e431c8e2p+705,   -0x1.bb96def3b7989p-1,  -0x1.ffae9cp-2, INEXACT)
T(RN, -0x1.ec14375017268p+441,   -0x1.03593be8d69b3p-1,  -0x1.ffc4ccp-2, INEXACT)
T(RN, -0x1.5f5f1a652a3b2p+521,    0x1.6678d7ac9f1bbp-2,  -0x1.ffd624p-2, INEXACT)
T(RZ,   0x1.c39eebbf8d84p+786,    0x1.9ddfdb085485fp-2, -0x1.40857ap-13, INEXACT)
T(RD,   0x1.c39eebbf8d84p+786,    0x1.9ddfdb085485fp-2, -0x1.40857ap-13, INEXACT)
T(RU,   0x1.c39eebbf8d84p+786,     0x1.9ddfdb085486p-2,   0x1.ffebf8p-1, INEXACT)
T(RN, -0x1.c10203af04899p+283,    0x1.f62f2553545d6p-2,  -0x1.ffd7bcp-2, INEXACT)
T(RN,   0x1.b954a46292417p+21,   -0x1.945b2811bf199p-2,  -0x1.ffe4dcp-2, INEXACT)
T(RZ,  0x1.0cf44f1df58b8p+899,    -0x1.51b3fbdd0cf9p-1,  0x1.296b34p-15, INEXACT)
T(RU,  0x1.0cf44f1df58b8p+899,    -0x1.51b3fbdd0cf9p-1,  0x1.296b34p-15, INEXACT)
T(RD,  0x1.0cf44f1df58b8p+899,   -0x1.51b3fbdd0cf91p-1,  -0x1.fffb5ap-1, INEXACT)
T(RZ,   0x1.8597b3066996fp+50,   -0x1.32261d24c1d3fp-5,  0x1.baae5ap-18, INEXACT)
T(RU,   0x1.8597b3066996fp+50,   -0x1.32261d24c1d3fp-5,  0x1.baae5ap-18, INEXACT)
T(RD,   0x1.8597b3066996fp+50,    -0x1.32261d24c1d4p-5,  -0x1.ffff22p-1, INEXACT)
T(RN, -0x1.7c417e8084d82p+152,    0x1.fa13ec9f94455p-1,   -0x1.ffce3p-2, INEXACT)
T(RZ,  -0x1.1e6834c573e3cp+38,    0x1.e8f633f42868bp-2, -0x1.657ce2p-14, INEXACT)
T(RD,  -0x1.1e6834c573e3cp+38,    0x1.e8f633f42868bp-2, -0x1.657ce2p-14, INEXACT)
T(RU,  -0x1.1e6834c573e3cp+38,    0x1.e8f633f42868cp-2,   0x1.fff4d4p-1, INEXACT)
T(RN, -0x1.1d70a368392d6p+878,    0x1.8f3e95da4e664p-2,  -0x1.ffcac6p-2, INEXACT)
T(RZ,  0x1.f375f9599ca64p+824,    0x1.689ff11689546p-1, -0x1.528f2cp-13, INEXACT)
T(RD,  0x1.f375f9599ca64p+824,    0x1.689ff11689546p-1, -0x1.528f2cp-13, INEXACT)
T(RU,  0x1.f375f9599ca64p+824,    0x1.689ff11689547p-1,   0x1.ffead8p-1, INEXACT)
T(RZ,  0x1.cd92c1ddd75a7p+794,   -0x1.d0ffa3a5b49d6p-2,  0x1.54b372p-13, INEXACT)
T(RU,  0x1.cd92c1ddd75a7p+794,   -0x1.d0ffa3a5b49d6p-2,  0x1.54b372p-13, INEXACT)
T(RD,  0x1.cd92c1ddd75a7p+794,   -0x1.d0ffa3a5b49d7p-2,  -0x1.ffeab4p-1, INEXACT)
T(RZ,  0x1.7129bad42b35ap+367,    0x1.92bdfffec2523p-1,  -0x1.fff44ep-1, INEXACT)
T(RD,  0x1.7129bad42b35ap+367,    0x1.92bdfffec2523p-1,  -0x1.fff44ep-1, INEXACT)
T(RU,  0x1.7129bad42b35ap+367,    0x1.92bdfffec2524p-1,  0x1.76391ep-14, INEXACT)
T(RN, -0x1.3a11ffed128dfp+481,    0x1.cdfda735d4718p-1,  -0x1.ffe5bcp-2, INEXACT)
T(RN, -0x1.130b7f379fbb6p+690,    0x1.dd560bba9e406p-1,  -0x1.ffc9bap-2, INEXACT)
T(RZ,  0x1.a1349c178ae2bp+522,    0x1.1e7461c5e77aep-1,  -0x1.fff826p-1, INEXACT)
T(RD,  0x1.a1349c178ae2bp+522,    0x1.1e7461c5e77aep-1,  -0x1.fff826p-1, INEXACT)
T(RU,  0x1.a1349c178ae2bp+522,    0x1.1e7461c5e77afp-1,  0x1.f6448ep-15, INEXACT)
T(RZ,  0x1.1cc6033b610b8p+708,   -0x1.907b8fc0ec1c9p-1,  0x1.09c676p-15, INEXACT)
T(RU,  0x1.1cc6033b610b8p+708,   -0x1.907b8fc0ec1c9p-1,  0x1.09c676p-15, INEXACT)
T(RD,  0x1.1cc6033b610b8p+708,   -0x1.907b8fc0ec1cap-1,  -0x1.fffbd8p-1, INEXACT)
T(RZ, -0x1.82bb48f485e87p+545,    0x1.ff27529253048p-1,  -0x1.ffe092p-1, INEXACT)
T(RD, -0x1.82bb48f485e87p+545,    0x1.ff27529253048p-1,  -0x1.ffe092p-1, INEXACT)
T(RU, -0x1.82bb48f485e87p+545,    0x1.ff27529253049p-1,  0x1.f6ec36p-13, INEXACT)
T(RZ,  -0x1.31a77f10fd7bp+443,   -0x1.82dfec6b4d389p-2,   0x1.ffee84p-1, INEXACT)
T(RU,  -0x1.31a77f10fd7bp+443,   -0x1.82dfec6b4d389p-2,   0x1.ffee84p-1, INEXACT)
T(RD,  -0x1.31a77f10fd7bp+443,   -0x1.82dfec6b4d38ap-2, -0x1.17c108p-13, INEXACT)
T(RZ,  0x1.9363991c78e67p+600,   -0x1.fd56b1c027141p-1,   0x1.fff6d6p-1, INEXACT)
T(RU,  0x1.9363991c78e67p+600,   -0x1.fd56b1c027141p-1,   0x1.fff6d6p-1, INEXACT)
T(RD,  0x1.9363991c78e67p+600,   -0x1.fd56b1c027142p-1,  -0x1.2536dp-14, INEXACT)
T(RZ,  0x1.6949b872f2b47p+259,    0x1.06020aece6841p-3,  -0x1.fff58ap-1, INEXACT)
T(RD,  0x1.6949b872f2b47p+259,    0x1.06020aece6841p-3,  -0x1.fff58ap-1, INEXACT)
T(RU,  0x1.6949b872f2b47p+259,    0x1.06020aece6842p-3,  0x1.4eb112p-14, INEXACT)
T(RZ,  0x1.662b8b9413761p+857,    0x1.2d0c6389dfb3ap-5,  -0x1.ffff38p-1, INEXACT)
T(RD,  0x1.662b8b9413761p+857,    0x1.2d0c6389dfb3ap-5,  -0x1.ffff38p-1, INEXACT)
T(RU,  0x1.662b8b9413761p+857,    0x1.2d0c6389dfb3bp-5,  0x1.8f81c4p-18, INEXACT)
T(RN,  -0x1.2323f45af9444p+92,    0x1.393041e700bb6p-1,  -0x1.ffd3a6p-2, INEXACT)
T(RZ,  0x1.dc36624e86ebep+465,    0x1.56be37e4607c8p-1,  -0x1.fff884p-1, INEXACT)
T(RD,  0x1.dc36624e86ebep+465,    0x1.56be37e4607c8p-1,  -0x1.fff884p-1, INEXACT)
T(RU,  0x1.dc36624e86ebep+465,    0x1.56be37e4607c9p-1,  0x1.df1b72p-15, INEXACT)
T(RZ, -0x1.8c20b2f8b2a35p+751,    -0x1.8a2cf215fbd8p-3,   0x1.fff844p-1, INEXACT)
T(RU, -0x1.8c20b2f8b2a35p+751,    -0x1.8a2cf215fbd8p-3,   0x1.fff844p-1, INEXACT)
T(RD, -0x1.8c20b2f8b2a35p+751,   -0x1.8a2cf215fbd81p-3, -0x1.eee618p-15, INEXACT)
T(RZ,  0x1.1f010d3031835p+313,    0x1.febfa16eb0804p-1, -0x1.b11186p-16, INEXACT)
T(RD,  0x1.1f010d3031835p+313,    0x1.febfa16eb0804p-1, -0x1.b11186p-16, INEXACT)
T(RU,  0x1.1f010d3031835p+313,    0x1.febfa16eb0805p-1,   0x1.fffc9ep-1, INEXACT)
T(RZ,  0x1.a7f8c24f59838p+553,   -0x1.3bbdacf48f60bp-1,  0x1.71be64p-13, INEXACT)
T(RU,  0x1.a7f8c24f59838p+553,   -0x1.3bbdacf48f60bp-1,  0x1.71be64p-13, INEXACT)
T(RD,  0x1.a7f8c24f59838p+553,   -0x1.3bbdacf48f60cp-1,  -0x1.ffe8e4p-1, INEXACT)
T(RZ, -0x1.faf4eb180f567p+249,    0x1.d75f60e5d9a08p-1, -0x1.180644p-14, INEXACT)
T(RD, -0x1.faf4eb180f567p+249,    0x1.d75f60e5d9a08p-1, -0x1.180644p-14, INEXACT)
T(RU, -0x1.faf4eb180f567p+249,    0x1.d75f60e5d9a09p-1,    0x1.fff74p-1, INEXACT)
T(RZ,  -0x1.6b7f9e467823p+992,   -0x1.ffa8a8d75f4e9p-1,   0x1.ffec28p-1, INEXACT)
T(RU,  -0x1.6b7f9e467823p+992,   -0x1.ffa8a8d75f4e9p-1,   0x1.ffec28p-1, INEXACT)
T(RD,  -0x1.6b7f9e467823p+992,   -0x1.ffa8a8d75f4eap-1,  -0x1.3d817p-13, INEXACT)
T(RN, -0x1.e66ea35b0e90ep+526,    0x1.4bd88e10ea82dp-3,  -0x1.ffe7c6p-2, INEXACT)
T(RN,  0x1.95f0a1fc527fap+325,   -0x1.fa212836de303p-1,  -0x1.ffc6dep-2, INEXACT)
T(RN,   0x1.d776404f95d86p+13,    0x1.50922dd5afe92p-1,  -0x1.ffd662p-2, INEXACT)
T(RN, -0x1.152a788362edp+1023,   -0x1.0df3d1586a61cp-4,  -0x1.ffcd52p-2, INEXACT)
T(RN,  -0x1.345d2045b0a88p+94,   -0x1.835cc1d1f974ep-1,  -0x1.fff8ecp-2, INEXACT)
T(RN, -0x1.3766ad71de9fbp+620,   -0x1.dbfd364bd71ffp-2,  -0x1.ffd2e4p-2, INEXACT)
T(RN,  0x1.d15aa75c02483p+928,    0x1.7296c539c2961p-2,   -0x1.ffe95p-2, INEXACT)
T(RN, -0x1.85638a9102c53p+904,   -0x1.fb02eaf7c9234p-1,  -0x1.ffd85ap-2, INEXACT)
T(RN,    -0x1.9362a1d29d8dp-2,    0x1.d8c8db7d4b5a4p-1,  -0x1.fff17cp-2, INEXACT)
T(RN, -0x1.abd6ad5a0d9a7p+475,   -0x1.20c75a4fa0e6bp-2,  -0x1.ffd09ap-2, INEXACT)
T(RN, -0x1.fc6101ea98df4p+794,    0x1.8ef990e658f66p-2,  -0x1.ffcddap-2, INEXACT)
T(RN,   0x1.74d650e18b716p+87,    0x1.2e752a2efb963p-4,  -0x1.ffdb76p-2, INEXACT)
T(RN,  0x1.2a7e9e0f7777fp+111,    0x1.246b2018e24acp-3,  -0x1.fff292p-2, INEXACT)
T(RZ,  0x1.ccdac994e0c04p+115,    0x1.c0e1b2e0fd3cbp-1,  -0x1.fffac6p-1, INEXACT)
T(RD,  0x1.ccdac994e0c04p+115,    0x1.c0e1b2e0fd3cbp-1,  -0x1.fffac6p-1, INEXACT)
T(RU,  0x1.ccdac994e0c04p+115,    0x1.c0e1b2e0fd3ccp-1,  0x1.4e4bb6p-15, INEXACT)
T(RN, -0x1.70909c76b23f2p+812,    0x1.e9b70873cbe5ep-4,  -0x1.ffefacp-2, INEXACT)
T(RZ,  0x1.742980d6e8817p+593,   -0x1.e744bb0cf5018p-2,   0x1.fff2dep-1, INEXACT)
T(RU,  0x1.742980d6e8817p+593,   -0x1.e744bb0cf5018p-2,   0x1.fff2dep-1, INEXACT)
T(RD,  0x1.742980d6e8817p+593,   -0x1.e744bb0cf5019p-2, -0x1.a42344p-14, INEXACT)
T(RZ,   0x1.da296d16443cfp+43,    0x1.2f80ec9489351p-1,  -0x1.ffff18p-1, INEXACT)
T(RD,   0x1.da296d16443cfp+43,    0x1.2f80ec9489351p-1,  -0x1.ffff18p-1, INEXACT)
T(RU,   0x1.da296d16443cfp+43,    0x1.2f80ec9489352p-1,  0x1.cf2daap-18, INEXACT)
T(RZ,   0x1.80ee8ffee611p+417,   -0x1.9108b58491fbfp-1,   0x1.fffab2p-1, INEXACT)
T(RU,   0x1.80ee8ffee611p+417,   -0x1.9108b58491fbfp-1,   0x1.fffab2p-1, INEXACT)
T(RD,   0x1.80ee8ffee611p+417,    -0x1.9108b58491fcp-1, -0x1.535d02p-15, INEXACT)
T(RZ,-0x1.a2755fff83336p+1013,    0x1.27fb0c8e8fe92p-2,  -0x1.fff2dap-1, INEXACT)
T(RD,-0x1.a2755fff83336p+1013,    0x1.27fb0c8e8fe92p-2,  -0x1.fff2dap-1, INEXACT)
T(RU,-0x1.a2755fff83336p+1013,    0x1.27fb0c8e8fe93p-2,  0x1.a4df78p-14, INEXACT)
T(RZ,  0x1.0d8de973e6647p+823,   -0x1.f61279efa1bbdp-1,  0x1.669ec6p-14, INEXACT)
T(RU,  0x1.0d8de973e6647p+823,   -0x1.f61279efa1bbdp-1,  0x1.669ec6p-14, INEXACT)
T(RD,  0x1.0d8de973e6647p+823,   -0x1.f61279efa1bbep-1,  -0x1.fff4ccp-1, INEXACT)
T(RZ, -0x1.480bd4bcac6a5p+175,   -0x1.9c3d2a4a4867ep-3,  0x1.dad3dep-15, INEXACT)
T(RU, -0x1.480bd4bcac6a5p+175,   -0x1.9c3d2a4a4867ep-3,  0x1.dad3dep-15, INEXACT)
T(RD, -0x1.480bd4bcac6a5p+175,   -0x1.9c3d2a4a4867fp-3,  -0x1.fff894p-1, INEXACT)
T(RZ,  0x1.29cfe40e2a056p+417,   -0x1.cf53afbe42fecp-1,   0x1.fff2dep-1, INEXACT)
T(RU,  0x1.29cfe40e2a056p+417,   -0x1.cf53afbe42fecp-1,   0x1.fff2dep-1, INEXACT)
T(RD,  0x1.29cfe40e2a056p+417,   -0x1.cf53afbe42fedp-1, -0x1.a451ccp-14, INEXACT)
T(RN, -0x1.3999013e377dap+602,   -0x1.af29674002a2ep-1,  -0x1.ffe30ep-2, INEXACT)
T(RZ,  0x1.74be90ce57d31p+275,   -0x1.aee0d2bf6f06ep-1,     0x1.fffep-1, INEXACT)
T(RU,  0x1.74be90ce57d31p+275,   -0x1.aee0d2bf6f06ep-1,     0x1.fffep-1, INEXACT)
T(RD,  0x1.74be90ce57d31p+275,   -0x1.aee0d2bf6f06fp-1, -0x1.004272p-16, INEXACT)
T(RZ,  -0x1.9f5e5ebb34f42p+56,   -0x1.65dda9ad4c757p-1,   0x1.fff502p-1, INEXACT)
T(RU,  -0x1.9f5e5ebb34f42p+56,   -0x1.65dda9ad4c757p-1,   0x1.fff502p-1, INEXACT)
T(RD,  -0x1.9f5e5ebb34f42p+56,   -0x1.65dda9ad4c758p-1, -0x1.5fd552p-14, INEXACT)
T(RN,  0x1.606c51188358dp+841,    0x1.be719dbe6ed93p-1,  -0x1.fffa7ep-2, INEXACT)
T(RZ, -0x1.fec1ca815888fp+614,    0x1.ed743e76c096ap-1, -0x1.a2703ap-14, INEXACT)
T(RD, -0x1.fec1ca815888fp+614,    0x1.ed743e76c096ap-1, -0x1.a2703ap-14, INEXACT)
T(RU, -0x1.fec1ca815888fp+614,    0x1.ed743e76c096bp-1,   0x1.fff2ecp-1, INEXACT)
T(RZ,-0x1.265b9a79ff64ap+1002,    0x1.d53a1b142048fp-1,  -0x1.fff048p-1, INEXACT)
T(RD,-0x1.265b9a79ff64ap+1002,    0x1.d53a1b142048fp-1,  -0x1.fff048p-1, INEXACT)
T(RU,-0x1.265b9a79ff64ap+1002,     0x1.d53a1b142049p-1,  0x1.f70edep-14, INEXACT)
T(RZ,  0x1.da3009796c789p+641,   -0x1.a55a54191cd06p-6,    0x1.fff92p-1, INEXACT)
T(RU,  0x1.da3009796c789p+641,   -0x1.a55a54191cd06p-6,    0x1.fff92p-1, INEXACT)
T(RD,  0x1.da3009796c789p+641,   -0x1.a55a54191cd07p-6, -0x1.b82742p-15, INEXACT)
T(RZ,  -0x1.c1ebc918de27bp+31,   -0x1.d5ac0f7b1cbf5p-4,    0x1.fff4dp-1, INEXACT)
T(RU,  -0x1.c1ebc918de27bp+31,   -0x1.d5ac0f7b1cbf5p-4,    0x1.fff4dp-1, INEXACT)
T(RD,  -0x1.c1ebc918de27bp+31,   -0x1.d5ac0f7b1cbf6p-4, -0x1.660b38p-14, INEXACT)
T(RZ,   0x1.90d56e6463dap+488,    0x1.8647b2ad21e49p-1,  -0x1.fff092p-1, INEXACT)
T(RD,   0x1.90d56e6463dap+488,    0x1.8647b2ad21e49p-1,  -0x1.fff092p-1, INEXACT)
T(RU,   0x1.90d56e6463dap+488,    0x1.8647b2ad21e4ap-1,  0x1.edb0d6p-14, INEXACT)
T(RN,  0x1.ffe5c29c5d6a6p+675,   -0x1.0a955045fdbe7p-1,  -0x1.fff2f6p-2, INEXACT)
T(RZ, -0x1.8b738ece2fa9cp+368,   -0x1.fe1d0c948449cp-1,  0x1.13d4eap-14, INEXACT)
T(RU, -0x1.8b738ece2fa9cp+368,   -0x1.fe1d0c948449cp-1,  0x1.13d4eap-14, INEXACT)
T(RD, -0x1.8b738ece2fa9cp+368,   -0x1.fe1d0c948449dp-1,  -0x1.fff762p-1, INEXACT)
T(RZ,  0x1.b22405e640236p+701,   -0x1.dbea6394b03f2p-1,    0x1.fffd4p-1, INEXACT)
T(RU,  0x1.b22405e640236p+701,   -0x1.dbea6394b03f2p-1,    0x1.fffd4p-1, INEXACT)
T(RD,  0x1.b22405e640236p+701,   -0x1.dbea6394b03f3p-1, -0x1.5fc8dep-16, INEXACT)
T(RZ,  -0x1.f598f82d578bp+717,    0x1.e4fd27875075ep-1, -0x1.429a74p-14, INEXACT)
T(RD,  -0x1.f598f82d578bp+717,    0x1.e4fd27875075ep-1, -0x1.429a74p-14, INEXACT)
T(RU,  -0x1.f598f82d578bp+717,    0x1.e4fd27875075fp-1,   0x1.fff5ecp-1, INEXACT)
T(RN,   0x1.b682e48ae1cbp+664,    0x1.6cadecccb41a7p-3,  -0x1.fff99cp-2, INEXACT)
T(RZ,  0x1.3f2f9c589e5b5p+267,   -0x1.6d622878d636ap-1,  0x1.26b5d6p-14, INEXACT)
T(RU,  0x1.3f2f9c589e5b5p+267,   -0x1.6d622878d636ap-1,  0x1.26b5d6p-14, INEXACT)
T(RD,  0x1.3f2f9c589e5b5p+267,   -0x1.6d622878d636bp-1,  -0x1.fff6cap-1, INEXACT)
T(RZ, -0x1.c40a256b5dde1p+264,   -0x1.a95a1e133d424p-1,  0x1.8eade8p-15, INEXACT)
T(RU, -0x1.c40a256b5dde1p+264,   -0x1.a95a1e133d424p-1,  0x1.8eade8p-15, INEXACT)
T(RD, -0x1.c40a256b5dde1p+264,   -0x1.a95a1e133d425p-1,  -0x1.fff9c6p-1, INEXACT)
T(RN, -0x1.cb1c3996bf441p+705,   -0x1.e0dc0f60bbc77p-1,  -0x1.ffe8c6p-2, INEXACT)
T(RN,  0x1.c1c6a6d59b866p+986,   -0x1.fff2764a9842ap-1,  -0x1.ffffb4p-2, INEXACT)
T(RN,  0x1.43fa7d97b7c23p+177,    0x1.fad5550d3ce44p-1,  -0x1.ffeca8p-2, INEXACT)
T(RN, -0x1.91aa9d99051edp+156,   -0x1.e4a6f2bc7d74ep-1,  -0x1.ffea34p-2, INEXACT)
T(RN,  0x1.18eca456dceaap+812,   -0x1.97d19e5a77cb9p-1,  -0x1.fff438p-2, INEXACT)
T(RN, -0x1.71673eaa57e18p+567,   -0x1.49736251f06e2p-3,  -0x1.ffeecap-2, INEXACT)
T(RN,  0x1.98cb992985f6cp+606,    0x1.43f11325ce678p-1,  -0x1.fffaaap-2, INEXACT)
T(RN,  -0x1.58c4a795c0c3p+815,   -0x1.cfdd121f2edeap-1,  -0x1.fff1f2p-2, INEXACT)
T(RN, -0x1.2c0ff97efddf6p+858,    0x1.9f94a09fc62f8p-2,  -0x1.ffe84ep-2, INEXACT)
T(RN,  0x1.d6b2e10539846p+760,   -0x1.51e6fc40c4539p-2,  -0x1.ffe168p-2, INEXACT)
T(RN, -0x1.98e5c7b1d7161p+156,   -0x1.81aa13091ff48p-1,  -0x1.ffe178p-2, INEXACT)
T(RN,  0x1.5ca761fbff4ddp+133,   -0x1.fc91c2eaeb88fp-2,  -0x1.fff4b6p-2, INEXACT)
T(RN, -0x1.90c42ceaa132bp+965,   -0x1.94d9bbfbe9f19p-3,  -0x1.fffcc6p-2, INEXACT)
T(RN, -0x1.a33ce4f7d3badp+294,   -0x1.835cd0ec268e2p-1,  -0x1.ffe546p-2, INEXACT)
T(RN,  -0x1.88a8f3e83246p+331,   -0x1.d1b6135e31c7fp-1,  -0x1.fff002p-2, INEXACT)
T(RZ,  -0x1.442a210bd796cp+34,    0x1.61a093b1cf993p-1,  -0x1.fffbdcp-1, INEXACT)
T(RD,  -0x1.442a210bd796cp+34,    0x1.61a093b1cf993p-1,  -0x1.fffbdcp-1, INEXACT)
T(RU,  -0x1.442a210bd796cp+34,    0x1.61a093b1cf994p-1,  0x1.092806p-15, INEXACT)
T(RZ,  0x1.4c7e88cee6f4dp+269,    0x1.32d864057c27dp-3,   -0x1.fffecp-1, INEXACT)
T(RD,  0x1.4c7e88cee6f4dp+269,    0x1.32d864057c27dp-3,   -0x1.fffecp-1, INEXACT)
T(RU,  0x1.4c7e88cee6f4dp+269,    0x1.32d864057c27ep-3,  0x1.402384p-17, INEXACT)
T(RN, -0x1.4f3b2cda19ebbp+963,   -0x1.31aa92756e6e6p-1,  -0x1.fff38cp-2, INEXACT)
T(RZ, -0x1.86cb616b6c0fap+971,   -0x1.a3e88db640859p-1,  0x1.936e08p-19, INEXACT)
T(RU, -0x1.86cb616b6c0fap+971,   -0x1.a3e88db640859p-1,  0x1.936e08p-19, INEXACT)
T(RD, -0x1.86cb616b6c0fap+971,   -0x1.a3e88db64085ap-1,  -0x1.ffff9cp-1, INEXACT)
T(RN, -0x1.2a572b2787a57p+192,    0x1.d40f27c7ce2d4p-1,  -0x1.fff06cp-2, INEXACT)
T(RZ,  0x1.069e09c958487p+532,    0x1.043e6435ad501p-1,   -0x1.fffdap-1, INEXACT)
T(RD,  0x1.069e09c958487p+532,    0x1.043e6435ad501p-1,   -0x1.fffdap-1, INEXACT)
T(RU,  0x1.069e09c958487p+532,    0x1.043e6435ad502p-1,   0x1.2faebp-16, INEXACT)
T(RN, -0x1.53b0bbadb7bacp+707,    0x1.3fbc58cde41cep-1,   -0x1.fff87p-2, INEXACT)
T(RZ,  0x1.2989e4eab97edp+868,    0x1.1906b55cd2024p-2,   -0x1.fffeep-1, INEXACT)
T(RD,  0x1.2989e4eab97edp+868,    0x1.1906b55cd2024p-2,   -0x1.fffeep-1, INEXACT)
T(RU,  0x1.2989e4eab97edp+868,    0x1.1906b55cd2025p-2,  0x1.1f9938p-17, INEXACT)
T(RZ, -0x1.72b09d1f914d3p+458,    0x1.f67f086e1397bp-1,  -0x1.fffd96p-1, INEXACT)
T(RD, -0x1.72b09d1f914d3p+458,    0x1.f67f086e1397bp-1,  -0x1.fffd96p-1, INEXACT)
T(RU, -0x1.72b09d1f914d3p+458,    0x1.f67f086e1397cp-1,  0x1.34f27cp-16, INEXACT)
T(RN,  0x1.684a0f0fafffbp+330,   -0x1.2bd05f54572a6p-1,   -0x1.fff71p-2, INEXACT)
T(RZ, -0x1.bcd3814831b82p+677,     0x1.6a2ce243f512p-7,  -0x1.fffa74p-1, INEXACT)
T(RD, -0x1.bcd3814831b82p+677,     0x1.6a2ce243f512p-7,  -0x1.fffa74p-1, INEXACT)
T(RU, -0x1.bcd3814831b82p+677,    0x1.6a2ce243f5121p-7,  0x1.631b34p-15, INEXACT)
T(RZ,   0x1.781326bd5b12fp+92,    0x1.d669b996b8617p-1,  -0x1.fffebap-1, INEXACT)
T(RD,   0x1.781326bd5b12fp+92,    0x1.d669b996b8617p-1,  -0x1.fffebap-1, INEXACT)
T(RU,   0x1.781326bd5b12fp+92,    0x1.d669b996b8618p-1,   0x1.4665ep-17, INEXACT)
T(RN,  0x1.2617da01e0f28p+370,     0x1.f576ce2742e3p-1,  -0x1.fff6f4p-2, INEXACT)
T(RN,   0x1.da777e1aa642p+904,    0x1.a0de0846a7b49p-1,  -0x1.fff1d2p-2, INEXACT)
T(RZ,  0x1.f67082636cb11p+919,   -0x1.35f9868ee7291p-1,  0x1.72981cp-16, INEXACT)
T(RU,  0x1.f67082636cb11p+919,   -0x1.35f9868ee7291p-1,  0x1.72981cp-16, INEXACT)
T(RD,  0x1.f67082636cb11p+919,   -0x1.35f9868ee7292p-1,  -0x1.fffd1ap-1, INEXACT)
T(RN,  0x1.ae7b84b5223c5p+852,   -0x1.9265ab4e549d6p-1,   -0x1.fff69p-2, INEXACT)
T(RZ, -0x1.4f453fc4b88c1p+405,    0x1.bdd6549a4d124p-2,  -0x1.ffff78p-1, INEXACT)
T(RD, -0x1.4f453fc4b88c1p+405,    0x1.bdd6549a4d124p-2,  -0x1.ffff78p-1, INEXACT)
T(RU, -0x1.4f453fc4b88c1p+405,    0x1.bdd6549a4d125p-2,  0x1.0f6612p-18, INEXACT)
T(RN,  0x1.31b4c13c0f2dap+123,    0x1.48868c974097ep-2,  -0x1.fff05ap-2, INEXACT)
T(RZ,  0x1.0c1c810a9271bp+141,   -0x1.66e779a92338ep-5,  0x1.96acd2p-15, INEXACT)
T(RU,  0x1.0c1c810a9271bp+141,   -0x1.66e779a92338ep-5,  0x1.96acd2p-15, INEXACT)
T(RD,  0x1.0c1c810a9271bp+141,   -0x1.66e779a92338fp-5,  -0x1.fff9a6p-1, INEXACT)
T(RN,  0x1.385fe3cbbb456p+327,   -0x1.ffcd8909e0c35p-1,   -0x1.fff52p-2, INEXACT)
T(RZ, -0x1.5bc9a466224f6p+613,   -0x1.3ac6f8b3cd70fp-1,    0x1.fffe2p-1, INEXACT)
T(RU, -0x1.5bc9a466224f6p+613,   -0x1.3ac6f8b3cd70fp-1,    0x1.fffe2p-1, INEXACT)
T(RD, -0x1.5bc9a466224f6p+613,    -0x1.3ac6f8b3cd71p-1, -0x1.e0d6e4p-17, INEXACT)
T(RN,    0x1.aa1f507fc1373p-2,    0x1.d44e1049acb13p-1,  -0x1.fff724p-2, INEXACT)
T(RZ,  0x1.350b298773dbfp+442,   -0x1.89826e5334ccep-1,  0x1.28aacep-19, INEXACT)
T(RU,  0x1.350b298773dbfp+442,   -0x1.89826e5334ccep-1,  0x1.28aacep-19, INEXACT)
T(RD,  0x1.350b298773dbfp+442,   -0x1.89826e5334ccfp-1,  -0x1.ffffb6p-1, INEXACT)
T(RN, -0x1.08deb6bc576e3p+806,   -0x1.9bf6f97a0c7e3p-1,  -0x1.fff8f2p-2, INEXACT)
T(RZ, -0x1.149fa6e9ec7eep+985,    0x1.f750542cd87acp-1,  -0x1.fffe24p-1, INEXACT)
T(RD, -0x1.149fa6e9ec7eep+985,    0x1.f750542cd87acp-1,  -0x1.fffe24p-1, INEXACT)
T(RU, -0x1.149fa6e9ec7eep+985,    0x1.f750542cd87adp-1,  0x1.dbf95cp-17, INEXACT)
T(RN,  0x1.1ab0db1fa1107p+740,   -0x1.6aa2b0be871e7p-1,  -0x1.fff0bep-2, INEXACT)
T(RZ, -0x1.f180e632fde77p+175,    0x1.765e92af59526p-1,  -0x1.fffc96p-1, INEXACT)
T(RD, -0x1.f180e632fde77p+175,    0x1.765e92af59526p-1,  -0x1.fffc96p-1, INEXACT)
T(RU, -0x1.f180e632fde77p+175,    0x1.765e92af59527p-1,  0x1.b57264p-16, INEXACT)
T(RZ,  0x1.8eecb4cf26cabp+693,   -0x1.66b4901d29b9cp-1,  0x1.1e522ap-17, INEXACT)
T(RU,  0x1.8eecb4cf26cabp+693,   -0x1.66b4901d29b9cp-1,  0x1.1e522ap-17, INEXACT)
T(RD,  0x1.8eecb4cf26cabp+693,   -0x1.66b4901d29b9dp-1,  -0x1.fffee2p-1, INEXACT)
T(RZ, -0x1.a7f1183d57ed3p+613,   -0x1.919d20116001ap-1,   0x1.fffccep-1, INEXACT)
T(RU, -0x1.a7f1183d57ed3p+613,   -0x1.919d20116001ap-1,   0x1.fffccep-1, INEXACT)
T(RD, -0x1.a7f1183d57ed3p+613,   -0x1.919d20116001bp-1, -0x1.991042p-16, INEXACT)
T(RZ, -0x1.6f6d015735b96p+903,   -0x1.2302424e485a6p-1,   0x1.627d4p-19, INEXACT)
T(RU, -0x1.6f6d015735b96p+903,   -0x1.2302424e485a6p-1,   0x1.627d4p-19, INEXACT)
T(RD, -0x1.6f6d015735b96p+903,   -0x1.2302424e485a7p-1,  -0x1.ffffa8p-1, INEXACT)
T(RZ, 0x1.daf5bbf0ad1f8p+1000,    0x1.8aa17ee18fd1bp-1, -0x1.c28fd6p-15, INEXACT)
T(RD, 0x1.daf5bbf0ad1f8p+1000,    0x1.8aa17ee18fd1bp-1, -0x1.c28fd6p-15, INEXACT)
T(RU, 0x1.daf5bbf0ad1f8p+1000,    0x1.8aa17ee18fd1cp-1,   0x1.fff8f6p-1, INEXACT)
T(RZ,  0x1.cd32ce88fb4ddp+752,    0x1.5ad4efc4733e4p-1,  -0x1.fff9a4p-1, INEXACT)
T(RD,  0x1.cd32ce88fb4ddp+752,    0x1.5ad4efc4733e4p-1,  -0x1.fff9a4p-1, INEXACT)
T(RU,  0x1.cd32ce88fb4ddp+752,    0x1.5ad4efc4733e5p-1,  0x1.9712b8p-15, INEXACT)
T(RN,  0x1.2b2390d00a733p+742,   -0x1.ce58de629e527p-1,  -0x1.fffd82p-2, INEXACT)
T(RN, -0x1.aa96c22d139d8p+276,   -0x1.ac419b73f79ffp-1,   -0x1.fff7cp-2, INEXACT)
T(RN, -0x1.f45fe2175d5c2p+358,   -0x1.c64502e1cd915p-2,  -0x1.fffb22p-2, INEXACT)
T(RN, -0x1.b57accfdfa46cp+561,   -0x1.ff3a25f90109dp-1,  -0x1.ffff34p-2, INEXACT)
T(RN, 0x1.64d88c10b84c2p+1017,    0x1.ff7685803faeep-1,  -0x1.fff8c8p-2, INEXACT)
T(RN,  0x1.d1a095321b1d8p+756,    0x1.f93e2cf97007fp-8,  -0x1.fff19cp-2, INEXACT)
T(RN, -0x1.55e4c7eaa64cbp+440,    0x1.c03f53cf672cfp-3,  -0x1.fff8d2p-2, INEXACT)
T(RN, -0x1.bdcc381034652p+343,    0x1.ff3749579b396p-1,  -0x1.fff114p-2, INEXACT)
T(RN, -0x1.b64df6404d3ecp+107,   -0x1.b325722e1f147p-1,   -0x1.fffb6p-2, INEXACT)
T(RN,  0x1.9f5cfc9e7dc15p+334,    0x1.46b9e6ad03431p-1,  -0x1.fffc3ep-2, INEXACT)
T(RZ,  -0x1.f5fa60e238edcp+59,    0x1.680f17448cf63p-3, -0x1.12d996p-17, INEXACT)
T(RD,  -0x1.f5fa60e238edcp+59,    0x1.680f17448cf63p-3, -0x1.12d996p-17, INEXACT)
T(RU,  -0x1.f5fa60e238edcp+59,    0x1.680f17448cf64p-3,   0x1.fffeeep-1, INEXACT)
T(RN,  0x1.87193b0395dcdp+710,    0x1.d1e90ff48de77p-1,  -0x1.fff802p-2, INEXACT)
T(RN, -0x1.a234887c88223p+195,    0x1.3e3f34759e6ecp-2,  -0x1.fffd86p-2, INEXACT)
T(RZ, -0x1.bb3bd692bb729p+451,     -0x1.fffc660dba7p-1,   0x1.ffff98p-1, INEXACT)
T(RU, -0x1.bb3bd692bb729p+451,     -0x1.fffc660dba7p-1,   0x1.ffff98p-1, INEXACT)
T(RD, -0x1.bb3bd692bb729p+451,   -0x1.fffc660dba701p-1, -0x1.9cc7aap-19, INEXACT)
T(RZ, -0x1.b7064d791420ap+795,    0x1.fee6693fb7272p-1,  -0x1.fffed2p-1, INEXACT)
T(RD, -0x1.b7064d791420ap+795,    0x1.fee6693fb7272p-1,  -0x1.fffed2p-1, INEXACT)
T(RU, -0x1.b7064d791420ap+795,    0x1.fee6693fb7273p-1,  0x1.2d1c54p-17, INEXACT)
T(RN,  0x1.bc6c0e0cad9e9p+729,    0x1.c351fc2d5ea67p-1,  -0x1.fff9e8p-2, INEXACT)
T(RZ,   0x1.92cec4887bd1p+912,   -0x1.b4deb2abab304p-1,  0x1.4998dep-16, INEXACT)
T(RU,   0x1.92cec4887bd1p+912,   -0x1.b4deb2abab304p-1,  0x1.4998dep-16, INEXACT)
T(RD,   0x1.92cec4887bd1p+912,   -0x1.b4deb2abab305p-1,  -0x1.fffd6cp-1, INEXACT)
T(RN,  0x1.156505c4b5df4p+622,   -0x1.b16b35c619c8cp-1,   -0x1.ffffap-2, INEXACT)
T(RN, -0x1.956d62e1e2eb4p+633,    0x1.02c1d0751ab44p-1,    -0x1.fffdp-2, INEXACT)
T(RZ, -0x1.0ad77227dc499p+426,   -0x1.33cb6373ad522p-3,   0x1.fffc18p-1, INEXACT)
T(RU, -0x1.0ad77227dc499p+426,   -0x1.33cb6373ad522p-3,   0x1.fffc18p-1, INEXACT)
T(RD, -0x1.0ad77227dc499p+426,   -0x1.33cb6373ad523p-3, -0x1.f46cb8p-16, INEXACT)
T(RN, -0x1.c38055c6103eep+478,    0x1.a2e168f8048bdp-5,  -0x1.fffbaap-2, INEXACT)
T(RZ,  0x1.702ccd800b3c2p+859,   -0x1.c4342bd9152b2p-1,  0x1.d820c4p-18, INEXACT)
T(RU,  0x1.702ccd800b3c2p+859,   -0x1.c4342bd9152b2p-1,  0x1.d820c4p-18, INEXACT)
T(RD,  0x1.702ccd800b3c2p+859,   -0x1.c4342bd9152b3p-1,  -0x1.ffff14p-1, INEXACT)
T(RN,  0x1.fdd1c22c53a8dp+509,   -0x1.54d6e25ea79cdp-3,  -0x1.fffce2p-2, INEXACT)
T(RZ,  0x1.44dd42f518ae5p+996,    0x1.35a07f55cd949p-1,  -0x1.ffffd8p-1, INEXACT)
T(RD,  0x1.44dd42f518ae5p+996,    0x1.35a07f55cd949p-1,  -0x1.ffffd8p-1, INEXACT)
T(RU,  0x1.44dd42f518ae5p+996,    0x1.35a07f55cd94ap-1,  0x1.3e110ap-20, INEXACT)
T(RZ, -0x1.f6711dcdb5f72p+965,   -0x1.66c35676e3d21p-1,   0x1.fffc7ep-1, INEXACT)
T(RU, -0x1.f6711dcdb5f72p+965,   -0x1.66c35676e3d21p-1,   0x1.fffc7ep-1, INEXACT)
T(RD, -0x1.f6711dcdb5f72p+965,   -0x1.66c35676e3d22p-1, -0x1.c086fcp-16, INEXACT)
T(RZ, -0x1.62e6a7f37a7f3p+928,    -0x1.27eaed2a8246p-2,   0x1.6ff82p-23, INEXACT)
T(RU, -0x1.62e6a7f37a7f3p+928,    -0x1.27eaed2a8246p-2,   0x1.6ff82p-23, INEXACT)
T(RD, -0x1.62e6a7f37a7f3p+928,   -0x1.27eaed2a82461p-2,  -0x1.fffffap-1, INEXACT)
T(RN, -0x1.bcbb470428849p+280,    0x1.6430e6158a1abp-4,  -0x1.fffefcp-2, INEXACT)
T(RN, -0x1.3a231e1b59c8bp+322,     0x1.48a024429aacp-1,  -0x1.fffff2p-2, INEXACT)
T(RZ, -0x1.a4b23bcf273d2p+454,   -0x1.1f885e77986dfp-3,   0x1.fffebap-1, INEXACT)
T(RU, -0x1.a4b23bcf273d2p+454,   -0x1.1f885e77986dfp-3,   0x1.fffebap-1, INEXACT)
T(RD, -0x1.a4b23bcf273d2p+454,    -0x1.1f885e77986ep-3, -0x1.451056p-17, INEXACT)
T(RN,  0x1.c590d08f5c1ecp+117,   -0x1.a601e4033910dp-1,  -0x1.fffa22p-2, INEXACT)
T(RZ, -0x1.d24c311b040efp+962,   -0x1.bdc799ab3a1b1p-5,   0x1.fffd8cp-1, INEXACT)
T(RU, -0x1.d24c311b040efp+962,   -0x1.bdc799ab3a1b1p-5,   0x1.fffd8cp-1, INEXACT)
T(RD, -0x1.d24c311b040efp+962,   -0x1.bdc799ab3a1b2p-5, -0x1.3a5fc8p-16, INEXACT)
T(RZ, -0x1.547d5496c4f5fp+284,   -0x1.cff9ca7c7f835p-2,   0x1.fffd92p-1, INEXACT)
T(RU, -0x1.547d5496c4f5fp+284,   -0x1.cff9ca7c7f835p-2,   0x1.fffd92p-1, INEXACT)
T(RD, -0x1.547d5496c4f5fp+284,   -0x1.cff9ca7c7f836p-2, -0x1.376d0ap-16, INEXACT)
T(RN,  0x1.8d3da54be2c35p+233,   -0x1.1a2dac95166e3p-1,  -0x1.fff936p-2, INEXACT)
T(RZ,  0x1.fc23c97031de5p+484,    0x1.18931c1a23f97p-1, -0x1.3f9778p-16, INEXACT)
T(RD,  0x1.fc23c97031de5p+484,    0x1.18931c1a23f97p-1, -0x1.3f9778p-16, INEXACT)
T(RU,  0x1.fc23c97031de5p+484,    0x1.18931c1a23f98p-1,    0x1.fffd8p-1, INEXACT)
T(RZ,   0x1.79dd7368775c3p+17,    0x1.ced65cabc55bfp-3, -0x1.ccfb72p-17, INEXACT)
T(RD,   0x1.79dd7368775c3p+17,    0x1.ced65cabc55bfp-3, -0x1.ccfb72p-17, INEXACT)
T(RU,   0x1.79dd7368775c3p+17,     0x1.ced65cabc55cp-3,   0x1.fffe34p-1, INEXACT)
T(RZ, -0x1.0e4ce5cb8790ep+956,   -0x1.b77696bef0e62p-4,   0x1.ffff9cp-1, INEXACT)
T(RU, -0x1.0e4ce5cb8790ep+956,   -0x1.b77696bef0e62p-4,   0x1.ffff9cp-1, INEXACT)
T(RD, -0x1.0e4ce5cb8790ep+956,   -0x1.b77696bef0e63p-4, -0x1.8ddd8ap-19, INEXACT)
T(RZ, -0x1.e61f14f603c66p+864,   -0x1.6f5acbcf21de1p-1,  0x1.da9786p-22, INEXACT)
T(RU, -0x1.e61f14f603c66p+864,   -0x1.6f5acbcf21de1p-1,  0x1.da9786p-22, INEXACT)
T(RD, -0x1.e61f14f603c66p+864,   -0x1.6f5acbcf21de2p-1,  -0x1.fffff2p-1, INEXACT)
T(RZ,  0x1.65ebb7b75d288p+813,   -0x1.aeabcc53e0f41p-2,   0x1.ffffbap-1, INEXACT)
T(RU,  0x1.65ebb7b75d288p+813,   -0x1.aeabcc53e0f41p-2,   0x1.ffffbap-1, INEXACT)
T(RD,  0x1.65ebb7b75d288p+813,   -0x1.aeabcc53e0f42p-2, -0x1.176e3cp-19, INEXACT)
T(RZ,  -0x1.7f4fa3f8ca03p+148,   -0x1.9fb379773a97fp-1,  0x1.07af6cp-17, INEXACT)
T(RU,  -0x1.7f4fa3f8ca03p+148,   -0x1.9fb379773a97fp-1,  0x1.07af6cp-17, INEXACT)
T(RD,  -0x1.7f4fa3f8ca03p+148,    -0x1.9fb379773a98p-1,  -0x1.fffef8p-1, INEXACT)
T(RZ,  0x1.e05a3f4539912p+501,    0x1.99b20f1318a47p-1, -0x1.f7d362p-16, INEXACT)
T(RD,  0x1.e05a3f4539912p+501,    0x1.99b20f1318a47p-1, -0x1.f7d362p-16, INEXACT)
T(RU,  0x1.e05a3f4539912p+501,    0x1.99b20f1318a48p-1,    0x1.fffc1p-1, INEXACT)
T(RN,  -0x1.86c0e635c48a6p+94,   -0x1.b8e2b09a9341fp-1,  -0x1.fffafap-2, INEXACT)
T(RZ,  0x1.dd55c0f71c5afp+805,    0x1.fff4c755f499dp-1,  -0x1.fffe8ep-1, INEXACT)
T(RD,  0x1.dd55c0f71c5afp+805,    0x1.fff4c755f499dp-1,  -0x1.fffe8ep-1, INEXACT)
T(RU,  0x1.dd55c0f71c5afp+805,    0x1.fff4c755f499ep-1,  0x1.710732p-17, INEXACT)
T(RN,  0x1.55ddbd56a8bd4p+281,    0x1.c3a031a6e1076p-1,  -0x1.fffe68p-2, INEXACT)
T(RN,  0x1.40fd2dcc5e7edp+406,    0x1.69072536fa9d1p-1,   -0x1.fffc7p-2, INEXACT)
T(RN, -0x1.9f6dab9165317p+727,    0x1.f7d4d881b6563p-1,  -0x1.fffa38p-2, INEXACT)
T(RN,  0x1.49d4fe0f21f3bp+865,   -0x1.08b18c816a597p-5,  -0x1.fffb74p-2, INEXACT)
T(RN,  0x1.41d05912ec64ep+516,    0x1.ea53b22c90193p-1,  -0x1.ffff16p-2, INEXACT)
T(RN, -0x1.66ef8a78d7a28p+255,   -0x1.bc6224b636396p-1,  -0x1.fffbc8p-2, INEXACT)
T(RZ, -0x1.122ffcdcfefabp+935,   -0x1.dc5612941c7b9p-1,  0x1.308bccp-19, INEXACT)
T(RU, -0x1.122ffcdcfefabp+935,   -0x1.dc5612941c7b9p-1,  0x1.308bccp-19, INEXACT)
T(RD, -0x1.122ffcdcfefabp+935,   -0x1.dc5612941c7bap-1,  -0x1.ffffb4p-1, INEXACT)
T(RN,  0x1.78df316bb0073p+503,    0x1.b3bcfd1df726bp-2,  -0x1.fffcaap-2, INEXACT)
T(RN, -0x1.6f9f14fca129dp+126,   -0x1.d503655d4bcedp-2,  -0x1.fffc12p-2, INEXACT)
T(RZ, -0x1.857ee09706635p+682,   -0x1.ff7f056e0cf26p-1,  0x1.0ba57ep-17, INEXACT)
T(RU, -0x1.857ee09706635p+682,   -0x1.ff7f056e0cf26p-1,  0x1.0ba57ep-17, INEXACT)
T(RD, -0x1.857ee09706635p+682,   -0x1.ff7f056e0cf27p-1,  -0x1.fffef4p-1, INEXACT)
T(RZ,  0x1.1bfaac20ce716p+863,   -0x1.73653a4c0c37dp-2,  0x1.a3e81ap-17, INEXACT)
T(RU,  0x1.1bfaac20ce716p+863,   -0x1.73653a4c0c37dp-2,  0x1.a3e81ap-17, INEXACT)
T(RD,  0x1.1bfaac20ce716p+863,   -0x1.73653a4c0c37ep-2,  -0x1.fffe5cp-1, INEXACT)
T(RN, 0x1.c04166ee4d20ap+1002,    0x1.719d2a4b3370ep-3,  -0x1.fffca6p-2, INEXACT)
T(RN,  0x1.c53e9d8e88e05p+761,   -0x1.8caa093b0c277p-1,  -0x1.ffffbep-2, INEXACT)
T(RZ,  0x1.c809eaa0b3127p+780,    -0x1.a52f71e54438p-2,   0x1.fffecap-1, INEXACT)
T(RU,  0x1.c809eaa0b3127p+780,    -0x1.a52f71e54438p-2,   0x1.fffecap-1, INEXACT)
T(RD,  0x1.c809eaa0b3127p+780,   -0x1.a52f71e544381p-2, -0x1.36e656p-17, INEXACT)
T(RZ,  0x1.d6e0c9b0ba23ep+759,    0x1.b444a25702956p-1, -0x1.1919f6p-21, INEXACT)
T(RD,  0x1.d6e0c9b0ba23ep+759,    0x1.b444a25702956p-1, -0x1.1919f6p-21, INEXACT)
T(RU,  0x1.d6e0c9b0ba23ep+759,    0x1.b444a25702957p-1,   0x1.ffffeep-1, INEXACT)
T(RZ,  0x1.9a6d64084dbcep+312,   -0x1.912891703446ep-2,   0x1.fffe88p-1, INEXACT)
T(RU,  0x1.9a6d64084dbcep+312,   -0x1.912891703446ep-2,   0x1.fffe88p-1, INEXACT)
T(RD,  0x1.9a6d64084dbcep+312,   -0x1.912891703446fp-2, -0x1.77b362p-17, INEXACT)
T(RN, -0x1.a51043339ab4ap+387,   -0x1.2bc6a09773c74p-4,  -0x1.fffd3ap-2, INEXACT)
T(RN,  0x1.dc8d3612a8d49p+352,    0x1.da2e9a25a0becp-2,  -0x1.fffd5ap-2, INEXACT)
T(RN, 0x1.8585b6bf87af9p+1012,    0x1.d6bc528b0025bp-4,  -0x1.ffff74p-2, INEXACT)
T(RZ,  0x1.461815f79a766p+145,    0x1.50c6b37342116p-3,  -0x1.fffe5ap-1, INEXACT)
T(RD,  0x1.461815f79a766p+145,    0x1.50c6b37342116p-3,  -0x1.fffe5ap-1, INEXACT)
T(RU,  0x1.461815f79a766p+145,    0x1.50c6b37342117p-3,  0x1.a6e118p-17, INEXACT)
T(RN, -0x1.11bd5ae369105p+698,    0x1.c6351969ca6f2p-1,  -0x1.fffe86p-2, INEXACT)
T(RZ,  -0x1.61bfd24808cedp+49,   -0x1.aed7de17d552bp-1,   0x1.fffffap-1, INEXACT)
T(RU,  -0x1.61bfd24808cedp+49,   -0x1.aed7de17d552bp-1,   0x1.fffffap-1, INEXACT)
T(RD,  -0x1.61bfd24808cedp+49,   -0x1.aed7de17d552cp-1, -0x1.a66a58p-23, INEXACT)
T(RZ, -0x1.794171712029ep+551,    0x1.d1adc130fd36ap-1,  -0x1.fffe5cp-1, INEXACT)
T(RD, -0x1.794171712029ep+551,    0x1.d1adc130fd36ap-1,  -0x1.fffe5cp-1, INEXACT)
T(RU, -0x1.794171712029ep+551,    0x1.d1adc130fd36bp-1,  0x1.a48e76p-17, INEXACT)
T(RZ,  0x1.1d4a74d3afd28p+372,    0x1.03ec0d38b62dap-6,  -0x1.ffff12p-1, INEXACT)
T(RD,  0x1.1d4a74d3afd28p+372,    0x1.03ec0d38b62dap-6,  -0x1.ffff12p-1, INEXACT)
T(RU,  0x1.1d4a74d3afd28p+372,    0x1.03ec0d38b62dbp-6,  0x1.dad20cp-18, INEXACT)
T(RZ,  0x1.c463c34ab04a1p+715,    0x1.a84311e09007bp-1, -0x1.b110c4p-17, INEXACT)
T(RD,  0x1.c463c34ab04a1p+715,    0x1.a84311e09007bp-1, -0x1.b110c4p-17, INEXACT)
T(RU,  0x1.c463c34ab04a1p+715,    0x1.a84311e09007cp-1,   0x1.fffe4ep-1, INEXACT)
T(RZ, -0x1.2efb75bcce48ep+386,     0x1.fee894e59a9fp-1, -0x1.8935ecp-18, INEXACT)
T(RD, -0x1.2efb75bcce48ep+386,     0x1.fee894e59a9fp-1, -0x1.8935ecp-18, INEXACT)
T(RU, -0x1.2efb75bcce48ep+386,    0x1.fee894e59a9f1p-1,   0x1.ffff3cp-1, INEXACT)
T(RN, -0x1.0a9100daeb424p+895,   -0x1.bc80cb52601d5p-1,  -0x1.fffdacp-2, INEXACT)
T(RZ,   0x1.5aed070073b97p+64,   -0x1.f8cadb619d841p-1,   0x1.fffebap-1, INEXACT)
T(RU,   0x1.5aed070073b97p+64,   -0x1.f8cadb619d841p-1,   0x1.fffebap-1, INEXACT)
T(RD,   0x1.5aed070073b97p+64,   -0x1.f8cadb619d842p-1, -0x1.457732p-17, INEXACT)
T(RN, -0x1.a5960560327b6p+821,   -0x1.364c860eeb42bp-1,  -0x1.fffd28p-2, INEXACT)
T(RN, -0x1.80b6ebec05a7ep+861,    0x1.267348151899bp-2,  -0x1.fffd44p-2, INEXACT)
T(RN,  0x1.19a00ecfea982p+548,   -0x1.e74bb650a939ap-1,    -0x1.fffcp-2, INEXACT)
T(RZ,  0x1.7b3f208e2b0d6p+685,   -0x1.6a263ded10ca5p-1,   0x1.ffff98p-1, INEXACT)
T(RU,  0x1.7b3f208e2b0d6p+685,   -0x1.6a263ded10ca5p-1,   0x1.ffff98p-1, INEXACT)
T(RD,  0x1.7b3f208e2b0d6p+685,   -0x1.6a263ded10ca6p-1, -0x1.9d2996p-19, INEXACT)
T(RZ,  0x1.5ced1ff27c88cp+928,    0x1.a2b0413f38be9p-3,  -0x1.fffe3ep-1, INEXACT)
T(RD,  0x1.5ced1ff27c88cp+928,    0x1.a2b0413f38be9p-3,  -0x1.fffe3ep-1, INEXACT)
T(RU,  0x1.5ced1ff27c88cp+928,    0x1.a2b0413f38beap-3,  0x1.c1581ap-17, INEXACT)
T(RN,  0x1.4d7fd17e2e6fcp+249,    0x1.4dfc819475cdfp-1,  -0x1.fffedcp-2, INEXACT)
T(RZ, -0x1.5beaf657aad7bp+531,   -0x1.fe7a509de5444p-1,   0x1.fffe98p-1, INEXACT)
T(RU, -0x1.5beaf657aad7bp+531,   -0x1.fe7a509de5444p-1,   0x1.fffe98p-1, INEXACT)
T(RD, -0x1.5beaf657aad7bp+531,   -0x1.fe7a509de5445p-1, -0x1.67bdaep-17, INEXACT)
T(RZ,  0x1.f5f0732e4e7b2p+551,    0x1.c3936c17d0181p-1, -0x1.cc14aap-25, INEXACT)
T(RD,  0x1.f5f0732e4e7b2p+551,    0x1.c3936c17d0181p-1, -0x1.cc14aap-25, INEXACT)
T(RU,  0x1.f5f0732e4e7b2p+551,    0x1.c3936c17d0182p-1,   0x1.fffffep-1, INEXACT)
T(RZ,  0x1.923aa30baa3b1p+677,   -0x1.c496997bd7975p-4,  0x1.6d2fecp-19, INEXACT)
T(RU,  0x1.923aa30baa3b1p+677,   -0x1.c496997bd7975p-4,  0x1.6d2fecp-19, INEXACT)
T(RD,  0x1.923aa30baa3b1p+677,   -0x1.c496997bd7976p-4,  -0x1.ffffa4p-1, INEXACT)
T(RN, -0x1.f189237474899p+930,    0x1.2d3c7c8df826ap-1,  -0x1.fffda6p-2, INEXACT)
T(RZ,  0x1.11512bddf0a97p+922,    0x1.ecdcddd6234a1p-1, -0x1.5dd55ep-17, INEXACT)
T(RD,  0x1.11512bddf0a97p+922,    0x1.ecdcddd6234a1p-1, -0x1.5dd55ep-17, INEXACT)
T(RU,  0x1.11512bddf0a97p+922,    0x1.ecdcddd6234a2p-1,   0x1.fffea2p-1, INEXACT)
T(RZ,   0x1.fb1687c15ed7p+472,    0x1.73670bff2a42bp-1,  -0x1.fffebap-1, INEXACT)
T(RD,   0x1.fb1687c15ed7p+472,    0x1.73670bff2a42bp-1,  -0x1.fffebap-1, INEXACT)
T(RU,   0x1.fb1687c15ed7p+472,    0x1.73670bff2a42cp-1,  0x1.4621e2p-17, INEXACT)
T(RN, -0x1.393aa1eae75dfp+929,    0x1.73b4745a9a824p-1,  -0x1.fffc48p-2, INEXACT)
T(RN, -0x1.5aac20505e518p+453,    0x1.c0c3594bad917p-3,  -0x1.ffff2ap-2, INEXACT)
T(RN,    0x1.346df93ba4f86p+1,   -0x1.7cd9ab20271fdp-1,  -0x1.fffe76p-2, INEXACT)
T(RN,  0x1.b1d88666ba1e8p+528,    0x1.cc26593afbc9bp-1,  -0x1.fffd72p-2, INEXACT)
T(RN,  0x1.513c5228383a7p+346,   -0x1.50f4b03727327p-2,  -0x1.fffc14p-2, INEXACT)
T(RN, -0x1.4c1426d444a77p+697,    0x1.819483235f641p-1,    -0x1.fffcp-2, INEXACT)
T(RZ, -0x1.7410d99f65b1ap+148,     0x1.0374c45152d5p-1,  -0x1.ffff32p-1, INEXACT)
T(RD, -0x1.7410d99f65b1ap+148,     0x1.0374c45152d5p-1,  -0x1.ffff32p-1, INEXACT)
T(RU, -0x1.7410d99f65b1ap+148,    0x1.0374c45152d51p-1,  0x1.9a730cp-18, INEXACT)
T(RZ,  -0x1.68bb7d895aa5p+812,    0x1.98fed3a5ee4c6p-1,  -0x1.437fep-19, INEXACT)
T(RD,  -0x1.68bb7d895aa5p+812,    0x1.98fed3a5ee4c6p-1,  -0x1.437fep-19, INEXACT)
T(RU,  -0x1.68bb7d895aa5p+812,    0x1.98fed3a5ee4c7p-1,    0x1.ffffbp-1, INEXACT)
T(RN,  0x1.e56f1a90fc6b3p+525,    0x1.491fa7468fb39p-1,  -0x1.ffff52p-2, INEXACT)
T(RN,  -0x1.310634a784e26p+41,    0x1.e3de91425c90ap-1,  -0x1.ffff9cp-2, INEXACT)
T(RZ,  0x1.a1e33c7d554ddp+505,    0x1.050c9fbfb7eb1p-1,  -0x1.ffff4ep-1, INEXACT)
T(RD,  0x1.a1e33c7d554ddp+505,    0x1.050c9fbfb7eb1p-1,  -0x1.ffff4ep-1, INEXACT)
T(RU,  0x1.a1e33c7d554ddp+505,    0x1.050c9fbfb7eb2p-1,  0x1.6317fap-18, INEXACT)
T(RN,  0x1.0e322760dc6efp+824,   -0x1.af4541fd39162p-1,  -0x1.fffe78p-2, INEXACT)
T(RN, -0x1.8e9cdf7f6a448p+575,    0x1.5e063ab858877p-1,  -0x1.ffff6ap-2, INEXACT)
T(RZ,   0x1.25d58ebe0a3f9p+15,    0x1.dda3163ed5d27p-1, -0x1.7ceab4p-18, INEXACT)
T(RD,   0x1.25d58ebe0a3f9p+15,    0x1.dda3163ed5d27p-1, -0x1.7ceab4p-18, INEXACT)
T(RU,   0x1.25d58ebe0a3f9p+15,    0x1.dda3163ed5d28p-1,   0x1.ffff42p-1, INEXACT)
T(RZ,  0x1.68b5aba76177dp+789,    0x1.55d3d43853304p-1, -0x1.264118p-19, INEXACT)
T(RD,  0x1.68b5aba76177dp+789,    0x1.55d3d43853304p-1, -0x1.264118p-19, INEXACT)
T(RU,  0x1.68b5aba76177dp+789,    0x1.55d3d43853305p-1,   0x1.ffffb6p-1, INEXACT)
T(RZ, -0x1.db356b127afb1p+674,    0x1.fffcaa32ec7b6p-1,  -0x1.ffff4cp-1, INEXACT)
T(RD, -0x1.db356b127afb1p+674,    0x1.fffcaa32ec7b6p-1,  -0x1.ffff4cp-1, INEXACT)
T(RU, -0x1.db356b127afb1p+674,    0x1.fffcaa32ec7b7p-1,   0x1.6923bp-18, INEXACT)
T(RZ, -0x1.d44a6360fa814p+809,    0x1.f87f23d63272ep-1,  -0x1.fffff8p-1, INEXACT)
T(RD, -0x1.d44a6360fa814p+809,    0x1.f87f23d63272ep-1,  -0x1.fffff8p-1, INEXACT)
T(RU, -0x1.d44a6360fa814p+809,    0x1.f87f23d63272fp-1,  0x1.0886b8p-22, INEXACT)
T(RZ,   0x1.60a5b1505836p+184,   -0x1.f602c6f21fa3dp-2,  0x1.328a98p-19, INEXACT)
T(RU,   0x1.60a5b1505836p+184,   -0x1.f602c6f21fa3dp-2,  0x1.328a98p-19, INEXACT)
T(RD,   0x1.60a5b1505836p+184,   -0x1.f602c6f21fa3ep-2,  -0x1.ffffb4p-1, INEXACT)
T(RZ,  0x1.725d5d9a7ef05p+514,    0x1.b5e9ee5a80b3cp-1,  -0x1.ffff9ep-1, INEXACT)
T(RD,  0x1.725d5d9a7ef05p+514,    0x1.b5e9ee5a80b3cp-1,  -0x1.ffff9ep-1, INEXACT)
T(RU,  0x1.725d5d9a7ef05p+514,    0x1.b5e9ee5a80b3dp-1,  0x1.8531a8p-19, INEXACT)
T(RN, -0x1.1a677f2072754p+218,    0x1.46b7c90eaab5bp-1,  -0x1.ffff04p-2, INEXACT)
T(RN, -0x1.71e1ec640185fp+663,   -0x1.7e28b4781bfd3p-2,  -0x1.ffffa6p-2, INEXACT)
T(RN, -0x1.65ffcba2c14edp+495,   -0x1.e84c64861391ap-1,  -0x1.ffff92p-2, INEXACT)
T(RZ, -0x1.f106c1fa07065p+923,    0x1.e0261e0e8d947p-1,   -0x1.ffff4p-1, INEXACT)
T(RD, -0x1.f106c1fa07065p+923,    0x1.e0261e0e8d947p-1,   -0x1.ffff4p-1, INEXACT)
T(RU, -0x1.f106c1fa07065p+923,    0x1.e0261e0e8d948p-1,  0x1.814a8ap-18, INEXACT)
T(RZ,   0x1.87364becc33ep+710,     0x1.fbb0d28d22d5p-1,  -0x1.ffff0cp-1, INEXACT)
T(RD,   0x1.87364becc33ep+710,     0x1.fbb0d28d22d5p-1,  -0x1.ffff0cp-1, INEXACT)
T(RU,   0x1.87364becc33ep+710,    0x1.fbb0d28d22d51p-1,  0x1.e9bef4p-18, INEXACT)
T(RZ,  -0x1.95c9f38317a3p+235,    0x1.80d8703d7a6eap-1, -0x1.70fbcap-18, INEXACT)
T(RD,  -0x1.95c9f38317a3p+235,    0x1.80d8703d7a6eap-1, -0x1.70fbcap-18, INEXACT)
T(RU,  -0x1.95c9f38317a3p+235,    0x1.80d8703d7a6ebp-1,   0x1.ffff48p-1, INEXACT)
T(RZ, -0x1.ff418adbc1b21p+734,   -0x1.e688957ea66a5p-1,  0x1.d42124p-18, INEXACT)
T(RU, -0x1.ff418adbc1b21p+734,   -0x1.e688957ea66a5p-1,  0x1.d42124p-18, INEXACT)
T(RD, -0x1.ff418adbc1b21p+734,   -0x1.e688957ea66a6p-1,  -0x1.ffff16p-1, INEXACT)
T(RZ,  0x1.c1d5d4a7a3b61p+338,    0x1.fffd5311aec16p-1, -0x1.18b00ep-20, INEXACT)
T(RD,  0x1.c1d5d4a7a3b61p+338,    0x1.fffd5311aec16p-1, -0x1.18b00ep-20, INEXACT)
T(RU,  0x1.c1d5d4a7a3b61p+338,    0x1.fffd5311aec17p-1,   0x1.ffffdcp-1, INEXACT)
T(RN,  0x1.d2492f126901bp+658,    0x1.9030614f68664p-4,  -0x1.fffeeep-2, INEXACT)
T(RN,  0x1.03dbc3a73522fp+636,   -0x1.3c9fa12d95d6ap-2,  -0x1.fffebap-2, INEXACT)
T(RZ, -0x1.f6ddb02377f5bp+974,    0x1.d78dd9a427567p-1,    -0x1.ffffp-1, INEXACT)
T(RD, -0x1.f6ddb02377f5bp+974,    0x1.d78dd9a427567p-1,    -0x1.ffffp-1, INEXACT)
T(RU, -0x1.f6ddb02377f5bp+974,    0x1.d78dd9a427568p-1,  0x1.feeeccp-18, INEXACT)
T(RN, -0x1.c34f569c52e45p+190,   -0x1.05cd8190a464fp-3,  -0x1.fffe72p-2, INEXACT)
T(RZ,  -0x1.ba0d6570175cbp+98,    0x1.fec61c0451c46p-1, -0x1.a1d19ap-18, INEXACT)
T(RD,  -0x1.ba0d6570175cbp+98,    0x1.fec61c0451c46p-1, -0x1.a1d19ap-18, INEXACT)
T(RU,  -0x1.ba0d6570175cbp+98,    0x1.fec61c0451c47p-1,    0x1.ffff3p-1, INEXACT)
T(RZ, -0x1.6080c39cbfefap+937,   -0x1.8a8d245ad18cap-4,   0x1.ffffaep-1, INEXACT)
T(RU, -0x1.6080c39cbfefap+937,   -0x1.8a8d245ad18cap-4,   0x1.ffffaep-1, INEXACT)
T(RD, -0x1.6080c39cbfefap+937,   -0x1.8a8d245ad18cbp-4, -0x1.441cd8p-19, INEXACT)
T(RN,  0x1.852f39a98ca63p+801,    0x1.4013e08f4ca57p-1,  -0x1.ffffdap-2, INEXACT)
T(RN,  0x1.26246a41cb2cdp+401,   -0x1.8513d2d04425fp-1,  -0x1.ffff94p-2, INEXACT)
T(RZ, -0x1.d0d4c2067335cp+230,    0x1.f3064db929628p-1,  -0x1.ffff5ep-1, INEXACT)
T(RD, -0x1.d0d4c2067335cp+230,    0x1.f3064db929628p-1,  -0x1.ffff5ep-1, INEXACT)
T(RU, -0x1.d0d4c2067335cp+230,    0x1.f3064db929629p-1,   0x1.43b1ep-18, INEXACT)
T(RZ,  0x1.c94d306f1d464p+161,    0x1.cab5ae8a871bdp-1,  -0x1.ffff14p-1, INEXACT)
T(RD,  0x1.c94d306f1d464p+161,    0x1.cab5ae8a871bdp-1,  -0x1.ffff14p-1, INEXACT)
T(RU,  0x1.c94d306f1d464p+161,    0x1.cab5ae8a871bep-1,  0x1.d6a0e4p-18, INEXACT)
T(RZ, -0x1.df76061ec1015p+540,    0x1.fe37add996cb3p-1,  -0x1.b45adp-20, INEXACT)
T(RD, -0x1.df76061ec1015p+540,    0x1.fe37add996cb3p-1,  -0x1.b45adp-20, INEXACT)
T(RU, -0x1.df76061ec1015p+540,    0x1.fe37add996cb4p-1,   0x1.ffffcap-1, INEXACT)
T(RN,  0x1.e3fe2f36b5e4bp+255,    0x1.fe6c4ec983cd7p-1,  -0x1.fffe06p-2, INEXACT)
T(RN,  -0x1.b1136fedea306p+91,    0x1.8b7f3ceb505cap-5,  -0x1.fffe58p-2, INEXACT)
T(RN,  0x1.bd42823ac5efep+944,   -0x1.6bcc9fdc79f29p-1,  -0x1.ffff62p-2, INEXACT)
T(RN, -0x1.3a5113083f306p+129,   -0x1.a6abc4e82834fp-1,  -0x1.ffffa4p-2, INEXACT)
T(RN,  0x1.4764d910dc162p+281,   -0x1.ff1d908327458p-1,   -0x1.ffff1p-2, INEXACT)
T(RN,  0x1.374b8a5e2caacp+378,   -0x1.ff75b04a5ad32p-1,  -0x1.fffe1ep-2, INEXACT)
T(RN,  0x1.0c2266247fa89p+636,    0x1.ff3efbef44875p-1,  -0x1.fffe5ap-2, INEXACT)
T(RN,-0x1.39e7dfb099943p+1023,   -0x1.70cf252e20d13p-1,   -0x1.fffebp-2, INEXACT)
T(RN, -0x1.503ec22e05eddp+793,    0x1.ecba8d73f5b21p-1,  -0x1.ffffdcp-2, INEXACT)
T(RZ,-0x1.ad2ab1e120311p+1018,   -0x1.fd1fca48dc512p-1,  0x1.d7876cp-20, INEXACT)
T(RU,-0x1.ad2ab1e120311p+1018,   -0x1.fd1fca48dc512p-1,  0x1.d7876cp-20, INEXACT)
T(RD,-0x1.ad2ab1e120311p+1018,   -0x1.fd1fca48dc513p-1,  -0x1.ffffc6p-1, INEXACT)
T(RN,  0x1.e56c1495abe88p+902,    0x1.4606376e4f9b6p-2,  -0x1.ffff5ap-2, INEXACT)
T(RZ, 0x1.0970a2e9d9644p+1003,    0x1.696d9d7bb6eccp-6, -0x1.c1ac9cp-22, INEXACT)
T(RD, 0x1.0970a2e9d9644p+1003,    0x1.696d9d7bb6eccp-6, -0x1.c1ac9cp-22, INEXACT)
T(RU, 0x1.0970a2e9d9644p+1003,    0x1.696d9d7bb6ecdp-6,   0x1.fffff2p-1, INEXACT)
T(RZ, -0x1.1f300db78da11p+239,   -0x1.fcc4c5ef678a5p-1,   0x1.9b387p-19, INEXACT)
T(RU, -0x1.1f300db78da11p+239,   -0x1.fcc4c5ef678a5p-1,   0x1.9b387p-19, INEXACT)
T(RD, -0x1.1f300db78da11p+239,   -0x1.fcc4c5ef678a6p-1,  -0x1.ffff9ap-1, INEXACT)
T(RZ, -0x1.16e31daf4c504p+887,    0x1.06b97c9adcca7p-1, -0x1.e7e52cp-22, INEXACT)
T(RD, -0x1.16e31daf4c504p+887,    0x1.06b97c9adcca7p-1, -0x1.e7e52cp-22, INEXACT)
T(RU, -0x1.16e31daf4c504p+887,    0x1.06b97c9adcca8p-1,    0x1.fffffp-1, INEXACT)
T(RZ, -0x1.27c8bef3768a7p+286,    0x1.c0d5818640741p-1, -0x1.b02bf8p-20, INEXACT)
T(RD, -0x1.27c8bef3768a7p+286,    0x1.c0d5818640741p-1, -0x1.b02bf8p-20, INEXACT)
T(RU, -0x1.27c8bef3768a7p+286,    0x1.c0d5818640742p-1,   0x1.ffffcap-1, INEXACT)
T(RZ,  0x1.87972a046090dp+111,    0x1.fe698cb9621dap-1,  -0x1.ffffa8p-1, INEXACT)
T(RD,  0x1.87972a046090dp+111,    0x1.fe698cb9621dap-1,  -0x1.ffffa8p-1, INEXACT)
T(RU,  0x1.87972a046090dp+111,    0x1.fe698cb9621dbp-1,  0x1.5d63fcp-19, INEXACT)
T(RZ,  0x1.bbea2c413b1bdp+129,   -0x1.5369cfc2196adp-2,  0x1.1864c2p-20, INEXACT)
T(RU,  0x1.bbea2c413b1bdp+129,   -0x1.5369cfc2196adp-2,  0x1.1864c2p-20, INEXACT)
T(RD,  0x1.bbea2c413b1bdp+129,   -0x1.5369cfc2196aep-2,  -0x1.ffffdcp-1, INEXACT)
T(RZ,  0x1.11d00e7441e78p+889,   -0x1.ced614dab0abbp-2,   0x1.ffffe4p-1, INEXACT)
T(RU,  0x1.11d00e7441e78p+889,   -0x1.ced614dab0abbp-2,   0x1.ffffe4p-1, INEXACT)
T(RD,  0x1.11d00e7441e78p+889,   -0x1.ced614dab0abcp-2, -0x1.b4c0cap-21, INEXACT)
T(RZ, -0x1.bb947776d0bbep+303,    0x1.243d6f6a420c2p-1, -0x1.bf793cp-19, INEXACT)
T(RD, -0x1.bb947776d0bbep+303,    0x1.243d6f6a420c2p-1, -0x1.bf793cp-19, INEXACT)
T(RU, -0x1.bb947776d0bbep+303,    0x1.243d6f6a420c3p-1,    0x1.ffff9p-1, INEXACT)
T(RN,  0x1.c13793c73bd5cp+125,    0x1.2abec48b35978p-1,  -0x1.ffff5cp-2, INEXACT)
T(RN, -0x1.2b080153844d2p+723,   -0x1.aa1355e2b1861p-1,   -0x1.ffffep-2, INEXACT)
T(RN, -0x1.ee022a9586d13p+186,    0x1.9eaa45422bd6cp-1,  -0x1.ffffd2p-2, INEXACT)
T(RZ,  -0x1.744971fd4f5aep+63,   -0x1.fff66824eba8fp-1,  0x1.003384p-19, INEXACT)
T(RU,  -0x1.744971fd4f5aep+63,   -0x1.fff66824eba8fp-1,  0x1.003384p-19, INEXACT)
T(RD,  -0x1.744971fd4f5aep+63,    -0x1.fff66824eba9p-1,   -0x1.ffffcp-1, INEXACT)
T(RZ,  0x1.23a73c4876acdp+991,    -0x1.c4e54ef937e2p-2,   0x1.ffffa2p-1, INEXACT)
T(RU,  0x1.23a73c4876acdp+991,    -0x1.c4e54ef937e2p-2,   0x1.ffffa2p-1, INEXACT)
T(RD,  0x1.23a73c4876acdp+991,   -0x1.c4e54ef937e21p-2, -0x1.754052p-19, INEXACT)
T(RZ, 0x1.4a9b551a22accp+1022,    0x1.c6450c38c1ba5p-1,  -0x1.ffffb6p-1, INEXACT)
T(RD, 0x1.4a9b551a22accp+1022,    0x1.c6450c38c1ba5p-1,  -0x1.ffffb6p-1, INEXACT)
T(RU, 0x1.4a9b551a22accp+1022,    0x1.c6450c38c1ba6p-1,  0x1.296ee8p-19, INEXACT)
T(RZ, -0x1.60cac398e07dap+331,    0x1.19ce4d8b9d47dp-2, -0x1.3c4dbap-23, INEXACT)
T(RD, -0x1.60cac398e07dap+331,    0x1.19ce4d8b9d47dp-2, -0x1.3c4dbap-23, INEXACT)
T(RU, -0x1.60cac398e07dap+331,    0x1.19ce4d8b9d47ep-2,   0x1.fffffcp-1, INEXACT)
T(RN,  -0x1.e08ffd73345d8p+91,   -0x1.1eaef90bd0107p-3,   -0x1.ffffap-2, INEXACT)
T(RZ,  -0x1.09d445998ebcep+46,   -0x1.fe2ce9d1da2d6p-1,  0x1.bf0332p-19, INEXACT)
T(RU,  -0x1.09d445998ebcep+46,   -0x1.fe2ce9d1da2d6p-1,  0x1.bf0332p-19, INEXACT)
T(RD,  -0x1.09d445998ebcep+46,   -0x1.fe2ce9d1da2d7p-1,   -0x1.ffff9p-1, INEXACT)
T(RN,  0x1.2914c6ee60463p+865,   0x1.465aa921c5339p-10,  -0x1.ffff5ap-2, INEXACT)
T(RN, -0x1.5b9026d43faa1p+369,    0x1.a1ecb3b48d384p-2,  -0x1.ffffb2p-2, INEXACT)
T(RZ,  0x1.2caa960ca3157p+369,   -0x1.a1d62d84c1f52p-3,    0x1.ffffep-1, INEXACT)
T(RU,  0x1.2caa960ca3157p+369,   -0x1.a1d62d84c1f52p-3,    0x1.ffffep-1, INEXACT)
T(RD,  0x1.2caa960ca3157p+369,   -0x1.a1d62d84c1f53p-3, -0x1.fb9336p-21, INEXACT)
T(RZ,  0x1.ef5734a47a5dep+601,    0x1.f98493e7ee4b5p-1, -0x1.0d68ecp-19, INEXACT)
T(RD,  0x1.ef5734a47a5dep+601,    0x1.f98493e7ee4b5p-1, -0x1.0d68ecp-19, INEXACT)
T(RU,  0x1.ef5734a47a5dep+601,    0x1.f98493e7ee4b6p-1,   0x1.ffffbcp-1, INEXACT)
T(RZ,  -0x1.56fbc559fe98p+654,   -0x1.c4b5ccc4fff67p-1,   0x1.fffffcp-1, INEXACT)
T(RU,  -0x1.56fbc559fe98p+654,   -0x1.c4b5ccc4fff67p-1,   0x1.fffffcp-1, INEXACT)
T(RD,  -0x1.56fbc559fe98p+654,   -0x1.c4b5ccc4fff68p-1, -0x1.25902ep-23, INEXACT)
T(RZ,   0x1.cc8ad39f7ecap+412,   -0x1.a7f77f146445ap-2,  0x1.53e856p-19, INEXACT)
T(RU,   0x1.cc8ad39f7ecap+412,   -0x1.a7f77f146445ap-2,  0x1.53e856p-19, INEXACT)
T(RD,   0x1.cc8ad39f7ecap+412,   -0x1.a7f77f146445bp-2,  -0x1.ffffacp-1, INEXACT)
T(RN,  0x1.659717dec33d5p+432,    0x1.4c94a61f0a132p-1,  -0x1.ffff92p-2, INEXACT)
T(RZ,  0x1.94c65561aa35ap+799,   -0x1.dd85a2981b5b3p-3,  0x1.defd3cp-21, INEXACT)
T(RU,  0x1.94c65561aa35ap+799,   -0x1.dd85a2981b5b3p-3,  0x1.defd3cp-21, INEXACT)
T(RD,  0x1.94c65561aa35ap+799,   -0x1.dd85a2981b5b4p-3,  -0x1.ffffe2p-1, INEXACT)
T(RN,  0x1.2d52d5f4f842ap+414,    0x1.58c51520eae1cp-1,  -0x1.ffff8ep-2, INEXACT)
T(RZ,  0x1.25397f1025327p+999,   -0x1.8190037e8264ap-1,   0x1.ffffaep-1, INEXACT)
T(RU,  0x1.25397f1025327p+999,   -0x1.8190037e8264ap-1,   0x1.ffffaep-1, INEXACT)
T(RD,  0x1.25397f1025327p+999,   -0x1.8190037e8264bp-1, -0x1.47bc2cp-19, INEXACT)
T(RN,  -0x1.7487e1f205655p+50,    0x1.d311c10ee22d5p-4,  -0x1.ffff9ap-2, INEXACT)
T(RN, -0x1.248c40f1c9415p+260,    0x1.21460cc66adabp-1,  -0x1.ffff86p-2, INEXACT)
T(RN,  0x1.53a71af27167bp+301,   -0x1.3ab3bd22dbb6cp-1,  -0x1.ffff8ep-2, INEXACT)
T(RN,   0x1.cd7277f88adcp+928,    0x1.b1b66885e3943p-1,  -0x1.ffff4ep-2, INEXACT)
T(RN,  0x1.f07f683f800f4p+604,   -0x1.1c47469433dbdp-1,   -0x1.ffff4p-2, INEXACT)
T(RN, -0x1.5f4eba6556329p+189,   -0x1.6aab07381aa2cp-4,   -0x1.ffff6p-2, INEXACT)
T(RN,    0x1.1a640e2fb4c07p+9,    0x1.85f265fc2657bp-1,  -0x1.ffff3ap-2, INEXACT)
T(RN, -0x1.753b2a9c82b19p+948,    -0x1.dabdc3bfd342p-4,  -0x1.ffff4ep-2, INEXACT)
T(RN, 0x1.aea64fa2a4878p+1010,     0x1.e550fa32cd1fp-1,   -0x1.fffffp-2, INEXACT)
T(RN, -0x1.a0df3dce8c923p+299,    0x1.d4046ca3c6cc9p-1,  -0x1.ffff68p-2, INEXACT)
T(RN, -0x1.c8066f9a715fep+298,    0x1.fede8722a83aep-1,  -0x1.ffffdep-2, INEXACT)
T(RN, -0x1.ebf63aadf4605p+956,   -0x1.31646e224e379p-1,  -0x1.ffffaap-2, INEXACT)
T(RN, -0x1.2179319f5eebfp+241,    -0x1.5946b3f1c76dp-1,  -0x1.ffff98p-2, INEXACT)
T(RZ, -0x1.eca3ecd8a53ecp+775,   -0x1.2bf4b5f71eae1p-1,  0x1.7a0074p-24, INEXACT)
T(RU, -0x1.eca3ecd8a53ecp+775,   -0x1.2bf4b5f71eae1p-1,  0x1.7a0074p-24, INEXACT)
T(RD, -0x1.eca3ecd8a53ecp+775,   -0x1.2bf4b5f71eae2p-1,  -0x1.fffffep-1, INEXACT)
T(RN,  0x1.83bda70f65b3bp+532,    0x1.0a3d8a72990eap-2,   -0x1.ffff9p-2, INEXACT)
T(RN,  0x1.6d2d60e1757fap+614,    0x1.2671b8504dd09p-1,  -0x1.ffffb8p-2, INEXACT)
T(RZ,  0x1.7c621de65e20bp+888,    0x1.dedda9b18b56fp-1, -0x1.d859e4p-20, INEXACT)
T(RD,  0x1.7c621de65e20bp+888,    0x1.dedda9b18b56fp-1, -0x1.d859e4p-20, INEXACT)
T(RU,  0x1.7c621de65e20bp+888,     0x1.dedda9b18b57p-1,   0x1.ffffc4p-1, INEXACT)
T(RZ,   0x1.a1ac8fadde3bp+449,    0x1.e5cc76dfe5ce9p-1,   -0x1.fffffp-1, INEXACT)
T(RD,   0x1.a1ac8fadde3bp+449,    0x1.e5cc76dfe5ce9p-1,   -0x1.fffffp-1, INEXACT)
T(RU,   0x1.a1ac8fadde3bp+449,    0x1.e5cc76dfe5ceap-1,  0x1.f16fb6p-22, INEXACT)
T(RN,  0x1.50415035b3801p+624,    0x1.9c60442024446p-2,  -0x1.ffff82p-2, INEXACT)
T(RZ, -0x1.5ff0d10919c42p+742,    0x1.23134059082c8p-1, -0x1.93bffep-21, INEXACT)
T(RD, -0x1.5ff0d10919c42p+742,    0x1.23134059082c8p-1, -0x1.93bffep-21, INEXACT)
T(RU, -0x1.5ff0d10919c42p+742,    0x1.23134059082c9p-1,   0x1.ffffe6p-1, INEXACT)
T(RN,  0x1.f8a3ba9717756p+626,   -0x1.fe89577838e2cp-1,   -0x1.ffff9p-2, INEXACT)
T(RZ,   0x1.35691caf2af1p+619,    0x1.2d6bfdae8bb14p-1, -0x1.51811ap-23, INEXACT)
T(RD,   0x1.35691caf2af1p+619,    0x1.2d6bfdae8bb14p-1, -0x1.51811ap-23, INEXACT)
T(RU,   0x1.35691caf2af1p+619,    0x1.2d6bfdae8bb15p-1,   0x1.fffffap-1, INEXACT)
T(RN,  -0x1.277576ca8c93p+258,   -0x1.0aeb293e7e8e4p-1,  -0x1.ffff8ep-2, INEXACT)
T(RZ,  0x1.46ac95f084decp+929,   -0x1.3393e63eba8c9p-1,   0x1.ffffc8p-1, INEXACT)
T(RU,  0x1.46ac95f084decp+929,   -0x1.3393e63eba8c9p-1,   0x1.ffffc8p-1, INEXACT)
T(RD,  0x1.46ac95f084decp+929,   -0x1.3393e63eba8cap-1, -0x1.c0182ap-20, INEXACT)
T(RZ,  0x1.83ead4267b4f9p+464,   -0x1.f7b9f6b040c97p-1,  0x1.f6e4b4p-20, INEXACT)
T(RU,  0x1.83ead4267b4f9p+464,   -0x1.f7b9f6b040c97p-1,  0x1.f6e4b4p-20, INEXACT)
T(RD,  0x1.83ead4267b4f9p+464,   -0x1.f7b9f6b040c98p-1,  -0x1.ffffc2p-1, INEXACT)
T(RZ, -0x1.4a85439884a27p+366,    0x1.75842cea69269p-1,  -0x1.ffffecp-1, INEXACT)
T(RD, -0x1.4a85439884a27p+366,    0x1.75842cea69269p-1,  -0x1.ffffecp-1, INEXACT)
T(RU, -0x1.4a85439884a27p+366,    0x1.75842cea6926ap-1,  0x1.32c58ap-21, INEXACT)
T(RN,  0x1.c8d2b3f6a1f6cp+129,    0x1.fd53f7e45d7ebp-1,  -0x1.ffff9cp-2, INEXACT)
T(RZ, -0x1.c7c4229629dffp+762,    0x1.ccd105cefc934p-2,  -0x1.ffffd2p-1, INEXACT)
T(RD, -0x1.c7c4229629dffp+762,    0x1.ccd105cefc934p-2,  -0x1.ffffd2p-1, INEXACT)
T(RU, -0x1.c7c4229629dffp+762,    0x1.ccd105cefc935p-2,  0x1.716042p-20, INEXACT)
T(RZ, -0x1.51c9b23fe1ad9p+226,    0x1.bb85b2e3c1693p-2,  -0x1.ffffdep-1, INEXACT)
T(RD, -0x1.51c9b23fe1ad9p+226,    0x1.bb85b2e3c1693p-2,  -0x1.ffffdep-1, INEXACT)
T(RU, -0x1.51c9b23fe1ad9p+226,    0x1.bb85b2e3c1694p-2,  0x1.0dce4ep-20, INEXACT)
T(RZ, -0x1.24f545a524dc8p+844,    0x1.6a26cb0d36f48p-1, -0x1.cecadcp-20, INEXACT)
T(RD, -0x1.24f545a524dc8p+844,    0x1.6a26cb0d36f48p-1, -0x1.cecadcp-20, INEXACT)
T(RU, -0x1.24f545a524dc8p+844,    0x1.6a26cb0d36f49p-1,   0x1.ffffc6p-1, INEXACT)
T(RZ,  0x1.2a115e02a9d06p+604,    0x1.7724160f38988p-1, -0x1.d46142p-20, INEXACT)
T(RD,  0x1.2a115e02a9d06p+604,    0x1.7724160f38988p-1, -0x1.d46142p-20, INEXACT)
T(RU,  0x1.2a115e02a9d06p+604,    0x1.7724160f38989p-1,   0x1.ffffc6p-1, INEXACT)
T(RN, -0x1.9bb71e656199ap+364,    0x1.fdef28834b96bp-1,   -0x1.ffffep-2, INEXACT)
T(RZ, 0x1.bb15fc52421dbp+1011,   -0x1.61d56484a4071p-2,   0x1.fffff8p-1, INEXACT)
T(RU, 0x1.bb15fc52421dbp+1011,   -0x1.61d56484a4071p-2,   0x1.fffff8p-1, INEXACT)
T(RD, 0x1.bb15fc52421dbp+1011,   -0x1.61d56484a4072p-2, -0x1.10b5e4p-22, INEXACT)
T(RZ, -0x1.1bac3dda40857p+463,   -0x1.4ceb2bfd2e024p-2,    0x1.ffffdp-1, INEXACT)
T(RU, -0x1.1bac3dda40857p+463,   -0x1.4ceb2bfd2e024p-2,    0x1.ffffdp-1, INEXACT)
T(RD, -0x1.1bac3dda40857p+463,   -0x1.4ceb2bfd2e025p-2, -0x1.7ef67ep-20, INEXACT)
T(RZ,  0x1.e9db40a917036p+861,    -0x1.97c56127059fp-2,  0x1.f6cd42p-22, INEXACT)
T(RU,  0x1.e9db40a917036p+861,    -0x1.97c56127059fp-2,  0x1.f6cd42p-22, INEXACT)
T(RD,  0x1.e9db40a917036p+861,   -0x1.97c56127059f1p-2,   -0x1.fffffp-1, INEXACT)
T(RZ,  -0x1.f9b99ab0d55fcp+95,   -0x1.da8de4751ddfdp-1,    0x1.ffffep-1, INEXACT)
T(RU,  -0x1.f9b99ab0d55fcp+95,   -0x1.da8de4751ddfdp-1,    0x1.ffffep-1, INEXACT)
T(RD,  -0x1.f9b99ab0d55fcp+95,   -0x1.da8de4751ddfep-1, -0x1.06b8cep-20, INEXACT)
T(RZ, -0x1.b54a8b0b07f5fp+654,   -0x1.9d34250f8c1ccp-1,   0x1.c1d13p-21, INEXACT)
T(RU, -0x1.b54a8b0b07f5fp+654,   -0x1.9d34250f8c1ccp-1,   0x1.c1d13p-21, INEXACT)
T(RD, -0x1.b54a8b0b07f5fp+654,   -0x1.9d34250f8c1cdp-1,  -0x1.ffffe4p-1, INEXACT)
T(RZ,   0x1.5c9f084f59d13p+48,    0x1.fb8d89e12cae3p-1,  -0x1.ffffeap-1, INEXACT)
T(RD,   0x1.5c9f084f59d13p+48,    0x1.fb8d89e12cae3p-1,  -0x1.ffffeap-1, INEXACT)
T(RU,   0x1.5c9f084f59d13p+48,    0x1.fb8d89e12cae4p-1,  0x1.69cf06p-21, INEXACT)
T(RZ,  0x1.84485272e1f5fp+905,    0x1.dc980813b8205p-2,  -0x1.ffffc2p-1, INEXACT)
T(RD,  0x1.84485272e1f5fp+905,    0x1.dc980813b8205p-2,  -0x1.ffffc2p-1, INEXACT)
T(RU,  0x1.84485272e1f5fp+905,    0x1.dc980813b8206p-2,   0x1.ecfdap-20, INEXACT)
T(RN,  0x1.f1e0a9b248812p+789,    0x1.354f8a0f390dcp-2,  -0x1.ffffc8p-2, INEXACT)
T(RZ, -0x1.e648e0c185d8cp+940,   -0x1.ac1d2d4cd677dp-1,    0x1.fffffp-1, INEXACT)
T(RU, -0x1.e648e0c185d8cp+940,   -0x1.ac1d2d4cd677dp-1,    0x1.fffffp-1, INEXACT)
T(RD, -0x1.e648e0c185d8cp+940,   -0x1.ac1d2d4cd677ep-1, -0x1.081ceap-21, INEXACT)
T(RN, -0x1.a3bab3d8bea7ap+828,   -0x1.59f761a323621p-3,  -0x1.ffffb6p-2, INEXACT)
T(RN,  0x1.c09132398f902p+556,   -0x1.f3f4900d1db46p-1,  -0x1.ffffdcp-2, INEXACT)
T(RN,  -0x1.dc0f37b6629cp+536,    0x1.d151239549308p-1,  -0x1.ffffa2p-2, INEXACT)
T(RN, -0x1.687d9f6a2e2b2p+214,   -0x1.8324dd2e1dd63p-2,  -0x1.ffffe2p-2, INEXACT)
T(RN,  0x1.4259f639add7fp+725,    0x1.f561747a45bfdp-1,  -0x1.ffff96p-2, INEXACT)
T(RN,  0x1.48c808df5ef1ep+942,    0x1.e20bfb3882befp-1,  -0x1.ffff86p-2, INEXACT)
T(RN, -0x1.46589ea86f6f2p+320,    0x1.f4d4a9dfe6f0bp-4,  -0x1.ffff9ep-2, INEXACT)
T(RN, -0x1.1b96081b08bf7p+550,    -0x1.7e33d057d367p-3,  -0x1.fffff8p-2, INEXACT)
T(RN,  0x1.d4a4c74ac95d5p+301,    0x1.3691811ed54cep-2,  -0x1.ffffa4p-2, INEXACT)
T(RZ,  0x1.15860227c9715p+512,   -0x1.b133f4280ea03p-2,   0x1.ffffe2p-1, INEXACT)
T(RU,  0x1.15860227c9715p+512,   -0x1.b133f4280ea03p-2,   0x1.ffffe2p-1, INEXACT)
T(RD,  0x1.15860227c9715p+512,   -0x1.b133f4280ea04p-2, -0x1.e8b9c2p-21, INEXACT)
T(RN,   0x1.7cf8cd26ff766p+70,    0x1.5be5b203e8ff5p-5,  -0x1.ffffecp-2, INEXACT)
T(RZ,  0x1.cc7c864399b09p+967,   -0x1.7fb668cb74b3bp-1,  0x1.237544p-21, INEXACT)
T(RU,  0x1.cc7c864399b09p+967,   -0x1.7fb668cb74b3bp-1,  0x1.237544p-21, INEXACT)
T(RD,  0x1.cc7c864399b09p+967,   -0x1.7fb668cb74b3cp-1,  -0x1.ffffeep-1, INEXACT)
T(RZ,  0x1.d9f772bb41198p+489,    0x1.c9161788e1b87p-1,  -0x1.fffffap-1, INEXACT)
T(RD,  0x1.d9f772bb41198p+489,    0x1.c9161788e1b87p-1,  -0x1.fffffap-1, INEXACT)
T(RU,  0x1.d9f772bb41198p+489,    0x1.c9161788e1b88p-1,  0x1.6f6c02p-23, INEXACT)
T(RZ,  -0x1.f7ce19c1bd46p+197,   -0x1.f17dc9dcc9adfp-1,   0x1.ffffeep-1, INEXACT)
T(RU,  -0x1.f7ce19c1bd46p+197,   -0x1.f17dc9dcc9adfp-1,   0x1.ffffeep-1, INEXACT)
T(RD,  -0x1.f7ce19c1bd46p+197,    -0x1.f17dc9dcc9aep-1,  -0x1.1e976p-21, INEXACT)
T(RZ,  -0x1.f7554c3c0676ap+70,    0x1.f82ec0fd189b8p-1, -0x1.b7f302p-22, INEXACT)
T(RD,  -0x1.f7554c3c0676ap+70,    0x1.f82ec0fd189b8p-1, -0x1.b7f302p-22, INEXACT)
T(RU,  -0x1.f7554c3c0676ap+70,    0x1.f82ec0fd189b9p-1,   0x1.fffff2p-1, INEXACT)
T(RN,   -0x1.e0bd7f4f7bbfap-2,    0x1.c89ae9b78af92p-1,  -0x1.fffffcp-2, INEXACT)
T(RZ, -0x1.c1e2fe2f25f06p+984,   -0x1.9855ad2e23d21p-1,  0x1.62a00ap-23, INEXACT)
T(RU, -0x1.c1e2fe2f25f06p+984,   -0x1.9855ad2e23d21p-1,  0x1.62a00ap-23, INEXACT)
T(RD, -0x1.c1e2fe2f25f06p+984,   -0x1.9855ad2e23d22p-1,  -0x1.fffffap-1, INEXACT)
T(RZ, -0x1.9a38121947fefp+977,    0x1.576166ba900b9p-1,   -0x1.ffffep-1, INEXACT)
T(RD, -0x1.9a38121947fefp+977,    0x1.576166ba900b9p-1,   -0x1.ffffep-1, INEXACT)
T(RU, -0x1.9a38121947fefp+977,    0x1.576166ba900bap-1,  0x1.f4003ap-21, INEXACT)
T(RZ,  0x1.7e52fd31ba056p+399,    0x1.77fa6a78789a8p-4,  -0x1.fffff6p-1, INEXACT)
T(RD,  0x1.7e52fd31ba056p+399,    0x1.77fa6a78789a8p-4,  -0x1.fffff6p-1, INEXACT)
T(RU,  0x1.7e52fd31ba056p+399,    0x1.77fa6a78789a9p-4,  0x1.3ad686p-22, INEXACT)
T(RZ,  0x1.5cc2f27548514p+881,    -0x1.14f9628d519bp-1,   0x1.ffffecp-1, INEXACT)
T(RU,  0x1.5cc2f27548514p+881,    -0x1.14f9628d519bp-1,   0x1.ffffecp-1, INEXACT)
T(RD,  0x1.5cc2f27548514p+881,   -0x1.14f9628d519b1p-1, -0x1.3df5f4p-21, INEXACT)
T(RZ, -0x1.2347ef7b7d7f3p+604,   -0x1.ea196061d7a27p-1,   0x1.fffffap-1, INEXACT)
T(RU, -0x1.2347ef7b7d7f3p+604,   -0x1.ea196061d7a27p-1,   0x1.fffffap-1, INEXACT)
T(RD, -0x1.2347ef7b7d7f3p+604,   -0x1.ea196061d7a28p-1, -0x1.6c6008p-23, INEXACT)
T(RN,  0x1.26fad942b447fp+287,    0x1.a7cb54ba73c6bp-4,  -0x1.ffffc6p-2, INEXACT)
T(RN, -0x1.e3ec4a771a16bp+655,   -0x1.a784bed95150cp-6,  -0x1.ffffcep-2, INEXACT)
T(RZ,  0x1.b2b63804cd8dfp+677,   -0x1.ff82fce1d9485p-1,  0x1.8f9334p-21, INEXACT)
T(RU,  0x1.b2b63804cd8dfp+677,   -0x1.ff82fce1d9485p-1,  0x1.8f9334p-21, INEXACT)
T(RD,  0x1.b2b63804cd8dfp+677,   -0x1.ff82fce1d9486p-1,  -0x1.ffffe8p-1, INEXACT)
T(RZ,  0x1.b3785a8ea60e7p+111,   -0x1.a2afea2707956p-6,   0x1.ffffe6p-1, INEXACT)
T(RU,  0x1.b3785a8ea60e7p+111,   -0x1.a2afea2707956p-6,   0x1.ffffe6p-1, INEXACT)
T(RD,  0x1.b3785a8ea60e7p+111,   -0x1.a2afea2707957p-6, -0x1.a761a4p-21, INEXACT)
T(RZ, -0x1.1f4c4358bccebp+661,    0x1.048839c2c6837p-1,  -0x1.fffffap-1, INEXACT)
T(RD, -0x1.1f4c4358bccebp+661,    0x1.048839c2c6837p-1,  -0x1.fffffap-1, INEXACT)
T(RU, -0x1.1f4c4358bccebp+661,    0x1.048839c2c6838p-1,  0x1.89e718p-23, INEXACT)
T(RZ,  0x1.f620030d72affp+788,     0x1.fb0f16398169p-1,  -0x1.fffff2p-1, INEXACT)
T(RD,  0x1.f620030d72affp+788,     0x1.fb0f16398169p-1,  -0x1.fffff2p-1, INEXACT)
T(RU,  0x1.f620030d72affp+788,    0x1.fb0f163981691p-1,  0x1.b960dep-22, INEXACT)
T(RN, -0x1.c4a13149ff74dp+949,    0x1.e1a96b5d42504p-1,  -0x1.ffffd2p-2, INEXACT)
T(RZ,  0x1.4db8e50fe802fp+532,    0x1.fa1c78f9c5ad5p-1, -0x1.0556bcp-22, INEXACT)
T(RD,  0x1.4db8e50fe802fp+532,    0x1.fa1c78f9c5ad5p-1, -0x1.0556bcp-22, INEXACT)
T(RU,  0x1.4db8e50fe802fp+532,    0x1.fa1c78f9c5ad6p-1,   0x1.fffff8p-1, INEXACT)
T(RZ,  0x1.95b04bd0062a8p+330,    0x1.439bdebf22b11p-2, -0x1.b5b68ap-21, INEXACT)
T(RD,  0x1.95b04bd0062a8p+330,    0x1.439bdebf22b11p-2, -0x1.b5b68ap-21, INEXACT)
T(RU,  0x1.95b04bd0062a8p+330,    0x1.439bdebf22b12p-2,   0x1.ffffe4p-1, INEXACT)
T(RZ,  0x1.58b5a76b05821p+805,   -0x1.b58bbda8bb875p-3,   0x1.fffff4p-1, INEXACT)
T(RU,  0x1.58b5a76b05821p+805,   -0x1.b58bbda8bb875p-3,   0x1.fffff4p-1, INEXACT)
T(RD,  0x1.58b5a76b05821p+805,   -0x1.b58bbda8bb876p-3, -0x1.861d64p-22, INEXACT)
T(RZ,  0x1.cb6ca988f842cp+317,   -0x1.bf43e53e3aa3ap-1,  0x1.fc24f4p-21, INEXACT)
T(RU,  0x1.cb6ca988f842cp+317,   -0x1.bf43e53e3aa3ap-1,  0x1.fc24f4p-21, INEXACT)
T(RD,  0x1.cb6ca988f842cp+317,   -0x1.bf43e53e3aa3bp-1,   -0x1.ffffep-1, INEXACT)
T(RZ, -0x1.4661f315cdfc5p+762,    0x1.bb34daae95f39p-1,  -0x1.ffffecp-1, INEXACT)
T(RD, -0x1.4661f315cdfc5p+762,    0x1.bb34daae95f39p-1,  -0x1.ffffecp-1, INEXACT)
T(RU, -0x1.4661f315cdfc5p+762,    0x1.bb34daae95f3ap-1,  0x1.374738p-21, INEXACT)
T(RZ, -0x1.a5c84b232700ep+920,   -0x1.a3041694b47a5p-2,   0x1.fffffap-1, INEXACT)
T(RU, -0x1.a5c84b232700ep+920,   -0x1.a3041694b47a5p-2,   0x1.fffffap-1, INEXACT)
T(RD, -0x1.a5c84b232700ep+920,   -0x1.a3041694b47a6p-2, -0x1.700fecp-23, INEXACT)
T(RN,  0x1.3b59f02a675ccp+811,    0x1.f8a5f18ea91cfp-2,  -0x1.ffffd6p-2, INEXACT)
T(RN,  0x1.1e77578905434p+488,    0x1.abf95c6c6fce5p-6,  -0x1.fffff6p-2, INEXACT)
T(RN,   0x1.aa799a45eaf14p+59,    0x1.f56fa64594b59p-1,  -0x1.ffffc8p-2, INEXACT)
T(RN,  0x1.03acea4fa03e6p+553,    0x1.b7376574d9096p-1,  -0x1.ffffc8p-2, INEXACT)
T(RN, -0x1.a5a26cfee06fdp+820,   -0x1.350b16477f445p-1,  -0x1.ffffdap-2, INEXACT)
T(RN, -0x1.ab2d32b9add58p+728,   -0x1.ecdccbd3c57f3p-2,  -0x1.ffffc4p-2, INEXACT)
T(RN,  0x1.163dd4fda4843p+477,   -0x1.ada8e38031147p-1,  -0x1.ffffd8p-2, INEXACT)
T(RN, -0x1.0c9e8f2ab096ep+809,     0x1.78341b3aad9ep-2,  -0x1.fffff6p-2, INEXACT)
T(RN, -0x1.3381aa35fd96bp+802,   -0x1.c2ad472786824p-1,  -0x1.fffff4p-2, INEXACT)
T(RN,  0x1.c3fead36eccacp+784,   -0x1.bdeb4ddae98a7p-1,  -0x1.ffffcep-2, INEXACT)
T(RN, -0x1.1ef1f831f5ce9p+120,    0x1.e22d260b2d5c8p-1,  -0x1.ffffc8p-2, INEXACT)
T(RN, -0x1.49df8181256d9p+474,    0x1.623630ce06c1bp-2,  -0x1.ffffccp-2, INEXACT)
T(RN, -0x1.0ed30f1b1e1f3p+526,    0x1.a384164552694p-5,  -0x1.fffff6p-2, INEXACT)
T(RN,  0x1.a7c0d64ea2219p+758,   -0x1.e89328fdf14f2p-1,  -0x1.ffffdep-2, INEXACT)
T(RN, -0x1.98ddf46f6abc8p+360,   -0x1.d8984d2b9828bp-2,  -0x1.ffffd6p-2, INEXACT)
T(RZ, -0x1.17b63097c670cp+799,    0x1.b41cb3c04d1e1p-1, -0x1.69827ep-23, INEXACT)
T(RD, -0x1.17b63097c670cp+799,    0x1.b41cb3c04d1e1p-1, -0x1.69827ep-23, INEXACT)
T(RU, -0x1.17b63097c670cp+799,    0x1.b41cb3c04d1e2p-1,   0x1.fffffap-1, INEXACT)
T(RZ,  0x1.0e2c9fdbeac34p+960,     -0x1.30cc1b14012p-3,  0x1.a44dacp-22, INEXACT)
T(RU,  0x1.0e2c9fdbeac34p+960,     -0x1.30cc1b14012p-3,  0x1.a44dacp-22, INEXACT)
T(RD,  0x1.0e2c9fdbeac34p+960,   -0x1.30cc1b1401201p-3,  -0x1.fffff2p-1, INEXACT)
T(RZ, -0x1.f5349b69348ffp+455,   -0x1.49f5cacece9cep-2,   0x1.fffff6p-1, INEXACT)
T(RU, -0x1.f5349b69348ffp+455,   -0x1.49f5cacece9cep-2,   0x1.fffff6p-1, INEXACT)
T(RD, -0x1.f5349b69348ffp+455,   -0x1.49f5cacece9cfp-2, -0x1.5945d8p-22, INEXACT)
T(RZ,  0x1.693dfa67ab712p+314,   -0x1.2a4257022bd98p-2,  0x1.e3e0cap-22, INEXACT)
T(RU,  0x1.693dfa67ab712p+314,   -0x1.2a4257022bd98p-2,  0x1.e3e0cap-22, INEXACT)
T(RD,  0x1.693dfa67ab712p+314,   -0x1.2a4257022bd99p-2,   -0x1.fffffp-1, INEXACT)
T(RZ, -0x1.3459e02e19df9p+645,    0x1.fe1406b0753eep-1,  -0x1.fffff2p-1, INEXACT)
T(RD, -0x1.3459e02e19df9p+645,    0x1.fe1406b0753eep-1,  -0x1.fffff2p-1, INEXACT)
T(RU, -0x1.3459e02e19df9p+645,    0x1.fe1406b0753efp-1,  0x1.caa43cp-22, INEXACT)
T(RZ, -0x1.39eab6fa7b0c4p+918,    0x1.89d08ec7d05ddp-1,  -0x1.fffff6p-1, INEXACT)
T(RD, -0x1.39eab6fa7b0c4p+918,    0x1.89d08ec7d05ddp-1,  -0x1.fffff6p-1, INEXACT)
T(RU, -0x1.39eab6fa7b0c4p+918,    0x1.89d08ec7d05dep-1,  0x1.4e512cp-22, INEXACT)
T(RN,  0x1.9ec82c93bad42p+891,    0x1.b595e13beed85p-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.4ff0c8997f152p+607,    0x1.82a5dbc5f0289p-1,  -0x1.fffff6p-1, INEXACT)
T(RD,  0x1.4ff0c8997f152p+607,    0x1.82a5dbc5f0289p-1,  -0x1.fffff6p-1, INEXACT)
T(RU,  0x1.4ff0c8997f152p+607,    0x1.82a5dbc5f028ap-1,  0x1.20210cp-22, INEXACT)
T(RN, -0x1.abfa297f4728bp+323,    0x1.800a89af9f7e1p-4,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.6eb342d414907p+164,    0x1.f006f2f3ffe82p-2, -0x1.2b92f2p-22, INEXACT)
T(RD,  0x1.6eb342d414907p+164,    0x1.f006f2f3ffe82p-2, -0x1.2b92f2p-22, INEXACT)
T(RU,  0x1.6eb342d414907p+164,    0x1.f006f2f3ffe83p-2,   0x1.fffff6p-1, INEXACT)
T(RN,-0x1.96974e0a0ca1bp+1020,   -0x1.47423f558e53cp-2,  -0x1.ffffe6p-2, INEXACT)
T(RZ, -0x1.87f2cf434697dp+322,     -0x1.ff7147283b5p-2,  0x1.2162cep-22, INEXACT)
T(RU, -0x1.87f2cf434697dp+322,     -0x1.ff7147283b5p-2,  0x1.2162cep-22, INEXACT)
T(RD, -0x1.87f2cf434697dp+322,   -0x1.ff7147283b501p-2,  -0x1.fffff6p-1, INEXACT)
T(RN, -0x1.cab79420b5fa2p+203,    0x1.c7d5416c99451p-1,  -0x1.ffffe8p-2, INEXACT)
T(RZ,  -0x1.421b3a358f5e3p+57,    0x1.fc661628e62acp-1,  -0x1.fffff8p-1, INEXACT)
T(RD,  -0x1.421b3a358f5e3p+57,    0x1.fc661628e62acp-1,  -0x1.fffff8p-1, INEXACT)
T(RU,  -0x1.421b3a358f5e3p+57,    0x1.fc661628e62adp-1,  0x1.02baa6p-22, INEXACT)
T(RN,  0x1.cd756ccae2816p+799,    0x1.bc619cc65207fp-1,  -0x1.ffffe6p-2, INEXACT)
T(RN,  0x1.2a0d5687ad5fbp+189,    -0x1.dd1b3b766efap-2,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.2d44837122fafp+193,   -0x1.fa8aa1f31fe29p-1,  -0x1.fffff8p-2, INEXACT)
T(RN,  0x1.9189f441446d5p+114,   -0x1.7783ea482dd27p-1,  -0x1.fffffep-2, INEXACT)
T(RZ,   0x1.7262b1f1dfeebp+62,    0x1.1adb9c6c2e63dp-3,  -0x1.8c372p-25, INEXACT)
T(RD,   0x1.7262b1f1dfeebp+62,    0x1.1adb9c6c2e63dp-3,  -0x1.8c372p-25, INEXACT)
T(RU,   0x1.7262b1f1dfeebp+62,    0x1.1adb9c6c2e63ep-3,   0x1.fffffep-1, INEXACT)
T(RZ,  0x1.6b58f6653baf8p+817,    0x1.df1a3a8761a8cp-1,  -0x1.fffff4p-1, INEXACT)
T(RD,  0x1.6b58f6653baf8p+817,    0x1.df1a3a8761a8cp-1,  -0x1.fffff4p-1, INEXACT)
T(RU,  0x1.6b58f6653baf8p+817,    0x1.df1a3a8761a8dp-1,  0x1.8ff452p-22, INEXACT)
T(RZ,  0x1.3f8abf2cc301ep+163,     0x1.ef5341c5977fp-8, -0x1.a07514p-22, INEXACT)
T(RD,  0x1.3f8abf2cc301ep+163,     0x1.ef5341c5977fp-8, -0x1.a07514p-22, INEXACT)
T(RU,  0x1.3f8abf2cc301ep+163,    0x1.ef5341c5977f1p-8,   0x1.fffff2p-1, INEXACT)
T(RZ, -0x1.01ad6cc305934p+182,  -0x1.1424ef5ce573fp-10,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.01ad6cc305934p+182,  -0x1.1424ef5ce573fp-10,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.01ad6cc305934p+182,   -0x1.1424ef5ce574p-10, -0x1.72634ap-25, INEXACT)
T(RZ,  -0x1.df988cccea61p+225,   -0x1.ee80f67180aefp-1,  0x1.694bdep-22, INEXACT)
T(RU,  -0x1.df988cccea61p+225,   -0x1.ee80f67180aefp-1,  0x1.694bdep-22, INEXACT)
T(RD,  -0x1.df988cccea61p+225,    -0x1.ee80f67180afp-1,  -0x1.fffff4p-1, INEXACT)
T(RZ,  0x1.22c2bf0969817p+744,   -0x1.fd9aaa483566dp-1,   0x1.fffffap-1, INEXACT)
T(RU,  0x1.22c2bf0969817p+744,   -0x1.fd9aaa483566dp-1,   0x1.fffffap-1, INEXACT)
T(RD,  0x1.22c2bf0969817p+744,   -0x1.fd9aaa483566ep-1, -0x1.b40e42p-23, INEXACT)
T(RZ,  0x1.bb9b37a8c420cp+251,    0x1.6937e89cef395p-4, -0x1.2cca1cp-24, INEXACT)
T(RD,  0x1.bb9b37a8c420cp+251,    0x1.6937e89cef395p-4, -0x1.2cca1cp-24, INEXACT)
T(RU,  0x1.bb9b37a8c420cp+251,    0x1.6937e89cef396p-4,   0x1.fffffep-1, INEXACT)
T(RZ, -0x1.58423a5695d22p+564,   -0x1.7c610e36b318fp-4,   0x1.90f37p-23, INEXACT)
T(RU, -0x1.58423a5695d22p+564,   -0x1.7c610e36b318fp-4,   0x1.90f37p-23, INEXACT)
T(RD, -0x1.58423a5695d22p+564,    -0x1.7c610e36b319p-4,  -0x1.fffffap-1, INEXACT)
T(RZ,  0x1.0fbc63664a5ffp+678,    0x1.71e77be4246f8p-4, -0x1.0e20fep-22, INEXACT)
T(RD,  0x1.0fbc63664a5ffp+678,    0x1.71e77be4246f8p-4, -0x1.0e20fep-22, INEXACT)
T(RU,  0x1.0fbc63664a5ffp+678,    0x1.71e77be4246f9p-4,   0x1.fffff8p-1, INEXACT)
T(RN,   0x1.0df340dbb4491p+28,    0x1.e8a001f33a3c1p-1,  -0x1.ffffeep-2, INEXACT)
T(RN,  0x1.89c7ea015a48dp+899,    0x1.eb0cb6d430b7ep-1,  -0x1.ffffeap-2, INEXACT)
T(RZ,  0x1.a3732b657594bp+664,    0x1.7bab7ecadbaa4p-1,  -0x1.fffff6p-1, INEXACT)
T(RD,  0x1.a3732b657594bp+664,    0x1.7bab7ecadbaa4p-1,  -0x1.fffff6p-1, INEXACT)
T(RU,  0x1.a3732b657594bp+664,    0x1.7bab7ecadbaa5p-1,   0x1.313a3p-22, INEXACT)
T(RN,  -0x1.25afd27aff1c5p+11,    0x1.d4278bb00fbb8p-1,   -0x1.ffffep-2, INEXACT)
T(RN, -0x1.4bf70e1371619p+718,     0x1.ffdf5e8130cbp-1,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.0b5fe1911398ap+87,   -0x1.845f897156a97p-2,   -0x1.fffffp-2, INEXACT)
T(RN,  0x1.e8f7c9334f7c9p+819,    0x1.fff30e46321ddp-1,   -0x1.fffffp-2, INEXACT)
T(RN,  0x1.346cf09e98757p+624,   -0x1.f8bc3335fa716p-1,  -0x1.ffffecp-2, INEXACT)
T(RN,  0x1.8d5c4578ef5d8p+180,    0x1.a3044398013c9p-1,  -0x1.fffffep-2, INEXACT)
T(RN,   0x1.f2bc220cc02edp+32,   -0x1.b2a474aa401fcp-1,  -0x1.fffff6p-2, INEXACT)
T(RN,   -0x1.f35b94beb8eep+29,   -0x1.9242ad8785107p-1,  -0x1.fffff6p-2, INEXACT)
T(RN,  0x1.93c21efac20bcp+531,    0x1.4afb13abb66aep-2,  -0x1.fffff8p-2, INEXACT)
T(RN,  0x1.38b3ef959e3b2p+578,    0x1.4d83f374e18fap-2,   -0x1.fffffp-2, INEXACT)
T(RZ,  0x1.6b1a156f0334ep+600,     0x1.b6f411738962p-2,  -0x1.fffff8p-1, INEXACT)
T(RD,  0x1.6b1a156f0334ep+600,     0x1.b6f411738962p-2,  -0x1.fffff8p-1, INEXACT)
T(RU,  0x1.6b1a156f0334ep+600,    0x1.b6f4117389621p-2,  0x1.e7db76p-23, INEXACT)
T(RZ,  0x1.7847f78a59123p+829,   -0x1.e726c00f1c95ap-2,   0x1.fffffcp-1, INEXACT)
T(RU,  0x1.7847f78a59123p+829,   -0x1.e726c00f1c95ap-2,   0x1.fffffcp-1, INEXACT)
T(RD,  0x1.7847f78a59123p+829,   -0x1.e726c00f1c95bp-2, -0x1.119f7cp-23, INEXACT)
T(RZ,  0x1.2e91616e66aa6p+208,    0x1.82fc98339b404p-1,  -0x1.fffffap-1, INEXACT)
T(RD,  0x1.2e91616e66aa6p+208,    0x1.82fc98339b404p-1,  -0x1.fffffap-1, INEXACT)
T(RU,  0x1.2e91616e66aa6p+208,    0x1.82fc98339b405p-1,  0x1.a222b6p-23, INEXACT)
T(RZ,  0x1.67fd691cf9ec8p+315,    0x1.537c48f922a7cp-1,  -0x1.fffffep-1, INEXACT)
T(RD,  0x1.67fd691cf9ec8p+315,    0x1.537c48f922a7cp-1,  -0x1.fffffep-1, INEXACT)
T(RU,  0x1.67fd691cf9ec8p+315,    0x1.537c48f922a7dp-1,  0x1.88dbe8p-25, INEXACT)
T(RZ,  0x1.41ceb01baba68p+546,    0x1.915972c2b633dp-2,  -0x1.fffffep-1, INEXACT)
T(RD,  0x1.41ceb01baba68p+546,    0x1.915972c2b633dp-2,  -0x1.fffffep-1, INEXACT)
T(RU,  0x1.41ceb01baba68p+546,    0x1.915972c2b633ep-2,  0x1.06e06ap-25, INEXACT)
T(RN, -0x1.4e73248245296p+742,     0x1.0aea76e11cbep-1,  -0x1.fffffcp-2, INEXACT)
T(RZ,   0x1.9b468054f573p+132,    0x1.15b0c8311f7b8p-1, -0x1.c17986p-24, INEXACT)
T(RD,   0x1.9b468054f573p+132,    0x1.15b0c8311f7b8p-1, -0x1.c17986p-24, INEXACT)
T(RU,   0x1.9b468054f573p+132,    0x1.15b0c8311f7b9p-1,   0x1.fffffcp-1, INEXACT)
T(RZ,  -0x1.4a0894d0c0dfcp+40,   -0x1.ef5e101947fcap-1,  0x1.2bf398p-24, INEXACT)
T(RU,  -0x1.4a0894d0c0dfcp+40,   -0x1.ef5e101947fcap-1,  0x1.2bf398p-24, INEXACT)
T(RD,  -0x1.4a0894d0c0dfcp+40,   -0x1.ef5e101947fcbp-1,  -0x1.fffffep-1, INEXACT)
T(RZ,  0x1.c36f4847e69fcp+877,   -0x1.ff5a8dd999e09p-1,  0x1.e04228p-23, INEXACT)
T(RU,  0x1.c36f4847e69fcp+877,   -0x1.ff5a8dd999e09p-1,  0x1.e04228p-23, INEXACT)
T(RD,  0x1.c36f4847e69fcp+877,   -0x1.ff5a8dd999e0ap-1,  -0x1.fffff8p-1, INEXACT)
T(RN,   -0x1.16f08ac740f8p+51,   -0x1.90d4e6cb34829p-1,   -0x1.fffffp-2, INEXACT)
T(RZ, -0x1.8c6b547f475dap+594,    0x1.8bf44e5e442d3p-1,  -0x1.fffffcp-1, INEXACT)
T(RD, -0x1.8c6b547f475dap+594,    0x1.8bf44e5e442d3p-1,  -0x1.fffffcp-1, INEXACT)
T(RU, -0x1.8c6b547f475dap+594,    0x1.8bf44e5e442d4p-1,  0x1.c434a6p-24, INEXACT)
T(RN,  0x1.eb911a3c638b5p+315,    0x1.75e47752c7235p-1,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.de44b000e8c56p+295,    0x1.a875967822a3dp-1,  -0x1.fffffap-1, INEXACT)
T(RD,  0x1.de44b000e8c56p+295,    0x1.a875967822a3dp-1,  -0x1.fffffap-1, INEXACT)
T(RU,  0x1.de44b000e8c56p+295,    0x1.a875967822a3ep-1,  0x1.8378b4p-23, INEXACT)
T(RZ,  0x1.54f877cc02984p+148,   -0x1.bac4f81df41d4p-6,   0x1.fffffcp-1, INEXACT)
T(RU,  0x1.54f877cc02984p+148,   -0x1.bac4f81df41d4p-6,   0x1.fffffcp-1, INEXACT)
T(RD,  0x1.54f877cc02984p+148,   -0x1.bac4f81df41d5p-6, -0x1.1d0da8p-23, INEXACT)
T(RZ, -0x1.00ba5522100c7p+182,   -0x1.01286bafc0eb2p-1,   0x1.fffffcp-1, INEXACT)
T(RU, -0x1.00ba5522100c7p+182,   -0x1.01286bafc0eb2p-1,   0x1.fffffcp-1, INEXACT)
T(RD, -0x1.00ba5522100c7p+182,   -0x1.01286bafc0eb3p-1, -0x1.1e576ep-23, INEXACT)
T(RZ,   0x1.b480e4441191p+695,   -0x1.ad8862de36a46p-1,   0x1.fffffap-1, INEXACT)
T(RU,   0x1.b480e4441191p+695,   -0x1.ad8862de36a46p-1,   0x1.fffffap-1, INEXACT)
T(RD,   0x1.b480e4441191p+695,   -0x1.ad8862de36a47p-1, -0x1.874ddep-23, INEXACT)
T(RZ, -0x1.9dc08725b0284p+115,    0x1.a0eb5f68583e5p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.9dc08725b0284p+115,    0x1.a0eb5f68583e5p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.9dc08725b0284p+115,    0x1.a0eb5f68583e6p-1,  0x1.4df88cp-28, INEXACT)
T(RZ, -0x1.16c5835dca79bp+355,    0x1.48435f83e30fdp-1, -0x1.510654p-23, INEXACT)
T(RD, -0x1.16c5835dca79bp+355,    0x1.48435f83e30fdp-1, -0x1.510654p-23, INEXACT)
T(RU, -0x1.16c5835dca79bp+355,    0x1.48435f83e30fep-1,   0x1.fffffap-1, INEXACT)
T(RN,  0x1.4cf5f531c794bp+852,   -0x1.fd065f433c60fp-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.acd2c0b30008ap+126,   -0x1.48dea130cf79bp-1,  -0x1.fffffap-2, INEXACT)
T(RZ, -0x1.6e3ef83b87725p+602,    0x1.58ea98eeb7fd3p-1, -0x1.29eacep-23, INEXACT)
T(RD, -0x1.6e3ef83b87725p+602,    0x1.58ea98eeb7fd3p-1, -0x1.29eacep-23, INEXACT)
T(RU, -0x1.6e3ef83b87725p+602,    0x1.58ea98eeb7fd4p-1,   0x1.fffffcp-1, INEXACT)
T(RZ,  -0x1.2c44a4b9758cp+465,   -0x1.9d2dc6787b1e2p-3,   0x1.fffffcp-1, INEXACT)
T(RU,  -0x1.2c44a4b9758cp+465,   -0x1.9d2dc6787b1e2p-3,   0x1.fffffcp-1, INEXACT)
T(RD,  -0x1.2c44a4b9758cp+465,   -0x1.9d2dc6787b1e3p-3, -0x1.aa7768p-24, INEXACT)
T(RZ, -0x1.8c0d29b3764a8p+615,   -0x1.41036eb67dcf5p-1,   0x1.fffffap-1, INEXACT)
T(RU, -0x1.8c0d29b3764a8p+615,   -0x1.41036eb67dcf5p-1,   0x1.fffffap-1, INEXACT)
T(RD, -0x1.8c0d29b3764a8p+615,   -0x1.41036eb67dcf6p-1, -0x1.4c910ap-23, INEXACT)
T(RN,  0x1.f7d345d0aeb2fp+358,    0x1.7befc3a20260dp-2,  -0x1.fffff2p-2, INEXACT)
T(RN,  0x1.537ec545470d6p+472,   -0x1.0e5bfde885cfap-1,  -0x1.fffff6p-2, INEXACT)
T(RN,  0x1.c608aea0c9791p+120,   -0x1.69ee1e06fdac8p-3,   -0x1.fffffp-2, INEXACT)
T(RN, -0x1.8ab31a490e935p+817,    0x1.f7854fbad7328p-1,   -0x1.fffffp-2, INEXACT)
T(RN,  0x1.eb66332ae818dp+214,     0x1.cf56ba97795ap-1,  -0x1.fffffap-2, INEXACT)
T(RZ,  0x1.a2c5f9994e7dcp+991,   -0x1.5eb987af7bcc8p-1,   0x1.12f02p-23, INEXACT)
T(RU,  0x1.a2c5f9994e7dcp+991,   -0x1.5eb987af7bcc8p-1,   0x1.12f02p-23, INEXACT)
T(RD,  0x1.a2c5f9994e7dcp+991,   -0x1.5eb987af7bcc9p-1,  -0x1.fffffcp-1, INEXACT)
T(RZ, -0x1.9b86485420cd3p+119,   -0x1.089a504312125p-1,  0x1.9b4602p-24, INEXACT)
T(RU, -0x1.9b86485420cd3p+119,   -0x1.089a504312125p-1,  0x1.9b4602p-24, INEXACT)
T(RD, -0x1.9b86485420cd3p+119,   -0x1.089a504312126p-1,  -0x1.fffffcp-1, INEXACT)
T(RN,  0x1.8ea6616f3cfb7p+390,   -0x1.2d58d4f5415dap-1,  -0x1.fffffcp-2, INEXACT)
T(RN, -0x1.c38c56957cea2p+385,     0x1.74dfd4cda7e2p-6,   -0x1.fffffp-2, INEXACT)
T(RN, -0x1.aec3b89c39749p+667,   -0x1.57df705bb3677p-3,   -0x1.fffffp-2, INEXACT)
T(RN, -0x1.9a87dc65ea4e8p+301,    0x1.f3b79eca1c319p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.a435399ea24d1p+82,   -0x1.b4d20a69bb944p-2,  -0x1.fffff6p-2, INEXACT)
T(RN, -0x1.1c8f8ba37764dp+586,   -0x1.88faa952a2f2ap-5,         -0x1p-1, INEXACT)
T(RN, -0x1.53061a37b3e6cp+868,   -0x1.ff8f57300fe02p-1,   -0x1.fffffp-2, INEXACT)
T(RN,  0x1.a0264f67e3827p+870,    0x1.8caf0eb470cddp-2,  -0x1.fffff2p-2, INEXACT)
T(RN,  -0x1.94173f0a74f3ep+39,    0x1.8e888a0df19a3p-6,  -0x1.fffff2p-2, INEXACT)
T(RN,  0x1.b98144e2cf56cp+103,   -0x1.4272e39c7e411p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  -0x1.7501595fbdf2p+824,   -0x1.6aa91ff2122a6p-1,  -0x1.fffffcp-2, INEXACT)
T(RN,  0x1.6ac961617eb09p+151,   -0x1.ce5888abe5df6p-1,  -0x1.fffffap-2, INEXACT)
T(RN,  0x1.c908894546cd9p+903,   -0x1.f4bb9e9080d9fp-1,  -0x1.fffff8p-2, INEXACT)
T(RZ,  -0x1.e3e01d700caa4p+46,    0x1.442d52ee94fe5p-8, -0x1.48f814p-24, INEXACT)
T(RD,  -0x1.e3e01d700caa4p+46,    0x1.442d52ee94fe5p-8, -0x1.48f814p-24, INEXACT)
T(RU,  -0x1.e3e01d700caa4p+46,    0x1.442d52ee94fe6p-8,   0x1.fffffep-1, INEXACT)
T(RZ, -0x1.54116ea1b8743p+946,   -0x1.2458396333615p-1,   0x1.fffffcp-1, INEXACT)
T(RU, -0x1.54116ea1b8743p+946,   -0x1.2458396333615p-1,   0x1.fffffcp-1, INEXACT)
T(RD, -0x1.54116ea1b8743p+946,   -0x1.2458396333616p-1, -0x1.88b11cp-24, INEXACT)
T(RZ,   -0x1.32171bd2fc39fp+8,   -0x1.b4f76409126f1p-3,  0x1.9015c8p-25, INEXACT)
T(RU,   -0x1.32171bd2fc39fp+8,   -0x1.b4f76409126f1p-3,  0x1.9015c8p-25, INEXACT)
T(RD,   -0x1.32171bd2fc39fp+8,   -0x1.b4f76409126f2p-3,  -0x1.fffffep-1, INEXACT)
T(RZ, -0x1.322206e717c5bp+916,   -0x1.64d6273e2787ap-1,          0x1p+0, INEXACT)
T(RU, -0x1.322206e717c5bp+916,   -0x1.64d6273e2787ap-1,          0x1p+0, INEXACT)
T(RD, -0x1.322206e717c5bp+916,   -0x1.64d6273e2787bp-1, -0x1.0d4124p-27, INEXACT)
T(RZ, -0x1.5d1a0a4e7acb5p+503,   -0x1.4712ef17ff3b4p-2,  0x1.0b5be8p-25, INEXACT)
T(RU, -0x1.5d1a0a4e7acb5p+503,   -0x1.4712ef17ff3b4p-2,  0x1.0b5be8p-25, INEXACT)
T(RD, -0x1.5d1a0a4e7acb5p+503,   -0x1.4712ef17ff3b5p-2,  -0x1.fffffep-1, INEXACT)
T(RZ,  0x1.3b7f4374144e4p+689,   -0x1.d934aac867505p-1,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.3b7f4374144e4p+689,   -0x1.d934aac867505p-1,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.3b7f4374144e4p+689,   -0x1.d934aac867506p-1, -0x1.2877cap-24, INEXACT)
T(RN,  0x1.7fb55bd671ef9p+861,    0x1.73beadba19a19p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.c8ee63f62ea93p+814,   -0x1.9b2e4f5b29159p-1,   0x1.fffffcp-1, INEXACT)
T(RU, -0x1.c8ee63f62ea93p+814,   -0x1.9b2e4f5b29159p-1,   0x1.fffffcp-1, INEXACT)
T(RD, -0x1.c8ee63f62ea93p+814,   -0x1.9b2e4f5b2915ap-1, -0x1.f40746p-24, INEXACT)
T(RN, -0x1.a2f1328fb6c3ap+190,   -0x1.6ca9912c8bcdfp-2,  -0x1.fffffcp-2, INEXACT)
T(RN, 0x1.a8214406dcc44p+1011,    0x1.6cea20c08655ep-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.1ca39d74f02aep+442,   -0x1.89c791f0e5e34p-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.f885243a7660ap+567,    0x1.b995b3ce2f3c1p-1, -0x1.35a178p-24, INEXACT)
T(RD,  0x1.f885243a7660ap+567,    0x1.b995b3ce2f3c1p-1, -0x1.35a178p-24, INEXACT)
T(RU,  0x1.f885243a7660ap+567,    0x1.b995b3ce2f3c2p-1,   0x1.fffffep-1, INEXACT)
T(RZ, -0x1.ee595e5fb7dfep+624,   -0x1.b758f54ad410cp-1,  0x1.b225d8p-27, INEXACT)
T(RU, -0x1.ee595e5fb7dfep+624,   -0x1.b758f54ad410cp-1,  0x1.b225d8p-27, INEXACT)
T(RD, -0x1.ee595e5fb7dfep+624,   -0x1.b758f54ad410dp-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.47ca5b7b69015p+280,   -0x1.f863c0d80632ep-1,  0x1.2c6a3ep-25, INEXACT)
T(RU, -0x1.47ca5b7b69015p+280,   -0x1.f863c0d80632ep-1,  0x1.2c6a3ep-25, INEXACT)
T(RD, -0x1.47ca5b7b69015p+280,   -0x1.f863c0d80632fp-1,  -0x1.fffffep-1, INEXACT)
T(RN,  0x1.65c450bf3eea8p+161,    0x1.5d0953f905a48p-3,  -0x1.fffffcp-2, INEXACT)
T(RN, -0x1.25bde45913685p+148,    0x1.903149c2ec179p-4,  -0x1.fffff8p-2, INEXACT)
T(RZ, -0x1.2df92cf08e47fp+645,    -0x1.fccdbfb9a941p-1,   0x1.9aa56p-28, INEXACT)
T(RU, -0x1.2df92cf08e47fp+645,    -0x1.fccdbfb9a941p-1,   0x1.9aa56p-28, INEXACT)
T(RD, -0x1.2df92cf08e47fp+645,   -0x1.fccdbfb9a9411p-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.66d4b86074f3dp+690,   -0x1.adfb26a799193p-2,   0x1.10bfap-26, INEXACT)
T(RU,  0x1.66d4b86074f3dp+690,   -0x1.adfb26a799193p-2,   0x1.10bfap-26, INEXACT)
T(RD,  0x1.66d4b86074f3dp+690,   -0x1.adfb26a799194p-2,         -0x1p+0, INEXACT)
T(RZ, -0x1.02caaf64e3d36p+652,   -0x1.1278a7051e052p-3,          0x1p+0, INEXACT)
T(RU, -0x1.02caaf64e3d36p+652,   -0x1.1278a7051e052p-3,          0x1p+0, INEXACT)
T(RD, -0x1.02caaf64e3d36p+652,   -0x1.1278a7051e053p-3, -0x1.74721ep-26, INEXACT)
T(RZ,   -0x1.9cdb748b12eep+17,    -0x1.525fab62e66fp-1,   0x1.fffffep-1, INEXACT)
T(RU,   -0x1.9cdb748b12eep+17,    -0x1.525fab62e66fp-1,   0x1.fffffep-1, INEXACT)
T(RD,   -0x1.9cdb748b12eep+17,   -0x1.525fab62e66f1p-1, -0x1.d70594p-25, INEXACT)
T(RN, -0x1.1959f08df21ebp+865,   -0x1.819201af67acdp-2,  -0x1.fffffap-2, INEXACT)
T(RN,  0x1.9343678acb1a6p+277,    -0x1.78cdcdd110bfp-4,  -0x1.fffffap-2, INEXACT)
T(RZ, -0x1.a1c199cc15bbbp+690,    0x1.adce9d3eb9493p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.a1c199cc15bbbp+690,    0x1.adce9d3eb9493p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.a1c199cc15bbbp+690,    0x1.adce9d3eb9494p-1,  0x1.63c54cp-27, INEXACT)
T(RZ, -0x1.be19f8afb1adep+954,   -0x1.a6203d71dd26fp-1,   0x1.fffffcp-1, INEXACT)
T(RU, -0x1.be19f8afb1adep+954,   -0x1.a6203d71dd26fp-1,   0x1.fffffcp-1, INEXACT)
T(RD, -0x1.be19f8afb1adep+954,    -0x1.a6203d71dd27p-1, -0x1.994f4cp-24, INEXACT)
T(RN,  -0x1.a9e32f575293p+893,   -0x1.6b7ccd0064926p-3,  -0x1.fffffcp-2, INEXACT)
T(RZ,    0x1.f942c6a02c6e3p+1,   -0x1.6297dcf715689p-1,   0x1.fffffep-1, INEXACT)
T(RU,    0x1.f942c6a02c6e3p+1,   -0x1.6297dcf715689p-1,   0x1.fffffep-1, INEXACT)
T(RD,    0x1.f942c6a02c6e3p+1,   -0x1.6297dcf71568ap-1, -0x1.a6b32ap-25, INEXACT)
T(RN,  -0x1.3d92d24f7cedp+250,    0x1.71928800d9b01p-1,  -0x1.fffffap-2, INEXACT)
T(RZ, -0x1.65ed2e9000b22p+406,   -0x1.19b0fbaf3299ep-1,  0x1.784a82p-24, INEXACT)
T(RU, -0x1.65ed2e9000b22p+406,   -0x1.19b0fbaf3299ep-1,  0x1.784a82p-24, INEXACT)
T(RD, -0x1.65ed2e9000b22p+406,   -0x1.19b0fbaf3299fp-1,  -0x1.fffffep-1, INEXACT)
T(RN, -0x1.418275230a365p+670,    0x1.5731663038504p-3,  -0x1.fffff8p-2, INEXACT)
T(RZ,  0x1.8ba1377f6d676p+970,   -0x1.a0da736f5ffbbp-6,          0x1p+0, INEXACT)
T(RU,  0x1.8ba1377f6d676p+970,   -0x1.a0da736f5ffbbp-6,          0x1p+0, INEXACT)
T(RD,  0x1.8ba1377f6d676p+970,   -0x1.a0da736f5ffbcp-6, -0x1.cf1236p-27, INEXACT)
T(RZ, -0x1.27c2f39380465p+916,    0x1.f2054b0643298p-1, -0x1.1c9b94p-25, INEXACT)
T(RD, -0x1.27c2f39380465p+916,    0x1.f2054b0643298p-1, -0x1.1c9b94p-25, INEXACT)
T(RU, -0x1.27c2f39380465p+916,    0x1.f2054b0643299p-1,   0x1.fffffep-1, INEXACT)
T(RN, -0x1.93ae9873ac0ecp+305,    -0x1.cd220ac43b8dp-4,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.ed9788b1dd6ddp+427,   -0x1.3763bbd258a96p-8,  -0x1.fffffcp-2, INEXACT)
T(RN, -0x1.77b60c580e397p+311,    0x1.ea09eb8240635p-1,  -0x1.fffffap-2, INEXACT)
T(RN, -0x1.121b5ba065bd7p+508,   -0x1.d06f67801df85p-2,  -0x1.fffffap-2, INEXACT)
T(RN,  0x1.c35654ca8c7a4p+572,    0x1.ca5d6478b2221p-1,  -0x1.fffffcp-2, INEXACT)
T(RN,  0x1.f79e2d2c93ed6p+193,   -0x1.596c1f113350cp-2,  -0x1.fffffap-2, INEXACT)
T(RN,  0x1.84e36b9c6d0c1p+869,    0x1.69b76420a053ap-1,  -0x1.fffffcp-2, INEXACT)
T(RZ, -0x1.c5a76c3ea9cdcp+807,   -0x1.aba349e7871aap-1,   0x1.fffffep-1, INEXACT)
T(RU, -0x1.c5a76c3ea9cdcp+807,   -0x1.aba349e7871aap-1,   0x1.fffffep-1, INEXACT)
T(RD, -0x1.c5a76c3ea9cdcp+807,   -0x1.aba349e7871abp-1, -0x1.574f74p-25, INEXACT)
T(RZ, -0x1.8f0da7358664ep+123,   -0x1.b39cc0503fb43p-1,          0x1p+0, INEXACT)
T(RU, -0x1.8f0da7358664ep+123,   -0x1.b39cc0503fb43p-1,          0x1p+0, INEXACT)
T(RD, -0x1.8f0da7358664ep+123,   -0x1.b39cc0503fb44p-1, -0x1.f43034p-28, INEXACT)
T(RZ, -0x1.912dd0a7a97e9p+321,   -0x1.060597a356b55p-1,  0x1.4a7b4ep-26, INEXACT)
T(RU, -0x1.912dd0a7a97e9p+321,   -0x1.060597a356b55p-1,  0x1.4a7b4ep-26, INEXACT)
T(RD, -0x1.912dd0a7a97e9p+321,   -0x1.060597a356b56p-1,         -0x1p+0, INEXACT)
T(RZ,   0x1.b77ba27615fd4p+17,   -0x1.0d646ecbc5238p-2,          0x1p+0, INEXACT)
T(RU,   0x1.b77ba27615fd4p+17,   -0x1.0d646ecbc5238p-2,          0x1p+0, INEXACT)
T(RD,   0x1.b77ba27615fd4p+17,   -0x1.0d646ecbc5239p-2, -0x1.e709f2p-26, INEXACT)
T(RN,  0x1.f76b4355d040cp+411,    0x1.429d3f18755a9p-1,  -0x1.fffffcp-2, INEXACT)
T(RZ,  0x1.85bfb082bec1bp+305,   -0x1.fb78164659eb2p-1,          0x1p+0, INEXACT)
T(RU,  0x1.85bfb082bec1bp+305,   -0x1.fb78164659eb2p-1,          0x1p+0, INEXACT)
T(RD,  0x1.85bfb082bec1bp+305,   -0x1.fb78164659eb3p-1, -0x1.5dbd6ap-26, INEXACT)
T(RZ,  0x1.09a76bd4c369ep+898,   -0x1.9bd60b639aae6p-1,  0x1.533edap-26, INEXACT)
T(RU,  0x1.09a76bd4c369ep+898,   -0x1.9bd60b639aae6p-1,  0x1.533edap-26, INEXACT)
T(RD,  0x1.09a76bd4c369ep+898,   -0x1.9bd60b639aae7p-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.d287a78e98b67p+864,    0x1.f83909d127605p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.d287a78e98b67p+864,    0x1.f83909d127605p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.d287a78e98b67p+864,    0x1.f83909d127606p-1,   0x1.d8e49p-26, INEXACT)
T(RN,   0x1.e999925e28bdp+606,    0x1.f9e1137d48fc8p-1,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.3395b796f49c2p+226,   -0x1.d0530fe910886p-1,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.3395b796f49c2p+226,   -0x1.d0530fe910886p-1,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.3395b796f49c2p+226,   -0x1.d0530fe910887p-1, -0x1.3117fep-25, INEXACT)
T(RZ,   0x1.0ae1ac87b16e6p+96,    0x1.2f7312b9e1061p-1, -0x1.040d7ap-25, INEXACT)
T(RD,   0x1.0ae1ac87b16e6p+96,    0x1.2f7312b9e1061p-1, -0x1.040d7ap-25, INEXACT)
T(RU,   0x1.0ae1ac87b16e6p+96,    0x1.2f7312b9e1062p-1,   0x1.fffffep-1, INEXACT)
T(RZ, -0x1.a0371ccec7ec6p+710,    0x1.e1d5b46061d1cp-1,         -0x1p+0, INEXACT)
T(RD, -0x1.a0371ccec7ec6p+710,    0x1.e1d5b46061d1cp-1,         -0x1p+0, INEXACT)
T(RU, -0x1.a0371ccec7ec6p+710,    0x1.e1d5b46061d1dp-1,  0x1.e5d64cp-28, INEXACT)
T(RZ, -0x1.d8df39aeb4db7p+156,    0x1.0855fb0137fc8p-2, -0x1.017ae2p-25, INEXACT)
T(RD, -0x1.d8df39aeb4db7p+156,    0x1.0855fb0137fc8p-2, -0x1.017ae2p-25, INEXACT)
T(RU, -0x1.d8df39aeb4db7p+156,    0x1.0855fb0137fc9p-2,   0x1.fffffep-1, INEXACT)
T(RZ,  0x1.8c546e121ffa2p+545,   -0x1.55c30d560c477p-1,          0x1p+0, INEXACT)
T(RU,  0x1.8c546e121ffa2p+545,   -0x1.55c30d560c477p-1,          0x1p+0, INEXACT)
T(RD,  0x1.8c546e121ffa2p+545,   -0x1.55c30d560c478p-1, -0x1.790ec6p-26, INEXACT)
T(RN,  -0x1.1be2456fa1b9bp+86,    0x1.f4b8cef79864dp-2,  -0x1.fffffcp-2, INEXACT)
T(RN,  0x1.18048a7da9f2dp+476,   -0x1.f4c758f254982p-2,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.e5ccb50e09e45p+566,    0x1.8698ba1d79374p-1, -0x1.b3f402p-25, INEXACT)
T(RD,  0x1.e5ccb50e09e45p+566,    0x1.8698ba1d79374p-1, -0x1.b3f402p-25, INEXACT)
T(RU,  0x1.e5ccb50e09e45p+566,    0x1.8698ba1d79375p-1,   0x1.fffffep-1, INEXACT)
T(RN,  0x1.8289cb74d682ap+727,   -0x1.1ab4b8e9b207fp-1,  -0x1.fffffep-2, INEXACT)
T(RZ,   -0x1.8a6ae66fe61p+160,   -0x1.28143d3a0888fp-1,  0x1.8c630ap-26, INEXACT)
T(RU,   -0x1.8a6ae66fe61p+160,   -0x1.28143d3a0888fp-1,  0x1.8c630ap-26, INEXACT)
T(RD,   -0x1.8a6ae66fe61p+160,    -0x1.28143d3a0889p-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.da036ebb5063bp+265,   -0x1.a8cf834827bdep-1,          0x1p+0, INEXACT)
T(RU, -0x1.da036ebb5063bp+265,   -0x1.a8cf834827bdep-1,          0x1p+0, INEXACT)
T(RD, -0x1.da036ebb5063bp+265,   -0x1.a8cf834827bdfp-1, -0x1.4ae7d8p-26, INEXACT)
T(RZ,  0x1.66745db03a147p+784,   -0x1.1cba993140e57p-3,   0x1.fffffep-1, INEXACT)
T(RU,  0x1.66745db03a147p+784,   -0x1.1cba993140e57p-3,   0x1.fffffep-1, INEXACT)
T(RD,  0x1.66745db03a147p+784,   -0x1.1cba993140e58p-3, -0x1.21e42ap-25, INEXACT)
T(RZ, -0x1.3b7a4f72f6f9ap+684,   -0x1.ec33d0fd85cf5p-2,  0x1.47f50ap-26, INEXACT)
T(RU, -0x1.3b7a4f72f6f9ap+684,   -0x1.ec33d0fd85cf5p-2,  0x1.47f50ap-26, INEXACT)
T(RD, -0x1.3b7a4f72f6f9ap+684,   -0x1.ec33d0fd85cf6p-2,         -0x1p+0, INEXACT)
T(RN,  0x1.1224300aa725dp+451,    0x1.cf4bfcdb87737p-2,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.e1afe14e74f08p+261,   -0x1.fdaae2cfcdacdp-1,  0x1.d4242ap-28, INEXACT)
T(RU,  0x1.e1afe14e74f08p+261,   -0x1.fdaae2cfcdacdp-1,  0x1.d4242ap-28, INEXACT)
T(RD,  0x1.e1afe14e74f08p+261,   -0x1.fdaae2cfcdacep-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.46e798bda0c67p+504,   -0x1.f19f43440fa9ep-1,          0x1p+0, INEXACT)
T(RU,  0x1.46e798bda0c67p+504,   -0x1.f19f43440fa9ep-1,          0x1p+0, INEXACT)
T(RD,  0x1.46e798bda0c67p+504,   -0x1.f19f43440fa9fp-1, -0x1.5065b2p-26, INEXACT)
T(RN, -0x1.52f170c9eca09p+316,   -0x1.31037441b4197p-1,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.c2cd2cb79643bp+827,   -0x1.b219a5c78f79dp-1,  0x1.0815f6p-25, INEXACT)
T(RU,  0x1.c2cd2cb79643bp+827,   -0x1.b219a5c78f79dp-1,  0x1.0815f6p-25, INEXACT)
T(RD,  0x1.c2cd2cb79643bp+827,   -0x1.b219a5c78f79ep-1,  -0x1.fffffep-1, INEXACT)
T(RN, -0x1.e08254336f511p+433,   -0x1.7962df9e191e7p-6,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.8f451a9163be7p+385,    0x1.74bb10f60962cp-1,         -0x1p-1, INEXACT)
T(RN, -0x1.ef11622ae2f43p+164,    0x1.ecfc8b507d034p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.daf878c2d43f9p+372,    0x1.670810d80a161p-1,         -0x1p-1, INEXACT)
T(RN,    0x1.ee27dbdd30837p-1,    0x1.237aad79bc57ep-1,         -0x1p-1, INEXACT)
T(RN, -0x1.eb60f31518274p+474,   -0x1.ffd44dd35a9dfp-1,  -0x1.fffffcp-2, INEXACT)
T(RN,  0x1.0ffc7df41b58ap+949,   -0x1.b2aa19924f146p-1,  -0x1.fffffep-2, INEXACT)
T(RN, 0x1.afaa06b6c70afp+1019,     0x1.fd4205fb3c01p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.ce2587251b649p+982,   -0x1.f30518a4e5691p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.66f3a257eb97cp+421,   -0x1.f826f1d14ec68p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.f1cbdf3b4ee27p+901,    0x1.8e56486c3c7a2p-3,  -0x1.fffffcp-2, INEXACT)
T(RN, -0x1.d0b2c86d6583ep+510,    -0x1.7ed4463b3748p-2,  -0x1.fffffcp-2, INEXACT)
T(RN,  -0x1.cfdce2e9f9b8p+917,   -0x1.fa5f8f794d3cfp-1,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.d3ab334ed0745p+306,   -0x1.cf3e1a869c7bbp-1,          0x1p+0, INEXACT)
T(RU, -0x1.d3ab334ed0745p+306,   -0x1.cf3e1a869c7bbp-1,          0x1p+0, INEXACT)
T(RD, -0x1.d3ab334ed0745p+306,   -0x1.cf3e1a869c7bcp-1, -0x1.13227ap-26, INEXACT)
T(RZ,  -0x1.040fe4f8ef6cbp+95,    0x1.c28c26cc85447p-1,         -0x1p+0, INEXACT)
T(RD,  -0x1.040fe4f8ef6cbp+95,    0x1.c28c26cc85447p-1,         -0x1p+0, INEXACT)
T(RU,  -0x1.040fe4f8ef6cbp+95,    0x1.c28c26cc85448p-1,  0x1.1e532ep-27, INEXACT)
T(RN, -0x1.508c354d32dd8p+534,   -0x1.f6652afacdb4bp-1,         -0x1p-1, INEXACT)
T(RN,  0x1.81f91f3d8e397p+270,   -0x1.8e8db1c99cc11p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.0c2bb787883cap+180,   -0x1.d8147b9921e4dp-1,         -0x1p-1, INEXACT)
T(RZ,  -0x1.650ef6c5be16p+249,   -0x1.8fd44c53ca64dp-1,  0x1.992c88p-29, INEXACT)
T(RU,  -0x1.650ef6c5be16p+249,   -0x1.8fd44c53ca64dp-1,  0x1.992c88p-29, INEXACT)
T(RD,  -0x1.650ef6c5be16p+249,   -0x1.8fd44c53ca64ep-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.a0c0759881b0ap+248,   -0x1.4eb0f66b954b8p-1,  0x1.42106ep-26, INEXACT)
T(RU,  0x1.a0c0759881b0ap+248,   -0x1.4eb0f66b954b8p-1,  0x1.42106ep-26, INEXACT)
T(RD,  0x1.a0c0759881b0ap+248,   -0x1.4eb0f66b954b9p-1,         -0x1p+0, INEXACT)
T(RN,   0x1.bd7cf27686c3p+734,    0x1.bdbeb38a8fa5bp-4,  -0x1.fffffep-2, INEXACT)
T(RZ,  0x1.6956ee73e0ca3p+942,    0x1.e8db53ca3d519p-2, -0x1.7bbd74p-26, INEXACT)
T(RD,  0x1.6956ee73e0ca3p+942,    0x1.e8db53ca3d519p-2, -0x1.7bbd74p-26, INEXACT)
T(RU,  0x1.6956ee73e0ca3p+942,    0x1.e8db53ca3d51ap-2,          0x1p+0, INEXACT)
T(RZ, -0x1.116494151c9e1p+121,   -0x1.755b04539ddf7p-1,  0x1.6183fep-26, INEXACT)
T(RU, -0x1.116494151c9e1p+121,   -0x1.755b04539ddf7p-1,  0x1.6183fep-26, INEXACT)
T(RD, -0x1.116494151c9e1p+121,   -0x1.755b04539ddf8p-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.5ba76cb8d5c68p+147,    0x1.d8d5665704419p-3,         -0x1p+0, INEXACT)
T(RD, -0x1.5ba76cb8d5c68p+147,    0x1.d8d5665704419p-3,         -0x1p+0, INEXACT)
T(RU, -0x1.5ba76cb8d5c68p+147,    0x1.d8d566570441ap-3,  0x1.f7b44cp-26, INEXACT)
T(RN, -0x1.ecfa55bee7301p+887,     0x1.2eca06f03684p-2,         -0x1p-1, INEXACT)
T(RZ, -0x1.47603d80e8b1ep+682,    -0x1.465490e96a18p-2,          0x1p+0, INEXACT)
T(RU, -0x1.47603d80e8b1ep+682,    -0x1.465490e96a18p-2,          0x1p+0, INEXACT)
T(RD, -0x1.47603d80e8b1ep+682,   -0x1.465490e96a181p-2, -0x1.15947ap-31, INEXACT)
T(RZ,  0x1.fcbc24959e5a3p+669,    0x1.a5815eca460e8p-6,         -0x1p+0, INEXACT)
T(RD,  0x1.fcbc24959e5a3p+669,    0x1.a5815eca460e8p-6,         -0x1p+0, INEXACT)
T(RU,  0x1.fcbc24959e5a3p+669,    0x1.a5815eca460e9p-6,  0x1.532ee4p-27, INEXACT)
T(RZ,  0x1.88fbb88109a86p+843,    0x1.2d3b0c586c8a9p-1,         -0x1p+0, INEXACT)
T(RD,  0x1.88fbb88109a86p+843,    0x1.2d3b0c586c8a9p-1,         -0x1p+0, INEXACT)
T(RU,  0x1.88fbb88109a86p+843,    0x1.2d3b0c586c8aap-1,  0x1.6a4736p-26, INEXACT)
T(RZ,   0x1.af0359815ec38p+73,    0x1.c2e23aee80cd2p-1,         -0x1p+0, INEXACT)
T(RD,   0x1.af0359815ec38p+73,    0x1.c2e23aee80cd2p-1,         -0x1p+0, INEXACT)
T(RU,   0x1.af0359815ec38p+73,    0x1.c2e23aee80cd3p-1,  0x1.40f57ap-27, INEXACT)
T(RZ, -0x1.0a198f659a4cap+846,    0x1.6934f0bcaaa66p-1, -0x1.77059cp-26, INEXACT)
T(RD, -0x1.0a198f659a4cap+846,    0x1.6934f0bcaaa66p-1, -0x1.77059cp-26, INEXACT)
T(RU, -0x1.0a198f659a4cap+846,    0x1.6934f0bcaaa67p-1,          0x1p+0, INEXACT)
T(RZ,  0x1.1054667c9186ap+707,   -0x1.be17668cf352cp-1,          0x1p+0, INEXACT)
T(RU,  0x1.1054667c9186ap+707,   -0x1.be17668cf352cp-1,          0x1p+0, INEXACT)
T(RD,  0x1.1054667c9186ap+707,   -0x1.be17668cf352dp-1, -0x1.fee814p-26, INEXACT)
T(RZ, -0x1.4abd3e790741fp+513,   -0x1.befecc3905de3p-1,          0x1p+0, INEXACT)
T(RU, -0x1.4abd3e790741fp+513,   -0x1.befecc3905de3p-1,          0x1p+0, INEXACT)
T(RD, -0x1.4abd3e790741fp+513,   -0x1.befecc3905de4p-1, -0x1.e16d9ap-26, INEXACT)
T(RZ, -0x1.1d036acd9779cp+549,    0x1.68445c7e711a7p-1, -0x1.6c846cp-27, INEXACT)
T(RD, -0x1.1d036acd9779cp+549,    0x1.68445c7e711a7p-1, -0x1.6c846cp-27, INEXACT)
T(RU, -0x1.1d036acd9779cp+549,    0x1.68445c7e711a8p-1,          0x1p+0, INEXACT)
T(RZ, -0x1.b8e4f2fe36f83p+398,   -0x1.baa2ec23e3bf3p-4,          0x1p+0, INEXACT)
T(RU, -0x1.b8e4f2fe36f83p+398,   -0x1.baa2ec23e3bf3p-4,          0x1p+0, INEXACT)
T(RD, -0x1.b8e4f2fe36f83p+398,   -0x1.baa2ec23e3bf4p-4, -0x1.b11028p-26, INEXACT)
T(RZ,  0x1.ebf030379f2f8p+558,    0x1.cfd8aacc956e5p-1, -0x1.6bb20ep-26, INEXACT)
T(RD,  0x1.ebf030379f2f8p+558,    0x1.cfd8aacc956e5p-1, -0x1.6bb20ep-26, INEXACT)
T(RU,  0x1.ebf030379f2f8p+558,    0x1.cfd8aacc956e6p-1,          0x1p+0, INEXACT)
T(RZ, -0x1.8bdec821f01ddp+750,    0x1.2b1d4037efea5p-3,         -0x1p+0, INEXACT)
T(RD, -0x1.8bdec821f01ddp+750,    0x1.2b1d4037efea5p-3,         -0x1p+0, INEXACT)
T(RU, -0x1.8bdec821f01ddp+750,    0x1.2b1d4037efea6p-3,  0x1.384cdap-26, INEXACT)
T(RN, -0x1.eb5261f3cb8c7p+286,    0x1.c19b1b449f723p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.03d1793620d9cp+758,    0x1.fffa6bf3ee113p-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.56d2ab9cc03a9p+695,    0x1.8baf4ee57e9eep-1,  -0x1.fffffep-2, INEXACT)
T(RZ, -0x1.fa299cd759b4ap+166,    0x1.0b528872b6fbcp-5, -0x1.bce3fap-28, INEXACT)
T(RD, -0x1.fa299cd759b4ap+166,    0x1.0b528872b6fbcp-5, -0x1.bce3fap-28, INEXACT)
T(RU, -0x1.fa299cd759b4ap+166,    0x1.0b528872b6fbdp-5,          0x1p+0, INEXACT)
T(RZ,  0x1.34d6fda51b176p+647,   -0x1.ff6ed12467fc8p-1,  0x1.3021c4p-26, INEXACT)
T(RU,  0x1.34d6fda51b176p+647,   -0x1.ff6ed12467fc8p-1,  0x1.3021c4p-26, INEXACT)
T(RD,  0x1.34d6fda51b176p+647,   -0x1.ff6ed12467fc9p-1,         -0x1p+0, INEXACT)
T(RN, -0x1.3e4583c495c62p+255,   -0x1.d9d8c9bf3a901p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.3119f24921cfcp+848,   -0x1.fbe703ffe9d18p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.45f377f3f34b5p+856,   -0x1.18d0be2332ae6p-3,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.20bbf050a52b1p+299,   -0x1.c7d8bf791334bp-2,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.cfa3cad328354p+441,    0x1.e7b15a8719639p-1,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.d518fd584442dp+117,    0x1.a9bc8416df1bfp-3,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.ad1efdbef8b05p+774,    0x1.37488400943e4p-3,  -0x1.fffffep-2, INEXACT)
T(RN,  0x1.db1b736251349p+322,   -0x1.d0d2e299917a2p-1,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.7dd757ea15be6p+865,   -0x1.97106f07d2846p-2,  -0x1.fffffep-2, INEXACT)
T(RN, -0x1.7803110e4bdd4p+262,    -0x1.6211a8a422cbp-1,         -0x1p-1, INEXACT)
T(RN,  0x1.18f1fc0e977b4p+853,   -0x1.d4afd29afd8c8p-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.a374dbacf886dp+394,    0x1.fef6109f507f1p-1, -0x1.cca9c8p-27, INEXACT)
T(RD,  0x1.a374dbacf886dp+394,    0x1.fef6109f507f1p-1, -0x1.cca9c8p-27, INEXACT)
T(RU,  0x1.a374dbacf886dp+394,    0x1.fef6109f507f2p-1,          0x1p+0, INEXACT)
T(RN, -0x1.67fb4d63f9856p+435,   -0x1.c277e9b2fb55cp-2,         -0x1p-1, INEXACT)
T(RN, -0x1.0151a573dbed9p+800,   -0x1.e2f3425480a64p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.0fe6c9cbb4288p+643,   -0x1.290320409c547p-1,  0x1.03e2cep-27, INEXACT)
T(RU, -0x1.0fe6c9cbb4288p+643,   -0x1.290320409c547p-1,  0x1.03e2cep-27, INEXACT)
T(RD, -0x1.0fe6c9cbb4288p+643,   -0x1.290320409c548p-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.7d346b2c73b79p+564,    0x1.fd52750bfd03ep-1, -0x1.6952f8p-30, INEXACT)
T(RD,  0x1.7d346b2c73b79p+564,    0x1.fd52750bfd03ep-1, -0x1.6952f8p-30, INEXACT)
T(RU,  0x1.7d346b2c73b79p+564,    0x1.fd52750bfd03fp-1,          0x1p+0, INEXACT)
T(RN, -0x1.31166218c12c1p+588,   -0x1.fffba980d521dp-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.edf00ba1b5499p+448,   -0x1.dc1c7fc110766p-2,          0x1p+0, INEXACT)
T(RU,  0x1.edf00ba1b5499p+448,   -0x1.dc1c7fc110766p-2,          0x1p+0, INEXACT)
T(RD,  0x1.edf00ba1b5499p+448,   -0x1.dc1c7fc110767p-2, -0x1.5754ecp-27, INEXACT)
T(RZ,  0x1.7a7dd2711bf0cp+529,   -0x1.8c47b4e256531p-1,          0x1p+0, INEXACT)
T(RU,  0x1.7a7dd2711bf0cp+529,   -0x1.8c47b4e256531p-1,          0x1p+0, INEXACT)
T(RD,  0x1.7a7dd2711bf0cp+529,   -0x1.8c47b4e256532p-1, -0x1.c1beb2p-27, INEXACT)
T(RZ,   0x1.4551c02d020b8p+52,    0x1.42ab936003b1bp-2,         -0x1p+0, INEXACT)
T(RD,   0x1.4551c02d020b8p+52,    0x1.42ab936003b1bp-2,         -0x1p+0, INEXACT)
T(RU,   0x1.4551c02d020b8p+52,    0x1.42ab936003b1cp-2,  0x1.81cc76p-27, INEXACT)
T(RZ,  0x1.1ae8885e05bbfp+599,   -0x1.69e3d2fd596c5p-1,          0x1p+0, INEXACT)
T(RU,  0x1.1ae8885e05bbfp+599,   -0x1.69e3d2fd596c5p-1,          0x1p+0, INEXACT)
T(RD,  0x1.1ae8885e05bbfp+599,   -0x1.69e3d2fd596c6p-1, -0x1.d292acp-27, INEXACT)
T(RZ,  0x1.b91e0308be7ddp+718,    0x1.e46c58910248fp-1, -0x1.be707ap-27, INEXACT)
T(RD,  0x1.b91e0308be7ddp+718,    0x1.e46c58910248fp-1, -0x1.be707ap-27, INEXACT)
T(RU,  0x1.b91e0308be7ddp+718,     0x1.e46c58910249p-1,          0x1p+0, INEXACT)
T(RZ,  0x1.801a31cb3238cp+927,   -0x1.8a16c271a7702p-1,          0x1p+0, INEXACT)
T(RU,  0x1.801a31cb3238cp+927,   -0x1.8a16c271a7702p-1,          0x1p+0, INEXACT)
T(RD,  0x1.801a31cb3238cp+927,   -0x1.8a16c271a7703p-1, -0x1.098044p-30, INEXACT)
T(RZ, -0x1.86ab8e5f5b7c1p+303,   -0x1.3867d7c78fb06p-1,          0x1p+0, INEXACT)
T(RU, -0x1.86ab8e5f5b7c1p+303,   -0x1.3867d7c78fb06p-1,          0x1p+0, INEXACT)
T(RD, -0x1.86ab8e5f5b7c1p+303,   -0x1.3867d7c78fb07p-1, -0x1.75af76p-27, INEXACT)
T(RZ, -0x1.45829a5428029p+583,    0x1.ff5f4112edc96p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.45829a5428029p+583,    0x1.ff5f4112edc96p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.45829a5428029p+583,    0x1.ff5f4112edc97p-1,  0x1.b91d28p-28, INEXACT)
T(RZ, -0x1.d112693a8330dp+871,   -0x1.199b7028e0dd2p-2,  0x1.ecaf22p-27, INEXACT)
T(RU, -0x1.d112693a8330dp+871,   -0x1.199b7028e0dd2p-2,  0x1.ecaf22p-27, INEXACT)
T(RD, -0x1.d112693a8330dp+871,   -0x1.199b7028e0dd3p-2,         -0x1p+0, INEXACT)
T(RN, -0x1.abb1ceb9cd2dep+707,   -0x1.fa30a53e47d51p-1,         -0x1p-1, INEXACT)
T(RZ, -0x1.8629770160a24p+122,    0x1.f38cee58fc184p-1,         -0x1p+0, INEXACT)
T(RD, -0x1.8629770160a24p+122,    0x1.f38cee58fc184p-1,         -0x1p+0, INEXACT)
T(RU, -0x1.8629770160a24p+122,    0x1.f38cee58fc185p-1,  0x1.ca7c48p-28, INEXACT)
T(RZ, -0x1.0fa6e4574816ap+940,   -0x1.5ed7f66383594p-1,  0x1.24f8b2p-28, INEXACT)
T(RU, -0x1.0fa6e4574816ap+940,   -0x1.5ed7f66383594p-1,  0x1.24f8b2p-28, INEXACT)
T(RD, -0x1.0fa6e4574816ap+940,   -0x1.5ed7f66383595p-1,         -0x1p+0, INEXACT)
T(RN, 0x1.979c379b473d9p+1001,    0x1.e669915f0bca5p-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.802e63486b45dp+190,    -0x1.f46eaf069a48p-1,          0x1p+0, INEXACT)
T(RU,  0x1.802e63486b45dp+190,    -0x1.f46eaf069a48p-1,          0x1p+0, INEXACT)
T(RD,  0x1.802e63486b45dp+190,   -0x1.f46eaf069a481p-1,   -0x1.81e6p-27, INEXACT)
T(RN,  0x1.fd5315133f691p+362,   -0x1.147ad7b2da8e8p-2,         -0x1p-1, INEXACT)
T(RN, -0x1.793a0a6969afdp+459,    0x1.07668de3fb9bep-1,         -0x1p-1, INEXACT)
T(RN, -0x1.b054a9bfa9fafp+465,   -0x1.5e38e9375a0d1p-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.03d8c7e83991dp+257,   -0x1.f48e63b8575eep-1,  0x1.e53ba2p-27, INEXACT)
T(RU,  0x1.03d8c7e83991dp+257,   -0x1.f48e63b8575eep-1,  0x1.e53ba2p-27, INEXACT)
T(RD,  0x1.03d8c7e83991dp+257,   -0x1.f48e63b8575efp-1,         -0x1p+0, INEXACT)
T(RN,  0x1.2a108d0de7649p+582,    0x1.12a507c50960fp-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.de3ffc74df0b7p+249,    0x1.4b95b4fbc4714p-4,         -0x1p+0, INEXACT)
T(RD,  0x1.de3ffc74df0b7p+249,    0x1.4b95b4fbc4714p-4,         -0x1p+0, INEXACT)
T(RU,  0x1.de3ffc74df0b7p+249,    0x1.4b95b4fbc4715p-4,  0x1.a7cd26p-27, INEXACT)
T(RZ,  0x1.3f71c81a6bd0ap+737,    0x1.3c196d241a6e2p-5, -0x1.4f0be4p-29, INEXACT)
T(RD,  0x1.3f71c81a6bd0ap+737,    0x1.3c196d241a6e2p-5, -0x1.4f0be4p-29, INEXACT)
T(RU,  0x1.3f71c81a6bd0ap+737,    0x1.3c196d241a6e3p-5,          0x1p+0, INEXACT)
T(RZ,  0x1.a928c67fb2f39p+151,   -0x1.cadc1f3a448b2p-1,          0x1p+0, INEXACT)
T(RU,  0x1.a928c67fb2f39p+151,   -0x1.cadc1f3a448b2p-1,          0x1p+0, INEXACT)
T(RD,  0x1.a928c67fb2f39p+151,   -0x1.cadc1f3a448b3p-1, -0x1.92d5a6p-27, INEXACT)
T(RZ, -0x1.3857528caea65p+149,   -0x1.77cc7d9af8f3cp-1,  0x1.ce5148p-27, INEXACT)
T(RU, -0x1.3857528caea65p+149,   -0x1.77cc7d9af8f3cp-1,  0x1.ce5148p-27, INEXACT)
T(RD, -0x1.3857528caea65p+149,   -0x1.77cc7d9af8f3dp-1,         -0x1p+0, INEXACT)
T(RN,  0x1.572080977f4fdp+428,   -0x1.dcd46108c910bp-1,         -0x1p-1, INEXACT)
T(RN,  0x1.7aac69f23862ap+672,    0x1.6ca680d1bfba5p-1,         -0x1p-1, INEXACT)
T(RN,  -0x1.f8d88996527fp+477,    0x1.e2b1760dc9279p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.6b6503ffe756dp+803,   -0x1.275c46ab6f333p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.0f6a02d54dd55p+743,   -0x1.dcb01f31b45d3p-2,         -0x1p-1, INEXACT)
T(RN, -0x1.b5e8d8e505845p+520,    0x1.dc0d3d6d578d6p-1,         -0x1p-1, INEXACT)
T(RN,  0x1.f65774dfcf097p+549,   -0x1.458625eb2f432p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.79703315c8aeap+624,   -0x1.81e18d111f545p-3,         -0x1p-1, INEXACT)
T(RN,  0x1.a5a5a05af890cp+398,    0x1.af30eb7dd4cb9p-1,         -0x1p-1, INEXACT)
T(RN, -0x1.e976fdeae5b96p+165,   -0x1.2db580a4f49c6p-2,         -0x1p-1, INEXACT)
T(RN,  0x1.28c94fc1cd9f3p+235,   -0x1.c753ba3d1c09ap-1,         -0x1p-1, INEXACT)
T(RZ,  0x1.cdbdbab8d3f41p+180,    -0x1.e65848fd2a93p-3,  0x1.2bd098p-29, INEXACT)
T(RU,  0x1.cdbdbab8d3f41p+180,    -0x1.e65848fd2a93p-3,  0x1.2bd098p-29, INEXACT)
T(RD,  0x1.cdbdbab8d3f41p+180,   -0x1.e65848fd2a931p-3,         -0x1p+0, INEXACT)
T(RZ,  0x1.7f6899a802f25p+591,   -0x1.f6efee38f0b4fp-1,  0x1.2365fep-28, INEXACT)
T(RU,  0x1.7f6899a802f25p+591,   -0x1.f6efee38f0b4fp-1,  0x1.2365fep-28, INEXACT)
T(RD,  0x1.7f6899a802f25p+591,    -0x1.f6efee38f0b5p-1,         -0x1p+0, INEXACT)
T(RZ,  -0x1.a46a09dd1e0fp+496,   -0x1.bc424deaf9fa3p-1,  0x1.63e68cp-28, INEXACT)
T(RU,  -0x1.a46a09dd1e0fp+496,   -0x1.bc424deaf9fa3p-1,  0x1.63e68cp-28, INEXACT)
T(RD,  -0x1.a46a09dd1e0fp+496,   -0x1.bc424deaf9fa4p-1,         -0x1p+0, INEXACT)
T(RZ,  0x1.a1abd0614a1f1p+294,   -0x1.f167ae9fa5a79p-1,  0x1.fabfbep-28, INEXACT)
T(RU,  0x1.a1abd0614a1f1p+294,   -0x1.f167ae9fa5a79p-1,  0x1.fabfbep-28, INEXACT)
T(RD,  0x1.a1abd0614a1f1p+294,   -0x1.f167ae9fa5a7ap-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.fe722eb5bccafp+394,   -0x1.e77e03e4c297cp-1,  0x1.76f26ep-31, INEXACT)
T(RU, -0x1.fe722eb5bccafp+394,   -0x1.e77e03e4c297cp-1,  0x1.76f26ep-31, INEXACT)
T(RD, -0x1.fe722eb5bccafp+394,   -0x1.e77e03e4c297dp-1,         -0x1p+0, INEXACT)
T(RZ, -0x1.d67dbbb2b482ap+381,   -0x1.fc6038fd9c7c8p-1,          0x1p+0, INEXACT)
T(RU, -0x1.d67dbbb2b482ap+381,   -0x1.fc6038fd9c7c8p-1,          0x1p+0, INEXACT)
T(RD, -0x1.d67dbbb2b482ap+381,   -0x1.fc6038fd9c7c9p-1, -0x1.fb3d42p-28, INEXACT)
T(RN,   0x1.2e8e884b6620ap-12,    0x1.fffffe9a6b674p-1,    0x1.e0ecep-3, INEXACT)
T(RN,   0x1.15acceda78abfp-12,    0x1.fffffed2d093dp-1,  -0x1.10c346p-3, INEXACT)
T(RN,   0x1.42ab2358760c9p-12,    0x1.fffffe694d08ep-1,  -0x1.88d396p-3, INEXACT)
T(RN,   0x1.b19a6bebe9d32p-12,    0x1.fffffd2194427p-1,  -0x1.606142p-2, INEXACT)
T(RN,    0x1.10aac140f2acp-12,    0x1.fffffedd94b39p-1,   0x1.e59bccp-3, INEXACT)
T(RN,   0x1.6a71fa2513c1bp-12,    0x1.fffffdfed9762p-1,  -0x1.84a5fep-2, INEXACT)
T(RN,   0x1.936c63af66c24p-12,    0x1.fffffd844190cp-1,  -0x1.44210ep-2, INEXACT)
T(RN,   0x1.599c558bcbdd5p-12,    0x1.fffffe2d69424p-1,   0x1.13162ep-2, INEXACT)
T(RN,   0x1.28cb28b1043d2p-12,    0x1.fffffea7e990dp-1,  -0x1.d0acf2p-3, INEXACT)
T(RN,   0x1.a7537d515f95ep-12,    0x1.fffffd43fafd4p-1,  -0x1.0cd028p-3, INEXACT)
T(RN,   0x1.3c345b1afb4b9p-11,    0x1.fffff9e5bad4ap-1,    0x1.2018bp-2, INEXACT)
T(RN,   0x1.3ead21ba67b97p-11,    0x1.fffff9cd35afbp-1,   0x1.977f28p-3, INEXACT)
T(RN,   0x1.8d004346404f6p-11,    0x1.fffff66158c51p-1,  -0x1.95f912p-2, INEXACT)
T(RN,   0x1.a255e577c2d42p-11,    0x1.fffff5518d90dp-1,    0x1.90dbap-3, INEXACT)
T(RN,   0x1.88d4f6eadc22cp-11,     0x1.fffff694cc72p-1,   0x1.46220ep-9, INEXACT)
T(RN,    0x1.dfaf295323b5p-11,    0x1.fffff1f4bc3e7p-1,  -0x1.443cccp-2, INEXACT)
T(RN,   0x1.e8f8f2dcb2664p-11,    0x1.fffff16827d1cp-1,   0x1.10fdeap-2, INEXACT)
T(RN,   0x1.cf08fa22dc45ep-11,    0x1.fffff2e9fa29ep-1,   0x1.621062p-2, INEXACT)
T(RN,   0x1.aaa3b7ab194fap-11,    0x1.fffff4e3eaea6p-1,  -0x1.6ce10cp-2, INEXACT)
T(RN,   0x1.cddfdfbf907aep-11,    0x1.fffff2fabfcfap-1,  -0x1.58c24cp-3, INEXACT)
T(RN,   0x1.75cae52289a76p-10,    0x1.ffffdde37258ap-1,  -0x1.a7306cp-2, INEXACT)
T(RN,   0x1.aec5921e907e4p-10,    0x1.ffffd2b23bb58p-1,   0x1.405948p-2, INEXACT)
T(RN,   0x1.245af539754dap-10,    0x1.ffffeb2206288p-1,  -0x1.4e72fep-3, INEXACT)
T(RN,    0x1.384cf2c31fbdp-10,    0x1.ffffe83045c17p-1,   -0x1.4d3bep-2, INEXACT)
T(RN,   0x1.e5f3edc253631p-10,      0x1.ffffc6589e6p-1,  -0x1.a2d986p-2, INEXACT)
T(RN,   0x1.87c7a13bb3f1ep-10,     0x1.ffffda86c9d2p-1,   0x1.67ecdap-4, INEXACT)
T(RN,    0x1.ca33ff891e22p-10,    0x1.ffffccbe1f4c9p-1,   0x1.64bb04p-2, INEXACT)
T(RN,   0x1.622ba441ab902p-10,    0x1.ffffe16034b2cp-1,  -0x1.f559a2p-3, INEXACT)
T(RN,   0x1.39ea53b28d85cp-10,    0x1.ffffe7f112bdcp-1,  -0x1.5486d2p-9, INEXACT)
T(RN,   0x1.ede1384dc56ccp-10,    0x1.ffffc4732d979p-1,   0x1.194056p-2, INEXACT)
T(RN,    0x1.0a5aec2a07f6ap-9,    0x1.ffffbab7bccb7p-1,  -0x1.911528p-5, INEXACT)
T(RN,    0x1.f50f281247f13p-9,    0x1.ffff0ad2fea1fp-1,  -0x1.2d64f6p-2, INEXACT)
T(RN,    0x1.77dc0a8fce0f4p-9,    0x1.ffff760a6d2d3p-1,  -0x1.acaeb4p-3, INEXACT)
T(RN,     0x1.686cdc36b62ap-9,    0x1.ffff81236ed41p-1,   0x1.720d3cp-3, INEXACT)
T(RN,    0x1.efa6e5c69c4b2p-9,    0x1.ffff10165c635p-1,   0x1.7e84d6p-3, INEXACT)
T(RN,     0x1.687152049ecbp-9,    0x1.ffff81204b07dp-1,   0x1.7087aep-2, INEXACT)
T(RN,     0x1.148f7c5cddf4p-9,    0x1.ffffb54e94abdp-1,  -0x1.223a92p-4, INEXACT)
T(RN,    0x1.1364b96832651p-9,    0x1.ffffb5ef9e4b5p-1,  -0x1.1545f6p-5, INEXACT)
T(RN,    0x1.719ecc201fe39p-9,    0x1.ffff7a953b0e1p-1,   0x1.5adeecp-2, INEXACT)
T(RN,    0x1.b7a2ec99eb769p-9,    0x1.ffff433fffcedp-1,  -0x1.6f2292p-2, INEXACT)
T(RN,    0x1.3a4186554090ep-8,    0x1.fffe7e3b6222dp-1,  -0x1.dba414p-3, INEXACT)
T(RN,    0x1.4ba0d3ac82e31p-8,    0x1.fffe5266f3aa3p-1,  -0x1.71404ep-3, INEXACT)
T(RN,     0x1.057b9cbe5142p-8,    0x1.fffef4eacdec6p-1,  -0x1.04cb94p-3, INEXACT)
T(RN,    0x1.0639fa605bc9bp-8,    0x1.fffef3655dddbp-1,   0x1.139442p-2, INEXACT)
T(RN,    0x1.da4a30808da5bp-8,    0x1.fffc914a2a3cap-1,  -0x1.cd76dap-3, INEXACT)
T(RN,    0x1.b16621632f40cp-8,     0x1.fffd2246098fp-1,   0x1.9ec578p-3, INEXACT)
T(RN,     0x1.a704364db8bep-8,    0x1.fffd4501b385ap-1,   0x1.60bec2p-3, INEXACT)
T(RN,    0x1.e6894bc8cff0ep-8,    0x1.fffc635380f3bp-1,   0x1.2f0b1ep-2, INEXACT)
T(RN,    0x1.d7c24fd8bbd79p-8,    0x1.fffc9aa460b9cp-1,   0x1.97869ap-3, INEXACT)
T(RN,    0x1.836ff83a87f52p-8,    0x1.fffdb5a4b6712p-1,  -0x1.b90b32p-3, INEXACT)
T(RN,     0x1.a69b36eced8bp-7,    0x1.fff519798a22fp-1,   0x1.263206p-4, INEXACT)
T(RN,    0x1.f803f1e0f23b4p-7,    0x1.fff07ed5e6abdp-1,   0x1.a2133cp-3, INEXACT)
T(RN,    0x1.954b91cbd3d13p-7,    0x1.fff5f96799eb7p-1,   -0x1.29aa3p-2, INEXACT)
T(RN,     0x1.424dc970de88p-7,    0x1.fff9a8e4400bfp-1,  -0x1.ad44bep-2, INEXACT)
T(RN,    0x1.bfd379fff8128p-7,    0x1.fff3c27bb15f7p-1,  -0x1.863c42p-6, INEXACT)
T(RN,    0x1.fd6298b283c36p-7,    0x1.fff029d001d69p-1,  -0x1.1dc39ep-2, INEXACT)
T(RN,    0x1.2de167dbbfe2dp-7,    0x1.fffa7013413b7p-1,  -0x1.a376c2p-2, INEXACT)
T(RN,    0x1.ad86ffdc5fb33p-7,    0x1.fff4bd539e2dep-1,  -0x1.34468ap-5, INEXACT)
T(RN,    0x1.6dcdf88ca9b7cp-7,    0x1.fff7d5319d22dp-1,   0x1.8d9568p-2, INEXACT)
T(RN,    0x1.29b93caf35c9fp-7,     0x1.fffa97051d0cp-1,  -0x1.b2c4aap-4, INEXACT)
T(RN,    0x1.b863094059a28p-6,    0x1.ffd0a771705a9p-1,   0x1.36f5acp-2, INEXACT)
T(RN,    0x1.8100b03879caap-6,    0x1.ffdbd03c00bf3p-1,    0x1.b5bfbp-5, INEXACT)
T(RN,    0x1.c7b6182b48dc5p-6,    0x1.ffcd4d497fa55p-1,   0x1.23ca4cp-2, INEXACT)
T(RN,     0x1.c31958ae062bp-6,    0x1.ffce52a89c94fp-1,  -0x1.41b0c8p-4, INEXACT)
T(RN,    0x1.e6ef4493965b7p-6,    0x1.ffc61e01bbe2ep-1,   -0x1.d9f2cp-2, INEXACT)
T(RN,    0x1.ff970c1348c96p-6,    0x1.ffc01b8e85b32p-1,  -0x1.79c1a8p-6, INEXACT)
T(RN,    0x1.f5b5343f6f4d7p-6,    0x1.ffc28d4ec5866p-1,   0x1.822576p-2, INEXACT)
T(RN,    0x1.0f284ac33bb7bp-6,    0x1.ffee0cb590205p-1,   -0x1.6bab7p-2, INEXACT)
T(RN,    0x1.49e9196500aeep-6,    0x1.ffe56dab5eea1p-1,  -0x1.5798f8p-3, INEXACT)
T(RN,     0x1.3b60125d19fbp-6,    0x1.ffe7b7d80f027p-1,   0x1.ef859ap-2, INEXACT)
T(RN,     0x1.cb4fe0b6ec84p-5,    0x1.ff3207ee915c6p-1,  -0x1.949d04p-5, INEXACT)
T(RN,    0x1.32bbe041d1cb7p-5,    0x1.ffa42153f8a42p-1,  -0x1.ba5dc6p-2, INEXACT)
T(RN,    0x1.5e9b7a080217dp-5,    0x1.ff87f950ca0ccp-1,   0x1.0eef0ap-2, INEXACT)
T(RN,    0x1.41e293eae997cp-5,    0x1.ff9ad4d53a628p-1,  -0x1.5243fcp-3, INEXACT)
T(RN,    0x1.401d5e40d1308p-5,    0x1.ff9bf0e6bc68dp-1,  -0x1.3ec722p-3, INEXACT)
T(RN,    0x1.00c09ea0ba6b2p-5,    0x1.ffbfa0e5ce55fp-1,   0x1.8863ccp-2, INEXACT)
T(RN,    0x1.681481870001dp-5,    0x1.ff8166cc74ea4p-1,   0x1.7d7be8p-3, INEXACT)
T(RN,    0x1.460616b9c2e89p-5,    0x1.ff9836a1525eep-1,  -0x1.edca38p-4, INEXACT)
T(RN,    0x1.036c7b426a676p-5,    0x1.ffbe483c1b481p-1,  -0x1.cdb5c6p-2, INEXACT)
T(RN,    0x1.d0e38b7d1630ap-5,    0x1.ff2d0016b09eep-1,   0x1.6132a6p-5, INEXACT)
T(RN,    0x1.647a5f4b4b9dfp-4,    0x1.fe0feb9d1b89fp-1,  -0x1.b7397cp-4, INEXACT)
T(RN,    0x1.bf63590b43906p-4,    0x1.fcf2ead2495d2p-1,  -0x1.6a2c6ep-3, INEXACT)
T(RN,    0x1.3aa48e770bf42p-4,    0x1.fe7d7894ed2fbp-1,   -0x1.db3bep-3, INEXACT)
T(RN,    0x1.b2646f55249d6p-4,    0x1.fd1f981a12043p-1,   0x1.f0182ap-3, INEXACT)
T(RN,     0x1.e18d5f5e72c1p-4,    0x1.fc77366b6ea1ep-1,  -0x1.e62c38p-4, INEXACT)
T(RN,    0x1.920c3af86d782p-4,    0x1.fd8917535b4cdp-1,   0x1.a7410cp-2, INEXACT)
T(RN,    0x1.0598b6fd790f6p-4,    0x1.fef4c681c1a08p-1,  -0x1.ff2312p-3, INEXACT)
T(RN,    0x1.7d2ebcdfa3847p-4,    0x1.fdc8d4aefdadbp-1,   0x1.3adbe8p-4, INEXACT)
T(RN,    0x1.eff4567ee4eacp-4,    0x1.fc40598e865a9p-1,  -0x1.b552b2p-2, INEXACT)
T(RN,    0x1.457538a6bd073p-4,    0x1.fe6274e000974p-1,   0x1.764f98p-2, INEXACT)
T(RN,    0x1.dade15999365ep-3,    0x1.f24c55506fd79p-1,  -0x1.7fe92ep-3, INEXACT)
T(RN,    0x1.a0b6a1ed81148p-3,    0x1.f57010e3785ccp-1,   0x1.332468p-3, INEXACT)
T(RN,    0x1.0523898d78262p-3,    0x1.fbd7eb72ba0b3p-1,  -0x1.11fb46p-3, INEXACT)
T(RN,    0x1.6ee3ca9c8460fp-3,    0x1.f7ce5decd7c6cp-1,  -0x1.f24e2ep-3, INEXACT)
T(RN,    0x1.6c688c10d0f27p-3,    0x1.f7ea92105f837p-1,   0x1.692ac6p-4, INEXACT)
T(RN,    0x1.7bfaf6c22f31ap-3,    0x1.f73672ad2141cp-1,   0x1.5ac446p-5, INEXACT)
T(RN,    0x1.fe69896f7c292p-3,    0x1.f02e64133be27p-1,   0x1.3d6fa8p-3, INEXACT)
T(RN,    0x1.9f78c453635eep-3,    0x1.f58019af5c53dp-1,  -0x1.65427ap-4, INEXACT)
T(RN,    0x1.7ceb135d89d5dp-3,    0x1.f72b5c5e5ba38p-1,    0x1.e02e7p-2, INEXACT)
T(RN,    0x1.9507d5ec8860cp-3,    0x1.f60510d711aeap-1,  -0x1.06d812p-4, INEXACT)
T(RN,    0x1.e2a069d785201p-2,    0x1.c82d79a192a26p-1,   0x1.94a4d6p-6, INEXACT)
T(RN,    0x1.1e3e0e228f7b3p-2,    0x1.ec2056c817f47p-1,   -0x1.c1bb1p-6, INEXACT)
T(RN,     0x1.d3235dba27efp-2,    0x1.cba4438df9c5ap-1,  -0x1.5644e4p-3, INEXACT)
T(RN,    0x1.16fbe745156d2p-2,    0x1.ed1d82c3214c8p-1,   0x1.f07a84p-4, INEXACT)
T(RN,    0x1.363cd23269a66p-2,    0x1.e8ae69844fccbp-1,    0x1.7b0dfp-3, INEXACT)
T(RN,    0x1.6f3e0a46f3d4cp-2,    0x1.df6cc6a98c6dcp-1,  -0x1.6d5a72p-2, INEXACT)
T(RN,    0x1.92749e5210fc8p-2,    0x1.d8f67c1e560d9p-1,  -0x1.c7a992p-4, INEXACT)
T(RN,    0x1.cc0f3c8dd01aep-2,     0x1.cd309938df3ep-1,   0x1.6df23cp-2, INEXACT)
T(RN,    0x1.48089091c97fcp-2,    0x1.e5f3f21113c1bp-1,   0x1.e2ae26p-2, INEXACT)
T(RN,    0x1.f9b8cd4eb1648p-2,    0x1.c2d19a69c7132p-1,  -0x1.be9bc8p-2, INEXACT)
T(RN,    0x1.a2e736ffb809ap-1,    0x1.5dfb4ba3a8efcp-1,   0x1.de90b8p-2, INEXACT)
T(RN,    0x1.cef42406de909p-1,    0x1.3c930fec58a6fp-1,  -0x1.a31bbap-4, INEXACT)
T(RN,    0x1.5276cafeffec6p-1,    0x1.942469a8ebedcp-1,   0x1.9014f2p-2, INEXACT)
T(RN,    0x1.e28271981a923p-1,    0x1.2cfa488a024cdp-1,  -0x1.2afc66p-2, INEXACT)
T(RN,    0x1.6e4f2deb8c879p-1,    0x1.8275164945acep-1,   -0x1.3bc61p-3, INEXACT)
T(RN,    0x1.4e02b2ef298a6p-1,    0x1.96dc7520c6ad3p-1,   0x1.1e49dap-3, INEXACT)
T(RN,    0x1.73dbe2f5e07dcp-1,    0x1.7ecb5f7b93c84p-1,   0x1.0efe8ap-3, INEXACT)
T(RN,    0x1.b6bbbdfa47694p-1,    0x1.4f3fb10e3d09fp-1,   0x1.0646b4p-5, INEXACT)
T(RN,    0x1.edf9d79b3e524p-1,    0x1.23a0813cdbb83p-1,  -0x1.35ed9cp-2, INEXACT)
T(RN,    0x1.5b20e2fe0ad8bp-1,    0x1.8ec3da1559f84p-1,  -0x1.6b344ep-2, INEXACT)
T(RN,    0x1.d285197f9d6a7p+0,   -0x1.fdc0b00338cf8p-3,  -0x1.e38006p-2, INEXACT)
T(RN,    0x1.7e9e255b5a616p+0,    0x1.37cbb4bb935f7p-4,   0x1.402422p-6, INEXACT)
T(RN,    0x1.2d53a785bac51p+0,    0x1.88d9dff24a288p-2,   0x1.f82baep-4, INEXACT)
T(RN,    0x1.51a472e355048p+0,    0x1.fe6a1ddea19b4p-3,  -0x1.05ee7ap-2, INEXACT)
T(RN,    0x1.ee8d94d004162p+0,   -0x1.69bc821851a49p-2,  -0x1.f6e652p-2, INEXACT)
T(RN,    0x1.403669638f08fp+0,    0x1.42154b24bee62p-2,   0x1.76269ep-2, INEXACT)
T(RN,    0x1.6d2e141661d4ep+0,    0x1.2686b0ff838dep-3,  -0x1.2dc3b8p-3, INEXACT)
T(RN,    0x1.269cc8b802c6bp+0,    0x1.a183ef855a418p-2,  -0x1.3e7fc4p-2, INEXACT)
T(RN,    0x1.6e6eecdf04675p+0,    0x1.1c99b4725ea4bp-3,  -0x1.1b54bap-2, INEXACT)
T(RN,    0x1.728de9fca7863p+0,    0x1.f7d5364690fe9p-4,  -0x1.e68bd6p-2, INEXACT)
T(RN,     0x1.0cec9707e706p+1,   -0x1.02e8ec4ca95f7p-1,  -0x1.c5f564p-2, INEXACT)
T(RN,    0x1.a5e1a3a716034p+1,   -0x1.f9e9a7d5ed20cp-1,   0x1.a0386ap-2, INEXACT)
T(RN,    0x1.5e80617251755p+1,   -0x1.d6ec38f1efb5fp-1,   0x1.09e6fcp-5, INEXACT)
T(RN,    0x1.4ea8ee3a3fbd9p+1,   -0x1.ba840404ecfe3p-1,   0x1.b8c446p-2, INEXACT)
T(RN,    0x1.173d7954ac9b8p+1,   -0x1.25a148fee6614p-1,   0x1.c29356p-3, INEXACT)
T(RN,    0x1.07d7f3ef1780ap+1,   -0x1.e25b1daffef42p-2,  -0x1.e26e58p-7, INEXACT)
T(RN,    0x1.0966b85a9e3fbp+1,   -0x1.ed4ff185a8bf9p-2,  -0x1.ef3ea4p-3, INEXACT)
T(RN,    0x1.51e180cba4b8dp+1,    -0x1.c0db00f6d2c1p-1,  -0x1.de3536p-6, INEXACT)
T(RN,    0x1.979d4d2dbebf2p+1,   -0x1.ff876e8864551p-1,  -0x1.3f0b3ap-4, INEXACT)
T(RN,    0x1.8cddadfea5af5p+1,   -0x1.ff916eb91d571p-1,   0x1.b5c0b6p-2, INEXACT)
T(RN,    0x1.c37a461b73a2fp+2,    0x1.6f28bf91f00c6p-1,  -0x1.164d0cp-3, INEXACT)
T(RN,    0x1.c38ba8ba33a1cp+2,    0x1.6ec7c2b6650efp-1,   0x1.a98948p-2, INEXACT)
T(RN,    0x1.39257207b058cp+2,    0x1.6fb40bf8c8cffp-3,  -0x1.e9c604p-7, INEXACT)
T(RN,    0x1.6df42dbd8f294p+2,    0x1.b062e8fc2e3ccp-1,   0x1.96a2fcp-2, INEXACT)
T(RN,    0x1.f68c693a7d4c6p+2,   0x1.b395a040c0ac8p-10,  -0x1.fed786p-2, INEXACT)
T(RN,    0x1.4269300723238p+2,    0x1.473eb9bbd71a9p-2,   0x1.0ba0cep-4, INEXACT)
T(RN,    0x1.c70e27a3612fcp+2,    0x1.5aa5e8f200c69p-1,  -0x1.f1122ap-5, INEXACT)
T(RN,    0x1.af961672c0ee7p+2,    0x1.cab30042aa7f3p-1,  -0x1.34f9c2p-2, INEXACT)
T(RN,     0x1.a04dca2ef8c3p+2,     0x1.f37bfa596545p-1,  -0x1.c7d89ap-2, INEXACT)
T(RN,    0x1.20c83d7a77646p+2,   -0x1.9735e7bee0b76p-3,   0x1.ca3b1cp-2, INEXACT)
T(RN,    0x1.98a0cbf768262p+3,    0x1.f575c4f6b327ap-1,  -0x1.093cfcp-6, INEXACT)
T(RN,    0x1.1c46edaf1304ep+3,   -0x1.b6da10fee43d6p-1,   0x1.fc272ep-3, INEXACT)
T(RN,     0x1.c6075888ef0bp+3,   -0x1.a37d9f290c39cp-5,  -0x1.75ad1ep-6, INEXACT)
T(RN,    0x1.469eef17303d8p+3,   -0x1.6b38efb57d59fp-1,   0x1.1d0718p-2, INEXACT)
T(RN,    0x1.37c7465262826p+3,   -0x1.e6483283a3d56p-1,  -0x1.7feb3cp-2, INEXACT)
T(RN,    0x1.9c7a07ce72aeep+3,    0x1.e5700b6cf5988p-1,  -0x1.20e3fcp-2, INEXACT)
T(RN,    0x1.d23c3f8dcb21ap+3,   -0x1.ad602e5d835ddp-2,   0x1.0d2604p-3, INEXACT)
T(RN,    0x1.ceec38d5cd8a4p+3,   -0x1.4b03c1fedb59ap-2,    0x1.254fdp-2, INEXACT)
T(RN,    0x1.4a7e7377a9a04p+3,   -0x1.3cff058007f22p-1,  -0x1.fc9e24p-2, INEXACT)
T(RN,    0x1.8a57443062049p+3,    0x1.f0ee4ac3df0d4p-1,   -0x1.09162p-2, INEXACT)
T(RN,    0x1.f5a5e1f581b9ep+4,    0x1.fefc9199d9d74p-1,  -0x1.5fde14p-2, INEXACT)
T(RN,    0x1.2117ecd18a92ap+4,    0x1.6b8cce6bcec02p-1,   0x1.557098p-5, INEXACT)
T(RN,    0x1.090d18372f2d5p+4,   -0x1.4eed2f3fc76a7p-1,   0x1.fe00f6p-2, INEXACT)
T(RN,    0x1.54bec6b467418p+4,   -0x1.896238736166fp-1,  -0x1.0b2dcep-3, INEXACT)
T(RN,    0x1.acf509ffa00fcp+4,   -0x1.b287af26180ffp-4,    0x1.48fb6p-3, INEXACT)
T(RN,    0x1.fd7ed6215b7abp+4,    0x1.d1ea0bb2eb9c6p-1,  -0x1.47ec86p-3, INEXACT)
T(RN,    0x1.6c353a212e6bep+4,   -0x1.6ee95cb65fab8p-1,   0x1.aab47ap-4, INEXACT)
T(RN,    0x1.5220b161f8c71p+4,   -0x1.4ec23975e04adp-1,  -0x1.e10edap-3, INEXACT)
T(RN,    0x1.ccdfd42b27f2ep+4,   -0x1.b9ad2e750eacbp-1,  -0x1.7464f4p-3, INEXACT)
T(RN,     0x1.c8ed8d415edep+4,   -0x1.eb89f6288df57p-1,  -0x1.72853ap-8, INEXACT)
T(RN,    0x1.a683a5959cc36p+5,   -0x1.a8a4da0df68eep-1,   0x1.1c3c1ep-6, INEXACT)
T(RN,    0x1.ec7996d0b61b5p+5,    0x1.2cf63d63c4183p-2,  -0x1.64e302p-2, INEXACT)
T(RN,    0x1.cbab88ff89f14p+5,     0x1.3a339b72ee3ap-1,   0x1.a4534ap-2, INEXACT)
T(RN,    0x1.b5435b5f6248cp+5,   -0x1.421955f099111p-2,   0x1.fedf7cp-2, INEXACT)
T(RN,    0x1.633236e4c4ca5p+5,    0x1.d4146ccfb03e5p-1,  -0x1.7f3e2cp-3, INEXACT)
T(RN,    0x1.935fbb9f8b3b6p+5,    0x1.f9c301587aa73p-1,    0x1.de99fp-2, INEXACT)
T(RN,    0x1.1a8cfcaa6dbe3p+5,   -0x1.72a63d120ea3bp-1,   0x1.5da9f8p-2, INEXACT)
T(RN,    0x1.6a9412de2540fp+5,    0x1.d47a131ec9576p-3,  -0x1.71fac2p-2, INEXACT)
T(RN,    0x1.5256913eeb2ecp+5,   -0x1.e7376172b96aap-4,  -0x1.5a3fd4p-2, INEXACT)
T(RN,    0x1.9e792b3bf50bcp+5,    0x1.bc2fa44bdad06p-6,  -0x1.561748p-2, INEXACT)
T(RN,    0x1.ed6a268b03d95p+6,   -0x1.58f35ef8f0e89p-1,   0x1.b4be76p-2, INEXACT)
T(RN,     0x1.7fcfca66b848p+6,   -0x1.124f944a8088fp-3,  -0x1.4662acp-3, INEXACT)
T(RN,    0x1.930a0f7db6866p+6,    0x1.f2a663b63ac71p-1,   0x1.eee01cp-3, INEXACT)
T(RN,    0x1.20fe1269e4867p+6,   -0x1.fffb3fe1a8c28p-1,    0x1.f6195p-3, INEXACT)
T(RN,    0x1.676cb33f97a81p+6,   -0x1.42db4d1c9a6fap-2,   0x1.a418b6p-2, INEXACT)
T(RN,    0x1.3b4b8ce59297fp+6,   -0x1.eb7ee86c7a1f7p-1,   0x1.591c22p-2, INEXACT)
T(RN,    0x1.87d1515ee6071p+6,   -0x1.b06b2166b4345p-1,   0x1.761cd4p-2, INEXACT)
T(RN,     0x1.466086021b96p+6,    0x1.fe0e961110d5bp-1,   0x1.332554p-3, INEXACT)
T(RN,    0x1.35aeb5be6f14ep+6,   -0x1.bedffdfdcb721p-2,   0x1.5fccccp-2, INEXACT)
T(RN,    0x1.fbb08fd7118cbp+6,    0x1.3a68141164215p-2,  -0x1.fc1c44p-2, INEXACT)
T(RN,    0x1.d99445a1a193cp+7,   -0x1.8f60fd5a78832p-2,  -0x1.3a90c4p-2, INEXACT)
T(RN,    0x1.0812c87a619c3p+7,    0x1.fdefefd39c5adp-1,   0x1.f68a76p-3, INEXACT)
T(RN,     0x1.20672c049e9ap+7,    0x1.e751ed1ad641bp-1,   0x1.7a3c68p-6, INEXACT)
T(RN,    0x1.b2c6c312d9efcp+7,   -0x1.a134ee51c5912p-1,   0x1.90f2cap-2, INEXACT)
T(RN,    0x1.1a191ebbb4d7fp+7,   -0x1.e59647f1fe9c7p-1,   0x1.40166ep-2, INEXACT)
T(RN,    0x1.b253d139c59ebp+7,   -0x1.d8ced01775fa5p-1,   0x1.6d2e3cp-7, INEXACT)
T(RN,    0x1.9e645dff93ae6p+7,    0x1.fa520fadfea71p-1,   0x1.cada04p-2, INEXACT)
T(RN,    0x1.9783ca704027ap+7,   -0x1.cde3cc15162e4p-1,   -0x1.0ee21p-2, INEXACT)
T(RN,    0x1.01c3e7a4bfb94p+7,   -0x1.fe7850ed76ac7p-1,  -0x1.89cb38p-5, INEXACT)
T(RN,     0x1.e9a84405bf43p+7,    0x1.f425ecca73358p-1,   0x1.011b94p-2, INEXACT)
T(RN,    0x1.c6fba52142678p+8,   -0x1.b50a8dda3d9d3p-1,   0x1.ac8ddcp-3, INEXACT)
T(RN,    0x1.f027c4c149598p+8,    0x1.f411fa58d5f4bp-1,   0x1.184c48p-2, INEXACT)
T(RN,    0x1.7692fb3f68937p+8,   -0x1.7f5c4c6140b5fp-1,   0x1.0c9ceep-7, INEXACT)
T(RN,    0x1.01313ab20848cp+8,    0x1.d3db4e757b079p-1,   -0x1.60b81p-2, INEXACT)
T(RN,    0x1.4a7058f40e926p+8,   -0x1.ae9a4cbd117d6p-1,   0x1.816e86p-3, INEXACT)
T(RN,    0x1.ec3ba39276065p+8,   -0x1.15e40b058b93dp-1,   0x1.4ebc3ep-3, INEXACT)
T(RN,    0x1.e7cb6389743d6p+8,   -0x1.52d2d055d1054p-1,  -0x1.480dd2p-5, INEXACT)
T(RN,    0x1.758bb7f00f868p+8,   -0x1.e88fb74bacc83p-1,  -0x1.84a35ap-3, INEXACT)
T(RN,    0x1.7a619b999432dp+8,    0x1.6fee30d7a6685p-3,    -0x1.bec4p-3, INEXACT)
T(RN,    0x1.fe9eb9b6228c6p+8,   -0x1.c699269bc50f8p-4,   0x1.eff728p-3, INEXACT)
T(RN,    0x1.440a670b7b5d3p+9,    0x1.38f316d02724fp-1,  -0x1.159e7cp-2, INEXACT)
T(RN,    0x1.cae2a3f3bf0bcp+9,    0x1.d254a6aef7e2ep-1,  -0x1.9088f2p-2, INEXACT)
T(RN,    0x1.2dd1459ef1bd4p+9,    0x1.cd37f3d85aba1p-1,   0x1.777f64p-2, INEXACT)
T(RN,    0x1.8a224f751ee5ep+9,   -0x1.ed378b690e966p-1,    0x1.a2dd9p-3, INEXACT)
T(RN,    0x1.6064b5f8e7abcp+9,    0x1.eb9a6e017c6a1p-2,   0x1.3dcc98p-3, INEXACT)
T(RN,    0x1.8982a06c7ef82p+9,   -0x1.a6336515f0cc1p-5,  -0x1.9584dap-4, INEXACT)
T(RN,    0x1.6afbf42f7d236p+9,   -0x1.eeba429413cd7p-1,  -0x1.b03844p-2, INEXACT)
T(RN,    0x1.f7742831cc452p+9,   -0x1.bad31cd0fa05ap-6,   -0x1.36f2fp-6, INEXACT)
T(RN,    0x1.b3aa0fbe18e3ep+9,   -0x1.c9adf8504d0b8p-2,   0x1.e33096p-2, INEXACT)
T(RN,    0x1.6762e429c1247p+9,   -0x1.96ef20429b043p-1,  -0x1.1179f4p-2, INEXACT)
T(RN,   0x1.b72f3a6347906p+10,   -0x1.aa1c76a133c1ep-1,   0x1.059f7ep-2, INEXACT)
T(RN,   0x1.8d37871b94e2ep+10,    0x1.6c9cfbc1cd155p-1,   0x1.b6a70ap-2, INEXACT)
T(RN,   0x1.cf39847db66bep+10,    0x1.9a6192700108ep-1,  -0x1.b43024p-2, INEXACT)
T(RN,   0x1.1e01041c142d6p+10,    0x1.c70c5defdeb1ep-1,  -0x1.bb13ccp-2, INEXACT)
T(RN,   0x1.2b1dbf35521d9p+10,   -0x1.c5aa92e372f09p-1,   0x1.2d6628p-5, INEXACT)
T(RN,   0x1.2a214b069405fp+10,    0x1.20af0044b6e33p-2,   0x1.46edeep-2, INEXACT)
T(RN,   0x1.6917c1576ca72p+10,    0x1.729b1f94786cfp-1,   0x1.c76cbep-4, INEXACT)
T(RN,   0x1.c53dbecd1169fp+10,   -0x1.ee04c675fadf2p-1,   0x1.71dcbcp-6, INEXACT)
T(RN,   0x1.90cb0b1f9cafcp+10,    0x1.258421f4d59bcp-1,   0x1.7c8d72p-2, INEXACT)
T(RN,   0x1.a34873d5a9b02p+10,    0x1.c68477a867053p-1,   0x1.d845c4p-2, INEXACT)
T(RN,   0x1.bfeddeeb8a7b8p+11,   -0x1.baac86fc200c6p-2,   0x1.7044b8p-3, INEXACT)
T(RN,   0x1.c288d8bcdf1b6p+11,   -0x1.4a4666871b7a5p-1,  -0x1.6f879ep-9, INEXACT)
T(RN,    0x1.d6901b2faaddp+11,    0x1.4810948cb7215p-1,  -0x1.e27e12p-6, INEXACT)
T(RN,   0x1.f8d99b515a796p+11,    0x1.1dcb936660a6ep-2,   0x1.df0afcp-2, INEXACT)
T(RN,     0x1.631c3b87a49p+11,    0x1.453b0cdc3244ep-1,  -0x1.9134c6p-3, INEXACT)
T(RN,    0x1.eff2bd18dacap+11,   -0x1.f097f38be44c4p-1,   0x1.c91a36p-3, INEXACT)
T(RN,   0x1.dc6c03ea7eb3ap+11,   -0x1.9fa2a5003838ep-1,  -0x1.c5e892p-3, INEXACT)
T(RN,   0x1.b248fd8b5dce4p+11,    0x1.e5ec896c1da48p-1,   0x1.577f48p-2, INEXACT)
T(RN,   0x1.d7734f12002bap+11,   -0x1.f01f0e35dacf3p-4,  -0x1.9e9082p-2, INEXACT)
T(RN,   0x1.3fd36cf5403bfp+11,    0x1.bf4402168c126p-3,   0x1.1ba4a2p-2, INEXACT)
T(RN,   0x1.096aad262fc0cp+12,    0x1.70feabedcacabp-1,  -0x1.30d05ap-3, INEXACT)
T(RN,   0x1.55a91c22a6391p+12,    0x1.f5fb322237de3p-1,   -0x1.04406p-2, INEXACT)
T(RN,   0x1.c8257ed629892p+12,   -0x1.d2b81e32b95c6p-1,   -0x1.25802p-5, INEXACT)
T(RN,   0x1.561c589074ef9p+12,    0x1.c0b326e87df14p-2,   0x1.3a40e4p-2, INEXACT)
T(RN,   0x1.56faa9eba6aa8p+12,   -0x1.88f4521251e13p-1,    0x1.cce22p-2, INEXACT)
T(RN,   0x1.5d29f02c383a8p+12,    0x1.4a6304045de08p-1,   0x1.3e1546p-5, INEXACT)
T(RN,   0x1.78a6186493d2dp+12,    0x1.6269b5c075805p-1,   0x1.869866p-5, INEXACT)
T(RN,   0x1.3c06cf5e7f68ep+12,    0x1.08281ace7ad81p-5,  -0x1.7140eep-4, INEXACT)
T(RN,   0x1.8ff55f2151215p+12,   -0x1.fdfeec0db0c66p-1,  -0x1.713b82p-3, INEXACT)
T(RN,    0x1.d4d018d32adep+12,    0x1.c0b8b4f3243a4p-2,  -0x1.dc8966p-6, INEXACT)
T(RN,   0x1.0efe7c34c1f13p+13,    0x1.0e2cb4eb6411ap-1,    0x1.63786p-2, INEXACT)
T(RN,   0x1.90b5a8f1c412ap+13,     0x1.2bc06f23d861p-2,  -0x1.ad85aep-2, INEXACT)
T(RN,   0x1.272f9eeeeac2ep+13,   -0x1.5e9a777d6832cp-1,    0x1.023b1p-4, INEXACT)
T(RN,   0x1.18474e592b141p+13,   -0x1.e3bea8a28e17bp-1,   0x1.249514p-2, INEXACT)
T(RN,   0x1.37539eb347a77p+13,   -0x1.ca47eb633d661p-1,  -0x1.cce90ep-2, INEXACT)
T(RN,   0x1.f2276b3b0bf0ep+13,    0x1.c4a898a007c74p-1,   0x1.d1748ep-3, INEXACT)
T(RN,   0x1.b35c7b895ecdcp+13,   -0x1.55d6aa0f46239p-3,   0x1.6822d6p-2, INEXACT)
T(RN,   0x1.81453e8a89ba9p+13,    0x1.008bdc3092cb5p-1,   0x1.f86cc4p-2, INEXACT)
T(RN,   0x1.5d5be48730d2dp+13,   -0x1.07b85f606e75dp-3,   0x1.d96c6ap-2, INEXACT)
T(RN,   0x1.48d992a475bb2p+13,    0x1.acbecb06c4c9dp-2,   -0x1.b4c33p-2, INEXACT)
T(RN,   0x1.95f6418ee1a5ap+14,    0x1.a8a62bc6def19p-1,  -0x1.2d5d2ep-2, INEXACT)
T(RN,   0x1.0a350a8b77f1cp+14,   -0x1.d6ea4bbfbc0b8p-1,  -0x1.93dfc8p-3, INEXACT)
T(RN,    0x1.3daaa7ad4e0bp+14,   -0x1.3858ceed691bcp-3,   0x1.45478ap-2, INEXACT)
T(RN,   0x1.408035aebf8bdp+14,   -0x1.a84d4a2956b1ep-1,  -0x1.9db87ap-4, INEXACT)
T(RN,    0x1.5b06c9d52596p+14,    0x1.a697f4acd54abp-3,   0x1.6f5866p-2, INEXACT)
T(RN,   0x1.20d7ee044278dp+14,    0x1.516cbbdb37adep-1,   0x1.2a5f4ep-3, INEXACT)
T(RN,   0x1.9edcdcd051673p+14,     0x1.73303c8b6221p-5,  -0x1.600b8cp-2, INEXACT)
T(RN,   0x1.7fad9d588b224p+14,    0x1.827286cc33ffbp-1,   0x1.52f8bcp-4, INEXACT)
T(RN,   0x1.cee90263e2406p+14,    0x1.0600289fe0e86p-1,   0x1.91bd7ap-2, INEXACT)
T(RN,   0x1.7787c7d01ebacp+14,    0x1.72a588e58f6bfp-1,  -0x1.e7f13ap-2, INEXACT)
T(RN,   0x1.cb8b9c7a11dbfp+15,    0x1.8dfa49cd91e88p-3,  -0x1.88045cp-3, INEXACT)
T(RN,   0x1.8508580629f62p+15,   -0x1.6665388aa8ad1p-2,  -0x1.00bd38p-2, INEXACT)
T(RN,   0x1.65ef71c765cf3p+15,    0x1.343e42e00cf0bp-2,  -0x1.ededeap-9, INEXACT)
T(RN,   0x1.70a9e4249da6ep+15,   -0x1.372218f5bdb97p-1,  -0x1.3c2984p-2, INEXACT)
T(RN,   0x1.e6354fbc069b6p+15,    0x1.e9ec04ae7b559p-1,   -0x1.0779ap-4, INEXACT)
T(RN,   0x1.4d0dd5cf2d5d8p+15,    0x1.c29d206676898p-1,  -0x1.e8aea2p-2, INEXACT)
T(RN,    0x1.a53718566edbp+15,    0x1.c9807d53b7bb1p-1,  -0x1.91dda6p-2, INEXACT)
T(RN,   0x1.9ff1f30a6999cp+15,   -0x1.d6c8c526a572ep-1,  -0x1.37a46ep-3, INEXACT)
T(RN,   0x1.92311de829c7cp+15,   -0x1.80c9e30d59c15p-1,   0x1.58cc0ap-3, INEXACT)
T(RN,   0x1.7bacaf954f134p+15,   -0x1.0073bd1f7d6f6p-1,   0x1.80d92ep-2, INEXACT)
T(RN,   0x1.ea66224760552p+16,   -0x1.29e0105cf8a31p-1,    0x1.66bedp-4, INEXACT)
T(RN,   0x1.7a6c832f1c7cep+16,   -0x1.6be878f4827ccp-1,    -0x1.a358p-2, INEXACT)
T(RN,    0x1.caaa73a8ca19p+16,   -0x1.26c3e99b0978fp-3,   -0x1.8cc28p-4, INEXACT)
T(RN,   0x1.c43e4d8be3b06p+16,    0x1.e44cb82df3e47p-1,   0x1.d68a06p-2, INEXACT)
T(RN,   0x1.0b8cbc118483ap+16,    0x1.edab75599c8f4p-1,   0x1.e5d864p-2, INEXACT)
T(RN,   0x1.65cea403cf616p+16,   -0x1.6d4fac4bf8e99p-1,  -0x1.a26facp-3, INEXACT)
T(RN,   0x1.06ab2b911ee29p+16,    0x1.bc0fefaaff491p-1,  -0x1.2f078ep-3, INEXACT)
T(RN,   0x1.e2e44c37202a5p+16,    0x1.920b358e0391ap-3,  -0x1.6a71dep-4, INEXACT)
T(RN,   0x1.87bfe50c92fccp+16,   -0x1.91d12dbaf8ca6p-2,   0x1.a6cacep-3, INEXACT)
T(RN,   0x1.ce49d039c7f12p+16,   -0x1.baefae6e32f3bp-2,  -0x1.6d6446p-4, INEXACT)
T(RN,   0x1.a224fb1d1ed3cp+17,    -0x1.fa0a165fed8dp-1,   0x1.555f46p-6, INEXACT)
T(RN,   0x1.fcd9185cc387ap+17,   -0x1.fab3bfc0c8d07p-2,   0x1.e9cad8p-3, INEXACT)
T(RN,    0x1.e904ac8d030cp+17,    0x1.0eb54d4df74bep-2,  -0x1.f17218p-5, INEXACT)
T(RN,   0x1.d0f6906d7c218p+17,   -0x1.93e69d29b8456p-1,   0x1.dedad4p-2, INEXACT)
T(RN,   0x1.455bc6fe7e94ap+17,   -0x1.a55bb83db313ep-1,  -0x1.847bb6p-2, INEXACT)
T(RN,   0x1.5425d965e51dcp+17,    -0x1.f46ead2869a6p-5,  -0x1.463c0cp-2, INEXACT)
T(RN,   0x1.733b5f6293932p+17,   -0x1.44c614c7d6898p-2,  -0x1.915564p-2, INEXACT)
T(RN,   0x1.8ad11fcdd2716p+17,   -0x1.c8aca9bd51909p-1,  -0x1.4ec22cp-2, INEXACT)
T(RN,   0x1.374e725f60e88p+17,   -0x1.f6c2ebf46f84ap-1,   0x1.9e8d3cp-2, INEXACT)
T(RN,   0x1.9e7af84fbac82p+17,    0x1.9980c3d6cf00dp-1,   0x1.e6776cp-2, INEXACT)
T(RN,   0x1.63b42e3f25069p+18,   -0x1.eae05af0629f8p-3,   0x1.415b98p-3, INEXACT)
T(RN,   0x1.e96897c6d7fd5p+18,    0x1.57f8b26803879p-2,  -0x1.25573ap-4, INEXACT)
T(RN,   0x1.7202a5caba09ep+18,   -0x1.7b2a3b5e4a917p-2,  -0x1.a36802p-3, INEXACT)
T(RN,   0x1.542e2f9a444d1p+18,    0x1.e2c76f92c42c2p-3,   0x1.14e724p-2, INEXACT)
T(RN,   0x1.96a55cea4ac36p+18,    0x1.fe04183570f01p-1,    0x1.cd8a1p-4, INEXACT)
T(RN,   0x1.f4502b37399c2p+18,   -0x1.5990afaa0d513p-1,   0x1.fbfc1ap-2, INEXACT)
T(RN,   0x1.7aeb41adac8acp+18,    0x1.7252d0225af41p-2,   0x1.caac78p-2, INEXACT)
T(RN,   0x1.4d29688f81f8ep+18,     0x1.c668d37d73b7p-1,   0x1.369814p-4, INEXACT)
T(RN,   0x1.b7c5437a42ed9p+18,   -0x1.ee9b27f137019p-1,  -0x1.286e76p-2, INEXACT)
T(RN,   0x1.091c384750d43p+18,   -0x1.119343b705db6p-8,   0x1.417548p-2, INEXACT)
T(RN,   0x1.35edb42af682cp+19,    0x1.ffba0c7e72da2p-1,  -0x1.617be8p-5, INEXACT)
T(RN,   0x1.2420fb3494fc4p+19,     0x1.57cc8875bcd6p-2,   0x1.6252a8p-2, INEXACT)
T(RN,   0x1.59572da478c98p+19,   -0x1.fd97d30d5455bp-1,   0x1.8eb9f6p-4, INEXACT)
T(RN,   0x1.6bc245ea34af9p+19,    0x1.f066b4e8b6b1ep-1,   0x1.807f96p-6, INEXACT)
T(RN,   0x1.d5d08e24efdb7p+19,    0x1.2d32d08817d92p-3,   -0x1.45b3cp-5, INEXACT)
T(RN,   0x1.d6eea87dc607ap+19,    0x1.e5e53ebe872f9p-1,   0x1.a45daep-2, INEXACT)
T(RN,   0x1.39815723a2a79p+19,    0x1.b14c72e247d27p-2,  -0x1.f2c672p-4, INEXACT)
T(RN,   0x1.002039de136ccp+19,    0x1.de0e71dbc3401p-1,  -0x1.dfab1cp-7, INEXACT)
T(RN,   0x1.4410f797c1794p+19,    0x1.9c3dea76c66ffp-2,  -0x1.12b2bep-2, INEXACT)
T(RN,   0x1.79f5027539243p+19,    0x1.2f2a6e578b767p-1,  -0x1.fef79ap-3, INEXACT)
T(RN,   0x1.23b569b4a903fp+20,   -0x1.f731870db0bdcp-1,  -0x1.cb9124p-2, INEXACT)
T(RN,   0x1.c1ff5f82cf0b1p+20,    0x1.1bca4798da464p-2,  -0x1.5e2d92p-3, INEXACT)
T(RN,    0x1.93914545323fp+20,    0x1.bb987107b5cedp-1,  -0x1.967732p-6, INEXACT)
T(RN,   0x1.cf57965201acap+20,    0x1.85687aad11bcap-1,   0x1.c8f462p-3, INEXACT)
T(RN,   0x1.d47426e5c8844p+20,   -0x1.2071a281c772ap-1,   0x1.31c1c8p-3, INEXACT)
T(RN,   0x1.7988e60165b8ap+20,   -0x1.9c36cfeaee78ep-1,  -0x1.408fd4p-4, INEXACT)
T(RN,   0x1.68bb08b2c20a7p+20,    0x1.04e073d2340f1p-2,  -0x1.6ddeaap-3, INEXACT)
T(RN,   0x1.fcd1fdb08cabdp+20,  -0x1.a38a0de2e4b8cp-10,   0x1.c8c482p-3, INEXACT)
T(RN,   0x1.169151ae1c4e9p+20,    0x1.6bd7736e8a23bp-1,   0x1.4b5014p-3, INEXACT)
T(RN,   0x1.df7f7eb07902dp+20,    0x1.803d7ccbfbad6p-1,  -0x1.e20768p-3, INEXACT)
T(RN,   0x1.af06963861ffap+21,    0x1.b47a6efaddb31p-2,   -0x1.25427p-6, INEXACT)
T(RN,   0x1.d182d9d7f3e5fp+21,    0x1.1239059f16462p-1,  -0x1.7c205ap-5, INEXACT)
T(RN,   0x1.4117f16aa9826p+21,    0x1.6392a6b5caf47p-1,   0x1.ea76c4p-6, INEXACT)
T(RN,   0x1.4662e52d78974p+21,   -0x1.b5583dc14f6d2p-1,   0x1.ea19a4p-3, INEXACT)
T(RN,   0x1.d164cda569652p+21,    0x1.61aac4837e04ep-1,  -0x1.5c8262p-2, INEXACT)
T(RN,   0x1.8c0b527d20f0ap+21,   -0x1.8e79005921d69p-1,  -0x1.b445d6p-2, INEXACT)
T(RN,   0x1.cea65592b2a5dp+21,   -0x1.fd28166c72ef1p-1,   0x1.edb702p-2, INEXACT)
T(RN,   0x1.5d690a158af39p+21,    0x1.a88de443f9aafp-3,   0x1.8f1af6p-7, INEXACT)
T(RN,   0x1.a817e72f7e354p+21,    0x1.fc1b0b0d4c772p-3,   0x1.ab043ep-2, INEXACT)
T(RN,   0x1.9d6842b8ef18cp+21,   -0x1.5ec30372efd68p-3,   0x1.b93e1cp-4, INEXACT)
T(RN,   0x1.ed472ea3bcd8bp+22,    0x1.87f0fe93dd7e1p-2,   0x1.bcd4e2p-2, INEXACT)
T(RN,   0x1.87a94a1c72e7bp+22,     0x1.332fb358f5a7p-1,     0x1.daf6p-2, INEXACT)
T(RN,   0x1.01fba070f2b27p+22,    0x1.40d1337e6f0f2p-1,  -0x1.f3c188p-2, INEXACT)
T(RN,   0x1.34961927ed1dbp+22,    0x1.fb64e9f24f293p-1,   0x1.0173c6p-2, INEXACT)
T(RN,   0x1.01c2f22384f01p+22,   -0x1.febc692445e1cp-1,  -0x1.7a7c92p-2, INEXACT)
T(RN,   0x1.aab24ccb53565p+22,   -0x1.df7e6d5855ebbp-1,  -0x1.f15baep-2, INEXACT)
T(RN,   0x1.8b6d40e65db28p+22,   -0x1.032b805b5871dp-2,  -0x1.9eb9f2p-2, INEXACT)
T(RN,   0x1.43506cb22975dp+22,    0x1.b685d949a27ap-14,  -0x1.43c4acp-4, INEXACT)
T(RN,   0x1.16efe3be020c6p+22,    0x1.04868bdbef36ep-2,   -0x1.0df58p-3, INEXACT)
T(RN,   0x1.215f895d497f6p+22,    0x1.f28b5ac67e407p-1,   0x1.f0d4a8p-2, INEXACT)
T(RN,   0x1.674dd1a269fdcp+23,    0x1.244e1f1d86cc5p-3,   0x1.837026p-2, INEXACT)
T(RN,   0x1.4f83a1fa0cc61p+23,    0x1.f8e9fa36fcc8fp-1,  -0x1.d2f8f6p-3, INEXACT)
T(RN,   0x1.3001400bf17cbp+23,    0x1.fb0418554a8cbp-1,   0x1.223f74p-4, INEXACT)
T(RN,   0x1.2c554fbc33f13p+23,   -0x1.27196e147a5bbp-2,  -0x1.7c41f4p-3, INEXACT)
T(RN,   0x1.149522436f56ap+23,   -0x1.17d9a191eef72p-1,   0x1.dc3b0cp-2, INEXACT)
T(RN,   0x1.863eb854646f8p+23,   -0x1.ffff74f2e05bcp-1,   -0x1.18928p-2, INEXACT)
T(RN,   0x1.025e719127d92p+23,    0x1.292b9bdaedf69p-2,   0x1.5f926ap-2, INEXACT)
T(RN,   0x1.8d3e6ba22bdbbp+23,   -0x1.6e15454cedfd8p-3,   0x1.930d7cp-2, INEXACT)
T(RN,   0x1.93d539d201261p+23,    0x1.f08f9a2f02ae7p-1,   -0x1.6a109p-2, INEXACT)
T(RN,   0x1.3d8dfd7d3bbaep+23,   -0x1.d0a4bcb9c1e7cp-1,  -0x1.663222p-4, INEXACT)
T(RN,   0x1.e63d26e1f8bc4p+24,   -0x1.cfac6d18030b8p-1,     0x1.3d33p-3, INEXACT)
T(RN,   0x1.4fe2473d1ae2cp+24,    0x1.2302d04744c7ep-1,    0x1.27f46p-4, INEXACT)
T(RN,   0x1.76c293bedef88p+24,   -0x1.ebfb0863507ccp-3,  -0x1.0503aep-4, INEXACT)
T(RN,   0x1.367cd217a5783p+24,    0x1.dc840a4195f88p-1,  -0x1.f92d44p-2, INEXACT)
T(RN,   0x1.d9aad69631c5ep+24,   -0x1.f35dbfa7536dfp-1,   0x1.f397a4p-4, INEXACT)
T(RN,   0x1.d1d1959fb6732p+24,    0x1.df980eaddb1d6p-2,   0x1.6ef082p-2, INEXACT)
T(RN,   0x1.7302bd1a9ece5p+24,    0x1.e91244f8f6191p-1,   0x1.cf82eep-2, INEXACT)
T(RN,   0x1.040dc954d51f7p+24,    0x1.be13bc2f14d8ep-1,   0x1.3517eep-3, INEXACT)
T(RN,   0x1.30c7c3c077c44p+24,    0x1.0a99a5beabf2ep-1,   0x1.812544p-2, INEXACT)
T(RN,   0x1.1782bd22c6545p+24,   -0x1.0d6981963f0efp-1,  -0x1.a9434ap-3, INEXACT)
T(RN,   0x1.cbfd68180e9f4p+25,    0x1.d7841f92e2b11p-6,  -0x1.017872p-3, INEXACT)
T(RN,   0x1.b53ceca1a07f8p+25,    0x1.f4e223b620cdbp-5,  -0x1.d04cf2p-3, INEXACT)
T(RN,   0x1.bccb55b4a89ccp+25,    0x1.9a7dc5ea8c812p-2,   0x1.8fb788p-2, INEXACT)
T(RN,   0x1.e9213f381d806p+25,    0x1.cee638055f121p-4,   0x1.37f39cp-2, INEXACT)
T(RN,   0x1.2531848dc7b1fp+25,     0x1.c8927d5a553dp-3,  -0x1.b2148ap-2, INEXACT)
T(RN,   0x1.411272a060e1ep+25,    0x1.13292e8951e95p-1,  -0x1.0cdb3ap-3, INEXACT)
T(RN,   0x1.dd855d94b52eap+25,   -0x1.e7d9f25c8c0f6p-1,    0x1.90de1p-2, INEXACT)
T(RN,   0x1.dcbf2e8878222p+25,    0x1.bde0a2c946fa3p-1,  -0x1.481d84p-4, INEXACT)
T(RN,   0x1.0752f01af4a12p+25,   -0x1.a0c97c795cb75p-1,  -0x1.3dd3b8p-4, INEXACT)
T(RN,   0x1.eb1f592745918p+25,    0x1.f945b9c25de68p-1,  -0x1.0bf53ep-2, INEXACT)
T(RN,   0x1.fc3dea978b895p+26,   -0x1.8dbe83a9fd979p-1,   0x1.7e3856p-2, INEXACT)
T(RN,   0x1.1b74d052d4546p+26,    0x1.fa5fd928a46fdp-1,  -0x1.7659d8p-4, INEXACT)
T(RN,   0x1.e123691a7c4bep+26,    0x1.f72c8e16dbc79p-1,    0x1.36541p-2, INEXACT)
T(RN,   0x1.643624e38d3e7p+26,    0x1.844278c15fd22p-1,   0x1.767d0ap-2, INEXACT)
T(RN,   0x1.3f4e03d98ecf9p+26,   0x1.f44e40011b1d8p-10,  -0x1.d61284p-4, INEXACT)
T(RN,   0x1.d12a1113120ecp+26,   -0x1.f1c1c7eed4d45p-1,  -0x1.a9fb44p-2, INEXACT)
T(RN,   0x1.7b30b7dd906f2p+26,   -0x1.b97b9f59dd5bdp-1,    0x1.f77fcp-3, INEXACT)
T(RN,   0x1.1e45c971ba438p+26,   -0x1.e1f007aa25df3p-2,   0x1.929184p-2, INEXACT)
T(RN,   0x1.ced41d6e8b4f4p+26,   -0x1.dfb49a6a8cd84p-1,   0x1.c59c24p-2, INEXACT)
T(RN,   0x1.1b8bfbb29e475p+26,    0x1.ff93f5813ba62p-1,  -0x1.19ab32p-3, INEXACT)
T(RN,   0x1.d2876675c6e8ap+27,    0x1.93b6b7cde209ap-1,  -0x1.3bf318p-2, INEXACT)
T(RN,   0x1.15b41512c675dp+27,    0x1.54569ce95106dp-1,   0x1.8f6808p-6, INEXACT)
T(RN,   0x1.2054b30614f84p+27,   -0x1.a36997dd5e167p-1,  -0x1.893666p-2, INEXACT)
T(RN,   0x1.f5c90f1672f78p+27,   -0x1.e9c908028cdc2p-1,   0x1.db3faep-4, INEXACT)
T(RN,   0x1.26e4c9f356eb2p+27,   -0x1.edd4bb99612a8p-1,  -0x1.6a9d26p-2, INEXACT)
T(RN,   0x1.e681e9b7bae4ep+27,    0x1.d204c51d8a81ep-1,    0x1.2e244p-2, INEXACT)
T(RN,   0x1.f2f48b29552e2p+27,    0x1.f2937a0565045p-2,  -0x1.2f59f6p-2, INEXACT)
T(RN,   0x1.509af25122255p+27,   -0x1.08b7ef325b2d4p-3,   0x1.a84fa6p-5, INEXACT)
T(RN,   0x1.d4ba05cd145c2p+27,   -0x1.ffcb89f935c26p-1,  -0x1.7995aap-2, INEXACT)
T(RN,   0x1.658027ed4183cp+27,    0x1.bea46b972c388p-1,   -0x1.d5a66p-3, INEXACT)
T(RN,   0x1.e50ab041cc996p+28,    0x1.b98ed3b5be60cp-2,   0x1.2b7884p-2, INEXACT)
T(RN,   0x1.b461243bf670fp+28,    0x1.80f3f180c84e9p-2,   0x1.61f89ap-5, INEXACT)
T(RN,   0x1.5d14f9aba6516p+28,   -0x1.f1fec666eace8p-1,  -0x1.d0c528p-2, INEXACT)
T(RN,   0x1.182a807aa97eep+28,    0x1.c4da9d0ba9d8ap-1,  -0x1.ef6878p-4, INEXACT)
T(RN,   0x1.d3e9fedb63c04p+28,   -0x1.abd4aa62f99acp-1,  -0x1.9c046ap-4, INEXACT)
T(RN,   0x1.09b520ae0a0f6p+28,    0x1.c14336e0fc4c6p-1,  -0x1.56498ap-2, INEXACT)
T(RN,   0x1.6e655190e85b5p+28,    0x1.b06e5b4d47c8ap-1,   0x1.a89af4p-6, INEXACT)
T(RN,   0x1.fbb9151d60199p+28,    0x1.4efecce288df3p-2,   0x1.4f8a48p-2, INEXACT)
T(RN,   0x1.091bc03c94fecp+28,    0x1.ffd7f9c6c1528p-1,  -0x1.1e3d1ap-3, INEXACT)
T(RN,   0x1.1724ab793e8e2p+28,    0x1.f1496d9a07eeep-1,   -0x1.4a041p-3, INEXACT)
T(RN,   0x1.ab1658a7b9c34p+29,     0x1.0e00eaa629f9p-1,  -0x1.d8e14ep-2, INEXACT)
T(RN,   0x1.34d7e740e209ep+29,    0x1.20767263beb2dp-2,  -0x1.32abc8p-3, INEXACT)
T(RN,   0x1.e2b864303a9c4p+29,    -0x1.528b7e23c879p-1,   0x1.a1868cp-3, INEXACT)
T(RN,   0x1.44b643ad562e5p+29,   -0x1.fb378542e5b3fp-1,   0x1.ee58dcp-4, INEXACT)
T(RN,   0x1.dff2bc7238cf8p+29,    0x1.e750661fc7a83p-1,   0x1.aa5bb6p-2, INEXACT)
T(RN,   0x1.3e32ef46c68b7p+29,   -0x1.ba23563a0d85bp-1,  -0x1.8fccfap-4, INEXACT)
T(RN,   0x1.351de55acf818p+29,   -0x1.1fd308283952bp-1,   0x1.62d34cp-3, INEXACT)
T(RN,   0x1.d6afdb2d1711ep+29,    0x1.dfe240a957ff2p-2,  -0x1.0b8f6ep-4, INEXACT)
T(RN,   0x1.1db441802826ap+29,   -0x1.0f7753c6f115fp-1,   0x1.5fad52p-6, INEXACT)
T(RN,   0x1.7ac0a0966f3bep+29,   -0x1.f9155a455a524p-1,  -0x1.24d358p-2, INEXACT)
T(RN,   0x1.5df7e73f113e2p+30,    0x1.1efde94757bc5p-1,   0x1.55265cp-3, INEXACT)
T(RN,   0x1.4d11308781418p+30,    0x1.e65d888fb61dfp-2,    0x1.21b24p-2, INEXACT)
T(RN,   0x1.817b4e7b602eep+30,    0x1.9da1e7f007e3ap-1,    0x1.6f118p-3, INEXACT)
T(RN,   0x1.3b49a578f4c19p+30,   -0x1.db2cbc4545e7bp-1,  -0x1.b81e66p-4, INEXACT)
T(RN,      0x1.0ad0c5707fp+30,    0x1.9225c4c98ebefp-2,  -0x1.0ca294p-3, INEXACT)
T(RN,   0x1.2f76e1d3ed2f9p+30,   -0x1.98b92211e160bp-1,   -0x1.df689p-3, INEXACT)
T(RN,   0x1.ae91628aa72e2p+30,    0x1.1b05a921672a8p-1,  -0x1.6334f2p-6, INEXACT)
T(RN,   0x1.c19e291c951b6p+30,    0x1.fd58f9871733bp-1,  -0x1.025298p-2, INEXACT)
T(RN,   0x1.a43e1ae6c9e51p+30,    0x1.de05bd82902eap-1,  -0x1.6dbcaap-2, INEXACT)
T(RN,   0x1.c25c9fff84052p+30,    0x1.c52cc70fbc45fp-1,  -0x1.fcba6ep-2, INEXACT)
T(RN,   0x1.7ed37ef230c9bp+31,    0x1.512ccb8a5c50bp-1,   0x1.449d9cp-2, INEXACT)
T(RN,   0x1.dc725f251ba04p+31,    0x1.fc29adf5e75e8p-1,   0x1.76e174p-3, INEXACT)
T(RN,   0x1.53aed7d26dc5fp+31,    0x1.fee485619602fp-1,   0x1.2c039ap-4, INEXACT)
T(RN,   0x1.ecd6ce51cff7cp+31,   -0x1.af1ab88ec5934p-1,  -0x1.9b30bep-3, INEXACT)
T(RN,   0x1.b4a00427d4704p+31,    0x1.acc8105c8fe32p-1,  -0x1.7ae47cp-2, INEXACT)
T(RN,   0x1.7da7997c43d4ap+31,    0x1.b759cbef3927ep-4,  -0x1.ea5802p-3, INEXACT)
T(RN,   0x1.f02c1df07367cp+31,    0x1.ec8d8dc8bfc2fp-1,  -0x1.615e18p-2, INEXACT)
T(RN,   0x1.94195d4ac1158p+31,   -0x1.fcb0e2b5b4aeap-1,  -0x1.7b6f8ap-3, INEXACT)
T(RN,   0x1.b7c1ae2c80fa9p+31,    0x1.fb9cd4ab9af54p-1,  -0x1.206994p-2, INEXACT)
T(RN,   0x1.1dd1d9b5c94a7p+31,    0x1.bb439994bb01bp-1,  -0x1.793f56p-2, INEXACT)
T(RN,   0x1.120e5e4720769p+32,   -0x1.f232677cc680ep-1,  -0x1.e3547ep-3, INEXACT)
T(RN,   0x1.a149cf4c96394p+32,   -0x1.bbcfda1f5698fp-1,   0x1.2e7e6cp-2, INEXACT)
T(RN,   0x1.c54abf1b0de7bp+32,    0x1.8cfd1642fec19p-1,  -0x1.fff822p-2, INEXACT)
T(RN,   0x1.e67bbae72b298p+32,   -0x1.ffee070153107p-1,  -0x1.2026c6p-5, INEXACT)
T(RN,   0x1.5cfdd203b29c8p+32,    0x1.f57222b23f963p-1,  -0x1.1983ccp-3, INEXACT)
T(RN,   0x1.27ba9d71e6d8bp+32,   -0x1.b4e2efbbe1062p-3,   0x1.c857cap-2, INEXACT)
T(RN,   0x1.bf1b9ac2ff86ap+32,    0x1.cbc242585c01bp-2,    0x1.ddb52p-3, INEXACT)
T(RN,   0x1.d3b1baab4e3d8p+32,    0x1.8bc3328f67a72p-1,   0x1.7b5848p-2, INEXACT)
T(RN,   0x1.9b0800de25916p+32,    0x1.a8a5efae1e526p-1,   0x1.bbb528p-3, INEXACT)
T(RN,   0x1.e8ebf6528b9ffp+32,   -0x1.dd0ecebd13ac3p-1,   0x1.ed4232p-2, INEXACT)
T(RN,    0x1.7a4f785f4757p+33,    0x1.fa408c167c475p-1,   0x1.76968ap-6, INEXACT)
T(RN,   0x1.57ab06c4f52c7p+33,   -0x1.afb18940cb63dp-1,   0x1.95ce64p-3, INEXACT)
T(RN,   0x1.99c2fbd06084cp+33,    0x1.d764cf248cf5fp-1,   0x1.f1317ap-3, INEXACT)
T(RN,   0x1.8af92b9a1298cp+33,   -0x1.3e5514bee7e5bp-2,  -0x1.e887cap-2, INEXACT)
T(RN,   0x1.7cdd4ae455664p+33,    0x1.171d2c504ac36p-1,  -0x1.54f9ccp-3, INEXACT)
T(RN,   0x1.0c0198bf106b7p+33,   -0x1.83c1ce10a0c1cp-1,  -0x1.9ba222p-2, INEXACT)
T(RN,   0x1.5f6387b73fabcp+33,     0x1.25ebaaf62588p-1,   0x1.3e5058p-2, INEXACT)
T(RN,   0x1.9219ac697357ep+33,    0x1.b31008fd4bbe9p-1,   0x1.131c68p-2, INEXACT)
T(RN,   0x1.784d1a020c219p+33,   -0x1.a92ea6e587708p-1,  -0x1.4470d8p-2, INEXACT)
T(RN,   0x1.685f94ddd7898p+33,    0x1.9821579a1edd7p-2,  -0x1.ee0c54p-2, INEXACT)
T(RN,   0x1.87be1a7ab1178p+34,     -0x1.f720a18337ap-1,  -0x1.db8e0ap-2, INEXACT)
T(RN,   0x1.58afa0b4329ccp+34,    -0x1.cf9ed0f58d99p-4,     0x1.2674p-2, INEXACT)
T(RN,   0x1.71c97b9abb9b6p+34,   -0x1.c2f1d9dc28857p-1,  -0x1.11073cp-2, INEXACT)
T(RN,    0x1.aa850bb5910fp+34,    0x1.317390a9ee032p-1,   0x1.390156p-3, INEXACT)
T(RN,   0x1.efda8630cd70bp+34,    0x1.78429b0d7be6dp-1,   0x1.489e82p-3, INEXACT)
T(RN,   0x1.a66be78e41dc8p+34,   -0x1.fa8b9488956fbp-1,   0x1.989c14p-3, INEXACT)
T(RN,   0x1.d5796257f00dep+34,   -0x1.1e4d06aba1c41p-2,  -0x1.ef143ep-3, INEXACT)
T(RN,   0x1.7afaffa2e0e8dp+34,   -0x1.eaf61ba0239c7p-1,   0x1.558642p-3, INEXACT)
T(RN,   0x1.56d68035ca1e8p+34,    0x1.040a4bac9bcfdp-3,   -0x1.a4ef5p-3, INEXACT)
T(RN,   0x1.16967e2601794p+34,    0x1.302c6152c004fp-2,   0x1.0ac866p-3, INEXACT)
T(RN,   0x1.334067496e425p+35,   -0x1.e4e5843d44a57p-1,   0x1.900e7ep-6, INEXACT)
T(RN,   0x1.5cd64715cb295p+35,     0x1.817ac32c61cfp-3,   0x1.34a1dep-2, INEXACT)
T(RN,   0x1.03384a7e8e6cdp+35,    0x1.b9f21cb094a38p-1,   0x1.3823d2p-2, INEXACT)
T(RN,   0x1.6de40714f2aacp+35,      0x1.f80c32a5914p-1,  -0x1.615488p-3, INEXACT)
T(RN,   0x1.d205771b0cd7bp+35,    0x1.664c65464d87ap-1,   0x1.c90788p-4, INEXACT)
T(RN,   0x1.c1ad1f488d3b2p+35,   -0x1.66bd5844d4c44p-1,  -0x1.341c96p-2, INEXACT)
T(RN,   0x1.7aaec5faf2ca7p+35,    0x1.e14b936a72196p-1,  -0x1.013604p-2, INEXACT)
T(RN,   0x1.c998ac398bbf9p+35,   -0x1.ea3b773697aadp-1,   0x1.4dd6dap-3, INEXACT)
T(RN,   0x1.8aefef39cc6bcp+35,   -0x1.c1901d8e70aa2p-1,   0x1.78fa38p-2, INEXACT)
T(RN,   0x1.1e6c011284563p+35,    0x1.8007d680ea8e6p-1,  -0x1.c0f62cp-5, INEXACT)
T(RN,    0x1.9c52849e344cp+36,    0x1.f94ce2457d94bp-1,   0x1.1a75eep-2, INEXACT)
T(RN,   0x1.afb62140e4e71p+36,   -0x1.ffddb0d3a80cfp-1,  -0x1.4563cap-8, INEXACT)
T(RN,   0x1.d84d02950af3ep+36,    0x1.f30e8a304bad6p-1,  -0x1.5b6ca8p-2, INEXACT)
T(RN,   0x1.16e09eb77f839p+36,   -0x1.ae57ef2f6b671p-1,  -0x1.28a15ap-2, INEXACT)
T(RN,   0x1.36b5f09427507p+36,    0x1.dddc834e92f4bp-1,  -0x1.ebb2dcp-2, INEXACT)
T(RN,   0x1.8053c5c2755dcp+36,   -0x1.fff920d560301p-1,  -0x1.404be2p-3, INEXACT)
T(RN,   0x1.6d731bb51f7a9p+36,   -0x1.b461f787304fap-5,  -0x1.eb2904p-3, INEXACT)
T(RN,   0x1.db52f39b1063ep+36,   -0x1.76b3197d22d64p-2,   -0x1.00bf8p-4, INEXACT)
T(RN,   0x1.9aa2b399d8c94p+36,    0x1.ec8bf8ee05066p-1,  -0x1.95d1eap-3, INEXACT)
T(RN,   0x1.ed1443b395926p+36,   -0x1.e2ae3bd8ee888p-3,  -0x1.275fd2p-3, INEXACT)
T(RN,   0x1.783913b0f0bf6p+37,    -0x1.fff27d48d1fap-1,   0x1.e8d466p-4, INEXACT)
T(RN,   0x1.457cb9027de02p+37,    0x1.55c44a13a953ap-3,   0x1.aba956p-2, INEXACT)
T(RN,   0x1.c770929e11866p+37,    0x1.42cc5f9a7e6cep-1,   0x1.162538p-3, INEXACT)
T(RN,   0x1.ee0c3fba8570cp+37,   -0x1.5ef43dd8b48d5p-2,  -0x1.3371fep-2, INEXACT)
T(RN,   0x1.13cae572b93e6p+37,   -0x1.effdf3cdacbf2p-1,    0x1.e0d2dp-2, INEXACT)
T(RN,   0x1.a69826cd53df8p+37,    0x1.fa049bf8ee7afp-1,  -0x1.9cb704p-2, INEXACT)
T(RN,   0x1.2eec673f276a8p+37,    0x1.c8719fcc2e871p-1,   0x1.dfede2p-2, INEXACT)
T(RN,   0x1.2992a250c0a79p+37,    0x1.44e6fdeceb46ep-1,  -0x1.3cf2d4p-2, INEXACT)
T(RN,   0x1.d1920fe71e83cp+37,   -0x1.caa6dac0d516ap-1,  -0x1.8cc06cp-5, INEXACT)
T(RN,   0x1.27eaf986c8ae6p+37,    0x1.e0df1b56db3e7p-1,  -0x1.55c4ecp-2, INEXACT)
T(RN,   0x1.269af382985cdp+38,   -0x1.9233ef111665fp-1,   0x1.20f108p-6, INEXACT)
T(RN,   0x1.f60f0c686934ep+38,   -0x1.beb4a0e9f17f2p-3,  -0x1.13f216p-4, INEXACT)
T(RN,   0x1.1aa8f8b823b8dp+38,   -0x1.24068d3f1edecp-9,  -0x1.13b6f4p-8, INEXACT)
T(RN,    0x1.98239535a892p+38,   -0x1.ec06926cbff2ap-1,   0x1.af471ep-6, INEXACT)
T(RN,   0x1.fe3e75e3444b8p+38,    0x1.579561f121eb5p-3,   0x1.f5d4c4p-3, INEXACT)
T(RN,   0x1.92ece515443a2p+38,    0x1.9eacb70692d51p-2,  -0x1.7533fcp-3, INEXACT)
T(RN,   0x1.a5d90e777a28cp+38,   -0x1.ed5e8bc15297dp-5,  -0x1.487b04p-2, INEXACT)
T(RN,   0x1.2aef839e8d321p+38,   -0x1.c5adfc9cbe3afp-1,   -0x1.e2266p-4, INEXACT)
T(RN,   0x1.4e50647c9a0adp+38,   -0x1.cc788621fc61bp-1,    0x1.01cfap-3, INEXACT)
T(RN,   0x1.618033c5122fap+38,   -0x1.f674e287fb8b8p-5,  -0x1.36e772p-2, INEXACT)
T(RN,   0x1.40963d1f58267p+39,     -0x1.47f42c4af0dp-1,   -0x1.d5b5cp-2, INEXACT)
T(RN,   0x1.018c9a9fd2501p+39,   -0x1.9990c609391abp-1,  -0x1.d964dap-2, INEXACT)
T(RN,   0x1.ba699124d61cep+39,   -0x1.55470c9a25744p-3,  -0x1.8c15cap-2, INEXACT)
T(RN,   0x1.8199cb86f750ap+39,    0x1.fe6f17cafc242p-1,   0x1.374474p-3, INEXACT)
T(RN,   0x1.0d46fe329ad91p+39,    0x1.fdc89fb51c624p-1,   0x1.b2fdd4p-2, INEXACT)
T(RN,    0x1.d60f0bf11bddp+39,    0x1.563158b472338p-2,   0x1.3982bep-6, INEXACT)
T(RN,   0x1.de57396fd389dp+39,    0x1.f5bf090c2d3a5p-1,  -0x1.de22d2p-2, INEXACT)
T(RN,   0x1.b0d69985261dap+39,   -0x1.b1e01f24b6455p-3,  -0x1.c39eaap-3, INEXACT)
T(RN,    0x1.d643bbfb6271p+39,   -0x1.8cd0b6493c831p-4,   0x1.ffb934p-2, INEXACT)
T(RN,   0x1.6205e071ccc89p+39,    0x1.494dd8f6b670bp-1,    0x1.fac69p-3, INEXACT)
T(RN,   0x1.8a1f858a70c03p+40,   -0x1.a814fa7ea5528p-1,  -0x1.22986cp-2, INEXACT)
T(RN,    0x1.a9432d106b66p+40,   -0x1.f5c0d3ac86712p-1,   0x1.d7198ap-3, INEXACT)
T(RN,   0x1.60c194c9e5917p+40,   -0x1.ea49ec5a3c3c5p-1,   0x1.a522d2p-3, INEXACT)
T(RN,   0x1.5bb88998e21b8p+40,   -0x1.3ee7eade3d06ap-2,   0x1.e4a5e6p-4, INEXACT)
T(RN,   0x1.b876068515b8ep+40,   -0x1.fa0c09a6b8e97p-1,   0x1.97b574p-3, INEXACT)
T(RN,   0x1.5fea80cf64ee8p+40,   -0x1.f3faa49e3b6e7p-1,  -0x1.12100ep-3, INEXACT)
T(RN,   0x1.30ee4f9590287p+40,    0x1.fe8e61b9eadb8p-1,    0x1.2d4f6p-2, INEXACT)
T(RN,   0x1.fa8e1fbaeae5dp+40,    0x1.aa12bf4b866e4p-1,   0x1.051a6cp-2, INEXACT)
T(RN,   0x1.5a670d231f16cp+40,   -0x1.94bdcb95ab61ep-2,   0x1.b0da9cp-3, INEXACT)
T(RN,   0x1.27ee3fae038dap+40,    0x1.fd776946244cdp-1,   0x1.ddf0ccp-2, INEXACT)
T(RN,   0x1.fd8dad0cb297ep+41,   -0x1.fa44182e4fb0cp-3,    0x1.aaeffp-4, INEXACT)
T(RN,   0x1.3aa2192aa779bp+41,   -0x1.a7948cf0b1351p-1,  -0x1.63ef9ep-2, INEXACT)
T(RN,   0x1.110184fc833e2p+41,    0x1.b86c97501f661p-1,  -0x1.fbc6e4p-2, INEXACT)
T(RN,   0x1.abb552624de3bp+41,   -0x1.5a59b188acd48p-1,  -0x1.63ed08p-2, INEXACT)
T(RN,   0x1.fbb65788276f2p+41,   -0x1.68010fea15c8fp-1,   0x1.96905ap-4, INEXACT)
T(RN,   0x1.5523f5e805b18p+41,   -0x1.d15466570099ap-1,   -0x1.689acp-2, INEXACT)
T(RN,   0x1.a116e37878f32p+41,     0x1.9c5ead9d83e5p-4,  -0x1.c05876p-2, INEXACT)
T(RN,   0x1.b5a012841dbd4p+41,   -0x1.8ec14fb094651p-2,   0x1.ff7e02p-3, INEXACT)
T(RN,   0x1.2b3b81d316fe4p+41,   -0x1.c3ba4e2cef7e7p-2,   0x1.f24814p-3, INEXACT)
T(RN,   0x1.cc43e9203da22p+41,    0x1.4d0a5ceada5d3p-3,   0x1.6677f2p-3, INEXACT)
T(RN,   0x1.cac84baf9e852p+42,    0x1.8b2ceab71b3fap-2,   0x1.122fdap-2, INEXACT)
T(RN,   0x1.6be9caba60d33p+42,    0x1.ff2bf5709ce1ap-1,  -0x1.bf4c0cp-3, INEXACT)
T(RN,   0x1.f8c15723e22bcp+42,    0x1.fef0307b3435ep-1,   0x1.591c6cp-2, INEXACT)
T(RN,   0x1.29b4d6ba9b2a2p+42,   -0x1.1fd4f1703c596p-2,  -0x1.d01f5ap-2, INEXACT)
T(RN,   0x1.979630d39abfcp+42,    0x1.6c83cea5a91ebp-1,   0x1.43fd38p-3, INEXACT)
T(RN,   0x1.b9f0d6dab4556p+42,   -0x1.8035410193386p-1,   0x1.c36ff8p-2, INEXACT)
T(RN,   0x1.8a2f5a06a81e2p+42,    0x1.ee64483a09343p-3,  -0x1.c8231cp-3, INEXACT)
T(RN,   0x1.b8b73e8ca0074p+42,   -0x1.f5df53a90074ep-1,   0x1.5f9d72p-5, INEXACT)
T(RN,   0x1.1a6edc06c8d15p+42,   -0x1.1404b6ef0b321p-6,   0x1.48698ep-4, INEXACT)
T(RN,   0x1.b0496672ee7bap+42,    0x1.ea9a2dfb4c2fbp-2,  -0x1.74d3c6p-7, INEXACT)
T(RN,   0x1.9e9b8d69cd926p+43,    0x1.b8fc90f23f2e3p-1,   0x1.1e7fd2p-3, INEXACT)
T(RN,   0x1.bf2ae5d13e561p+43,   -0x1.cddfae96fcce1p-1,   0x1.0b571cp-2, INEXACT)
T(RN,    0x1.bfe7394e30f8p+43,   -0x1.7d48698ba236bp-2,     0x1.7438p-2, INEXACT)
T(RN,   0x1.0e1aa0c3c66fap+43,   -0x1.da68bc871f2dcp-1,  -0x1.0d287ep-2, INEXACT)
T(RN,   0x1.1ece8ba5d1d33p+43,    0x1.c117bed098e5bp-1,  -0x1.f5fe52p-7, INEXACT)
T(RN,   0x1.e2e30a5b3ee5ap+43,    0x1.c0d061cfc2c89p-1,   -0x1.0ffa4p-2, INEXACT)
T(RN,   0x1.35351a6a2cacep+43,    0x1.b358e26694df5p-2,  -0x1.f53406p-2, INEXACT)
T(RN,   0x1.ca8fbe72bd6b2p+43,    0x1.d2eb91c9a40d4p-4,  -0x1.ef9944p-2, INEXACT)
T(RN,   0x1.ea80c3e0494a7p+43,    0x1.8b9eba4693c75p-1,   0x1.297d9ep-3, INEXACT)
T(RN,   0x1.4f225b4689ebap+43,   -0x1.54b393324c03ap-1,   0x1.6195e6p-3, INEXACT)
T(RN,   0x1.3c7fd3bf611ccp+44,   -0x1.cabb7739edc5dp-1,   0x1.e075bap-5, INEXACT)
T(RN,   0x1.9a5fec33d3b66p+44,   -0x1.0265ce0d7f703p-3,  -0x1.9fb758p-2, INEXACT)
T(RN,   0x1.cc2464ae34b1ep+44,   -0x1.ffc0b655c17a4p-1,   0x1.444fc4p-4, INEXACT)
T(RN,    0x1.b53e1c3c4ec8p+44,   -0x1.4e9afcdd96a56p-2,  -0x1.4e1b9ap-6, INEXACT)
T(RN,   0x1.0ab2e4760f1c8p+44,    0x1.cc2d425c1337cp-2,  -0x1.e05c16p-2, INEXACT)
T(RN,    0x1.857fb341b264p+44,    0x1.679a7c7eac501p-1,  -0x1.edbed4p-3, INEXACT)
T(RN,   0x1.03522bd1e6bf8p+44,    0x1.74aa4c2346cbep-3,  -0x1.4b2a0ap-2, INEXACT)
T(RN,   0x1.114ac811b8bdbp+44,    0x1.f6d3d794fead4p-2,   0x1.6a6216p-2, INEXACT)
T(RN,   0x1.765dd12e7c724p+44,    0x1.a5333b3a28d2fp-1,   0x1.e79d2ep-2, INEXACT)
T(RN,   0x1.5e374951398eap+44,    0x1.bc7bcb26a0a32p-1,  -0x1.e96fc2p-2, INEXACT)
T(RN,   0x1.8f04703130accp+45,   -0x1.43ec07627f98bp-1,   0x1.e170a2p-2, INEXACT)
T(RN,   0x1.084c4b687b646p+45,    0x1.db522681e2293p-1,   0x1.31c0b6p-2, INEXACT)
T(RN,   0x1.e0c73e459906ep+45,    0x1.f89d86bf4a00ep-1,   0x1.6ebcf8p-3, INEXACT)
T(RN,   0x1.c028a7ef5612cp+45,   -0x1.d09d0b4b9d36bp-1,    0x1.a5a4cp-2, INEXACT)
T(RN,   0x1.d6945fe3baef6p+45,    0x1.be919762a9f62p-1,  -0x1.64150ap-3, INEXACT)
T(RN,   0x1.112a9a0f20262p+45,   -0x1.8f06257b34408p-2,  -0x1.42c9eap-2, INEXACT)
T(RN,   0x1.35574ff3fa8d8p+45,     0x1.bab5e79366e8p-1,  -0x1.6c199cp-4, INEXACT)
T(RN,   0x1.90ddb801df8ecp+45,    0x1.9c66dca305002p-3,   0x1.af5c86p-3, INEXACT)
T(RN,   0x1.6d94d368729d8p+45,    0x1.1bd56e52f6348p-1,  -0x1.ebfafcp-2, INEXACT)
T(RN,   0x1.815b6115f1ecdp+45,   -0x1.c64ef6fc5d42dp-1,   0x1.09fc9ep-2, INEXACT)
T(RN,   0x1.0ad53284c99e5p+46,   -0x1.ff4cef0f38f3ep-1,  -0x1.8a8108p-2, INEXACT)
T(RN,   0x1.52176b9c1c22cp+46,    0x1.77af3229b2363p-3,  -0x1.92bf46p-3, INEXACT)
T(RN,    0x1.6c059ddfe239p+46,   -0x1.d68ec2b292cacp-1,   0x1.7af4c8p-3, INEXACT)
T(RN,   0x1.1bde6f409fa58p+46,    0x1.bf91e4b40778fp-2,   -0x1.f9372p-2, INEXACT)
T(RN,   0x1.f893a505155e7p+46,    0x1.dbdad378e72d8p-2,   0x1.23751ep-6, INEXACT)
T(RN,   0x1.7125137327116p+46,   -0x1.fd7d3e6305d62p-1,   0x1.a76ee8p-2, INEXACT)
T(RN,    0x1.7efb70059d0dp+46,   -0x1.b46fffaaac75ap-3,  -0x1.7a9fc4p-3, INEXACT)
T(RN,   0x1.1b3215e43da1ap+46,    0x1.6a4a258564591p-1,  -0x1.2f7df4p-3, INEXACT)
T(RN,   0x1.c386d28485b63p+46,      -0x1.c6314871abp-1,  -0x1.7f6028p-4, INEXACT)
T(RN,   0x1.fb839ea7cded2p+46,    0x1.a60673f094bd8p-1,   0x1.0921c8p-2, INEXACT)
T(RN,   0x1.528a6b0a97e5cp+47,   -0x1.8592405b06af4p-3,  -0x1.ef1246p-2, INEXACT)
T(RN,   0x1.eb2aefbd20745p+47,    0x1.ba9a251abe223p-1,   -0x1.0e852p-3, INEXACT)
T(RN,   0x1.f52ae2b8dc728p+47,    0x1.1e6474c987a12p-1,  -0x1.dd8f7ap-2, INEXACT)
T(RN,   0x1.94a5b320ad5e2p+47,    0x1.6ee3ca7a14d4cp-1,   0x1.1db358p-2, INEXACT)
T(RN,   0x1.b6ad3b473e70ap+47,    0x1.e0c3aba296103p-2,   0x1.58c05ep-2, INEXACT)
T(RN,   0x1.35316fbd5abe4p+47,   -0x1.90a252fd1d503p-1,   0x1.5064bep-3, INEXACT)
T(RN,   0x1.d9ca4bcee5b04p+47,    0x1.ffde80001629cp-1,  -0x1.91858cp-2, INEXACT)
T(RN,   0x1.e3744816127d8p+47,   -0x1.ef6c8b7d330c3p-1,   -0x1.ce0c7p-4, INEXACT)
T(RN,   0x1.7640472c3bd24p+47,    0x1.b98eca879bedfp-2,  -0x1.c99edap-2, INEXACT)
T(RN,   0x1.ca8ddaa5f6e05p+47,     0x1.8b7070e9dfefp-1,   0x1.1e0e8cp-4, INEXACT)
T(RN,   0x1.6e6e2ae187116p+48,    0x1.e1c1e8fba48f3p-1,  -0x1.b0d05ap-2, INEXACT)
T(RN,    0x1.40ce00cd10ecp+48,    0x1.ee70db66f86d6p-1,    0x1.69da1p-2, INEXACT)
T(RN,   0x1.4f39913fdcd38p+48,    0x1.989208ce58106p-1,   0x1.816d2ap-4, INEXACT)
T(RN,   0x1.309bb7092e423p+48,   -0x1.ef8184a67aecep-2,  -0x1.18478ap-2, INEXACT)
T(RN,   0x1.cb0528b8131f8p+48,    0x1.f5b1797368133p-1,  -0x1.ecbae6p-3, INEXACT)
T(RN,   0x1.0870ca6e99ccfp+48,   -0x1.87a297aec5d3ap-1,   0x1.6bf3cep-2, INEXACT)
T(RN,   0x1.3d46f2f914c6ap+48,    0x1.7b028077c14cap-2,  -0x1.20b8e2p-5, INEXACT)
T(RN,    0x1.ad6f9e00f9a3p+48,   -0x1.42611859d3fcdp-1,  -0x1.f828c2p-2, INEXACT)
T(RN,   0x1.6e710deb1b16fp+48,   -0x1.5647fa65e8a6ap-4,  -0x1.faa7fap-3, INEXACT)
T(RN,   0x1.fe558aa20c629p+48,    0x1.d6f72ebd2ace6p-2,   0x1.dd5a06p-2, INEXACT)
T(RN,   0x1.7e833def8199dp+49,    0x1.45b02f7758142p-1,   0x1.f5342ap-4, INEXACT)
T(RN,   0x1.46b5b3ef79accp+49,    0x1.86e7eb2aef4b2p-1,  -0x1.7a1e56p-4, INEXACT)
T(RN,   0x1.0edff9a768a82p+49,   -0x1.269bbaf9c2b6cp-2,  -0x1.839338p-5, INEXACT)
T(RN,   0x1.bd4ec6467c67bp+49,    0x1.1abfbc86e373fp-1,  -0x1.bedd6ep-2, INEXACT)
T(RN,   0x1.9ff27d7c56c0bp+49,   -0x1.a30783c21c0eep-2,  -0x1.271a76p-2, INEXACT)
T(RN,    0x1.b5b25b70c33cp+49,   -0x1.4ec5afd405c9bp-2,   -0x1.bf04ep-2, INEXACT)
T(RN,   0x1.dbda149d755fap+49,    0x1.e30f55046960fp-1,  -0x1.5892e6p-5, INEXACT)
T(RN,   0x1.43b3dac37c079p+49,   -0x1.e134a7e2f0d83p-2,  -0x1.1c2482p-4, INEXACT)
T(RN,    0x1.97d7cffa9ee7p+49,    0x1.c31552cbfe6ddp-3,   0x1.cb3b56p-2, INEXACT)
T(RN,   0x1.8ee7758aa605cp+49,    0x1.aa1163cbe97fep-1,   0x1.b137c2p-2, INEXACT)
T(RN,    0x1.9966aac52a67p+50,    0x1.38835dbc9f9a9p-1,    0x1.cfb88p-3, INEXACT)
T(RN,   0x1.dd1ef62cc90c3p+50,   -0x1.90eb56e952628p-3,  -0x1.8783a6p-5, INEXACT)
T(RN,   0x1.988c63369e486p+50,    0x1.23e55b783886dp-4,  -0x1.cf4948p-3, INEXACT)
T(RN,   0x1.e01a45123a23cp+50,    0x1.53cfca5f74a24p-1,  -0x1.7e0348p-2, INEXACT)
T(RN,   0x1.621df9fb23fafp+50,    0x1.f6ef19a1fc305p-1,   0x1.a6b19ap-4, INEXACT)
T(RN,   0x1.b8976cddfa852p+50,    -0x1.a8ce92aab2fcp-1,   0x1.d9a92ap-2, INEXACT)
T(RN,   0x1.f10aabaefeedep+50,    0x1.915ea65f5d108p-6,  -0x1.0f0a22p-3, INEXACT)
T(RN,   0x1.a9c542277da9ap+50,   -0x1.f2d405a445716p-1,    0x1.d3645p-5, INEXACT)
T(RN,   0x1.be6ac03d346f5p+50,    -0x1.84d7e2495887p-1,   0x1.153c76p-2, INEXACT)
T(RN,   0x1.76dde7dff2dfap+50,    -0x1.b99d3405e45ep-3,   0x1.c5fa94p-2, INEXACT)
T(RN,   0x1.38fbb3ea7de8cp+51,    0x1.f43df0109c90ap-1,   0x1.b8fd86p-3, INEXACT)
T(RN,     0x1.b8f83a4ccf5p+51,    0x1.d879f295f7f22p-1,  -0x1.7dc528p-4, INEXACT)
T(RN,   0x1.c5728bfc10b03p+51,   -0x1.e2147073788a9p-3,   0x1.64003ep-2, INEXACT)
T(RN,   0x1.1bf307fb4eb3cp+51,    0x1.94d650195f407p-3,   0x1.1f1f2ap-2, INEXACT)
T(RN,    0x1.410e0cd7c454p+51,   -0x1.c4578da95fbbcp-1,  -0x1.5afb84p-3, INEXACT)
T(RN,   0x1.bcc3cd5d416bbp+51,   -0x1.5827f7997b1b8p-1,  -0x1.9b3304p-3, INEXACT)
T(RN,   0x1.fa82a7cdb7b06p+51,   -0x1.f461d08563453p-2,  -0x1.be1038p-3, INEXACT)
T(RN,   0x1.6956e79a34ae8p+51,   -0x1.11482cd595823p-1,   0x1.465ceep-3, INEXACT)
T(RN,   0x1.f7da52bc63f65p+51,    0x1.41b56a470a9cbp-1,   0x1.994fd4p-7, INEXACT)
T(RN,   0x1.e840f43d1a55ap+51,   -0x1.671bc5fb12d15p-2,   0x1.c4a3f4p-2, INEXACT)
T(RN,   0x1.9d4b9844dfc43p+52,   -0x1.e80517567e4c1p-2,   0x1.720bc2p-3, INEXACT)
T(RN,   0x1.92fdead8171a8p+52,    0x1.c8f738023383fp-1,    0x1.57bbap-3, INEXACT)
T(RN,   0x1.03a26d1892f3dp+52,    0x1.2c05c16c27829p-1,  -0x1.7864a4p-3, INEXACT)
T(RN,   0x1.a718e2df88f99p+52,   -0x1.f8b6d7cdd1329p-1,   0x1.0972bcp-5, INEXACT)
T(RN,   0x1.341a445ea62a8p+52,    0x1.bbcc211b93a2fp-1,   0x1.91c136p-3, INEXACT)
T(RN,   0x1.3e8cb4a893574p+52,    0x1.fdc5abcd12de7p-1,   0x1.efcbf4p-3, INEXACT)
T(RN,   0x1.3bcdc0ed49607p+52,   -0x1.b130debc0c3c1p-1,  -0x1.0d3c08p-8, INEXACT)
T(RN,   0x1.ed69c59344dfcp+52,    0x1.272b0ff1e0d4dp-1,  -0x1.d6db42p-4, INEXACT)
T(RN,   0x1.66f1a14bc4917p+52,   -0x1.e25f0ccdfdc8ap-1,   0x1.6abf5ap-2, INEXACT)
T(RN,    0x1.aa0c9b143407p+52,   -0x1.6c5d5083f8dfep-1,   0x1.e9fed6p-4, INEXACT)
T(RN,   0x1.0b5f3656c52afp+53,   -0x1.fa2fbf53f289cp-1,   0x1.1c54cep-2, INEXACT)
T(RN,   0x1.b8a13d6bc08acp+53,   -0x1.7ba99ae3ae979p-1,   0x1.3b997cp-4, INEXACT)
T(RN,   0x1.7587673e861ccp+53,   -0x1.27f342f39de7cp-3,   0x1.1e069ep-2, INEXACT)
T(RN,   0x1.5f08a94bc7271p+53,   -0x1.ea20d151d9397p-1,  -0x1.de39c6p-7, INEXACT)
T(RN,   0x1.435706ee02ca5p+53,    0x1.172f43ad4e795p-1,   -0x1.90352p-3, INEXACT)
T(RN,   0x1.c872ed9088878p+53,    0x1.bf33e1a4083bbp-1,   0x1.4442d2p-4, INEXACT)
T(RN,   0x1.329d7a3d380c4p+53,    0x1.2afeedb113d02p-1,   0x1.475bfep-2, INEXACT)
T(RN,    0x1.9285ed33aeaap+53,   -0x1.f4ea362d8093bp-1,  -0x1.1d4c3cp-3, INEXACT)
T(RN,   0x1.3c991fc3464f2p+53,    0x1.bda1735199937p-1,  -0x1.ebc236p-3, INEXACT)
T(RN,   0x1.177c1a214f83ep+53,   -0x1.17fc4defe5579p-1,  -0x1.e5ef48p-2, INEXACT)
T(RN,   0x1.183a785f5333ep+54,   -0x1.cf87c7866b94dp-1,   0x1.fcb0aep-2, INEXACT)
T(RN,    0x1.ec72ae824998p+54,   -0x1.4819c453cee47p-2,   0x1.01b462p-2, INEXACT)
T(RN,   0x1.0622d9b019d48p+54,   -0x1.482a290b948e4p-2,  -0x1.f0934ep-2, INEXACT)
T(RN,   0x1.eba3bd2e6b218p+54,   -0x1.b76c6e6dcad82p-2,   0x1.850aaap-2, INEXACT)
T(RN,   0x1.f17ec4272669cp+54,   -0x1.f992f3f77d4f9p-1,   0x1.67c414p-5, INEXACT)
T(RN,   0x1.7108988701ed6p+54,   -0x1.786cf7ce5578bp-1,   0x1.39a7c6p-6, INEXACT)
T(RN,   0x1.30e2b05a16625p+54,    0x1.5c2eda21b4f81p-3,  -0x1.fcf96cp-4, INEXACT)
T(RN,    0x1.ff6976373e98p+54,   -0x1.d2ef0b4dfb2cep-1,   0x1.9380dcp-2, INEXACT)
T(RN,   0x1.44700e87d2ea6p+54,    0x1.7fc0e40c5c731p-2,   0x1.c7121cp-3, INEXACT)
T(RN,    0x1.dddd6bddc562p+54,    0x1.cf995ea657233p-2,    0x1.31bebp-3, INEXACT)
T(RN,   0x1.72d3511534e6ep+55,    0x1.6d773d9223227p-1,   0x1.ea72a4p-2, INEXACT)
T(RN,   0x1.da1ef81ff3685p+55,    0x1.d5940d3972216p-2,   0x1.0ada0ep-2, INEXACT)
T(RN,   0x1.9b684e9e94528p+55,    0x1.76649ca40ee5ap-1,  -0x1.ba88bcp-2, INEXACT)
T(RN,   0x1.9c9543f293fddp+55,    0x1.ff00addc29a38p-1,  -0x1.4a0b3cp-2, INEXACT)
T(RN,    0x1.ce9441c5b888p+55,    0x1.06e148ccc9e1ep-2,   -0x1.785b9p-2, INEXACT)
T(RN,   0x1.ba5eeede436f4p+55,    0x1.f2fb11bd035c5p-1,   0x1.b2761ap-2, INEXACT)
T(RN,   0x1.c7545473420e1p+55,   -0x1.fe8761927737cp-1,   0x1.0e6d2cp-2, INEXACT)
T(RN,    0x1.af8838ee78d4p+55,    0x1.d248be8497018p-3,   -0x1.95ff1p-4, INEXACT)
T(RN,   0x1.11e202c94baadp+55,    0x1.d7f587f22f9b6p-1,   -0x1.1ea11p-3, INEXACT)
T(RN,   0x1.40a3a898a10bep+55,    0x1.ebefd45249f6bp-1,  -0x1.351624p-5, INEXACT)
T(RN,   0x1.72b9320c919c6p+56,   -0x1.d8412cacff6dfp-3,   0x1.48d0dap-2, INEXACT)
T(RN,   0x1.26f0286fa7d97p+56,   -0x1.a3ca21fe25d96p-2,   0x1.02e79cp-5, INEXACT)
T(RN,    0x1.d10bcd28f94dp+56,    0x1.0368a4b054e7cp-2,  -0x1.c1543ep-2, INEXACT)
T(RN,   0x1.b7da2513bf979p+56,   -0x1.f41d9c7e9242ep-2,    0x1.ab1f3p-3, INEXACT)
T(RN,   0x1.643b810d5ac22p+56,   -0x1.167ad13811bf7p-2,   0x1.7c89a4p-5, INEXACT)
T(RN,   0x1.9f3efae6614fdp+56,   -0x1.4e3edd7137089p-1,  -0x1.4e1086p-2, INEXACT)
T(RN,   0x1.aa6b90bfbb17ap+56,   -0x1.cf341abae187fp-1,  -0x1.0cb7c8p-3, INEXACT)
T(RN,   0x1.66bf84e68da77p+56,   -0x1.e0623de055e61p-2,  -0x1.496fb8p-3, INEXACT)
T(RN,   0x1.cf946852f2256p+56,    0x1.ea31fccafb909p-1,   0x1.8736a2p-3, INEXACT)
T(RN,   0x1.6e270c264325cp+56,   -0x1.aec6d749c88aap-1,   0x1.31a5cp-10, INEXACT)
T(RN,   0x1.02d1499d5dec2p+57,   -0x1.ff3e79632c279p-1,  -0x1.8aadb6p-2, INEXACT)
T(RN,    0x1.0255534b8f94p+57,   -0x1.364eb9343067bp-1,  -0x1.ee9f14p-2, INEXACT)
T(RN,   0x1.36858b5fabf17p+57,    0x1.0c05dd0738643p-2,  -0x1.c2b22cp-2, INEXACT)
T(RN,   0x1.1688ae032318cp+57,   -0x1.7d314023bd9f5p-1,   0x1.a87e8ep-4, INEXACT)
T(RN,   0x1.a837dbae9cb94p+57,   -0x1.6ee33144d5b3cp-1,  -0x1.6fb3acp-6, INEXACT)
T(RN,   0x1.cfaedd2fd1822p+57,   -0x1.6793f50ab10abp-1,   0x1.3b4284p-2, INEXACT)
T(RN,   0x1.3763f723b512bp+57,   -0x1.c856170e73d9fp-1,  -0x1.3698c4p-3, INEXACT)
T(RN,   0x1.237dcd5936a21p+57,   -0x1.d707009700595p-1,  -0x1.f739c2p-7, INEXACT)
T(RN,   0x1.7e67f36e019ecp+57,    0x1.3404113436201p-2,   0x1.8c0252p-2, INEXACT)
T(RN,   0x1.46ae9dc51032ep+57,   -0x1.eaad1e5da6fefp-2,   0x1.b31bc6p-2, INEXACT)
T(RN,   0x1.3d894a0207c83p+58,    0x1.ed5f3da6d601ap-3,   -0x1.5ce2ap-5, INEXACT)
T(RN,   0x1.b18e8eb927fa4p+58,    0x1.762cb7a9d897ep-1,  -0x1.6dddbap-2, INEXACT)
T(RN,   0x1.05a1e22080d8ap+58,    -0x1.72c810cae0d1p-1,    0x1.d45a7p-2, INEXACT)
T(RN,   0x1.d7343ae66cf82p+58,    0x1.4b3a205942058p-1,  -0x1.85423cp-3, INEXACT)
T(RN,   0x1.11da8a932f528p+58,   -0x1.7f2e6d0437f23p-1,   0x1.25d55ep-6, INEXACT)
T(RN,   0x1.56280ae718221p+58,    0x1.304adf2206a59p-1,  -0x1.1a714ap-2, INEXACT)
T(RN,   0x1.5705afabdc28dp+58,    0x1.7491cd76b6136p-3,   0x1.ab51c8p-2, INEXACT)
T(RN,   0x1.30f22df01db2ap+58,    0x1.9b7cb024cd31fp-1,   0x1.dcf348p-2, INEXACT)
T(RN,   0x1.f8946556a57a6p+58,   -0x1.50cee7fe34752p-2,   0x1.8776b2p-5, INEXACT)
T(RN,   0x1.a2773e3f40018p+58,   -0x1.6a2611d1408cfp-1,  -0x1.5e57dcp-4, INEXACT)
T(RN,   0x1.16859739d441bp+59,   -0x1.4fba051682688p-1,  -0x1.1da0dep-2, INEXACT)
T(RN,   0x1.dd5fa6be44b0cp+59,    0x1.fffdfe0cbfd3fp-1,  -0x1.633806p-2, INEXACT)
T(RN,   0x1.305366b15299cp+59,    0x1.91cf6f18f014dp-3,  -0x1.5c3e2ap-3, INEXACT)
T(RN,   0x1.3ea851da72a8bp+59,    0x1.f186f77ff84acp-1,     0x1.e36fp-2, INEXACT)
T(RN,   0x1.5109905ad00d4p+59,   -0x1.fc2558519f4f5p-1,   0x1.581a72p-2, INEXACT)
T(RN,   0x1.344936a36772cp+59,   -0x1.91c2e33def3c1p-2,  -0x1.75aceap-2, INEXACT)
T(RN,   0x1.4936f3c5bc1a5p+59,    0x1.e558deaf8d5efp-1,   0x1.97636ap-2, INEXACT)
T(RN,    0x1.89978f816438p+59,    -0x1.2f944254c9c6p-5,  -0x1.13cd36p-3, INEXACT)
T(RN,   0x1.c9905e04d2bb9p+59,   -0x1.c47f9a96ae839p-1,  -0x1.c4d794p-4, INEXACT)
T(RN,   0x1.699312a8781c9p+59,    0x1.561d4a9945147p-2,   0x1.e90e5cp-2, INEXACT)
T(RN,   0x1.66bcb1be47494p+60,   -0x1.944d140b87262p-2,   0x1.33f986p-2, INEXACT)
T(RN,    0x1.161f6f2f207ep+60,   -0x1.9a945c14c5aaep-1,  -0x1.8dbe28p-5, INEXACT)
T(RN,   0x1.a96cdc8c42256p+60,    0x1.fdcfe133648dap-1,  -0x1.c50a64p-5, INEXACT)
T(RN,   0x1.11fd04affb0eap+60,   -0x1.9c6df06888c62p-1,  -0x1.c6e4ecp-5, INEXACT)
T(RN,   0x1.2e0c12ce8e7c1p+60,   -0x1.fc05c74bbe7acp-1,   0x1.b31f8cp-2, INEXACT)
T(RN,   0x1.9f3faf4c774a4p+60,     0x1.957357a7b87bp-1,   0x1.d78a42p-4, INEXACT)
T(RN,   0x1.d8af2aeca7ad8p+60,   -0x1.fcf09ed6511e3p-4,    0x1.8313dp-5, INEXACT)
T(RN,    0x1.443fe7a29bc2p+60,   -0x1.fed0072efaa82p-1,  -0x1.7f04c4p-4, INEXACT)
T(RN,   0x1.840d1a25cee23p+60,    0x1.cea6554e431d2p-1,    0x1.aa17bp-4, INEXACT)
T(RN,   0x1.f47a3c5ec76fep+60,   -0x1.15be7c6571be6p-1,  -0x1.7ae43ap-2, INEXACT)
T(RN,   0x1.453302145d6f5p+61,    0x1.6316a05794486p-2,  -0x1.b8760cp-4, INEXACT)
T(RN,   0x1.df126da9605dbp+61,    0x1.ee069c36254fdp-1,  -0x1.f5f2a8p-2, INEXACT)
T(RN,   0x1.b5534490b1172p+61,   -0x1.aeffeb34085e9p-1,  -0x1.4e600ap-3, INEXACT)
T(RN,   0x1.77f5c576d5e78p+61,    0x1.1c592b5807042p-4,   0x1.6f6d3ep-3, INEXACT)
T(RN,   0x1.01f90c1beac0ap+61,    0x1.2450e77750c67p-2,   0x1.8e6f18p-2, INEXACT)
T(RN,   0x1.8b32841209413p+61,    0x1.be5f34f0e5f2bp-4,   -0x1.5bc18p-2, INEXACT)
T(RN,   0x1.3264e5c2a8449p+61,   -0x1.cbf6717f863e6p-1,   0x1.669e88p-3, INEXACT)
T(RN,   0x1.0f4cbe5bda77ep+61,    -0x1.8751245c10ecp-1,   0x1.a54548p-2, INEXACT)
T(RN,   0x1.a36f51a7294fep+61,   -0x1.0a490bee4de83p-7,   0x1.4ee772p-2, INEXACT)
T(RN,    0x1.b80b0dfa73e9p+61,    0x1.d3b50d0ecd54bp-1,  -0x1.857422p-2, INEXACT)
T(RN,   0x1.efccc285630dap+62,   -0x1.b26bd9f4e7986p-1,    -0x1.70f3p-3, INEXACT)
T(RN,   0x1.1ea10cecc3c9fp+62,    0x1.ed2de4f9a76acp-1,  -0x1.5278d4p-2, INEXACT)
T(RN,   0x1.378cde7c53866p+62,     0x1.13903d1b621fp-3,   -0x1.ce868p-2, INEXACT)
T(RN,   0x1.a15a826109acep+62,    0x1.f36741f1e81ffp-1,  -0x1.559ef8p-2, INEXACT)
T(RN,   0x1.0ddfe7c147188p+62,   -0x1.eebefbb25bd02p-1,  -0x1.b597fcp-5, INEXACT)
T(RN,   0x1.0eddc9b3f959ep+62,    0x1.f0eb4c91bbb9fp-7,  -0x1.33cab4p-2, INEXACT)
T(RN,   0x1.2db4af36014e2p+62,    0x1.d604ae44d6343p-1,  -0x1.137cacp-2, INEXACT)
T(RN,   0x1.34fcf1c2e1ee8p+62,   -0x1.98c307e89f7b6p-1,  -0x1.c8c5f8p-2, INEXACT)
T(RN,   0x1.62fd8af45027fp+62,     0x1.fc0c58847af5p-1,  -0x1.99211cp-2, INEXACT)
T(RN,   0x1.10c98a5d33885p+62,    0x1.e268ccce6ed3dp-1,   0x1.fd838ap-3, INEXACT)
T(RN,   0x1.4ff12cd5cd29dp+63,   -0x1.9f0ae8a65a7e7p-1,  -0x1.a38324p-2, INEXACT)
T(RN,   0x1.48f30a0473f6ap+63,    0x1.cf6f642b9441dp-1,  -0x1.e05e5cp-5, INEXACT)
T(RN,   0x1.1e311aebfff65p+63,     0x1.4070026a9cebp-1,  -0x1.fdd3a2p-3, INEXACT)
T(RN,   0x1.80ce2ae5dd4b8p+63,     0x1.ef7c1585b4d7p-1,   0x1.5449fcp-6, INEXACT)
T(RN,   0x1.d2552bc1e45ecp+63,    0x1.dd77bbd84728ap-1,   0x1.9edceap-3, INEXACT)
T(RN,   0x1.3376236bf1ebcp+63,   -0x1.1d3c459852fc8p-1,   -0x1.b4cabp-2, INEXACT)
T(RN,   0x1.2545f96a09963p+63,    0x1.ff7a6bb776669p-1,   -0x1.623c6p-2, INEXACT)
T(RN,   0x1.804ec008dd14ap+63,   -0x1.c30fe7e9a2d12p-1,  -0x1.1e916ap-2, INEXACT)
T(RN,   0x1.23ad055ee886bp+63,   -0x1.c781f061b5fe2p-1,   0x1.ae21eap-2, INEXACT)
T(RN,   0x1.9af5b07fd3acep+63,    0x1.ef7a3ac65d6a4p-1,   0x1.c30f56p-2, INEXACT)
T(RN,   0x1.3664ab9adfb8bp+64,   -0x1.7869b4fbad3b9p-2,   0x1.7a7138p-2, INEXACT)
T(RN,   0x1.a7e0ad63b8e7ap+64,    0x1.fff5924ab9eb4p-1,  -0x1.94bcacp-2, INEXACT)
T(RN,   0x1.73179d502b15dp+64,    0x1.ffff36c948e34p-1,  -0x1.06db1cp-3, INEXACT)
T(RN,   0x1.5ed1c9e00add5p+64,    0x1.1368896a2a6bcp-1,   0x1.92e356p-2, INEXACT)
T(RN,   0x1.3033b8751efe7p+64,   -0x1.a6155deb6d081p-2,  -0x1.e3447cp-4, INEXACT)
T(RN,   0x1.1e668aafdd511p+64,   -0x1.fe20fa2fafc2ep-1,    0x1.88a7ap-2, INEXACT)
T(RN,   0x1.35a80341a623bp+64,    0x1.d1f878b0785b3p-1,   0x1.cb741ep-2, INEXACT)
T(RN,   0x1.43f536d171bedp+64,   -0x1.848e743f3211ap-1,   0x1.a34d12p-3, INEXACT)
T(RN,   0x1.5b994ca7b6211p+64,    0x1.e2c17e54b9599p-1,  -0x1.565e3cp-5, INEXACT)
T(RN,   0x1.b542343c54e81p+64,   -0x1.377ec642b4241p-2,  -0x1.99eb2ap-2, INEXACT)
T(RN,   0x1.1781c8a180509p+65,    0x1.1f03a1fece081p-2,   0x1.be7bc4p-5, INEXACT)
T(RN,   0x1.8d4914fc6f0eap+65,    0x1.9be0ce1df5ac6p-4,   0x1.51739ap-3, INEXACT)
T(RN,   0x1.4feb4e8fb4e4bp+65,    0x1.ff8f1198392c4p-1,  -0x1.e81b0cp-2, INEXACT)
T(RN,   0x1.c798c8ee74304p+65,   -0x1.cc52c4565406ap-1,   0x1.ce1168p-3, INEXACT)
T(RN,   0x1.3e8d9bce6f5dbp+65,   -0x1.d84582910cb4ap-1,  -0x1.28ce86p-3, INEXACT)
T(RN,   0x1.7715277d76d24p+65,     0x1.d0b21777e651p-1,   0x1.da2008p-3, INEXACT)
T(RN,   0x1.64ca668e835bep+65,   -0x1.df641f999a732p-1,    0x1.8d686p-2, INEXACT)
T(RN,   0x1.465bf59f5d7ccp+65,   -0x1.87e32e38e5d16p-2,   0x1.ee5f1ap-2, INEXACT)
T(RN,   0x1.0a003876afac9p+65,    0x1.ddcf9ab18668ap-2,  -0x1.5579b2p-2, INEXACT)
T(RN,   0x1.b14120e2befbcp+65,    0x1.ce14327aad964p-1,  -0x1.b7c34ep-2, INEXACT)
T(RN,    0x1.295b369f2bbep+66,   -0x1.694e874b43f6cp-3,   0x1.335f56p-2, INEXACT)
T(RN,   0x1.9a7583dd53ab5p+66,    0x1.245a94b7a8c78p-1,   -0x1.c6364p-2, INEXACT)
T(RN,   0x1.55ffbd55baa0ep+66,    0x1.5ea33b00f91f3p-1,  -0x1.19349ep-3, INEXACT)
T(RN,   0x1.0098e31cf49f1p+66,    0x1.1870883dbe79ap-1,    0x1.68067p-2, INEXACT)
T(RN,   0x1.371c6f5b0cf95p+66,   -0x1.419d9c5fc6ab5p-1,   -0x1.6a227p-4, INEXACT)
T(RN,   0x1.ca84ed643820ep+66,    -0x1.febbd386df8bp-1,   0x1.f2035ap-3, INEXACT)
T(RN,   0x1.24473e5cdd935p+66,    0x1.ee0729ae27d37p-1,  -0x1.d0fdfcp-6, INEXACT)
T(RN,   0x1.29ca8157464cap+66,   -0x1.dc9a1ee5ba6dfp-1,   0x1.51f538p-2, INEXACT)
T(RN,   0x1.264da412d9f0bp+66,    0x1.efa13951ae3b5p-1,  -0x1.12519ap-2, INEXACT)
T(RN,   0x1.219f81c8d9453p+66,   -0x1.21e56677229b3p-2,   0x1.f3b3dcp-3, INEXACT)
T(RN,    0x1.cfcfd8e36406p+67,    0x1.74edd1275858fp-1,  -0x1.24e74ap-6, INEXACT)
T(RN,   0x1.ad2a96463d37cp+67,   -0x1.dec36d1edcd7fp-1,   0x1.0ddd42p-2, INEXACT)
T(RN,   0x1.b9a87a7b5fc5ep+67,    -0x1.d34e3beb95eep-2,   0x1.cb4cd6p-3, INEXACT)
T(RN,   0x1.fab189fd2d992p+67,    0x1.d795d71cbcc4dp-1,  -0x1.124242p-4, INEXACT)
T(RN,   0x1.6fe140aff21fcp+67,   -0x1.39eb35085b2b7p-3,   0x1.cfef64p-3, INEXACT)
T(RN,   0x1.6f95628800636p+67,    0x1.b56000bb04a79p-1,     0x1.524bp-4, INEXACT)
T(RN,   0x1.f9cebe1e48234p+67,    0x1.2da4a044e5d47p-1,   0x1.1425d4p-2, INEXACT)
T(RN,   0x1.439f63495786ap+67,    0x1.fe398090e203cp-1,   0x1.e8480cp-3, INEXACT)
T(RN,   0x1.57efb70987db1p+67,   -0x1.1c9474d1767b6p-4,   0x1.8fda4ep-2, INEXACT)
T(RN,   0x1.381d8091fb233p+67,   -0x1.96f0dc009d4dcp-2,   0x1.4a404cp-4, INEXACT)
T(RN,   0x1.ba7b3638abbd2p+68,    0x1.dfb9775a94047p-2,  -0x1.bf86d4p-7, INEXACT)
T(RN,    0x1.083ea9b39393p+68,   -0x1.89e1dd6796dcap-1,  -0x1.19100ap-3, INEXACT)
T(RN,   0x1.61b2229a48cdap+68,    0x1.36fe41f160ecap-2,  -0x1.5435b6p-2, INEXACT)
T(RN,   0x1.0f5f26dd1d49fp+68,    -0x1.e963b27a04aap-1,   0x1.5d9edcp-2, INEXACT)
T(RN,   0x1.5c3274efa1f0dp+68,    0x1.354d7d178fa83p-3,   0x1.3821dcp-4, INEXACT)
T(RN,   0x1.fe1bab61ff6e8p+68,   -0x1.e681233abd19dp-1,    0x1.75443p-3, INEXACT)
T(RN,   0x1.a66ae8e16e10cp+68,     0x1.f0c6c5348cedp-2,   0x1.f301c6p-2, INEXACT)
T(RN,   0x1.94295dd309c43p+68,   -0x1.0bbf88933cdedp-2,   0x1.eeb7dap-5, INEXACT)
T(RN,   0x1.d2818bed849e4p+68,   -0x1.ea676f88e2612p-1,   0x1.2a0326p-2, INEXACT)
T(RN,   0x1.954f782807703p+68,   -0x1.b7e11fe8ceec4p-1,   0x1.0a4abep-4, INEXACT)
T(RN,   0x1.4261b34b39963p+69,   -0x1.841354940fdacp-4,  -0x1.f6c64ep-2, INEXACT)
T(RN,   0x1.db699d8e87dd3p+69,   -0x1.82199897e35b4p-2,   0x1.9cd568p-3, INEXACT)
T(RN,   0x1.6ad5c25a71f91p+69,     -0x1.df68803b7eep-2,   0x1.66649cp-2, INEXACT)
T(RN,   0x1.2b7d7efdfb482p+69,   -0x1.67bb96abbbe6dp-3,   0x1.2cf7fep-3, INEXACT)
T(RN,   0x1.b956d8402f892p+69,    0x1.d83eb418e95eep-3,   0x1.fd2cacp-3, INEXACT)
T(RN,   0x1.0a5f1a2717242p+69,    0x1.796b0786dcc9dp-2,   0x1.e1196ap-2, INEXACT)
T(RN,   0x1.078cde345ad11p+69,   -0x1.d9f5d0dfd7fc6p-1,   0x1.e02544p-3, INEXACT)
T(RN,   0x1.c7068da6c02abp+69,   -0x1.a3a2d5c7b2279p-1,   0x1.c1f512p-3, INEXACT)
T(RN,   0x1.bc710890d07c8p+69,     0x1.ec78e3fe66ddp-2,  -0x1.2b4818p-7, INEXACT)
T(RN,   0x1.bfa08f2fcf64dp+69,   -0x1.a94d608766fd3p-1,   0x1.2e27f6p-2, INEXACT)
T(RN,   0x1.edfa96cadb269p+70,   -0x1.7e00f34127254p-2,  -0x1.477a48p-2, INEXACT)
T(RN,   0x1.8c28b1df40488p+70,    0x1.516f1b6564eafp-2,   -0x1.8c9cap-3, INEXACT)
T(RN,   0x1.57614d54f0e49p+70,    0x1.ffffb1a0ed6f1p-1,    0x1.64f48p-3, INEXACT)
T(RN,   0x1.b0c0394672dd2p+70,    0x1.5192cef1e7b38p-1,   0x1.5c0336p-2, INEXACT)
T(RN,   0x1.1902e29281c25p+70,   -0x1.402907942ee8bp-1,   0x1.402338p-3, INEXACT)
T(RN,   0x1.546edbdbf05e4p+70,    -0x1.67f13a1a05d8p-1,   0x1.d518eap-5, INEXACT)
T(RN,   0x1.2d514ca02dc78p+70,    0x1.e5fcbcc77913bp-1,  -0x1.707b54p-3, INEXACT)
T(RN,   0x1.b6fba3bea8ac2p+70,   -0x1.f5dbd382bd988p-1,  -0x1.44aacap-3, INEXACT)
T(RN,   0x1.51be7b96f31dbp+70,    0x1.9295f65d56e01p-1,   0x1.1c2b1cp-3, INEXACT)
T(RN,   0x1.9c0d7751b66d2p+70,    0x1.faed24a877bc5p-1,   0x1.aae996p-2, INEXACT)
T(RN,   0x1.f97fe99d9b3cdp+71,   -0x1.b1792029e970dp-1,  -0x1.01c6d8p-2, INEXACT)
T(RN,   0x1.0b5d8377d91cdp+71,   -0x1.161756af22a87p-4,   0x1.1aa416p-3, INEXACT)
T(RN,   0x1.491af4102f2dfp+71,    0x1.b97bb770345a3p-3,  -0x1.78763cp-2, INEXACT)
T(RN,   0x1.5b180d1945b62p+71,   -0x1.3518ad79b774ap-2,   0x1.ffd8bep-2, INEXACT)
T(RN,   0x1.8e5c06029f3d1p+71,   -0x1.87ea531ff56c8p-3,   0x1.46a868p-4, INEXACT)
T(RN,   0x1.d58b21c09df52p+71,    0x1.6e6c4b65af9dep-2,  -0x1.ae28dcp-3, INEXACT)
T(RN,   0x1.08609612972d5p+71,   -0x1.c99bfe3fdb473p-1,   -0x1.238c7p-2, INEXACT)
T(RN,   0x1.153c83e39bf3ap+71,    0x1.70a181f3dd336p-4,   0x1.cb1aacp-3, INEXACT)
T(RN,   0x1.751beae5ac94ep+71,    0x1.bc3cde371f3cap-2,   0x1.e1c014p-3, INEXACT)
T(RN,   0x1.cd1d9355b0e5ap+71,    0x1.a11120143d6efp-1,   -0x1.7bc42p-3, INEXACT)
T(RN,   0x1.9f72b85b4c4b8p+72,    0x1.f3849db902426p-1,   0x1.bdeb34p-2, INEXACT)
T(RN,   0x1.efd8d177f62d2p+72,   -0x1.7aa963a4aa865p-4,   0x1.25eac4p-3, INEXACT)
T(RN,   0x1.366c1451aa1d3p+72,   -0x1.af4a74c85595bp-1,   0x1.d62abap-2, INEXACT)
T(RN,   0x1.8e62db37e23d9p+72,    0x1.a7a5e843edbeap-3,   -0x1.02abap-2, INEXACT)
T(RN,   0x1.963932b511d3ep+72,    0x1.168c4967a0b78p-1,  -0x1.b5d2ccp-3, INEXACT)
T(RN,   0x1.35d9f0deea711p+72,    0x1.d1ff121d57faep-1,   0x1.408c1cp-2, INEXACT)
T(RN,   0x1.126e2089add21p+72,    0x1.30a7543b256cap-1,   0x1.3d801ep-4, INEXACT)
T(RN,   0x1.312d2793c7327p+72,   -0x1.ffffe2c84831fp-1,   0x1.b3ddaap-2, INEXACT)
T(RN,   0x1.192376b89f407p+72,    0x1.4d9902aaa1704p-3,   0x1.536ca6p-2, INEXACT)
T(RN,    0x1.afa70300aee6p+72,    0x1.7ff2934ad29a7p-1,  -0x1.0a22e2p-2, INEXACT)
T(RN,   0x1.f7950e964e19ap+73,   -0x1.221df843006e5p-1,    0x1.aa773p-4, INEXACT)
T(RN,   0x1.2404efa98cf76p+73,    0x1.23e69c514f6a2p-5,  -0x1.7f120ep-4, INEXACT)
T(RN,   0x1.27cebeb7d37d4p+73,    0x1.fadaf87a2acf5p-1,   -0x1.cfcf8p-4, INEXACT)
T(RN,   0x1.e8e83574b2ebcp+73,   -0x1.a006ddef751b5p-1,  -0x1.bad628p-3, INEXACT)
T(RN,   0x1.83d91907dbc77p+73,    0x1.e88959b100443p-1,  -0x1.f7e526p-3, INEXACT)
T(RN,   0x1.9db2ed525ef04p+73,   -0x1.486bf19730a38p-2,  -0x1.5afd34p-2, INEXACT)
T(RN,   0x1.142e021b9e16bp+73,   -0x1.dfa00445dfa83p-1,   0x1.999dfep-3, INEXACT)
T(RN,    0x1.12aaaea798b7p+73,   -0x1.de4ce231b13f9p-1,  -0x1.13ae04p-2, INEXACT)
T(RN,    0x1.b96be4b7cac3p+73,     0x1.8bac9e2dd27dp-1,   0x1.593356p-2, INEXACT)
T(RN,   0x1.707cbf959affep+73,   -0x1.adf5dc27e9555p-1,   0x1.a161fap-2, INEXACT)
T(RN,   0x1.51fea22e7c57dp+74,   -0x1.a683e92f7a4cbp-1,  -0x1.80b18ap-4, INEXACT)
T(RN,   0x1.1072023241158p+74,   -0x1.07281ad9d7f77p-2,  -0x1.1bcde2p-3, INEXACT)
T(RN,   0x1.dc422d7c5d5a9p+74,   -0x1.fe87851dc5539p-1,   0x1.8c687ap-4, INEXACT)
T(RN,   0x1.f710a0a597dc8p+74,    0x1.2c145386069cdp-1,  -0x1.c12f34p-5, INEXACT)
T(RN,   0x1.2c3951009c0dap+74,    0x1.fa572e76f5654p-1,    0x1.20f18p-4, INEXACT)
T(RN,   0x1.e64a7f88150cep+74,    0x1.a6bf42f0b1ef9p-1,  -0x1.2a7df8p-2, INEXACT)
T(RN,   0x1.bc3af895fa788p+74,    0x1.c54125e50535dp-2,   0x1.20733ap-2, INEXACT)
T(RN,   0x1.e1b03dd4d77a8p+74,    0x1.c6d3a99a794cap-1,    0x1.82bcfp-2, INEXACT)
T(RN,   0x1.83ac792b06d85p+74,    0x1.79c01dbb16663p-2,   0x1.f8d3a8p-3, INEXACT)
T(RN,   0x1.2b840d9c570f4p+74,   -0x1.4b97492621718p-1,  -0x1.162ea2p-6, INEXACT)
T(RN,   0x1.67ea8c0e3b47ep+75,    0x1.d4e5a56dcc91dp-2,  -0x1.9d36b6p-2, INEXACT)
T(RN,   0x1.82d7c667cc3acp+75,   -0x1.7e4cc8b5a74f6p-2,    0x1.67285p-2, INEXACT)
T(RN,   0x1.9cf6476f09b91p+75,   -0x1.e4791d15bcb94p-1,  -0x1.b1af66p-2, INEXACT)
T(RN,   0x1.b0d8dad3d27ecp+75,   -0x1.5870089b638afp-3,  -0x1.dbe11cp-2, INEXACT)
T(RN,   0x1.6a5c8aabd073ap+75,   -0x1.3c3c7aa89aebbp-1,   0x1.812ac2p-2, INEXACT)
T(RN,    0x1.13eabc7f227cp+75,    0x1.2fa5a7835158ep-3,   0x1.fd41fcp-5, INEXACT)
T(RN,   0x1.d1516b691b3fap+75,    0x1.3aaea2f675b55p-3,    0x1.32f6cp-7, INEXACT)
T(RN,   0x1.933cc85010a59p+75,    0x1.f9b7bbd2b40efp-1,   0x1.21295cp-3, INEXACT)
T(RN,   0x1.2394064da3251p+75,   -0x1.04506d90736d6p-3,  -0x1.74531ap-3, INEXACT)
T(RN,   0x1.31a08a05eaf32p+75,    0x1.482877f4e05e1p-1,  -0x1.6e3994p-3, INEXACT)
T(RN,   0x1.b1ad4d9fdb7eep+76,    0x1.d903f89b94b35p-1,   0x1.c0ac96p-4, INEXACT)
T(RN,   0x1.e877986570324p+76,    0x1.fcd01c7125826p-1,  -0x1.825152p-2, INEXACT)
T(RN,   0x1.a13c20c43e738p+76,   -0x1.1fe551439012bp-3,   0x1.c5e4b2p-2, INEXACT)
T(RN,   0x1.42eb9614a820ap+76,    0x1.5c0632dbdd29dp-1,  -0x1.aebcbep-2, INEXACT)
T(RN,   0x1.3985f195efc35p+76,   -0x1.02362e57cd574p-2,   0x1.b097b6p-3, INEXACT)
T(RN,    0x1.2e633a9bbb34p+76,    0x1.ed2ff6a4e0098p-2,   0x1.aa414ep-2, INEXACT)
T(RN,   0x1.fa2cc7ac2af88p+76,    0x1.8f03f1bd8cbf3p-1,   0x1.bf7d2ep-2, INEXACT)
T(RN,   0x1.627223cfeb27ap+76,   -0x1.f539b2b539ec7p-1,   0x1.0be832p-2, INEXACT)
T(RN,   0x1.4f14c66b11cb5p+76,     0x1.64b6550bec02p-5,  -0x1.1c1398p-2, INEXACT)
T(RN,   0x1.c0ab14ae8fe19p+76,   -0x1.3d73a7d1102bfp-1,   0x1.0ce7a4p-3, INEXACT)
T(RN,   0x1.4ac3a6ac7dc3cp+77,   -0x1.9f5d14d0c1a0dp-1,  -0x1.95f7dcp-5, INEXACT)
T(RN,   0x1.4a46344b5bcbap+77,   -0x1.858102dba5b27p-1,   0x1.04ae5cp-5, INEXACT)
T(RN,   0x1.1cfe9a2445de8p+77,   -0x1.1d269b65a71b5p-2,    0x1.610fbp-4, INEXACT)
T(RN,    0x1.e2b25d0bed52p+77,    0x1.ff36f1eb5d2d3p-2,   0x1.3a7d88p-3, INEXACT)
T(RN,   0x1.b8e0ee2c75326p+77,    0x1.0242ed476915bp-1,   0x1.08c0c6p-2, INEXACT)
T(RN,   0x1.cba84c67e3b1ap+77,    0x1.4ae82d54b404ap-1,   0x1.e8cb72p-2, INEXACT)
T(RN,   0x1.e0b918a27ae4cp+77,   -0x1.f9aaca20fc2dap-1,   0x1.9c99b4p-7, INEXACT)
T(RN,   0x1.1f3e001417ed7p+77,   -0x1.8142b501ea565p-1,   0x1.7c3becp-4, INEXACT)
T(RN,   0x1.796da175a2ce5p+77,    0x1.ffec757907885p-1,    0x1.c677fp-2, INEXACT)
T(RN,   0x1.6a3b3ad7eebdbp+77,    0x1.20e18885b4aacp-1,   0x1.416824p-2, INEXACT)
T(RN,   0x1.8885cd93e805ep+78,    0x1.2f295aa8d185fp-2,   0x1.f657a6p-3, INEXACT)
T(RN,   0x1.91ab89a45d0a5p+78,   -0x1.97b31b6f2173ep-1,  -0x1.a61b1ap-2, INEXACT)
T(RN,   0x1.3865f8021fba9p+78,   -0x1.a15650664f416p-1,   0x1.f5ca56p-3, INEXACT)
T(RN,    0x1.50e9f30bde58p+78,   -0x1.ff091d2bb100fp-1,  -0x1.f482c4p-2, INEXACT)
T(RN,   0x1.185eb7fa39dadp+78,   -0x1.eb1273c079f45p-1,   0x1.e1ac66p-3, INEXACT)
T(RN,   0x1.38aecb1c3edc6p+78,    0x1.9c857363d7a99p-2,  -0x1.cdcc44p-6, INEXACT)
T(RN,   0x1.fecf69c5553eep+78,    0x1.ff2728652b86cp-1,  -0x1.956fd6p-2, INEXACT)
T(RN,   0x1.c107dc04957b4p+78,    0x1.ff74c320af94ap-1,   0x1.edc00ep-5, INEXACT)
T(RN,   0x1.16f4059599a3bp+78,    0x1.f83221c3dad4dp-1,  -0x1.40930cp-2, INEXACT)
T(RN,   0x1.30b49517e65e4p+78,    0x1.e4a4c99880c0dp-1,  -0x1.957bdep-3, INEXACT)
T(RN,   0x1.2bee5b4278219p+79,   -0x1.fa10e37055fafp-1,  -0x1.923124p-2, INEXACT)
T(RN,    0x1.ac298ffed43dp+79,   -0x1.ebe85d04b7016p-1,  -0x1.394726p-2, INEXACT)
T(RN,   0x1.cc8024b7c7592p+79,    0x1.f4301ea54c914p-1,  -0x1.8c67b4p-2, INEXACT)
T(RN,   0x1.3de84f16e1c3cp+79,   -0x1.2fc1dfb6ac244p-1,    0x1.4f362p-4, INEXACT)
T(RN,   0x1.10ede3a4f9d4ap+79,    0x1.ffff40c31f045p-1,   0x1.57cd4ep-2, INEXACT)
T(RN,   0x1.a2b7b36556fa2p+79,   -0x1.0f8fd738735f2p-1,   0x1.62fb06p-3, INEXACT)
T(RN,   0x1.9f04587ce42e7p+79,   -0x1.c0c9d725673bcp-1,  -0x1.361516p-9, INEXACT)
T(RN,   0x1.a046662df9788p+79,   -0x1.d7be8460f6e2ep-2,   0x1.2386d6p-3, INEXACT)
T(RN,   0x1.3b7b4acf64c87p+79,   -0x1.fa579412dffbcp-1,  -0x1.32439cp-2, INEXACT)
T(RN,   0x1.c6b552750abdep+79,    0x1.4243b9c638dc8p-1,  -0x1.25f94cp-2, INEXACT)
T(RN,   0x1.e67ffd7f52eb8p+80,   -0x1.39525af979ebbp-1,  -0x1.d17ab6p-2, INEXACT)
T(RN,   0x1.74b91ff731dd3p+80,   -0x1.ecf4f96b51592p-1,   0x1.9b4818p-2, INEXACT)
T(RN,   0x1.760beba2403a5p+80,    0x1.584efcaec150dp-1,  -0x1.6001eep-4, INEXACT)
T(RN,   0x1.5c9620f83c954p+80,    0x1.fd4a037d216f5p-1,  -0x1.bb2dc2p-7, INEXACT)
T(RN,   0x1.8ef307d4b1286p+80,    0x1.f2f9eb6d116a2p-1,  -0x1.d26118p-4, INEXACT)
T(RN,   0x1.913995b225346p+80,    0x1.ff9751fcb4feep-1,   0x1.6c2ca6p-5, INEXACT)
T(RN,   0x1.fdce76db12cb6p+80,    0x1.39cecc1832a99p-2,  -0x1.45eec4p-2, INEXACT)
T(RN,   0x1.d8d6cecd76eecp+80,    0x1.c167005ee4b9fp-4,   0x1.cef4b4p-2, INEXACT)
T(RN,   0x1.6f282de67798ap+80,      0x1.d77c92d8e75p-1,  -0x1.1c1a78p-2, INEXACT)
T(RN,   0x1.f6f9fc3de21a4p+80,   -0x1.332a001500963p-1,   0x1.d1f9b6p-3, INEXACT)
T(RN,   0x1.5d725c9ad86cdp+81,    0x1.b8160027b71b8p-1,   0x1.2f42fap-2, INEXACT)
T(RN,   0x1.0c42449cc0df9p+81,    0x1.89cfbe5ce4ddap-4,   0x1.47a8b6p-2, INEXACT)
T(RN,   0x1.f5ea98b7cb822p+81,   -0x1.f7b2099b39f93p-1,   0x1.0e61c8p-2, INEXACT)
T(RN,   0x1.c1115e79c8956p+81,    0x1.4ba3e47989441p-1,   0x1.487124p-4, INEXACT)
T(RN,   0x1.875e57362f0d1p+81,    0x1.89394b68cbe9bp-1,   0x1.c40b7ap-2, INEXACT)
T(RN,   0x1.c88a2105f7aecp+81,    0x1.554c116b47824p-3,   0x1.9effbep-3, INEXACT)
T(RN,   0x1.26143ca98b19fp+81,   -0x1.4132af09f187fp-1,   0x1.3230c6p-5, INEXACT)
T(RN,    0x1.6842e0163c2ep+81,   -0x1.ebdfd96abe5dep-1,   0x1.43da5ep-2, INEXACT)
T(RN,   0x1.2acee3a0f4b1ep+81,    0x1.144620fbe742dp-1,  -0x1.742428p-2, INEXACT)
T(RN,   0x1.f00392f1c7c64p+81,    -0x1.ee15cb45f6dap-1,   0x1.d8baa4p-3, INEXACT)
T(RN,   0x1.2debbd97ae2fep+82,   -0x1.5dfc037bd2df8p-1,  -0x1.27b6cap-3, INEXACT)
T(RN,   0x1.542b54c254414p+82,    0x1.02a16b284ef31p-2,   0x1.649d9ap-2, INEXACT)
T(RN,    0x1.db2c8b8066bep+82,    0x1.d1e481740d1ebp-1,  -0x1.b988a4p-2, INEXACT)
T(RN,   0x1.c0b5bb24f389ep+82,    0x1.4f92e00c483c5p-2,  -0x1.70b7bap-2, INEXACT)
T(RN,   0x1.061bfd012ac82p+82,   -0x1.f127532dd4217p-1,   -0x1.a72e3p-2, INEXACT)
T(RN,   0x1.291621c502b3cp+82,    0x1.fff7f45352b0cp-1,  -0x1.3c3e5cp-2, INEXACT)
T(RN,   0x1.e24f66595e212p+82,    0x1.2fd479a3b97e7p-1,  -0x1.6962d4p-4, INEXACT)
T(RN,   0x1.5695f05cdefe7p+82,    0x1.b05157c569402p-5,  -0x1.65c404p-3, INEXACT)
T(RN,   0x1.8733afc33926cp+82,   -0x1.28782980757d3p-1,    0x1.fa116p-4, INEXACT)
T(RN,   0x1.d7b73001ab5a2p+82,   -0x1.6106388cd5305p-1,   0x1.33e0cep-2, INEXACT)
T(RN,   0x1.a8f6e7f2fdf92p+83,    0x1.8561379ae8d6ap-1,  -0x1.63b66ep-2, INEXACT)
T(RN,   0x1.d09371d4ad0abp+83,    0x1.70f87a65de59ap-1,   0x1.ec333ap-2, INEXACT)
T(RN,   0x1.d8ca11288dcaap+83,   -0x1.afbbc9c95b12dp-1,   0x1.0c2064p-2, INEXACT)
T(RN,   0x1.2a8fe8544a2cep+83,   -0x1.b9bff6c11b022p-1,   0x1.649f48p-6, INEXACT)
T(RN,   0x1.c86b830dd2504p+83,    0x1.ed5c8cade9937p-2,   0x1.77899ep-2, INEXACT)
T(RN,   0x1.4ba55981b780dp+83,    0x1.2713a5846beb2p-1,   0x1.24eb02p-2, INEXACT)
T(RN,    0x1.2e7547c8ffb6p+83,   -0x1.b9baed05a1c88p-1,   0x1.3abb5cp-2, INEXACT)
T(RN,   0x1.9b840397689a9p+83,    0x1.84f2944de1f51p-1,  -0x1.a39494p-4, INEXACT)
T(RN,   0x1.b7ea1a5c86997p+83,    0x1.fe26019b6bc67p-1,  -0x1.4ca4cap-3, INEXACT)
T(RN,   0x1.7c18e873e3598p+83,   -0x1.1ca91a8c0ca22p-1,   0x1.cf1ce6p-2, INEXACT)
T(RN,   0x1.acaa27e49f98ep+84,    0x1.f433a57b8ffddp-1,  -0x1.8549ecp-2, INEXACT)
T(RN,   0x1.c8672205006c2p+84,   -0x1.8eb7dfa2204c5p-2,  -0x1.b847a6p-3, INEXACT)
T(RN,   0x1.2c1b94dc8e736p+84,    0x1.01f89fa39609ap-2,    0x1.0817ap-2, INEXACT)
T(RN,   0x1.45d1025de2fd5p+84,    0x1.fea5b77d27c55p-1,  -0x1.6d4bbcp-3, INEXACT)
T(RN,   0x1.6603ab1644854p+84,   -0x1.49d3fb2d4c201p-1,  -0x1.7098b8p-2, INEXACT)
T(RN,   0x1.a0a07222adaaap+84,    0x1.0b17e63ed80fep-1,  -0x1.56ee46p-4, INEXACT)
T(RN,    0x1.54447cf7cb96p+84,   -0x1.03344a855e193p-1,  -0x1.2d18bap-3, INEXACT)
T(RN,   0x1.4f19f3deebe85p+84,    0x1.20e5fff076a8cp-1,  -0x1.754672p-5, INEXACT)
T(RN,   0x1.14ac9ad5d64bcp+84,    0x1.c1d95584c92f3p-1,   0x1.7ba488p-2, INEXACT)
T(RN,   0x1.8b6eeb91a5dd3p+84,    0x1.11dfa0d15999dp-1,  -0x1.595664p-3, INEXACT)
T(RN,   0x1.b0bc3fc1166eep+85,    0x1.c815b8a231a4ap-2,   0x1.0bb54ep-2, INEXACT)
T(RN,   0x1.14050581ee56ap+85,    0x1.1bfeb02f0f4c2p-1,  -0x1.c8490cp-4, INEXACT)
T(RN,    0x1.8f4f5c2fc214p+85,   -0x1.fb2b512d01ba2p-1,  -0x1.409e14p-3, INEXACT)
T(RN,   0x1.3fed3ac573b21p+85,   -0x1.9b6c3e118334bp-3,  -0x1.9592aep-2, INEXACT)
T(RN,    0x1.a7c52ca09a44p+85,    0x1.9d0ba2f4e0673p-1,   0x1.5998e4p-4, INEXACT)
T(RN,   0x1.6526790e77e4cp+85,    0x1.f6f0958dc3b9fp-1,   0x1.d83f74p-2, INEXACT)
T(RN,   0x1.e420c7f4c404bp+85,    0x1.17d27ae6c434ap-1,   0x1.df5d28p-2, INEXACT)
T(RN,   0x1.b52d4edf0286ap+85,    0x1.a46b61553ea96p-3,   0x1.cba34ep-3, INEXACT)
T(RN,   0x1.bb60173e2d7dep+85,    0x1.a94ed26317fcdp-1,   0x1.0bb4d6p-2, INEXACT)
T(RN,   0x1.bd3b20f91f786p+85,    0x1.dc907fad143c3p-1,  -0x1.b9813cp-7, INEXACT)
T(RN,   0x1.95f0de6d62624p+86,   -0x1.ffad3f270a366p-1,   0x1.7c7298p-4, INEXACT)
T(RN,   0x1.a86f692eb5f5bp+86,   -0x1.4561884aa7843p-3,    0x1.a00edp-2, INEXACT)
T(RN,   0x1.0f822124499f7p+86,    0x1.5dc88bdcb682ep-1,   0x1.b97018p-2, INEXACT)
T(RN,   0x1.54f4db030cabep+86,    0x1.f04a44a9500c6p-2,  -0x1.6edba2p-2, INEXACT)
T(RN,   0x1.8c0175afe478cp+86,    0x1.0c7d20fa1e14ap-1,   -0x1.274b5p-3, INEXACT)
T(RN,   0x1.4710ba2333683p+86,   -0x1.a4560da0e14f8p-5,  -0x1.5ecb0cp-2, INEXACT)
T(RN,   0x1.67d66b54487f4p+86,     0x1.f5f409931467p-1,  -0x1.b4571ap-2, INEXACT)
T(RN,    0x1.592f1176f098p+86,   -0x1.ffd7bc28ded92p-1, -0x1.77fca6p-10, INEXACT)
T(RN,   0x1.22000aa4b0349p+86,   -0x1.f8dc2f92c0ccbp-3,  -0x1.08e29cp-3, INEXACT)
T(RN,    0x1.92a1aad82192p+86,    0x1.6bb3972cd2d16p-2,  -0x1.3942a6p-5, INEXACT)
T(RN,   0x1.5a2731684d19bp+87,   -0x1.0fc2f4a4cdb49p-3,    0x1.54904p-4, INEXACT)
T(RN,    0x1.c6bc954f7e57p+87,   -0x1.283222bf43a3fp-4,   0x1.6920dcp-2, INEXACT)
T(RN,    0x1.c34c868d3db9p+87,   -0x1.91325c06c9dfap-3,  -0x1.864adep-2, INEXACT)
T(RN,   0x1.079512ae34ccdp+87,    0x1.9e08dbbc512f7p-2,  -0x1.0a0d8ap-4, INEXACT)
T(RN,   0x1.e1ca2eaf81672p+87,   -0x1.fe6c3a50ef1ccp-1,  -0x1.73af54p-2, INEXACT)
T(RN,   0x1.2b0eb72622e21p+87,   -0x1.6695a1fb62e1ep-1,   0x1.1f25acp-2, INEXACT)
T(RN,   0x1.4f1a43bb6b006p+87,   -0x1.a431802271834p-1,   0x1.ba002cp-4, INEXACT)
T(RN,   0x1.2927aff1d98a2p+87,    0x1.9dcbac17abb0ap-1,   0x1.dafb2ep-2, INEXACT)
T(RN,   0x1.6314ad2481454p+87,   -0x1.9c3929f0ed982p-3,   0x1.1fd486p-5, INEXACT)
T(RN,   0x1.ffc73944393cep+87,    0x1.ef197916cf284p-1,   0x1.a61d18p-5, INEXACT)
T(RN,   0x1.512e1602a3fb3p+88,    0x1.3b91897b47c9ap-1,   0x1.d25826p-2, INEXACT)
T(RN,   0x1.92711351db53cp+88,   -0x1.f223d0733e4acp-1,     0x1.ac1ap-2, INEXACT)
T(RN,   0x1.e3694731a66e7p+88,   -0x1.ffcf8ca701efdp-1,   0x1.96bcf6p-2, INEXACT)
T(RN,   0x1.a3b702edff69cp+88,   -0x1.9bbf640ec1ab9p-1,   0x1.965614p-4, INEXACT)
T(RN,   0x1.1ba808ed93596p+88,   -0x1.1aca70ff4deedp-2,   0x1.b40008p-2, INEXACT)
T(RN,   0x1.0489d4efb46a3p+88,    0x1.006e9d3e8ac43p-7,    0x1.b20ecp-2, INEXACT)
T(RN,   0x1.020cfba406081p+88,    0x1.c93ae8efb10e3p-7,  -0x1.4700bcp-5, INEXACT)
T(RN,   0x1.a83d79c785bf2p+88,    0x1.e1a8b51e4fc49p-1,  -0x1.2a3354p-2, INEXACT)
T(RN,   0x1.4093c7ccf3ef6p+88,    0x1.eeb7e185d2e7cp-1,  -0x1.4b1012p-2, INEXACT)
T(RN,   0x1.601cebd528ccep+88,   -0x1.6a817180c6f02p-1,  -0x1.a98708p-2, INEXACT)
T(RN,   0x1.1f9090dcd106cp+89,   -0x1.f17f5f609965ep-1,   0x1.54ac0cp-2, INEXACT)
T(RN,   0x1.a6f8d9f94f994p+89,    0x1.71062e38323dap-1,   -0x1.32e43p-2, INEXACT)
T(RN,   0x1.fc8cf239fa2f6p+89,   -0x1.ff8cf5e24bed6p-1,  -0x1.6c9dcap-4, INEXACT)
T(RN,   0x1.60d39d5b5dd57p+89,   -0x1.0f588ab48b433p-1,  -0x1.df84d2p-3, INEXACT)
T(RN,   0x1.fbd5fa6cda6b2p+89,    0x1.dae8266dcde9ep-1,    0x1.283c6p-3, INEXACT)
T(RN,    0x1.727d1f553cd4p+89,    0x1.faa1b11dba65ep-1,   0x1.257606p-2, INEXACT)
T(RN,   0x1.be4bbcbb83692p+89,    0x1.ea72c17c7c32ap-1,   0x1.8de314p-2, INEXACT)
T(RN,   0x1.8264db886992ep+89,   -0x1.9503719af8fe9p-1,  -0x1.44bfb4p-3, INEXACT)
T(RN,   0x1.2316b44b15a41p+89,   -0x1.fa7477096c22cp-1,   0x1.6d23e4p-7, INEXACT)
T(RN,   0x1.0ca61143ed2c8p+89,    0x1.57c874ec83679p-2,  -0x1.eca606p-2, INEXACT)
T(RN,   0x1.8f1f7f9748799p+90,   -0x1.2470845b8b65fp-1,  -0x1.91a7dep-4, INEXACT)
T(RN,   0x1.f91fa2a4e0566p+90,    0x1.1a51a9d04656cp-2,   0x1.7239dcp-3, INEXACT)
T(RN,   0x1.597156c8aa8fbp+90,    0x1.77a8be208116cp-1,   -0x1.8f6f9p-3, INEXACT)
T(RN,   0x1.2193e75b298b9p+90,   -0x1.d3953a1a44961p-1,   0x1.11642ap-4, INEXACT)
T(RN,   0x1.d5e691ebb19acp+90,    0x1.84b89a41000afp-1,  -0x1.0fa4d2p-2, INEXACT)
T(RN,   0x1.7c83f5ef99f82p+90,   -0x1.91ca71bf6b31ep-1,  -0x1.e3a33ep-2, INEXACT)
T(RN,   0x1.2226c5bbb5db7p+90,   -0x1.fc06d3bff7e23p-1,   0x1.2b97d6p-5, INEXACT)
T(RN,   0x1.81d6d94948afap+90,    0x1.bbeed38a11b58p-1,  -0x1.455476p-3, INEXACT)
T(RN,   0x1.b641bd9a73d29p+90,    0x1.ee349d8df320ap-1,  -0x1.2e9156p-2, INEXACT)
T(RN,   0x1.a2ef2bce5d127p+90,    0x1.fbea5a000f43ap-1,  -0x1.8fc132p-3, INEXACT)
T(RN,   0x1.d963c3ee663aap+91,    -0x1.17eeda979a4bp-2,    0x1.1d8bdp-4, INEXACT)
T(RN,   0x1.96edb0b3ffbbep+91,   -0x1.bd69712160d87p-1,   0x1.b49b36p-4, INEXACT)
T(RN,   0x1.819a642045823p+91,    0x1.6f61b2ace558ap-1,   0x1.2b54a2p-2, INEXACT)
T(RN,   0x1.3469770f31457p+91,    0x1.7a4d66c7af01ep-3,   0x1.cf1bdap-2, INEXACT)
T(RN,   0x1.8ef62d1f5d176p+91,    0x1.564a860d54f73p-2,    0x1.6e25bp-2, INEXACT)
T(RN,   0x1.5fca19a94e0d6p+91,    0x1.9d341d7256b64p-1,  -0x1.a3ce08p-2, INEXACT)
T(RN,   0x1.e1354a89ac114p+91,   -0x1.5ed357fc588b2p-1,   0x1.886af8p-2, INEXACT)
T(RN,   0x1.fa4a59f20ec84p+91,   -0x1.db9cb30041addp-1,  -0x1.285b8ap-4, INEXACT)
T(RN,   0x1.f82ee8706fa58p+91,    0x1.c39fe44378586p-1,  -0x1.d58706p-4, INEXACT)
T(RN,   0x1.9a685cd50a1f2p+91,     0x1.c850fd26c1ecp-1,   0x1.8a5658p-8, INEXACT)
T(RN,   0x1.f65541dbe90cep+92,    -0x1.9fb3aaf75432p-1,    0x1.2a988p-2, INEXACT)
T(RN,   0x1.1cd2494df96a6p+92,   -0x1.c72abcff62b15p-1,   0x1.1d5f9ep-5, INEXACT)
T(RN,   0x1.84c7b34029da6p+92,    0x1.fde69cf664b72p-2,   0x1.c261ccp-4, INEXACT)
T(RN,   0x1.d12eca68044c9p+92,   -0x1.361c926381f7bp-2,  -0x1.bbc0f8p-4, INEXACT)
T(RN,   0x1.b15f6a6299042p+92,   -0x1.f03a4e3fbb9d8p-1,   0x1.d3759ep-4, INEXACT)
T(RN,   0x1.ee153993b6c65p+92,   -0x1.ccb69a89ef3bfp-1,  -0x1.709384p-2, INEXACT)
T(RN,   0x1.612c7cdb4064ap+92,    0x1.3886a70300c7bp-1,   0x1.effaf8p-7, INEXACT)
T(RN,   0x1.c7918326217ccp+92,    0x1.1432f97e927c6p-1,  -0x1.70575cp-3, INEXACT)
T(RN,   0x1.6100c3ee49da6p+92,    0x1.c9de09e465545p-5,  -0x1.32bad2p-2, INEXACT)
T(RN,   0x1.909c3161c7f22p+92,    0x1.14184e3d43176p-1,   0x1.62ab8ep-5, INEXACT)
T(RN,   0x1.9ee876cc0620fp+93,    0x1.caac6f7121699p-1,  -0x1.cf01d2p-2, INEXACT)
T(RN,   0x1.7979a93a868c8p+93,   -0x1.e36d7aaaaa82cp-4,  -0x1.448a02p-2, INEXACT)
T(RN,   0x1.802ef9e7b5d38p+93,    0x1.fd16df9f592cep-5,   0x1.c0a264p-3, INEXACT)
T(RN,   0x1.fd3f4b62fbf3cp+93,   -0x1.fe1d1749cea98p-1,   0x1.ddad9cp-3, INEXACT)
T(RN,   0x1.1fd3b81aa1b52p+93,    0x1.8dc2f5261895cp-1,   0x1.5e4b86p-2, INEXACT)
T(RN,   0x1.e07d0976fe48ap+93,    0x1.0f62275b85917p-3,  -0x1.410bd2p-5, INEXACT)
T(RN,   0x1.b782667d3053ep+93,   -0x1.e23d522924bcdp-1,   0x1.74972cp-2, INEXACT)
T(RN,   0x1.e297aeaf93b4ap+93,   -0x1.2fd8e59e6c41bp-1,   0x1.94be0ep-4, INEXACT)
T(RN,   0x1.e0e522fbdefb9p+93,     0x1.6008c229fb03p-1,   0x1.95e882p-6, INEXACT)
T(RN,   0x1.6b14f76494066p+93,    0x1.0a854083e4e28p-4,   0x1.d0e1acp-2, INEXACT)
T(RN,   0x1.61e454d48a863p+94,    0x1.6cb0247b8b1edp-2,   0x1.9f4faep-4, INEXACT)
T(RN,   0x1.ef6574bd92355p+94,   -0x1.d4af42fc62d4dp-2,  -0x1.bc1322p-7, INEXACT)
T(RN,   0x1.9f4e65613f33cp+94,   -0x1.c7aa9d4190143p-1,   0x1.6bef3ep-4, INEXACT)
T(RN,   0x1.9eb023a298c9ap+94,    0x1.78e047d1abff9p-2,  -0x1.99db86p-2, INEXACT)
T(RN,   0x1.0700b00eb0ccap+94,   -0x1.feb265ca8aca7p-1,   0x1.73d7cep-2, INEXACT)
T(RN,   0x1.d248a55a8ed58p+94,   -0x1.8100547fd827bp-1,  -0x1.d28386p-2, INEXACT)
T(RN,    0x1.fcfd4ee61008p+94,   -0x1.8ae92b7c32f0bp-1,   0x1.f23d94p-3, INEXACT)
T(RN,   0x1.32ed66879eb4cp+94,    0x1.db729a9e530e2p-2,   -0x1.5639bp-4, INEXACT)
T(RN,   0x1.1293c460f3a93p+94,   -0x1.f91d4210b3a2dp-1,  -0x1.d58f8ep-2, INEXACT)
T(RN,   0x1.d8b9c121c1e46p+94,    0x1.4828a2f8f3ae7p-1,   0x1.7eeb64p-2, INEXACT)
T(RN,   0x1.fb61d52142facp+95,    0x1.fddca2ef1448ap-1,  -0x1.366b24p-3, INEXACT)
T(RN,   0x1.a7efbb9aa3026p+95,   -0x1.a65afeb32dd0bp-1,   0x1.ffb7cep-4, INEXACT)
T(RN,   0x1.4fb2bef8ee328p+95,   -0x1.d808fa3fba57bp-1,  -0x1.9e819cp-4, INEXACT)
T(RN,   0x1.45a0a0bd3f70ap+95,   -0x1.01ab9629cfd18p-1,  -0x1.197934p-2, INEXACT)
T(RN,   0x1.fd1837fbd6202p+95,     0x1.e9a736182e49p-1,   0x1.8a5f06p-3, INEXACT)
T(RN,   0x1.19f895391fde6p+95,   -0x1.ab49d380fef8fp-2,    -0x1.7067p-4, INEXACT)
T(RN,   0x1.59d6206cbd9b4p+95,   -0x1.8058d1cc48965p-2,  -0x1.d57c9ep-5, INEXACT)
T(RN,   0x1.fb9ed33244976p+95,   -0x1.c40c23b70763dp-4,   0x1.8419a4p-4, INEXACT)
T(RN,   0x1.4cef73b067d7ep+95,    0x1.dfc791b385888p-1,   0x1.8378e8p-2, INEXACT)
T(RN,   0x1.da2171522c1c6p+95,   -0x1.f4cbcd8bd639fp-1,    0x1.a9dd6p-3, INEXACT)
T(RN,   0x1.3dd6596095babp+96,   -0x1.d78347548ff4ep-1,   0x1.e21aa8p-2, INEXACT)
T(RN,   0x1.759b2b6c8844ap+96,   -0x1.4bd8059847759p-1,  -0x1.ec9056p-2, INEXACT)
T(RN,   0x1.70f576d9debaap+96,   -0x1.fca70f5b06598p-1,   0x1.280c52p-2, INEXACT)
T(RN,   0x1.48a29d79adabcp+96,   -0x1.550d84d36af65p-1,    0x1.d8596p-2, INEXACT)
T(RN,   0x1.7d3f417821062p+96,   -0x1.c5b7495517976p-1,  -0x1.c541cap-2, INEXACT)
T(RN,   0x1.2c9db2d53cf89p+96,   -0x1.c751b0ab65522p-1,   0x1.dd3b64p-2, INEXACT)
T(RN,   0x1.a5c141aac5258p+96,    0x1.00de73f0706f9p-1,  -0x1.1425d4p-3, INEXACT)
T(RN,   0x1.10259086c80bap+96,    0x1.e428fdd30276ap-3,  -0x1.36a70cp-2, INEXACT)
T(RN,   0x1.40b2238401646p+96,    0x1.f4f82dbdbfc14p-1,   -0x1.d2769p-4, INEXACT)
T(RN,   0x1.298e0f741e5d6p+96,   -0x1.ffffb29f09f7dp-1,  -0x1.21d462p-4, INEXACT)
T(RN,   0x1.a541022b18ff6p+97,    0x1.9499cbeba1aa7p-1,   0x1.262ae2p-3, INEXACT)
T(RN,   0x1.2aea2bc48f41ap+97,   -0x1.44a0a618fec38p-1,  -0x1.ee6812p-2, INEXACT)
T(RN,    0x1.ef6f469b497ep+97,    0x1.d582bb5fab188p-1,   0x1.312c6cp-2, INEXACT)
T(RN,   0x1.24214859329b9p+97,   -0x1.c2aab20db018cp-1,   0x1.f47bb4p-2, INEXACT)
T(RN,   0x1.6d1fcc8cc06d7p+97,    0x1.227ac8afef43cp-4,   0x1.569afcp-3, INEXACT)
T(RN,    0x1.7cf5418f3434p+97,   -0x1.942ea8c24f383p-2,  -0x1.e3a24ap-4, INEXACT)
T(RN,   0x1.3188446083239p+97,    0x1.ca5d101589b1fp-5,   0x1.1f306cp-4, INEXACT)
T(RN,   0x1.77e57fc595f1bp+97,   -0x1.bf94fa551910ap-1,  -0x1.f3b70cp-4, INEXACT)
T(RN,   0x1.d5716f3f37cecp+97,    0x1.b010b1c402d9ep-2,    0x1.609d6p-2, INEXACT)
T(RN,   0x1.70fbae880ae46p+97,    0x1.abb37be5a4dbcp-2,  -0x1.9b88dap-3, INEXACT)
T(RN,   0x1.e0df63e868564p+98,    0x1.b67b6703cbbf6p-1,   0x1.678294p-2, INEXACT)
T(RN,   0x1.f1baeb5f94ea8p+98,    0x1.c7e54020a769dp-4,   -0x1.bbc96p-3, INEXACT)
T(RN,   0x1.dee3f16171fd3p+98,   -0x1.5051619d17096p-2,   0x1.cea0b2p-2, INEXACT)
T(RN,   0x1.c8eb2eedf8636p+98,   -0x1.ffff010ed23d7p-1,  -0x1.8c38a6p-4, INEXACT)
T(RN,   0x1.0b04f0289ee0dp+98,   -0x1.7be11d525350fp-1,  -0x1.d4f41ep-2, INEXACT)
T(RN,   0x1.90e979d1d4f86p+98,    0x1.2084d13e09a86p-6,   0x1.2072f2p-2, INEXACT)
T(RN,   0x1.7197bf2d4ee58p+98,    0x1.701c8ad4f657dp-1,  -0x1.4de95ep-2, INEXACT)
T(RN,   0x1.e8a95df07687ep+98,    0x1.fbae144f99881p-1,   0x1.8417acp-2, INEXACT)
T(RN,   0x1.656e44da242a9p+98,   -0x1.6c396845a11f7p-1,  -0x1.249c16p-2, INEXACT)
T(RN,   0x1.4e8ac9f0c3c87p+98,    0x1.3ba4a921c8fd1p-1,  -0x1.8e799ep-2, INEXACT)
T(RN,   0x1.5c035021183e2p+99,   -0x1.6e56d98aff756p-1,  -0x1.bac05cp-2, INEXACT)
T(RN,   0x1.e67b788014eacp+99,    0x1.fdf1d790e55d7p-1,   0x1.e245eap-3, INEXACT)
T(RN,   0x1.4bf6541e423e4p+99,   -0x1.c71bc6235b074p-1,  -0x1.9d0e9ep-4, INEXACT)
T(RN,   0x1.f3cb171bcd8e9p+99,    -0x1.3d0dac79b11cp-1,   0x1.ba2d84p-3, INEXACT)
T(RN,   0x1.588264fe33fa8p+99,   -0x1.1c1d230a88306p-2,   0x1.81e682p-2, INEXACT)
T(RN,   0x1.d797930ab5c8cp+99,   -0x1.6bc1ba6009d45p-1,  -0x1.85a858p-3, INEXACT)
T(RN,   0x1.8d22f9b466a0ep+99,    -0x1.1348e8cbfa6ap-2,  -0x1.0b9c76p-3, INEXACT)
T(RN,   0x1.89b1ee7139d3cp+99,   -0x1.ef393616fe34ep-1,  -0x1.dfd7bcp-2, INEXACT)
T(RN,   0x1.8d2dcbe6df1c4p+99,   -0x1.646e2a1e6fa04p-1,  -0x1.82c058p-2, INEXACT)
T(RN,   0x1.50418dc115fdcp+99,    0x1.778f1abb9b5e1p-1,   0x1.5eb874p-2, INEXACT)
T(RN,  0x1.e6de94f8fbde2p+100,    0x1.9efc57f82607bp-2,  -0x1.504dfcp-2, INEXACT)
T(RN,  0x1.b7f15299716aap+100,   -0x1.fbdca6e6c882ap-1,   0x1.29b9bap-3, INEXACT)
T(RN,  0x1.562c8502d06cep+100,   -0x1.d32a4ae44d1d7p-1,  -0x1.d86cb8p-3, INEXACT)
T(RN,  0x1.7cfd9c25622c8p+100,   -0x1.f631aa4f091a4p-1,  -0x1.4a20cap-2, INEXACT)
T(RN,  0x1.5611f33735ff8p+100,   -0x1.6c101bf405569p-1,   0x1.ea5254p-5, INEXACT)
T(RN,  0x1.ac5533ecb695cp+100,    0x1.88862cf55d115p-2,   0x1.00f48ap-4, INEXACT)
T(RN,  0x1.fe12fff55d552p+100,    0x1.ff8f9cd8d66a2p-1,  -0x1.d3b80ep-3, INEXACT)
T(RN,  0x1.6d260aa8a4648p+100,   -0x1.cfc9724d24688p-1,   0x1.dfb09cp-3, INEXACT)
T(RN,  0x1.16e34fd54430ap+100,    0x1.dfc20828a68f4p-1,   -0x1.4b595p-3, INEXACT)
T(RN,  0x1.e77009ef63274p+100,   -0x1.cb5f87cdeb8e7p-1,   0x1.7f4da8p-2, INEXACT)
T(RN,  0x1.0731e2522d32fp+101,     0x1.3b6da2fca616p-2,  -0x1.63a8fcp-2, INEXACT)
T(RN,  0x1.70b58bbfb9625p+101,    0x1.d411e8f847b7dp-1,    0x1.78e88p-2, INEXACT)
T(RN,  0x1.e37fb7c1a26ccp+101,    0x1.3bc17024860e5p-1,   0x1.3f1caap-2, INEXACT)
T(RN,  0x1.65325f6ed2a9cp+101,    0x1.d4787052dd193p-1,   0x1.40e9aap-5, INEXACT)
T(RN,  0x1.f18437a7edcdcp+101,   -0x1.70b5ab43d032dp-5,  -0x1.c37d88p-4, INEXACT)
T(RN,  0x1.d6f5dec2c6f42p+101,    0x1.ff845bdc86fdcp-1,  -0x1.abd84ep-3, INEXACT)
T(RN,  0x1.1313b895ed659p+101,    0x1.a4f8a547f48b6p-1,   0x1.1896d4p-2, INEXACT)
T(RN,   0x1.aaa610dcb96dp+101,   -0x1.d48c94d190118p-2,  -0x1.3b433ap-2, INEXACT)
T(RN,  0x1.6818e35fc8c66p+101,    0x1.f7a234f536e8ap-2,  -0x1.6d69d8p-4, INEXACT)
T(RN,  0x1.65c530b7f200dp+101,    0x1.e4cd8f54f1557p-1,   0x1.6485e2p-2, INEXACT)
T(RN,  0x1.9a190212410c6p+102,    0x1.b44c66bd69771p-1,  -0x1.01bc58p-4, INEXACT)
T(RN,  0x1.9ba503c2c8f09p+102,   -0x1.624f52d24882dp-2,   0x1.308228p-2, INEXACT)
T(RN,  0x1.2ee14981ff53fp+102,   -0x1.bfabf2cc6f2cap-1,  -0x1.2cb272p-3, INEXACT)
T(RN,  0x1.4fa384f1f0253p+102,    -0x1.f1ea8fdc28dcp-4,   0x1.766eccp-3, INEXACT)
T(RN,  0x1.5dc91546e5372p+102,   -0x1.bc888fb752708p-1,  -0x1.4fa354p-2, INEXACT)
T(RN,  0x1.4aaf754546467p+102,    0x1.6fcea7a87791bp-1,  -0x1.d2be5ep-3, INEXACT)
T(RN,  0x1.1c569fe0cb804p+102,    0x1.7e77c226cd795p-4,  -0x1.2d7678p-5, INEXACT)
T(RN,  0x1.ccb02134dac4ap+102,    0x1.b8a757157d363p-1,  -0x1.85542ep-2, INEXACT)
T(RN,  0x1.8cd885cc90884p+102,    0x1.7cc7a5868ce3bp-1,  -0x1.88ec76p-2, INEXACT)
T(RN,   0x1.70dd1b776b0fp+102,   -0x1.e3158bbf59a7cp-1,  -0x1.19236cp-2, INEXACT)
T(RN,  0x1.0947a149c8e3ap+103,   -0x1.0ac1045f1c82dp-5,  -0x1.f2a862p-3, INEXACT)
T(RN,  0x1.586459d99da1ep+103,   -0x1.ffb14a6469a59p-1,  -0x1.bcf7fcp-2, INEXACT)
T(RN,  0x1.22db69cef819ep+103,   -0x1.5d841d7211e4fp-1,  -0x1.84d30cp-2, INEXACT)
T(RN,  0x1.d75b4d379efd6p+103,    0x1.f1a8d4e038d3dp-1,   -0x1.d1a7dp-6, INEXACT)
T(RN,  0x1.176e653b3f3d3p+103,   -0x1.2edc69bf77207p-1,  -0x1.e392dcp-2, INEXACT)
T(RN,  0x1.942e21c384e06p+103,   -0x1.04a29f70b55ebp-2,    -0x1.0e2cp-2, INEXACT)
T(RN,  0x1.0b73e2429cae9p+103,    0x1.fb65a775bbed1p-1,  -0x1.9a887ap-2, INEXACT)
T(RN,  0x1.0607a5959e40ap+103,    0x1.dfd0360430d79p-1,   0x1.1853fep-2, INEXACT)
T(RN,  0x1.f15b6c561497cp+103,    0x1.c1c29cc693b72p-3,  -0x1.e13d4cp-5, INEXACT)
T(RN,  0x1.60492a3a445fbp+103,    0x1.a5267000ae277p-2,   0x1.d58c34p-3, INEXACT)
T(RN,  0x1.78c075687f032p+104,   -0x1.c8d04d5620366p-5,  -0x1.7833d2p-2, INEXACT)
T(RN,  0x1.ff1adb3c0baecp+104,   -0x1.1a5515da133b8p-1,  -0x1.13fc2ap-3, INEXACT)
T(RN,  0x1.1aee98c231949p+104,    0x1.ca811c3f9a927p-2,   0x1.e58814p-3, INEXACT)
T(RN,  0x1.73fba811133cdp+104,   -0x1.e46017dda450fp-1,  -0x1.7a52b2p-2, INEXACT)
T(RN,  0x1.dcdb0f655f7c2p+104,   -0x1.ddb1231f5406ep-1,  -0x1.1ecd98p-3, INEXACT)
T(RN,  0x1.2de95124e650dp+104,   -0x1.3794e9dd5a226p-1,   0x1.ca340ep-6, INEXACT)
T(RN,  0x1.b5023689006fap+104,    0x1.64e37edebe65cp-2,  -0x1.d61044p-4, INEXACT)
T(RN,  0x1.ad99dc048fa7ep+104,   -0x1.7744c16a04afbp-2,  -0x1.6120b4p-3, INEXACT)
T(RN,  0x1.4439efefa108dp+104,   -0x1.f91db6b805169p-1,  -0x1.73ed72p-4, INEXACT)
T(RN,  0x1.fc2d9d889e4d2p+104,   -0x1.f24a3f7a94b41p-1,  -0x1.5a338ap-3, INEXACT)
T(RN,  0x1.ed099c5b3bd3cp+105,    0x1.1c5305ef9c3e6p-1,   -0x1.95d89p-3, INEXACT)
T(RN,  0x1.bca6ca791351ap+105,   -0x1.0ef7a351c519cp-3,  -0x1.86926ap-2, INEXACT)
T(RN,  0x1.898b3b0dddad9p+105,      0x1.8957da960fcp-2,  -0x1.e9d468p-3, INEXACT)
T(RN,  0x1.9ff241b2f6344p+105,    0x1.702a887b912e8p-1,  -0x1.e6875ep-2, INEXACT)
T(RN,  0x1.a65d398f1f274p+105,    0x1.7c9cbd5c2064bp-1,  -0x1.0f668ep-2, INEXACT)
T(RN,  0x1.1196694c56bc7p+105,   -0x1.ffa72ac392409p-1,   0x1.4a4232p-2, INEXACT)
T(RN,  0x1.dc7939ea202acp+105,   -0x1.fce03e945a122p-1,   0x1.7a809ap-2, INEXACT)
T(RN,  0x1.15ca09b232653p+105,    0x1.8f12e37017538p-1,    0x1.27f5bp-3, INEXACT)
T(RN,  0x1.c1fbe66bd03abp+105,    0x1.95ca99dea9cb8p-1,    0x1.299d4p-2, INEXACT)
T(RN,  0x1.af8335f8c17cep+105,    0x1.ca384a6d86866p-5,   0x1.05f7b6p-2, INEXACT)
T(RN,  0x1.c8c63bbef28bep+106,   -0x1.9ac12f6f549dcp-3,   0x1.3116d8p-2, INEXACT)
T(RN,  0x1.90bb120300aa2p+106,   -0x1.05024042adfc6p-1,  -0x1.b7fadep-2, INEXACT)
T(RN,  0x1.8a6fc4293ac82p+106,   -0x1.f1b0e71fc16aep-1,   0x1.5abdb2p-2, INEXACT)
T(RN,   0x1.3e6e2685bc27p+106,    0x1.3c4786dead7a8p-1,  -0x1.e8260ep-3, INEXACT)
T(RN,  0x1.656e5ac52e022p+106,   -0x1.a4486a75b4c7bp-1,   0x1.d24a66p-3, INEXACT)
T(RN,  0x1.5429c3c3ebbbfp+106,    0x1.5813a50b5f71ep-1,  -0x1.a5cf7ap-2, INEXACT)
T(RN,  0x1.74565d005daaap+106,   -0x1.f1fe76ab1b9abp-1,  -0x1.594562p-6, INEXACT)
T(RN,  0x1.210557c43c0d2p+106,    0x1.d50f448e11e4fp-5,  -0x1.430afcp-2, INEXACT)
T(RN,  0x1.44dd569a815bdp+106,    0x1.e0058541a7e8ep-1,  -0x1.a24b1ap-3, INEXACT)
T(RN,  0x1.e5ae971d0d426p+106,    0x1.c161eb8cc4fb9p-1,   -0x1.aa92bp-2, INEXACT)
T(RN,  0x1.bec205d512917p+107,    0x1.e9976263907a2p-1,  -0x1.641ac2p-3, INEXACT)
T(RN,  0x1.d96ee68557d6fp+107,   -0x1.ff22c4c6df247p-1,    0x1.cb079p-5, INEXACT)
T(RN,  0x1.721b44503bb54p+107,   -0x1.fee9af8eb5212p-1,  -0x1.829274p-5, INEXACT)
T(RN,  0x1.a4c0de3637872p+107,   -0x1.2f24d7abf792fp-1,   0x1.628a3cp-2, INEXACT)
T(RN,  0x1.4cbefc02bbf16p+107,   -0x1.f999c11bc987ep-1,   0x1.c0a762p-4, INEXACT)
T(RN,  0x1.6b998731cdf93p+107,   -0x1.feebd78740459p-1,   0x1.ab13d6p-2, INEXACT)
T(RN,  0x1.625f07c88887ep+107,   -0x1.fdad577a4d951p-1,   0x1.8c9d1ap-4, INEXACT)
T(RN,  0x1.684778909f652p+107,   -0x1.0e5a9411f0c69p-1,  -0x1.5a1bdcp-2, INEXACT)
T(RN,  0x1.5890a941fa23cp+107,    0x1.0cafceadc3128p-1,  -0x1.a20b6cp-5, INEXACT)
T(RN,  0x1.80683af6b365ep+107,   -0x1.a4111e0783e86p-1,   0x1.a30d42p-2, INEXACT)
T(RN,   0x1.acc5f98831edp+108,    0x1.a77c324ab0e65p-1,  -0x1.166c0cp-2, INEXACT)
T(RN,  0x1.eb160611fe692p+108,    0x1.d500e8ba465eep-8,  -0x1.45ef2cp-3, INEXACT)
T(RN,   0x1.97f9db724545p+108,    0x1.d5d962688085ep-1,  -0x1.16656ep-2, INEXACT)
T(RN,   0x1.4a6b6139d915p+108,    0x1.645e57c3f245dp-6,  -0x1.d29f5cp-2, INEXACT)
T(RN,  0x1.a60c86eb6c1c3p+108,   -0x1.b81648c70051bp-3,    0x1.7a681p-2, INEXACT)
T(RN,  0x1.5eaa817938418p+108,    -0x1.df1e429f0b07p-2,  -0x1.a763c2p-2, INEXACT)
T(RN,  0x1.1cc117eb107c7p+108,   -0x1.2d92c68d19cafp-2,    0x1.74a9dp-2, INEXACT)
T(RN,  0x1.1bd974308f9d9p+108,    0x1.49dc11ccec209p-1,   0x1.04f09ep-3, INEXACT)
T(RN,   0x1.b1898edf4db9p+108,    0x1.b30e347eb420cp-1,  -0x1.59f128p-3, INEXACT)
T(RN,  0x1.bd523565eb282p+108,   -0x1.f90805ec1a4f5p-1,   0x1.2c1d34p-2, INEXACT)
T(RN,  0x1.817230b5c24c8p+109,   -0x1.d1f220c1a29a1p-1,  -0x1.d165c8p-9, INEXACT)
T(RN,  0x1.e4a65cac8bab8p+109,    0x1.0c00582ca6f9fp-1,   0x1.da4778p-2, INEXACT)
T(RN,  0x1.f891c4d026791p+109,    0x1.1ee25ada2cb7ap-3,   0x1.050fe4p-3, INEXACT)
T(RN,  0x1.f5f325a9c3e98p+109,   -0x1.6a52140e8e4d8p-1,   0x1.01e1dep-2, INEXACT)
T(RN,  0x1.f2853597b4794p+109,    0x1.cd39305c23e91p-3,  -0x1.89e82ep-2, INEXACT)
T(RN,  0x1.c1fa832566403p+109,   -0x1.75487ea1bfbabp-2,  -0x1.c4f7b2p-2, INEXACT)
T(RN,   0x1.546692210516p+109,    0x1.c7a04522b7eccp-1,   0x1.61bcaap-4, INEXACT)
T(RN,  0x1.0d1a48c0b84cbp+109,   -0x1.fea469a48deefp-1,   0x1.a15e9cp-2, INEXACT)
T(RN,  0x1.5e573f8a44af6p+109,   -0x1.2a0fa2b15aaf1p-5,  -0x1.ff484cp-2, INEXACT)
T(RN,  0x1.c1bc60053fed4p+109,    -0x1.602863bc22d7p-1,  -0x1.d6f3bcp-2, INEXACT)
T(RN,  0x1.643ed4d7fc764p+110,   -0x1.d791a4eeccfecp-1,  -0x1.b4b50cp-2, INEXACT)
T(RN,  0x1.79bc51bde67d4p+110,   -0x1.8025848c4fee5p-1,    0x1.bb1e8p-3, INEXACT)
T(RN,  0x1.99332725b5e64p+110,    0x1.e3e55a777c872p-1,  -0x1.cd5af2p-5, INEXACT)
T(RN,  0x1.a686a2ca0ae78p+110,   -0x1.ef0a4a6c9bb78p-2,   0x1.ec0d2cp-4, INEXACT)
T(RN,  0x1.b0c24e950d66bp+110,    0x1.2517d32ddc3b8p-1,   0x1.8a1272p-2, INEXACT)
T(RN,  0x1.a1c7be1642fcfp+110,    0x1.4f1506b38c77fp-1,   0x1.cb24b6p-2, INEXACT)
T(RN,  0x1.1285474bab9d9p+110,     0x1.a69d072c2c32p-1,  -0x1.1b7b74p-2, INEXACT)
T(RN,  0x1.21621128de3dep+110,   -0x1.4eda571f0a022p-2,    0x1.3510fp-4, INEXACT)
T(RN,  0x1.0d7a52ce1f5f1p+110,    0x1.bfe77e48a29aep-1,  -0x1.763e6ep-3, INEXACT)
T(RN,  0x1.00a3ee6ceba77p+110,    0x1.fe354e4d11829p-1,   0x1.f63954p-3, INEXACT)
T(RN,  0x1.0c51ce0a4331fp+111,   -0x1.228f8245eaa74p-1,  -0x1.b4fdd6p-3, INEXACT)
T(RN,  0x1.f21ef7a3f6c7ap+111,     0x1.8c3179b246ecp-1,   0x1.8ebe0ep-4, INEXACT)
T(RN,   0x1.88694268795ap+111,    0x1.e3afef1e6d6f1p-1,   0x1.460f52p-3, INEXACT)
T(RN,  0x1.3f681f045d86ap+111,    0x1.2f91bc9f59722p-1,   0x1.769f88p-2, INEXACT)
T(RN,  0x1.836642ad92ab2p+111,    0x1.f8eaca825e928p-1,  -0x1.404e62p-6, INEXACT)
T(RN,  0x1.2916887e8105fp+111,   -0x1.b06c78f6bf14bp-1,  -0x1.6612c4p-3, INEXACT)
T(RN,  0x1.fca7826da6821p+111,   -0x1.7a7228dfd35efp-1,  -0x1.76f336p-2, INEXACT)
T(RN,  0x1.31136802f3b96p+111,   -0x1.9a003f9baf085p-2,  -0x1.4fd37ep-2, INEXACT)
T(RN,  0x1.7e651f5bc5842p+111,    0x1.30534df8fcf6ap-1,  -0x1.e862cep-3, INEXACT)
T(RN,  0x1.8cf26a03c8658p+111,    0x1.1cb6619b0416ep-1,  -0x1.3410a8p-2, INEXACT)
T(RN,  0x1.15019add37dc3p+112,      0x1.c984b4798ecp-1,    0x1.e6b45p-2, INEXACT)
T(RN,  0x1.58dad954ca0b7p+112,   -0x1.764a69a0261c9p-3,   0x1.1baebep-2, INEXACT)
T(RN,  0x1.87d7b76709a0ap+112,   -0x1.ee7242caa0983p-2,  -0x1.894f9cp-2, INEXACT)
T(RN,  0x1.ea8060f4a03f5p+112,   -0x1.51f682aada1c3p-7,   0x1.6b5f16p-2, INEXACT)
T(RN,  0x1.35c3fd9f6f112p+112,    0x1.e8e9160d95c72p-2,  -0x1.64b3e8p-2, INEXACT)
T(RN,  0x1.7115f434fc347p+112,    0x1.35cbc6d56fbc7p-1,  -0x1.c00606p-3, INEXACT)
T(RN,  0x1.9e025b30516f6p+112,    0x1.ff39cf26aeec8p-1,  -0x1.9456f4p-3, INEXACT)
T(RN,  0x1.73c49c7147637p+112,   -0x1.db4119ba1676bp-3,  -0x1.2da284p-4, INEXACT)
T(RN,  0x1.be61b302dcbf6p+112,    0x1.2e4fb8f9ea546p-2,  -0x1.a769d4p-6, INEXACT)
T(RN,  0x1.2484015a76a7cp+112,    0x1.5041fe763be72p-1,   0x1.30249ap-2, INEXACT)
T(RN,   0x1.bf98879ffcfdp+113,   -0x1.ea9e285c289dep-1,   0x1.50d6ccp-3, INEXACT)
T(RN,  0x1.debbae599e248p+113,    0x1.9bc41d4a1ca87p-1,   0x1.3fe066p-2, INEXACT)
T(RN,  0x1.75322e0ba69c8p+113,   -0x1.fdf69331ca8d7p-3,  -0x1.58f9e6p-2, INEXACT)
T(RN,  0x1.82f3652f99bd4p+113,    0x1.2e19d5bade744p-2,  -0x1.9bc384p-2, INEXACT)
T(RN,    0x1.b29a3125688p+113,    0x1.f30af594548a6p-1,   0x1.be5fd8p-2, INEXACT)
T(RN,  0x1.ab71e3d99de12p+113,   -0x1.fe56170435d7ep-1,  -0x1.d2cfe2p-3, INEXACT)
T(RN,  0x1.afe9a37e68eeep+113,   -0x1.7c273a2acc96ep-1,   0x1.b81be2p-3, INEXACT)
T(RN,   0x1.0e95cb9e81dbp+113,    0x1.2ee5ceabc3e0fp-1,   0x1.1a8438p-3, INEXACT)
T(RN,  0x1.b665227cf2e0dp+113,    -0x1.5a4fc9cb498ep-3,   -0x1.8b477p-2, INEXACT)
T(RN,  0x1.b7088d35a5ac4p+113,    0x1.16e52c5fadc6ap-2,   0x1.130acep-2, INEXACT)
T(RN,   0x1.a193ae3ef53fp+114,   -0x1.a3f22969bd00bp-1,  -0x1.8f6312p-4, INEXACT)
T(RN,  0x1.b7ec12b8663f7p+114,   -0x1.8474c011d7afcp-2,  -0x1.109ceap-2, INEXACT)
T(RN,  0x1.fd71402befb8ep+114,   -0x1.0a22481ed26f4p-2,  -0x1.235fdep-2, INEXACT)
T(RN,  0x1.f0182c4670134p+114,    0x1.db92ccc80c593p-1,  -0x1.086718p-3, INEXACT)
T(RN,   0x1.7682678b94bbp+114,    0x1.26a0103c5a308p-1,  -0x1.b946ecp-2, INEXACT)
T(RN,  0x1.c0a8129a587b1p+114,   -0x1.cfe9b8702bfaap-2,  -0x1.6f34f4p-2, INEXACT)
T(RN,  0x1.853aeed202374p+114,    0x1.a054f6829e6dap-1,   0x1.cd284ep-3, INEXACT)
T(RN,  0x1.5fcb8c7309cecp+114,    0x1.f8f8fe88bd782p-1,  -0x1.4dfb4cp-2, INEXACT)
T(RN,  0x1.40579f6892974p+114,    0x1.1113fa67ba35ep-1,   0x1.165efep-2, INEXACT)
T(RN,  0x1.f1e96c0d51e75p+114,    0x1.e152472582313p-1,  -0x1.19f35cp-2, INEXACT)
T(RN,  0x1.cc6cbee3a18e3p+115,    0x1.28fc76aa1f43fp-5,   0x1.ae0356p-2, INEXACT)
T(RN,  0x1.442ddf1b230dap+115,    0x1.a881d51f62773p-2,  -0x1.35e9d4p-4, INEXACT)
T(RN,  0x1.e3e6ff21bb346p+115,   -0x1.b5ce179e3e8a7p-1,   0x1.e53e62p-3, INEXACT)
T(RN,  0x1.e2d548fbbab7fp+115,    0x1.a5fa023fdbc68p-2,   -0x1.38402p-2, INEXACT)
T(RN,   0x1.adf5ca261ca4p+115,   -0x1.8100609c9436ep-1,  -0x1.c56b78p-2, INEXACT)
T(RN,  0x1.d8ab1064bdf9cp+115,    0x1.f4ca7f75690b3p-1,   0x1.1349c8p-4, INEXACT)
T(RN,  0x1.36cadc093544cp+115,   -0x1.a4e985f7ef41cp-4,  -0x1.a7438ap-3, INEXACT)
T(RN,   0x1.ddfa3ca82628p+115,    0x1.b3d65ab5269c4p-1,  -0x1.aa1d9cp-2, INEXACT)
T(RN,  0x1.d6f181ddc6916p+115,    0x1.fea99b4df3df9p-1,  -0x1.e334bep-2, INEXACT)
T(RN,  0x1.f48e84e6fb2bdp+115,    0x1.d9ea836dfe403p-1,    0x1.e3881p-3, INEXACT)
T(RN,  0x1.79110d0f6125bp+116,   -0x1.3efe8aa7ace4dp-1,   0x1.6835dcp-2, INEXACT)
T(RN,   0x1.ab1af717da0bp+116,   -0x1.e7633ee43faa5p-1,  -0x1.245a0cp-2, INEXACT)
T(RN,  0x1.6420f5317da8fp+116,    0x1.19bf8eeac0048p-1,   0x1.86478ep-3, INEXACT)
T(RN,   0x1.d01c5124931cp+116,   -0x1.59c079a1b1db2p-1,   0x1.6f5e7ap-3, INEXACT)
T(RN,  0x1.4a7629babe6e7p+116,    0x1.b8a457bc7bcb3p-1,   0x1.58be72p-5, INEXACT)
T(RN,  0x1.6a1fbd08aef11p+116,    0x1.9a65daf98a46cp-3,   0x1.6862eap-2, INEXACT)
T(RN,  0x1.7b5681fd2854ep+116,   -0x1.b41a6b50ad689p-1,   0x1.d6407ap-3, INEXACT)
T(RN,  0x1.cfa3b902f1b4cp+116,    0x1.aa26acfd9c57cp-1,  -0x1.e3aa0ep-5, INEXACT)
T(RN,  0x1.5bce493ea0ff4p+116,   -0x1.f63b9c57fb7b7p-1,  -0x1.b705dep-2, INEXACT)
T(RN,   0x1.4c9280b44c74p+116,   -0x1.74f90d38f73e6p-3,   0x1.5016e2p-2, INEXACT)
T(RN,  0x1.02caa821d6007p+117,    0x1.ffec4081185e8p-1,  -0x1.2fe148p-2, INEXACT)
T(RN,  0x1.4eeb290070233p+117,    0x1.ff9c2d69edaaep-1,  -0x1.f952f6p-5, INEXACT)
T(RN,  0x1.141d07165296ep+117,    0x1.cb361333a535bp-2,   -0x1.ed718p-3, INEXACT)
T(RN,  0x1.b7a271095731ap+117,   -0x1.127201d29662ep-3,  -0x1.1d5614p-3, INEXACT)
T(RN,  0x1.1a91355f048fap+117,    0x1.b241867c19f24p-1,   0x1.979774p-4, INEXACT)
T(RN,  0x1.7fc6259107426p+117,   -0x1.bd348ad291c48p-3,   0x1.ba40a6p-2, INEXACT)
T(RN,  0x1.19ced0f232a59p+117,    0x1.876a3a3a0026cp-2,   0x1.9ffc08p-7, INEXACT)
T(RN,  0x1.a3458f5626122p+117,    0x1.18be658024c0cp-8,   0x1.98bec8p-8, INEXACT)
T(RN,  0x1.02066f5190766p+117,   -0x1.8769250df5bbcp-1,  -0x1.23c10ep-3, INEXACT)
T(RN,   0x1.fa408af03764p+117,    0x1.e1149dd7246d1p-1,   0x1.4b84d8p-7, INEXACT)
T(RN,  0x1.7422f159dbeefp+118,   -0x1.2c692f2272ffep-4,   0x1.546716p-3, INEXACT)
T(RN,  0x1.f087a2d29e678p+118,    0x1.6ee319119121ap-1,  -0x1.3b8e32p-3, INEXACT)
T(RN,  0x1.0d97f81f2d4edp+118,    0x1.224f4a0a4d47bp-1,   0x1.eee272p-3, INEXACT)
T(RN,    0x1.9b42f5080c9p+118,   -0x1.95a8d6b024c3ap-5,  -0x1.b440e2p-3, INEXACT)
T(RN,  0x1.08138ae3da357p+118,   -0x1.fe4794fe889fbp-1,  -0x1.6fd156p-3, INEXACT)
T(RN,   0x1.5242c671336bp+118,   -0x1.bce3220b92358p-1,   0x1.ecd948p-6, INEXACT)
T(RN,  0x1.8ad97e61d395ep+118,    0x1.c24ff0da5a7e1p-1,  -0x1.889522p-5, INEXACT)
T(RN,  0x1.5cde2e69079c4p+118,    -0x1.b37fa9e9feaep-2,  -0x1.59237ep-3, INEXACT)
T(RN,  0x1.0a32c956ca6cap+118,   -0x1.90aa1a99ceeafp-1,   0x1.376a14p-2, INEXACT)
T(RN,  0x1.a99883a800c9cp+118,   -0x1.4ccbfbbd38e86p-1,  -0x1.603628p-2, INEXACT)
T(RN,  0x1.446097c77ed79p+119,    0x1.e381073e9edb8p-1,   0x1.2a3de8p-3, INEXACT)
T(RN,  0x1.e67334a8e77d6p+119,    0x1.fcdbec95482cap-2,    0x1.6eb0fp-5, INEXACT)
T(RN,  0x1.2d41fb0438921p+119,    0x1.ac7be273d759ap-1,  -0x1.ba86e4p-2, INEXACT)
T(RN,  0x1.c917e359e66dbp+119,     0x1.767ac8ac21f3p-1,  -0x1.803418p-2, INEXACT)
T(RN,  0x1.82798e97f0e82p+119,   -0x1.b25168a57d2b7p-1,    0x1.82d96p-4, INEXACT)
T(RN,  0x1.724699c78f41fp+119,    0x1.3af1f23b9e9cap-1,  -0x1.401526p-2, INEXACT)
T(RN,  0x1.c2346fdadc0dap+119,    0x1.c53cf50e12721p-3,  -0x1.f5ae56p-3, INEXACT)
T(RN,  0x1.2ff27e65ab7f2p+119,    0x1.0cecfc0d9dc5ep-2,   0x1.86218ap-4, INEXACT)
T(RN,  0x1.635cda19ea533p+119,   -0x1.8ca31bc769f62p-1,   0x1.1f7736p-3, INEXACT)
T(RN,  0x1.831c366930a13p+119,    0x1.ee13b960ed18ap-1,   0x1.5d0254p-2, INEXACT)
T(RN,  0x1.2ad5d19d216e6p+120,   -0x1.f2ee4f507a734p-1,  -0x1.ccfdeap-2, INEXACT)
T(RN,  0x1.b70c4f0173effp+120,   -0x1.25c9b9cc111b5p-2,  -0x1.2241dcp-4, INEXACT)
T(RN,  0x1.9847142b02cc4p+120,    0x1.94df51f3fe6fep-1,  -0x1.61ec24p-2, INEXACT)
T(RN,  0x1.1912ddd705918p+120,    0x1.e2bbb99d9a603p-1,   0x1.a37e44p-2, INEXACT)
T(RN,  0x1.6dd5156ac7ecep+120,   -0x1.1ee64e9edea17p-1,   0x1.866956p-3, INEXACT)
T(RN,  0x1.fcbcb1d9b929ap+120,    0x1.9d0a6540919bfp-2,  -0x1.a67344p-3, INEXACT)
T(RN,  0x1.a027ed3e3431ep+120,   -0x1.d4da8f5546c76p-1,  -0x1.fb6932p-5, INEXACT)
T(RN,  0x1.6a8bb0844e7b7p+120,    0x1.fa54955403d6ap-1,   0x1.1e048cp-3, INEXACT)
T(RN,  0x1.2bcf23e90d576p+120,   -0x1.80c0637fe20d7p-2,   0x1.3ab1a6p-2, INEXACT)
T(RN,  0x1.aa64ebc25a8f8p+120,    0x1.e49917cd4ad71p-1,  -0x1.421a62p-3, INEXACT)
T(RN,  0x1.b26f18e7655b8p+121,   -0x1.ff5e9b60f740bp-1,  -0x1.51ef52p-4, INEXACT)
T(RN,  0x1.9db1d002e333cp+121,    0x1.fffd882b0a5c7p-1,    0x1.31056p-2, INEXACT)
T(RN,  0x1.caf77a3dbabc8p+121,   -0x1.3d558bd6ee62ap-2,   0x1.8b3466p-3, INEXACT)
T(RN,  0x1.8609fdc893d92p+121,    0x1.def95f2309953p-2,   0x1.44c5aep-2, INEXACT)
T(RN,  0x1.7bfe0c038f3a6p+121,   -0x1.7c1d28cd714b9p-1,  -0x1.f9fbe2p-2, INEXACT)
T(RN,  0x1.c8dd3b10ab448p+121,    0x1.01cb2c0d42549p-3,  -0x1.8260bep-2, INEXACT)
T(RN,  0x1.76d2bfd13eabcp+121,    0x1.bda9b7bfb1ee7p-2,   -0x1.02282p-2, INEXACT)
T(RN,  0x1.5c6726c5d4579p+121,   -0x1.6de2b0845f284p-2,  -0x1.6e2048p-2, INEXACT)
T(RN,  0x1.8240454b4fe2cp+121,   -0x1.d639ee6120048p-1,   0x1.665648p-2, INEXACT)
T(RN,  0x1.c0a2e4ec80e94p+121,    0x1.88f3575c56abcp-1,   0x1.d498bap-6, INEXACT)
T(RN,   0x1.3135c41510dap+122,    0x1.a8776bbe44e2dp-1,  -0x1.700964p-4, INEXACT)
T(RN,  0x1.4e94d7f5d77e1p+122,   -0x1.58bc20ca5f783p-1,  -0x1.d7decep-2, INEXACT)
T(RN,  0x1.f03834a4af6abp+122,     0x1.2aeeffe18c22p-2,   0x1.9837e4p-2, INEXACT)
T(RN,  0x1.ade19fe694cb7p+122,   -0x1.03f12bc09cb36p-2,   0x1.c7bc3ep-2, INEXACT)
T(RN,  0x1.ac913a769421bp+122,    0x1.99f8adfe8e294p-3,    0x1.95bc6p-2, INEXACT)
T(RN,  0x1.6397eeba64bb8p+122,    -0x1.d4f11497bc67p-2,  -0x1.c7d8e4p-2, INEXACT)
T(RN,  0x1.aa8bd9292b2c1p+122,   -0x1.f43245c3df2b3p-1,  -0x1.727e18p-8, INEXACT)
T(RN,  0x1.ae8b5bee53ecdp+122,    0x1.1b6803fce8cbcp-1,  -0x1.55b3bap-5, INEXACT)
T(RN,  0x1.35f6ed65600a2p+122,    -0x1.20a2be12591ep-2,    0x1.7db71p-2, INEXACT)
T(RN,  0x1.81c39a4d6ea24p+122,    0x1.a8c633f3db2b3p-1,  -0x1.4afb2ep-2, INEXACT)
T(RN,  0x1.c67d8ff344cfap+123,    0x1.083952c3a4899p-1,  -0x1.950e0cp-3, INEXACT)
T(RN,  0x1.991ff3335fe42p+123,    0x1.084d30e9d527ap-1,   0x1.5ae35cp-2, INEXACT)
T(RN,  0x1.b99712ded7d5ap+123,    0x1.d211e9b32ab22p-2,   0x1.e361b8p-5, INEXACT)
T(RN,   0x1.83db49f74008p+123,   -0x1.3ac4450129866p-3,  -0x1.e7e11cp-3, INEXACT)
T(RN,  0x1.2d98dc8a7a8e6p+123,   -0x1.fbf5268df33d3p-1,   0x1.ea9b68p-2, INEXACT)
T(RN,  0x1.120a5c7621328p+123,    0x1.8ebf7d101f232p-3,   -0x1.d136dp-2, INEXACT)
T(RN,  0x1.9a2b548c7b414p+123,    0x1.d34bcd51d2068p-1,  -0x1.49d022p-2, INEXACT)
T(RN,  0x1.4ec1ff44bb43fp+123,    0x1.d0acc7607ffddp-1,  -0x1.575868p-3, INEXACT)
T(RN,  0x1.852ea0203b056p+123,    0x1.e6907c9e8f897p-1,   0x1.b38cc4p-2, INEXACT)
T(RN,  0x1.37a7631a81f1ep+123,    0x1.b9af950020e6cp-1,   0x1.bf936ep-2, INEXACT)
T(RN,  0x1.6ea1c98bcbdd8p+124,    0x1.f4362e1e48153p-1,  -0x1.93f432p-2, INEXACT)
T(RN,  0x1.7e55b720ce5c5p+124,   -0x1.0de1d554b5948p-1,   0x1.8155e4p-3, INEXACT)
T(RN,  0x1.994188663682dp+124,    0x1.f593e6dc9e88fp-1,  -0x1.a3b6a8p-2, INEXACT)
T(RN,  0x1.56c65eeaf15b9p+124,   -0x1.1011c80eb2499p-1,   0x1.4adafcp-5, INEXACT)
T(RN,  0x1.f364a04a8e814p+124,   -0x1.e175be7b827bdp-2,   0x1.f8a8f8p-3, INEXACT)
T(RN,  0x1.105bcde9a01ccp+124,   -0x1.2d9bc90917a61p-1,  -0x1.19b2b6p-5, INEXACT)
T(RN,  0x1.2a477c3da61e6p+124,     0x1.25c15ec2bc2ap-1,  -0x1.5ef39ap-5, INEXACT)
T(RN,  0x1.34f121d98add1p+124,    0x1.18a844fa07537p-1,    0x1.6e181p-4, INEXACT)
T(RN,  0x1.5b5cfad52614dp+124,    0x1.3abf36343c565p-1,   0x1.d0e684p-3, INEXACT)
T(RN,  0x1.3c79ee519932fp+124,   -0x1.1d4dd9414d0adp-2,  -0x1.49acc6p-3, INEXACT)
T(RN,  0x1.173b273abcd68p+125,    0x1.df571825ace34p-1,  -0x1.8d5886p-2, INEXACT)
T(RN,  0x1.6f70948958e2ap+125,   -0x1.4a83bd59c45c2p-1,   -0x1.0bebdp-3, INEXACT)
T(RN,  0x1.8919a5138680fp+125,    0x1.ff0a2bb2eaf17p-1,   0x1.906f42p-3, INEXACT)
T(RN,  0x1.7d7f37e3c7412p+125,    0x1.9b560e21bdba6p-1,   0x1.9b78c2p-2, INEXACT)
T(RN,  0x1.949c71d89e48ap+125,   -0x1.4b4b019671e3bp-1,   0x1.67b498p-3, INEXACT)
T(RN,  0x1.56f9e43e52bcap+125,    0x1.6de6b4c829a71p-2,   -0x1.89515p-2, INEXACT)
T(RN,  0x1.2a77f9cb100cap+125,    0x1.f0347f930d0c8p-1,   0x1.d0df6cp-2, INEXACT)
T(RN,  0x1.a4fab02ed99d6p+125,    0x1.fffa3b0e2b948p-1,  -0x1.8841dcp-2, INEXACT)
T(RN,  0x1.216f8557c552fp+125,   -0x1.074f079e966cap-1,  -0x1.6f4a7ap-3, INEXACT)
T(RN,  0x1.80e2b5df26d5ep+125,   -0x1.f5afbbc597396p-5,  -0x1.61aedep-2, INEXACT)
T(RN,  0x1.17487fa4dbc8ep+126,     0x1.a876a49f2754p-1,   0x1.61f6dap-2, INEXACT)
T(RN,  0x1.dbb9e36b0092cp+126,   -0x1.710f2ffb41a72p-1,   0x1.40840ep-4, INEXACT)
T(RN,  0x1.01dc1e66cebd3p+126,    0x1.e938deb047d81p-1,    0x1.92287p-4, INEXACT)
T(RN,  0x1.1fa9dc9eb91e4p+126,    0x1.dab0a44ff2addp-2,   0x1.cdf262p-5, INEXACT)
T(RN,  0x1.24041b96dab71p+126,    0x1.eb857ea116c2ep-1,   0x1.4189eep-2, INEXACT)
T(RN,  0x1.f1606ca9e97f2p+126,   -0x1.0b0cf9401aeddp-2,   0x1.9f26ecp-3, INEXACT)
T(RN,  0x1.a8ace492381a4p+126,    0x1.146e65361219ap-7,   0x1.d56fd8p-2, INEXACT)
T(RN,  0x1.d49a52151e562p+126,    0x1.95e36892676a4p-2,   0x1.fca656p-5, INEXACT)
T(RN,  0x1.43d660a9c362fp+126,    0x1.0a77af118f7a3p-4,  -0x1.5b8df4p-2, INEXACT)
T(RN,   0x1.72c1b0b52a77p+126,   -0x1.638243bd47e7cp-2,   0x1.1e4816p-3, INEXACT)
T(RN,  0x1.54ba0c6d7fa11p+127,   -0x1.663716a2593f2p-1,   0x1.c17e1ep-2, INEXACT)
T(RN,  0x1.76884a557a4b9p+127,   -0x1.fb42c403ecf34p-1,  -0x1.b3c3d8p-5, INEXACT)
T(RN,  0x1.432abccb6b117p+127,    0x1.63e7ed7aefe8bp-3,   0x1.4fd3e4p-2, INEXACT)
T(RN,  0x1.6c4043e336e96p+127,   -0x1.4a9f73d946635p-1,   -0x1.e47efp-9, INEXACT)
T(RN,  0x1.26f002e94d487p+127,   -0x1.896fdaa4d6389p-6,  -0x1.7ef0aep-2, INEXACT)
T(RN,  0x1.c76c3585136b8p+127,    0x1.2aae2e3916c73p-2,  -0x1.6bceecp-2, INEXACT)
T(RN,  0x1.cf84f14ea10e2p+127,    0x1.e8ad782af53dap-1,   0x1.fb8dfep-2, INEXACT)
T(RN,  0x1.76ab655936f8ap+127,     0x1.ff520ebd1933p-1,  -0x1.4999f8p-3, INEXACT)
T(RN,  0x1.44525e873cfcep+127,   -0x1.51a8353dea54ep-1,   0x1.9c7d32p-2, INEXACT)
T(RN,  0x1.4080db397c60ep+127,     0x1.97f5c7191066p-1,   0x1.cfff6cp-2, INEXACT)
T(RN,  0x1.857b01486d82fp+128,   -0x1.0ef49d71b9e64p-1,   -0x1.7571ep-2, INEXACT)
T(RN,  0x1.cefb528636c6ap+128,   -0x1.872ff917df0e1p-1,   -0x1.1ae1dp-2, INEXACT)
T(RN,  0x1.2a0aeaa9e2164p+128,    0x1.2c39612148126p-3,   0x1.f4d05cp-3, INEXACT)
T(RN,  0x1.abc3fc19a0abcp+128,   -0x1.718878025a5ecp-5,   0x1.f9053ep-4, INEXACT)
T(RN,  0x1.be8b8489352fep+128,    0x1.f95ac5755e69bp-1,  -0x1.c05abep-4, INEXACT)
T(RN,  0x1.de6f166fd29bbp+128,   -0x1.8d872d9ff8504p-1,  -0x1.de9728p-4, INEXACT)
T(RN,  0x1.cfc823dff288cp+128,    0x1.658677a2686e8p-1,  -0x1.c888cep-4, INEXACT)
T(RN,  0x1.b3172c03c8abap+128,   -0x1.f53fedd1e01d3p-1,   -0x1.abb95p-2, INEXACT)
T(RN,  0x1.ba13547f586a9p+128,   -0x1.fa20687c7b7dap-1,  -0x1.7b9918p-2, INEXACT)
T(RN,  0x1.62fb2d7ae01d7p+128,   -0x1.a0b66d397d636p-3,  -0x1.d8b15cp-2, INEXACT)
T(RN,  0x1.7577801920526p+129,    0x1.13390545e0123p-2,   -0x1.1b2abp-3, INEXACT)
T(RN,  0x1.4acb76a8c0566p+129,   -0x1.1367a03f33248p-3,  -0x1.6731b8p-2, INEXACT)
T(RN,  0x1.4b4463f4a544ep+129,     0x1.08322605223ap-6,  -0x1.7e51b6p-2, INEXACT)
T(RN,  0x1.4fc38e2826032p+129,    0x1.fcd19266dfe6bp-1,  -0x1.7c3732p-3, INEXACT)
T(RN,  0x1.955fb01be1b53p+129,    0x1.4e4db98649381p-2,  -0x1.08d036p-2, INEXACT)
T(RN,  0x1.6b58082f60d45p+129,    0x1.dd0ef7997463ep-1,  -0x1.42364ap-3, INEXACT)
T(RN,  0x1.95a6ab4eb4b11p+129,   -0x1.50742c19c2d0cp-1,  -0x1.50f81ap-3, INEXACT)
T(RN,  0x1.a037ecb089124p+129,    0x1.47f5b5ffcf96ap-1,    0x1.db6d3p-2, INEXACT)
T(RN,  0x1.8504460be0332p+129,   -0x1.a65a0856a648dp-2,   0x1.0dd848p-3, INEXACT)
T(RN,  0x1.5aabf02d778e1p+129,    0x1.8df2ae0f4836ap-1,  -0x1.2074a4p-2, INEXACT)
T(RN,  0x1.d342e01248786p+130,    -0x1.e9edd360ae1bp-1,   -0x1.d1935p-2, INEXACT)
T(RN,  0x1.2bfc23cfabb09p+130,     0x1.0953316d24d9p-2,  -0x1.30e8f2p-5, INEXACT)
T(RN,  0x1.3540289803834p+130,   -0x1.7824d92ee91c9p-2,   0x1.2cc7e4p-2, INEXACT)
T(RN,  0x1.a08151b24193ep+130,   -0x1.fbb975ba1ee26p-1,   0x1.e81242p-3, INEXACT)
T(RN,  0x1.585ff365089f7p+130,   -0x1.9a45e7cb32f39p-2,   -0x1.1fc24p-2, INEXACT)
T(RN,  0x1.01edbf52d3091p+130,   -0x1.febda09793dddp-1,   0x1.faf8fep-5, INEXACT)
T(RN,  0x1.a532ae1204a7ep+130,   -0x1.4955eeb3ad411p-1,    0x1.44903p-3, INEXACT)
T(RN,  0x1.7e0a06d8d969ap+130,    0x1.211766cf3f56ap-1,  -0x1.306b66p-3, INEXACT)
T(RN,  0x1.2f49eae2ea376p+130,    0x1.e71f73eedc18bp-2,    0x1.b99e5p-2, INEXACT)
T(RN,  0x1.260d94fa48d5bp+130,    0x1.d7199d43372f8p-1,  -0x1.b432ccp-4, INEXACT)
T(RN,  0x1.b34187bc1111cp+131,   -0x1.fecd14b05e10ap-1,   -0x1.c3809p-2, INEXACT)
T(RN,  0x1.977a78aeea158p+131,    0x1.e3628da15bf66p-1,   0x1.2c1c92p-2, INEXACT)
T(RN,  0x1.9dcbcbdf11858p+131,   -0x1.f64ba489192e7p-1,  -0x1.de7632p-5, INEXACT)
T(RN,  0x1.752c48d3dc545p+131,   -0x1.41b768daa277ep-5,   0x1.4ff028p-2, INEXACT)
T(RN,   0x1.ffd13e3bb29fp+131,   -0x1.51cccdf853887p-2,   0x1.a7d736p-5, INEXACT)
T(RN,  0x1.e3109e775cbd9p+131,   -0x1.fdafc3af85c82p-1,   0x1.9c14cap-2, INEXACT)
T(RN,  0x1.e60760ebe36ebp+131,    0x1.61919d59c6792p-1,  -0x1.bd1522p-3, INEXACT)
T(RN,  0x1.84ed73ea2bfc8p+131,   -0x1.44253746e8511p-3,   -0x1.d0d6fp-3, INEXACT)
T(RN,  0x1.802aedd729a81p+131,   -0x1.fa9d0cb304d2bp-1,   0x1.caae48p-3, INEXACT)
T(RN,  0x1.f37ffe67324b6p+131,    0x1.d9aeaf4e5750ep-1,  -0x1.aae084p-2, INEXACT)
T(RN,  0x1.156a125ff8f52p+132,   -0x1.7ca5f8cc17338p-3,   0x1.debbf8p-6, INEXACT)
T(RN,  0x1.248830d3752a5p+132,    0x1.140f8d5c7bbf2p-1,  -0x1.ff6b5cp-2, INEXACT)
T(RN,  0x1.d26c72c677dbcp+132,    0x1.245df10b209e3p-1,  -0x1.526c64p-3, INEXACT)
T(RN,  0x1.2bf10072c2c39p+132,   -0x1.3044477c6dc95p-1,  -0x1.34d846p-4, INEXACT)
T(RN,  0x1.59dfd00bf57aap+132,     0x1.1f00f3e3eb68p-4,   0x1.f35d74p-5, INEXACT)
T(RN,  0x1.77a9810b60abfp+132,   -0x1.afdece6042bbap-1,  -0x1.d431b4p-2, INEXACT)
T(RN,  0x1.71f88d441c51fp+132,    0x1.6b3e9ccf4c2c8p-3,  -0x1.4c7f6ap-2, INEXACT)
T(RN,  0x1.bd3c51f1be66bp+132,   -0x1.b6f8650394b0cp-1,   0x1.540e4cp-5, INEXACT)
T(RN,  0x1.e426f0f794ee2p+132,   -0x1.fc3bc92d607cfp-1,  -0x1.d95a22p-2, INEXACT)
T(RN,  0x1.49b23bf32e335p+132,    0x1.fb949c9c656acp-1,   0x1.032462p-6, INEXACT)
T(RN,  0x1.28be8249161d4p+133,   -0x1.34b481dab7673p-1,   0x1.d5d202p-4, INEXACT)
T(RN,  0x1.68b0dc4303ef4p+133,   -0x1.bc2ce79063081p-1,  -0x1.9c4aaap-7, INEXACT)
T(RN,  0x1.60d02c54047ccp+133,    0x1.e08270a1181a8p-3,  -0x1.b333c6p-3, INEXACT)
T(RN,  0x1.19e460f208a98p+133,    0x1.262759b68be0bp-1,   0x1.c91c64p-2, INEXACT)
T(RN,   0x1.2b29d429a1c7p+133,    0x1.fbd6708f0a235p-1,  -0x1.9b708ap-2, INEXACT)
T(RN,  0x1.4376ae6c821aap+133,   -0x1.c1533ef062983p-1,  -0x1.d4cecep-4, INEXACT)
T(RN,   0x1.e6fa2433780ap+133,   -0x1.fb6450f46d792p-1,  -0x1.1bf318p-2, INEXACT)
T(RN,  0x1.c9983578c170ap+133,    0x1.eb94047ca660fp-1,    0x1.276a4p-3, INEXACT)
T(RN,  0x1.6c7b8417c7e5ep+133,    0x1.f54f3b917e8cdp-1,   0x1.178636p-5, INEXACT)
T(RN,  0x1.598cacffa70aap+133,    -0x1.d1ea7d5a0ac6p-1,   0x1.0a358ep-2, INEXACT)
T(RN,  0x1.249bb58640445p+134,   -0x1.801ea0aaf7331p-2,   0x1.5dac0ap-2, INEXACT)
T(RN,  0x1.d4118df91c2e2p+134,    0x1.99839bc89c29ap-2,   0x1.755f3cp-3, INEXACT)
T(RN,   0x1.2f4a52e25a3dp+134,    0x1.359cb7477a721p-1,  -0x1.b525ecp-3, INEXACT)
T(RN,   0x1.40b9480dc974p+134,   -0x1.bd23bfaa5c0fbp-1,  -0x1.3b4cdap-3, INEXACT)
T(RN,  0x1.fe891bbae98fdp+134,    -0x1.b5e6d09b591fp-2,  -0x1.a3471ep-3, INEXACT)
T(RN,    0x1.b8902f194ddp+134,     0x1.47dc18a2b143p-1,  -0x1.a2bed2p-6, INEXACT)
T(RN,  0x1.159735ef06d6cp+134,    0x1.f72a062414606p-1,   0x1.e11836p-3, INEXACT)
T(RN,  0x1.b87d3a423311cp+134,    0x1.2ed3902429dcdp-2,  -0x1.57719cp-9, INEXACT)
T(RN,  0x1.38d6bad3ba636p+134,    0x1.a1f7260f92b66p-1,   0x1.47492ep-4, INEXACT)
T(RN,  0x1.3d35e56a99731p+134,    0x1.e6d1d12186823p-1,  -0x1.8ab98ep-2, INEXACT)
T(RN,  0x1.4db1ae590ed38p+135,    0x1.9b4f10cd432b7p-1,  -0x1.35af54p-5, INEXACT)
T(RN,  0x1.abebf9ae807c4p+135,    -0x1.f792a75c3a78p-4,  -0x1.8a020ap-2, INEXACT)
T(RN,  0x1.008042118f499p+135,    0x1.a674ba0b34b64p-3,   -0x1.b4f3dp-3, INEXACT)
T(RN,  0x1.e5d8e20012b4fp+135,   -0x1.b8d776e270093p-1,   0x1.b6c20cp-2, INEXACT)
T(RN,  0x1.97d808e61fa56p+135,   -0x1.fe036fc61f79fp-1,   0x1.3b3f5cp-8, INEXACT)
T(RN,  0x1.9d8062dbfc2a6p+135,   -0x1.6c2f0d034e191p-3,   0x1.e2fb4ap-3, INEXACT)
T(RN,  0x1.1d7ba603e70f9p+135,   -0x1.b45e06c1fe1c6p-3,    0x1.3df94p-4, INEXACT)
T(RN,  0x1.f5b0370577925p+135,    0x1.67110caf297c9p-3,  -0x1.5489c4p-2, INEXACT)
T(RN,   0x1.c784ecd97e79p+135,   -0x1.d4106396e409dp-1,   0x1.f35a28p-4, INEXACT)
T(RN,  0x1.267f92c0124fdp+135,    0x1.432fb47403fc1p-1,  -0x1.8f2fcap-2, INEXACT)
T(RN,  0x1.f052ef487f208p+136,   -0x1.7a6c72056a182p-1,   0x1.0f55fap-2, INEXACT)
T(RN,  0x1.890392b168cdap+136,    0x1.c9ba2610c886dp-1,   0x1.02e004p-2, INEXACT)
T(RN,  0x1.d42af0c001bebp+136,   -0x1.99980f2d16a81p-1,   0x1.b951fep-3, INEXACT)
T(RN,   0x1.b231a283ab12p+136,    0x1.e0215f2c7ec8fp-1,   0x1.9ed13ap-2, INEXACT)
T(RN,  0x1.d9d69912bcefep+136,    0x1.8e7f093187771p-2,  -0x1.c59a0cp-2, INEXACT)
T(RN,  0x1.0b45d363e1887p+136,   -0x1.724530262e3b2p-1,  -0x1.028e3ep-3, INEXACT)
T(RN,  0x1.35aea5952495ep+136,   -0x1.625f5ab0458acp-3,  -0x1.0a7e0cp-4, INEXACT)
T(RN,  0x1.f78b88fd3e439p+136,    0x1.45fe2f52a8effp-1,  -0x1.88565ep-2, INEXACT)
T(RN,  0x1.b2c13bfeee62ep+136,   -0x1.a3a0b86ec01c9p-4,    0x1.243dap-2, INEXACT)
T(RN,  0x1.af1b7cbba77bcp+136,    0x1.912447cea93cep-1,   0x1.4a4af6p-3, INEXACT)
T(RN,  0x1.2defedb6a56a7p+137,    0x1.47c638de7815fp-1,   -0x1.0c103p-2, INEXACT)
T(RN,  0x1.6729d054c7a3cp+137,   -0x1.89a38bf6f32fbp-1,   0x1.2156a4p-2, INEXACT)
T(RN,  0x1.134d02b88507fp+137,    0x1.d60e0fdf9bb4ap-1,    0x1.23344p-2, INEXACT)
T(RN,  0x1.5c80a4e9869aap+137,   -0x1.8dceb8dd3148cp-2,  -0x1.f17746p-2, INEXACT)
T(RN,  0x1.0c373908ccd2cp+137,    -0x1.874ebb18eb1fp-2,    0x1.aa5b5p-3, INEXACT)
T(RN,  0x1.20af0509b65adp+137,    0x1.082f031d56a6bp-1,   0x1.294d5cp-3, INEXACT)
T(RN,   0x1.2094f9ce34aep+137,   -0x1.fa4d91fa96b6dp-1,   0x1.254b04p-3, INEXACT)
T(RN,  0x1.726eefde8d0dcp+137,    0x1.338d4d507b521p-2,   0x1.c230fap-5, INEXACT)
T(RN,  0x1.1adbf3e194ca6p+137,    0x1.fd8bc5517c57cp-1,   0x1.a24d8ep-3, INEXACT)
T(RN,  0x1.abbcecbceac93p+137,   -0x1.5f35be1b9a6d9p-1,  -0x1.db59b8p-3, INEXACT)
T(RN,  0x1.eef37fad66eaep+138,   -0x1.9bcea642709c9p-1,   0x1.f75c04p-2, INEXACT)
T(RN,  0x1.6478c979194f8p+138,    0x1.f7a4ea595b88cp-4,  -0x1.9cff02p-2, INEXACT)
T(RN,  0x1.57503e2687d03p+138,    0x1.635a6532fdda5p-1,   0x1.61eeeep-2, INEXACT)
T(RN,  0x1.50979eec7bf7ep+138,   -0x1.f6475065fc72cp-1,   0x1.d07e92p-2, INEXACT)
T(RN,  0x1.fa56d659d49b6p+138,   -0x1.b9374570974b2p-3,   0x1.a11398p-2, INEXACT)
T(RN,    0x1.2c1753c255fp+138,   -0x1.5ec69b3a52e46p-1,  -0x1.7da246p-2, INEXACT)
T(RN,  0x1.2e77a75058ae2p+138,   -0x1.8fff818048246p-1,   0x1.dc2c36p-3, INEXACT)
T(RN,  0x1.375ced12c3b5cp+138,    0x1.ce0576cd5db03p-1,   -0x1.50c3bp-7, INEXACT)
T(RN,  0x1.554179d08ad4fp+138,   -0x1.2431ee5920aafp-1,  -0x1.2adaeep-2, INEXACT)
T(RN,  0x1.332fcebfd0b74p+138,   -0x1.1dd48ac367776p-1,   0x1.9807a4p-2, INEXACT)
T(RN,  0x1.1b1ae9ea7a6fep+139,    0x1.fff35623fa8cap-1,  -0x1.8a55c2p-2, INEXACT)
T(RN,   0x1.d1fb586eb42ap+139,    0x1.af606b2c4b0a6p-4,  -0x1.7230c8p-3, INEXACT)
T(RN,  0x1.2932e523fa302p+139,    0x1.e6f087079ea9dp-2,   0x1.7f7e6ap-2, INEXACT)
T(RN,  0x1.4307caede040fp+139,   -0x1.2d299ce432211p-5,  -0x1.fdf49ep-2, INEXACT)
T(RN,  0x1.75a62cbaefad7p+139,    0x1.c4802dfd7ec72p-1,  -0x1.6a223ap-2, INEXACT)
T(RN,  0x1.4399e90cdbc14p+139,    0x1.9273dcfc1ee3ep-4,  -0x1.4fc89ep-3, INEXACT)
T(RN,  0x1.f03d28f50b3e2p+139,    0x1.249218e16914fp-4,  -0x1.0e407cp-2, INEXACT)
T(RN,  0x1.f330a23c79031p+139,   -0x1.d4ab5510bda73p-3,   0x1.cbb52ap-3, INEXACT)
T(RN,  0x1.ba524ae23a1d7p+139,    0x1.c779d96396e6cp-2,  -0x1.eeb152p-2, INEXACT)
T(RN,  0x1.8950acdf7d56ap+139,   -0x1.ffff84730a6afp-1,   0x1.428ab2p-5, INEXACT)
T(RN,  0x1.9afd4c0063ad2p+140,    0x1.b34dd2a21a11ep-1,  -0x1.bb4378p-2, INEXACT)
T(RN,  0x1.29ed363b7de64p+140,   -0x1.65602035591e5p-1,  -0x1.91b598p-2, INEXACT)
T(RN,  0x1.0d44a674ea6a9p+140,    0x1.7685d5295a74bp-1,  -0x1.040c32p-2, INEXACT)
T(RN,  0x1.3c40a566f3e12p+140,    0x1.a5f3350747861p-1,   0x1.6da418p-4, INEXACT)
T(RN,  0x1.65b0933378b92p+140,    0x1.094e9350f9986p-1,   0x1.c57dcap-4, INEXACT)
T(RN,  0x1.506f78dd62bf6p+140,   -0x1.945258f6eb3bep-1,   0x1.7d12fap-2, INEXACT)
T(RN,  0x1.ae0be31bf079fp+140,    0x1.568171c4b2fb1p-3,   0x1.f7f7eap-2, INEXACT)
T(RN,  0x1.83af23231bca3p+140,    0x1.88259412b240cp-1,  -0x1.fe7b0cp-3, INEXACT)
T(RN,  0x1.da68ebc36a0b8p+140,   -0x1.8c4851e77c7d6p-1,   0x1.58571ap-2, INEXACT)
T(RN,  0x1.935818c14df4dp+140,    0x1.a7aa352f54403p-1,    0x1.4846bp-2, INEXACT)
T(RN,   0x1.2520daeeea02p+141,   -0x1.9cfa421f2d7cdp-2,   0x1.77f092p-2, INEXACT)
T(RN,  0x1.faea50b58920ap+141,   -0x1.e69e3c505b31fp-1,   0x1.ef1e42p-5, INEXACT)
T(RN,  0x1.0008212cb2c0ep+141,     0x1.7895ecc04ad7p-1,   0x1.a3360ep-2, INEXACT)
T(RN,   0x1.15d072be3422p+141,    0x1.e40a4b166cf27p-1,  -0x1.07ca58p-2, INEXACT)
T(RN,  0x1.66eceee484839p+141,    0x1.06975dffa39aep-1,    0x1.37127p-2, INEXACT)
T(RN,  0x1.75a4c7dc97985p+141,    0x1.fff835837a447p-1,    0x1.3ee57p-2, INEXACT)
T(RN,  0x1.e8096d0aba4dcp+141,     0x1.668cb0bd5134p-1,   0x1.dabf7cp-3, INEXACT)
T(RN,  0x1.5f2167a3e36d9p+141,    0x1.83f55b68c9aa3p-1,   0x1.7b853ep-2, INEXACT)
T(RN,  0x1.9c12f12e36688p+141,   -0x1.cf8e787706e65p-1,    0x1.8795fp-3, INEXACT)
T(RN,  0x1.6119da268b374p+141,    0x1.3bbf6fa498c1ep-1,    0x1.626b6p-2, INEXACT)
T(RN,  0x1.ffe15844dce13p+142,   -0x1.cfdff2ee4ef71p-1,   0x1.6ecbc4p-3, INEXACT)
T(RN,   0x1.0466132b4881p+142,    0x1.a6ad8b1160a75p-1,  -0x1.c5d6f8p-2, INEXACT)
T(RN,  0x1.d6166b1e515e6p+142,   -0x1.ffdd133c694e6p-1,  -0x1.8771eap-2, INEXACT)
T(RN,  0x1.c2673fb63378fp+142,    0x1.816dbf74f266dp-2,   0x1.ea9194p-2, INEXACT)
T(RN,  0x1.3870c176fa603p+142,   -0x1.3b0fc4af2c225p-1,  -0x1.09da8ap-2, INEXACT)
T(RN,  0x1.153bb9967bf4bp+142,    0x1.85e7026c80a7ep-2,  -0x1.59fe2cp-2, INEXACT)
T(RN,  0x1.413a5d76133cep+142,   -0x1.3d6ae6b2651e1p-1,   0x1.df79a2p-2, INEXACT)
T(RN,   0x1.1aab55db9789p+142,   -0x1.9003354451d34p-1,   -0x1.2edefp-7, INEXACT)
T(RN,   0x1.335f92576321p+142,     0x1.00bd16ae6606p-6,   0x1.378978p-3, INEXACT)
T(RN,  0x1.5b73bd278bd9fp+142,    -0x1.fd42302cf123p-1,  -0x1.137aa4p-2, INEXACT)
T(RN,  0x1.12ecfd80e7a84p+143,    0x1.ed500a5109e59p-1,  -0x1.7cca5ep-3, INEXACT)
T(RN,  0x1.bb7165b3cfe82p+143,    0x1.28f2741ee9b0fp-1,  -0x1.856bb6p-2, INEXACT)
T(RN,  0x1.2da952f19775cp+143,   -0x1.6b8301608b957p-1,  -0x1.813902p-3, INEXACT)
T(RN,  0x1.4b04b275f8f2cp+143,    0x1.fac40ff08fb2dp-1,  -0x1.7bc9f8p-4, INEXACT)
T(RN,  0x1.f966b6969d681p+143,    0x1.fed14903d737ap-1,  -0x1.18c7c4p-4, INEXACT)
T(RN,  0x1.94a9d94414b5ap+143,    0x1.81247a66faf9bp-2,   0x1.d08faep-8, INEXACT)
T(RN,  0x1.c71c5436316b6p+143,   -0x1.32c395c508a2dp-2,  -0x1.397b12p-6, INEXACT)
T(RN,  0x1.52535b7cf82cap+143,   -0x1.39d00a16d1a0ap-1,   0x1.91cbf8p-3, INEXACT)
T(RN,  0x1.cbafa06996a5ap+143,   -0x1.6af20d0a1d792p-2,  -0x1.13a726p-2, INEXACT)
T(RN,  0x1.c1ebc960c7becp+143,    0x1.52f882f2000f2p-2,  -0x1.860af8p-3, INEXACT)
T(RN,  0x1.8d738c3982662p+144,    0x1.fd0b3b87c05a1p-1,  -0x1.f3fe1ap-2, INEXACT)
T(RN,  0x1.34611de6f33f3p+144,    0x1.caa6f68acdd0bp-1,   0x1.40f258p-5, INEXACT)
T(RN,  0x1.6aca56ecb2673p+144,   -0x1.7132766d67061p-1,   0x1.faac04p-3, INEXACT)
T(RN,  0x1.3da1dcf60b5f7p+144,    0x1.7be533cc6ca8fp-9,   0x1.7e32acp-2, INEXACT)
T(RN,  0x1.ff29c068c2b28p+144,    0x1.276f4543e1c08p-2,   0x1.0e8f92p-2, INEXACT)
T(RN,   0x1.ecf823317902p+144,    0x1.cc5312292e9d6p-1,   -0x1.ea54bp-2, INEXACT)
T(RN,  0x1.41503b5e7e476p+144,   -0x1.e8969cdc021c9p-1,    -0x1.0b51p-3, INEXACT)
T(RN,  0x1.b67f40a59ffe9p+144,   -0x1.f63c706e3d824p-1,   0x1.7e854cp-3, INEXACT)
T(RN,  0x1.6a0927e44dc45p+144,   -0x1.82066fb2e510ap-2,  -0x1.fa4188p-2, INEXACT)
T(RN,  0x1.b0799afd8c626p+144,   -0x1.98c635b9d5b77p-2,   0x1.9f6268p-5, INEXACT)
T(RN,  0x1.fbebc51e1d43ap+145,    0x1.0c2d0c18328ddp-2,  -0x1.4d0a0cp-2, INEXACT)
T(RN,  0x1.096eba88ad18ep+145,   -0x1.09958bfa8cffep-1,  -0x1.eec812p-3, INEXACT)
T(RN,   0x1.5fbf13cf19b3p+145,   -0x1.ec95802ee2e51p-1,   0x1.2a93cep-3, INEXACT)
T(RN,  0x1.0d719cb3f5318p+145,   -0x1.41226f17dd5e8p-5,  -0x1.a0f2fcp-3, INEXACT)
T(RN,  0x1.c496ced9e8218p+145,   -0x1.56777167c7ed6p-1,   -0x1.64f64p-3, INEXACT)
T(RN,  0x1.bf14ee43f34c6p+145,    0x1.0f522ee734d86p-1,    0x1.735e1p-2, INEXACT)
T(RN,  0x1.1d7fb7163affap+145,    0x1.fb59136f9e1e2p-1,   -0x1.3af41p-5, INEXACT)
T(RN,  0x1.00c3767ccbf9cp+145,    0x1.e2e8d58b61f26p-1,  -0x1.1a62e2p-3, INEXACT)
T(RN,  0x1.22c96d24fa244p+145,   -0x1.b62a315ed66ecp-1,  -0x1.7d2da6p-5, INEXACT)
T(RN,  0x1.3a4b667257d6ap+145,    0x1.f9f6d9dc50694p-1,  -0x1.115284p-3, INEXACT)
T(RN,  0x1.d40fdec20711ep+146,    0x1.82f4a484a1791p-2,   0x1.6fa586p-2, INEXACT)
T(RN,  0x1.c0a8cefe14b74p+146,   -0x1.8d6434ed99d34p-1,   0x1.e10d0ep-2, INEXACT)
T(RN,  0x1.b58b26ad14156p+146,    0x1.5b987b25bbe43p-1,  -0x1.f158eap-7, INEXACT)
T(RN,  0x1.cd70af804c9efp+146,    0x1.aec4116d73bd7p-1,  -0x1.26ea8ap-2, INEXACT)
T(RN,  0x1.f0bcb84472212p+146,    0x1.f53b5b5e688b1p-1,    -0x1.18dfp-3, INEXACT)
T(RN,  0x1.ab3cd5eb75c32p+146,    0x1.d6ba0c38f930dp-1,   0x1.b5a0f8p-2, INEXACT)
T(RN,  0x1.14321b29985efp+146,   -0x1.a663fe855f4eap-7,  -0x1.d68966p-2, INEXACT)
T(RN,  0x1.1fbecdeb85743p+146,   -0x1.e4cda35291571p-3,    0x1.c5fcbp-2, INEXACT)
T(RN,  0x1.832a299085bbbp+146,   -0x1.c75a1bb461d85p-1,    0x1.dea99p-2, INEXACT)
T(RN,  0x1.bece1cad4d002p+146,   -0x1.80a94defc3c53p-1,   0x1.089d8ap-2, INEXACT)
T(RN,  0x1.f34064358049ep+147,   -0x1.3d65a01595ea5p-1,   0x1.1245aap-3, INEXACT)
T(RN,   0x1.c506f9942ee5p+147,   -0x1.d97daae23901fp-1,   0x1.837516p-3, INEXACT)
T(RN,  0x1.845fbd1dbbc1ep+147,    0x1.e5eb9d998d77fp-1,  -0x1.e7d9eap-6, INEXACT)
T(RN,  0x1.26ba886be8602p+147,   -0x1.29ac76a2304e9p-3,   0x1.ff58b2p-4, INEXACT)
T(RN,  0x1.0fdd7d503dd8fp+147,    0x1.b4bb83b0b7d1ap-1,  -0x1.0ca0bcp-2, INEXACT)
T(RN,  0x1.c3f7687818444p+147,   -0x1.e4cc5a355bcf9p-1,  -0x1.3ea62cp-2, INEXACT)
T(RN,  0x1.dc4dec2076622p+147,   -0x1.d668526512fbcp-1,    0x1.96751p-3, INEXACT)
T(RN,  0x1.fa4357d8c3f06p+147,   -0x1.8891ce618f082p-1,  -0x1.64aa36p-2, INEXACT)
T(RN,  0x1.2c08e3567fb06p+147,    0x1.45367f6351ad1p-1,   0x1.80f268p-2, INEXACT)
T(RN,  0x1.7a54052c2db47p+147,    0x1.fdc71e796d0b7p-1,  -0x1.5d8af2p-3, INEXACT)
T(RN,  0x1.826e218643c26p+148,    0x1.ece274bcfd3d4p-1,  -0x1.aff5fep-2, INEXACT)
T(RN,  0x1.83ff467d18122p+148,     0x1.df3a78fcca8bp-1,  -0x1.3d2702p-3, INEXACT)
T(RN,   0x1.6895a318c134p+148,   -0x1.e5ae3fdfab685p-3,  -0x1.d4230ap-5, INEXACT)
T(RN,  0x1.653b8c9fc3609p+148,    0x1.7815cea753c3dp-6,   -0x1.c046bp-4, INEXACT)
T(RN,  0x1.4c1bcf7f4e808p+148,   -0x1.f5604bd5515e8p-1,   0x1.c67652p-2, INEXACT)
T(RN,  0x1.91028184b96a4p+148,   -0x1.f0344aab535a2p-1,  -0x1.84b6aap-4, INEXACT)
T(RN,  0x1.dd23907917d2ap+148,   -0x1.95f71cd44f188p-1,  -0x1.e084dcp-2, INEXACT)
T(RN,   0x1.c6c5a597b3bap+148,   -0x1.f8215144bbdf8p-1,  0x1.1ae2c8p-10, INEXACT)
T(RN,  0x1.167a2b021d8c1p+148,     0x1.cd7307f71dedp-4,   0x1.0feb88p-3, INEXACT)
T(RN,  0x1.ef50393607875p+148,    0x1.e76f8ab312336p-1,  -0x1.abfe2cp-4, INEXACT)
T(RN,  0x1.2d1f00c10c0fbp+149,    0x1.bf11640b04d77p-2,  -0x1.3c5124p-2, INEXACT)
T(RN,  0x1.d05683d6f6e41p+149,    0x1.f0c1446014b77p-1,   -0x1.98ce8p-2, INEXACT)
T(RN,  0x1.37f4f66b46084p+149,    0x1.553a175100eb2p-1,  -0x1.961478p-3, INEXACT)
T(RN,  0x1.5484f8ff95455p+149,    0x1.dc95b07af6393p-1,   0x1.f0e418p-2, INEXACT)
T(RN,  0x1.d95c80bdf6672p+149,   -0x1.add8aa1b79796p-3,  -0x1.18f93ep-2, INEXACT)
T(RN,  0x1.ba0b1a83bc478p+149,    0x1.be18587f2e74dp-1,   -0x1.caf2fp-6, INEXACT)
T(RN,  0x1.46ce02807d4d9p+149,    0x1.f47095957557ep-1,   0x1.156d94p-2, INEXACT)
T(RN,  0x1.4af16bc4757b4p+149,   -0x1.7ad1fb3d60fdfp-3,   0x1.9d3bbcp-2, INEXACT)
T(RN,  0x1.07b39c0341f0ap+149,   -0x1.7f686ed35cfa6p-1,  -0x1.2da412p-5, INEXACT)
T(RN,  0x1.b6ee324ba2e2dp+149,   -0x1.2aad8af6b06b2p-5,  -0x1.a9f174p-2, INEXACT)
T(RN,   0x1.defe5ab0d319p+150,   -0x1.4bd4039e8640dp-1,   0x1.8650c6p-2, INEXACT)
T(RN,  0x1.8f31a38f8cffep+150,    0x1.d3e2232c81614p-1,   0x1.7e6a2ap-2, INEXACT)
T(RN,  0x1.a04f47fe38bc8p+150,   -0x1.b9d25f41abefbp-1,    0x1.f6eeep-2, INEXACT)
T(RN,  0x1.82b2eeeb8f502p+150,    0x1.4efb7d0101d4fp-2,   0x1.683a4ap-2, INEXACT)
T(RN,  0x1.29d21a87f0445p+150,   -0x1.4a7385d7d3f9ap-7,   0x1.22fa7cp-2, INEXACT)
T(RN,  0x1.193e632c3f893p+150,    0x1.1d1963a22f0aap-5,   0x1.38860ap-4, INEXACT)
T(RN,  0x1.978f3851e42dcp+150,   -0x1.9c61b9822a1b6p-1,   0x1.dcfbb6p-2, INEXACT)
T(RN,  0x1.f03555aeed9a2p+150,    0x1.de2e94bd7565bp-1,   0x1.f03b0ap-2, INEXACT)
T(RN,  0x1.f15a8cc5e362cp+150,   -0x1.c367e95512469p-1,   0x1.bf0364p-3, INEXACT)
T(RN,  0x1.26f3b6abb930bp+150,    -0x1.df1e13f1bdd1p-1,   0x1.75ec1ep-2, INEXACT)
T(RN,  0x1.ba861158bff36p+151,   -0x1.bcbdd952f798cp-1,  -0x1.b3f43ep-2, INEXACT)
T(RN,  0x1.d10d35f52541ep+151,    0x1.84d215a2c1104p-3,  -0x1.3c2546p-4, INEXACT)
T(RN,  0x1.146c9406e81d1p+151,    0x1.da04030baddbdp-1,  -0x1.e0acc6p-2, INEXACT)
T(RN,  0x1.1f3c468576f73p+151,   -0x1.f99c0d2b7f13ep-1,  -0x1.439c32p-4, INEXACT)
T(RN,  0x1.08305e8c1ac97p+151,   -0x1.82bdc5d1681a8p-1,  -0x1.5390f6p-3, INEXACT)
T(RN,  0x1.b71d2bca1305bp+151,    0x1.2dae8e7f90986p-1,   0x1.be61f8p-3, INEXACT)
T(RN,  0x1.eb82f5d48cadep+151,    0x1.a04f7b24267a4p-1,  -0x1.55b51ep-4, INEXACT)
T(RN,  0x1.89251241326c4p+151,   -0x1.282eb56738f85p-1,   0x1.9d9452p-3, INEXACT)
T(RN,  0x1.6bcdb9219ccb1p+151,   -0x1.fc63ddeec9622p-1,  -0x1.851b3cp-4, INEXACT)
T(RN,  0x1.c5ab7884c389cp+151,    0x1.045b37fe42d98p-5,   -0x1.a8ad6p-5, INEXACT)
T(RN,  0x1.b5c13ef38cef4p+152,    0x1.221078c55ad3bp-2,   0x1.41375cp-2, INEXACT)
T(RN,  0x1.ad819e8acc15ap+152,   -0x1.ff2f711e8f891p-1,  -0x1.aefd62p-4, INEXACT)
T(RN,  0x1.0c8a8b41097c8p+152,    0x1.e66d892ca216ap-3,  -0x1.1ca12cp-4, INEXACT)
T(RN,  0x1.7fd5bdb3e464ep+152,    0x1.13608038317e6p-1,  -0x1.637d82p-2, INEXACT)
T(RN,  0x1.19c8d43b703e4p+152,    -0x1.5b7b9deee5a7p-1,   0x1.fd3d24p-3, INEXACT)
T(RN,  0x1.1a281227cbd8dp+152,    0x1.c1533b4ec9966p-1,  -0x1.7c8a48p-2, INEXACT)
T(RN,  0x1.880ff8f93c86cp+152,   -0x1.62cfc5cc0af12p-1,  -0x1.2107cep-3, INEXACT)
T(RN,  0x1.5881b53be9e42p+152,    0x1.ecc5c6dc8a4dep-1,   0x1.87dc3ap-2, INEXACT)
T(RN,  0x1.aa84967cb58e6p+152,   -0x1.e67ef3135770ep-1,  -0x1.f8b6acp-5, INEXACT)
T(RN,  0x1.d1ca9e5df1d7ep+152,   -0x1.d222b1991121ep-2,    0x1.26c79p-5, INEXACT)
T(RN,  0x1.a999491557864p+153,    0x1.ffcdbf0dd5fafp-1,   0x1.8aead2p-3, INEXACT)
T(RN,  0x1.77022520f3ee6p+153,    -0x1.155443c53abcp-1,  -0x1.3b08f8p-3, INEXACT)
T(RN,  0x1.849239fab742bp+153,   -0x1.d6ed5745f5e1dp-1,    0x1.25497p-2, INEXACT)
T(RN,  0x1.19f01238b7ca4p+153,    0x1.897ce7ea9de1cp-1,  -0x1.7bcd8cp-3, INEXACT)
T(RN,  0x1.2aef1b891e237p+153,    0x1.ff14115d3f932p-1,    0x1.9b632p-3, INEXACT)
T(RN,  0x1.339f0d4e73dcap+153,    0x1.bcc7db9506372p-1,   0x1.50a868p-2, INEXACT)
T(RN,  0x1.a3c959280f82ep+153,    0x1.f87b7aba22c09p-1,    0x1.5ebbbp-2, INEXACT)
T(RN,  0x1.cfaff149b4ac6p+153,   -0x1.d70e439e189bap-1,    0x1.43834p-2, INEXACT)
T(RN,  0x1.7e32a6b49aba8p+153,   -0x1.712be2db26becp-1,    0x1.1a19ep-2, INEXACT)
T(RN,  0x1.9ad14950a9875p+153,    0x1.9ef03f49d3c1dp-1,  -0x1.104724p-8, INEXACT)
T(RN,  0x1.e0021825bcad8p+154,    0x1.869640046a367p-1,  -0x1.7d3244p-3, INEXACT)
T(RN,  0x1.2ead4042678bbp+154,    0x1.d96de779e534cp-2,   0x1.5ab096p-3, INEXACT)
T(RN,  0x1.f6bb2289be468p+154,   -0x1.35ad350e38b75p-1,   -0x1.425dfp-2, INEXACT)
T(RN,  0x1.3e77f169c1c67p+154,   -0x1.5121d218add11p-1,   0x1.c4892ap-2, INEXACT)
T(RN,  0x1.e86c1024f4558p+154,    0x1.8aea7132c7712p-1,   0x1.72ea22p-3, INEXACT)
T(RN,   0x1.abfc2f74733bp+154,    0x1.f345de14a5878p-1,  -0x1.64ab4ap-2, INEXACT)
T(RN,  0x1.28e7833a9516ep+154,    0x1.e28ffca4031aap-1,   -0x1.49643p-2, INEXACT)
T(RN,  0x1.ed1e150752e8ap+154,    0x1.87cf228c71cecp-1,   0x1.da767ep-3, INEXACT)
T(RN,  0x1.fcdd5996faa3bp+154,    0x1.f3c8691e4fd16p-1,   0x1.f9158ap-2, INEXACT)
T(RN,  0x1.007176b7b6408p+154,   -0x1.cc06d8c208b5dp-1,  -0x1.f123bap-3, INEXACT)
T(RN,  0x1.1a6eba7c4182ep+155,   -0x1.1862c4f09aa38p-1,   0x1.f8013cp-2, INEXACT)
T(RN,  0x1.a7af58b9bed93p+155,   -0x1.f5b6d66e4f438p-1,   0x1.b08514p-2, INEXACT)
T(RN,  0x1.cbd8402759476p+155,   -0x1.a2f860a4cfa14p-2,   0x1.3940fap-2, INEXACT)
T(RN,  0x1.2d76b12c3a75cp+155,     0x1.e79de92f0fcbp-1,   0x1.595454p-3, INEXACT)
T(RN,   0x1.4e58145045c8p+155,    0x1.ac02dd5084112p-1,  -0x1.7642ccp-2, INEXACT)
T(RN,  0x1.5a3f1aa7c29dep+155,    0x1.4f4c7cbad6378p-1,   0x1.1f2e42p-3, INEXACT)
T(RN,  0x1.e8d23a23922abp+155,   -0x1.e88f222381c9ep-2,  -0x1.f59746p-3, INEXACT)
T(RN,  0x1.e06f2e329cea6p+155,   -0x1.f9a6146c0ed15p-1,   0x1.6549ecp-2, INEXACT)
T(RN,   0x1.29aa505ccf0bp+155,    0x1.db4e1a7c7f775p-1,  -0x1.6119d4p-3, INEXACT)
T(RN,  0x1.e47909039a00cp+155,   -0x1.b8b7a03dcc30dp-1,   0x1.d5e378p-2, INEXACT)
T(RN,  0x1.5846c7a7b8f1ap+156,    0x1.d8ac71473249fp-1,   0x1.5878d4p-2, INEXACT)
T(RN,  0x1.8d188b678c396p+156,    0x1.a80070b4ba184p-3,   0x1.12676cp-5, INEXACT)
T(RN,  0x1.dcc0c70e8c162p+156,   -0x1.acdb69fe36dd2p-1,   0x1.3c9e5ep-2, INEXACT)
T(RN,  0x1.70177aa2f0ca5p+156,    0x1.d5ab9fd234f0ep-1,   0x1.070bc4p-2, INEXACT)
T(RN,  0x1.58491717c6a0cp+156,   -0x1.fa1f3acc3c067p-1,   0x1.896d36p-2, INEXACT)
T(RN,  0x1.24d10b933e69fp+156,    0x1.049144af560a2p-4,  -0x1.2fe598p-3, INEXACT)
T(RN,   0x1.8253315ccd25p+156,    0x1.9ee871b8c0f56p-2,   0x1.ca8c38p-3, INEXACT)
T(RN,  0x1.9b237a21986c7p+156,    0x1.0398c43dcaa51p-7,  -0x1.1c840ap-3, INEXACT)
T(RN,  0x1.f4f0cbad421e1p+156,   -0x1.694ad50f080fcp-1,   0x1.b59a9ep-7, INEXACT)
T(RN,  0x1.ae3e4963e9982p+156,   -0x1.0c960fe6ef779p-1,   0x1.2e1f74p-3, INEXACT)
T(RN,  0x1.711a1c204f8b9p+157,   -0x1.fff3dff714056p-1,   0x1.b95e7cp-3, INEXACT)
T(RN,  0x1.aee66076206e2p+157,    0x1.72536b174d38bp-2,   0x1.39d8d2p-2, INEXACT)
T(RN,  0x1.8e7fa0aec2374p+157,    0x1.5ca837c9764c3p-1,  -0x1.52e01ep-3, INEXACT)
T(RN,  0x1.f76fcc50c07aep+157,   -0x1.0d0f8f4c9cd83p-2,   0x1.5c311ep-2, INEXACT)
T(RN,  0x1.9572c157bd919p+157,    0x1.022ef530508efp-3,   -0x1.c32c9p-9, INEXACT)
T(RN,  0x1.4f609e0d4cc7ep+157,    -0x1.290e9593b039p-2,  -0x1.f7e448p-8, INEXACT)
T(RN,  0x1.34c584775f00cp+157,   -0x1.fd69c9262741fp-1,    -0x1.123cp-2, INEXACT)
T(RN,  0x1.2b77de113203fp+157,   -0x1.3d2108a2c655ep-1,   0x1.c41902p-2, INEXACT)
T(RN,  0x1.47c3841542813p+157,   -0x1.64b2833d4c396p-3,   0x1.c4a45ap-2, INEXACT)
T(RN,  0x1.43c3259dbd1eep+157,    -0x1.550c4b5207f6p-1,    0x1.d276bp-4, INEXACT)
T(RN,  0x1.83fff947401edp+158,   -0x1.af638433f8a5dp-1,   0x1.72882ap-3, INEXACT)
T(RN,  0x1.966f99241ce5ap+158,   -0x1.cbfc157bdc369p-1,  -0x1.ffda62p-5, INEXACT)
T(RN,  0x1.29f62980f9193p+158,    0x1.e4b6d2992a5a4p-1,   -0x1.6959ep-5, INEXACT)
T(RN,  0x1.58f67242d942dp+158,    0x1.eb4607b0ec978p-1,   0x1.9e130ap-2, INEXACT)
T(RN,  0x1.9bfb86c130948p+158,    0x1.f58f6cb98632ep-1,  -0x1.887c08p-6, INEXACT)
T(RN,  0x1.5f8a5ef50928ep+158,     0x1.b33ac2da4247p-1,   0x1.72b0aap-3, INEXACT)
T(RN,  0x1.88870fddc4776p+158,   -0x1.8d237bd407226p-1,  -0x1.7bd0e4p-5, INEXACT)
T(RN,  0x1.e45288cbff29dp+158,   -0x1.a52f0dfde4a22p-1,   0x1.10d432p-6, INEXACT)
T(RN,  0x1.782abb140f1c8p+158,   -0x1.ea13be69ba2a6p-1,  -0x1.423382p-5, INEXACT)
T(RN,  0x1.97742afbb5382p+158,   -0x1.ff0fe00b5ecadp-1,    -0x1.ad7cp-3, INEXACT)
T(RN,  0x1.ffde2658becc6p+159,    0x1.efe8893490ea4p-1,   0x1.e5c69ep-2, INEXACT)
T(RN,  0x1.329853e70e043p+159,    0x1.38997c177b1d7p-1,  -0x1.728b0ap-2, INEXACT)
T(RN,  0x1.4062cfb8ea115p+159,   -0x1.abecfde0e4ff2p-1,  -0x1.4637acp-2, INEXACT)
T(RN,  0x1.d09c06784f094p+159,   -0x1.e3c34d7201658p-1,   -0x1.1d964p-4, INEXACT)
T(RN,  0x1.0c4243d4c9a55p+159,    0x1.bc1d73fd7af29p-1,  -0x1.923f0ep-2, INEXACT)
T(RN,  0x1.f5b7507fbbda2p+159,    0x1.a07a89923aee7p-1,  -0x1.4fe88ap-3, INEXACT)
T(RN,  0x1.99b50c24e44a2p+159,   -0x1.dde4a8820e8adp-1,   0x1.0f235ap-3, INEXACT)
T(RN,  0x1.f7da5dcbe7be2p+159,    0x1.dd8f23323a5cbp-1,   0x1.6385bep-3, INEXACT)
T(RN,  0x1.eb171bd1cf10cp+159,   -0x1.b434289d945a8p-1,  -0x1.f1f7f4p-2, INEXACT)
T(RN,  0x1.df34bf8defcccp+159,    0x1.4cc58441e297fp-1,   0x1.696844p-2, INEXACT)
T(RN,  0x1.82e6c8793ebf5p+160,   -0x1.ed9c26c900695p-3,   -0x1.31a3fp-2, INEXACT)
T(RN,  0x1.7673f949a62eap+160,    0x1.7f8bf764614e1p-1,   0x1.c58278p-2, INEXACT)
T(RN,  0x1.0d1db83a231a9p+160,    0x1.e3b63d505a067p-3,   0x1.70cdb4p-2, INEXACT)
T(RN,  0x1.3fee067684138p+160,    0x1.48477059f0cbbp-2,  -0x1.865feap-6, INEXACT)
T(RN,  0x1.dc02024b07cc1p+160,   -0x1.3a9bc57279e07p-1,   0x1.57c5b2p-3, INEXACT)
T(RN,  0x1.81894328a42e1p+160,   -0x1.c28daf0e1f8ffp-2,   0x1.bbd2e2p-2, INEXACT)
T(RN,  0x1.cfa5f0900ba7ap+160,    0x1.1d36ca7ed306bp-1,  -0x1.61121ep-4, INEXACT)
T(RN,  0x1.ed5b59e1398d2p+160,   -0x1.fe1ecab28d872p-1,   -0x1.96998p-2, INEXACT)
T(RN,  0x1.b40440e12b833p+160,    0x1.8c2b2d7898641p-1,   0x1.59f57ap-2, INEXACT)
T(RN,  0x1.89b51d8b7793ep+160,    0x1.7fbd8b648795bp-1,   -0x1.c2ac3p-2, INEXACT)
T(RN,  0x1.5e426a4c3d3d3p+161,    0x1.4e0745a3fee2ep-1,  -0x1.7b75c6p-4, INEXACT)
T(RN,  0x1.69c85fabdbc1dp+161,     0x1.9a1368665d6fp-1,   0x1.e3f5a6p-2, INEXACT)
T(RN,  0x1.12acffa395077p+161,    0x1.c71b9bd84bb6ap-1,   0x1.b446eep-2, INEXACT)
T(RN,  0x1.5189eec321122p+161,    0x1.420ab0d0e581dp-2,  -0x1.98aeeap-4, INEXACT)
T(RN,  0x1.2171d705b9d4bp+161,    0x1.15149b8b2448ep-3,   0x1.fa0bdcp-4, INEXACT)
T(RN,   0x1.192e6407e73dp+161,    0x1.332fc04c8b119p-3,   0x1.f58ba6p-2, INEXACT)
T(RN,  0x1.7d2aa2cbb4ba2p+161,    -0x1.45ee1cca737ep-1,  -0x1.c70a66p-4, INEXACT)
T(RN,  0x1.e29d094373075p+161,    0x1.aeb12c75229cbp-2,  -0x1.64abdap-2, INEXACT)
T(RN,  0x1.40793a5928bb9p+161,   -0x1.3f05db05656dap-1,  -0x1.8ebcfep-2, INEXACT)
T(RN,  0x1.9091a48244e64p+161,    0x1.3733f31d2d1adp-2,   0x1.d1e8c6p-5, INEXACT)
T(RN,  0x1.ea2020eb97726p+162,    0x1.ecf8f27a83f2dp-1,    0x1.700a9p-3, INEXACT)
T(RN,  0x1.859f3385ea432p+162,   -0x1.649844155bf1fp-2,   0x1.a1ee02p-2, INEXACT)
T(RN,  0x1.17c9ff4c7c539p+162,    0x1.0fd0c5516299dp-1,   0x1.42a45ap-2, INEXACT)
T(RN,  0x1.131b81e47af99p+162,    0x1.ef61ede7eb6aap-3,   0x1.6b85d8p-2, INEXACT)
T(RN,  0x1.a9edca4049d6fp+162,   -0x1.eaeb86e0be9adp-1,  -0x1.8ac09cp-2, INEXACT)
T(RN,  0x1.23e558d8525bbp+162,    0x1.e400d0fd879fcp-1,   0x1.6b4904p-3, INEXACT)
T(RN,  0x1.0d8e678e98a36p+162,    0x1.7656126ac7256p-1,  -0x1.9bc3d6p-2, INEXACT)
T(RN,  0x1.273a7bc4ebc2ep+162,    0x1.30156e548c454p-1,  -0x1.302cf2p-5, INEXACT)
T(RN,  0x1.e18629676e689p+162,     0x1.f72727221ccep-1,  -0x1.3f2fa6p-2, INEXACT)
T(RN,  0x1.b88dd98784fe4p+162,   -0x1.18c97b7a15212p-2,   0x1.3ff51cp-4, INEXACT)
T(RN,  0x1.7c4c253e73592p+163,    0x1.c09308bc27ea1p-2,  -0x1.e7c14cp-6, INEXACT)
T(RN,  0x1.d1183861801f2p+163,    0x1.868873edd0bfbp-1,    0x1.3616bp-2, INEXACT)
T(RN,  0x1.e74f20fafe18ep+163,   -0x1.0d971c5984935p-3,  -0x1.ece2acp-6, INEXACT)
T(RN,  0x1.962ecdd7cd737p+163,   -0x1.e1cc7da1d41a6p-1,    0x1.93d5dp-2, INEXACT)
T(RN,  0x1.8b54465ee558ep+163,    0x1.c42e3ad413f4cp-1,    0x1.d0e1ep-2, INEXACT)
T(RN,  0x1.db19fe92bcfc6p+163,    0x1.bc0354c683258p-3,  -0x1.dd903cp-2, INEXACT)
T(RN,  0x1.fe9b4f028224ep+163,   -0x1.0b5df33c2ff1bp-3,   0x1.2c25b8p-7, INEXACT)
T(RN,  0x1.63acf58a3f78cp+163,   -0x1.27b69f9dc0a67p-1,   0x1.003fb6p-3, INEXACT)
T(RN,  0x1.0f4170e2ca789p+163,   -0x1.01b20cd270724p-3,  -0x1.d5ee72p-4, INEXACT)
T(RN,  0x1.bd425ad1f8374p+163,    0x1.7607e3e669038p-3,  -0x1.3cff98p-3, INEXACT)
T(RN,  0x1.706e1f1de059dp+164,   -0x1.c4f299e3bc796p-1,   0x1.fac8b2p-4, INEXACT)
T(RN,  0x1.9188a34a50eb2p+164,   -0x1.fe256ff0b9249p-1,  -0x1.4c858cp-3, INEXACT)
T(RN,  0x1.44bfc6cc81d38p+164,    0x1.e636488b209eap-1,   0x1.259f64p-2, INEXACT)
T(RN,  0x1.5093dfa89147ep+164,   -0x1.f4f447a0165dfp-1,  -0x1.acb59cp-3, INEXACT)
T(RN,  0x1.0454d2750bb12p+164,   -0x1.5dbccadaf57ecp-3,    0x1.8da76p-2, INEXACT)
T(RN,  0x1.693a0466a2ad7p+164,    0x1.06dfde2e33169p-1,  -0x1.01d7a6p-4, INEXACT)
T(RN,  0x1.8f0369d4b3336p+164,    0x1.4629b57c8dd8cp-2,   0x1.40d974p-2, INEXACT)
T(RN,  0x1.c4f86e9d82bccp+164,   -0x1.840b3b5f578f4p-3,  -0x1.164222p-2, INEXACT)
T(RN,  0x1.c96d8a17f7aa9p+164,   -0x1.9a142871649a5p-2,  -0x1.5e0334p-3, INEXACT)
T(RN,  0x1.7aa6a022747f5p+164,    0x1.025dcff6b1ab6p-5,  -0x1.68d87ep-2, INEXACT)
T(RN,  0x1.b2958ebb74df2p+165,   -0x1.46ff670a46dfbp-1,   0x1.f321b8p-2, INEXACT)
T(RN,  0x1.7b23cf46899bbp+165,   -0x1.bb4eebd6ae5e6p-2,   -0x1.57875p-2, INEXACT)
T(RN,  0x1.ce9ecbcb5b98fp+165,   -0x1.466fcd4396f5bp-1,  -0x1.8bb09cp-2, INEXACT)
T(RN,  0x1.6e6c16bedf5f1p+165,   -0x1.4f72437a942b2p-1,  -0x1.766ab2p-3, INEXACT)
T(RN,  0x1.b84ad70417d38p+165,    0x1.fe64af2579a68p-1,  -0x1.b1ff4cp-2, INEXACT)
T(RN,  0x1.4c333e9c1fb1ep+165,    0x1.aad1869adb0e9p-3,  -0x1.136aacp-2, INEXACT)
T(RN,  0x1.93c5ae0699686p+165,   -0x1.3d163d960ea5ep-1,    0x1.bb232p-2, INEXACT)
T(RN,  0x1.40be3c1028b35p+165,    0x1.51360fb5c86d2p-2,   0x1.80427ep-2, INEXACT)
T(RN,  0x1.43cf58a8badd3p+165,    0x1.c23da14a5f00fp-1,  -0x1.081f62p-2, INEXACT)
T(RN,  0x1.a50cbfac0427ep+165,    0x1.1dec82898f27bp-1,   0x1.244472p-2, INEXACT)
T(RN,  0x1.c3535230ec303p+166,   -0x1.7df2bf0464938p-4,  -0x1.812afap-2, INEXACT)
T(RN,  0x1.c5c3b45a99882p+166,   -0x1.1cdcafe7e75aep-1,   -0x1.7cfb8p-2, INEXACT)
T(RN,  0x1.ed04f25f9d348p+166,   -0x1.7691cd4b243c3p-2,  -0x1.797c5cp-2, INEXACT)
T(RN,  0x1.8a67c974d7faep+166,    0x1.ff14100471df3p-1,    0x1.c3e83p-3, INEXACT)
T(RN,  0x1.327b58908b159p+166,   -0x1.4a83ebc119719p-1,  -0x1.be6794p-4, INEXACT)
T(RN,  0x1.d1500e406c94ap+166,    0x1.4fc937d6d4af2p-1,   0x1.e76776p-2, INEXACT)
T(RN,  0x1.39b1ae6cba5a4p+166,   -0x1.22a151ce46cd3p-1,  -0x1.4a36cep-2, INEXACT)
T(RN,  0x1.665978c0a09f3p+166,   -0x1.5d54e24085e44p-1,   0x1.a7cde2p-3, INEXACT)
T(RN,  0x1.a2c8e6d428ec2p+166,    0x1.ffe4c8b1e3d3bp-1,  -0x1.f4ab32p-3, INEXACT)
T(RN,  0x1.08842e14d811ap+166,    0x1.c37300b03d9bcp-1,  -0x1.a8ef88p-3, INEXACT)
T(RN,  0x1.36724f39b20bfp+167,   -0x1.4744bea4becdfp-5,   0x1.041e88p-2, INEXACT)
T(RN,  0x1.277ea7cb4ba31p+167,   -0x1.cfb14ecba70ffp-1,  -0x1.a20692p-3, INEXACT)
T(RN,  0x1.5df69eaf7b3e3p+167,     0x1.98dfe27f7527p-1,   0x1.b6ce92p-2, INEXACT)
T(RN,  0x1.f8c32b2d59be4p+167,   -0x1.00d13a74133f2p-1,  -0x1.0b86d8p-2, INEXACT)
T(RN,  0x1.a1bc9043cf86ep+167,    -0x1.635c84bb571ep-1,  -0x1.af36c2p-3, INEXACT)
T(RN,  0x1.347643e56fc94p+167,    0x1.deb39b96e1c56p-1,   -0x1.c9752p-3, INEXACT)
T(RN,   0x1.d773e28d87d3p+167,    0x1.aefe66083e465p-1,   0x1.7c41c6p-7, INEXACT)
T(RN,  0x1.65a5fffc3ce8fp+167,    0x1.5c1b3d8c7eec8p-1,   0x1.dc3b96p-3, INEXACT)
T(RN,  0x1.9a06b9d993a87p+167,    0x1.0b6a8a88186bcp-2,  -0x1.18b5eap-2, INEXACT)
T(RN,  0x1.eb295dc4c2e64p+167,    -0x1.822e9bcbcfe1p-1,  -0x1.745a9cp-2, INEXACT)
T(RN,  0x1.8e1499f2bfcd2p+168,   -0x1.466d6d9c8f133p-3,   0x1.c5a4c8p-4, INEXACT)
T(RN,     0x1.83b97ce2ddp+168,     0x1.afa64276b78fp-2,  -0x1.81521ap-2, INEXACT)
T(RN,  0x1.8214d7b50b3b9p+168,   -0x1.4b2f0defeeca3p-2,    0x1.80845p-2, INEXACT)
T(RN,  0x1.9cffbbe0da346p+168,    0x1.e518566941c35p-2,   -0x1.1524dp-2, INEXACT)
T(RN,  0x1.1db666ce0f06dp+168,    0x1.730dbf7e0a3a1p-1,  -0x1.ffe638p-2, INEXACT)
T(RN,  0x1.07aaf8a045924p+168,   -0x1.de02055c52f08p-1,    0x1.76755p-6, INEXACT)
T(RN,  0x1.7fb9057270132p+168,    0x1.a05468e9b5264p-2,   -0x1.ac1d6p-3, INEXACT)
T(RN,  0x1.bbea2e3552068p+168,    0x1.e0cd2c53008d6p-2,   0x1.b4d15ap-2, INEXACT)
T(RN,  0x1.28b91a07d0662p+168,    -0x1.7626977e904fp-3,   0x1.1f15e8p-2, INEXACT)
T(RN,  0x1.05a60c61b9f4ep+168,    0x1.8b9fc4a2706ecp-1,    0x1.20b6dp-4, INEXACT)
T(RN,  0x1.e8b1958c2d562p+169,    0x1.dcc57ff60d0dcp-1,   0x1.c08948p-4, INEXACT)
T(RN,  0x1.80ff8a0b619fap+169,    0x1.0a66599da83e5p-2,   0x1.86c2c8p-2, INEXACT)
T(RN,  0x1.7c44bd9d9cc31p+169,    0x1.56ed8dffe2099p-5,  -0x1.6c0de8p-2, INEXACT)
T(RN,  0x1.eadd52c6c8b54p+169,   -0x1.ffc14ab595be6p-1,   -0x1.5322fp-5, INEXACT)
T(RN,  0x1.0cd9985d3aa3ap+169,    0x1.3e75db3534153p-1,   -0x1.4401bp-2, INEXACT)
T(RN,  0x1.c69c078d19168p+169,   -0x1.95d0d87809efdp-5,  -0x1.3f2d6ep-5, INEXACT)
T(RN,   0x1.69b7dc3d512ep+169,    0x1.b93bc96bdaef2p-2,   0x1.6ed8eap-3, INEXACT)
T(RN,  0x1.d6500c5916dcep+169,   -0x1.93ea65cd6114ep-3,  -0x1.4f6b76p-2, INEXACT)
T(RN,  0x1.8a97c82dd24f7p+169,    -0x1.bbe4214979c9p-1,  -0x1.46d972p-2, INEXACT)
T(RN,  0x1.81fe39fb0a77ep+169,    0x1.e1998afc6771bp-1,  -0x1.dcd384p-2, INEXACT)
T(RN,  0x1.cfef3dc0cfa2ep+170,    0x1.9006b9ce8b111p-1,   0x1.958168p-3, INEXACT)
T(RN,   0x1.ba9b6fd4c20fp+170,    0x1.83f3bdfd5747cp-1,   0x1.430d2cp-2, INEXACT)
T(RN,  0x1.4c3eb4fb645c8p+170,    0x1.ff9d0522596eap-1,  -0x1.5b0de6p-3, INEXACT)
T(RN,  0x1.846fc667a2196p+170,    0x1.f70c8044d125ap-1,  -0x1.9c39eep-6, INEXACT)
T(RN,  0x1.43b94582a5c2bp+170,    0x1.0d239f46a5917p-1,   0x1.64aa0ep-5, INEXACT)
T(RN,   0x1.fb8636e0aa2fp+170,   -0x1.f6ece40d6f71ep-1,   0x1.21ac78p-2, INEXACT)
T(RN,  0x1.fce2280eff7eep+170,    0x1.8102ce256b23bp-1,  -0x1.3e363ep-2, INEXACT)
T(RN,  0x1.3c0bdad7d7212p+170,    0x1.fee045068e274p-1,  -0x1.7fb50ep-2, INEXACT)
T(RN,  0x1.db34e5289f26fp+170,    0x1.e4c308b1d18afp-1,  -0x1.36316cp-2, INEXACT)
T(RN,  0x1.e502636704683p+170,    0x1.c4b37a5190362p-5,  -0x1.5d9556p-2, INEXACT)
T(RN,  0x1.935cff7c42564p+171,    0x1.fbfb3c8a8db98p-1,   0x1.acb454p-2, INEXACT)
T(RN,   0x1.66f4118a61cep+171,    -0x1.dedff32dc87cp-1,  -0x1.d67ab4p-4, INEXACT)
T(RN,  0x1.4a2ef47277c66p+171,    0x1.fec12a1ae63d9p-1,  -0x1.7b0b5ep-3, INEXACT)
T(RN,  0x1.265a822a56ab5p+171,    0x1.b64e23db9d869p-1,    0x1.68969p-2, INEXACT)
T(RN,  0x1.6e8a099286ceap+171,   -0x1.fd3eea49cff5cp-4,   0x1.1467c2p-3, INEXACT)
T(RN,  0x1.66d5d1641ec3ap+171,    0x1.0064b933ecc4cp-5,  -0x1.af23a4p-3, INEXACT)
T(RN,  0x1.87cf8faca079cp+171,   -0x1.e389e2adc2c62p-2,  -0x1.cb8dc6p-2, INEXACT)
T(RN,  0x1.d301ac748c997p+171,    0x1.dee2afd8f38d5p-1,   0x1.19c802p-2, INEXACT)
T(RN,  0x1.7299870839dc8p+171,    0x1.2638d6b206ee2p-3,   0x1.1fe2a8p-2, INEXACT)
T(RN,  0x1.0781a988344a6p+171,   -0x1.eb34d1c714c71p-1,   0x1.02d96ep-3, INEXACT)
T(RN,  0x1.e735cbc580273p+172,    0x1.f08249fb8b117p-1,  -0x1.330adap-2, INEXACT)
T(RN,  0x1.16c243606dd8ap+172,   -0x1.ef1a622b5e644p-2,   0x1.a7b49cp-2, INEXACT)
T(RN,  0x1.6d5d6a80be628p+172,   -0x1.c4c3d29763336p-1,  -0x1.52171cp-2, INEXACT)
T(RN,  0x1.4af5e8ca0d0d4p+172,   -0x1.97b3afe52f35ap-3,   0x1.4aebc2p-2, INEXACT)
T(RN,  0x1.2e6ad0be8778cp+172,   -0x1.005ecab7fe341p-1,   -0x1.2997bp-3, INEXACT)
T(RN,  0x1.ec55036f7c4fap+172,   -0x1.f303d962183cap-3,  -0x1.e78dfep-3, INEXACT)
T(RN,  0x1.69fea58254e7bp+172,    0x1.5f30b423c1ea2p-1,   0x1.25ac1ep-3, INEXACT)
T(RN,  0x1.fe61fd1841e27p+172,   -0x1.996fa645d1a84p-4,   0x1.5ff30ap-3, INEXACT)
T(RN,  0x1.afd39c6dcc1e4p+172,    0x1.f662a7dd15be1p-1,   0x1.59496ap-2, INEXACT)
T(RN,  0x1.6828985f61c37p+172,   -0x1.c8fe254199abdp-1,  -0x1.16177ep-3, INEXACT)
T(RN,  0x1.6d2613b23ee4ep+173,    0x1.ff0166a2fa941p-1,   0x1.310734p-5, INEXACT)
T(RN,  0x1.1934a553a7695p+173,   -0x1.7a17932a10881p-1,  -0x1.66aea2p-2, INEXACT)
T(RN,  0x1.17e9ec33f01c6p+173,    0x1.fb06605b9416cp-1,   0x1.d81998p-2, INEXACT)
T(RN,  0x1.436fa6117d877p+173,    0x1.f39be7cf986d1p-1,    0x1.5c656p-4, INEXACT)
T(RN,  0x1.19395a10cd3c5p+173,   -0x1.9013ed5a87c8fp-1,  -0x1.ef4f48p-2, INEXACT)
T(RN,  0x1.4ceb14cb7dea4p+173,    0x1.380051fef6fe1p-2,  -0x1.1168b4p-3, INEXACT)
T(RN,  0x1.bb242ffef0842p+173,   -0x1.be7faf580b319p-1,  -0x1.db16acp-2, INEXACT)
T(RN,   0x1.5fc7c9414b3fp+173,   -0x1.18905d7d5ab7ap-4,  -0x1.5436d2p-2, INEXACT)
T(RN,  0x1.49486df973413p+173,    0x1.014ac38d90114p-1,  -0x1.0dfd4cp-3, INEXACT)
T(RN,  0x1.053d8dbd48f3ep+173,   -0x1.f210888e3489dp-1,  -0x1.45e02ep-2, INEXACT)
T(RN,  0x1.1b3b440323e7fp+174,    0x1.ec48a691d798dp-2,   -0x1.5e9bfp-7, INEXACT)
T(RN,  0x1.1e5b70f088669p+174,   -0x1.b04528beb2de2p-3,  -0x1.255534p-3, INEXACT)
T(RN,   0x1.5cbef315c979p+174,   -0x1.0aa16c4e5fa8bp-1,  -0x1.366af8p-2, INEXACT)
T(RN,  0x1.07691e77d818dp+174,   -0x1.6db6687bf1f2dp-2,  -0x1.74857cp-2, INEXACT)
T(RN,  0x1.9ba08d18e9f5ep+174,    0x1.d95ea722e0eadp-1,   0x1.ef17dcp-3, INEXACT)
T(RN,  0x1.09cb847a9565ap+174,    0x1.1c65470d54009p-1,  -0x1.8b1476p-5, INEXACT)
T(RN,  0x1.2c9abaf892d35p+174,    0x1.d90b45b47752cp-1,  -0x1.55bf9cp-5, INEXACT)
T(RN,  0x1.e2d74eeb01e66p+174,   -0x1.34a5fee56c0eap-1,   0x1.e392b2p-5, INEXACT)
T(RN,  0x1.32d4a4e9a7301p+174,    0x1.aae92f561b941p-1,   0x1.23f746p-2, INEXACT)
T(RN,  0x1.b8f5c04a9fbbap+174,   -0x1.fffebce8ef373p-1,   0x1.6d8ef6p-2, INEXACT)
T(RN,  0x1.22da667a5896fp+175,    0x1.cf69af9c7a5d7p-1,  -0x1.f09a0ap-3, INEXACT)
T(RN,  0x1.94d9a4835126cp+175,   -0x1.3556a3ac048d4p-1,   0x1.f1ea9ap-3, INEXACT)
T(RN,  0x1.0976f2985ed09p+175,   -0x1.ef260cc6bbc5cp-1,  -0x1.5dfae8p-5, INEXACT)
T(RN,  0x1.7b6e175e4bc1dp+175,    -0x1.e6006bb15c05p-1,   0x1.ee73b6p-2, INEXACT)
T(RN,  0x1.dc3734f79340ep+175,   -0x1.f6a9b22b292ecp-1,  -0x1.fefe7ap-4, INEXACT)
T(RN,  0x1.26b855829a516p+175,   -0x1.f9603baedb327p-1,   -0x1.5797cp-2, INEXACT)
T(RN,  0x1.7f75cfb3424ccp+175,     0x1.efe718d4c3b6p-1,   0x1.ef6fcep-3, INEXACT)
T(RN,  0x1.7eadafb0d286ap+175,    0x1.c4f13c4fed98ep-1,   -0x1.55ccap-3, INEXACT)
T(RN,  0x1.29c3832dcf3e1p+175,   -0x1.4c38988dd45ddp-1,   0x1.b294eap-2, INEXACT)
T(RN,  0x1.5b1eda98df4c7p+175,   -0x1.0c055cbe1a55ap-2,  -0x1.ddd622p-2, INEXACT)
T(RN,  0x1.4d0fef71974d8p+176,   -0x1.fc7d9d4fee476p-1,  -0x1.c1a314p-6, INEXACT)
T(RN,  0x1.2f2348c8cbee3p+176,   -0x1.79202c95cc513p-1,  -0x1.1f7ad4p-2, INEXACT)
T(RN,  0x1.3d40ea42d91e7p+176,    0x1.ffe289a74dbefp-1,   0x1.cf1cc8p-2, INEXACT)
T(RN,  0x1.213e6f610b183p+176,   -0x1.0ee55c3244f9ap-4,   0x1.96f5cap-5, INEXACT)
T(RN,  0x1.e9b7c2d9b8a09p+176,   -0x1.5c921382b7887p-1,   0x1.dd540ap-2, INEXACT)
T(RN,  0x1.c0781e1eeb246p+176,   -0x1.10529f724bd8ap-1,  -0x1.90a714p-2, INEXACT)
T(RN,  0x1.38585c5af3ec7p+176,    0x1.fbedb902cfd91p-1,   0x1.b287d4p-2, INEXACT)
T(RN,  0x1.d3570c79b81aap+176,    0x1.c94c34bc4ee8ap-1,   0x1.039426p-2, INEXACT)
T(RN,  0x1.58a383a03e2f5p+176,   -0x1.6662cd5c6342bp-1,   0x1.581efap-5, INEXACT)
T(RN,  0x1.565ec2ba911a2p+176,   -0x1.8e5b9dbfc3722p-1,   0x1.a75e28p-2, INEXACT)
T(RN,  0x1.600180b916fc6p+177,    0x1.60baeccade364p-2,  -0x1.1831e4p-2, INEXACT)
T(RN,  0x1.172cf6d61780cp+177,    0x1.22b94108caaf3p-5,  -0x1.e351f8p-3, INEXACT)
T(RN,  0x1.cbb88a8178ec7p+177,   -0x1.4ee52041f9ae7p-1,  -0x1.5eeea2p-2, INEXACT)
T(RN,  0x1.0b4e3f354dfb2p+177,    0x1.9730bf54be19fp-2,   0x1.772a5cp-2, INEXACT)
T(RN,  0x1.5ea39ceea1759p+177,    0x1.f9790c50e4f68p-1,  -0x1.6486c8p-3, INEXACT)
T(RN,  0x1.58245c064a90dp+177,    0x1.9ac8f4d0eb634p-3,  -0x1.907376p-2, INEXACT)
T(RN,  0x1.b8eb48ae2de5cp+177,    0x1.74b16e1f07d9dp-3,  -0x1.e074d2p-4, INEXACT)
T(RN,  0x1.7385f6b8dbbf8p+177,    0x1.6c2a23d07f961p-3,  -0x1.5f0e84p-2, INEXACT)
T(RN,  0x1.acbc1acb0b36cp+177,    0x1.7b980c72d2762p-3,   0x1.9b9778p-3, INEXACT)
T(RN,  0x1.63013ca6d3391p+177,   -0x1.fffa49a059a5fp-1,    0x1.1d17dp-2, INEXACT)
T(RN,  0x1.035c03b15a923p+178,    0x1.b990296b90d69p-2,   0x1.6d8fa8p-2, INEXACT)
T(RN,  0x1.979ccc71648d2p+178,   -0x1.d387bc1aa693bp-4,   0x1.0be42ap-2, INEXACT)
T(RN,  0x1.6bd9e03920c1ap+178,   -0x1.f69dee02ab154p-1,  -0x1.f66974p-2, INEXACT)
T(RN,  0x1.e3a7a12964d5ap+178,   -0x1.529dfdccfd2b2p-2,  -0x1.5f0a68p-2, INEXACT)
T(RN,  0x1.a1ef44785d7eap+178,   -0x1.f833c2fb658d4p-1,   0x1.73b986p-2, INEXACT)
T(RN,  0x1.35dd2402fad68p+178,   -0x1.8647fb8911b26p-1,  -0x1.f3a85ap-2, INEXACT)
T(RN,  0x1.e480a53a22054p+178,    0x1.753dfa39eba72p-1,   0x1.9c03fcp-4, INEXACT)
T(RN,  0x1.4bfdfcf63c68ap+178,   -0x1.62b2a89ea4996p-3,   0x1.d64888p-2, INEXACT)
T(RN,  0x1.eabf87b762a96p+178,    0x1.c055efdfa637ap-1,   0x1.cbe392p-2, INEXACT)
T(RN,  0x1.6881639e27cb9p+178,   -0x1.d4df57c448753p-1,  -0x1.2864fcp-4, INEXACT)
T(RN,  0x1.33afddb39e145p+179,   -0x1.9535acfc0c30cp-3,  -0x1.7bcd68p-5, INEXACT)
T(RN,   0x1.f3d7e543fd3fp+179,    0x1.aa6f1ad26356ep-1,  -0x1.873a2cp-6, INEXACT)
T(RN,  0x1.a156c51d0887bp+179,    0x1.e2e25f8156153p-1,   0x1.03e3c4p-2, INEXACT)
T(RN,  0x1.1855f180c78cbp+179,   -0x1.d0b284eb942f3p-2,   0x1.356a66p-2, INEXACT)
T(RN,  0x1.f86ecc10e8f1ep+179,    0x1.fd7dab7b80d3fp-1,   0x1.fdd426p-2, INEXACT)
T(RN,  0x1.fd9542e5821b8p+179,   -0x1.b5e5042d6a939p-4,  -0x1.ee5ca2p-7, INEXACT)
T(RN,  0x1.2cb75b7d11be2p+179,   -0x1.fffdc4d55863bp-1,   0x1.181932p-2, INEXACT)
T(RN,  0x1.3a9f7e5de82aep+179,   -0x1.56449d8d17e09p-2,   0x1.079a26p-2, INEXACT)
T(RN,  0x1.65f5523f656dbp+179,   -0x1.641fee3edcb58p-1,    0x1.d8d41p-6, INEXACT)
T(RN,  0x1.f28904eceab5cp+179,   -0x1.f44d73be86807p-3,  -0x1.701068p-8, INEXACT)
T(RN,  0x1.bc26a11a6ea4cp+180,    0x1.e4cae0063d3c1p-1,  -0x1.0378cep-3, INEXACT)
T(RN,  0x1.a9fca8bd4bf28p+180,    0x1.16bb24be8016ap-3,  -0x1.bddfbap-2, INEXACT)
T(RN,  0x1.f437e9b9a3212p+180,   -0x1.d44e335b033aap-1,   0x1.b42bdep-3, INEXACT)
T(RN,  0x1.423445f3685c8p+180,   -0x1.843511b6e7c73p-1,  -0x1.c574c8p-3, INEXACT)
T(RN,  0x1.3488788ef8d75p+180,   -0x1.f663b8ec5953cp-1,  -0x1.31f61cp-3, INEXACT)
T(RN,  0x1.82eb6df110133p+180,   -0x1.ffd7c955f20d3p-1,  -0x1.efa09cp-8, INEXACT)
T(RN,  0x1.a78a9132ceb56p+180,   -0x1.a4147a4f543f5p-1,   0x1.f70e1ap-3, INEXACT)
T(RN,   0x1.5ccbc4c3d199p+180,    0x1.f9c4c03442147p-1,  -0x1.81d94ap-3, INEXACT)
T(RN,  0x1.5124c6db30b2ap+180,    0x1.85c73dd8f82e7p-1,   0x1.227d96p-3, INEXACT)
T(RN,  0x1.2f2ef71d9c218p+180,   -0x1.fffe5f017a556p-1,   -0x1.e4b63p-2, INEXACT)
T(RN,  0x1.3c44dc3f9f939p+181,    0x1.632fd21ef1fc9p-4,    -0x1.dd32p-4, INEXACT)
T(RN,  0x1.7a6898bd16bf5p+181,    0x1.0b9e813b2fc82p-4,  -0x1.efc5c4p-2, INEXACT)
T(RN,  0x1.c98a5538980a6p+181,    0x1.fe46fa4f2f132p-1,   0x1.c730b4p-3, INEXACT)
T(RN,   0x1.dd51055494a8p+181,    0x1.f98819487afcbp-1,  -0x1.1e2a84p-2, INEXACT)
T(RN,   0x1.6f9f5aa809fep+181,    0x1.da54709da34b6p-4,  -0x1.c6ad94p-2, INEXACT)
T(RN,  0x1.88716d40bf803p+181,    0x1.5623b6d3e72eap-1,   0x1.b13bdcp-2, INEXACT)
T(RN,  0x1.57b3711c7233ap+181,   -0x1.e261bea83d5f7p-1,   0x1.bcc354p-2, INEXACT)
T(RN,  0x1.c25706d463a46p+181,   -0x1.701adbb43595bp-2,   0x1.ad20e4p-2, INEXACT)
T(RN,  0x1.0f3d65fe31247p+181,    0x1.af569889e5b46p-1,  -0x1.ae0c08p-2, INEXACT)
T(RN,  0x1.b3cffa2a460aep+181,    0x1.fd33f52863f77p-1,  -0x1.74eb0ep-2, INEXACT)
T(RN,  0x1.2114922f35b79p+182,    0x1.a7bb677f8f9c8p-1,  -0x1.25ff66p-3, INEXACT)
T(RN,  0x1.2cce862ce3696p+182,    0x1.fb60f0fd04c57p-1,  -0x1.c2d1b8p-2, INEXACT)
T(RN,  0x1.2bd65ae406485p+182,    0x1.0ef8b3559d5d2p-1,   0x1.3d415cp-2, INEXACT)
T(RN,   0x1.8425f7e28a97p+182,    0x1.07d2e2f9fc851p-1,  -0x1.116508p-2, INEXACT)
T(RN,  0x1.554e68574efc8p+182,    0x1.fa3a9a9e1b2d6p-1,  -0x1.1bd146p-4, INEXACT)
T(RN,   0x1.84515043bd6bp+182,    0x1.e302e7d7e63c3p-3,   0x1.deb606p-2, INEXACT)
T(RN,  0x1.7381423db3076p+182,    0x1.fcfe3e21ed1dbp-1,   0x1.1710c6p-3, INEXACT)
T(RN,  0x1.77cbde836e18ap+182,   -0x1.fe5fa649f3e48p-1,  -0x1.3218d6p-2, INEXACT)
T(RN,  0x1.428411614014cp+182,   -0x1.ffff25340b5d3p-1,  -0x1.409cc8p-4, INEXACT)
T(RN,  0x1.ac1da4f6adc0dp+182,    0x1.fff9ead23428ap-1,   0x1.427426p-3, INEXACT)
T(RN,  0x1.bdeb10d536032p+183,    0x1.33a3475a74b92p-1,  -0x1.4d9598p-2, INEXACT)
T(RN,  0x1.b69685ac49da4p+183,   -0x1.4518fead6fef1p-1,  -0x1.46650ap-3, INEXACT)
T(RN,  0x1.62013ff5c37cap+183,    0x1.ffa85a2d9473ep-1,   0x1.70a4f4p-2, INEXACT)
T(RN,  0x1.5a501baacad49p+183,   -0x1.caf6ac35dc8a1p-3,  -0x1.04d3fep-2, INEXACT)
T(RN,  0x1.4563cd3260402p+183,   -0x1.2a5ed08a65bc4p-2,    0x1.0aebcp-3, INEXACT)
T(RN,  0x1.630b86bd4452ap+183,    0x1.5ae4b4cc8491bp-5,   0x1.fe602cp-3, INEXACT)
T(RN,  0x1.a6f8803f3f4d6p+183,    0x1.0e7d8ae653f54p-3,   0x1.8c2782p-2, INEXACT)
T(RN,   0x1.e58a2bb6127cp+183,    0x1.797b976a83e3ep-1,  -0x1.297b86p-2, INEXACT)
T(RN,  0x1.6755c09750bb7p+183,   -0x1.ff760a5374733p-1,  -0x1.55eb66p-2, INEXACT)
T(RN,   0x1.587327855c9dp+183,    0x1.511d710396578p-3,  -0x1.22e388p-2, INEXACT)
T(RN,  0x1.eedde0223f79cp+184,   -0x1.a2a29c8948861p-2,   -0x1.9bec6p-2, INEXACT)
T(RN,  0x1.d8980116cc726p+184,   -0x1.f67263e18ae3dp-1,  -0x1.694906p-3, INEXACT)
T(RN,   0x1.5340f0deb7abp+184,    0x1.faad3c531677dp-1,   0x1.daa5a4p-4, INEXACT)
T(RN,  0x1.bc46db547e086p+184,    0x1.71a47fbbb81ebp-1,  -0x1.2c134ep-3, INEXACT)
T(RN,  0x1.ee2537501edcep+184,    0x1.ea90bb5065692p-1,   0x1.dfab82p-4, INEXACT)
T(RN,  0x1.7b34c3962076cp+184,    0x1.ba149665de34cp-1,   0x1.c97f9ap-7, INEXACT)
T(RN,  0x1.27ee8602edac2p+184,    0x1.671080e76541bp-4,  -0x1.1fa6b6p-2, INEXACT)
T(RN,   0x1.0fa2587c7962p+184,    0x1.f255407d2537fp-1,  -0x1.b0188cp-2, INEXACT)
T(RN,  0x1.98602e751674ap+184,   -0x1.d9a86198485fap-1,  -0x1.aaf5c4p-3, INEXACT)
T(RN,  0x1.896332bf764f8p+184,    0x1.daa0a4882d90ep-1,  -0x1.4e2fa2p-8, INEXACT)
T(RN,  0x1.5b48a4518f604p+185,   -0x1.ffb72377ce31ep-1,  -0x1.78c004p-2, INEXACT)
T(RN,  0x1.0505f037e3a44p+185,    0x1.9e1cb667dfe2dp-4,  -0x1.d97448p-3, INEXACT)
T(RN,  0x1.d74c34492d3eap+185,   -0x1.267a5ccff1243p-1,  -0x1.8b08dap-2, INEXACT)
T(RN,  0x1.3813ac685da51p+185,     0x1.b9855ea80486p-1,  -0x1.d30158p-2, INEXACT)
T(RN,  0x1.351cc8e34a4b9p+185,    -0x1.ffff789ade04p-1,  -0x1.48597ap-6, INEXACT)
T(RN,  0x1.8dbbf0627f7f4p+185,    0x1.a629648721eadp-1,  -0x1.c3b808p-4, INEXACT)
T(RN,  0x1.c5d2fbaf022ffp+185,   -0x1.717da154e42c2p-4,   0x1.c9d75ap-2, INEXACT)
T(RN,  0x1.d845d367ba5fcp+185,    0x1.0b1782641bab1p-1,   0x1.19ab3ep-5, INEXACT)
T(RN,  0x1.3f1fe17fae731p+185,   -0x1.4723c9f1bb0d8p-2,   0x1.734306p-3, INEXACT)
T(RN,   0x1.fbd2174a8291p+185,    0x1.ab42027ad4053p-2,  -0x1.aa54a6p-3, INEXACT)
T(RN,   0x1.733d01064127p+186,    0x1.fef28ca8474aep-1,  -0x1.bb44bcp-3, INEXACT)
T(RN,  0x1.f5ec20a699ca7p+186,   -0x1.c303ef96bf11ep-2,  -0x1.a9caa4p-2, INEXACT)
T(RN,  0x1.259fe83c04ffap+186,   -0x1.977bb8a30b895p-7,  -0x1.e52094p-2, INEXACT)
T(RN,  0x1.919f1f9fc8b5ap+186,    0x1.abea9c64ef7f9p-1,   0x1.00afaap-4, INEXACT)
T(RN,  0x1.093ff58fef182p+186,   -0x1.dfb7ea9a61de1p-1,  -0x1.c42fa6p-2, INEXACT)
T(RN,  0x1.60b2ae1d3f658p+186,    0x1.e2d64410af576p-1,  -0x1.7ed92cp-2, INEXACT)
T(RN,   0x1.89414e6218cap+186,   -0x1.e62abd6bdc22ap-1,  -0x1.28183ap-5, INEXACT)
T(RN,   0x1.a9cbe746dcb4p+186,     0x1.50d42bb11b71p-3,   0x1.be6e2ep-2, INEXACT)
T(RN,  0x1.72c3e40873df8p+186,    0x1.5e8927fe99c75p-2,  -0x1.a2153ep-4, INEXACT)
T(RN,  0x1.e531ad65ec719p+186,    0x1.d8da03dcc5d1bp-6,    0x1.4fbf9p-5, INEXACT)
T(RN,  0x1.b486bcdfba148p+187,    0x1.0ba6fa2b40f6ap-4,   0x1.9f7212p-2, INEXACT)
T(RN,  0x1.01cd6b29e6e51p+187,    0x1.bb2f2f2ad1cc1p-1,   0x1.097178p-2, INEXACT)
T(RN,  0x1.5a638ea05d282p+187,    0x1.e6111bf60b0afp-1,  -0x1.00725ap-3, INEXACT)
T(RN,  0x1.427c4a8a96c81p+187,    0x1.ef127ca89dadfp-2,   0x1.db241ep-4, INEXACT)
T(RN,  0x1.ad77f8bf25da5p+187,    0x1.fbde247e9222ep-1,   0x1.bd392cp-3, INEXACT)
T(RN,  0x1.9304fe669de14p+187,   -0x1.f78e1063e0b61p-1,    0x1.92094p-2, INEXACT)
T(RN,  0x1.d44299e447398p+187,    -0x1.f6385dd02925p-1,   0x1.f66cbap-9, INEXACT)
T(RN,  0x1.c3d68e690beaep+187,    0x1.47a20444a2fc1p-2,  -0x1.1b9136p-2, INEXACT)
T(RN,  0x1.6f2805623ea0fp+187,   -0x1.de55169f0fedbp-1,   -0x1.57c35p-4, INEXACT)
T(RN,  0x1.ec95fb85d4bd1p+187,   -0x1.221fa5b67314dp-2,   0x1.af6366p-2, INEXACT)
T(RN,  0x1.141d0cb81356ep+188,   -0x1.7b130a334c4aep-2,   0x1.735aecp-2, INEXACT)
T(RN,  0x1.b9142f7ed2508p+188,    0x1.e6599f6342459p-1,    -0x1.455ap-3, INEXACT)
T(RN,  0x1.f13fcc9052395p+188,   -0x1.09c2a5671c7a2p-1,   0x1.a80faap-3, INEXACT)
T(RN,  0x1.4a641fad56d56p+188,    0x1.ffda420542b74p-1,  -0x1.9ba096p-4, INEXACT)
T(RN,  0x1.c995a1fdafeeep+188,   -0x1.6e3a56bd06376p-4,   -0x1.9fd97p-2, INEXACT)
T(RN,  0x1.c34fd4c41e0fep+188,    0x1.e7c47741c8868p-1,    0x1.b162ap-4, INEXACT)
T(RN,  0x1.e09907709eaeap+188,    0x1.fd587be19d334p-1,   0x1.7ebf3ap-3, INEXACT)
T(RN,   0x1.e590103fe466p+188,    0x1.6b492fbda6d23p-2,  -0x1.5a3e2cp-3, INEXACT)
T(RN,  0x1.ea400f64f9994p+188,   -0x1.89c83f8cefc46p-2,  -0x1.d06af6p-5, INEXACT)
T(RN,  0x1.b65a6b6b49b9ap+188,   -0x1.ec801b0296d88p-3,   0x1.b62a82p-3, INEXACT)
T(RN,  0x1.f76df4f16e5dcp+189,   -0x1.c73dfd55c3eb5p-2,  -0x1.961b72p-3, INEXACT)
T(RN,  0x1.1c900e4fcb799p+189,     0x1.fefa95d01491p-1,    0x1.9b6e7p-3, INEXACT)
T(RN,  0x1.87d9c997c72aep+189,    0x1.f2d21f33f18d3p-2,   0x1.e2a9fcp-2, INEXACT)
T(RN,  0x1.7283d979afcc9p+189,   -0x1.fc1a0b63590edp-1,   0x1.47a134p-2, INEXACT)
T(RN,  0x1.7808e0e63f321p+189,   -0x1.9d7bbca6308f4p-1,   0x1.8ab2a8p-2, INEXACT)
T(RN,  0x1.e89425eac4765p+189,    0x1.b1000f0f67858p-1,   0x1.de0c48p-2, INEXACT)
T(RN,  0x1.f419e754aa87ep+189,   -0x1.c98bfaf097044p-1,  -0x1.f87c5ap-4, INEXACT)
T(RN,  0x1.8fab3e2bd779fp+189,   -0x1.23f5d20ffa2ccp-2,    0x1.14aa2p-3, INEXACT)
T(RN,  0x1.d140eb6c69fbep+189,    0x1.df42fa8f56701p-1,   0x1.6ed9c8p-2, INEXACT)
T(RN,  0x1.57cd3710fdea4p+189,   -0x1.7bc1a153d2ea5p-3,   -0x1.9f3e1p-3, INEXACT)
T(RN,  0x1.5eb8db060f5d7p+190,    0x1.b2249a660b4dbp-1,  -0x1.78fd9ep-2, INEXACT)
T(RN,   0x1.cafbf5356961p+190,    0x1.ca33e527def46p-1,   0x1.3ee062p-2, INEXACT)
T(RN,  0x1.ac3a534c917bep+190,   -0x1.272f6f5b8346ep-2,    0x1.344a1p-2, INEXACT)
T(RN,  0x1.193e6e79c098dp+190,    0x1.9f508cbfdeee6p-4,  -0x1.ca9d3ep-2, INEXACT)
T(RN,  0x1.9a7545a60e674p+190,   -0x1.e2347745fdfecp-1,  -0x1.d042f8p-2, INEXACT)
T(RN,  0x1.460b1eb142045p+190,   -0x1.f734e55d6c939p-1,  -0x1.3d3302p-2, INEXACT)
T(RN,  0x1.4dc5bf95af91dp+190,   -0x1.6acb0a204fb88p-2,  -0x1.f89368p-2, INEXACT)
T(RN,  0x1.d19bc20a3a23dp+190,   -0x1.dbfae88780629p-1,   -0x1.6ee14p-2, INEXACT)
T(RN,  0x1.a48f8da40f80ep+190,   -0x1.f0a8ae8416111p-2,  -0x1.8fc3fap-2, INEXACT)
T(RN,  0x1.a68c56b7febc1p+190,    0x1.19ff521d5d7b6p-1,   0x1.4bf9a8p-4, INEXACT)
T(RN,  0x1.27408eeab2378p+191,   -0x1.f5e0d7b94ed98p-2,  -0x1.2b0346p-5, INEXACT)
T(RN,  0x1.706fb3a2214ebp+191,   -0x1.fe82838c270b4p-1,  -0x1.36920ep-3, INEXACT)
T(RN,  0x1.f9461a0ede0b2p+191,     0x1.cbdb78c0dc09p-1,   0x1.521f4ap-6, INEXACT)
T(RN,  0x1.374b70552911bp+191,    0x1.ab07392683814p-1,   0x1.7ffb52p-2, INEXACT)
T(RN,  0x1.d8f4d0de73373p+191,   -0x1.a11d0d632ee46p-1,   0x1.06900cp-2, INEXACT)
T(RN,  0x1.219babd3ed6cfp+191,   -0x1.75d2e46457391p-1,  -0x1.3badd4p-5, INEXACT)
T(RN,  0x1.d3f0dba251bf3p+191,   -0x1.911de1292ae9ep-1,  -0x1.54fda4p-5, INEXACT)
T(RN,  0x1.cc48e37a55a5cp+191,    0x1.1ac6cb10feb4dp-6,   0x1.06114ep-3, INEXACT)
T(RN,  0x1.11aef1c0d03aep+191,   -0x1.fdfdd54db6cccp-1,  -0x1.404d58p-2, INEXACT)
T(RN,  0x1.276e6aefa8758p+191,   -0x1.d82f605cc4629p-1,   0x1.99f556p-2, INEXACT)
T(RN,  0x1.33be3c94395c1p+192,   -0x1.fc672185ce8b4p-1,   0x1.0d3068p-2, INEXACT)
T(RN,  0x1.a37bbb9bbe583p+192,     0x1.371cd280b4ccp-2,   0x1.673234p-2, INEXACT)
T(RN,  0x1.e72cf62ab7c5cp+192,   -0x1.8d638c0fb5bfbp-2,  -0x1.a5b79cp-2, INEXACT)
T(RN,   0x1.d2a0eebb0764p+192,   -0x1.d9370918c3066p-1,   0x1.0ceb24p-2, INEXACT)
T(RN,  0x1.a238ef3706c97p+192,   -0x1.60e929db235bcp-1,   0x1.a98b12p-4, INEXACT)
T(RN,  0x1.1b1b48c0515c7p+192,    0x1.d7bb7aedc3cd3p-1,   0x1.9eb166p-2, INEXACT)
T(RN,  0x1.ea4d817ff8041p+192,    0x1.3116086e7c6acp-1,   -0x1.65dcap-2, INEXACT)
T(RN,  0x1.2945a0059fdadp+192,    0x1.6188ee06a9ed3p-1,   0x1.75aa26p-4, INEXACT)
T(RN,  0x1.10eb242fd6381p+192,    0x1.fb07402adc90ap-1,   0x1.b4fdd4p-4, INEXACT)
T(RN,    0x1.ee44d557088p+192,    0x1.4c136e1b524dbp-4,     -0x1.ff8p-2, INEXACT)
T(RN,  0x1.974e703570f0ep+193,   -0x1.08422d1850a16p-3,  -0x1.5e9986p-3, INEXACT)
T(RN,  0x1.526fe84854994p+193,   -0x1.a304b89cacfaep-1,   0x1.2bb902p-3, INEXACT)
T(RN,  0x1.1e68f054f198dp+193,    0x1.8ee6ce5b0e55ap-2,   0x1.5f3ca8p-3, INEXACT)
T(RN,  0x1.d3073c181800ap+193,   -0x1.9b5a2ba8caeaep-1,   0x1.75c1d6p-2, INEXACT)
T(RN,  0x1.dfbdfbb6adb3ap+193,   -0x1.c1ce8c3515ad6p-1,   -0x1.be73dp-5, INEXACT)
T(RN,  0x1.b63c623a9d72ap+193,   -0x1.49e935cdb92b8p-3,  -0x1.bf93aep-4, INEXACT)
T(RN,  0x1.43320041d7d2ep+193,    0x1.0f7e42cbd70c3p-2,  -0x1.60107ep-4, INEXACT)
T(RN,   0x1.4934ccf3e63fp+193,   -0x1.c33a95f3f8ec1p-2,   0x1.6e8924p-4, INEXACT)
T(RN,   0x1.fc49bab8e026p+193,    0x1.8d18e6f177b43p-1,  -0x1.b79cfep-2, INEXACT)
T(RN,  0x1.2323bc58bb1bbp+193,   -0x1.7e6dfeccfa191p-3,   -0x1.5cebfp-3, INEXACT)
T(RN,  0x1.645378fa2b704p+194,    0x1.9ce3332e4df9dp-1,  -0x1.00b068p-3, INEXACT)
T(RN,  0x1.c51836f69113dp+194,   -0x1.ef79292df48b2p-1,  -0x1.70c19ep-3, INEXACT)
T(RN,  0x1.f061ad9eea502p+194,   -0x1.fdffc5959eb37p-1,   0x1.0ade64p-2, INEXACT)
T(RN,  0x1.512298adad7a7p+194,    0x1.31a0f7a6f4da3p-1,   0x1.31828ep-2, INEXACT)
T(RN,  0x1.9ffe0e8270198p+194,   -0x1.31cb372e1b35bp-1,   -0x1.8b562p-2, INEXACT)
T(RN,  0x1.ad3232a6c364bp+194,    0x1.f9d403fc29557p-1,   0x1.5f9b56p-4, INEXACT)
T(RN,   0x1.ad6a74b6f0c4p+194,    0x1.f9f0a70c22442p-1,   0x1.8b399ep-2, INEXACT)
T(RN,  0x1.1b8c17c562fe3p+194,    0x1.51a921cd3c58bp-1,  -0x1.2ce74ep-2, INEXACT)
T(RN,  0x1.d9ba7aa688f35p+194,    0x1.53a290c1a4eaap-4,    0x1.dc959p-2, INEXACT)
T(RN,  0x1.d4daacd05dfedp+194,    0x1.ec0431bebb6e1p-1,  -0x1.ad2768p-2, INEXACT)
T(RN,  0x1.c58ec58f13bdap+195,    0x1.f211220f29341p-4,  -0x1.804284p-2, INEXACT)
T(RN,  0x1.594984d9e0895p+195,    0x1.7619844227e66p-1,  -0x1.e50372p-3, INEXACT)
T(RN,  0x1.ead0ceb35907ap+195,    0x1.fc8e284837cbdp-1,  -0x1.ba85bcp-5, INEXACT)
T(RN,  0x1.d6f995ef0c866p+195,    0x1.f4c66bf0f3d93p-1,   -0x1.c1e34p-2, INEXACT)
T(RN,    0x1.070daebabfap+195,   -0x1.9ed60b889db9ap-2,  -0x1.fc45b2p-2, INEXACT)
T(RN,  0x1.279961c122fabp+195,    0x1.f305ac42de161p-1,  -0x1.41a82ep-3, INEXACT)
T(RN,  0x1.38ebf3ed6059bp+195,    0x1.e44b8ec3dea5dp-1,   0x1.906bb6p-3, INEXACT)
T(RN,  0x1.aec5cd47f80f4p+195,    0x1.cf1cc752b526fp-1,   0x1.6306fap-3, INEXACT)
T(RN,  0x1.33871087d9a8dp+195,    0x1.45c8366ca0f9fp-4,   0x1.7fea98p-2, INEXACT)
T(RN,  0x1.7cb1a6da7447fp+195,   -0x1.3646ff038f5d5p-1,   0x1.1df102p-4, INEXACT)
T(RN,  0x1.da5c54f4ccbb9p+196,    0x1.cd84168e9c109p-1,   0x1.f0914ep-2, INEXACT)
T(RN,  0x1.58b5923b72a38p+196,   -0x1.ff827590c148bp-1,  -0x1.db69fap-3, INEXACT)
T(RN,   0x1.f8089cb0878ep+196,   -0x1.1e324effa5b0bp-2,  -0x1.286b7ep-2, INEXACT)
T(RN,  0x1.c7c0eeb990644p+196,   -0x1.ff1bed0a23815p-1,  -0x1.97f67cp-3, INEXACT)
T(RN,  0x1.8ac71f742536bp+196,   -0x1.483bea788dd7bp-2,  -0x1.eb0e84p-2, INEXACT)
T(RN,  0x1.a68fc3178c5dap+196,    0x1.f471a19af4325p-1,   -0x1.3f4eep-2, INEXACT)
T(RN,  0x1.080bbecf6bc5fp+196,    0x1.6f843641d565ap-1,   0x1.319d06p-2, INEXACT)
T(RN,  0x1.5244ffe038399p+196,    0x1.e0d7fda39a692p-1,  -0x1.878a4ep-5, INEXACT)
T(RN,  0x1.1ced609fb8431p+196,     0x1.c4ec7517a4f8p-1,   0x1.332696p-2, INEXACT)
T(RN,    0x1.77ae4539d91p+196,   -0x1.43e6c3c1cd8c2p-1,  -0x1.1ae55ep-2, INEXACT)
T(RN,  0x1.aaef8ebf5a86bp+197,     0x1.8cd69ecc77a6p-1,   0x1.143656p-2, INEXACT)
T(RN,  0x1.41d5e67f4a3efp+197,   -0x1.b980a00739da2p-1,   0x1.b8eebep-2, INEXACT)
T(RN,  0x1.ffa2ff311479ep+197,   -0x1.21d847186bd31p-1,     0x1.7d6cp-2, INEXACT)
T(RN,  0x1.066847cc586e3p+197,    0x1.b61d03de1cb4ep-4,   -0x1.bc006p-3, INEXACT)
T(RN,  0x1.baaddc47d893ep+197,   -0x1.c68b341c26095p-3,   0x1.03466ap-2, INEXACT)
T(RN,  0x1.0604d1c55f40ep+197,    0x1.fc6616c103852p-2,   0x1.32be48p-5, INEXACT)
T(RN,  0x1.37bb5f7e0cd3ep+197,    0x1.9a3c60bbeb274p-3,   0x1.587954p-4, INEXACT)
T(RN,  0x1.8ef8d9bd544c2p+197,    0x1.fe0f1d74a9f02p-1,   0x1.221fdep-2, INEXACT)
T(RN,  0x1.0f680b13419f7p+197,    -0x1.2a3880c4dde2p-1,  -0x1.da0922p-2, INEXACT)
T(RN,  0x1.a40788adaa9d8p+197,    0x1.f3588d3f0c888p-1,  -0x1.669ffep-3, INEXACT)
T(RN,  0x1.c3058768970a4p+198,    0x1.e843cb27ce357p-1,   0x1.05bf32p-2, INEXACT)
T(RN,  0x1.d1a6fa123af1ap+198,    -0x1.6b05527127b3p-4,  -0x1.7422d4p-2, INEXACT)
T(RN,  0x1.853cd2dcc609ep+198,   -0x1.e7568087840abp-1,   -0x1.be3dap-3, INEXACT)
T(RN,  0x1.dbee0b3141862p+198,   -0x1.a15ad59f8bcefp-1,    -0x1.ef9cp-2, INEXACT)
T(RN,  0x1.628d6102009ebp+198,    0x1.255e562c5d8cfp-3,   0x1.fc2e3cp-3, INEXACT)
T(RN,  0x1.4bb203bb7abadp+198,    0x1.feb6a8c00fb77p-3,  -0x1.6f22c2p-3, INEXACT)
T(RN,  0x1.6e12add504148p+198,   -0x1.02ffc5d250d35p-1,   0x1.e292ccp-2, INEXACT)
T(RN,  0x1.c951c201fa0cap+198,   -0x1.d95a5028d3ddep-1,    0x1.c3209p-2, INEXACT)
T(RN,  0x1.5a6aea33bb1a8p+198,   -0x1.885b5faf40e3ep-4,   -0x1.f2f26p-3, INEXACT)
T(RN,  0x1.259fe7ba0ab36p+198,    0x1.ffc083424a5f2p-1,  -0x1.7441d4p-2, INEXACT)
T(RN,  0x1.917dca4824eeep+199,     0x1.95390384e398p-3,   0x1.95d2a4p-2, INEXACT)
T(RN,  0x1.7c70f96ad575ep+199,    0x1.184e37c34cec4p-1,  -0x1.20b14ap-4, INEXACT)
T(RN,  0x1.436e303be3fc9p+199,    0x1.c0d056ec43f94p-3,  -0x1.3fa062p-2, INEXACT)
T(RN,  0x1.b94f0524100d9p+199,    0x1.d66cd71ffc888p-1,  -0x1.932402p-2, INEXACT)
T(RN,  0x1.0893c99d8f0afp+199,   -0x1.1f10d8048229dp-1,   -0x1.96ec7p-2, INEXACT)
T(RN,  0x1.374b66439a25bp+199,   -0x1.b49af309b3852p-1,   0x1.b32a7cp-2, INEXACT)
T(RN,  0x1.d65fca204d3f8p+199,   -0x1.f0c773aaf1241p-1,   0x1.d64502p-3, INEXACT)
T(RN,  0x1.9439145691bc8p+199,   -0x1.dd390a2e4906ep-1,  -0x1.9dfe5ap-2, INEXACT)
T(RN,   0x1.da45eba67f3ep+199,   -0x1.fee2694e4f942p-1,  -0x1.418f94p-2, INEXACT)
T(RN,  0x1.99169ee226982p+199,    0x1.f28766adfb63bp-1,  -0x1.82c198p-4, INEXACT)
T(RN,  0x1.5501fd238d4f9p+200,    0x1.4ce2a614773ecp-1,  -0x1.f01a1cp-4, INEXACT)
T(RN,  0x1.ea5ea9594c0eep+200,   -0x1.fa23e35c44212p-1,   0x1.1787c6p-2, INEXACT)
T(RN,  0x1.8fc1b78770b0ep+200,    0x1.6798eb1789454p-1,   -0x1.3eb99p-2, INEXACT)
T(RN,  0x1.94fdb7ac2af64p+200,   -0x1.212f085036629p-1,  -0x1.0d7e42p-3, INEXACT)
T(RN,  0x1.4a41e0eff04bfp+200,    0x1.58d910255d27bp-1,   0x1.3e3dfep-2, INEXACT)
T(RN,  0x1.00f6c89c6c655p+200,   -0x1.72e498a1ec89dp-2,   0x1.92b01ep-3, INEXACT)
T(RN,  0x1.4cb0014af6e01p+200,   -0x1.a8fca968aed06p-1,   0x1.3322b6p-2, INEXACT)
T(RN,  0x1.93fe65e19be0fp+200,   -0x1.fdff206355796p-1,  -0x1.45dd8ap-2, INEXACT)
T(RN,   0x1.cd09fbf1b7b9p+200,   -0x1.e3be83f5c549bp-3,  -0x1.d28032p-3, INEXACT)
T(RN,  0x1.99026ee0df66ep+200,    0x1.a6fdf1d90d71ap-1,  -0x1.e65faep-2, INEXACT)
T(RN,  0x1.276e343c0ecd1p+201,    0x1.eb68b57f382d1p-1,  -0x1.b51628p-3, INEXACT)
T(RN,  0x1.25b6f36738a3ep+201,   -0x1.72424bc9bf101p-1,   0x1.e93946p-3, INEXACT)
T(RN,  0x1.7ac0c08308b31p+201,   -0x1.c360fc939e6bfp-1,  -0x1.63e17ap-3, INEXACT)
T(RN,  0x1.6627cd8e7263ap+201,    0x1.3811341991fd6p-1,  -0x1.823d18p-2, INEXACT)
T(RN,  0x1.e5588191d868ap+201,    0x1.f788503c2722dp-1,    0x1.41c73p-6, INEXACT)
T(RN,  0x1.aa2a966d7bc12p+201,   -0x1.e47901a2f4269p-9,  -0x1.cea8c8p-3, INEXACT)
T(RN,  0x1.bc0e72fbfe9a8p+201,    0x1.f94c7670e7a53p-1,   0x1.687dcap-2, INEXACT)
T(RN,  0x1.763d78d7bf3d2p+201,    0x1.a4758d09fa513p-1,   0x1.2f8366p-5, INEXACT)
T(RN,  0x1.1255cde6d7e5cp+201,   -0x1.8d6f76c141f81p-1,  -0x1.1a8f28p-3, INEXACT)
T(RN,  0x1.f4054cd80f368p+201,   -0x1.f0dc9443bde83p-6,  -0x1.80790ep-3, INEXACT)
T(RN,  0x1.46c8ae7454a44p+202,   -0x1.c15f696016a01p-1,   0x1.9437fcp-2, INEXACT)
T(RN,  0x1.ed0a0c505274fp+202,    0x1.3660c8ee7c7a5p-2,   0x1.f748a4p-2, INEXACT)
T(RN,  0x1.d95d0e19c2d56p+202,   -0x1.7913b90b0c0d9p-1,  -0x1.3d5716p-3, INEXACT)
T(RN,  0x1.de4ba04e15402p+202,    0x1.8f411af4053f6p-1,   -0x1.4c955p-4, INEXACT)
T(RN,  0x1.b742736564b9ep+202,    0x1.755dd51adf10bp-4,  -0x1.a20286p-5, INEXACT)
T(RN,  0x1.7b7365e2b2873p+202,   -0x1.f9bad40cd6222p-1,   0x1.2cbfa4p-5, INEXACT)
T(RN,  0x1.38b380a15be99p+202,    0x1.418c4f91aee16p-6,   0x1.65a90ap-3, INEXACT)
T(RN,  0x1.340f152e420e8p+202,   -0x1.f4ecb6a906973p-1,  -0x1.7fa35ap-3, INEXACT)
T(RN,  0x1.6023f2e03c1cfp+202,   -0x1.eb0103c7955dfp-2,  -0x1.a87932p-2, INEXACT)
T(RN,  0x1.ecfb33970f9b8p+202,    0x1.e11cf14800157p-2,   -0x1.5a323p-3, INEXACT)
T(RN,  0x1.0a84f37a04532p+203,   -0x1.f55ce151856afp-1,  -0x1.7ecf56p-2, INEXACT)
T(RN,  0x1.bcd0c0e9cd2aep+203,   -0x1.63e34cd37b365p-1,  -0x1.450ffap-3, INEXACT)
T(RN,  0x1.4cf9225daa54ap+203,    0x1.fc26df8dbaa2ep-1,  -0x1.2ae5e2p-2, INEXACT)
T(RN,  0x1.55ee12062b01dp+203,    0x1.93a8603fd0fa2p-3,  -0x1.2d93acp-4, INEXACT)
T(RN,  0x1.785ac9c0564e6p+203,   -0x1.a24f8df0734efp-1,  -0x1.935dbap-3, INEXACT)
T(RN,  0x1.eb0e3aa188c82p+203,    0x1.f9c18f61f6fdbp-1,   0x1.a3d5ecp-4, INEXACT)
T(RN,  0x1.9826220504feap+203,    0x1.37a9e028b254fp-1,  -0x1.a03e22p-6, INEXACT)
T(RN,  0x1.a5b4323972aafp+203,   -0x1.92abf11d4e954p-1,   0x1.79c592p-2, INEXACT)
T(RN,  0x1.b687cd439c153p+203,     0x1.d73530532757p-1,   0x1.b60262p-5, INEXACT)
T(RN,  0x1.9b6775281e9a1p+203,    0x1.4d47ae0398f95p-1,   0x1.8b0a98p-7, INEXACT)
T(RN,  0x1.64d053c7f3b8ep+204,     0x1.8927bb96fd3cp-7,   0x1.ca3952p-5, INEXACT)
T(RN,  0x1.cb80863895baep+204,   -0x1.aab030085526fp-2,  -0x1.2b1df6p-4, INEXACT)
T(RN,  0x1.ad0482fddaf53p+204,    0x1.f20872af2908bp-1,   0x1.3c976ep-3, INEXACT)
T(RN,  0x1.f57c3b534795ep+204,   -0x1.ffb61ebab73f2p-1,   0x1.cebb68p-2, INEXACT)
T(RN,  0x1.722183a411fcep+204,   -0x1.b69a7b8962b3fp-2,  -0x1.aa7a14p-2, INEXACT)
T(RN,   0x1.3efeec81d094p+204,    0x1.a113666dc69abp-1,   0x1.86d7b6p-2, INEXACT)
T(RN,  0x1.87c3fb8ea9de4p+204,   -0x1.b09da0f17d4cap-4,  -0x1.1e0bacp-3, INEXACT)
T(RN,  0x1.dab6c17f4433bp+204,    0x1.2181ecb5effbcp-1,   0x1.9c2152p-2, INEXACT)
T(RN,  0x1.8a43ccab02ec6p+204,   -0x1.b263876ace2f5p-1,   0x1.d972b6p-4, INEXACT)
T(RN,  0x1.f761e7d0c6cdap+204,   -0x1.ff3f7607db2f1p-2,  -0x1.82bb36p-3, INEXACT)
T(RN,  0x1.053c83aaf525fp+205,    0x1.d1d2f49d1e33bp-1,  -0x1.72f95ep-2, INEXACT)
T(RN,  0x1.d6f3d02de0e27p+205,    0x1.d121355433dc8p-3,   0x1.c40f8ap-2, INEXACT)
T(RN,  0x1.8bfd2c700774cp+205,    0x1.c5a49ba8f9283p-1,  -0x1.db82bep-4, INEXACT)
T(RN,  0x1.2da07fc2b3e26p+205,    -0x1.92bfea9940f9p-1,   0x1.d828e2p-4, INEXACT)
T(RN,  0x1.078d91e478c72p+205,   -0x1.f16f9a2c76bb3p-1,  -0x1.154294p-2, INEXACT)
T(RN,  0x1.f51b7d25c7771p+205,   -0x1.7de839b4d6757p-1,  -0x1.9cecbap-3, INEXACT)
T(RN,  0x1.a1a32d74ea502p+205,   -0x1.790fe70502c73p-1,    0x1.da398p-2, INEXACT)
T(RN,  0x1.b181ac89d9379p+205,    0x1.2f955d6d827fbp-1,   0x1.af9958p-3, INEXACT)
T(RN,  0x1.b79f67df6f5c4p+205,    0x1.8fd13fc96d836p-3,  -0x1.cecacap-4, INEXACT)
T(RN,  0x1.53375c924cee6p+205,    0x1.a268d8be5b59ap-3,  -0x1.489d58p-4, INEXACT)
T(RN,  0x1.4749412e5a133p+206,     0x1.78a82b27c33bp-5,   0x1.28a4c8p-2, INEXACT)
T(RN,  0x1.e79d8cce429b8p+206,   -0x1.1bc23a0467942p-1,  -0x1.c0dde4p-2, INEXACT)
T(RN,  0x1.b3985d08dc586p+206,   -0x1.fffa916191867p-1,   0x1.74a7a6p-6, INEXACT)
T(RN,  0x1.dd3f269146e22p+206,    0x1.b19ca4a0a2ea9p-1,   0x1.dbc6dcp-4, INEXACT)
T(RN,  0x1.da2f4d8283209p+206,   -0x1.fe59c3ece52c6p-1,   -0x1.ae151p-2, INEXACT)
T(RN,  0x1.cbeaf2cd5b688p+206,    0x1.f95874b930ebap-1,  -0x1.4ea742p-4, INEXACT)
T(RN,  0x1.f9324c67464c7p+206,    0x1.fd43576b8bacep-1,  -0x1.3e5132p-2, INEXACT)
T(RN,  0x1.22f0957b34dd2p+206,    0x1.e17734ba0dd29p-2,  -0x1.085f22p-3, INEXACT)
T(RN,  0x1.4584e598b0764p+206,     0x1.fe543db641c3p-4,  -0x1.6c6a16p-2, INEXACT)
T(RN,  0x1.e02e40a3ce3bep+206,    0x1.d844db5bf8602p-1,   0x1.1996f8p-4, INEXACT)
T(RN,   0x1.823f318b68c6p+207,    0x1.ef9d229cc2421p-1,  -0x1.ee9c4ep-2, INEXACT)
T(RN,  0x1.79eb490e6f19ep+207,   -0x1.11408b31d28c8p-1,  -0x1.52d55ap-2, INEXACT)
T(RN,  0x1.a528ae8e4e0a4p+207,    0x1.d49d7c3a3e16ep-3,   -0x1.73d95p-2, INEXACT)
T(RN,  0x1.ed8236c2c3b3dp+207,    0x1.f7a109d667bfap-1,   0x1.faaeaep-2, INEXACT)
T(RN,  0x1.abe3e613355a5p+207,    0x1.ff5c94fffc981p-3,   0x1.a5ba06p-2, INEXACT)
T(RN,  0x1.ee1f59e3fd07ep+207,   -0x1.f8eb817123d95p-1,   -0x1.b3435p-4, INEXACT)
T(RN,  0x1.fa1268425ab6cp+207,   -0x1.baa122b9bd271p-3,   0x1.4b3ea6p-3, INEXACT)
T(RN,   0x1.9eb56db73163p+207,   -0x1.fe1a4beed984fp-1,   0x1.8d1e88p-3, INEXACT)
T(RN,  0x1.624e78d67f42cp+207,   -0x1.deeab64c70facp-1,   0x1.b3ca62p-3, INEXACT)
T(RN,  0x1.2901d9ecc73f8p+207,   -0x1.f336bbfa39867p-3,   0x1.2859acp-2, INEXACT)
T(RN,   0x1.ae9e7c3386eap+208,   -0x1.ecd1953e436b3p-1,  -0x1.d6cc54p-2, INEXACT)
T(RN,  0x1.1ddab17a795f2p+208,    0x1.fffb85c0477eap-1,   0x1.3a606ap-3, INEXACT)
T(RN,  0x1.56b2857dddd0bp+208,    0x1.fc8240f493208p-1,   0x1.014cd4p-3, INEXACT)
T(RN,  0x1.dc04f32e00482p+208,   -0x1.ff945e8b599cfp-1,   0x1.038968p-2, INEXACT)
T(RN,  0x1.42a942e989b28p+208,    0x1.88173f97ba0fep-2,   0x1.2419f6p-2, INEXACT)
T(RN,  0x1.3664d98cdbb84p+208,    0x1.f14503098de88p-1,   0x1.796874p-2, INEXACT)
T(RN,   0x1.b3a9173affe1p+208,    0x1.a9baf5cacc47fp-4,   0x1.17fcc2p-3, INEXACT)
T(RN,  0x1.27a77d4ab28aap+208,    -0x1.f1d9727e5108p-1,   0x1.ba71d2p-2, INEXACT)
T(RN,  0x1.d73f87e982246p+208,   -0x1.f3912a78df4b8p-2,  -0x1.47d358p-2, INEXACT)
T(RN,  0x1.f7de0528dededp+208,   -0x1.b1271f0fea186p-1,   0x1.3845cap-2, INEXACT)
T(RN,  0x1.db031ecfa1da8p+209,   -0x1.a097a00cd363ap-1,  -0x1.0bdbc8p-4, INEXACT)
T(RN,  0x1.20a6a7d9a598dp+209,    -0x1.a8395d73b49bp-2,   0x1.65e908p-3, INEXACT)
T(RN,  0x1.fb554b6612d09p+209,   -0x1.caa007df6496cp-2,   0x1.1150b2p-4, INEXACT)
T(RN,  0x1.70a7ab779055fp+209,   -0x1.3affc4d39e045p-1,   0x1.cd076ap-2, INEXACT)
T(RN,  0x1.545e6676c825ep+209,   -0x1.c12c95c0f34c6p-1,   -0x1.7e374p-3, INEXACT)
T(RN,  0x1.f48de36e10a24p+209,    -0x1.96b453f99823p-1,   0x1.9bc12ap-2, INEXACT)
T(RN,  0x1.4fa803a17507cp+209,    0x1.c905e9be04b0ap-2,  -0x1.f91168p-8, INEXACT)
T(RN,  0x1.84ed851d6ad08p+209,   -0x1.ff4fc99ace319p-1,   0x1.cc39aep-3, INEXACT)
T(RN,  0x1.84942938fd48ep+209,    0x1.1e9e24818b8aep-1,   0x1.7d460cp-3, INEXACT)
T(RN,  0x1.98f1f39ff8f9cp+209,   -0x1.a465450297681p-2,  -0x1.b6c0c4p-2, INEXACT)
T(RN,  0x1.ed2a2d657c3c1p+210,   -0x1.a64cd7ea239e1p-1,   0x1.a986e6p-4, INEXACT)
T(RN,  0x1.171e11e75dc4cp+210,   -0x1.fa2e79a00da4ap-2,  -0x1.4452d8p-3, INEXACT)
T(RN,  0x1.f9b3ab3857a37p+210,   -0x1.85b8cd1629dffp-1,  -0x1.274d8cp-3, INEXACT)
T(RN,  0x1.51db1307d7f87p+210,   -0x1.0556c719c4fc6p-2,  -0x1.f0210ep-3, INEXACT)
T(RN,  0x1.f1768643b6238p+210,   -0x1.c585d4ec5aadfp-1,   0x1.ed1c48p-2, INEXACT)
T(RN,  0x1.53db047450d5bp+210,   -0x1.14371c2e8554cp-1,  -0x1.92d052p-2, INEXACT)
T(RN,  0x1.4183c5c3a6b96p+210,   -0x1.91e43fffda338p-2,   0x1.58db6ap-5, INEXACT)
T(RN,  0x1.eed431b0fa5b3p+210,   -0x1.93d06bf48bf0ap-1,  -0x1.ef22a8p-4, INEXACT)
T(RN,  0x1.5ce5fd7354cc4p+210,   -0x1.17006bd8f0de6p-1,  -0x1.302208p-3, INEXACT)
T(RN,  0x1.0af2ebdaf6b6ep+210,   -0x1.b539386307afep-7,  -0x1.5bfac4p-4, INEXACT)
T(RN,   0x1.f1d8ce77ed08p+211,   -0x1.5ad0de9ca0d7dp-1,   0x1.330178p-3, INEXACT)
T(RN,  0x1.8966196ce173dp+211,    0x1.cc719f01486dcp-1,   0x1.8a74bep-4, INEXACT)
T(RN,    0x1.19ca623ffa3p+211,    0x1.8f75778255cd4p-1,   0x1.e17f78p-3, INEXACT)
T(RN,   0x1.803ade2428a2p+211,    0x1.b8b6778c08d5dp-2,   0x1.478868p-3, INEXACT)
T(RN,  0x1.0a21725d87a16p+211,   -0x1.58aef9f370c1ap-3,   0x1.36b6b4p-2, INEXACT)
T(RN,  0x1.370692b293e5ap+211,   -0x1.ff8be0758b196p-1,  -0x1.1e08ccp-5, INEXACT)
T(RN,  0x1.2f030fc0af1e8p+211,   -0x1.fa662e6b743ebp-1,  -0x1.833614p-2, INEXACT)
T(RN,  0x1.f95b974387206p+211,   -0x1.faa7c12b8bb17p-1,  -0x1.91e3fap-3, INEXACT)
T(RN,  0x1.ba52a19c6c192p+211,    0x1.6f6d433ea115ep-1,  -0x1.ba4222p-4, INEXACT)
T(RN,  0x1.9f8e8706fff5ap+211,    0x1.5f3fd44fc4604p-1,   0x1.889272p-2, INEXACT)
T(RN,  0x1.11d010e2d4d26p+212,    0x1.fd3bca925e989p-1,  -0x1.06f524p-2, INEXACT)
T(RN,  0x1.a64b32159a9b2p+212,   -0x1.3601b269aa90ap-3,   0x1.ce2876p-2, INEXACT)
T(RN,  0x1.71b58960be97dp+212,     0x1.d7e60d48323ap-1,    0x1.c2e91p-3, INEXACT)
T(RN,  0x1.8cc929a511c0cp+212,    0x1.e6e9653243ea2p-1,  -0x1.cfe38cp-2, INEXACT)
T(RN,   0x1.80450c1dd575p+212,   -0x1.10c9274fb6e59p-2,   0x1.ff3f14p-3, INEXACT)
T(RN,  0x1.a6884a5176564p+212,    0x1.3410f994d5ad3p-6,    0x1.7eff8p-6, INEXACT)
T(RN,  0x1.1d6b34cc8fe84p+212,   -0x1.7af92ee7da722p-3,  -0x1.cb03ecp-2, INEXACT)
T(RN,    0x1.be0a646563fp+212,    0x1.68bf609db4e4fp-2,   0x1.f2a35ap-3, INEXACT)
T(RN,  0x1.bf97792dda4f6p+212,    0x1.d6446c6a1f206p-1,    0x1.f36e4p-2, INEXACT)
T(RN,  0x1.99604716ec65cp+212,   -0x1.3d498cb479b71p-1,   0x1.3842bap-3, INEXACT)
T(RN,  0x1.3999772ab0f39p+213,   -0x1.b6a3121e492ffp-1,  -0x1.c97882p-3, INEXACT)
T(RN,  0x1.304248b18fefcp+213,   -0x1.ca41bfeec397fp-1,  -0x1.6d18f4p-3, INEXACT)
T(RN,  0x1.daa7aa96bbbc6p+213,    0x1.af907722af403p-2,   0x1.59afcep-2, INEXACT)
T(RN,  0x1.ab6de5ee72d6ap+213,   -0x1.7381b803d116ep-1,   0x1.291154p-3, INEXACT)
T(RN,   0x1.a9cb0e8e5ea6p+213,   -0x1.7ef2c91cf28d5p-1,   0x1.a07cc2p-2, INEXACT)
T(RN,   0x1.3b2fabacaf47p+213,    0x1.deb19d473fc21p-1,   0x1.e61cdap-5, INEXACT)
T(RN,  0x1.61235959e2e64p+213,   -0x1.f54b62574b2efp-1,  -0x1.852958p-4, INEXACT)
T(RN,  0x1.6f810bd26be04p+213,   -0x1.63e9e05c44677p-4,   -0x1.59a7fp-3, INEXACT)
T(RN,  0x1.c24dedf68eaa8p+213,     0x1.403b3678f4cfp-1,  -0x1.f350d4p-3, INEXACT)
T(RN,  0x1.b9dc2a68e2b26p+213,   -0x1.6261368da8ed8p-1,   0x1.aa20a8p-4, INEXACT)
T(RN,  0x1.3cb1d08dfac9dp+214,    0x1.c8030ca1f7e09p-2,  -0x1.024d38p-2, INEXACT)
T(RN,  0x1.6cbe45c80d197p+214,    0x1.193228be5333fp-1,   0x1.8ddc5ap-3, INEXACT)
T(RN,  0x1.7905acbd24d4fp+214,   -0x1.e54fb41d983b6p-4,  -0x1.786586p-5, INEXACT)
T(RN,  0x1.c01890561071cp+214,   -0x1.0fe471981a7cfp-2,   0x1.6aa6dap-2, INEXACT)
T(RN,  0x1.b5ea25d430a66p+214,   -0x1.dbe89b7e42fb2p-3,  -0x1.edfba4p-3, INEXACT)
T(RN,   0x1.2b4ac93d7eafp+214,   -0x1.ad3bf5a3eda09p-1,   0x1.8094b8p-2, INEXACT)
T(RN,  0x1.b78a6e43005d5p+214,    0x1.403dc0f8fe03fp-1,   -0x1.12933p-2, INEXACT)
T(RN,  0x1.f1e46fbf4fd22p+214,    0x1.6e1cf943f957bp-1,  -0x1.95e156p-2, INEXACT)
T(RN,  0x1.85111edf980e4p+214,    0x1.26b2391488f09p-1,   0x1.d38454p-2, INEXACT)
T(RN,  0x1.a63cd3c4f9027p+214,   -0x1.c10ea15d65983p-1,   -0x1.8e194p-3, INEXACT)
T(RN,  0x1.c2369f5a50726p+215,   -0x1.f2662089a531fp-1,  -0x1.af8e68p-2, INEXACT)
T(RN,   0x1.bf6ed71831ffp+215,   -0x1.b5fb12a57bcfbp-1,   0x1.aed05ap-3, INEXACT)
T(RN,  0x1.2d46c13c9a10ap+215,   -0x1.b75a8b049faf8p-1,  -0x1.204368p-2, INEXACT)
T(RN,  0x1.029ff81540b02p+215,    0x1.9690e7c0cee67p-1,  -0x1.8860b4p-2, INEXACT)
T(RN,  0x1.5be39a4b39fe3p+215,   -0x1.ffa299de772eep-1,   0x1.ef9748p-2, INEXACT)
T(RN,  0x1.c446b7c3621efp+215,   -0x1.5923e5fcd1eccp-1,   0x1.aafd62p-3, INEXACT)
T(RN,  0x1.34189291ae17bp+215,   -0x1.dbe4763396b8cp-1,   0x1.83225cp-5, INEXACT)
T(RN,  0x1.cf41725ca95b4p+215,    0x1.54ff7fd80cdcap-3,  -0x1.362db8p-3, INEXACT)
T(RN,  0x1.26a9416df2185p+215,    0x1.cec7bda6f08c1p-2,   0x1.1ed068p-3, INEXACT)
T(RN,  0x1.a1598d1dcc2b8p+215,   -0x1.ea966827732c7p-2,    0x1.a637ep-3, INEXACT)
T(RN,  0x1.ceee9bad01505p+216,   -0x1.18b567b4a0114p-1,   0x1.527facp-5, INEXACT)
T(RN,  0x1.e72591ffba52dp+216,   -0x1.3ddf1af211fb2p-1,   0x1.e1838ep-5, INEXACT)
T(RN,   0x1.ed493722e741p+216,     0x1.78c6b3fb4385p-3,    0x1.c06dcp-2, INEXACT)
T(RN,  0x1.0d30596ee91fdp+216,   -0x1.e4dfe83129286p-1,   0x1.ff704cp-2, INEXACT)
T(RN,  0x1.073bbb299624ep+216,   -0x1.d810486725a07p-1,  -0x1.7b63e2p-3, INEXACT)
T(RN,   0x1.f747271d3b2bp+216,   -0x1.dfedbd4030fccp-1,  -0x1.40ecccp-2, INEXACT)
T(RN,  0x1.288c9de56a355p+216,   -0x1.c517dfa7bd734p-1,  -0x1.ca243cp-3, INEXACT)
T(RN,   0x1.9c9596cef166p+216,    0x1.a8ef2e785c01fp-1,   0x1.f0fbbcp-2, INEXACT)
T(RN,  0x1.e3d4433e20dacp+216,    0x1.797aec3146bb9p-2,   0x1.fabd8ep-5, INEXACT)
T(RN,  0x1.14bb02ec0a25dp+216,    0x1.f9bd4a3d3372ep-1,   0x1.4b16b4p-2, INEXACT)
T(RN,  0x1.3d6f5f9d154efp+217,   -0x1.3158948c465e9p-4,  -0x1.e21eeep-2, INEXACT)
T(RN,  0x1.0bdfa5b657a59p+217,   -0x1.c44784c28be86p-1,  -0x1.519ebap-3, INEXACT)
T(RN,  0x1.aa23b6b8aea7dp+217,    0x1.1bb987ab489b1p-1,   0x1.605b44p-2, INEXACT)
T(RN,  0x1.f8af26c428f46p+217,    0x1.0ef19b843c409p-1,  -0x1.f63882p-4, INEXACT)
T(RN,  0x1.7f56d5432b6d2p+217,   -0x1.d118566afbdb3p-1,  -0x1.020834p-7, INEXACT)
T(RN,  0x1.8c8805f8a2d58p+217,   -0x1.f9d5e1089ae0fp-1,   -0x1.4a541p-7, INEXACT)
T(RN,  0x1.caf91a497a35cp+217,    0x1.f5e80e67584c2p-1,   0x1.244386p-3, INEXACT)
T(RN,  0x1.f0bc6110457f6p+217,    0x1.97dd6aca94784p-2,   0x1.a1ffecp-3, INEXACT)
T(RN,  0x1.94dfb38d45c03p+217,   -0x1.8d06d9ed0cac5p-1,    0x1.c7631p-2, INEXACT)
T(RN,  0x1.974783cb32926p+217,   -0x1.a8ab67b9fb14bp-1,    0x1.7b368p-2, INEXACT)
T(RN,  0x1.8bce3ff105584p+218,    0x1.96a3bd771703cp-1,    0x1.09e96p-2, INEXACT)
T(RN,  0x1.24713a2f5afb2p+218,    0x1.14979732b9dd7p-1,  -0x1.a15d36p-4, INEXACT)
T(RN,  0x1.ee8e837b8ba1cp+218,   -0x1.1c936298639dap-1,    0x1.9a09ep-2, INEXACT)
T(RN,  0x1.7d6ba8b371f7ep+218,    0x1.ff748a0b7afd3p-1,  -0x1.852114p-4, INEXACT)
T(RN,  0x1.90469eaad5c7ap+218,    0x1.fec866376f922p-1,   0x1.13db8ap-2, INEXACT)
T(RN,  0x1.abde44ca701f2p+218,   -0x1.98b2293f53483p-3,   0x1.1b5aeep-2, INEXACT)
T(RN,  0x1.7c746ebdfe8eep+218,    0x1.006dc698c3d0ep-1,  -0x1.07ae6cp-2, INEXACT)
T(RN,  0x1.268511845b33cp+218,   -0x1.96eba68d0deb8p-1,  -0x1.46c4cap-2, INEXACT)
T(RN,  0x1.592eed0889beep+218,   -0x1.f7bd45c869af5p-1,   0x1.0fb52cp-3, INEXACT)
T(RN,  0x1.18a83e8279d7dp+218,   -0x1.c66b75dd31602p-1,  -0x1.73ec7cp-3, INEXACT)
T(RN,  0x1.14a37f9e1bb9ap+219,    0x1.344ea3ac717b4p-4,  -0x1.97103cp-3, INEXACT)
T(RN,  0x1.357e8ea53a345p+219,   -0x1.b65cacb235008p-1,  -0x1.404d12p-3, INEXACT)
T(RN,  0x1.a1d2e8c8d98a2p+219,    0x1.4be3a70028baap-3,  -0x1.37dc6cp-2, INEXACT)
T(RN,  0x1.efbbef3859782p+219,    0x1.1dab05e13176fp-2,   0x1.23f59cp-6, INEXACT)
T(RN,  0x1.cdc8813e04c84p+219,   -0x1.711feb3928121p-1,    0x1.f1d1fp-2, INEXACT)
T(RN,  0x1.7749fa9033f36p+219,   -0x1.bbfbcbbb6922dp-2,   0x1.afe418p-2, INEXACT)
T(RN,  0x1.f169d39651d4cp+219,    0x1.bf81622566298p-1,  -0x1.1af184p-4, INEXACT)
T(RN,  0x1.1212bf13f4fc7p+219,    0x1.e3cf7b9c22522p-2,   0x1.e5f822p-4, INEXACT)
T(RN,  0x1.c0c4317a87611p+219,   -0x1.82f5fa705c40bp-1,  -0x1.ad6a48p-4, INEXACT)
T(RN,  0x1.bbb8992a2b00cp+219,   -0x1.eb3d5e51c33edp-1,  -0x1.0ba956p-3, INEXACT)
T(RN,  0x1.70f7110fdfbbcp+220,    0x1.a7b3d6dade78ep-1,   0x1.2d8decp-2, INEXACT)
T(RN,  0x1.b1d5ecf5a2b07p+220,     0x1.e135995f73d1p-1,   -0x1.115b8p-3, INEXACT)
T(RN,  0x1.53e7d5845fe3dp+220,    0x1.385d92ec0c733p-1,  -0x1.ffa8e6p-2, INEXACT)
T(RN,  0x1.8b16eadbfd324p+220,    0x1.6a1cf1187fedfp-1,  -0x1.fd33dep-2, INEXACT)
T(RN,  0x1.1e2ea03fd7d6dp+220,    0x1.e599d42457d19p-1,  -0x1.6802bep-2, INEXACT)
T(RN,  0x1.ddff33ce62234p+220,   -0x1.f9c12d724fca3p-2,   0x1.43a21ap-2, INEXACT)
T(RN,  0x1.1d05e63c51b02p+220,   -0x1.f06ce4cba567cp-1,   0x1.8c190ap-4, INEXACT)
T(RN,  0x1.c1dd90ee7cdaep+220,   -0x1.ffab81cd782cfp-1,  -0x1.f97ad8p-2, INEXACT)
T(RN,   0x1.e7aaca419062p+220,   -0x1.73f5d565f737dp-1,   0x1.9d2052p-2, INEXACT)
T(RN,  0x1.1902a4653c0dfp+220,    0x1.ea934f7a27a56p-1,  -0x1.442fccp-2, INEXACT)
T(RN,  0x1.447ccda0abbd5p+221,   -0x1.f86454c9c3cf1p-2,  -0x1.4dd092p-3, INEXACT)
T(RN,  0x1.22e04e86031d7p+221,    0x1.c3969e190c961p-1,  -0x1.0800d2p-2, INEXACT)
T(RN,  0x1.18b56f9e52398p+221,   -0x1.e238701e60bd1p-1,  -0x1.222c32p-4, INEXACT)
T(RN,  0x1.76d84a8501844p+221,   -0x1.bd680900ae6ddp-1,    0x1.4d744p-2, INEXACT)
T(RN,  0x1.c847811c3727fp+221,    0x1.620bfe6816066p-1,    0x1.203cdp-3, INEXACT)
T(RN,  0x1.0f44ad1c74d7bp+221,    0x1.fa997b0ff1a6dp-1,   0x1.21069ep-3, INEXACT)
T(RN,  0x1.91b4834b90916p+221,   -0x1.11c89c6ddf5ddp-2,   0x1.515abep-3, INEXACT)
T(RN,  0x1.85babd5ca2f6ep+221,     0x1.e8015ac27d9dp-1,     0x1.99d7p-3, INEXACT)
T(RN,  0x1.280f0975c6b8ep+221,    0x1.4502dd3bf76f7p-1,   0x1.d47232p-2, INEXACT)
T(RN,  0x1.6692164eca76fp+221,    0x1.4b3346b0b7506p-1,   0x1.b71d76p-3, INEXACT)
T(RN,  0x1.2861362ce3ac5p+222,   -0x1.d2fca14b0abdep-1,   0x1.7a967ap-2, INEXACT)
T(RN,  0x1.7a738eaffdb5ap+222,   -0x1.6b9b827605ee2p-1,   0x1.3f187ep-3, INEXACT)
T(RN,  0x1.9945231dbbaaap+222,    -0x1.ede6bafb00f3p-3,   0x1.c77274p-2, INEXACT)
T(RN,    0x1.4374200b375p+222,    0x1.9b4cc8e4c14a9p-1,   0x1.e30d1ep-2, INEXACT)
T(RN,  0x1.3f288ebe3c1bcp+222,   -0x1.d9ab3e35e2a2bp-1,  -0x1.7384a4p-3, INEXACT)
T(RN,  0x1.3599acdcab96dp+222,    0x1.8a2ac88a845acp-1,   0x1.fba166p-2, INEXACT)
T(RN,  0x1.967e4ceefe834p+222,    0x1.b28c06cd8e10dp-1,   0x1.1b0342p-2, INEXACT)
T(RN,  0x1.ef55a5ef1b10ap+222,    0x1.f5af619d342a4p-1,   0x1.6b1146p-3, INEXACT)
T(RN,  0x1.914f260bf745cp+222,    0x1.56878c6c56082p-4,   0x1.a71f86p-4, INEXACT)
T(RN,  0x1.85c9cf616258bp+222,    0x1.78b1a53531c65p-1,  -0x1.c45e4ep-3, INEXACT)
T(RN,  0x1.05a3e98bb75c1p+223,    0x1.4e7a57ba23c24p-1,  -0x1.8d5376p-3, INEXACT)
T(RN,  0x1.5c748547aedcfp+223,    0x1.a1db6bca75c64p-1,   -0x1.9da49p-3, INEXACT)
T(RN,  0x1.f0199448a4e46p+223,    0x1.4021558bc784dp-2,   0x1.442d5cp-5, INEXACT)
T(RN,  0x1.d2d5d06520a61p+223,    0x1.a902fa623f7f3p-3,   0x1.316a14p-3, INEXACT)
T(RN,  0x1.32a189f99afc9p+223,   -0x1.a9c712ee1969fp-1,  -0x1.3672a6p-2, INEXACT)
T(RN,  0x1.9d3640d08eb4ap+223,   -0x1.a8509a077d637p-2,   0x1.21c6a4p-2, INEXACT)
T(RN,  0x1.19a53063b4417p+223,    -0x1.4e4b3b85a307p-1,   0x1.e60268p-3, INEXACT)
T(RN,  0x1.f5de1fb3df9c4p+223,   -0x1.1d6868291f3f9p-1,   0x1.34a378p-3, INEXACT)
T(RN,   0x1.8e12be399e8dp+223,    0x1.cd55de2937baap-1,   0x1.ebb578p-2, INEXACT)
T(RN,  0x1.09b925ace59f1p+223,   -0x1.e3743e68ed825p-1,  -0x1.956216p-3, INEXACT)
T(RN,  0x1.7654842af1204p+224,    0x1.54deb6d9e9222p-1,  -0x1.fdb0b4p-2, INEXACT)
T(RN,  0x1.fb7675d59877bp+224,   -0x1.2674f8b0e1068p-2,   0x1.b38df6p-5, INEXACT)
T(RN,   0x1.f26a7ff1acb5p+224,    0x1.d56620eee7ed6p-1,   0x1.eabdcep-4, INEXACT)
T(RN,  0x1.e82041ac5271fp+224,    0x1.5f84460974185p-2,   0x1.142b2ep-2, INEXACT)
T(RN,  0x1.3a4684473039ep+224,    0x1.eccf312cfe409p-1,  -0x1.d65e98p-2, INEXACT)
T(RN,  0x1.936824f313aa2p+224,    0x1.06a2f286c4fb6p-4,   -0x1.e75d2p-3, INEXACT)
T(RN,  0x1.42de5cff29504p+224,    0x1.a78324254564dp-2,    0x1.073a6p-3, INEXACT)
T(RN,  0x1.d53a54f810882p+224,    0x1.9bea9eedaecfbp-2,   0x1.319542p-3, INEXACT)
T(RN,  0x1.4ec044c225018p+224,    0x1.e249088f5d9fbp-1,  -0x1.422bb4p-2, INEXACT)
T(RN,  0x1.13b2ccc95838cp+224,    0x1.1f71971e8be76p-1,   0x1.d947dep-4, INEXACT)
T(RN,  0x1.7859af14bceb2p+225,    0x1.f1cc0b768ea69p-1,   -0x1.4ec4fp-5, INEXACT)
T(RN,   0x1.a29042be486bp+225,    0x1.3d1d9ffde5d23p-1,  -0x1.4e610cp-2, INEXACT)
T(RN,  0x1.813f26d2f697bp+225,    0x1.f132173d4d6a8p-2,  -0x1.cd2998p-3, INEXACT)
T(RN,  0x1.cd465a37bbefap+225,    0x1.dd5446c9e689ep-1,   0x1.754be4p-6, INEXACT)
T(RN,   0x1.15075f347361p+225,    0x1.d01b5057f0973p-1,   0x1.b6cb26p-2, INEXACT)
T(RN,  0x1.d3834ef2a5e29p+225,    0x1.9db80a31013f7p-2,   0x1.448208p-2, INEXACT)
T(RN,  0x1.b2df197985936p+225,    0x1.a4e60995d8c31p-1,   0x1.362106p-2, INEXACT)
T(RN,  0x1.582cece21704fp+225,   -0x1.c7590cd61acffp-1,   0x1.5dbb12p-7, INEXACT)
T(RN,  0x1.eb600c2ca5aa4p+225,   -0x1.7bd6ea5ffbe2fp-1,  -0x1.fd942ap-2, INEXACT)
T(RN,  0x1.94a5f4adcd2ccp+225,   -0x1.85df35648512dp-1,   0x1.f57d24p-2, INEXACT)
T(RN,  0x1.c77cd36a74c88p+226,   -0x1.faa4ae13efb1fp-1,   0x1.ee0872p-2, INEXACT)
T(RN,  0x1.12ab54a8505f1p+226,   -0x1.fe53a4f702499p-1,   0x1.7e6b26p-2, INEXACT)
T(RN,  0x1.e3fe5dd144e28p+226,    0x1.fb935ca1b760bp-1,   -0x1.99247p-3, INEXACT)
T(RN,  0x1.e161ff0b99248p+226,    0x1.2e0809e90d9e6p-2,  -0x1.85fd8ep-4, INEXACT)
T(RN,  0x1.71cfd71555b95p+226,    0x1.ad29ad9ae1a92p-2,    -0x1.d802p-4, INEXACT)
T(RN,  0x1.4bfb4f04541dcp+226,   -0x1.19a40fa1d7483p-2,  -0x1.2efb76p-2, INEXACT)
T(RN,  0x1.3ad5a2edd706cp+226,    0x1.07ca2647fb1fcp-1,  -0x1.4f5328p-2, INEXACT)
T(RN,  0x1.492cec2c60487p+226,   -0x1.5a9707b3262dap-1,   0x1.185ffap-2, INEXACT)
T(RN,  0x1.f6fcfa5a46114p+226,   -0x1.ea5d70f4acb34p-1,   0x1.290dcep-2, INEXACT)
T(RN,  0x1.21f6911b18ebcp+226,    0x1.ff372f157e8dfp-1,   0x1.314bf6p-3, INEXACT)
T(RN,  0x1.2480fd7a536e8p+227,   -0x1.210d591080399p-1,   -0x1.8bd2fp-2, INEXACT)
T(RN,  0x1.f999dcde2a3afp+227,    0x1.8fb4f4070aec2p-1,  -0x1.becf98p-3, INEXACT)
T(RN,  0x1.b351f67b83f1bp+227,    0x1.fd126913ee091p-1,  -0x1.2d7936p-3, INEXACT)
T(RN,  0x1.ce7e3e22f5347p+227,   -0x1.f815aa004a6b5p-1,  -0x1.88b322p-2, INEXACT)
T(RN,  0x1.14de171a13957p+227,   -0x1.b9c156ba9b135p-1,  -0x1.43efa6p-4, INEXACT)
T(RN,  0x1.3cd6496e5e3cap+227,   -0x1.ea0deb7ecda6cp-1,  -0x1.f5d886p-2, INEXACT)
T(RN,   0x1.c79f28ccdd01p+227,   -0x1.c5378622c4952p-1,  -0x1.ac9b4ap-2, INEXACT)
T(RN,  0x1.e118d91b1c572p+227,   -0x1.ea47f0c405352p-1,  -0x1.077426p-2, INEXACT)
T(RN,    0x1.aea0ae22dffp+227,   -0x1.83b12eed60f51p-1,    0x1.79745p-6, INEXACT)
T(RN,  0x1.adf70a3811ff9p+227,     0x1.25daec1c08eep-1,   0x1.f1f58ap-3, INEXACT)
T(RN,  0x1.2acba6015a06bp+228,   -0x1.7673f5c068267p-1,   0x1.bdb86ep-7, INEXACT)
T(RN,  0x1.1b40d98e6cfd2p+228,   -0x1.4c6eae6f6b224p-2,  -0x1.c227b2p-2, INEXACT)
T(RN,  0x1.8d0396f4e33dep+228,    0x1.94e259c43a286p-2,   -0x1.1669ap-2, INEXACT)
T(RN,  0x1.7ccc0e5be9a78p+228,   -0x1.9e7ee65b80f5fp-1,  -0x1.3f7a62p-4, INEXACT)
T(RN,  0x1.a02c5366cc89dp+228,   -0x1.e067911cdfd47p-3,  -0x1.da3d7ep-3, INEXACT)
T(RN,   0x1.8b65de474ee1p+228,    0x1.aa689796bc0b3p-1,  -0x1.303436p-2, INEXACT)
T(RN,  0x1.5e5e3ef9ad714p+228,   -0x1.8c863849f68eep-4,  -0x1.733bb6p-3, INEXACT)
T(RN,  0x1.8d3ec07e72cedp+228,    0x1.ff948697a005dp-1,   0x1.292a54p-5, INEXACT)
T(RN,  0x1.a998838802311p+228,   -0x1.f2f6c18cdb3a8p-1,  -0x1.a0eb24p-4, INEXACT)
T(RN,   0x1.44586343a54cp+228,   -0x1.4e1560c44c22bp-3,   0x1.d37a76p-2, INEXACT)
T(RN,  0x1.cbad0336f2456p+229,   -0x1.5bdfa5d913c06p-3,   0x1.857ba6p-2, INEXACT)
T(RN,  0x1.164d619b1b233p+229,   -0x1.e42a0ab4f7658p-2,   -0x1.d61e9p-2, INEXACT)
T(RN,  0x1.727a2ad06d22ep+229,    0x1.3e6d3c3c4cfd6p-1,   -0x1.bf3bbp-2, INEXACT)
T(RN,   0x1.fc3d46c2bb7ep+229,    0x1.ddab3730084acp-1,   0x1.bb81cap-6, INEXACT)
T(RN,  0x1.f165ad12eeb34p+229,    0x1.a6c1e28e6ccdep-1,  -0x1.f8b132p-2, INEXACT)
T(RN,  0x1.018b0899755f3p+229,   -0x1.fd05d66cc37dep-1,   -0x1.af66bp-4, INEXACT)
T(RN,  0x1.534fb1650a4a8p+229,    0x1.0fd9540ae18dep-1,   0x1.5cba98p-6, INEXACT)
T(RN,  0x1.84f5785421becp+229,    0x1.1f4924fcdab52p-2,   0x1.2f4bc2p-2, INEXACT)
T(RN,  0x1.8e9b2b8f6f402p+229,   -0x1.18c8cd7bae9fbp-4,   0x1.24ccf8p-3, INEXACT)
T(RN,  0x1.0804459b5a91cp+229,   -0x1.8c0466e36faaap-1,  -0x1.72846ep-5, INEXACT)
T(RN,  0x1.67884158208c5p+230,    0x1.ff9b23e17a3a8p-1,   0x1.187d38p-3, INEXACT)
T(RN,  0x1.4ca813d9ff1d9p+230,    0x1.fffc090e6380fp-1,  -0x1.d996f8p-3, INEXACT)
T(RN,  0x1.8b725d14f9c5ap+230,    0x1.ffba5e5957648p-1,  -0x1.89f292p-5, INEXACT)
T(RN,  0x1.92d8df542286ep+230,   -0x1.7e938b26fa113p-1,   0x1.2cefeep-2, INEXACT)
T(RN,  0x1.831b1eed73734p+230,   -0x1.ca0f05ac0fbe6p-1,   0x1.74178cp-5, INEXACT)
T(RN,  0x1.e31dda42bd1d2p+230,    0x1.814484723dfa4p-1,   0x1.18ca06p-3, INEXACT)
T(RN,  0x1.4b04f07540abap+230,   -0x1.7ca3198990f9ap-1,   0x1.80da8ep-2, INEXACT)
T(RN,  0x1.095833eda8aa4p+230,    0x1.25879af3788f6p-3,    0x1.8737cp-2, INEXACT)
T(RN,  0x1.989c88f744f3fp+230,    0x1.064f091f3944cp-1,   0x1.c5ab0cp-2, INEXACT)
T(RN,  0x1.0470f50f10bedp+230,   -0x1.033654a429789p-1,   0x1.0127d6p-2, INEXACT)
T(RN,  0x1.a0ac4c5991064p+231,   -0x1.ffc2736b558b4p-1,  -0x1.38585ap-5, INEXACT)
T(RN,  0x1.5e89764c53867p+231,    -0x1.b2262c8e6b9fp-1,  -0x1.a59a3cp-3, INEXACT)
T(RN,  0x1.a2f7582a9233ep+231,    0x1.a401e76647d1ep-2,   0x1.3386e2p-4, INEXACT)
T(RN,  0x1.f21292c528a34p+231,    0x1.002dee1a1b759p-1,  -0x1.e1174ep-3, INEXACT)
T(RN,  0x1.5a9532ecd8d9ep+231,   -0x1.b7dac7afac43cp-1,   0x1.6e6b3ap-2, INEXACT)
T(RN,  0x1.fe1ca307222e3p+231,   -0x1.4cf1bac08803bp-4,    0x1.888c4p-3, INEXACT)
T(RN,  0x1.e5ed636dc772ap+231,    0x1.71ae0cbd215a5p-2,  -0x1.59bc16p-2, INEXACT)
T(RN,  0x1.da4d7759c0b64p+231,    0x1.6083ba220f6dep-2,  -0x1.67ae6cp-2, INEXACT)
T(RN,  0x1.8891b9a402edap+231,    0x1.1faf8a189ccbep-3,  -0x1.8d0a4ap-2, INEXACT)
T(RN,  0x1.a0844ec6b11f6p+231,   -0x1.9ce02b0ec73f1p-1,   0x1.21b2e8p-3, INEXACT)
T(RN,  0x1.1ca076a5865f5p+232,   -0x1.a005144144147p-1,   0x1.56943cp-2, INEXACT)
T(RN,  0x1.bd38885e4782ep+232,    0x1.f6759808bb598p-1,  -0x1.2d8d3ap-2, INEXACT)
T(RN,   0x1.eb74c5fbe134p+232,    0x1.6a92de6a2ee57p-1,   -0x1.af8cbp-6, INEXACT)
T(RN,  0x1.e590edfa2a388p+232,    0x1.d50add05c6087p-2,  -0x1.0aba1cp-2, INEXACT)
T(RN,  0x1.23283a3c48f0fp+232,   -0x1.011243571a115p-1,  -0x1.0e0a66p-2, INEXACT)
T(RN,  0x1.8b439a0826304p+232,    0x1.06a6132fe97a8p-1,  -0x1.a53994p-2, INEXACT)
T(RN,  0x1.944aa10d78fa8p+232,    0x1.50e05f3068a14p-2,   0x1.6c7a0ep-3, INEXACT)
T(RN,  0x1.5aab4caca3d39p+232,    0x1.95c56c43427dep-1,  -0x1.e9779cp-2, INEXACT)
T(RN,  0x1.a9548145cd3f5p+232,   -0x1.c6f32f2c38618p-1,  -0x1.0b8182p-5, INEXACT)
T(RN,  0x1.d29dfbda2546cp+232,   -0x1.f684f2c47fbfbp-1,   0x1.6e95b6p-5, INEXACT)
T(RN,  0x1.e0962a80c6258p+233,    0x1.6279915aa53d3p-1,  -0x1.899058p-2, INEXACT)
T(RN,  0x1.299909ced3d98p+233,    0x1.a21a6c92cb489p-1,  -0x1.ae1186p-3, INEXACT)
T(RN,  0x1.761d0b37f1157p+233,    0x1.016a8393b4e6cp-2,   0x1.af696ep-6, INEXACT)
T(RN,  0x1.c0f3a7eb7c41ep+233,   -0x1.b520b5d28678fp-1,    0x1.4fa7dp-2, INEXACT)
T(RN,  0x1.e8484a36b72e4p+233,    0x1.83f8bdf5107e4p-2,   0x1.b2de7cp-2, INEXACT)
T(RN,  0x1.7eff841fcef38p+233,   -0x1.852e3015960f5p-1,  -0x1.6747b4p-3, INEXACT)
T(RN,  0x1.2701143f9e268p+233,    0x1.fc0214e15f82ep-1,  -0x1.7ad74cp-3, INEXACT)
T(RN,  0x1.282d945ac2512p+233,    -0x1.7cef550fe90ep-2,  -0x1.2bc284p-3, INEXACT)
T(RN,  0x1.3c1caa5b0b429p+233,   -0x1.f738b59754b0fp-1,    0x1.4cfccp-7, INEXACT)
T(RN,  0x1.2b14b8faabd38p+233,   -0x1.eac2370bcb2b8p-1,  -0x1.14b076p-2, INEXACT)
T(RN,  0x1.d987a6bf5ef92p+234,    0x1.63bd6b36c34cdp-1,  -0x1.b12132p-2, INEXACT)
T(RN,  0x1.cb52c5926c18ep+234,    0x1.2aa0176c7659dp-3,  -0x1.e5b30ap-4, INEXACT)
T(RN,  0x1.f0bae6d6dd41cp+234,   -0x1.ffecae2d1877cp-1,   0x1.cfe7c8p-5, INEXACT)
T(RN,  0x1.33e064a29ea6cp+234,     0x1.72189fb55baap-1,   0x1.8304fcp-2, INEXACT)
T(RN,  0x1.6654941b94d19p+234,    0x1.5de1545c66633p-1,  -0x1.6a2e72p-2, INEXACT)
T(RN,  0x1.617e9c90ef683p+234,   -0x1.f86bfe5ebd5c4p-1,   0x1.18d058p-2, INEXACT)
T(RN,  0x1.d81d22aeb6751p+234,   -0x1.ddb87296241b4p-2,  -0x1.ba62e4p-2, INEXACT)
T(RN,  0x1.cf3a1a3924cf6p+234,    0x1.ed3cb4bb78c9dp-5,   0x1.0ece98p-7, INEXACT)
T(RN,  0x1.446748685ca9ap+234,   -0x1.c141282aa1597p-4,  -0x1.a45372p-4, INEXACT)
T(RN,  0x1.9dbfbb1e92a9cp+234,   -0x1.0dd4bd01fb7f3p-2,   0x1.93dd22p-5, INEXACT)
T(RN,  0x1.5ceacb3f6132dp+235,    0x1.7e14b4c2b4f8ep-2,  -0x1.5a0b5ep-3, INEXACT)
T(RN,  0x1.466135b666499p+235,    0x1.9ae7731318982p-1,   0x1.3e9a2ep-4, INEXACT)
T(RN,  0x1.62be1b52c0222p+235,   -0x1.32aacdbee1a2ep-1,  -0x1.ac1f8ep-3, INEXACT)
T(RN,  0x1.cb50ce388121ep+235,    0x1.b613670116652p-1,  -0x1.e893bcp-6, INEXACT)
T(RN,  0x1.6fa4b685dad72p+235,    0x1.07655a7e56b42p-1,   -0x1.13c19p-3, INEXACT)
T(RN,  0x1.e84ee7946d552p+235,   -0x1.196e14d268181p-1,  -0x1.7cc454p-2, INEXACT)
T(RN,   0x1.315b6cb42101p+235,   -0x1.e267764673532p-1,   0x1.9385a6p-2, INEXACT)
T(RN,  0x1.f75b4a3713488p+235,    0x1.924e41cd1482dp-2,   0x1.3b8b1cp-2, INEXACT)
T(RN,  0x1.52d1389f6b32dp+235,   -0x1.c7722c5c6b594p-3,  -0x1.2bbf72p-2, INEXACT)
T(RN,  0x1.14632eda6c20ep+235,    0x1.02c84b2cd5a74p-1,  -0x1.a1e126p-7, INEXACT)
T(RN,  0x1.b6494b399fb64p+236,    -0x1.ae920fd30577p-1,    0x1.daa13p-2, INEXACT)
T(RN,   0x1.92e86dfb6a29p+236,   -0x1.fd4d856f1cb53p-1,   -0x1.020cbp-2, INEXACT)
T(RN,  0x1.80a691a296d24p+236,    0x1.750a52c725414p-1,   0x1.238f9cp-2, INEXACT)
T(RN,  0x1.aa25d1fd06423p+236,   -0x1.027ea320ebdeap-5,   0x1.fd04c8p-2, INEXACT)
T(RN,   0x1.83068530cfb6p+236,   -0x1.37ec223bf2b2fp-1,   0x1.8ca068p-2, INEXACT)
T(RN,  0x1.9a6c85a2538c8p+236,    0x1.a4273bb0afe6fp-5,  -0x1.f3938ap-3, INEXACT)
T(RN,  0x1.077e749e37ceep+236,    0x1.70f6a51da8effp-1,   0x1.e338c6p-3, INEXACT)
T(RN,  0x1.14aede066d889p+236,    0x1.66c8b3f92632bp-1,  -0x1.5d780cp-4, INEXACT)
T(RN,  0x1.2003514410a54p+236,    0x1.ece84aaf4bfa8p-1,  -0x1.8d6baap-3, INEXACT)
T(RN,   0x1.15ff72725e87p+236,    0x1.d9dc17e064338p-1,   -0x1.18424p-3, INEXACT)
T(RN,  0x1.75093b5f875cap+237,    0x1.90bba0d6ab2d8p-1,   0x1.f1bb2ap-2, INEXACT)
T(RN,  0x1.022f18fae3aedp+237,   -0x1.b5d4725c266e3p-1,  -0x1.9f2c5ap-2, INEXACT)
T(RN,   0x1.6856bb1d3dbdp+237,   -0x1.d3b391b1edbfap-1,  -0x1.d04166p-2, INEXACT)
T(RN,  0x1.4297b196d6369p+237,   -0x1.4c1ebf25b2dccp-1,  -0x1.bef80ap-3, INEXACT)
T(RN,  0x1.b4d0e808c12a1p+237,   -0x1.f2faf1bcb75c2p-1,  -0x1.c5d42ep-4, INEXACT)
T(RN,  0x1.07fa571ae4e32p+237,    0x1.2c92d92d85c9ap-1,  -0x1.904e74p-3, INEXACT)
T(RN,   0x1.db5d5dde1826p+237,    0x1.874d4111a69e6p-1,   -0x1.8dc64p-3, INEXACT)
T(RN,  0x1.468aba18211acp+237,    0x1.9d4095c0e6b83p-1,   0x1.100db6p-3, INEXACT)
T(RN,  0x1.08ebcc1923cbfp+237,   -0x1.e8a812a81a85ep-1,  -0x1.ec2958p-2, INEXACT)
T(RN,  0x1.ca4d6ed377293p+237,   -0x1.a227d6d6a9431p-1,  -0x1.3245d8p-3, INEXACT)
T(RN,  0x1.e8487df472162p+238,    0x1.ccbe1ddf6f7eep-1,   0x1.1485ecp-2, INEXACT)
T(RN,  0x1.8c4471599e92ep+238,    0x1.e415034312cc5p-1,   0x1.1a51cap-3, INEXACT)
T(RN,  0x1.7567e24a82e04p+238,   -0x1.e06cddcbe9768p-1,   0x1.a1e8a8p-3, INEXACT)
T(RN,  0x1.495d2480d3a33p+238,    0x1.303fc72de02f3p-3,   0x1.2d8cfep-2, INEXACT)
T(RN,  0x1.5551248497715p+238,   -0x1.97006f75264a8p-2,  -0x1.a22868p-2, INEXACT)
T(RN,  0x1.37eccbccfd56cp+238,    0x1.f7115ad368c65p-1,   0x1.17682ap-2, INEXACT)
T(RN,  0x1.3c4886167ae52p+238,   -0x1.82ebc51fd16e6p-3,  -0x1.01db12p-2, INEXACT)
T(RN,  0x1.6af72c2f2fa53p+238,    0x1.1d6498fc0a387p-1,  -0x1.038824p-3, INEXACT)
T(RN,  0x1.bd8261b8e5587p+238,    0x1.3264c547501a9p-1,   0x1.f15cd2p-2, INEXACT)
T(RN,  0x1.dca6eb8cf2688p+238,    0x1.5c16258d781efp-1,   0x1.25a808p-3, INEXACT)
T(RN,  0x1.ce2ec6e16c279p+239,   -0x1.29e7e3bda78d1p-2,   -0x1.0227cp-4, INEXACT)
T(RN,  0x1.b2d3d8f9e3ddcp+239,   -0x1.12a123d56abafp-4,  -0x1.718d28p-4, INEXACT)
T(RN,  0x1.7553c1c48dcfcp+239,    0x1.f46a8f02b0351p-2,  -0x1.fb7728p-2, INEXACT)
T(RN,  0x1.1fc1c4e639833p+239,    0x1.f9ab038fd6104p-1,    0x1.e6851p-4, INEXACT)
T(RN,  0x1.45da296d18917p+239,   -0x1.e29e508eedb9bp-1,  -0x1.5b7f7ap-3, INEXACT)
T(RN,  0x1.befd77cf74914p+239,    0x1.37859131bac17p-1,   0x1.204eaap-2, INEXACT)
T(RN,  0x1.18da7d522e3cfp+239,   -0x1.91b3a0b52350bp-8,   0x1.7bee18p-2, INEXACT)
T(RN,  0x1.f7e3f51a30b48p+239,    0x1.fd882effa07a2p-1,  -0x1.186c6cp-5, INEXACT)
T(RN,  0x1.60e56035e50cep+239,   -0x1.658aeaa2a6d43p-1,   0x1.cd928ap-5, INEXACT)
T(RN,   0x1.8a1db84eacc5p+239,   -0x1.d722e653bf167p-1,   0x1.58f56ap-3, INEXACT)
T(RN,  0x1.32fa1e50c9a43p+240,    -0x1.875e59755e5bp-1,  -0x1.b60f0cp-3, INEXACT)
T(RN,  0x1.55ab6c4eaba92p+240,    0x1.d07a46595a8b5p-1,   0x1.19fb96p-3, INEXACT)
T(RN,  0x1.600e338879cd6p+240,   -0x1.91b0820e58b32p-1,   0x1.6fec64p-2, INEXACT)
T(RN,  0x1.58fdf4028a7e4p+240,   -0x1.9341b11f9b726p-1,  -0x1.c27c5ap-2, INEXACT)
T(RN,  0x1.88e94c0082e51p+240,    -0x1.e17411714dcfp-1,  -0x1.18dc62p-3, INEXACT)
T(RN,  0x1.16d089622071dp+240,   -0x1.8f694ccae5c5ap-4,   -0x1.695aep-2, INEXACT)
T(RN,  0x1.16a06e5a64082p+240,    0x1.fffdfd32eac63p-1,   0x1.960b96p-2, INEXACT)
T(RN,  0x1.bfcfdbae9b5bbp+240,   -0x1.4768eb61cd6f3p-2,   0x1.ef73e6p-4, INEXACT)
T(RN,  0x1.0fd3a914a124fp+240,    0x1.942791715c443p-1,  -0x1.80f306p-2, INEXACT)
T(RN,  0x1.3e945d988c742p+240,   -0x1.1a262c7229f66p-1,   -0x1.0a621p-2, INEXACT)
T(RN,  0x1.32c858ebc1a3ep+241,    0x1.f597b701ab607p-1,  -0x1.338934p-2, INEXACT)
T(RN,  0x1.918306955847cp+241,   -0x1.c9112f9008c68p-1,   0x1.8d034ep-2, INEXACT)
T(RN,  0x1.d436246a33966p+241,    0x1.00fc4dcfdfcdcp-1,   0x1.44668ap-5, INEXACT)
T(RN,  0x1.91c03cfde120ap+241,     0x1.870b9ab30f3dp-4,   0x1.feab16p-2, INEXACT)
T(RN,  0x1.87a8d6ef806b2p+241,   -0x1.f2200880327e4p-1,   0x1.673492p-3, INEXACT)
T(RN,  0x1.e466d9f3d20c6p+241,   -0x1.0136dd17e8109p-4,  -0x1.647232p-2, INEXACT)
T(RN,  0x1.ae3eed98b56d8p+241,    0x1.05ee4374ff1ccp-3,   0x1.3e1058p-3, INEXACT)
T(RN,  0x1.9b36a25272758p+241,    0x1.4412d8b54c06bp-2,   0x1.de173cp-4, INEXACT)
T(RN,  0x1.dedc8fe6565cep+241,   -0x1.f97db95b813a1p-1,   0x1.31562cp-2, INEXACT)
T(RN,  0x1.e443e0689d77ep+241,    0x1.f8f80bdbe5ea3p-1,  -0x1.46c196p-2, INEXACT)
T(RN,   0x1.b5acbc0be8c6p+242,    0x1.4b4d310be79d2p-1,  -0x1.b64f32p-4, INEXACT)
T(RN,  0x1.6aab43c1b144cp+242,   -0x1.0aa5eb129c42ep-5,  -0x1.2dc7eap-4, INEXACT)
T(RN,  0x1.45249bd414f7ap+242,   -0x1.d63a94ae5c666p-3,  -0x1.30da88p-2, INEXACT)
T(RN,  0x1.2d95b787cb76ep+242,   -0x1.1f953fb82e54ap-1,  -0x1.57ea4cp-2, INEXACT)
T(RN,  0x1.438c4ea7a1d37p+242,    0x1.82bf8f6fca095p-3,   -0x1.57c02p-3, INEXACT)
T(RN,  0x1.73080d6af1667p+242,    0x1.a1ffd76720926p-1,   0x1.3fcdf6p-2, INEXACT)
T(RN,  0x1.60f4cd4ca5a3ep+242,    0x1.ea596947d5c8cp-2,    0x1.dde44p-2, INEXACT)
T(RN,  0x1.7f0d9371e7b76p+242,    0x1.aa512ff13a03ep-1,  -0x1.cb1736p-4, INEXACT)
T(RN,  0x1.c2329ae36eeb9p+242,    0x1.88b58379810c4p-1,  -0x1.eb9ba8p-7, INEXACT)
T(RN,   0x1.b7a283ae85cbp+242,   -0x1.adb9976e0af4bp-1,  -0x1.fa858ap-2, INEXACT)
T(RN,  0x1.1f594ff55b8dap+243,    0x1.96744e0f0ed54p-5,   0x1.e34b26p-7, INEXACT)
T(RN,  0x1.7ad589c596b76p+243,    0x1.fac4ddc90d56cp-1,   0x1.f1e51ap-2, INEXACT)
T(RN,   0x1.bb092306bd6fp+243,    0x1.b0d43ac08970bp-1,  -0x1.761fecp-6, INEXACT)
T(RN,   0x1.6f88b42e6b7bp+243,    0x1.f0817a5ec005dp-1,   0x1.2f297cp-3, INEXACT)
T(RN,  0x1.b922931338c8cp+243,    0x1.fa68b9d080834p-5,   0x1.fa581ap-2, INEXACT)
T(RN,  0x1.a2185ac8ec73dp+243,   -0x1.ce9470de1e804p-2,   0x1.b90cc8p-2, INEXACT)
T(RN,   0x1.bfc570d99a01p+243,    0x1.43ad94576702fp-2,   0x1.dacd42p-2, INEXACT)
T(RN,  0x1.63c632fcc846ep+243,   -0x1.babdb2262c889p-1,    0x1.90c33p-3, INEXACT)
T(RN,   0x1.8895faee3956p+243,   -0x1.e50f705a4151ap-1,  -0x1.06c328p-3, INEXACT)
T(RN,  0x1.b7e9f89a01bfdp+243,   -0x1.72e65ee9ba148p-3,   0x1.473728p-2, INEXACT)
T(RN,  0x1.73707ed3f702ep+244,   -0x1.6b1cf872ba1aep-3,  -0x1.701afcp-3, INEXACT)
T(RN,  0x1.2b11a16765d8bp+244,   -0x1.c545b462176efp-1,  -0x1.8f61e8p-2, INEXACT)
T(RN,  0x1.0e86e0e80909cp+244,   -0x1.e6b3e7cf13fd2p-1,    0x1.49ccep-2, INEXACT)
T(RN,  0x1.e2e4c661c4234p+244,    0x1.bdcbc8f9715e5p-6,  -0x1.daa37cp-2, INEXACT)
T(RN,  0x1.a7146a7fbd352p+244,    0x1.e19e1b3b91fa4p-1,   0x1.0c9004p-9, INEXACT)
T(RN,  0x1.0e94308a8a96ap+244,   -0x1.b6eb17b797fecp-1,   0x1.ba9a48p-2, INEXACT)
T(RN,  0x1.4cf8e6ae48a44p+244,    0x1.efdb0c2b6101ap-1,  -0x1.fa71eap-3, INEXACT)
T(RN,  0x1.469f9acfa7ae8p+244,   -0x1.f16d37e75b48fp-1,   0x1.8e4c5cp-3, INEXACT)
T(RN,  0x1.63d121fbfd50ap+244,    0x1.e82546d44674cp-1,  -0x1.ff91a8p-2, INEXACT)
T(RN,  0x1.56885fad3805bp+244,    0x1.b4136624ce45ep-2,  -0x1.1f5bc4p-3, INEXACT)
T(RN,  0x1.0c7c03fc33d5bp+245,    0x1.acef67450d7a2p-2,   0x1.ebfc86p-2, INEXACT)
T(RN,   0x1.c5d61b27ef7ap+245,   -0x1.7b35505f544c4p-1,  -0x1.1cb458p-6, INEXACT)
T(RN,  0x1.a5584a23a1c88p+245,   -0x1.20eb7561a4cc4p-2,   -0x1.760f3p-3, INEXACT)
T(RN,  0x1.23a39938bae15p+245,   -0x1.fff55df7fa6fcp-1,  -0x1.6a25ccp-3, INEXACT)
T(RN,  0x1.3043fcce6e0b1p+245,   -0x1.fb49cc358f4c1p-1,  -0x1.558438p-2, INEXACT)
T(RN,  0x1.4a8ab869de4d6p+245,    0x1.2decadbe277afp-2,  -0x1.78406cp-2, INEXACT)
T(RN,  0x1.affb6d5ca15f4p+245,   -0x1.c461b1106a6c9p-1,  -0x1.2e13a2p-2, INEXACT)
T(RN,  0x1.9e9ed24f16916p+245,   -0x1.70cb282eecf09p-2,  -0x1.38dc5ap-4, INEXACT)
T(RN,   0x1.95d64985eadfp+245,    0x1.9e968d7e838a3p-3,  -0x1.7d17a6p-2, INEXACT)
T(RN,  0x1.d6fae6a646f08p+245,    0x1.4286ed72adb8ep-8,   0x1.1ea28ep-2, INEXACT)
T(RN,  0x1.5d67dc16ca98dp+246,    -0x1.0f4cc44fc5a7p-1,  -0x1.0a6626p-3, INEXACT)
T(RN,  0x1.5aa53728f7f3ap+246,   -0x1.5a1085f341c8cp-2,    0x1.62c8bp-2, INEXACT)
T(RN,  0x1.19dacf2381f0ep+246,    0x1.e796c59820648p-1,  -0x1.cf0b5ap-2, INEXACT)
T(RN,  0x1.b6c4966eefc5ap+246,    0x1.ae2111c93fa7dp-3,   0x1.1662fep-6, INEXACT)
T(RN,  0x1.32d65a4077858p+246,    0x1.d4aad12bb97dep-1,   0x1.640132p-2, INEXACT)
T(RN,  0x1.2929516b88f5ap+246,    0x1.81239ebc30936p-1,  -0x1.a9dfc2p-3, INEXACT)
T(RN,  0x1.ce24e9103b173p+246,    -0x1.406e9e16df5dp-6,   0x1.6648cep-4, INEXACT)
T(RN,  0x1.2afb92db1d12ap+246,   -0x1.ff808c3586208p-1,  -0x1.3af7d6p-2, INEXACT)
T(RN,  0x1.662e65526770bp+246,   -0x1.c3d1d08a34cb2p-1,   0x1.030ec8p-4, INEXACT)
T(RN,  0x1.9644b8d1a5ba2p+246,   -0x1.f6d45a9074faap-1,  -0x1.0426f6p-7, INEXACT)
T(RN,  0x1.2a8d5edcc8346p+247,   -0x1.5b848904c1c51p-2,  -0x1.9c4b86p-2, INEXACT)
T(RN,  0x1.21dc7e17ee9ecp+247,    0x1.4a7e6967783e2p-1,     0x1.f627p-3, INEXACT)
T(RN,  0x1.745c2e7b05a18p+247,   -0x1.9c90e1248a99ap-1,   0x1.de97eep-2, INEXACT)
T(RN,  0x1.9f0c5e06cd4ecp+247,    0x1.ff72c0c25384ap-1,   -0x1.45c85p-2, INEXACT)
T(RN,  0x1.af007c88e4f82p+247,    0x1.feae348e1cee3p-1,   -0x1.55f6ep-6, INEXACT)
T(RN,  0x1.40f74f052c073p+247,   -0x1.722c3753e0fc2p-1,   0x1.511524p-2, INEXACT)
T(RN,  0x1.e77820b88a94fp+247,    0x1.51558a42591e4p-1,  -0x1.e0cce8p-3, INEXACT)
T(RN,  0x1.1a5847c05de7cp+247,    0x1.750299c3d5a41p-1,   0x1.2e2a76p-4, INEXACT)
T(RN,  0x1.e5a56bc607c11p+247,   -0x1.2c492557539d5p-6,  -0x1.af8d24p-2, INEXACT)
T(RN,  0x1.64af3278079b1p+247,    0x1.fa3b7a23beb97p-1,   0x1.15f90cp-4, INEXACT)
T(RN,  0x1.4c14ab5782246p+248,    0x1.9f6d133c94466p-2,   0x1.a0a128p-2, INEXACT)
T(RN,  0x1.bc155b7869194p+248,    0x1.f7933dece4cdap-1,  -0x1.45f308p-3, INEXACT)
T(RN,  0x1.3bdd2e3e076c4p+248,   -0x1.95d1a5b0d1e0ap-2,   0x1.284278p-2, INEXACT)
T(RN,   0x1.e2687fe57a1fp+248,    0x1.6fa1249116839p-1,     0x1.856ep-2, INEXACT)
T(RN,  0x1.c6b58d7674102p+248,    0x1.d6da65bee2183p-1,   0x1.b75078p-2, INEXACT)
T(RN,  0x1.f5a1d728e7584p+248,    0x1.55a57ca2f65efp-2,   0x1.2f3ffep-4, INEXACT)
T(RN,  0x1.17abb38cbb8efp+248,   -0x1.b330e1d441ed9p-1,  -0x1.1be93ep-6, INEXACT)
T(RN,  0x1.4dc2931154c83p+248,   -0x1.fd3571a86809ep-2,   0x1.92b8b6p-5, INEXACT)
T(RN,  0x1.013c1ca5cfd2fp+248,    0x1.fbf544842a8e5p-1,   0x1.dcade6p-2, INEXACT)
T(RN,  0x1.150a54713b001p+248,   -0x1.d04419018f359p-1,  -0x1.32586cp-2, INEXACT)
T(RN,  0x1.95c0f2e190afep+249,   -0x1.f4ca24660d345p-1,  -0x1.c01292p-2, INEXACT)
T(RN,  0x1.5dd7818aea224p+249,   -0x1.bc61e2bea6be6p-1,   0x1.c734ecp-3, INEXACT)
T(RN,  0x1.fdb70ab020877p+249,   -0x1.aee0b7e7229d4p-1,    -0x1.5d67p-2, INEXACT)
T(RN,  0x1.d6d4f7ae4cd7ep+249,   -0x1.f30e0f9caf626p-1,  -0x1.411f62p-3, INEXACT)
T(RN,  0x1.a28bb7d54cd2cp+249,    0x1.60935d7d11118p-3,    0x1.605f7p-3, INEXACT)
T(RN,  0x1.56f8265be25ffp+249,   -0x1.a1052b0774b2dp-2,    0x1.20f97p-6, INEXACT)
T(RN,  0x1.b81361f2ec2f3p+249,    0x1.96f241859db7bp-3,   0x1.34330cp-2, INEXACT)
T(RN,  0x1.12af4ff198f9cp+249,   -0x1.7a9d034851dbbp-1,   0x1.ff762ap-3, INEXACT)
T(RN,  0x1.e97020a83920dp+249,   -0x1.a7f76a6cb82fdp-1,   0x1.7d7178p-2, INEXACT)
T(RN,  0x1.60c49fadba03ap+249,    0x1.fd3cf58db17f9p-1,   0x1.382048p-3, INEXACT)
T(RN,  0x1.2383b7c2c693ep+250,    -0x1.1267c0212e11p-3,   -0x1.b3909p-2, INEXACT)
T(RN,  0x1.02df2109ea739p+250,    0x1.f3dac76771724p-1,   0x1.365c56p-3, INEXACT)
T(RN,  0x1.8f311a958f5adp+250,    0x1.1cd8f3ddb0f1ap-1,   0x1.f88812p-3, INEXACT)
T(RN,  0x1.7d2e7382db6f9p+250,   -0x1.df63d62b47e8fp-1,  -0x1.ee49a6p-4, INEXACT)
T(RN,  0x1.dd23ec2b12033p+250,   -0x1.2b4493f208e26p-2,  -0x1.0af12ep-2, INEXACT)
T(RN,  0x1.de49a7383dc2cp+250,    0x1.21de2b5e8775ep-1,     0x1.d552p-3, INEXACT)
T(RN,  0x1.35ba6a6ef7df9p+250,    0x1.5a17af1f7a2c8p-1,  -0x1.ee0522p-4, INEXACT)
T(RN,  0x1.fc55f187b39bap+250,   -0x1.331dc3b556eb4p-4,  -0x1.5497d2p-3, INEXACT)
T(RN,  0x1.4527b0c178afap+250,    0x1.484d01563c862p-2,   0x1.8bf87ap-2, INEXACT)
T(RN,  0x1.f7e8a4b5902a4p+250,    0x1.58831033dd817p-2,   0x1.bb61e2p-4, INEXACT)
T(RN,  0x1.94959c675de9ep+251,    0x1.e622dee4f56fep-1,   0x1.1cb4fcp-3, INEXACT)
T(RN,  0x1.963c70d2a6f84p+251,    0x1.d4a5a73fa1ecap-1,  -0x1.eda534p-4, INEXACT)
T(RN,  0x1.0ac833a2bd295p+251,    0x1.f4383baafd041p-1,  -0x1.f4ef6ep-2, INEXACT)
T(RN,  0x1.fcb8d69708e22p+251,    0x1.cb053406841e3p-1,   0x1.c5ceacp-2, INEXACT)
T(RN,  0x1.a2ecbb61c1da6p+251,    0x1.d8a55951c80e9p-1,   0x1.2f62eap-2, INEXACT)
T(RN,  0x1.3940d9abe91c8p+251,   -0x1.7df31935ae637p-2,  -0x1.5ed232p-3, INEXACT)
T(RN,  0x1.7574167973cfbp+251,    0x1.f08bb92cac08fp-1,   0x1.b3b0a6p-6, INEXACT)
T(RN,  0x1.6ab4ca18b8c56p+251,   -0x1.778b3a34f8056p-3,  -0x1.d7e978p-2, INEXACT)
T(RN,  0x1.b68dccb43fdecp+251,   -0x1.6ba0251bbad9fp-1,   0x1.463066p-2, INEXACT)
T(RN,  0x1.2543266bc1606p+251,    0x1.f5d9042d1a8b8p-1,   -0x1.3d618p-2, INEXACT)
T(RN,  0x1.c6d95138c99aap+252,    0x1.f3b0d97a17036p-3,  -0x1.80ca6cp-6, INEXACT)
T(RN,  0x1.221b2ca3f7218p+252,   -0x1.9c302bf62f752p-4,    0x1.dcc7ap-2, INEXACT)
T(RN,  0x1.88454392bb478p+252,    0x1.7cdb69115565cp-2,   0x1.0fd0c6p-3, INEXACT)
T(RN,  0x1.03d38ceede4bfp+252,    0x1.fe35050e92123p-1,  -0x1.1f56d6p-2, INEXACT)
T(RN,  0x1.40cc0a95193c9p+252,    0x1.a67445e0ee63dp-2,  -0x1.77460cp-2, INEXACT)
T(RN,  0x1.ce6282406e8f8p+252,   -0x1.f7b1738134545p-1,   0x1.aa4c5ap-2, INEXACT)
T(RN,   0x1.f7b82d59e0abp+252,    0x1.d3b256dcfd8f3p-1,   0x1.07df7cp-6, INEXACT)
T(RN,  0x1.2622b8d8dd3c4p+252,   -0x1.61cd66f046045p-2,   0x1.812432p-4, INEXACT)
T(RN,  0x1.1f6ad134c393ap+252,   -0x1.dc243fab4e6aep-1,   0x1.43135ep-3, INEXACT)
T(RN,  0x1.f83eddf134329p+252,   -0x1.8fa5ca41f7932p-1,  -0x1.5ce122p-2, INEXACT)
T(RN,  0x1.b25420224f6a9p+253,   -0x1.ee8719c72fe64p-2,   0x1.8df162p-2, INEXACT)
T(RN,   0x1.b2a0e2ae3c25p+253,   -0x1.d3ac3fd7bfa26p-1,    0x1.5abb3p-4, INEXACT)
T(RN,  0x1.62f9e70b3240fp+253,   -0x1.f41a4205cb316p-1,   0x1.c86b2cp-2, INEXACT)
T(RN,  0x1.21c03219ba6cbp+253,   -0x1.4644581166707p-2,  -0x1.c8bb84p-3, INEXACT)
T(RN,  0x1.324c7635171aep+253,   -0x1.a0a996878febap-1,  -0x1.c0d64cp-6, INEXACT)
T(RN,  0x1.caba6cf56403ap+253,   -0x1.60261bdb9ea44p-5,  -0x1.47f65ep-5, INEXACT)
T(RN,  0x1.dd234bfe18e9ap+253,    0x1.5ab48f991fcacp-2,   0x1.5af01cp-2, INEXACT)
T(RN,  0x1.b535bea242ac4p+253,   -0x1.402220256caf6p-4,  -0x1.2718e6p-4, INEXACT)
T(RN,   0x1.e55808192ca1p+253,   -0x1.d1ba8447b734dp-1,   0x1.5fbb32p-5, INEXACT)
T(RN,  0x1.8b03b517bba0dp+253,     0x1.5d672d02543dp-1,   0x1.10acccp-4, INEXACT)
T(RN,  0x1.30c7939494c52p+254,   -0x1.fc8a72ad5c861p-1,  -0x1.55f198p-3, INEXACT)
T(RN,  0x1.0b282bdeec55dp+254,    0x1.5ded997edc6b1p-2,  -0x1.1c60a6p-2, INEXACT)
T(RN,  0x1.9a73c6ccda188p+254,    0x1.edec83058c589p-2,  -0x1.9da334p-5, INEXACT)
T(RN,   0x1.e3d0fe1eda67p+254,   -0x1.9e37b0c5255bbp-1,   0x1.029d34p-2, INEXACT)
T(RN,    0x1.3e00c008635p+254,   -0x1.49ca19469d9e6p-1,     0x1.5abbp-3, INEXACT)
T(RN,  0x1.55d042acf51f4p+254,   -0x1.8a41d30d6e52dp-3,   0x1.b84592p-3, INEXACT)
T(RN,  0x1.d2e90b152af32p+254,    0x1.fe9d3a721660dp-5,   0x1.dcacb2p-5, INEXACT)
T(RN,  0x1.214baa6c73e3bp+254,   -0x1.36ddab047dba3p-1,   0x1.dde5eep-3, INEXACT)
T(RN,  0x1.4e84174bfc987p+254,   -0x1.fae97a998a57bp-1,   0x1.7edb3ap-2, INEXACT)
T(RN,  0x1.a4327add59282p+254,    0x1.7c2386d85fc46p-1,   0x1.03497cp-7, INEXACT)
T(RN,  0x1.c703246b0f452p+255,   -0x1.3f0bc3ec4f4d4p-2,   0x1.eb0c34p-2, INEXACT)
T(RN,  0x1.dc74001cd0bf7p+255,    -0x1.fe39751e1727p-1,   0x1.1e2764p-4, INEXACT)
T(RN,  0x1.be9dbe6683d12p+255,    0x1.fe1e9ee6e778cp-1,  -0x1.7ee08ep-3, INEXACT)
T(RN,  0x1.8b3c2bc39a2b4p+255,    0x1.ca43799b8b8dep-3,   0x1.236e52p-2, INEXACT)
T(RN,  0x1.ac5bd5963c7cep+255,   -0x1.5ca6a006eae52p-1,  -0x1.617f5cp-3, INEXACT)
T(RN,  0x1.b188f5be057e9p+255,   -0x1.bd71e4f31e7d1p-1,  -0x1.d505b6p-2, INEXACT)
T(RN,  0x1.960cdd58f82adp+255,   -0x1.ab60b1f2ad079p-4,  -0x1.79d646p-2, INEXACT)
T(RN,  0x1.d6bb20168736ep+255,    0x1.56440409e435fp-1,   0x1.6ef81ap-2, INEXACT)
T(RN,  0x1.01af2b0da36a7p+255,   -0x1.fa7937b116782p-1,   0x1.f5ce4cp-2, INEXACT)
T(RN,  0x1.9806ba43b9d71p+255,    0x1.52d9df989a5afp-1,   0x1.e0ab0ap-3, INEXACT)
T(RN,  0x1.97859a41e7196p+256,   -0x1.d86960ba0f6e1p-1,  -0x1.fdab3ep-3, INEXACT)
T(RN,  0x1.78b6b4cc05f14p+256,    0x1.46113c8aefd5cp-3,   0x1.1bceeep-4, INEXACT)
T(RN,  0x1.7ec00538ea6e9p+256,    0x1.fe1d2d68c2a3ep-1,  -0x1.374248p-2, INEXACT)
T(RN,   0x1.dd9dc76c8679p+256,   -0x1.8b299452adc3ap-3,  -0x1.66be18p-4, INEXACT)
T(RN,  0x1.1fdaa0a70b804p+256,    0x1.cf503d8491866p-3,   0x1.f62be6p-3, INEXACT)
T(RN,  0x1.a620d91f333d7p+256,    0x1.729bbf4368fdfp-1,  -0x1.bdad76p-4, INEXACT)
T(RN,  0x1.95036bce1c82ep+256,    0x1.7e274014cb59ap-2,   0x1.568eb4p-4, INEXACT)
T(RN,  0x1.c0c23c028745ap+256,    0x1.d59ead4e3e429p-2,  -0x1.fba358p-3, INEXACT)
T(RN,  0x1.3b1dffdb255bcp+256,    0x1.7149c16ace935p-1,  -0x1.0ac242p-3, INEXACT)
T(RN,  0x1.d8c3eaa5a0cecp+256,    0x1.abc853e6210adp-1,   0x1.beb73ep-5, INEXACT)
T(RN,  0x1.96af158d1d668p+257,   -0x1.cd3dfd45a080ep-1,   0x1.f3aa8cp-3, INEXACT)
T(RN,  0x1.72aaa4b6001f4p+257,    0x1.b2e12609d237bp-2,   0x1.1fced6p-6, INEXACT)
T(RN,  0x1.6b620fa0be676p+257,   -0x1.1f1d98686b044p-5,   0x1.6d5344p-4, INEXACT)
T(RN,  0x1.2836fed102e96p+257,   -0x1.e2204a4df4711p-2,   0x1.b43b5ap-5, INEXACT)
T(RN,  0x1.a65f99187808fp+257,    0x1.1dd0d164a53e5p-2,   0x1.45f07cp-2, INEXACT)
T(RN,  0x1.ad649b76a0169p+257,    0x1.fe351e77476bbp-1,  -0x1.a3c1a2p-2, INEXACT)
T(RN,  0x1.9b7b952219ceap+257,    -0x1.733d7ec57c76p-3,   0x1.93cbdcp-3, INEXACT)
T(RN,  0x1.8e47cda1b6168p+257,   -0x1.43bb198f7e903p-3,  -0x1.40d288p-2, INEXACT)
T(RN,  0x1.a5d19a572fef1p+257,   -0x1.acdeceb4372e4p-1,   -0x1.8992fp-3, INEXACT)
T(RN,  0x1.41801a82db48ap+257,   -0x1.0c30ccf415ef1p-1,  -0x1.f2a674p-2, INEXACT)
T(RN,  0x1.fde8cc2b547b1p+258,   -0x1.c6f8ec440e90cp-1,   0x1.12fd3cp-2, INEXACT)
T(RN,  0x1.99fc71071458cp+258,    0x1.78fabef983ae3p-1,   0x1.8270aep-2, INEXACT)
T(RN,  0x1.47dff4edd8cfap+258,   -0x1.a42d538ca15fcp-1,   0x1.007ebap-2, INEXACT)
T(RN,  0x1.8f465b42e0392p+258,    0x1.68324b6793c9cp-2,  -0x1.bf37c6p-3, INEXACT)
T(RN,  0x1.f0afcb199eb5fp+258,   -0x1.076bb7eba5bc2p-9,   0x1.8d6f06p-2, INEXACT)
T(RN,  0x1.5a748f8166dcap+258,   -0x1.53e5140174fa2p-1,   0x1.a9e8a6p-2, INEXACT)
T(RN,  0x1.9ef9eb33fe5f7p+258,    0x1.62d3807416912p-1,   0x1.9aabecp-2, INEXACT)
T(RN,  0x1.f397e97a93487p+258,   -0x1.186ceb5185e0bp-3,  -0x1.2be19cp-2, INEXACT)
T(RN,  0x1.37f7b73c5a613p+258,    0x1.f62f1ad59179fp-1,  -0x1.7d99fep-2, INEXACT)
T(RN,  0x1.09511227c18c9p+258,   -0x1.9b8b7ab2d2889p-1,   0x1.6749e8p-3, INEXACT)
T(RN,  0x1.c44bcbfc57968p+259,    0x1.fbe7bd3381aa6p-1,  -0x1.26be9ep-2, INEXACT)
T(RN,  0x1.819674a678436p+259,   -0x1.bbad395afda4ep-1,  -0x1.6d315cp-3, INEXACT)
T(RN,  0x1.31ff16e40b075p+259,    0x1.041b935bcba12p-1,  -0x1.71f1b8p-5, INEXACT)
T(RN,   0x1.f22d170b5aebp+259,   -0x1.af6216a6119b2p-3,  -0x1.8da0acp-4, INEXACT)
T(RN,  0x1.27c5e9ad04cadp+259,   -0x1.c9d5a5f8f2e77p-8,   0x1.cabb9ep-2, INEXACT)
T(RN,  0x1.a4f707b9eec4dp+259,    0x1.272c386368bbfp-1,   0x1.6be8bcp-3, INEXACT)
T(RN,  0x1.313bb6d843047p+259,    0x1.f105a978cdb3ap-1,   0x1.74deeep-4, INEXACT)
T(RN,  0x1.d524ffa1a7b27p+259,    0x1.0f3827a1254adp-1,   0x1.1e5fa6p-2, INEXACT)
T(RN,  0x1.d5e7492da779ap+259,    0x1.033b0fb640118p-1,   0x1.7ca054p-5, INEXACT)
T(RN,  0x1.ab83416496e56p+259,    0x1.8286f9d893056p-1,  -0x1.f3926ep-2, INEXACT)
T(RN,  0x1.2436175f7fe22p+260,    0x1.ac098d4aad34cp-2,  -0x1.aa12b6p-2, INEXACT)
T(RN,  0x1.c37b98469dbbep+260,    0x1.f39935a111216p-3,   0x1.69ab6cp-3, INEXACT)
T(RN,  0x1.1a50732c4eea4p+260,    0x1.a6dc32073095dp-1,  -0x1.13ae92p-2, INEXACT)
T(RN,  0x1.e379b22f43809p+260,    0x1.cae1808d3051ap-2,   0x1.20b276p-3, INEXACT)
T(RN,  0x1.d9c41da64e968p+260,   -0x1.6db0564cbaf38p-2,  -0x1.5df006p-5, INEXACT)
T(RN,  0x1.4da8a2a4a6086p+260,    0x1.d39956d739846p-1,   -0x1.faf3ap-3, INEXACT)
T(RN,  0x1.59f6132fef98cp+260,   -0x1.f198c8a6a97a1p-1,   -0x1.e27c9p-4, INEXACT)
T(RN,  0x1.2d7ecf9d0beadp+260,   -0x1.3e995e7fb6c33p-1,   -0x1.f094fp-2, INEXACT)
T(RN,  0x1.63750a4a431e2p+260,    0x1.ceb08024aab8dp-1,   0x1.3113fep-2, INEXACT)
T(RN,  0x1.b7634c16806d5p+260,   -0x1.4f6b6374e468ep-1,   -0x1.d24a1p-3, INEXACT)
T(RN,  0x1.e83f8e3ecee27p+261,   -0x1.f38fd69ae066ap-5,   -0x1.040acp-5, INEXACT)
T(RN,  0x1.417c7e3967c2ep+261,   -0x1.1cd470959557cp-1,  -0x1.837566p-2, INEXACT)
T(RN,  0x1.10df31ec00f7cp+261,    0x1.df5407d64adc5p-1,  -0x1.44ca5cp-2, INEXACT)
T(RN,  0x1.ddd4e225a8bf8p+261,   -0x1.ae389c2d743e1p-2,  -0x1.bd1994p-2, INEXACT)
T(RN,  0x1.42334582a8642p+261,    0x1.cbc562c4541e8p-6,  -0x1.9ce16ap-2, INEXACT)
T(RN,  0x1.f2b953aa62613p+261,   -0x1.c88eadb2fb49cp-2,   0x1.d142a2p-2, INEXACT)
T(RN,  0x1.203a13df108dap+261,    0x1.b81018a5f0acap-1,    0x1.58566p-2, INEXACT)
T(RN,  0x1.21bef4eba49bdp+261,   -0x1.e9d1da5a14cdap-1,   0x1.ecc808p-2, INEXACT)
T(RN,  0x1.e0e99f0181c84p+261,   -0x1.dc20e44430f5dp-1,   0x1.a5c9c8p-3, INEXACT)
T(RN,  0x1.918a88010d326p+261,   -0x1.bea242beafcdep-1,   0x1.ed514ep-3, INEXACT)
T(RN,  0x1.c10e5fcf6ad8cp+262,    0x1.2848f4201b11bp-3,   0x1.ee9ce6p-2, INEXACT)
T(RN,  0x1.c2b5b9acd9331p+262,   -0x1.67abd1962f973p-2,   0x1.27911ep-3, INEXACT)
T(RN,  0x1.597a856b8b0bdp+262,    0x1.90523f4638646p-1,   0x1.cdd9aep-3, INEXACT)
T(RN,  0x1.7c7f23cdbe41ap+262,   -0x1.fe7d38895ca05p-6,   -0x1.7a324p-3, INEXACT)
T(RN,  0x1.e590a3a96cd77p+262,    0x1.1f0a939c3aff1p-1,   0x1.6096a6p-2, INEXACT)
T(RN,  0x1.10193f7b1b418p+262,    0x1.62aa5f34876dfp-5,    0x1.627c4p-2, INEXACT)
T(RN,  0x1.17f39e3b0cf6ep+262,    0x1.fd699e424d136p-1,   0x1.c6c8eap-3, INEXACT)
T(RN,  0x1.c00d0c3b65ffep+262,    -0x1.eb66b6ffceb2p-1,  -0x1.4b359cp-3, INEXACT)
T(RN,  0x1.c1ba835c29341p+262,   -0x1.f5dc408a8473bp-1,   0x1.8a7694p-3, INEXACT)
T(RN,  0x1.e9f5b92bd6252p+262,   -0x1.d7bb9587ff5dcp-1,   -0x1.0b483p-4, INEXACT)
T(RN,  0x1.a52250c3cde3dp+263,   -0x1.e8dc219fd8ddep-1,   0x1.e80d02p-4, INEXACT)
T(RN,  0x1.4b7f62861769ep+263,   -0x1.95469207761a6p-1,  -0x1.33e17ep-3, INEXACT)
T(RN,  0x1.718afc00a3dd9p+263,    0x1.f9014b1b968c5p-1,   0x1.431bb8p-3, INEXACT)
T(RN,  0x1.a2a60493eebe9p+263,    -0x1.0a9b843e38cep-9,    0x1.e4ba1p-6, INEXACT)
T(RN,  0x1.15eb38058c5c6p+263,   -0x1.0e3b301d340e6p-2,   0x1.01359ep-4, INEXACT)
T(RN,   0x1.44c958070f0ap+263,    0x1.abf614a40558dp-1,  -0x1.6c662ap-2, INEXACT)
T(RN,  0x1.c4c7efe825ca4p+263,   -0x1.d6fc7e5b81948p-1,   0x1.81bd5cp-2, INEXACT)
T(RN,  0x1.591815ff0c9fbp+263,    0x1.fedac2b6ba097p-1,   0x1.44d528p-2, INEXACT)
T(RN,  0x1.3ce52ef5114ddp+263,   -0x1.8923b56c7ee87p-1,  -0x1.2bde8ap-2, INEXACT)
T(RN,  0x1.99cb018847a0ap+263,    0x1.32043195c6947p-4,  -0x1.22067ep-3, INEXACT)
T(RN,   0x1.99bf0d7286d1p+264,    0x1.fea6c9ba7188bp-1,  -0x1.6fc47ep-2, INEXACT)
T(RN,  0x1.88d79d811710dp+264,   -0x1.274a02cc8a38bp-3,   0x1.417e46p-6, INEXACT)
T(RN,  0x1.8dc134e356bb8p+264,   -0x1.5f1cb2ae7e816p-1,   0x1.e98a6cp-4, INEXACT)
T(RN,   0x1.1fbdd794540ep+264,   -0x1.a4d5588693ad8p-2,   0x1.3fb8b2p-3, INEXACT)
T(RN,  0x1.43fd53245af9fp+264,   -0x1.ed1ec1dd6db56p-5,  -0x1.54890ep-4, INEXACT)
T(RN,  0x1.702b49287ecc2p+264,    0x1.b528c3c168bd2p-1,   0x1.a82994p-3, INEXACT)
T(RN,  0x1.6cdcde44700d2p+264,   -0x1.66e97ef3b35fcp-4,   0x1.53de94p-2, INEXACT)
T(RN,  0x1.520c8fcc0fa4dp+264,   -0x1.99914ee9d4f62p-1,   0x1.085ac8p-4, INEXACT)
T(RN,   0x1.a2feb62fd4b1p+264,   -0x1.cd79ba3ad02c3p-4,   -0x1.307bdp-2, INEXACT)
T(RN,  0x1.d5d6b347ec47ep+264,    -0x1.653200d0d6d9p-1,   0x1.49c5cap-2, INEXACT)
T(RN,  0x1.6a75399a99cf4p+265,    0x1.2c8ee9a917cf5p-3,  -0x1.e0211cp-2, INEXACT)
T(RN,  0x1.68b2dafc9c164p+265,    0x1.b29be0051b139p-1,  -0x1.69bb46p-2, INEXACT)
T(RN,  0x1.e3ca77082a0eap+265,    0x1.311b227da6f3ep-7,     0x1.4ea7p-2, INEXACT)
T(RN,  0x1.915b68424aa71p+265,    0x1.f63f1ae6017bcp-1,  -0x1.332a86p-2, INEXACT)
T(RN,  0x1.aaba7bc96ae78p+265,    -0x1.b978eb1741bdp-1,  -0x1.e48876p-2, INEXACT)
T(RN,  0x1.a4c8e1d63625bp+265,    0x1.3d84d61b073fcp-2,   -0x1.f71a1p-5, INEXACT)
T(RN,  0x1.5afb6e3ab448cp+265,   -0x1.57ff0f73c9c39p-2,   0x1.5f584ap-2, INEXACT)
T(RN,  0x1.370b45b3cd324p+265,    0x1.fdf0d65bfdf79p-1,   0x1.5a522cp-2, INEXACT)
T(RN,  0x1.63925fb2d27c9p+265,    0x1.62b0dc982a854p-4,   0x1.02c9e6p-4, INEXACT)
T(RN,   0x1.3d8f647d7bddp+265,    0x1.0631845d109cep-3,   0x1.9c48cap-4, INEXACT)
T(RN,  0x1.4259a2edca0c4p+266,    0x1.20662cbc81543p-2,    0x1.12a3cp-4, INEXACT)
T(RN,   0x1.c9e8c2161f88p+266,   -0x1.fda33663f937dp-1,  -0x1.b16684p-7, INEXACT)
T(RN,  0x1.15a702379a514p+266,    0x1.c0cd14f1d378dp-1,   0x1.4780aep-4, INEXACT)
T(RN,  0x1.c5d6d571c34f5p+266,   -0x1.aa19dcb87584ap-3,  -0x1.c600c4p-2, INEXACT)
T(RN,   0x1.d51e8f15fa2dp+266,    -0x1.3ff06ca05da9p-1,   0x1.56d436p-2, INEXACT)
T(RN,  0x1.2f152c6745d7bp+266,    0x1.1a8502a427a74p-1,   0x1.5dff08p-2, INEXACT)
T(RN,  0x1.9eaab9336b8c3p+266,    0x1.8391cf4dd15cap-1,  -0x1.9bac74p-2, INEXACT)
T(RN,  0x1.a35b91d8f607ap+266,   -0x1.2150a5650029ep-5,  -0x1.0bbbb2p-4, INEXACT)
T(RN,  0x1.a73d6e731a688p+266,   -0x1.11b72c09fb685p-1,  -0x1.aa1846p-6, INEXACT)
T(RN,   0x1.93c6d8f37c3dp+266,   -0x1.fffed9e05f7bdp-1,  -0x1.14cea2p-3, INEXACT)
T(RN,  0x1.8d6762301f822p+267,   -0x1.8cf455e64c2b4p-1,   0x1.c20cd2p-2, INEXACT)
T(RN,  0x1.15a39fdf9c0bfp+267,    0x1.6366b0a90c165p-2,   0x1.6e19f8p-5, INEXACT)
T(RN,   0x1.e79e1be1fbbdp+267,   -0x1.0e61ddccde4adp-1,  -0x1.d2deb2p-3, INEXACT)
T(RN,  0x1.d849b4e8248f6p+267,    -0x1.6e76512c289dp-1,   0x1.a9182ep-3, INEXACT)
T(RN,  0x1.3df4d1d46071ap+267,   -0x1.fda7e812d6794p-1,  -0x1.e752f4p-4, INEXACT)
T(RN,   0x1.466afa38b395p+267,   -0x1.d169be2ff4a06p-1,  -0x1.b05e06p-8, INEXACT)
T(RN,  0x1.e418d725f2117p+267,    0x1.fde62a1165da6p-3,   0x1.526b34p-2, INEXACT)
T(RN,  0x1.abc43f72ac4d2p+267,   -0x1.d36d0862267c1p-1,   0x1.ef2168p-3, INEXACT)
T(RN,  0x1.cfd10f93c2bd4p+267,    0x1.fb15df0764ee6p-1,   0x1.87dc9ep-2, INEXACT)
T(RN,  0x1.fcd80b6090727p+267,   -0x1.8c588b4f0aa5cp-1,  -0x1.920f64p-2, INEXACT)
T(RN,  0x1.a4092b0f4fdbdp+268,    0x1.50def5580c2ecp-3,  -0x1.d006e8p-2, INEXACT)
T(RN,  0x1.2e5c7aa989699p+268,    0x1.b390667a4d99fp-3,   0x1.969246p-2, INEXACT)
T(RN,  0x1.3efdd76ff84aap+268,    0x1.ff191634f1f61p-1,   -0x1.7b676p-2, INEXACT)
T(RN,  0x1.40b5b4ffee3d3p+268,    0x1.1506d6d2c2167p-2,  -0x1.e9e19ap-5, INEXACT)
T(RN,  0x1.13dda907fd2f2p+268,   -0x1.18b751c83a28bp-1,  -0x1.6886e4p-3, INEXACT)
T(RN,  0x1.76b6c86b54685p+268,    0x1.c1d1b1de9c9f2p-1,   0x1.afae46p-3, INEXACT)
T(RN,  0x1.3009489db8938p+268,    0x1.8a492d555b6c7p-2,    0x1.f9722p-4, INEXACT)
T(RN,  0x1.3bd65f947ae82p+268,    0x1.345c55317a213p-2,    0x1.d2065p-2, INEXACT)
T(RN,  0x1.23736803f7852p+268,   -0x1.f6c469c2142c3p-1,  -0x1.11f8c6p-2, INEXACT)
T(RN,  0x1.d3c383ff8cbb6p+268,    0x1.bdc8c093afe1dp-2,   0x1.1f2852p-2, INEXACT)
T(RN,  0x1.2af8dfaf6f77fp+269,   -0x1.f54551e686d67p-1,  -0x1.446746p-3, INEXACT)
T(RN,  0x1.b4e23226945acp+269,   -0x1.60db894d27e6dp-1,   0x1.b22c02p-2, INEXACT)
T(RN,  0x1.77402d9445d69p+269,    0x1.785e79efa3aaap-2,   0x1.d04b48p-2, INEXACT)
T(RN,  0x1.6de2ae960fa09p+269,    0x1.387258d21c713p-2,   0x1.e0facap-2, INEXACT)
T(RN,  0x1.79ac84af5bb21p+269,    0x1.423225ebd39efp-2,  -0x1.27f1eep-3, INEXACT)
T(RN,  0x1.8ba6c70653996p+269,   -0x1.8f64efb94e8d2p-3,  -0x1.2dfc68p-3, INEXACT)
T(RN,  0x1.048d77f6dc3afp+269,   -0x1.d5f81bbbbe5aep-1,  -0x1.487098p-4, INEXACT)
T(RN,  0x1.f0d1266aff609p+269,   -0x1.f00076555854ep-2,   -0x1.d9067p-2, INEXACT)
T(RN,  0x1.e8c09fed4283ap+269,    0x1.f6c0e1fd26bd6p-1,   0x1.44a4fep-2, INEXACT)
T(RN,  0x1.5c9ee02600d2fp+269,    0x1.425bf08952acbp-3,  -0x1.c9b346p-4, INEXACT)
T(RN,  0x1.cd48d2b5fc88ep+270,   -0x1.30fe783321ebcp-1,  -0x1.d01ef2p-2, INEXACT)
T(RN,  0x1.b73c07f77dbeap+270,    0x1.e28e9b5586a3dp-6,   0x1.fc5016p-2, INEXACT)
T(RN,  0x1.d5e5f4589b4adp+270,    0x1.c1844179f6b3ap-1,   -0x1.a8908p-2, INEXACT)
T(RN,  0x1.541ad251be894p+270,     0x1.cf350a7463dap-1,  -0x1.570a44p-2, INEXACT)
T(RN,  0x1.9f1bf3a5c6b0ap+270,    0x1.7b01c2ea03e8fp-1,   0x1.5c3276p-3, INEXACT)
T(RN,  0x1.ae555ef4a8792p+270,    0x1.ffffc26c5dfa5p-1,   0x1.b1de34p-3, INEXACT)
T(RN,  0x1.5ce64d9bd08eep+270,    0x1.ad92f9b0c636ap-3,  -0x1.434ed4p-2, INEXACT)
T(RN,  0x1.1f817db01ea09p+270,    0x1.10cc51042072dp-1,   0x1.967862p-7, INEXACT)
T(RN,  0x1.c918141fc2ab9p+270,   -0x1.1e00fede435a8p-1,   0x1.02861ep-4, INEXACT)
T(RN,  0x1.8efb9c9651d61p+270,   -0x1.c3474aa748a01p-1,   0x1.bc6df4p-2, INEXACT)
T(RN,   0x1.c4ae3f00ada8p+271,    0x1.8298f4428ee6bp-1,   0x1.5d011ap-2, INEXACT)
T(RN,  0x1.c21c4f4dd3a24p+271,   -0x1.f44a591ab9c3dp-1,  -0x1.93a278p-3, INEXACT)
T(RN,  0x1.ffa2d910c0aa1p+271,   -0x1.19bc18bf03e0bp-1,  -0x1.8bab16p-3, INEXACT)
T(RN,  0x1.fc95f8d49c436p+271,    0x1.fb4b7034412eap-1,    -0x1.82a4p-2, INEXACT)
T(RN,   0x1.b17aa494d02bp+271,   -0x1.48912ce968cd9p-2,  -0x1.80da68p-3, INEXACT)
T(RN,  0x1.e9ed8a87baa16p+271,   -0x1.3f630a748a22bp-1,   -0x1.faf12p-3, INEXACT)
T(RN,   0x1.8bddc386c949p+271,    0x1.6beb6fb428cc8p-1,  -0x1.c735e4p-2, INEXACT)
T(RN,  0x1.1f2602078c064p+271,    0x1.57b4d8abb00f3p-1,   0x1.5a17e4p-2, INEXACT)
T(RN,  0x1.52025828cf561p+271,   -0x1.c0473f8fdb57ap-1,  -0x1.117a66p-2, INEXACT)
T(RN,  0x1.041d822a4309dp+271,    0x1.24429013c1e0fp-2,  -0x1.3253d2p-2, INEXACT)
T(RN,  0x1.39247248e891bp+272,    0x1.e94dc15aef536p-1,  -0x1.29d7aap-2, INEXACT)
T(RN,   0x1.2c5de78fb225p+272,   -0x1.9bef9a83c93f4p-1,   0x1.0e468cp-6, INEXACT)
T(RN,  0x1.48d35578873d3p+272,     0x1.fb1c9fd2b47ap-1,  -0x1.4a9026p-4, INEXACT)
T(RN,  0x1.fc45bd25b13f6p+272,    0x1.363f9e199c397p-1,  -0x1.2e8f88p-2, INEXACT)
T(RN,  0x1.1d1bb7d347127p+272,   -0x1.059d606fa84dfp-1,   0x1.2b00dap-5, INEXACT)
T(RN,  0x1.5a93fe4e62e34p+272,   -0x1.f0c09870f377fp-1,    0x1.d8429p-2, INEXACT)
T(RN,  0x1.aef713b4920a3p+272,   -0x1.fe2eaa3b462cbp-1,   -0x1.8d693p-3, INEXACT)
T(RN,  0x1.d71453a8b9956p+272,   -0x1.fc073172f4602p-2,  -0x1.529864p-4, INEXACT)
T(RN,  0x1.e2eef7634eecap+272,    0x1.40c843407922ap-1,   0x1.e39db8p-3, INEXACT)
T(RN,  0x1.444d768a56bb2p+272,   -0x1.f96e80991eb8cp-1,   0x1.615ff4p-2, INEXACT)
T(RN,  0x1.fe4fd995f82f2p+273,   -0x1.ee507e2e3ffa6p-1,   0x1.89bf28p-2, INEXACT)
T(RN,  0x1.08cd7353f5447p+273,   -0x1.b3d3ba09b8221p-1,   0x1.fa91e2p-2, INEXACT)
T(RN,  0x1.01a8db3086d9dp+273,   -0x1.e9edf81d5425bp-1,  -0x1.e393a4p-3, INEXACT)
T(RN,  0x1.f98b0792c0de9p+273,     0x1.9ad044bbd125p-1,  -0x1.e73c72p-2, INEXACT)
T(RN,  0x1.e54fc22416f99p+273,    0x1.9d0f12b4ef217p-1,  -0x1.1bb848p-2, INEXACT)
T(RN,  0x1.6bc462847d49ap+273,    0x1.0b9a037bdf646p-1,  -0x1.b8c758p-3, INEXACT)
T(RN,  0x1.607f9dd2bba02p+273,   -0x1.bb618459546bdp-2,   0x1.0f02eep-2, INEXACT)
T(RN,    0x1.703cc887fbep+273,    0x1.4203d6a194605p-1,  -0x1.de6014p-3, INEXACT)
T(RN,  0x1.e9cb1eb64e5bap+273,   -0x1.479147e08617cp-2,   0x1.a818aap-3, INEXACT)
T(RN,  0x1.b7a43207a4a41p+273,    0x1.fffde35036d33p-1,   -0x1.25755p-3, INEXACT)
T(RN,  0x1.8db6aced9c81bp+274,    0x1.a5528d2c7c342p-1,  -0x1.e8ee2ap-5, INEXACT)
T(RN,  0x1.6c3812333d9c2p+274,    0x1.ff27e5e4cb418p-1,   0x1.77fcecp-4, INEXACT)
T(RN,  0x1.0ce3759e7204fp+274,    0x1.0a0b474677157p-4,  -0x1.22d4a4p-2, INEXACT)
T(RN,  0x1.4e5a9bf3dc47ap+274,     0x1.ffe4dbf8cf86p-1,   0x1.c875d4p-4, INEXACT)
T(RN,  0x1.00615a2ea810dp+274,    -0x1.d5288b431b68p-1,  -0x1.ad340ap-2, INEXACT)
T(RN,  0x1.f8752b7b56d92p+274,     0x1.f19910399a49p-1,   0x1.831198p-2, INEXACT)
T(RN,  0x1.a00dfc6d89d4fp+274,    0x1.245a3fc41a488p-2,  -0x1.cd0fc8p-2, INEXACT)
T(RN,  0x1.c32c02f2666d6p+274,    0x1.88cb6a59eee7fp-1,   0x1.79c948p-3, INEXACT)
T(RN,  0x1.b08fd89dc46fap+274,    0x1.f4bfa4b2f2f04p-1,   0x1.26a28ap-2, INEXACT)
T(RN,  0x1.b0570675e9566p+274,   -0x1.9078dd1851ffbp-1,   0x1.86012cp-2, INEXACT)
T(RN,  0x1.1d4c9b7236b15p+275,   -0x1.8bd8a8126b54cp-1,  -0x1.4123c8p-4, INEXACT)
T(RN,  0x1.e4ca9503c3e83p+275,   -0x1.47fc3bdde3f66p-1,  -0x1.e2a318p-2, INEXACT)
T(RN,  0x1.42f0f4fa56f02p+275,   -0x1.cf3282e19e63dp-1,  -0x1.8c7694p-2, INEXACT)
T(RN,  0x1.9a2a6566f90f8p+275,   -0x1.c4335111359abp-1,  -0x1.c1d35ap-4, INEXACT)
T(RN,  0x1.116d77be2af11p+275,    0x1.e85fa9daf2092p-1,   0x1.f55c18p-2, INEXACT)
T(RN,  0x1.5bfe430fd26b5p+275,    0x1.53d2b324e5063p-1,  -0x1.ddea86p-4, INEXACT)
T(RN,  0x1.9ad354e7b1326p+275,   -0x1.fe9ca8d8a9d38p-1,   0x1.92e1c4p-2, INEXACT)
T(RN,  0x1.66543b377b22ap+275,   -0x1.5d1b8eaa18491p-1,   0x1.569036p-2, INEXACT)
T(RN,  0x1.4ab2b53ec689dp+275,   -0x1.f79b3dbf34078p-1,  -0x1.007998p-2, INEXACT)
T(RN,   0x1.f1b3b53492dap+275,   -0x1.e4572f8adeeb1p-1,   0x1.684a9ep-3, INEXACT)
T(RN,  0x1.05637533975a6p+276,    0x1.0b850694fac89p-1,   0x1.ca6b3cp-2, INEXACT)
T(RN,  0x1.d41f5b7c18088p+276,   -0x1.f70cd5762fd6dp-1,  -0x1.2d4cc2p-2, INEXACT)
T(RN,  0x1.b99b551303fa7p+276,   -0x1.c05faa1e70b96p-1,   0x1.ac2c8ap-2, INEXACT)
T(RN,  0x1.9b7cf3ceb774bp+276,   -0x1.77d234f4ab6f9p-1,  -0x1.944e0cp-2, INEXACT)
T(RN,  0x1.e8366443ba1d8p+276,    0x1.ffff567bf3b55p-1,  -0x1.9d80b4p-2, INEXACT)
T(RN,  0x1.e7b7ab5ceb3fep+276,    0x1.fa43de513b987p-1,   -0x1.bf75cp-7, INEXACT)
T(RN,  0x1.66b31f1bc9dd2p+276,   -0x1.8c62dd6b9f634p-1,  -0x1.f1b6a6p-4, INEXACT)
T(RN,  0x1.a183d58aed404p+276,    0x1.ff9ddee3d39dap-1,   0x1.229586p-4, INEXACT)
T(RN,  0x1.a76314da43798p+276,   -0x1.587c16315377ep-1,  -0x1.8c13c2p-2, INEXACT)
T(RN,  0x1.3c06e1a9b1f4ep+276,    0x1.6dbfe53bd9ad4p-2,   0x1.adafbap-3, INEXACT)
T(RN,  0x1.94a66604d446ep+277,   -0x1.cf82637b8f52ap-1,  -0x1.cbb9eap-2, INEXACT)
T(RN,  0x1.e48ddbfdbae3ap+277,    0x1.df739ba64817bp-1,  -0x1.6532d8p-2, INEXACT)
T(RN,  0x1.afa6102b561c4p+277,    0x1.bf3964c7615bep-1,   0x1.e535bcp-2, INEXACT)
T(RN,  0x1.b94e79de2c332p+277,   -0x1.db78af7e2431fp-2,  -0x1.14374cp-3, INEXACT)
T(RN,  0x1.e4d0f5922500ap+277,   -0x1.b7dcbb68796d2p-1,  -0x1.6e0372p-2, INEXACT)
T(RN,  0x1.e5a9531c3068ep+277,    0x1.11a7ff375c503p-1,   0x1.e0e802p-6, INEXACT)
T(RN,  0x1.65033698763b4p+277,    0x1.5681fb5bb176ap-1,   0x1.4d7fccp-3, INEXACT)
T(RN,  0x1.d8db6729db76bp+277,    0x1.b8e9eb2888ab6p-2,   -0x1.cd45dp-2, INEXACT)
T(RN,  0x1.9ce2424be117cp+277,    0x1.dcee6ade4fdc7p-3,  -0x1.fd8c7ap-3, INEXACT)
T(RN,  0x1.8e436e94cdea2p+277,    0x1.4e73ed3b27a2ep-1,   0x1.0e2f98p-4, INEXACT)
T(RN,  0x1.86ca175f24688p+278,     0x1.3969d3abc757p-2,   0x1.02cfeep-2, INEXACT)
T(RN,  0x1.c1f42f487699fp+278,   -0x1.174429a54b182p-4,   0x1.cdccb8p-2, INEXACT)
T(RN,   0x1.b4e44ef4daadp+278,    -0x1.5d3e93763215p-1,   0x1.8811f6p-2, INEXACT)
T(RN,  0x1.01fc9298531dfp+278,   -0x1.a0cb93f90d3aap-6,  -0x1.65ab86p-2, INEXACT)
T(RN,  0x1.72b01053201dap+278,   -0x1.9990dbbf85c25p-1,  -0x1.172a7cp-2, INEXACT)
T(RN,  0x1.cf4962d97ee74p+278,    0x1.9a77b62a9364cp-2,   0x1.da68b2p-2, INEXACT)
T(RN,  0x1.2ffd4a486adc6p+278,    0x1.9707485cdff3fp-3,   0x1.98d4a6p-2, INEXACT)
T(RN,  0x1.284e1d675c77bp+278,   -0x1.644901c44c12bp-1,  -0x1.7381aap-2, INEXACT)
T(RN,  0x1.947c1981e1138p+278,   -0x1.9473fed9c4789p-3,  -0x1.68176cp-6, INEXACT)
T(RN,  0x1.0b1868d3f113cp+278,     0x1.ff68d2c2ae2fp-1,   0x1.90005ap-2, INEXACT)
T(RN,  0x1.8f78d671ee966p+279,    0x1.93524782bb72fp-1,   0x1.d54b12p-5, INEXACT)
T(RN,  0x1.e377133ab2dd4p+279,    -0x1.0f30878f1d5ap-2,   0x1.228542p-3, INEXACT)
T(RN,   0x1.2db253627ec1p+279,    0x1.bb968b5f4097dp-2,  -0x1.6cd7e4p-5, INEXACT)
T(RN,  0x1.9a171c0993988p+279,    0x1.72f168e0dfab5p-2,   0x1.16257ep-2, INEXACT)
T(RN,  0x1.1effc00f3619ap+279,    0x1.e45115f5d618fp-3,  -0x1.e8d5cap-3, INEXACT)
T(RN,  0x1.81dcf75a94806p+279,    0x1.bd1db2c7b3944p-1,   0x1.86dd4ap-2, INEXACT)
T(RN,  0x1.47f8345586b6ep+279,   -0x1.e1f95a558b8d7p-1,   0x1.3beff6p-3, INEXACT)
T(RN,  0x1.c7746aa4e61f5p+279,    0x1.9ce1e9c1d6a2ep-2,  -0x1.6ff21cp-2, INEXACT)
T(RN,  0x1.ea7322c35ace4p+279,   -0x1.b77da871d336cp-3,   0x1.c934dcp-2, INEXACT)
T(RN,  0x1.d028fe7433af4p+279,   -0x1.fb9c4a880d742p-1,   0x1.db604ap-4, INEXACT)
T(RN,  0x1.8ade203dcd714p+280,    0x1.fee24f321893cp-1,   0x1.91246ap-5, INEXACT)
T(RN,  0x1.8d07d9f306868p+280,   -0x1.4a999525b0f53p-2,   0x1.17f58cp-2, INEXACT)
T(RN,  0x1.94a183b3ae54ep+280,    0x1.414adaa92e81ap-1,  -0x1.5c7942p-5, INEXACT)
T(RN,  0x1.a3dc63d235263p+280,   -0x1.3c114c8d14793p-2,   -0x1.79d54p-2, INEXACT)
T(RN,  0x1.b2093ed545eaap+280,   -0x1.d9b54cc9eca73p-3,  -0x1.25cde2p-2, INEXACT)
T(RN,  0x1.7dbe00a2a9889p+280,    0x1.a140172a4960cp-2,    0x1.f5768p-8, INEXACT)
T(RN,  0x1.af3d876756cc8p+280,    0x1.811e9c473115cp-1,  -0x1.cdea24p-4, INEXACT)
T(RN,  0x1.e9345003fe466p+280,    0x1.ff1f65d928c21p-1,   0x1.408ea8p-2, INEXACT)
T(RN,  0x1.091d629e3a3d3p+280,   -0x1.9a004c64e0831p-3,    0x1.46459p-3, INEXACT)
T(RN,  0x1.82706420e1939p+280,   -0x1.6120557ea1c89p-1,   0x1.88d06ap-2, INEXACT)
T(RN,  0x1.186d3605771c3p+281,    0x1.fa2f2a7616217p-2,   0x1.f8ed96p-2, INEXACT)
T(RN,  0x1.f0458ecabae36p+281,   -0x1.132524cf92f22p-5,   0x1.06117cp-2, INEXACT)
T(RN,  0x1.1aa80206f6453p+281,   -0x1.e939ce49d4049p-1,   0x1.e52872p-4, INEXACT)
T(RN,  0x1.58dfab16a9f7ep+281,    0x1.f91ee3c67b24ap-1,  -0x1.efa408p-2, INEXACT)
T(RN,  0x1.c44a015476a83p+281,   -0x1.e5a58ba29ed2fp-1,  -0x1.756246p-4, INEXACT)
T(RN,  0x1.0bf6a1063d5f1p+281,    0x1.f1eb89bac034ep-1,  -0x1.c7df74p-3, INEXACT)
T(RN,  0x1.8f3450c37da03p+281,    0x1.b1b0d33f0adc6p-2,   0x1.de6932p-2, INEXACT)
T(RN,  0x1.5013af92380c9p+281,    0x1.ae3a1edb3537fp-3,  -0x1.b4b86ep-2, INEXACT)
T(RN,  0x1.230d39758ceb3p+281,    0x1.e7e9eede8d949p-2,  -0x1.8ec358p-2, INEXACT)
T(RN,  0x1.9e250874dea7cp+281,    -0x1.7d0e8b083f9ep-1,  -0x1.b31f0ep-2, INEXACT)
T(RN,  0x1.58c71b68819eep+282,   -0x1.6305736b8a473p-2,   0x1.1abde4p-2, INEXACT)
T(RN,  0x1.7785aee1ace59p+282,   -0x1.6883bbfe721cep-1,  -0x1.5bfe4ep-5, INEXACT)
T(RN,  0x1.41d8ce06abd36p+282,   0x1.b737c6308e859p-11,    0x1.e6e65p-3, INEXACT)
T(RN,    0x1.be5ca2e1b95p+282,    0x1.4900d3109f62cp-3,  -0x1.e01f14p-3, INEXACT)
T(RN,  0x1.d8079c8a71bb7p+282,     0x1.3fa323bf47ffp-4,   0x1.a1310ep-2, INEXACT)
T(RN,  0x1.49e83e1e9f50ap+282,    0x1.eff9ef3975df9p-1,  -0x1.50d46ap-4, INEXACT)
T(RN,  0x1.032428baa74f2p+282,    0x1.48f631519b9bbp-2,  -0x1.7071f4p-4, INEXACT)
T(RN,  0x1.43f71d9c16b05p+282,    0x1.c43700626679fp-2,  -0x1.933a12p-2, INEXACT)
T(RN,  0x1.d8704eba9fd5cp+282,    0x1.17bc6d1e2660dp-1,  -0x1.d0858ap-2, INEXACT)
T(RN,   0x1.24a1e56cc3cep+282,    0x1.4f7cc1454ec94p-1,   0x1.543ee8p-2, INEXACT)
T(RN,  0x1.6a5ac9f180059p+283,    0x1.c268d674522ccp-3,   0x1.052d56p-2, INEXACT)
T(RN,  0x1.a0cb79ef6978ap+283,    0x1.f20fe25969761p-1,   -0x1.46486p-2, INEXACT)
T(RN,  0x1.5dcd13cc09805p+283,   -0x1.0429c50d697f4p-1,   -0x1.3aac9p-3, INEXACT)
T(RN,  0x1.50f586efd77ecp+283,    -0x1.87c3026d9b7ap-4,   0x1.66346cp-4, INEXACT)
T(RN,  0x1.109ac3c087f3bp+283,   -0x1.e7bdc0e8b5743p-1,   0x1.0032eap-2, INEXACT)
T(RN,  0x1.507915e16b953p+283,   -0x1.439f8696bb354p-2,   0x1.b8ceaap-3, INEXACT)
T(RN,  0x1.255106c7e98c3p+283,    0x1.d053e81dacdfap-1,  -0x1.b39118p-2, INEXACT)
T(RN,  0x1.560afdef5b328p+283,    0x1.d5204c962c803p-3,   0x1.edbc5ep-2, INEXACT)
T(RN,  0x1.e36d7e4c4f3bcp+283,   -0x1.dc683083be01bp-4,   0x1.39aa94p-2, INEXACT)
T(RN,  0x1.b87ff4c78e1fap+283,    0x1.e51206dcc1018p-1,   0x1.66817ep-5, INEXACT)
T(RN,  0x1.ebfa43f0a87ccp+284,   -0x1.1856335cb4037p-6,   0x1.172bf8p-3, INEXACT)
T(RN,  0x1.232a423779237p+284,   -0x1.ba81e0519be98p-1,   0x1.ba9612p-3, INEXACT)
T(RN,  0x1.10a8d0babb08ep+284,    0x1.ddbec33064c03p-1,   -0x1.d17bdp-2, INEXACT)
T(RN,  0x1.eb10c3dd0d626p+284,    0x1.b5048390633e8p-1,   0x1.45579cp-2, INEXACT)
T(RN,  0x1.3eb0ff1d00246p+284,   -0x1.bad683ad0846bp-1,   0x1.d414a8p-2, INEXACT)
T(RN,  0x1.8ac6f1e424eaap+284,   -0x1.e799f72736bbbp-1,  -0x1.a6c64ep-2, INEXACT)
T(RN,  0x1.9ae07a140f9f8p+284,   -0x1.f97a55946cb5cp-1,  -0x1.4ef8c8p-4, INEXACT)
T(RN,  0x1.c5796eeeb9618p+284,     0x1.2ce874fbe0f9p-1,   0x1.067f36p-2, INEXACT)
T(RN,  0x1.e01bebb5af92cp+284,    0x1.e3f7ce025d2c2p-2,   -0x1.15f3dp-3, INEXACT)
T(RN,  0x1.ce812f6de920ap+284,   -0x1.50f304519b64ap-1,   0x1.9d7344p-3, INEXACT)
T(RN,  0x1.d60d86ee2cc58p+285,   -0x1.aecc9d7e07c02p-4,  -0x1.16c07ep-2, INEXACT)
T(RN,  0x1.7a93b5d0e3968p+285,    0x1.97ed09eb1fd9ep-7,  -0x1.ffb8bcp-2, INEXACT)
T(RN,  0x1.d887d8bc42fd4p+285,    0x1.f5c3b28a156c3p-1,  -0x1.d21738p-7, INEXACT)
T(RN,  0x1.2e4ab68310c22p+285,    0x1.e5d112f2aa792p-1,  -0x1.3f0f16p-3, INEXACT)
T(RN,  0x1.b060f8b634e94p+285,    0x1.90efe698c386ap-1,   0x1.c95618p-2, INEXACT)
T(RN,  0x1.aa626bc66e174p+285,    0x1.9728f206f7c55p-1,    0x1.84acep-3, INEXACT)
T(RN,  0x1.0e4ea4859be3bp+285,   -0x1.adaaa69fcc2f5p-2,  -0x1.fa1efep-2, INEXACT)
T(RN,  0x1.764330138df61p+285,    0x1.4d68e17a74948p-1,  -0x1.81d152p-5, INEXACT)
T(RN,  0x1.89a1c000f4b52p+285,   -0x1.2ef75c63db108p-3,  -0x1.13b292p-5, INEXACT)
T(RN,  0x1.66a814b7c87acp+285,   -0x1.7793405c07c64p-1,   -0x1.b89d5p-3, INEXACT)
T(RN,  0x1.cc8afa281b6cap+286,    0x1.fdeb75513e63ap-1,  -0x1.261942p-2, INEXACT)
T(RN,  0x1.054cc08298807p+286,    0x1.141ce6ae6e4d6p-2,   0x1.084888p-2, INEXACT)
T(RN,  0x1.01366651f6ecep+286,   -0x1.0492996efbd5ap-1,  -0x1.dbade6p-2, INEXACT)
T(RN,  0x1.9deea479b80a5p+286,    0x1.23f9872cf5704p-8,   -0x1.c8f9ep-3, INEXACT)
T(RN,  0x1.654be9620048cp+286,   -0x1.ff29459a92b6cp-1,  -0x1.e5fa68p-2, INEXACT)
T(RN,  0x1.7e828e1138bdep+286,    0x1.ee13c73965bc3p-1,   0x1.5f4e9ep-3, INEXACT)
T(RN,  0x1.199b896e1b186p+286,     0x1.7849abbce394p-1,    0x1.d66acp-7, INEXACT)
T(RN,  0x1.7c176466e977bp+286,    0x1.0538e4ad92f41p-1,   0x1.360872p-3, INEXACT)
T(RN,  0x1.4925b7fb48062p+286,   -0x1.ffff1fe72d9afp-1,    0x1.442b3p-2, INEXACT)
T(RN,  0x1.1dfe3c914b5c9p+286,   -0x1.94a706e33cb53p-1,   0x1.526d12p-3, INEXACT)
T(RN,  0x1.74981c15fb32ap+287,   -0x1.3604d4f3461e5p-1,  -0x1.0e4deep-3, INEXACT)
T(RN,   0x1.fe2125727d22p+287,    0x1.6fb89e025652bp-1,  -0x1.b598b4p-2, INEXACT)
T(RN,  0x1.0e122ec09f8dfp+287,    0x1.a40b052a7e016p-2,   0x1.641482p-2, INEXACT)
T(RN,   0x1.f437aeec3787p+287,   -0x1.d4ecf05da566cp-4,    0x1.59c58p-2, INEXACT)
T(RN,  0x1.331fc1a015727p+287,    0x1.9f41e9eb47c82p-1,  -0x1.939372p-4, INEXACT)
T(RN,  0x1.fd1526ac49ca2p+287,    0x1.cb0c333ec3e82p-1,   0x1.7dec72p-4, INEXACT)
T(RN,  0x1.5087dd1973067p+287,   -0x1.e6d52baab73bbp-1,   0x1.b07956p-4, INEXACT)
T(RN,  0x1.efabe60472298p+287,    0x1.fdc706290d04fp-1,  -0x1.2bda68p-3, INEXACT)
T(RN,  0x1.b0cf6841ecf5ap+287,   -0x1.5248ea3e28eedp-1,  -0x1.a5b5fcp-4, INEXACT)
T(RN,  0x1.fdfa126b53186p+287,   -0x1.30abda7ffd03ep-1,   0x1.8c447ep-3, INEXACT)
T(RN,  0x1.084fa96aaa59cp+288,    -0x1.c24e49dbea96p-1,  -0x1.701262p-3, INEXACT)
T(RN,  0x1.bde35a37d681cp+288,   -0x1.bf0e3230216acp-3,  -0x1.4d169ap-5, INEXACT)
T(RN,  0x1.bc19fa908202ap+288,    0x1.f6a06e2ab80dcp-4,  -0x1.f22c46p-4, INEXACT)
T(RN,  0x1.6b514fe2d927cp+288,    0x1.b1e48810a24f9p-3,    0x1.1695bp-7, INEXACT)
T(RN,  0x1.dc628dbcc1b1ep+288,    -0x1.5ddc89a8ae24p-1,  -0x1.a6233ep-2, INEXACT)
T(RN,  0x1.4504d38506304p+288,   -0x1.4325ddfa336a3p-3,  -0x1.2ca504p-5, INEXACT)
T(RN,  0x1.06a4246a0cccep+288,    0x1.145f666b9d117p-1,   0x1.64d9dap-4, INEXACT)
T(RN,  0x1.15727b89833b8p+288,   -0x1.9950dded8b57bp-6,  -0x1.9472eap-2, INEXACT)
T(RN,  0x1.4ccecc3b23354p+288,   -0x1.b84f62ad61debp-1,   0x1.65c618p-2, INEXACT)
T(RN,  0x1.79f5989aa2e18p+288,   -0x1.c270bcc99a8f8p-2,    0x1.4a755p-3, INEXACT)
T(RN,  0x1.4a36dbf5b21e5p+289,   -0x1.04881d14c90bep-3,    0x1.9cef6p-2, INEXACT)
T(RN,  0x1.2d614fc858fc6p+289,    0x1.e15f9d977b3d7p-1,  -0x1.94d68ep-3, INEXACT)
T(RN,  0x1.d267d05084c1ap+289,   -0x1.89f4469924ddcp-1,  -0x1.40ad18p-2, INEXACT)
T(RN,  0x1.fb949d94ed901p+289,   -0x1.51e9bb8dc8f88p-3,  -0x1.12c086p-4, INEXACT)
T(RN,  0x1.ae87d727d8594p+289,   -0x1.861d70e823a86p-6,  -0x1.cbcb0cp-5, INEXACT)
T(RN,  0x1.4ee9aff0fad36p+289,   -0x1.089a7cb5f2e1ap-3,  -0x1.fbda34p-2, INEXACT)
T(RN,  0x1.b35ee69e3606ep+289,   -0x1.8068bd991cf91p-1,   0x1.9ee212p-2, INEXACT)
T(RN,  0x1.20149e61c2264p+289,   -0x1.0ea435e5d2445p-1,  -0x1.0925eep-8, INEXACT)
T(RN,  0x1.860a3548248edp+289,   -0x1.e77bc590b4cd9p-1,  -0x1.e9c8fcp-2, INEXACT)
T(RN,  0x1.8a39a3f91acbfp+289,   -0x1.ff73f6c71dd19p-1,   0x1.44c134p-2, INEXACT)
T(RN,  0x1.5c55ba9f7f5f4p+290,   -0x1.bdb18d99148a4p-2,   0x1.43495ep-4, INEXACT)
T(RN,  0x1.0a40125196b78p+290,    0x1.0d87f1937c40ap-1,  -0x1.549e7ep-7, INEXACT)
T(RN,  0x1.11f7b78785059p+290,   -0x1.1c8ac37924cfbp-1,  -0x1.e4d98ap-3, INEXACT)
T(RN,  0x1.d1e9023ea3a08p+290,   -0x1.9fdb7de5d18a1p-7,  -0x1.9b5a96p-3, INEXACT)
T(RN,  0x1.75225297bd7eep+290,     0x1.7423d537a98ep-2,  -0x1.35911ap-2, INEXACT)
T(RN,   0x1.71b5e3fcc4fap+290,    0x1.d8fd4ddef92e9p-1,  -0x1.a2aa58p-3, INEXACT)
T(RN,  0x1.a405e30c29dd8p+290,    -0x1.e324854747f2p-1,   0x1.5f4726p-2, INEXACT)
T(RN,  0x1.56e4795cdbd97p+290,    0x1.ad14fc9c566e9p-1,  -0x1.784f1cp-2, INEXACT)
T(RN,  0x1.ac18a1eef733dp+290,     0x1.c34136a9729ep-1,   0x1.9093aap-2, INEXACT)
T(RN,  0x1.74d5e6da01df9p+290,    0x1.fffd4de211faap-1,  -0x1.ef8726p-3, INEXACT)
T(RN,  0x1.d79fda99b9744p+291,    0x1.5c1b9b8fe6129p-7,   0x1.fe202cp-3, INEXACT)
T(RN,  0x1.accb6d20f8438p+291,    0x1.0bf3592c4ea98p-1,  -0x1.7a527ep-2, INEXACT)
T(RN,  0x1.5114ae49f5f26p+291,   -0x1.7ea07c43742f2p-1,   0x1.985a02p-2, INEXACT)
T(RN,  0x1.0e4526103bdf3p+291,    -0x1.290942453eadp-1,   -0x1.dd51ap-2, INEXACT)
T(RN,  0x1.06df6eee29fd3p+291,    0x1.f97fd7337be95p-1,  -0x1.5ca7e2p-2, INEXACT)
T(RN,  0x1.4ab4121d7873bp+291,     0x1.e81fb1fdb049p-1,  -0x1.171388p-2, INEXACT)
T(RN,  0x1.4b371040516c8p+291,   -0x1.fbcb0e0b1fdd7p-3,  -0x1.fe9de4p-4, INEXACT)
T(RN,  0x1.e4a43fd645b32p+291,   -0x1.cc46ba4176028p-3,  -0x1.e17c24p-2, INEXACT)
T(RN,  0x1.6dde8d447228ap+291,    0x1.24198c13c0483p-1,  -0x1.6cd9dcp-3, INEXACT)
T(RN,  0x1.6a79d4dcddcb6p+291,   -0x1.270007361f5e8p-1,   0x1.158e16p-3, INEXACT)
T(RN,  0x1.972b311349e86p+292,   -0x1.d50a850fa0383p-1,   -0x1.68f61p-7, INEXACT)
T(RN,  0x1.4804fdb3ec2dep+292,    0x1.fd9440cc8ba56p-1,  -0x1.e2c11ep-2, INEXACT)
T(RN,  0x1.0f19a9618b552p+292,    0x1.90fff1841efd9p-3,  -0x1.920538p-5, INEXACT)
T(RN,   0x1.89371a7cae76p+292,   -0x1.495382f012e0fp-2,  -0x1.5861bep-2, INEXACT)
T(RN,  0x1.0be0576c8bcd8p+292,   -0x1.cb530d8c59ef9p-1,   0x1.de178ep-2, INEXACT)
T(RN,  0x1.d7b6e7d2d6062p+292,     0x1.46ce684f44c1p-4,  -0x1.be8bc8p-2, INEXACT)
T(RN,  0x1.9673ed3b80264p+292,    0x1.b4bd3dade4783p-3,   0x1.3b88e8p-2, INEXACT)
T(RN,   0x1.462e2f8f70a6p+292,    0x1.a90e00a3fb088p-1,   0x1.1e2da4p-2, INEXACT)
T(RN,  0x1.4c5339c0f38e5p+292,   -0x1.f7e403e483704p-3,   -0x1.d36e7p-2, INEXACT)
T(RN,  0x1.c7c0b1a23e7e4p+292,    0x1.18b310c30eeb1p-3,  -0x1.491cb6p-3, INEXACT)
T(RN,  0x1.7b1c59725281cp+293,    0x1.d9a1f3a1cc236p-1,  -0x1.1f1beap-2, INEXACT)
T(RN,  0x1.e4bf972b35a2ap+293,    0x1.f4a760a86d16bp-1,    0x1.2c77dp-4, INEXACT)
T(RN,  0x1.712fb0c9f1305p+293,    0x1.2204507000d31p-1,   -0x1.85924p-2, INEXACT)
T(RN,  0x1.37fcccc14148cp+293,   -0x1.e60262da29143p-3,    0x1.fabf7p-2, INEXACT)
T(RN,  0x1.572415147cbfcp+293,    0x1.5a8acdc962cd1p-4,  -0x1.5ae59ep-4, INEXACT)
T(RN,  0x1.fcd480285d3e8p+293,   -0x1.9b4a88e9cb9e4p-4,    -0x1.45f8p-3, INEXACT)
T(RN,  0x1.bb54d9cc697b4p+293,      -0x1.55491c9feap-2,  -0x1.09b59ap-2, INEXACT)
T(RN,  0x1.db2a7931aa84ap+293,    0x1.8bef32a559189p-2,  -0x1.8c99ccp-3, INEXACT)
T(RN,  0x1.38b5cbfd9763ap+293,    0x1.d33b826873793p-2,   0x1.dcd53ap-2, INEXACT)
T(RN,  0x1.cab0a9730b7dap+293,    0x1.7b243f9eb1b86p-1,   0x1.ed206ep-5, INEXACT)
T(RN,  0x1.5c0a3449b3568p+294,   -0x1.2d02d6fa04275p-2,  -0x1.fdea56p-2, INEXACT)
T(RN,  0x1.aaff1391109b2p+294,    -0x1.72cd2c161eecp-3,   0x1.f65ebcp-5, INEXACT)
T(RN,  0x1.3cdbb4ed7f8bdp+294,   -0x1.8512dd8b7a8a4p-1,  -0x1.6b57f4p-2, INEXACT)
T(RN,  0x1.2b8a056350e7dp+294,   -0x1.552f0e0d8c4fcp-2,   0x1.ed5116p-3, INEXACT)
T(RN,  0x1.efc3eee4847a5p+294,   -0x1.fe9e11619710fp-1,   0x1.8ae41ep-3, INEXACT)
T(RN,  0x1.db0176ac3d437p+294,   -0x1.78af09b311bdbp-1,   -0x1.a58ccp-2, INEXACT)
T(RN,  0x1.b3d5c19f5e8f1p+294,   -0x1.7b636276638afp-2,    0x1.f3ad1p-3, INEXACT)
T(RN,  0x1.9c89a5651295ep+294,   -0x1.8a11b042115dap-1,   -0x1.21fc9p-4, INEXACT)
T(RN,  0x1.d39c35cefb20cp+294,   -0x1.d91d7633cfeabp-3,    0x1.11d17p-5, INEXACT)
T(RN,  0x1.160a3f0b15e8ap+294,   -0x1.ffafe6f246c73p-1,  -0x1.a8e94cp-6, INEXACT)
T(RN,  0x1.3a29295adecaap+295,   -0x1.e67c8bd83b99fp-1,   0x1.a23b5ep-2, INEXACT)
T(RN,  0x1.0bdd39eb88682p+295,    0x1.fe8ce4a48f12fp-1,  -0x1.a94bf6p-3, INEXACT)
T(RN,  0x1.0b30e6cce04c8p+295,    0x1.1f55d80c0b6d2p-4,  -0x1.7cd748p-3, INEXACT)
T(RN,  0x1.d7b2982b40f18p+295,   -0x1.9e4d2484ffecbp-2,   0x1.bedba6p-2, INEXACT)
T(RN,  0x1.7b5f2f75b3724p+295,   -0x1.4919adc0df2bcp-2,  -0x1.193c58p-2, INEXACT)
T(RN,  0x1.097a2dc415077p+295,   -0x1.c38cab0ac226dp-3,  -0x1.191f14p-7, INEXACT)
T(RN,  0x1.4f9b04bf6892bp+295,   -0x1.f7cb23ced2068p-1,  -0x1.1eb026p-3, INEXACT)
T(RN,  0x1.2f9a2ab1a6e9bp+295,    0x1.fa6610defd582p-1,   0x1.a75e56p-3, INEXACT)
T(RN,  0x1.bb7b46badcea4p+295,   -0x1.c63e7760d74efp-1,  -0x1.a5956ep-3, INEXACT)
T(RN,  0x1.b6545e0b4270cp+295,    0x1.e70e98fd5b6dep-1,   0x1.c5b688p-3, INEXACT)
T(RN,  0x1.6a0a9ed9daad5p+296,    0x1.20bd9fd2f7025p-1,  -0x1.42a398p-2, INEXACT)
T(RN,  0x1.10adc88cef78cp+296,   -0x1.bfb0e7af5037ap-1,  -0x1.5a54c4p-2, INEXACT)
T(RN,  0x1.3151428049cefp+296,   -0x1.ec3d930ddcb4ep-5,   0x1.8337ccp-4, INEXACT)
T(RN,  0x1.5bec238f5bb73p+296,    0x1.ff19c4373218ep-1,   0x1.291bb6p-2, INEXACT)
T(RN,  0x1.f4c904f7fa07ep+296,   -0x1.b67fb68ce1192p-1,   0x1.ea7254p-6, INEXACT)
T(RN,  0x1.7a6757d72ab04p+296,    0x1.8406b0bdd8e99p-5,   0x1.a16b1cp-3, INEXACT)
T(RN,   0x1.773e9e4bca1bp+296,    0x1.7fe7b4771b6d7p-2,   0x1.b1281ep-2, INEXACT)
T(RN,  0x1.077ccee2b832dp+296,   -0x1.cca9855dc3eabp-1,    0x1.2e69ep-4, INEXACT)
T(RN,  0x1.a87beab6423c9p+296,    0x1.a1f89ae1f9ebap-1,  -0x1.ac018ap-3, INEXACT)
T(RN,  0x1.44afbafab7e83p+296,   -0x1.68e53b4fdcf31p-3,  -0x1.7c3b24p-2, INEXACT)
T(RN,  0x1.32eefb23de9c3p+297,   -0x1.c4a4df893a4e5p-1,   0x1.427eeap-2, INEXACT)
T(RN,  0x1.7a57628863f1dp+297,    0x1.8aa51decb4978p-3,   0x1.eaf27cp-4, INEXACT)
T(RN,  0x1.5f5fad0c88b98p+297,    0x1.0a69d3f63fd35p-1,  -0x1.d3f2d4p-2, INEXACT)
T(RN,  0x1.950573ff4a571p+297,    0x1.10891db3a8ff8p-1,   0x1.d2b23ap-2, INEXACT)
T(RN,  0x1.46354b539b39cp+297,    0x1.45fb23d1de264p-1,   0x1.b242b6p-9, INEXACT)
T(RN,  0x1.1f199abad92a5p+297,   -0x1.6fdacafadf4d8p-1,  -0x1.9b475ap-2, INEXACT)
T(RN,  0x1.238ecbea5a4e1p+297,   -0x1.dfb879c24f4ffp-1,   0x1.52cc26p-2, INEXACT)
T(RN,  0x1.da4dc89030a12p+297,    0x1.aced111da35efp-2,  -0x1.7639cap-3, INEXACT)
T(RN,  0x1.9d658691a6608p+297,   -0x1.8a35e23382455p-2,   0x1.9d830ap-3, INEXACT)
T(RN,  0x1.39b8778c8510ep+297,    -0x1.f4d75f1be088p-1,  -0x1.a7f6c6p-3, INEXACT)
T(RN,  0x1.23ee3428da9c9p+298,    0x1.3d711fc16ad8fp-1,   0x1.78d276p-4, INEXACT)
T(RN,  0x1.531b60e292d44p+298,    0x1.1ba71f98ab0fcp-1,  -0x1.34656cp-4, INEXACT)
T(RN,  0x1.19d1d91a25cbfp+298,   -0x1.fae130efceedcp-1,  -0x1.ad7ed2p-2, INEXACT)
T(RN,  0x1.6a5d40bbd3be9p+298,   -0x1.afa81522db7b4p-1,  -0x1.489696p-4, INEXACT)
T(RN,  0x1.429b91c74f233p+298,   -0x1.77fd6697b8c1bp-2,   0x1.d00132p-2, INEXACT)
T(RN,  0x1.b34fb0f506efcp+298,    0x1.20430dae2f17dp-1,  -0x1.6a17d6p-2, INEXACT)
T(RN,   0x1.395bbda9e867p+298,   -0x1.ff80406e914c9p-1,   0x1.6d776ep-2, INEXACT)
T(RN,   0x1.5b30e92e1404p+298,   -0x1.fff7b1b98c663p-1,  -0x1.e8f798p-2, INEXACT)
T(RN,  0x1.eeb83f8ed4f74p+298,    -0x1.e06821b301e6p-1,  -0x1.fba056p-2, INEXACT)
T(RN,  0x1.31e1c37d651d4p+298,   -0x1.750a95edd1a17p-1,   0x1.e63f3ap-6, INEXACT)
T(RN,  0x1.6c9004c385261p+299,    0x1.fd6d17d873605p-1,  -0x1.ed2542p-6, INEXACT)
T(RN,  0x1.9bd05d13f13dap+299,    0x1.ae2650e07cc2fp-2,  -0x1.005c42p-8, INEXACT)
T(RN,  0x1.4d51ad4542f53p+299,   -0x1.f24e0ea6bde15p-1,  -0x1.df308ap-2, INEXACT)
T(RN,  0x1.0bf7c0a19f50fp+299,   -0x1.e52a7914f0335p-1,  -0x1.111e28p-2, INEXACT)
T(RN,  0x1.d8f662fecf042p+299,    -0x1.67a8af2a1a0ap-3,  -0x1.778aaep-2, INEXACT)
T(RN,  0x1.88bc363eda00ap+299,   -0x1.b65f2b5f6f8fcp-1,  -0x1.f0068ep-7, INEXACT)
T(RN,  0x1.865a6cfb3c504p+299,    0x1.f24f60f143512p-1,  -0x1.11e596p-2, INEXACT)
T(RN,  0x1.1d9e41693cff4p+299,   -0x1.8c70490339c12p-1,   -0x1.5c6cep-3, INEXACT)
T(RN,   0x1.d61d60562cdfp+299,    0x1.ffff6069317a1p-1,   0x1.91b90ep-2, INEXACT)
T(RN,  0x1.8b4adb14ae0d2p+299,    0x1.57a50f17d5d2bp-2,   -0x1.2f4f1p-3, INEXACT)
T(RN,  0x1.70a0b3ebcef9bp+300,   -0x1.c03b25573f82ep-1,  -0x1.6b1e52p-2, INEXACT)
T(RN,  0x1.8ae1f90099cb2p+300,   -0x1.815d4a7c26654p-2,   0x1.d3bddep-3, INEXACT)
T(RN,  0x1.899ef18279f7cp+300,   -0x1.d07a3d33a7b95p-1,   0x1.78187ap-2, INEXACT)
T(RN,  0x1.ae5a08724c9f4p+300,   -0x1.301d7a7d174b6p-2,   -0x1.ab769p-3, INEXACT)
T(RN,  0x1.8f04ffd8e3506p+300,    0x1.e2da1d59d597ep-1,   0x1.a5306ap-2, INEXACT)
T(RN,  0x1.2d23962991c0bp+300,   -0x1.a94695cd8cdc9p-5,  -0x1.73c56ap-3, INEXACT)
T(RN,  0x1.fd4ebf916ce32p+300,    0x1.240d9e22498dfp-1,  -0x1.a1d8c2p-2, INEXACT)
T(RN,   0x1.169537785655p+300,   -0x1.e4c9b18c329b6p-1,  -0x1.897c08p-2, INEXACT)
T(RN,  0x1.df6df8f143848p+300,    0x1.7c967a27c9253p-2,  -0x1.e3e25ap-2, INEXACT)
T(RN,  0x1.3075df822ce5ep+300,    0x1.aa98402426c2fp-1,   0x1.c8eafap-2, INEXACT)
T(RN,  0x1.163738e9f7fb3p+301,   -0x1.f3452a0471888p-1,   0x1.8f8396p-2, INEXACT)
T(RN,  0x1.c36d45bd77d8ep+301,    0x1.c932e4687effap-1,   -0x1.0bde2p-2, INEXACT)
T(RN,  0x1.6dd6deb0b8623p+301,   -0x1.3553cef66ccf6p-1,   0x1.88dd38p-3, INEXACT)
T(RN,  0x1.720cfb20acd05p+301,   -0x1.ff17d8b65d902p-1,   0x1.abdef2p-2, INEXACT)
T(RN,  0x1.faad2282a414ap+301,    0x1.a640c812753e4p-1,    0x1.1a657p-2, INEXACT)
T(RN,  0x1.4eb0683c47e8ap+301,   -0x1.e996b2d9bd0e1p-3,   0x1.34434ap-2, INEXACT)
T(RN,  0x1.022f09ed8cbaep+301,    0x1.2bf3e1b3856e2p-1,   0x1.a350dep-2, INEXACT)
T(RN,  0x1.647a8655952a2p+301,   -0x1.fc37920ce6e24p-1,    0x1.51b59p-3, INEXACT)
T(RN,  0x1.c9666d6dd72d8p+301,   -0x1.b827d27a50111p-1,  -0x1.e44efep-2, INEXACT)
T(RN,  0x1.a7a545b4e3488p+301,     0x1.ff97cdef1c82p-1,  -0x1.830a4ap-4, INEXACT)
T(RN,  0x1.365b2709c44e3p+302,     0x1.0fec9108f0b7p-1,   0x1.1ecbacp-2, INEXACT)
T(RN,  0x1.36ebe5922c6bfp+302,    0x1.8eecc00453c55p-3,  -0x1.a34b6ap-2, INEXACT)
T(RN,  0x1.57584b261d297p+302,    0x1.eca58f723e38bp-1,   -0x1.b88e8p-2, INEXACT)
T(RN,  0x1.613b73c5302eep+302,     0x1.c71266e216f4p-2,   0x1.bdb5d4p-4, INEXACT)
T(RN,  0x1.9e32e609260e8p+302,    0x1.147dc00cd5b65p-2,   0x1.67e7f8p-2, INEXACT)
T(RN,  0x1.e736fd101b7ccp+302,    0x1.baff618d83dcap-1,    0x1.b8a47p-4, INEXACT)
T(RN,   0x1.650d5c7c7ddap+302,    0x1.db6b69f861eb4p-1,   0x1.2a1926p-3, INEXACT)
T(RN,  0x1.733ab4a611148p+302,   -0x1.cadd2726ee29bp-1,  -0x1.f6f9a6p-2, INEXACT)
T(RN,  0x1.5f07e1b288cdcp+302,   -0x1.010b99f92544dp-1,  -0x1.0a9678p-4, INEXACT)
T(RN,  0x1.1026e921a9db6p+302,    0x1.ce7b22f9b21cdp-1,  -0x1.fe8204p-4, INEXACT)
T(RN,  0x1.991243e310e42p+303,    -0x1.e5792558608ap-1,   0x1.b95302p-2, INEXACT)
T(RN,  0x1.3704a1a062669p+303,    0x1.68131b8de9a5fp-1,   0x1.83c77ep-3, INEXACT)
T(RN,  0x1.af7df3b7d0fcdp+303,   -0x1.a5722f0f12146p-1,   0x1.3dfe28p-2, INEXACT)
T(RN,  0x1.6f7a4bb83bd6fp+303,    -0x1.e1ac0bb5eda5p-1,   0x1.be1e48p-3, INEXACT)
T(RN,  0x1.0714bc158c0e3p+303,   -0x1.27109d4431fb4p-1,  -0x1.e720b8p-3, INEXACT)
T(RN,   0x1.f6a2607dcb95p+303,   -0x1.f3732c3dc1b42p-1,   0x1.810a7cp-3, INEXACT)
T(RN,  0x1.e4bdb8ce32094p+303,   -0x1.1c61622c81017p-2,  -0x1.cd4dfep-3, INEXACT)
T(RN,  0x1.f676c99956d25p+303,   -0x1.42ce7074ef0d6p-3,  -0x1.1010fap-2, INEXACT)
T(RN,  0x1.b682c38a30b67p+303,   -0x1.3df9eace8a364p-2,   0x1.19668ep-2, INEXACT)
T(RN,  0x1.509ace56b635bp+303,   -0x1.ff54ab3a6d834p-1,   0x1.20b04ap-2, INEXACT)
T(RN,  0x1.cb7ff808d2992p+304,   -0x1.aa2262a01e153p-3,   0x1.89c23ep-2, INEXACT)
T(RN,  0x1.888da14a00c03p+304,    0x1.f4e0ac57071d9p-1,   0x1.36373cp-2, INEXACT)
T(RN,  0x1.939e56e86c12fp+304,   -0x1.8310fc97095d1p-2,   0x1.7dc9b4p-3, INEXACT)
T(RN,  0x1.298573e0ca455p+304,   0x1.a4f98932f92b1p-11,    0x1.97e7ap-2, INEXACT)
T(RN,  0x1.700ca78282bf6p+304,    0x1.d72503818a2dfp-1,   0x1.bf80aap-2, INEXACT)
T(RN,   0x1.917c71334879p+304,    0x1.6c7ca7fb7589dp-1,  -0x1.67e374p-2, INEXACT)
T(RN,  0x1.23f190d518924p+304,   -0x1.b82de1fb2225bp-1,   0x1.81f244p-2, INEXACT)
T(RN,   0x1.2fdfcb93ab4cp+304,   -0x1.a6e54ab903e29p-4,   0x1.5dfb4ep-3, INEXACT)
T(RN,  0x1.978abc104402ep+304,   -0x1.d97444e5ee0bfp-1,   0x1.7d4e2cp-2, INEXACT)
T(RN,  0x1.c9b0629b3c888p+304,   -0x1.daf80dd98aa1ap-1,   0x1.40bf54p-3, INEXACT)
T(RN,  0x1.9ffa166f0370ap+305,    0x1.fe2d1883d3f67p-2,   0x1.84229ap-2, INEXACT)
T(RN,  0x1.a89334cab3562p+305,    0x1.ffc6c79d6296bp-1,   0x1.235bfep-3, INEXACT)
T(RN,  0x1.3df39e9fda9a3p+305,   -0x1.762c57d50a06fp-1,   0x1.91cf54p-2, INEXACT)
T(RN,  0x1.f797026061118p+305,   -0x1.a31ec91673eeap-2,  -0x1.dcb97ap-2, INEXACT)
T(RN,  0x1.a431474cd759bp+305,   -0x1.2a625946088b7p-1,   0x1.ff962ep-2, INEXACT)
T(RN,  0x1.7822d030faaa5p+305,   -0x1.c3506f8fa2fdap-1,  -0x1.852882p-2, INEXACT)
T(RN,  0x1.8f8fd375c1302p+305,    0x1.66a5f41a5542bp-1,  -0x1.fecb72p-2, INEXACT)
T(RN,  0x1.c8f778c9f5e28p+305,   -0x1.cb71cd8292e4ap-1,  -0x1.afea6ep-4, INEXACT)
T(RN,  0x1.31eba9d436783p+305,   -0x1.af58707105d76p-1,  -0x1.08ff44p-3, INEXACT)
T(RN,  0x1.f697c7c0cdca6p+305,   -0x1.fffed41d30ee5p-1,  -0x1.6a6506p-2, INEXACT)
T(RN,  0x1.2cf5a3e195874p+306,    0x1.13c10a6ecc0a8p-1,   0x1.0cec9cp-4, INEXACT)
T(RN,  0x1.3455e6fae5fc6p+306,    0x1.3977c4ac9fab2p-1,   0x1.cbe1a4p-2, INEXACT)
T(RN,  0x1.8a65e3c626946p+306,    0x1.68703c4d8ce43p-3,   -0x1.421adp-3, INEXACT)
T(RN,  0x1.b5e1edf67cbd3p+306,    0x1.18a5a9512cda1p-1,  -0x1.2fb932p-2, INEXACT)
T(RN,  0x1.0fa897bc508a4p+306,   -0x1.7798c31ad5a29p-6,   0x1.14bb7ep-3, INEXACT)
T(RN,  0x1.32991bee478a5p+306,   -0x1.4cccd807f39b2p-1,   0x1.a96aa8p-2, INEXACT)
T(RN,  0x1.73af220a7ecfdp+306,   -0x1.d715bd6b422c1p-1,   0x1.0e0924p-2, INEXACT)
T(RN,  0x1.3c129c09fae25p+306,    0x1.95a3b4755a05bp-1,   0x1.122e66p-2, INEXACT)
T(RN,  0x1.96c11d24a0a1dp+306,    0x1.3530cbff6d32bp-1,  -0x1.c27b4ap-2, INEXACT)
T(RN,  0x1.129335dd3436bp+306,    0x1.32c2328ad7f92p-2,   0x1.f4f90ap-4, INEXACT)
T(RN,  0x1.b42d5593cca12p+307,   -0x1.fab05f0766295p-1,   0x1.c0b3eap-2, INEXACT)
T(RN,  0x1.133e7d91979b2p+307,   -0x1.1f4b37b942f29p-5,  -0x1.2b4144p-2, INEXACT)
T(RN,  0x1.a30bfbd6c65aep+307,    0x1.9380fa69ad9edp-1,  -0x1.ca41dcp-2, INEXACT)
T(RN,  0x1.3d5b70f0f0612p+307,    0x1.e6927d482fae2p-1,   -0x1.c89e4p-3, INEXACT)
T(RN,   0x1.ef01de72036dp+307,   -0x1.fff23828a307fp-1,    0x1.f407ep-2, INEXACT)
T(RN,  0x1.141571dd7c0eap+307,    0x1.9d5ce3aa4a06ap-1,  -0x1.8fb116p-7, INEXACT)
T(RN,  0x1.c5b6354a2ca6bp+307,    0x1.dde8c73a8aff8p-1,   0x1.e071bep-3, INEXACT)
T(RN,  0x1.76d2333769bb2p+307,   -0x1.754f95d3720e2p-1,  -0x1.d2d1bcp-2, INEXACT)
T(RN,  0x1.38585f5ad23cbp+307,    0x1.fff2f0b9bd221p-1,   0x1.8e9966p-2, INEXACT)
T(RN,   0x1.d41bf8d61d2fp+307,    0x1.61627a2391c0fp-2,  -0x1.cc5012p-2, INEXACT)
T(RN,  0x1.db4e9b81da242p+308,   -0x1.3650cd5baba1bp-1,   0x1.8b2938p-4, INEXACT)
T(RN,  0x1.7d6399c7f2334p+308,   -0x1.a22224565d225p-3,   -0x1.a2d0fp-2, INEXACT)
T(RN,  0x1.7f24a266f0cf9p+308,     0x1.ff29471073b5p-1,   0x1.48e8dap-2, INEXACT)
T(RN,   0x1.ac4cf3a3613ep+308,    0x1.c45b08715cdc3p-6,  -0x1.9a13b6p-2, INEXACT)
T(RN,  0x1.e047fc40ce188p+308,    0x1.2df21fcf8fd3cp-3,  -0x1.55e44cp-3, INEXACT)
T(RN,  0x1.1bfa0c1e82a62p+308,   -0x1.99ff3d584a809p-1,   0x1.8347b4p-2, INEXACT)
T(RN,  0x1.0dc52531d056dp+308,   -0x1.1455428d7ef99p-1,   0x1.162a0ap-3, INEXACT)
T(RN,  0x1.31b3d6c52a6dfp+308,   -0x1.d09475c79d4efp-2,  -0x1.2c88eep-7, INEXACT)
T(RN,  0x1.a4f9127effa5fp+308,    0x1.e047779c94833p-2,  -0x1.1f6888p-3, INEXACT)
T(RN,  0x1.b74cc6af6e7c3p+308,    0x1.dc60468ee6a84p-1,  -0x1.8ec104p-4, INEXACT)
T(RN,   0x1.21773775575cp+309,    0x1.38674bae016eep-1,  -0x1.f1ca82p-4, INEXACT)
T(RN,  0x1.7a37de70570efp+309,   -0x1.6997a347cb61ap-5,  -0x1.43aee6p-3, INEXACT)
T(RN,  0x1.49ec914c0cd4dp+309,    0x1.fa974e001bdefp-1,   0x1.29dd56p-3, INEXACT)
T(RN,  0x1.1f202ec4f80fcp+309,   -0x1.2225909db982ep-1,  -0x1.f8023ap-3, INEXACT)
T(RN,  0x1.d37b2af612b68p+309,   -0x1.b244ab1134dd3p-1,  -0x1.5f6998p-2, INEXACT)
T(RN,  0x1.9c560924b2ae4p+309,   -0x1.fa396045934d8p-1,  -0x1.221e3ap-2, INEXACT)
T(RN,  0x1.96b2f5ad9706ep+309,   -0x1.c32d64e317b22p-1,   0x1.6ab5b4p-5, INEXACT)
T(RN,  0x1.71255360591f3p+309,    0x1.cd295c8b6515ap-2,   0x1.674656p-2, INEXACT)
T(RN,  0x1.8f605d76c74f3p+309,   -0x1.92e06e795a263p-2,   0x1.35a6ecp-3, INEXACT)
T(RN,  0x1.9c8502d320b62p+309,    0x1.6e73c00a7271ep-3,  -0x1.e0f602p-2, INEXACT)
T(RN,  0x1.a343df9716ecfp+310,    0x1.b6219b104e445p-1,   0x1.8b91f2p-5, INEXACT)
T(RN,  0x1.93420c3cee5fcp+310,   -0x1.5525dc386e79bp-1,  -0x1.e457dap-2, INEXACT)
T(RN,  0x1.7d4db4b7d7841p+310,   -0x1.bcb596ee417bbp-1,   -0x1.42a33p-4, INEXACT)
T(RN,   0x1.e16fbe87328dp+310,    0x1.9b56c6515ff61p-3,  -0x1.880722p-2, INEXACT)
T(RN,  0x1.f887d275dc0a2p+310,   -0x1.8cef64de78656p-1,  -0x1.32b6cep-2, INEXACT)
T(RN,  0x1.68d6aaaa6bc23p+310,   -0x1.9663a541b782dp-1,  -0x1.404482p-6, INEXACT)
T(RN,  0x1.13525d2266323p+310,    0x1.fb383279d3e56p-1,   0x1.4768b6p-2, INEXACT)
T(RN,  0x1.bbfebcc07379cp+310,    0x1.f186fc833f311p-1,   0x1.b2ba9ap-2, INEXACT)
T(RN,  0x1.6e8b8f476e176p+310,    0x1.c37432cd21dbap-1,   0x1.1a49c8p-3, INEXACT)
T(RN,  0x1.cac6f92078cf1p+310,   -0x1.ce608b734a2bap-2,   0x1.8ae148p-5, INEXACT)
T(RN,  0x1.151696c58d108p+311,   -0x1.fe544c6664cfbp-1,  -0x1.7fd764p-3, INEXACT)
T(RN,  0x1.bab9508535316p+311,    0x1.29155b247fe9fp-1,  -0x1.b19474p-3, INEXACT)
T(RN,  0x1.f617af8368bbap+311,   -0x1.85ea31643926bp-2,   0x1.c0e024p-4, INEXACT)
T(RN,  0x1.51cbaf68ad0e9p+311,   -0x1.2d645e5e541d3p-1,   0x1.39bfe4p-3, INEXACT)
T(RN,  0x1.fef435241a397p+311,    0x1.e5d1dd7aa2ac1p-2,   0x1.65f304p-2, INEXACT)
T(RN,  0x1.311be0d7ce058p+311,   -0x1.c2ee46c8983b8p-1,  -0x1.cc0606p-2, INEXACT)
T(RN,  0x1.aab072d61e42cp+311,   -0x1.e7f90de7512fbp-3,   -0x1.c501dp-2, INEXACT)
T(RN,  0x1.11e0cf76c7244p+311,    -0x1.60218357687fp-1,  -0x1.d25a64p-2, INEXACT)
T(RN,  0x1.f1c7ff84b2959p+311,   -0x1.3965c8f84288fp-1,   0x1.1a7994p-3, INEXACT)
T(RN,  0x1.39b66c857714ep+311,     0x1.ae4df947ae2dp-1,    0x1.1c6e5p-6, INEXACT)
T(RN,  0x1.9dc0fd686f1b4p+312,   -0x1.25b7c5786d292p-2,    -0x1.068bp-2, INEXACT)
T(RN,  0x1.af91ca6703526p+312,   -0x1.6d02ceec2b48ep-1,   0x1.0f005ep-2, INEXACT)
T(RN,  0x1.8625f8c855ab8p+312,    0x1.da641a5c13faap-1,  -0x1.e72714p-3, INEXACT)
T(RN,  0x1.a948534297024p+312,    0x1.3b49ebdd530bap-1,   0x1.96f212p-2, INEXACT)
T(RN,  0x1.b2db7730556d2p+312,   -0x1.ec4911ae3f1a7p-1,  -0x1.fa856ep-3, INEXACT)
T(RN,   0x1.698e3f50a9ffp+312,    0x1.f7e93136b4f34p-1,   0x1.4d2e84p-3, INEXACT)
T(RN,  0x1.29e24d8802279p+312,   -0x1.be296b27a9168p-1,   0x1.74623cp-3, INEXACT)
T(RN,   0x1.40ef9727da8fp+312,   -0x1.4c41aa57bc407p-1,  -0x1.ade18ap-2, INEXACT)
T(RN,  0x1.eca98876434a2p+312,   -0x1.07668f5b3b0ddp-9,   0x1.7afcf4p-3, INEXACT)
T(RN,  0x1.17df2ea090089p+312,   -0x1.389ed8a198f49p-3,    0x1.c2622p-2, INEXACT)
T(RN,  0x1.8229dfbcd8497p+313,   -0x1.bd1bc56c4c4edp-5,   0x1.794f3ep-2, INEXACT)
T(RN,  0x1.020553a002912p+313,   -0x1.edab6718a39b3p-2,  -0x1.1a2098p-3, INEXACT)
T(RN,  0x1.b17f651571e0ap+313,    0x1.8d577fc70a4eap-1,  -0x1.5a48a6p-2, INEXACT)
T(RN,   0x1.21fe3cb2f435p+313,    0x1.f1e2554f8706ap-1,  -0x1.20a826p-2, INEXACT)
T(RN,  0x1.1c29f16a9a86bp+313,    0x1.7c2d744b4f331p-1,   0x1.8def3cp-3, INEXACT)
T(RN,  0x1.56c2cb151eea8p+313,    0x1.bd979b22daabdp-1,   -0x1.067c6p-2, INEXACT)
T(RN,  0x1.0885e55f9278ap+313,   -0x1.7d9c3fe5a5985p-1,   0x1.95e9c6p-2, INEXACT)
T(RN,  0x1.a71ada4d73101p+313,   -0x1.ab788e3f4c314p-3,  -0x1.c2a3fep-5, INEXACT)
T(RN,  0x1.b5359582108c4p+313,    0x1.cc506c0bed033p-1,  -0x1.c5fb8ap-4, INEXACT)
T(RN,  0x1.dacc075e5abbap+313,    0x1.724b1c6426806p-7,   0x1.25335cp-2, INEXACT)
T(RN,  0x1.ff1a2ae9c7e96p+314,   -0x1.89a64f5440c8bp-6,   0x1.229748p-2, INEXACT)
T(RN,  0x1.edab75498f0c9p+314,   -0x1.2839db26b43fdp-2,  -0x1.40e55ep-2, INEXACT)
T(RN,  0x1.40276e39cef7bp+314,   -0x1.eab8450b76df2p-2,   0x1.520366p-5, INEXACT)
T(RN,  0x1.9575b7b078bbap+314,   -0x1.667c15982327dp-1,  -0x1.f710aap-3, INEXACT)
T(RN,  0x1.11e7140e624b6p+314,    0x1.fd59fd9495aa7p-1,   0x1.fcc2a8p-3, INEXACT)
T(RN,  0x1.8d5fb20277b78p+314,    -0x1.79a5b2307633p-2,  -0x1.7e07b2p-2, INEXACT)
T(RN,  0x1.1ccda54a17c56p+314,   -0x1.e7da7e92d142ap-1,  -0x1.b9428ep-2, INEXACT)
T(RN,  0x1.54107dd3c2497p+314,   -0x1.5ff5e277ffbd1p-1,   -0x1.07e96p-5, INEXACT)
T(RN,   0x1.f8c9289e13fdp+314,    0x1.8d78af2cbdf83p-4,   0x1.0c61f4p-2, INEXACT)
T(RN,  0x1.2b14f949d994ep+314,    0x1.3a950df068e6ep-3,  -0x1.09389cp-4, INEXACT)
T(RN,  0x1.ea05b50453768p+315,    0x1.c4ded413f7e0dp-1,  -0x1.b694f2p-2, INEXACT)
T(RN,  0x1.beae7d347397cp+315,   -0x1.3c64d682d0ebcp-2,  -0x1.a3494ap-2, INEXACT)
T(RN,  0x1.d6c7d861ac728p+315,    0x1.edccc659eaf74p-1,   0x1.ea1cc2p-2, INEXACT)
T(RN,  0x1.44e82852ff313p+315,    0x1.a9c8458b60887p-1,  -0x1.cc3676p-5, INEXACT)
T(RN,  0x1.ac1eee363c088p+315,   -0x1.547aaa3852a37p-2,  -0x1.70ebcep-2, INEXACT)
T(RN,  0x1.126637048a05cp+315,   -0x1.1451763812d54p-2,   0x1.5c2bbap-4, INEXACT)
T(RN,  0x1.29a28e6fee906p+315,    0x1.053cc5daa15a3p-1,   0x1.c9a60ap-4, INEXACT)
T(RN,  0x1.e715ed4b6a56ep+315,    0x1.9d349ad0d4718p-5,   0x1.69913cp-5, INEXACT)
T(RN,  0x1.ea1612ce84ca4p+315,   -0x1.e8fcb79227fe9p-1,   0x1.38c638p-2, INEXACT)
T(RN,  0x1.f158ed0620942p+315,   -0x1.cdc6cb8e1273dp-6,  -0x1.2a2026p-2, INEXACT)
T(RN,   0x1.bc499583dcdcp+316,   -0x1.f2ec524c84188p-1,  -0x1.b673d2p-3, INEXACT)
T(RN,  0x1.a13dede403a92p+316,    0x1.caf02ee36d65cp-2,  -0x1.425052p-3, INEXACT)
T(RN,  0x1.b92d76e0eb886p+316,    0x1.5fdd13354d512p-2,  -0x1.30b5eep-2, INEXACT)
T(RN,  0x1.6d2be0271f442p+316,    0x1.ea3a42a106dc1p-2,   0x1.bdd7dcp-3, INEXACT)
T(RN,  0x1.95f1ed2382144p+316,   -0x1.a818b6791a5b7p-2,  -0x1.f849e8p-2, INEXACT)
T(RN,  0x1.eddc400995fcep+316,   -0x1.fbf766ffd8583p-1,  -0x1.a018e4p-3, INEXACT)
T(RN,   0x1.c3fd32711489p+316,    0x1.ffee594ae212dp-8,   0x1.0bf33ap-2, INEXACT)
T(RN,  0x1.58735acd1cb1fp+316,    0x1.a871a00e8102cp-1,   0x1.b7d81ap-2, INEXACT)
T(RN,  0x1.fc048bb5dce6bp+316,    0x1.c66f6f799cd2fp-1,  -0x1.2ad054p-2, INEXACT)
T(RN,  0x1.64482ec6f6af2p+316,   -0x1.878f2bc970c7ep-2,   0x1.8608dep-2, INEXACT)
T(RN,  0x1.dfc21f5e30f0cp+317,    0x1.51df28973cddbp-1,  -0x1.b1b694p-3, INEXACT)
T(RN,  0x1.c608676d0cb88p+317,   -0x1.fe68fa371c632p-1,  -0x1.99fde2p-2, INEXACT)
T(RN,  0x1.8c17916f98fd4p+317,    0x1.d6fa564157cb7p-1,   0x1.fd0c14p-2, INEXACT)
T(RN,  0x1.f2c0a60627d7cp+317,   -0x1.fa8b3d6bf1d9fp-1,  0x1.59e20ep-10, INEXACT)
T(RN,  0x1.010090129887cp+317,    0x1.3b5b9aa2c4c6ap-1,  -0x1.cb031cp-3, INEXACT)
T(RN,  0x1.cecc95c91c4f6p+317,    0x1.7c161c284e205p-1,  -0x1.eaad56p-3, INEXACT)
T(RN,  0x1.2d1b0865a28f5p+317,   -0x1.216a313090797p-1,  -0x1.594938p-2, INEXACT)
T(RN,  0x1.cba50fd23d5bap+317,    0x1.3a757564de715p-1,   0x1.c51832p-3, INEXACT)
T(RN,  0x1.0c3a93c720737p+317,    0x1.05ab1184d39adp-1,   0x1.cef3c8p-2, INEXACT)
T(RN,  0x1.fce98a6e111f1p+317,    0x1.bf60044aa1685p-1,  -0x1.b0bb46p-2, INEXACT)
T(RN,  0x1.20ed9f88a00eap+318,    0x1.80281b4307219p-2,  -0x1.a74796p-2, INEXACT)
T(RN,  0x1.2f59a58443f46p+318,   -0x1.5bc61a4047db6p-4,   0x1.a090e4p-2, INEXACT)
T(RN,  0x1.2ee0366a10d8bp+318,    0x1.3400be6de2e6cp-1,  -0x1.34f3bep-6, INEXACT)
T(RN,  0x1.0916fcc814723p+318,    0x1.d0d08db26cccep-1,  -0x1.c7088cp-2, INEXACT)
T(RN,  0x1.de5220a3117a8p+318,    0x1.9e595cc9fc68ep-1,   0x1.5b18e6p-3, INEXACT)
T(RN,  0x1.622c34135c5c3p+318,     0x1.ff408c7780c9p-1,  -0x1.0b6d5ep-3, INEXACT)
T(RN,  0x1.5ecc6360b1693p+318,    0x1.2dfec7df0a025p-1,   0x1.3a28dcp-3, INEXACT)
T(RN,  0x1.cd911078a8e43p+318,   -0x1.963d328c47722p-2,   0x1.6fc626p-2, INEXACT)
T(RN,  0x1.3ee0191a03571p+318,    0x1.24c0185abeff7p-1,  -0x1.4d3e22p-2, INEXACT)
T(RN,  0x1.9fa0e2f0d0318p+318,    0x1.a6d6f49af6c46p-1,   0x1.ce47b6p-4, INEXACT)
T(RN,  0x1.c74d4eae20716p+319,   -0x1.623a0e44dccacp-1,   0x1.c44d7ap-5, INEXACT)
T(RN,  0x1.e265f29a2322cp+319,   -0x1.c36f100456b91p-1,   0x1.014716p-5, INEXACT)
T(RN,  0x1.1f2b403aaa0dep+319,    0x1.549ec49a281bbp-3,   0x1.a83e4ep-4, INEXACT)
T(RN,  0x1.aa4420baa56d8p+319,   -0x1.c8fe8ab3b45b7p-1,   -0x1.6e323p-2, INEXACT)
T(RN,   0x1.4923dd181d63p+319,   -0x1.eb42fd6cc81ecp-1,   0x1.b555bep-4, INEXACT)
T(RN,  0x1.a42989f3c376ep+319,    0x1.ffbed9421896dp-1,  -0x1.43fc8ep-2, INEXACT)
T(RN,  0x1.7bec37d5ca964p+319,   -0x1.e88426ca5c9fbp-1,  -0x1.905f6ap-2, INEXACT)
T(RN,  0x1.362f47e27b182p+319,   -0x1.fffd9967156b6p-1,  -0x1.5d8e14p-5, INEXACT)
T(RN,  0x1.f61d9a2af5f54p+319,   -0x1.77725c60ee8dep-3,   0x1.0dcceap-5, INEXACT)
T(RN,  0x1.d647882abc07fp+319,    0x1.77058d4e3ccd1p-1,    0x1.f1d48p-4, INEXACT)
T(RN,   0x1.5b6353adddc3p+320,    0x1.68688b4f58702p-1,  -0x1.08e958p-3, INEXACT)
T(RN,  0x1.dd3824edf6dd4p+320,    0x1.f62be86c81e6bp-1,   0x1.24b858p-2, INEXACT)
T(RN,  0x1.0e278a0ec55ddp+320,   -0x1.4f763234f36dap-1,  -0x1.b7f2aep-4, INEXACT)
T(RN,  0x1.6e98761888d4bp+320,   -0x1.c3cc6edd4b0acp-3,  -0x1.ef31d8p-5, INEXACT)
T(RN,  0x1.19f98db8390e3p+320,   -0x1.afba36516dee4p-1,   0x1.4af53ep-4, INEXACT)
T(RN,  0x1.999080bb51039p+320,   -0x1.fa7491c5e888dp-1,   0x1.b73096p-3, INEXACT)
T(RN,  0x1.98388e241f32cp+320,   -0x1.8dcc3b184d38ep-1,  -0x1.2d9476p-5, INEXACT)
T(RN,  0x1.5f64c52952812p+320,    0x1.3fc6475bc967ep-2,   0x1.ee2bc2p-3, INEXACT)
T(RN,  0x1.e382b89be7993p+320,    0x1.7238243b0975ap-3,  -0x1.6c3f52p-2, INEXACT)
T(RN,  0x1.2a6a93fb878d4p+320,   -0x1.bbcdadf08e01fp-1,  -0x1.4602c6p-2, INEXACT)
T(RN,  0x1.3541e4588bd2ep+321,   -0x1.ff23696d752f4p-1,   0x1.3f14acp-3, INEXACT)
T(RN,  0x1.1259e980b594cp+321,    0x1.1e1ad7d6ca10fp-1,   0x1.1ce766p-4, INEXACT)
T(RN,  0x1.01cbd4b3bbc83p+321,   -0x1.ca1a348373798p-3,   0x1.acc698p-3, INEXACT)
T(RN,  0x1.f21b2bfe97232p+321,    0x1.de77706fdfd53p-1,    0x1.b012fp-3, INEXACT)
T(RN,  0x1.8f2f31a502893p+321,   -0x1.8f002c00d3132p-1,   0x1.2176bcp-2, INEXACT)
T(RN,  0x1.ffbf303c77532p+321,    -0x1.ffa9ac95d251p-1,  -0x1.ca30bep-2, INEXACT)
T(RN,  0x1.418ec4842ad1cp+321,   -0x1.e5e9f01ce4486p-5,  -0x1.71145ap-2, INEXACT)
T(RN,  0x1.c0d0f29d494e8p+321,    0x1.feacf0492e827p-1,   0x1.f738fcp-3, INEXACT)
T(RN,  0x1.0141547935701p+321,   -0x1.dc07ca6a86763p-1,   0x1.a8e30ap-2, INEXACT)
T(RN,  0x1.6ba9a6beba4c3p+321,   -0x1.ce6bd1324075ap-3,  -0x1.0c333ap-3, INEXACT)
T(RN,  0x1.85134f1d041dap+322,    0x1.41032fe326ba2p-5,  -0x1.726d98p-2, INEXACT)
T(RN,  0x1.35f51edfaa888p+322,   -0x1.df8d42375fb7cp-1,   0x1.d23a68p-2, INEXACT)
T(RN,  0x1.0b25edfe1971bp+322,   -0x1.347cc522b055fp-1,  -0x1.a6553ap-5, INEXACT)
T(RN,  0x1.074753975c53bp+322,   -0x1.506a3af75bcfbp-2,   0x1.af4b5cp-3, INEXACT)
T(RN,   0x1.f0ad25d754dep+322,    0x1.77e3d3bcc0f93p-2,   0x1.190c02p-2, INEXACT)
T(RN,  0x1.acb9b1ea1b408p+322,   -0x1.2e4817e8db19ap-4,   0x1.4b7ceep-5, INEXACT)
T(RN,  0x1.c4c27a6375086p+322,    0x1.6e96730998b57p-2,   -0x1.73173p-2, INEXACT)
T(RN,  0x1.f29b465be4556p+322,   -0x1.f84c52beccd4fp-1,  -0x1.6def38p-3, INEXACT)
T(RN,  0x1.6ae4a2df5d45ap+322,    0x1.4ffb00a092406p-5,   0x1.d1c78ap-2, INEXACT)
T(RN,  0x1.fc55653ddb28ap+322,    0x1.9d93ed104306ap-1,   -0x1.34449p-2, INEXACT)
T(RN,  0x1.212d6ca016718p+323,    0x1.18143f2d9ade1p-4,   -0x1.6c267p-3, INEXACT)
T(RN,  0x1.8cbf0e7691dc7p+323,   -0x1.23a12a533b782p-2,   0x1.449552p-3, INEXACT)
T(RN,  0x1.e8a4d28380b9ep+323,    0x1.44a80bd1d4ec4p-1,   0x1.9b928cp-2, INEXACT)
T(RN,  0x1.3b056bc32e935p+323,    0x1.ae6f72ce14726p-1,  -0x1.05af66p-5, INEXACT)
T(RN,  0x1.8addd9c2e4fd7p+323,   -0x1.813d00f597062p-1,  -0x1.f596e4p-2, INEXACT)
T(RN,  0x1.7af4aabffcc08p+323,   -0x1.b4dc40684ac81p-2,   0x1.009576p-3, INEXACT)
T(RN,  0x1.b7110f121a8f3p+323,   -0x1.c88590e389ed7p-1,  -0x1.73c2acp-9, INEXACT)
T(RN,  0x1.d02fd3ef739dcp+323,    0x1.31707ae846daep-2,   0x1.ab8ea2p-3, INEXACT)
T(RN,  0x1.4b9e2412ad314p+323,    0x1.fa952db9cd5a5p-1,  -0x1.413fd4p-3, INEXACT)
T(RN,   0x1.5519c58873cdp+323,    0x1.9699c33e7399bp-1,  -0x1.c7bf78p-2, INEXACT)
T(RN,  0x1.04129be2ac194p+324,    0x1.bbf001af347cfp-1,  -0x1.e0b6e2p-4, INEXACT)
T(RN,  0x1.6d6e5c766fa54p+324,    0x1.3a58fa8cd8f07p-1,  -0x1.ba95f4p-2, INEXACT)
T(RN,   0x1.a3a00c77e336p+324,    -0x1.55d46bb21e56p-1,   0x1.4b9d46p-3, INEXACT)
T(RN,  0x1.37d5e5202fd7fp+324,   -0x1.0b20c25590a88p-6,  -0x1.c2c178p-2, INEXACT)
T(RN,  0x1.5c82cb975e0a4p+324,    0x1.fb3880da0d37fp-1,   -0x1.28a61p-2, INEXACT)
T(RN,   0x1.99709823accep+324,    0x1.37de692cab879p-1,   0x1.80bd88p-3, INEXACT)
T(RN,  0x1.68ff7dbbedf22p+324,     0x1.e608d6ed1be5p-2,  -0x1.acc1bap-3, INEXACT)
T(RN,  0x1.8bfbc9999890ap+324,    0x1.e2bbc74407494p-1,   -0x1.be9f1p-3, INEXACT)
T(RN,   0x1.d295591f218ap+324,    0x1.b4043465f2a41p-2,   0x1.82d3ap-10, INEXACT)
T(RN,  0x1.a98c115bc9724p+324,   -0x1.3defd0c47635dp-1,  -0x1.987646p-3, INEXACT)
T(RN,  0x1.131afe3641da3p+325,    0x1.ce4fbf3e3cb04p-1,   0x1.1bd9f2p-3, INEXACT)
T(RN,  0x1.8828a7180f01fp+325,   -0x1.884721d3c97eep-7,  -0x1.8b407cp-6, INEXACT)
T(RN,  0x1.ad147e605d739p+325,    0x1.32aaa80b58a7fp-1,   -0x1.ff254p-2, INEXACT)
T(RN,  0x1.0ef560b70a712p+325,    0x1.1d8f45863a34ep-5,   0x1.8cdd72p-2, INEXACT)
T(RN,  0x1.3ab35924ec889p+325,    0x1.cc0626450e11fp-1,   0x1.4e74eap-3, INEXACT)
T(RN,  0x1.7dadb72d93db6p+325,    0x1.bf870dfb4cb47p-1,   0x1.a97e86p-2, INEXACT)
T(RN,  0x1.81c9f71ff9a98p+325,    0x1.fb24afcc4b95bp-1,  -0x1.85b446p-3, INEXACT)
T(RN,  0x1.684c07cb6a7a3p+325,   -0x1.7e07016585175p-1,   0x1.1ccfaep-4, INEXACT)
T(RN,  0x1.83f340c61d419p+325,    0x1.fa0211338a293p-2,   0x1.391684p-2, INEXACT)
T(RN,  0x1.5328c34042037p+325,   -0x1.3a0dc286b4718p-2,   0x1.900366p-2, INEXACT)
T(RN,  0x1.88a87d7e57811p+326,    0x1.3b88892cad457p-1,  -0x1.c6ea2ap-2, INEXACT)
T(RN,  0x1.775be1452881cp+326,    0x1.b2b7b83347444p-3,  -0x1.158aa8p-3, INEXACT)
T(RN,  0x1.88e36ab88c663p+326,    0x1.0dd1816eded3bp-3,  -0x1.16c572p-4, INEXACT)
T(RN,  0x1.94b0d8a77dfe6p+326,   -0x1.ff2c97165f1d8p-1,  -0x1.4d2d82p-3, INEXACT)
T(RN,  0x1.929ba0fdf2b8ap+326,    0x1.0e132bffe4fa2p-3,  -0x1.146a1cp-2, INEXACT)
T(RN,   0x1.cd9fe8fbee1cp+326,   -0x1.590b0c5aef1c2p-1,  -0x1.e0938ap-3, INEXACT)
T(RN,  0x1.0db595b49217bp+326,   -0x1.8feedb310147ap-1,   0x1.345d04p-5, INEXACT)
T(RN,  0x1.33f184de4839fp+326,    0x1.9c7ceeeaefaf2p-1,    0x1.88c63p-2, INEXACT)
T(RN,  0x1.cadcab7acd01ep+326,      0x1.a7f826162bep-1,   0x1.5a6bb2p-2, INEXACT)
T(RN,  0x1.a5bf0411ef18ep+326,   -0x1.fda407b6cb346p-1,  -0x1.ea8f6ep-2, INEXACT)
T(RN,  0x1.7d0058e0a466dp+327,   -0x1.30ef209b17083p-1,  -0x1.48f6a8p-5, INEXACT)
T(RN,  0x1.09d1d7c98b466p+327,    0x1.938611a6dcf6ep-4,   -0x1.23f14p-2, INEXACT)
T(RN,  0x1.cbed5a8258876p+327,   -0x1.3577eb5242cc7p-1,  -0x1.0ce9cp-12, INEXACT)
T(RN,  0x1.972422568d013p+327,    0x1.7b3c06f58cafap-1,   0x1.96e84ap-3, INEXACT)
T(RN,  0x1.7895ff6b5da26p+327,   -0x1.8f13c0be7e1d4p-2,   0x1.792ee6p-3, INEXACT)
T(RN,  0x1.1b0253a49c213p+327,   -0x1.d813b66c4f2bcp-1,  -0x1.61f474p-6, INEXACT)
T(RN,  0x1.838633d0d6e7ep+327,   -0x1.ab2339a7cbefcp-2,   0x1.1da04p-11, INEXACT)
T(RN,  0x1.5a809f9dece9ep+327,    0x1.9c8f40e62c1bbp-1,   0x1.f4f8e6p-2, INEXACT)
T(RN,  0x1.b7115ba4be95fp+327,   -0x1.ff2f6df40adf7p-1,  -0x1.c1dc88p-2, INEXACT)
T(RN,  0x1.e3d3033e2ab52p+327,    0x1.01a72954f10dap-1,   -0x1.4d92dp-5, INEXACT)
T(RN,  0x1.c29f0ad998776p+328,    0x1.ebcec3ddd1e1ap-1,   -0x1.2cf57p-3, INEXACT)
T(RN,  0x1.88077694cd9afp+328,    0x1.3b91e6e89d638p-1,    0x1.32837p-2, INEXACT)
T(RN,  0x1.29c2b05b0ef48p+328,   -0x1.ff6ae33e16bdbp-1,   0x1.ee033ep-4, INEXACT)
T(RN,  0x1.250dd04ac41b4p+328,    0x1.a5bcf4cf51d93p-3,   0x1.3377d6p-5, INEXACT)
T(RN,  0x1.189dc79c00065p+328,    0x1.930aeedf504cdp-1,   0x1.ac222ep-2, INEXACT)
T(RN,  0x1.657dba8a842bap+328,    0x1.eaa2fd3add9acp-1,  -0x1.c1d334p-3, INEXACT)
T(RN,  0x1.45af42c4e88b3p+328,   -0x1.52d6fb5ac26e5p-1,   0x1.ab2854p-4, INEXACT)
T(RN,  0x1.bdf4c75020dcbp+328,   -0x1.ed75bfb8b3df6p-1,  -0x1.aa77d6p-3, INEXACT)
T(RN,  0x1.34637548a7b6dp+328,    0x1.c59f7d623292cp-1,   0x1.cd7d1ap-2, INEXACT)
T(RN,  0x1.048c6115184bbp+328,    0x1.863f710f495a2p-2,   0x1.fdd6eap-4, INEXACT)
T(RN,  0x1.a94be66471588p+329,    0x1.006c10ed4f5a4p-1,  -0x1.965c0ep-6, INEXACT)
T(RN,  0x1.9d97454ef91edp+329,   -0x1.370dd5914537ep-1,  -0x1.0533d8p-2, INEXACT)
T(RN,  0x1.fc20b63f88d34p+329,    0x1.da9d037189ffep-2,  -0x1.fafe92p-2, INEXACT)
T(RN,  0x1.9dc37d6e5b234p+329,   -0x1.441bab21e4d3fp-1,  -0x1.4678eap-5, INEXACT)
T(RN,  0x1.53c009cb501f9p+329,    0x1.6f2a349f4d7cbp-1,   0x1.a6206ep-3, INEXACT)
T(RN,  0x1.55f6be24c54c6p+329,   -0x1.6ddb8ea883818p-1,    0x1.9e2a9p-2, INEXACT)
T(RN,  0x1.b1cd4c168a12bp+329,   -0x1.f64cac52966a2p-1,    0x1.9f6d5p-6, INEXACT)
T(RN,  0x1.1d57c988a72bep+329,   -0x1.a6208209a7e3cp-4,   0x1.9b66fap-3, INEXACT)
T(RN,  0x1.c2eb08022e04fp+329,    0x1.f7b16ff0cdf21p-1,  -0x1.c55812p-2, INEXACT)
T(RN,  0x1.05c17e01829bap+329,   -0x1.7d690d3add3d5p-1,   0x1.e5cd64p-3, INEXACT)
T(RN,  0x1.f2c0e0eb92646p+330,    0x1.8d4ee924c8fa2p-1,   0x1.3c59ecp-3, INEXACT)
T(RN,  0x1.101b3bc8ce9a6p+330,   -0x1.de628dcc8c85ep-1,   0x1.b2a9e8p-3, INEXACT)
T(RN,  0x1.9a4eef749b99bp+330,     0x1.1a39755b0e87p-2,  -0x1.f8e632p-7, INEXACT)
T(RN,  0x1.70b60c4c15af4p+330,    0x1.834b7d1b36a7ep-1,  -0x1.a30efcp-4, INEXACT)
T(RN,   0x1.0482715ab063p+330,   -0x1.30d02cb9490b3p-2,  -0x1.d1f872p-3, INEXACT)
T(RN,   0x1.1cdbba35f1a3p+330,   -0x1.ef000801ce613p-1,  -0x1.8f5c64p-8, INEXACT)
T(RN,  0x1.f0b1b5cc17ca8p+330,    0x1.5d8e6a08ec18ep-3,  -0x1.806072p-2, INEXACT)
T(RN,  0x1.d84bfaac9ed94p+330,   -0x1.59a6103a7a1f2p-2,   0x1.ad9e42p-4, INEXACT)
T(RN,  0x1.d327380ce2bd6p+330,   -0x1.568cc8c88e055p-6,  -0x1.659eb8p-2, INEXACT)
T(RN,  0x1.13f98f44a82e4p+330,    -0x1.225c63a7f24dp-1,   0x1.278aa8p-2, INEXACT)
T(RN,  0x1.9eadfb9ad0873p+331,    0x1.a57f6cb174cd6p-3,  -0x1.4452acp-2, INEXACT)
T(RN,   0x1.79635e88e143p+331,   -0x1.6e58815407f1cp-1,   0x1.3e860cp-2, INEXACT)
T(RN,  0x1.c869c5755eb4bp+331,    0x1.f6615db0e2b8bp-1,    0x1.95afdp-7, INEXACT)
T(RN,   0x1.d953bb1a7ab6p+331,   -0x1.b11e9ee8f1a7cp-1,  -0x1.6e1208p-2, INEXACT)
T(RN,  0x1.7a0d3543748bdp+331,    0x1.12f693d9ae9fep-1,  -0x1.f5ecb4p-3, INEXACT)
T(RN,  0x1.58a84aea93a92p+331,   -0x1.ca2cf67a8a21bp-4,  -0x1.9e5fa8p-3, INEXACT)
T(RN,  0x1.9021de8592bd4p+331,    0x1.7ab49f5e5f7dcp-4,   0x1.71a4e2p-3, INEXACT)
T(RN,  0x1.3eb667124930fp+331,    0x1.716d0933dde4ep-1,  -0x1.c6757ap-2, INEXACT)
T(RN,  0x1.edbe450c4a39cp+331,   -0x1.03536a795a289p-1,  -0x1.e8f278p-3, INEXACT)
T(RN,  0x1.13658cc6ec8a9p+331,   -0x1.5727d593efa6ap-1,    0x1.3d771p-5, INEXACT)
T(RN,  0x1.a7d3bc2f12d72p+332,    0x1.3e93bf05a9ec6p-2,  -0x1.714a02p-3, INEXACT)
T(RN,  0x1.21463601b6c34p+332,    0x1.148f2e9a30fb7p-1,  -0x1.c5cd0ep-2, INEXACT)
T(RN,  0x1.e84f9672c16bap+332,    0x1.d8d77944873bap-5,  -0x1.719022p-2, INEXACT)
T(RN,  0x1.5e33f316b3395p+332,   -0x1.ce095066db6acp-1,   0x1.47e2b6p-2, INEXACT)
T(RN,  0x1.b3e7194e995ebp+332,   -0x1.772ec4ca11825p-4,  -0x1.58b372p-2, INEXACT)
T(RN,  0x1.0f557ba1b41d4p+332,   -0x1.6381669453686p-2,  -0x1.91c1a2p-2, INEXACT)
T(RN,  0x1.e147fbadbf20bp+332,   -0x1.16a6d87e23819p-2,  -0x1.047b5cp-6, INEXACT)
T(RN,  0x1.c5ae364ff9d5ep+332,    0x1.2ed934411805bp-2,   -0x1.2299ep-5, INEXACT)
T(RN,   0x1.69c6e1e69b58p+332,   -0x1.07cddc6a267dcp-5,  -0x1.d129b4p-3, INEXACT)
T(RN,  0x1.b0b9a40261bd8p+332,    0x1.1322790fb126ep-2,    0x1.fe1cdp-2, INEXACT)
T(RN,  0x1.68bac59fb3572p+333,   -0x1.fe5638dfb389ap-7,   0x1.493ff2p-2, INEXACT)
T(RN,  0x1.eb9e65866affap+333,    0x1.e421383d019eep-1,  -0x1.f5cc1ep-3, INEXACT)
T(RN,  0x1.92b5b2ed2920cp+333,    0x1.e0455f18c4f81p-1,   0x1.1251f6p-2, INEXACT)
T(RN,  0x1.7d7df30a0795bp+333,   -0x1.826d294e405c6p-1,  -0x1.8ac08ap-5, INEXACT)
T(RN,  0x1.414d3e22107d1p+333,      0x1.dea66549f7cp-3,  -0x1.1ebbe4p-2, INEXACT)
T(RN,  0x1.f2347bc052504p+333,   -0x1.5016d1a389666p-1,   0x1.034704p-2, INEXACT)
T(RN,  0x1.0d4103bdbf178p+333,    0x1.18caa731335f4p-1,   0x1.c26eccp-6, INEXACT)
T(RN,  0x1.4d85c3504b0bap+333,   -0x1.1712a64b2e048p-1,   0x1.13b40ap-4, INEXACT)
T(RN,  0x1.681ce8aaa100bp+333,    0x1.50b1293c08dd3p-1,  -0x1.dd92eap-2, INEXACT)
T(RN,  0x1.6dc7e00b1f712p+333,     0x1.b8fabdef04dbp-1,  -0x1.e62fc6p-2, INEXACT)
T(RN,  0x1.996fe6df73a61p+334,    0x1.c79e33e3bb4d8p-1,  -0x1.3405d8p-2, INEXACT)
T(RN,  0x1.3b8987b77d94ep+334,    -0x1.b4d916316cd7p-1,   0x1.2ffea4p-4, INEXACT)
T(RN,  0x1.6da2e68e60651p+334,   -0x1.f7ebbb2882fb2p-1,    0x1.6f9b7p-2, INEXACT)
T(RN,  0x1.1d936a98f85c6p+334,   -0x1.590223163aeb1p-1,   0x1.81f20cp-3, INEXACT)
T(RN,  0x1.0e69e7d96c7d7p+334,   -0x1.fb040ec9cae26p-1,   0x1.e8ef66p-3, INEXACT)
T(RN,  0x1.7472fde8d8329p+334,   -0x1.db8452e7e0a0cp-1,   0x1.d613dap-2, INEXACT)
T(RN,  0x1.78dbf0b9dacbcp+334,   -0x1.44a754116f4afp-2,  -0x1.78d8b2p-2, INEXACT)
T(RN,  0x1.0bb1ca67596bfp+334,   -0x1.0bffe46d606e5p-2,  -0x1.47667ap-3, INEXACT)
T(RN,   0x1.e703d8747be4p+334,   -0x1.f29694d531a9bp-4,  -0x1.e75c02p-2, INEXACT)
T(RN,   0x1.46d2fda88c48p+334,    -0x1.01f4f549024ap-1,  -0x1.54d18ap-2, INEXACT)
T(RN,  0x1.9201a94d20495p+335,    0x1.4fe36f3300b25p-4,    0x1.899b5p-3, INEXACT)
T(RN,  0x1.4f9581d94e16fp+335,   -0x1.feb5964e3c873p-1,   0x1.5efb34p-4, INEXACT)
T(RN,  0x1.c5aee4aa53b69p+335,    -0x1.dda06e4f3f2bp-1,   0x1.94c224p-3, INEXACT)
T(RN,  0x1.967d8fa94c30cp+335,   -0x1.ca231822ef93ep-3,  -0x1.b90a2ep-3, INEXACT)
T(RN,  0x1.becb7b30d8c92p+335,    0x1.bbd7e1201f18ap-1,  -0x1.fe716ap-3, INEXACT)
T(RN,  0x1.46887283bb2b2p+335,    0x1.71dddc6c81df8p-2,   0x1.cddc58p-2, INEXACT)
T(RN,  0x1.733731cf7fbf6p+335,    0x1.b6e549439cad6p-3,  -0x1.147164p-2, INEXACT)
T(RN,  0x1.7879d239cf897p+335,   -0x1.03f56672e9494p-4,   0x1.758ec8p-5, INEXACT)
T(RN,  0x1.e0cd6e72197e9p+335,    0x1.c08370d3a7081p-2,  -0x1.2c6f06p-3, INEXACT)
T(RN,  0x1.5683d6c825cb6p+335,   -0x1.026c83cfe0e85p-1,  -0x1.57cc0cp-3, INEXACT)
T(RN,  0x1.e2ae17b9e42dcp+336,    0x1.dbb01d23d0b66p-1,  -0x1.4bf552p-2, INEXACT)
T(RN,  0x1.a072a6bcfcbe8p+336,    0x1.41bdaecabc112p-2,   0x1.926738p-2, INEXACT)
T(RN,  0x1.95393c85b9043p+336,    0x1.8af4a45720a87p-1,   0x1.d5b50ep-3, INEXACT)
T(RN,   0x1.8e7936e8c8a3p+336,    0x1.f60e2bcb73885p-1,  -0x1.c17aecp-2, INEXACT)
T(RN,  0x1.525a4d32fb10ep+336,    0x1.1167dcfd730d1p-2,   0x1.83bb9ep-2, INEXACT)
T(RN,  0x1.93acfa14085eap+336,    0x1.f512b87ba3bb8p-1,  -0x1.f23ca4p-2, INEXACT)
T(RN,  0x1.eaa1a7cee6c13p+336,    0x1.de866c1315f9ep-2,  -0x1.fb7ceap-6, INEXACT)
T(RN,  0x1.bed076b4e3ba8p+336,    0x1.8523cd0c9dd28p-1,   -0x1.4963bp-2, INEXACT)
T(RN,  0x1.8db04707776a6p+336,    0x1.e9e8dc5e516b6p-1,   0x1.e8a358p-4, INEXACT)
T(RN,  0x1.c815b47380bd5p+336,   -0x1.e9bc4b99b86fbp-1,  -0x1.348474p-5, INEXACT)
T(RN,  0x1.493f5af35ca8fp+337,    0x1.7e45e8c3d623ap-2,  -0x1.4ed6dep-3, INEXACT)
T(RN,  0x1.b15be93bf4bc2p+337,    0x1.fa564cb0a833ap-2,   0x1.91a8a2p-2, INEXACT)
T(RN,  0x1.080129a845b74p+337,   -0x1.2a92d1d03cefep-1,  -0x1.626264p-2, INEXACT)
T(RN,  0x1.9b5d12e0bd302p+337,   -0x1.8fff25459fd3fp-1,  -0x1.2b121ap-2, INEXACT)
T(RN,  0x1.baf467af9316fp+337,   -0x1.ae89804a8ab21p-2,   -0x1.47befp-2, INEXACT)
T(RN,  0x1.1e393792e5824p+337,   -0x1.2ea440c7bda1ap-2,   0x1.0545f6p-2, INEXACT)
T(RN,  0x1.9575b140c104cp+337,     0x1.f81ae76e49f8p-2,  -0x1.83f592p-4, INEXACT)
T(RN,  0x1.104083881eba5p+337,    -0x1.4c39781e6b16p-6,   -0x1.253e9p-2, INEXACT)
T(RN,    0x1.2a489a97163p+337,    0x1.84649b4b85505p-1,  -0x1.a0e05ap-2, INEXACT)
T(RN,  0x1.7e60a3a61f352p+337,   -0x1.8be66bdf93958p-2,   0x1.db9312p-3, INEXACT)
T(RN,  0x1.66915cb0ef165p+338,    0x1.e49d020eb40dfp-1,  -0x1.e5ccc2p-3, INEXACT)
T(RN,  0x1.f8bbd0e5ed3bep+338,   -0x1.5c75cc3bef1b8p-1,  -0x1.d93db4p-7, INEXACT)
T(RN,   0x1.beee13ec4ca3p+338,   -0x1.7283a4adb6e99p-2,  -0x1.a262a8p-3, INEXACT)
T(RN,  0x1.2646bc9a640a7p+338,    -0x1.7df67425897bp-1,  -0x1.d32a8ap-3, INEXACT)
T(RN,  0x1.5c427711d8a3bp+338,    0x1.c11a00f2baac3p-2,   0x1.2473aap-2, INEXACT)
T(RN,  0x1.194fe495a5b79p+338,    0x1.3a1cc1a43dd0dp-1,  -0x1.808d2ep-2, INEXACT)
T(RN,  0x1.150e8c03de89fp+338,    0x1.977079852046ep-1,   0x1.bfe9fap-3, INEXACT)
T(RN,   0x1.aaa8a9a98f31p+338,    0x1.e6958f07e051ap-2,   0x1.ab6f0ap-2, INEXACT)
T(RN,  0x1.12a1cddf4dde9p+338,    0x1.eb490caa1000ap-1,   -0x1.addb5p-2, INEXACT)
T(RN,  0x1.7277f1db62fa6p+338,   -0x1.729e5ef72a90dp-1,   0x1.6108a4p-4, INEXACT)
T(RN,  0x1.6a53e754d38e9p+339,    0x1.8364953456e06p-1,  -0x1.fff78ap-2, INEXACT)
T(RN,  0x1.dcad68be11e6dp+339,    0x1.f02236d923af5p-2,   0x1.264ac2p-3, INEXACT)
T(RN,  0x1.784a601ea9f89p+339,    0x1.73b992e200d6fp-2,   0x1.1d005ap-3, INEXACT)
T(RN,  0x1.b55a5b0317689p+339,    0x1.735536bd3743dp-1,   0x1.4dee38p-3, INEXACT)
T(RN,  0x1.495eeb44e0417p+339,    0x1.76ae9433d581bp-1,   0x1.aa2f78p-2, INEXACT)
T(RN,  0x1.c9f1959cff3f4p+339,   -0x1.0c66c113ad52bp-2,   0x1.dc8832p-2, INEXACT)
T(RN,  0x1.5934b333b0bcap+339,    -0x1.d49ab2608361p-2,   0x1.b547f8p-2, INEXACT)
T(RN,  0x1.93c8b428a3476p+339,   -0x1.4ec1bbf19501cp-5,  -0x1.54f878p-5, INEXACT)
T(RN,  0x1.07511b5f84dd5p+339,   -0x1.3bfb4d28e9932p-5,  -0x1.6be378p-2, INEXACT)
T(RN,  0x1.72e9fb80a71ccp+339,   -0x1.b201d478332c8p-1,   0x1.136994p-4, INEXACT)
T(RN,  0x1.aa70cbcefc634p+340,   -0x1.df9fc2e047eecp-3,  -0x1.d16ffep-3, INEXACT)
T(RN,  0x1.be332607a9edap+340,    0x1.ad695d53cc65fp-4,   0x1.3ded4ep-2, INEXACT)
T(RN,  0x1.33d3826550814p+340,    0x1.1a730ba16a71dp-2,   0x1.f48908p-3, INEXACT)
T(RN,  0x1.1859bd7a2381fp+340,    0x1.3676eef972e99p-1,   0x1.3259dep-2, INEXACT)
T(RN,  0x1.f1be66ae7ad0ep+340,    0x1.c5ac2657b04f7p-1,   0x1.f6d974p-2, INEXACT)
T(RN,  0x1.c383a4d2382bbp+340,   -0x1.d2a7b431b0a9ap-1,    0x1.1ab21p-2, INEXACT)
T(RN,  0x1.2ad689a70e878p+340,    0x1.fd9dc924ec68bp-1,   0x1.bdd2b8p-2, INEXACT)
T(RN,  0x1.e63ee2ae80852p+340,    0x1.1230c6bd4283cp-2,  -0x1.53a3e8p-2, INEXACT)
T(RN,  0x1.c1b2b823b11e2p+340,   -0x1.7f784ead8a952p-5,   0x1.6c6308p-2, INEXACT)
T(RN,  0x1.ea305ba55292ep+340,    0x1.a7316c762f3f2p-1,  -0x1.6588fap-2, INEXACT)
T(RN,  0x1.af4b95977c48cp+341,    0x1.a8acf97191d88p-1,   0x1.ec59b2p-4, INEXACT)
T(RN,  0x1.8426b5563ae4ep+341,    0x1.f13dd181a967ap-1,   0x1.e23e02p-3, INEXACT)
T(RN,  0x1.85e45e9319fc8p+341,    0x1.b2c9ac2d721d1p-2,   0x1.cbe49ap-3, INEXACT)
T(RN,  0x1.d5965232f3f16p+341,   -0x1.ba2a4086274b3p-3,   0x1.bd6ee2p-2, INEXACT)
T(RN,  0x1.e710adb05c19ap+341,   -0x1.98bb0e1065155p-2,   0x1.0e2602p-3, INEXACT)
T(RN,  0x1.9177fb715f514p+341,   -0x1.863c7e72b0711p-2,   0x1.ef642ep-4, INEXACT)
T(RN,  0x1.ff0c0df0487dap+341,    0x1.f927f61d3fb36p-1,    0x1.89f7cp-2, INEXACT)
T(RN,  0x1.4ef98561277d7p+341,    0x1.00a1a410b27c8p-1,    0x1.60d48p-3, INEXACT)
T(RN,    0x1.c3118887c57p+341,   -0x1.020f263e975d2p-1,  -0x1.62ba9ap-3, INEXACT)
T(RN,   0x1.e5e64ffd3f5bp+341,   -0x1.c4e95f054045ep-1,   0x1.04939ep-3, INEXACT)
T(RN,  0x1.09b4fbc9a8634p+342,    0x1.b7276089f7d7ep-5,   -0x1.125dcp-2, INEXACT)
T(RN,  0x1.64ef43c87fcc1p+342,   -0x1.69d600ca39ebap-1,  -0x1.0c6e1cp-3, INEXACT)
T(RN,  0x1.baf90eef506a7p+342,   -0x1.cf44e475e9bdfp-2,    0x1.8dcc9p-2, INEXACT)
T(RN,  0x1.4fc4bbd2ea0d2p+342,    0x1.490ad5c293795p-1,  -0x1.3bcacep-2, INEXACT)
T(RN,  0x1.e2bcd6484ce8ap+342,   -0x1.d1979609579fcp-1,   0x1.bc8abcp-4, INEXACT)
T(RN,  0x1.68a0089ffe1f8p+342,    0x1.e38c1403ec2f4p-1,  -0x1.8cbbd8p-8, INEXACT)
T(RN,  0x1.0fecce1c3c2dfp+342,    0x1.768cd99a658f2p-2,  -0x1.0671b6p-3, INEXACT)
T(RN,  0x1.b1a5d383d477cp+342,   -0x1.7b9c1fc982405p-1,  -0x1.dc04f6p-2, INEXACT)
T(RN,  0x1.fd7f5d216f518p+342,   -0x1.1a2029a6c3d4ap-6,  -0x1.c7cdc2p-3, INEXACT)
T(RN,  0x1.8ed45037abcacp+342,    -0x1.0652e5633002p-1,   -0x1.13ae7p-2, INEXACT)
T(RN,  0x1.b0371b1c64186p+343,    0x1.ca1d0e2360c87p-1,   0x1.47ccc2p-4, INEXACT)
T(RN,  0x1.ed5349d3c680ep+343,   -0x1.deaf73247db53p-1,  -0x1.c64516p-2, INEXACT)
T(RN,  0x1.a297e8b2630acp+343,    -0x1.ac8d3e853ec8p-2,   0x1.de9edep-3, INEXACT)
T(RN,  0x1.7775d90584f83p+343,    0x1.cd5dd6c093a2ep-1,   0x1.f1df86p-2, INEXACT)
T(RN,  0x1.320a7ae01e337p+343,    0x1.346eca8e2ae19p-1,   0x1.5149eep-2, INEXACT)
T(RN,  0x1.de200125fd4dcp+343,   -0x1.f01ef8da465a7p-3,   0x1.b09054p-2, INEXACT)
T(RN,  0x1.86e8ed92d23dap+343,    0x1.114633cf85cb9p-2,   -0x1.3fcc3p-2, INEXACT)
T(RN,  0x1.aacedeec73d86p+343,   -0x1.9b7047ab23183p-1,   -0x1.57356p-2, INEXACT)
T(RN,  0x1.df7997f4bfbf7p+343,    0x1.629c74c6f2509p-8,    0x1.96d81p-2, INEXACT)
T(RN,  0x1.2b8c2d1f1c7fap+343,   -0x1.394710bdbe58ep-1,   0x1.6edc3cp-3, INEXACT)
T(RN,  0x1.7d4dc3b12f589p+344,    -0x1.d04ba00d2426p-1,   0x1.c93554p-6, INEXACT)
T(RN,  0x1.e546d27c7328ap+344,   -0x1.640581fef95cap-3,   -0x1.ca22fp-2, INEXACT)
T(RN,  0x1.2100065df5a6ap+344,    0x1.e42ae2ab6c1dfp-1,   0x1.71d93ep-3, INEXACT)
T(RN,  0x1.e7a3cfcfef918p+344,    0x1.ecbbab89a4759p-1,  -0x1.aeef38p-4, INEXACT)
T(RN,  0x1.4ec7f53dc9604p+344,    0x1.ec6ae04099459p-1,   0x1.2ae9fep-4, INEXACT)
T(RN,  0x1.0c9cc7603ec36p+344,   -0x1.eba97373198e3p-1,   -0x1.8a882p-4, INEXACT)
T(RN,  0x1.2d370795355c6p+344,    0x1.fd4d819dd27e1p-1,    0x1.c03f5p-2, INEXACT)
T(RN,  0x1.fa0236523ce54p+344,   -0x1.fffffffcab0d6p-1,  -0x1.f77e66p-2, INEXACT)
T(RN,  0x1.7749f81c4f7f2p+344,    -0x1.f13625a5d107p-1,    0x1.f5cb3p-2, INEXACT)
T(RN,  0x1.f0c8ccfac482cp+344,    -0x1.4ac5b7d225bfp-1,   0x1.b43c74p-5, INEXACT)
T(RN,  0x1.c4825391ee598p+345,    -0x1.b120eb7dcb34p-1,   0x1.4eccecp-4, INEXACT)
T(RN,   0x1.7e3316e5aebap+345,   -0x1.4d7f6c2fa7944p-2,  -0x1.f338ecp-3, INEXACT)
T(RN,  0x1.b796ef6890f0ap+345,    0x1.8377ff3523c2bp-1,  -0x1.9a701cp-4, INEXACT)
T(RN,  0x1.2704235b43398p+345,   -0x1.9d1c2e8420493p-2,  -0x1.eb0c66p-7, INEXACT)
T(RN,  0x1.f102744d45945p+345,    0x1.b703852076e1ep-3,   0x1.bf0fa4p-4, INEXACT)
T(RN,  0x1.8e42dc253a816p+345,   -0x1.7808e55b8a77dp-3,  -0x1.fb3b56p-3, INEXACT)
T(RN,  0x1.613c3c2865abfp+345,    0x1.ee4cb390c77d2p-2,   0x1.2ffbb6p-2, INEXACT)
T(RN,  0x1.d196cf55cc3e2p+345,    0x1.5d4a77a51a5fbp-1,   0x1.d225f4p-3, INEXACT)
T(RN,  0x1.5faa2f6fbc2d8p+345,    0x1.e967fffdf372ap-1,   0x1.f2c3eep-2, INEXACT)
T(RN,  0x1.b1910c2731224p+345,  -0x1.f90f44e977bbcp-10,  -0x1.9cf2bcp-5, INEXACT)
T(RN,  0x1.a91aa53b9c3d1p+346,    0x1.7b15491aff8c7p-2,  -0x1.ba8344p-4, INEXACT)
T(RN,  0x1.fb586bc6f5ed8p+346,    0x1.fb89b85a2e285p-1,  -0x1.cf1ee8p-3, INEXACT)
T(RN,  0x1.3df59eef60f24p+346,   -0x1.778750fb1e26fp-1,   -0x1.b8bd3p-2, INEXACT)
T(RN,  0x1.7b04a1f6ae175p+346,    0x1.56230ec0aea93p-1,   0x1.655f96p-2, INEXACT)
T(RN,  0x1.cf6d212c11805p+346,    0x1.eec846524aecbp-1,    0x1.5a64ep-3, INEXACT)
T(RN,  0x1.5b0678c2b416ep+346,    0x1.ffe26d9e28a6fp-1,   0x1.3f9c46p-2, INEXACT)
T(RN,  0x1.0c0d5c2af3c2ep+346,    0x1.fffd1bcda7a7dp-1,  -0x1.5442a8p-2, INEXACT)
T(RN,  0x1.63d0179dacd81p+346,    0x1.f1da2799ffdf8p-1,  0x1.a294bcp-12, INEXACT)
T(RN,  0x1.1238a9b81faeap+346,    -0x1.0da0f77c527fp-4,  -0x1.9671b8p-2, INEXACT)
T(RN,  0x1.7a843b66b8a85p+346,     0x1.ca21c4669d2dp-1,  -0x1.849b04p-5, INEXACT)
T(RN,   0x1.e02d1e2e8c4fp+347,   -0x1.98a21f7496d39p-2,   0x1.7af06ep-3, INEXACT)
T(RN,  0x1.37c1f15044a35p+347,    0x1.02889df7fa4fep-5,   0x1.a75988p-6, INEXACT)
T(RN,  0x1.3e5ecf3e06a1ep+347,    0x1.69177d94e0d55p-3,   0x1.9e5356p-2, INEXACT)
T(RN,  0x1.76164b81bca94p+347,   -0x1.fa908283c9934p-5,  -0x1.21e594p-3, INEXACT)
T(RN,  0x1.05d41a2681799p+347,   -0x1.0aacdaa756ddcp-1,  -0x1.e1d574p-5, INEXACT)
T(RN,  0x1.b8c246c2b9e36p+347,   -0x1.985a6fcf76f1cp-2,  -0x1.828d86p-2, INEXACT)
T(RN,  0x1.eecd691529da6p+347,    0x1.ffbec57c8976fp-1,  -0x1.5697fap-4, INEXACT)
T(RN,  0x1.9f731aaafc2e6p+347,   -0x1.fb93ea447cf08p-1,  -0x1.eb3ddep-2, INEXACT)
T(RN,  0x1.091a69b59bd94p+347,   -0x1.6ffb80acc2abdp-1,   0x1.705ac2p-8, INEXACT)
T(RN,   0x1.bf41b990e064p+347,    0x1.dc9c9ba154d31p-1,   0x1.70f7cep-4, INEXACT)
T(RN,   0x1.9ad2630e4d5bp+348,    0x1.0457ef840b288p-3,  -0x1.f98918p-2, INEXACT)
T(RN,  0x1.284e440daa66dp+348,    0x1.fedd9b893485fp-1,   0x1.ab5caap-6, INEXACT)
T(RN,  0x1.9e6589c86cdcbp+348,    0x1.0bf23215eddbap-2,  -0x1.e461a2p-2, INEXACT)
T(RN,  0x1.e465599aae95ap+348,   -0x1.1655089d59c12p-1,   0x1.4d8bd2p-2, INEXACT)
T(RN,  0x1.4bad91716a9fdp+348,   -0x1.07303d35879c6p-1,   0x1.2e7714p-2, INEXACT)
T(RN,  0x1.4a1c16d458394p+348,   -0x1.fc2c41620154bp-4,  -0x1.4bda68p-5, INEXACT)
T(RN,  0x1.4f8ea50260cbap+348,    0x1.d1a28d567413fp-1,    0x1.ea1bcp-5, INEXACT)
T(RN,  0x1.0317079c1b5a7p+348,   -0x1.0d2d8af6fde4cp-1,   0x1.b581a8p-2, INEXACT)
T(RN,  0x1.e5d0d6c069b52p+348,   -0x1.d8eb15bb7a0d1p-2,    0x1.4e70ep-8, INEXACT)
T(RN,  0x1.87a71343510fap+348,    0x1.4572f632d30abp-1,   0x1.568f3cp-4, INEXACT)
T(RN,  0x1.70917c9ab27b8p+349,    0x1.e163503a5acc3p-1,   0x1.4faeeep-2, INEXACT)
T(RN,  0x1.a3bc6075bd936p+349,    0x1.c408fe9856126p-1,   0x1.c18ae6p-2, INEXACT)
T(RN,  0x1.7bf2be5c813f9p+349,    0x1.1f1eca4c59677p-1,   0x1.fe45f8p-8, INEXACT)
T(RN,  0x1.e2a478bdf1736p+349,    0x1.e9930162c4602p-2,   0x1.75b054p-2, INEXACT)
T(RN,  0x1.28b7828db0b0cp+349,    0x1.c2ae4cf5b3ef2p-3,    0x1.9af5ap-7, INEXACT)
T(RN,  0x1.9d1aff10ac626p+349,    0x1.461af1497d825p-7,  -0x1.d6f5f8p-4, INEXACT)
T(RN,  0x1.1bdcf98f04865p+349,    0x1.db93b23be6fedp-1,   0x1.4726eep-2, INEXACT)
T(RN,  0x1.98bdc5c5fc468p+349,   -0x1.12d35e92be5f4p-1,   0x1.5b18b8p-2, INEXACT)
T(RN,  0x1.8ae9f13f183aap+349,   -0x1.7ab90afb27debp-1,   0x1.204562p-3, INEXACT)
T(RN,  0x1.94f03593e01e7p+349,    0x1.1123bc2260566p-1,   0x1.4f46e4p-6, INEXACT)
T(RN,  0x1.d33cedb112018p+350,   -0x1.197938120d1d6p-1,  -0x1.bb76f2p-2, INEXACT)
T(RN,  0x1.a579e25e565dap+350,   -0x1.2021e359a304fp-1,  -0x1.bd58ccp-4, INEXACT)
T(RN,  0x1.c18ea428e084bp+350,    0x1.06df25dc0b25bp-1,  -0x1.47da26p-2, INEXACT)
T(RN,  0x1.a92f94ac7d73fp+350,    0x1.c4a2acc74144ep-1,  -0x1.b21b86p-3, INEXACT)
T(RN,  0x1.5a0fa730ac50ap+350,    0x1.6fbbea311ce82p-1,   0x1.02c72cp-5, INEXACT)
T(RN,  0x1.bd05eb9ab2478p+350,    0x1.ff4a47fc07dd5p-1,  -0x1.b9b3bap-2, INEXACT)
T(RN,  0x1.f010dfb8696eap+350,   -0x1.4a18344bbcf64p-1,  -0x1.925c02p-6, INEXACT)
T(RN,  0x1.9738f202d2ffbp+350,     0x1.ff9fb25a622ep-1,   -0x1.ee8c8p-5, INEXACT)
T(RN,  0x1.cf1c5b913374ap+350,    0x1.e664b4e7b0b25p-1,   -0x1.24212p-3, INEXACT)
T(RN,  0x1.a33d6fc761288p+350,    0x1.b442ab788dc0bp-1,    0x1.47b34p-3, INEXACT)
T(RN,  0x1.ec94e963db779p+351,   -0x1.3c26773e20045p-2,   0x1.a4fa86p-2, INEXACT)
T(RN,  0x1.cdc45daa80aaap+351,    0x1.32872aeeeb31fp-1,  -0x1.c43e1ep-3, INEXACT)
T(RN,  0x1.678316302ca4bp+351,    0x1.f826f4078d89ep-1,   -0x1.9eab6p-3, INEXACT)
T(RN,   0x1.f93d52a97617p+351,   -0x1.bddf05e0fb56ep-1,   0x1.0c454cp-2, INEXACT)
T(RN,  0x1.f6ceedfd6ec24p+351,    -0x1.fb7102d70d99p-1,   0x1.d28868p-3, INEXACT)
T(RN,    0x1.52422eafdbcp+351,    0x1.ecf763ef7ce5cp-1,  -0x1.195426p-4, INEXACT)
T(RN,  0x1.63ee67ff39974p+351,   -0x1.ca93253ad85f3p-1,  -0x1.b74a34p-2, INEXACT)
T(RN,   0x1.d8b67848a549p+351,    0x1.67b70bfd7c6d9p-2,  -0x1.2da18ep-3, INEXACT)
T(RN,  0x1.23be2f3c25ef7p+351,   -0x1.907c14d41dda1p-5,   0x1.2cd2e6p-2, INEXACT)
T(RN,  0x1.0201516907c67p+351,    0x1.ff80aa086c88ep-1,  -0x1.54c24ap-2, INEXACT)
T(RN,  0x1.aa46c2f1117bep+352,   -0x1.3d95f69c5e813p-4,   0x1.93fa98p-5, INEXACT)
T(RN,  0x1.f60b800842fcap+352,   -0x1.bb82fd58452b8p-2,   0x1.c20704p-2, INEXACT)
T(RN,  0x1.31a8c1b1a10dbp+352,   -0x1.7f7e684530142p-2,  -0x1.37b8fep-4, INEXACT)
T(RN,  0x1.cd42ad1305b9bp+352,     -0x1.985ec1f8afbp-2,  -0x1.499368p-4, INEXACT)
T(RN,  0x1.239fdf649322bp+352,   -0x1.596e91f667d55p-1,  -0x1.7a8f26p-4, INEXACT)
T(RN,  0x1.3b9baab7ccfbfp+352,    0x1.cb93ead760535p-1,  -0x1.f47d44p-2, INEXACT)
T(RN,  0x1.1492f4e9e2d1fp+352,    0x1.88ba317daffdep-1,  -0x1.6d828cp-2, INEXACT)
T(RN,  0x1.f7442ba2b9a3cp+352,    0x1.f877c47950213p-1,   -0x1.e8f0ep-2, INEXACT)
T(RN,  0x1.64b53b7e3fc0fp+352,   -0x1.ef4462cc9b41dp-1,   0x1.eafd9ep-2, INEXACT)
T(RN,   0x1.d85a5d41108cp+352,   -0x1.6e4388fa881c1p-1,   -0x1.e481dp-4, INEXACT)
T(RN,  0x1.83be2226b09bcp+353,    0x1.fb677183bbf39p-2,  -0x1.40bacep-2, INEXACT)
T(RN,  0x1.b31e1a47f23fap+353,    0x1.f9302b0dbc04ep-2,  -0x1.44df54p-3, INEXACT)
T(RN,  0x1.812e86b7ae0e3p+353,    0x1.264b4a66861f4p-2,  -0x1.08ae84p-2, INEXACT)
T(RN,  0x1.899a109b4424dp+353,    0x1.46af119f0f9e9p-1,   0x1.4a6dfep-2, INEXACT)
T(RN,  0x1.6e05625a53dc2p+353,    0x1.0b706848205c6p-1,    -0x1.a9a6p-2, INEXACT)
T(RN,  0x1.6059ae6ec6444p+353,    0x1.34979cc5e1c34p-1,  -0x1.4e64aep-2, INEXACT)
T(RN,  0x1.b544f3097fe32p+353,   -0x1.3d3c7909d42ffp-5,   0x1.bdcecep-2, INEXACT)
T(RN,  0x1.cbbe586249546p+353,    0x1.58a60cd3552fep-1,  -0x1.d40324p-2, INEXACT)
T(RN,   0x1.8868dc60f339p+353,   -0x1.462a13bbd9239p-1,   -0x1.72f5ep-3, INEXACT)
T(RN,  0x1.253da70d7f3dbp+353,    0x1.ffd047e5391e4p-1,   -0x1.5f22bp-2, INEXACT)
T(RN,  0x1.5de1115787669p+354,    0x1.512cb80eeaca8p-3,  -0x1.ed81a4p-2, INEXACT)
T(RN,  0x1.71987ce4fc37ep+354,     0x1.e60b25bb066ep-2,   0x1.6a1e04p-3, INEXACT)
T(RN,  0x1.195bfe5dbf2a2p+354,    0x1.d39ae4ed29562p-1,   0x1.d44decp-2, INEXACT)
T(RN,  0x1.2fa0dbce7f4b7p+354,    0x1.ed3532172a17ep-1,  -0x1.2bd2bcp-2, INEXACT)
T(RN,  0x1.72e798af73134p+354,    0x1.bad1d86d34e6cp-1,  -0x1.55a136p-4, INEXACT)
T(RN,  0x1.0dcb371fa47aep+354,   -0x1.b97680e2198b4p-3,   -0x1.0f8b2p-4, INEXACT)
T(RN,   0x1.c042266104eap+354,    0x1.1104d3be922a3p-1,   0x1.d0d86ap-4, INEXACT)
T(RN,  0x1.609f53a29a237p+354,   -0x1.f40bb73009f82p-3,  -0x1.bc7492p-7, INEXACT)
T(RN,  0x1.926fff6bf5e1bp+354,   -0x1.71e92d74963a6p-1,  -0x1.f4325cp-2, INEXACT)
T(RN,  0x1.9ca7ecf702496p+354,    0x1.3e65486578ed4p-1,  -0x1.4e44ccp-4, INEXACT)
T(RN,  0x1.97e2c8a967292p+355,    0x1.c2fe2483eb68fp-1,  -0x1.ba724ap-2, INEXACT)
T(RN,  0x1.5f55c0340071ep+355,   -0x1.81aab34c28fb1p-1,  -0x1.45862cp-2, INEXACT)
T(RN,  0x1.095282f193c33p+355,   -0x1.f451f38252036p-1,  -0x1.d25f6cp-4, INEXACT)
T(RN,  0x1.22ead89da5644p+355,   -0x1.20be41bb438a8p-1,   -0x1.a2a28p-4, INEXACT)
T(RN,   0x1.ccbbfa6fc92ep+355,    -0x1.cb28f1895f8cp-1,   -0x1.92b5dp-2, INEXACT)
T(RN,   0x1.96dce192c74ep+355,   -0x1.c5be3edb578f9p-1,   0x1.119d16p-2, INEXACT)
T(RN,  0x1.31deebbb526abp+355,   -0x1.a009b9236413fp-4,   0x1.af6a46p-5, INEXACT)
T(RN,  0x1.b1e1c3d0abc4fp+355,    0x1.fd5207c783fcep-1,  -0x1.391752p-3, INEXACT)
T(RN,  0x1.5d504b81714edp+355,   -0x1.93d3de9040108p-1,  -0x1.1426b4p-4, INEXACT)
T(RN,  0x1.4f4c9a7812b18p+355,    0x1.2c30410cc94c6p-6,    0x1.8ce7bp-2, INEXACT)
T(RN,  0x1.129625603c235p+356,   -0x1.1c4298d86d93dp-2,  -0x1.e56994p-2, INEXACT)
T(RN,  0x1.74f313aa5926ep+356,    0x1.fac6f0e6a8842p-1,   0x1.1eeed4p-2, INEXACT)
T(RN,  0x1.5362d1763f8fap+356,   -0x1.2116c802284c5p-1,   0x1.c4ba44p-3, INEXACT)
T(RN,   0x1.6ccbe712f991p+356,    0x1.e04955fe06168p-2,   0x1.a9e43ep-2, INEXACT)
T(RN,  0x1.f7ff9a73b4701p+356,   -0x1.c2e2eb5a32ac7p-4,    0x1.acb64p-3, INEXACT)
T(RN,  0x1.7838923e9e891p+356,    0x1.fdbf6b7535181p-1,   0x1.8bb23cp-2, INEXACT)
T(RN,  0x1.244a408f13a8fp+356,    0x1.0145d8702762dp-1,   0x1.426784p-3, INEXACT)
T(RN,  0x1.ef4fafd40e722p+356,   -0x1.fb87285d2c184p-1,   0x1.6f499ep-2, INEXACT)
T(RN,  0x1.09e381992bbd5p+356,    -0x1.f1a9853f1e86p-1,   0x1.9408fcp-2, INEXACT)
T(RN,  0x1.53c8fdb0c44dep+356,    0x1.f3be9fbe673d9p-1,   0x1.6f738ap-2, INEXACT)
T(RN,  0x1.a1d19085f3de3p+357,   -0x1.f09fe15c3fed2p-1,   0x1.59f622p-4, INEXACT)
T(RN,  0x1.97725f43e0382p+357,   -0x1.9f2283e00f2cfp-5,   -0x1.2b8ffp-2, INEXACT)
T(RN,  0x1.89f89457cac62p+357,    0x1.4064fbe6239acp-2,   0x1.e5d172p-3, INEXACT)
T(RN,  0x1.ac2daee48ce6ep+357,   -0x1.ffc44e0fcfd41p-1,  -0x1.9714e2p-2, INEXACT)
T(RN,  0x1.db13db0fae50cp+357,    0x1.c0f9f5124fd1ap-1,   0x1.c10dd4p-2, INEXACT)
T(RN,  0x1.6b8aa33109cccp+357,    0x1.5febc1ca79806p-1,   0x1.29d4bcp-2, INEXACT)
T(RN,  0x1.90972f14093c9p+357,    0x1.6e6ff9d67ba39p-1,  -0x1.9410e2p-2, INEXACT)
T(RN,  0x1.5602fe0f32784p+357,   -0x1.fa9d8b7090606p-1,  -0x1.30787ep-2, INEXACT)
T(RN,  0x1.d6273387d53dep+357,   -0x1.b681624299c75p-2,  -0x1.144664p-3, INEXACT)
T(RN,  0x1.1074ec0588df5p+357,   -0x1.319eef6ad7bb4p-2,   0x1.f83d9ap-6, INEXACT)
T(RN,  0x1.9b929623bf946p+358,   -0x1.67e4f7debe1a6p-1,  -0x1.94711ep-3, INEXACT)
T(RN,  0x1.74ce4063ecf39p+358,    -0x1.fc1ab94780bep-1,  -0x1.6ec082p-5, INEXACT)
T(RN,   0x1.e147d30f874dp+358,    0x1.fffef169ccf88p-1,  -0x1.ebb978p-2, INEXACT)
T(RN,  0x1.bb438aeccbb75p+358,   -0x1.6698ba219eca6p-1,   0x1.087cbcp-2, INEXACT)
T(RN,  0x1.6aac53ddc142dp+358,    0x1.1728c9b61f2f3p-3,  -0x1.0b21f6p-2, INEXACT)
T(RN,  0x1.8aed3e3206c7cp+358,    0x1.ff761fa71d00dp-1,    0x1.4109fp-3, INEXACT)
T(RN,  0x1.6dac51389eb57p+358,   -0x1.3135aa8079671p-1,   -0x1.c5f86p-2, INEXACT)
T(RN,  0x1.87e3aeaca6a58p+358,    0x1.19c5a8722c6d1p-1,   0x1.5d9c06p-2, INEXACT)
T(RN,  0x1.fc390c083b652p+358,    0x1.b5f95eb860825p-4,    0x1.ca073p-5, INEXACT)
T(RN,  0x1.dbaec849bb2f5p+358,   -0x1.f8ae14cc5c725p-1,  -0x1.360a52p-4, INEXACT)
T(RN,  0x1.289849485b7b3p+359,   -0x1.b7de48eeb3b12p-1,  -0x1.57c106p-2, INEXACT)
T(RN,  0x1.9ad8336901f3dp+359,    0x1.e2a1a133b61c4p-1,  -0x1.dcf4acp-2, INEXACT)
T(RN,  0x1.a60b71ad95c0ep+359,    0x1.3d8c630c624d7p-2,  -0x1.b23b3cp-4, INEXACT)
T(RN,  0x1.1790f2b53180ap+359,    0x1.abdbc139554abp-2,   0x1.d2bc8ep-2, INEXACT)
T(RN,  0x1.71097237751a9p+359,   -0x1.a6eae0e376061p-1,  -0x1.ad2a02p-3, INEXACT)
T(RN,  0x1.68b67fb3b0f42p+359,    0x1.fc219cf8b3eeap-1,   0x1.003a5ap-3, INEXACT)
T(RN,  0x1.d308a15c6b9c6p+359,   -0x1.9012b0fb901d4p-3,   -0x1.60b34p-3, INEXACT)
T(RN,  0x1.3b689f1d1493ep+359,   -0x1.a615a872ff47ep-1,    0x1.8c1d2p-2, INEXACT)
T(RN,  0x1.fcb6e5c6d47dfp+359,   -0x1.f44cd0e276f3ep-1,   0x1.5ff77ep-2, INEXACT)
T(RN,  0x1.2383c64223c24p+359,    0x1.cc36461a04e29p-1,    0x1.d406bp-2, INEXACT)
T(RN,  0x1.0696ecc87dab6p+360,   -0x1.284f857326eccp-1,    0x1.f92d3p-3, INEXACT)
T(RN,  0x1.b186416864f62p+360,    0x1.f0716ed1e8933p-1,  -0x1.f4df0cp-3, INEXACT)
T(RN,  0x1.e47441214b31ap+360,    0x1.5c013e56812d2p-1,  -0x1.64e76ap-2, INEXACT)
T(RN,  0x1.1e5cb26a6df7cp+360,   -0x1.f0d9ff002f5e7p-6,   0x1.f26a38p-3, INEXACT)
T(RN,  0x1.af309ce4658dbp+360,   -0x1.42e1dec210459p-5,   0x1.fecb9ap-3, INEXACT)
T(RN,  0x1.991a658bbe34ap+360,    0x1.fce6d5014475dp-2,   -0x1.2c7b2p-6, INEXACT)
T(RN,  0x1.4cf4dfdd81853p+360,   -0x1.fdbc0549bfab3p-1,  -0x1.08e542p-5, INEXACT)
T(RN,  0x1.3e38eb758ee9dp+360,   -0x1.a9de9cf1fc95bp-1,   0x1.c15324p-3, INEXACT)
T(RN,  0x1.be188358cd29ep+360,   -0x1.131aeecef95a2p-1,   0x1.0d553cp-2, INEXACT)
T(RN,  0x1.5ed6621471267p+360,    0x1.6b950158fb8d6p-5,  -0x1.ebc728p-2, INEXACT)
T(RN,  0x1.5de38b35b88f3p+361,    0x1.54a2d3f6fcc17p-1,   0x1.31a82ep-2, INEXACT)
T(RN,   0x1.1432a1ebaeeep+361,   -0x1.50703f11ab5ccp-4,   0x1.374dd2p-2, INEXACT)
T(RN,  0x1.424dfe428d54cp+361,    -0x1.3eb5e00bb67cp-1,   0x1.c8472cp-4, INEXACT)
T(RN,  0x1.cd5f2c2afc053p+361,   -0x1.319fb3c3ac39ap-1,   0x1.f9bcf6p-3, INEXACT)
T(RN,  0x1.72ca77c0965dcp+361,    0x1.8afe23cc44f28p-1,   0x1.88defep-2, INEXACT)
T(RN,  0x1.9514407916be4p+361,    0x1.f847b809d8a08p-2,  -0x1.583aa8p-3, INEXACT)
T(RN,  0x1.11f4861361ad4p+361,    0x1.ff1b28e9f512ap-1,   0x1.b204aap-4, INEXACT)
T(RN,  0x1.004542822848cp+361,    0x1.28dd6c73135acp-1,   0x1.736cf8p-3, INEXACT)
T(RN,  0x1.c3d0535106172p+361,   -0x1.27ce04f232ca9p-3,   -0x1.c7332p-2, INEXACT)
T(RN,  0x1.d5ffea090eea2p+361,    0x1.fb4d8511c69bbp-1,   0x1.df453ep-2, INEXACT)
T(RN,  0x1.fcaf45607b7ecp+362,    0x1.fff72a1de3e04p-1,  -0x1.e8a9e6p-3, INEXACT)
T(RN,  0x1.2eb9b1b2a8898p+362,   -0x1.fdbada2c2127cp-1,  -0x1.038376p-2, INEXACT)
T(RN,  0x1.27d38da9d2fe8p+362,    0x1.aac61806430f8p-4,  -0x1.d85992p-2, INEXACT)
T(RN,  0x1.24ad1c64d08a1p+362,    0x1.65ffc57f55a17p-1,   0x1.b670a6p-3, INEXACT)
T(RN,  0x1.4ac250c97d6cbp+362,   -0x1.715928ab5bbbfp-2,  -0x1.6f8d3ap-2, INEXACT)
T(RN,  0x1.f28d4f86b88c8p+362,   -0x1.818d8b5f81354p-5,  -0x1.dc5b3cp-4, INEXACT)
T(RN,  0x1.d5ef934c8e5f1p+362,    0x1.e786ccb17d786p-1,    0x1.6cbc8p-2, INEXACT)
T(RN,  0x1.cbd3e96014343p+362,    0x1.ab92c3cd7e3d6p-2,  -0x1.d6abb2p-2, INEXACT)
T(RN,  0x1.108e420afdb16p+362,    -0x1.836af6722d12p-1,   -0x1.743d8p-2, INEXACT)
T(RN,  0x1.1b3fb08d7493ep+362,    0x1.fdfa178f820e4p-1,   0x1.769b84p-3, INEXACT)
T(RN,  0x1.40d898401d302p+363,    0x1.dcdc9aeb0ce11p-1,  -0x1.b1703ap-3, INEXACT)
T(RN,  0x1.06b8433615408p+363,    0x1.6ee460ca05541p-1,  -0x1.e8b174p-2, INEXACT)
T(RN,  0x1.3e9c85c6f0847p+363,    0x1.aa5ab99645ae1p-1,  -0x1.8c0754p-2, INEXACT)
T(RN,  0x1.4a64cbc9c9e38p+363,   -0x1.fc4bfad24e4d6p-1,   0x1.525c0cp-4, INEXACT)
T(RN,  0x1.f5b921c352912p+363,    0x1.300bab18adc37p-2,   0x1.508f22p-2, INEXACT)
T(RN,  0x1.1111f319fd392p+363,   -0x1.cacf9ae53d3b8p-3,  -0x1.b7eec2p-2, INEXACT)
T(RN,  0x1.e28f8dfadbb05p+363,   -0x1.4a33a3a11c3a4p-1,   0x1.28cbbap-2, INEXACT)
T(RN,  0x1.cb33752c1aa4cp+363,    0x1.77bba6316275dp-1,  -0x1.bf21c2p-2, INEXACT)
T(RN,  0x1.e889a49ebf681p+363,    0x1.5bb56a7c7d891p-1,  -0x1.6f8f04p-4, INEXACT)
T(RN,  0x1.4254cc42214dcp+363,    -0x1.ff0d26e4ca7ep-1,   0x1.aa7bacp-3, INEXACT)
T(RN,  0x1.8c33e7a95a43bp+364,    0x1.95c948412b186p-1,  -0x1.9befbcp-2, INEXACT)
T(RN,   0x1.377b64909937p+364,    0x1.fc603926f4a49p-1,   -0x1.c1701p-3, INEXACT)
T(RN,  0x1.25d234e71dc4cp+364,   -0x1.321d565c141c6p-2,   0x1.bb251ep-3, INEXACT)
T(RN,  0x1.78788e5005572p+364,   -0x1.f12d32aca6b5fp-1,  -0x1.243d62p-4, INEXACT)
T(RN,  0x1.8dbbc4986b496p+364,   -0x1.cca35235c557bp-1,  -0x1.c0b74ep-2, INEXACT)
T(RN,  0x1.ba981bba23dd4p+364,    0x1.f75a13464c229p-1,   0x1.22739ap-3, INEXACT)
T(RN,  0x1.71acdada3f524p+364,    0x1.7e239fa92dd42p-4,   0x1.4b96c8p-2, INEXACT)
T(RN,  0x1.52b8b464c23ecp+364,   -0x1.d641d028b3d32p-3,   0x1.d81feap-2, INEXACT)
T(RN,  0x1.ca836d7f0f939p+364,    0x1.d4f726c1994a2p-1,  -0x1.a2be58p-2, INEXACT)
T(RN,  0x1.c1c865fa38059p+364,   -0x1.5693e8279496cp-1,  -0x1.fc18fap-3, INEXACT)
T(RN,  0x1.79bb9a6ff1252p+365,    0x1.f77446a0c6dbep-3,  -0x1.bddd1ap-3, INEXACT)
T(RN,  0x1.6a30c7ff4764ap+365,   -0x1.ed287683a0b14p-1,  -0x1.96301ap-4, INEXACT)
T(RN,  0x1.da6a2ff531156p+365,    0x1.e319756b4c2ddp-2,  -0x1.c58acep-4, INEXACT)
T(RN,  0x1.e67c38c3a5a3ep+365,   -0x1.a6f8edf44ee6ep-5,  -0x1.a695b8p-5, INEXACT)
T(RN,  0x1.7d44e7f0ac015p+365,   -0x1.8ffe9be65a0e4p-6,   0x1.e901a8p-4, INEXACT)
T(RN,  0x1.9f9d215aff8f8p+365,   -0x1.ffbe34b8d8405p-1,  -0x1.577a7cp-4, INEXACT)
T(RN,  0x1.d0a7c16091ff9p+365,    0x1.6b119900499a4p-1,   0x1.89d602p-3, INEXACT)
T(RN,  0x1.0e7fda24f2913p+365,   -0x1.c16e4803189b6p-1,   -0x1.9edcfp-6, INEXACT)
T(RN,  0x1.158c99d02f086p+365,    0x1.32b3af36f599bp-3,  -0x1.489bd4p-2, INEXACT)
T(RN,  0x1.ffcbdd8c17e65p+365,   -0x1.f571264d487d7p-1,   0x1.deef24p-5, INEXACT)
T(RN,  0x1.81f6bb0739d4ap+366,   -0x1.9a27002d97157p-1,  -0x1.335a92p-4, INEXACT)
T(RN,   0x1.e3b90f87a0e4p+366,    0x1.3eef9728914b8p-1,  -0x1.192966p-3, INEXACT)
T(RN,  0x1.1a8c562fbb701p+366,   -0x1.ee61ee56c48adp-1,   -0x1.d74abp-3, INEXACT)
T(RN,  0x1.3fe2518dfdbdap+366,   -0x1.bd421fd2bfcbbp-1,  -0x1.a3a33ep-3, INEXACT)
T(RN,   0x1.db4e44b3a909p+366,    0x1.ef3e497dcbc5cp-1,   0x1.92f9a8p-2, INEXACT)
T(RN,   0x1.67209ece079dp+366,    0x1.81735cefe6331p-1,    0x1.1bd78p-2, INEXACT)
T(RN,  0x1.b798cd439a3dcp+366,   -0x1.a345ec0c9c1c9p-1,   0x1.4c8d7ap-2, INEXACT)
T(RN,  0x1.a1907a9aea76ep+366,   -0x1.acdc1ccdf3506p-3,   0x1.f22aa8p-5, INEXACT)
T(RN,  0x1.e5ad815f3c845p+366,    0x1.b2ae59746509fp-1,    0x1.42575p-2, INEXACT)
T(RN,  0x1.7787a501a5a28p+366,   -0x1.1b59a923d365bp-3,  -0x1.10f6a2p-5, INEXACT)
T(RN,  0x1.c29e7b09e794ep+367,   -0x1.214d86bd07737p-1,   -0x1.fae3p-10, INEXACT)
T(RN,  0x1.6325ea2ee7504p+367,    0x1.c7b3cc5ff062bp-1,  -0x1.59a4a6p-2, INEXACT)
T(RN,  0x1.6bbdd3f420e55p+367,   -0x1.36b164e7b9951p-3,  -0x1.4f29c6p-4, INEXACT)
T(RN,  0x1.b1ef80fe5f0e7p+367,   -0x1.f33cf0fb86822p-1,  -0x1.1ce6f2p-3, INEXACT)
T(RN,  0x1.e370fea2fca35p+367,    0x1.bfd3cd3657cc1p-1,  -0x1.58235cp-2, INEXACT)
T(RN,  0x1.9e69e9f3487dap+367,   -0x1.3bfe0e1b5ea37p-1,  -0x1.906da6p-2, INEXACT)
T(RN,  0x1.03c16c8671c4fp+367,    0x1.400d4f7a5f6fep-1,   0x1.10e352p-2, INEXACT)
T(RN,  0x1.9a863de978deap+367,    0x1.fff3d57cb1103p-1,   0x1.3426eap-2, INEXACT)
T(RN,  0x1.a0531b194499ep+367,    0x1.26d997cc112a9p-1,   0x1.29eb1cp-3, INEXACT)
T(RN,  0x1.7dd6be2cced84p+367,   -0x1.7db5b809eaaa9p-1,   0x1.b24884p-2, INEXACT)
T(RN,  0x1.07cfda3011527p+368,    0x1.59aa0db6a51b6p-2,   0x1.84555cp-2, INEXACT)
T(RN,  0x1.f572bc5fed184p+368,   -0x1.f41afbec9e314p-1,   0x1.da0152p-4, INEXACT)
T(RN,  0x1.029d73b7856ebp+368,   -0x1.aff2767efa791p-1,    -0x1.4f9dp-3, INEXACT)
T(RN,  0x1.b6983a012580cp+368,    0x1.b953143d64835p-1,    0x1.e2d81p-2, INEXACT)
T(RN,   0x1.d1e76f165368p+368,   -0x1.c253fbc2e8653p-1,  -0x1.758f06p-2, INEXACT)
T(RN,  0x1.0dbe16ed0e2c3p+368,    0x1.f4f5397d5d9cep-1,  -0x1.c0be78p-4, INEXACT)
T(RN,  0x1.62639d6b0bad9p+368,   -0x1.c00215e8d17b1p-3,    0x1.d3b78p-3, INEXACT)
T(RN,  0x1.954e937a0fb11p+368,    0x1.f7548ba414937p-4,   0x1.37b90ep-3, INEXACT)
T(RN,  0x1.07bc59e714a7dp+368,   -0x1.fe959e314bb7fp-1,    0x1.c29d4p-4, INEXACT)
T(RN,  0x1.f4ef5f9d3ad48p+368,    0x1.31af266313411p-3,   0x1.2043bcp-2, INEXACT)
T(RN,  0x1.50e0b9157d0f9p+369,     0x1.6658cab3294fp-1,   0x1.9bef0cp-2, INEXACT)
T(RN,  0x1.ba80a9c172c76p+369,   -0x1.e5eb532cda3ebp-1,   0x1.4ccb2ap-4, INEXACT)
T(RN,  0x1.6e2dfd104efcap+369,    0x1.f1aa10f1e5ed1p-1,   0x1.bf2e9ep-8, INEXACT)
T(RN,  0x1.ca8f19e5f571ep+369,   -0x1.f16e39950564fp-1,  -0x1.9c5424p-6, INEXACT)
T(RN,  0x1.c04dad439020ep+369,   -0x1.e0a9886538aebp-1,  -0x1.61fdf6p-2, INEXACT)
T(RN,   0x1.5585869049f6p+369,   -0x1.f75b3f84d80f3p-1,  -0x1.2321aep-2, INEXACT)
T(RN,  0x1.a78fb38b25915p+369,   -0x1.fdc19e898042bp-1,   0x1.52fe26p-2, INEXACT)
T(RN,  0x1.ade8d50ba259fp+369,   -0x1.c0d7a9ed036e6p-2,   0x1.5341a4p-2, INEXACT)
T(RN,  0x1.85d9c34638f81p+369,   -0x1.fdf169f476e1ep-1,    0x1.d1addp-2, INEXACT)
T(RN,  0x1.1d2608b76bc35p+369,   -0x1.fffb2d4933196p-1,  -0x1.b1766ep-4, INEXACT)
T(RN,  0x1.ffef25a5da395p+370,   -0x1.84daa658341b4p-3,   -0x1.49686p-3, INEXACT)
T(RN,  0x1.8eae5d8fdb1a4p+370,    0x1.f6429eaf39382p-1,  -0x1.e1ce1ep-5, INEXACT)
T(RN,  0x1.f468e9a954bebp+370,    0x1.fd84154bec74ep-1,   0x1.af5d56p-2, INEXACT)
T(RN,  0x1.d3add69900ea6p+370,   -0x1.6591adf8dfb87p-1,  -0x1.a06792p-2, INEXACT)
T(RN,   0x1.9b8a58b24a4ep+370,    0x1.8fdd29c0195dcp-1,   0x1.35533cp-2, INEXACT)
T(RN,  0x1.57bde766f2dcep+370,   -0x1.fb9b6379ae236p-1,   0x1.a9a4a4p-6, INEXACT)
T(RN,  0x1.7154cbe536aa4p+370,   -0x1.f51b2a2117be5p-1,   0x1.fe8994p-2, INEXACT)
T(RN,  0x1.bc787793542c1p+370,    0x1.a262740a822f9p-1,   -0x1.cabb4p-3, INEXACT)
T(RN,  0x1.a7c01275e78eep+370,    0x1.b2a785dc575eap-1,  -0x1.dc65c4p-2, INEXACT)
T(RN,  0x1.1622553a92bd6p+370,   -0x1.8c555bc80ad5dp-1,   0x1.859a26p-3, INEXACT)
T(RN,  0x1.67c5109f2fa2cp+371,   -0x1.dc9516ba88504p-3,   0x1.c90ab8p-3, INEXACT)
T(RN,   0x1.e59cc5053132p+371,    -0x1.ea82481ff715p-1,  -0x1.30314ep-5, INEXACT)
T(RN,  0x1.2c9cfeff20ad3p+371,    0x1.efe39c3d0050dp-2,  -0x1.38e21cp-2, INEXACT)
T(RN,  0x1.77a293cf2b838p+371,    0x1.a9a6bd1f2e9fbp-1,  -0x1.4fddc6p-5, INEXACT)
T(RN,  0x1.ab210c4b896d5p+371,    0x1.2af1d654b9557p-3,   0x1.2078b4p-2, INEXACT)
T(RN,  0x1.f386240a291aap+371,   -0x1.fdc553280f9a3p-1,   0x1.228ee6p-6, INEXACT)
T(RN,   0x1.a9063af2e391p+371,    0x1.e9efd66b7d127p-1,  -0x1.c17a96p-2, INEXACT)
T(RN,  0x1.bed27a7443793p+371,    0x1.d7cb34bcd3e2cp-2,   0x1.95a0b2p-2, INEXACT)
T(RN,  0x1.11ff8ac7a2ecep+371,    0x1.e69ac50be97c8p-1,   -0x1.b5d92p-2, INEXACT)
T(RN,  0x1.d3bd8ddc8076bp+371,   -0x1.df61e217030a8p-1,  -0x1.ba10a8p-3, INEXACT)
T(RN,  0x1.a37ff3825e32dp+372,    0x1.a71f4224c8726p-1,   0x1.76c1c6p-2, INEXACT)
T(RN,  0x1.fc2a36ccd1551p+372,   -0x1.654da864a3d1ep-4,  -0x1.144172p-3, INEXACT)
T(RN,  0x1.0dbbe8cd8a56dp+372,    -0x1.f7029b6974a6p-1,  -0x1.a778c2p-2, INEXACT)
T(RN,  0x1.d3364bc98ed2ap+372,    0x1.0cf2a3163ff2dp-1,   -0x1.ab43ap-3, INEXACT)
T(RN,  0x1.f1f406d638b5fp+372,   -0x1.a48e66e32a2f8p-1,   0x1.8dc3d8p-8, INEXACT)
T(RN,  0x1.84c66a5897b68p+372,   -0x1.6d7af03b486c7p-1,  -0x1.8f4594p-3, INEXACT)
T(RN,  0x1.7cd56f3c95e37p+372,   -0x1.818d79b517099p-1,   0x1.1fc10ep-3, INEXACT)
T(RN,  0x1.0805417e4daefp+372,   -0x1.f41568adcd0b5p-1,  -0x1.e54bc8p-2, INEXACT)
T(RN,   0x1.a821321f20ddp+372,   -0x1.fe6efe09fdf3dp-2,   0x1.efa12ap-6, INEXACT)
T(RN,  0x1.ff95728b40266p+372,    0x1.6b13a403dc8aep-1,   0x1.207a58p-3, INEXACT)
T(RN,  0x1.8cae8250692f7p+373,   -0x1.1d851810b2b24p-1,  -0x1.aaf388p-4, INEXACT)
T(RN,  0x1.aa16cae5cc25fp+373,    0x1.5dce9420187f4p-6,    0x1.367d6p-2, INEXACT)
T(RN,  0x1.a83f14e37ca9bp+373,    0x1.59aaa8621bd8ap-1,   -0x1.7c886p-5, INEXACT)
T(RN,  0x1.aa0210bc948edp+373,   -0x1.777f03dae03c2p-2,  -0x1.84dca8p-2, INEXACT)
T(RN,  0x1.573d07e44bc59p+373,    0x1.1d6bcb6bb49c4p-1,  -0x1.745c72p-2, INEXACT)
T(RN,  0x1.6310437a1050ep+373,    0x1.7120a34efe27ap-2,  -0x1.c45ffap-2, INEXACT)
T(RN,  0x1.de06c9cd2ffc4p+373,    0x1.dc092b00c0fbep-1,   0x1.d2b26ep-2, INEXACT)
T(RN,  0x1.0f24e6eb4e4a4p+373,    -0x1.ffb45bf74f99p-1,   0x1.19f706p-2, INEXACT)
T(RN,  0x1.6b4de9a706926p+373,   -0x1.1e5f5c2282bd3p-1,  -0x1.b3ff7ap-2, INEXACT)
T(RN,  0x1.fd2a71a527094p+373,   -0x1.fb788234cb321p-4,   0x1.458c3ap-2, INEXACT)
T(RN,  0x1.c6ad1a9d56916p+374,    0x1.53377fb78aad5p-1,  -0x1.ac127ep-5, INEXACT)
T(RN,  0x1.cadf55d6dd90ep+374,   -0x1.6e20ba6d55a1ap-1,   0x1.373ec4p-3, INEXACT)
T(RN,   0x1.54c8c0ee5943p+374,    0x1.cea78c2ac8a21p-2,  -0x1.d76d36p-2, INEXACT)
T(RN,  0x1.3c21ac0ad0e65p+374,   -0x1.622c6266a8e55p-1,  -0x1.8a94e4p-3, INEXACT)
T(RN,  0x1.73d1ae6c7d5b5p+374,    0x1.55ac1fdf519edp-1,   0x1.82970cp-4, INEXACT)
T(RN,  0x1.18a620fc3b97cp+374,    0x1.8a804c8632c66p-2,  -0x1.5ee77ap-2, INEXACT)
T(RN,  0x1.89b7eca3eb901p+374,   -0x1.4df43746f4f66p-1,   0x1.649cd6p-2, INEXACT)
T(RN,  0x1.16b7f34c40082p+374,    0x1.a5fdac2a63abbp-2,  -0x1.98c4b4p-2, INEXACT)
T(RN,  0x1.c82c5de8fdbd8p+374,    0x1.f6b822f56b2a6p-1,   0x1.eb9496p-4, INEXACT)
T(RN,  0x1.19521aeccd436p+374,   -0x1.0132f2b5f19b8p-1,  -0x1.0d1d36p-2, INEXACT)
T(RN,  0x1.a64c1fe92ba04p+375,   -0x1.a0a764ec8fa6ep-2,   0x1.150166p-3, INEXACT)
T(RN,   0x1.aeb36636a519p+375,    0x1.e2540e752691bp-2,   0x1.663a5cp-2, INEXACT)
T(RN,  0x1.7b22492ba6cc4p+375,    0x1.e336571bf0702p-1,   0x1.5055dap-4, INEXACT)
T(RN,  0x1.6a937caabc20ep+375,   -0x1.24a015e161b4bp-1,  -0x1.976d2cp-3, INEXACT)
T(RN,  0x1.2bd1880432e75p+375,    -0x1.f8df7ee4d205p-1,   0x1.db25c4p-3, INEXACT)
T(RN,  0x1.476a589ab5408p+375,    -0x1.27fb990d35b5p-3,   0x1.d36d94p-4, INEXACT)
T(RN,  0x1.648b6708084c9p+375,    0x1.ffdf0102be3fdp-1,  -0x1.4bbfecp-3, INEXACT)
T(RN,  0x1.1dae76113c497p+375,    0x1.297d230aad8dfp-1,   0x1.11184ap-3, INEXACT)
T(RN,  0x1.fe3b4c24ca5d6p+375,   -0x1.14cac3916c78ep-3,   0x1.5a3328p-3, INEXACT)
T(RN,  0x1.c3381244f556ep+375,    0x1.4e3bda790b51cp-1,  -0x1.491afep-6, INEXACT)
T(RN,  0x1.c8737d8e37658p+376,   -0x1.6fec11f84bb4ep-3,   0x1.d57bc6p-2, INEXACT)
T(RN,  0x1.578ad220a70f8p+376,   -0x1.fb70ef27e3908p-1,  -0x1.f7ba7ap-3, INEXACT)
T(RN,   0x1.570918019725p+376,   -0x1.e18b7947fc4a2p-1,  -0x1.42fb8ap-3, INEXACT)
T(RN,  0x1.10b43cf071d4fp+376,    0x1.5f9bef90722b5p-1,   0x1.ec3048p-4, INEXACT)
T(RN,   0x1.d91fae1d0cf3p+376,    0x1.e7c9fa2f83d41p-1,    0x1.05924p-4, INEXACT)
T(RN,  0x1.203a694951463p+376,   -0x1.b7488ded7b84ep-1,   0x1.cb9b68p-2, INEXACT)
T(RN,  0x1.37a6a7aabb01ep+376,    0x1.ac91602995779p-2,  -0x1.b541d4p-2, INEXACT)
T(RN,  0x1.3e90221e14c73p+376,   -0x1.f12837c82fbf9p-1,  -0x1.d2f08cp-2, INEXACT)
T(RN,  0x1.1ce0390b74daep+376,    -0x1.4c5664d3919dp-2,   0x1.62d32ep-2, INEXACT)
T(RN,  0x1.17eb1e987f137p+376,   -0x1.ea35a9e00123bp-1,  -0x1.fbd46ep-2, INEXACT)
T(RN,  0x1.92030df77aa65p+377,   -0x1.ff70032d472ebp-1,  -0x1.90b39cp-2, INEXACT)
T(RN,  0x1.ab0d6debdeadep+377,   -0x1.ff77a326bcdf8p-1,  -0x1.a84f74p-5, INEXACT)
T(RN,  0x1.eb4b6448a0e28p+377,    0x1.9b478296a12e4p-2,   0x1.785d3cp-3, INEXACT)
T(RN,  0x1.485364b966a41p+377,   -0x1.ecd9def73652bp-1,    0x1.0fac6p-2, INEXACT)
T(RN,  0x1.2b47d606a0577p+377,   -0x1.10a2e75557b25p-2,   -0x1.f70d1p-3, INEXACT)
T(RN,  0x1.f5d19c6a67127p+377,    0x1.326907f0e082ap-1,   0x1.5d56b6p-5, INEXACT)
T(RN,  0x1.5871c1e50d0a5p+377,   -0x1.a58d7a95074e3p-1,  -0x1.ebc1e4p-5, INEXACT)
T(RN,  0x1.9326e05a16824p+377,    0x1.747d97886520ep-1,   0x1.fd5c34p-3, INEXACT)
T(RN,  0x1.8520e0bca08f7p+377,   -0x1.a39488812b881p-2,   0x1.8a2eecp-4, INEXACT)
T(RN,  0x1.b0ea54838f6fep+377,    0x1.35f89916994c9p-3,   0x1.b08722p-2, INEXACT)
T(RN,  0x1.e5d575ae84763p+378,    0x1.268da95052bc5p-1,   0x1.c007dep-2, INEXACT)
T(RN,   0x1.b7106ffb1544p+378,   -0x1.e2971aa790cd6p-2,   0x1.6717bcp-3, INEXACT)
T(RN,  0x1.a7633392ea734p+378,    0x1.8bc8e1f225cbcp-4,  -0x1.452962p-4, INEXACT)
T(RN,  0x1.43e7ce84053b8p+378,    0x1.f0f6f43343609p-1,   0x1.3e825cp-2, INEXACT)
T(RN,  0x1.eb31af3357af2p+378,   -0x1.e456a1e2f0618p-1,  -0x1.cae22ap-3, INEXACT)
T(RN,  0x1.b045420f737d9p+378,   -0x1.43a4fbefd8e9bp-1,  -0x1.401b4ep-2, INEXACT)
T(RN,  0x1.8e9f53b0c038ep+378,    0x1.989ee2914bcdbp-1,   0x1.9238dep-2, INEXACT)
T(RN,   0x1.18f6237fa8acp+378,   -0x1.9d1f578b7571ap-1,   -0x1.e3729p-6, INEXACT)
T(RN,  0x1.0f78bda5bac6dp+378,    0x1.41c06d4c4f0f4p-2,   0x1.e430a4p-3, INEXACT)
T(RN,  0x1.ec702162f0adap+378,    -0x1.509dd76ad7ccp-3,   0x1.5a36d2p-2, INEXACT)
T(RN,  0x1.5e989a104b985p+379,    0x1.b3bbac08f1395p-3,   0x1.948898p-3, INEXACT)
T(RN,  0x1.851959632e3a4p+379,    0x1.fd6e4ad9b6135p-1,     0x1.821fp-2, INEXACT)
T(RN,  0x1.c28cddefb8634p+379,    0x1.f7fdc9496b8b5p-1,   0x1.c03b02p-5, INEXACT)
T(RN,  0x1.de8ca31ff524bp+379,    0x1.d376d6175c1eep-1,   0x1.83019ap-6, INEXACT)
T(RN,  0x1.64217855bcd5ep+379,   -0x1.b7d53e81ef82bp-3,   0x1.e427e4p-8, INEXACT)
T(RN,  0x1.f1be11d433c76p+379,   -0x1.f93cab4d9f581p-1,   0x1.b28814p-2, INEXACT)
T(RN,  0x1.adc0de6474b96p+379,    0x1.da57c460ae577p-1,  -0x1.e87648p-2, INEXACT)
T(RN,  0x1.45b71fa49a5e9p+379,    0x1.8a1ff2960c7fcp-1,   0x1.4afc84p-3, INEXACT)
T(RN,  0x1.c2411e966ca98p+379,    0x1.0e40f22d2df32p-1,   0x1.393a68p-4, INEXACT)
T(RN,  0x1.70b7ca448514ep+379,   -0x1.1684f8493be4fp-2,   0x1.af9368p-2, INEXACT)
T(RN,  0x1.76e172b42a768p+380,   -0x1.536fd3918e99ep-1,   0x1.2103b2p-2, INEXACT)
T(RN,  0x1.219661115c756p+380,   -0x1.bf4c38076ef56p-2,   -0x1.c8106p-3, INEXACT)
T(RN,  0x1.7876754d94627p+380,    0x1.8a0eba1cd16eap-1,   0x1.70d9c8p-4, INEXACT)
T(RN,  0x1.0403d5529d499p+380,   -0x1.26ee25406a698p-1,   0x1.8454f4p-2, INEXACT)
T(RN,  0x1.a3335654cdca9p+380,   -0x1.3c4eb7e745f0ap-1,   0x1.7ca748p-2, INEXACT)
T(RN,  0x1.5571c30840861p+380,   -0x1.bc2034ead8958p-1,   0x1.b511aep-5, INEXACT)
T(RN,  0x1.95cd766906818p+380,   -0x1.ecfcdf6bb434dp-1,  -0x1.21a4a8p-2, INEXACT)
T(RN,  0x1.9388639ef1235p+380,    0x1.a913d2aa0ba43p-1,   0x1.9a8f04p-3, INEXACT)
T(RN,  0x1.882ab722e4ac2p+380,    0x1.0b15d2e204b65p-1,   0x1.09cde8p-4, INEXACT)
T(RN,  0x1.348af04b41f2ep+380,   -0x1.fe69163dd4e96p-1,  -0x1.abdb14p-2, INEXACT)
T(RN,  0x1.24f992ee12eccp+381,   -0x1.1b948618b6895p-2,   0x1.06ff8ap-3, INEXACT)
T(RN,  0x1.e791d78fc00b4p+381,   -0x1.b4f08ab3d3308p-2,   0x1.27705ap-2, INEXACT)
T(RN,  0x1.b2ce924f24ee6p+381,   -0x1.f12908b75b228p-3,    0x1.5f301p-3, INEXACT)
T(RN,  0x1.1ae6134de50c2p+381,   -0x1.3e899b7a9de38p-1,  -0x1.ea8772p-3, INEXACT)
T(RN,  0x1.44739c91e6732p+381,   -0x1.706c647a8af4bp-1,  0x1.07b926p-13, INEXACT)
T(RN,  0x1.c74addff881e6p+381,    0x1.06434166082aep-1,  -0x1.23d304p-6, INEXACT)
T(RN,  0x1.42321c07b554dp+381,    0x1.e6c38d05295bap-2,   0x1.f531bep-2, INEXACT)
T(RN,  0x1.a66f0cbeeeef8p+381,    0x1.723275f097b71p-5,   0x1.31e834p-4, INEXACT)
T(RN,  0x1.a4033ba3f8258p+381,     0x1.f4aa84da6112p-1,   -0x1.6edc4p-3, INEXACT)
T(RN,  0x1.a89c952b652f6p+381,    -0x1.ad1f2134b71cp-3,   0x1.e3cdccp-3, INEXACT)
T(RN,  0x1.a5a0800ea6377p+382,    0x1.e597a58076582p-1,   0x1.0156e6p-2, INEXACT)
T(RN,  0x1.a93990705e2d5p+382,    0x1.4b877a08a6b3dp-5,  -0x1.2a05ecp-4, INEXACT)
T(RN,  0x1.e9961539f4533p+382,    0x1.9aceeb9816d1cp-1,  -0x1.cb5a4ap-6, INEXACT)
T(RN,  0x1.1d107543bc85ap+382,   -0x1.fd6a3bc94679ep-1,  -0x1.c2a0e2p-2, INEXACT)
T(RN,  0x1.773370b154302p+382,   -0x1.4dd71b2165014p-4,   0x1.065e28p-2, INEXACT)
T(RN,  0x1.297c27633912bp+382,    0x1.e35d3b54a9b2bp-1,  -0x1.eac088p-2, INEXACT)
T(RN,  0x1.0d796a884ffa8p+382,    0x1.50ae6122493eep-2,  -0x1.a9b8dap-3, INEXACT)
T(RN,  0x1.c50774a0c8f42p+382,    0x1.5b2b5c6290906p-1,   0x1.112adcp-2, INEXACT)
T(RN,  0x1.a3ee357416638p+382,   -0x1.6d6a42f06cf54p-1,   0x1.937cfep-2, INEXACT)
T(RN,  0x1.441b3e9e54f64p+382,   -0x1.2422709375199p-5,  -0x1.f60056p-4, INEXACT)
T(RN,  0x1.1cd3b2fe1b5f1p+383,   -0x1.b06fbd3c5439ap-1,   0x1.99e684p-2, INEXACT)
T(RN,  0x1.e1895dc571082p+383,   -0x1.b99c2a558f47ap-3,  -0x1.c55eaep-6, INEXACT)
T(RN,  0x1.8afc1c1f0f344p+383,    0x1.446a077658a48p-4,   0x1.7f614cp-2, INEXACT)
T(RN,  0x1.3de53061ebe0dp+383,    0x1.ffdba1ccd5777p-1,  -0x1.ca3ceep-2, INEXACT)
T(RN,  0x1.440dae90a6e26p+383,   -0x1.e03375383667bp-3,   0x1.6a5c72p-2, INEXACT)
T(RN,  0x1.a23a567944068p+383,   -0x1.bda085f809caap-1,  -0x1.2543dcp-2, INEXACT)
T(RN,  0x1.773d7682c4026p+383,    0x1.8de7b0cf53d0fp-1,  -0x1.3167f6p-5, INEXACT)
T(RN,  0x1.bb96959a2bdb8p+383,   -0x1.d839f84e344d5p-3,  -0x1.b7fe3ep-4, INEXACT)
T(RN,  0x1.b77a1ef42c64fp+383,   -0x1.51b6935841cfdp-2,  -0x1.1ae9e6p-2, INEXACT)
T(RN,  0x1.c2f0c51bbadc2p+383,    0x1.a77c46140159bp-1,    0x1.332f3p-4, INEXACT)
T(RN,  0x1.7e8e9108526f9p+384,   -0x1.e4c0c72dab923p-1,  -0x1.6b805ap-2, INEXACT)
T(RN,  0x1.2e53e5f1e84b9p+384,   -0x1.cab2daa9bcbaap-1,  -0x1.c1c416p-3, INEXACT)
T(RN,  0x1.0b8bbe8aa3d29p+384,   -0x1.fc9726ac01552p-1,   -0x1.b3b66p-4, INEXACT)
T(RN,  0x1.24ca01fa47c99p+384,    0x1.c0496c3af955dp-1,  -0x1.92fd66p-4, INEXACT)
T(RN,  0x1.b435a2c291232p+384,    0x1.e97dc8d709f2cp-1,   0x1.98484ap-4, INEXACT)
T(RN,  0x1.34582c2b66c41p+384,   -0x1.5ea8eb9b7d0a6p-1,   0x1.f5e8acp-2, INEXACT)
T(RN,  0x1.1f7d91b62a14bp+384,   -0x1.fa6edea6e2b32p-1,  -0x1.495d66p-2, INEXACT)
T(RN,  0x1.c793726067afep+384,   -0x1.c718f1e234b4bp-2,   0x1.ecf198p-2, INEXACT)
T(RN,  0x1.e0019ec50fd86p+384,    0x1.910d13eb0d0bcp-1,   0x1.ce9298p-2, INEXACT)
T(RN,   0x1.0f8c864f8a94p+384,   -0x1.27cf8adbd1fdep-1,   0x1.e4b5b6p-2, INEXACT)
T(RN,  0x1.ff834aeb24ae5p+385,   -0x1.e7b989410a781p-1,  -0x1.d6cb38p-4, INEXACT)
T(RN,  0x1.e48edce675987p+385,    0x1.74978bf5660f9p-2,  -0x1.9d5eb2p-2, INEXACT)
T(RN,  0x1.f188bf650d03cp+385,   -0x1.c9fa817447372p-4,  -0x1.805b5cp-2, INEXACT)
T(RN,  0x1.0077e5417a519p+385,   -0x1.0980c89e71ad2p-2,    0x1.8b3a6p-3, INEXACT)
T(RN,  0x1.c0bd0bbcccd3ep+385,   -0x1.fe13cf38fa463p-1,  -0x1.17edc4p-2, INEXACT)
T(RN,  0x1.e66358d50295cp+385,    0x1.869a0077b06f2p-1,   0x1.2214a8p-6, INEXACT)
T(RN,  0x1.1bebdc45d72c5p+385,   -0x1.148b191aa7114p-2,   -0x1.55991p-2, INEXACT)
T(RN,  0x1.6a3100eac8231p+385,    0x1.7fc1908981337p-1,     0x1.500ep-2, INEXACT)
T(RN,   0x1.e9031d46873ap+385,    0x1.a346461d9e129p-3,   0x1.0bc9d8p-5, INEXACT)
T(RN,  0x1.6a913402624c7p+385,   -0x1.f729f8e35ad5fp-1,   0x1.d8e52ep-3, INEXACT)
T(RN,  0x1.95d628c95a877p+386,   -0x1.fffff7e14e664p-1,   -0x1.cc76fp-3, INEXACT)
T(RN,  0x1.ce95aafddfc02p+386,   -0x1.dbb3096fc798ap-1,  -0x1.9b1158p-2, INEXACT)
T(RN,  0x1.170d0f0e6a2bap+386,   -0x1.462b6bcab4d01p-1,   -0x1.e474dp-2, INEXACT)
T(RN,  0x1.9cb4cf724db6bp+386,   -0x1.d53e1092b4d7bp-3,  -0x1.8415b2p-3, INEXACT)
T(RN,   0x1.e5ed850a4df7p+386,    0x1.7a3cab28c2ecap-1,  -0x1.7f7bf8p-2, INEXACT)
T(RN,  0x1.e2ec229d1ab73p+386,    0x1.f42c67a764698p-2,    0x1.cad2fp-2, INEXACT)
T(RN,   0x1.8a631b63673dp+386,   -0x1.5c57dee34d086p-1,   0x1.ccefa4p-3, INEXACT)
T(RN,  0x1.ff24e85d29648p+386,   -0x1.77f6255764783p-2,   0x1.edf3bcp-2, INEXACT)
T(RN,   0x1.aee9071a5abfp+386,   -0x1.631b9100bc77bp-2,  -0x1.07a492p-2, INEXACT)
T(RN,  0x1.3c954338a46acp+386,    0x1.cec0eb6ff530ep-1,   0x1.b49ae8p-7, INEXACT)
T(RN,  0x1.19eccdfd67566p+387,    0x1.e04d6246b8e51p-2,  -0x1.5c0fd4p-4, INEXACT)
T(RN,  0x1.546f4ed0e54fbp+387,   -0x1.dd2eca5816099p-2,  -0x1.a193d2p-3, INEXACT)
T(RN,  0x1.4acc7c9d425f9p+387,   -0x1.ffa8123aca2dcp-1,  -0x1.371012p-3, INEXACT)
T(RN,  0x1.8e725b79cb8d5p+387,    0x1.3e690ec01c76dp-1,   0x1.f5500cp-4, INEXACT)
T(RN,  0x1.90138456c2bc7p+387,   -0x1.0bbfa531c6823p-1,  -0x1.6a9358p-2, INEXACT)
T(RN,  0x1.9046c55323a04p+387,   -0x1.36b527965426bp-1,   0x1.c6670cp-5, INEXACT)
T(RN,   0x1.b5c838593981p+387,   -0x1.3b4da8e902a2cp-2,   0x1.064618p-2, INEXACT)
T(RN,  0x1.777795e200d2dp+387,    0x1.efe24aab58426p-1,   0x1.f2d6c6p-2, INEXACT)
T(RN,  0x1.a420aa276d90cp+387,    0x1.11f8e6b2a13c1p-1,  -0x1.e86a08p-2, INEXACT)
T(RN,  0x1.3538e287b3f84p+387,    0x1.cff93d8a60ef5p-1,   -0x1.5683ep-3, INEXACT)
T(RN,  0x1.c2e203a97296ap+388,   -0x1.4b73e546d3713p-1,   0x1.ba11eap-3, INEXACT)
T(RN,  0x1.b5a370bc4a544p+388,    0x1.e32c80a741e28p-1,  -0x1.137974p-2, INEXACT)
T(RN,  0x1.08657663d3949p+388,   -0x1.fedf872ecb897p-1,  -0x1.77523cp-2, INEXACT)
T(RN,  0x1.556ab3d188f8cp+388,   -0x1.403c5792ae80fp-1,   0x1.2cc106p-2, INEXACT)
T(RN,  0x1.c63f2fe9ca922p+388,   -0x1.e1367eef492a1p-1,  -0x1.6cd082p-2, INEXACT)
T(RN,   0x1.99593b660d48p+388,   -0x1.554acc466a1a7p-1,   0x1.906254p-2, INEXACT)
T(RN,  0x1.6af278eff910cp+388,    0x1.c9603705e9579p-1,   -0x1.2599dp-2, INEXACT)
T(RN,   0x1.88e32c074c7cp+388,    0x1.2405767972df2p-2,   0x1.19cc6cp-2, INEXACT)
T(RN,  0x1.849cf1cc57fdep+388,    0x1.6847c4a8cb196p-1,   0x1.262beep-3, INEXACT)
T(RN,   0x1.d9b0aafab904p+388,   -0x1.db1078f1da62fp-1,   -0x1.0d7aap-2, INEXACT)
T(RN,  0x1.50a31ebd56931p+389,    0x1.b6f4a26f8a53cp-4,    0x1.b102ep-2, INEXACT)
T(RN,  0x1.ed6ceee5c38a9p+389,   -0x1.db3dd4a1076ddp-1,  -0x1.35ba72p-2, INEXACT)
T(RN,  0x1.368ac2df153ddp+389,     -0x1.52861350448p-1,   0x1.976e46p-2, INEXACT)
T(RN,  0x1.6d1276768756ap+389,    0x1.cef0d8ef97b77p-4,   0x1.1e1676p-3, INEXACT)
T(RN,  0x1.1144c4c5404a4p+389,    0x1.000a02bc9afe1p-1,  -0x1.9f9f54p-5, INEXACT)
T(RN,  0x1.eb84ca83fcf86p+389,    0x1.5f83b2b2910fbp-1,  -0x1.7a7108p-7, INEXACT)
T(RN,  0x1.016296cfaea68p+389,    0x1.75daaf001e946p-1,   -0x1.17dc3p-4, INEXACT)
T(RN,  0x1.f38db6b91c25ap+389,   -0x1.deccecfffaff9p-1,  -0x1.782bbap-2, INEXACT)
T(RN,   0x1.9a4bcbfbdb3ap+389,    0x1.58628599a5297p-1,  -0x1.cd9e82p-5, INEXACT)
T(RN,   0x1.a29d0514fcd6p+389,   -0x1.8046350701a19p-5,   -0x1.5ffbdp-5, INEXACT)
T(RN,   0x1.c70ba0fdbf8cp+390,    0x1.18c5ee3ae6dd5p-3,   -0x1.a7814p-2, INEXACT)
T(RN,  0x1.09c0325bb998bp+390,    0x1.cdb72e74c2921p-1,  -0x1.7d554ep-2, INEXACT)
T(RN,  0x1.453ca33c37c67p+390,    0x1.fe5b191314c46p-1,  -0x1.c57194p-4, INEXACT)
T(RN,  0x1.57675ce4df9d5p+390,   -0x1.235fc229d510ap-6,    -0x1.a74dp-2, INEXACT)
T(RN,  0x1.3ebe60fab4f0ep+390,   -0x1.694cb2eb3957dp-1,    0x1.4aa37p-4, INEXACT)
T(RN,  0x1.f97cc438f071cp+390,    0x1.e76950d59ee16p-2,  -0x1.4b5516p-3, INEXACT)
T(RN,  0x1.3cc654d58f828p+390,    0x1.c80ae609d5baap-1,  -0x1.7e4142p-5, INEXACT)
T(RN,   0x1.afeee23b80e9p+390,   -0x1.85d9fa73fc834p-2,  -0x1.7266f4p-3, INEXACT)
T(RN,  0x1.66faf6a8f21c2p+390,   -0x1.20a526dbafeefp-3,  -0x1.dea83ep-2, INEXACT)
T(RN,  0x1.0ef1a3390bd74p+390,    0x1.90f1aa5e6ca3ep-1,   0x1.8c7494p-3, INEXACT)
T(RN,  0x1.451a83b572afep+391,    0x1.fe9588d72d2dcp-1,   0x1.7284ccp-4, INEXACT)
T(RN,  0x1.96be848bc895ep+391,    0x1.e6ec0265bf178p-1,   0x1.7c3fcap-6, INEXACT)
T(RN,  0x1.6817a0b3f0a14p+391,   -0x1.7c0e4a1adce62p-1,   0x1.8d3332p-3, INEXACT)
T(RN,  0x1.130510bc85a61p+391,   -0x1.ea5df4befe952p-1,  -0x1.fce0c4p-2, INEXACT)
T(RN,  0x1.e84b744d2d403p+391,   -0x1.faf782a5efeb9p-1,   0x1.50138ep-5, INEXACT)
T(RN,  0x1.4ecae75ab4166p+391,   -0x1.61b749bdc1917p-2,   0x1.3f9912p-2, INEXACT)
T(RN,   0x1.ce020fd59b97p+391,    0x1.8ffcb5d5900f1p-3,  -0x1.8feba8p-3, INEXACT)
T(RN,  0x1.3ab2ebb9b964ap+391,   -0x1.ac70ac13ba8fap-1,   0x1.36d7dep-2, INEXACT)
T(RN,  0x1.619e1e4317399p+391,   -0x1.beb9602e4cc56p-1,    0x1.de56bp-2, INEXACT)
T(RN,  0x1.ecf2cecd5434ep+391,   -0x1.fffec95acec09p-1,   0x1.6a4cf4p-3, INEXACT)
T(RN,  0x1.e3524b7fc5016p+392,    0x1.8f899f111b3aap-1,   -0x1.3a6ffp-4, INEXACT)
T(RN,  0x1.be8d480f66362p+392,    0x1.e589107cd1f12p-1,   -0x1.77f56p-2, INEXACT)
T(RN,  0x1.5245f005af30cp+392,    0x1.212e75f63f055p-2,   -0x1.46bb8p-2, INEXACT)
T(RN,   0x1.5a838c4514f2p+392,    0x1.c415322c38b93p-1,  -0x1.455adap-2, INEXACT)
T(RN,  0x1.771b68733ac44p+392,    -0x1.83b77df22962p-4,   -0x1.ee1d6p-3, INEXACT)
T(RN,  0x1.ff68683b16bd6p+392,   -0x1.3ffe30dde3fe8p-3,  -0x1.6992e6p-4, INEXACT)
T(RN,  0x1.ff27ae5204044p+392,    0x1.aeab750942bf3p-1,    0x1.496fdp-2, INEXACT)
T(RN,  0x1.65068ff0d98fep+392,    0x1.d94e7e7baf57cp-1,   0x1.cce4e4p-3, INEXACT)
T(RN,  0x1.b4c55ba473cbep+392,   -0x1.0790bd71d2cf7p-1,  -0x1.2e3ceep-6, INEXACT)
T(RN,  0x1.11aa9a3b937d3p+392,    0x1.f191a4e9891dfp-1,  -0x1.98feb8p-3, INEXACT)
T(RN,  0x1.0a5543ff9004cp+393,   -0x1.fe06a38c2052bp-1,  -0x1.deb3fep-2, INEXACT)
T(RN,  0x1.81a071504ee61p+393,    -0x1.a696e315753ap-4,  -0x1.a395a6p-3, INEXACT)
T(RN,  0x1.c1c07e60fea4ap+393,    -0x1.f6e8c94dc0f3p-1,   0x1.e9918cp-4, INEXACT)
T(RN,  0x1.72af28b749442p+393,    0x1.b5d125d83c2a1p-3,  -0x1.e202dcp-2, INEXACT)
T(RN,  0x1.93e3baa31f42ep+393,   -0x1.ef70d84c270dap-1,   0x1.5e6454p-4, INEXACT)
T(RN,  0x1.f5dace5922896p+393,    0x1.0419826d5b889p-2,  -0x1.718098p-2, INEXACT)
T(RN,  0x1.b435676d2b802p+393,   -0x1.d9bc59edb12c6p-2,    0x1.795c9p-5, INEXACT)
T(RN,  0x1.2520c8a7b7491p+393,   -0x1.fef40deb128e5p-1,   -0x1.2c448p-2, INEXACT)
T(RN,  0x1.f63a5062812c7p+393,    0x1.f96ee98140aaep-4,  -0x1.0b28f4p-2, INEXACT)
T(RN,  0x1.33a0558a0d8bdp+393,   -0x1.fbfa1393240c3p-1,   0x1.cd7d5cp-2, INEXACT)
T(RN,  0x1.f7f69a0ecc9e2p+394,   -0x1.29a654f17010dp-1,   0x1.80f838p-2, INEXACT)
T(RN,  0x1.29293c5c7577bp+394,   -0x1.e651f3dddce3bp-1,   0x1.0d2896p-4, INEXACT)
T(RN,  0x1.c8be58478ac2ep+394,    0x1.d54720043c044p-3,   0x1.ea4c6ap-2, INEXACT)
T(RN,  0x1.8abde891a15dep+394,     0x1.5f9817b4c11cp-1,   -0x1.2c0d7p-2, INEXACT)
T(RN,  0x1.4986fca6e1af8p+394,   -0x1.e37035dcf245bp-1,   0x1.08e708p-2, INEXACT)
T(RN,  0x1.10fa537f4ca16p+394,   -0x1.26b83f42f4f04p-1,  -0x1.e05a5ap-2, INEXACT)
T(RN,  0x1.d35cc9a3443e2p+394,   -0x1.29328546b8f75p-2,   0x1.aa8486p-5, INEXACT)
T(RN,   0x1.d174b0e8fac9p+394,   -0x1.da033dca87105p-1,   0x1.66a584p-3, INEXACT)
T(RN,  0x1.9f49a5e092439p+394,    0x1.ffc3a6c0d6b9cp-1,  -0x1.af9cb6p-4, INEXACT)
T(RN,   0x1.66ec502f7aecp+394,   -0x1.082626b4d34f3p-1,  -0x1.d2702cp-2, INEXACT)
T(RN,  0x1.4cf14853d8a92p+395,    0x1.b5a53efb51f84p-1,   0x1.d1cc82p-2, INEXACT)
T(RN,  0x1.525be22f36c24p+395,    0x1.82332bf0b5f68p-1,   0x1.6d092cp-2, INEXACT)
T(RN,  0x1.fb8935c70549cp+395,    0x1.77226acedbb56p-1,  -0x1.8d720ep-3, INEXACT)
T(RN,  0x1.c19a280f8d3e8p+395,     -0x1.b3cba9f1854p-1,  -0x1.4bdc52p-4, INEXACT)
T(RN,  0x1.9d51e1ce43638p+395,   -0x1.ecbae7c60767cp-1,   -0x1.4dfa6p-2, INEXACT)
T(RN,  0x1.2fda3af62adc1p+395,    0x1.636ff1c5ab0f2p-4,   0x1.235a58p-2, INEXACT)
T(RN,  0x1.2a262d1bbc99bp+395,    -0x1.f96828e33d8ep-1,   0x1.f2d2f8p-2, INEXACT)
T(RN,  0x1.a9b9d70bba7efp+395,   -0x1.43cbe8143e322p-2,  -0x1.f8a84ep-2, INEXACT)
T(RN,  0x1.d0a424c721fc2p+395,   -0x1.ecf5fcc2646cep-6,   0x1.ef0388p-3, INEXACT)
T(RN,  0x1.21568202afd74p+395,    0x1.8c28f58036404p-1,  -0x1.a88076p-2, INEXACT)
T(RN,  0x1.16758f51de631p+396,   -0x1.2571b91a3fef4p-1,  -0x1.a4a938p-2, INEXACT)
T(RN,  0x1.c0bbae9a1de5ap+396,    0x1.045e3c1fe89fbp-2,   0x1.a104eap-3, INEXACT)
T(RN,  0x1.8cd9c8ca65149p+396,    0x1.a1cf689b5c093p-1,  -0x1.7ec9e2p-2, INEXACT)
T(RN,  0x1.c3b24204b4df4p+396,    0x1.2e09c9ab8ca0ep-1,  -0x1.6cd368p-3, INEXACT)
T(RN,  0x1.1fafa66fb7243p+396,    0x1.5ac513d02e2aap-2,    -0x1.f12ep-2, INEXACT)
T(RN,  0x1.a0140e0561becp+396,   -0x1.c058b2c643c4ep-1,  -0x1.0ee0cap-2, INEXACT)
T(RN,  0x1.51af8005379c4p+396,    0x1.88b662edd0976p-3,   0x1.984126p-3, INEXACT)
T(RN,  0x1.c43a703f4a4e6p+396,    0x1.cc1ea1ed05663p-1,   0x1.e8c3a8p-2, INEXACT)
T(RN,  0x1.0dcbb18e45784p+396,   -0x1.e4519027aca2dp-1,   -0x1.d3089p-3, INEXACT)
T(RN,  0x1.dfa81b6c5d6adp+396,   -0x1.f47ac1522c22cp-2,  -0x1.fbc6a8p-2, INEXACT)
T(RN,  0x1.19cc0e5f32099p+397,   -0x1.168c64852432cp-1,   -0x1.18ccfp-2, INEXACT)
T(RN,  0x1.ee0613afd690ep+397,   -0x1.e0f61ce5cfadfp-1,   0x1.07203cp-2, INEXACT)
T(RN,  0x1.7e7efee1321a8p+397,    0x1.28c4bbedb7cbfp-1,   0x1.78377ap-2, INEXACT)
T(RN,  0x1.2fe2b4d0f9aa3p+397,    0x1.634caddfab15dp-1,   -0x1.9c325p-3, INEXACT)
T(RN,  0x1.56b4ae8d9a7ebp+397,   -0x1.cb44d285cce16p-2,  -0x1.f51354p-2, INEXACT)
T(RN,  0x1.69e5f5f39290bp+397,   -0x1.133dc2a570a18p-1,  -0x1.47b0bep-2, INEXACT)
T(RN,  0x1.a970d807888eap+397,   -0x1.bca270d8c35e3p-1,   0x1.b548acp-2, INEXACT)
T(RN,   0x1.177b9994f337p+397,   -0x1.21c0f36652006p-2,   0x1.2e3a32p-5, INEXACT)
T(RN,  0x1.f737bec6453dbp+397,    0x1.fa6c3e2c5193dp-2,  -0x1.d2abfep-3, INEXACT)
T(RN,  0x1.34d48e5479f89p+397,   -0x1.fef4b4249a1bbp-1,  -0x1.089fe4p-2, INEXACT)
T(RN,  0x1.06f55b8befd7bp+398,   -0x1.8d0596c7b06d7p-1,  -0x1.c93d3cp-2, INEXACT)
T(RN,  0x1.ea4da144933c7p+398,    0x1.e85d618f90eb9p-1,    0x1.31ca2p-4, INEXACT)
T(RN,  0x1.316b44b03111ep+398,     0x1.bf44677a3171p-3,   -0x1.1e2d6p-7, INEXACT)
T(RN,  0x1.07c054b86285fp+398,   -0x1.b3fbcb30a915ap-1,  -0x1.8384ccp-2, INEXACT)
T(RN,  0x1.fa425d85bf47ap+398,   -0x1.67a87af5ed935p-3,   0x1.10b132p-4, INEXACT)
T(RN,  0x1.ebcb48664f55cp+398,    -0x1.405ed4f6b1a2p-1,   0x1.77605ap-4, INEXACT)
T(RN,   0x1.161f4b24b542p+398,   -0x1.6b09bb5971f2ap-1,   0x1.5dab16p-9, INEXACT)
T(RN,  0x1.a02eb486139c9p+398,    0x1.bbc9784be8fb8p-1,   -0x1.21ec2p-2, INEXACT)
T(RN,   0x1.27a76553bfafp+398,   -0x1.7c17fda2955a6p-1,   0x1.f606f2p-2, INEXACT)
T(RN,  0x1.d11a32274fe46p+398,     0x1.e4e1491ab0a1p-2,  -0x1.b8fceap-3, INEXACT)
T(RN,  0x1.690f855fe6cc5p+399,   -0x1.c62a6f66e54f4p-1,   0x1.8eaedep-2, INEXACT)
T(RN,  0x1.a88e522591135p+399,   -0x1.966c6b09b7175p-2,   -0x1.ca69ap-2, INEXACT)
T(RN,  0x1.fd216200ea74cp+399,   -0x1.469c95e6cf5bfp-1,  -0x1.16ce02p-3, INEXACT)
T(RN,  0x1.73b4bde581032p+399,   -0x1.47b0abb552037p-1,   0x1.f91d0cp-3, INEXACT)
T(RN,  0x1.ac591e10bfbf2p+399,   -0x1.95df89d050a87p-1,   0x1.cebe62p-5, INEXACT)
T(RN,  0x1.ff1f1e642d1fcp+399,   -0x1.77f829f183d8ap-2,  -0x1.7ba91cp-2, INEXACT)
T(RN,   0x1.32ced30703c9p+399,   -0x1.f18e6912665c4p-1,   0x1.a36c4ap-4, INEXACT)
T(RN,  0x1.3ad40f5b8b748p+399,    0x1.ffd2d49681edfp-1,   0x1.bf1ceap-2, INEXACT)
T(RN,  0x1.e1a247f3a0fdcp+399,    0x1.724a35519f4ccp-1,   0x1.2a24dcp-2, INEXACT)
T(RN,  0x1.eef5fa0592b98p+399,   -0x1.ad64beee4c265p-1,  -0x1.636a88p-3, INEXACT)
T(RN,  0x1.073236b679698p+400,   -0x1.5464ed2967be5p-1,   0x1.798f44p-3, INEXACT)
T(RN,  0x1.865a10874aa22p+400,   -0x1.116a272820397p-2,  -0x1.b9877cp-4, INEXACT)
T(RN,  0x1.05e881695c18bp+400,   -0x1.5963795ebccd4p-1,  -0x1.bff4e2p-2, INEXACT)
T(RN,  0x1.f481c1e04e792p+400,    0x1.fdd764ca66289p-1,   0x1.06b87ep-2, INEXACT)
T(RN,  0x1.3317720f6bb22p+400,    0x1.f33911f976d1fp-1,   0x1.c99332p-2, INEXACT)
T(RN,  0x1.db5f0f0117adcp+400,    0x1.e804cde973933p-4,  -0x1.db2c4cp-2, INEXACT)
T(RN,  0x1.b59f2ace4807cp+400,    0x1.ff8bc13e637c9p-1,  -0x1.d84b18p-3, INEXACT)
T(RN,  0x1.efc3f458473ecp+400,   -0x1.c628f6565ccfcp-1,  -0x1.421f62p-6, INEXACT)
T(RN,  0x1.dc6769a42fa9cp+400,   -0x1.d29d7c9785a1dp-3,   0x1.1cc376p-6, INEXACT)
T(RN,  0x1.841145030126cp+400,    0x1.86266e62bef69p-1,   -0x1.f9095p-4, INEXACT)
T(RN,  0x1.062ad1a09bafdp+401,    0x1.f78e4ec182e03p-1,   -0x1.304a5p-5, INEXACT)
T(RN,  0x1.f6e1013e6f042p+401,   -0x1.946d3503e261ep-1,   0x1.c342c4p-2, INEXACT)
T(RN,  0x1.f51d298cfc283p+401,    0x1.3b03ad8b83746p-2,    0x1.96ccep-3, INEXACT)
T(RN,  0x1.0f8c13c29112dp+401,      0x1.f42aa3f589fp-1,  -0x1.79cb2ep-2, INEXACT)
T(RN,  0x1.e222c59a931bap+401,   -0x1.f5e35c1e0b731p-1,   0x1.561412p-2, INEXACT)
T(RN,  0x1.e421e32a575a4p+401,   -0x1.ac58fa423c944p-1,   0x1.98f9f6p-2, INEXACT)
T(RN,  0x1.fdcea93add0d7p+401,   -0x1.fea36f17672c8p-1,   0x1.ab1ebap-2, INEXACT)
T(RN,  0x1.e5c1fda52b283p+401,    0x1.35b54f10186dcp-1,   0x1.30e58ep-4, INEXACT)
T(RN,  0x1.b8aa9d3678f85p+401,    0x1.e8546770b0ca3p-2,    0x1.8f207p-2, INEXACT)
T(RN,   0x1.dd0dd28345fcp+401,   -0x1.c6017bc59ee99p-2,  -0x1.600bf6p-2, INEXACT)
T(RN,  0x1.33232af5c5341p+402,    0x1.92dac6512008fp-1,  -0x1.191f34p-2, INEXACT)
T(RN,  0x1.dd18d9cb6a48ap+402,    0x1.b291efee17b95p-2,   0x1.40f76ep-5, INEXACT)
T(RN,  0x1.074fec08d3995p+402,    0x1.8eff799f7ac5ap-2,   0x1.404a96p-2, INEXACT)
T(RN,  0x1.251f16f0be3f4p+402,    0x1.eab3bd2abc09ap-1,  -0x1.62d62ap-2, INEXACT)
T(RN,  0x1.86ffecca8c1a3p+402,    0x1.ea31a5c29beeep-3,   0x1.b556dcp-2, INEXACT)
T(RN,  0x1.90dfe20f91189p+402,   -0x1.f52e93bc883ccp-1,  -0x1.4bef84p-3, INEXACT)
T(RN,  0x1.fbabbc6b444fbp+402,    0x1.ec0a0311056dbp-1,  -0x1.800324p-3, INEXACT)
T(RN,  0x1.9cb4c098f47aep+402,   -0x1.f3b1b0b922cf9p-1,  -0x1.51acf2p-2, INEXACT)
T(RN,  0x1.e21ea598e6e6dp+402,    0x1.986f780613931p-2,  -0x1.0fe196p-2, INEXACT)
T(RN,  0x1.d5455ac045ac8p+402,    0x1.9f85c794e2b45p-2,   0x1.838782p-2, INEXACT)
T(RN,  0x1.228a8fa700dc9p+403,    0x1.e1a51cbb4336cp-1,   0x1.f65434p-4, INEXACT)
T(RN,  0x1.1a5843648edb3p+403,    0x1.fff3e3f1c341bp-1,   0x1.02dd98p-6, INEXACT)
T(RN,  0x1.e487444fc4df8p+403,    0x1.330d0639eaa5bp-3,  -0x1.2d597cp-4, INEXACT)
T(RN,  0x1.febf7d062e5acp+403,    0x1.02245ae49d58ep-1,   0x1.193af2p-2, INEXACT)
T(RN,  0x1.ab5af80d09ee9p+403,    0x1.7dde4877ef17fp-3,    0x1.4c4edp-4, INEXACT)
T(RN,  0x1.ced37fe174bbep+403,   -0x1.c7a8d0baa4cb9p-2,  -0x1.708746p-5, INEXACT)
T(RN,  0x1.f31927542c48dp+403,    0x1.4dc4b6fd63f28p-1,  -0x1.f819d4p-2, INEXACT)
T(RN,  0x1.b488c24507508p+403,   -0x1.48e5c2c1bae02p-8,  -0x1.05ef88p-2, INEXACT)
T(RN,  0x1.867da8db87edbp+403,   -0x1.6d179314bc03ep-1,   0x1.6b8dccp-2, INEXACT)
T(RN,  0x1.273353514fa69p+403,    0x1.0657c1d53d4f3p-1,   0x1.6aea52p-4, INEXACT)
T(RN,  0x1.0b8a30c017559p+404,    0x1.8946c9466ddd2p-3,   0x1.894b34p-2, INEXACT)
T(RN,  0x1.bebada9395f37p+404,    0x1.51e9110c1fd38p-1,   0x1.aca3bap-3, INEXACT)
T(RN,  0x1.02bad38f9f999p+404,    0x1.a595bc4b7a37fp-1,  -0x1.6b8e34p-2, INEXACT)
T(RN,   0x1.3f71736995f2p+404,   -0x1.35fda1d68ab04p-1,  -0x1.3c292ap-2, INEXACT)
T(RN,  0x1.e800793b45286p+404,    0x1.64cf606d24701p-3,   0x1.ee270cp-4, INEXACT)
T(RN,  0x1.134c395d5a6bap+404,   -0x1.a79f2a626670ep-2,   0x1.8e179ap-2, INEXACT)
T(RN,  0x1.28dd249f0a71dp+404,    0x1.7f0c54a32a8e5p-1,  -0x1.3cbf2ep-2, INEXACT)
T(RN,  0x1.443e6a295802cp+404,    0x1.184bd20e4d914p-1,  -0x1.e635c6p-3, INEXACT)
T(RN,  0x1.223875d70f9d6p+404,    0x1.f4bd0a3f8894ep-1,   -0x1.01e26p-2, INEXACT)
T(RN,  0x1.0b4fd1e9a34a4p+404,   -0x1.24fbb72b86711p-5,   0x1.07981cp-4, INEXACT)
T(RN,  0x1.c5ea1a3b5c2e8p+405,   -0x1.fffa3524c66d7p-1,   0x1.c91064p-4, INEXACT)
T(RN,  0x1.c65fc367ef6ecp+405,    0x1.d4856779af8fdp-1,   0x1.50871ap-5, INEXACT)
T(RN,  0x1.f4664ed695b34p+405,    0x1.b38b92f931345p-1,  -0x1.5b3f32p-4, INEXACT)
T(RN,  0x1.28ab549c79a99p+405,   -0x1.dfca0dac56a7bp-1,  -0x1.080fb2p-2, INEXACT)
T(RN,  0x1.7d5d17f106e74p+405,    0x1.608463bb2d696p-6,   0x1.b6df12p-2, INEXACT)
T(RN,  0x1.d3d7e842890a6p+405,    0x1.d327668070d39p-1,   0x1.8a3ccap-3, INEXACT)
T(RN,  0x1.65f36e709ef96p+405,    0x1.6b43822ef49a1p-2,   0x1.a85b6ep-4, INEXACT)
T(RN,  0x1.7675e8a5eae3fp+405,    0x1.5521a10a92228p-2,   0x1.67ff32p-3, INEXACT)
T(RN,  0x1.8c274add003ccp+405,   -0x1.3b077012424fdp-3,   0x1.02011cp-5, INEXACT)
T(RN,  0x1.fb444e00e1fbep+405,   -0x1.fd977b027ed84p-1,  -0x1.08b8bep-5, INEXACT)
T(RN,  0x1.150ec2a978cf9p+406,    -0x1.d786a35f52e7p-2,    0x1.54aa2p-6, INEXACT)
T(RN,  0x1.b8ac5bdce0bc2p+406,    0x1.a1511fe93ba8cp-1,   0x1.482e1ep-5, INEXACT)
T(RN,  0x1.4fa4ac02fe4ffp+406,    0x1.efc50cc7130afp-1,  -0x1.6dfc0ap-3, INEXACT)
T(RN,  0x1.a974e5ffff526p+406,   -0x1.55d9918be130ap-3,   0x1.eedee6p-7, INEXACT)
T(RN,  0x1.21b8076b726eep+406,    0x1.14dc7d4bfe3a7p-2,   0x1.09564ap-2, INEXACT)
T(RN,  0x1.1a0be90a0ff4fp+406,   -0x1.d3d3094978446p-2,   0x1.1a091ap-2, INEXACT)
T(RN,  0x1.4ef1ffada2a5ap+406,   -0x1.3c5b87e5702bbp-1,   0x1.92e27ep-4, INEXACT)
T(RN,  0x1.d520467eb3433p+406,   -0x1.ffbbe6ad3897bp-1,   -0x1.2ff24p-2, INEXACT)
T(RN,  0x1.9fc568b6a2ceap+406,    0x1.fd9954f8a8438p-1,  -0x1.0cb566p-3, INEXACT)
T(RN,  0x1.258817317f9efp+406,    0x1.f99c0bb8f055ep-1,   -0x1.b8702p-3, INEXACT)
T(RN,  0x1.75beb64d5ca06p+407,    0x1.ef5b68f35cf1bp-1,   0x1.0d8cb2p-4, INEXACT)
T(RN,  0x1.8ecd34d37d011p+407,    0x1.691360944cadcp-3,    0x1.9674bp-2, INEXACT)
T(RN,  0x1.dd8957ae0b1efp+407,    0x1.f9be1c3d205fap-1,  -0x1.fde48ep-2, INEXACT)
T(RN,  0x1.e1e2fe7ad9b31p+407,    0x1.79a8a2529c8e6p-4,   0x1.bf7088p-4, INEXACT)
T(RN,  0x1.884445cfdd382p+407,    0x1.fe3abcffc1b25p-1,   0x1.d5bd38p-3, INEXACT)
T(RN,  0x1.c2b44dd4cf74bp+407,   -0x1.e9752865d131cp-1,  -0x1.c6b36ep-2, INEXACT)
T(RN,  0x1.fc20166a8bddap+407,   -0x1.9925fdb1ef695p-2,   0x1.ad98d4p-2, INEXACT)
T(RN,  0x1.74c62542f64c6p+407,    0x1.0da7bc7bcbd6ep-1,   0x1.17d55ap-5, INEXACT)
T(RN,   0x1.cd044cbb8ee8p+407,   -0x1.e15ac80d5e4a3p-1,  -0x1.52d528p-3, INEXACT)
T(RN,  0x1.23c52795de429p+407,    0x1.8c79e4ce24b04p-1,  -0x1.64108cp-2, INEXACT)
T(RN,  0x1.cba75656af397p+408,    0x1.ffe587df6130bp-1,  -0x1.8e531cp-4, INEXACT)
T(RN,  0x1.a19e3516bc044p+408,   -0x1.3dda5c0f59222p-1,   0x1.68ab84p-4, INEXACT)
T(RN,  0x1.6b2882bf14626p+408,    0x1.5f57cc748552dp-4,  -0x1.87e604p-3, INEXACT)
T(RN,  0x1.653e5c742f1dcp+408,   -0x1.65c87640eb0b4p-1,   0x1.308b06p-2, INEXACT)
T(RN,  0x1.04c18d05ef5f1p+408,   -0x1.01359f113e64ep-1,   -0x1.816afp-4, INEXACT)
T(RN,  0x1.4cc0eb7eff3f6p+408,   -0x1.c44af78574c55p-1,   0x1.6f9634p-3, INEXACT)
T(RN,   0x1.eaab4e5884a7p+408,    0x1.8658c40670ad1p-1,  -0x1.bc6592p-4, INEXACT)
T(RN,  0x1.3886bb5e2b022p+408,   -0x1.7e34cc96049eap-3,   0x1.f8e98cp-3, INEXACT)
T(RN,  0x1.b83d97bede7dap+408,   -0x1.2eedc587f5377p-2,   0x1.fec6e2p-3, INEXACT)
T(RN,  0x1.e6517a7faffcap+408,    0x1.24b6e59719ac2p-1,   0x1.999428p-3, INEXACT)
T(RN,  0x1.869803a58c1e7p+409,     0x1.9db2c97d3908p-2,  -0x1.a5de6ep-3, INEXACT)
T(RN,  0x1.e9b537c248e74p+409,     -0x1.49e4fb44edfp-4,   0x1.3a457ap-2, INEXACT)
T(RN,  0x1.197e6e76fb5d2p+409,   -0x1.fe0f4ecdff525p-1,   0x1.a4c362p-3, INEXACT)
T(RN,  0x1.04f373f17edacp+409,    0x1.8993bf687c9c7p-2,   0x1.239092p-2, INEXACT)
T(RN,  0x1.198258610711dp+409,    0x1.63edf572a94bbp-6,  -0x1.9b3cc4p-2, INEXACT)
T(RN,  0x1.05f0b33154587p+409,    0x1.596fde27e02d5p-1,  -0x1.5e08c6p-2, INEXACT)
T(RN,  0x1.0e9fb1275c3f1p+409,    0x1.a8938e95978e4p-2,   0x1.f9e80ap-2, INEXACT)
T(RN,  0x1.40434e02c26cep+409,   -0x1.e530fe0c54886p-1,   0x1.330f14p-4, INEXACT)
T(RN,   0x1.bbc553c93618p+409,    0x1.37faffc8f7068p-8,  -0x1.b3c17ap-4, INEXACT)
T(RN,   0x1.b4c8e06cef49p+409,      -0x1.55ceeb8a25p-3,   0x1.a9981ap-2, INEXACT)
T(RN,  0x1.f8ad205ee6f2ep+410,   -0x1.fc189127dcc8fp-1,   0x1.96d86ep-2, INEXACT)
T(RN,  0x1.fa59b8d96eae9p+410,    0x1.b71786e6aa2a8p-1,   0x1.aee564p-2, INEXACT)
T(RN,  0x1.e97b7b1eb73cep+410,    0x1.67a318a5a7389p-1,  -0x1.7f37b2p-5, INEXACT)
T(RN,  0x1.4a4668cb0e312p+410,    0x1.80864b5a45f73p-2,  -0x1.099626p-3, INEXACT)
T(RN,  0x1.2a7545bd6c5bbp+410,    0x1.3d356ec1af708p-1,  -0x1.aac146p-7, INEXACT)
T(RN,  0x1.f3748a1fd61e2p+410,   -0x1.892f44eb81468p-4,  -0x1.3ab148p-5, INEXACT)
T(RN,   0x1.2549699f6c25p+410,    0x1.00eeb1df5ff0ep-2,   -0x1.d31bfp-2, INEXACT)
T(RN,  0x1.6215bb7bba8c7p+410,    0x1.7a9989126c41ap-2,   0x1.472456p-4, INEXACT)
T(RN,  0x1.9b41d8c884e54p+410,   -0x1.8034be200972fp-1,   0x1.eb6f24p-3, INEXACT)
T(RN,  0x1.bf22c166affd2p+410,     0x1.4062d4df8ee9p-1,  -0x1.1cae8ep-4, INEXACT)
T(RN,  0x1.a941f47422434p+411,    0x1.dd7a208701b94p-1,   0x1.08b576p-3, INEXACT)
T(RN,  0x1.1095f8446195ap+411,    0x1.349a75abac738p-1,  -0x1.1317fap-5, INEXACT)
T(RN,  0x1.15a2978d34978p+411,    0x1.acb0d6d7a0662p-3,   0x1.0b8318p-3, INEXACT)
T(RN,  0x1.a3d4c1dbedb28p+411,   -0x1.b3d1c6b834ca7p-4,   0x1.001cc6p-2, INEXACT)
T(RN,  0x1.bcd899d5ab61ep+411,    0x1.588881049bde4p-3,   0x1.482fcap-6, INEXACT)
T(RN,  0x1.5041fcda36455p+411,    0x1.a25310140e73ap-3,   0x1.41c604p-3, INEXACT)
T(RN,  0x1.0367aa28831c7p+411,   -0x1.1631e944fac57p-1,  -0x1.65b702p-4, INEXACT)
T(RN,  0x1.949c5543df458p+411,    0x1.6c88e28f51acep-2,    0x1.6db44p-2, INEXACT)
T(RN,  0x1.4fa57ab5eceb2p+411,    -0x1.eba7144dfd88p-3,  -0x1.36c92cp-2, INEXACT)
T(RN,  0x1.de772b4f0f878p+411,    0x1.eb138ebe55356p-1,  -0x1.f5d416p-2, INEXACT)
T(RN,  0x1.e270e52b30154p+412,    0x1.ec037812e5f7dp-1,   0x1.6cf34ap-8, INEXACT)
T(RN,  0x1.edfcc6564f04ap+412,    0x1.f1b5e82ab6cd6p-1,   0x1.258d98p-5, INEXACT)
T(RN,  0x1.1bb358dc87b68p+412,     0x1.4307d38a7d85p-2,   -0x1.f131cp-2, INEXACT)
T(RN,  0x1.eb4d1b0f6113bp+412,   -0x1.bc4e1f38c8dbep-1,  -0x1.9c489cp-2, INEXACT)
T(RN,  0x1.b8da172d4648bp+412,   -0x1.aa1aa57ab74aep-1,  -0x1.9dec86p-4, INEXACT)
T(RN,  0x1.0a90066da58fep+412,    0x1.f95d0b248fd02p-1,   0x1.e7492ap-8, INEXACT)
T(RN,  0x1.93fba99454d36p+412,   -0x1.7cd0270b3a241p-2,  -0x1.374732p-5, INEXACT)
T(RN,  0x1.1971867ded9b9p+412,   -0x1.fc69f8ff47b11p-1,   0x1.b5ee7ep-2, INEXACT)
T(RN,  0x1.b574f99622511p+412,   -0x1.ee3f199864862p-1,  -0x1.6436cep-8, INEXACT)
T(RN,  0x1.1d4e4d272fd1ap+412,    0x1.c64cd2f67b267p-1,   0x1.49675ap-2, INEXACT)
T(RN,  0x1.540fafeccabb8p+413,    0x1.a9480978b67c4p-1,  -0x1.cfa4a8p-3, INEXACT)
T(RN,  0x1.c3fb32178ea14p+413,   -0x1.a39a656a81d12p-1,   0x1.04cacap-2, INEXACT)
T(RN,  0x1.d5032acd9bb08p+413,   -0x1.c2ef3150f3806p-1,   0x1.caae72p-2, INEXACT)
T(RN,  0x1.2871c702d7b6bp+413,    0x1.e20664aa36d1ap-2,  -0x1.ed0c5cp-2, INEXACT)
T(RN,  0x1.ba35479e10396p+413,    0x1.bbee303d7cff2p-2,  -0x1.e3c25cp-5, INEXACT)
T(RN,  0x1.1840a29416b14p+413,    0x1.a4b9d85653a0dp-1,   -0x1.e3ef3p-2, INEXACT)
T(RN,  0x1.814611c3458acp+413,   -0x1.e226b486386d6p-1,   0x1.8c1fe4p-2, INEXACT)
T(RN,  0x1.938716399170bp+413,    0x1.b82bd37038265p-1,   0x1.693268p-5, INEXACT)
T(RN,  0x1.32aa7cb51c3d2p+413,     0x1.e16df71b47f1p-1,  -0x1.6dc47ap-3, INEXACT)
T(RN,  0x1.e8c4aa25e3632p+413,    0x1.98a4198899f23p-1,  -0x1.83f7a8p-3, INEXACT)
T(RN,  0x1.65e5268901b16p+414,    -0x1.1a23dae582d1p-1,   0x1.04ea2cp-2, INEXACT)
T(RN,  0x1.ccb64739cd476p+414,   -0x1.a7a9f429aad3fp-2,   0x1.9385d4p-2, INEXACT)
T(RN,  0x1.209909cc94b93p+414,    0x1.68d3c1f907391p-1,   0x1.1d75dcp-4, INEXACT)
T(RN,  0x1.7d302fcb5dc81p+414,   -0x1.b0ffe87400675p-1,  -0x1.34b668p-2, INEXACT)
T(RN,  0x1.4f1f6329e2951p+414,   -0x1.d765b84e721b5p-1,  -0x1.76482ap-2, INEXACT)
T(RN,  0x1.798577f7eac6ap+414,   -0x1.6c42bad17a5e2p-1,   0x1.d9cbc8p-2, INEXACT)
T(RN,  0x1.87829db2c86acp+414,   -0x1.2a30160bd5bc9p-1,   -0x1.55589p-6, INEXACT)
T(RN,  0x1.168a093be7853p+414,    0x1.ff7324c6bf24fp-1,  -0x1.47fa76p-2, INEXACT)
T(RN,  0x1.014f022f966bep+414,    0x1.bcab9038d4312p-1,  -0x1.603ca8p-2, INEXACT)
T(RN,  0x1.edd2f723dc6fcp+414,    0x1.4566e48fe7bdap-2,  -0x1.cc08d6p-3, INEXACT)
T(RN,  0x1.6255db45902f4p+415,    0x1.bf677cafbf378p-1,  -0x1.9600d6p-5, INEXACT)
T(RN,  0x1.0de7b8df7cf2cp+415,   -0x1.8e2e121e54b6fp-2,   -0x1.91c93p-3, INEXACT)
T(RN,  0x1.1026554826538p+415,   -0x1.9078f61c5f56ap-3,  -0x1.3dbbe4p-2, INEXACT)
T(RN,  0x1.73279698c52d5p+415,    0x1.d8e8ad4bb2d1ep-3,  -0x1.5b71e2p-2, INEXACT)
T(RN,  0x1.77b5c1c1c4e52p+415,    0x1.831fb32f4830cp-2,    0x1.608c6p-4, INEXACT)
T(RN,  0x1.9686c37df2568p+415,    0x1.b0d0cefe5fce5p-1,   -0x1.9682ep-4, INEXACT)
T(RN,  0x1.1b16f8e4be8fbp+415,   -0x1.e104456dd74a9p-1,   0x1.3471aep-3, INEXACT)
T(RN,  0x1.cf2b6e63e9cd6p+415,   -0x1.d7e429510654ep-1,   0x1.9e257cp-2, INEXACT)
T(RN,  0x1.810721ee1a3ddp+415,    0x1.12f2fbf25e7b6p-1,  -0x1.03ec56p-5, INEXACT)
T(RN,  0x1.6edfd896d3bb6p+415,    -0x1.99ef01256d69p-1,   0x1.d61f3ap-2, INEXACT)
T(RN,  0x1.6956fde73a39ap+416,    0x1.a07a69950d28dp-1,  -0x1.f3e01cp-2, INEXACT)
T(RN,  0x1.fd926d6356251p+416,   -0x1.f98245b9b8b37p-1,    0x1.05016p-2, INEXACT)
T(RN,  0x1.729ccbcf842c6p+416,    0x1.31112abe2e04cp-1,    0x1.b02f7p-2, INEXACT)
T(RN,  0x1.de1a2167f586cp+416,   -0x1.13e978c1a915bp-4,   0x1.23ca2cp-2, INEXACT)
T(RN,  0x1.05397e08e5a9bp+416,   -0x1.d60e8ec3cbf4ep-1,   0x1.66e4dcp-2, INEXACT)
T(RN,  0x1.108cfd873a404p+416,    0x1.f5e8b401c9833p-1,   0x1.1ac38ap-4, INEXACT)
T(RN,  0x1.c7fb4f5ff0156p+416,   -0x1.e8295e299e77ep-1,   0x1.e39a78p-2, INEXACT)
T(RN,  0x1.840ed94431628p+416,    0x1.5a6e75f280866p-1,   -0x1.35165p-2, INEXACT)
T(RN,   0x1.672fdaccef8fp+416,   -0x1.9685187af05c2p-4,  -0x1.6b79aep-2, INEXACT)
T(RN,  0x1.9ff193d696ccbp+416,   -0x1.1c5a1d8fc2744p-4,  -0x1.7eaccap-4, INEXACT)
T(RN,  0x1.79c6da9396e3dp+417,    0x1.12f340b7dd188p-1,  -0x1.98d84cp-4, INEXACT)
T(RN,  0x1.4cf25c21bf28bp+417,    0x1.7ec53d554928fp-5,   0x1.0ff874p-2, INEXACT)
T(RN,  0x1.99171506f7becp+417,   -0x1.fd78740847c79p-1,  -0x1.6d15aep-2, INEXACT)
T(RN,  0x1.734e6842cd4d5p+417,    0x1.0968e7654f4d6p-3,   0x1.4fe8fcp-3, INEXACT)
T(RN,  0x1.6cb4fdba4a12cp+417,    0x1.ce2a911e53a9dp-1,  -0x1.8c0b94p-2, INEXACT)
T(RN,  0x1.1795b80b9ce8ep+417,    0x1.ffd99d74c6bfcp-1,   0x1.693382p-6, INEXACT)
T(RN,  0x1.aa4c59764f99ep+417,     0x1.4bcf633c85e9p-1,   0x1.fbd9e6p-5, INEXACT)
T(RN,  0x1.64fefaec00bfcp+417,    0x1.c725476631709p-1,   -0x1.5bfd9p-8, INEXACT)
T(RN,  0x1.c2e6753b8ac3cp+417,   -0x1.ff9af7754fd19p-1,  -0x1.fc3408p-2, INEXACT)
T(RN,  0x1.d96ad9c6d34d4p+417,   -0x1.0ecfd0c6329e4p-6,    0x1.1daeep-3, INEXACT)
T(RN,  0x1.682f59c783265p+418,   -0x1.f4a1c2e2cb9abp-1,   0x1.088184p-4, INEXACT)
T(RN,  0x1.28c0244cbf7b3p+418,   -0x1.cbf638196fc25p-3,  -0x1.4467f8p-3, INEXACT)
T(RN,  0x1.d3e47aa757eafp+418,   -0x1.2f8f2c58cb8d3p-1,   0x1.ad4f68p-2, INEXACT)
T(RN,   0x1.9f743686883cp+418,    0x1.fbc264ecd6249p-1,   0x1.9fbacep-2, INEXACT)
T(RN,  0x1.51e6547d6ee3cp+418,    0x1.a0e57a4def256p-1,  -0x1.daa09ep-2, INEXACT)
T(RN,  0x1.d48ec516d7b93p+418,    0x1.f0d246eb23d54p-1,   0x1.456a78p-3, INEXACT)
T(RN,  0x1.4d5f270feb0dap+418,    0x1.f448e80dc0a31p-1,  -0x1.9ef8f6p-2, INEXACT)
T(RN,  0x1.80d0584f691c8p+418,     -0x1.cc7953526e8p-1,  -0x1.552fc4p-3, INEXACT)
T(RN,  0x1.6153d2b57bf04p+418,   -0x1.62cd341ddfcaap-2,  -0x1.07086ap-5, INEXACT)
T(RN,  0x1.de77379e85462p+418,   -0x1.155ab9ba1aa97p-1,  -0x1.6d2e7cp-4, INEXACT)
T(RN,  0x1.e59919e664438p+419,    0x1.b1107d7f3bad2p-1,  -0x1.f733f6p-3, INEXACT)
T(RN,  0x1.3bba514591f14p+419,    0x1.aa69602f7ba1bp-1,  -0x1.e8c0fep-7, INEXACT)
T(RN,  0x1.f12a3498d5b04p+419,   -0x1.aaa6036eb1041p-1,   0x1.d7ac9cp-2, INEXACT)
T(RN,  0x1.c074c7046ea26p+419,    0x1.f415b814a35d9p-1,   0x1.287214p-3, INEXACT)
T(RN,  0x1.5d0195dd69cddp+419,    0x1.fe8ce6074bbf7p-1,  -0x1.a8a0ecp-4, INEXACT)
T(RN,  0x1.1ef4e2953c4b3p+419,   -0x1.adbf74f0af62bp-3,  -0x1.1b4986p-2, INEXACT)
T(RN,   0x1.b868d48f46e7p+419,   -0x1.2ca2171a85369p-1,   0x1.4bdf66p-4, INEXACT)
T(RN,  0x1.fd72958cf5c3bp+419,   -0x1.ff6ce1725a3cdp-1,   -0x1.3ae04p-2, INEXACT)
T(RN,  0x1.47afbbb36f8b8p+419,    0x1.3e93e9bb200b4p-2,  -0x1.92a124p-7, INEXACT)
T(RN,  0x1.30c2723e32983p+419,   -0x1.3ebb21e56bf55p-1,   -0x1.ec89ep-3, INEXACT)
T(RN,  0x1.ba420864d62fep+420,    0x1.2023172267044p-1,  -0x1.d878a8p-2, INEXACT)
T(RN,  0x1.5da68c4ec055ap+420,   -0x1.96dd43cf5e0d5p-1,  -0x1.1d91a2p-3, INEXACT)
T(RN,  0x1.6efc0aa42b439p+420,   -0x1.0e01495462c39p-1,  -0x1.3f48d6p-2, INEXACT)
T(RN,  0x1.a4bfa20616922p+420,   -0x1.bf17506866302p-1,  -0x1.e8f74ep-3, INEXACT)
T(RN,  0x1.fb9d45a5b5623p+420,   -0x1.4f8185e7cbdc5p-1,  -0x1.2e745cp-2, INEXACT)
T(RN,  0x1.e6f032092b801p+420,    0x1.9e4c748fc1074p-5,  -0x1.a0daaap-2, INEXACT)
T(RN,  0x1.3c88093f2f9a9p+420,    0x1.ec39d3d77d0ccp-1,   0x1.ab500cp-2, INEXACT)
T(RN,  0x1.b566bb341a191p+420,    0x1.6642b57affc69p-5,  -0x1.a60d1ap-3, INEXACT)
T(RN,  0x1.75ffccb8606a7p+420,     0x1.9af72f3a5b69p-2,  -0x1.d06e0cp-3, INEXACT)
T(RN,  0x1.40b2e4c786e2ep+420,   -0x1.9e4dd60e34fd8p-5,   -0x1.a8d1ap-3, INEXACT)
T(RN,  0x1.5b1e4765547cap+421,    0x1.574443c3efcd3p-1,  -0x1.05819ap-2, INEXACT)
T(RN,  0x1.274fd293441a7p+421,   -0x1.e7930ab2256cap-1,  -0x1.7600f2p-2, INEXACT)
T(RN,  0x1.5abf8e092817bp+421,   -0x1.7882828b69edfp-2,    0x1.8d7abp-2, INEXACT)
T(RN,   0x1.db5bc733ef51p+421,    0x1.db3611ea697d4p-1,   0x1.60b9a6p-2, INEXACT)
T(RN,   0x1.de3502201993p+421,    0x1.098b0b95e40d5p-1,   0x1.82ef28p-4, INEXACT)
T(RN,  0x1.ea1436e7658ebp+421,   -0x1.fb93a28110dc5p-3,   -0x1.f5447p-7, INEXACT)
T(RN,  0x1.774cca52a07abp+421,   -0x1.b1c2cf3091cc4p-2,  -0x1.65e178p-4, INEXACT)
T(RN,  0x1.aa0af392c854ep+421,    0x1.a6230519ef42bp-3,  -0x1.c84e54p-2, INEXACT)
T(RN,  0x1.9eb7d9f7fb738p+421,     0x1.8607b1476141p-1,  -0x1.d37978p-2, INEXACT)
T(RN,  0x1.016ac501cf2a6p+421,   -0x1.9e79efc9c9738p-1,  -0x1.758736p-2, INEXACT)
T(RN,  0x1.0cc04379b9193p+422,    0x1.79fe44aa9e167p-3,  -0x1.8ae192p-2, INEXACT)
T(RN,  0x1.474483a796f12p+422,   -0x1.3baede802f1cdp-2,  -0x1.f84d06p-4, INEXACT)
T(RN,  0x1.b05b77c004abfp+422,    0x1.3940efd26cb9ap-2,  -0x1.647ccep-2, INEXACT)
T(RN,  0x1.41018e5416307p+422,    0x1.f8e28dd06d75cp-2,  -0x1.e331ecp-2, INEXACT)
T(RN,  0x1.885c2673b368bp+422,   -0x1.f12b8e5b3efd6p-5,   0x1.67fd4ep-2, INEXACT)
T(RN,  0x1.e294d1afbbdf4p+422,    0x1.d5cb97245cd53p-1,  -0x1.0e60aep-3, INEXACT)
T(RN,  0x1.24ea0248e1a96p+422,    0x1.513968faa8371p-1,  -0x1.224aaep-2, INEXACT)
T(RN,  0x1.e9839fe5418ccp+422,   -0x1.52f63669ca65bp-1,   -0x1.83678p-2, INEXACT)
T(RN,  0x1.610344a02e56fp+422,   -0x1.4ba0db62e4f82p-2,  -0x1.17438ap-2, INEXACT)
T(RN,  0x1.34f68b0ac60d4p+422,   -0x1.65a57e1015789p-2,   0x1.2674fcp-4, INEXACT)
T(RN,  0x1.bea554934fa58p+423,   -0x1.e7631408a59ecp-2,   0x1.dc9408p-2, INEXACT)
T(RN,  0x1.7d66f7f01f7dep+423,   -0x1.6c082d8125cebp-3,   0x1.d54b96p-3, INEXACT)
T(RN,  0x1.5c4a7cb5c0a02p+423,   -0x1.8d9e069258ab9p-1,   0x1.735c48p-2, INEXACT)
T(RN,  0x1.2810a59bb1f89p+423,   -0x1.18316baca6796p-1,  -0x1.ce6bcap-2, INEXACT)
T(RN,  0x1.d04493c66b6e2p+423,    0x1.2ffb5df4ccb88p-1,  -0x1.5d5d16p-3, INEXACT)
T(RN,  0x1.9e150338cac8ap+423,   -0x1.f047ba90d34d7p-2,  -0x1.960c2ap-4, INEXACT)
T(RN,  0x1.3cd285c6a4d9ep+423,    -0x1.f46222cc2963p-1,  -0x1.e2a9aep-3, INEXACT)
T(RN,  0x1.d071b5b78b787p+423,   -0x1.4759b24e3ba62p-1,   0x1.af3302p-4, INEXACT)
T(RN,  0x1.31ab1fd7098cep+423,   -0x1.744db390ee8a5p-2,   0x1.550906p-9, INEXACT)
T(RN,  0x1.68c0d19bca3d8p+423,   -0x1.382e2045b768fp-3,   0x1.8f698ep-2, INEXACT)
T(RN,  0x1.78b1adfc79d9dp+424,   -0x1.e2b38c3d13123p-1,   0x1.080f74p-3, INEXACT)
T(RN,  0x1.34b2a6a9418eap+424,    0x1.69674296b2be8p-2,  -0x1.8120f2p-5, INEXACT)
T(RN,   0x1.549fb22375d3p+424,    0x1.ce43cee120051p-1,   -0x1.c3834p-2, INEXACT)
T(RN,  0x1.b41bfd5a97df2p+424,   -0x1.01ec12f68aca5p-4,    0x1.2bdc3p-2, INEXACT)
T(RN,  0x1.a04f44dc5bea1p+424,    0x1.f5625065b665dp-1,  -0x1.90c1d6p-4, INEXACT)
T(RN,  0x1.81e54ac313178p+424,   -0x1.a99f9cab5fc1dp-1,    0x1.4f834p-2, INEXACT)
T(RN,  0x1.6aaa9ad71a557p+424,    0x1.66620b9e78c03p-1,  -0x1.edfe5ap-3, INEXACT)
T(RN,  0x1.19d2da78db53cp+424,   -0x1.25bc040e6fdf3p-1,   0x1.22abccp-2, INEXACT)
T(RN,  0x1.ac5e319bbcd88p+424,   -0x1.cce860f28d437p-6,   0x1.38cc96p-2, INEXACT)
T(RN,  0x1.4c7b9d8557beap+424,   -0x1.779989178a649p-1,   0x1.bb7be2p-3, INEXACT)
T(RN,  0x1.23ea28c646cf4p+425,   -0x1.f7f0047e05a49p-1,  -0x1.d00316p-2, INEXACT)
T(RN,  0x1.4988b173b8129p+425,   -0x1.9a6dd3e83d1a2p-1,   0x1.023884p-2, INEXACT)
T(RN,  0x1.80ff478e4c57fp+425,    0x1.384fffcdc6df7p-2,   0x1.54df8cp-2, INEXACT)
T(RN,  0x1.6b379b9d86d4dp+425,    0x1.ae59433da6aebp-1,   0x1.89de52p-4, INEXACT)
T(RN,  0x1.4494fb0523f02p+425,   -0x1.e686e363021f4p-1,   0x1.69c018p-2, INEXACT)
T(RN,  0x1.566fcd2d2f57ep+425,   -0x1.ffd8f8aca4d4bp-1,   0x1.473bdcp-5, INEXACT)
T(RN,  0x1.bef356113e5d7p+425,    0x1.ccc20f450f2e5p-1,   0x1.1e607cp-2, INEXACT)
T(RN,  0x1.7f8b7eadbc655p+425,   -0x1.40e12eb59f385p-1,  -0x1.6bf9b4p-7, INEXACT)
T(RN,  0x1.0e83cdae9231fp+425,    0x1.3840de906ae9fp-2,  -0x1.40d0c2p-8, INEXACT)
T(RN,  0x1.1901a4b8737ccp+425,   -0x1.f106cd4160e0fp-5,  -0x1.8b2e82p-3, INEXACT)
T(RN,  0x1.02eb24fcf9179p+426,   -0x1.47eba6aa262a9p-1,   0x1.ed1176p-2, INEXACT)
T(RN,  0x1.a42a14a7adb8cp+426,   -0x1.9fe4d7d13f5cfp-1,   0x1.582fbep-3, INEXACT)
T(RN,  0x1.9f7e61ae54ba4p+426,    -0x1.bc2f3b6ced35p-3,  -0x1.8e0accp-2, INEXACT)
T(RN,  0x1.ed940b92813cep+426,   -0x1.6a62f199a5faap-1,   0x1.70fbdep-2, INEXACT)
T(RN,  0x1.3ec69db63232ep+426,    0x1.51cc8b050d517p-1,  -0x1.2b64d6p-4, INEXACT)
T(RN,  0x1.1669ad215498cp+426,    0x1.c3522240bd3b7p-1,    0x1.40f7cp-3, INEXACT)
T(RN,  0x1.b46b1e27ebde5p+426,    0x1.aa22ed35cbac6p-1,   0x1.21efeap-2, INEXACT)
T(RN,  0x1.ec22611c258a2p+426,   -0x1.319260e396168p-3,  -0x1.32e8dep-3, INEXACT)
T(RN,  0x1.6d2d9e538c61dp+426,    0x1.75a6f4d45d6dfp-1,   0x1.5f33cep-3, INEXACT)
T(RN,  0x1.08697e6c8d044p+426,    0x1.f7bc424616693p-7,  -0x1.2d3ac6p-2, INEXACT)
T(RN,  0x1.5e2163312acdbp+427,    0x1.20f27e77cb5bbp-1,  -0x1.d17afep-2, INEXACT)
T(RN,  0x1.f109cdf0b9484p+427,     0x1.61239bd9e722p-2,   0x1.fc192cp-2, INEXACT)
T(RN,  0x1.70e74b59027a4p+427,   -0x1.2621a4a8a0424p-1,  -0x1.84fdbap-2, INEXACT)
T(RN,  0x1.a62b9a186d282p+427,      0x1.918d50f2d5ap-2,  -0x1.d4c434p-4, INEXACT)
T(RN,   0x1.572845e36c42p+427,    0x1.54d2748300ce5p-1,  -0x1.427834p-3, INEXACT)
T(RN,  0x1.100b57294c7a3p+427,   -0x1.5d794b4279a33p-1,   0x1.2e1d3ap-3, INEXACT)
T(RN,  0x1.86b760f74c798p+427,   -0x1.a2a964ad2c929p-3,  -0x1.8dcc68p-3, INEXACT)
T(RN,  0x1.f536aeb85f774p+427,    0x1.560adb9b177dfp-5,  -0x1.eec828p-3, INEXACT)
T(RN,  0x1.9b4556df4b90cp+427,    0x1.a258b8814c48cp-1,   0x1.2bed48p-3, INEXACT)
T(RN,  0x1.a479054d1e8bep+427,   -0x1.48c35be23d558p-1,   0x1.906756p-3, INEXACT)
T(RN,  0x1.def7f33abf8d4p+428,    0x1.b0b7675b1d8eep-1,  -0x1.426246p-2, INEXACT)
T(RN,  0x1.eaa8b55fb0d11p+428,    0x1.ba857250c16ddp-1,    0x1.a8e88p-2, INEXACT)
T(RN,  0x1.8df288a95aca2p+428,     0x1.fe5678b5aa26p-1,  -0x1.3c26e2p-6, INEXACT)
T(RN,  0x1.c6b783f86880ap+428,    0x1.c87edd606a478p-2,   0x1.8da0d4p-2, INEXACT)
T(RN,  0x1.768bdf993caeep+428,    0x1.67cdb9b9aa09fp-2,  -0x1.fabd0cp-3, INEXACT)
T(RN,  0x1.2e728af3be9f9p+428,    0x1.1d0a3b41f40edp-1,   0x1.16e65cp-7, INEXACT)
T(RN,  0x1.e7bd7459f2926p+428,     0x1.573eea42319dp-4,   -0x1.4bccfp-4, INEXACT)
T(RN,  0x1.e28cb5a0cfa88p+428,    0x1.fd8243840978ap-1,    0x1.bb39fp-2, INEXACT)
T(RN,  0x1.106975604746cp+428,   -0x1.fa9c4451bfb49p-2,  -0x1.f947d4p-2, INEXACT)
T(RN,  0x1.aad68ae24b022p+428,   -0x1.ec9d6839492fap-1,  -0x1.8bbd92p-3, INEXACT)
T(RN,  0x1.d73aa62855e17p+429,     0x1.ae08d08eb449p-1,   -0x1.2fea8p-2, INEXACT)
T(RN,  0x1.b751794eac154p+429,    0x1.26aec63df07f9p-1,  -0x1.de2118p-2, INEXACT)
T(RN,  0x1.55ed6693b07edp+429,    0x1.c425bb54ff3e3p-3,  -0x1.b412b4p-3, INEXACT)
T(RN,  0x1.4c62e0f727615p+429,   -0x1.fb3ae47362446p-1,   0x1.f2eda2p-2, INEXACT)
T(RN,  0x1.cb98738bdd741p+429,   -0x1.ff93076dec825p-1,  -0x1.976af4p-7, INEXACT)
T(RN,  0x1.d025d91f88308p+429,   -0x1.7b0a93da284c9p-2,  -0x1.3ef4ccp-3, INEXACT)
T(RN,  0x1.bc4b0bdd709cap+429,    0x1.4bde9ed5cce08p-1,    0x1.a623cp-2, INEXACT)
T(RN,  0x1.014a1b70a2376p+429,    0x1.ba7d19335b76fp-1,   -0x1.c651ep-2, INEXACT)
T(RN,  0x1.abfeb9f7e9724p+429,   -0x1.a4bb1451bd61ap-4,   0x1.16a954p-3, INEXACT)
T(RN,  0x1.cfbb4000b6b8ep+429,    0x1.ff96f399e7954p-1,  -0x1.aec7eap-2, INEXACT)
T(RN,  0x1.64b127680dad9p+430,    0x1.51bf5f93700b1p-2,   0x1.c0c982p-3, INEXACT)
T(RN,  0x1.cc8c65762b389p+430,   -0x1.04610e2f35017p-2,  -0x1.b73f7ep-2, INEXACT)
T(RN,  0x1.62789271ae2b3p+430,   -0x1.8ac4eabff857cp-1,  -0x1.762f54p-2, INEXACT)
T(RN,   0x1.f5693f0e8045p+430,   -0x1.a3e0463436234p-1,   0x1.0547f6p-3, INEXACT)
T(RN,  0x1.9379572bf3351p+430,   -0x1.3179572c90b17p-1,  -0x1.3ef8eep-2, INEXACT)
T(RN,  0x1.ac037b4082621p+430,    0x1.f87a96f85c3e6p-1,  -0x1.31904cp-2, INEXACT)
T(RN,  0x1.07ff3a63fff47p+430,   -0x1.f0508ed9c2625p-3,  -0x1.4bff9ap-3, INEXACT)
T(RN,  0x1.1c59a7a0c3368p+430,    0x1.01f8bcb51b357p-2,  -0x1.01ec3ap-2, INEXACT)
T(RN,  0x1.93ad27ee056bbp+430,    0x1.90b545c3fc8cap-2,   -0x1.b3d5fp-2, INEXACT)
T(RN,  0x1.f663ea434a91ep+430,   -0x1.d1179892ff315p-1,   0x1.05b0b2p-3, INEXACT)
T(RN,  0x1.df46144d4b987p+431,    0x1.0627fb6461828p-2,   -0x1.36054p-4, INEXACT)
T(RN,  0x1.f4e69202189e4p+431,   -0x1.312381d5ac2c1p-2,  -0x1.911af4p-9, INEXACT)
T(RN,  0x1.0ed7bfffc8d5dp+431,    0x1.b7d1ac7619524p-1,  -0x1.266cc2p-2, INEXACT)
T(RN,  0x1.a137252634a61p+431,    0x1.ea14cf7542a1fp-1,   0x1.98330ep-2, INEXACT)
T(RN,  0x1.fbb1dc4c7bc64p+431,    0x1.d5fc936699c86p-2,   0x1.3e3e76p-3, INEXACT)
T(RN,  0x1.2ee230cbd9c62p+431,    0x1.757976efb6766p-4,  -0x1.ed9328p-5, INEXACT)
T(RN,   0x1.8af426967254p+431,   -0x1.ed30c948034e5p-3,    0x1.07cf9p-2, INEXACT)
T(RN,  0x1.3345df3c03bbep+431,   -0x1.90864375e8467p-1,  -0x1.2505eep-2, INEXACT)
T(RN,  0x1.c3e758e278a19p+431,   -0x1.29e4335c9c37fp-3,    0x1.e9d5cp-2, INEXACT)
T(RN,  0x1.bdb1d997ca2b8p+431,   -0x1.f662e9a01e76cp-3,   0x1.ee7ecep-7, INEXACT)
T(RN,  0x1.099fafd6d61b7p+432,    -0x1.e718457080d3p-1,   0x1.33b81ap-2, INEXACT)
T(RN,  0x1.ee7eb16539556p+432,   -0x1.fbe828150cebep-1,    0x1.418b9p-2, INEXACT)
T(RN,  0x1.6e9506d91b7b9p+432,    0x1.2ee3a6c6eac25p-2,   -0x1.851d5p-4, INEXACT)
T(RN,  0x1.3871a5faf3f6fp+432,    0x1.edefbc4da33a4p-1,   0x1.129bf4p-4, INEXACT)
T(RN,   0x1.4fd64e0d935cp+432,    0x1.e404a89a4900ep-1,   -0x1.bb204p-2, INEXACT)
T(RN,  0x1.648c448850aa6p+432,    0x1.c60ccfee05495p-1,   0x1.269f2ap-4, INEXACT)
T(RN,  0x1.567c872041fa8p+432,   -0x1.6e208bb9d1032p-2,   0x1.22db32p-3, INEXACT)
T(RN,  0x1.02a445c2ebf69p+432,   -0x1.b85e85cade667p-1,   0x1.a68a34p-7, INEXACT)
T(RN,  0x1.767699ac26c42p+432,   -0x1.8968576f15655p-2,  -0x1.39bf5cp-3, INEXACT)
T(RN,  0x1.b98d5b21fb1bcp+432,    0x1.b5e4e70d9acebp-2,    0x1.b152ep-2, INEXACT)
T(RN,  0x1.05c7048574798p+433,   -0x1.f7b131d5be41bp-1,  -0x1.297016p-5, INEXACT)
T(RN,  0x1.5d99969a4ccccp+433,   -0x1.fc00395863183p-1,    0x1.1b01bp-2, INEXACT)
T(RN,  0x1.1c0340cb1f527p+433,   -0x1.38d52fe7e34ddp-2,    -0x1.fb17p-4, INEXACT)
T(RN,  0x1.6a3ccac663314p+433,    0x1.a59d7a02eb46dp-2,  -0x1.85f512p-2, INEXACT)
T(RN,  0x1.ef163db337f76p+433,    0x1.fef2173738b17p-5,   0x1.ace08cp-3, INEXACT)
T(RN,  0x1.4dc748bc702abp+433,    0x1.ea6d287f3a2dep-2,    0x1.ba068p-4, INEXACT)
T(RN,  0x1.367a4bd1ff9e7p+433,   -0x1.20fdc3fdedf9ap-3,   0x1.2e7d54p-2, INEXACT)
T(RN,  0x1.33ed900ab712ap+433,    0x1.f796f91a1c611p-2,  -0x1.e60974p-2, INEXACT)
T(RN,  0x1.c7130302d51ecp+433,    0x1.810c9679464b6p-1,  -0x1.3ba19ap-3, INEXACT)
T(RN,   0x1.ee7fa8c05f54p+433,     0x1.eddc00341979p-1,   0x1.6d652cp-2, INEXACT)
T(RN,  0x1.ae0487f48dcaep+434,   -0x1.9a595d8a93b77p-2,   0x1.1154f2p-2, INEXACT)
T(RN,  0x1.a0a73730a615bp+434,   -0x1.9ee1a2d6a3513p-2,    0x1.36bf3p-2, INEXACT)
T(RN,  0x1.10ce0a5aa9c46p+434,    0x1.4c071558882e1p-3,    0x1.968afp-2, INEXACT)
T(RN,  0x1.776b40cc81637p+434,   -0x1.6c0ad577445c5p-1,   0x1.3332eep-4, INEXACT)
T(RN,  0x1.7a5903fa13b72p+434,   -0x1.f5d944657955fp-1,   -0x1.a3c69p-2, INEXACT)
T(RN,  0x1.ca6ddbd74c28ap+434,   -0x1.084f15ab6ffbfp-1,  -0x1.bbae3cp-2, INEXACT)
T(RN,  0x1.3982a3ed0931ep+434,    0x1.7e45e0583d289p-1,    0x1.0226fp-2, INEXACT)
T(RN,  0x1.5578744917538p+434,    0x1.3499884370d7fp-1,  -0x1.ccb63ep-3, INEXACT)
T(RN,  0x1.4d430371f1678p+434,   -0x1.d0d73529477ebp-1,   -0x1.21761p-6, INEXACT)
T(RN,  0x1.491b65ad33361p+434,    0x1.20c4c205b06d8p-2,   0x1.7ebf4ap-5, INEXACT)
T(RN,  0x1.783b088cf7b27p+435,   -0x1.e4835f9bd8e48p-1,   0x1.acf036p-3, INEXACT)
T(RN,   0x1.c5ef524ebefdp+435,   -0x1.e707eb8e09e8ap-1,   0x1.782e66p-3, INEXACT)
T(RN,  0x1.1d1ab956712bbp+435,    0x1.752ca0ef43a07p-2,  -0x1.b5c55ep-2, INEXACT)
T(RN,  0x1.1950488f42eaep+435,    -0x1.642414e023f1p-2,   0x1.1e5e0ep-2, INEXACT)
T(RN,  0x1.2eb224c374ed9p+435,    0x1.540da79a9a1a9p-1,  -0x1.526014p-2, INEXACT)
T(RN,  0x1.38076c51f2674p+435,    0x1.ea3b45d5205dfp-6,  -0x1.2afbf2p-2, INEXACT)
T(RN,  0x1.10b7993cb4009p+435,    0x1.ffba37b6df607p-1,   -0x1.79324p-4, INEXACT)
T(RN,  0x1.b5cb7b4298c84p+435,    0x1.dd4e72eb01dcap-1,  -0x1.6ae86cp-4, INEXACT)
T(RN,   0x1.4da0b7e98fd5p+435,    0x1.929a4defc5679p-1,   0x1.bad17cp-6, INEXACT)
T(RN,  0x1.521bfd4ecb7f3p+435,    0x1.2787bb1527554p-2,  -0x1.f38528p-2, INEXACT)
T(RN,  0x1.980a42900dda4p+436,   -0x1.f5837144fe275p-1,   0x1.d9ceccp-2, INEXACT)
T(RN,  0x1.7f7a1ffad05ccp+436,    0x1.2043c85ae11a4p-2,   0x1.244abcp-6, INEXACT)
T(RN,  0x1.99eb7409def44p+436,   -0x1.5d8ec1ccf777bp-1,   0x1.b3d48ep-2, INEXACT)
T(RN,  0x1.ec567c32f4f4ep+436,    0x1.a3e5b9da0ef61p-1,   0x1.f14148p-2, INEXACT)
T(RN,  0x1.ca9e0ea7fd728p+436,    0x1.67b8e6f6be19ep-1,  -0x1.b59fd2p-3, INEXACT)
T(RN,   0x1.966186442c0cp+436,    0x1.2464b458d9f83p-1,  -0x1.6047dcp-2, INEXACT)
T(RN,  0x1.8dd012de5e8aep+436,    0x1.5d438c7c43c3ap-1,  -0x1.4f300ep-3, INEXACT)
T(RN,  0x1.efef131e010cap+436,    0x1.c53f7cfd251eap-1,   -0x1.22315p-3, INEXACT)
T(RN,  0x1.ebd435641110cp+436,    0x1.fe829632691f5p-1,   0x1.915236p-2, INEXACT)
T(RN,  0x1.6034c8113077ap+436,   -0x1.cdbba74c00becp-1,  -0x1.5730f6p-3, INEXACT)
T(RN,  0x1.3e4fd99008fb5p+437,    0x1.d8a7016a7913fp-1,  -0x1.b6955ap-3, INEXACT)
T(RN,  0x1.9fc5ef34bc593p+437,    0x1.645c58219e2b2p-3,   0x1.343068p-2, INEXACT)
T(RN,   0x1.4805d7f05937p+437,   -0x1.a2e54eb0e0009p-3,   0x1.057832p-6, INEXACT)
T(RN,  0x1.47115e7bfda94p+437,   -0x1.118fbf61cc45fp-1,  -0x1.3e46cap-2, INEXACT)
T(RN,  0x1.91fc2c9ac0262p+437,   -0x1.b198fa3ca455ep-2,  -0x1.27f52ep-3, INEXACT)
T(RN,  0x1.e74169e1068f4p+437,    0x1.fa554c91dd059p-4,   0x1.294974p-2, INEXACT)
T(RN,  0x1.119d1441743eep+437,    0x1.a4b64e69d3b9bp-2,   0x1.612adep-3, INEXACT)
T(RN,  0x1.925171811c3cap+437,   -0x1.d9abaac8323f1p-1,  -0x1.c48ffap-3, INEXACT)
T(RN,  0x1.c656e2b5a39f4p+437,   -0x1.a4811a048d624p-1,   0x1.932dfap-2, INEXACT)
T(RN,  0x1.ad780014d37a8p+437,    0x1.c442b6cdcd1a2p-3,  -0x1.5d69bap-2, INEXACT)
T(RN,  0x1.94e688608d0d2p+438,    0x1.680b0c515a17bp-1,    0x1.ca577p-5, INEXACT)
T(RN,  0x1.57dc73ebdc35ep+438,   -0x1.9df868dbc3eb8p-1,    0x1.10b05p-2, INEXACT)
T(RN,  0x1.474a0aa3838b8p+438,   -0x1.1825a230a47b5p-1,  -0x1.174f06p-2, INEXACT)
T(RN,  0x1.1b52f25d2edf8p+438,    0x1.f5d136aa3da66p-1,   0x1.034a52p-4, INEXACT)
T(RN,  0x1.31566a0e66279p+438,    0x1.34ad68b473606p-1,   0x1.0d579ep-5, INEXACT)
T(RN,  0x1.ae5f410fa9602p+438,    0x1.fdcb4d01ca25fp-1,   0x1.22eddap-4, INEXACT)
T(RN,  0x1.e5d81da6afdd4p+438,    0x1.292e9fdebc771p-2,  -0x1.16d73ep-3, INEXACT)
T(RN,  0x1.657d407ddee1ep+438,   -0x1.b44d11cc2f2eep-1,   0x1.b47388p-2, INEXACT)
T(RN,  0x1.26626e8d5a45ap+438,     0x1.85fe8ee7a878p-3,  -0x1.884904p-2, INEXACT)
T(RN,  0x1.76d0d746ad60dp+438,     0x1.fa18f35d84adp-1,   0x1.f6cf62p-5, INEXACT)
T(RN,  0x1.df120ae3b5a7dp+439,    0x1.b287d5b93d3cbp-2,  -0x1.77fad4p-3, INEXACT)
T(RN,  0x1.9bfea54628925p+439,    0x1.ff05b8a4f4f51p-1,   0x1.66340cp-4, INEXACT)
T(RN,  0x1.2c5e454395c9ep+439,    0x1.a57ae2b98e777p-1,  -0x1.ca0f58p-3, INEXACT)
T(RN,  0x1.60db229ee796ep+439,   -0x1.42b65a3022b16p-1,   0x1.68d73ap-3, INEXACT)
T(RN,  0x1.e9aa84a8732f9p+439,   -0x1.bfac8b9b04d46p-1,   0x1.2ce224p-9, INEXACT)
T(RN,  0x1.5ae8598cff1c4p+439,    0x1.7d307c7e0e1bep-1,  -0x1.f2dfccp-8, INEXACT)
T(RN,  0x1.52208863c5294p+439,    0x1.7bb2f33283275p-2,  -0x1.5ed58cp-4, INEXACT)
T(RN,  0x1.c25c8b3c6d31ep+439,    0x1.58be7abe22c16p-1,  -0x1.c28f06p-2, INEXACT)
T(RN,  0x1.79806ae2a520bp+439,    0x1.f915762c33568p-1,    0x1.48687p-4, INEXACT)
T(RN,  0x1.3bd97389e980ep+439,   -0x1.bc5a3b67c0806p-1,   0x1.2d24bep-2, INEXACT)
T(RN,  0x1.ed86be33e63f4p+440,    0x1.4d36a43272b77p-2,   0x1.b61e12p-2, INEXACT)
T(RN,  0x1.d547353f74b28p+440,   -0x1.1745b2548326dp-3,   -0x1.c399cp-4, INEXACT)
T(RN,  0x1.9c3a638f31948p+440,    0x1.6d2dfd29b0685p-1,  -0x1.b7b2bap-2, INEXACT)
T(RN,   0x1.7f50612da5a5p+440,    0x1.60dd39e1f7999p-2,  -0x1.830cfap-2, INEXACT)
T(RN,  0x1.e4c25fc3f29bbp+440,   -0x1.451e2fdbdc9a5p-1,  -0x1.ecd75ep-2, INEXACT)
T(RN,  0x1.27fa8f01c3a47p+440,    0x1.2845afbe94b34p-3,   0x1.311906p-2, INEXACT)
T(RN,  0x1.25e69ada0720ep+440,    0x1.ac40b8a90f753p-1,   0x1.09407cp-3, INEXACT)
T(RN,   0x1.b3e1e2052db4p+440,    0x1.f67adcda5b7c6p-1,  -0x1.819d94p-2, INEXACT)
T(RN,  0x1.b8ce51337fa0fp+440,   -0x1.c2f140b25c6e4p-1,   0x1.be7ed8p-2, INEXACT)
T(RN,  0x1.057bc5408a503p+440,    0x1.de20c14f6fe5fp-1,  -0x1.9aee28p-6, INEXACT)
T(RN,  0x1.109d77d02b8e2p+441,   -0x1.75c8cdd91f97ep-1,   0x1.20dbeap-7, INEXACT)
T(RN,  0x1.01ffbf38acad3p+441,    0x1.0e75037397c76p-1,  -0x1.b80fa8p-2, INEXACT)
T(RN,  0x1.43221e4438226p+441,   -0x1.964b19c72a409p-2,   0x1.fd8386p-3, INEXACT)
T(RN,  0x1.364a108fad295p+441,   -0x1.6c2bdc203cba4p-1,  -0x1.9ddd9p-11, INEXACT)
T(RN,  0x1.d4d9170e2afccp+441,    0x1.c7168169a188cp-1,  -0x1.e93004p-3, INEXACT)
T(RN,  0x1.5d7fc4ec44c33p+441,    0x1.c41fbaf36a12ep-2,   0x1.efb288p-3, INEXACT)
T(RN,  0x1.7c9fae084b292p+441,   -0x1.d8cab2af1500cp-1,    0x1.3c315p-3, INEXACT)
T(RN,  0x1.3e48bd05e716fp+441,    0x1.89ee3ba225587p-1,   0x1.60c812p-3, INEXACT)
T(RN,  0x1.ccccc94b04adfp+441,    0x1.df5f80e5206a8p-2,   0x1.0748bap-2, INEXACT)
T(RN,  0x1.e68667174e845p+441,   -0x1.b571b01615d6bp-2,   0x1.a57184p-5, INEXACT)
T(RN,  0x1.19ce0e30bde87p+442,    0x1.f4f9a038f7361p-1,   0x1.c50b04p-2, INEXACT)
T(RN,  0x1.7153647efb017p+442,   -0x1.d8d11214d8c2cp-3,   0x1.b1d0c6p-2, INEXACT)
T(RN,  0x1.604d0ebc8cc93p+442,    0x1.f3cb1e44bb58ap-1,  -0x1.4dff1cp-3, INEXACT)
T(RN,  0x1.785ad561d3aecp+442,   -0x1.e84c68bd550efp-4,   0x1.7afa88p-2, INEXACT)
T(RN,  0x1.ee09d1cfce0fcp+442,   -0x1.d4e9d6667c8e1p-1,  -0x1.93fe5ap-2, INEXACT)
T(RN,  0x1.74415e2c29458p+442,   -0x1.5399b9fdff9c3p-1,   0x1.d7da64p-3, INEXACT)
T(RN,  0x1.be5bda7084702p+442,   -0x1.ac2cda11c7357p-2,  -0x1.1afb54p-2, INEXACT)
T(RN,  0x1.a4a01c441c5ecp+442,   -0x1.0ad3db3778014p-2,   -0x1.3040cp-2, INEXACT)
T(RN,  0x1.e5bceec9f96c3p+442,   -0x1.6546148bc3eb3p-1,  -0x1.b1e3eap-5, INEXACT)
T(RN,  0x1.6c8d09fefba31p+442,    0x1.8fcd6fd1f2636p-1,  -0x1.811644p-2, INEXACT)
T(RN,  0x1.d827a55aac12cp+443,   -0x1.1cfe5844afb7fp-3,   0x1.4bf1aep-5, INEXACT)
T(RN,   0x1.8164b18f5662p+443,   -0x1.ffbbb61731d3bp-1,  -0x1.afae04p-2, INEXACT)
T(RN,  0x1.6e6df969b2a24p+443,   -0x1.256db0f725513p-4,  -0x1.5ecba8p-3, INEXACT)
T(RN,  0x1.341e4eb145e61p+443,    0x1.a567d87aceabdp-1,  -0x1.3a4c58p-2, INEXACT)
T(RN,   0x1.47d9a5b6b4f7p+443,   -0x1.a8e42a4d2dd5cp-1,   0x1.77cdbcp-5, INEXACT)
T(RN,  0x1.f0f538fddfc46p+443,    0x1.f44d9c6fa28b6p-1,   -0x1.f3c9cp-2, INEXACT)
T(RN,  0x1.297052b4179aep+443,   -0x1.357244259c075p-2,  -0x1.d4722ap-7, INEXACT)
T(RN,  0x1.049f84fe2267ap+443,   -0x1.ab1a9edaf8795p-4,  -0x1.5c6e7cp-2, INEXACT)
T(RN,  0x1.921ea3f9aaacep+443,   -0x1.94d492c69d3e7p-1,  -0x1.a705bep-3, INEXACT)
T(RN,  0x1.be7171bc0884ap+443,   -0x1.2813dc6f887d4p-5,   0x1.321204p-4, INEXACT)
T(RN,  0x1.2e635aa85343ep+444,    -0x1.b4e53b3da10fp-3,  -0x1.a700dep-2, INEXACT)
T(RN,  0x1.02701d18b5036p+444,   -0x1.3ea11a8919285p-1,   0x1.2ba74ap-3, INEXACT)
T(RN,  0x1.158ae0e586e09p+444,    0x1.28113e24915ebp-1,   0x1.11b8c2p-3, INEXACT)
T(RN,  0x1.8eb8a7c64acc8p+444,   -0x1.769f615175dccp-2,   0x1.701a5ep-3, INEXACT)
T(RN,  0x1.9818d554625f2p+444,    -0x1.ca75fec96c58p-1,  -0x1.cde82cp-6, INEXACT)
T(RN,   0x1.3c6ca1e8f36bp+444,   -0x1.f034b000583b2p-1,   0x1.bb3da6p-7, INEXACT)
T(RN,  0x1.adfad27997b6bp+444,    0x1.ee0ccdd0ebd45p-1,   0x1.182322p-7, INEXACT)
T(RN,  0x1.2327264c63ef2p+444,   -0x1.d71153caf49e8p-1,   0x1.ebe9c6p-2, INEXACT)
T(RN,  0x1.447faf644e0f8p+444,   -0x1.8378cc490709cp-1,   0x1.f6f72ep-2, INEXACT)
T(RN,  0x1.e014415bc656ap+444,    0x1.eff7f780956cap-1,  -0x1.c0e524p-2, INEXACT)
T(RN,  0x1.d729c55be3e2fp+445,   -0x1.e66edd0e2ac0ap-4,   0x1.43e222p-2, INEXACT)
T(RN,  0x1.630e00997591cp+445,   -0x1.8a8aa463ee422p-2,  -0x1.37091ap-2, INEXACT)
T(RN,  0x1.499221fdb46acp+445,   -0x1.952008ca637cdp-1,   0x1.15e746p-3, INEXACT)
T(RN,  0x1.ecd12fd6eb3e4p+445,   -0x1.17e5186316589p-1,   0x1.ad162ep-8, INEXACT)
T(RN,  0x1.43ad33503721ap+445,    0x1.e14297c8b67b2p-1,  -0x1.4b1ee2p-3, INEXACT)
T(RN,  0x1.e2e5da17abb04p+445,    0x1.cdab3ae1862adp-1,   0x1.d945bep-5, INEXACT)
T(RN,   0x1.edc975f49b09p+445,    0x1.f64588869bf43p-1,  -0x1.faae7ep-2, INEXACT)
T(RN,  0x1.f233e60ae3a96p+445,   -0x1.23f1276acb5cbp-1,   -0x1.27c7bp-2, INEXACT)
T(RN,  0x1.e6d10eb0e00bap+445,    0x1.dad90a26f27d2p-1,    0x1.f5bc3p-3, INEXACT)
T(RN,  0x1.3fe4bab2eab84p+445,    0x1.8aace931ccbb9p-1,   0x1.14173ep-2, INEXACT)
T(RN,  0x1.799e768f35822p+446,    0x1.62f99986d2538p-2,  -0x1.5d73c4p-2, INEXACT)
T(RN,  0x1.f0b87bf603c0ap+446,     0x1.fcd902923a2bp-1,  -0x1.523e26p-3, INEXACT)
T(RN,  0x1.951e5a21a7bddp+446,    0x1.4b58dd043a9c1p-1,  -0x1.2915c2p-7, INEXACT)
T(RN,  0x1.a925850d7bba3p+446,   -0x1.16a54caf6b22ap-1,    0x1.26081p-2, INEXACT)
T(RN,  0x1.c566673a727ecp+446,   -0x1.4a95f0db42472p-1,  -0x1.a29d34p-2, INEXACT)
T(RN,  0x1.fe84fa1d4f6d4p+446,    0x1.c34d5870bfa08p-1,  -0x1.d2830cp-4, INEXACT)
T(RN,   0x1.a94a028dab3ep+446,    0x1.3953a721481cap-2,   0x1.78bef6p-3, INEXACT)
T(RN,  0x1.21821be702ea2p+446,   -0x1.6ca53adbf5a0ap-2,   0x1.51effep-2, INEXACT)
T(RN,  0x1.457570f244ca4p+446,   -0x1.eb5fbbd58e8e1p-3,  -0x1.e97c8ap-2, INEXACT)
T(RN,  0x1.e94dfc57a9d0dp+446,    0x1.dc39fa864df6dp-1,     0x1.09c5p-5, INEXACT)
T(RN,   0x1.9ee16b59244bp+447,   -0x1.1a2c188e99557p-2,  -0x1.40b25cp-2, INEXACT)
T(RN,   0x1.aae290bf4428p+447,   -0x1.f2182932b9886p-1,   0x1.1aebfcp-5, INEXACT)
T(RN,  0x1.ecb1445d6767ap+447,    0x1.41297dce5fc31p-3,  -0x1.c0ee2ep-2, INEXACT)
T(RN,  0x1.13b6e7c73cbf7p+447,    -0x1.0291125e2298p-7,   0x1.3dd076p-6, INEXACT)
T(RN,  0x1.85ecfc54559adp+447,    0x1.fb30ddc14201ep-1,   0x1.a7559ep-2, INEXACT)
T(RN,   0x1.0b64fb2ffafcp+447,    0x1.772735b068595p-3,   0x1.27b964p-3, INEXACT)
T(RN,  0x1.337642fa8f827p+447,    0x1.a0c6096f8cdfbp-1,   0x1.083862p-3, INEXACT)
T(RN,  0x1.2d5dc5761bb1dp+447,     0x1.00e1c905830ep-1,  -0x1.bd5df4p-2, INEXACT)
T(RN,  0x1.e9ee788149fbep+447,   -0x1.eef14a93e9b84p-1,   0x1.f77bccp-2, INEXACT)
T(RN,  0x1.c8e55eb9421fep+447,   -0x1.729cb482e2517p-1,  -0x1.215a48p-2, INEXACT)
T(RN,  0x1.8d46464bf682ap+448,    0x1.7eee41689f4c1p-2,   0x1.a3b032p-3, INEXACT)
T(RN,  0x1.9790703c351f4p+448,   -0x1.aafc9bdb64a0cp-2,  -0x1.a8970ap-2, INEXACT)
T(RN,  0x1.403e88b056d7bp+448,   -0x1.d393a013d0e3bp-1,    0x1.7530ap-2, INEXACT)
T(RN,  0x1.8283731ad6ca3p+448,    0x1.d7dfdf58f3f24p-1,  -0x1.4dfa7cp-4, INEXACT)
T(RN,  0x1.fbd65cbc8a4dep+448,    0x1.edf6500e6bc6dp-1,  -0x1.93b996p-3, INEXACT)
T(RN,  0x1.8bb37cf993266p+448,    0x1.fa434f6701383p-1,   0x1.11d234p-2, INEXACT)
T(RN,  0x1.472c9c940909cp+448,   -0x1.a6da0e70bc76ep-1,  -0x1.3c73f6p-4, INEXACT)
T(RN,  0x1.8ed4635ed4b06p+448,    0x1.090d348c96331p-3,  -0x1.bd7774p-2, INEXACT)
T(RN,  0x1.b5208b0a5edd2p+448,    0x1.fcbca801cc2a3p-1,  -0x1.05e994p-2, INEXACT)
T(RN,  0x1.7531aa2d6f982p+448,   -0x1.8a6952247e1cfp-2,   0x1.1f0c32p-3, INEXACT)
T(RN,   0x1.6121f3419897p+449,   -0x1.fd5e795ade08bp-4,   0x1.861fccp-2, INEXACT)
T(RN,  0x1.13ab471bd31d9p+449,    0x1.b6c8b236191f5p-2,   -0x1.118cdp-5, INEXACT)
T(RN,  0x1.8a69f6e463888p+449,    0x1.aa84cb9b1b25bp-1,   -0x1.60a9bp-3, INEXACT)
T(RN,  0x1.c1704ec38c176p+449,   -0x1.b1c7c5b56883ap-1,  -0x1.e939aap-2, INEXACT)
T(RN,  0x1.e15d50582f81cp+449,   -0x1.f8de75b82e60ap-1,  -0x1.8ba31cp-2, INEXACT)
T(RN,  0x1.3e5b179fc60fcp+449,   -0x1.883d6a90d3b65p-1,   -0x1.7a20ep-7, INEXACT)
T(RN,  0x1.81ff1a47336ddp+449,   -0x1.28ebffec8fb7bp-1,   0x1.27a152p-2, INEXACT)
T(RN,  0x1.0980206f483f6p+449,    0x1.edb7aea2ec87cp-1,  -0x1.b258d8p-2, INEXACT)
T(RN,  0x1.d6250508559e8p+449,   -0x1.604c0c61d8171p-2,   0x1.e43796p-3, INEXACT)
T(RN,  0x1.812efcd87f61cp+449,    0x1.e7cd6aea019b9p-1,  -0x1.0b5f08p-2, INEXACT)
T(RN,  0x1.a7e5752a08f12p+450,   -0x1.641715729692ep-1,  -0x1.72290ap-2, INEXACT)
T(RN,  0x1.acfa849a17b5ap+450,    0x1.daecb19778d09p-1,    0x1.a7bf2p-2, INEXACT)
T(RN,  0x1.65497e7927218p+450,   -0x1.1b73cc739bddap-2,  -0x1.2acaeep-2, INEXACT)
T(RN,  0x1.dfbe766f4b721p+450,    0x1.d23bb54243dbep-2,   0x1.e92d5ap-2, INEXACT)
T(RN,  0x1.d5b550b6dd061p+450,   -0x1.7e809607372c9p-1,   0x1.e82f56p-2, INEXACT)
T(RN,  0x1.da4208b625328p+450,     0x1.6cf02ab35e04p-1,  -0x1.79d722p-2, INEXACT)
T(RN,  0x1.99e352a12ed52p+450,    0x1.bcc7ea3e13b1ap-1,   0x1.5480c4p-3, INEXACT)
T(RN,  0x1.d676a6fd88ed4p+450,    0x1.d46178e48be7fp-1,   0x1.e0b728p-3, INEXACT)
T(RN,  0x1.717ab467794f6p+450,   -0x1.9aed1320348e2p-3,   0x1.938026p-4, INEXACT)
T(RN,  0x1.75ac8175d596ep+450,    0x1.3041a0129eca4p-2,   0x1.08ea5ep-3, INEXACT)
T(RN,  0x1.e349ddf26c086p+451,    0x1.f70280ed8d3dcp-1,   0x1.8c2deep-3, INEXACT)
T(RN,  0x1.952678107ee6bp+451,   -0x1.e6e5eaf67aa74p-5,   0x1.e8f1a4p-2, INEXACT)
T(RN,  0x1.be2125afd5498p+451,   -0x1.b4882ba5b020dp-2,   0x1.41aac8p-2, INEXACT)
T(RN,  0x1.95c6d71d6605bp+451,    0x1.edbaeb59bc568p-1,  -0x1.a0f0bep-2, INEXACT)
T(RN,   0x1.e0add05730bcp+451,    0x1.5b980e0225a56p-1,  -0x1.1dc9c8p-6, INEXACT)
T(RN,   0x1.3a6509566d5ap+451,    0x1.ffc6c0e7bfebep-1,  -0x1.8a28e2p-2, INEXACT)
T(RN,  0x1.6773a53397d41p+451,     0x1.f7dcf63425dap-1,  -0x1.edc8cap-2, INEXACT)
T(RN,  0x1.0358cc4f79cf5p+451,     0x1.ee2550f03a57p-1,  -0x1.e8c094p-2, INEXACT)
T(RN,  0x1.c46896ecfa114p+451,   -0x1.e13895f77ca76p-3,   0x1.57e9dap-5, INEXACT)
T(RN,  0x1.e4348b12d21aep+451,    0x1.2f9bed8131b31p-1,  -0x1.077ad8p-2, INEXACT)
T(RN,  0x1.c6d45e0c60f86p+452,   -0x1.62f8e99466703p-1,  -0x1.4c7b94p-6, INEXACT)
T(RN,  0x1.dd0bcee7e4a92p+452,    0x1.3c6c58ce28e63p-1,  -0x1.7d3af2p-6, INEXACT)
T(RN,  0x1.aedd2249ee6e8p+452,    0x1.fa3c2ca9c3021p-1,   0x1.bb6a86p-3, INEXACT)
T(RN,  0x1.2f9863f599f1ap+452,   -0x1.a7a58e1501ef8p-1,   0x1.3fca0ap-2, INEXACT)
T(RN,  0x1.46dce2c36b7f4p+452,   -0x1.03ab9ba61b10bp-1,  -0x1.082a38p-2, INEXACT)
T(RN,  0x1.1bc3a04db405dp+452,    -0x1.f119d483ab45p-2,   0x1.c7aa0cp-2, INEXACT)
T(RN,  0x1.18479721f9a6dp+452,    0x1.c9ec532e73229p-1,   0x1.e4ed44p-3, INEXACT)
T(RN,  0x1.49fe16254c69cp+452,   -0x1.dee5078663ad8p-1,   0x1.0e8104p-5, INEXACT)
T(RN,  0x1.9d75ec07818ecp+452,    0x1.bc176ae8a1be2p-1,   -0x1.48a7dp-6, INEXACT)
T(RN,  0x1.6e5a7e7a79e01p+452,   -0x1.bdb445241b8e2p-3,  -0x1.defa88p-2, INEXACT)
T(RN,  0x1.34fa3a3b65475p+453,    0x1.286d8111af124p-9,   0x1.a102e6p-2, INEXACT)
T(RN,  0x1.b09330523a307p+453,   -0x1.8fb133acd8c8fp-1,  -0x1.9d5d26p-2, INEXACT)
T(RN,  0x1.8bd549adfa646p+453,    0x1.4ba8265b6911fp-2,   0x1.3a855ap-3, INEXACT)
T(RN,  0x1.f28cc9449c603p+453,    0x1.a3293c3d640cbp-1,   0x1.9b5e54p-2, INEXACT)
T(RN,  0x1.b3813504ecac9p+453,   -0x1.f44a6d9664daap-1,  -0x1.df2d2ep-2, INEXACT)
T(RN,  0x1.ecb7ac8d72caep+453,    0x1.e68fc28581291p-1,      0x1.de3p-2, INEXACT)
T(RN,  0x1.b8644c9c2a0f6p+453,    0x1.287a3242281eep-1,   0x1.ff4aecp-3, INEXACT)
T(RN,  0x1.d3edf10912a4bp+453,    0x1.9ca66284c3af4p-1,   0x1.93bd74p-3, INEXACT)
T(RN,  0x1.0cd0f07c70b68p+453,    0x1.2071b294af2edp-1,  -0x1.d78416p-2, INEXACT)
T(RN,  0x1.8e3ffb718c40fp+453,     0x1.2cd78d6bc159p-1,  -0x1.5989c6p-2, INEXACT)
T(RN,  0x1.a442cd1a0c3acp+454,   -0x1.6d9b72a4e8621p-1,    0x1.c7d09p-6, INEXACT)
T(RN,  0x1.f6b71de0def12p+454,   -0x1.0a4c00029932bp-2,  -0x1.77e074p-2, INEXACT)
T(RN,  0x1.369ecbf211a87p+454,    0x1.e4fa0e4e21ebap-1,  -0x1.397738p-4, INEXACT)
T(RN,  0x1.90aa58eed0961p+454,    0x1.e7adabe1cf8d6p-2,  -0x1.27e2bep-2, INEXACT)
T(RN,  0x1.405bfd6386c86p+454,    0x1.bf7edc4bf9c58p-1,   0x1.93c848p-3, INEXACT)
T(RN,  0x1.10b5e7f5b60d1p+454,    0x1.9e044045c01c9p-1,   0x1.d1d25cp-2, INEXACT)
T(RN,  0x1.46adcf781d1e5p+454,    0x1.4332a56c6940bp-1,  0x1.d50decp-12, INEXACT)
T(RN,  0x1.08a12c173cffcp+454,    0x1.e6fe954e1d108p-2,   0x1.3ebe54p-2, INEXACT)
T(RN,  0x1.a629389b2a34ep+454,    0x1.88dc428958b99p-1,   0x1.b94144p-2, INEXACT)
T(RN,  0x1.bacea493ac6a2p+454,   -0x1.29432da91a58fp-1,   -0x1.534b6p-3, INEXACT)
T(RN,  0x1.6e9c90d0706d7p+455,   -0x1.97b8ae493e73ep-3,   0x1.32858ap-2, INEXACT)
T(RN,  0x1.277ae81765dcbp+455,   -0x1.e583e6781c759p-1,   0x1.4eca28p-2, INEXACT)
T(RN,  0x1.67cca863e991dp+455,    0x1.bf7a63c82edc1p-2,  -0x1.b3f6f8p-3, INEXACT)
T(RN,  0x1.d8302ec2cc378p+455,   -0x1.ffffb6566571bp-1,   0x1.87dc6cp-2, INEXACT)
T(RN,   0x1.b1f039d84308p+455,    0x1.495eddecf6df4p-1,   -0x1.6c28ep-4, INEXACT)
T(RN,  0x1.12e422425e9d4p+455,   -0x1.a23ba48c5249ep-3,  -0x1.bebb4ep-2, INEXACT)
T(RN,  0x1.75e909ea0015bp+455,   -0x1.62f499dbcd48fp-1,   -0x1.4b863p-2, INEXACT)
T(RN,   0x1.6a200a194d71p+455,   -0x1.9dc34a4ec256fp-1,   0x1.800996p-2, INEXACT)
T(RN,  0x1.8f1a00130801ap+455,   -0x1.6a5dc47f54f67p-2,   0x1.6ae88ep-2, INEXACT)
T(RN,  0x1.901da4670bccap+455,    -0x1.9a1eef66172ap-3,   0x1.29613ep-3, INEXACT)
T(RN,  0x1.2927824bda353p+456,    0x1.b3f69ff75975ep-1,   0x1.2a0096p-2, INEXACT)
T(RN,  0x1.575fc0065ef74p+456,   -0x1.45b233086a107p-2,  -0x1.1e2f08p-5, INEXACT)
T(RN,  0x1.4adc17f7fb5d6p+456,   -0x1.cc9e1c2ab62cbp-1,   0x1.7f0616p-3, INEXACT)
T(RN,  0x1.8f3fa7062aee9p+456,   -0x1.fd7915b39fdc5p-1,   0x1.aa7a6cp-3, INEXACT)
T(RN,  0x1.388192de1946ep+456,   -0x1.890251b7bde77p-1,    0x1.bde96p-3, INEXACT)
T(RN,  0x1.658c6d1973a5ap+456,   -0x1.fe06b0bce0169p-1,    0x1.c3feap-3, INEXACT)
T(RN,  0x1.0ac8f336559acp+456,   -0x1.c644e54a23011p-1,  -0x1.37acdep-4, INEXACT)
T(RN,  0x1.2de5842d957fcp+456,    0x1.f8c453bed6fd8p-1,  -0x1.d2d198p-2, INEXACT)
T(RN,  0x1.bb717b14dfcd4p+456,    0x1.31d134c9b39d5p-2,   0x1.68ea7ap-3, INEXACT)
T(RN,  0x1.3324ea4c253fap+456,   -0x1.784c2f183bd2cp-1,  -0x1.723fc2p-2, INEXACT)
T(RN,  0x1.4fdcd4204f1bep+457,     0x1.4907b0019bfep-3,   0x1.5da8cep-3, INEXACT)
T(RN,  0x1.10eef19f21c5bp+457,    0x1.40cd523a3919fp-2,   0x1.afcd0cp-3, INEXACT)
T(RN,  0x1.e7f455b998edap+457,    0x1.3e21eaeba7059p-2,  -0x1.e8a9aap-2, INEXACT)
T(RN,  0x1.f63038a5da984p+457,   -0x1.c184054b719cfp-1,    0x1.b92e6p-3, INEXACT)
T(RN,  0x1.9ce24361d4e62p+457,   -0x1.bdc7b1dbd1a6bp-1,  -0x1.320fd8p-2, INEXACT)
T(RN,  0x1.8e8ab6ce3fd62p+457,   -0x1.8bd478f29acefp-1,  -0x1.f317f8p-2, INEXACT)
T(RN,  0x1.cf6ae98cf8578p+457,    0x1.428e87dd5d418p-6,   0x1.c1d7cap-2, INEXACT)
T(RN,  0x1.c9698ffca1d0cp+457,    0x1.be6312a32978dp-2,   0x1.61d394p-4, INEXACT)
T(RN,  0x1.75824ce7d555ap+457,    0x1.b9b35f2d415b7p-1,  -0x1.40738ap-2, INEXACT)
T(RN,  0x1.0ff93d4296dfep+457,    -0x1.a9bb109b94f6p-3,   0x1.2612d8p-2, INEXACT)
T(RN,  0x1.e21cc25c1a0b1p+458,   -0x1.8fd4e0071881fp-3,   -0x1.9fda4p-2, INEXACT)
T(RN,  0x1.5957ae12d6675p+458,   -0x1.d96862ec63986p-1,  -0x1.586f5ap-4, INEXACT)
T(RN,  0x1.8cb213ae57592p+458,   -0x1.46d8a0915dd74p-2,   0x1.d000fep-3, INEXACT)
T(RN,  0x1.945eb33e0f04ep+458,   -0x1.8e685e90c11a9p-1,  -0x1.f73c88p-2, INEXACT)
T(RN,  0x1.8099a575b842ep+458,   -0x1.3138b279f6f44p-1,   0x1.07fcd6p-5, INEXACT)
T(RN,  0x1.599eac69861f2p+458,    0x1.9ef8b6e6d9363p-3,  -0x1.5ff28ep-2, INEXACT)
T(RN,  0x1.c2601fa039686p+458,    0x1.334f33693d809p-1,   0x1.258d18p-5, INEXACT)
T(RN,  0x1.648ec97005de3p+458,    0x1.7dc870334b865p-2,   -0x1.27479p-3, INEXACT)
T(RN,  0x1.fbe00f49a147cp+458,    0x1.ad848bd178cbcp-1,  -0x1.708faep-7, INEXACT)
T(RN,  0x1.087e79a4e9f0ep+458,   -0x1.0eba1f961df5ep-1,  -0x1.00b418p-2, INEXACT)
T(RN,  0x1.bfd2b98c69745p+459,   -0x1.0a8e4b39cb535p-3,    -0x1.f26ep-3, INEXACT)
T(RN,   0x1.cc07b61a53afp+459,   -0x1.862cbab085975p-1,  -0x1.35d9e2p-3, INEXACT)
T(RN,  0x1.59e613719e0ddp+459,    0x1.fa049a2204459p-1,   0x1.cd42b4p-3, INEXACT)
T(RN,  0x1.12f2bd5c5587dp+459,   -0x1.fff4020d88bbfp-1,  -0x1.0af7dep-2, INEXACT)
T(RN,  0x1.34feb9f0deabep+459,    0x1.db139074ee446p-2,   0x1.cc7d44p-4, INEXACT)
T(RN,  0x1.d7face2044f02p+459,   -0x1.5df5ae5f61aa3p-2,    0x1.543f7p-2, INEXACT)
T(RN,  0x1.0102f1afda13bp+459,    0x1.c88cfc5563918p-1,  -0x1.313e6ep-3, INEXACT)
T(RN,  0x1.6b2e6b9cb5b2dp+459,    0x1.f32db4aa615f1p-1,    0x1.d41cap-2, INEXACT)
T(RN,  0x1.e944c597247a4p+459,    0x1.e214f92494956p-1,  -0x1.32ac1ap-3, INEXACT)
T(RN,  0x1.41e15cb490c12p+459,    0x1.3cd40c5a8774ap-2,    0x1.d149bp-3, INEXACT)
T(RN,  0x1.f04252a50fa3cp+460,   -0x1.c1fdc72b48bdbp-1,   0x1.d84cd4p-2, INEXACT)
T(RN,  0x1.463afa5fc5e26p+460,    0x1.3cedafe576a3fp-2,   0x1.290536p-2, INEXACT)
T(RN,  0x1.944c1d18ccc78p+460,    0x1.f18fece1705f2p-1,  -0x1.71168ap-2, INEXACT)
T(RN,  0x1.bc2218575aecap+460,   -0x1.ffb3b3f9d40a7p-1,   0x1.1a2582p-8, INEXACT)
T(RN,  0x1.8042aee062c8bp+460,    0x1.b5874cd7bd0f4p-1,   0x1.c1410ap-2, INEXACT)
T(RN,  0x1.0b50dd1dea5fcp+460,   -0x1.23fae922ad449p-2,  -0x1.111f72p-2, INEXACT)
T(RN,  0x1.0a7be9fb82b47p+460,   -0x1.ff566f9118d4ep-1,   0x1.4f8dfcp-2, INEXACT)
T(RN,  0x1.6b6bfb47541b1p+460,   -0x1.f66ab141e645cp-1,   0x1.3a2306p-2, INEXACT)
T(RN,  0x1.b39b79b1e9374p+460,    0x1.094d48b03aa07p-1,  -0x1.35424cp-3, INEXACT)
T(RN,  0x1.a998ffb68f87ep+460,   -0x1.ff92f150faed3p-1,  -0x1.58cadep-2, INEXACT)
T(RN,  0x1.64313784e36e2p+461,   -0x1.3d1a7c53da61dp-8,  -0x1.3311f6p-2, INEXACT)
T(RN,  0x1.fbbbacc84295fp+461,    0x1.ecd7831abf82fp-1,   0x1.709386p-3, INEXACT)
T(RN,  0x1.b34f1437e73ccp+461,   -0x1.e9641681cd324p-1,   0x1.b6fd5ep-2, INEXACT)
T(RN,  0x1.1129793dcbcd2p+461,    0x1.d0a5f3e454f4fp-3,   0x1.3f35aap-5, INEXACT)
T(RN,  0x1.eb3a86620e583p+461,   -0x1.dbc3c9bed3aa4p-1,   0x1.71aa0ap-3, INEXACT)
T(RN,  0x1.f4c2f31c2519cp+461,   -0x1.ff821ac8f778cp-4,   0x1.d47dc4p-6, INEXACT)
T(RN,  0x1.ebd26b2c2b38ep+461,    0x1.e5da0cb0a448ap-1,  -0x1.ef9686p-3, INEXACT)
T(RN,  0x1.eaa671a51fa1cp+461,   -0x1.416504f5e6151p-1,   0x1.22ba26p-2, INEXACT)
T(RN,  0x1.f93ac07e55d86p+461,   -0x1.7190d57fbacdcp-1,  -0x1.a92b94p-2, INEXACT)
T(RN,  0x1.4e04a0ab807efp+461,   -0x1.e9259002f45b3p-1,   0x1.697664p-2, INEXACT)
T(RN,  0x1.f27acae6b18a6p+462,    0x1.9f4ab4d83cc4dp-6,  -0x1.2d9a6ap-5, INEXACT)
T(RN,  0x1.160182bb3178fp+462,    0x1.96dfff539e74bp-1,   0x1.8a6fc2p-2, INEXACT)
T(RN,  0x1.fc84587092008p+462,     0x1.caddb6d932d8p-1,   0x1.caeedcp-2, INEXACT)
T(RN,  0x1.2c14b251e1324p+462,    0x1.8588d9e270c5fp-1,   0x1.2a211cp-2, INEXACT)
T(RN,   0x1.81b78eb6b5cap+462,    0x1.c53df119ae3d4p-6,  -0x1.5de612p-6, INEXACT)
T(RN,  0x1.af8f0be5d501ep+462,   -0x1.cde3c5d3557c9p-1,   0x1.814ac4p-3, INEXACT)
T(RN,  0x1.d1f1ab2761f94p+462,    0x1.c7b4fe7462fdcp-2,  -0x1.6b1186p-2, INEXACT)
T(RN,  0x1.adc20ff30d137p+462,    0x1.9737bc3b8d986p-1,  -0x1.5cbc5ap-2, INEXACT)
T(RN,  0x1.9413a858d8a88p+462,   -0x1.c1485ae3db24dp-1,  -0x1.d2f77ap-4, INEXACT)
T(RN,   0x1.410bfdc0e3f6p+462,    0x1.ffeb72e7be59bp-1,  -0x1.a5138cp-2, INEXACT)
T(RN,  0x1.35972679070dfp+463,   -0x1.f4e284bca7947p-1,  -0x1.667016p-4, INEXACT)
T(RN,  0x1.f0ae1a8e98836p+463,    0x1.e9c6268be8443p-1,   0x1.78425ep-4, INEXACT)
T(RN,  0x1.eb7bdda439ec8p+463,    0x1.fc348f6f3fe55p-1,  -0x1.5cc31ap-6, INEXACT)
T(RN,  0x1.b74990858009ep+463,    0x1.71fb95c87195fp-1,  -0x1.9c3b96p-3, INEXACT)
T(RN,  0x1.4e9301f675f07p+463,   -0x1.ac4d4a8aec80ep-6,    0x1.a1cf1p-3, INEXACT)
T(RN,  0x1.77afc34716515p+463,    0x1.cb11bc1ed1156p-1,   0x1.1441acp-2, INEXACT)
T(RN,  0x1.0cf56089374a9p+463,   -0x1.67f0c2832954bp-3,   0x1.afdf2ap-3, INEXACT)
T(RN,  0x1.e6dd6196780b3p+463,    0x1.16eee75d235bfp-1,  -0x1.a09b2cp-2, INEXACT)
T(RN,  0x1.691cc9dce5886p+463,    0x1.f15d9df4a0836p-1,  -0x1.f73c7ep-2, INEXACT)
T(RN,  0x1.0fc6a6c2bb495p+463,    0x1.746e0f9d14072p-4,  -0x1.e15494p-2, INEXACT)
T(RN,  0x1.e85424699ab6ep+464,   -0x1.997bf5086eebep-4,  -0x1.eed81ep-2, INEXACT)
T(RN,  0x1.894376e3dbb28p+464,   -0x1.4417096e3cdabp-2,  -0x1.5ed0b6p-2, INEXACT)
T(RN,  0x1.3788810359a18p+464,   -0x1.2568fb0a46c46p-1,  -0x1.e071a6p-3, INEXACT)
T(RN,  0x1.82ba966998a7cp+464,    0x1.8259e8653c0b6p-1,  -0x1.5f9386p-3, INEXACT)
T(RN,  0x1.206dd351e52aap+464,    0x1.70523ddf74692p-1,   0x1.8cb6a2p-2, INEXACT)
T(RN,  0x1.67aefa993ad0cp+464,   -0x1.fc5081500659dp-1,   0x1.7907a4p-2, INEXACT)
T(RN,  0x1.3b64befa9b0a1p+464,   -0x1.fff8292a6fa45p-1,   0x1.5720ccp-3, INEXACT)
T(RN,  0x1.fe3bb3d43de56p+464,    -0x1.12a85db28537p-1,  -0x1.46ea9ap-3, INEXACT)
T(RN,  0x1.ddcf420ed6186p+464,   -0x1.ec4c618c04a31p-1,  -0x1.7825eap-2, INEXACT)
T(RN,  0x1.d0cb95f02ad77p+464,    0x1.e80ad4fe54c72p-5,   0x1.58cfd8p-3, INEXACT)
T(RN,  0x1.3f3d09044134cp+465,    -0x1.94e9efd7477cp-3,  -0x1.585a6ap-2, INEXACT)
T(RN,  0x1.76395cd3e6346p+465,    0x1.80b9bbd74c295p-2,   0x1.ac8112p-2, INEXACT)
T(RN,  0x1.047f52afba0fdp+465,   -0x1.fe3b0a88b7cb1p-1,   -0x1.21981p-2, INEXACT)
T(RN,  0x1.4ffe158ad2ac6p+465,   -0x1.b13dacc9ae641p-2,  -0x1.7c3e5cp-3, INEXACT)
T(RN,  0x1.98967e4d1f3a2p+465,    0x1.994e4835f1811p-1,   0x1.0465a4p-2, INEXACT)
T(RN,  0x1.77b45749abb64p+465,   -0x1.76667483ac517p-1,   0x1.492ab6p-4, INEXACT)
T(RN,  0x1.3991d0c09b80dp+465,    0x1.7334402e562a3p-3,  -0x1.00876cp-3, INEXACT)
T(RN,  0x1.39ed54d8cf5ccp+465,     0x1.f0b5e78ba15ap-1,  -0x1.c5f4d6p-3, INEXACT)
T(RN,  0x1.b32ce9939efb9p+465,    0x1.f6bca7c9f341bp-1,   0x1.b78ef2p-3, INEXACT)
T(RN,  0x1.4da6e25650dd9p+465,    0x1.fc10f8b8081b5p-1,   0x1.dc3a12p-5, INEXACT)
T(RN,  0x1.e6f281dd34cc4p+466,    0x1.76b184a73af54p-1,  -0x1.ac7e5cp-2, INEXACT)
T(RN,  0x1.d44ef2ed9a456p+466,    0x1.f212c66d8aa21p-7,  -0x1.d80046p-4, INEXACT)
T(RN,  0x1.eea1b16025a0ap+466,   -0x1.7dd3cd4ca0998p-1,   0x1.b2649cp-3, INEXACT)
T(RN,  0x1.68cdc8ec2bb41p+466,    0x1.fc831ad3824e8p-1,  -0x1.6997fcp-5, INEXACT)
T(RN,  0x1.cc141bf716af3p+466,    0x1.1f55dd216f3a2p-2,    0x1.7c712p-2, INEXACT)
T(RN,  0x1.87fb43c3cd516p+466,    0x1.6499bc22ef26cp-1,   0x1.a4c672p-3, INEXACT)
T(RN,  0x1.08c4c92545385p+466,    0x1.65a8e5a55b306p-2,   0x1.5318bap-2, INEXACT)
T(RN,  0x1.c8aa4c3cafae2p+466,   -0x1.84ba40aa9c379p-2,  -0x1.571852p-2, INEXACT)
T(RN,   0x1.666326dde96dp+466,    0x1.d109bd7546a8ap-1,    0x1.11ebep-2, INEXACT)
T(RN,  0x1.1e709b36d4ddcp+466,   -0x1.fdf96fae9614cp-1,   0x1.698648p-2, INEXACT)
T(RN,  0x1.ca81855a79cf4p+467,   -0x1.c47e6dd25de66p-1,   0x1.02b8a8p-2, INEXACT)
T(RN,  0x1.4498ac15ae1c5p+467,    0x1.fc5fc8caa19ccp-1,   0x1.ee8fd8p-3, INEXACT)
T(RN,  0x1.48d8bca5d90f8p+467,    0x1.c290408884dabp-1,   0x1.0a956cp-2, INEXACT)
T(RN,  0x1.5f1502af16404p+467,    0x1.d4ad70d4ffa85p-1,   0x1.40a082p-2, INEXACT)
T(RN,  0x1.6e393d97f0587p+467,    0x1.3faaa9e3102acp-1,   0x1.497eccp-2, INEXACT)
T(RN,  0x1.ad6a52247509fp+467,   -0x1.703639e7d212bp-1,   0x1.3b5428p-3, INEXACT)
T(RN,  0x1.12ae58cc709ccp+467,    0x1.fff4cc20806bfp-1,   0x1.3ead36p-3, INEXACT)
T(RN,   0x1.aa0e782b45edp+467,   -0x1.cff6692ed2677p-1,  -0x1.cfa3d2p-3, INEXACT)
T(RN,  0x1.85b94beed7f1cp+467,    0x1.021e4febba315p-1,   0x1.11391ep-2, INEXACT)
T(RN,  0x1.c945efb0be002p+467,   -0x1.1c3e900854661p-1,  -0x1.724a6ap-2, INEXACT)
T(RN,  0x1.522c672a7549bp+468,   -0x1.2cc947882bff3p-1,   0x1.ef91c8p-2, INEXACT)
T(RN,  0x1.cdcd015d7986ap+468,    0x1.92c8e3b087debp-1,   0x1.4d9574p-2, INEXACT)
T(RN,  0x1.9eccc652ff513p+468,    0x1.f63c4a3ddeaabp-1,  -0x1.c514e4p-3, INEXACT)
T(RN,  0x1.5f4c355b2b8f6p+468,    0x1.fffd03fb7b251p-1,  -0x1.6a8ae4p-6, INEXACT)
T(RN,   0x1.96b631a5444bp+468,   -0x1.d58d064bf94bbp-1,   0x1.06b5b4p-2, INEXACT)
T(RN,  0x1.45868f8a00c98p+468,    0x1.feac7eca3a1c3p-1,  -0x1.c556eep-2, INEXACT)
T(RN,  0x1.4d759d0daa13dp+468,   -0x1.0acbd3ec6fb4dp-1,  -0x1.58bb3ep-2, INEXACT)
T(RN,  0x1.43b01def75f8cp+468,   -0x1.2a0f56e3031a2p-1,  -0x1.80f6bep-6, INEXACT)
T(RN,  0x1.a26a918798c38p+468,    0x1.e20b8e71a45a6p-1,   0x1.ed08e2p-2, INEXACT)
T(RN,  0x1.d6395f8fbf3bcp+468,    0x1.b114f5a036d4ap-1,    0x1.cbc8cp-3, INEXACT)
T(RN,  0x1.b9aa91fde1926p+469,   -0x1.7889e6f771e0fp-4,   0x1.4f3a48p-4, INEXACT)
T(RN,  0x1.84123dae18688p+469,   -0x1.53b337eb4f40cp-2,   -0x1.a0344p-3, INEXACT)
T(RN,   0x1.45f07a247a38p+469,    0x1.a77b396eed8fdp-1,  -0x1.8612c2p-2, INEXACT)
T(RN,   0x1.784e0ed34ea3p+469,    0x1.f5897f766ee08p-1,  -0x1.e96e74p-2, INEXACT)
T(RN,  0x1.a7286b4316f6dp+469,   -0x1.e9b38d40172d6p-1,  -0x1.9ad2bap-2, INEXACT)
T(RN,  0x1.300a6ec2d1184p+469,    0x1.46ab547660553p-1,   0x1.9fc0f8p-3, INEXACT)
T(RN,  0x1.8745ad01309e8p+469,   -0x1.de0426afa83f4p-2,  -0x1.3eabf6p-2, INEXACT)
T(RN,  0x1.74f844420fffep+469,   -0x1.a04940d9d5063p-1,  -0x1.493624p-3, INEXACT)
T(RN,  0x1.a8274474f0714p+469,    0x1.fff6b075c07a5p-1,   0x1.cc4a66p-4, INEXACT)
T(RN,  0x1.8e49a76ced01bp+469,   -0x1.fffe0a510a559p-1,  -0x1.5913b8p-2, INEXACT)
T(RN,    0x1.1f5e8173085p+470,   -0x1.db66e42285da8p-1,   0x1.e52a66p-2, INEXACT)
T(RN,  0x1.cfd4f637f333dp+470,    0x1.34190f0c77a61p-1,   0x1.ef40d8p-3, INEXACT)
T(RN,  0x1.fcfe6b6394fa9p+470,   -0x1.fe57bd48f4053p-1,  -0x1.3dde86p-6, INEXACT)
T(RN,  0x1.7be2db2aef119p+470,   -0x1.ecd1833113f57p-3,  -0x1.380c5ap-2, INEXACT)
T(RN,  0x1.cf6ac2e4aa7eep+470,    0x1.ef96201a4f65cp-4,  -0x1.6d6cfep-5, INEXACT)
T(RN,  0x1.bf7f9c6dd86eep+470,    0x1.fc2fc345dd956p-1,    0x1.8a31fp-2, INEXACT)
T(RN,  0x1.7a7f25c3d311ap+470,    0x1.ff50ca09ce9b1p-1,  -0x1.bb80fcp-2, INEXACT)
T(RN,  0x1.92526a0635291p+470,   -0x1.bad0682f09e13p-3,   0x1.893282p-8, INEXACT)
T(RN,  0x1.061e07763f2b8p+470,    0x1.c8069a22257b3p-3,   0x1.186208p-2, INEXACT)
T(RN,  0x1.af12ae528e4ebp+470,   -0x1.129d397d6ce3fp-1,   0x1.6625cap-2, INEXACT)
T(RN,  0x1.eba6e7f6d964cp+471,   -0x1.fed40467f2a69p-1,  -0x1.221f86p-4, INEXACT)
T(RN,  0x1.c177cb7f75a4bp+471,    0x1.0a5500dfc9486p-2,    0x1.56952p-2, INEXACT)
T(RN,  0x1.cd01da6d08d44p+471,   -0x1.d3c03218b434dp-1,  -0x1.5a3f62p-4, INEXACT)
T(RN,  0x1.831b6bb815052p+471,   -0x1.e9b8436c9f75ap-1,    0x1.0f729p-2, INEXACT)
T(RN,  0x1.f6cf657830e8ap+471,   -0x1.de9a6fd2a3198p-4,  -0x1.03e2acp-5, INEXACT)
T(RN,  0x1.70e64b1040c0dp+471,   -0x1.3f62803e42795p-2,   0x1.9a2302p-2, INEXACT)
T(RN,  0x1.6471f171f5fa4p+471,   -0x1.fa3de7380719dp-1,   0x1.ca267cp-6, INEXACT)
T(RN,  0x1.95e90c533795ap+471,    0x1.5510b0639ec9bp-1,  -0x1.342fa2p-2, INEXACT)
T(RN,  0x1.a6e6400c37d16p+471,   -0x1.c4d9990b361c7p-1,  -0x1.0ac4a4p-2, INEXACT)
T(RN,  0x1.37286b2077769p+471,    0x1.d3171fdb30512p-1,  -0x1.4a0a72p-5, INEXACT)
T(RN,  0x1.dd64fb026ae54p+472,    0x1.b984b3cad9baep-1,  -0x1.60a58cp-2, INEXACT)
T(RN,  0x1.8e3de772e2fa6p+472,    0x1.64914280e12dep-1,   0x1.1fe3f6p-5, INEXACT)
T(RN,  0x1.1bd418feb7391p+472,    0x1.9c0e888c4f81ap-1,  -0x1.b6c8d4p-2, INEXACT)
T(RN,  0x1.51d82ed05131fp+472,    0x1.6d39f2fee3112p-2,   0x1.a1caccp-5, INEXACT)
T(RN,  0x1.33a18cd265985p+472,    0x1.8db0b94d097d5p-1,  -0x1.0264acp-2, INEXACT)
T(RN,  0x1.47d64334b8895p+472,   -0x1.d4eceba9b6f32p-1,  -0x1.bf0f54p-5, INEXACT)
T(RN,  0x1.12bcf51a5a04dp+472,    0x1.becb5c5d4aa13p-1,   0x1.344a26p-4, INEXACT)
T(RN,   0x1.697321a73262p+472,    0x1.3fc0671cdb4f9p-2,   0x1.651498p-2, INEXACT)
T(RN,  0x1.355b526af2899p+472,   -0x1.c3d2da73c9125p-6,   0x1.88641ap-3, INEXACT)
T(RN,  0x1.9826c32df30a8p+472,    0x1.85f1ff2aa47fbp-1,  -0x1.812dc4p-2, INEXACT)
T(RN,  0x1.cf08b85dbeec2p+473,   -0x1.2fb873b185ad4p-1,   0x1.0fd202p-2, INEXACT)
T(RN,  0x1.99c5c3a12643ap+473,    0x1.87168325f51b6p-4,   0x1.a1cbd6p-4, INEXACT)
T(RN,  0x1.4190c199d564ep+473,    0x1.7f6bead6a3883p-1,    0x1.554ebp-2, INEXACT)
T(RN,  0x1.436ac6a836f32p+473,   -0x1.f3429bbe55eedp-1,  -0x1.e55a42p-4, INEXACT)
T(RN,  0x1.d93b6c457a10dp+473,    0x1.fffef44464d24p-1,    0x1.71a66p-2, INEXACT)
T(RN,  0x1.3dea538e39704p+473,   -0x1.d3507ce7af757p-1,  -0x1.b7b08ap-2, INEXACT)
T(RN,  0x1.95611ac1f8dfap+473,   -0x1.81aa2b200b45ap-1,    0x1.9aa9bp-2, INEXACT)
T(RN,  0x1.c858c66a4062ap+473,   -0x1.7b2baeeb5fc1ep-1,   -0x1.9105dp-2, INEXACT)
T(RN,  0x1.7d4e9dc19e4fcp+473,   -0x1.f8a3045c1825fp-1,   0x1.ae05a6p-4, INEXACT)
T(RN,  0x1.1d3e79fae9b6dp+473,    0x1.3e1c2db43740fp-1,   0x1.17e406p-2, INEXACT)
T(RN,  0x1.44f1c5d902533p+474,    0x1.31cefca885884p-1,   0x1.46fda4p-5, INEXACT)
T(RN,  0x1.23856739d8e18p+474,    0x1.1a4c14e881a87p-1,   0x1.4aad48p-3, INEXACT)
T(RN,  0x1.7185d35c93b69p+474,    0x1.f7f8698f7a011p-1,   0x1.e974f2p-2, INEXACT)
T(RN,  0x1.4feb9eda2f299p+474,    0x1.f625b55a141fdp-5,   0x1.a94252p-9, INEXACT)
T(RN,  0x1.dc30128fb33e4p+474,   -0x1.e6638109bece8p-1,   0x1.ae23f2p-2, INEXACT)
T(RN,  0x1.523e0eac2fa1ap+474,   -0x1.82c4e584eefe7p-1,  -0x1.8908d4p-4, INEXACT)
T(RN,  0x1.55115c4cea50dp+474,   -0x1.b334c7b4e3236p-1,   0x1.8812b2p-3, INEXACT)
T(RN,   0x1.dbbc28578456p+474,   -0x1.c04ebbb515802p-2,  -0x1.1af122p-5, INEXACT)
T(RN,  0x1.96d72225549b4p+474,   -0x1.01f6857036517p-2,   0x1.b25a3ap-2, INEXACT)
T(RN,  0x1.b86dcc037f767p+474,    0x1.6d7c0175a5e33p-1,   0x1.ddf97cp-3, INEXACT)
T(RN,  0x1.439af9ece3268p+475,    0x1.61b0caca1e306p-4,   0x1.b61d9cp-2, INEXACT)
T(RN,  0x1.36434793e0de8p+475,    0x1.4d72d8581618fp-1,   0x1.b381f8p-5, INEXACT)
T(RN,  0x1.1758d15395162p+475,   -0x1.3a77ecc8a0dfcp-2,  -0x1.84c6f8p-3, INEXACT)
T(RN,  0x1.0b54ae710a3d7p+475,   -0x1.f01cd6c2c6a17p-1,  -0x1.d5f89cp-2, INEXACT)
T(RN,  0x1.052acce5e6387p+475,   -0x1.7d10b57a50f04p-1,   0x1.de78ccp-2, INEXACT)
T(RN,  0x1.4bd0a27197c3cp+475,   -0x1.cab94e0708c0dp-1,  -0x1.1d57e4p-3, INEXACT)
T(RN,   0x1.48b248cbb35ap+475,    0x1.d4bb075b74634p-1,   0x1.affe2cp-2, INEXACT)
T(RN,  0x1.8224c1d04fc67p+475,    0x1.97f41e6c5ec11p-2,  -0x1.4f7118p-4, INEXACT)
T(RN,  0x1.b1ff4a77121dcp+475,   -0x1.f1faaa67617b2p-1,  -0x1.a02d9ap-2, INEXACT)
T(RN,  0x1.f011fc3bee1dcp+475,   -0x1.9531794fd9e3bp-3,  -0x1.6dbdb8p-2, INEXACT)
T(RN,  0x1.e02ff07edc26ap+476,   -0x1.8a08878506e45p-1,   0x1.5d4cd2p-2, INEXACT)
T(RN,   0x1.f0ff87fa19ddp+476,   -0x1.e5f5e0b7d1a3ep-2,  -0x1.3a5636p-2, INEXACT)
T(RN,  0x1.ce4e5930d9615p+476,   -0x1.579b02750f3a9p-1,  -0x1.4e103ep-3, INEXACT)
T(RN,  0x1.cbec4a5049806p+476,    -0x1.bf5dd7ff688fp-1,  -0x1.97a53cp-3, INEXACT)
T(RN,  0x1.5155dbddf5a14p+476,    0x1.b4e190ef161d1p-1,   0x1.0634cep-2, INEXACT)
T(RN,  0x1.c6101f1c60352p+476,   -0x1.a44d97847cd06p-1,  -0x1.29f0d2p-3, INEXACT)
T(RN,  0x1.86da5e34578f8p+476,   -0x1.7b206a6df5cddp-2,  -0x1.ec4d22p-3, INEXACT)
T(RN,  0x1.eebb70befb4b2p+476,    0x1.a87d576549ef9p-1,  -0x1.72b748p-3, INEXACT)
T(RN,  0x1.037f4e3b01866p+476,   -0x1.b68e535b2f551p-2,   -0x1.ce5e4p-2, INEXACT)
T(RN,  0x1.a4f46f0517f36p+476,   -0x1.457384f35dadep-2,   0x1.f30772p-2, INEXACT)
T(RN,  0x1.86b8f3bba114ep+477,    0x1.a98b71b76097bp-2,  -0x1.73fe06p-2, INEXACT)
T(RN,  0x1.5c8c80e0564fdp+477,   -0x1.a6bb6ae5113abp-3,  -0x1.cfd4b8p-3, INEXACT)
T(RN,  0x1.16ef11933a646p+477,   -0x1.d97b00903869ep-1,  -0x1.695b62p-4, INEXACT)
T(RN,  0x1.eb6e582a1510ep+477,    0x1.3bcee6ef2b82ep-2,    0x1.b0798p-6, INEXACT)
T(RN,  0x1.3f71caafc1c9bp+477,    0x1.f4230e1a851b6p-2,   0x1.c3c9dep-3, INEXACT)
T(RN,  0x1.fe6239239f89cp+477,    0x1.ff1d29031eb93p-1,   0x1.9d0446p-3, INEXACT)
T(RN,  0x1.bf39aa9f60e2cp+477,   -0x1.df48071e2a96ep-2,   0x1.98284ep-2, INEXACT)
T(RN,  0x1.89aedcf1af98dp+477,    0x1.fffffd56cfe36p-1,  -0x1.224d82p-2, INEXACT)
T(RN,   0x1.c3b0c5016bf3p+477,   -0x1.ffa055a20057cp-1,    0x1.bc445p-3, INEXACT)
T(RN,   0x1.bdee092ddab8p+477,   -0x1.fc9b85d4e1255p-1,  -0x1.4c43bcp-2, INEXACT)
T(RN,   0x1.79a043eaf816p+478,   -0x1.caa6ad0117a3dp-4,   -0x1.f3785p-2, INEXACT)
T(RN,  0x1.6714f9d2ce67dp+478,    0x1.c9efdb9c149fdp-1,  -0x1.ef9732p-2, INEXACT)
T(RN,  0x1.bafab40ed6de2p+478,    0x1.cfd81b9f43fddp-1,  -0x1.fa4b7ep-3, INEXACT)
T(RN,  0x1.bbc4748701774p+478,   -0x1.b565693f45efdp-1,   0x1.983f52p-2, INEXACT)
T(RN,  0x1.7b876cdfc65e1p+478,   -0x1.f2da40a7b90dcp-1,  -0x1.28054ep-2, INEXACT)
T(RN,  0x1.5bc276c166e0ep+478,    0x1.e7d727ff756b7p-3,   0x1.c5ae2ap-2, INEXACT)
T(RN,  0x1.4448b575bb836p+478,   -0x1.db899cc278884p-1,  -0x1.4e72e8p-2, INEXACT)
T(RN,  0x1.c6246f223fd02p+478,    0x1.bcfcdb02400d9p-1,   0x1.2e8f6cp-3, INEXACT)
T(RN,  0x1.bca434ce1a602p+478,   -0x1.9687a9df0c42cp-1,  -0x1.ebb51ep-3, INEXACT)
T(RN,   0x1.dfcff4b6d4cep+478,   -0x1.accd662de3695p-1,  -0x1.c378a4p-2, INEXACT)
T(RN,  0x1.526700405b29ap+479,   -0x1.ad0a0a2ba21d7p-1,  -0x1.027be6p-7, INEXACT)
T(RN,  0x1.d58ddcfff0da7p+479,    0x1.63f0da1c97a84p-1,    0x1.c855ep-3, INEXACT)
T(RN,  0x1.bbb3d06de5c1ap+479,   -0x1.3c33ef43adca1p-3,   0x1.667c1cp-5, INEXACT)
T(RN,  0x1.36d516105abb7p+479,   -0x1.70e3a04371101p-1,   0x1.ca7844p-3, INEXACT)
T(RN,  0x1.7d8397a0a7b54p+479,   -0x1.0032bf7a81dfcp-1,  -0x1.df1d14p-2, INEXACT)
T(RN,  0x1.b3d115a5d64e8p+479,    0x1.cb5ffbd68ee39p-1,   0x1.bf752cp-3, INEXACT)
T(RN,  0x1.69c7df6b7c1f8p+479,    -0x1.ebaff975b6a3p-4,  -0x1.a3836ep-2, INEXACT)
T(RN,  0x1.f1bdc2c3abbcap+479,    0x1.da4f4e4b630f4p-1,  -0x1.254bd4p-2, INEXACT)
T(RN,  0x1.997a1810fc547p+479,   -0x1.f9e4d90f68123p-1,  -0x1.112c0ap-2, INEXACT)
T(RN,  0x1.d8c3a7ee8e126p+479,    0x1.9fc99c75095bdp-2,  -0x1.ccb156p-4, INEXACT)
T(RN,  0x1.8593145e0d2b7p+480,   -0x1.9fa1f9d837885p-1,   0x1.43f968p-2, INEXACT)
T(RN,  0x1.fbcba2c301c91p+480,   -0x1.94be8d2e02471p-5,  -0x1.ab9976p-3, INEXACT)
T(RN,  0x1.cb5a1fbbd9ec2p+480,    0x1.5671785ee849fp-3,   0x1.548f24p-2, INEXACT)
T(RN,  0x1.d381b1f2c432cp+480,     0x1.09b8a41346e8p-1,   0x1.084b24p-3, INEXACT)
T(RN,  0x1.48f4b63faa95dp+480,   -0x1.ed0bc075cebc7p-2,   0x1.6e8378p-3, INEXACT)
T(RN,  0x1.8c037e6b0c3f6p+480,    0x1.f91d0796aacacp-1,   0x1.cf408ap-5, INEXACT)
T(RN,  0x1.cc9bf153922c2p+480,    0x1.536d9a406f51ep-5,  -0x1.292358p-2, INEXACT)
T(RN,  0x1.5f4cf168eb914p+480,   -0x1.6fe1aff11c1f3p-3,   0x1.a7283ap-2, INEXACT)
T(RN,  0x1.c6f05c5dfd824p+480,    0x1.16fa63091dbcdp-2,   0x1.17825ep-4, INEXACT)
T(RN,  0x1.0b3b43ae7e54cp+480,    0x1.b688d258ffc84p-1,   0x1.61f878p-5, INEXACT)
T(RN,  0x1.802c28455e5a2p+481,   -0x1.bcfc36fcdbaf2p-1,   0x1.e02ab2p-2, INEXACT)
T(RN,  0x1.442e524615a0bp+481,   -0x1.6a33ac4013bc9p-2,  -0x1.c46deap-4, INEXACT)
T(RN,  0x1.017b42569e41bp+481,    0x1.06482b98b9663p-1,   -0x1.20a86p-2, INEXACT)
T(RN,  0x1.478178c6fcffep+481,    0x1.9ac8fb9307d51p-1,  -0x1.9c4b44p-2, INEXACT)
T(RN,  0x1.531001ba49714p+481,   -0x1.f7aeec62a5bf8p-2,  -0x1.f6fcb4p-2, INEXACT)
T(RN,  0x1.2f1bdb643615ep+481,    0x1.e855057e72792p-4,  -0x1.b3319cp-3, INEXACT)
T(RN,  0x1.558b8e668f717p+481,   -0x1.f759d710822f6p-1,  -0x1.544baep-2, INEXACT)
T(RN,  0x1.3392ad2970a55p+481,    0x1.a2262358b782bp-2,  -0x1.4511e2p-2, INEXACT)
T(RN,  0x1.772b8b6600ee3p+481,    0x1.cb2d92751746bp-1,  -0x1.a78c92p-2, INEXACT)
T(RN,   0x1.2306fde98c2ep+481,    0x1.4f3157b45cb1ep-1,   0x1.88486ap-2, INEXACT)
T(RN,   0x1.04ea695709b1p+482,   -0x1.9682d81e7ecbap-1,   0x1.bd072ep-2, INEXACT)
T(RN,   0x1.c7c9861313f2p+482,   -0x1.ba472f5c592eep-2,  -0x1.b73bfap-2, INEXACT)
T(RN,  0x1.bee60a728fb94p+482,   -0x1.e410f818e1663p-2,  -0x1.98ba56p-2, INEXACT)
T(RN,    0x1.168a300633ep+482,    0x1.c6c2d713a069ep-1,   0x1.7f40dap-2, INEXACT)
T(RN,   0x1.0b41ad8a76f2p+482,    0x1.1f74a5cae6655p-1,  -0x1.147b36p-2, INEXACT)
T(RN,  0x1.2552861718addp+482,   -0x1.e9d2c22381d12p-3,  -0x1.e62d92p-2, INEXACT)
T(RN,  0x1.b858258ea5a88p+482,    0x1.6497be95c5c45p-1,   0x1.c4ff32p-2, INEXACT)
T(RN,  0x1.b5f458cda5546p+482,    0x1.ebbbd5715974ap-1,   0x1.ff75acp-4, INEXACT)
T(RN,  0x1.c8f9d5cb6b309p+482,    0x1.ff6eac76bb4d4p-1,  -0x1.90853ep-2, INEXACT)
T(RN,  0x1.cd13b4908a892p+482,   -0x1.fe0c4c25378d5p-1,   0x1.2bcc4cp-2, INEXACT)
T(RN,  0x1.175be1cf2ab89p+483,   -0x1.a66dce05e2397p-1,   0x1.dd2214p-2, INEXACT)
T(RN,  0x1.d483d00de67f5p+483,    0x1.8735883e33383p-1,  -0x1.b97a2cp-2, INEXACT)
T(RN,  0x1.7de0592eee39ap+483,     0x1.05d835d3324cp-1,  -0x1.382d4cp-3, INEXACT)
T(RN,  0x1.7e85f7bce4b9ep+483,    0x1.af7b9bc72f6ccp-3,  0x1.1b547ep-10, INEXACT)
T(RN,  0x1.f9aa0f1644e3fp+483,    -0x1.d4d53b8e9b15p-2,   0x1.b98f42p-2, INEXACT)
T(RN,  0x1.dacfe23f0f4f8p+483,    0x1.fd1390d1f0ce6p-3,   0x1.18a016p-4, INEXACT)
T(RN,  0x1.fc3c3bf27005ap+483,   -0x1.88877f4940d08p-1,   0x1.81af38p-4, INEXACT)
T(RN,  0x1.acf8bc081f5b2p+483,   -0x1.346f088379feap-2,  -0x1.8114dap-3, INEXACT)
T(RN,  0x1.f0275c97db2b8p+483,    0x1.5b3a550331ea7p-1,   0x1.af54bep-3, INEXACT)
T(RN,   0x1.5bdc833eda6ep+483,    0x1.02768d8a2614cp-1,  -0x1.f5cb6ep-2, INEXACT)
T(RN,  0x1.f2b6153ad0d5ap+484,    0x1.a7acd8319b9f6p-1,   0x1.531cfep-4, INEXACT)
T(RN,  0x1.4b36ca89605fep+484,   -0x1.ca2035c3ac26dp-2,   0x1.93e446p-4, INEXACT)
T(RN,  0x1.d2c3524ad063ap+484,   -0x1.9ab2cf99a1584p-1,   -0x1.3923ap-2, INEXACT)
T(RN,  0x1.7454736fd7ddap+484,    0x1.15a8d14c94f29p-1,    0x1.328bap-3, INEXACT)
T(RN,  0x1.a36d0dea98371p+484,    0x1.a713535ff703ep-2,  -0x1.4f11a6p-4, INEXACT)
T(RN,  0x1.235dfd2080b86p+484,    -0x1.1b96953040e8p-1,   0x1.3f505ap-4, INEXACT)
T(RN,  0x1.556ee37485a3ap+484,    0x1.97fe58493527dp-2,   0x1.650fbcp-4, INEXACT)
T(RN,   0x1.d91ddffd52f8p+484,    0x1.fc4ff4f0ad148p-1,  -0x1.3196eep-2, INEXACT)
T(RN,  0x1.a9aba9c4f2288p+484,    0x1.d75e3ccba2a24p-1,   0x1.f9f87ep-3, INEXACT)
T(RN,  0x1.2dc3f2f09266ep+484,   -0x1.4cc5e67cf6795p-1,   -0x1.b12c8p-9, INEXACT)
T(RN,   0x1.1f5169b41316p+485,    0x1.ff03e4c946f5ep-1,  -0x1.8a5faep-2, INEXACT)
T(RN,  0x1.74214c9651722p+485,   -0x1.1361c827a7e6cp-3,  -0x1.c000c6p-3, INEXACT)
T(RN,  0x1.849f8119986e8p+485,    0x1.04a3187b97389p-1,   0x1.3782ecp-5, INEXACT)
T(RN,   0x1.81c9fe55a8b1p+485,   -0x1.fddc84d23b5a7p-4,   0x1.d707eap-4, INEXACT)
T(RN,  0x1.6a255d41801a8p+485,    0x1.40b227f966567p-1,   0x1.ddda64p-2, INEXACT)
T(RN,   0x1.ecbbaec26dacp+485,    0x1.e7063dc19c81fp-2,   -0x1.7204fp-4, INEXACT)
T(RN,  0x1.bf9c6b784cdb6p+485,    0x1.6b1d47d8ee468p-2,  -0x1.18f67ap-2, INEXACT)
T(RN,   0x1.de2a77567f1bp+485,    0x1.98ff6a1e21e3ep-1,   0x1.ea929cp-3, INEXACT)
T(RN,  0x1.35e007f884822p+485,   -0x1.dd1d201c70a3fp-5,  -0x1.c67c5cp-5, INEXACT)
T(RN,  0x1.a24fecf4d13a9p+485,   -0x1.f6d69597e5096p-1,  -0x1.6ca8eap-4, INEXACT)
T(RN,  0x1.00cb5f8df4dcap+486,    0x1.5c509223725a5p-1,   0x1.386a1cp-3, INEXACT)
T(RN,  0x1.2a3647eade2c9p+486,   -0x1.f0f40a0dab566p-1,  -0x1.616da4p-3, INEXACT)
T(RN,  0x1.cb36d61628f7dp+486,   -0x1.ef1e54b4089dbp-2,  -0x1.b59902p-3, INEXACT)
T(RN,  0x1.c664858a7eceap+486,   -0x1.71b5c9d47e0fep-3,   0x1.60d048p-6, INEXACT)
T(RN,  0x1.2ce22efc18f54p+486,   -0x1.78024e61d0ba3p-1,    0x1.8de8dp-4, INEXACT)
T(RN,   0x1.36be3ba70382p+486,    0x1.e4ada6be392bfp-3,   0x1.0787f6p-2, INEXACT)
T(RN,  0x1.a0e2fe2b4d745p+486,   -0x1.a9beb88bf97ebp-1,   0x1.2d5e88p-2, INEXACT)
T(RN,  0x1.65faeb5886989p+486,   -0x1.d6e52e309fec6p-1,   -0x1.9f66cp-3, INEXACT)
T(RN,  0x1.6225baf00f565p+486,    0x1.efa7814a2ff8ep-1,  -0x1.64853ep-2, INEXACT)
T(RN,  0x1.b5baf1985435cp+486,    0x1.e8ad4b07eb862p-1,    0x1.7775fp-4, INEXACT)
T(RN,  0x1.0fb5c4085ef5fp+487,   -0x1.501cd12e297f6p-2,  -0x1.4e2fdap-2, INEXACT)
T(RN,  0x1.93920100f5d9ap+487,    0x1.17f21886b07cdp-6,   0x1.9f5cc6p-5, INEXACT)
T(RN,  0x1.ff7cba78dd6e5p+487,   -0x1.b3c44eeda6ba3p-1,  -0x1.fe7bf6p-2, INEXACT)
T(RN,  0x1.358e63a96b9b2p+487,   -0x1.c9a7e43019491p-1,   0x1.f14cfep-2, INEXACT)
T(RN,  0x1.b169d9756abc4p+487,    0x1.416767925ebdap-1,   0x1.fdf8eap-2, INEXACT)
T(RN,  0x1.9b3925e636932p+487,    0x1.d538c6d2058a8p-1,   0x1.8ee93ap-2, INEXACT)
T(RN,  0x1.83f424b01d998p+487,   -0x1.699ec5852a469p-1,    0x1.b3facp-4, INEXACT)
T(RN,  0x1.8d9bdafcd27b5p+487,    0x1.177a3f60a9241p-1,   0x1.218c2ap-5, INEXACT)
T(RN,  0x1.8b1c60a2ab0f2p+487,   -0x1.d1e4b46c62c7dp-1,    0x1.fe272p-3, INEXACT)
T(RN,   0x1.84b12199a177p+487,    0x1.cc4bd3db25326p-2,   -0x1.c727cp-2, INEXACT)
T(RN,  0x1.07425925455dap+488,   -0x1.e11b3f1af7a1dp-3,  -0x1.83cd52p-9, INEXACT)
T(RN,  0x1.a9cb92fc8f597p+488,    0x1.9c093ff445674p-3,   0x1.3fa3c2p-2, INEXACT)
T(RN,  0x1.5d2609ec03611p+488,   -0x1.4a3ba7ca9f74dp-4,  -0x1.4e23e2p-2, INEXACT)
T(RN,  0x1.78995c7d971ebp+488,    -0x1.129cee0dd1b5p-1,  -0x1.641818p-7, INEXACT)
T(RN,  0x1.f7d5ab20aaabep+488,   -0x1.f995bc36371afp-1,  -0x1.443f1ap-2, INEXACT)
T(RN,  0x1.b69dd9020459ap+488,    0x1.57f07e1a281bbp-3,   0x1.2ecbe6p-4, INEXACT)
T(RN,  0x1.4307d66f5f08bp+488,    -0x1.80162f432fddp-1,   0x1.6e43f6p-2, INEXACT)
T(RN,  0x1.78998f655b699p+488,    0x1.4eaabb66c549cp-2,   0x1.71a7c2p-3, INEXACT)
T(RN,  0x1.04eef3c20ad01p+488,    0x1.fe29e15ec60ddp-1,  -0x1.dcaa4cp-3, INEXACT)
T(RN,  0x1.f1f037c2ff946p+488,   -0x1.53fa41a2ee7a6p-1,   0x1.e80544p-3, INEXACT)
T(RN,  0x1.8aab38b38001dp+489,    -0x1.f4cb69405575p-1,  -0x1.a39d1ap-2, INEXACT)
T(RN,  0x1.7e76b7482edf4p+489,   -0x1.06c653f99852fp-1,   0x1.82f45ap-2, INEXACT)
T(RN,  0x1.1037b0fb340bep+489,   -0x1.aad862f1eea27p-2,   -0x1.0567ep-2, INEXACT)
T(RN,  0x1.e6efc947c3fcep+489,    0x1.9f7b41c6cf37bp-4,  -0x1.3890fep-2, INEXACT)
T(RN,  0x1.21aa97cc581e8p+489,   -0x1.efdac02ce3a5dp-1,   0x1.5af192p-2, INEXACT)
T(RN,  0x1.a7c3c82c3d88ap+489,    0x1.d0be5e0d5d476p-1,  -0x1.d76ccap-3, INEXACT)
T(RN,  0x1.09bc659a66693p+489,    0x1.c7a0fe1671a96p-1,   0x1.c1cc44p-3, INEXACT)
T(RN,  0x1.4bb9c066963f8p+489,    0x1.34bd3ed6b4eaep-1,  -0x1.880c38p-2, INEXACT)
T(RN,  0x1.6a1ca8a34541fp+489,     0x1.cf969afabd23p-2,  -0x1.b3d6ecp-2, INEXACT)
T(RN,  0x1.b11b396670d8ap+489,    0x1.d8798785e3667p-1,  -0x1.26617cp-3, INEXACT)
T(RN,  0x1.706a5ab42f798p+490,   -0x1.8b7220e1b0691p-4,   0x1.c3ee76p-2, INEXACT)
T(RN,  0x1.9a2971d5a884cp+490,   -0x1.5bf229e7b44fep-3,  -0x1.654e7cp-3, INEXACT)
T(RN,  0x1.d2eb73e61b9d1p+490,    0x1.bb5d1c6dedd28p-1,    0x1.c0daap-2, INEXACT)
T(RN,  0x1.bf7b17d495f4dp+490,   -0x1.09e5c056a943dp-6,   0x1.10a908p-4, INEXACT)
T(RN,  0x1.51d6814f28df6p+490,   -0x1.6a7ad178a33f2p-2,  -0x1.b1915ap-2, INEXACT)
T(RN,  0x1.c57057bad1b82p+490,    0x1.230681aeb4505p-1,   -0x1.0518dp-6, INEXACT)
T(RN,  0x1.8b3325d4f08bcp+490,    0x1.323d26c18aa41p-1,  -0x1.7feb52p-3, INEXACT)
T(RN,  0x1.5be0e8a17b753p+490,   -0x1.ff04ef79f1597p-1,   0x1.d64694p-2, INEXACT)
T(RN,  0x1.1368b8a74e85bp+490,    0x1.f2bcfead82289p-1,  -0x1.fec016p-2, INEXACT)
T(RN,  0x1.78148f091196dp+490,   -0x1.4bee463c72496p-2,  -0x1.5f6aacp-4, INEXACT)
T(RN,  0x1.e78b45d987017p+491,    0x1.de0cb5eb47df2p-1,  -0x1.3e0d2ep-4, INEXACT)
T(RN,  0x1.037b055b204c7p+491,   -0x1.0d77c5c7dbc1ep-1,   0x1.36b4fep-2, INEXACT)
T(RN,  0x1.8b9cd23025101p+491,   -0x1.43de53af2dca8p-1,  -0x1.6a40d6p-2, INEXACT)
T(RN,  0x1.76c2aea1b104fp+491,   -0x1.2107d06b2b2e9p-1,   0x1.d1e5b2p-2, INEXACT)
T(RN,  0x1.3d61f363d4d57p+491,     0x1.296332da7008p-2,  -0x1.26260ep-2, INEXACT)
T(RN,  0x1.9a7698992fba6p+491,   -0x1.2261260c4246bp-1,  -0x1.4fd21ep-2, INEXACT)
T(RN,   0x1.9cf7f6c21d9bp+491,   -0x1.e61da57595d21p-1,  -0x1.4d3cfap-2, INEXACT)
T(RN,  0x1.1f818cab765eap+491,   -0x1.e4cd6606607dfp-1,   0x1.15e5d2p-5, INEXACT)
T(RN,    0x1.ccefab5d40ep+491,    0x1.5dffbf83b75aep-3,   0x1.b3226cp-2, INEXACT)
T(RN,   0x1.d91391a91181p+491,   -0x1.a694560290684p-1,   0x1.65eab4p-4, INEXACT)
T(RN,  0x1.04f8b6fc667e9p+492,    0x1.01ecf076051abp-2,   0x1.f461b4p-4, INEXACT)
T(RN,  0x1.730213e80b078p+492,    0x1.c98e8253297bfp-1,  -0x1.7e11bcp-5, INEXACT)
T(RN,  0x1.d89e5737a2a7ep+492,    0x1.5477b2f15f755p-4,   -0x1.2918dp-2, INEXACT)
T(RN,  0x1.f34cb14759baep+492,   -0x1.d83bb07af97e4p-3,  -0x1.93e798p-3, INEXACT)
T(RN,  0x1.ecc0783aaaac2p+492,   -0x1.07aa6593c3462p-4,   0x1.f6a77ap-3, INEXACT)
T(RN,  0x1.f9ee9afe6fef6p+492,    0x1.e216af33e9f19p-2,   0x1.dc8d2cp-4, INEXACT)
T(RN,  0x1.6fd738689defbp+492,   -0x1.09c5113e2df39p-1,   -0x1.d511cp-3, INEXACT)
T(RN,   0x1.dcce2fd3f356p+492,    0x1.ffffffce12accp-1,   0x1.876224p-5, INEXACT)
T(RN,  0x1.e092a26c6fad9p+492,   -0x1.0b7ab2321330bp-3,   -0x1.75e85p-3, INEXACT)
T(RN,  0x1.41b2dffca74a4p+492,   -0x1.34d2c7f334672p-2,  -0x1.b1a9aep-2, INEXACT)
T(RN,  0x1.03c8bfce2ce17p+493,   -0x1.37ab24ba54271p-2,  -0x1.f9206ap-5, INEXACT)
T(RN,  0x1.7b893d69653dap+493,   -0x1.6765344491008p-3,   0x1.f2b12cp-3, INEXACT)
T(RN,  0x1.d2e471decffb2p+493,    0x1.e5a607af48a35p-1,  -0x1.105852p-3, INEXACT)
T(RN,  0x1.f34e75ab81044p+493,    0x1.9603729a3544dp-1,   0x1.3d9656p-2, INEXACT)
T(RN,  0x1.60d03e233c791p+493,    0x1.3fa48201538a5p-1,  -0x1.a4324cp-2, INEXACT)
T(RN,  0x1.1e759c56a0d28p+493,   -0x1.eeaa80d45c799p-1,   0x1.5e9c0ap-2, INEXACT)
T(RN,  0x1.1324c91447bd1p+493,    0x1.cf22df0659046p-3,   0x1.8ffd4ap-2, INEXACT)
T(RN,  0x1.0b300d386be4ep+493,    0x1.61337583d2b47p-1,  -0x1.de275ap-2, INEXACT)
T(RN,  0x1.9fe5f6c504b9cp+493,   -0x1.2bb8d16a660e6p-3,  -0x1.09f564p-2, INEXACT)
T(RN,  0x1.7f303e3a90d54p+493,    0x1.1f9bc58b7e752p-1,  -0x1.d64cf4p-3, INEXACT)
T(RN,  0x1.a692061e25722p+494,   -0x1.99299c9fe14efp-1,   0x1.15494cp-2, INEXACT)
T(RN,  0x1.9c8a24fb79ad2p+494,     0x1.1deba9361accp-1,   0x1.4e6ff6p-2, INEXACT)
T(RN,  0x1.f454a119215c9p+494,   -0x1.ebfd5f9a9fa5dp-1,   -0x1.91f9ep-2, INEXACT)
T(RN,   0x1.9fcdbe7d06d1p+494,   -0x1.e667f49bfbb33p-1,  -0x1.01d99cp-2, INEXACT)
T(RN,  0x1.48d5e033faff9p+494,    0x1.29f967977272ap-2,  -0x1.39c19ap-2, INEXACT)
T(RN,  0x1.a333106bdeef6p+494,   -0x1.acfa640479baap-4,   0x1.1ea1ccp-2, INEXACT)
T(RN,  0x1.4384036ec74c9p+494,   -0x1.9f64ee68b48a2p-2,  -0x1.43ab4ap-4, INEXACT)
T(RN,  0x1.526f16a586fa3p+494,    0x1.b74688f5a76b1p-1,   0x1.f5e698p-3, INEXACT)
T(RN,  0x1.e89a9e5219bb4p+494,    0x1.6756b97919a7dp-1,   0x1.56bf78p-3, INEXACT)
T(RN,  0x1.9cfb249669a7bp+494,    0x1.b7938008f20b2p-1,  -0x1.6a4298p-2, INEXACT)
T(RN,  0x1.f03759784ce88p+495,    -0x1.f811f18939c1p-1,   0x1.9c8c8ep-2, INEXACT)
T(RN,  0x1.75ac60ef42e0ep+495,   -0x1.e680f6f062f81p-2,  -0x1.834dfep-5, INEXACT)
T(RN,  0x1.daf27ae883f36p+495,    -0x1.4adab23465f3p-2,   0x1.0e95f2p-2, INEXACT)
T(RN,  0x1.dbf5e87eee866p+495,    0x1.d88f6dcc7b7c8p-3,  -0x1.0dc668p-2, INEXACT)
T(RN,  0x1.66f5eccd883b2p+495,    0x1.d3901b530b374p-1,   0x1.1d5872p-2, INEXACT)
T(RN,  0x1.c4110a023cf4dp+495,    0x1.3f6b408f93d5fp-7,  -0x1.96a3f4p-6, INEXACT)
T(RN,  0x1.6f58fac066efdp+495,   -0x1.8541e26213da2p-2,   0x1.e7263ap-3, INEXACT)
T(RN,   0x1.7b64edf7307fp+495,    0x1.09bbbd076ffd7p-1,  -0x1.9429bcp-4, INEXACT)
T(RN,   0x1.82a38f96343dp+495,    -0x1.a86ef2192306p-2,  -0x1.5e51d4p-4, INEXACT)
T(RN,  0x1.386953546cdd6p+495,    0x1.fe5b936f46266p-4,  -0x1.05377cp-2, INEXACT)
T(RN,  0x1.2d55a5eb569b4p+496,    0x1.6e81e6a67db58p-1,  -0x1.889d2cp-2, INEXACT)
T(RN,  0x1.d48933bd5f884p+496,   -0x1.a104eecda6027p-1,   0x1.4fc416p-4, INEXACT)
T(RN,   0x1.dfbf28fb7637p+496,    0x1.4ac332ef88fd9p-1,  -0x1.ac7fb2p-4, INEXACT)
T(RN,  0x1.038a9b9c12933p+496,    0x1.49f5c3736bb98p-1,   0x1.a5a7c4p-4, INEXACT)
T(RN,  0x1.8b1b3e7765e34p+496,   -0x1.27bdb2eedf397p-1,  -0x1.79f0b8p-3, INEXACT)
T(RN,   0x1.3a46dacf6467p+496,    0x1.d645ec9eb4f7cp-2,    0x1.cebc9p-6, INEXACT)
T(RN,  0x1.a9992d0c925f2p+496,   -0x1.c660623a89eb4p-3,   0x1.051bc8p-2, INEXACT)
T(RN,  0x1.6fd1a15965df5p+496,   -0x1.c22710d60cab6p-3,   0x1.f6622ap-2, INEXACT)
T(RN,  0x1.6dc28d10eac31p+496,    0x1.f84dbc6813d15p-1,   0x1.4d2564p-2, INEXACT)
T(RN,  0x1.3bda03ad96b43p+496,   -0x1.f509e4e6b5f44p-1,  -0x1.1e23e6p-2, INEXACT)
T(RN,   0x1.12890f0d36f2p+497,    0x1.a6f3afccc4ca6p-1,  -0x1.8be974p-2, INEXACT)
T(RN,  0x1.199cbf6481f84p+497,    0x1.8130f790dc54cp-2,   -0x1.a55f6p-2, INEXACT)
T(RN,  0x1.cb952842dc378p+497,   -0x1.9a03c66c2ada2p-6,   0x1.4ba5fcp-6, INEXACT)
T(RN,  0x1.f7d6f89609aadp+497,    0x1.7124d09b7ba31p-1,   0x1.9fa3fep-3, INEXACT)
T(RN,  0x1.0c2d684b08e82p+497,   -0x1.160ebc2b654f4p-1,   0x1.feaa94p-2, INEXACT)
T(RN,  0x1.9c25fab468daap+497,   -0x1.4bfe0890dbad8p-1,  -0x1.2f0ca4p-3, INEXACT)
T(RN,  0x1.4328487efb5c7p+497,    0x1.c3671b5fc9044p-1,  -0x1.57a70ap-4, INEXACT)
T(RN,  0x1.cb13c310128c7p+497,   -0x1.a1295b70aabbcp-1,   0x1.919858p-4, INEXACT)
T(RN,  0x1.c749817cd22b8p+497,   -0x1.b78c0129125ccp-1,  -0x1.916b8ap-4, INEXACT)
T(RN,  0x1.e8c657f708337p+497,   -0x1.01f7f64d9b604p-2,  -0x1.b8b24cp-3, INEXACT)
T(RN,  0x1.d41fa450e6148p+498,   -0x1.ec1696c9a7dd4p-1,   -0x1.19098p-2, INEXACT)
T(RN,  0x1.cc48e0367a512p+498,    0x1.ef7d675ae7c33p-1,  -0x1.bebb7ap-2, INEXACT)
T(RN,  0x1.10d895cc3cde1p+498,    0x1.aacfa12487029p-2,   0x1.5900f6p-2, INEXACT)
T(RN,  0x1.2bd5be08e7e64p+498,   -0x1.72b63675f3bfep-1,    -0x1.53cep-2, INEXACT)
T(RN,  0x1.5bec023ad20a6p+498,    -0x1.ed90b553ae4bp-1,   0x1.e703ecp-3, INEXACT)
T(RN,  0x1.ec3ccfdd4980ep+498,    0x1.73264c3e8dfdfp-1,  -0x1.34871ep-2, INEXACT)
T(RN,  0x1.34d982a4d5cbfp+498,   -0x1.b38492db2e381p-2,  -0x1.307c56p-2, INEXACT)
T(RN,  0x1.4c445de1d40f6p+498,    0x1.9539b2e8599fbp-2,  -0x1.fded98p-2, INEXACT)
T(RN,  0x1.f80eb1b039383p+498,   -0x1.ffcfd085db29fp-1,  -0x1.dc0bfap-3, INEXACT)
T(RN,   0x1.572402d549adp+498,   -0x1.ea5f6756543dcp-1,  -0x1.60c22ep-3, INEXACT)
T(RN,  0x1.f8268cf64bad4p+499,    0x1.8f2f2da1c1768p-1,  -0x1.840c9ep-2, INEXACT)
T(RN,  0x1.75a437d2e9412p+499,   -0x1.a3a6429d881c4p-3,  -0x1.57812ap-4, INEXACT)
T(RN,  0x1.c3190175d9b62p+499,   -0x1.439010e7416dap-4,  -0x1.f4aa54p-2, INEXACT)
T(RN,  0x1.d0911ba4eb272p+499,   -0x1.53a97b14b0017p-4,  -0x1.081246p-2, INEXACT)
T(RN,   0x1.3f61b7c64786p+499,    0x1.91934abf29a3ap-6,   0x1.c29b86p-4, INEXACT)
T(RN,  0x1.deebb06473308p+499,   -0x1.fee2072431ef3p-1,  -0x1.a01082p-2, INEXACT)
T(RN,  0x1.c58f02646888cp+499,    0x1.3b9bcda2f549fp-1,  -0x1.2b8c26p-4, INEXACT)
T(RN,  0x1.68e35e8bc28e7p+499,   -0x1.e5e55fbb51ba4p-1,   0x1.bdc786p-2, INEXACT)
T(RN,  0x1.55699bf7cfea5p+499,    0x1.4d53200442adcp-2,   0x1.805c24p-5, INEXACT)
T(RN,  0x1.7e7a58e56690ep+499,    0x1.d9a1599651497p-1,   0x1.0c7fbap-6, INEXACT)
T(RN,   0x1.fe9f09aea06ap+500,    0x1.9f9676e47fc44p-2,   0x1.278b32p-2, INEXACT)
T(RN,  0x1.588caa1adcf5ap+500,    0x1.bccbbc7822573p-1,  -0x1.76a1b6p-3, INEXACT)
T(RN,  0x1.79f89f70a4db4p+500,    0x1.e5546fa9dd009p-1,  -0x1.239234p-4, INEXACT)
T(RN,  0x1.10f7e2aab5f92p+500,   -0x1.bcf9d01c3dc8cp-2,   0x1.33f1cap-3, INEXACT)
T(RN,  0x1.331f34b4441a9p+500,   -0x1.e876d7af3262fp-8,  -0x1.d38656p-2, INEXACT)
T(RN,  0x1.d8f158af6a39cp+500,    0x1.2818a7596565fp-2,  -0x1.1cb6cep-2, INEXACT)
T(RN,  0x1.3dc9194365de5p+500,    0x1.31136abd01be8p-3,   0x1.e11c6ap-5, INEXACT)
T(RN,  0x1.0f8d3f6f6b7b8p+500,    0x1.abc70a7b149c4p-3,    0x1.e2a25p-3, INEXACT)
T(RN,  0x1.2f08616af2897p+500,   -0x1.ccdc795c35565p-1,   0x1.a9464ep-8, INEXACT)
T(RN,  0x1.56a68da647333p+500,    0x1.ecb11e989fc12p-1,   0x1.308406p-2, INEXACT)
T(RN,  0x1.ca26d880d495cp+501,   -0x1.f3d03bbf61475p-3,   0x1.d99d1cp-5, INEXACT)
T(RN,   0x1.028c63612956p+501,     0x1.b349554b5746p-1,   -0x1.4b849p-2, INEXACT)
T(RN,  0x1.5623b9e392512p+501,   -0x1.0d3c1affd34adp-2,  -0x1.50f596p-3, INEXACT)
T(RN,  0x1.3b97b6cc31a79p+501,   -0x1.583fa489417dep-4,  -0x1.e40246p-2, INEXACT)
T(RN,  0x1.1104c92dd4225p+501,   -0x1.3eafe07cf7898p-1,   0x1.6ae49ap-2, INEXACT)
T(RN,  0x1.82328eb152bbep+501,     0x1.5d5ece4407d1p-1,   0x1.ece654p-2, INEXACT)
T(RN,  0x1.3c31fd658de2cp+501,    0x1.84b89da45bb42p-1,  -0x1.59622ep-6, INEXACT)
T(RN,  0x1.a34bb4ff1c9dfp+501,    0x1.a7b25b8c172fep-2,   0x1.48ebacp-2, INEXACT)
T(RN,  0x1.95a421bd33dc8p+501,    0x1.0451fba8236c8p-2,  -0x1.0aca12p-7, INEXACT)
T(RN,  0x1.f997027635458p+501,    0x1.a44aa42f68a33p-4,  -0x1.2fc1b4p-2, INEXACT)
T(RN,  0x1.f7f5dcdf1954ap+502,   -0x1.626bdc73b4fb9p-2,  -0x1.26f43cp-2, INEXACT)
T(RN,  0x1.f8997b1f89666p+502,    0x1.65f3ff719a00dp-2,   0x1.a6b792p-3, INEXACT)
T(RN,  0x1.f05bb0c4297d2p+502,    0x1.f7e00b25e289cp-1,  -0x1.7b3ab8p-3, INEXACT)
T(RN,  0x1.c7f0a5d1af2a6p+502,   -0x1.5f8f2e3e22926p-1,   0x1.fb2346p-2, INEXACT)
T(RN,  0x1.c7eb6f303c213p+502,    0x1.9ac354f60c817p-2,    0x1.9ad1ep-3, INEXACT)
T(RN,  0x1.719a930f8d1b2p+502,   -0x1.ff4cefcdd9d4ap-1,   -0x1.8a402p-3, INEXACT)
T(RN,   0x1.a25942ebf804p+502,    -0x1.b3bc4c3ec05bp-1,   -0x1.5de66p-3, INEXACT)
T(RN,  0x1.65cca9d404428p+502,    0x1.0137ad187b11dp-1,  -0x1.2e74d8p-2, INEXACT)
T(RN,  0x1.84cf99377590fp+502,    0x1.8325f0a139cf8p-4,   -0x1.68305p-3, INEXACT)
T(RN,  0x1.d7d00e26627f2p+502,    0x1.841c97fdad121p-3,  -0x1.42d228p-2, INEXACT)
T(RN,  0x1.09e5be98088b2p+503,    0x1.937c8874222b3p-1,  -0x1.b52eacp-2, INEXACT)
T(RN,  0x1.e6bb7e0311a97p+503,     0x1.6d512ba2f0eep-1,   0x1.6a3a9ep-3, INEXACT)
T(RN,  0x1.b7d3d852801ccp+503,     0x1.48bc22fa038ep-2,   0x1.901a5cp-4, INEXACT)
T(RN,  0x1.c68be8ac25382p+503,    0x1.2aa185790c835p-2,  -0x1.74a3aap-3, INEXACT)
T(RN,  0x1.472faf2d86e62p+503,   -0x1.8136948a41aecp-3,  -0x1.9a1478p-4, INEXACT)
T(RN,  0x1.5899b90e34f71p+503,   -0x1.b441754f43ad7p-1,  -0x1.390422p-4, INEXACT)
T(RN,  0x1.d36ad95358e28p+503,   -0x1.e7bd0a9cd7adbp-1,    0x1.70476p-5, INEXACT)
T(RN,  0x1.6cc98c6969f1cp+503,    0x1.0253b9c76f1b5p-1,  -0x1.83723cp-2, INEXACT)
T(RN,  0x1.5d71685f8f571p+503,   -0x1.739409c664a2cp-1,   0x1.e6163cp-2, INEXACT)
T(RN,  0x1.cd94a9c83dd66p+503,   -0x1.78c563a4ebc31p-1,  -0x1.2fb0b8p-2, INEXACT)
T(RN,   0x1.2b318b6ef9eap+504,    0x1.f98ac4ad9a1b4p-1,  -0x1.0c3ec4p-2, INEXACT)
T(RN,  0x1.3e1e4d3c800ecp+504,   -0x1.fda71e50a4c51p-1,    0x1.0931bp-2, INEXACT)
T(RN,   0x1.ea4035295172p+504,    0x1.ff493debc5bdbp-1,   -0x1.2d074p-3, INEXACT)
T(RN,  0x1.c009e8cea5198p+504,    0x1.f7c2e5d9189b5p-1,   -0x1.d48dep-3, INEXACT)
T(RN,  0x1.f3a48fd681ef1p+504,    0x1.f5fac914c2f01p-1,   0x1.39147ap-4, INEXACT)
T(RN,  0x1.7697449944737p+504,   -0x1.6e62cbb0c7bfbp-4,   0x1.35e9a4p-2, INEXACT)
T(RN,  0x1.1aa81fbda88ffp+504,   -0x1.090bdac50d657p-2,  -0x1.04abaap-2, INEXACT)
T(RN,  0x1.607e7089f349bp+504,   -0x1.76b647044c318p-2,   0x1.b36308p-2, INEXACT)
T(RN,  0x1.22f8c32f5ae7dp+504,   -0x1.25f754f757971p-5,  -0x1.21c7f8p-2, INEXACT)
T(RN,  0x1.5e8be8f8d57aap+504,   -0x1.67ce65190250fp-1,  -0x1.441d8ap-2, INEXACT)
T(RN,  0x1.43b92e4baa7b2p+505,   -0x1.a6dbb1276d98cp-4,   0x1.054ff2p-4, INEXACT)
T(RN,   0x1.f5921c359134p+505,      0x1.887ff3709c1p-1,   0x1.1e0492p-2, INEXACT)
T(RN,  0x1.0ec40b8b16167p+505,    0x1.08a41549caef5p-1,   -0x1.5f1d1p-2, INEXACT)
T(RN,  0x1.9352a6a476f35p+505,   -0x1.d2514e41bda66p-2,  -0x1.c31feep-4, INEXACT)
T(RN,  0x1.bf83a254a9d18p+505,   -0x1.07319acd4f488p-1,   0x1.3b9d64p-3, INEXACT)
T(RN,  0x1.82a9d519c50a1p+505,   -0x1.e9d737fe174f3p-1,   0x1.d145eap-4, INEXACT)
T(RN,  0x1.d4324e85470a8p+505,   -0x1.76bf1ba8a992bp-1,    0x1.f586fp-2, INEXACT)
T(RN,  0x1.95e559febb9f9p+505,   -0x1.65ed9e6a2d72ap-7,  -0x1.f9a28ap-2, INEXACT)
T(RN,  0x1.b42a3cdc93752p+505,   -0x1.a35fb814d91afp-2,  -0x1.c73ccap-3, INEXACT)
T(RN,  0x1.47e79dedd138ep+505,   -0x1.d785972d4358cp-1,  -0x1.573578p-3, INEXACT)
T(RN,  0x1.86450d8345426p+506,    0x1.fffe6de014d4fp-1,   -0x1.20739p-5, INEXACT)
T(RN,   0x1.a22c24d4acbap+506,   -0x1.f15b6abf3e93ep-1,   0x1.2c03fcp-3, INEXACT)
T(RN,   0x1.d3335f546499p+506,    0x1.ff5c14946c028p-1,   0x1.323c9cp-2, INEXACT)
T(RN,  0x1.320206af0fcb7p+506,    0x1.2c91ca334262fp-2,   -0x1.8f1b7p-2, INEXACT)
T(RN,  0x1.b3054b4a90eaap+506,   -0x1.13c70af40d924p-1,  -0x1.513a42p-3, INEXACT)
T(RN,  0x1.242dca1ebc2a4p+506,    0x1.199b6793a8a33p-2,   0x1.7118c2p-2, INEXACT)
T(RN,  0x1.a25d4c22a4348p+506,   -0x1.7ca0d81c6d76ep-1,   -0x1.5f126p-4, INEXACT)
T(RN,  0x1.6ed0c8cffb2c2p+506,    0x1.39f7f2d829d07p-3,    0x1.37aeep-2, INEXACT)
T(RN,   0x1.8c554bce57cdp+506,    0x1.505a8b23e835bp-4,  -0x1.b06ccap-5, INEXACT)
T(RN,  0x1.c80af1dc58fb6p+506,   -0x1.f5e7f5dea9a62p-1,  -0x1.519b96p-2, INEXACT)
T(RN,  0x1.86b059743e6cep+507,    0x1.1b61ff48f98c6p-1,  -0x1.fbff9ep-3, INEXACT)
T(RN,  0x1.27ad470fb1175p+507,    0x1.fff9af32161a7p-1,  -0x1.d7534ap-2, INEXACT)
T(RN,  0x1.5357a13fe6f19p+507,    0x1.9987fcc050548p-1,  -0x1.93d4e6p-4, INEXACT)
T(RN,  0x1.8e1ff7531d308p+507,     0x1.5c27771d3446p-1,   0x1.4a216ep-3, INEXACT)
T(RN,  0x1.6dfa8e41f0b1fp+507,   -0x1.d11202002abacp-2,  -0x1.091878p-2, INEXACT)
T(RN,  0x1.994d718c72235p+507,    0x1.ffcbf9cdebb04p-1,  -0x1.fe95f6p-4, INEXACT)
T(RN,  0x1.64dfdbcb85ec2p+507,    0x1.8e8eb6be7c51fp-1,  -0x1.de0848p-4, INEXACT)
T(RN,   0x1.c75813113406p+507,    0x1.0411b94058df4p-1,  -0x1.f9cbc4p-3, INEXACT)
T(RN,  0x1.a56ae70098945p+507,   -0x1.05739340f82ccp-3,    0x1.d2dffp-4, INEXACT)
T(RN,  0x1.e9c8f26cb5e8bp+507,   -0x1.9c5716dbf4008p-1,   0x1.43596ep-3, INEXACT)
T(RN,   0x1.28fa9e500254p+508,    0x1.2ccf0e555f976p-1,   0x1.cb949ap-2, INEXACT)
T(RN,  0x1.d3ad55bca81fcp+508,   -0x1.06d9caf4fc14cp-2,  -0x1.322c88p-4, INEXACT)
T(RN,  0x1.7a7e5668ebd4ep+508,    0x1.bb596808a0e95p-2,  -0x1.7de32ep-2, INEXACT)
T(RN,  0x1.5d251102eed78p+508,    0x1.bd17cd55b244cp-1,   0x1.a1638ap-3, INEXACT)
T(RN,  0x1.38c3ce3a43183p+508,    0x1.c5ea160da304cp-1,  -0x1.e0d814p-2, INEXACT)
T(RN,   0x1.62927105255fp+508,   -0x1.186fe1d0b50d8p-1,   0x1.0ad37cp-2, INEXACT)
T(RN,  0x1.981b7cb6945a9p+508,   -0x1.6bf2339befa22p-1,   -0x1.e832ap-2, INEXACT)
T(RN,  0x1.eaa7c1a861f12p+508,    0x1.47bbf9adff41fp-1,  -0x1.17fcb4p-3, INEXACT)
T(RN,  0x1.4f72010e087a4p+508,    0x1.df5acdc65e59bp-1,   -0x1.d50fep-2, INEXACT)
T(RN,  0x1.aa6d33ff56994p+508,   -0x1.ef0ddbf4a7b0ap-1,   0x1.badf5ep-2, INEXACT)
T(RN,  0x1.d24429e0e5e4dp+509,    0x1.9e2c1db1da679p-1,   0x1.807c3cp-2, INEXACT)
T(RN,  0x1.d6aba40a6e9e6p+509,    0x1.656bceeca43c4p-1,  -0x1.7c39a8p-5, INEXACT)
T(RN,  0x1.08e94285a30ddp+509,   -0x1.435c6d3baaed9p-2,  -0x1.be71ccp-6, INEXACT)
T(RN,  0x1.23b73bea351d9p+509,    0x1.681aa46f99c58p-7,  -0x1.80a13cp-2, INEXACT)
T(RN,  0x1.399a539d05293p+509,   -0x1.acc13a874cce7p-1,  -0x1.2f948ep-7, INEXACT)
T(RN,  0x1.68cb1ea81a179p+509,   -0x1.deae236e825adp-1,   0x1.b252ecp-3, INEXACT)
T(RN,  0x1.1d1bc116df079p+509,   -0x1.ef270f8825cb5p-1,   0x1.4ba9ecp-2, INEXACT)
T(RN,  0x1.5cf432fbc068ep+509,   -0x1.5f82ff80ba6a5p-3,   0x1.60533ep-2, INEXACT)
T(RN,  0x1.aff12af7d9dcdp+509,    -0x1.f7bde5525cc9p-1,   0x1.317a9ap-2, INEXACT)
T(RN,  0x1.fcf03c1ce3196p+509,   -0x1.c33c2a2eb8c79p-1,  -0x1.04cf1cp-2, INEXACT)
T(RN,  0x1.d874267d776a5p+510,    0x1.fd05c8feae74ep-1,  -0x1.408648p-3, INEXACT)
T(RN,  0x1.20f758dd6ae31p+510,    0x1.cbae59440ffbcp-5,   0x1.cae478p-5, INEXACT)
T(RN,  0x1.add688872535cp+510,    0x1.f9885139fc093p-1,  -0x1.701188p-4, INEXACT)
T(RN,  0x1.d4441013dcd1ep+510,    0x1.702633d2e5bb1p-1,  -0x1.efcae8p-2, INEXACT)
T(RN,   0x1.23d7f7089cf2p+510,    0x1.4e315d83b9ca5p-1,  -0x1.b5ec54p-3, INEXACT)
T(RN,  0x1.9ed0f19a2cef8p+510,   -0x1.03f18fd1bc1efp-1,   -0x1.4b6fbp-2, INEXACT)
T(RN,  0x1.710cbdf87113bp+510,   -0x1.a1aac9652af32p-2,     0x1.0fe4p-2, INEXACT)
T(RN,   0x1.4124252b9f45p+510,    0x1.c89f6b1d62933p-7,  -0x1.54e47cp-3, INEXACT)
T(RN,  0x1.679e564021e9dp+510,   -0x1.d6e8d2d495f5ep-2,  -0x1.16f8a8p-3, INEXACT)
T(RN,  0x1.f696c48a2cf6ap+510,    0x1.eb93c1ba70382p-1,    0x1.410c4p-2, INEXACT)
T(RN,  0x1.ea7071cf9449ap+511,   -0x1.0ff60251289adp-2,   0x1.9cc3e2p-4, INEXACT)
T(RN,  0x1.1f79aa06055f8p+511,   -0x1.a6a49eb4601c7p-1,   0x1.40d76cp-2, INEXACT)
T(RN,  0x1.c7285a8d25374p+511,   -0x1.2ee83ffdf8cb8p-4,  -0x1.5e20aep-2, INEXACT)
T(RN,  0x1.67e941e8b716cp+511,   -0x1.f8d38762a5066p-1,   0x1.07725ep-3, INEXACT)
T(RN,  0x1.2e2ce15e1bf73p+511,    0x1.110980fb78cbdp-2,   0x1.44414cp-3, INEXACT)
T(RN,  0x1.097df141d041dp+511,   -0x1.22ce5a4dfcee2p-4,  -0x1.9ccd08p-2, INEXACT)
T(RN,  0x1.46bdb2e7ac942p+511,    0x1.4d7e6cf31090ep-2,  -0x1.e65338p-2, INEXACT)
T(RN,  0x1.1beac7aff9728p+511,   -0x1.0812daa1f7fbbp-1,   0x1.889a96p-3, INEXACT)
T(RN,  0x1.234285daf77eap+511,   -0x1.bc380e4111f79p-1,   0x1.2c963ep-2, INEXACT)
T(RN,  0x1.49ecd30f2a451p+511,    0x1.628d11bd8bfb2p-1,     0x1.f9bbp-3, INEXACT)
T(RN,   0x1.2ffd9f86ad83p+512,   -0x1.4b4c07ffcbc7ap-3,   0x1.16a97cp-4, INEXACT)
T(RN,   0x1.3e2a87f127bep+512,    0x1.6f85185c44639p-1,   0x1.33704ep-2, INEXACT)
T(RN,   0x1.0d4f49fb6f0fp+512,    0x1.6ba980a49d4b8p-1,   0x1.d3e326p-2, INEXACT)
T(RN,  0x1.f6ccef07d93d1p+512,    0x1.eddcfcfcefd3dp-1,  -0x1.c744a8p-2, INEXACT)
T(RN,  0x1.cf2d46eb2eeeap+512,   -0x1.f4853139a9264p-1,    0x1.1a37fp-2, INEXACT)
T(RN,  0x1.fa35bab9a8a06p+512,    -0x1.eb48cbe97f19p-1,  -0x1.764e28p-2, INEXACT)
T(RN,  0x1.ae1593b71d4bcp+512,   -0x1.fe58b0bc2e1cdp-1,   0x1.bc6eeap-7, INEXACT)
T(RN,  0x1.ffef33f139afap+512,   -0x1.8d9e48449a256p-1,   -0x1.ec57ap-3, INEXACT)
T(RN,  0x1.9258d3f82ccf5p+512,   -0x1.b49a93da648a2p-1,   0x1.bbcb9ep-6, INEXACT)
T(RN,  0x1.ab3ecec94fb56p+512,    0x1.c3823e31f513bp-1,   0x1.4641d6p-2, INEXACT)
T(RN,  0x1.95abc83948852p+513,    0x1.ff6d40a9671f9p-1,  -0x1.bf886cp-2, INEXACT)
T(RN,   0x1.eff093d92037p+513,    0x1.7b3de39fd6832p-2,  -0x1.55aabep-2, INEXACT)
T(RN,  0x1.4e89ecf875738p+513,   -0x1.650c31117f66ap-2,  -0x1.d20962p-2, INEXACT)
T(RN,  0x1.23581e426f1e1p+513,    0x1.3644228cafb06p-2,   0x1.e118fcp-2, INEXACT)
T(RN,  0x1.d3eda8ec3c869p+513,    0x1.b2128e756df2fp-1,   0x1.84feb8p-2, INEXACT)
T(RN,  0x1.fa4758b5cde84p+513,    0x1.ee9133b47c609p-1,  -0x1.72a5c2p-3, INEXACT)
T(RN,  0x1.32e8cda93fe09p+513,   -0x1.ceb7e796b9763p-3,   0x1.b921dep-5, INEXACT)
T(RN,  0x1.e4ad200a97098p+513,    0x1.50e84e0f2dafap-3,  -0x1.e7cd02p-4, INEXACT)
T(RN,  0x1.b4ac8d3f0bcc1p+513,   -0x1.439d29ce6ed72p-1,    0x1.510d7p-2, INEXACT)
T(RN,  0x1.b4c59c7b9b962p+513,   -0x1.ffe75b1141c56p-1,   0x1.8fa6a8p-2, INEXACT)
T(RN,  0x1.224b87b0e48b9p+514,   -0x1.cc6bb867d85ddp-1,  -0x1.417426p-2, INEXACT)
T(RN,  0x1.ef75b0794204dp+514,    0x1.fffe52b9d263cp-1,  -0x1.f0492ap-6, INEXACT)
T(RN,  0x1.c93ceed9db2e4p+514,    0x1.f326fba6d762cp-1,  -0x1.c50ff8p-6, INEXACT)
T(RN,  0x1.02ffd63295374p+514,   -0x1.5bc6058631d8cp-3,  -0x1.770de6p-4, INEXACT)
T(RN,  0x1.f2e0704320f41p+514,    0x1.80b24fa0847ddp-1,   0x1.674554p-3, INEXACT)
T(RN,  0x1.2870cde3c58b8p+514,    0x1.557dba96f4ef1p-1,    0x1.c8eb8p-2, INEXACT)
T(RN,  0x1.7a51e0bc3d178p+514,   -0x1.fe3c6cb892f8ap-1,   0x1.c1ece4p-2, INEXACT)
T(RN,  0x1.f5bcb5cf22a3ep+514,   -0x1.faceb5c7e278bp-1,  -0x1.08cfa4p-2, INEXACT)
T(RN,  0x1.fbfe86a3785d3p+514,     0x1.d7b6016806eap-1,   0x1.26ef2ap-2, INEXACT)
T(RN,  0x1.d8fabf0dd8c9ep+514,    0x1.73977bd2956bbp-4,   0x1.8c0082p-3, INEXACT)
T(RN,  0x1.a6ff5022be0b9p+515,    0x1.6def5ab5062cap-3,  -0x1.9053e8p-2, INEXACT)
T(RN,  0x1.a4db017eab18ap+515,    0x1.0bd7a9e19ab9dp-5,   0x1.1292cap-2, INEXACT)
T(RN,  0x1.010fffcf3b61ap+515,    0x1.16daba70def1ap-2,   0x1.23cdcap-2, INEXACT)
T(RN,  0x1.c46a4995e87dcp+515,   -0x1.6d062a7bd8a69p-2,  -0x1.a7644ap-2, INEXACT)
T(RN,   0x1.53b8366933b6p+515,   -0x1.3363d16fb2221p-5,    0x1.c14e6p-2, INEXACT)
T(RN,   0x1.54197abad152p+515,   -0x1.d81a001dcca9bp-4,   0x1.b3bfa6p-3, INEXACT)
T(RN,  0x1.46fe7df5febe8p+515,   -0x1.3dcfca3a44f53p-1,   0x1.34e822p-2, INEXACT)
T(RN,  0x1.ba718a79485abp+515,   -0x1.c254abd1fc0b9p-1,   0x1.8cf452p-3, INEXACT)
T(RN,  0x1.8d3257d1cf636p+515,   -0x1.fe1c3443fd549p-1,  -0x1.7b27fcp-2, INEXACT)
T(RN,  0x1.7acab59f342a6p+515,   -0x1.f3b2f16a8658dp-1,  -0x1.b26824p-3, INEXACT)
T(RN,   0x1.f3f94f2aba21p+516,    0x1.a7e778fb0b99bp-1,  -0x1.04c564p-2, INEXACT)
T(RN,  0x1.336b7ffb6c504p+516,   -0x1.ad4e7d3999c07p-1,  -0x1.a840c6p-7, INEXACT)
T(RN,  0x1.6ab4194a7a706p+516,    0x1.4e8fdf4f35a1dp-2,   -0x1.85449p-2, INEXACT)
T(RN,  0x1.8936185601b3fp+516,    0x1.f4101b240544ap-1,    0x1.aea19p-2, INEXACT)
T(RN,  0x1.c9a0e3bb43b1cp+516,   -0x1.edf75c0dd306dp-2,  -0x1.4637fep-3, INEXACT)
T(RN,  0x1.a67a89bfe91f8p+516,   -0x1.fd6a2d6283734p-1,  -0x1.30108cp-2, INEXACT)
T(RN,  0x1.9660b69948519p+516,   -0x1.2d33b66bbaea8p-2,   0x1.f9910ep-3, INEXACT)
T(RN,  0x1.588e3691785c8p+516,    0x1.fcafd5108f04dp-1,   -0x1.38648p-4, INEXACT)
T(RN,  0x1.dfa55e451fed2p+516,    -0x1.f80c96c64bd7p-1,   0x1.5052b4p-8, INEXACT)
T(RN,  0x1.65f0788fde8bdp+516,   -0x1.41387a3a4d568p-5,    0x1.03512p-2, INEXACT)
T(RN,  0x1.b40e3793452bap+517,   -0x1.9b9c007f917f9p-2,   0x1.4402fap-3, INEXACT)
T(RN,  0x1.17f9f409e6c52p+517,   -0x1.673c19305715bp-2,   0x1.261b0ep-2, INEXACT)
T(RN,  0x1.600f00ab79f42p+517,   -0x1.84647f8f3556cp-1,  -0x1.f43864p-7, INEXACT)
T(RN,  0x1.8d99a8e17b636p+517,   -0x1.36d85057abda1p-3,   0x1.9c5ce6p-2, INEXACT)
T(RN,   0x1.fae9851677f5p+517,    0x1.d01a11738cbfcp-1,    0x1.40ba9p-2, INEXACT)
T(RN,  0x1.cbc4ae73203d8p+517,    0x1.63cdcf670645cp-4,   0x1.d7ff76p-5, INEXACT)
T(RN,   0x1.287bbd20f7ddp+517,   -0x1.c525a77c05185p-5,   0x1.f6a6d8p-2, INEXACT)
T(RN,  0x1.48542b3ab1457p+517,    0x1.6e89dec93109ep-2,  -0x1.d9b912p-3, INEXACT)
T(RN,  0x1.5e30285149c19p+517,   -0x1.b4fca2dbaca06p-1,   0x1.a395f2p-2, INEXACT)
T(RN,  0x1.bae67826155e8p+517,   -0x1.e52e91d4e6ae9p-2,  -0x1.f3b776p-2, INEXACT)
T(RN,  0x1.8b232190d1cbep+518,     0x1.4d2eb565a908p-3,   0x1.d0848cp-2, INEXACT)
T(RN,  0x1.402be9fd74a97p+518,   -0x1.a013c49ce19efp-1,   0x1.6c0394p-3, INEXACT)
T(RN,  0x1.bbda5bfd0137ep+518,   -0x1.619084b197bebp-1,  -0x1.f50fecp-3, INEXACT)
T(RN,  0x1.19d9c06162c5ap+518,    -0x1.1f1fad8de61ep-2,   0x1.6554e8p-2, INEXACT)
T(RN,  0x1.7154abe29e2a1p+518,   -0x1.e256a0e309254p-1,   -0x1.568e9p-2, INEXACT)
T(RN,  0x1.b442ed294d76ap+518,     0x1.34468317c23ap-1,  -0x1.cc98fcp-3, INEXACT)
T(RN,  0x1.9d097acd66392p+518,   -0x1.59c2b709edaf5p-2,   0x1.8765acp-3, INEXACT)
T(RN,  0x1.9da277dd376b8p+518,    0x1.87237acade932p-2,    0x1.98db7p-2, INEXACT)
T(RN,  0x1.db667ea7942bcp+518,   -0x1.6e3366725f421p-1,  -0x1.53c0bep-3, INEXACT)
T(RN,  0x1.9de8bb381b1ccp+518,   -0x1.c0754525f67f5p-3,  -0x1.16e25ep-4, INEXACT)
T(RN,  0x1.e120a189b3be6p+519,   -0x1.f535682c2892ap-1,   0x1.e95cb2p-3, INEXACT)
T(RN,  0x1.adaef7eb7d896p+519,    0x1.853184e19e248p-1,   0x1.3de666p-4, INEXACT)
T(RN,  0x1.ae4ceaf997b2cp+519,   -0x1.fcdd28fe06ffap-1,   -0x1.f5fc9p-3, INEXACT)
T(RN,  0x1.31d9705ee3473p+519,    0x1.b1268ec71687ep-1,   0x1.3287d4p-4, INEXACT)
T(RN,  0x1.49f097b2d89a2p+519,   -0x1.fd8e2ea8f1e82p-1,  -0x1.6a0966p-2, INEXACT)
T(RN,  0x1.276bb02a50364p+519,   -0x1.e784765ea3d1ap-1,  -0x1.2f6af6p-6, INEXACT)
T(RN,  0x1.807f0fd648d1ep+519,    0x1.ced2c41ce057dp-1,   -0x1.33c6cp-2, INEXACT)
T(RN,  0x1.87fafbeaf437bp+519,   -0x1.ae1ea8196a9fbp-1,   0x1.f4e21ep-2, INEXACT)
T(RN,  0x1.f64ca0f6d0b29p+519,   -0x1.42de7a3ce40d4p-1,   0x1.004cb8p-2, INEXACT)
T(RN,  0x1.e63578e0388e7p+519,    0x1.3337e3a4e56b8p-1,   0x1.015cbap-3, INEXACT)
T(RN,  0x1.579add1a7a743p+520,    0x1.a4cf1de61451ap-1,   0x1.dde0fep-3, INEXACT)
T(RN,   0x1.74769a0c4d63p+520,    -0x1.9e2932a23bbep-1,   0x1.f343eep-2, INEXACT)
T(RN,  0x1.65e70735eb534p+520,    0x1.714858c48f778p-2,   0x1.5d0af4p-2, INEXACT)
T(RN,  0x1.4806f9f1a03a6p+520,   -0x1.12a0e28f1a457p-1,   -0x1.f11c7p-2, INEXACT)
T(RN,  0x1.9170e0592d323p+520,    0x1.b1978b9399861p-1,   0x1.eddec8p-5, INEXACT)
T(RN,  0x1.2c7d01d463895p+520,    0x1.ee025477589bdp-3,  -0x1.8bdecep-2, INEXACT)
T(RN,  0x1.4322be1d34eb2p+520,    0x1.5c85d28779ca2p-2,  -0x1.35e6cap-5, INEXACT)
T(RN,  0x1.5f486f4b8d31ap+520,   -0x1.b443f62273773p-1,  -0x1.6257d4p-2, INEXACT)
T(RN,  0x1.9eeacba5d704dp+520,     0x1.7249e4a3db86p-2,   0x1.e44186p-5, INEXACT)
T(RN,  0x1.12958bf4f727dp+520,    0x1.aba16e03b56c6p-1,  -0x1.26bbd8p-2, INEXACT)
T(RN,  0x1.4d9ac22c7f16fp+521,    0x1.8cf9539767ef4p-1,  -0x1.4b02aep-2, INEXACT)
T(RN,  0x1.cabd3885ffa6cp+521,   -0x1.c401cd3554b1cp-2,   0x1.12f402p-2, INEXACT)
T(RN,  0x1.94b109715a0f4p+521,     0x1.ef63b7247de7p-1,    0x1.739cdp-4, INEXACT)
T(RN,   0x1.9f1eb58cced8p+521,   -0x1.6b2cc0f641a0ap-2,  -0x1.b18deep-2, INEXACT)
T(RN,  0x1.6368c05646ac7p+521,   -0x1.a5b0ceb597845p-2,   0x1.52fac4p-7, INEXACT)
T(RN,  0x1.90766b0805ad4p+521,    0x1.d262e9e81d982p-1,   0x1.a2307ep-2, INEXACT)
T(RN,  0x1.ee76fdedb6798p+521,   -0x1.7ab098a7dd04dp-1,  -0x1.928846p-2, INEXACT)
T(RN,   0x1.74e726764b0ep+521,    0x1.ff9e45a2b1084p-1,  -0x1.fe630ep-5, INEXACT)
T(RN,  0x1.443f2d20ca618p+521,   -0x1.fd2fb267c6459p-3,   0x1.de0cd4p-2, INEXACT)
T(RN,  0x1.5438794cb9c98p+521,    0x1.e90b5e9a7eb45p-3,   0x1.65ff94p-4, INEXACT)
T(RN,  0x1.3a336ff577045p+522,   -0x1.4eab747914027p-1,  -0x1.bcbf78p-3, INEXACT)
T(RN,  0x1.ae94fe9e1d124p+522,     0x1.b0dcc6ebab4bp-2,  -0x1.712d12p-6, INEXACT)
T(RN,  0x1.aea52556b8dd2p+522,    0x1.594496778385bp-1,  -0x1.927bf2p-2, INEXACT)
T(RN,  0x1.d33031b816178p+522,    0x1.993cba87bbc55p-2,   0x1.fe22aap-2, INEXACT)
T(RN,  0x1.614f5b2fa69bfp+522,    0x1.84f310d5ff252p-3,    0x1.f767ap-3, INEXACT)
T(RN,  0x1.b929098ca3b8bp+522,   -0x1.8017fb6a7a1e2p-1,  -0x1.eb7a4ap-2, INEXACT)
T(RN,  0x1.4a7aed573d39ep+522,   -0x1.ffcee4ef40ab3p-1,   0x1.2d49e8p-2, INEXACT)
T(RN,  0x1.a2f14eea5c994p+522,   -0x1.d911c0b2271ecp-1,  -0x1.c4d002p-3, INEXACT)
T(RN,  0x1.65be01ac9feedp+522,   -0x1.b74434f827663p-2,   0x1.2d65fep-3, INEXACT)
T(RN,  0x1.c260fca687202p+522,   -0x1.a358afc1ad495p-1,  -0x1.922b56p-3, INEXACT)
T(RN,  0x1.9d3d92485e2b5p+523,    0x1.ffece5cab4ca5p-1,  -0x1.94ba8cp-2, INEXACT)
T(RN,  0x1.fa25fbd27edfap+523,    0x1.81cc51a66319bp-1,   -0x1.a4df3p-3, INEXACT)
T(RN,  0x1.a42a6eebb7f71p+523,   -0x1.f968fc227fe51p-1,   0x1.9f2764p-6, INEXACT)
T(RN,  0x1.b6a48aaad6974p+523,   -0x1.7d9e854156453p-1,   -0x1.cf40ep-2, INEXACT)
T(RN,  0x1.fa8cd38b7d9a4p+523,    0x1.649a2f25a14c4p-3,   0x1.51378ap-2, INEXACT)
T(RN,  0x1.05364f72a21f6p+523,   -0x1.fe6f73700e61dp-1,   0x1.8e8b9ap-3, INEXACT)
T(RN,  0x1.3f9a37c1bd7edp+523,    0x1.eb05d4db92d8bp-1,   0x1.a0be28p-2, INEXACT)
T(RN,  0x1.5cee755e395bfp+523,   -0x1.f9f615b29dcf4p-3,  -0x1.91add8p-2, INEXACT)
T(RN,  0x1.37023f5128a96p+523,    -0x1.49fbe028a9a9p-2,   0x1.f74184p-3, INEXACT)
T(RN,  0x1.12f9b4601cdb3p+523,   -0x1.7f696d5bc5bf9p-1,  -0x1.b5e1ccp-2, INEXACT)
T(RN,  0x1.fe4d0d9d611bdp+524,   -0x1.d4d4ca484a362p-1,   0x1.8f7886p-2, INEXACT)
T(RN,  0x1.51250b3431196p+524,   -0x1.5e81b638f6f3dp-1,   0x1.d3cafcp-8, INEXACT)
T(RN,   0x1.40b62646f60bp+524,   -0x1.2ea0749988fcap-2,   0x1.833b7ep-2, INEXACT)
T(RN,  0x1.30ea975956848p+524,    0x1.a6499a574de81p-1,   0x1.3c2ac4p-2, INEXACT)
T(RN,  0x1.0659a5ceaee36p+524,    0x1.b92d31716fdadp-3,  -0x1.b9d0a4p-6, INEXACT)
T(RN,  0x1.f9d3dd5cc1d2ep+524,   -0x1.7947945b61da7p-1,  -0x1.7642bap-2, INEXACT)
T(RN,  0x1.93f0dc89a271ep+524,    0x1.867ffd8050891p-1,   -0x1.219b6p-2, INEXACT)
T(RN,  0x1.54345d6cdf2c8p+524,    0x1.dc1d25cb0bdb4p-1,  -0x1.0222a4p-5, INEXACT)
T(RN,  0x1.2c662fd2adeb5p+524,   -0x1.7efa23d2286d3p-3,   0x1.e61946p-3, INEXACT)
T(RN,  0x1.68a9f04ac090ap+524,   -0x1.e17d52dd57f2dp-5,  -0x1.7ee77cp-2, INEXACT)
T(RN,  0x1.9a4bbf126c3cap+525,    0x1.691fead74301fp-2,   -0x1.3b534p-2, INEXACT)
T(RN,  0x1.9f4d539f41b84p+525,   -0x1.7e4b1fc15c932p-2,    0x1.e80edp-3, INEXACT)
T(RN,  0x1.587b4cb9e219cp+525,    0x1.b4bc4d53ad35ep-1,  -0x1.7aba52p-2, INEXACT)
T(RN,  0x1.05c22b15eac8fp+525,    0x1.d9979ee6a3774p-1,   0x1.cfde3cp-3, INEXACT)
T(RN,  0x1.1f2f32485a59ap+525,    0x1.f2675f4b0cf9fp-1,  -0x1.f6fb64p-2, INEXACT)
T(RN,  0x1.ad57bc0532892p+525,   -0x1.ba4894d1da874p-2,  -0x1.16f2e8p-2, INEXACT)
T(RN,  0x1.4e385586cc10ap+525,   -0x1.917f1959484f9p-1,   0x1.60b8bap-2, INEXACT)
T(RN,  0x1.35bea88752293p+525,    -0x1.d8ca042ab79fp-1,  -0x1.be3e4cp-6, INEXACT)
T(RN,  0x1.12f51789ea978p+525,   -0x1.a6ed5c270e617p-1,  -0x1.2904e2p-2, INEXACT)
T(RN,  0x1.cf6d208618c85p+525,    0x1.ee21f8433a2e7p-2,  -0x1.f79212p-2, INEXACT)
T(RN,  0x1.5adbe856bb932p+526,    0x1.6e02d9373d565p-1,  -0x1.d5ffa8p-2, INEXACT)
T(RN,   0x1.2122370bfa18p+526,   -0x1.382b8cc4c6dbep-3,    0x1.d800fp-2, INEXACT)
T(RN,  0x1.acb2cfd968a58p+526,    0x1.9478cca4237adp-1,   0x1.fe09b6p-2, INEXACT)
T(RN,  0x1.00d3898c4492bp+526,   -0x1.b126288e91a24p-3,  -0x1.820264p-2, INEXACT)
T(RN,  0x1.4249b440b8d32p+526,   -0x1.c1e779d8be015p-1,   0x1.a861c2p-3, INEXACT)
T(RN,  0x1.b3bd336b25a19p+526,    0x1.c683ea9affebbp-1,   0x1.f7704ap-4, INEXACT)
T(RN,  0x1.50263f47c2934p+526,   -0x1.45f818ee8870ep-1,  -0x1.b90536p-2, INEXACT)
T(RN,  0x1.e5d2fb7457569p+526,    0x1.faa2f6ecb8f08p-1,   0x1.4e6afap-2, INEXACT)
T(RN,  0x1.1469ee92a076ap+526,    0x1.9cef59852f69bp-2,  -0x1.9fa60ap-4, INEXACT)
T(RN,  0x1.717496e027711p+526,    0x1.367c2cb275c2dp-1,  -0x1.ba0a1ap-2, INEXACT)
T(RN,  0x1.e4196d335cdc4p+527,    0x1.bfba5f9ae225ap-2,  -0x1.5c5266p-2, INEXACT)
T(RN,  0x1.d23f8a50d23eep+527,    0x1.28d247d91c662p-1,  -0x1.83f104p-3, INEXACT)
T(RN,  0x1.a718bd772d17cp+527,    0x1.ea56d2338b0d9p-1,   0x1.38f514p-3, INEXACT)
T(RN,  0x1.2a825df65c3bcp+527,   -0x1.fac768946d479p-1,   0x1.260a08p-2, INEXACT)
T(RN,  0x1.4f52b691749d8p+527,   -0x1.ff9f916fb1a9ep-1,   0x1.47c15ap-2, INEXACT)
T(RN,  0x1.a3c026655d587p+527,   -0x1.e0bb902362807p-2,   0x1.812372p-3, INEXACT)
T(RN,  0x1.73b5efd814fa4p+527,   -0x1.ed544ea69adb2p-1,  -0x1.c3b172p-2, INEXACT)
T(RN,   0x1.facf4ae105ddp+527,    0x1.aa221016cf9b1p-1,   0x1.288aa8p-3, INEXACT)
T(RN,  0x1.119dc405be3ecp+527,    0x1.d9ae52be6c934p-2,   0x1.d71b84p-3, INEXACT)
T(RN,  0x1.bf64f1575a0fbp+527,   -0x1.75d0ba0ca3994p-1,   -0x1.c7428p-2, INEXACT)
T(RN,  0x1.a35a39d00dd06p+528,     0x1.f40d5b12f658p-1,   0x1.c1fa78p-2, INEXACT)
T(RN,  0x1.4f02bdad9b756p+528,   -0x1.0791a1c8d59f9p-1,  -0x1.5bb0b8p-2, INEXACT)
T(RN,  0x1.20825ba54c723p+528,   -0x1.330d4916277a5p-1,  -0x1.b6cc76p-5, INEXACT)
T(RN,  0x1.abe93b3951a51p+528,   -0x1.c2f3bb68969d6p-3,   -0x1.bac22p-2, INEXACT)
T(RN,  0x1.4c4f08220d2bap+528,   -0x1.ec72dc3320518p-1,   0x1.c10544p-2, INEXACT)
T(RN,  0x1.b45fbfe198919p+528,    0x1.fb40606132afbp-1,  -0x1.534f22p-3, INEXACT)
T(RN,  0x1.01b190e2b5973p+528,    0x1.dcbcabb81d67ep-1,  -0x1.cf3502p-2, INEXACT)
T(RN,  0x1.357d7c79415f2p+528,    0x1.e7a612b3a7187p-1,   0x1.fff8c8p-2, INEXACT)
T(RN,  0x1.5b82e3eb623c1p+528,   -0x1.2b0e090f486a6p-1,  -0x1.ce7bdcp-3, INEXACT)
T(RN,  0x1.f5c8b07c99692p+528,   -0x1.b5a5b7dde2109p-5,    0x1.a8442p-7, INEXACT)
T(RN,  0x1.0ea203594af6ap+529,   -0x1.e3131af01bef4p-5,   0x1.7f6a4ep-2, INEXACT)
T(RN,  0x1.d8a59a3214d9cp+529,   -0x1.857fbbcb8ad66p-4,   0x1.0445d6p-5, INEXACT)
T(RN,  0x1.d0216ed91e13ep+529,   -0x1.9c5ee202aa1efp-1,  -0x1.5db1fap-4, INEXACT)
T(RN,  0x1.9a629c63a2d3ep+529,    -0x1.fead48cb711ep-1,   0x1.1a8794p-3, INEXACT)
T(RN,  0x1.7cacb20e1de4ep+529,   -0x1.2f9527f889359p-1,  -0x1.7778e8p-2, INEXACT)
T(RN,  0x1.94ed871ffd875p+529,    0x1.d97456b51c049p-1,  -0x1.dda1f4p-2, INEXACT)
T(RN,  0x1.2331b38fe2982p+529,   -0x1.a8930a750b884p-4,   0x1.f7ff02p-2, INEXACT)
T(RN,  0x1.f9566ec775384p+529,   -0x1.694952f47b44cp-3,  -0x1.fce17ap-2, INEXACT)
T(RN,  0x1.67a27d877c728p+529,    0x1.c82c23aeb8f33p-2,    0x1.b6bc9p-3, INEXACT)
T(RN,  0x1.075bf74590644p+529,   -0x1.c79f324f72516p-2,   0x1.f70f64p-2, INEXACT)
T(RN,  0x1.3bf6874b5a34ap+530,   -0x1.fbb534b2381d2p-3,   0x1.cf1e2ep-3, INEXACT)
T(RN,  0x1.62dc93cc8a95cp+530,    0x1.eee491d2a1bbap-1,   0x1.e4c1d2p-5, INEXACT)
T(RN,  0x1.9c2226dd653c6p+530,   -0x1.ea72559c83337p-1,  -0x1.987dc6p-2, INEXACT)
T(RN,  0x1.47d444b71dc0ap+530,    0x1.cd4533116efbep-1,  -0x1.34241cp-2, INEXACT)
T(RN,  0x1.8fc6d2441cfeap+530,    0x1.d1be8a1054488p-2,  -0x1.139f72p-3, INEXACT)
T(RN,  0x1.e4274b19a0aa3p+530,    0x1.f5954ce5a6a37p-1,  -0x1.d9aa5ap-2, INEXACT)
T(RN,  0x1.60cfad2398ec2p+530,    0x1.945b04c600245p-1,  -0x1.eeb5c2p-2, INEXACT)
T(RN,  0x1.f93ae272d8809p+530,   -0x1.09008448c576bp-1,  -0x1.a21fc2p-2, INEXACT)
T(RN,  0x1.56b9dc5970bf9p+530,   -0x1.d4f2359f3a16ep-1,   0x1.82b4d4p-2, INEXACT)
T(RN,  0x1.bdf2d1ec1fe0cp+530,    0x1.9d64617a66236p-1,   0x1.77ec3cp-3, INEXACT)
T(RN,  0x1.b3c2c232baaf2p+531,     0x1.c2e212c436d1p-4,  -0x1.c57d22p-5, INEXACT)
T(RN,  0x1.bd124aebbecb4p+531,     0x1.f370279b5dafp-1,   0x1.41bf92p-3, INEXACT)
T(RN,  0x1.1c838c2a4620dp+531,   -0x1.e0d35a5a87662p-1,   0x1.880544p-2, INEXACT)
T(RN,  0x1.5283ac7656c14p+531,    0x1.c054ec8030d97p-2,   0x1.c36806p-3, INEXACT)
T(RN,  0x1.3055bde3092c6p+531,   -0x1.dd1219a49acf3p-1,  -0x1.6c1c18p-2, INEXACT)
T(RN,  0x1.d852d2a3c2e22p+531,   -0x1.f74bae5ed32a7p-1,   0x1.93e0e4p-2, INEXACT)
T(RN,  0x1.948a4f9e46324p+531,   -0x1.fe7dc4457e811p-1,  -0x1.043e9ep-2, INEXACT)
T(RN,  0x1.b03c9ad2a25efp+531,    0x1.394e73a649c76p-1,   0x1.451e44p-2, INEXACT)
T(RN,  0x1.566d54b8ee4e6p+531,    0x1.2de062cd943fep-2,  -0x1.059f68p-2, INEXACT)
T(RN,  0x1.1cc13db767fb7p+531,   -0x1.ffbbb74f17fe6p-1,  -0x1.906296p-4, INEXACT)
T(RN,  0x1.258afeb4e1604p+532,    0x1.a9cab57a4ae6ap-4,  -0x1.41a816p-2, INEXACT)
T(RN,  0x1.3477536d86453p+532,   -0x1.18d804bd1c01dp-1,  -0x1.ba0492p-2, INEXACT)
T(RN,  0x1.1d21cca2fad79p+532,   -0x1.3b92fc845a2afp-1,   0x1.791d0ap-4, INEXACT)
T(RN,  0x1.e9df890b0680ep+532,   -0x1.48bd6b07f2dadp-3,   -0x1.b8958p-3, INEXACT)
T(RN,  0x1.f42d370bc8acbp+532,   -0x1.fd258adebf51dp-1,  -0x1.c4ec6cp-2, INEXACT)
T(RN,  0x1.83b9e2466a528p+532,    0x1.d6e83f8958a1ap-1,    0x1.855f4p-2, INEXACT)
T(RN,  0x1.9c1542882e998p+532,    0x1.c907ddc909112p-1,   0x1.48ff84p-3, INEXACT)
T(RN,  0x1.f944c3dbe1366p+532,   -0x1.9599d9a507d54p-1,  -0x1.57aafep-2, INEXACT)
T(RN,  0x1.df7e0846e5f5dp+532,    0x1.6b25702c19702p-1,  -0x1.7247dep-6, INEXACT)
T(RN,  0x1.4f01890326058p+532,   -0x1.dbb43513a5e65p-1,   0x1.cb9e92p-4, INEXACT)
T(RN,    0x1.d14e7e07fb6p+533,    0x1.c84a2c90a1254p-1,   0x1.002782p-2, INEXACT)
T(RN,  0x1.d3030a4333fc5p+533,   -0x1.166c1f8adcdefp-1,  -0x1.2ac1e6p-3, INEXACT)
T(RN,  0x1.cc4f315788ab8p+533,   -0x1.dc1d6fb3ebe8dp-2,   0x1.3a2f62p-2, INEXACT)
T(RN,  0x1.af9c219ae1215p+533,   -0x1.d1c273dac3dd3p-1,   0x1.455a0ep-2, INEXACT)
T(RN,  0x1.2d2ab6bb8660ep+533,    0x1.7fd84101029dfp-1,    0x1.4738bp-4, INEXACT)
T(RN,  0x1.d15083174c61cp+533,    0x1.4a29d82322e5ep-1,  -0x1.2d2232p-3, INEXACT)
T(RN,  0x1.57a8756bcbb7cp+533,   -0x1.e31c13bc3c3fcp-2,  -0x1.b3a7cap-2, INEXACT)
T(RN,  0x1.f1234c86668b4p+533,    0x1.e37c657626d24p-1,    0x1.51577p-2, INEXACT)
T(RN,  0x1.faf03f92e7117p+533,    0x1.37d3adba2948ap-1,   0x1.4f8906p-3, INEXACT)
T(RN,  0x1.8598630872462p+533,     0x1.01a92339a641p-3,  -0x1.8ae834p-2, INEXACT)
T(RN,  0x1.5851acc95cc77p+534,    0x1.e425611311e56p-1,  -0x1.482964p-7, INEXACT)
T(RN,   0x1.58833ebea674p+534,   -0x1.fd3998f26b3c5p-1,   0x1.5a3d96p-2, INEXACT)
T(RN,  0x1.0f7ab73f8c7a1p+534,    0x1.f11383441ea67p-1,  -0x1.9239f4p-5, INEXACT)
T(RN,  0x1.6e253d928e415p+534,   -0x1.f8f3472dc11a8p-1,   0x1.b9f6acp-2, INEXACT)
T(RN,  0x1.8c24cbbb0a34ap+534,   -0x1.434892cc80761p-1,  -0x1.551616p-4, INEXACT)
T(RN,  0x1.575bbf61528a8p+534,   -0x1.86315040ca221p-1,    0x1.4d14ep-2, INEXACT)
T(RN,  0x1.440a898bf7e16p+534,   -0x1.a592e2ee422c2p-1,  -0x1.dce78cp-2, INEXACT)
T(RN,  0x1.d3bbc562870ecp+534,   -0x1.9f7f7a219ea4dp-2,  -0x1.1990eep-4, INEXACT)
T(RN,  0x1.2e6f339d44bf5p+534,    0x1.90e0e2dd5706ep-1,   0x1.ce6594p-4, INEXACT)
T(RN,  0x1.0c6285fe7fe7fp+534,   -0x1.39db91df1c5e2p-1,   -0x1.b894ap-3, INEXACT)
T(RN,  0x1.3bf4206054398p+535,     0x1.f11a60a34b06p-1,  -0x1.9d66ecp-3, INEXACT)
T(RN,  0x1.c51e895d9121ap+535,   -0x1.1d44c0375feeap-1,  -0x1.d489d8p-2, INEXACT)
T(RN,  0x1.8f840b06162aap+535,    0x1.e291763c80468p-1,    0x1.3aec4p-3, INEXACT)
T(RN,  0x1.c341adb90fb83p+535,    0x1.c9156b20608e9p-1,   0x1.88396p-15, INEXACT)
T(RN,  0x1.3f5210ca1127cp+535,   -0x1.de44515562791p-1,   0x1.1a5f0ep-3, INEXACT)
T(RN,  0x1.db22cda9ce87ap+535,    0x1.a24db92bb6451p-1,   0x1.2a5b04p-2, INEXACT)
T(RN,  0x1.4110f24f3d114p+535,    0x1.dbf0ce9472b63p-3,  -0x1.479954p-6, INEXACT)
T(RN,  0x1.7af60e8e60c3ep+535,   -0x1.ed6eb4c4a4515p-1,  -0x1.386776p-2, INEXACT)
T(RN,  0x1.125bccb382e0dp+535,    0x1.eb57ee0d8e4eep-1,   0x1.9b77c2p-5, INEXACT)
T(RN,  0x1.7db6f0f7f711ep+535,     0x1.2603cef18e11p-3,   0x1.531c7ap-3, INEXACT)
T(RN,  0x1.df91828a26436p+536,   -0x1.8b60993556d07p-1,  -0x1.defdb4p-2, INEXACT)
T(RN,  0x1.4df9833455566p+536,    0x1.df28704b90b73p-1,  -0x1.9465fcp-3, INEXACT)
T(RN,  0x1.18a8db019c42fp+536,    0x1.7f56cbdf6b1dep-1,  -0x1.ca117ap-3, INEXACT)
T(RN,  0x1.3cc5de4ac2d53p+536,   -0x1.f3e17962e1072p-2,   0x1.d2e6e6p-3, INEXACT)
T(RN,  0x1.91884fb7fb7e8p+536,   -0x1.9f3c74c3e15bfp-1,    0x1.ad06bp-3, INEXACT)
T(RN,  0x1.2f511aa634374p+536,    0x1.7dc91e0b56449p-6,    0x1.6f638p-5, INEXACT)
T(RN,  0x1.fde98dc2d64a6p+536,   -0x1.d58d3de1182e1p-2,  -0x1.4b5742p-3, INEXACT)
T(RN,  0x1.cba232d265862p+536,   -0x1.16808909dcdf7p-1,   0x1.b98d76p-2, INEXACT)
T(RN,  0x1.5034387ad3c76p+536,    0x1.ffec3974e334cp-1,  -0x1.821c8ep-7, INEXACT)
T(RN,  0x1.7b636d880dff4p+536,   -0x1.c4b78b78c8ac6p-1,   0x1.e2c5a2p-2, INEXACT)
T(RN,  0x1.200c8f5443df6p+537,   -0x1.a446171924311p-1,   0x1.c47e34p-4, INEXACT)
T(RN,  0x1.74df813828728p+537,    0x1.5cb20a8369e3dp-9,   0x1.2cef22p-2, INEXACT)
T(RN,  0x1.4e37259c214a8p+537,    -0x1.fefc12824ff5p-1,  -0x1.789e58p-2, INEXACT)
T(RN,  0x1.e7c2967c4bccap+537,    -0x1.07541f6104b1p-1,   0x1.aef522p-2, INEXACT)
T(RN,  0x1.33a727e370a7dp+537,   -0x1.e705902c11b43p-1,   0x1.36dfdcp-5, INEXACT)
T(RN,  0x1.b7e8f9bb30258p+537,    0x1.18a5318057d14p-1,   0x1.fafca4p-2, INEXACT)
T(RN,  0x1.3213a8410ccf4p+537,    0x1.fc22ee654479dp-1,   0x1.1a1ae2p-2, INEXACT)
T(RN,  0x1.38c3e7c32451dp+537,    0x1.6218b73cbb569p-1,  -0x1.307808p-8, INEXACT)
T(RN,  0x1.691eda7fb487cp+537,   -0x1.fa25ce5847cb3p-2,   0x1.97a4d4p-5, INEXACT)
T(RN,  0x1.9758d78699c5ap+537,   -0x1.e00340023e705p-1,  -0x1.a877dep-3, INEXACT)
T(RN,  0x1.fd8b5eca97a9ap+538,    0x1.ff4280f31cd77p-2,   0x1.02a342p-2, INEXACT)
T(RN,  0x1.a337089b4a5dcp+538,    0x1.ee9cd6f0cb34cp-2,    0x1.0c278p-2, INEXACT)
T(RN,  0x1.482a2f3e35b53p+538,    0x1.01ab5a5d03164p-2,  -0x1.b9af82p-3, INEXACT)
T(RN,  0x1.995626a6a78b8p+538,   -0x1.0f58a660efaf6p-1,   0x1.b1e792p-2, INEXACT)
T(RN,  0x1.a0a01ca66dbc2p+538,   -0x1.26de50ffb3d51p-2,   0x1.1dc7ecp-2, INEXACT)
T(RN,  0x1.3e582cae8ad16p+538,    0x1.c9f8abf76fca7p-1,   0x1.197cf6p-8, INEXACT)
T(RN,  0x1.c2655c4568e52p+538,    0x1.fc534d01db873p-2,  -0x1.5c2ce8p-6, INEXACT)
T(RN,  0x1.bc6a84d9fa3e6p+538,    0x1.44593bf222c21p-2,  -0x1.0cd564p-2, INEXACT)
T(RN,  0x1.13e3fbeaf7ccap+538,   -0x1.55745769718fbp-3,   0x1.1efce4p-3, INEXACT)
T(RN,  0x1.15f8f1516b3f6p+538,    0x1.66dfade2f2e2cp-1,   0x1.f5b956p-2, INEXACT)
T(RN,  0x1.c9eb2be904e0ep+539,    -0x1.8f89a6cd37eap-2,    0x1.38d5ap-2, INEXACT)
T(RN,  0x1.b4189706c6574p+539,    0x1.5cf874b6433d5p-2,   -0x1.87fd7p-2, INEXACT)
T(RN,  0x1.c1110161de18cp+539,    0x1.677103b27653ap-3,   -0x1.bb1c5p-3, INEXACT)
T(RN,  0x1.6f7e8a12933b8p+539,    0x1.205e395731fc2p-1,   0x1.08b8cap-3, INEXACT)
T(RN,  0x1.1db993ce64601p+539,    0x1.ee84f90d6b868p-2,   0x1.b87852p-2, INEXACT)
T(RN,  0x1.d82a69839adfdp+539,    0x1.a9b8163eaed9dp-2,  -0x1.93620ep-2, INEXACT)
T(RN,  0x1.370c477e7dfd6p+539,   -0x1.9fa817d48313ap-2,   0x1.cb5ab8p-5, INEXACT)
T(RN,  0x1.a5af01cfb9cd6p+539,   -0x1.fa92ce0bd4a21p-1,   0x1.40123ap-5, INEXACT)
T(RN,  0x1.61cf25c273ec1p+539,    0x1.d1c2b09b130bdp-1,   0x1.85d4ecp-2, INEXACT)
T(RN,  0x1.8068033525953p+539,   -0x1.8c16ff022bebep-1,   0x1.d596a8p-2, INEXACT)
T(RN,  0x1.9e797542b5abcp+540,   -0x1.eddfb5522eebbp-3,    0x1.6572ep-2, INEXACT)
T(RN,  0x1.0071627499cfep+540,   -0x1.ffb27ec5422a1p-1,   -0x1.8bc9bp-3, INEXACT)
T(RN,  0x1.153c787c1c07ep+540,   -0x1.6cd7b0bd2f0a1p-1,  -0x1.1fca92p-2, INEXACT)
T(RN,  0x1.722f32e6619a1p+540,   -0x1.d3feb7db27f09p-1,   0x1.faf108p-3, INEXACT)
T(RN,   0x1.c18dc6c696d6p+540,     0x1.07a8875029ccp-1,   0x1.028ebap-3, INEXACT)
T(RN,  0x1.706934d913b5cp+540,    0x1.3d1f6e97e5febp-1,  -0x1.534776p-4, INEXACT)
T(RN,  0x1.4ecd1dd9d9e11p+540,   -0x1.010f32aa2567ap-4,   0x1.8ba2eep-2, INEXACT)
T(RN,  0x1.5f551ff907f58p+540,    0x1.ee5200637733bp-1,   0x1.9cec5ep-3, INEXACT)
T(RN,  0x1.e02fc8c89a25dp+540,   -0x1.c12ac0b602bcfp-1,   0x1.3326a8p-2, INEXACT)
T(RN,  0x1.e6d05952d4f1ep+540,    0x1.dda865716eb7bp-1,  -0x1.b688cap-4, INEXACT)
T(RN,  0x1.1161898828293p+541,   -0x1.332c563c10b6dp-2,   0x1.fad36ap-2, INEXACT)
T(RN,  0x1.4c98775353486p+541,   -0x1.a03b7178037a2p-1,   0x1.17e43ep-2, INEXACT)
T(RN,  0x1.8a58253482e86p+541,   -0x1.a9a42130563fep-1,   0x1.91135ep-3, INEXACT)
T(RN,  0x1.2f65f29a1d389p+541,    0x1.742ce38fdbb47p-1,  -0x1.0f66d8p-4, INEXACT)
T(RN,  0x1.569abba107d15p+541,   -0x1.71caa7f65f043p-4,   0x1.897782p-3, INEXACT)
T(RN,  0x1.c1fbd230b3704p+541,    -0x1.5047e5478836p-2,    0x1.2a445p-7, INEXACT)
T(RN,  0x1.aa5301199264cp+541,    0x1.5ac024f44dfedp-1,  -0x1.9ea3b8p-3, INEXACT)
T(RN,  0x1.19fd3f94ba47bp+541,    0x1.9e7f6dfc1802dp-1,   -0x1.f2ce5p-2, INEXACT)
T(RN,  0x1.8c2dbefc85949p+541,    0x1.4705510b50043p-2,   0x1.ba7508p-4, INEXACT)
T(RN,  0x1.a30c849ec6315p+541,   -0x1.aff1b50295239p-1,  -0x1.0d4e74p-3, INEXACT)
T(RN,  0x1.606f735e49c42p+542,   -0x1.fec90b908b349p-2,    0x1.08491p-2, INEXACT)
T(RN,  0x1.4abc9b439b7d8p+542,    -0x1.94e4c5b44dbbp-1,   0x1.13964ep-4, INEXACT)
T(RN,  0x1.7bb1ac394d62bp+542,    0x1.6989be5f86272p-2,   0x1.b0a9eap-2, INEXACT)
T(RN,  0x1.31e30a0711d5cp+542,    0x1.ba358ffa71d98p-1,  -0x1.d67c82p-2, INEXACT)
T(RN,  0x1.c04dfd6e0bcd1p+542,    0x1.ead52b7cf29cbp-1,    0x1.7e5fdp-2, INEXACT)
T(RN,  0x1.6a149badaf787p+542,    0x1.4dd09f10a93d8p-8,   0x1.c5f4cap-5, INEXACT)
T(RN,  0x1.a079f4f6f09d4p+542,   -0x1.613368e91ec3cp-1,  -0x1.dceb98p-2, INEXACT)
T(RN,  0x1.74f07071f8699p+542,   -0x1.54fd9b011ab3bp-1,   0x1.8b173ap-4, INEXACT)
T(RN,  0x1.a62dcc85c0a75p+542,    0x1.13fa40ab27b43p-1,  -0x1.cd8d24p-2, INEXACT)
T(RN,  0x1.e764ed682d77cp+542,    0x1.cb62705845af2p-1,  -0x1.c2ba56p-2, INEXACT)
T(RN,  0x1.2d9241b0a8281p+543,   -0x1.e2d6f93cd20ecp-1,  -0x1.024956p-3, INEXACT)
T(RN,  0x1.605394bf493ccp+543,    0x1.aea4f61324bbap-1,   0x1.d47944p-3, INEXACT)
T(RN,  0x1.24b96836b8046p+543,   -0x1.91be782b6dcf9p-1,  -0x1.13c32ep-9, INEXACT)
T(RN,  0x1.7229c24979c0bp+543,   -0x1.ffe44b0236119p-1,   0x1.4d5f9cp-3, INEXACT)
T(RN,  0x1.5c5e3ef3d8899p+543,   -0x1.cb8a1707c7ac1p-1,   0x1.16ab72p-6, INEXACT)
T(RN,  0x1.397e452e1d99ap+543,   -0x1.f316e26d079afp-1,  -0x1.8bc0a8p-3, INEXACT)
T(RN,   0x1.3684f1526e11p+543,    0x1.df37b0d844ecdp-1,  -0x1.f03334p-2, INEXACT)
T(RN,  0x1.eefb98107c5cap+543,   -0x1.20d7ef02470d8p-3,  -0x1.2a8b2ep-2, INEXACT)
T(RN,  0x1.78084fc09d4fep+543,    0x1.1819a67ac3404p-2,  -0x1.15224ap-3, INEXACT)
T(RN,  0x1.c35ae843b9289p+543,   -0x1.e02b50c6c4432p-2,  -0x1.223bc2p-6, INEXACT)
T(RN,  0x1.b7e7d5dbfe198p+544,   -0x1.e16f758062faep-1,  -0x1.2997bap-2, INEXACT)
T(RN,  0x1.e72e5b590c588p+544,   -0x1.397a023e7f6c2p-5,   0x1.125584p-3, INEXACT)
T(RN,  0x1.2e45ee06c8b45p+544,    0x1.033adaaad621cp-1,  -0x1.6b2e9ep-2, INEXACT)
T(RN,  0x1.764f66be62fffp+544,    0x1.440f25ace1d86p-1,   0x1.f5551cp-2, INEXACT)
T(RN,  0x1.ab9c79555d8c4p+544,   -0x1.ffc43047c4965p-1,   0x1.633066p-2, INEXACT)
T(RN,  0x1.9c2117794d2c2p+544,     0x1.21938001cccbp-1,   0x1.58446ep-2, INEXACT)
T(RN,  0x1.023ad04f4ed2dp+544,   -0x1.799c7719cc95ap-1,    0x1.130eap-2, INEXACT)
T(RN,  0x1.69a9722f336f4p+544,    0x1.165dfb876afb9p-2,  -0x1.247e44p-2, INEXACT)
T(RN,  0x1.23d997ca546fap+544,   -0x1.ff4c0da42e679p-1,  -0x1.9f3628p-3, INEXACT)
T(RN,  0x1.09bd3a2913392p+544,   -0x1.89517c1e1100cp-2,   0x1.b09a28p-3, INEXACT)
T(RN,  0x1.823ca35a1be06p+545,    0x1.f3892c780493fp-3,  -0x1.2b0d36p-2, INEXACT)
T(RN,  0x1.d21ac7c5aa231p+545,   -0x1.687178bb283a3p-3,  -0x1.118584p-3, INEXACT)
T(RN,  0x1.3953701d28048p+545,    0x1.f68414eade69fp-1,   0x1.e73494p-2, INEXACT)
T(RN,  0x1.39ff2050f5d14p+545,    -0x1.4a79a57743a7p-3,  -0x1.87ea24p-3, INEXACT)
T(RN,  0x1.43aa4bb6d6576p+545,    0x1.c211e9418c30cp-1,  -0x1.05182cp-2, INEXACT)
T(RN,  0x1.2432d3762bd57p+545,    0x1.f5b966910f023p-1,    0x1.64c88p-2, INEXACT)
T(RN,  0x1.ed10d220425dap+545,    0x1.4b3b3c4a5fa7dp-1,   0x1.3acc0cp-2, INEXACT)
T(RN,  0x1.961859dbf7e1ap+545,    0x1.a53e8205dfd02p-2,  -0x1.4edc6ep-3, INEXACT)
T(RN,  0x1.c8f84c44aecdap+545,    -0x1.fc4950aedb24p-2,  -0x1.036196p-2, INEXACT)
T(RN,  0x1.6827c7d687c5dp+545,   -0x1.8061056e54bf7p-2,   0x1.b6c114p-3, INEXACT)
T(RN,  0x1.37ab4b12a37eap+546,   -0x1.b84de15961191p-1,   0x1.5d1164p-2, INEXACT)
T(RN,    0x1.6f1f5787b7dp+546,    0x1.8cd91fdd26359p-1,  -0x1.16b55ap-7, INEXACT)
T(RN,  0x1.b2b1a08a3688fp+546,    0x1.4f59eac9b4717p-1,    0x1.de448p-3, INEXACT)
T(RN,  0x1.ae47868427592p+546,    0x1.d642a0f458492p-1,  -0x1.268046p-2, INEXACT)
T(RN,  0x1.cfbca10939e0cp+546,    0x1.eeb4ed48b8e2fp-1,   -0x1.3ffc9p-6, INEXACT)
T(RN,  0x1.bf3a9d42bbddep+546,   -0x1.b41529e31355ap-5,  -0x1.938e3cp-2, INEXACT)
T(RN,  0x1.c7e89f9bcd956p+546,   -0x1.c86aec0a48be7p-1,   0x1.ace3c6p-2, INEXACT)
T(RN,  0x1.b9053e909f53ap+546,    0x1.f546ad2af3b96p-1,  -0x1.a59676p-2, INEXACT)
T(RN,  0x1.1c32766eebf8bp+546,   -0x1.f34041c022ef3p-1,  -0x1.d86e84p-3, INEXACT)
T(RN,  0x1.862e1ec6d24bfp+546,    0x1.39cb2e8086a36p-2,  -0x1.06358cp-2, INEXACT)
T(RN,  0x1.c0552f1d40386p+547,    0x1.598de6f0741bbp-2,  -0x1.adfafep-3, INEXACT)
T(RN,  0x1.4279f67abd07fp+547,    0x1.db558068e0d33p-2,   0x1.be1876p-4, INEXACT)
T(RN,  0x1.149b1c1e51d97p+547,   -0x1.58ded98223f1fp-1,   0x1.a2a4cap-2, INEXACT)
T(RN,  0x1.0eabbed3fdab3p+547,    0x1.731ef1440ac01p-7,   0x1.13e336p-3, INEXACT)
T(RN,  0x1.57babe687082dp+547,    0x1.a9136fafc9bb1p-1,   0x1.d18c32p-3, INEXACT)
T(RN,  0x1.a1d1342c010c2p+547,    -0x1.2ca75b84d22cp-1,  -0x1.3ab05ap-3, INEXACT)
T(RN,  0x1.7fc349ef2012ep+547,   -0x1.0a0df8698242ap-1,  -0x1.acfc4cp-2, INEXACT)
T(RN,  0x1.5e223408015f8p+547,    0x1.d824d5cc0f802p-1,  -0x1.da0f12p-3, INEXACT)
T(RN,  0x1.26a3d12b064c6p+547,    0x1.ffa8da6b0cfc2p-1,   0x1.fa42bcp-4, INEXACT)
T(RN,  0x1.3c4118fde1b77p+547,    0x1.f13a7d5e42213p-1,   0x1.409b0ap-2, INEXACT)
T(RN,  0x1.83554d0c0aa38p+548,    0x1.bf2fbae4f05b3p-2,  -0x1.c49edcp-3, INEXACT)
T(RN,  0x1.cf70239645212p+548,   -0x1.91a13370c75c5p-1,   0x1.f889d2p-2, INEXACT)
T(RN,  0x1.20a53dbf884a6p+548,    0x1.0607c2a683eb4p-1,   0x1.288916p-2, INEXACT)
T(RN,  0x1.9e7872ec0b04ap+548,    0x1.eada7ff2c51f9p-1,  -0x1.f084a6p-5, INEXACT)
T(RN,  0x1.be259ffd8b62ep+548,    -0x1.ea822ce9b364p-4,  -0x1.6451ecp-2, INEXACT)
T(RN,  0x1.bbcb95a4eff36p+548,    0x1.7387be4dcad95p-1,   0x1.2e3836p-3, INEXACT)
T(RN,   0x1.4fad16267d9fp+548,    0x1.df23b2937ababp-1,   0x1.26eadap-2, INEXACT)
T(RN,  0x1.d1fb9badc0ef4p+548,   -0x1.050d4f109b32fp-2,  -0x1.0a46e6p-7, INEXACT)
T(RN,  0x1.3a71c58366fc2p+548,    0x1.6fa9918d0e5d9p-1,  -0x1.d21bccp-2, INEXACT)
T(RN,  0x1.abab81b889188p+548,   -0x1.b9aa4d5de1054p-1,   0x1.3565c4p-2, INEXACT)
T(RN,  0x1.773da89e913ffp+549,    0x1.56ac5cc6c9daap-3,  -0x1.8438c2p-4, INEXACT)
T(RN,  0x1.c87054d9b1cc8p+549,    0x1.e479e95caff3ap-1,  -0x1.f2e152p-2, INEXACT)
T(RN,   0x1.881a33d85884p+549,   -0x1.982770d9e2e12p-1,   0x1.2d7d08p-5, INEXACT)
T(RN,  0x1.f837381518855p+549,    0x1.d2cb8925f8a44p-1,   0x1.b55e82p-3, INEXACT)
T(RN,  0x1.bc239552a432cp+549,   -0x1.c2c099c0f4169p-1,   0x1.4b7f18p-3, INEXACT)
T(RN,  0x1.e1f70467f9782p+549,   -0x1.6c617ffdc4c78p-1,   0x1.409488p-3, INEXACT)
T(RN,  0x1.ab0d7d8f2f0d8p+549,    0x1.a0626faae4b17p-2,   0x1.c9fd24p-2, INEXACT)
T(RN,  0x1.ef4e0f3a55336p+549,    0x1.7fb7009341738p-1,   0x1.300406p-3, INEXACT)
T(RN,  0x1.9f017aaf15622p+549,    0x1.b8865308e50d5p-4,  -0x1.ba8e66p-2, INEXACT)
T(RN,  0x1.e40b38d0e45a5p+549,    0x1.c2a36d150cebap-1,   0x1.96dfe4p-2, INEXACT)
T(RN,  0x1.2d8cadaf4dcacp+550,    0x1.f67025d99e314p-1,  -0x1.c0afb6p-4, INEXACT)
T(RN,  0x1.f2053ab905916p+550,    0x1.f004225052065p-1,  -0x1.e4508ep-6, INEXACT)
T(RN,  0x1.ee58c3b530d9bp+550,    0x1.6d798d0fced68p-1,  -0x1.a0d198p-2, INEXACT)
T(RN,  0x1.b40cfcdf138bap+550,   -0x1.da0b7b40ad81bp-1,   0x1.a8a09ep-3, INEXACT)
T(RN,  0x1.c739ad4a978eap+550,   -0x1.bbc4d93fa0511p-3,   0x1.69f588p-3, INEXACT)
T(RN,  0x1.d9653febbaa4cp+550,     0x1.d9f2759ee0c2p-1,   0x1.b2b01ep-3, INEXACT)
T(RN,  0x1.f860e56507a7fp+550,    0x1.6ab5d589bf5c6p-1,  -0x1.9baa9ap-3, INEXACT)
T(RN,  0x1.6cd074c5d5d7dp+550,   -0x1.86fe74bc75fabp-1,   0x1.54d996p-2, INEXACT)
T(RN,  0x1.2308e941fdfaap+550,    0x1.16bee144c23bep-1,   0x1.884244p-2, INEXACT)
T(RN,  0x1.82ec64ee3a316p+550,    0x1.d5db46074ed1dp-1,  -0x1.a0609ap-2, INEXACT)
T(RN,  0x1.e6e1f80af1fadp+551,   -0x1.ccaa53484983cp-2,  -0x1.f9c67ep-2, INEXACT)
T(RN,  0x1.9659bd679977ep+551,    0x1.318a1de78299bp-2,  -0x1.1de0e6p-3, INEXACT)
T(RN,  0x1.8ea594908521fp+551,    0x1.7a20821073fcdp-1,   0x1.a5edf2p-2, INEXACT)
T(RN,  0x1.b38e8111967d8p+551,    0x1.342e15da868eep-4,  -0x1.190f42p-2, INEXACT)
T(RN,  0x1.55e06a5386799p+551,    0x1.ff42b6fd19ac3p-1,  -0x1.f267aep-3, INEXACT)
T(RN,  0x1.f7b11e0b2a2b4p+551,    0x1.fa6b2db2768e7p-1,    -0x1.8f2cp-3, INEXACT)
T(RN,  0x1.568e4af6be243p+551,    -0x1.fe5054478cc8p-1,  -0x1.0c3b1ep-2, INEXACT)
T(RN,  0x1.91216699c0216p+551,    0x1.1a939e0833658p-1,  -0x1.8b0496p-2, INEXACT)
T(RN,  0x1.c9cf2caf72842p+551,    0x1.221df4e98d179p-2,   0x1.06182ap-4, INEXACT)
T(RN,   0x1.85b8e01d92d2p+551,    0x1.6ea4822db675ap-1,   0x1.e82574p-2, INEXACT)
T(RN,  0x1.ad9f779f94a9ep+552,    0x1.0e5b3d125f338p-1,   0x1.aafdf4p-2, INEXACT)
T(RN,  0x1.b47008eeb2ceap+552,    0x1.baa75f5a96349p-2,   0x1.9d7ec8p-3, INEXACT)
T(RN,  0x1.2f0a767d8fb4cp+552,   -0x1.38843b4518614p-1,  -0x1.99e268p-6, INEXACT)
T(RN,  0x1.df5c06b2d0884p+552,    0x1.b2871fd48151bp-1,  -0x1.030d9ap-3, INEXACT)
T(RN,  0x1.9606d89490357p+552,    0x1.99845808e338ap-4,   0x1.00ab96p-5, INEXACT)
T(RN,  0x1.4b8ceaf81aef9p+552,    0x1.3bec31821ce39p-2,   0x1.f11ca6p-4, INEXACT)
T(RN,  0x1.ea25a111d0cf4p+552,      0x1.105233c73c5p-2,   -0x1.42ca4p-5, INEXACT)
T(RN,  0x1.eecabb9f3c1f2p+552,    0x1.f97377c33488cp-1,   0x1.78f632p-2, INEXACT)
T(RN,  0x1.ef9dc6c70c2e8p+552,   -0x1.5bc30f21d05fcp-4,   0x1.05b97ep-3, INEXACT)
T(RN,  0x1.1188c083be65dp+552,    0x1.9067c94534e56p-1,   0x1.c024b2p-9, INEXACT)
T(RN,  0x1.5b938094d1757p+553,   -0x1.0bb51bba7d1b3p-1,  -0x1.dff114p-2, INEXACT)
T(RN,  0x1.389e0d4044786p+553,   -0x1.cfaf6b275b98ap-3,   0x1.c8d396p-4, INEXACT)
T(RN,  0x1.b381ca4c6026ap+553,    -0x1.eb0833c5f7a4p-1,  -0x1.527d6cp-2, INEXACT)
T(RN,  0x1.130b6d1516073p+553,    0x1.a2580a0889c24p-3,   0x1.ba36fcp-3, INEXACT)
T(RN,  0x1.89faa3eea586dp+553,   -0x1.b89d76089473fp-2,    0x1.486edp-3, INEXACT)
T(RN,  0x1.338662717ccc8p+553,   -0x1.dce0ba2566af4p-1,   0x1.9ac5cap-5, INEXACT)
T(RN,  0x1.500c68aff1b7ap+553,    0x1.ab82240d41147p-1,   0x1.1832e2p-7, INEXACT)
T(RN,  0x1.453812cb7a4a6p+553,    0x1.be4d790f4f2e2p-1,   0x1.513e68p-2, INEXACT)
T(RN,   0x1.2bb548a37108p+553,   -0x1.1ad7d9fe30c55p-3,  -0x1.955d2cp-5, INEXACT)
T(RN,  0x1.0896d5115d2c3p+553,    0x1.f9372be298f05p-1,   -0x1.350b5p-2, INEXACT)
T(RN,  0x1.ff30462582381p+554,   -0x1.d8a839395fc96p-1,  -0x1.b7c0eap-3, INEXACT)
T(RN,  0x1.9944c325f1766p+554,   -0x1.69b42c66c40f8p-1,  -0x1.f9afbap-3, INEXACT)
T(RN,  0x1.2ad79b0f0ff5ap+554,   -0x1.25a10e813eb0bp-5,  -0x1.f234b4p-3, INEXACT)
T(RN,  0x1.2c67e07db2b68p+554,    -0x1.2cc25a9b19c6p-1,   0x1.eeddecp-2, INEXACT)
T(RN,  0x1.d79f9c1277b28p+554,   -0x1.ff80076dececap-1,   0x1.1f8bcap-2, INEXACT)
T(RN,  0x1.9cc24b32dfca4p+554,   -0x1.f50676b24a9b4p-1,   0x1.65a49ep-3, INEXACT)
T(RN,   0x1.5b520f25cbd9p+554,    0x1.fbc6e6aafd66ep-1,   0x1.e632e8p-3, INEXACT)
T(RN,  0x1.6f60f9389f747p+554,   -0x1.43f6565ad616bp-2,   0x1.9fd39cp-2, INEXACT)
T(RN,  0x1.884ee9f05b1b4p+554,     0x1.b7531bf93633p-1,   -0x1.2184ep-4, INEXACT)
T(RN,  0x1.7d734ec98b19ep+554,   -0x1.8b627bb33c855p-1,   0x1.0fbee4p-2, INEXACT)
T(RN,  0x1.868608a97b4c6p+555,   -0x1.ddac377067289p-1,   0x1.e39c88p-2, INEXACT)
T(RN,  0x1.4d1392a8bd034p+555,   -0x1.db84a790f1d05p-1,  -0x1.072c66p-5, INEXACT)
T(RN,  0x1.1dfefceedaf1cp+555,    0x1.fe8bb0d6b8a52p-1,   0x1.bdd0a2p-4, INEXACT)
T(RN,  0x1.a5ed5a9385b71p+555,    0x1.43893f9235c5ap-4,   0x1.02341ap-3, INEXACT)
T(RN,  0x1.5fb86dd7c4221p+555,    0x1.862993f10ec3cp-1,  -0x1.fd0efap-4, INEXACT)
T(RN,  0x1.58e1166eb9539p+555,    -0x1.b62385a58c05p-1,   0x1.8dd174p-3, INEXACT)
T(RN,  0x1.21839e460fa86p+555,    0x1.d9489adb3d42dp-1,  -0x1.474c82p-3, INEXACT)
T(RN,  0x1.a88b9f2fe11a5p+555,   -0x1.30cd2200754edp-4,    0x1.a6157p-2, INEXACT)
T(RN,  0x1.4bee420ce5d41p+555,   -0x1.f008bf5fa30c6p-1,  -0x1.6abe52p-3, INEXACT)
T(RN,  0x1.e1da701ef12c8p+555,    -0x1.c3cf1a2cae42p-1,  -0x1.011c22p-3, INEXACT)
T(RN,  0x1.56739c9e6459ep+556,   -0x1.1b4ff74b90439p-1,   0x1.d43edep-5, INEXACT)
T(RN,   0x1.b926a1f9a51cp+556,    0x1.d76bf7cd0b6cfp-1,    0x1.726c3p-2, INEXACT)
T(RN,  0x1.ac91cf340da96p+556,    0x1.fd04bad598e62p-1,  -0x1.ce6022p-2, INEXACT)
T(RN,  0x1.89bd12301e745p+556,    0x1.f775f4f13b25ep-2,   0x1.62e2c2p-2, INEXACT)
T(RN,  0x1.68a74546b7602p+556,    0x1.7c35ef9682612p-3,     0x1.b18dp-2, INEXACT)
T(RN,  0x1.eb16ee81cbf62p+556,   -0x1.82045c56c8a47p-1,   0x1.82b2c4p-2, INEXACT)
T(RN,  0x1.d395df922625ap+556,    0x1.6fa17fb0fc038p-4,  -0x1.849e34p-2, INEXACT)
T(RN,  0x1.75ec1615c624dp+556,    0x1.f82f116beab71p-1,   0x1.26a3f2p-2, INEXACT)
T(RN,  0x1.323f528aa7bf6p+556,   -0x1.efb5c189c28ebp-1,   0x1.b02e94p-3, INEXACT)
T(RN,  0x1.6bf832b495e7bp+556,    -0x1.f5a466514815p-2,  -0x1.97da9cp-2, INEXACT)
T(RN,  0x1.aaba9d3bf3437p+557,    0x1.e49c94a53c957p-1,   0x1.385152p-3, INEXACT)
T(RN,  0x1.ad5cc82c829f8p+557,    0x1.fbdfef83f6a6cp-1,    0x1.640cdp-2, INEXACT)
T(RN,  0x1.99a4791b08fcep+557,   -0x1.ed1fb83a2c6cep-1,    0x1.2bfd9p-4, INEXACT)
T(RN,  0x1.b7880749faff6p+557,    0x1.94c6718effd07p-2,   -0x1.28a47p-3, INEXACT)
T(RN,  0x1.542e08eff68aep+557,    0x1.d636c4a62202ep-5,  -0x1.700788p-2, INEXACT)
T(RN,  0x1.8cbae61343c8cp+557,    0x1.fffffe8704e84p-1,   0x1.57be7cp-2, INEXACT)
T(RN,  0x1.d7a2084f41efep+557,    0x1.9c76a0391297ep-1,   0x1.b7a7cep-2, INEXACT)
T(RN,  0x1.3bdd90cdb4807p+557,    0x1.9b39a21661f99p-5,   0x1.d63674p-3, INEXACT)
T(RN,  0x1.fbaf469183886p+557,   -0x1.c4f48855452f2p-1,  -0x1.dacb44p-2, INEXACT)
T(RN,  0x1.8522d032e420ep+557,    0x1.30664faa2ba78p-3,   0x1.3b377ep-3, INEXACT)
T(RN,  0x1.3005cc6adcad5p+558,   -0x1.7073fee9d8259p-1,  -0x1.7b083ep-6, INEXACT)
T(RN,  0x1.56fc35f846b79p+558,   -0x1.0234c7263ca34p-3,  -0x1.1506bap-2, INEXACT)
T(RN,  0x1.c2bb810bf2ae4p+558,    0x1.fee2d80866a5bp-1,  -0x1.90cdeap-2, INEXACT)
T(RN,  0x1.d4e9f486c25a3p+558,   -0x1.99de780f6335fp-6,   0x1.fffdd2p-4, INEXACT)
T(RN,  0x1.b0e8c76afb242p+558,   -0x1.d7820f4323dd1p-1,  -0x1.de4a9cp-4, INEXACT)
T(RN,  0x1.7fff2cfe8c11fp+558,   -0x1.ff4c40b12e7d3p-1,   0x1.7e70e8p-2, INEXACT)
T(RN,   0x1.ba82ac7eddd7p+558,   -0x1.75047066bcefbp-1,  -0x1.530994p-5, INEXACT)
T(RN,  0x1.f22fded021309p+558,    0x1.f38584fc0416ep-2,  -0x1.410bc4p-5, INEXACT)
T(RN,  0x1.de4f316206a8dp+558,   -0x1.ea854821241f1p-2,  -0x1.09fbc4p-3, INEXACT)
T(RN,  0x1.a177624cc0864p+558,   -0x1.9776737be4be6p-1,   0x1.c65b62p-3, INEXACT)
T(RN,  0x1.75df6e23e94d2p+559,   -0x1.db3d511ff997bp-1,  -0x1.819ddcp-6, INEXACT)
T(RN,  0x1.f32c704b96393p+559,   -0x1.7322f76056d53p-2,  -0x1.dbbe24p-7, INEXACT)
T(RN,  0x1.a6dc528fb6bb4p+559,   -0x1.cf8473542f18ap-1,   0x1.1ea6e6p-3, INEXACT)
T(RN,  0x1.ab403255b69ddp+559,   -0x1.1717029afa5bcp-2,    0x1.121dcp-3, INEXACT)
T(RN,  0x1.f0da5ef170cd3p+559,    0x1.3aaee84b19e9dp-1,   0x1.f18b18p-2, INEXACT)
T(RN,  0x1.46405239c3d2cp+559,   -0x1.64c170f4b5af4p-2,  -0x1.385082p-6, INEXACT)
T(RN,  0x1.f3220060cdfa8p+559,   -0x1.65ed66cd474dbp-1,  -0x1.de57c6p-4, INEXACT)
T(RN,  0x1.f98103c33a80ap+559,    0x1.de06b91743439p-1,  -0x1.5e8e3ap-4, INEXACT)
T(RN,  0x1.53b91f72fa81bp+559,    0x1.0c464845779fap-1,  -0x1.aad084p-5, INEXACT)
T(RN,   0x1.8fdcfb953922p+559,    0x1.de020e1840854p-5,    0x1.dbbbep-2, INEXACT)
T(RN,  0x1.935d36bfd5adbp+560,   -0x1.f97eab6e515adp-1,   0x1.0b9146p-3, INEXACT)
T(RN,   0x1.75204708b57ap+560,   -0x1.c104c7e03e9c2p-3,   0x1.b30716p-2, INEXACT)
T(RN,  0x1.eb65ce0bfce7cp+560,    0x1.7fb5c15a7fe78p-2,   0x1.f1a042p-2, INEXACT)
T(RN,  0x1.0eb797b8efda4p+560,    0x1.c688f4f24da8ap-1,   0x1.d0280ap-6, INEXACT)
T(RN,  0x1.61a90d0c4ea1ap+560,    0x1.aae1201e35473p-1,   0x1.518076p-2, INEXACT)
T(RN,   0x1.bad75aedd3c9p+560,    0x1.edea91fb38721p-3,   0x1.6d7006p-4, INEXACT)
T(RN,  0x1.aaaeded1d7b0ap+560,    0x1.de77777b25388p-2,   0x1.fe669cp-3, INEXACT)
T(RN,  0x1.aa38f02850d88p+560,    0x1.1c81446d28c7ep-1,  -0x1.ed6cb2p-3, INEXACT)
T(RN,  0x1.6a60565d2f916p+560,   -0x1.c83277d3a3641p-1,   0x1.b4c902p-5, INEXACT)
T(RN,  0x1.0d27e0f40ae12p+560,    0x1.19d0b0689118ep-1,   -0x1.f4d85p-3, INEXACT)
T(RN,  0x1.dafc40c8c1e4cp+561,    0x1.e09ef4e206fbep-2,  -0x1.0b3e16p-2, INEXACT)
T(RN,  0x1.5db59d4d8b357p+561,    0x1.aed2af3443471p-2,   0x1.15577ep-2, INEXACT)
T(RN,  0x1.4c4dbcc296c08p+561,   -0x1.bdca97ef27261p-1,   0x1.1c04b4p-3, INEXACT)
T(RN,  0x1.5f64578a21a51p+561,   -0x1.fbc9dab92d889p-1,   -0x1.a8a17p-4, INEXACT)
T(RN,  0x1.c765ca5b2974ap+561,    0x1.4e5e69b224061p-1,  -0x1.be4144p-2, INEXACT)
T(RN,   0x1.2a1429f60774p+561,    0x1.c7354c42b5c01p-2,  -0x1.a2142cp-2, INEXACT)
T(RN,  0x1.0b004c0ebe32ep+561,   -0x1.679ae8bedc784p-1,   0x1.1be974p-2, INEXACT)
T(RN,  0x1.602ca04ac7d78p+561,    0x1.b62c6eac18cc2p-1,  -0x1.751966p-5, INEXACT)
T(RN,  0x1.26ce115e83c12p+561,    0x1.d159b4d4670c8p-2,   0x1.c0e182p-2, INEXACT)
T(RN,  0x1.12999205c6b2dp+561,     0x1.2272f2365457p-1,   0x1.e89092p-3, INEXACT)
T(RN,  0x1.55d0366f7e968p+562,    0x1.75115e2ace0d5p-1,   -0x1.cc10bp-2, INEXACT)
T(RN,  0x1.cfc573e421236p+562,   -0x1.05de74a2315a2p-3,  -0x1.513996p-6, INEXACT)
T(RN,  0x1.02a76e9370552p+562,   -0x1.e007a6c2a7655p-1,   0x1.b03c56p-3, INEXACT)
T(RN,  0x1.45ee65e7d3a9bp+562,    0x1.cbf38361a2981p-1,   -0x1.745ffp-2, INEXACT)
T(RN,  0x1.efc43a5f34c92p+562,    0x1.deeeb967d1c7bp-1,  -0x1.f898e2p-3, INEXACT)
T(RN,  0x1.ee5cda7944d61p+562,    0x1.10f5eed8a6568p-2,  -0x1.4ac874p-4, INEXACT)
T(RN,  0x1.c08ada74807dep+562,   -0x1.06aaca10d5874p-2,  -0x1.67b2dep-3, INEXACT)
T(RN,  0x1.069b1819aad97p+562,   -0x1.c37f7dbc2c90fp-1,   0x1.33c55cp-3, INEXACT)
T(RN,   0x1.c3495a6ede76p+562,    0x1.5a79f5922863ep-2,   0x1.6f4fa4p-2, INEXACT)
T(RN,  0x1.37445a14c08edp+562,    0x1.7363f0c3fe2fbp-2,  -0x1.14ead8p-5, INEXACT)
T(RN,  0x1.07a3b7b7bc212p+563,    0x1.519397d28e67dp-2,   0x1.4366e8p-8, INEXACT)
T(RN,  0x1.a36c2da86ed0ep+563,    0x1.f9c5601cc0ac1p-5,  -0x1.95aa58p-3, INEXACT)
T(RN,  0x1.e9cfaadb3c178p+563,    0x1.fc6689ad4d082p-1,  -0x1.4270d2p-7, INEXACT)
T(RN,  0x1.e23c3914bd1d9p+563,    -0x1.20c407042a7cp-1,  -0x1.b4d77ep-3, INEXACT)
T(RN,  0x1.6b5cd6b764fbep+563,   -0x1.bc26e2d9f1591p-1,   0x1.257234p-2, INEXACT)
T(RN,  0x1.d14529b0c2576p+563,   -0x1.96dbc72d5da06p-2,    0x1.11d9ap-2, INEXACT)
T(RN,  0x1.6e6c6aaf30ac2p+563,   -0x1.d1b82cfbfe5e6p-1,   0x1.8155eep-2, INEXACT)
T(RN,  0x1.cdd19d6db479ap+563,   -0x1.7f185e9f3d103p-1,  -0x1.ff6318p-2, INEXACT)
T(RN,  0x1.cd79ee7a75958p+563,    0x1.49c9bc3444656p-1,  -0x1.771678p-2, INEXACT)
T(RN,  0x1.4fe401a7b232ap+563,     0x1.77cd763ff7a4p-3,   0x1.6d7af6p-2, INEXACT)
T(RN,  0x1.e8383fb2de9c8p+564,    0x1.72f2f8af9bd36p-1,   0x1.5a26c4p-4, INEXACT)
T(RN,  0x1.61b043bb4ae7fp+564,    -0x1.d561b9178f46p-1,   -0x1.4b49ap-3, INEXACT)
T(RN,  0x1.9484ea54df253p+564,    -0x1.4b1b24203836p-1,  -0x1.049384p-3, INEXACT)
T(RN,  0x1.4df4aa2cc7161p+564,   -0x1.a6f9fca3a6a5fp-1,  -0x1.cfac9cp-2, INEXACT)
T(RN,  0x1.da4de6c2dd7b8p+564,   -0x1.685d64d88f91ep-2,  -0x1.8cc284p-2, INEXACT)
T(RN,  0x1.a5241783daaefp+564,   -0x1.fdf1bdcdc715cp-1,   0x1.daaa98p-2, INEXACT)
T(RN,  0x1.c01ecd0e04065p+564,   -0x1.ecdbdfc729779p-2,   0x1.5db482p-2, INEXACT)
T(RN,  0x1.4f7cebdf6c72dp+564,   -0x1.fb4462be3db98p-3,  -0x1.4b867cp-4, INEXACT)
T(RN,  0x1.774d3cc59b1fdp+564,    0x1.f20ff719faac6p-1,  -0x1.a30084p-3, INEXACT)
T(RN,  0x1.c764ce3839262p+564,    0x1.d32516f44b084p-1,  -0x1.d1ef48p-2, INEXACT)
T(RN,  0x1.e95f958e04b28p+565,   -0x1.134a6affba91ep-2,  -0x1.337b74p-3, INEXACT)
T(RN,  0x1.227b4fe043602p+565,   -0x1.81ff33cd4bb4bp-1,  -0x1.2d2f72p-2, INEXACT)
T(RN,  0x1.3107483d1d8fep+565,   -0x1.8ccc287436fb6p-1,   0x1.aee456p-2, INEXACT)
T(RN,  0x1.62497a2098329p+565,    0x1.d03c5d251fa2ap-3,  -0x1.5bf014p-5, INEXACT)
T(RN,  0x1.e0fd0c6552a82p+565,      0x1.132f785f877p-2,   0x1.b6bb5cp-3, INEXACT)
T(RN,  0x1.8d356125b5612p+565,   -0x1.32df94f30f919p-1,   0x1.e98a44p-2, INEXACT)
T(RN,  0x1.422f5358f952dp+565,   -0x1.f873e6966f383p-1,  -0x1.0fc982p-2, INEXACT)
T(RN,  0x1.ef9e8a6c76eb8p+565,   -0x1.2425d5ad48dbep-3,   0x1.b89672p-3, INEXACT)
T(RN,  0x1.43b5618657788p+565,    0x1.bb51cbfe31356p-1,   -0x1.0a405p-2, INEXACT)
T(RN,  0x1.fc0e32cf747b8p+565,   -0x1.fff2d69dfc7bdp-1,   0x1.53ced6p-9, INEXACT)
T(RN,  0x1.de1825284190bp+566,   -0x1.5a337fc837e11p-1,   0x1.c1cc56p-2, INEXACT)
T(RN,  0x1.82d6892fb6da2p+566,    -0x1.6712c7488eb7p-1,  -0x1.bb70e2p-3, INEXACT)
T(RN,  0x1.4b9c1a6b8fc4ap+566,    0x1.b8ea893516c0bp-1,  -0x1.1e52a4p-5, INEXACT)
T(RN,  0x1.cf46d072614a6p+566,    0x1.f388bf5283c37p-1,   0x1.c7cf22p-2, INEXACT)
T(RN,  0x1.87185fe5f559ap+566,    0x1.6d873274b5a9ap-2,   0x1.6ba73ep-7, INEXACT)
T(RN,  0x1.d6504e4232a28p+566,    0x1.c0a9ef05b7f13p-4,  -0x1.2f83e4p-2, INEXACT)
T(RN,  0x1.9b7ef74c1a186p+566,   -0x1.7d3ca659871e7p-5,  -0x1.218ed6p-3, INEXACT)
T(RN,  0x1.6c74bbb3f4f04p+566,   -0x1.5b229c26ad572p-3,   0x1.f32854p-2, INEXACT)
T(RN,  0x1.9c28261e0b20ep+566,   -0x1.4bb1ddf415eadp-1,   0x1.db5c64p-4, INEXACT)
T(RN,  0x1.d1986c9baadbep+566,    0x1.fd189f3d3cf34p-1,   0x1.a88216p-2, INEXACT)
T(RN,  0x1.c9a6858a030c4p+567,    0x1.c4ef094bac212p-5,  -0x1.54470ap-2, INEXACT)
T(RN,  0x1.18530b6755ea8p+567,    -0x1.c818c0a3b4fap-2,   0x1.12d274p-2, INEXACT)
T(RN,  0x1.3a1e3b9d9ba13p+567,    0x1.6105b55aa9233p-2,   0x1.1b7b8ap-2, INEXACT)
T(RN,  0x1.3e3d659b46c45p+567,    0x1.2844c3bf95343p-2,  -0x1.4588d6p-2, INEXACT)
T(RN,  0x1.e413003b87292p+567,   -0x1.4a9f30ea941ddp-1,   0x1.33922cp-4, INEXACT)
T(RN,  0x1.2c584cc8a3d68p+567,   -0x1.5fb922ab2fd44p-2,  -0x1.acc3bap-2, INEXACT)
T(RN,  0x1.d8c85dc9a759ep+567,   -0x1.9de2e9cb5874ep-3,   0x1.f04b4ap-2, INEXACT)
T(RN,  0x1.badd925003484p+567,    0x1.4b6440be0efbap-1,  -0x1.33eb34p-5, INEXACT)
T(RN,  0x1.42e36320bd098p+567,   -0x1.fb15763b8278fp-1,  -0x1.b547b6p-6, INEXACT)
T(RN,  0x1.1f26509419db3p+567,    0x1.7616a90dec11bp-1,  -0x1.58d77cp-3, INEXACT)
T(RN,  0x1.662745dc665b8p+568,   -0x1.0fe31b2591403p-3,   0x1.e2b8dep-5, INEXACT)
T(RN,  0x1.c28bc75df0f1bp+568,   -0x1.fc627240eca8bp-1,  -0x1.827e78p-2, INEXACT)
T(RN,  0x1.971be66306f97p+568,   -0x1.2948294b93525p-2,   0x1.0d07b8p-2, INEXACT)
T(RN,  0x1.5be79954587d3p+568,    0x1.50d1b19784289p-1,  -0x1.4afc96p-3, INEXACT)
T(RN,  0x1.caaea20dd4b6cp+568,   -0x1.e8d6c83dd2933p-1,   0x1.13854ap-2, INEXACT)
T(RN,  0x1.d6cb73c12a3bep+568,    0x1.99096e8c6ed82p-1,   0x1.0623d4p-3, INEXACT)
T(RN,  0x1.31c0fd277b422p+568,    0x1.236b04a4ddd97p-1,   -0x1.94c99p-2, INEXACT)
T(RN,  0x1.0478fd8cd8b62p+568,    0x1.54105cd85e574p-1, -0x1.fb3e7cp-13, INEXACT)
T(RN,   0x1.b0283b5f7006p+568,    0x1.111f86b5f6cffp-1,    -0x1.ded9p-4, INEXACT)
T(RN,  0x1.1caeabcbf6485p+568,   -0x1.0c019be7b498ep-3,  -0x1.f7bf6ep-4, INEXACT)
T(RN,  0x1.6228e140afc76p+569,   -0x1.202d4d3517866p-2,  -0x1.2f208cp-3, INEXACT)
T(RN,   0x1.848ea3870235p+569,    0x1.c484d04b101e3p-1,   0x1.6e8582p-3, INEXACT)
T(RN,  0x1.2e5a512bd18ecp+569,    0x1.93351d30abd8fp-2,  -0x1.8ce3ecp-6, INEXACT)
T(RN,  0x1.b100a0252a326p+569,   -0x1.a853f8d932182p-3,   0x1.b0c53ap-5, INEXACT)
T(RN,  0x1.9dd833fdbb2b6p+569,    0x1.6f47bd1f17221p-1,   0x1.6effb6p-2, INEXACT)
T(RN,  0x1.a3d5adb394ffep+569,    0x1.d7fda9269e937p-1,   0x1.aa95aap-2, INEXACT)
T(RN,  0x1.f95434fe745c4p+569,    0x1.d796243520a12p-1,   0x1.019d44p-2, INEXACT)
T(RN,   0x1.d5778796c3edp+569,     0x1.637b685b1155p-1,  -0x1.97879cp-4, INEXACT)
T(RN,  0x1.013a3f6abf812p+569,   -0x1.e8f0963c500d9p-7,   0x1.49a81ap-4, INEXACT)
T(RN,  0x1.9a9bc92b84227p+569,   -0x1.fae2c816ea724p-1,  -0x1.2a49bep-3, INEXACT)
T(RN,  0x1.270017a2b331ep+570,    0x1.ee6eaf00e6407p-1,   0x1.911888p-9, INEXACT)
T(RN,  0x1.e759b7bc122bap+570,    0x1.b0c5669ab6cfcp-1,   0x1.9bbd52p-2, INEXACT)
T(RN,  0x1.4d7fdbb09bc87p+570,    0x1.18fd899f1f369p-1,   0x1.334124p-3, INEXACT)
T(RN,  0x1.e45ccecc9e24dp+570,    0x1.f6162bfd8b778p-1,  -0x1.8acc64p-3, INEXACT)
T(RN,  0x1.1ac63da56c311p+570,   -0x1.8b7f917cce7e2p-3,    0x1.1b787p-2, INEXACT)
T(RN,  0x1.1a15a030f3432p+570,   -0x1.fffb04902eea9p-1,   -0x1.d29eap-2, INEXACT)
T(RN,  0x1.ccdfcef562764p+570,    -0x1.c669ece9a47fp-2,    0x1.ea223p-4, INEXACT)
T(RN,  0x1.c7978008e1f5fp+570,   -0x1.bc2fe9d772353p-1,   0x1.0356aap-2, INEXACT)
T(RN,  0x1.ea298951ef338p+570,   -0x1.a223ada20f528p-1,   0x1.888b1ep-2, INEXACT)
T(RN,  0x1.ef5abfc3d18b8p+570,    0x1.d9b55e28ba194p-1,   0x1.793c2ap-4, INEXACT)
T(RN,  0x1.e03d3cbd83c63p+571,    0x1.f1ce7c5bf6158p-1,  -0x1.7131acp-3, INEXACT)
T(RN,  0x1.5a3517ce3175ap+571,   -0x1.f3514b8af5b76p-1,   0x1.e5ef82p-3, INEXACT)
T(RN,  0x1.577aab280e136p+571,    0x1.a0a845e06b34bp-1,  -0x1.38935ap-3, INEXACT)
T(RN,  0x1.326da29886d39p+571,   -0x1.ff4e87a5389fcp-1,   0x1.aad6f8p-3, INEXACT)
T(RN,  0x1.4d08b094f6e07p+571,    0x1.b05d66358297fp-1,   0x1.f6ff3cp-2, INEXACT)
T(RN,  0x1.535cccedd4f88p+571,   -0x1.8fd2446f89fe9p-1,  -0x1.6a264cp-8, INEXACT)
T(RN,  0x1.e1a1d9d275d58p+571,   -0x1.f9b79ba358a27p-3,  -0x1.f7caf4p-2, INEXACT)
T(RN,  0x1.d2b7b66d30ce4p+571,     0x1.102e2be23d1ap-3,   0x1.29baa2p-2, INEXACT)
T(RN,  0x1.7a0cd08bdfadfp+571,    0x1.876b9ad16ec58p-3,  -0x1.702fe2p-4, INEXACT)
T(RN,  0x1.3ed3fa5c21992p+571,   -0x1.fff49fa60bf84p-1,   -0x1.2a118p-3, INEXACT)
T(RN,   0x1.83c8eef5659fp+572,   -0x1.d041929cafb27p-1,  -0x1.fa5444p-4, INEXACT)
T(RN,  0x1.784be0e1c8c92p+572,   -0x1.73b544897ab27p-1,   0x1.b17174p-3, INEXACT)
T(RN,  0x1.18121fb8722e3p+572,   -0x1.abd69c7b97434p-3,  -0x1.ca0dbcp-2, INEXACT)
T(RN,  0x1.932e3085f488fp+572,   -0x1.acc4fa2fb898dp-1,  -0x1.1227ccp-4, INEXACT)
T(RN,    0x1.6557c5ecc98p+572,    0x1.88b2b18209a2bp-1,   0x1.682b34p-4, INEXACT)
T(RN,  0x1.8960597d7474ep+572,   -0x1.a95bd4f87f889p-1,   0x1.091c5cp-3, INEXACT)
T(RN,   0x1.a037ed308375p+572,    0x1.df503a1c748abp-5,  -0x1.14e214p-5, INEXACT)
T(RN,  0x1.8525181b46614p+572,    0x1.e2749ca79416ep-1,  -0x1.f1ddeep-2, INEXACT)
T(RN,  0x1.c5c4b5f54c6e4p+572,    0x1.e9cce1d559671p-1,   0x1.99b5c2p-4, INEXACT)
T(RN,  0x1.2f2080500d8ddp+572,   -0x1.831b11053dd58p-3,   0x1.c4a918p-2, INEXACT)
T(RN,  0x1.867e408ee035ep+573,   -0x1.f468bde53f552p-2,   0x1.c6542cp-2, INEXACT)
T(RN,  0x1.4e1ad2ba3a782p+573,   -0x1.d0e290f3fe9b2p-1,   0x1.bfebcap-3, INEXACT)
T(RN,  0x1.a3ee8f52251b3p+573,   -0x1.87073806a6796p-2,  -0x1.0d508ap-2, INEXACT)
T(RN,  0x1.5b27403691669p+573,   -0x1.a005860e52521p-1,   0x1.dcec5cp-2, INEXACT)
T(RN,  0x1.746db8bc0881bp+573,    0x1.dc79720e63675p-1,  -0x1.65def6p-2, INEXACT)
T(RN,  0x1.1ed0352926f9ap+573,    0x1.efb670793f59bp-1,   0x1.a618eep-5, INEXACT)
T(RN,   0x1.500e323fdeeep+573,    0x1.ed46b7b6af22bp-1,  -0x1.401358p-4, INEXACT)
T(RN,  0x1.ba901aea05a9fp+573,    0x1.fed857fc1a391p-1,   0x1.9e5cd4p-2, INEXACT)
T(RN,   0x1.64290638e5bep+573,    0x1.c2820d817f574p-1,  -0x1.995e4cp-3, INEXACT)
T(RN,  0x1.e1c8c3996f266p+573,   -0x1.d1e1d4546cb26p-1,  -0x1.6c163ep-3, INEXACT)
T(RN,  0x1.cde606847a91ap+574,   -0x1.5783cfca74e57p-1,   0x1.b28456p-2, INEXACT)
T(RN,  0x1.09bca439a71d8p+574,    0x1.440eb8aeb4762p-1,   0x1.4f5fd8p-2, INEXACT)
T(RN,  0x1.5bc909b791e17p+574,   -0x1.fdeb181676424p-1,   -0x1.5f9f4p-2, INEXACT)
T(RN,  0x1.f3ee4f903f987p+574,    0x1.fffffff4c4ce7p-1,  -0x1.eb8268p-2, INEXACT)
T(RN,  0x1.6136d94ce3568p+574,    0x1.ed1be82374f4dp-2,  -0x1.f2dfeap-2, INEXACT)
T(RN,  0x1.6fee5b72c57d1p+574,   -0x1.a436b1d204a46p-3,  -0x1.fd1386p-2, INEXACT)
T(RN,  0x1.cc0eff16826aep+574,   -0x1.fc800f35f7561p-1,    0x1.c24abp-3, INEXACT)
T(RN,  0x1.38452d046a284p+574,   -0x1.370cc5095d776p-2,  -0x1.dd7b08p-3, INEXACT)
T(RN,  0x1.e7960d0c7b015p+574,   -0x1.1c790f4afe743p-2,  -0x1.3741fap-2, INEXACT)
T(RN,  0x1.c72d5cbee5274p+574,   -0x1.57a7670c03eabp-1,  -0x1.4452c6p-5, INEXACT)
T(RN,  0x1.b0c78cb22c656p+575,    0x1.e55a566b08642p-1,   0x1.828084p-8, INEXACT)
T(RN,  0x1.fa03e28d73848p+575,   -0x1.7b437830d0a37p-2,  -0x1.070666p-5, INEXACT)
T(RN,  0x1.e51c5b9b5bc82p+575,    0x1.a10dc21bcfe8cp-2,  -0x1.b59402p-2, INEXACT)
T(RN,  0x1.3ca1ce01c8bd3p+575,   -0x1.96ecb0e33652ap-1,   0x1.799774p-2, INEXACT)
T(RN,   0x1.517a1938f58cp+575,   -0x1.31275168191f9p-1,   0x1.76c206p-4, INEXACT)
T(RN,  0x1.11b88a7109aa4p+575,   -0x1.0fcbcbcc9bfcbp-2,   0x1.acae92p-3, INEXACT)
T(RN,  0x1.9d8c39ad05af3p+575,    0x1.fadd9c82b103ep-1,   0x1.8930f6p-3, INEXACT)
T(RN,  0x1.26e18b97c47efp+575,    0x1.c6c0dac4250a3p-1,  -0x1.0ea3b8p-4, INEXACT)
T(RN,  0x1.118efbcdc2082p+575,    0x1.ffaae1d8577d6p-1,  -0x1.039a42p-6, INEXACT)
T(RN,  0x1.f4bd3362b5bc6p+575,    0x1.ff47257093d82p-1,  -0x1.31f1acp-3, INEXACT)
T(RN,  0x1.7259095482f32p+576,   -0x1.19db06f3f134cp-1,  -0x1.b30312p-2, INEXACT)
T(RN,  0x1.7cc623ac5cc7cp+576,   -0x1.a01b86a022f0ap-3,   0x1.6c0f6ep-4, INEXACT)
T(RN,  0x1.1bae6d83c72d9p+576,   -0x1.f4e9a37488403p-2,   -0x1.6454ap-2, INEXACT)
T(RN,  0x1.a84ad0adb5b65p+576,    0x1.ffef77ce7a839p-1,  -0x1.17a6ecp-3, INEXACT)
T(RN,   0x1.ac7999efede4p+576,   -0x1.2ab5e22db4d67p-3,  -0x1.3728bap-2, INEXACT)
T(RN,  0x1.5428a71668e46p+576,   -0x1.93967946ac228p-1,   0x1.df01d4p-2, INEXACT)
T(RN,  0x1.2b54999746fc8p+576,    0x1.d19904674aa4ap-1,   0x1.7ac06ep-2, INEXACT)
T(RN,  0x1.3bf9d47c46098p+576,    0x1.8cc5176c22be8p-2,  -0x1.0ca73cp-2, INEXACT)
T(RN,   0x1.3ba89530beabp+576,   -0x1.f1978fa9e208bp-1,   0x1.510724p-2, INEXACT)
T(RN,  0x1.64aa4ef8eee82p+576,   -0x1.86022906a305dp-1,   0x1.100512p-2, INEXACT)
T(RN,  0x1.0b15c38fa7525p+577,   -0x1.f62ea20c20f9bp-1,   0x1.2e4b28p-2, INEXACT)
T(RN,  0x1.e1bd75926561ap+577,   -0x1.ab21f0c30f7e9p-1,   0x1.ef9994p-8, INEXACT)
T(RN,  0x1.e794a6a6341dfp+577,   -0x1.aff5c65eaeba9p-1,   -0x1.a0746p-2, INEXACT)
T(RN,  0x1.6b439806ea208p+577,   -0x1.f297587149873p-1,  -0x1.7f7994p-2, INEXACT)
T(RN,  0x1.579f15c7119f8p+577,   -0x1.2f5a21274b8aep-1,    0x1.c0ca9p-3, INEXACT)
T(RN,  0x1.89a69f9e3901ap+577,   -0x1.dfcb69893d33ap-4,   0x1.470f28p-2, INEXACT)
T(RN,  0x1.a6a81d400dcf2p+577,     0x1.09f08c57f612p-5,  -0x1.72406ep-3, INEXACT)
T(RN,  0x1.471637b189e51p+577,    0x1.998c7155aae6ep-1,  -0x1.42400cp-6, INEXACT)
T(RN,  0x1.d057b1bdb84c4p+577,     0x1.0696067cfb8ap-3,   0x1.0955e8p-3, INEXACT)
T(RN,  0x1.85617f0ee9214p+577,    0x1.ff20d691d2cf9p-1,  -0x1.d47feep-4, INEXACT)
T(RN,    0x1.440364cc323p+578,   -0x1.216109cbb6d5ap-1,    0x1.b451bp-2, INEXACT)
T(RN,   0x1.fea7a5e3ed67p+578,   -0x1.cf3aec3c5bd7fp-6,  -0x1.5f1e9cp-3, INEXACT)
T(RN,  0x1.8dea8e9ef087fp+578,    0x1.d6adea44cd622p-1,  -0x1.5c321cp-2, INEXACT)
T(RN,  0x1.baf04cffab246p+578,   -0x1.c7256ac4e314dp-3,   -0x1.c2933p-2, INEXACT)
T(RN,  0x1.10b9ea54af16ap+578,    0x1.795e5bb6091f7p-1,   0x1.fe207ep-3, INEXACT)
T(RN,  0x1.4df0b3414d717p+578,   -0x1.4e134a2ab5428p-1,  -0x1.08e728p-3, INEXACT)
T(RN,  0x1.d5faceaa69b76p+578,    0x1.73d9bbb4872ccp-1,  -0x1.bce214p-2, INEXACT)
T(RN,  0x1.ad5c281788788p+578,    0x1.241bdd68bf59cp-1,  -0x1.42951cp-4, INEXACT)
T(RN,   0x1.7096b7e7f10fp+578,    0x1.c01c083be26b9p-4,  -0x1.a8b8e4p-3, INEXACT)
T(RN,  0x1.fb3fe7564f57cp+578,   -0x1.93a2964ec1a11p-1,   0x1.dc3538p-3, INEXACT)
T(RN,  0x1.f40804f585497p+579,    0x1.f464e25197884p-1,   0x1.856c2ap-2, INEXACT)
T(RN,  0x1.f94e44a726fffp+579,   -0x1.d19d66eeb87a5p-1,  -0x1.a5e1dap-5, INEXACT)
T(RN,  0x1.4f8659658aa7bp+579,    0x1.fa63528383a94p-6,   0x1.494326p-2, INEXACT)
T(RN,  0x1.e259322159c06p+579,   -0x1.ea353d7069d9cp-2,   0x1.814498p-5, INEXACT)
T(RN,  0x1.d9ce1be81353dp+579,    0x1.f50078eadffd2p-1,   0x1.ccce84p-2, INEXACT)
T(RN,  0x1.ddd2a7b2af588p+579,    0x1.c0fa0117a47dep-1,    0x1.4d099p-5, INEXACT)
T(RN,  0x1.afdcb8957c297p+579,    0x1.089d07dc0612ap-1,  -0x1.87bb6ap-2, INEXACT)
T(RN,  0x1.be567f28ad02bp+579,    -0x1.6b26b5c80e41p-1,  -0x1.83a954p-3, INEXACT)
T(RN,  0x1.44e9181a7a47ep+579,   -0x1.fc88dabcd50edp-2,   0x1.3744d6p-3, INEXACT)
T(RN,  0x1.e99cff9849adap+579,    -0x1.8e6834265da2p-2,   0x1.0a8d82p-4, INEXACT)
T(RN,  0x1.e3208712b2206p+580,    0x1.b3e6f6449826cp-1,  -0x1.fb9bd2p-2, INEXACT)
T(RN,  0x1.faa47953e8cdfp+580,    0x1.3d57330c16dc8p-1,   0x1.315ea6p-2, INEXACT)
T(RN,  0x1.15feb8008c72ep+580,    0x1.841a42445abf2p-1,   0x1.0fcfb6p-4, INEXACT)
T(RN,  0x1.4538b4c85f09bp+580,   -0x1.49e2b2ff6157fp-1,  -0x1.2b3accp-7, INEXACT)
T(RN,  0x1.55402ab13e858p+580,   -0x1.19324ee65f544p-3,  -0x1.126182p-2, INEXACT)
T(RN,  0x1.dd33045b8c178p+580,    0x1.fb5861427d071p-1,   0x1.db7d28p-2, INEXACT)
T(RN,  0x1.bd73a83c43ae8p+580,   -0x1.ecc028018956dp-1,  -0x1.dd5888p-2, INEXACT)
T(RN,  0x1.15d19667688c6p+580,   -0x1.b8aff72fe075dp-1,  -0x1.b18f2ap-2, INEXACT)
T(RN,  0x1.b1b92894b6851p+580,   -0x1.670134e922136p-3,   0x1.39173cp-2, INEXACT)
T(RN,  0x1.f2ed4988d3cf1p+580,   -0x1.713298e59d43cp-4,  -0x1.c77de2p-3, INEXACT)
T(RN,  0x1.741eec90fe00ep+581,    0x1.e3017c9023637p-2,  -0x1.8d6ec8p-4, INEXACT)
T(RN,  0x1.e8a648d714bdfp+581,    0x1.66dde18294e3ap-4,   0x1.6b1a64p-3, INEXACT)
T(RN,  0x1.9b04d4ddc4fd8p+581,   -0x1.601fce83f71ddp-1,   -0x1.cbfadp-3, INEXACT)
T(RN,  0x1.18ae298e02ae8p+581,    0x1.fae640868501dp-1,  -0x1.c729b2p-5, INEXACT)
T(RN,   0x1.9938fc7c3287p+581,    0x1.f0b2b74f08906p-2,  -0x1.a10edap-7, INEXACT)
T(RN,  0x1.2596390cc8369p+581,    0x1.a1d01cdc06bf4p-1,   0x1.090eb2p-2, INEXACT)
T(RN,  0x1.15bc642d75633p+581,   -0x1.e2ce778bb57f3p-1,  -0x1.359ed6p-2, INEXACT)
T(RN,  0x1.41ec890b14e23p+581,    0x1.051f417dc5664p-1,  -0x1.7932e2p-2, INEXACT)
T(RN,  0x1.cdefe66d941f5p+581,    0x1.80e3c44493eaep-1,   0x1.ce434ap-3, INEXACT)
T(RN,  0x1.921e59f8e9c99p+581,    -0x1.f7d964aa2645p-1,   0x1.61d2e2p-4, INEXACT)
T(RN,   0x1.ab76fa447ab2p+582,   -0x1.ee678f4991d4fp-3,    0x1.e1e28p-2, INEXACT)
T(RN,  0x1.fdf79fdecfbcdp+582,    0x1.6c9a10f78b66fp-1,  -0x1.6bc4e6p-2, INEXACT)
T(RN,   0x1.679607cd6b9ep+582,   -0x1.e1e06c9ad517ap-5,   0x1.3b650ep-2, INEXACT)
T(RN,  0x1.d52a023963292p+582,   -0x1.b593375a1d9ffp-1,   -0x1.9212dp-5, INEXACT)
T(RN,  0x1.1eeaf5f4b18ecp+582,    0x1.d2fbaab941736p-1,   0x1.0eef02p-2, INEXACT)
T(RN,  0x1.2cc43f684d074p+582,    0x1.9c567f66f24a6p-1,   0x1.b68bbcp-5, INEXACT)
T(RN,  0x1.890896ab14bd4p+582,    0x1.7a06ce40722d7p-1,  -0x1.6f2406p-2, INEXACT)
T(RN,  0x1.1d896279a26b3p+582,    0x1.e62fb12b12c7bp-1,  -0x1.0b0768p-4, INEXACT)
T(RN,  0x1.7bacf6ca2f5e7p+582,   -0x1.b3cd662a1b45cp-2,   0x1.58b7b8p-3, INEXACT)
T(RN,   0x1.fca902b8ca96p+582,   -0x1.e52ddc5916e13p-6,  -0x1.a5a5bep-2, INEXACT)
T(RN,   0x1.93a12d308f5ap+583,   -0x1.fe27c1321ca09p-1,   0x1.fec276p-3, INEXACT)
T(RN,  0x1.e3c78de4da8c9p+583,   -0x1.f6c46d28a623ep-1,  -0x1.912e9cp-2, INEXACT)
T(RN,  0x1.d238207014ecap+583,   -0x1.8042f29f36009p-2,   0x1.e9ee64p-2, INEXACT)
T(RN,  0x1.c04a269729de9p+583,    0x1.f9601813cdb55p-1,  -0x1.a6ee5cp-3, INEXACT)
T(RN,  0x1.6dfbab896cc84p+583,    0x1.fc08013f26d6fp-1,   -0x1.0daeep-2, INEXACT)
T(RN,  0x1.e276b1b00fc0cp+583,    0x1.6af13bf21a124p-4,   0x1.41e7cep-2, INEXACT)
T(RN,  0x1.6ac9630165cf2p+583,    0x1.0d416a0803fe7p-1,  -0x1.1df844p-2, INEXACT)
T(RN,   0x1.ff08c56b2833p+583,    0x1.fee8c858ec34fp-1,  -0x1.cac266p-2, INEXACT)
T(RN,  0x1.77602ebcd6268p+583,   -0x1.9f8346e8a62c1p-1,   -0x1.3e1f4p-2, INEXACT)
T(RN,  0x1.a368917afa10ap+583,   -0x1.e6b10f629d1f7p-1,   0x1.6db1a8p-3, INEXACT)
T(RN,  0x1.fcc203f5f7947p+584,   -0x1.29e7d6f44ca2ap-6,  -0x1.470886p-3, INEXACT)
T(RN,  0x1.fd84e41d5bebep+584,    0x1.f3f2d4ce1c841p-1,  -0x1.0d0198p-2, INEXACT)
T(RN,  0x1.f9c0903b86a48p+584,    0x1.e5b39c0c59ff8p-1,   0x1.152ed6p-3, INEXACT)
T(RN,  0x1.a08bf6d6b40f8p+584,    0x1.b8cd801ad4449p-2,   0x1.d26388p-2, INEXACT)
T(RN,  0x1.13619f090bd22p+584,   -0x1.f1a70e2518dd5p-1,  -0x1.2e26d8p-6, INEXACT)
T(RN,  0x1.a5db34a95708cp+584,   -0x1.5a2d5289e010bp-2,  -0x1.60325ap-3, INEXACT)
T(RN,  0x1.b809173a8230cp+584,    0x1.ea6b50e174127p-1,   0x1.9074b2p-2, INEXACT)
T(RN,  0x1.6ede0eeee7928p+584,   -0x1.529663b113424p-1,   0x1.432326p-2, INEXACT)
T(RN,  0x1.f3ed93cc7c57ap+584,   -0x1.e960494f12018p-1,  -0x1.63b452p-3, INEXACT)
T(RN,   0x1.310fa8051132p+584,   -0x1.bbdf2e5a6071fp-1,   0x1.9c68d6p-2, INEXACT)
T(RN,  0x1.88282f9f4cc52p+585,   -0x1.aacb698cd693cp-1,   0x1.5fab4ep-3, INEXACT)
T(RN,  0x1.8e70e548360b8p+585,   -0x1.7c707a52063c6p-2,   -0x1.fb6a3p-2, INEXACT)
T(RN,  0x1.301cd30843766p+585,   -0x1.ca7ebabf1deb3p-2,  -0x1.44afa8p-6, INEXACT)
T(RN,  0x1.3ef2dd573fe96p+585,   -0x1.3b20097371a3fp-1,  -0x1.16b606p-5, INEXACT)
T(RN,  0x1.6fea984306d6ep+585,    0x1.b1bbbe53f41dbp-1,   0x1.7df90ep-4, INEXACT)
T(RN,  0x1.d50050efa0ad8p+585,    0x1.fbde45187b8f8p-1,   0x1.31a686p-2, INEXACT)
T(RN,  0x1.6d390fdf07434p+585,     0x1.3fb47bf3a40bp-1,  -0x1.7b3e4ep-2, INEXACT)
T(RN,  0x1.f7cb6fcf93aebp+585,    0x1.8a36f4bde24dap-1,   0x1.b5cb74p-7, INEXACT)
T(RN,  0x1.16cb1b131eb77p+585,    0x1.4ef15d12bb5e7p-5,    0x1.99436p-2, INEXACT)
T(RN,  0x1.b1fcf42d515e2p+585,   -0x1.fff673c196ff4p-1,   0x1.fcf32ep-4, INEXACT)
T(RN,  0x1.56a2f82e8717dp+586,   -0x1.6258bd1ce327cp-1,   0x1.7fb992p-5, INEXACT)
T(RN,  0x1.ded1b5023f84ep+586,     0x1.a796b178201dp-4,   -0x1.e83eep-2, INEXACT)
T(RN,  0x1.1b84b69e43aeap+586,   -0x1.c3af67aaa2d77p-1,   0x1.7af474p-2, INEXACT)
T(RN,  0x1.f528b5fb49162p+586,   -0x1.f67644b29e6a3p-1,   0x1.e6124cp-5, INEXACT)
T(RN,  0x1.05de610b16745p+586,   -0x1.b5fb09f914d5ep-3,   0x1.4ab524p-3, INEXACT)
T(RN,   0x1.5b983f7f84fap+586,    0x1.ff6d1d1838a24p-1,  -0x1.e95926p-2, INEXACT)
T(RN,  0x1.703b6a8956981p+586,    0x1.b0ffbf51c3d65p-6,   0x1.116078p-3, INEXACT)
T(RN,  0x1.900925a1393b5p+586,   -0x1.bdba305542c56p-2,  -0x1.72713ap-2, INEXACT)
T(RN,  0x1.e7553530b89f4p+586,    0x1.d954bb0f35329p-1,  -0x1.e367a2p-2, INEXACT)
T(RN,  0x1.255e1673397b8p+586,   -0x1.c178c0719fb98p-1,   0x1.16a358p-2, INEXACT)
T(RN,   0x1.afac65c8321cp+587,    0x1.09c6be6d805bep-9,  -0x1.3e6a82p-8, INEXACT)
T(RN,  0x1.59439c403c3d5p+587,    0x1.fc8949cc0a9afp-1,   0x1.317472p-2, INEXACT)
T(RN,  0x1.66dbd52891f3ap+587,   -0x1.ec3898a008cf7p-1,  -0x1.713b02p-4, INEXACT)
T(RN,  0x1.12c75b458fbedp+587,    0x1.bac4302f455dep-1,  -0x1.6036c8p-2, INEXACT)
T(RN,  0x1.144e7047661a6p+587,    0x1.f52283fcd7c04p-1,  -0x1.b442dap-4, INEXACT)
T(RN,  0x1.64257fca7cc37p+587,    0x1.0d52a99c8fce8p-3,   0x1.f02eacp-2, INEXACT)
T(RN,   0x1.fa4ece520777p+587,   -0x1.ef8a9269270cdp-1,  -0x1.59d426p-4, INEXACT)
T(RN,  0x1.1cb9a662a922cp+587,   -0x1.ff54b480cc691p-1,    0x1.78093p-3, INEXACT)
T(RN,  0x1.33144cc4bfc31p+587,   -0x1.b0e77e5cab30ap-1,  -0x1.cd7342p-2, INEXACT)
T(RN,  0x1.0cd9c5a33e2e9p+587,   -0x1.fbb763f51b5d1p-1,   0x1.e352a8p-2, INEXACT)
T(RN,   0x1.d238571faec2p+588,    0x1.21167abc000e5p-1,  -0x1.49fedep-2, INEXACT)
T(RN,  0x1.ce506933af654p+588,    0x1.b76a33ba9532cp-3,   0x1.c0ec14p-4, INEXACT)
T(RN,  0x1.5360af1a379cep+588,   -0x1.bd6fefdd4e433p-2,   -0x1.7f772p-9, INEXACT)
T(RN,  0x1.e0a2e46bd921fp+588,   -0x1.afb6ece6f1305p-1,  -0x1.f8d084p-4, INEXACT)
T(RN,  0x1.6d3cb1c63bb5fp+588,   -0x1.8b9ad7fedbe1fp-1,  -0x1.4da218p-2, INEXACT)
T(RN,  0x1.e650fc8d36795p+588,    0x1.b5688ab38f59cp-4,    0x1.6b276p-3, INEXACT)
T(RN,  0x1.664b499ded29cp+588,    0x1.c74c824801ac6p-1,  -0x1.e669eap-2, INEXACT)
T(RN,  0x1.ff636d3b0601cp+588,   -0x1.be87767ac069cp-1,  -0x1.dc45b6p-3, INEXACT)
T(RN,  0x1.b821b26e2924ap+588,   -0x1.9c1c3b388a861p-1,   0x1.1dd62ep-2, INEXACT)
T(RN,  0x1.be96ca9c9842cp+588,    0x1.d01e5438ab83dp-1,  -0x1.e1de32p-2, INEXACT)
T(RN,  0x1.c2b6690927c2cp+589,    0x1.e2763a1b6439ep-1,   0x1.7a8b8cp-6, INEXACT)
T(RN,  0x1.86735a9545d97p+589,   -0x1.84fded0aa3ca7p-2,    0x1.55ed5p-3, INEXACT)
T(RN,  0x1.8278bce923cfdp+589,   -0x1.7e843b44f75c7p-3,  -0x1.19a2bap-2, INEXACT)
T(RN,  0x1.3c806eac9529ep+589,    0x1.89ab562423211p-2,   0x1.bb121ep-2, INEXACT)
T(RN,  0x1.c21b37281de94p+589,   -0x1.df64ab69c58abp-1,   0x1.e18828p-3, INEXACT)
T(RN,  0x1.b7ca855337fd6p+589,   -0x1.c9440a3401043p-1,  -0x1.16a30ep-2, INEXACT)
T(RN,  0x1.624d7da18483cp+589,    0x1.0b68f35cac298p-1,   0x1.710e36p-2, INEXACT)
T(RN,  0x1.e88a4c19667bap+589,    0x1.3a93be4daa907p-1,   0x1.cb760ap-4, INEXACT)
T(RN,  0x1.6d4831b1152d3p+589,    0x1.ef5832b605ca3p-1,   0x1.254aeap-2, INEXACT)
T(RN,  0x1.d96dbfc44629ep+589,    0x1.a5bc35fa93a74p-2,   0x1.4fc2a8p-3, INEXACT)
T(RN,  0x1.2683f6e0c176cp+590,    0x1.ea4cb24d5d9bcp-1,   0x1.42f83cp-2, INEXACT)
T(RN,  0x1.10b302463fc4bp+590,    0x1.f3e94db2fb12cp-1,   0x1.263542p-2, INEXACT)
T(RN,   0x1.886d32604112p+590,   -0x1.8048f0ffe38bap-1,  -0x1.4424d8p-6, INEXACT)
T(RN,  0x1.41f2cdf6ac5a2p+590,   -0x1.8be1de4662d79p-1,   -0x1.c68b4p-5, INEXACT)
T(RN,  0x1.699d22c5744f8p+590,    0x1.ffd75ebae1dcap-1,   0x1.ba5bc6p-2, INEXACT)
T(RN,  0x1.fb7b05e25a56cp+590,   -0x1.9fc651e5de0b3p-1,   0x1.d8217ep-2, INEXACT)
T(RN,  0x1.1e0e2ab062d03p+590,   -0x1.61cd32aa88c28p-1,  -0x1.fcf05cp-2, INEXACT)
T(RN,   0x1.8a9f41b7dfbep+590,    -0x1.ffc615a70a36p-1,  -0x1.f90c04p-3, INEXACT)
T(RN,  0x1.6cd105a57acc1p+590,    0x1.bc11f89c0c008p-1,  -0x1.f3036ap-2, INEXACT)
T(RN,  0x1.483034089d673p+590,   -0x1.e9158279cd14ep-1,   0x1.c72824p-3, INEXACT)
T(RN,  0x1.249120371bf6dp+591,    0x1.7f57faa0c7e65p-1,   0x1.47c77cp-3, INEXACT)
T(RN,  0x1.1d2a99ee20902p+591,   -0x1.d361dee599cddp-2,   0x1.b9623ep-3, INEXACT)
T(RN,  0x1.2bdf39706a37bp+591,   -0x1.3f7027951ad7fp-1,   0x1.a48ccap-2, INEXACT)
T(RN,  0x1.ca87400a21c1ep+591,    0x1.eec560fc5c725p-1,  -0x1.92a4eep-2, INEXACT)
T(RN,  0x1.bcc748ea2499ep+591,    0x1.6f6e95c796122p-2,   0x1.976a8ap-2, INEXACT)
T(RN,  0x1.df3240fdf35d3p+591,   -0x1.e42a4a739a695p-2,  -0x1.33641ep-2, INEXACT)
T(RN,  0x1.df186ed9f080ap+591,   -0x1.a2f157a1c057fp-1,  -0x1.2122dcp-2, INEXACT)
T(RN,  0x1.3fa1d50a397ebp+591,    0x1.5cb85605d2343p-3,  -0x1.e36ed6p-2, INEXACT)
T(RN,  0x1.50ebec55b38d9p+591,    0x1.3998d4bbdb02ep-3,   0x1.d8928ap-3, INEXACT)
T(RN,  0x1.99f41646e837ep+591,   -0x1.fc3008a808411p-1,   0x1.eb67c6p-2, INEXACT)
T(RN,  0x1.234b812a186c9p+592,    -0x1.0882d56dd17bp-4,  -0x1.5a0d34p-2, INEXACT)
T(RN,  0x1.97ae503caff9ep+592,   -0x1.4e6c89cb1846ep-1,   0x1.8920a8p-3, INEXACT)
T(RN,  0x1.e9ea62632eb78p+592,    0x1.8bf8de76d679ap-1,  -0x1.e65baep-3, INEXACT)
T(RN,  0x1.bc92118fcdb14p+592,   -0x1.748d3fe8e301fp-1,   0x1.e4b1fep-2, INEXACT)
T(RN,  0x1.38db3b352c3c9p+592,    0x1.213ee6d85f46ap-1,  -0x1.b5191cp-3, INEXACT)
T(RN,  0x1.64c99d7d5580ap+592,   -0x1.d54be6b4ddbbap-1,   0x1.8d543cp-2, INEXACT)
T(RN,  0x1.12cb6ec5c8668p+592,    0x1.896c3887e89afp-2,  -0x1.3416f8p-2, INEXACT)
T(RN,  0x1.1ff5f1e83fafep+592,    0x1.09e24c53e31a5p-3,  -0x1.376d6cp-2, INEXACT)
T(RN,  0x1.a7e3031980252p+592,    0x1.6bc904792a63fp-2,  -0x1.906d6cp-4, INEXACT)
T(RN,  0x1.0c6be91513505p+592,   -0x1.fffa15f62e69ap-1,  -0x1.132ddep-2, INEXACT)
T(RN,  0x1.a452f4ba9dd88p+593,    0x1.3923a94a793b6p-1,   0x1.3e113cp-5, INEXACT)
T(RN,  0x1.1b88e19774b8dp+593,    0x1.fbf720509f0a5p-1,  -0x1.a0e7b8p-5, INEXACT)
T(RN,  0x1.06e079307bb02p+593,   -0x1.cc8aa14fc36f7p-1,   0x1.20c284p-2, INEXACT)
T(RN,  0x1.8efc9a1f3270ap+593,   -0x1.139185265f3cbp-1,  -0x1.009dc6p-4, INEXACT)
T(RN,  0x1.05be9eebc2327p+593,    0x1.e969d442a0c47p-1,   0x1.c86e82p-6, INEXACT)
T(RN,   0x1.363cd3e056cap+593,    -0x1.5295f958b1f9p-1,   0x1.4cfb3ep-4, INEXACT)
T(RN,  0x1.6fac4bf2af178p+593,    0x1.fabd0f989b53bp-1,  -0x1.3d6fdep-2, INEXACT)
T(RN,  0x1.da4878a9d962bp+593,    0x1.6261e0c050c4ep-1,   0x1.9aed72p-2, INEXACT)
T(RN,  0x1.4099b08e967a3p+593,    0x1.6597ea9ed9ff7p-1,  -0x1.361db6p-2, INEXACT)
T(RN,  0x1.e41c2704bfcf5p+593,   -0x1.dc76c860964ebp-1,   0x1.9e60c8p-3, INEXACT)
T(RN,  0x1.854026a168015p+594,   -0x1.d5e136c32f2cbp-2,  -0x1.1e4992p-4, INEXACT)
T(RN,  0x1.b669d8300de98p+594,    0x1.196c3d04fc1f2p-2,  -0x1.aeb1dcp-3, INEXACT)
T(RN,  0x1.ec48c982cbdaap+594,   -0x1.75b267df33436p-2,   0x1.199c54p-6, INEXACT)
T(RN,  0x1.472e1381964c9p+594,   -0x1.4c3bdc8e04692p-1,   0x1.898c64p-2, INEXACT)
T(RN,   0x1.eefb4933f20ap+594,    0x1.d363d1581c161p-1,    0x1.0d417p-2, INEXACT)
T(RN,  0x1.63cedec3666dap+594,   -0x1.f2ba2baf4a374p-2,  -0x1.ef027cp-2, INEXACT)
T(RN,  0x1.c1f1ecd9d6dacp+594,   -0x1.ba382e2037adap-1,   -0x1.5ed9ep-4, INEXACT)
T(RN,  0x1.208ce23b161c8p+594,   -0x1.fd6ae7e8b2b7ap-1,   0x1.559028p-3, INEXACT)
T(RN,  0x1.5f14bef00f184p+594,   -0x1.acb96f7a59c8ap-1,   0x1.395b02p-2, INEXACT)
T(RN,  0x1.5cd98b291d5e6p+594,     0x1.2519acfc3294p-5,  -0x1.701724p-6, INEXACT)
T(RN,  0x1.d9a29af8a7f87p+595,    0x1.1aef166bd79d5p-2,   0x1.8437a4p-2, INEXACT)
T(RN,  0x1.b5393cab09f4dp+595,    0x1.78e69bd9f8f75p-3,   0x1.e0e648p-2, INEXACT)
T(RN,  0x1.caaab505ec02ap+595,   -0x1.f61f383c63d6ep-3,    0x1.096adp-2, INEXACT)
T(RN,   0x1.d50196e953b7p+595,    0x1.4b2ceb57f1eabp-1,  -0x1.2d5fd4p-2, INEXACT)
T(RN,  0x1.c0d21c383af68p+595,    0x1.fe559f6157c53p-1,  -0x1.0141eep-2, INEXACT)
T(RN,  0x1.4d93cfe8826d4p+595,    0x1.2561e0f3f5d19p-3,  -0x1.8f325ep-5, INEXACT)
T(RN,  0x1.02a6b06bc7ec7p+595,   -0x1.05307d4dc8adep-3,  -0x1.fcb392p-4, INEXACT)
T(RN,  0x1.152a484660f8ep+595,    0x1.e6b220f5efdfap-1,   0x1.aa5024p-2, INEXACT)
T(RN,  0x1.c7dbf65bff642p+595,    0x1.2966d55a5c31ep-1,  -0x1.68f524p-5, INEXACT)
T(RN,  0x1.79a7f2caae871p+595,    0x1.aa70f2ff2875fp-1,  -0x1.810eb4p-6, INEXACT)
T(RN,  0x1.5f955048240e4p+596,   -0x1.2a1975ad737aep-2,  -0x1.861b44p-2, INEXACT)
T(RN,  0x1.571246b476ed8p+596,   -0x1.515cda0918e9fp-1,  -0x1.bd5202p-4, INEXACT)
T(RN,  0x1.6ba393a4f350dp+596,    0x1.f30471173b134p-1,  -0x1.3677aap-3, INEXACT)
T(RN,  0x1.f62cd893c2cbcp+596,   -0x1.7a5b9d174171ap-2,   -0x1.067afp-5, INEXACT)
T(RN,  0x1.bf3ec4f011ed4p+596,   -0x1.cf2d079719cf8p-1,   0x1.cf59c2p-2, INEXACT)
T(RN,  0x1.d8bcbf222715ep+596,    0x1.1ba99f87d5b54p-3,  -0x1.1a8926p-2, INEXACT)
T(RN,  0x1.bfdedbae251fap+596,    0x1.df78fa0140624p-1,    0x1.c098ep-2, INEXACT)
T(RN,  0x1.e8be3a8e2b29ep+596,   -0x1.f0473025c45a1p-2,   0x1.f5ab0cp-6, INEXACT)
T(RN,  0x1.bf465f96ab7d6p+596,    0x1.c027ffaec68a5p-4,   0x1.f6bd64p-3, INEXACT)
T(RN,  0x1.cc0d64008b3cfp+596,   -0x1.e7e5d932c105ap-1,  -0x1.93099ap-2, INEXACT)
T(RN,  0x1.cecd335432f93p+597,   -0x1.fe9adb6578845p-1,  -0x1.a3cbc4p-2, INEXACT)
T(RN,  0x1.55821ee2879b5p+597,    0x1.c35c431c58794p-1,  -0x1.e99c78p-2, INEXACT)
T(RN,  0x1.c7f8b83f078b8p+597,   -0x1.ac90e4c7209cdp-1,  -0x1.441e2ep-2, INEXACT)
T(RN,  0x1.d9f3ad2829f46p+597,    0x1.d037d43a8931ep-1,  -0x1.feaf5ep-2, INEXACT)
T(RN,  0x1.80a5f83d51936p+597,   -0x1.f771369d92d69p-1,   0x1.37a0e8p-3, INEXACT)
T(RN,  0x1.82cf0a57e4fc6p+597,    0x1.49d3ac30d69e7p-1,  -0x1.9eac2ep-2, INEXACT)
T(RN,  0x1.5f6d1a25bf5fcp+597,   -0x1.aa00fe23cb108p-1,   0x1.306a7cp-2, INEXACT)
T(RN,  0x1.06a7f0b76512ep+597,   -0x1.fb95b226d4eafp-1,   0x1.149e1ap-7, INEXACT)
T(RN,  0x1.0ed7a0013028cp+597,   -0x1.2ee69cbf444ddp-2,  -0x1.fee922p-4, INEXACT)
T(RN,  0x1.9902a14ca9222p+597,   -0x1.b44428d2001c8p-4,  -0x1.1b7f06p-2, INEXACT)
T(RN,  0x1.345c76c5349aep+598,     0x1.49c11dcf1fb7p-4,  -0x1.d17074p-3, INEXACT)
T(RN,  0x1.394683e849cf1p+598,   -0x1.ff3c14485cd61p-1,  -0x1.841e72p-2, INEXACT)
T(RN,  0x1.e96ab3032ff18p+598,    0x1.ce6f2249f636ap-1,  -0x1.d211a6p-4, INEXACT)
T(RN,  0x1.fc4cbc7d1b0eep+598,   -0x1.59bd5021498e6p-1,   0x1.03c5bep-3, INEXACT)
T(RN,  0x1.e88cb6504771ap+598,   -0x1.37eac2aaab9f7p-1,  -0x1.ae89e2p-2, INEXACT)
T(RN,  0x1.0bdea5359860fp+598,   -0x1.3073344d71597p-3,   0x1.3043f2p-6, INEXACT)
T(RN,  0x1.685bb22b7ac5cp+598,     0x1.68640b6af905p-1,   -0x1.e90f7p-2, INEXACT)
T(RN,  0x1.889ab3f92ed2dp+598,    0x1.871260e038769p-7,   0x1.db6ef2p-2, INEXACT)
T(RN,  0x1.ee05b1ae23424p+598,    0x1.fb4ade9b5e8a9p-1,  -0x1.022f46p-2, INEXACT)
T(RN,  0x1.655ca13e3e0c4p+598,   -0x1.14fd17997a0cbp-2,  -0x1.86e55cp-4, INEXACT)
T(RN,  0x1.c84654d163ad6p+599,   -0x1.e73ed749e67e1p-1,   0x1.acdc8ep-2, INEXACT)
T(RN,  0x1.c2368e0113491p+599,   -0x1.e7fd8baf901d9p-1,  -0x1.79c65ep-2, INEXACT)
T(RN,  0x1.bafbdd59cc088p+599,    0x1.6e5e1e67430d7p-1,   -0x1.39ccbp-2, INEXACT)
T(RN,  0x1.080da745fdf17p+599,    -0x1.2bf2fa9e3afep-5,  -0x1.a8f7a2p-2, INEXACT)
T(RN,  0x1.cf89c0569f985p+599,    0x1.7b0b81e2035bbp-1,   0x1.3cb29cp-2, INEXACT)
T(RN,  0x1.b26ab5caaacd1p+599,    0x1.f87c3b4ae2286p-3,  -0x1.c30a94p-2, INEXACT)
T(RN,   0x1.7d9fa24db977p+599,    0x1.feee15d7aac08p-1,   0x1.b45e3ep-3, INEXACT)
T(RN,  0x1.e520983fc662ep+599,    0x1.bee56421eb899p-1,   0x1.658e7ap-3, INEXACT)
T(RN,  0x1.52d656edef697p+599,    0x1.bc2bf6808223dp-2,  -0x1.3c18fcp-3, INEXACT)
T(RN,  0x1.64771e3dd775cp+599,   -0x1.79d042133ae3cp-1,   0x1.159eaep-2, INEXACT)
T(RN,  0x1.e9b4442cf8898p+600,   -0x1.ea17ee8ab4252p-3,  -0x1.a613c8p-2, INEXACT)
T(RN,  0x1.dafb640e70d7ap+600,   -0x1.b5b16cbafd0f1p-3,  -0x1.d0a85ap-2, INEXACT)
T(RN,  0x1.251a512e5793bp+600,    0x1.eba08b70798dep-2,  -0x1.cd4ed4p-2, INEXACT)
T(RN,  0x1.4da1544eb3641p+600,    0x1.d8432c339a0dcp-8,  -0x1.d18d8cp-2, INEXACT)
T(RN,  0x1.7a37b15051d95p+600,   -0x1.fa556636b698dp-1,  -0x1.5ea712p-3, INEXACT)
T(RN,   0x1.3e5a0016097fp+600,   -0x1.e5cae0ec80456p-1,   0x1.6b9182p-2, INEXACT)
T(RN,  0x1.3a4ec68c6f495p+600,    0x1.a372d4b7390cfp-2,     0x1.1a83p-3, INEXACT)
T(RN,  0x1.b1b56a54c06dap+600,   -0x1.62910d746bfcfp-2,   0x1.28095ep-4, INEXACT)
T(RN,  0x1.fd22b5ba0318ap+600,   -0x1.8dd1ea75ebba4p-1,  -0x1.f04222p-3, INEXACT)
T(RN,   0x1.cad45ae62ea9p+600,   -0x1.2d8ddbc587a2bp-1,  -0x1.365222p-2, INEXACT)
T(RN,  0x1.83c641b7756eep+601,   -0x1.5370a6e289e34p-3,   -0x1.8af63p-2, INEXACT)
T(RN,  0x1.c884e8e4957d6p+601,    0x1.9e1466c7fc61fp-1,  -0x1.1e66f4p-2, INEXACT)
T(RN,  0x1.cf55afc15a2fep+601,   -0x1.cf163d2de262ap-1,   0x1.773f5ap-5, INEXACT)
T(RN,  0x1.57ac0401d91c7p+601,    -0x1.1cd451920931p-3,   0x1.bb21a8p-2, INEXACT)
T(RN,   0x1.dab4a469010ap+601,    0x1.fa239bad4d7d5p-1,  -0x1.4c5988p-2, INEXACT)
T(RN,  0x1.ff74f17e4c2b2p+601,    0x1.f627ad283ed6bp-1,   0x1.6d4112p-3, INEXACT)
T(RN,  0x1.365c341ff63f7p+601,   -0x1.c72ff8614d27cp-1,   0x1.456612p-6, INEXACT)
T(RN,  0x1.7bee11bb005d7p+601,    0x1.a5157976379d5p-1,  -0x1.3d8ed2p-2, INEXACT)
T(RN,  0x1.afb79f1024e0ap+601,     0x1.99407910e0dcp-1,   0x1.6e8f94p-4, INEXACT)
T(RN,  0x1.3a42ee9f72398p+601,    0x1.f624aa3eb29dbp-1,   0x1.113bacp-2, INEXACT)
T(RN,   0x1.a806b2aeb848p+602,    0x1.6be370302a32bp-2,   0x1.aee662p-3, INEXACT)
T(RN,  0x1.33ad661153d4cp+602,    0x1.fc29b6d52307dp-1,   0x1.109fc2p-3, INEXACT)
T(RN,  0x1.51dba58b6a809p+602,    0x1.fd1cbbb314422p-4,   0x1.327242p-2, INEXACT)
T(RN,  0x1.1714bce62c311p+602,    0x1.ffb0bbc438f25p-1,   0x1.03f75ep-2, INEXACT)
T(RN,  0x1.94f174a7e09e2p+602,    0x1.ed776f450a32ap-1,   0x1.9016f8p-4, INEXACT)
T(RN,  0x1.251c62771f4b1p+602,    0x1.f45ec58956286p-1,  -0x1.18ed4ep-2, INEXACT)
T(RN,  0x1.d55e157e8a641p+602,   -0x1.fa075f172c9e8p-1,   0x1.053182p-2, INEXACT)
T(RN,   0x1.7a5a10d04877p+602,    0x1.c29a4606d2bf1p-1,   0x1.8fd0b2p-2, INEXACT)
T(RN,  0x1.0f6ad991bc5cep+602,    0x1.d19a5ad9f4335p-4,  -0x1.5fb41ep-2, INEXACT)
T(RN,  0x1.5c5594f32678fp+602,   -0x1.d250e0bf3cbf7p-1,   0x1.4cfa6ep-2, INEXACT)
T(RN,  0x1.0096bc511e805p+603,    0x1.ffffc5fdb14efp-1,  -0x1.c2031cp-4, INEXACT)
T(RN,  0x1.a9d0246b41b17p+603,    0x1.fcdb36fbc02a2p-1,  -0x1.27bf06p-3, INEXACT)
T(RN,  0x1.89193f0400b9dp+603,   -0x1.a080768c43e21p-3,    -0x1.af73p-4, INEXACT)
T(RN,  0x1.6352b2cbf2954p+603,     0x1.84a56da2c7fbp-1,   0x1.47cd02p-3, INEXACT)
T(RN,  0x1.e86016d96e092p+603,    0x1.86fd75f313cfep-1,   0x1.da5e8cp-2, INEXACT)
T(RN,  0x1.99beb24a8692dp+603,    0x1.ee7fdd90024e8p-1,   0x1.e453cap-3, INEXACT)
T(RN,  0x1.7176fe592731bp+603,    -0x1.42abe0977a43p-1,  -0x1.a719eep-4, INEXACT)
T(RN,  0x1.81fbe0ab6bab6p+603,   -0x1.9b332054989f4p-1,  -0x1.5ef416p-2, INEXACT)
T(RN,  0x1.35b9c37e4abe7p+603,   -0x1.a990f4a251a7cp-1,   0x1.eccbccp-3, INEXACT)
T(RN,  0x1.d185ee9159e5dp+603,   -0x1.da8515224246dp-1,  -0x1.ff1112p-3, INEXACT)
T(RN,  0x1.0b68c3db7c0cep+604,    0x1.5aed7299095e8p-1,  -0x1.8e5a6ep-2, INEXACT)
T(RN,  0x1.2becf13a5a091p+604,   -0x1.d25872f56361ep-1,   0x1.def132p-2, INEXACT)
T(RN,  0x1.4f51550ef6cfap+604,   -0x1.831df60804a7ep-3,   0x1.778658p-3, INEXACT)
T(RN,  0x1.4917685401c44p+604,   -0x1.88f53984399d1p-1,   0x1.e8cfc6p-2, INEXACT)
T(RN,  0x1.7241e3367df61p+604,   -0x1.d6c17ddd6794cp-1,    0x1.fa0e6p-3, INEXACT)
T(RN,  0x1.8cbb473b00a76p+604,   -0x1.51b1c58067f5fp-1,   0x1.5110bap-4, INEXACT)
T(RN,  0x1.f08c802ffbf7cp+604,    0x1.7cb3d5793365dp-1,  -0x1.c9e612p-2, INEXACT)
T(RN,  0x1.4d044f6226d3ep+604,    0x1.f1f5197a888dep-3,  -0x1.4f296cp-5, INEXACT)
T(RN,   0x1.33c8435b9e64p+604,   -0x1.b26481e74dc7fp-5,   0x1.5117c6p-3, INEXACT)
T(RN,  0x1.35e0782198db6p+604,   -0x1.fe64bd1657db5p-1,  -0x1.c559c4p-2, INEXACT)
T(RN,   0x1.bf1385ebc241p+605,   -0x1.384c487caa956p-2,   0x1.dfbc16p-2, INEXACT)
T(RN,  0x1.c10b06810713ep+605,   -0x1.5a640d47f5b0dp-1,  -0x1.85eefcp-2, INEXACT)
T(RN,  0x1.e6ce559b74d98p+605,    0x1.df4d5f0e5d135p-1,  -0x1.737cb2p-2, INEXACT)
T(RN,  0x1.8d1452e8f3098p+605,   -0x1.6398921e07b66p-1,   0x1.0e78fcp-5, INEXACT)
T(RN,  0x1.c79c8cfa29302p+605,    0x1.3dfd8cc6c3866p-3,   -0x1.dd1b4p-2, INEXACT)
T(RN,  0x1.35d4b2ffc8ba4p+605,   -0x1.11287675d7e0ep-1,   0x1.8afb8ep-9, INEXACT)
T(RN,   0x1.ba36a738a36fp+605,    0x1.fda1a3c2b3bb7p-1,   0x1.b7d618p-3, INEXACT)
T(RN,  0x1.726c3fcabcb5ep+605,   -0x1.730c5f30cf6e5p-4,   0x1.47d258p-2, INEXACT)
T(RN,  0x1.6a5ad47509f17p+605,   -0x1.ee247f531dc8dp-1,    0x1.9397cp-5, INEXACT)
T(RN,  0x1.a37dbbc346716p+605,    0x1.c402af8c7d99fp-1,  -0x1.56b966p-2, INEXACT)
T(RN,  0x1.6a90541c34dd3p+606,    0x1.5904e073690eep-2,   0x1.490244p-2, INEXACT)
T(RN,  0x1.5c6aa81876b18p+606,   -0x1.76c5aabc70efbp-1,    0x1.c265ep-2, INEXACT)
T(RN,  0x1.686ad8055b6b7p+606,    0x1.aafe76d21f16ep-1,  -0x1.c0ff16p-2, INEXACT)
T(RN,  0x1.6b45a18a09216p+606,    0x1.cd792572fa921p-3,   0x1.73ce76p-3, INEXACT)
T(RN,  0x1.dd5d952f800b6p+606,    0x1.9038120e23d28p-1,  -0x1.b53208p-5, INEXACT)
T(RN,  0x1.a8797807c05ecp+606,   -0x1.051caa3a213bcp-2,  -0x1.5dd032p-3, INEXACT)
T(RN,  0x1.a3ed619162084p+606,    0x1.7991ae2879329p-1,   0x1.48c3eap-3, INEXACT)
T(RN,  0x1.0dc475ef80a33p+606,   -0x1.c3f0df8b2bf8bp-1,  -0x1.d5bb62p-2, INEXACT)
T(RN,  0x1.04c1ac469061ap+606,   -0x1.ff27cd29a08c3p-1,   0x1.60102cp-2, INEXACT)
T(RN,   0x1.54c4b789af17p+606,    0x1.9d08e2ea2efbap-1,   0x1.1ba786p-3, INEXACT)
T(RN,  0x1.3311c19151442p+607,   -0x1.40d4ee241aebfp-1,  -0x1.49a234p-2, INEXACT)
T(RN,  0x1.65cdad6ea0b36p+607,    0x1.4b82e3d87e79bp-1,  -0x1.b00d7cp-2, INEXACT)
T(RN,  0x1.c76334cc2f48cp+607,   -0x1.006e972e36b78p-1,   0x1.2a7018p-2, INEXACT)
T(RN,  0x1.806011925cee8p+607,   -0x1.066c6a0357b44p-1,   0x1.932416p-2, INEXACT)
T(RN,  0x1.94da09ecde35ep+607,    0x1.ec37d54c10cdbp-1,   0x1.490a1ap-5, INEXACT)
T(RN,  0x1.2378e7443af8ap+607,    0x1.63128c8f51527p-2,  -0x1.6781a6p-5, INEXACT)
T(RN,  0x1.3cbf4d3e82567p+607,   -0x1.5bf114f0ee17ep-5,   0x1.472adcp-3, INEXACT)
T(RN,   0x1.e2551f271b38p+607,    0x1.f91fc2c55bf97p-2,  -0x1.629c08p-2, INEXACT)
T(RN,  0x1.ce48f62f58b69p+607,   -0x1.ec99ab22e5f78p-1,   0x1.9ce89ep-3, INEXACT)
T(RN,  0x1.6a3a1810b069ap+607,   -0x1.e17295990ea3dp-1,    0x1.74c95p-3, INEXACT)
T(RN,  0x1.3df386c6e66dbp+608,   -0x1.436e4a4de697bp-1,   0x1.bf69cap-6, INEXACT)
T(RN,  0x1.f1795dd9cac42p+608,     0x1.db13d46373a3p-1,  -0x1.2270b2p-3, INEXACT)
T(RN,  0x1.0e7dfd31df16fp+608,    0x1.2d9e35d89da78p-1,   0x1.de089ap-2, INEXACT)
T(RN,  0x1.9b3084b321a4ap+608,    0x1.fc95f7e388623p-1,    0x1.29dfap-2, INEXACT)
T(RN,  0x1.4d4e8eda49d36p+608,    0x1.59e5e4e0a712ep-1,   0x1.b5204ep-5, INEXACT)
T(RN,  0x1.3f2a84fe33715p+608,    0x1.d7de3e584bb0ep-2,  -0x1.f00a0cp-3, INEXACT)
T(RN,  0x1.b6678e63c0e3ep+608,   -0x1.1a6ec6b668d1ap-2,  -0x1.de1e92p-7, INEXACT)
T(RN,  0x1.560dc5ae21bb8p+608,   -0x1.86b00502aa7abp-1,  -0x1.d87864p-3, INEXACT)
T(RN,  0x1.9a0076c1e7a96p+608,    0x1.8b87ad3543ac9p-2,   -0x1.69717p-2, INEXACT)
T(RN,  0x1.4fff5c0e7fa84p+608,    0x1.cab190a440c11p-1,  -0x1.f646f8p-2, INEXACT)
T(RN,   0x1.ec52ed1eed17p+609,   -0x1.aed137393d2acp-2,  -0x1.5a4452p-2, INEXACT)
T(RN,  0x1.e0ec67fe3a5e6p+609,   -0x1.f44320ed4339bp-1,   0x1.71774ap-3, INEXACT)
T(RN,  0x1.486f0a54e77a8p+609,   -0x1.f4576e4cfe849p-1,   0x1.76aad6p-3, INEXACT)
T(RN,  0x1.42abf45f4a836p+609,    0x1.f33139e9b2c43p-1,  -0x1.7c0bacp-2, INEXACT)
T(RN,  0x1.e7358352adcecp+609,    0x1.db0b71eec2701p-1,   0x1.1186aep-5, INEXACT)
T(RN,  0x1.042dd910c1bd4p+609,    -0x1.1b5a99cd8f03p-3,  -0x1.69b648p-2, INEXACT)
T(RN,  0x1.6a0a93365d636p+609,    0x1.ec196da9af19ap-1,  -0x1.565644p-3, INEXACT)
T(RN,  0x1.0db1ae166c986p+609,     0x1.ec30470df258p-1,  -0x1.f37c74p-2, INEXACT)
T(RN,  0x1.338b0a95301fdp+609,   -0x1.381fb68c50f77p-2,  -0x1.1c194ep-2, INEXACT)
T(RN,  0x1.81d2631b64449p+609,    -0x1.dfa29b65b1b4p-3,   0x1.64c18cp-5, INEXACT)
T(RN,  0x1.914bc411f4e0fp+610,    -0x1.ffaeb4a1f19cp-1,  -0x1.ee5cfep-2, INEXACT)
T(RN,  0x1.a7a93014e9d04p+610,    0x1.7fbc299c5c301p-1,  -0x1.761d6ep-3, INEXACT)
T(RN,  0x1.3776a7efcbfe6p+610,    -0x1.211a87bb07e5p-2,   0x1.fcebfep-2, INEXACT)
T(RN,  0x1.eebfdeb33c163p+610,   -0x1.c4799d0ab67c5p-1,   0x1.b0b34ep-2, INEXACT)
T(RN,  0x1.2659479e234a2p+610,     0x1.38718c8abc43p-1,    0x1.323edp-6, INEXACT)
T(RN,  0x1.1ddf3f1156e06p+610,   -0x1.ebdf99d4279edp-1,  -0x1.5d249cp-3, INEXACT)
T(RN,  0x1.81a96bbf79a75p+610,    0x1.3b4ae4554a138p-1,  -0x1.b6e444p-2, INEXACT)
T(RN,  0x1.0f53c68ce0e2bp+610,    0x1.3e002e13d80e1p-2,   0x1.cbf9ccp-2, INEXACT)
T(RN,  0x1.7130917615f04p+610,    0x1.12d49d4829acep-2,  -0x1.87d9d8p-2, INEXACT)
T(RN,  0x1.719b1261f72dfp+610,   -0x1.c828a8b77cefdp-2,  -0x1.6e52cap-2, INEXACT)
T(RN,  0x1.c3003e9deff76p+611,    0x1.d61fd21d4b1a2p-1,   0x1.101814p-4, INEXACT)
T(RN,  0x1.76adceda1fea4p+611,   -0x1.72cc3162c1079p-2,   0x1.2abce2p-5, INEXACT)
T(RN,  0x1.e2aeecc48b8d6p+611,   -0x1.317f94e0ac8fap-1,   0x1.6b9cb6p-2, INEXACT)
T(RN,  0x1.d715552f6d5c1p+611,    0x1.fdbbf594f301cp-1,  -0x1.98baaep-2, INEXACT)
T(RN,  0x1.25056481574ecp+611,   -0x1.fcd1627a6a145p-1,   0x1.bfa7fcp-2, INEXACT)
T(RN,  0x1.ef9fa2ca2a2fcp+611,    0x1.e55cbc1bcbd4bp-1,   0x1.5a021ap-4, INEXACT)
T(RN,  0x1.8b9c112a9cd95p+611,    0x1.ec67f134cb5e9p-1,   0x1.aa3fa6p-5, INEXACT)
T(RN,   0x1.45425c6ff064p+611,    0x1.0277517e9989cp-1,   0x1.f3b5bap-2, INEXACT)
T(RN,  0x1.cf348a1b9ec22p+611,    0x1.beebd4d8ae459p-2,   0x1.c8dcfep-5, INEXACT)
T(RN,  0x1.d71850e9ec14cp+611,    0x1.f3d24f0f0de65p-1,   -0x1.43f26p-2, INEXACT)
T(RN,  0x1.e8e1f556e5805p+612,   -0x1.cf9eb7fb927dep-1,   0x1.4f265ap-2, INEXACT)
T(RN,  0x1.e9673f3bf579ep+612,   -0x1.e5ace26176d8fp-1,  -0x1.e95f28p-2, INEXACT)
T(RN,  0x1.19a69fad974ffp+612,    0x1.ced64965faddcp-1,  -0x1.e30432p-3, INEXACT)
T(RN,  0x1.541ab626fadfep+612,   -0x1.a19b22f6f3529p-1,   0x1.3e40eap-5, INEXACT)
T(RN,  0x1.97e2b812217d5p+612,   -0x1.f3ddd963298ecp-3,   0x1.863d18p-3, INEXACT)
T(RN,  0x1.5b1484d4f1593p+612,    0x1.d38b1ea88dad5p-1,  -0x1.f11bfcp-2, INEXACT)
T(RN,  0x1.a6698d6aac5c9p+612,    0x1.fb1196d3aa1d4p-1,  -0x1.2763fep-2, INEXACT)
T(RN,  0x1.3b0d8c2be9ed1p+612,    0x1.235543859c98ep-1,   0x1.6a314ap-4, INEXACT)
T(RN,  0x1.a07c0ad984a8fp+612,    0x1.c5e92ef39337ep-1,    0x1.febc8p-2, INEXACT)
T(RN,  0x1.fddb3ed787c97p+612,   -0x1.3041fec7ad012p-1,  -0x1.b8595ep-3, INEXACT)
T(RN,  0x1.20214897858d3p+613,    0x1.f4cced0a5a193p-1,  -0x1.c71886p-2, INEXACT)
T(RN,  0x1.c5a694c3adbbep+613,   -0x1.3a369644bd1f5p-1,  -0x1.b4531cp-2, INEXACT)
T(RN,  0x1.74b16adbc16d7p+613,   -0x1.77dca0384eb8ep-4,   0x1.f1471ep-2, INEXACT)
T(RN,  0x1.7bf259fce8859p+613,   -0x1.dcb27ce6272a7p-1,  -0x1.b1548ep-2, INEXACT)
T(RN,   0x1.c8e6b89a15a3p+613,    0x1.ebbb71283df94p-2,    0x1.012dcp-3, INEXACT)
T(RN,  0x1.e5f9fdaa3e3fbp+613,   -0x1.635c146049d7dp-1,  -0x1.b617b6p-3, INEXACT)
T(RN,  0x1.15dc595a8c455p+613,   -0x1.ff8f1127e64f4p-1,  -0x1.067698p-8, INEXACT)
T(RN,  0x1.745fc10ee6324p+613,   -0x1.9711be54ea95bp-1,  -0x1.64dc6cp-2, INEXACT)
T(RN,  0x1.89a3c31c5ba56p+613,   -0x1.d0d54b0e6d7e6p-1,  -0x1.af4cd4p-4, INEXACT)
T(RN,  0x1.eac210bae9b87p+613,    0x1.dff5060dc8843p-1,   0x1.006f3ap-2, INEXACT)
T(RN,  0x1.0efde4cf663d3p+614,   -0x1.c6cf7b8ec6a5bp-1,   0x1.a06c98p-3, INEXACT)
T(RN,  0x1.69e2298a3b851p+614,   -0x1.6e75893ea8807p-2,   0x1.cb733ep-7, INEXACT)
T(RN,  0x1.b004859c7d474p+614,    0x1.5f5f801bfc4c9p-3,   0x1.841be2p-3, INEXACT)
T(RN,  0x1.f3cc50001388dp+614,   -0x1.a5ce8d51dcbd6p-4,  -0x1.306782p-3, INEXACT)
T(RN,  0x1.a8c077ac61703p+614,    0x1.fded5df134f1bp-1,  -0x1.e4dcaap-3, INEXACT)
T(RN,  0x1.d9f111a372b7bp+614,   -0x1.73979432cffd4p-1,    0x1.66d52p-3, INEXACT)
T(RN,  0x1.d56a978a10e0cp+614,   -0x1.e5f274314cd0fp-2,   0x1.48a412p-3, INEXACT)
T(RN,  0x1.afa98346981f4p+614,    0x1.4b071c50bf337p-1,   0x1.908d26p-2, INEXACT)
T(RN,  0x1.9bd3b7024dfdep+614,    0x1.4784ef0a4af02p-1,   0x1.e1c2bep-4, INEXACT)
T(RN,  0x1.296217e9e7086p+614,   -0x1.fc2203609cd6bp-1,   0x1.6e774cp-2, INEXACT)
T(RN,  0x1.5e3cea5e016b8p+615,    0x1.a29462ee5b63fp-9,  -0x1.ca5edcp-4, INEXACT)
T(RN,   0x1.00ab3379469ap+615,    0x1.ef063a488db41p-1,   0x1.9f6a88p-6, INEXACT)
T(RN,  0x1.e9a336ca7b47ep+615,   -0x1.ffb3956611f75p-1,  -0x1.18ec28p-3, INEXACT)
T(RN,   0x1.7b48bc9bd128p+615,   -0x1.e596d892b5d1ap-1,  -0x1.8d2228p-2, INEXACT)
T(RN,  0x1.47688f94c1fc9p+615,     0x1.b173e4680a1ap-1,  -0x1.4b4b94p-4, INEXACT)
T(RN,  0x1.ef4b86c8c7bcep+615,     0x1.74d012182268p-6,    0x1.25ff7p-2, INEXACT)
T(RN,   0x1.f8aa6917677dp+615,   -0x1.c2a9e55c7cd2ap-3,  -0x1.734ca6p-2, INEXACT)
T(RN,  0x1.480b01d85b27ep+615,   -0x1.d7c6b0679faa3p-1,   0x1.1a5fb6p-5, INEXACT)
T(RN,  0x1.9a1ed7ecb7e2ep+615,    0x1.c2571a3bd2088p-1,   0x1.214e1ep-4, INEXACT)
T(RN,  0x1.1ad672a5679f2p+615,   -0x1.e5877119ebee6p-1,    0x1.3b207p-3, INEXACT)
T(RN,  0x1.424a1c6a27012p+616,    0x1.407f85b01c992p-1,   0x1.8ccf56p-5, INEXACT)
T(RN,   0x1.ce73ab6bb3c7p+616,    0x1.f3331d567f456p-3,  -0x1.56a172p-2, INEXACT)
T(RN,  0x1.5e962a25aaac8p+616,   -0x1.b4563466c460dp-1,   0x1.ae7464p-2, INEXACT)
T(RN,  0x1.e50c89df05891p+616,   -0x1.3857890754d2ap-3,   0x1.5b05cep-2, INEXACT)
T(RN,  0x1.2de23fda46195p+616,   -0x1.b790992d09f0bp-1,  -0x1.d85c36p-4, INEXACT)
T(RN,  0x1.e4eb86f9c3d0cp+616,   -0x1.2b891699612b5p-1,   -0x1.d9322p-5, INEXACT)
T(RN,  0x1.b6381738d42bap+616,    0x1.0b4658e6f8909p-4,  -0x1.d4ada6p-2, INEXACT)
T(RN,  0x1.294e636335132p+616,    0x1.bac93710bd961p-1,   0x1.90d4aap-4, INEXACT)
T(RN,  0x1.5053ce52195a4p+616,   -0x1.61d40087418ffp-2,  -0x1.cff172p-2, INEXACT)
T(RN,  0x1.9563aa6b35472p+616,   -0x1.fffa79570bf03p-1,    0x1.d38ccp-2, INEXACT)
T(RN,  0x1.7089b0c04180bp+617,    -0x1.6f68f4950c16p-1,   0x1.09ee4cp-3, INEXACT)
T(RN,  0x1.a3cd7913bcaecp+617,   -0x1.80c2d4815bfcep-2,  -0x1.0f6658p-3, INEXACT)
T(RN,  0x1.de86d59920ca2p+617,   -0x1.c10ce257eb383p-1,  -0x1.7f8b6cp-2, INEXACT)
T(RN,  0x1.e712b4439c16ap+617,    0x1.5e174520e26a8p-1,  -0x1.67abc8p-5, INEXACT)
T(RN,  0x1.1680e358a4c86p+617,    0x1.b098c76146d99p-2,   0x1.db4ed2p-3, INEXACT)
T(RN,   0x1.a896e7312e82p+617,    0x1.e2597a442af61p-1,    0x1.9b53ep-3, INEXACT)
T(RN,  0x1.30b43f59a954ep+617,   -0x1.1ca449f641d63p-1,    0x1.07499p-2, INEXACT)
T(RN,  0x1.15f11ea946ad4p+617,   -0x1.fff766ef85ae9p-1,  -0x1.56afaep-4, INEXACT)
T(RN,  0x1.c83d99bd71616p+617,    0x1.9de8758d4b09ap-1,   0x1.375206p-4, INEXACT)
T(RN,  0x1.84edfe461a1a8p+617,    0x1.1e61dc10b0d91p-1,   0x1.dac5f2p-6, INEXACT)
T(RN,  0x1.a3a687451d8c6p+618,    0x1.e68616e4db28ep-1,   0x1.7eec2cp-4, INEXACT)
T(RN,  0x1.e149576a7dc2ep+618,   -0x1.269872d3d8976p-1,  -0x1.8a71f2p-3, INEXACT)
T(RN,   0x1.1ee73570d4e8p+618,   -0x1.e5f22fdee8f0fp-1,   0x1.9df15ep-2, INEXACT)
T(RN,  0x1.3664f3c3b5501p+618,    0x1.a2d2d2f537c3ap-1,   0x1.7a132ep-3, INEXACT)
T(RN,  0x1.ba621e427df06p+618,    0x1.d63294d8fcc5cp-1,  -0x1.788376p-4, INEXACT)
T(RN,  0x1.987bec498741ap+618,    0x1.08af308792953p-1,   0x1.96fb4cp-2, INEXACT)
T(RN,  0x1.a6fd932a436b6p+618,    0x1.d342d5651cb7fp-1,   0x1.46137ep-4, INEXACT)
T(RN,  0x1.32bda443fd614p+618,    0x1.fe022b6e9ee04p-1,   0x1.790f9ap-5, INEXACT)
T(RN,  0x1.d286e4837a4fap+618,    0x1.e5b3a86618b0ap-1,  -0x1.f0ff76p-5, INEXACT)
T(RN,  0x1.f4558ff6a6b6dp+618,   -0x1.be3ec86b214cdp-2,   0x1.e9b94cp-3, INEXACT)
T(RN,   0x1.dd0fcfdaedaap+619,    0x1.e5457b8f6ca6ep-2,   0x1.ee80d8p-2, INEXACT)
T(RN,  0x1.b5c2b0b7542eap+619,   -0x1.777601bd2409ep-1,  -0x1.63c18cp-2, INEXACT)
T(RN,  0x1.0c60c5722d756p+619,    0x1.3a4852df25336p-4,  -0x1.44ae1ap-5, INEXACT)
T(RN,  0x1.c8e0a94e23eebp+619,    0x1.d546c84153b68p-2,   -0x1.3c2adp-2, INEXACT)
T(RN,  0x1.5818802779ce3p+619,    0x1.7af00d92bee26p-1,  -0x1.2d1c9cp-2, INEXACT)
T(RN,  0x1.ae399786a37cbp+619,   -0x1.0c4033db9b285p-3,  -0x1.cdfdaap-2, INEXACT)
T(RN,  0x1.3cd5ab614d469p+619,    0x1.efee97b68a18ep-1,    0x1.15f14p-3, INEXACT)
T(RN,  0x1.9f16bcf8542e3p+619,   -0x1.d304674787419p-1,  -0x1.d639ecp-2, INEXACT)
T(RN,  0x1.58016f2287decp+619,    0x1.730ee93371523p-1,  -0x1.c507c2p-4, INEXACT)
T(RN,  0x1.c397dc472bac4p+619,    0x1.e22e8a66cd9b6p-4,   0x1.74de02p-4, INEXACT)
T(RN,  0x1.5a538dc41828ap+620,    0x1.3d6337dda506dp-1,   0x1.f5f6e2p-4, INEXACT)
T(RN,  0x1.27a6e2ef78161p+620,   -0x1.fc574f9824f0bp-1,   -0x1.215bap-5, INEXACT)
T(RN,  0x1.afa9ac8ec87e2p+620,     0x1.fec466d19064p-1,   -0x1.32f81p-4, INEXACT)
T(RN,  0x1.a669f961efd1ap+620,   -0x1.ac1f7d0de1105p-1,    0x1.7eca9p-3, INEXACT)
T(RN,  0x1.56bdc299a598fp+620,   -0x1.ac084b583287dp-1,  -0x1.a041f8p-2, INEXACT)
T(RN,  0x1.bdff8dd31c94ep+620,    0x1.ea6f5f872ce1ap-1,   -0x1.3a6ecp-2, INEXACT)
T(RN,  0x1.f7e8abd740125p+620,   -0x1.26500129736cdp-1,    0x1.7afbep-2, INEXACT)
T(RN,   0x1.9669d10b0b93p+620,    0x1.49a7dfb46340cp-2,   0x1.a0f93ap-2, INEXACT)
T(RN,  0x1.ae4bce8e11f62p+620,    0x1.fab60273a3c7fp-1,  -0x1.9dade8p-3, INEXACT)
T(RN,   0x1.e8dd5eac6defp+620,    0x1.201b24227c2a4p-1,   0x1.4fa7f4p-4, INEXACT)
T(RN,  0x1.bc1c7312c26efp+621,   -0x1.ffffbb78f59ddp-1,    0x1.dda25p-2, INEXACT)
T(RN,  0x1.0d9239cfae10ap+621,    0x1.ba273e91b5996p-6,   0x1.566b62p-3, INEXACT)
T(RN,  0x1.22266543f1449p+621,    0x1.3c311883ed5a8p-5,    0x1.bdb31p-2, INEXACT)
T(RN,  0x1.6919823dbb272p+621,    0x1.a389dad0d124cp-1,   -0x1.58f58p-2, INEXACT)
T(RN,  0x1.38684992158d3p+621,    0x1.fa984ba30ba88p-1,   0x1.e5127ep-2, INEXACT)
T(RN,  0x1.e922b55fb3728p+621,    0x1.ff99a32cf3b95p-1,  -0x1.ae0c48p-3, INEXACT)
T(RN,  0x1.8525a57312fc6p+621,   -0x1.b0f06978541fcp-1,  -0x1.4c1802p-5, INEXACT)
T(RN,  0x1.ea04352f2a358p+621,   -0x1.7ce21e6c07518p-3,  -0x1.41f61ap-3, INEXACT)
T(RN,  0x1.5c3ef9ad0a299p+621,   -0x1.06aa551eff9b6p-1,   0x1.9384eep-3, INEXACT)
T(RN,  0x1.342744cca140ep+621,    0x1.ba17cca8681c4p-1,  -0x1.477fe4p-4, INEXACT)
T(RN,  0x1.944598f3fb5c8p+622,    0x1.7dfb3100f4d0ep-3,  -0x1.360af2p-4, INEXACT)
T(RN,  0x1.1049508d4784ep+622,   -0x1.701a0bc1e3d8cp-1,    0x1.80d82p-2, INEXACT)
T(RN,  0x1.6c2b1d82beabdp+622,   -0x1.f12872d56e263p-1,   0x1.8e0266p-5, INEXACT)
T(RN,  0x1.ba221bdb5e479p+622,   -0x1.fea63eaf9b07cp-2,   0x1.0c5136p-2, INEXACT)
T(RN,  0x1.2d6a82650cd19p+622,    0x1.9d7e4cb20fa35p-3,   0x1.9bc944p-2, INEXACT)
T(RN,  0x1.2e634dfee177ep+622,    0x1.fecfa6d18072ap-1,  -0x1.7125a4p-2, INEXACT)
T(RN,  0x1.ff259a115da2ep+622,   -0x1.2aa4906f398b1p-1,    0x1.30064p-2, INEXACT)
T(RN,  0x1.dc7bb4ec4484ap+622,   -0x1.fff1274e2706cp-1,    0x1.e4ab8p-2, INEXACT)
T(RN,  0x1.b8a3d352b6da8p+622,   -0x1.d9303d7bc30e6p-1,  -0x1.e43a76p-2, INEXACT)
T(RN,  0x1.1f52100cc6e1ep+622,    0x1.a5c7c3c9e3569p-3,  -0x1.276b44p-5, INEXACT)
T(RN,  0x1.9eca561a61d14p+623,    0x1.c3b9de2f94a6ep-4,   0x1.01a096p-2, INEXACT)
T(RN,  0x1.bf2b65d5a09a2p+623,   -0x1.a8894068266b4p-1,  -0x1.f6c6c2p-2, INEXACT)
T(RN,  0x1.e0bbd91d93037p+623,    0x1.41902282f8484p-5,   -0x1.f6e27p-2, INEXACT)
T(RN,   0x1.d3e8d1809c34p+623,   -0x1.de187035441d8p-1,   0x1.5cd8bep-3, INEXACT)
T(RN,  0x1.bc614331ef5eep+623,   -0x1.755bc61449f91p-2,   0x1.eb98a2p-2, INEXACT)
T(RN,  0x1.b40cccbd301c4p+623,   -0x1.38cc93d60aa74p-1,   0x1.7c2842p-2, INEXACT)
T(RN,  0x1.bae1ac6ff18bcp+623,    -0x1.712c8e5d7933p-4,   0x1.9bb564p-4, INEXACT)
T(RN,  0x1.503dc40da0815p+623,   -0x1.64244dd3e7686p-1,   0x1.0fc316p-4, INEXACT)
T(RN,  0x1.ee2435796e988p+623,    0x1.b6e273584b0d4p-1,   0x1.a7789ap-3, INEXACT)
T(RN,  0x1.39150dc7c7919p+623,   -0x1.1e7c6c9a0019fp-2,  -0x1.2d1626p-8, INEXACT)
T(RN,  0x1.39a1a38ce5d1ap+624,     0x1.b73f17f5871ep-1,  -0x1.b414bep-5, INEXACT)
T(RN,  0x1.48f2a1610b229p+624,    0x1.b447803e2271ap-2,   0x1.1deb3ep-8, INEXACT)
T(RN,   0x1.035b5ab4c46dp+624,   -0x1.461ee100846afp-3,  -0x1.90f402p-3, INEXACT)
T(RN,  0x1.6c466d8c008adp+624,   -0x1.fbb93e8021393p-1,  -0x1.cf9fa8p-3, INEXACT)
T(RN,   0x1.bb9445d0221fp+624,    0x1.f061cb1de88f5p-1, -0x1.63c302p-10, INEXACT)
T(RN,  0x1.1fb5c5aef5b5cp+624,   -0x1.4ec0470647a92p-2,  -0x1.9410e6p-2, INEXACT)
T(RN,  0x1.3217f45cc9b7bp+624,    0x1.36f8ab4d93961p-1,  -0x1.b37e48p-2, INEXACT)
T(RN,  0x1.52efd36bb42f1p+624,    0x1.a71290a5527a3p-1,  -0x1.2845fap-3, INEXACT)
T(RN,   0x1.edf6a2d7402cp+624,   -0x1.afb25bdd29f2fp-3,  -0x1.b98034p-2, INEXACT)
T(RN,   0x1.889879023b36p+624,   -0x1.567c94e958279p-5,   0x1.4477f2p-2, INEXACT)
T(RN,  0x1.5b9886ba6501dp+625,    0x1.3433d9e8ed534p-1,     0x1.afe2p-4, INEXACT)
T(RN,  0x1.827fd4d379a32p+625,   -0x1.dc9a432de0a22p-3,  -0x1.af9a46p-2, INEXACT)
T(RN,  0x1.0e49fd87dbab1p+625,    0x1.0b43662635b66p-1,   0x1.6608cap-4, INEXACT)
T(RN,  0x1.44c898237a1aep+625,   -0x1.91a1d84dc5164p-1,  -0x1.2ff5a6p-2, INEXACT)
T(RN,  0x1.9391f9a148a9bp+625,    0x1.f415226d7c866p-1,  -0x1.87e824p-6, INEXACT)
T(RN,  0x1.fd98a015ba46ep+625,    0x1.6298f685266dep-1,  -0x1.7c037ap-4, INEXACT)
T(RN,  0x1.099d9ece0b957p+625,   -0x1.dcdf72a1f2747p-1,  -0x1.d1749ep-3, INEXACT)
T(RN,  0x1.66d2593d156c6p+625,    0x1.d2723be2eca26p-1,  -0x1.43ce32p-3, INEXACT)
T(RN,   0x1.a3ff0a3d0f4ep+625,    0x1.224771df52981p-2,  -0x1.a4fb7cp-4, INEXACT)
T(RN,  0x1.9549ff517bf6ep+625,   -0x1.caf505bf8b14dp-2,    0x1.df9edp-3, INEXACT)
T(RN,  0x1.db0af0b9cec21p+626,   -0x1.11897a38e21fbp-1,  -0x1.2bfdb6p-2, INEXACT)
T(RN,  0x1.222382365d6bep+626,   -0x1.91281e0f6baa2p-5,    0x1.d9fdep-3, INEXACT)
T(RN,  0x1.ab85b73ef5255p+626,   -0x1.9a624c540b0fdp-2,   0x1.5a812cp-2, INEXACT)
T(RN,  0x1.c5bd6ac1369c7p+626,    0x1.c936103126afdp-1,  -0x1.ff7912p-4, INEXACT)
T(RN,   0x1.502fc298ec07p+626,    0x1.4004fc25dbfdcp-1,   0x1.10c8ccp-5, INEXACT)
T(RN,  0x1.5680f0b8b3b8fp+626,    0x1.25d8298ceeaa6p-4,  -0x1.d60712p-2, INEXACT)
T(RN,  0x1.246017afcad8cp+626,   -0x1.37f3bb67d6719p-1,  -0x1.8e9e58p-3, INEXACT)
T(RN,  0x1.8971b4468c70cp+626,   -0x1.8c8673da44527p-1,  -0x1.c81e7ep-4, INEXACT)
T(RN,  0x1.13cf5a74aad22p+626,    0x1.94a43d4f58744p-1,   0x1.fcc632p-3, INEXACT)
T(RN,  0x1.cb413401bb553p+626,    0x1.ef8ddf937a025p-1,   0x1.45f9bap-2, INEXACT)
T(RN,   0x1.6f224a2c9c8fp+627,   -0x1.e9e35fa8be3cdp-1,   0x1.6e9ddap-2, INEXACT)
T(RN,  0x1.744502c93f474p+627,   -0x1.0bc8df90d842dp-2,  -0x1.f6b4b2p-8, INEXACT)
T(RN,  0x1.ad935a19a53c8p+627,    0x1.fbdddf51394d5p-5,  -0x1.39e332p-3, INEXACT)
T(RN,  0x1.98e814f8d14c6p+627,   -0x1.bcef59631b7f4p-1,  -0x1.eed48ap-2, INEXACT)
T(RN,  0x1.651b0814f69bep+627,    0x1.f7769f2124876p-1,  -0x1.2c3d8ap-2, INEXACT)
T(RN,  0x1.f4d90b91fe8cfp+627,    0x1.fcea4366b5631p-1,    0x1.c22f2p-5, INEXACT)
T(RN,  0x1.96b5abdb22db4p+627,    0x1.903da0e8886c7p-1,   0x1.2f18d2p-2, INEXACT)
T(RN,  0x1.2336f630cee23p+627,   -0x1.09467679995f6p-2,  -0x1.5aa4bep-4, INEXACT)
T(RN,  0x1.52c636f307e99p+627,    0x1.fd20ed7c09bebp-1,   0x1.559f2cp-3, INEXACT)
T(RN,  0x1.41a6a26420107p+627,    0x1.adafd37f58545p-1,  -0x1.59057cp-5, INEXACT)
T(RN,  0x1.dffbec93088a4p+628,    -0x1.235ef4ec57ccp-1,   -0x1.16e51p-5, INEXACT)
T(RN,   0x1.99801e9f5033p+628,    0x1.50e87b20b15edp-1,  -0x1.34b992p-2, INEXACT)
T(RN,  0x1.6472874563505p+628,    0x1.d94b6abd30775p-4,   0x1.6a385ap-4, INEXACT)
T(RN,  0x1.bc557802633a8p+628,   -0x1.ec611fa7e55fbp-1,   0x1.6968a8p-2, INEXACT)
T(RN,  0x1.ada27e5797f48p+628,    0x1.6f085255aaa5dp-7,    0x1.de031p-6, INEXACT)
T(RN,  0x1.7b295e681ab6ap+628,   -0x1.a5e5f7b8be96dp-1,  -0x1.48b486p-3, INEXACT)
T(RN,  0x1.3bad25bb7b033p+628,   -0x1.2b47f0552492ap-2,  -0x1.3e0932p-3, INEXACT)
T(RN,  0x1.90630de57e3eep+628,   -0x1.88ea041fa3717p-2,   0x1.9f719ap-2, INEXACT)
T(RN,  0x1.f6f75305c4bc6p+628,   -0x1.f2687d863d13fp-1,   -0x1.0dde7p-2, INEXACT)
T(RN,  0x1.aeb37ef18f5bcp+628,    0x1.900a0f0c29251p-3,  -0x1.cf72fcp-2, INEXACT)
T(RN,  0x1.8179e0956d82ep+629,    0x1.de4491d0f783fp-2,  -0x1.af4d1ap-4, INEXACT)
T(RN,   0x1.dd685740adaep+629,   -0x1.bf163fae2e1adp-2,   0x1.153a6cp-3, INEXACT)
T(RN,  0x1.6ae61d9ebfa2ap+629,   -0x1.dde4cf38323d5p-3,   0x1.775f58p-2, INEXACT)
T(RN,  0x1.5d824aa9f0941p+629,    0x1.a442db1b28343p-3,   -0x1.8ed02p-2, INEXACT)
T(RN,  0x1.22454ffcb8a53p+629,   -0x1.1d4a307a606cbp-1,   0x1.9e452ep-2, INEXACT)
T(RN,  0x1.57376031ce903p+629,    0x1.a9c91e4692614p-1,   0x1.9e1188p-2, INEXACT)
T(RN,  0x1.efb5170d37b72p+629,   -0x1.75c8e55f7664bp-2,  -0x1.639d4p-10, INEXACT)
T(RN,  0x1.0c634eefaf2a8p+629,   -0x1.ff3742cf519b6p-1,   0x1.3090b8p-7, INEXACT)
T(RN,  0x1.6f7c72b60fc44p+629,    0x1.941cb9d1abbc8p-1,   0x1.e46536p-3, INEXACT)
T(RN,  0x1.94629e7a0be64p+629,    0x1.fc81269fef738p-1,  -0x1.71c7c6p-4, INEXACT)
T(RN,  0x1.81ed8f6637924p+630,    0x1.5fb752b4bea2ap-1,    0x1.29897p-2, INEXACT)
T(RN,   0x1.899342b9aedbp+630,    0x1.f7d8df333259bp-1,  -0x1.40bd42p-2, INEXACT)
T(RN,  0x1.af38581791906p+630,    0x1.dcbf3d16c019ep-1,  -0x1.8b4f22p-3, INEXACT)
T(RN,  0x1.94c3f74cc33acp+630,    0x1.7a80f2ea5069cp-2,  -0x1.bd5086p-2, INEXACT)
T(RN,  0x1.7a14ba60fff7fp+630,   -0x1.574d199092813p-2,  -0x1.3d8b3ep-2, INEXACT)
T(RN,  0x1.467316c99a17fp+630,   -0x1.53b875879e718p-3,    0x1.a7a5bp-6, INEXACT)
T(RN,  0x1.f8bab966303aep+630,    -0x1.7c5937ed0967p-2,   0x1.79e65ap-2, INEXACT)
T(RN,  0x1.7740509abc7a1p+630,    0x1.df94975b2860fp-2,   0x1.dbf12ap-3, INEXACT)
T(RN,  0x1.76de2becf69bcp+630,   -0x1.c32acefeb8eaap-1,   -0x1.a9d28p-2, INEXACT)
T(RN,  0x1.4a6f665ab326fp+630,    0x1.c35d0280bde6ep-1,   -0x1.f1161p-4, INEXACT)
T(RN,  0x1.ae0471518c056p+631,   -0x1.3f6407cd80a86p-2,  -0x1.7cfcf2p-3, INEXACT)
T(RN,    0x1.9ad90f675b4p+631,    0x1.fa5dba5e9ea93p-1,  -0x1.b2b374p-2, INEXACT)
T(RN,  0x1.de7689462b4efp+631,    0x1.7237742fc1a7cp-1,   0x1.a309fcp-5, INEXACT)
T(RN,  0x1.b8e2ef6bf1037p+631,    0x1.b398068741469p-1,  -0x1.28bb2cp-7, INEXACT)
T(RN,  0x1.4f5375db104dep+631,    0x1.054520e225068p-2,   0x1.ffd5f6p-4, INEXACT)
T(RN,  0x1.d4ce9ff1b3899p+631,    0x1.fc5847b17f6ecp-1,  -0x1.1673fcp-2, INEXACT)
T(RN,  0x1.ae4c273a2e19cp+631,   -0x1.6b4dc20af5927p-1,   -0x1.8b421p-7, INEXACT)
T(RN,  0x1.ff9aea17da194p+631,    0x1.fff446e08c7c1p-1,  -0x1.19fa98p-2, INEXACT)
T(RN,   0x1.f3a56cb8d13bp+631,    0x1.fcb3a27c8d03ap-1,    0x1.0468ap-2, INEXACT)
T(RN,  0x1.af3cd25d4803ap+631,   -0x1.ebd6822941d08p-1,  -0x1.4c33e2p-3, INEXACT)
T(RN,  0x1.bac6a8b356c58p+632,    0x1.31154ae943c2ap-2,   0x1.b54bc6p-3, INEXACT)
T(RN,  0x1.625cd68727e01p+632,   0x1.6eea948d8978fp-10,  -0x1.7b7f0cp-2, INEXACT)
T(RN,  0x1.d84c82c6a6518p+632,   -0x1.91c3d5f003f3ep-1,  -0x1.f7bedcp-3, INEXACT)
T(RN,  0x1.f60e9ced4d39cp+632,    0x1.86c3f4eea17d4p-1,   0x1.49017cp-2, INEXACT)
T(RN,  0x1.fe06c2b4d23f3p+632,   -0x1.571432ab56492p-2,   0x1.cbe636p-4, INEXACT)
T(RN,  0x1.497b027165a6cp+632,   -0x1.f2ff6ceadd7ffp-1,    0x1.16817p-2, INEXACT)
T(RN,  0x1.fe759bb7e9d32p+632,   -0x1.6bc9c49e25b6ap-1,  -0x1.3d12cep-3, INEXACT)
T(RN,  0x1.b81ec537076d6p+632,   -0x1.ed7d2a1267973p-2,    -0x1.3e14p-2, INEXACT)
T(RN,  0x1.fe67d17cc9209p+632,    0x1.ed953ab8ab1dfp-1,   0x1.8bbba4p-2, INEXACT)
T(RN,  0x1.2ea5258b6c3e4p+632,   -0x1.c539243ec4a78p-1,   0x1.004208p-2, INEXACT)
T(RN,  0x1.e292ca2a867fbp+633,   -0x1.335c7b248acbdp-1,   0x1.e9e64ap-2, INEXACT)
T(RN,  0x1.9fa30d3c7f034p+633,    0x1.9427656591272p-4,  -0x1.9903f2p-2, INEXACT)
T(RN,  0x1.557f5809b6fbbp+633,    0x1.f63a834820eb2p-5,   0x1.61245ep-4, INEXACT)
T(RN,  0x1.11abf3d66a126p+633,    0x1.0c1f630d5e66fp-1,   0x1.2414acp-3, INEXACT)
T(RN,  0x1.62f7087d6be0ap+633,    0x1.70c2ae09bd1b4p-1,   0x1.c3d5bep-2, INEXACT)
T(RN,  0x1.6553c9a58c097p+633,   -0x1.345711f8a1dc5p-3,  -0x1.667d5ep-2, INEXACT)
T(RN,  0x1.83ad75cff1732p+633,    0x1.762e63c57e981p-1,  -0x1.7445d8p-3, INEXACT)
T(RN,  0x1.6c4ebcc2ae3dcp+633,    0x1.0ea0a8ec55f06p-1,   0x1.ccff84p-2, INEXACT)
T(RN,  0x1.dd3349c880631p+633,     0x1.f80eb279418dp-1,   0x1.30728ep-2, INEXACT)
T(RN,  0x1.cf419c56d1eb5p+633,    0x1.f852408058282p-1,  -0x1.74f1e4p-2, INEXACT)
T(RN,  0x1.316d27eafe042p+634,    0x1.b41cc9c50a191p-1,  -0x1.542206p-5, INEXACT)
T(RN,  0x1.83ad7e1d94328p+634,    0x1.6bd59e8d8843fp-1,   -0x1.6c5d8p-3, INEXACT)
T(RN,  0x1.6e6fddba7362dp+634,    0x1.db2597ecedfcbp-1,    -0x1.9e8ep-2, INEXACT)
T(RN,  0x1.b052c04fe97eap+634,   -0x1.da18b1011b0c2p-1,   -0x1.094b3p-3, INEXACT)
T(RN,  0x1.04a7f8193d014p+634,    0x1.fffc3a99e1fcfp-1,    0x1.01fddp-4, INEXACT)
T(RN,   0x1.bcf2119ba524p+634,   -0x1.a51eee562ddd1p-2,   0x1.37e02cp-4, INEXACT)
T(RN,  0x1.d88bc3024aa8ep+634,   -0x1.f6dd399841a24p-1,  -0x1.646efep-2, INEXACT)
T(RN,  0x1.2f5f8cbdf7b0fp+634,   -0x1.881e0840f7cf4p-2,    0x1.5de9cp-3, INEXACT)
T(RN,  0x1.b27aee4a7eee2p+634,    0x1.2a5d4f1c11dccp-1,  -0x1.acdac6p-2, INEXACT)
T(RN,  0x1.a6b9dcf2b8777p+634,    0x1.3fe4d1c31099dp-1,   0x1.86bf02p-4, INEXACT)
T(RN,  0x1.d4838cf8d7e26p+635,   -0x1.3758a60027525p-1,  -0x1.10cb4ap-4, INEXACT)
T(RN,  0x1.6cac3dbc8ef4cp+635,   -0x1.c293556a8edc2p-3,   0x1.f5ecb8p-2, INEXACT)
T(RN,  0x1.d8ff5d37fc23cp+635,   -0x1.61c1ca7227d7ep-1,   0x1.ac4b92p-3, INEXACT)
T(RN,  0x1.d6366b32edc97p+635,    0x1.58fed8065214dp-2,  -0x1.7e6d3ap-2, INEXACT)
T(RN,  0x1.f7a65da9e995cp+635,    0x1.92fabb4c4acfep-1,   0x1.8f5ecep-3, INEXACT)
T(RN,  0x1.94906a53b7bbdp+635,   -0x1.fce5974190f58p-1,     0x1.3ed2p-3, INEXACT)
T(RN,  0x1.41168e363ebdcp+635,    0x1.e1cee4ddfdc01p-1,  -0x1.4f51a4p-2, INEXACT)
T(RN,  0x1.eb3fa44697351p+635,   -0x1.f5106da9ffb9ap-3,   0x1.9629cep-3, INEXACT)
T(RN,  0x1.44c6ef241f2a4p+635,   -0x1.1f8b9df40f9ebp-1,  -0x1.820becp-5, INEXACT)
T(RN,  0x1.2693e4f5d95aap+635,   -0x1.7f07eea61d313p-1,   0x1.e88d4cp-3, INEXACT)
T(RN,  0x1.26b7977ef0547p+636,    0x1.a19b4ef161acdp-3,  -0x1.7051cap-2, INEXACT)
T(RN,  0x1.4ebaed262458ep+636,   -0x1.93ac4584109e2p-2,  -0x1.7362c8p-6, INEXACT)
T(RN,  0x1.b4e194a77d2a4p+636,    0x1.455606495921cp-1,   0x1.6e1232p-3, INEXACT)
T(RN,  0x1.4edc2ac8d25efp+636,   -0x1.f3ac1e6627cbbp-1,   0x1.d85822p-5, INEXACT)
T(RN,  0x1.3b9c275a553c3p+636,    -0x1.d51a63483611p-1,  -0x1.cf94f2p-2, INEXACT)
T(RN,  0x1.34898789158dcp+636,    -0x1.ff8a316805efp-1,   -0x1.bd35fp-2, INEXACT)
T(RN,  0x1.c869b4641e62ep+636,     0x1.bb2a98ea0251p-1,   0x1.647338p-2, INEXACT)
T(RN,  0x1.d4f33784be397p+636,    0x1.8afe551ec3037p-1,   0x1.947d8ap-2, INEXACT)
T(RN,  0x1.1117a7d9e7d7ap+636,    0x1.5cbef4a76903fp-1,    0x1.1e73ap-3, INEXACT)
T(RN,  0x1.5943a6f1c424bp+636,    0x1.2324b62051136p-1,  -0x1.3f71d2p-2, INEXACT)
T(RN,  0x1.6999e279f7a4ep+637,    -0x1.48039b6accd2p-1,  -0x1.aa5f96p-2, INEXACT)
T(RN,  0x1.2608e9fcb5878p+637,   -0x1.53a3845e3d24dp-1,   0x1.3f8e34p-3, INEXACT)
T(RN,  0x1.80c05f50cbc61p+637,   -0x1.7d88741330281p-1,   0x1.b451f4p-2, INEXACT)
T(RN,   0x1.4882d444a8fbp+637,    0x1.fcc49d6cf8225p-1,   -0x1.3e86fp-2, INEXACT)
T(RN,  0x1.5612b4e6b6c16p+637,    0x1.fd00f1433d401p-1,  -0x1.fbed36p-2, INEXACT)
T(RN,  0x1.de011d1aeaebdp+637,    0x1.62e82c58a7a68p-4,   0x1.d5285cp-2, INEXACT)
T(RN,  0x1.9a8185e477e3ep+637,    0x1.dc39d95dd6891p-2,    0x1.9801ep-2, INEXACT)
T(RN,  0x1.6a7a8ffca83dcp+637,    0x1.1e86846fd60e2p-2,   0x1.839ef2p-3, INEXACT)
T(RN,  0x1.c72855376121ep+637,   -0x1.fb7dd9a5ab1cep-1,    0x1.94e1cp-4, INEXACT)
T(RN,  0x1.668b002c60a34p+637,   -0x1.41a291694bfeap-1,   0x1.c9c10ap-2, INEXACT)
T(RN,  0x1.570c93a8792f4p+638,    0x1.f99730fa5e372p-1,  -0x1.73d512p-2, INEXACT)
T(RN,  0x1.f55f46327ee95p+638,    0x1.838f4d8227f11p-3,  -0x1.9ff02ep-2, INEXACT)
T(RN,  0x1.04b1ae1c2d1e4p+638,   -0x1.ff876e4f8e8d5p-1,  -0x1.e3fa7cp-2, INEXACT)
T(RN,  0x1.3aa03c4993356p+638,    0x1.207b47c9ad6bbp-2,   0x1.0a2afap-5, INEXACT)
T(RN,  0x1.96aa0d69a038ep+638,   -0x1.a20e107e06d8bp-2,   0x1.a4c91cp-3, INEXACT)
T(RN,   0x1.2846182d6fd5p+638,   -0x1.e47ce72dd6671p-2,   0x1.7dbbdap-2, INEXACT)
T(RN,  0x1.85d686709570ap+638,    0x1.1b70c081b9f56p-1,  -0x1.69c1f4p-2, INEXACT)
T(RN,  0x1.488be03b0ee12p+638,    0x1.0762d09eff47fp-1,   0x1.92422ep-2, INEXACT)
T(RN,  0x1.a81987b53854ap+638,   -0x1.1292836a8ab1ap-1,   0x1.5a4502p-2, INEXACT)
T(RN,  0x1.084528d09d7ccp+638,   -0x1.8688b9e3ba239p-2,  -0x1.3d149ep-2, INEXACT)
T(RN,  0x1.0c4be342b75fbp+639,   -0x1.c6658d68f6b19p-2,  -0x1.afff7ap-3, INEXACT)
T(RN,  0x1.6d9aea5e0e42cp+639,    0x1.b9f111676d519p-1,   0x1.afcf32p-3, INEXACT)
T(RN,  0x1.113f2d060ff23p+639,   -0x1.5beb6aea80b69p-1,   0x1.f1a7f6p-2, INEXACT)
T(RN,  0x1.7c4c06ebc7e62p+639,   -0x1.a017df1c207bcp-1,   0x1.7b4604p-9, INEXACT)
T(RN,  0x1.c95172eb72454p+639,   -0x1.54aec8004a293p-2,  -0x1.44b664p-3, INEXACT)
T(RN,  0x1.46229a0789eb6p+639,    0x1.726f3fc38032ap-1,  -0x1.0f1dc2p-2, INEXACT)
T(RN,  0x1.53ab7cb81e2e5p+639,    0x1.c62b0c94305ecp-4,  -0x1.2fdacap-6, INEXACT)
T(RN,  0x1.1084b1f263c27p+639,   -0x1.9074ee309aba9p-1,   0x1.1e45d8p-4, INEXACT)
T(RN,   0x1.a74ac19f7438p+639,   -0x1.378502ef8dc24p-1,   0x1.5819c8p-2, INEXACT)
T(RN,  0x1.feb80d7bb0a25p+639,   -0x1.6140a74a260abp-1,   0x1.58e056p-2, INEXACT)
T(RN,  0x1.c31895969533ap+640,   -0x1.fdd8c199b327cp-1,   0x1.ad958cp-4, INEXACT)
T(RN,  0x1.b4e70c9a12a3cp+640,    0x1.a9019a7ced909p-1,  -0x1.74517cp-2, INEXACT)
T(RN,  0x1.b5ed3c957fd74p+640,   -0x1.fda2ca2d7d1ddp-1,  -0x1.b3f23cp-2, INEXACT)
T(RN,  0x1.f615b67390faep+640,    0x1.d7e2a9948919bp-1,   0x1.1e26b4p-2, INEXACT)
T(RN,  0x1.d039f5b1a9a4ap+640,   -0x1.fd598305ed1f1p-1,  -0x1.dae424p-2, INEXACT)
T(RN,  0x1.e4e2eeae4ae08p+640,    0x1.91c131032f79bp-2,   0x1.b39436p-4, INEXACT)
T(RN,  0x1.81db1f154c79ep+640,   -0x1.7703c52b4e012p-2,    0x1.5e8bfp-4, INEXACT)
T(RN,  0x1.cecf4d4099aa5p+640,   -0x1.a7bfe1cea574ap-1,   0x1.7216cep-4, INEXACT)
T(RN,  0x1.df760e2c7c674p+640,    0x1.ff2687d35ae3bp-1,   0x1.bcaa2cp-4, INEXACT)
T(RN,  0x1.433637c87be38p+640,   -0x1.f49286dd6c313p-3,   0x1.093e28p-2, INEXACT)
T(RN,  0x1.5e19700a732bcp+641,   -0x1.b686c72e4a476p-1,   0x1.c4d0c6p-2, INEXACT)
T(RN,  0x1.e706e5dc3416cp+641,   -0x1.8abfe44b13bd9p-4,  -0x1.e677eep-3, INEXACT)
T(RN,  0x1.0f434cafead82p+641,   -0x1.cbb509628d875p-1,   -0x1.ad6bbp-2, INEXACT)
T(RN,  0x1.37530d73a6e93p+641,    0x1.955e3cc24027ep-1,   0x1.9da8f4p-6, INEXACT)
T(RN,  0x1.cce782e8dfe1cp+641,   -0x1.d52bf10ec499ap-1,  -0x1.c37042p-2, INEXACT)
T(RN,  0x1.c1652bea9d603p+641,    0x1.cf2043f8ee04fp-1,   0x1.de81aap-2, INEXACT)
T(RN,  0x1.062a0b0552326p+641,   -0x1.f8882dcb089b2p-1,  -0x1.b796fcp-5, INEXACT)
T(RN,  0x1.c3f20448a4d8ap+641,    0x1.30281ad62ff17p-1,  -0x1.a2ae9ap-2, INEXACT)
T(RN,  0x1.7a4e4a448836bp+641,    0x1.925f5498637a5p-1,  -0x1.c906a8p-8, INEXACT)
T(RN,  0x1.0a3128cb1090bp+641,   -0x1.7449e00c8b2bfp-1,  -0x1.49e82ep-2, INEXACT)
T(RN,  0x1.3ec54e50e8f56p+642,   -0x1.bc4470e32b403p-2,   0x1.d30b4ap-2, INEXACT)
T(RN,  0x1.c05aefdca417cp+642,   -0x1.f757897aecd64p-1,   0x1.20774cp-3, INEXACT)
T(RN,   0x1.bc368649ea74p+642,    0x1.68075d2b463e3p-1,   -0x1.d2d68p-3, INEXACT)
T(RN,  0x1.bdb9238bee069p+642,   -0x1.0e8d14e145c4fp-2,   0x1.a802f2p-2, INEXACT)
T(RN,  0x1.e83325ce28d54p+642,    0x1.1a345a823f047p-3,   0x1.3ef644p-4, INEXACT)
T(RN,  0x1.12be12c7d1a1cp+642,     0x1.b365ef86020fp-2,  -0x1.4c342ep-3, INEXACT)
T(RN,  0x1.b2b6892f156c4p+642,    0x1.a19dc582e7602p-1,  -0x1.42b76ep-3, INEXACT)
T(RN,  0x1.f0986142924d8p+642,    0x1.8d7b1f4d68ad5p-1,  -0x1.5a1358p-3, INEXACT)
T(RN,  0x1.590b8a79f08c4p+642,   -0x1.8a9baab20bc1bp-1,  -0x1.a9e2d4p-5, INEXACT)
T(RN,  0x1.0527af32e5048p+642,   -0x1.f8e17ca11deb1p-1,   0x1.5e58e8p-2, INEXACT)
T(RN,  0x1.7f3294c44ec65p+643,   -0x1.ee29582474afap-1,    0x1.3adb3p-2, INEXACT)
T(RN,  0x1.401cadcc8ee8ep+643,   -0x1.075e807d8145fp-2,   0x1.ce5ab4p-2, INEXACT)
T(RN,  0x1.d374c35c00befp+643,   -0x1.b7f7325217da8p-1,   0x1.469bd6p-9, INEXACT)
T(RN,  0x1.f7c3dfe081c28p+643,     0x1.080146828babp-1,   0x1.6290ccp-2, INEXACT)
T(RN,  0x1.263a0d5ed90bdp+643,    0x1.93f107a5d2743p-1,   0x1.689b94p-3, INEXACT)
T(RN,  0x1.1b5c592398dfdp+643,    0x1.da979ac8fb03dp-6,   0x1.2b5606p-5, INEXACT)
T(RN,  0x1.9aa74b9a415a4p+643,   -0x1.28b645422ce4ep-1,   -0x1.3c614p-2, INEXACT)
T(RN,  0x1.1ac1fbb73cfa3p+643,   -0x1.6514077fa30f5p-2,  -0x1.b0c542p-6, INEXACT)
T(RN,  0x1.0285e939e7b7ap+643,   -0x1.91fc6cd20d654p-1,  -0x1.740522p-2, INEXACT)
T(RN,    0x1.accf9d6bed9p+643,    0x1.fff433fffe644p-1,  -0x1.6a99dep-8, INEXACT)
T(RN,  0x1.641e7211b474cp+644,   -0x1.ffcfe88f779dfp-1,   0x1.d4c8fap-3, INEXACT)
T(RN,  0x1.2b2db5520fd2ep+644,    0x1.fe9352f7f4557p-1,  -0x1.92bf36p-6, INEXACT)
T(RN,  0x1.42350e569dd99p+644,    0x1.e0e649b168afap-1,   0x1.ebbd34p-2, INEXACT)
T(RN,  0x1.67ec61db9f06fp+644,    0x1.330df049d399ap-2,   0x1.0a1482p-2, INEXACT)
T(RN,  0x1.fb5365b7616a1p+644,    0x1.173d8a46a01f3p-3,   0x1.23a49cp-2, INEXACT)
T(RN,  0x1.f40e40dd81fd9p+644,   -0x1.dc3e29b539f9dp-2,    0x1.a92fcp-5, INEXACT)
T(RN,  0x1.92abb5595cc1ap+644,    -0x1.9a60c9d4d28ap-1,   0x1.c2d454p-2, INEXACT)
T(RN,  0x1.ed7550ef9dd26p+644,   -0x1.da7768b615531p-1,  -0x1.518c32p-6, INEXACT)
T(RN,  0x1.5cfdaceb53386p+644,    0x1.2a9134d371954p-1,   0x1.d70da2p-2, INEXACT)
T(RN,  0x1.1e373a533cc6cp+644,    0x1.055ad170afd7ap-1,   0x1.44349ap-2, INEXACT)
T(RN,  0x1.12dc52e21532ep+645,    0x1.ff808961d5b9bp-1,   -0x1.423e7p-3, INEXACT)
T(RN,  0x1.7512da437b248p+645,    0x1.0613ad21c657ep-2,  0x1.b8d9c6p-10, INEXACT)
T(RN,  0x1.79e415c74c93fp+645,   -0x1.fbd4c96fc8761p-1,  -0x1.7ab2c4p-4, INEXACT)
T(RN,  0x1.cc5ab6302ac7ep+645,    0x1.b6ba3304e0b2ep-2,   0x1.c0f998p-2, INEXACT)
T(RN,    0x1.a3fc7be1c44p+645,   -0x1.60d515706275cp-3,   0x1.a4143ap-3, INEXACT)
T(RN,  0x1.ed6eb91ba978fp+645,   -0x1.bb0c8fff869a1p-1,  -0x1.5d5ec4p-5, INEXACT)
T(RN,  0x1.ac0d5b6999212p+645,   -0x1.e9837585c1cffp-1,   0x1.02f312p-2, INEXACT)
T(RN,  0x1.9071592af5b78p+645,    0x1.b6b3edf646253p-1,    0x1.0b815p-2, INEXACT)
T(RN,  0x1.a193fb1196772p+645,   -0x1.fa0efd0a61936p-1,   0x1.18cd6ap-3, INEXACT)
T(RN,  0x1.cb9fab0ed06dep+645,    0x1.3186aeacad57ap-2,  -0x1.67b03ep-2, INEXACT)
T(RN,   0x1.aa09c47014c9p+646,   -0x1.97e9243bada0bp-4,    0x1.642afp-2, INEXACT)
T(RN,  0x1.50fa4abe5418cp+646,     0x1.6cc4c80ccdf3p-1,  -0x1.c9f658p-4, INEXACT)
T(RN,  0x1.497927b03985ep+646,    0x1.9bd8678338511p-1,  -0x1.0949f8p-2, INEXACT)
T(RN,  0x1.84b4db7fc86b8p+646,   -0x1.8172be898a099p-1,  -0x1.1d3a6ep-2, INEXACT)
T(RN,  0x1.fbe40e2cc1716p+646,   -0x1.7a82d3bad7d21p-2,    0x1.09d33p-2, INEXACT)
T(RN,   0x1.0edca592ca33p+646,    -0x1.317ca75372b7p-4,  -0x1.652e6ap-7, INEXACT)
T(RN,  0x1.e2be75fe1027ap+646,   -0x1.cb7b61ec8f40fp-1,  -0x1.b8697ap-2, INEXACT)
T(RN,  0x1.d33c5ec5571eep+646,    0x1.d898dc8d5dce1p-1,    0x1.54b5cp-2, INEXACT)
T(RN,   0x1.80d2cc23de15p+646,    0x1.b43383b549648p-1,  -0x1.124018p-4, INEXACT)
T(RN,   0x1.02618e9a3082p+646,   -0x1.f4d35ddffd562p-1,  -0x1.8152f2p-2, INEXACT)
T(RN,   0x1.59b0e2530124p+647,   -0x1.e254ba4e7784dp-4,   0x1.8ea51ep-2, INEXACT)
T(RN,  0x1.6e29b82a411bcp+647,    0x1.ee615fb5c4985p-1,  -0x1.d9552ap-3, INEXACT)
T(RN,  0x1.b23c83b37b34fp+647,    0x1.901af3b2782d8p-1,    0x1.d7b47p-2, INEXACT)
T(RN,   0x1.a43e52e854e7p+647,   -0x1.6ae30f84e7894p-1,   -0x1.aceb4p-3, INEXACT)
T(RN,  0x1.d0b98d4cb35d8p+647,   -0x1.0c68db5417b47p-4,   0x1.3a065cp-6, INEXACT)
T(RN,  0x1.9f0fc00ccf2cep+647,    0x1.780cf9e0cba54p-1,  -0x1.45d2f2p-4, INEXACT)
T(RN,  0x1.8d242f86cf14fp+647,    0x1.939f3406162a7p-1,  -0x1.6199d4p-5, INEXACT)
T(RN,  0x1.d9267738d7d69p+647,   -0x1.db86b230fe73fp-1,   0x1.07860cp-2, INEXACT)
T(RN,  0x1.ddc2e387c0b86p+647,   -0x1.e0687f1fbf7ecp-1,  -0x1.6290e8p-5, INEXACT)
T(RN,  0x1.a497ef97eabfbp+647,   -0x1.d834dbc4fb8dcp-1,   0x1.724c5cp-3, INEXACT)
T(RN,  0x1.ccf99ca99726cp+648,    0x1.21bc8258ce912p-3,  -0x1.11995ap-2, INEXACT)
T(RN,   0x1.65f60c293d79p+648,    0x1.f126796a2cdedp-1,  -0x1.6f274ap-2, INEXACT)
T(RN,  0x1.2241e6ed05d18p+648,   -0x1.ef521013b7d62p-1,   0x1.d6dfdcp-3, INEXACT)
T(RN,  0x1.77459ff319f2fp+648,   -0x1.dfacf36ca26eep-1,   0x1.87fb94p-5, INEXACT)
T(RN,   0x1.d38598e6f127p+648,    0x1.eb56ac58017a3p-1,   0x1.900324p-2, INEXACT)
T(RN,  0x1.492f998c4efacp+648,    0x1.6b897ff726ad5p-4,   0x1.7dd184p-2, INEXACT)
T(RN,  0x1.a6ccaa2390813p+648,   -0x1.22d22373cbc29p-2,   0x1.bf9734p-2, INEXACT)
T(RN,  0x1.a718f3aecc308p+648,   -0x1.ef819bde7cf8fp-2,  -0x1.d3f744p-2, INEXACT)
T(RN,  0x1.3869dba471f75p+648,    0x1.2281bac5e77b3p-1,  -0x1.3abec8p-3, INEXACT)
T(RN,  0x1.504ae36a40331p+648,   -0x1.009a1198d85ccp-1,   0x1.6c1176p-2, INEXACT)
T(RN,  0x1.4bd719d6f859bp+649,    0x1.b7885c4c5eb5ep-4,  -0x1.6db61ap-2, INEXACT)
T(RN,  0x1.f146240d192b3p+649,    0x1.882a9d45ac899p-1,  -0x1.2964aap-3, INEXACT)
T(RN,  0x1.eac91b2fd6b28p+649,   -0x1.ee05191891e1ap-1,  -0x1.5e2108p-4, INEXACT)
T(RN,  0x1.dd48a1daca848p+649,   -0x1.cc1e3a39f2df7p-1,  -0x1.54bd92p-3, INEXACT)
T(RN,  0x1.48ce14af863f1p+649,    0x1.f106ed2f90977p-1,   0x1.19d8acp-3, INEXACT)
T(RN,  0x1.a35a362c36b1cp+649,   -0x1.bca678fc27dcap-1,  -0x1.c9c0aap-2, INEXACT)
T(RN,  0x1.4e13c42d7b75fp+649,   -0x1.0187dc5993a56p-2,   0x1.587454p-2, INEXACT)
T(RN,   0x1.d48bdfcf5ce1p+649,   -0x1.52c6c435786b5p-4,  -0x1.7373f8p-7, INEXACT)
T(RN,  0x1.8f3934a49206bp+649,    0x1.fe95568ddee99p-1,  -0x1.cf8decp-3, INEXACT)
T(RN,  0x1.912bb82ddd19fp+649,   -0x1.a7c2577e8abb1p-2,  -0x1.9823a4p-3, INEXACT)
T(RN,  0x1.6f62af7565b34p+650,   -0x1.e7b361af8ad3cp-5,  -0x1.5ccc7cp-3, INEXACT)
T(RN,  0x1.f8b239eba0964p+650,    0x1.492111bd31f24p-1,  -0x1.08ac1ap-2, INEXACT)
T(RN,  0x1.494093fba10eep+650,   -0x1.5208b1a845412p-1,  -0x1.c28c74p-4, INEXACT)
T(RN,  0x1.01ae7197c648ap+650,   -0x1.48ca79248776fp-2,   0x1.4a00dep-3, INEXACT)
T(RN,  0x1.6876d13ae2aeep+650,   -0x1.ffe5be386301fp-1,  -0x1.920848p-2, INEXACT)
T(RN,  0x1.7d7d7a995039ap+650,   -0x1.fa277da6a00b3p-1,   0x1.92b4c2p-2, INEXACT)
T(RN,  0x1.226a0e0c131bcp+650,    0x1.44a2111b200d9p-1,   0x1.f641dap-3, INEXACT)
T(RN,  0x1.c3d65191b7364p+650,   -0x1.1d35b80c0bcc4p-4,  -0x1.5fbb12p-2, INEXACT)
T(RN,  0x1.5f8da8681f031p+650,     0x1.4e90d3046f43p-1,   0x1.75ad48p-2, INEXACT)
T(RN,  0x1.605d6d16b7cbfp+650,    0x1.743a042c654a4p-3,    0x1.88031p-2, INEXACT)
T(RN,   0x1.ab2a3184d39fp+651,   -0x1.f1a4f2e15d6fdp-2,  -0x1.6799acp-2, INEXACT)
T(RN,  0x1.4c12a80c1d4f4p+651,   -0x1.a629c30d41039p-1,  -0x1.7a04b4p-2, INEXACT)
T(RN,  0x1.37ef10af818a4p+651,   -0x1.faa2e037949d2p-1,   0x1.c3def4p-2, INEXACT)
T(RN,  0x1.d140f96bccc7ap+651,   -0x1.eabbee3794f48p-3,   0x1.43c3c8p-5, INEXACT)
T(RN,   0x1.5b6430c02af4p+651,   -0x1.0656a4f295094p-2,   0x1.accafep-6, INEXACT)
T(RN,  0x1.15f53c1110189p+651,   -0x1.08acdb2041ce6p-1,   0x1.6cbff2p-4, INEXACT)
T(RN,  0x1.d66f5d2f63678p+651,   -0x1.c1700a9bd5098p-1,   0x1.a1d7b8p-3, INEXACT)
T(RN,  0x1.92e5c23369916p+651,   -0x1.a9bdcfbd076a1p-4,  -0x1.810ffap-3, INEXACT)
T(RN,  0x1.d13f7f6a62152p+651,    0x1.eae5cde025345p-1,   0x1.82a2fcp-3, INEXACT)
T(RN,  0x1.fa680322f134fp+651,    0x1.fbc66e326adfbp-5,  -0x1.3655f8p-3, INEXACT)
T(RN,  0x1.93d7859c37ccep+652,   -0x1.c16e5ec335a59p-1,   0x1.7f5104p-3, INEXACT)
T(RN,  0x1.d44bc64740f98p+652,   -0x1.2d6e32120b4b8p-1,  -0x1.e93638p-2, INEXACT)
T(RN,  0x1.1e39542fa42b8p+652,    0x1.b0032cc2ce7bap-1,   0x1.bad5bcp-3, INEXACT)
T(RN,  0x1.9ccc27ea1d392p+652,   -0x1.c966dd5678a0bp-4,   0x1.c9f98ep-4, INEXACT)
T(RN,  0x1.e2e2067aa586cp+652,   -0x1.43f8a478cb18fp-2,   0x1.8505e2p-2, INEXACT)
T(RN,  0x1.f284515bb7ba1p+652,   -0x1.6d1fa7b1b7361p-2,   0x1.b5e91cp-2, INEXACT)
T(RN,  0x1.877264d6f852dp+652,   -0x1.bc5175bad8acep-1,   0x1.dedf92p-3, INEXACT)
T(RN,  0x1.ed4cfd0287b9cp+652,    0x1.f3fac222d200ep-3,    0x1.a1823p-3, INEXACT)
T(RN,  0x1.04ef70a89014cp+652,   -0x1.151981cab3258p-1,   0x1.8d476cp-4, INEXACT)
T(RN,  0x1.12037493aff28p+652,    0x1.1ddaa49f8b031p-3,  -0x1.3767c2p-5, INEXACT)
T(RN,  0x1.d4b31be0ba019p+653,     0x1.fadbc88fadfep-1,   0x1.b1ee5ap-2, INEXACT)
T(RN,  0x1.9f82169ab3905p+653,    0x1.a94b69e82df8bp-1,   0x1.d1100cp-3, INEXACT)
T(RN,   0x1.e0fa507207a8p+653,    0x1.07b671a1ba499p-1,   0x1.aa309ap-2, INEXACT)
T(RN,  0x1.d9a8c4cb6fc24p+653,   -0x1.e5a4cf0af4b76p-2,  -0x1.09f5c8p-2, INEXACT)
T(RN,  0x1.49f37f183bac5p+653,     0x1.f33e039433cap-1,   -0x1.ee056p-2, INEXACT)
T(RN,  0x1.e61161758e8e6p+653,   -0x1.ec7dd0a678bb9p-2,   0x1.ecaa32p-2, INEXACT)
T(RN,  0x1.15b871f7c6d89p+653,    0x1.558bf6596770cp-3,   0x1.ec1a42p-7, INEXACT)
T(RN,  0x1.3eceac1bb7d82p+653,   -0x1.086f4bd46306dp-4,   0x1.7e558ep-2, INEXACT)
T(RN,  0x1.27694d7d1a989p+653,    0x1.fc4bdddd96626p-1,   0x1.e94608p-2, INEXACT)
T(RN,  0x1.e3d77ba1f64cap+653,   -0x1.77e14e5ba3f23p-2,  -0x1.7101bep-2, INEXACT)
T(RN,  0x1.e826253e2f3cbp+654,    0x1.128786a474038p-1,   0x1.ed2ba2p-2, INEXACT)
T(RN,  0x1.bcf13c17031e7p+654,    0x1.863cbebad578dp-2,   0x1.664372p-2, INEXACT)
T(RN,  0x1.a1c9cc592ca77p+654,    0x1.eb83065bc09c5p-1,   0x1.9c491ap-3, INEXACT)
T(RN,   0x1.997b924664bfp+654,   -0x1.7673d5502a3f3p-3,  -0x1.13c37cp-2, INEXACT)
T(RN,  0x1.39cd2ae209541p+654,   -0x1.664091db83385p-2,   0x1.c859a4p-2, INEXACT)
T(RN,  0x1.73300c85c01bbp+654,    0x1.c793125213012p-3,  -0x1.72b096p-2, INEXACT)
T(RN,  0x1.a34250429bb82p+654,    0x1.f00a8bb3b215ap-1,   0x1.6c872cp-5, INEXACT)
T(RN,  0x1.2cd918d8255dap+654,    0x1.ed70360812958p-1,   0x1.ab8b2ap-2, INEXACT)
T(RN,  0x1.e20ff98dae432p+654,    0x1.f0ff9a658c4e6p-3,   0x1.a987c2p-3, INEXACT)
T(RN,  0x1.11e29640d37f1p+654,   -0x1.f65554662e9e2p-1,   0x1.069294p-2, INEXACT)
T(RN,  0x1.6675350f22877p+655,   -0x1.9387331112a1dp-1,   0x1.6d5232p-5, INEXACT)
T(RN,  0x1.bfff47380ab38p+655,    0x1.c6fed5c51d68dp-1,  -0x1.5c4866p-2, INEXACT)
T(RN,  0x1.399774314885ap+655,   -0x1.effbecd494411p-1,  -0x1.07b044p-4, INEXACT)
T(RN,  0x1.ac25c9e1367c8p+655,   -0x1.3d699f48f314bp-1,   0x1.9d2a6ap-2, INEXACT)
T(RN,  0x1.d4b127beaae5fp+655,    0x1.3caee799765f3p-1,  -0x1.05668ep-4, INEXACT)
T(RN,  0x1.1f3f2e8cd2ee5p+655,   -0x1.8428b7104f449p-1,  -0x1.0d274ep-8, INEXACT)
T(RN,  0x1.c6ff99b2d673ep+655,   -0x1.ffb9ca8487327p-1,  -0x1.cd2b5ap-3, INEXACT)
T(RN,  0x1.f3e080e9508cfp+655,   -0x1.a3c619d1b34dcp-1,  -0x1.243dd6p-2, INEXACT)
T(RN,  0x1.d68fbd4fc9262p+655,   -0x1.ffca54817fdf8p-1,  -0x1.a58882p-2, INEXACT)
T(RN,  0x1.e0c685f5aeffcp+655,   -0x1.b88d12c67d7f3p-1,  -0x1.947da8p-4, INEXACT)
T(RN,  0x1.90e42161dd9c5p+656,    0x1.405642bcd9a6dp-1,   0x1.93cf34p-3, INEXACT)
T(RN,  0x1.129b65bb41f49p+656,   -0x1.7e9aac5eff2fep-4,   0x1.3dad94p-3, INEXACT)
T(RN,   0x1.cdc2661e97e5p+656,   -0x1.e81f9079ebbb7p-1,    0x1.c93cdp-2, INEXACT)
T(RN,  0x1.e654d937d6f66p+656,   -0x1.e4e15725f1221p-1,   0x1.2926ccp-3, INEXACT)
T(RN,  0x1.63e2ca45aee2cp+656,    0x1.3c57eb337ed93p-6,  -0x1.2976a6p-2, INEXACT)
T(RN,   0x1.ddf4c83b691ep+656,    0x1.ea4b5978b2662p-1,   -0x1.b2c0fp-2, INEXACT)
T(RN,  0x1.70c7b8559d25bp+656,    0x1.91577c633b284p-1,  -0x1.d19f1ep-5, INEXACT)
T(RN,  0x1.8ce5015c5fd4cp+656,    0x1.fc47fb4266d3cp-2,  -0x1.a1ffc2p-4, INEXACT)
T(RN,  0x1.a482e9b60591ep+656,    -0x1.ed0b91af3358p-1,  -0x1.01da9cp-2, INEXACT)
T(RN,  0x1.688c461de931ap+656,    0x1.609ebd4636269p-5,  -0x1.d9d962p-3, INEXACT)
T(RN,  0x1.fe62845852eaap+657,    0x1.0f20792de40f9p-1,  -0x1.5af8e4p-2, INEXACT)
T(RN,  0x1.d2831b8bfc943p+657,   -0x1.fa3f79aa5f20cp-1,   0x1.ca3d5ep-3, INEXACT)
T(RN,  0x1.fbcb64fdb784ep+657,   -0x1.a2c1318bcce7ep-2,    0x1.5c79bp-3, INEXACT)
T(RN,  0x1.bb82bc2d1850ap+657,    0x1.c07cbc32d75dep-1,   -0x1.7bb22p-3, INEXACT)
T(RN,  0x1.a01a71d79e2bcp+657,   -0x1.95aaa2d847b5cp-1,  -0x1.68f1bcp-3, INEXACT)
T(RN,  0x1.f53e3a1ba471ep+657,    0x1.e3fd3da5209dbp-1,  -0x1.a63fd4p-3, INEXACT)
T(RN,  0x1.8aabee5788097p+657,   -0x1.78eb7c1ce9631p-2,  -0x1.e62ca2p-2, INEXACT)
T(RN,  0x1.ad0bdb535d4f8p+657,    0x1.dcc562f00a28bp-1,   0x1.981848p-2, INEXACT)
T(RN,  0x1.d7cb0666e0ee9p+657,    0x1.69584c2842374p-1,   0x1.2afb7cp-2, INEXACT)
T(RN,  0x1.bf8f9b9230bb1p+657,   -0x1.c917024689ff1p-1,   0x1.96aaa4p-2, INEXACT)
T(RN,  0x1.94e3bb4a02854p+658,   -0x1.7067421983df9p-1,  -0x1.34a5fep-2, INEXACT)
T(RN,  0x1.9feab671afbbfp+658,    0x1.7881d5f1650d3p-1,   0x1.917e32p-2, INEXACT)
T(RN,  0x1.b6ff59e2f9d2cp+658,   -0x1.a87d9c41262a5p-1,  -0x1.3a15e6p-3, INEXACT)
T(RN,  0x1.4574c07c02992p+658,    0x1.f37c98f90b2a4p-2,  -0x1.e16962p-4, INEXACT)
T(RN,  0x1.bc0cd86401e5cp+658,    0x1.813543d85874bp-1,  -0x1.15c85ep-2, INEXACT)
T(RN,  0x1.0cf10887fffd4p+658,    0x1.50f4174ee2288p-2,  -0x1.691b16p-3, INEXACT)
T(RN,  0x1.c9a46f27749ddp+658,   -0x1.e4264be29c8a1p-1,  -0x1.860402p-2, INEXACT)
T(RN,  0x1.8f3c30591102cp+658,   -0x1.39815acfe5851p-2,  -0x1.01a698p-3, INEXACT)
T(RN,  0x1.5511f9c401db2p+658,    0x1.64d49af97628bp-1,  -0x1.f5582cp-2, INEXACT)
T(RN,  0x1.0429589b50c49p+658,   -0x1.b1953ad2eb693p-1,  -0x1.5e1b7ep-5, INEXACT)
T(RN,  0x1.4271ba51395e8p+659,   -0x1.af0f72654a9fcp-2,   0x1.69d1bcp-2, INEXACT)
T(RN,   0x1.f7d3a2cf7e3fp+659,    0x1.d236f8c6ab191p-1,   0x1.74b264p-3, INEXACT)
T(RN,  0x1.312dcfc66633ep+659,    0x1.f82d7e1bc30a5p-1,   0x1.ce2636p-2, INEXACT)
T(RN,  0x1.44460a1db6021p+659,   -0x1.fd8c68df3aaafp-1,  -0x1.89ca44p-2, INEXACT)
T(RN,  0x1.16e54f50d3d52p+659,    0x1.97a24ef489283p-2,  -0x1.e0610cp-3, INEXACT)
T(RN,  0x1.6aa74d9c2ef0ep+659,    0x1.3215153bc7278p-1,    0x1.f6d12p-4, INEXACT)
T(RN,  0x1.410448ab7342ep+659,    0x1.fe3e46446043fp-1,  -0x1.a4fa94p-5, INEXACT)
T(RN,  0x1.3b7f1eac68236p+659,    0x1.cfddef233af3ep-1,    0x1.a870ap-2, INEXACT)
T(RN,  0x1.c20ae015a123ep+659,    -0x1.c2155a742f57p-1,  -0x1.ba33a6p-3, INEXACT)
T(RN,   0x1.86d91c30780cp+659,    0x1.26ca832838592p-7,   0x1.3a89eep-2, INEXACT)
T(RN,  0x1.9c266477c50cep+660,    0x1.29f6f16c108e4p-1,   0x1.847592p-2, INEXACT)
T(RN,  0x1.5e47e158dccd6p+660,    0x1.cc90a71e829d2p-3,  -0x1.0d32b6p-2, INEXACT)
T(RN,  0x1.d09e7804dd9f6p+660,   -0x1.2cad773291649p-2,   -0x1.6afe2p-2, INEXACT)
T(RN,  0x1.acaf06b9ecab2p+660,    0x1.7ae68f46b1a3cp-3,   0x1.614bbap-2, INEXACT)
T(RN,  0x1.083f1cee85726p+660,    0x1.2ec6b0650a29dp-2,   0x1.1a8ffap-2, INEXACT)
T(RN,  0x1.7f3f4577c946ep+660,    0x1.ef99f3d8dad43p-1,   0x1.baf06ep-3, INEXACT)
T(RN,  0x1.816334c80ad41p+660,   -0x1.d364f5fb4fe05p-2,   0x1.6d61b8p-2, INEXACT)
T(RN,  0x1.0cc6f9385d758p+660,     0x1.fd0ddf6bd2b9p-1,  -0x1.c70852p-4, INEXACT)
T(RN,  0x1.ffd5b5598c832p+660,    0x1.f981226596341p-2,  -0x1.840a62p-3, INEXACT)
T(RN,  0x1.084f5c760a9f6p+660,   -0x1.d410ab14f9109p-5,   0x1.0d8af4p-2, INEXACT)
T(RN,  0x1.aa270a15552f2p+661,    0x1.b8a3318eccf8ap-1,   0x1.e68e18p-7, INEXACT)
T(RN,  0x1.d310491672524p+661,    0x1.fdbcd5c1adb85p-1,  -0x1.cd62bep-2, INEXACT)
T(RN,  0x1.3213ba5e415fcp+661,    0x1.488460ce378a8p-2,   0x1.80ff96p-4, INEXACT)
T(RN,  0x1.3d6923291ebeep+661,    0x1.e54d594d72518p-1,   -0x1.390adp-2, INEXACT)
T(RN,  0x1.725e4f434a219p+661,   -0x1.29c05be95f2eap-4,   0x1.9aef2ep-3, INEXACT)
T(RN,  0x1.d7039d9c6777bp+661,   -0x1.11112cef1ecb4p-3,    0x1.67d29p-3, INEXACT)
T(RN,  0x1.99a22a1af6642p+661,     0x1.8829404d16ebp-1,   0x1.0444acp-2, INEXACT)
T(RN,  0x1.1ff779851190fp+661,   -0x1.c2d5bfe8a14c2p-2,   -0x1.c31a9p-2, INEXACT)
T(RN,  0x1.0c5c8649df19fp+661,    0x1.d8d41ea07347dp-1,  -0x1.51d6e2p-2, INEXACT)
T(RN,  0x1.b206ff84832acp+661,    0x1.6f9a34ad1c94bp-1,  -0x1.ab12bap-3, INEXACT)
T(RN,  0x1.ea27f6e796a58p+662,   -0x1.c1749b8d76c04p-3,   0x1.962a14p-2, INEXACT)
T(RN,  0x1.88273be7fde52p+662,    0x1.f977070fe022ap-1,  -0x1.ea0a96p-2, INEXACT)
T(RN,  0x1.4ff05dace3bbap+662,    0x1.b4b114656eb52p-1,   0x1.81d4b8p-4, INEXACT)
T(RN,  0x1.13d2830f318f1p+662,   -0x1.264d8e1423756p-1,   0x1.50140cp-2, INEXACT)
T(RN,  0x1.9aab279ee91f5p+662,   -0x1.7b6559b93f389p-1,   0x1.c99dc2p-2, INEXACT)
T(RN,  0x1.182eebf3062f8p+662,   -0x1.f7c3b9f060534p-1,  -0x1.40f3e8p-2, INEXACT)
T(RN,  0x1.f620e48201cf2p+662,    0x1.ae35deb744384p-1,   0x1.d97e4ep-5, INEXACT)
T(RN,  0x1.ae585b8f1d5e8p+662,    0x1.d4d1a10a190eep-1,   0x1.aa3c9ap-2, INEXACT)
T(RN,  0x1.210788a5a0eaep+662,   -0x1.a962bf303596fp-1,   0x1.1edfd6p-7, INEXACT)
T(RN,  0x1.d4b4743f9e731p+662,   -0x1.4839a494cb34dp-1,  -0x1.a37592p-8, INEXACT)
T(RN,  0x1.f7d2d4828b2a7p+663,    0x1.af9c8e66f527ep-3,  -0x1.3379eep-4, INEXACT)
T(RN,  0x1.fc3a77424c11ap+663,    0x1.266820840d453p-1,   0x1.91adc4p-2, INEXACT)
T(RN,  0x1.38e0b3ffb83cbp+663,    0x1.faaf51307011ep-1,    0x1.ee33bp-2, INEXACT)
T(RN,  0x1.cc1211c3ff66ap+663,   -0x1.b916a0a124b3ep-1,  -0x1.844834p-3, INEXACT)
T(RN,  0x1.020fa38632663p+663,    0x1.3c60ea3a11357p-1,   0x1.d08d36p-3, INEXACT)
T(RN,  0x1.56a4a62fa9cd1p+663,    0x1.75725e3df935ep-1,    0x1.68da3p-4, INEXACT)
T(RN,  0x1.4d23bc2939932p+663,   -0x1.d852a5fcc0518p-2,  -0x1.a23f12p-2, INEXACT)
T(RN,  0x1.434099c5e08c6p+663,   -0x1.4a24e70e87fedp-4,   0x1.79095cp-3, INEXACT)
T(RN,  0x1.07e262b1ecbb1p+663,    0x1.da505c58b8051p-1,    0x1.e9167p-4, INEXACT)
T(RN,  0x1.b66ae6ca2ed5ep+663,   -0x1.90538f70130f3p-2,  -0x1.8e2b0ap-3, INEXACT)
T(RN,  0x1.31b9ad039ce19p+664,   -0x1.7c210dab79dbap-1,  -0x1.a10bccp-5, INEXACT)
T(RN,  0x1.2444257da6287p+664,   -0x1.7ea0b2169f01ap-2,   0x1.37c52ap-5, INEXACT)
T(RN,  0x1.5e69600eaffbfp+664,   -0x1.fb7c6b634af8bp-2,  -0x1.da64a2p-2, INEXACT)
T(RN,  0x1.68095aa43ea54p+664,    0x1.d7b7a6ba1ddd3p-1,   0x1.4e1edap-4, INEXACT)
T(RN,  0x1.69be75e930d36p+664,   -0x1.f3661bb2848bep-1,   0x1.7a361ap-2, INEXACT)
T(RN,   0x1.87b9647399bep+664,    -0x1.1ecfc4bf7c29p-5,  -0x1.039756p-4, INEXACT)
T(RN,  0x1.2359da8cf1602p+664,   -0x1.9e5557dec5fd2p-3,  -0x1.597c82p-2, INEXACT)
T(RN,  0x1.45e9a3334ab12p+664,    0x1.8302cb085ccb2p-3,   0x1.25f9aep-5, INEXACT)
T(RN,  0x1.b72e253970547p+664,    0x1.ef46dcd051736p-1,  -0x1.f454f4p-3, INEXACT)
T(RN,  0x1.46231929f6192p+664,    0x1.7d32d7e09ba2ep-1,   0x1.38ff78p-3, INEXACT)
T(RN,  0x1.744629a44fd07p+665,   -0x1.7e122b5d9024ep-1,  -0x1.bf83c6p-4, INEXACT)
T(RN,  0x1.f9315234403c6p+665,   -0x1.db9b2ad4391d4p-1,   0x1.0f41b6p-2, INEXACT)
T(RN,  0x1.e2bb2f0ede0e1p+665,     0x1.4610a7328ba7p-1,   0x1.462a76p-5, INEXACT)
T(RN,   0x1.fc0b2269dde2p+665,    0x1.eae261bcae0a7p-1,   0x1.852898p-3, INEXACT)
T(RN,  0x1.14eea7a60adecp+665,    0x1.4c5972e6921f8p-1,  -0x1.3c037ap-4, INEXACT)
T(RN,  0x1.7c8508eb89adcp+665,   -0x1.91332490bef5dp-1,  -0x1.da5c2cp-2, INEXACT)
T(RN,  0x1.68ac1ff233345p+665,    0x1.feb4ce735977ap-1,   0x1.5a7014p-2, INEXACT)
T(RN,  0x1.29dd94031204cp+665,   -0x1.dd3dde58b985fp-2,   0x1.e2be06p-3, INEXACT)
T(RN,  0x1.0ab495dd0ba8bp+665,    0x1.ff94116f2c41ap-1,    0x1.f71bbp-3, INEXACT)
T(RN,  0x1.f4a5939007997p+665,    0x1.af88c9e55d004p-1,   0x1.5c30d2p-2, INEXACT)
T(RN,  0x1.6317e9162eccdp+666,   -0x1.428f03b93f948p-2,  -0x1.4716eap-2, INEXACT)
T(RN,  0x1.d426eb95281d1p+666,    0x1.dc8f6b95b0a87p-1,  -0x1.cea50ep-2, INEXACT)
T(RN,  0x1.aa3727b4572d3p+666,     0x1.855d5ece8e0dp-3,   0x1.39c1f8p-5, INEXACT)
T(RN,  0x1.f545e5b77f8e4p+666,   -0x1.8754a4ddce821p-3,   0x1.daac52p-2, INEXACT)
T(RN,   0x1.8255e8d84a53p+666,    0x1.fe915def0e0c3p-1,   0x1.a10758p-2, INEXACT)
T(RN,  0x1.4d8ac1123ccfap+666,    0x1.303dbaed59238p-2,   0x1.578488p-4, INEXACT)
T(RN,  0x1.afd7eb2b6b768p+666,     0x1.ea5ff3fe3926p-1,    0x1.b5756p-3, INEXACT)
T(RN,  0x1.8301562107ab4p+666,    0x1.c69b16d538efap-1,   -0x1.ffdd7p-4, INEXACT)
T(RN,  0x1.460c95f2cb97ep+666,    0x1.02c5da6332a54p-1,   0x1.86ee6ap-2, INEXACT)
T(RN,  0x1.ae022f44e7f9bp+666,    0x1.6f6bde9834d01p-4,   0x1.fc854cp-3, INEXACT)
T(RN,  0x1.069ac38160eacp+667,   -0x1.9ff88f3137d15p-1,  -0x1.3dd4b2p-3, INEXACT)
T(RN,  0x1.ad9780510bb37p+667,    0x1.f94155dc08db4p-1,   0x1.7fec22p-2, INEXACT)
T(RN,  0x1.a95c4eba2c3e4p+667,    0x1.877ab9c60a74fp-1,  -0x1.51551ep-3, INEXACT)
T(RN,  0x1.d2f604157976ep+667,   -0x1.9779aaafc0195p-1,  -0x1.77df7cp-2, INEXACT)
T(RN,  0x1.751cdd5b09948p+667,    0x1.22e82f7c16211p-1,   0x1.883e9ep-3, INEXACT)
T(RN,  0x1.0b56c51b95837p+667,   -0x1.6dabbc3939e18p-3,  -0x1.d33d22p-3, INEXACT)
T(RN,  0x1.8e48e38385405p+667,   -0x1.6d3255a945d3cp-1,   0x1.3eee66p-3, INEXACT)
T(RN,   0x1.ed15363ef19bp+667,    0x1.551116346a59bp-1,  -0x1.f0958ap-4, INEXACT)
T(RN,  0x1.b66caef82b934p+667,    0x1.e8b316a1fb44bp-1,  -0x1.c18aeap-2, INEXACT)
T(RN,  0x1.a6b6f02f91a9cp+667,    0x1.f4627db019db5p-1,   0x1.ef5192p-3, INEXACT)
T(RN,  0x1.147d8cd04cb3dp+668,   -0x1.368f48e2a2266p-1,   0x1.dd0baep-5, INEXACT)
T(RN,  0x1.79a69ed59884fp+668,   -0x1.d57cb4bff8bd2p-1,  -0x1.2142b4p-3, INEXACT)
T(RN,  0x1.086650d03e82bp+668,    0x1.cc8dcbb862284p-1,    0x1.b5be2p-3, INEXACT)
T(RN,  0x1.8d6eb7b1c19e3p+668,    0x1.f9a9bb188d576p-1,   0x1.f0f4e2p-3, INEXACT)
T(RN,  0x1.f72d8c32cc164p+668,    0x1.1aca00dfdd7f1p-1,  -0x1.5bf506p-2, INEXACT)
T(RN,  0x1.97346e918389ep+668,    0x1.34901b41caf2fp-2,  -0x1.8cfeeep-3, INEXACT)
T(RN,  0x1.a6bf9ce0258cep+668,    0x1.ad56eacd1c6edp-1,   0x1.de98eap-2, INEXACT)
T(RN,  0x1.4e157ec01104bp+668,    0x1.9c63c3e6dbe43p-3,  -0x1.b598d6p-2, INEXACT)
T(RN,  0x1.461708017bcd3p+668,    0x1.9136f11ad305dp-1,  -0x1.33a25cp-7, INEXACT)
T(RN,  0x1.5bea016351a98p+668,   -0x1.67b379722f865p-1,  -0x1.dfcf98p-7, INEXACT)
T(RN,  0x1.68b78bafef43ep+669,     0x1.6ce0bfd45958p-1,  -0x1.5e2d88p-2, INEXACT)
T(RN,  0x1.17cdb954a1ca4p+669,    -0x1.5b7fbe18a2b4p-1,  -0x1.fda3e8p-2, INEXACT)
T(RN,  0x1.07d129515d8b7p+669,    0x1.67adb957f3d8ep-1,  -0x1.19be94p-4, INEXACT)
T(RN,  0x1.4b700a0c6f50dp+669,    0x1.f183178a512d1p-1,    0x1.97a9ap-7, INEXACT)
T(RN,  0x1.81e47690623e8p+669,   -0x1.3cea5abef3dffp-1,   0x1.e0d1f6p-2, INEXACT)
T(RN,  0x1.343f4edea625ap+669,    0x1.d13065b40df23p-5,  -0x1.9ed276p-2, INEXACT)
T(RN,  0x1.bec61d8b1bf07p+669,    0x1.123aa09fe4679p-1,  -0x1.6e7daap-4, INEXACT)
T(RN,  0x1.e62ad13fe1f86p+669,    0x1.24bf6f2c115a3p-1,  -0x1.3fb91cp-2, INEXACT)
T(RN,  0x1.9bf61db9f38cap+669,   -0x1.5dcf633a8f245p-1,   0x1.7c97dep-2, INEXACT)
T(RN,  0x1.fc418f8a9dc58p+669,    0x1.ffe5261674313p-1,   0x1.e4abb2p-2, INEXACT)
T(RN,  0x1.0ac25d1e4dc7bp+670,   -0x1.ff715b83bdbfbp-1,  -0x1.fe854ep-2, INEXACT)
T(RN,  0x1.7d670b5145d84p+670,    0x1.c20ca005ec488p-1,   0x1.428ea4p-3, INEXACT)
T(RN,  0x1.6142cbd2b5b1cp+670,   -0x1.cefaebc66cd89p-1,  -0x1.14cc7cp-6, INEXACT)
T(RN,  0x1.806f3af415ed4p+670,   -0x1.24f77ae3cf47ep-2,  -0x1.9c7332p-2, INEXACT)
T(RN,  0x1.786cc30a7a29cp+670,   -0x1.4888d3ef2836ap-1,  -0x1.5b6284p-3, INEXACT)
T(RN,  0x1.874bd2182d91bp+670,   -0x1.c1998f9bb34dcp-1,   0x1.db2c4cp-4, INEXACT)
T(RN,  0x1.087bc1ad72334p+670,   -0x1.ff480d33dd0f6p-1,   0x1.f080a2p-2, INEXACT)
T(RN,  0x1.0d56e1b6296e5p+670,   -0x1.0490b1e8628e4p-1,  -0x1.b37ec6p-2, INEXACT)
T(RN,  0x1.e95dc85c4046fp+670,   -0x1.fe787aa2c687ap-2,   0x1.014074p-2, INEXACT)
T(RN,  0x1.ac2996f086401p+670,    0x1.96a7534e3b3dfp-2,   0x1.665a22p-2, INEXACT)
T(RN,   0x1.ce480a95aeb1p+671,   -0x1.bc5f4eec5f106p-1,  -0x1.35a442p-2, INEXACT)
T(RN,  0x1.2dce62a75ced8p+671,   -0x1.90281b0e3e04fp-1,   0x1.52998ep-6, INEXACT)
T(RN,   0x1.cc942890fe74p+671,   -0x1.1cf644d9cebc9p-6,    0x1.741d3p-2, INEXACT)
T(RN,  0x1.60291dc632e9bp+671,   -0x1.82472f1d09827p-3,  -0x1.e005bep-2, INEXACT)
T(RN,  0x1.40550877a7f25p+671,    0x1.bcd6b6b0c1d08p-1,  -0x1.0f1b2ep-3, INEXACT)
T(RN,  0x1.47e5c95060244p+671,    0x1.86cc0aef0f288p-2,   0x1.653f72p-4, INEXACT)
T(RN,  0x1.0e17611842c06p+671,   -0x1.a4ea7ebd048adp-2,   0x1.874ab4p-3, INEXACT)
T(RN,  0x1.497a3bba1d63bp+671,   -0x1.eadb8b439fe4cp-3,   0x1.fe6fb6p-4, INEXACT)
T(RN,  0x1.cb7f70cec14d9p+671,   -0x1.d4fc0c990b43bp-1,   0x1.0ff37ep-4, INEXACT)
T(RN,  0x1.65dfac0489147p+671,    0x1.00428ab3f6f2fp-1,    0x1.f8977p-2, INEXACT)
T(RN,  0x1.64fc7d95f68a5p+672,    0x1.93fe2ce78e24bp-1,   0x1.3b3516p-2, INEXACT)
T(RN,  0x1.1f73d9835287ep+672,   -0x1.a885b8c63eebep-1,   0x1.560974p-3, INEXACT)
T(RN,  0x1.4960eb4869eeep+672,   -0x1.ffe6d5e59d961p-1,  -0x1.7b7282p-4, INEXACT)
T(RN,  0x1.4d4bb87a2799cp+672,   -0x1.1b4bf3fa231ffp-2,  -0x1.87c98cp-3, INEXACT)
T(RN,  0x1.84d708fdf0a7ap+672,    0x1.46c363240ac9ap-7,   0x1.8dde2cp-6, INEXACT)
T(RN,  0x1.c021d3140f1fap+672,    0x1.8cebde42380c1p-1,   0x1.c85cb4p-3, INEXACT)
T(RN,  0x1.16089d3b6a42dp+672,   -0x1.efac1a231c64bp-1,  -0x1.8b9bd4p-2, INEXACT)
T(RN,  0x1.cef7a5b37cf7ep+672,   -0x1.12d73dab4c467p-1,   0x1.12ddecp-2, INEXACT)
T(RN,  0x1.38b8716bdf4d7p+672,    0x1.db184552cbdf9p-1,   0x1.4931c2p-3, INEXACT)
T(RN,  0x1.7876cf3fa2399p+672,   -0x1.b3444758f059ep-1,   0x1.f29ab4p-2, INEXACT)
T(RN,  0x1.1b14f7bd41b12p+673,    -0x1.9ec83e61514bp-1,  -0x1.6c24b8p-3, INEXACT)
T(RN,  0x1.4b91a6ecefb39p+673,    0x1.99887a7334effp-2,    0x1.00793p-2, INEXACT)
T(RN,    0x1.210bdd01013p+673,   -0x1.bf4ff104fa66cp-3,  -0x1.797ac4p-5, INEXACT)
T(RN,  0x1.f0fde9e644486p+673,    -0x1.77dc3d043917p-1,  -0x1.f64f96p-8, INEXACT)
T(RN,  0x1.641d3105ca106p+673,    -0x1.54232c7f98a6p-2,  -0x1.f17fa4p-2, INEXACT)
T(RN,   0x1.d8cd056f6034p+673,    0x1.e0559c778aa92p-1,  -0x1.0c415ep-2, INEXACT)
T(RN,  0x1.ec833df44d3fep+673,   -0x1.c2283a9201a9fp-1,  -0x1.69b216p-3, INEXACT)
T(RN,  0x1.45894a6358283p+673,    -0x1.f12b6f146d59p-1,   0x1.2de058p-2, INEXACT)
T(RN,  0x1.00b9ea9e02954p+673,    0x1.bdb82ac1ee24dp-1,   0x1.3394c6p-5, INEXACT)
T(RN,  0x1.afe9ede12585dp+673,    0x1.ca1bdc363c615p-3,   0x1.fd20bep-2, INEXACT)
T(RN,  0x1.21a963e9d9e8ep+674,    0x1.f436955321bf2p-2,  -0x1.b50ab8p-2, INEXACT)
T(RN,  0x1.58ce6d604b784p+674,   -0x1.3b835ffb493d2p-1,   0x1.7ae30ep-2, INEXACT)
T(RN,  0x1.583286f92d0bap+674,   -0x1.f78956337bf52p-1,  -0x1.705542p-3, INEXACT)
T(RN,  0x1.5b3de306590e4p+674,    0x1.b7f7115cbe08dp-6,  -0x1.0c28bcp-3, INEXACT)
T(RN,  0x1.42cc0f90b66fap+674,    0x1.7390e4698dfecp-6,  -0x1.e4ff02p-8, INEXACT)
T(RN,  0x1.2373dc5adcef8p+674,   -0x1.fdcc72dfb5e42p-1,   -0x1.ea9f9p-6, INEXACT)
T(RN,  0x1.f19978ef37eaep+674,    0x1.c739f97da0d82p-1,   -0x1.5ac42p-8, INEXACT)
T(RN,  0x1.4aa9edad6083cp+674,   -0x1.0b52caeecd3b2p-1,   0x1.f2a84ap-6, INEXACT)
T(RN,  0x1.b1372540dcc49p+674,   -0x1.e79413d56e4fep-1,   -0x1.f7d8ap-2, INEXACT)
T(RN,  0x1.99d245c8ab85ep+674,    0x1.c17db4c66b99dp-1,    0x1.5e486p-3, INEXACT)
T(RN,  0x1.76e7620383674p+675,   -0x1.2c28d27636f36p-1,   0x1.e795ecp-2, INEXACT)
T(RN,  0x1.a743de02d2fbap+675,    0x1.188b474ba443ep-1,  -0x1.33c19ap-2, INEXACT)
T(RN,  0x1.3a6392c4dc0e2p+675,    0x1.cf161c137fe9ap-1,   0x1.c2bd9ap-2, INEXACT)
T(RN,  0x1.076456598beb8p+675,     0x1.3b763b52f5e8p-2,   0x1.ef950ap-2, INEXACT)
T(RN,  0x1.61a7156467167p+675,   -0x1.1c34e0b120896p-1,  -0x1.844d6ap-3, INEXACT)
T(RN,  0x1.39ad2a9b6f1a7p+675,   -0x1.f3092736aab85p-1,  -0x1.0b3946p-2, INEXACT)
T(RN,  0x1.3de41c840614fp+675,    0x1.105ef8704e99ep-2,  -0x1.41d274p-6, INEXACT)
T(RN,  0x1.fd4326dda9c66p+675,   -0x1.2cb3fc6c0cdc9p-3,   0x1.82aa1cp-3, INEXACT)
T(RN,  0x1.1d1d45ddd0c0dp+675,    0x1.e17b29b53a506p-1,   0x1.7590acp-3, INEXACT)
T(RN,  0x1.c0a854237876ap+675,    0x1.e9928d1dd3f05p-1,   0x1.f52f9cp-5, INEXACT)
T(RN,  0x1.96098064bd5dap+676,    0x1.752c99411f655p-1,   0x1.abc566p-3, INEXACT)
T(RN,  0x1.f9e43f3cc5453p+676,    0x1.c34d6b6985c31p-1,   0x1.f5ba92p-3, INEXACT)
T(RN,  0x1.c7a780f1266ebp+676,   -0x1.35c33bb494ad2p-1,   0x1.dbeb38p-2, INEXACT)
T(RN,  0x1.050d3f37ced3ap+676,   -0x1.b6c0e1d816045p-1,   -0x1.594fbp-3, INEXACT)
T(RN,  0x1.b7362d253eb33p+676,    0x1.2a59bc8ae11e8p-2,  -0x1.9e6f92p-3, INEXACT)
T(RN,  0x1.55799896448c5p+676,    0x1.4a9152ed04a9cp-1,   0x1.1aa53ap-4, INEXACT)
T(RN,   0x1.98394a45de54p+676,   -0x1.9805e82d265e8p-2,  -0x1.5f3b14p-6, INEXACT)
T(RN,  0x1.8fa410b473af7p+676,    0x1.ff7ac9ef6035dp-1,    0x1.2ffa1p-3, INEXACT)
T(RN,   0x1.f9f07d014a91p+676,    0x1.c9efad2349908p-1,   0x1.4d0888p-3, INEXACT)
T(RN,   0x1.eb7461c8468cp+676,   -0x1.d75ccd7b31904p-2,  -0x1.b2b15ep-5, INEXACT)
T(RN,   0x1.cbde760b9988p+677,    0x1.d83b99903b4cfp-1,  -0x1.06e938p-6, INEXACT)
T(RN,  0x1.c53e07fbdb836p+677,    0x1.f9d5b40e834d2p-1,   0x1.cbeee6p-4, INEXACT)
T(RN,  0x1.a38fa9f5e6decp+677,   -0x1.9dd20326fc6a4p-3,  -0x1.76ddb4p-3, INEXACT)
T(RN,  0x1.03f5b6dd2e88dp+677,    -0x1.0301f537da37p-2,  -0x1.6810fep-5, INEXACT)
T(RN,  0x1.041ff6ceaee2bp+677,   -0x1.100256f18d5a9p-2,    0x1.79cbdp-2, INEXACT)
T(RN,  0x1.da5c48ed53d48p+677,    0x1.fefe1a8cc6f9cp-1,   -0x1.a6ed6p-3, INEXACT)
T(RN,  0x1.559fd3a8e7ef2p+677,   -0x1.04260fa345f87p-2,   0x1.40df98p-2, INEXACT)
T(RN,  0x1.6699d8e7a3663p+677,    0x1.591d913c3bd72p-1,   0x1.153262p-2, INEXACT)
T(RN,   0x1.25f06c29c4a4p+677,    -0x1.e5618e2465dfp-2,  -0x1.25020cp-6, INEXACT)
T(RN,  0x1.38905bf40bc0bp+677,     0x1.7e630bd050d4p-1,   0x1.a06e9cp-4, INEXACT)
T(RN,  0x1.306d1760cd30dp+678,   -0x1.e31bf030bff6ap-3,  -0x1.76ff44p-3, INEXACT)
T(RN,  0x1.d58a820b9f982p+678,   -0x1.aea1b1ee9656ap-4,   0x1.8ba224p-4, INEXACT)
T(RN,  0x1.df6037d1bc883p+678,    0x1.d72886a15a81dp-2,  -0x1.de995ep-2, INEXACT)
T(RN,  0x1.a946f845cff42p+678,   -0x1.87826f225a551p-1,  -0x1.896e5ep-3, INEXACT)
T(RN,  0x1.59deedbfe2f9fp+678,   -0x1.e3bdb4f15291fp-1,    0x1.ba175p-2, INEXACT)
T(RN,  0x1.3da090b89eb11p+678,   -0x1.42514b163adafp-2,  -0x1.4ab40ep-4, INEXACT)
T(RN,  0x1.a9f56bbe968e1p+678,   -0x1.3a1b3ea2445d2p-1,   0x1.2cd17cp-2, INEXACT)
T(RN,  0x1.18f738e97d194p+678,   -0x1.e746be5f67661p-1,  -0x1.8ad804p-3, INEXACT)
T(RN,  0x1.569d949f0ca79p+678,    0x1.6bbcaff3a0b7dp-3,   -0x1.d3b36p-2, INEXACT)
T(RN,  0x1.7cfb19b991131p+678,    0x1.28f0fca12a85dp-1,   0x1.846f5ap-2, INEXACT)
T(RN,  0x1.b14644310b0d6p+679,   -0x1.436b06944bee7p-1,    0x1.1151ap-3, INEXACT)
T(RN,  0x1.7ab75a9c94df7p+679,   -0x1.4d4f38cceb46ap-2,   0x1.0ae848p-5, INEXACT)
T(RN,  0x1.fd0521043aa7cp+679,    0x1.088419e1ceda3p-2,   0x1.a68fe4p-2, INEXACT)
T(RN,  0x1.3477963a980a9p+679,    0x1.4a6c333f1435cp-2,   0x1.79ae44p-6, INEXACT)
T(RN,  0x1.2e4371ecb0a2ap+679,    0x1.d79a8e66b6499p-1,  -0x1.b8680ep-3, INEXACT)
T(RN,   0x1.d3229702dfacp+679,    0x1.3523a6e4f7b2ep-3,  -0x1.c224a2p-3, INEXACT)
T(RN,  0x1.e3fa81c29d8dcp+679,    0x1.6cc6f5c0d4c3fp-2,   0x1.fd6324p-2, INEXACT)
T(RN,  0x1.e3f27e669bf3ap+679,    0x1.d4c93ebff8577p-1,  -0x1.99a89ap-3, INEXACT)
T(RN,  0x1.d5c77bc6d1e4cp+679,    0x1.7b8247ea14f99p-5,   0x1.0a9564p-5, INEXACT)
T(RN,  0x1.83435249f7462p+679,   -0x1.1a85b090587abp-1,  -0x1.2144e6p-2, INEXACT)
T(RN,   0x1.32dd5dabb38ap+680,    0x1.d11e1ff0e427bp-3,  -0x1.6ec4acp-3, INEXACT)
T(RN,  0x1.f5a6013622bc7p+680,   -0x1.5a3d67ae48586p-1,  -0x1.86e766p-2, INEXACT)
T(RN,  0x1.291bb8dc3a6a4p+680,   -0x1.37a8b6f89e1ecp-2,  -0x1.4dce98p-4, INEXACT)
T(RN,  0x1.516850d6ac70bp+680,   -0x1.a3e0c031597cdp-1,  -0x1.d5c834p-8, INEXACT)
T(RN,  0x1.8205b8c4dcf2cp+680,    0x1.2edf2a13f50f3p-1,   0x1.9b2d8cp-3, INEXACT)
T(RN,  0x1.bc1aa70cf0dacp+680,   -0x1.bc0375d336cf2p-2,   0x1.566288p-2, INEXACT)
T(RN,  0x1.978d6d34086c8p+680,    0x1.abaedcf2e6e77p-1,  -0x1.765838p-2, INEXACT)
T(RN,  0x1.7a77406880836p+680,   -0x1.cac912ea1801fp-1,   0x1.074d14p-3, INEXACT)
T(RN,  0x1.8bd9264a9b7eap+680,   -0x1.30bfa0d8b3174p-1,   0x1.371ecap-3, INEXACT)
T(RN,  0x1.f020b2f2aeec4p+680,    0x1.5fa67a5b08747p-1,   0x1.875c5ap-2, INEXACT)
T(RN,  0x1.a65a73104a951p+681,    0x1.4457d08ef6acfp-1,   0x1.e0003ap-2, INEXACT)
T(RN,  0x1.5b557dfd3dc1fp+681,    0x1.010543c278d6cp-2,   0x1.94066cp-2, INEXACT)
T(RN,  0x1.50ce364961865p+681,   -0x1.cbbf7c0a5d03cp-1,   0x1.9b441cp-2, INEXACT)
T(RN,  0x1.faff5e9f141fdp+681,   -0x1.f2b90b4d8ea39p-1,   0x1.5de2f6p-2, INEXACT)
T(RN,  0x1.6684a5cfb9f9dp+681,    -0x1.0ac09974ca9ep-3,  -0x1.c74f28p-6, INEXACT)
T(RN,  0x1.b5dfa5b41e6f7p+681,   -0x1.9d297bc4022d6p-3,  -0x1.53b19ap-2, INEXACT)
T(RN,  0x1.79c75fe5bd971p+681,   -0x1.46135c926ea0cp-1,  -0x1.cf5c9ap-2, INEXACT)
T(RN,  0x1.6f23308c8144dp+681,   -0x1.1fcb9174df4bep-1,  -0x1.b987d6p-2, INEXACT)
T(RN,  0x1.af59a4699aa9ep+681,   -0x1.5215efbbbda0fp-1,   0x1.cf99e6p-2, INEXACT)
T(RN,  0x1.1f42a483f4d5cp+681,    0x1.da0ad54581602p-1,  -0x1.f684b2p-4, INEXACT)
T(RN,  0x1.aa40881f08962p+682,   -0x1.8fac1d43c9f34p-2,    0x1.beb8fp-3, INEXACT)
T(RN,  0x1.5d009228ce80ep+682,     0x1.6910550cd4d4p-1,  -0x1.b9acdcp-3, INEXACT)
T(RN,  0x1.dc4f61bc12784p+682,    0x1.c872f28117d43p-1,  -0x1.f382aep-2, INEXACT)
T(RN,  0x1.5a1ecd9686d24p+682,   -0x1.b3bde72b13409p-3,   0x1.b1ddb2p-2, INEXACT)
T(RN,  0x1.9fd4beec64586p+682,   -0x1.aec5de8277611p-1,  -0x1.067c2ep-2, INEXACT)
T(RN,  0x1.1499e4cbfa3d4p+682,    0x1.fbfd753082cd2p-1,  -0x1.6d1ab2p-4, INEXACT)
T(RN,  0x1.bec98544ddc46p+682,   -0x1.72569ca041ea6p-1,   0x1.68d208p-2, INEXACT)
T(RN,  0x1.c5c4e03d71928p+682,    0x1.5b5da5708c3ddp-1,   0x1.4a2eaep-2, INEXACT)
T(RN,  0x1.39f866ce7bbdap+682,   -0x1.b289da5dc85a2p-8,   0x1.05bc8cp-3, INEXACT)
T(RN,  0x1.8a16b16797e0ap+682,   -0x1.e65c61a49adaep-3,   0x1.49cc36p-2, INEXACT)
T(RN,  0x1.658d7c1190728p+683,    0x1.a3045757e0fddp-2,   0x1.9bf076p-3, INEXACT)
T(RN,  0x1.5046b6612651bp+683,    0x1.9d8cd0ea7cd58p-3,  -0x1.af9eb6p-2, INEXACT)
T(RN,  0x1.39a32ebb8f9b8p+683,    0x1.89381cce3bc9ep-6,   0x1.472efcp-2, INEXACT)
T(RN,  0x1.ae4b45ee105e8p+683,    0x1.524fefa17f98ep-1,   0x1.1acc56p-2, INEXACT)
T(RN,  0x1.c5d39de3e47a8p+683,   -0x1.f7a548482d219p-1,   0x1.08f3fcp-5, INEXACT)
T(RN,  0x1.01ea4bf593eb2p+683,   -0x1.be6d2bfc5788ap-1,  -0x1.d157e4p-6, INEXACT)
T(RN,  0x1.c29c849df22d6p+683,   -0x1.ef2ddad0f1cc9p-1,   0x1.2d5b0ap-4, INEXACT)
T(RN,  0x1.e24185d937898p+683,    0x1.edcc3944cfa0fp-1,   0x1.e01dc6p-4, INEXACT)
T(RN,  0x1.c75b0891f8a99p+683,    0x1.fd8e2185de315p-1,   0x1.b87364p-3, INEXACT)
T(RN,  0x1.67b9fa87b1aa1p+683,   -0x1.d62e8ac2ee3bcp-1,  -0x1.822064p-2, INEXACT)
T(RN,  0x1.0daeef833f121p+684,   -0x1.fcb3e9647af36p-1,  -0x1.bdbc9ep-3, INEXACT)
T(RN,  0x1.7f521f6a120f2p+684,    0x1.ce3edda5ff854p-4,   0x1.20ccccp-2, INEXACT)
T(RN,  0x1.573e0b4eea518p+684,    0x1.f82ce6088d223p-1,   -0x1.db526p-2, INEXACT)
T(RN,  0x1.a597904903b76p+684,    0x1.ec89b7ef7ce62p-1,  -0x1.be6bc2p-3, INEXACT)
T(RN,  0x1.5e6d830e3a978p+684,   -0x1.d843a478b5781p-2,    0x1.b0622p-2, INEXACT)
T(RN,  0x1.77aa4c2277ceap+684,   -0x1.37c0ef75d6b81p-1,   0x1.d6235ep-2, INEXACT)
T(RN,  0x1.a60de63402eaap+684,    0x1.bc107b0d7c737p-1,   0x1.2f9f52p-2, INEXACT)
T(RN,  0x1.b8c1181e00d0ap+684,    0x1.dd246ff3ac3efp-4,   0x1.f01778p-2, INEXACT)
T(RN,   0x1.a13028a2ab15p+684,    0x1.1dc388aa5ec41p-1,  -0x1.69d8dcp-2, INEXACT)
T(RN,  0x1.30fa81f6955bap+684,   -0x1.6a0bf93a45cfcp-3,   0x1.3a1472p-2, INEXACT)
T(RN,  0x1.1b7a89bc8a939p+685,    0x1.e231e8fc2d979p-1,  -0x1.1571dap-2, INEXACT)
T(RN,  0x1.5909a98909e5fp+685,    0x1.f27a2052a6733p-1,   0x1.7a500cp-2, INEXACT)
T(RN,   0x1.89c58ce2e3c9p+685,    0x1.e2efb82a6e5c7p-1,  -0x1.c566fep-2, INEXACT)
T(RN,  0x1.956d293291b2ep+685,    0x1.2125fe0b420dap-1,  -0x1.2d1086p-2, INEXACT)
T(RN,  0x1.e002787782ef2p+685,   -0x1.45664826bb4b6p-1,   0x1.6cc6f4p-8, INEXACT)
T(RN,  0x1.4760d8f162be8p+685,    0x1.c37f3318c5979p-1,   0x1.14e5a2p-3, INEXACT)
T(RN,   0x1.f4cd71d4471bp+685,   -0x1.b518f2bd188e3p-1,  -0x1.8fa46ep-2, INEXACT)
T(RN,  0x1.9cf985b89cef5p+685,   -0x1.7cab1da21cb68p-1,  -0x1.48d66ep-3, INEXACT)
T(RN,  0x1.85d265ccf056ep+685,    0x1.d55ff168e91c9p-2,   0x1.a9c55cp-2, INEXACT)
T(RN,  0x1.3985cdf57fe11p+685,   -0x1.5be2905996a79p-1,  -0x1.909a96p-2, INEXACT)
T(RN,  0x1.2540408a4d496p+686,    0x1.bf54cdeb869bfp-4,  -0x1.a659b8p-2, INEXACT)
T(RN,  0x1.08971cac38fe1p+686,   -0x1.d7c5a24379134p-1,  -0x1.4a4efap-4, INEXACT)
T(RN,  0x1.11988894813f8p+686,   -0x1.912f4abf2d504p-3,   0x1.4cbe6ep-3, INEXACT)
T(RN,  0x1.67d82f62738e5p+686,     0x1.02fb29130e89p-1,   0x1.496d96p-2, INEXACT)
T(RN,  0x1.cd1d8fa3da642p+686,   -0x1.16f0fdebe1739p-1,   0x1.5bbcc6p-2, INEXACT)
T(RN,  0x1.9e8027e17d1f2p+686,   -0x1.fb2a91ac36654p-1,  -0x1.064904p-2, INEXACT)
T(RN,   0x1.b835734650c2p+686,   -0x1.f821166a365e3p-1,  -0x1.33d61ap-2, INEXACT)
T(RN,  0x1.cfa89eabf21afp+686,    0x1.ebe12a18c8c58p-1,   0x1.2885e2p-2, INEXACT)
T(RN,  0x1.9d5b3e312210bp+686,    0x1.c0db1a8796c0dp-2,   0x1.b1574ep-2, INEXACT)
T(RN,  0x1.96810f3202a18p+686,     0x1.a9b268aec0d5p-1,   0x1.fa3a08p-5, INEXACT)
T(RN,   0x1.a4809e4bcab5p+687,    0x1.88874b512d027p-1,   0x1.8e4e92p-4, INEXACT)
T(RN,  0x1.d1dbe046213bcp+687,    0x1.06194aae11ea3p-4,    -0x1.c9b1p-2, INEXACT)
T(RN,  0x1.16cf609325d72p+687,    0x1.e7b44e7fb4145p-1,   0x1.fcea9ep-2, INEXACT)
T(RN,  0x1.ca77071a528a8p+687,   -0x1.bad371f52d3d5p-1,   0x1.c6c834p-2, INEXACT)
T(RN,  0x1.93905677ac311p+687,   -0x1.248375f6845f9p-2,   -0x1.631d8p-3, INEXACT)
T(RN,  0x1.92199f3607998p+687,    0x1.6411f86085366p-3,  -0x1.a41708p-2, INEXACT)
T(RN,  0x1.74ea6f1b69f14p+687,   -0x1.fbb466ae61bf1p-1,   0x1.3d3c1ep-2, INEXACT)
T(RN,  0x1.1be0b848f543fp+687,   -0x1.7916adfeaf3fdp-1,  -0x1.c9ac84p-2, INEXACT)
T(RN,  0x1.8ea7a1cb7a60ep+687,    0x1.a947a3f10ecebp-1,   0x1.eef894p-3, INEXACT)
T(RN,  0x1.3a4c5565dc39dp+687,   -0x1.65991652e797fp-2,   0x1.985d68p-5, INEXACT)
T(RN,  0x1.1162ced3e2d48p+688,    0x1.3268631759e39p-1,   0x1.efe454p-4, INEXACT)
T(RN,   0x1.a004e61f9815p+688,   -0x1.9c40de7334917p-1,   0x1.8913f4p-2, INEXACT)
T(RN,  0x1.6e7e368553012p+688,    0x1.7b69005dc6246p-4,   -0x1.ca3e1p-3, INEXACT)
T(RN,  0x1.5e6719d43adf3p+688,    0x1.fea6dcff4dcb8p-1,  -0x1.ff3a02p-5, INEXACT)
T(RN,  0x1.d2ad782c3acd4p+688,   -0x1.fb36d0dbf07edp-2,   0x1.2f22c4p-2, INEXACT)
T(RN,  0x1.d96e05e932635p+688,    0x1.69eafe736da3cp-1,   0x1.64d40cp-6, INEXACT)
T(RN,  0x1.388118f17295cp+688,   -0x1.7a40b92047682p-4,   0x1.3b0118p-2, INEXACT)
T(RN,  0x1.4647cd65beeb9p+688,   -0x1.20d6099dfc2dep-3,  -0x1.fa98fcp-3, INEXACT)
T(RN,  0x1.de5ffa0587fd1p+688,   -0x1.0c26227f82a59p-2,    0x1.9dae2p-3, INEXACT)
T(RN,  0x1.ef88b331c0dfap+688,    0x1.326c35001e624p-2,  -0x1.ef1272p-2, INEXACT)
T(RN,  0x1.a98cb268b8b88p+689,    0x1.1405be5750001p-3,  -0x1.54ae4ep-2, INEXACT)
T(RN,  0x1.3c6856672fc15p+689,   -0x1.cf4f01603c0fep-1,  -0x1.ddd484p-3, INEXACT)
T(RN,  0x1.93f6638b8ec8ep+689,    0x1.840f078ff46f2p-3,   -0x1.9422bp-2, INEXACT)
T(RN,  0x1.bf22274972d06p+689,   -0x1.f7e1de1e2e3ecp-2,  -0x1.67ff26p-5, INEXACT)
T(RN,  0x1.81bbfed8de1b4p+689,   -0x1.9f83059014e94p-1,  -0x1.2f8894p-2, INEXACT)
T(RN,  0x1.d2f8190418368p+689,   -0x1.397a472942e93p-3,  -0x1.b2d5fap-3, INEXACT)
T(RN,  0x1.fdc91b533e2cap+689,   -0x1.e09f989a75539p-1,  -0x1.b765eep-3, INEXACT)
T(RN,  0x1.790f619c21c0cp+689,    0x1.d1948ec1cca23p-1,   0x1.bec1aep-2, INEXACT)
T(RN,   0x1.3d7bdbd0dd6ap+689,   -0x1.f64f0d6d92feep-1,   0x1.e1d46ap-2, INEXACT)
T(RN,  0x1.3faf8118ad138p+689,    0x1.ebdad16801c71p-1,  -0x1.d8cc86p-2, INEXACT)
T(RN,  0x1.d2a884e7d3388p+690,    0x1.5a1495c8961aep-1,    0x1.397f7p-2, INEXACT)
T(RN,  0x1.9463bb638c1c2p+690,    0x1.8cfe3f24a042ep-3,  -0x1.edff8cp-3, INEXACT)
T(RN,  0x1.cafeb5468625ep+690,    0x1.7473026bd3924p-1,   0x1.b67e2ap-2, INEXACT)
T(RN,  0x1.60d5315da47e2p+690,   -0x1.f9235e2144082p-1,  -0x1.8e9242p-2, INEXACT)
T(RN,  0x1.637d5673131e1p+690,   -0x1.adaa484e8403dp-1,  -0x1.ca686ap-2, INEXACT)
T(RN,  0x1.d839ccb8ca6fep+690,    0x1.d7f9bddecf6d4p-1,   0x1.f7537cp-3, INEXACT)
T(RN,  0x1.29736aa959494p+690,    0x1.3ee2c69fd15a5p-1,  -0x1.d7ec18p-4, INEXACT)
T(RN,  0x1.cfb96ba942924p+690,    0x1.d7b4375c503afp-1,  -0x1.532336p-3, INEXACT)
T(RN,   0x1.ec8a334427b3p+690,    0x1.bf46808badb0ep-1,   0x1.c472b4p-3, INEXACT)
T(RN,   0x1.0e730d24b5e5p+690,   -0x1.45e8901e9f478p-5,   0x1.ee11a8p-5, INEXACT)
T(RN,  0x1.ccf8e4dba76bep+691,   -0x1.fd8f22e429a8ep-1,  -0x1.86b03ep-2, INEXACT)
T(RN,  0x1.36d2daf368c95p+691,   -0x1.205c6173f1a31p-2,   0x1.02f568p-2, INEXACT)
T(RN,  0x1.eb0173b707c56p+691,    0x1.f8a230eb28662p-1,   -0x1.9eec5p-2, INEXACT)
T(RN,  0x1.512d247d3c749p+691,   -0x1.f1643de470aa7p-1,  -0x1.7f6be6p-3, INEXACT)
T(RN,  0x1.5480a60225a62p+691,    0x1.bd74729253a81p-1,  -0x1.c7fa7ap-2, INEXACT)
T(RN,  0x1.bd6cc9796bf7dp+691,   -0x1.d9c935add0d61p-1,   0x1.d76418p-2, INEXACT)
T(RN,  0x1.52b05754b0156p+691,    0x1.fab45ceac3ca3p-1,   0x1.fa5ec8p-3, INEXACT)
T(RN,  0x1.a5572e34169b8p+691,   -0x1.ea24cadac60e5p-1,   0x1.e279c8p-2, INEXACT)
T(RN,  0x1.dac753053085cp+691,   -0x1.ecfefe9b24d9dp-1,  -0x1.78e8a6p-2, INEXACT)
T(RN,  0x1.ca32a66e41ef8p+691,    0x1.455d007bfaba6p-1,   0x1.395b76p-2, INEXACT)
T(RN,  0x1.09aab1d335e26p+692,    0x1.ffff2a08086bfp-1,   0x1.4c10f2p-5, INEXACT)
T(RN,  0x1.c14fc1252542ap+692,   -0x1.975a388fd4564p-1,  -0x1.e68bc4p-3, INEXACT)
T(RN,  0x1.87d1e11c97b3bp+692,   -0x1.ba911adce8d91p-1,  -0x1.f4b09cp-2, INEXACT)
T(RN,  0x1.6b3d74ddd7824p+692,   -0x1.4355f077f62d7p-2,   0x1.8b949ep-2, INEXACT)
T(RN,  0x1.c49a430f1dc5fp+692,   -0x1.f395f26b5ccebp-1,   0x1.49a7ccp-2, INEXACT)
T(RN,  0x1.a1e27a320234bp+692,   -0x1.3849b1fd41678p-3,  -0x1.e0d0fap-2, INEXACT)
T(RN,  0x1.edfc688a6c6d3p+692,    0x1.a03d74a72a759p-2,   0x1.2bfc14p-2, INEXACT)
T(RN,  0x1.03a5645344342p+692,   -0x1.f250814b3dd69p-1,   0x1.9a204ep-2, INEXACT)
T(RN,  0x1.69d94bc3cee66p+692,    0x1.7cb27909e7544p-1,  -0x1.d0168ap-2, INEXACT)
T(RN,  0x1.69d60264b82bbp+692,   -0x1.4fd7f9570ae2bp-2,  -0x1.33e056p-2, INEXACT)
T(RN,  0x1.9204c5fe2cce5p+693,   -0x1.b68ea10d64a7dp-1,  -0x1.016524p-2, INEXACT)
T(RN,  0x1.1bf1681f8d1f8p+693,   -0x1.a0c23d9928b7cp-3,  -0x1.75cb74p-3, INEXACT)
T(RN,  0x1.d65cbdbc89a53p+693,    0x1.f499717cb37fap-1,  -0x1.d5e724p-2, INEXACT)
T(RN,  0x1.cc0b6ffe7ab9fp+693,    0x1.91d5c731fbc1bp-2,   0x1.b792b8p-2, INEXACT)
T(RN,  0x1.4e927fca2be2bp+693,   -0x1.13d30a4dad5bbp-2,  -0x1.ad814ep-5, INEXACT)
T(RN,  0x1.564d99954b9f4p+693,    0x1.9ab1bb44763a8p-2,   0x1.238866p-3, INEXACT)
T(RN,  0x1.f9250dc605c51p+693,    0x1.ce1cc21caaf54p-2,  -0x1.da3332p-2, INEXACT)
T(RN,  0x1.bd38de828012ep+693,   -0x1.4ab94e2df9923p-3,   0x1.9480b6p-5, INEXACT)
T(RN,  0x1.01976492a76eep+693,    0x1.d3b569f7dfc0cp-4,   0x1.dd6588p-2, INEXACT)
T(RN,  0x1.7edba6769c4eep+693,    0x1.ff1e32715e6e7p-3,   0x1.f92e2cp-3, INEXACT)
T(RN,  0x1.f3e33b06b02aap+694,    0x1.f00632b25ef95p-1,  -0x1.2c5094p-2, INEXACT)
T(RN,  0x1.89a3d6598393fp+694,    0x1.587e83ac38169p-3,  -0x1.df360ep-3, INEXACT)
T(RN,  0x1.efb124c38a0d2p+694,    0x1.6b7c76c366f47p-1,   0x1.b6cf1ap-4, INEXACT)
T(RN,  0x1.0940512dea294p+694,    0x1.20cb9184faa4ap-2,   0x1.7c55c8p-2, INEXACT)
T(RN,  0x1.78318eeb61771p+694,   -0x1.33587571d66c8p-6,  -0x1.4a25e8p-6, INEXACT)
T(RN,  0x1.57c87d8e0db0fp+694,    0x1.b20061af58ea7p-1,   0x1.26139cp-3, INEXACT)
T(RN,  0x1.287e5d037e0fdp+694,   -0x1.8c40b01c069eap-4,  -0x1.ac1b4ep-4, INEXACT)
T(RN,  0x1.f4a2fc1323189p+694,    0x1.7cda40d14dc16p-1,   0x1.725908p-6, INEXACT)
T(RN,  0x1.b8e525ff15ed9p+694,    -0x1.78d719b113e9p-1,   -0x1.91b85p-2, INEXACT)
T(RN,  0x1.e0a06c379549dp+694,    0x1.ccd4838e95307p-1,   0x1.de7a94p-5, INEXACT)
T(RN,  0x1.cb0fc7dac9112p+695,    0x1.61a52916719c4p-3,  -0x1.6518eap-5, INEXACT)
T(RN,  0x1.c1dcdf7845e46p+695,   -0x1.fffb4adbcb2d6p-1,    0x1.f3337p-4, INEXACT)
T(RN,  0x1.ba28022f1c1acp+695,   -0x1.29a2c5ad664b7p-3,  -0x1.ffd3e8p-2, INEXACT)
T(RN,  0x1.b0ca40d1cf4c2p+695,    0x1.9bff7effa6c53p-1,   0x1.7398aap-6, INEXACT)
T(RN,  0x1.ab8ea626a1623p+695,   -0x1.141205acc45c9p-2,   0x1.d30a08p-4, INEXACT)
T(RN,  0x1.105bc669f4543p+695,   -0x1.ca1caf174f221p-1,  -0x1.c13feep-3, INEXACT)
T(RN,  0x1.285b2d56a96b7p+695,   -0x1.e1a4282423f1fp-3,  -0x1.7baae8p-2, INEXACT)
T(RN,  0x1.ee2ef0f2e6458p+695,    0x1.2f323942471b7p-2,  -0x1.40002ep-2, INEXACT)
T(RN,  0x1.f9c5a69a63fc2p+695,    0x1.95a1b1208458cp-1,  -0x1.0bfb38p-3, INEXACT)
T(RN,  0x1.ee96df85a9492p+695,   -0x1.32e709c10f82bp-4,   -0x1.934bcp-3, INEXACT)
T(RN,  0x1.a254ba06e5c9ap+696,   -0x1.ff864fb6cccdfp-1,  -0x1.6b9062p-2, INEXACT)
T(RN,  0x1.3c09f82b03f46p+696,   -0x1.faeb63c4da85dp-1,  -0x1.a9c5cap-2, INEXACT)
T(RN,  0x1.5f6c24cc82d58p+696,   -0x1.d5346922b61eep-1,   0x1.b79abep-4, INEXACT)
T(RN,  0x1.c7b1008879bacp+696,    0x1.9baa3dc096876p-2,  -0x1.b330cap-2, INEXACT)
T(RN,  0x1.74bb5c48164cdp+696,   -0x1.cdc3be83b589fp-1,  -0x1.98adaap-2, INEXACT)
T(RN,  0x1.08dd0900ee091p+696,   -0x1.5c70ffa866987p-1,   0x1.bb461ep-6, INEXACT)
T(RN,  0x1.01015495f987dp+696,    0x1.fdbeaacf58782p-1,  -0x1.19a4fcp-2, INEXACT)
T(RN,  0x1.013d5db7b9f3ep+696,   -0x1.c2687ade7bd9cp-1,  -0x1.0ab112p-3, INEXACT)
T(RN,  0x1.67615393540f4p+696,    0x1.4aaed6a50451dp-3,  -0x1.1967f2p-4, INEXACT)
T(RN,  0x1.5073b68fc1826p+696,   -0x1.e59a39947aadap-1,   0x1.591256p-3, INEXACT)
T(RN,  0x1.c485a72092af6p+697,    0x1.322901df4545ep-3,   0x1.b64f22p-2, INEXACT)
T(RN,  0x1.58a10b45fc01ep+697,   -0x1.e349ed99d88ccp-1,  -0x1.bce468p-2, INEXACT)
T(RN,  0x1.b4281a728c1fap+697,   -0x1.f13ec22889f24p-1,   0x1.cf9ccap-9, INEXACT)
T(RN,  0x1.bbbb044d019ccp+697,    0x1.faa7ec9d0ea2ep-1,   0x1.62cc4ap-3, INEXACT)
T(RN,  0x1.0fca07e0c7548p+697,   -0x1.828191a3b1577p-2,  -0x1.10bd32p-2, INEXACT)
T(RN,  0x1.c63c5aab9ba02p+697,   -0x1.fec57bf224429p-1,  -0x1.8baf7ap-3, INEXACT)
T(RN,  0x1.df501b50adfeap+697,   -0x1.d4a2979b6782bp-3,  -0x1.25a1d4p-2, INEXACT)
T(RN,  0x1.875ab0ff2b071p+697,    0x1.345b0a65865a5p-1,  -0x1.466e22p-3, INEXACT)
T(RN,  0x1.d8e980838396cp+697,   -0x1.3efc5e507bee2p-1,  -0x1.56e0d6p-9, INEXACT)
T(RN,  0x1.3ab179ddf332cp+697,   -0x1.fee9bfbf2d313p-1,   0x1.3bc60cp-6, INEXACT)
T(RN,   0x1.02c40a92220bp+698,    0x1.4452410cf0fd3p-2,   -0x1.bc544p-3, INEXACT)
T(RN,  0x1.9c826e5e1a2bap+698,    0x1.f93e8ab8765aap-1,   0x1.d26696p-2, INEXACT)
T(RN,  0x1.f9d815fd5984fp+698,   -0x1.fd2aa4879833fp-1,   0x1.68c072p-2, INEXACT)
T(RN,  0x1.a91dce6a1c7c2p+698,    0x1.72a2c888937a5p-1,  -0x1.52139cp-2, INEXACT)
T(RN,  0x1.cae85245f1dcep+698,    0x1.e51f538267aa7p-1,   0x1.c33d74p-3, INEXACT)
T(RN,  0x1.a2d416be84df8p+698,    0x1.993ec160e42cep-1,  -0x1.ba6fdep-6, INEXACT)
T(RN,   0x1.e7116682406dp+698,    0x1.fce48c5b2ae32p-1,   -0x1.e9363p-6, INEXACT)
T(RN,  0x1.c0ddd7567b8e8p+698,   -0x1.bff430f221b91p-1,   0x1.a613bap-2, INEXACT)
T(RN,  0x1.4fdf3ed72a748p+698,    0x1.f7d56b85c87e6p-1,   0x1.abb4bcp-2, INEXACT)
T(RN,  0x1.af9afc99bbcdcp+698,   -0x1.bf38d8cd37de8p-2,  -0x1.27e2e8p-3, INEXACT)
T(RN,  0x1.e1fb0de8a269cp+699,    -0x1.6590376a3feap-1,   0x1.973ac2p-2, INEXACT)
T(RN,  0x1.b42495fc0d09cp+699,    0x1.1a1b9b12f19aep-1,    0x1.bf83ap-3, INEXACT)
T(RN,  0x1.d4c24a223c42cp+699,   -0x1.fe997d9de51d5p-1,  -0x1.c4e376p-2, INEXACT)
T(RN,  0x1.8454cfce73c54p+699,   -0x1.b11f83f1b421fp-1,   0x1.e9e08cp-2, INEXACT)
T(RN,   0x1.5936e8a0e28cp+699,    0x1.f48d84932284bp-1,  -0x1.c3a6bep-3, INEXACT)
T(RN,  0x1.24d582a318eb4p+699,   -0x1.fe37b41170cd3p-1,   0x1.ae0cfap-7, INEXACT)
T(RN,    0x1.a7831dc87c8p+699,   -0x1.de24e943cdc9ep-4,   -0x1.43a48p-2, INEXACT)
T(RN,  0x1.738b065604f91p+699,    0x1.f81faf7494551p-1,  -0x1.49db74p-3, INEXACT)
T(RN,  0x1.f90b6c61df69cp+699,    0x1.37efbcf7784fcp-1,    0x1.34dcep-2, INEXACT)
T(RN,  0x1.2a42c8d87134bp+699,    0x1.7750fff29c76dp-1,   0x1.57a246p-2, INEXACT)
T(RN,   0x1.00482dcb5fabp+700,   -0x1.e1108507c907bp-1,  -0x1.4d1916p-4, INEXACT)
T(RN,  0x1.8380a1bd66df8p+700,   -0x1.e9be7b41509f2p-3,    0x1.fcad2p-2, INEXACT)
T(RN,  0x1.ecb0f04b17986p+700,    0x1.7cdb59ed8a6d6p-1,   -0x1.9c4dap-2, INEXACT)
T(RN,  0x1.fe1c2ef8399b6p+700,    0x1.983d8945f3124p-1,  -0x1.142f98p-3, INEXACT)
T(RN,  0x1.c829e4a6c5bd2p+700,    0x1.272730bfe3e5cp-3,   0x1.5a9978p-2, INEXACT)
T(RN,  0x1.76dff5e8df157p+700,   -0x1.b7541808bfcc8p-2,   0x1.70c502p-2, INEXACT)
T(RN,  0x1.bfe31fb63cbd6p+700,   -0x1.8e1c51d3e364dp-1,  -0x1.8fbc56p-3, INEXACT)
T(RN,  0x1.00e31f073f88dp+700,    0x1.fcd49910cb279p-1,   0x1.2b703ep-3, INEXACT)
T(RN,  0x1.41955b9827973p+700,     0x1.dac05b184186p-3,   -0x1.5b445p-2, INEXACT)
T(RN,  0x1.71900907ea20ap+700,   -0x1.71a5e8f40d7d7p-1,   0x1.3847fap-2, INEXACT)
T(RN,  0x1.ee4b97c31e7b6p+701,    0x1.e91f173e9ecb3p-1,  -0x1.2c3698p-2, INEXACT)
T(RN,  0x1.532b2b7f3914cp+701,    0x1.aa0a6f2e4c759p-1,  -0x1.fe9326p-4, INEXACT)
T(RN,  0x1.26bdb5e6385f7p+701,    0x1.4ddd7fd09afe1p-1,   0x1.1c6c76p-4, INEXACT)
T(RN,  0x1.e07c366a408a6p+701,    0x1.ca30e5a4b088cp-1,  -0x1.812e7ep-3, INEXACT)
T(RN,  0x1.81627d001ad5ep+701,   -0x1.fd974b920bcd9p-1,   -0x1.46b1cp-4, INEXACT)
T(RN,  0x1.dd9a1741f2363p+701,    0x1.6e73a865150a9p-1,  -0x1.b3a81ap-3, INEXACT)
T(RN,  0x1.2dacaaa20d637p+701,   -0x1.f9628c358fb96p-1,   0x1.16efeap-2, INEXACT)
T(RN,  0x1.2681ef1d8ecf6p+701,   -0x1.555b241829788p-1,   0x1.bb7602p-6, INEXACT)
T(RN,  0x1.8b5c277a67a03p+701,   -0x1.a6383755bbb85p-1,   0x1.6d791ap-2, INEXACT)
T(RN,  0x1.e07c48cb721f4p+701,   -0x1.f6feebd113f7ap-1,   0x1.fa9702p-4, INEXACT)
T(RN,  0x1.861927fe438b6p+702,    -0x1.a530a746fc56p-1,  -0x1.0eb99ep-5, INEXACT)
T(RN,  0x1.5fc7210aac6a8p+702,     0x1.1f0cf82b9e0ap-1,   0x1.dce528p-4, INEXACT)
T(RN,  0x1.1e24d403e14e1p+702,   -0x1.f717623fa187ap-1,  -0x1.bca9fcp-2, INEXACT)
T(RN,  0x1.5aa949e539342p+702,    0x1.186075bf346bap-1,   0x1.181034p-4, INEXACT)
T(RN,  0x1.25500f1cc70fdp+702,   -0x1.0b5da3b3af55ap-1,  -0x1.a83e6ap-3, INEXACT)
T(RN,  0x1.1686f98a49068p+702,    0x1.3e7f70d161fefp-1,   0x1.7599d8p-3, INEXACT)
T(RN,  0x1.38487179b810ep+702,   -0x1.b659392b89467p-1,     0x1.8d43p-3, INEXACT)
T(RN,   0x1.be24b8f3ae22p+702,   -0x1.c2d83224ec3fcp-1,  -0x1.145b98p-3, INEXACT)
T(RN,  0x1.808b5d0820dbap+702,   -0x1.69e20280c0ab7p-2,  -0x1.d957b2p-3, INEXACT)
T(RN,  0x1.afbcaf15498a6p+702,   -0x1.82cf191c0f26bp-2,  -0x1.9355f8p-2, INEXACT)
T(RN,  0x1.86aceae2c971fp+703,   -0x1.e0c6b316585cdp-1,   0x1.467ea8p-2, INEXACT)
T(RN,  0x1.4651fcdf5ae6ap+703,   -0x1.dd0f17cad51f1p-1,  -0x1.33dd34p-2, INEXACT)
T(RN,   0x1.7b3482c0f896p+703,   -0x1.b9063ecc3ae4ap-5,   0x1.11454ap-2, INEXACT)
T(RN,  0x1.174e1bd5da368p+703,   -0x1.e9c19720e72b6p-1,   0x1.c708b4p-2, INEXACT)
T(RN,  0x1.4c21ad2d6d706p+703,    0x1.be192e1cc83c9p-2,   0x1.6d50d8p-2, INEXACT)
T(RN,  0x1.1235c9286fd9fp+703,    0x1.3a1c854419923p-2,  -0x1.b9be88p-3, INEXACT)
T(RN,  0x1.bd94076cb3f42p+703,   -0x1.f75587929abf4p-3,   0x1.c0c228p-2, INEXACT)
T(RN,  0x1.6374d04cce647p+703,    0x1.ab6a7765a37f3p-1,  -0x1.4a7126p-3, INEXACT)
T(RN,  0x1.a8841d1c338e2p+703,    0x1.79d56918cc3bbp-1,   0x1.a132eep-2, INEXACT)
T(RN,  0x1.5eeaf2f378753p+703,   -0x1.df4d1a08732a3p-1,   0x1.c2a58ap-2, INEXACT)
T(RN,  0x1.a44ed28d0a06ep+704,   -0x1.3542ca242ad17p-2,  -0x1.af6b1ap-2, INEXACT)
T(RN,   0x1.0c1dc8ba7f33p+704,    0x1.67295a9f697c3p-1,   0x1.01749cp-2, INEXACT)
T(RN,  0x1.9a44460e58ed8p+704,   -0x1.3d83800473052p-1,   0x1.54da5ep-4, INEXACT)
T(RN,  0x1.b49ce3dcf05c4p+704,   -0x1.f7f84f012b147p-3,  -0x1.44864ap-4, INEXACT)
T(RN,  0x1.b05f4a1f18c85p+704,    0x1.f74c6aef4daa3p-3,  -0x1.b68ce6p-7, INEXACT)
T(RN,  0x1.3bf5290eb7a4ep+704,    0x1.5c47ef4baff1ap-1,   0x1.03f8a8p-2, INEXACT)
T(RN,  0x1.090ab4f7fff71p+704,    0x1.121abc1dea71cp-3,  -0x1.c16ff8p-2, INEXACT)
T(RN,  0x1.b7f1c2e6842fbp+704,    0x1.b05b3794a7e6bp-1,   -0x1.92754p-3, INEXACT)
T(RN,  0x1.72f9590e16304p+704,   -0x1.24e73c23e4c04p-1,    0x1.f8175p-3, INEXACT)
T(RN,  0x1.9b64a6aba3c62p+704,   -0x1.5eef185989413p-1,   0x1.6e65dep-3, INEXACT)
T(RN,  0x1.ac82cacab5762p+705,    0x1.b8c8849c9c60ap-1,   0x1.72489ep-2, INEXACT)
T(RN,  0x1.afa587ad5306ep+705,   -0x1.707cbd71e82f3p-2,   0x1.d9c512p-2, INEXACT)
T(RN,  0x1.964d70e1b9e2cp+705,   -0x1.0a050121b637dp-3,  -0x1.f09766p-2, INEXACT)
T(RN,  0x1.670ffbaae11d2p+705,   -0x1.e9d8f62719d35p-1,  -0x1.69a1f6p-4, INEXACT)
T(RN,  0x1.73258a29c6fbbp+705,    -0x1.fff400ccb067p-1,  -0x1.efdefep-7, INEXACT)
T(RN,  0x1.f12c3c360a024p+705,   -0x1.a4b2f10c0ece3p-4,  -0x1.cddd04p-3, INEXACT)
T(RN,  0x1.45c1e373b4712p+705,    0x1.b5677b8240836p-2,   0x1.bbda26p-3, INEXACT)
T(RN,  0x1.8520201b13f5ep+705,    0x1.2031e0fdcec19p-1,  -0x1.e1e46ep-3, INEXACT)
T(RN,  0x1.7f83a66dd6a2fp+705,   -0x1.d6c33b5cbc4f6p-1,   0x1.373d92p-2, INEXACT)
T(RN,  0x1.0b670d76b78f3p+705,   -0x1.c424821f7d672p-1,   0x1.99cd34p-2, INEXACT)
T(RN,  0x1.bb742500f545ep+706,    0x1.611efb005fcd5p-1,   0x1.c159c4p-2, INEXACT)
T(RN,  0x1.e206b4c1c6a7ap+706,    0x1.aad7786788d91p-2,   0x1.392374p-8, INEXACT)
T(RN,  0x1.b13d3fa251fd6p+706,   -0x1.a82769f86bdeep-1,   0x1.8ad026p-2, INEXACT)
T(RN,  0x1.2a96af522cd67p+706,   -0x1.650333764c445p-1,   0x1.7e1f62p-2, INEXACT)
T(RN,  0x1.85743e6c5c714p+706,    0x1.e9b2c355be7b1p-1,   0x1.ab8c88p-3, INEXACT)
T(RN,  0x1.130d1a0844944p+706,    0x1.035d941d4440fp-6,  -0x1.044db4p-3, INEXACT)
T(RN,  0x1.f7fc3563d4b21p+706,   -0x1.d244d7b46129cp-6,    -0x1.d4a1p-3, INEXACT)
T(RN,  0x1.994d627b1b5c5p+706,   -0x1.10f73594371f3p-1,  -0x1.c92348p-4, INEXACT)
T(RN,  0x1.6102a0736227cp+706,    0x1.74794c3ab981fp-4,   0x1.3dee58p-2, INEXACT)
T(RN,  0x1.0adc11f999864p+706,     0x1.ec26730cb867p-1,  -0x1.6953a6p-2, INEXACT)
T(RN,  0x1.15664ecc3eb1dp+707,   -0x1.f9a33135b84ebp-1,  -0x1.d9ed5ep-2, INEXACT)
T(RN,   0x1.2d5fde908b99p+707,   -0x1.1dcacb69ee9ddp-2,   0x1.3b190ap-2, INEXACT)
T(RN,  0x1.73b7c9c34a7e2p+707,   -0x1.fecf0c47deedep-1,   0x1.4d888ap-6, INEXACT)
T(RN,  0x1.74646680b7c98p+707,    0x1.fc02b3118370dp-1,   -0x1.4e4b1p-4, INEXACT)
T(RN,   0x1.bab8d12ccb62p+707,    0x1.a2a43c72fa785p-1,   0x1.1dc54cp-2, INEXACT)
T(RN,  0x1.d56f29f8b7fe2p+707,    0x1.8254136d9a66ep-1,  -0x1.c54ccep-2, INEXACT)
T(RN,  0x1.dbde5c7d61d42p+707,    0x1.f90d9ef903355p-1,  -0x1.c8e402p-3, INEXACT)
T(RN,  0x1.5cc9d379a28ecp+707,   -0x1.40f39617fa953p-1,   0x1.6f1372p-2, INEXACT)
T(RN,  0x1.d1914eeb95dccp+707,   -0x1.c1da1f827436ep-1,   0x1.6be2ccp-2, INEXACT)
T(RN,  0x1.f661fd24ecaf4p+707,   -0x1.39b76e807a043p-4,  -0x1.b77638p-2, INEXACT)
T(RN,  0x1.60cfafa77caccp+708,    0x1.ef109f2358dc1p-1,   0x1.c8e5bcp-4, INEXACT)
T(RN,  0x1.f9e0035052985p+708,    0x1.bf1c73517f8fap-1,   0x1.f5d97ap-2, INEXACT)
T(RN,  0x1.b1a225fb22a4bp+708,    0x1.e967bc8c0cea6p-1,  -0x1.a8a2cap-3, INEXACT)
T(RN,  0x1.0c0973ced6991p+708,    0x1.6184cbdf03b8fp-2,   0x1.592a84p-3, INEXACT)
T(RN,  0x1.6338e585b911ap+708,   -0x1.92fe446704575p-3,   0x1.b642e4p-2, INEXACT)
T(RN,  0x1.4a28f9d79daf8p+708,   -0x1.801d4a850fc13p-1,   0x1.073aa8p-4, INEXACT)
T(RN,  0x1.9dbc4093a42a8p+708,    0x1.a82368c4415b5p-5,    0x1.8824fp-2, INEXACT)
T(RN,  0x1.787d59762f7adp+708,   -0x1.263a3e41874d1p-1,  0x1.afb54ep-10, INEXACT)
T(RN,  0x1.c87c35ca49a01p+708,   -0x1.ffffffe56fe47p-1,   -0x1.3095dp-3, INEXACT)
T(RN,  0x1.9418b7240b182p+708,   -0x1.44c6d21690164p-1,   -0x1.d576fp-2, INEXACT)
T(RN,  0x1.8d2576b674858p+709,   -0x1.e26511c2ca567p-1,   0x1.094ea8p-2, INEXACT)
T(RN,  0x1.2d1a3ae8a65b2p+709,   -0x1.13b16dac3d918p-3,  -0x1.996622p-3, INEXACT)
T(RN,   0x1.96f24740789ep+709,    0x1.e508f1f33fda2p-1,  -0x1.429ae6p-2, INEXACT)
T(RN,  0x1.aedd7f0ddc9a6p+709,    0x1.fd7b99f6da12fp-1,  -0x1.754a98p-3, INEXACT)
T(RN,   0x1.4762a73f1ab5p+709,   -0x1.11a137235b685p-1,   0x1.3af20cp-2, INEXACT)
T(RN,  0x1.6b67fcd62ef14p+709,    0x1.ec417797e0181p-1,   0x1.287282p-4, INEXACT)
T(RN,  0x1.ad5a88d9bff62p+709,    0x1.d510c3d0a64c6p-1,   0x1.aeae2cp-2, INEXACT)
T(RN,  0x1.061926b107dadp+709,    0x1.c0b002feb3f45p-1,   0x1.df9066p-2, INEXACT)
T(RN,  0x1.6ec6c006acafcp+709,   -0x1.99b780917aa88p-1,  -0x1.49bf28p-2, INEXACT)
T(RN,  0x1.f96cc3c2a6f8ep+709,     0x1.4f19c4a354d6p-1,  -0x1.cb9054p-3, INEXACT)
T(RN,  0x1.220b149eb63d4p+710,    0x1.dee0aff0510cbp-1,   0x1.833f98p-5, INEXACT)
T(RN,  0x1.677f584632c78p+710,   -0x1.fa92f088f3fe9p-1,   0x1.cc8fccp-2, INEXACT)
T(RN,  0x1.039406964d614p+710,    0x1.a284439040e48p-1,  -0x1.5c7ebap-2, INEXACT)
T(RN,  0x1.f58005d4b4094p+710,   -0x1.f0b3662206299p-1,  -0x1.a3d026p-2, INEXACT)
T(RN,  0x1.6b10b53467b4ap+710,    0x1.1ae7589fcfae1p-1,  -0x1.80e42cp-4, INEXACT)
T(RN,  0x1.4a43b18d8e4afp+710,    0x1.d2cc63b816766p-1,   0x1.dd3a0ep-2, INEXACT)
T(RN,  0x1.781de48c3d76cp+710,    0x1.ffbb0e3e41713p-1,   -0x1.c18c5p-3, INEXACT)
T(RN,  0x1.4c7a0c5af1276p+710,    0x1.d2a6034df6468p-1,   0x1.5f8c0ep-5, INEXACT)
T(RN,  0x1.bcfd7777a3424p+710,     0x1.40da0ecbbb24p-1,  -0x1.9b6f66p-5, INEXACT)
T(RN,  0x1.c4f9c0d6ac387p+710,    -0x1.a05f1427900dp-1,    0x1.21b58p-7, INEXACT)
T(RN,  0x1.2035eb83c2202p+711,   -0x1.3f6f7c0e6996ep-7,  -0x1.a79ff4p-3, INEXACT)
T(RN,  0x1.10be37d85c34bp+711,   -0x1.a3c088721d537p-5,   0x1.b0d65cp-2, INEXACT)
T(RN,  0x1.6878edb52cb04p+711,    0x1.b6404638b2017p-1,   0x1.a64938p-3, INEXACT)
T(RN,  0x1.082455c34272dp+711,    0x1.1689881ba6df9p-1,  -0x1.cba698p-4, INEXACT)
T(RN,  0x1.a0e6c20b04624p+711,   -0x1.2fee59937cd48p-2,   0x1.0d455ap-2, INEXACT)
T(RN,  0x1.5d36ba5494d54p+711,   -0x1.625a1bc593652p-1,   0x1.fb7176p-4, INEXACT)
T(RN,  0x1.c073e80836ef8p+711,   -0x1.ff619c5286a36p-1,  -0x1.fb7beep-2, INEXACT)
T(RN,  0x1.23d21530acc41p+711,   -0x1.a5515b3b6c226p-2,   0x1.a8cb98p-4, INEXACT)
T(RN,  0x1.1c978f2786e21p+711,   -0x1.62d5fb2dbaa9cp-2,  -0x1.4079eep-2, INEXACT)
T(RN,   0x1.748c121b3048p+711,   -0x1.faf8182e5efc2p-1,   0x1.44dcb2p-2, INEXACT)
T(RN,  0x1.e79c45869e387p+712,   -0x1.d29c2cfe9f9fep-1,   0x1.b64be8p-3, INEXACT)
T(RN,   0x1.5fa9ac8f7a05p+712,    0x1.036ec9bc55373p-1,   0x1.ba6316p-2, INEXACT)
T(RN,  0x1.9000bb0fbebf6p+712,    0x1.ff85db4f97607p-1,  -0x1.28a2f2p-4, INEXACT)
T(RN,  0x1.beb24afdbb32cp+712,    0x1.9eca25d8247fbp-1,   0x1.538234p-3, INEXACT)
T(RN,  0x1.d08e6c7710b88p+712,   -0x1.1f36313b515b2p-1,   0x1.834bd2p-4, INEXACT)
T(RN,  0x1.8f1b91cd6847ep+712,   -0x1.fac890ce04047p-1,   0x1.b60838p-2, INEXACT)
T(RN,  0x1.f724076db2f3bp+712,    0x1.91890746f8865p-2,   0x1.1ae986p-7, INEXACT)
T(RN,  0x1.26325169b58b8p+712,   -0x1.e701e0388c277p-3,   -0x1.ceac2p-3, INEXACT)
T(RN,  0x1.1f8109033cfbep+712,   -0x1.61bac15a0f28ap-3,  -0x1.80b61ap-2, INEXACT)
T(RN,  0x1.ab2c120dbed52p+712,   -0x1.1bf6e8efe9db9p-2,   0x1.2a158ap-3, INEXACT)
T(RN,  0x1.c74ee5164c2b8p+713,   -0x1.dcf31d701141cp-1,  -0x1.b36a26p-5, INEXACT)
T(RN,  0x1.4aaabe4239faap+713,     0x1.f938f98ec8a2p-1,   0x1.bb9716p-2, INEXACT)
T(RN,  0x1.e6b50191e9bf2p+713,   -0x1.e116bcc833d1fp-1,  -0x1.d792c2p-3, INEXACT)
T(RN,  0x1.0df4b4c5aaeaap+713,     0x1.d0f8eba2af8ap-3,  -0x1.cbe86cp-2, INEXACT)
T(RN,  0x1.64b5c9e800576p+713,   -0x1.fda07bde429e8p-1,  -0x1.aee54ap-2, INEXACT)
T(RN,  0x1.fce01e23e50dep+713,     0x1.2351e7364913p-2,   0x1.6b063ep-2, INEXACT)
T(RN,   0x1.b62776299656p+713,   -0x1.14b021bcd6bbfp-2,   0x1.bed2ccp-6, INEXACT)
T(RN,  0x1.e5584ec01326bp+713,   -0x1.431eba378e893p-3,   -0x1.edfd2p-5, INEXACT)
T(RN,  0x1.9d222c801086ap+713,   -0x1.ecefe485996e9p-2,   -0x1.6d1dfp-2, INEXACT)
T(RN,  0x1.f320203fde348p+713,   -0x1.faccd20a2875fp-1,    0x1.0dcbap-2, INEXACT)
T(RN,  0x1.7e5f71658ea9ep+714,    0x1.d77172aaa0823p-1, -0x1.be623cp-10, INEXACT)
T(RN,  0x1.18072fdf46b46p+714,    0x1.ee2e6bbbb1b31p-1,  -0x1.4ecca2p-3, INEXACT)
T(RN,  0x1.c503e604bbd2ep+714,   -0x1.739a0fc921e9dp-2,   0x1.61e2c6p-2, INEXACT)
T(RN,  0x1.ba5b53b8c31aap+714,    0x1.edbb58063b43fp-1,  -0x1.f9bb4ap-4, INEXACT)
T(RN,   0x1.da8a5ecdc04ap+714,    0x1.7a85973ad2344p-4,    0x1.ebaaep-2, INEXACT)
T(RN,  0x1.27c4d3c935b77p+714,    0x1.c242a1f24929dp-1,    0x1.e146cp-2, INEXACT)
T(RN,  0x1.5db2e889ef802p+714,   -0x1.03dce5df3167ep-1,   0x1.5fd40ep-3, INEXACT)
T(RN,  0x1.9a98ec05adf7cp+714,    0x1.58dd7439817d8p-1,   0x1.e5b218p-2, INEXACT)
T(RN,  0x1.6aeffdf9d4303p+714,    0x1.e685f8c2b625bp-1,  -0x1.fd287ep-3, INEXACT)
T(RN,  0x1.e6013b7eea413p+714,     0x1.6722636253afp-1,  -0x1.aa3c98p-2, INEXACT)
T(RN,  0x1.f153e95c71222p+715,   -0x1.ff75a7e1180e2p-1,   -0x1.78d75p-3, INEXACT)
T(RN,  0x1.730ae1ad2b662p+715,    0x1.a72d35f4b4fb6p-2,   0x1.0fb44ap-2, INEXACT)
T(RN,  0x1.1abd4fd3b3c29p+715,    0x1.1264532beff5dp-4,  -0x1.fd7ed8p-2, INEXACT)
T(RN,  0x1.cfbe8cc1a7776p+715,   -0x1.f98479b670cb6p-1,  -0x1.831ac8p-4, INEXACT)
T(RN,  0x1.3d6070fec85a9p+715,    -0x1.4f6d630ce842p-3,   0x1.2d4ed6p-2, INEXACT)
T(RN,  0x1.375ee082daa03p+715,   -0x1.8b8f998cf7c4ep-1,  -0x1.30d7a4p-3, INEXACT)
T(RN,  0x1.d556bdc1015eep+715,   -0x1.b0c0e774508dep-4,   -0x1.6b519p-3, INEXACT)
T(RN,   0x1.98323f2ef875p+715,    0x1.2890d4e8d161fp-1,   0x1.a006ccp-5, INEXACT)
T(RN,  0x1.c1248f3442bc1p+715,    0x1.b4bbf950193a9p-1,    0x1.b47fap-2, INEXACT)
T(RN,  0x1.737a9ede40568p+715,    0x1.ad371987c9e97p-4,  -0x1.1bea0cp-5, INEXACT)
T(RN,  0x1.c3e599ee1449ap+716,    0x1.0f8a6c2f13dbcp-2,  -0x1.0716a6p-6, INEXACT)
T(RN,  0x1.4b123aaffeed5p+716,   -0x1.a07cdaceefe93p-1,   0x1.9f45d8p-2, INEXACT)
T(RN,  0x1.71fe3a5a5cff7p+716,    0x1.9b11f6f235441p-1,   -0x1.77dd6p-3, INEXACT)
T(RN,   0x1.31f957149ca1p+716,   -0x1.ec9324f33c00fp-1,    0x1.ffef2p-2, INEXACT)
T(RN,  0x1.78ae11190d154p+716,   -0x1.c65f855ba92c4p-1,    0x1.5f129p-3, INEXACT)
T(RN,  0x1.4776551617c21p+716,    0x1.5ddf94cca48fdp-2,  -0x1.e454b2p-6, INEXACT)
T(RN,  0x1.779a1f54205a6p+716,    0x1.c5698177df2f3p-1,   0x1.d1cba4p-3, INEXACT)
T(RN,  0x1.7ff35cff35f78p+716,    0x1.80cb64008a3d1p-1,  -0x1.da251ep-3, INEXACT)
T(RN,  0x1.b2dc78450e33fp+716,   -0x1.83f077c7f3e59p-2,   0x1.199bfap-2, INEXACT)
T(RN,  0x1.ab7c36bfac065p+716,   -0x1.f787b2509811fp-1,   0x1.3545b2p-4, INEXACT)
T(RN,  0x1.55d3d0f505efcp+717,   -0x1.92952ef55661ep-2,   0x1.658324p-7, INEXACT)
T(RN,  0x1.bc6662f6632dep+717,   -0x1.3d1ade4d4e9dbp-3,   -0x1.36e83p-2, INEXACT)
T(RN,  0x1.048bdc7ee9597p+717,   -0x1.ecaee6e16d282p-1,   0x1.9889fep-2, INEXACT)
T(RN,    0x1.874b46804d5p+717,   -0x1.fc5022a7babaap-2,   0x1.895636p-6, INEXACT)
T(RN,  0x1.e4a3e7102ab36p+717,   -0x1.80ec2b68fcaa4p-1,  -0x1.1c7f02p-4, INEXACT)
T(RN,  0x1.571a572de53d1p+717,    0x1.4ee6fe7e55826p-1,    0x1.675ebp-2, INEXACT)
T(RN,  0x1.7d2b9d10ba001p+717,    0x1.dd5ae9b667316p-1,  -0x1.6114ccp-5, INEXACT)
T(RN,  0x1.22d70d39f434dp+717,    0x1.8cfcc03665b5bp-2,  -0x1.5b0d7cp-3, INEXACT)
T(RN,  0x1.b8f5d76b9bfa4p+717,    -0x1.0be45900763dp-2,  -0x1.66beb2p-5, INEXACT)
T(RN,   0x1.28c8dd0acc02p+717,    0x1.a670be03593abp-3,   -0x1.87a35p-3, INEXACT)
T(RN,  0x1.109eef9baf142p+718,   -0x1.62958a6da8d78p-1,   0x1.d42a18p-2, INEXACT)
T(RN,  0x1.625f91607f3ecp+718,    0x1.b68cd73b38c7fp-1,   0x1.21be12p-3, INEXACT)
T(RN,  0x1.8b90d056fed2ep+718,    0x1.c49a03137076ap-3,  -0x1.8252b8p-3, INEXACT)
T(RN,  0x1.6253a7784c20ap+718,    0x1.f9e389d6459fbp-1,   0x1.83d67ap-3, INEXACT)
T(RN,  0x1.7d45951713649p+718,    0x1.ffca2991c40f5p-1,   0x1.2cfe08p-4, INEXACT)
T(RN,  0x1.cc04d5a8a2897p+718,   -0x1.fd5a4e63a6d44p-1,   -0x1.d9b33p-2, INEXACT)
T(RN,  0x1.9cfd90b3354c6p+718,    0x1.f807eacaf48b5p-1,   0x1.cbeb6ep-2, INEXACT)
T(RN,  0x1.8f4a6a8f48132p+718,    0x1.fc8fffd62b4cep-1,  -0x1.6e1d1ep-2, INEXACT)
T(RN,  0x1.fb4366e905583p+718,    0x1.c40679a3cedf4p-1,  -0x1.54241ep-2, INEXACT)
T(RN,  0x1.d9bfb879ab30ep+718,    0x1.d8b520a9439ebp-1,  -0x1.5aabbap-2, INEXACT)
T(RN,  0x1.2d0f126ff6cd8p+719,    -0x1.3093547c2987p-1,   -0x1.2c556p-3, INEXACT)
T(RN,  0x1.ba428c270e6ecp+719,    0x1.642b942a17779p-1,   0x1.1bb882p-2, INEXACT)
T(RN,  0x1.7f70d0496321cp+719,   -0x1.7c95ea1e1558ap-1,  -0x1.02f766p-2, INEXACT)
T(RN,  0x1.3685f55d05985p+719,   -0x1.358beec32cdf4p-1,  -0x1.8dd428p-4, INEXACT)
T(RN,  0x1.31b7260bfed69p+719,   -0x1.3ad2c781161f1p-1,  -0x1.eb6098p-4, INEXACT)
T(RN,  0x1.7e4e003b72036p+719,   -0x1.66f7f63a535f9p-2,  -0x1.8c2132p-5, INEXACT)
T(RN,  0x1.9eb28721c5314p+719,    0x1.bece383232b4ep-1,  -0x1.70bf26p-4, INEXACT)
T(RN,  0x1.a3d2e24af79bap+719,   -0x1.b6cfd77730d0cp-1,   -0x1.0859dp-2, INEXACT)
T(RN,  0x1.41dbf3c9527eep+719,    0x1.c06010cac5e41p-1,   0x1.7705b6p-2, INEXACT)
T(RN,  0x1.8d0bebc751f43p+719,   -0x1.a63cbfd54da1ap-2,   0x1.7e8396p-4, INEXACT)
T(RN,  0x1.9fdb46f10a405p+720,    -0x1.cf3ec0b12f2fp-1,  -0x1.370638p-2, INEXACT)
T(RN,   0x1.c171088d658ap+720,    0x1.048c9a8f794b7p-2,  -0x1.4627a4p-4, INEXACT)
T(RN,   0x1.110dfdd47112p+720,   -0x1.2bef94aa51769p-2,   0x1.98ca3ap-2, INEXACT)
T(RN,  0x1.dea8aa6d2ccc2p+720,    0x1.e17852ac103cbp-1,  -0x1.995bfap-4, INEXACT)
T(RN,  0x1.94937107bb336p+720,   -0x1.f6fe39ab163dep-1,    0x1.f7dcdp-2, INEXACT)
T(RN,  0x1.07cedd1f2b746p+720,   -0x1.ad6c6b63215ddp-1,   0x1.8078d4p-2, INEXACT)
T(RN,  0x1.b48c5bfc97b2ep+720,    0x1.eb60ebb5d679fp-1,   0x1.90564cp-3, INEXACT)
T(RN,   0x1.72e9c5dd0186p+720,   -0x1.ff30c8274d741p-1,   0x1.7ccef8p-2, INEXACT)
T(RN,   0x1.9caf4102b4cdp+720,   -0x1.3b2033041ad72p-1,   -0x1.d2627p-2, INEXACT)
T(RN,  0x1.791809d0e7feap+720,    0x1.6450084d0526ep-1,    0x1.67bffp-2, INEXACT)
T(RN,  0x1.75ed71c6854dcp+721,    0x1.13d33a4b5c3efp-2,  -0x1.bdb204p-2, INEXACT)
T(RN,  0x1.8b6a0360c1e36p+721,    0x1.3d67c971a27bap-1,   0x1.5aeca4p-2, INEXACT)
T(RN,  0x1.6e892360a0144p+721,    0x1.a635d85147fe9p-1,   0x1.e18894p-3, INEXACT)
T(RN,  0x1.2bccfb414c19ap+721,   -0x1.d693b0b3669ebp-1,   0x1.fb1e54p-2, INEXACT)
T(RN,  0x1.1ca9ce429aa62p+721,    0x1.855c0b6c6e6d2p-2,   0x1.dcf9eap-3, INEXACT)
T(RN,  0x1.22b141c86b227p+721,   -0x1.fd0a36265ed42p-2,   0x1.a5c8c2p-3, INEXACT)
T(RN,  0x1.07413d29bab75p+721,   -0x1.f8c874d3120e5p-4,   -0x1.fe63ap-4, INEXACT)
T(RN,  0x1.60f773b0e2c37p+721,   -0x1.18af798c96027p-1,  -0x1.f66bc2p-2, INEXACT)
T(RN,  0x1.2d12ccf416d3dp+721,    0x1.9b666b8115924p-4,   0x1.52a168p-2, INEXACT)
T(RN,  0x1.af17ff12dbfd2p+721,   -0x1.515116bc6db91p-5,  -0x1.8ad462p-7, INEXACT)
T(RN,  0x1.48b5de5572ab4p+722,   -0x1.f6de12b44034fp-1,     0x1.7dd2p-2, INEXACT)
T(RN,  0x1.6d7e82d90f35cp+722,    0x1.f11f42bb29e81p-1,   0x1.5ac1ecp-5, INEXACT)
T(RN,  0x1.c8150bb6e7c98p+722,   -0x1.cbee4bd659882p-1,  -0x1.53ddb2p-2, INEXACT)
T(RN,  0x1.1df96515abbdap+722,   -0x1.fffff556b5adcp-1,   0x1.db3b3ep-4, INEXACT)
T(RN,  0x1.36adec502fe37p+722,    0x1.e853569682de5p-1,  -0x1.b285b8p-3, INEXACT)
T(RN,  0x1.71ed4666c21b6p+722,   -0x1.65f1f77584974p-1,    0x1.d0299p-2, INEXACT)
T(RN,   0x1.d8c133d81bffp+722,   -0x1.ade347142914ep-2,   0x1.ca7934p-2, INEXACT)
T(RN,  0x1.e4746c2967e9fp+722,    0x1.f614566f2c25ep-1,  -0x1.585d7ap-2, INEXACT)
T(RN,  0x1.2965d3fff56cap+722,    0x1.2ed2a96652c9fp-4,   0x1.59a7d8p-3, INEXACT)
T(RN,  0x1.537971022be2ap+722,   -0x1.7d044cc64c6aep-1,  -0x1.70c0c4p-8, INEXACT)
T(RN,  0x1.3a53e1f314223p+723,   -0x1.04ce291882bafp-1,  -0x1.d99ee8p-2, INEXACT)
T(RN,  0x1.0115cf57f9308p+723,    0x1.ffa39809847e4p-1,   0x1.4e837ap-3, INEXACT)
T(RN,  0x1.41fcd92ddf8e1p+723,     0x1.ea8ae5e6d11dp-1,  -0x1.9d61fep-2, INEXACT)
T(RN,  0x1.fd19ecfaaa51bp+723,   -0x1.1f480463af157p-1,    0x1.63563p-2, INEXACT)
T(RN,  0x1.8a0a5b56237eep+723,   -0x1.e403c179a4cc5p-1,  -0x1.9cd97cp-4, INEXACT)
T(RN,  0x1.3b853855e56e4p+723,   -0x1.f2b6688a70641p-1,    0x1.6d142p-2, INEXACT)
T(RN,  0x1.52a01ba8ff924p+723,   -0x1.8d72c04b5f79fp-1,   0x1.95ef14p-2, INEXACT)
T(RN,  0x1.7b6cbefd6766cp+723,    0x1.b61ede985d465p-2,   0x1.116b7cp-2, INEXACT)
T(RN,   0x1.83e5f3c77e0ep+723,   -0x1.46f0173c8e03cp-1,  -0x1.141e34p-4, INEXACT)
T(RN,  0x1.e9c1f8551125ap+723,     0x1.53b079d5491bp-1,   0x1.cef354p-2, INEXACT)
T(RN,  0x1.5ed702db637ecp+724,    0x1.d741b4fedfb62p-1,   0x1.f3f05ap-4, INEXACT)
T(RN,  0x1.871ef0863a952p+724,    -0x1.416773d9f8ccp-1,  -0x1.afaff8p-2, INEXACT)
T(RN,  0x1.8567cd9614b22p+724,    0x1.05ef224718a71p-2,   0x1.597586p-2, INEXACT)
T(RN,  0x1.e21c2ba2b6cbbp+724,    0x1.e7b1274ac09f8p-2,  -0x1.965818p-6, INEXACT)
T(RN,  0x1.32b048efff27ap+724,    0x1.79aaee4e8ca04p-1,   -0x1.08dcbp-3, INEXACT)
T(RN,   0x1.657e4d60131bp+724,    0x1.45537679e7673p-3,   0x1.c9a7b2p-2, INEXACT)
T(RN,  0x1.6b57455fecb47p+724,   -0x1.f6894de3aff6ep-1,   -0x1.c6b22p-2, INEXACT)
T(RN,  0x1.63b0e97dda735p+724,   -0x1.925b9ba5234cbp-1,  -0x1.f44e22p-2, INEXACT)
T(RN,  0x1.12d1a9bfcf8b2p+724,    0x1.3c419c38174e1p-3,   0x1.72ff98p-2, INEXACT)
T(RN,   0x1.b90b216c841ap+724,    0x1.9f58808127c9ap-1,  -0x1.8b9d2ep-3, INEXACT)
T(RN,  0x1.9eae8390d993cp+725,    0x1.207b128eb83a8p-1,   0x1.c825d2p-2, INEXACT)
T(RN,  0x1.9c418854f7026p+725,    0x1.a7d27abf63277p-6,  -0x1.b6a744p-2, INEXACT)
T(RN,  0x1.54660a84f816ep+725,   -0x1.b83aadaedaac7p-1,  -0x1.6f2aaep-2, INEXACT)
T(RN,  0x1.ea47f80e270bep+725,   -0x1.ffc7acb06ed58p-1,   -0x1.90124p-2, INEXACT)
T(RN,  0x1.bdac9b84aabc8p+725,    0x1.9c02251ad3233p-1,  -0x1.64edf6p-2, INEXACT)
T(RN,  0x1.b15ae12f8a35bp+725,     0x1.10663f4b148bp-3,   0x1.977ebcp-4, INEXACT)
T(RN,  0x1.c43e87e954342p+725,    0x1.aaca19f6a91f4p-2,  -0x1.18329ap-2, INEXACT)
T(RN,  0x1.1a8488975e055p+725,    -0x1.e5d1684835b9p-2,   0x1.8bac02p-2, INEXACT)
T(RN,  0x1.3f810e3e54d09p+725,    -0x1.cf2d4c276dfcp-1,  -0x1.4ca788p-4, INEXACT)
T(RN,  0x1.e8ab68df85916p+725,    0x1.fcebc9be6b64cp-1,    0x1.8bc45p-2, INEXACT)
T(RN,  0x1.eb8a199e5d297p+726,   -0x1.4a03a1e7047d9p-1,   0x1.c801b6p-6, INEXACT)
T(RN,  0x1.5dfa1e0a33b37p+726,   -0x1.e9d77918fc6afp-3,   0x1.bdb502p-6, INEXACT)
T(RN,  0x1.de6c82cac2f1ap+726,    0x1.1c2a7b5ffe616p-3,  -0x1.c92a24p-3, INEXACT)
T(RN,  0x1.269cea388a857p+726,   -0x1.f426861a0d5acp-1,    0x1.267dap-4, INEXACT)
T(RN,  0x1.77066a2f000e3p+726,   -0x1.203be42d29e89p-4,  -0x1.655d7ap-3, INEXACT)
T(RN,   0x1.9cef11d2016ep+726,   -0x1.24d93137091e5p-1,   0x1.698ebcp-2, INEXACT)
T(RN,  0x1.d7718d15bddd4p+726,    0x1.abdbeaa3732dbp-5,  -0x1.54fcf4p-2, INEXACT)
T(RN,  0x1.cc6199f6ca2ccp+726,    0x1.d07fb0f579902p-4,  -0x1.890bc2p-3, INEXACT)
T(RN,  0x1.6866f61ef5b51p+726,   -0x1.8cc984c4daa95p-2,   0x1.438e9ep-3, INEXACT)
T(RN,  0x1.6c5689d111b61p+726,   -0x1.ed022621b05e8p-1,   0x1.215c9ep-2, INEXACT)
T(RN,  0x1.dd712a9f8f267p+727,   -0x1.d6e40ef25ccefp-1,  -0x1.1a4f78p-4, INEXACT)
T(RN,  0x1.ae698cf6061f8p+727,    0x1.03129316d4c3dp-2,  -0x1.5a1124p-2, INEXACT)
T(RN,  0x1.89f6ce45b6592p+727,   -0x1.fcd32c7485105p-1,   0x1.20e0dep-2, INEXACT)
T(RN,   0x1.37bae1e98f31p+727,   -0x1.15ee9999f0ed6p-2,   -0x1.9af6ap-3, INEXACT)
T(RN,  0x1.6ec439f904614p+727,     0x1.2c0adf6d7a1ap-1,  -0x1.6ba166p-3, INEXACT)
T(RN,  0x1.53bdd91de8f9ep+727,   -0x1.ee10474cabc84p-2,    0x1.29481p-3, INEXACT)
T(RN,   0x1.c621bb3c9a5ep+727,    0x1.8d081216d01d9p-2,    0x1.66be8p-3, INEXACT)
T(RN,  0x1.0b338afd36291p+727,   -0x1.7a99af3edc52bp-7,   0x1.129ac8p-4, INEXACT)
T(RN,   0x1.8527341995d3p+727,    0x1.4767d17d08307p-1,    0x1.b51ecp-2, INEXACT)
T(RN,  0x1.504bc5a053aadp+727,   -0x1.f535d0bfa5251p-1,  -0x1.f6beacp-2, INEXACT)
T(RN,  0x1.85da660f14c4bp+728,    0x1.1c1f9755c1176p-1,  -0x1.905d4cp-5, INEXACT)
T(RN,  0x1.46e5398dc41a4p+728,    0x1.5b5a3b316cc8ap-2,  -0x1.5ba916p-2, INEXACT)
T(RN,   0x1.3f5413ff76f4p+728,    0x1.9cb0de84e9fc6p-2,  -0x1.6e3f3ap-2, INEXACT)
T(RN,  0x1.5f4eaef15fe08p+728,    0x1.7b8b72d3c0e9bp-1,   0x1.a70a8ap-3, INEXACT)
T(RN,  0x1.393de0834d873p+728,   -0x1.3a22f64afd999p-1,  -0x1.fbb01cp-3, INEXACT)
T(RN,  0x1.b23502e1bf891p+728,   -0x1.9c2d2bbf57eb2p-1,  -0x1.591928p-3, INEXACT)
T(RN,  0x1.b78d943da4941p+728,   -0x1.01bb18bff0094p-2,   0x1.bb5a72p-4, INEXACT)
T(RN,  0x1.c0a2148ba52a8p+728,    0x1.c6a7b2b2573ffp-2,    0x1.28f08p-2, INEXACT)
T(RN,  0x1.fbba0280f6085p+728,    0x1.aaa146969417ap-2,   0x1.5a8238p-2, INEXACT)
T(RN,  0x1.45fce5450217bp+728,    0x1.7496100cc551fp-1,  -0x1.0e6b0cp-3, INEXACT)
T(RN,  0x1.a7bce357a9fbap+729,   -0x1.609abc8df5c35p-1,    0x1.b819dp-3, INEXACT)
T(RN,   0x1.450cb044b96bp+729,    0x1.ec3a9e2460abfp-5,   0x1.7865e4p-2, INEXACT)
T(RN,  0x1.0ae8472c7f0e3p+729,   -0x1.0c1e98b5bef5dp-3,   0x1.16d468p-4, INEXACT)
T(RN,  0x1.37009f136b618p+729,    0x1.e1c292bc08c6fp-1,  -0x1.5ba07ap-2, INEXACT)
T(RN,  0x1.a82f447117f12p+729,   -0x1.e679d7fa6c429p-1,   -0x1.5624fp-2, INEXACT)
T(RN,  0x1.9b972024c559ap+729,    0x1.3ed7797ce66f2p-1,  -0x1.5b5a4ap-3, INEXACT)
T(RN,  0x1.9ed9c41f17f7ep+729,   -0x1.1d8e553e6638fp-2,   0x1.f6839ep-2, INEXACT)
T(RN,  0x1.b458478d7d8a2p+729,   -0x1.e76c834822c2ep-4,  -0x1.1d9b6ep-2, INEXACT)
T(RN,  0x1.172e41f590ba9p+729,   -0x1.20a7479b284d3p-3,   0x1.f8c544p-2, INEXACT)
T(RN,  0x1.20aec46a8c1bcp+729,   -0x1.182112262e975p-1,  -0x1.ff62c2p-2, INEXACT)
T(RN,  0x1.1002683fa053cp+730,   -0x1.81cc3ff9b4c46p-1,   0x1.375236p-2, INEXACT)
T(RN,  0x1.3c23bc9fa082ep+730,   -0x1.06aa38519227dp-2,   0x1.7c86f2p-2, INEXACT)
T(RN,  0x1.fb604836acaa8p+730,    0x1.7e2b5634740d9p-2,   0x1.6f9d76p-2, INEXACT)
T(RN,  0x1.42253e683356cp+730,    0x1.c86f44b5b9478p-1,  -0x1.c3973ep-2, INEXACT)
T(RN,  0x1.59a349e3b1314p+730,   -0x1.e92898c44f55bp-2,  -0x1.99ebd8p-2, INEXACT)
T(RN,  0x1.f16a19db3ca6ep+730,    0x1.e32d53d955b6cp-1,  -0x1.ee7e22p-2, INEXACT)
T(RN,   0x1.241815a87fa7p+730,   -0x1.a2419e7e6f719p-1,    0x1.bc1bcp-4, INEXACT)
T(RN,  0x1.112a68a54b19dp+730,   -0x1.e26d0605da24ep-1,   0x1.baa114p-2, INEXACT)
T(RN,  0x1.28ab34d1deb4ap+730,   -0x1.6c51909296c11p-1,  -0x1.48fba6p-4, INEXACT)
T(RN,   0x1.7535e96dbce6p+730,   -0x1.95d9b413ee1cdp-1,  -0x1.8fad3ap-2, INEXACT)
T(RN,  0x1.7801c46e1c839p+731,   -0x1.4d38c893c5ddap-3,  -0x1.47c77ap-5, INEXACT)
T(RN,  0x1.15aad82486836p+731,   -0x1.2d72cac1b894cp-3,   0x1.e68932p-3, INEXACT)
T(RN,  0x1.c1b3c591df334p+731,   -0x1.49ecd00afbec5p-1,   0x1.e98ef6p-3, INEXACT)
T(RN,  0x1.2f5452d20c1dep+731,    0x1.8d29d9a20199cp-1,  -0x1.ea1204p-2, INEXACT)
T(RN,  0x1.d1518ec78e06ep+731,   -0x1.29ed34e097801p-1,   0x1.69e252p-2, INEXACT)
T(RN,  0x1.9c4ed6118de08p+731,   -0x1.388a2af2d702dp-1,  -0x1.b26964p-4, INEXACT)
T(RN,  0x1.bdf252a5b5473p+731,   -0x1.f2d2d21eb8112p-1,  -0x1.3a4b9ep-2, INEXACT)
T(RN,    0x1.931eda32345p+731,   -0x1.da331446671b7p-1,  -0x1.a831e2p-3, INEXACT)
T(RN,  0x1.763e4716b2eefp+731,    0x1.3932681a8026bp-1,   0x1.25e85cp-2, INEXACT)
T(RN,  0x1.473a54d7f3812p+731,    0x1.7907bec6c9eeap-3,  -0x1.8dfc68p-3, INEXACT)
T(RN,   0x1.13bdc09a5722p+732,   -0x1.fe61e2b93653bp-1,   -0x1.394d6p-3, INEXACT)
T(RN,  0x1.47887cf030aeep+732,    0x1.fb1cc2cf86c89p-1,  -0x1.b54f7ap-3, INEXACT)
T(RN,  0x1.1fc8a3ed0e3e4p+732,    0x1.ffd857b1bcf3cp-1,   0x1.91920ep-2, INEXACT)
T(RN,  0x1.090cd817ff50fp+732,   -0x1.4ca9adabd4dc5p-3,   0x1.b30fa2p-2, INEXACT)
T(RN,  0x1.444d073539155p+732,     0x1.a157a5cfc09ap-1,  -0x1.9e2eb8p-2, INEXACT)
T(RN,   0x1.e1c29c888865p+732,    0x1.a452ffc5ef3a8p-2,  -0x1.d61506p-8, INEXACT)
T(RN,   0x1.39ec054d87cap+732,    0x1.eeded687dabaap-1,   0x1.c9f944p-2, INEXACT)
T(RN,  0x1.5d1fa88bab7ebp+732,    0x1.d2c0b15dc090cp-1,   0x1.26136ap-2, INEXACT)
T(RN,  0x1.d59feb212aa89p+732,    0x1.fa31d88f41455p-4,  -0x1.2d3cd8p-4, INEXACT)
T(RN,  0x1.5d499cc67e2b8p+732,    0x1.d21e006d4f15bp-2,   0x1.a69d9ep-5, INEXACT)
T(RN,   0x1.987cb194df7cp+733,   -0x1.cf869afd8f235p-1,  -0x1.44be3cp-5, INEXACT)
T(RN,  0x1.d99668b7a15dfp+733,   -0x1.6d53f4f4b348ep-1,   0x1.854038p-3, INEXACT)
T(RN,  0x1.946041c6932c7p+733,    0x1.4582fe2fcf0aep-1,   0x1.0bcae8p-6, INEXACT)
T(RN,  0x1.e6ce4a11f66b9p+733,   -0x1.d1f77c3527091p-1,   0x1.cbccc4p-5, INEXACT)
T(RN,  0x1.8a1ee31d90ea8p+733,     0x1.b9e983be1307p-2,   -0x1.cbccap-2, INEXACT)
T(RN,  0x1.7f9b933524803p+733,    0x1.fed29ad996547p-1,  -0x1.1cfc48p-2, INEXACT)
T(RN,  0x1.2e647dd78d083p+733,    0x1.ffffd2ed515f5p-1,  -0x1.042894p-2, INEXACT)
T(RN,  0x1.4d1d0e9239a0fp+733,    0x1.fa2fb8ed5475dp-1,   0x1.03c02ep-4, INEXACT)
T(RN,    0x1.8cbb9015ce7p+733,   -0x1.c1a5ac8738c86p-1,   0x1.fd9338p-4, INEXACT)
T(RN,  0x1.0346cfc57a725p+733,    0x1.8de5fd5caeb5ap-3,  -0x1.fab4a2p-4, INEXACT)
T(RN,  0x1.2760e4ab8c761p+734,    0x1.d48f42914ab1bp-1,  -0x1.98148ap-2, INEXACT)
T(RN,  0x1.bba770a4de815p+734,    0x1.b1ce00a2fc561p-1,  -0x1.573538p-2, INEXACT)
T(RN,  0x1.0a4edf495d97dp+734,    0x1.1e53b1c01517cp-1,   0x1.e8c812p-4, INEXACT)
T(RN,  0x1.ddcc067524b4ap+734,   -0x1.0489faccf58f7p-1,   0x1.ae8628p-2, INEXACT)
T(RN,  0x1.fc827409d236fp+734,   -0x1.8d8990755f50bp-1,   0x1.71fb5cp-2, INEXACT)
T(RN,    0x1.afcf61ff48bp+734,   -0x1.d842180d3f542p-1,   0x1.b2440cp-3, INEXACT)
T(RN,  0x1.5285304f52eafp+734,    0x1.f8a238dc2fba9p-1,   -0x1.b1acfp-3, INEXACT)
T(RN,  0x1.93ccd8761f3c7p+734,    0x1.873eb7ab6500ep-2,  -0x1.b7098ap-2, INEXACT)
T(RN,  0x1.1747b0fdeca6ep+734,   -0x1.87004c71e6a06p-5,   0x1.5e196cp-4, INEXACT)
T(RN,   0x1.a6bab1cd61f2p+734,   -0x1.ff4d21df9f4c3p-1,   0x1.ea5eaap-2, INEXACT)
T(RN,  0x1.0b25273ed1888p+735,    0x1.bb82baba328bep-1,    0x1.973dbp-2, INEXACT)
T(RN,  0x1.d443e0f3ee116p+735,    0x1.dc3bd0045ca09p-1,   -0x1.274fep-2, INEXACT)
T(RN,  0x1.17c21d9500e3fp+735,   -0x1.ff39f53358044p-1,   0x1.dd4fe2p-3, INEXACT)
T(RN,  0x1.0d9137a9014e9p+735,   -0x1.878530b93408cp-1,   -0x1.e918ep-2, INEXACT)
T(RN,  0x1.dfe6f192a928dp+735,    0x1.002c75b05977bp-1,    0x1.a5cc3p-2, INEXACT)
T(RN,  0x1.37dd242ace408p+735,   -0x1.d4f4ced638472p-1,   0x1.22abf2p-2, INEXACT)
T(RN,  0x1.385512efddb88p+735,    0x1.369bff37670e2p-1,   -0x1.215b4p-2, INEXACT)
T(RN,   0x1.fb82bc61bb29p+735,    0x1.2295b540b7929p-1,  -0x1.f202c2p-2, INEXACT)
T(RN,   0x1.188304908eb5p+735,    0x1.98b1deff32ad6p-3,  -0x1.fa0a0ap-3, INEXACT)
T(RN,  0x1.8833fc1cca431p+735,   -0x1.f54d5df5e4cafp-6,   0x1.b387e2p-5, INEXACT)
T(RN,  0x1.9530d7cdfcd36p+736,   -0x1.7cf9b7f31fbe5p-1,  -0x1.da589cp-2, INEXACT)
T(RN,  0x1.6756671203099p+736,    0x1.2e882c8323a94p-1,  -0x1.4a2632p-3, INEXACT)
T(RN,  0x1.8324e8d584206p+736,   -0x1.3e36bc4e60d68p-6,   -0x1.6f4c9p-2, INEXACT)
T(RN,  0x1.65e62cad819f9p+736,   -0x1.b0b2d7072a105p-1,  -0x1.c1adb8p-2, INEXACT)
T(RN,  0x1.0ffbc81e093aep+736,    0x1.fdf94854fd1fep-1,  -0x1.c1b686p-2, INEXACT)
T(RN,  0x1.89124a2621468p+736,    0x1.cc0625418d33ap-1,   0x1.782e2ap-2, INEXACT)
T(RN,  0x1.9a862b204bd98p+736,    0x1.4e3d0b122d268p-3,   0x1.44bdbap-2, INEXACT)
T(RN,  0x1.9b81c56e98defp+736,    0x1.fffe2cc57755ap-1,  -0x1.647de8p-9, INEXACT)
T(RN,  0x1.24ab30fe5f5aap+736,    0x1.75310b3029c3ap-1,  -0x1.921b1ap-3, INEXACT)
T(RN,  0x1.ccb1839f4e658p+736,   -0x1.24cd4a1297d75p-1,  -0x1.e2dff8p-3, INEXACT)
T(RN,  0x1.e7bcc099d54fep+737,   -0x1.29acc8d65c46ap-3,  -0x1.3d059ap-3, INEXACT)
T(RN,  0x1.b473abdfdb966p+737,    0x1.195fd6b59c7e7p-3,    0x1.31bbep-2, INEXACT)
T(RN,  0x1.1dd437c332d72p+737,   -0x1.fd89dc2bb2f3cp-1,  -0x1.f14f4ap-2, INEXACT)
T(RN,  0x1.ad7b20d3b277ep+737,    0x1.f791dfb66c377p-1,   0x1.1b0ee8p-2, INEXACT)
T(RN,  0x1.624c961bacb34p+737,    0x1.dd6274e348cc8p-1,   0x1.1eae58p-2, INEXACT)
T(RN,  0x1.ad2a47fdac674p+737,    0x1.0e988bd652902p-3,  -0x1.4461cap-2, INEXACT)
T(RN,  0x1.a594fc5ff708ep+737,    0x1.27facb2ac3cbcp-3,   0x1.d29b52p-3, INEXACT)
T(RN,  0x1.b5259f3554f1ep+737,   -0x1.fa4499bacf796p-1,  -0x1.a80bc2p-2, INEXACT)
T(RN,  0x1.c2abf5488a96cp+737,    0x1.6bd9dd8002158p-5,  -0x1.58aa78p-4, INEXACT)
T(RN,  0x1.d81c403aa5b58p+737,    0x1.e87157898e3bdp-1,   0x1.7c534cp-2, INEXACT)
T(RN,  0x1.9526e84192e62p+738,    0x1.c131d9ac929bdp-4,  -0x1.77f508p-3, INEXACT)
T(RN,  0x1.dae6cbc7bcb2ep+738,   -0x1.34779ddcb8d81p-2,  -0x1.0d022ep-4, INEXACT)
T(RN,  0x1.dcbda7b99d37ep+738,    0x1.117f96b6e5c8cp-1,   0x1.e180c2p-2, INEXACT)
T(RN,  0x1.a30e3efb5e1e7p+738,    0x1.c25a8dbbeefe9p-1,   -0x1.282cep-2, INEXACT)
T(RN,  0x1.d1e188589a3b2p+738,   -0x1.8dd268db76477p-1,   -0x1.4bc85p-2, INEXACT)
T(RN,  0x1.8a37eff23bb9ap+738,    0x1.a3125b1271b64p-2,  -0x1.e1376ap-2, INEXACT)
T(RN,  0x1.ec7850e7025e2p+738,    0x1.acc4f4090c9adp-1,  -0x1.b925b8p-3, INEXACT)
T(RN,  0x1.781696e84303cp+738,   -0x1.974d3fe2549b7p-2,  -0x1.7581eap-2, INEXACT)
T(RN,    0x1.6ce94e98bd8p+738,   -0x1.348b70ba8b71bp-1,  -0x1.da094cp-2, INEXACT)
T(RN,  0x1.82d0ee40aa4cdp+738,     0x1.e3c704ae8fefp-1,   0x1.4377c2p-2, INEXACT)
T(RN,  0x1.db86e117dff2fp+739,   -0x1.a5e4aae9dd4d4p-1,   0x1.44d2d6p-9, INEXACT)
T(RN,  0x1.ec614a8199204p+739,    0x1.c84d2ea986c5cp-1,  -0x1.efa7b2p-3, INEXACT)
T(RN,  0x1.902e4b7006862p+739,    0x1.facfe03a19ce7p-1,  -0x1.4b2e7cp-2, INEXACT)
T(RN,  0x1.6e9aab35be266p+739,   -0x1.b6439e14ba076p-1,   0x1.811658p-2, INEXACT)
T(RN,  0x1.aae69e4fbf7b8p+739,   -0x1.9316671345866p-2,  -0x1.e40f0ep-3, INEXACT)
T(RN,  0x1.f6d30787639a2p+739,    0x1.5b5f7dc73527ep-3,   0x1.c1bb4ep-3, INEXACT)
T(RN,  0x1.5f761972b379ep+739,   -0x1.f8e2f66e1ab4dp-1,  -0x1.d497fcp-2, INEXACT)
T(RN,  0x1.556f7b17de9f8p+739,    0x1.437d1a4662162p-4,  -0x1.5828eep-3, INEXACT)
T(RN,  0x1.000c7fbda05dbp+739,   -0x1.ce0d07b82b2ecp-1,   0x1.ac0186p-6, INEXACT)
T(RN,   0x1.34b82a3754acp+739,   -0x1.28939432c956bp-1,   0x1.305e68p-5, INEXACT)
T(RN,  0x1.beaad145afc8cp+740,    0x1.f67a3c385bba6p-1,   0x1.b21daap-4, INEXACT)
T(RN,  0x1.e5afd54f17abcp+740,   -0x1.3aa86a193b309p-1,  -0x1.d9cb18p-2, INEXACT)
T(RN,  0x1.106787b7ef71ap+740,   -0x1.c8440ab8fb452p-1,  -0x1.0b9feep-4, INEXACT)
T(RN,  0x1.2c3cc3c3e1eccp+740,   -0x1.ab9ed231a962dp-1,   0x1.31438cp-4, INEXACT)
T(RN,  0x1.c8b92c41a0981p+740,   -0x1.ed23afb68bdf3p-1,   0x1.0cdeacp-4, INEXACT)
T(RN,  0x1.372575a7b2794p+740,    0x1.3b0ac3168e483p-3,   0x1.0e87b8p-2, INEXACT)
T(RN,  0x1.1b232f35978c3p+740,    0x1.e28b413c86eefp-1,  -0x1.a8cceep-2, INEXACT)
T(RN,   0x1.f10f14057eccp+740,   -0x1.b9eca10c91f82p-1,   0x1.b9e9c6p-4, INEXACT)
T(RN,  0x1.cb2e83a59f7fep+740,   -0x1.052a9adf2fbcdp-1,   0x1.9cc6d2p-3, INEXACT)
T(RN,  0x1.a3f1b606c1296p+740,    0x1.31b06365f1aa8p-6,   0x1.105d12p-2, INEXACT)
T(RN,  0x1.2a1496414739ep+741,    0x1.d324ab308fb0bp-1,   0x1.9947bep-4, INEXACT)
T(RN,   0x1.26c60c5694edp+741,    0x1.05b5832895f66p-1,   0x1.276d72p-3, INEXACT)
T(RN,  0x1.0400d1027ef9fp+741,    0x1.c429f30d827e3p-1,   0x1.b5c1b2p-4, INEXACT)
T(RN,  0x1.dd17f3c581a04p+741,   -0x1.f7e0a2671ac0bp-2,   0x1.c304b8p-2, INEXACT)
T(RN,  0x1.cc472381fcb54p+741,   -0x1.98d1fde7904d2p-1,   0x1.9fe9bap-3, INEXACT)
T(RN,  0x1.9ec16d906e155p+741,    0x1.09b211ad8745ep-2,   0x1.2e13bap-2, INEXACT)
T(RN,  0x1.763a37c24b6ecp+741,    0x1.36810b0eb6d0ep-1,   0x1.2c38eep-4, INEXACT)
T(RN,   0x1.3ca4abe7967cp+741,    0x1.e01a2a948c53bp-1,   0x1.d31318p-3, INEXACT)
T(RN,  0x1.0dbb6df8edd2dp+741,    0x1.89ddc57d7808ap-1,   0x1.b5b218p-2, INEXACT)
T(RN,   0x1.b3b62f59f0e5p+741,    0x1.c9e3e6ae01b12p-1,   0x1.c39128p-4, INEXACT)
T(RN,  0x1.8373c477e0eeep+742,   -0x1.17979f454e458p-3,   0x1.103ae2p-2, INEXACT)
T(RN,  0x1.9ffc4122adb28p+742,   -0x1.fdef7a8f9afb8p-1,  -0x1.7b974ap-2, INEXACT)
T(RN,  0x1.36dfe8d2cce5ep+742,    0x1.fffc68997984cp-1,   0x1.4eb534p-4, INEXACT)
T(RN,  0x1.44382341d6d32p+742,   -0x1.3449124c74d1fp-1,  -0x1.0181e4p-3, INEXACT)
T(RN,  0x1.8608f7d211e66p+742,    0x1.554194ecb0463p-1,   0x1.4d387ap-2, INEXACT)
T(RN,  0x1.38cf91362b594p+742,     0x1.ffffd7211737p-1,  -0x1.4a1084p-3, INEXACT)
T(RN,   0x1.66e2491e1923p+742,   -0x1.d542f3883083bp-1,   0x1.d7ad28p-6, INEXACT)
T(RN,  0x1.ba79925d17134p+742,   -0x1.f9468ed16caa5p-1,   0x1.11fd48p-2, INEXACT)
T(RN,  0x1.9c86ca1d2773cp+742,    0x1.9ac933a3bac59p-2,  -0x1.838382p-3, INEXACT)
T(RN,  0x1.1811e730ed0cep+742,   -0x1.c4d5f999d7ffep-2,  -0x1.503fdap-3, INEXACT)
T(RN,  0x1.84aee750a6386p+743,    0x1.c52d01cb0930dp-9,   0x1.6b38fcp-2, INEXACT)
T(RN,   0x1.74f6912526aap+743,    0x1.71fd480579ff5p-2,   0x1.e8540ep-2, INEXACT)
T(RN,  0x1.38911559e9963p+743,   -0x1.09374bffb4e52p-1,  -0x1.67b422p-2, INEXACT)
T(RN,  0x1.5ff8e627b7934p+743,    0x1.cbaeb2c3346ddp-1,  -0x1.7a0b6ap-2, INEXACT)
T(RN,  0x1.e22f88fb3bdbcp+743,   -0x1.d843d47ff013fp-2,    0x1.944c8p-4, INEXACT)
T(RN,  0x1.2a3dcc7670002p+743,    0x1.3f49824c7d9f5p-1,   0x1.8054fcp-4, INEXACT)
T(RN,  0x1.b8dc325b9eda2p+743,   -0x1.15c2582ea8a7cp-2,   0x1.524386p-2, INEXACT)
T(RN,  0x1.94d686265767cp+743,    0x1.b1db88059e7b1p-2,  -0x1.8f5b6ep-3, INEXACT)
T(RN,  0x1.3cad4deea21dfp+743,    -0x1.d08f88da2cc2p-1,  -0x1.8baceap-5, INEXACT)
T(RN,  0x1.44975fb842d54p+743,    0x1.8b9afea59f13cp-2,    -0x1.233cp-2, INEXACT)
T(RN,  0x1.f390f8de8405cp+744,   -0x1.baf2a5378dad7p-1,   0x1.f0ca3ep-6, INEXACT)
T(RN,  0x1.7042ac5bd5c5ap+744,   -0x1.c56a8ff74b32fp-3,   0x1.3344bep-3, INEXACT)
T(RN,  0x1.6c91fd6f6149cp+744,    0x1.6fb9eabf779dfp-2,  -0x1.68e146p-2, INEXACT)
T(RN,  0x1.1d4872aeecd3ap+744,    0x1.f3f7ecf4fefc8p-1,  -0x1.304688p-2, INEXACT)
T(RN,  0x1.d3af2d43f87bap+744,    0x1.69ed1b2755abep-2,  -0x1.7dbce8p-2, INEXACT)
T(RN,  0x1.f36b4b15addb4p+744,   -0x1.800606fe825ecp-3,  -0x1.0cd4eap-2, INEXACT)
T(RN,  0x1.c61e05fa3f4dbp+744,   -0x1.dfb70a00ee8f2p-1,   0x1.2dc8d6p-4, INEXACT)
T(RN,   0x1.17b738fb5717p+744,   -0x1.ff01268167485p-1,  -0x1.96be16p-3, INEXACT)
T(RN,  0x1.4249638243a4ep+744,    -0x1.de7dcb52aa82p-2,   0x1.73b9ccp-2, INEXACT)
T(RN,  0x1.9f082b6bf1f9dp+744,   -0x1.101d57bd4dfe5p-1,   0x1.d628f8p-5, INEXACT)
T(RN,  0x1.9b5eed39ede0cp+745,   -0x1.fe76dffa396d1p-1,  -0x1.6e5c66p-5, INEXACT)
T(RN,   0x1.34a5b7d480d3p+745,    0x1.4d31fd2141e79p-1,   0x1.693264p-2, INEXACT)
T(RN,  0x1.036a309e26db3p+745,    0x1.a23e6389c295ep-2,  -0x1.0ab776p-2, INEXACT)
T(RN,  0x1.3a71252e6fa3cp+745,    0x1.0cd1007036b99p-2,  -0x1.b9b82ap-5, INEXACT)
T(RN,  0x1.828d577dbe139p+745,   -0x1.f398db0795cdfp-5,   0x1.6d8a7ep-2, INEXACT)
T(RN,  0x1.856925c6fb283p+745,    0x1.16d1dbb1d92a2p-1,  -0x1.107288p-2, INEXACT)
T(RN,  0x1.3a6c58a655071p+745,    -0x1.edb87fb86d39p-4,  -0x1.71d138p-2, INEXACT)
T(RN,  0x1.4772215949258p+745,    0x1.f9af973e0e48dp-2,   0x1.8d2506p-2, INEXACT)
T(RN,  0x1.63ae341a45c2bp+745,   -0x1.fff530de86676p-1,   -0x1.ed853p-4, INEXACT)
T(RN,  0x1.60f3d26fa708cp+745,   -0x1.5f55c8c6ac6aep-6,  -0x1.b105aap-2, INEXACT)
T(RN,  0x1.3eb7d0a26c8cfp+746,    0x1.e7fc345338498p-1,   0x1.a75a0ap-4, INEXACT)
T(RN,  0x1.4a82f5a70735cp+746,    0x1.ded577f2305fdp-1,    0x1.7393cp-2, INEXACT)
T(RN,  0x1.b2617272b2e06p+746,    0x1.cc30e34450dfbp-3,   0x1.f4953ap-2, INEXACT)
T(RN,  0x1.1d64e8c54844ep+746,    0x1.cf20ffc7a9e72p-1,   0x1.097a8ap-4, INEXACT)
T(RN,  0x1.2095b7dbde3aap+746,   -0x1.9ab73b831c4f1p-3,   0x1.ec65b6p-2, INEXACT)
T(RN,  0x1.a32c62d4defd3p+746,    0x1.77fab3990029cp-1,  -0x1.d0dc16p-2, INEXACT)
T(RN,  0x1.8cfef9beb5303p+746,    0x1.8780ce5ac1d99p-1,   0x1.d7f5b6p-2, INEXACT)
T(RN,  0x1.4dd383b914b17p+746,    0x1.9f64fd5272406p-1,   0x1.8e6382p-2, INEXACT)
T(RN,  0x1.59909c33775b7p+746,    0x1.56f4a51a66577p-4,  -0x1.8aac48p-2, INEXACT)
T(RN,  0x1.26f422d0faa14p+746,   -0x1.fdbf342374908p-1,  -0x1.b74a2ap-2, INEXACT)
T(RN,  0x1.d64213440457ep+747,   -0x1.815dcc1c919c5p-1,  -0x1.ed8176p-3, INEXACT)
T(RN,  0x1.f50f0755b799ap+747,    0x1.e0751172695c2p-1,     0x1.d2e3p-2, INEXACT)
T(RN,  0x1.6f76cee766deep+747,     0x1.46757a60d06ep-1,   0x1.5ee376p-2, INEXACT)
T(RN,  0x1.22120f2e55bcdp+747,     -0x1.a551ab5e53cp-1,  -0x1.3cc21ep-6, INEXACT)
T(RN,   0x1.31c1b8a94168p+747,    0x1.f487a42319564p-2,  -0x1.9ae922p-3, INEXACT)
T(RN,  0x1.348f4284ba2afp+747,    0x1.74cf3e14c1a83p-1,  -0x1.8d815ep-8, INEXACT)
T(RN,  0x1.40b7088b08e59p+747,   -0x1.41ff482526b7cp-1,  -0x1.1ddf14p-3, INEXACT)
T(RN,  0x1.6af17a8b221c8p+747,    0x1.3baa1ecc73775p-1,    0x1.7b70dp-3, INEXACT)
T(RN,  0x1.47a59dab0fac5p+747,    0x1.acbbc18723879p-1,  -0x1.59c58ap-2, INEXACT)
T(RN,  0x1.98670aa40b1e6p+747,    0x1.58905f674c09ap-7,   -0x1.4cc11p-2, INEXACT)
T(RN,   0x1.4bdb36b2c7e9p+748,    0x1.64152cbd6f7adp-1,   0x1.9de058p-2, INEXACT)
T(RN,  0x1.ff5401be336eep+748,     0x1.d3208941fc03p-2,   0x1.191d64p-3, INEXACT)
T(RN,  0x1.c39af824417dcp+748,   -0x1.c392789b1b6f8p-3,  -0x1.dbb604p-3, INEXACT)
T(RN,  0x1.26791820d5f4ep+748,   -0x1.b9d03574452f2p-1,  -0x1.fb7506p-5, INEXACT)
T(RN,   0x1.46eb487bb9eep+748,   -0x1.fec83da59d02dp-1,  -0x1.41697ep-4, INEXACT)
T(RN,  0x1.cd1d773eec5bbp+748,    0x1.512ab3b25eae3p-4,  -0x1.6f5c7cp-2, INEXACT)
T(RN,  0x1.983e9d9a0f0f7p+748,    0x1.d20b730cbde72p-1,   0x1.a979fep-3, INEXACT)
T(RN,  0x1.ed5107992479cp+748,   -0x1.f8ad5e1dab4aap-1,  -0x1.cdd644p-4, INEXACT)
T(RN,   0x1.0e4dd14edffdp+748,     0x1.f67136f93e7dp-1,  -0x1.9983eap-3, INEXACT)
T(RN,  0x1.401881a96af0fp+748,   -0x1.b50f4e9e3a885p-1,  -0x1.5867f6p-3, INEXACT)
T(RN,  0x1.c17bd1b4439b8p+749,    0x1.cf89e61f0cf4dp-1,   0x1.600c22p-4, INEXACT)
T(RN,  0x1.d54089c45d10cp+749,    0x1.ff29ad38b6b11p-1,   0x1.d65ecap-2, INEXACT)
T(RN,  0x1.e63fd010168a6p+749,   -0x1.4afddda064232p-1,   0x1.544038p-3, INEXACT)
T(RN,  0x1.fe9359e3e09e6p+749,   -0x1.ff923a010af76p-1,  -0x1.b3635ep-3, INEXACT)
T(RN,   0x1.5928d25917f2p+749,   -0x1.fd511b89c73e9p-1,   0x1.bd4e4ap-4, INEXACT)
T(RN,  0x1.87cfd4f796432p+749,   -0x1.8199289c01497p-2,   0x1.d516fcp-3, INEXACT)
T(RN,   0x1.e4c6e8c303b2p+749,    0x1.ffe6d1bcf2579p-1,  -0x1.8e7672p-3, INEXACT)
T(RN,  0x1.51c3eb55e4b3ep+749,    0x1.cbb640f8d068cp-1,    0x1.c34adp-3, INEXACT)
T(RN,  0x1.010f4d6b0edb9p+749,   -0x1.4be0c41ce14f6p-2,   0x1.ced0dap-6, INEXACT)
T(RN,  0x1.96aa7aeed238ep+749,   -0x1.ff913f6a61d48p-1,   0x1.7cc234p-2, INEXACT)
T(RN,  0x1.445c5bc30d382p+750,    0x1.e69563a681842p-3,  -0x1.e16accp-2, INEXACT)
T(RN,  0x1.d067b250008acp+750,   -0x1.f444d8cd57feap-1,  -0x1.a968ccp-2, INEXACT)
T(RN,  0x1.a023ed3920c0ap+750,    0x1.50e93a582ea9bp-1,   0x1.f1ac4ap-4, INEXACT)
T(RN,  0x1.63e328ab8ab8fp+750,    0x1.644436cc004dbp-3,  -0x1.822828p-2, INEXACT)
T(RN,  0x1.f62a397f338fdp+750,   -0x1.4d7a1aa92aa0ap-1,   0x1.ff20fep-2, INEXACT)
T(RN,  0x1.1324c628688c4p+750,   -0x1.b1aaee63bc42ep-5,   0x1.ad2394p-2, INEXACT)
T(RN,  0x1.0a7041ae6ec7cp+750,     0x1.c48d58de899ep-1,  -0x1.55f9c6p-2, INEXACT)
T(RN,  0x1.6df3ef244e319p+750,   -0x1.6467948cd7629p-2,  -0x1.b2fae4p-2, INEXACT)
T(RN,  0x1.e67ea9c23a749p+750,    0x1.7094770787e12p-2,   0x1.ec0c42p-3, INEXACT)
T(RN,  0x1.1d987c660905dp+750,   -0x1.26b0cbafcbe3ap-6,  -0x1.3baf56p-2, INEXACT)
T(RN,   0x1.5b48d0739fbap+751,   -0x1.976c849cef7eep-1,   0x1.f2086ap-4, INEXACT)
T(RN,  0x1.105760975836ap+751,    0x1.92f8d8550c21fp-1,   -0x1.7e5eap-4, INEXACT)
T(RN,  0x1.07970cb601acep+751,   -0x1.78cc6141bd05cp-1,   -0x1.e6659p-2, INEXACT)
T(RN,  0x1.639b7f645aca6p+751,   -0x1.b22daa3b6ce26p-1,   0x1.7a05bap-4, INEXACT)
T(RN,  0x1.94a59a1bc65a4p+751,   -0x1.35ed43b0b5761p-1,   0x1.abc96cp-2, INEXACT)
T(RN,  0x1.b042aa6c90a76p+751,   -0x1.cc100d442ec85p-1,   0x1.4e24fep-2, INEXACT)
T(RN,   0x1.e462d23d1504p+751,   -0x1.52ceb3c8df626p-2,  -0x1.8eef34p-2, INEXACT)
T(RN,   0x1.a59d44caf10ep+751,    0x1.7509c602b230ep-1,   0x1.4c67dep-2, INEXACT)
T(RN,  0x1.d5067bac5e33cp+751,    0x1.8c8c7e0fc10bap-2,   0x1.21c032p-3, INEXACT)
T(RN,   0x1.022f52505fc7p+751,   -0x1.f6868d289f4f3p-6,  -0x1.16c8b4p-3, INEXACT)
T(RN,  0x1.770ad663547fcp+752,   -0x1.c40086132013ep-1,  -0x1.195faep-9, INEXACT)
T(RN,  0x1.bf562bff3d90ap+752,    0x1.252d89c82a40fp-3,   0x1.5f13acp-2, INEXACT)
T(RN,   0x1.d96f33b3f506p+752,     0x1.74946d0f551dp-1,  -0x1.8a090cp-2, INEXACT)
T(RN,  0x1.85e673a1b754cp+752,   -0x1.2bf8252bb0a66p-4,   0x1.7b73f2p-2, INEXACT)
T(RN,  0x1.5e55ff48516edp+752,    0x1.9604ba91ad79ap-1,  -0x1.0a6c72p-4, INEXACT)
T(RN,  0x1.6f9ab63c2ce8dp+752,    0x1.de8d67d3cfa3ep-3,   0x1.fd3c8ap-2, INEXACT)
T(RN,  0x1.579f8d27d4e9ep+752,   -0x1.14abc465adef1p-2,   0x1.52d3d6p-2, INEXACT)
T(RN,  0x1.a84411537d411p+752,    0x1.c4aa10acfd749p-2,  -0x1.4534c8p-2, INEXACT)
T(RN,  0x1.f166688cb532fp+752,    0x1.0db58f3249c1ep-2,   0x1.4b70dep-2, INEXACT)
T(RN,  0x1.319f407060712p+752,    0x1.da00948061105p-1,   -0x1.57d8bp-2, INEXACT)
T(RN,  0x1.5d2754e77e2f2p+753,    0x1.b2c87c2bcc263p-1,  -0x1.64e33cp-2, INEXACT)
T(RN,  0x1.cd7b20b906374p+753,    0x1.f95bbf3b89d0bp-1,  -0x1.748e32p-2, INEXACT)
T(RN,  0x1.9e6dab311cfbep+753,   -0x1.cbe06214beb7dp-1,  -0x1.7723f8p-3, INEXACT)
T(RN,  0x1.fa452ed01a9d4p+753,    0x1.ffb5be17a9dd9p-1,  -0x1.723226p-2, INEXACT)
T(RN,  0x1.a4d0ebb1eec2fp+753,   -0x1.1a4bd826a8253p-1,   0x1.8992bcp-2, INEXACT)
T(RN,  0x1.6ad11ba2aeae7p+753,   -0x1.ea4ca690259ffp-1,  -0x1.3880dcp-2, INEXACT)
T(RN,  0x1.fa099f5503f46p+753,   -0x1.a3c2c81deb25cp-1,   0x1.a85f2ap-7, INEXACT)
T(RN,  0x1.5ddfa2a99d806p+753,    0x1.e8441dec7ee24p-1,   0x1.627582p-4, INEXACT)
T(RN,  0x1.138f210df4d64p+753,   -0x1.b15cc3618e502p-1,   0x1.3073b8p-5, INEXACT)
T(RN,  0x1.521504371b819p+753,   -0x1.c06703a2ce592p-1,  -0x1.9f2036p-2, INEXACT)
T(RN,  0x1.ce284b3a3b611p+754,   -0x1.db0853e4758aap-3,   0x1.6f3d6ep-2, INEXACT)
T(RN,  0x1.092880ed5bec5p+754,   -0x1.e79391adfddf6p-1,   0x1.17e80cp-5, INEXACT)
T(RN,  0x1.5c84f11942a28p+754,   -0x1.8602c48aca05cp-2,   0x1.014d96p-2, INEXACT)
T(RN,  0x1.26684583c4a73p+754,   -0x1.4c57e8733c67cp-1,  -0x1.574136p-2, INEXACT)
T(RN,  0x1.f63fdda2276bcp+754,    -0x1.b6ca0a2a4ce7p-5,   0x1.2d4e5cp-4, INEXACT)
T(RN,  0x1.a027dddee0d6cp+754,    0x1.3a3a4e7fc8ff4p-2,   0x1.f7cb68p-5, INEXACT)
T(RN,  0x1.669a752ac8731p+754,   -0x1.f67167be8d5f9p-1,   0x1.b9750ep-4, INEXACT)
T(RN,  0x1.4e03685f33d9fp+754,   -0x1.66b8f20e6bb6dp-2,   0x1.f5d8f6p-4, INEXACT)
T(RN,  0x1.a263b1aacd6b6p+754,   -0x1.dfd8637281893p-1, -0x1.203448p-10, INEXACT)
T(RN,  0x1.12db0c4c69011p+754,    0x1.bad08959013cbp-2,  -0x1.4f7538p-3, INEXACT)
T(RN,  0x1.2151cde782e93p+755,    0x1.c8cef57e2d5a6p-1,   0x1.8e0474p-2, INEXACT)
T(RN,  0x1.e192b5fc7e8dcp+755,    0x1.dd4fe78cb8749p-1,  -0x1.9e6f1cp-2, INEXACT)
T(RN,  0x1.f09117aa6a696p+755,   -0x1.f89eb628ffaa2p-1,   -0x1.4f2eep-4, INEXACT)
T(RN,  0x1.7a8470e45fe9bp+755,     0x1.8a933eff5a92p-1,   0x1.7236b2p-2, INEXACT)
T(RN,  0x1.ede4ea9e418fap+755,   -0x1.a94feb79bf0b1p-4,   0x1.a702e4p-2, INEXACT)
T(RN,  0x1.fd0aae2fe1c79p+755,   -0x1.c69c16406537dp-1,  -0x1.9722b4p-3, INEXACT)
T(RN,  0x1.a0f9fdbd035e5p+755,   -0x1.fdbc260d6469ep-1,  -0x1.15064cp-2, INEXACT)
T(RN,  0x1.4c23022e77b13p+755,   -0x1.0bc1b10f1ff89p-1,   0x1.14f52cp-2, INEXACT)
T(RN,  0x1.69a980709355ep+755,    0x1.f9fbbc8fcb567p-1,  -0x1.cfc47cp-2, INEXACT)
T(RN,  0x1.27817dc972291p+755,    0x1.cdc942611491fp-5,   0x1.45c4c6p-2, INEXACT)
T(RN,  0x1.1830f9dbf3ccap+756,    0x1.52ccb5bc01c02p-2,  -0x1.b9b2ccp-2, INEXACT)
T(RN,  0x1.7d0b566336721p+756,    0x1.86e71687ec76bp-1,   0x1.372a24p-2, INEXACT)
T(RN,  0x1.db71d43e49057p+756,    0x1.364cc49818081p-1,   0x1.b0c32ap-2, INEXACT)
T(RN,  0x1.862a843f4b093p+756,   -0x1.44cf77ecb384bp-2,   -0x1.4fe5dp-3, INEXACT)
T(RN,  0x1.d3b3bcc2c0952p+756,    0x1.c2128dc5924c7p-1,  -0x1.6d5994p-3, INEXACT)
T(RN,  0x1.1eea8ccb4e9b5p+756,     0x1.ad3be4e1006ap-1,  -0x1.1d3476p-2, INEXACT)
T(RN,  0x1.11cc2348f285cp+756,   -0x1.115d76d3102c3p-2,  -0x1.057b06p-4, INEXACT)
T(RN,  0x1.a45be5a43389cp+756,   -0x1.fb8675d91b52bp-2,  -0x1.cde44cp-3, INEXACT)
T(RN,  0x1.669fce2cb967bp+756,   -0x1.b479582959f79p-1,    0x1.884d9p-6, INEXACT)
T(RN,  0x1.ad25316ad1577p+756,    0x1.2423c95eb084dp-5,   -0x1.03a91p-4, INEXACT)
T(RN,  0x1.577cbe5ac04c9p+757,   -0x1.da3590bc1689ep-1,  -0x1.3fa7f6p-2, INEXACT)
T(RN,  0x1.baa807eb50fbep+757,    0x1.f2fb9e70aa1f5p-4,    0x1.f95d3p-2, INEXACT)
T(RN,  0x1.873555c8b583dp+757,    0x1.fb752a7cc0fbep-1,   0x1.2fc42ep-2, INEXACT)
T(RN,  0x1.43fd1cc2bdb8cp+757,    0x1.eb89c6360d12bp-1,   0x1.e29232p-4, INEXACT)
T(RN,  0x1.6239068d5b898p+757,   -0x1.9864f69797354p-1,  -0x1.e3297ap-2, INEXACT)
T(RN,  0x1.a8bc5a8c94dc6p+757,     0x1.eb9b6974aa7fp-1,  -0x1.ed6f42p-5, INEXACT)
T(RN,  0x1.cbd1c45a2a2b8p+757,   -0x1.154ca0b1a3bcfp-5,   0x1.324556p-2, INEXACT)
T(RN,  0x1.83b66029d0d4dp+757,   -0x1.c7d75a85d7e9bp-4,   0x1.734204p-2, INEXACT)
T(RN,  0x1.b5b6e44dd5d02p+757,   -0x1.b9da3b2ccf09ep-1,  -0x1.10e71cp-4, INEXACT)
T(RN,  0x1.05a5f3becea4ap+757,    -0x1.d00e17cfb93fp-3,   0x1.8871fap-3, INEXACT)
T(RN,  0x1.e260258549c82p+758,    0x1.d73150fe17651p-1,    0x1.6cc44p-2, INEXACT)
T(RN,  0x1.a239b73e404f9p+758,    0x1.d1ef68c859f56p-1,   -0x1.992c4p-4, INEXACT)
T(RN,  0x1.4e679b11e61afp+758,   -0x1.7f4f5ffeb76adp-1,  -0x1.2ff2dep-2, INEXACT)
T(RN,  0x1.55c41711a3dd3p+758,    0x1.c0a223e9475e9p-2,   0x1.c75d06p-4, INEXACT)
T(RN,  0x1.b3c4795576d74p+758,    0x1.0ba7df8a3716dp-1,  -0x1.3c133cp-2, INEXACT)
T(RN,  0x1.2dbbcef3ff3adp+758,   -0x1.79f718eec3df7p-1,  -0x1.0d3ebap-4, INEXACT)
T(RN,  0x1.08c8595f4030ep+758,   -0x1.5cc9241506d83p-1,   -0x1.30e5cp-2, INEXACT)
T(RN,  0x1.b2a75561d1741p+758,    0x1.e4061bfafc678p-1,   0x1.8927d8p-5, INEXACT)
T(RN,  0x1.0a64c84d4be36p+758,    0x1.a3795733ab225p-1,  -0x1.f2adf6p-2, INEXACT)
T(RN,  0x1.7c84671ea2d37p+758,    0x1.8d40acb9febe9p-2,   0x1.a8d5d8p-3, INEXACT)
T(RN,  0x1.3f2d8caa2c082p+759,   -0x1.070fe24e17a54p-1,   0x1.585b78p-2, INEXACT)
T(RN,  0x1.7d5f744a8393bp+759,    0x1.d2c78bcfe3747p-1,   -0x1.837f8p-3, INEXACT)
T(RN,  0x1.6ee019e3f658ap+759,   -0x1.ebd9f12c8e23ap-1,  -0x1.58a4fep-4, INEXACT)
T(RN,  0x1.7a162d02bd7a8p+759,   -0x1.cd47601a5c949p-3,   0x1.a9019cp-2, INEXACT)
T(RN,  0x1.a57fef6a6155dp+759,    0x1.33450d9250945p-1,   0x1.1671d8p-2, INEXACT)
T(RN,  0x1.4ee7aaffa880cp+759,   -0x1.a51835e9c1457p-1,   0x1.5faf02p-2, INEXACT)
T(RN,  0x1.2ecc674a89981p+759,    0x1.7fade8032c4f8p-1,    0x1.d0eaap-2, INEXACT)
T(RN,  0x1.f4507e4794bc8p+759,    0x1.e63fccd99c4cfp-1,   0x1.e7adccp-2, INEXACT)
T(RN,  0x1.9038987c56604p+759,   -0x1.4015bb34cb4f4p-1,  -0x1.72e69ap-2, INEXACT)
T(RN,  0x1.1304be5023542p+759,    0x1.dc873a452e796p-1,   0x1.e775fcp-2, INEXACT)
T(RN,  0x1.d3282aa23e55cp+760,   -0x1.fdde6f8cabe63p-1,  -0x1.6de3f4p-3, INEXACT)
T(RN,  0x1.522fbaf516fdcp+760,   -0x1.cb8921839c8e4p-2,   0x1.81ec4ap-5, INEXACT)
T(RN,  0x1.a84a5834feb41p+760,   -0x1.164749d03df3bp-1,  -0x1.cbe82cp-3, INEXACT)
T(RN,  0x1.8d945cb8fa1fcp+760,    0x1.98d2e151bd107p-2,   0x1.8e7f6ap-3, INEXACT)
T(RN,  0x1.9f13533ea8cf7p+760,    0x1.1e547a6340a2cp-1,    0x1.19814p-3, INEXACT)
T(RN,  0x1.77e417e75f8c6p+760,     0x1.f9f21e34cc47p-1,   0x1.e2919ep-2, INEXACT)
T(RN,  0x1.7927417a00a0ap+760,   -0x1.85444f5c34d4ap-1,   0x1.906bbep-5, INEXACT)
T(RN,  0x1.5d299abbf7c54p+760,    0x1.a3b477ae65822p-1,   0x1.981046p-3, INEXACT)
T(RN,  0x1.62bcdbccc4a29p+760,    0x1.7f18842ba25bep-3,  -0x1.b823dcp-6, INEXACT)
T(RN,  0x1.795f58f60c312p+760,   -0x1.286a84063917ap-3,   0x1.53eca6p-2, INEXACT)
T(RN,  0x1.c0549ff987ca8p+761,   -0x1.ffc893e6f04ffp-1,   0x1.716432p-5, INEXACT)
T(RN,  0x1.1dc48459880b2p+761,   -0x1.add9cf7c542afp-3,   -0x1.4d6f8p-5, INEXACT)
T(RN,   0x1.a68258223daep+761,   -0x1.ffdf2f80410c1p-1,   0x1.800f72p-3, INEXACT)
T(RN,  0x1.96f5c5693e7f5p+761,   -0x1.7141cbd4a3c21p-3,  -0x1.8ae12ap-2, INEXACT)
T(RN,  0x1.9438607e75878p+761,     0x1.f660804aaed1p-1,  -0x1.1dd778p-4, INEXACT)
T(RN,  0x1.ac26ba82a8034p+761,    0x1.fc0b638a4f26ap-1,   0x1.b41e58p-3, INEXACT)
T(RN,  0x1.1272597c41eb5p+761,   -0x1.c531b3215be84p-1,   0x1.f33ec2p-2, INEXACT)
T(RN,  0x1.466f20061eb24p+761,    0x1.620e1796bd183p-4,   0x1.de0dd2p-4, INEXACT)
T(RN,  0x1.f471e2f28c653p+761,    0x1.08e04eae1eaefp-3,    0x1.2453ap-3, INEXACT)
T(RN,  0x1.20f5bc4984769p+761,    0x1.7fb654bff8c46p-2,  -0x1.d2c64ep-2, INEXACT)
T(RN,  0x1.4407d68a486f1p+762,   -0x1.f6bf55f56f7edp-2,   -0x1.366aep-6, INEXACT)
T(RN,  0x1.228591bd10d9bp+762,    0x1.faae614f43a4dp-1,   0x1.32105cp-2, INEXACT)
T(RN,  0x1.d287c4a5a51d3p+762,    0x1.3c7fe46925ac9p-3,  -0x1.0593a4p-5, INEXACT)
T(RN,  0x1.2ddbadb811cc3p+762,   -0x1.1367a9736b789p-2,   0x1.53c83ap-2, INEXACT)
T(RN,   0x1.357c48c8c0f8p+762,    -0x1.bde4daf52edcp-1,   0x1.64e3e8p-3, INEXACT)
T(RN,  0x1.0c9a5b2d7415bp+762,   -0x1.35864832a34d4p-2,   0x1.6b6428p-2, INEXACT)
T(RN,  0x1.8e1e526394a1dp+762,   -0x1.c6a32cce051b8p-2,   -0x1.7cb83p-2, INEXACT)
T(RN,  0x1.020724539f992p+762,     -0x1.de7dd558d59p-1,  -0x1.94caaap-2, INEXACT)
T(RN,  0x1.28b75fb937dbdp+762,   -0x1.b4c11f2d11137p-1,  -0x1.45d29ep-5, INEXACT)
T(RN,  0x1.942c53c7c9512p+762,    0x1.81f9fcdc3f14ep-2,  -0x1.06b258p-3, INEXACT)
T(RN,  0x1.94ee5dd2924ddp+763,   -0x1.95d39562d5ffdp-2,   0x1.9d5fa8p-2, INEXACT)
T(RN,  0x1.5a4119d555ae4p+763,    0x1.789d9506b3c2fp-1,    -0x1.4931p-2, INEXACT)
T(RN,  0x1.6bf57dcefbb03p+763,   -0x1.bd665a02eb602p-1,   0x1.ff5386p-2, INEXACT)
T(RN,  0x1.f8fd14b2f3567p+763,    0x1.5ac831c6f0baep-1,  -0x1.24e464p-2, INEXACT)
T(RN,  0x1.7c7741664a8a5p+763,    0x1.34ef6eab1a329p-1,  -0x1.3c8b6cp-2, INEXACT)
T(RN,  0x1.dfd93898c6ad1p+763,   -0x1.7cd478ae892bcp-1,  -0x1.91fe28p-2, INEXACT)
T(RN,  0x1.b2c51c4166856p+763,    0x1.98f0310e6133fp-1,  -0x1.ba4cdep-3, INEXACT)
T(RN,  0x1.ad9ee332179fep+763,   -0x1.4f0e903920b26p-2,   0x1.e594c2p-4, INEXACT)
T(RN,  0x1.8e5f68c298f29p+763,   -0x1.670ae0e0dc0d8p-1,   0x1.d977eap-4, INEXACT)
T(RN,  0x1.b3de85fce88cep+763,   -0x1.73f8a1667dcb5p-5,   0x1.876448p-3, INEXACT)
T(RN,  0x1.dc33f3a622143p+764,   -0x1.fb9fdf62bbabdp-1,   0x1.7b784ap-2, INEXACT)
T(RN,   0x1.50f7d10c2102p+764,    0x1.c8c552ace0896p-1,  -0x1.a4892ep-3, INEXACT)
T(RN,  0x1.a6ea4aded1efap+764,    0x1.ff2ab09a95b26p-1,   0x1.68ddf6p-2, INEXACT)
T(RN,  0x1.40962e3dff447p+764,   -0x1.c53c79d0a5c71p-1,  -0x1.ddb5acp-2, INEXACT)
T(RN,  0x1.fdb0737425834p+764,    0x1.3af0642b2231cp-1,  -0x1.a9ca58p-4, INEXACT)
T(RN,  0x1.2616da382b712p+764,   -0x1.4ad7609f02ac8p-1,  -0x1.bf767cp-2, INEXACT)
T(RN,  0x1.1404197049948p+764,    0x1.4c9dd06b071fep-2,   0x1.788148p-4, INEXACT)
T(RN,  0x1.52c4e1d7fecccp+764,    0x1.4f8ab86634c64p-1,   0x1.905e28p-2, INEXACT)
T(RN,  0x1.ea2105d78c795p+764,   -0x1.f766600b927fep-1,  -0x1.cbfc92p-3, INEXACT)
T(RN,  0x1.c05472a984afep+764,    0x1.e6fa3d7be0a0ep-1,   -0x1.0e276p-2, INEXACT)
T(RN,  0x1.1225a45dbe641p+765,   -0x1.97c2ef6b404a4p-2,  -0x1.806e4ap-2, INEXACT)
T(RN,  0x1.9987a5bec5138p+765,   -0x1.8c69cf3ed32bep-1,   0x1.9713d2p-2, INEXACT)
T(RN,  0x1.52c11eaa40101p+765,   -0x1.79b0a08a6f8fcp-1,   0x1.940b54p-6, INEXACT)
T(RN,  0x1.f312daf8e854bp+765,   -0x1.a4416f2430045p-5,   0x1.87b0cep-4, INEXACT)
T(RN,   0x1.16fe8be1668dp+765,    0x1.9659bbb14e59fp-3,    0x1.effa2p-4, INEXACT)
T(RN,   0x1.e3c1e4c46d65p+765,   -0x1.9114162f3f232p-1,  -0x1.3ac834p-3, INEXACT)
T(RN,   0x1.5e8a55f88381p+765,   -0x1.b5bf94367ea36p-1,  -0x1.46c396p-4, INEXACT)
T(RN,  0x1.dc53f9ac7bbcfp+765,    0x1.2994a75baf52cp-1,   0x1.107924p-8, INEXACT)
T(RN,  0x1.87bd30bef21a8p+765,   -0x1.18fa72fc5e2bfp-1,  -0x1.4f2544p-2, INEXACT)
T(RN,  0x1.1cbe7bbc60b4ap+765,   -0x1.c51b52848f9d4p-1,   0x1.3455a4p-3, INEXACT)
T(RN,  0x1.70727c80db35cp+766,   -0x1.ff3513983d1f6p-1,   0x1.97d5aep-2, INEXACT)
T(RN,  0x1.b022eb271c606p+766,   -0x1.c363fcacff837p-1,   0x1.8c465ap-2, INEXACT)
T(RN,  0x1.bfc2949db992cp+766,    0x1.f68d89e9a28a1p-1,  -0x1.24dcd4p-3, INEXACT)
T(RN,  0x1.a7f2195810116p+766,    0x1.8bbd6fb8ee355p-1,   -0x1.daa31p-2, INEXACT)
T(RN,  0x1.eb0afe3be0571p+766,   -0x1.16c6954063ea3p-2,   0x1.a7a0d4p-9, INEXACT)
T(RN,  0x1.c3a8b1562184cp+766,   -0x1.e1a53b5976a6dp-1,  -0x1.962e74p-2, INEXACT)
T(RN,  0x1.ab944157ab0a6p+766,    0x1.113c85973a5e4p-1,    0x1.f7bdfp-4, INEXACT)
T(RN,  0x1.8076b174457bep+766,    0x1.daa45b81827e7p-1,   0x1.4321cep-2, INEXACT)
T(RN,   0x1.627811ef516ep+766,    0x1.dcc831e8b32d1p-2,   0x1.e8e57ep-2, INEXACT)
T(RN,  0x1.d4745077f5a43p+766,    0x1.ff0f663f2f29ap-1,  -0x1.09070ep-2, INEXACT)
T(RN,   0x1.843221d1ee9fp+767,    0x1.484a6aa953257p-1,    0x1.fe727p-2, INEXACT)
T(RN,  0x1.74053bb3856e6p+767,   -0x1.45dfb56b7ac36p-1,  -0x1.daae7cp-4, INEXACT)
T(RN,  0x1.51b84d285f15fp+767,   -0x1.828e57ee48839p-4,   0x1.c62a3ap-3, INEXACT)
T(RN,  0x1.062fdeffde16dp+767,    -0x1.398a21f46473p-1,  -0x1.80cb1ap-2, INEXACT)
T(RN,  0x1.42a85f71845a6p+767,    0x1.d9688b3768a59p-1,   0x1.e5721cp-4, INEXACT)
T(RN,  0x1.fc03c24cb2e79p+767,   -0x1.d12511d1cb349p-1,  -0x1.b85e7ap-4, INEXACT)
T(RN,  0x1.30a11782cb594p+767,   -0x1.f0deeb707a355p-1,   0x1.274bbep-2, INEXACT)
T(RN,  0x1.2c1c6e230646ep+767,   -0x1.fcd3b1b1259dap-1,  -0x1.a0b50ep-2, INEXACT)
T(RN,  0x1.7d89a3c2bcf0fp+767,    0x1.eb0ca5e6bb58dp-2,   0x1.bb6a8ep-3, INEXACT)
T(RN,  0x1.40ee1c78777e6p+767,    0x1.ff8a55ca40042p-1,  -0x1.a2013ep-2, INEXACT)
T(RN,  0x1.8b8bf7e569fe4p+768,    0x1.fdba829a19771p-1,  -0x1.2edfc6p-2, INEXACT)
T(RN,  0x1.242a63fce870fp+768,    0x1.acac5500bf3c9p-2,  -0x1.0e2b36p-3, INEXACT)
T(RN,  0x1.c32bdab62a4d2p+768,   -0x1.fff5295a3281fp-1,   0x1.ab5916p-3, INEXACT)
T(RN,  0x1.a63e4e0e608c6p+768,   -0x1.7629ab6356c53p-2,   0x1.ad5acap-3, INEXACT)
T(RN,  0x1.2345432033ab6p+768,   -0x1.fedf534bfc55ep-1,   0x1.c7f8dep-8, INEXACT)
T(RN,  0x1.fdc4df80ca5bcp+768,   -0x1.b04a3cd5d31cap-1,   0x1.4e4b98p-3, INEXACT)
T(RN,  0x1.6310b1513eb82p+768,    0x1.c627b488bce75p-7,  -0x1.3d07dcp-2, INEXACT)
T(RN,  0x1.fa3213f4aad4ep+768,    0x1.58432a0e0fb29p-1,  -0x1.fcbf36p-2, INEXACT)
T(RN,  0x1.be508a2b93d8bp+768,    0x1.bca95b64b5abdp-1,  -0x1.0184b4p-4, INEXACT)
T(RN,  0x1.bdbb8e68c7b48p+768,   -0x1.f332a7da1b8c6p-1,   -0x1.aff5bp-2, INEXACT)
T(RN,  0x1.86f429bea48cdp+769,    0x1.eb45d9bf8466ep-1,  -0x1.93a432p-5, INEXACT)
T(RN,  0x1.8c8befb4b08ecp+769,    0x1.933c1d4e4ed82p-1,   0x1.a0f55cp-2, INEXACT)
T(RN,  0x1.cbea8e0bc6fafp+769,   -0x1.36597dc636f16p-2,  -0x1.7a1e76p-3, INEXACT)
T(RN,  0x1.df5b6b6fa040dp+769,    0x1.8eade67127261p-2,   0x1.d2842ap-2, INEXACT)
T(RN,  0x1.6e35807ded5bap+769,   -0x1.67e18d9c5a77dp-1,  -0x1.7bbbb8p-3, INEXACT)
T(RN,  0x1.b7eb20d103054p+769,    0x1.ffa50a1376923p-1,   0x1.0ba6b6p-2, INEXACT)
T(RN,    0x1.bf67b2086fdp+769,    0x1.4de2487b1ddc1p-1,   0x1.813e6ap-3, INEXACT)
T(RN,  0x1.581e1e74608c3p+769,    0x1.b2ddd93466aaap-1,  -0x1.4904d2p-5, INEXACT)
T(RN,  0x1.1f2bd77a076cap+769,    0x1.32b38c041f6edp-2,  -0x1.7607aap-2, INEXACT)
T(RN,  0x1.d10de1c59ba56p+769,    0x1.21892568b9e1dp-3,   0x1.2d05a6p-6, INEXACT)
T(RN,   0x1.407c97136614p+770,    0x1.dcfd97e65c92fp-2,  -0x1.eeeceap-3, INEXACT)
T(RN,  0x1.6d59a62d0c8b1p+770,   -0x1.40d96de431805p-2,    0x1.d2bd3p-3, INEXACT)
T(RN,  0x1.539c5b700a36ep+770,   -0x1.f265611122bcfp-1,   0x1.2487ccp-2, INEXACT)
T(RN,  0x1.2f05c4764b70fp+770,    0x1.f5e7a9d200e39p-1,  -0x1.fe6fe2p-2, INEXACT)
T(RN,  0x1.ab0cd106c0bc2p+770,    0x1.c7175564df1dap-1,  -0x1.6156f6p-3, INEXACT)
T(RN,  0x1.c30ede37b45a4p+770,   -0x1.d0d8c9fad9632p-1,   0x1.f09ce8p-2, INEXACT)
T(RN,  0x1.36eae16b961f1p+770,    0x1.5ee1e24db0f09p-1,   0x1.d7ab36p-4, INEXACT)
T(RN,  0x1.14a0c9d08baf4p+770,    0x1.fdce5c7e35017p-1,   0x1.b04eb6p-2, INEXACT)
T(RN,  0x1.838589605113ep+770,    0x1.9e6ed759c3593p-1,    0x1.e3c37p-2, INEXACT)
T(RN,  0x1.2ecade3bc7f1bp+770,   -0x1.2cc8696dea079p-2,   0x1.46b878p-2, INEXACT)
T(RN,  0x1.8f83567c01c46p+771,   -0x1.f8d9d87b9d29ap-2,   0x1.6215f2p-3, INEXACT)
T(RN,  0x1.94f4d877ce656p+771,    0x1.aea09f3361b0ap-2,  -0x1.c8ea2ep-5, INEXACT)
T(RN,  0x1.03b585142304ap+771,    0x1.283707bdf4ab5p-3,    0x1.8a8dep-2, INEXACT)
T(RN,   0x1.8cdc8c8d585bp+771,   -0x1.90dc33b656acep-2,  -0x1.ee6914p-2, INEXACT)
T(RN,  0x1.793fb08f970dep+771,    0x1.d8bac6698b81ep-2,   0x1.1c12e6p-3, INEXACT)
T(RN,  0x1.a191ec9aaf148p+771,    0x1.86133f40c7a89p-4,   0x1.325a06p-2, INEXACT)
T(RN,  0x1.449c0abdd5c9bp+771,    0x1.0b397c3b0c0ecp-2,   0x1.777052p-3, INEXACT)
T(RN,  0x1.261f69040f0e1p+771,   -0x1.4cfb0a53833f6p-1,  -0x1.12e7dcp-5, INEXACT)
T(RN,   0x1.45f17a6f3bdbp+771,   -0x1.5f370e348df9ap-1,  -0x1.60f6acp-4, INEXACT)
T(RN,  0x1.ba083ac20369ap+771,    0x1.fef5e8aa47a39p-1,   0x1.86f03ep-2, INEXACT)
T(RN,  0x1.8a12a097410b8p+772,    0x1.42a668328f354p-1,  -0x1.3c8278p-2, INEXACT)
T(RN,  0x1.5a9663837c14ap+772,   -0x1.632188eb39b2dp-1,   0x1.84a2bep-4, INEXACT)
T(RN,  0x1.4c44cf56d9d8ap+772,   -0x1.678723ace6218p-2,  -0x1.9b2bdap-3, INEXACT)
T(RN,  0x1.1532a6186a9fep+772,    0x1.fe09d54284378p-1,  -0x1.050a64p-2, INEXACT)
T(RN,   0x1.ed39f4064f3ap+772,    0x1.a18c0298bba95p-1,   0x1.f6b49cp-2, INEXACT)
T(RN,  0x1.230464c8ba194p+772,     0x1.a3f552cf9aa4p-1,   0x1.f31f8ap-2, INEXACT)
T(RN,  0x1.5a4bf4fd698aap+772,   -0x1.53e63e2c11193p-1,  -0x1.1b4ec8p-3, INEXACT)
T(RN,  0x1.34d151cad31bcp+772,   -0x1.d35e35a21db47p-1,   0x1.f5deeap-3, INEXACT)
T(RN,  0x1.326eafc8b7a0ep+772,   -0x1.38bac54c87f57p-1,    0x1.963d9p-2, INEXACT)
T(RN,  0x1.92118768eb935p+772,   -0x1.df68098e100d2p-1,   0x1.4babe8p-3, INEXACT)
T(RN,  0x1.61815efdf1aeep+773,    0x1.5d2d2dc43834fp-3,  -0x1.bbf736p-2, INEXACT)
T(RN,  0x1.8d52dff873a0ap+773,   -0x1.fe13f15ca0c06p-1,  -0x1.6d9fd8p-3, INEXACT)
T(RN,  0x1.d2ef2b525e60ap+773,    0x1.ac25f6ff20c84p-3,   0x1.bd4d4ap-5, INEXACT)
T(RN,  0x1.b38577011b464p+773,    0x1.d097948c9569cp-1,  -0x1.9d18c6p-4, INEXACT)
T(RN,  0x1.045635177cdd3p+773,    0x1.9f1397d8520e3p-1,    0x1.e70f8p-3, INEXACT)
T(RN,  0x1.c42c9b1aa4295p+773,    0x1.3d2ccea6d90f4p-2,   0x1.958c58p-2, INEXACT)
T(RN,  0x1.817a6e113889cp+773,   -0x1.2740d663bf045p-2,  -0x1.26212ep-2, INEXACT)
T(RN,  0x1.01bc4c282f8c1p+773,   -0x1.5752474ce8259p-8,  -0x1.60fdd8p-3, INEXACT)
T(RN,  0x1.f620bff59c46fp+773,   -0x1.bfac3bccdf5d9p-1,  -0x1.cd4748p-2, INEXACT)
T(RN,   0x1.a4f8de314b0fp+773,   -0x1.0d6d1a85ff8bcp-1,   0x1.c75902p-2, INEXACT)
T(RN,   0x1.a9e2ed244be9p+774,   -0x1.b86bee6fffeb5p-1,   0x1.50555cp-2, INEXACT)
T(RN,  0x1.5a89505053cc4p+774,   -0x1.62141d54e865fp-1,  -0x1.17b742p-3, INEXACT)
T(RN,    0x1.f1b06157f1fp+774,    0x1.1b9ca06065307p-2,  -0x1.add014p-2, INEXACT)
T(RN,  0x1.2ae180d1e7ce7p+774,   -0x1.2d69cc13419c7p-2,    0x1.85633p-5, INEXACT)
T(RN,  0x1.b649b0992d35ap+774,   -0x1.0183bbbade314p-1,   0x1.6c7436p-2, INEXACT)
T(RN,  0x1.ace7d23e12558p+774,   -0x1.ffc523d70bd5cp-1,  -0x1.a14a8cp-2, INEXACT)
T(RN,  0x1.9995a215b303ap+774,   -0x1.963a7e8442298p-1,  -0x1.6384e6p-6, INEXACT)
T(RN,  0x1.e9147d9561304p+774,    0x1.c186f86ccb0ecp-1,   0x1.1ef4fep-3, INEXACT)
T(RN,  0x1.df87f72f5714ap+774,    0x1.b55459c978328p-2,   0x1.59160ap-7, INEXACT)
T(RN,  0x1.db3bdc9062176p+774,     0x1.40b5659b2d32p-1,   -0x1.96cfbp-2, INEXACT)
T(RN,  0x1.ae7595c8de05ep+775,    0x1.e142ee55fa9e5p-1,    0x1.eda25p-3, INEXACT)
T(RN,  0x1.a02fc86df8f83p+775,   -0x1.774dc4a1eddc3p-3,  -0x1.c67694p-2, INEXACT)
T(RN,  0x1.6e6942d6a16cdp+775,    0x1.60eee22c3b5ebp-2,   0x1.450d7cp-2, INEXACT)
T(RN,  0x1.fe99682fdd8d4p+775,    0x1.c36c93f4478cep-2,   -0x1.4ea48p-2, INEXACT)
T(RN,  0x1.e6c8abbd10076p+775,    -0x1.4017ab56087bp-4,    0x1.d097cp-3, INEXACT)
T(RN,  0x1.1935d0a285f18p+775,    0x1.eb89794acd7adp-4,  -0x1.9779ecp-2, INEXACT)
T(RN,  0x1.64ac3327b1268p+775,    0x1.ffaae803a7b11p-1,   -0x1.e9b38p-7, INEXACT)
T(RN,  0x1.87417d6233c6ap+775,   -0x1.fdbd72b96e329p-1,  -0x1.ffbe3cp-4, INEXACT)
T(RN,  0x1.621a9abf02cb7p+775,    0x1.fccce399ae63dp-1,  -0x1.659374p-2, INEXACT)
T(RN,  0x1.db2acd9df6614p+775,   -0x1.8299f8568aa41p-1,   -0x1.5fca4p-3, INEXACT)
T(RN,  0x1.4e5c5de61f065p+776,    0x1.8c8d2b740155cp-1,  -0x1.146f68p-2, INEXACT)
T(RN,  0x1.73c5622a9acaap+776,    0x1.5bfc76b2aaf1cp-1,   0x1.9373d4p-2, INEXACT)
T(RN,  0x1.f116bd157681ap+776,    0x1.ce3af8a3b70eap-1,  -0x1.3e701cp-2, INEXACT)
T(RN,  0x1.c2315027f14eep+776,     0x1.0840b039c4d4p-2,  -0x1.1038acp-4, INEXACT)
T(RN,  0x1.62d1287ac9c97p+776,    0x1.f97bdce72cfffp-1,  -0x1.d4db22p-2, INEXACT)
T(RN,  0x1.ae4db2c8d3adbp+776,   -0x1.515a18c77f73bp-4,   0x1.f9c492p-2, INEXACT)
T(RN,  0x1.651766c9bb518p+776,   -0x1.f9ebdfc29df98p-1,   0x1.5d17dep-2, INEXACT)
T(RN,  0x1.0686b9706fa44p+776,    0x1.b3f45f8949fc9p-1,   0x1.7205b4p-2, INEXACT)
T(RN,  0x1.89be7d0233b0ap+776,   -0x1.483cd0ab008b3p-1,  -0x1.eee2e8p-3, INEXACT)
T(RN,  0x1.c5b34bb6e20e4p+776,    0x1.281cfe65738d8p-3,  -0x1.df7e7ep-2, INEXACT)
T(RN,  0x1.b7923397ba986p+777,   -0x1.f0e940a02e5dbp-1,  -0x1.b9124ep-2, INEXACT)
T(RN,  0x1.f02722806795cp+777,   -0x1.eb7795053afa4p-1,   0x1.e6bb1ap-4, INEXACT)
T(RN,  0x1.4cf6a9996ccd8p+777,    0x1.950ca39116a34p-1,   0x1.6f33e2p-4, INEXACT)
T(RN,  0x1.b39c3bc965694p+777,    0x1.dfd75ac8428dfp-1,  -0x1.3e9492p-3, INEXACT)
T(RN,  0x1.db5f939146e36p+777,    0x1.928fcff646aedp-1,    0x1.61a57p-2, INEXACT)
T(RN,  0x1.d79e40d9b3461p+777,   -0x1.b914d085004d3p-2,   0x1.e3e60ap-2, INEXACT)
T(RN,  0x1.43b65f4b35716p+777,   -0x1.ed71fc4244b17p-1,  -0x1.06c154p-2, INEXACT)
T(RN,  0x1.3d2df531c0eb8p+777,    0x1.fde711785ce29p-1,   0x1.742342p-4, INEXACT)
T(RN,  0x1.446f1516c457fp+777,    0x1.feee69cb2ede1p-1,   0x1.08292cp-4, INEXACT)
T(RN,  0x1.9de4fe6a14caap+777,    0x1.5af7899c23b74p-6,   0x1.31fbccp-2, INEXACT)
T(RN,  0x1.ebb4ecef66651p+778,   -0x1.89942f4ce0543p-4,   0x1.bcdcc6p-5, INEXACT)
T(RN,  0x1.5a0d0fd5c651fp+778,    0x1.c4ec9c590e595p-2,   0x1.503b04p-3, INEXACT)
T(RN,  0x1.12e71ae8ffe64p+778,    0x1.cce4af4da0dcep-1,   -0x1.eb58fp-3, INEXACT)
T(RN,  0x1.3906c82a10958p+778,   -0x1.e3fdc56fb376fp-2,    0x1.f5229p-2, INEXACT)
T(RN,     0x1.907843cf48p+778,    0x1.eea5d8955ec13p-1,  -0x1.16d2d4p-2, INEXACT)
T(RN,  0x1.67c13a5a474cdp+778,    0x1.81aada9dd22a5p-1,   0x1.aa86eap-2, INEXACT)
T(RN,  0x1.e9a9447a7f0e7p+778,    0x1.ae16ff2c35e77p-1,   0x1.cbc6f4p-3, INEXACT)
T(RN,  0x1.08cbd096540f1p+778,   -0x1.f3cc08d4bc2dcp-1,  -0x1.1f08c2p-2, INEXACT)
T(RN,  0x1.963a50f483097p+778,    0x1.9deec86913e48p-1,  -0x1.df8d14p-3, INEXACT)
T(RN,  0x1.7f42c8005e07dp+778,    0x1.c865e04f677ddp-4,   0x1.ed27e4p-3, INEXACT)
T(RN,  0x1.67dd443f61d45p+779,    0x1.b83ac5a353a4ap-1,   0x1.23dbe6p-3, INEXACT)
T(RN,  0x1.1ad0b975aed4ap+779,   -0x1.d8e3c336904d5p-2,  -0x1.5c1d8ep-4, INEXACT)
T(RN,   0x1.ca72bb2a93b4p+779,    0x1.4757c93f36a4ap-2,  -0x1.479c1ep-3, INEXACT)
T(RN,  0x1.796fb3046773ap+779,   -0x1.27ebc08ec08d5p-1,    0x1.4c503p-2, INEXACT)
T(RN,  0x1.f209eee8319eep+779,   -0x1.a3b2be6986e8bp-1,   0x1.94f1a4p-2, INEXACT)
T(RN,  0x1.2340bddcf8a64p+779,    0x1.6bbb1225b0948p-1,  -0x1.993306p-3, INEXACT)
T(RN,  0x1.d4f0a40fac746p+779,     0x1.9f8291d98097p-1,  -0x1.5d840ap-2, INEXACT)
T(RN,  0x1.67ed825ef6cbcp+779,   -0x1.649f9592458e1p-1,   0x1.ee09f8p-2, INEXACT)
T(RN,  0x1.455c2f47eb5b5p+779,    0x1.a0ad7952d0d37p-3,  -0x1.7ec8f2p-2, INEXACT)
T(RN,  0x1.6ee485ea4ccecp+779,    0x1.48839c955b901p-1,   0x1.8b224ep-2, INEXACT)
T(RN,  0x1.9c717bb270e48p+780,   -0x1.0ad2ecf0083e6p-6,   0x1.dc8112p-4, INEXACT)
T(RN,  0x1.a0ff47a19e12cp+780,    0x1.f871e8372537bp-1,  -0x1.bc9642p-6, INEXACT)
T(RN,   0x1.a7647c307fd6p+780,    -0x1.3bdc8adb7ea9p-2,   0x1.8d5c66p-4, INEXACT)
T(RN,   0x1.982e303e8c92p+780,    0x1.b7696b20f06d4p-1,   0x1.7bc702p-2, INEXACT)
T(RN,  0x1.b6a88a5fed8aep+780,    0x1.9ffa3ff983b79p-2,   0x1.d6aa6ep-4, INEXACT)
T(RN,  0x1.012c12b3f0d9cp+780,    0x1.f794cf840084dp-1,   0x1.7969a6p-2, INEXACT)
T(RN,  0x1.f7d5490cf8274p+780,   -0x1.7fa7a3a3f6e7ap-1,   0x1.a1b8d2p-2, INEXACT)
T(RN,  0x1.9d76ddd4e5ecep+780,    -0x1.b557be4ef1c9p-1,   0x1.18929cp-2, INEXACT)
T(RN,  0x1.ac5d61f2d907ap+780,    0x1.a6f911632f9e7p-1,   0x1.7dbac8p-2, INEXACT)
T(RN,  0x1.173a4480af28fp+780,    0x1.90423e89516a9p-1,   0x1.cd24fcp-2, INEXACT)
T(RN,  0x1.354b6fb15b182p+781,   -0x1.33823335567bcp-1,   0x1.602538p-3, INEXACT)
T(RN,  0x1.850bd2431be13p+781,    0x1.c9920f3c1a7a7p-1,  -0x1.d960fap-4, INEXACT)
T(RN,  0x1.4a48e38f35432p+781,   -0x1.ce3f02dd4dd24p-1,    0x1.09817p-2, INEXACT)
T(RN,  0x1.cd3f299e7b52cp+781,   -0x1.7cc3cdf200725p-1,  -0x1.6c4452p-3, INEXACT)
T(RN,  0x1.3ce94ca0d7bd8p+781,    0x1.ffe1191aa47efp-1,   0x1.5667e2p-4, INEXACT)
T(RN,  0x1.a80e349267ef2p+781,   -0x1.c3ff90deab758p-1,   0x1.60a234p-2, INEXACT)
T(RN,  0x1.20a46664fae25p+781,    0x1.9505cb957ba22p-1,   0x1.6a9fbcp-2, INEXACT)
T(RN,  0x1.673df8f261d21p+781,   -0x1.4af0a08311879p-1,   0x1.833508p-2, INEXACT)
T(RN,  0x1.3efbaaac6531ap+781,   -0x1.c7b3bcecc43f2p-2,  -0x1.bac8eap-2, INEXACT)
T(RN,  0x1.b1e19e784f2f6p+781,    0x1.3f7608d208d61p-2,   -0x1.57e1fp-5, INEXACT)
T(RN,  0x1.53bc7f5b1425dp+782,    0x1.efba100418f6cp-1,  -0x1.0ed228p-2, INEXACT)
T(RN,  0x1.6d75b519ee93cp+782,    0x1.57106efac588ep-2,   0x1.16946ep-2, INEXACT)
T(RN,  0x1.8602d78cded2cp+782,    0x1.89d06ccb9fda5p-2,  -0x1.20838cp-2, INEXACT)
T(RN,  0x1.a6887ce73e39fp+782,    0x1.fd816485a7f1ap-1,  -0x1.44a1eep-2, INEXACT)
T(RN,  0x1.2a643c42c33d2p+782,    0x1.bde9e22a75661p-1,   0x1.cc49bap-2, INEXACT)
T(RN,  0x1.94c24bc584b66p+782,   -0x1.d0f293e70f5b6p-1,   -0x1.461dep-3, INEXACT)
T(RN,  0x1.0c707e479b5fbp+782,    0x1.2ff69fa7f3781p-3,  -0x1.ebe59cp-2, INEXACT)
T(RN,  0x1.d13d57d694bc2p+782,    0x1.ee63aff34b2a1p-2,   0x1.31608ap-2, INEXACT)
T(RN,  0x1.6cf3aa94659eep+782,    0x1.f2f86c0ec4b4bp-1,   0x1.bf8688p-5, INEXACT)
T(RN,  0x1.2b0f84e71c1aap+782,   -0x1.8c379dacc2f2fp-3,  -0x1.eafdbep-2, INEXACT)
T(RN,  0x1.83de7be55e066p+783,   -0x1.d29fd47c99cf7p-1,   0x1.bb1df4p-2, INEXACT)
T(RN,   0x1.ff5be47da34ap+783,    0x1.f54e85fa3bb0ap-4,   0x1.e9f068p-5, INEXACT)
T(RN,  0x1.c968f39f7de7dp+783,    0x1.14a761cd32d4dp-1,  -0x1.b374fap-4, INEXACT)
T(RN,  0x1.4d68a607455e5p+783,   -0x1.92c7e8f7c543fp-4,  -0x1.dc7476p-2, INEXACT)
T(RN,  0x1.f0556ecc70dc2p+783,    0x1.415f673256b0cp-1,  -0x1.d9915ap-2, INEXACT)
T(RN,  0x1.2d107cbe11d41p+783,   -0x1.2b89cd7c2ad7ep-4,  -0x1.84fd48p-2, INEXACT)
T(RN,  0x1.1737f490a7172p+783,    0x1.fff8f4479ef34p-1,   0x1.01eb56p-2, INEXACT)
T(RN,  0x1.9d721d7642b97p+783,   -0x1.1425d9587c414p-3,  0x1.286678p-11, INEXACT)
T(RN,  0x1.7460a22d05f22p+783,   -0x1.8d89a34e3a71cp-4,   0x1.25e79cp-3, INEXACT)
T(RN,  0x1.c35f43d2c88bap+783,    0x1.51ffd966db004p-2,  -0x1.35a0d4p-2, INEXACT)
T(RN,  0x1.d60a1db07bf65p+784,   -0x1.f98a1f8d1b494p-1,   -0x1.a8e7dp-4, INEXACT)
T(RN,  0x1.9a962a14a640bp+784,   -0x1.a59b209f16b27p-4,   0x1.2db65ap-2, INEXACT)
T(RN,  0x1.b5da0c2f02014p+784,    0x1.4037033047abep-1,  -0x1.eb2346p-2, INEXACT)
T(RN,  0x1.0a1a333eea197p+784,     0x1.8c9e2df13cb1p-4,   -0x1.01064p-2, INEXACT)
T(RN,  0x1.5b2f2a87ac403p+784,   -0x1.8089c03e0d35ep-2,  -0x1.74a286p-3, INEXACT)
T(RN,  0x1.7c2ca0a86bfd2p+784,    0x1.57a56b4110051p-1,   0x1.89853ep-6, INEXACT)
T(RN,  0x1.bb84cdd9dba52p+784,   -0x1.d838fc0e31112p-2,  -0x1.22250ap-2, INEXACT)
T(RN,  0x1.27fc11bccc599p+784,    0x1.ffdb4681a8dfep-1,  -0x1.478416p-2, INEXACT)
T(RN,   0x1.89146012b4e2p+784,   -0x1.4dc0c315c7547p-1,  -0x1.e69d88p-2, INEXACT)
T(RN,  0x1.237ec4885e8edp+784,   -0x1.c4f894830d5b7p-1,   0x1.5b4db8p-2, INEXACT)
T(RN,  0x1.bdcc2c5428ce2p+785,    0x1.b0eebb757714dp-3,  -0x1.e4a81cp-2, INEXACT)
T(RN,  0x1.ca10dc57bd4e2p+785,   -0x1.3aec249fbf01fp-1,  -0x1.a0972ap-2, INEXACT)
T(RN,  0x1.5eeb1611ee0b3p+785,    -0x1.e80108688e6dp-1,   0x1.50d32ap-2, INEXACT)
T(RN,  0x1.ad507746d42acp+785,   -0x1.a86a91f8aaefdp-3,   0x1.3f108cp-7, INEXACT)
T(RN,   0x1.70efb22ea6e5p+785,    0x1.348a74d36e955p-2,    0x1.443edp-3, INEXACT)
T(RN,  0x1.cdd96368676cap+785,   -0x1.4ac33c30700fdp-1,   0x1.b2bfe6p-2, INEXACT)
T(RN,  0x1.cbe731a785dcdp+785,   -0x1.f5c8b254b33fbp-1,   0x1.c21376p-2, INEXACT)
T(RN,  0x1.02b4b180809ccp+785,   -0x1.d8686a081e3b6p-2,   0x1.9fb4eap-5, INEXACT)
T(RN,  0x1.acb4ef7b8f35fp+785,    0x1.822929d348e0cp-1,  -0x1.eb1244p-2, INEXACT)
T(RN,  0x1.8c3e581e1c74ep+785,   -0x1.d3eba6fa39179p-1,  -0x1.78c336p-2, INEXACT)
T(RN,  0x1.e4eedb3c60417p+786,    0x1.f117b8dbd4987p-1,   0x1.209598p-2, INEXACT)
T(RN,  0x1.90d432fec9244p+786,    0x1.91182c499d669p-2,   0x1.e527e6p-4, INEXACT)
T(RN,  0x1.fc7795e7dfc6fp+786,   -0x1.effc3e73e8cfap-1,  -0x1.7dc982p-2, INEXACT)
T(RN,  0x1.e6302b7fc4fa3p+786,   -0x1.9183cefecfe28p-1,   0x1.22ad9p-10, INEXACT)
T(RN,  0x1.fb6970a3d2e49p+786,   -0x1.52aafd7c4fcb4p-1,   0x1.d2a0aep-2, INEXACT)
T(RN,  0x1.9b78c9837ec8bp+786,    0x1.69bbc9dd381f6p-1,  -0x1.80ce94p-2, INEXACT)
T(RN,  0x1.d6b67934c5c3ep+786,     0x1.93416d147388p-2,  -0x1.18c428p-5, INEXACT)
T(RN,  0x1.d03086779e8f8p+786,    -0x1.af1b9942d39ap-1,   0x1.95a7dcp-2, INEXACT)
T(RN,  0x1.79672dce18331p+786,   -0x1.f04f604e72517p-1,   0x1.ed4bd8p-2, INEXACT)
T(RN,  0x1.c291c9287a538p+786,    0x1.d3adae89932fap-1,   0x1.b18232p-2, INEXACT)
T(RN,  0x1.2191f39716506p+787,   -0x1.fd79fb2dc3307p-1,    0x1.d0609p-3, INEXACT)
T(RN,  0x1.55bbc42120029p+787,    0x1.339f7d82be062p-1,  -0x1.d5d548p-2, INEXACT)
T(RN,  0x1.9130d7c25303fp+787,    0x1.f502d5189903cp-1,   0x1.6be796p-2, INEXACT)
T(RN,  0x1.bfca35d809456p+787,    0x1.fde472ee9b97fp-1,   0x1.68e25ap-2, INEXACT)
T(RN,  0x1.9cf289d10c868p+787,    0x1.669535a2cf2b6p-1,    0x1.c5795p-2, INEXACT)
T(RN,  0x1.bb37d0e07f1aap+787,    0x1.117ae8622b98ap-1,   0x1.f9c096p-3, INEXACT)
T(RN,  0x1.68a726980ff62p+787,    0x1.d54b3f484b10ep-1,   0x1.f026acp-4, INEXACT)
T(RN,  0x1.e3389210acab1p+787,   -0x1.ece510b5df67fp-1,  -0x1.31a208p-2, INEXACT)
T(RN,  0x1.256cbbd0bd209p+787,   -0x1.e68a804948b15p-1,    0x1.9f759p-5, INEXACT)
T(RN,  0x1.7163ee9b3a93fp+787,   -0x1.d2f0b14144b4ep-3,    0x1.e05afp-2, INEXACT)
T(RN,  0x1.9e553db374a94p+788,    0x1.b0364ee17dbd2p-1,  -0x1.8cb8d6p-3, INEXACT)
T(RN,  0x1.b6457a827900dp+788,   -0x1.8d49625122c2dp-1,  -0x1.0c9a24p-2, INEXACT)
T(RN,  0x1.98618b13cb2d2p+788,     0x1.867bfc2b7d9bp-1,   0x1.368d48p-4, INEXACT)
T(RN,  0x1.e2caea2a32713p+788,   -0x1.3bc99e3d129e7p-4,   0x1.fafe5cp-4, INEXACT)
T(RN,  0x1.050846a9a2a2cp+788,   -0x1.cd7fd931d9318p-1,   0x1.7ae346p-4, INEXACT)
T(RN,  0x1.70d0b494b38ccp+788,   -0x1.611b8e3cde181p-1,  -0x1.a0d40cp-2, INEXACT)
T(RN,    0x1.dae40866c52p+788,   -0x1.7b17ef30c50f8p-4,  -0x1.c5044cp-4, INEXACT)
T(RN,  0x1.2754949bd49e5p+788,   -0x1.fef3cfc680e6ap-1,  -0x1.85595ep-2, INEXACT)
T(RN,  0x1.932988ea3b3e8p+788,   -0x1.c82ff9faf1aeep-1,   0x1.d3bf94p-2, INEXACT)
T(RN,   0x1.33b4aab1b384p+788,    0x1.c80e1951088cbp-1,  -0x1.16053ep-2, INEXACT)
T(RN,  0x1.2f1c97a7f3b96p+789,   -0x1.6c2fd9e40cddbp-1,  -0x1.e30472p-6, INEXACT)
T(RN,   0x1.85d391bdc7c4p+789,   -0x1.d68d8c0ed1fd3p-3,   0x1.cd85dcp-3, INEXACT)
T(RN,  0x1.86719ec4be3d8p+789,    0x1.7b5e5dbc18008p-4,  -0x1.1a2c36p-2, INEXACT)
T(RN,  0x1.10a745721262fp+789,   -0x1.ffe033a127a69p-1,  -0x1.ee5c42p-2, INEXACT)
T(RN,  0x1.85b174a4e7652p+789,    0x1.dd3e9cb65cab8p-8,   0x1.85822cp-2, INEXACT)
T(RN,  0x1.c668432e7bbdep+789,    0x1.f90386fac9a64p-1,  -0x1.fbff36p-2, INEXACT)
T(RN,  0x1.2284c2c825239p+789,    0x1.8a73acc4b0453p-1,   0x1.1e6f3ep-3, INEXACT)
T(RN,  0x1.9d749306a4385p+789,    0x1.93f7a8038c1b6p-1,  -0x1.c8eda2p-2, INEXACT)
T(RN,  0x1.15e036b724f3ap+789,    0x1.dd3e24322960ap-2,   0x1.70b4c8p-7, INEXACT)
T(RN,  0x1.7224e5d412036p+789,   -0x1.a2977d0f279bbp-2,   0x1.64da38p-4, INEXACT)
T(RN,  0x1.1d2d646cc837fp+790,   -0x1.51a3ca25cd54dp-5,  -0x1.09e3bcp-2, INEXACT)
T(RN,  0x1.e31b7aa16548ep+790,   -0x1.a99b54b15bb96p-2,  -0x1.d5f3b2p-2, INEXACT)
T(RN,  0x1.af255c4ec4cf2p+790,    -0x1.7e9f6da22687p-1,  -0x1.d76978p-2, INEXACT)
T(RN,  0x1.b63b96538f6f8p+790,    0x1.afd128bacf616p-1,   0x1.ae9ad6p-2, INEXACT)
T(RN,  0x1.0ee751f8eb2f6p+790,   -0x1.94d24783bd7abp-2,   0x1.87c30cp-2, INEXACT)
T(RN,  0x1.9f9c8ac99a8efp+790,    0x1.912d15d969ad4p-1,  -0x1.a846acp-2, INEXACT)
T(RN,  0x1.aa0a9de28aae5p+790,     0x1.ffdea03337c1p-1,  -0x1.79d852p-2, INEXACT)
T(RN,  0x1.88be3458792c4p+790,    0x1.e6f3f30b84e71p-1,  -0x1.bdd5f8p-7, INEXACT)
T(RN,  0x1.0936ebb571828p+790,   -0x1.d0485f156c95fp-1,    0x1.deca1p-4, INEXACT)
T(RN,  0x1.0f36517fb4e49p+790,   -0x1.b674f6417fdacp-2,  -0x1.c805bcp-2, INEXACT)
T(RN,   0x1.e2e708e862d5p+791,    0x1.b1733734edc68p-1,  -0x1.c1561ap-5, INEXACT)
T(RN,  0x1.3b7d3935b4481p+791,   -0x1.8315efc91d0c5p-2,  -0x1.7c1e64p-3, INEXACT)
T(RN,  0x1.458b0bfb9ed97p+791,    0x1.682a9d25c83ffp-2,  -0x1.6bff6ap-3, INEXACT)
T(RN,  0x1.7406dee72176bp+791,    0x1.f8d950dc39a75p-1,  -0x1.604338p-4, INEXACT)
T(RN,   0x1.bd39de7145bfp+791,   -0x1.e54df8e3d3554p-1,  -0x1.9e6f1cp-2, INEXACT)
T(RN,  0x1.4339f9864ac46p+791,   -0x1.37c7e8cb09355p-4,   0x1.290d22p-2, INEXACT)
T(RN,   0x1.54c93efcd18cp+791,    0x1.7e600229f4d56p-1,  -0x1.3deedcp-2, INEXACT)
T(RN,  0x1.5c759405ce352p+791,    0x1.666540b633845p-3,  -0x1.b72672p-3, INEXACT)
T(RN,  0x1.3593b2ddcaa84p+791,    0x1.cda8ebdd7789dp-1,   0x1.c13e28p-2, INEXACT)
T(RN,  0x1.0e1345f45fe46p+791,   -0x1.b9101adeeb318p-1,   0x1.fab2eap-5, INEXACT)
T(RN,  0x1.3bdd301df25e6p+792,    0x1.fd0fabec3ef0ep-1,  -0x1.0f1a64p-2, INEXACT)
T(RN,  0x1.e2e3939f394bbp+792,   -0x1.d28f486fc1edbp-3,   0x1.75e3acp-3, INEXACT)
T(RN,  0x1.5868e856710c7p+792,   -0x1.bd7d55045499ap-1,  -0x1.05e7eep-2, INEXACT)
T(RN,  0x1.4e0d49843f8b5p+792,    0x1.518983bbcebfep-1,  -0x1.43a0b8p-2, INEXACT)
T(RN,  0x1.2b21a89963b2fp+792,   -0x1.6a8eb54115a5dp-3,   0x1.d87e9ap-2, INEXACT)
T(RN,  0x1.2afc2e5e4a8b6p+792,   -0x1.ef1eeed3fbd8cp-1,  -0x1.db17a4p-2, INEXACT)
T(RN,  0x1.8e102670bd618p+792,   -0x1.1a812ae55e1a6p-3,  -0x1.88b8c6p-5, INEXACT)
T(RN,  0x1.5f72e5dca8148p+792,   -0x1.fa4d60000ec44p-1,   0x1.04fa1ep-6, INEXACT)
T(RN,  0x1.833480b864117p+792,    0x1.a821380569a49p-5,  -0x1.e946bcp-2, INEXACT)
T(RN,  0x1.65cfc6ef0c214p+792,   -0x1.d8fd29a949cd5p-1,  -0x1.49e904p-3, INEXACT)
T(RN,  0x1.5146ad727537bp+793,   -0x1.fca09642e9c9ap-1,  -0x1.c399fcp-2, INEXACT)
T(RN,  0x1.e132a0fb92792p+793,   -0x1.5acd57a311569p-2,  -0x1.4b23ccp-2, INEXACT)
T(RN,  0x1.4b80a9bfbc6a2p+793,    0x1.64d93f48bb472p-1,  -0x1.97639ep-2, INEXACT)
T(RN,  0x1.c57615805703fp+793,   -0x1.8d7ecba436f66p-1,   0x1.f4d994p-3, INEXACT)
T(RN,  0x1.04378db9c1077p+793,    0x1.e0985f85f3f86p-1,  -0x1.f76386p-7, INEXACT)
T(RN,  0x1.e754cb795be65p+793,   -0x1.2063997765b42p-4,  -0x1.f1f7d2p-2, INEXACT)
T(RN,  0x1.0a41914ac99eep+793,    0x1.8451f03004479p-2,   0x1.bca5aap-3, INEXACT)
T(RN,  0x1.742ed20476d49p+793,    0x1.ff3fc0ab41e1ep-1,    0x1.abea7p-3, INEXACT)
T(RN,  0x1.fc74333de51a6p+793,   -0x1.7fbaa947e7039p-3,   0x1.75b934p-5, INEXACT)
T(RN,  0x1.07eda5f76f4c3p+793,    0x1.ba26f00bb5bf9p-2,  -0x1.e2f0cap-2, INEXACT)
T(RN,  0x1.99fa1f1522d29p+794,    0x1.d97679aaaadd5p-1,   0x1.48d9d2p-2, INEXACT)
T(RN,    0x1.af82d72cea2p+794,   -0x1.ac7fcac33181fp-8,   0x1.a5fe74p-2, INEXACT)
T(RN,  0x1.b076a316e2ad6p+794,    0x1.06cc4470ac4f5p-5,  -0x1.3a48cep-2, INEXACT)
T(RN,  0x1.390a7c8e7562bp+794,   -0x1.20d3029ebf2b8p-4,  -0x1.6d39fcp-6, INEXACT)
T(RN,  0x1.83bba97e71da2p+794,   -0x1.a7ef89a603d7fp-3,  -0x1.51084cp-2, INEXACT)
T(RN,  0x1.10deac97da5afp+794,    0x1.0f38cb153872ap-1,   0x1.62a33ap-2, INEXACT)
T(RN,  0x1.bba38a72a90abp+794,   -0x1.9770280fd65acp-1,    0x1.abd74p-2, INEXACT)
T(RN,  0x1.0a45ba5c1010cp+794,     0x1.1a29fa51d2fep-2,   -0x1.ab0fcp-3, INEXACT)
T(RN,  0x1.855e39c5a4852p+794,   -0x1.f48889f998288p-1,   0x1.5ce642p-3, INEXACT)
T(RN,  0x1.6d3e5cfb7dd32p+794,   -0x1.9249121f48c12p-1,  -0x1.634632p-2, INEXACT)
T(RN,  0x1.53eb6cae0cf5ep+795,    0x1.35b6c84e74f61p-1,  -0x1.6d470cp-5, INEXACT)
T(RN,  0x1.76db5696c8b75p+795,   -0x1.f8adc4202fadcp-1,   0x1.012828p-2, INEXACT)
T(RN,  0x1.90601ee270b4fp+795,   -0x1.f58f6cff31debp-1,   0x1.c4e286p-3, INEXACT)
T(RN,  0x1.365da197edbe9p+795,    0x1.f3e2a53b62435p-1,   0x1.dcb664p-3, INEXACT)
T(RN,  0x1.d9a7f0d4bc478p+795,   -0x1.d10d3565efebap-1,   -0x1.d17ccp-4, INEXACT)
T(RN,  0x1.13979596ff621p+795,   -0x1.f35c86184797cp-3,   0x1.b8ff68p-5, INEXACT)
T(RN,  0x1.7d464a7d1e246p+795,   -0x1.f679f3b660d8cp-1,   0x1.790646p-2, INEXACT)
T(RN,  0x1.fa8a13f45b7b6p+795,    0x1.fb1d3fafd253fp-1,  -0x1.7b8b2ep-4, INEXACT)
T(RN,  0x1.50bab9983c812p+795,   -0x1.ff035d47d8578p-1,  -0x1.ae8df4p-2, INEXACT)
T(RN,  0x1.fb67e7ab10472p+795,    0x1.c54ac1341521cp-1,  -0x1.ab86dcp-2, INEXACT)
T(RN,  0x1.36b145d291607p+796,    0x1.a952a31d1666fp-6,  -0x1.9a32ecp-2, INEXACT)
T(RN,  0x1.4de1ffce67f7bp+796,    0x1.c3d49ee2daf28p-1,  -0x1.7e67acp-2, INEXACT)
T(RN,  0x1.10b1e2a6ddffbp+796,   -0x1.6d3a72d638226p-1,  -0x1.03e4acp-3, INEXACT)
T(RN,  0x1.3eaa1994747c9p+796,   -0x1.fb7f7640c819bp-1,  -0x1.17c5a2p-2, INEXACT)
T(RN,  0x1.c5e91528d03bap+796,   -0x1.947a5a6429c17p-1,   0x1.5415cep-5, INEXACT)
T(RN,  0x1.836bbec5f98fap+796,    0x1.c55d5475a3de4p-1,   0x1.5eca82p-3, INEXACT)
T(RN,  0x1.9137e922f2446p+796,   -0x1.be7dd610d088cp-1,   0x1.2adb36p-2, INEXACT)
T(RN,  0x1.8fe68981eb742p+796,    0x1.209cb084bfbb9p-1,  -0x1.bbc244p-5, INEXACT)
T(RN,  0x1.06c3953af2317p+796,   -0x1.f2dbbc51a664dp-2,   0x1.34a47ep-2, INEXACT)
T(RN,  0x1.25f3f2d82acffp+796,   -0x1.6ef3b4e46caa7p-2,   0x1.b8a3acp-3, INEXACT)
T(RN,  0x1.201aba4326872p+797,    0x1.ecdd87787abb1p-1,   0x1.ee2378p-2, INEXACT)
T(RN,  0x1.173114ffd869ap+797,   -0x1.89a43291aa78dp-1,   0x1.61480cp-2, INEXACT)
T(RN,  0x1.da1c0c52c1d04p+797,    0x1.7d6ec149645f4p-1,  -0x1.eb0806p-3, INEXACT)
T(RN,  0x1.db962792522aap+797,   -0x1.67f3653ffb7e2p-1,   0x1.db78eap-3, INEXACT)
T(RN,   0x1.d76a45c77c45p+797,   -0x1.82f27403761bcp-3,  -0x1.5a96c4p-3, INEXACT)
T(RN,   0x1.ee70c20fb955p+797,    0x1.ce03ddb986cd6p-1,   0x1.b8202ap-3, INEXACT)
T(RN,  0x1.db8c462d4947ep+797,    -0x1.cbf40c256b36p-1,   0x1.565fc2p-3, INEXACT)
T(RN,  0x1.4ea7206a82404p+797,   -0x1.061ac2b9a9d88p-2,   0x1.ad0acap-2, INEXACT)
T(RN,  0x1.a0c33d19ed5aap+797,   -0x1.2404a29b5c5bcp-1,   0x1.9c17cep-5, INEXACT)
T(RN,  0x1.40e4bad1d3f1cp+797,    0x1.e1893fe838b8ap-1,   0x1.7a8f7cp-3, INEXACT)
T(RN,  0x1.238b7f776623cp+798,    0x1.c7f420c365ebap-1,  -0x1.adbb12p-2, INEXACT)
T(RN,  0x1.01bdb9942791fp+798,   -0x1.d473a8c6e0463p-1,    0x1.1afddp-3, INEXACT)
T(RN,  0x1.53e2c5f735f69p+798,   -0x1.b2e00dee36c5ap-1,   0x1.30d696p-4, INEXACT)
T(RN,   0x1.3ecbb38715c5p+798,    -0x1.302a24163631p-1,   0x1.cad862p-4, INEXACT)
T(RN,  0x1.64502cc734774p+798,   -0x1.f186e0fa4959bp-1,  -0x1.a8b32ep-2, INEXACT)
T(RN,  0x1.ec8d5668ebc1ep+798,   -0x1.0798149db0646p-1,   0x1.18b7eep-3, INEXACT)
T(RN,  0x1.dc6b4fe864564p+798,   -0x1.59972f70f46fbp-3,   0x1.fa2d5ap-3, INEXACT)
T(RN,  0x1.841f077a790c6p+798,    0x1.b8bbd54821f0dp-1,   0x1.b86f92p-4, INEXACT)
T(RN,  0x1.8da6b2cd0be3ap+798,    0x1.4638da55efca4p-1,  -0x1.45ed88p-4, INEXACT)
T(RN,  0x1.531cb7d78726ap+798,   -0x1.a38b1a45afd1ep-1,   0x1.f33658p-2, INEXACT)
T(RN,  0x1.71c5c4ee706bdp+799,   -0x1.9488da569903ap-1,   0x1.da04f8p-3, INEXACT)
T(RN,  0x1.b6abe7a02502bp+799,    0x1.cf42777b87cddp-1,  -0x1.d7251cp-2, INEXACT)
T(RN,   0x1.de0b35ad881dp+799,   -0x1.ffeddd00f2d88p-1,   0x1.0b3b18p-2, INEXACT)
T(RN,  0x1.3176773e6f5e9p+799,   -0x1.fa4328ccb7bedp-1,   0x1.2a7446p-3, INEXACT)
T(RN,  0x1.e6fae2871e84ap+799,   -0x1.fcf24933eeff3p-1,  -0x1.f48e5cp-4, INEXACT)
T(RN,  0x1.fa679b4f7f414p+799,    0x1.11caf07961e47p-1,  -0x1.e0591ep-2, INEXACT)
T(RN,  0x1.79371abe024e7p+799,    0x1.fa576f83d982ep-1,  -0x1.fcfb62p-3, INEXACT)
T(RN,   0x1.6dd784eb6d7fp+799,   -0x1.9ae95bd7499c8p-2,   0x1.1b179cp-2, INEXACT)
T(RN,  0x1.9cae5369213cap+799,   -0x1.aa635b439db11p-1,  -0x1.84628ap-3, INEXACT)
T(RN,  0x1.3c290c29fbca5p+799,    0x1.b5fff930a488cp-1,    0x1.acf9bp-6, INEXACT)
T(RN,  0x1.581fc1d7fa798p+800,   -0x1.ff7ed7fd5423dp-1,   0x1.7a3d7ep-2, INEXACT)
T(RN,  0x1.8ab9b788b466ep+800,    0x1.4d7414d1f2162p-1,  -0x1.dc8618p-5, INEXACT)
T(RN,  0x1.364c81104780dp+800,   -0x1.218d00f67304ep-1,   0x1.c2d486p-3, INEXACT)
T(RN,  0x1.750c5cbc5f6bep+800,   -0x1.46c1d041ca25ap-2,  -0x1.e78b24p-2, INEXACT)
T(RN,   0x1.cfb26f67b61cp+800,    0x1.ee5761641180ap-1,  -0x1.44965ap-3, INEXACT)
T(RN,  0x1.21e3c53e31f82p+800,   -0x1.fdd9e1a38eaf5p-4,  -0x1.e98504p-2, INEXACT)
T(RN,  0x1.5242c4bd468acp+800,    0x1.072496c2699d7p-1,   0x1.cd988ap-3, INEXACT)
T(RN,   0x1.8a69b2dd5f89p+800,    0x1.0a2a0566df21cp-2,  -0x1.ddad62p-5, INEXACT)
T(RN,  0x1.affe262c0fa36p+800,   -0x1.ff5766a6f2943p-1,  -0x1.3c3348p-3, INEXACT)
T(RN,   0x1.515d4738a25fp+800,   -0x1.ca28779dfbd0cp-1,  -0x1.18be6ap-3, INEXACT)
T(RN,  0x1.ad3fa251dd2e6p+801,   -0x1.bf790ca1fcdf4p-5,  -0x1.4b739cp-2, INEXACT)
T(RN,  0x1.1fb5a94634c49p+801,   -0x1.ec29212f86afcp-1,   0x1.0836bep-3, INEXACT)
T(RN,  0x1.2aced309af062p+801,   -0x1.2163645fc90c3p-1,   -0x1.0d177p-2, INEXACT)
T(RN,  0x1.ebc25792b8ad8p+801,   -0x1.ff534e065e986p-1,   0x1.cf094cp-2, INEXACT)
T(RN,  0x1.cb02c810c6c94p+801,   -0x1.b62d3dfd1e4d3p-1,   0x1.e9642cp-6, INEXACT)
T(RN,  0x1.6c4e085098ca1p+801,    -0x1.095632130979p-9,  -0x1.e1203ap-3, INEXACT)
T(RN,  0x1.aeec9bea2238ep+801,   -0x1.bd46d4adcf804p-2,   0x1.5c5d72p-4, INEXACT)
T(RN,  0x1.27bf5303035f2p+801,    0x1.f9cd9c4bc793ap-1,   -0x1.d5ccbp-3, INEXACT)
T(RN,  0x1.f4531f440e90cp+801,     0x1.25924fc0aa8fp-1,  -0x1.334c64p-2, INEXACT)
T(RN,  0x1.3cdaf2b804aaap+801,    0x1.ee250663308f9p-1,  -0x1.1adccap-5, INEXACT)
T(RN,  0x1.f9b085b3ae3fbp+802,   -0x1.9edb1f71d7a37p-7,  -0x1.b4ce96p-2, INEXACT)
T(RN,  0x1.833bafe1b4d29p+802,    0x1.7f1a390173477p-2,   0x1.b346fep-2, INEXACT)
T(RN,  0x1.3d8f7d9662004p+802,    0x1.fd9bd6a0d9a06p-1,  -0x1.193732p-6, INEXACT)
T(RN,  0x1.48c9549adfcccp+802,    0x1.9ad4425a7dea6p-1,   0x1.02f4c2p-2, INEXACT)
T(RN,  0x1.6b706fd74aaeep+802,   -0x1.b5e053351e702p-1,  -0x1.bbf534p-3, INEXACT)
T(RN,  0x1.d8274bd099abep+802,   -0x1.821516b5b99b1p-3,  -0x1.eddb3cp-2, INEXACT)
T(RN,  0x1.6a6e39d134fffp+802,   -0x1.062c06bea3cdcp-2,  -0x1.db59dcp-2, INEXACT)
T(RN,  0x1.9d1966d0955c4p+802,    0x1.d94d702a3fbffp-1,  -0x1.5ec5f6p-4, INEXACT)
T(RN,  0x1.b31f274e24e48p+802,   -0x1.cd77162798c89p-1,  -0x1.5a1504p-7, INEXACT)
T(RN,   0x1.c62c989e953ap+802,   -0x1.dd5719a4fcb2fp-1,   0x1.07e75ap-6, INEXACT)
T(RN,  0x1.d4964bcc513ffp+803,   -0x1.ab8fc98a7ec2dp-5,   0x1.9577e6p-3, INEXACT)
T(RN,  0x1.3b929080072f4p+803,   -0x1.b5336a50466b5p-1,   0x1.e2a18ep-2, INEXACT)
T(RN,  0x1.bed90182f42b6p+803,    0x1.12b7f60e23faep-4,   0x1.67769ep-2, INEXACT)
T(RN,  0x1.be979ad375d92p+803,    0x1.ba3ef62bef00cp-1,  -0x1.0a1f18p-2, INEXACT)
T(RN,  0x1.f81c2b16e5b38p+803,    0x1.0abfd746b7921p-2,   0x1.568cc4p-2, INEXACT)
T(RN,  0x1.cbe2f6670ba49p+803,    0x1.9707c80b9ed56p-1,  -0x1.5e027ap-3, INEXACT)
T(RN,  0x1.ecd03635dec6dp+803,    0x1.fd8db8c56787bp-1,   0x1.ee32b8p-2, INEXACT)
T(RN,  0x1.03a87716c038fp+803,    0x1.a10c343b2ece5p-3,  -0x1.c61a1ep-5, INEXACT)
T(RN,  0x1.33a966603cb44p+803,   -0x1.8a0bf3809d139p-1,  -0x1.18992ap-2, INEXACT)
T(RN,  0x1.4b48a78cc1cc4p+803,   -0x1.b4fdae29cc6f4p-1,   -0x1.9a04dp-7, INEXACT)
T(RN,  0x1.67c0803a719ffp+804,    0x1.a2985e23c1eb1p-1,   0x1.fec3b2p-4, INEXACT)
T(RN,   0x1.b9edc4753431p+804,    0x1.f2f760b8b1acep-1,  -0x1.d13b66p-2, INEXACT)
T(RN,  0x1.c07759ad895a2p+804,    0x1.d6c7b3f0271d7p-2,   0x1.92891ep-2, INEXACT)
T(RN,  0x1.05f76c8fd0005p+804,   -0x1.4c70b19b91b3bp-1,   0x1.af1bbep-5, INEXACT)
T(RN,   0x1.c81ed5c8f69fp+804,    0x1.d8723cce5a0b7p-4,   0x1.2c41d2p-4, INEXACT)
T(RN,  0x1.a0c141d42e6d6p+804,    -0x1.782f621c8e1dp-1,   0x1.5a62d6p-3, INEXACT)
T(RN,  0x1.bec1e03eb8b42p+804,   -0x1.3efefcace7193p-6,   0x1.fb2896p-2, INEXACT)
T(RN,  0x1.cfcb349f852fap+804,    0x1.ffa7952c7278fp-1,   -0x1.93c3dp-5, INEXACT)
T(RN,  0x1.7c62f7d2228fcp+804,    0x1.95d7764342438p-6,  -0x1.b69a96p-4, INEXACT)
T(RN,  0x1.abb675cd85064p+804,    0x1.43eef75d5da41p-3,  -0x1.056bf6p-5, INEXACT)
T(RN,  0x1.467de612334c2p+805,    0x1.0e93715e40be2p-1,  -0x1.d6aeaap-2, INEXACT)
T(RN,  0x1.be8b10744ce06p+805,     0x1.dbb19aed805fp-1,    0x1.06f9cp-2, INEXACT)
T(RN,   0x1.c0aa0dd0181cp+805,    0x1.e73fa6b12d9e1p-1,   0x1.c2f07ap-2, INEXACT)
T(RN,  0x1.0759af2330af2p+805,    0x1.7089475182151p-2,  -0x1.04b0e4p-5, INEXACT)
T(RN,   0x1.a61d83f8a0cdp+805,     0x1.9e64235ce7d3p-3,   -0x1.787c9p-3, INEXACT)
T(RN,  0x1.ba2cd9dcb9884p+805,    0x1.d6a0565f75665p-1,  -0x1.87cc56p-4, INEXACT)
T(RN,  0x1.eec142a59e855p+805,    0x1.a4bbdf899ce5fp-1,   0x1.0bfe8cp-6, INEXACT)
T(RN,  0x1.81a205ba90feep+805,    0x1.48185f62a72bcp-1,   0x1.a7cc6ep-4, INEXACT)
T(RN,  0x1.29828513ba5d1p+805,   -0x1.7079f821940c1p-1,  -0x1.c1e392p-2, INEXACT)
T(RN,  0x1.af759419db832p+805,   -0x1.48f0dc816e177p-5,   0x1.3cc8f8p-3, INEXACT)
T(RN,  0x1.49a65b2694cb8p+806,   -0x1.458e7142a18e3p-1,  -0x1.863906p-4, INEXACT)
T(RN,  0x1.1cc93a11b8462p+806,   -0x1.39e5c9614c139p-1,   0x1.01723cp-3, INEXACT)
T(RN,  0x1.31ea0134d7519p+806,   -0x1.eadae07819817p-1,   0x1.899d9cp-2, INEXACT)
T(RN,  0x1.89b250a0eb1dfp+806,   -0x1.56a30d16677b9p-6,    0x1.c3bdap-2, INEXACT)
T(RN,  0x1.a65bf5075be32p+806,    0x1.3f2c14f0d5d76p-4,   0x1.ec15fap-4, INEXACT)
T(RN,  0x1.be51018e570c9p+806,    0x1.fc88a11601c2ap-1,  -0x1.ae7482p-3, INEXACT)
T(RN,  0x1.dc598366498cbp+806,   -0x1.7d354fb5cf51dp-6,  -0x1.afbf88p-3, INEXACT)
T(RN,  0x1.f35d70cf4158ep+806,   -0x1.b7a8e6ae7b00dp-2,   -0x1.a08ddp-6, INEXACT)
T(RN,  0x1.388710b06cc83p+806,   -0x1.a48daa1eb135bp-1,   0x1.a2c574p-3, INEXACT)
T(RN,  0x1.ce1f231b11bb2p+806,   -0x1.240d8ed7798cfp-2,  -0x1.0474eap-2, INEXACT)
T(RN,  0x1.afddbb3a2364bp+807,     0x1.94b88995fbb8p-1,    0x1.ce981p-7, INEXACT)
T(RN,  0x1.00b641a11db3cp+807,    0x1.62f4705f8716fp-2,  -0x1.b5be96p-2, INEXACT)
T(RN,  0x1.bf93403146a66p+807,    0x1.e8122afb2781fp-1,   0x1.a06c92p-5, INEXACT)
T(RN,  0x1.841bbe3b60ea5p+807,   -0x1.9b37ac56960d6p-1,    0x1.b81d2p-6, INEXACT)
T(RN,  0x1.b5ddaaea5a11cp+807,   -0x1.a46bfa3e35e1fp-4,   -0x1.420b7p-2, INEXACT)
T(RN,   0x1.f7c450d18d56p+807,   -0x1.e7e3545496324p-1,  -0x1.ff3cd8p-2, INEXACT)
T(RN,  0x1.4330ee8dd9ba3p+807,    -0x1.3969d1343c2ep-3,  -0x1.7c3124p-2, INEXACT)
T(RN,  0x1.03038d04debc2p+807,   -0x1.964217b26b9ccp-3,  0x1.554678p-12, INEXACT)
T(RN,  0x1.e6c352b51f562p+807,     0x1.f13cc85e5909p-1,  -0x1.6c2dfap-2, INEXACT)
T(RN,  0x1.ba074324e0501p+807,    0x1.f60fb94435527p-1,   0x1.164b5ep-2, INEXACT)
T(RN,  0x1.4a92332bde0c8p+808,    0x1.ba898df93007ep-3,  -0x1.a6b306p-2, INEXACT)
T(RN,  0x1.9b1e390c9ac3cp+808,   -0x1.b965de67a1a38p-4,   0x1.facee6p-2, INEXACT)
T(RN,   0x1.9bf1c7faa2e5p+808,    0x1.fefa8994e3513p-1,   0x1.3a6aaap-2, INEXACT)
T(RN,  0x1.df9cd1a923c01p+808,    0x1.6acd2e28ad5eep-4,  -0x1.8f80acp-5, INEXACT)
T(RN,  0x1.3492ae944b4edp+808,   -0x1.94dad584e12d5p-1,   0x1.86523ep-2, INEXACT)
T(RN,  0x1.216db52622973p+808,   -0x1.3b4fb38b4ce26p-4,  -0x1.abeac2p-4, INEXACT)
T(RN,  0x1.09d74b2c53fb4p+808,   -0x1.07314166d5d84p-1,  -0x1.554f24p-2, INEXACT)
T(RN,  0x1.31de2a1bd0f53p+808,   -0x1.fdbabd1d02af9p-1,   0x1.2177e8p-2, INEXACT)
T(RN,  0x1.8039f4e46434ap+808,   -0x1.44f5a83d9bf49p-1,   0x1.07a268p-3, INEXACT)
T(RN,  0x1.ce44de4b515c2p+808,    0x1.ce7f45e6a98ffp-4,   0x1.305eeap-8, INEXACT)
T(RN,  0x1.5d7261d89d8fbp+809,    0x1.2f44c0c84df9cp-1,    0x1.489d4p-2, INEXACT)
T(RN,  0x1.0d9a5ef6342a8p+809,    0x1.e3a0e35f1723dp-2,   0x1.abe292p-3, INEXACT)
T(RN,  0x1.38fbdea49e0cep+809,    0x1.c2b88c2a5b505p-1,   0x1.e408dep-2, INEXACT)
T(RN,  0x1.c3ed5be0f480ep+809,   -0x1.f97d328fccb49p-1,  -0x1.bea172p-2, INEXACT)
T(RN,  0x1.4876e040e7614p+809,    0x1.2c6e2628a7a0fp-2,   -0x1.c8782p-2, INEXACT)
T(RN,  0x1.452fe27f715fap+809,   -0x1.5c869984cbb59p-1,   0x1.be9a7ep-3, INEXACT)
T(RN,  0x1.1204039369f4ap+809,   -0x1.e0fb3e6b074bbp-1,  -0x1.f4e266p-3, INEXACT)
T(RN,  0x1.f95f52ed9a417p+809,    0x1.ff5823b1a0e74p-1,   0x1.eedb4ep-3, INEXACT)
T(RN,  0x1.af73770398596p+809,   -0x1.2a4fcd3c34654p-4,   0x1.dc9dfcp-3, INEXACT)
T(RN,  0x1.bed77ff9de0a3p+809,    0x1.f651c09800177p-1,  -0x1.47f4c4p-2, INEXACT)
T(RN,  0x1.5bb84bc7985e1p+810,   -0x1.5ae4b3881f3a6p-2,   0x1.d9434ap-3, INEXACT)
T(RN,   0x1.a89b8f44e289p+810,   -0x1.fe75fa6b70d82p-1,    0x1.0fb33p-4, INEXACT)
T(RN,  0x1.62761f832f1c1p+810,    0x1.8730567784824p-1,    0x1.6d178p-2, INEXACT)
T(RN,  0x1.54a1b736c6a7dp+810,   -0x1.563d7271eb9f4p-1,    0x1.b137ap-3, INEXACT)
T(RN,   0x1.38c26f13aaccp+810,    0x1.f76616e706cd6p-1,  -0x1.ea16dcp-2, INEXACT)
T(RN,  0x1.0884922c73f42p+810,   -0x1.e11e47dbc1df8p-1,   0x1.2f41e2p-2, INEXACT)
T(RN,  0x1.501d9934e4626p+810,    0x1.1a745eaa100e2p-1,   0x1.d9a8d4p-2, INEXACT)
T(RN,  0x1.aded65885f4f5p+810,    0x1.fb88602363c4fp-1,  -0x1.9e77fcp-2, INEXACT)
T(RN,  0x1.b18eeb391921bp+810,    0x1.59c9d195ce9bcp-1,  -0x1.df516ap-3, INEXACT)
T(RN,  0x1.1d5ab5d1d3538p+810,   -0x1.9e600679cb283p-1,  -0x1.520ff4p-5, INEXACT)
T(RN,  0x1.82dcfa8d5b298p+811,   -0x1.551ad74a8400cp-1,   0x1.890f14p-2, INEXACT)
T(RN,  0x1.f2a40fd3350a4p+811,    0x1.a660aa41e6c88p-2,  -0x1.9fe762p-3, INEXACT)
T(RN,   0x1.abddd0658b52p+811,   -0x1.d4b82fdce7b8cp-1,  -0x1.249c06p-4, INEXACT)
T(RN,  0x1.5e9ae2d4a4326p+811,   -0x1.fb1f33c63190bp-1,   0x1.2fe6e6p-4, INEXACT)
T(RN,  0x1.1b1be69164f43p+811,   -0x1.c9480ad43ecf6p-1,   0x1.9c0726p-2, INEXACT)
T(RN,  0x1.12d1c576984b1p+811,    0x1.e9e59860066b2p-1,   0x1.fccb0ap-3, INEXACT)
T(RN,  0x1.c0269ea234b3ap+811,   -0x1.f1ad8cf303addp-4,   0x1.65f458p-5, INEXACT)
T(RN,  0x1.50e3b919cb9efp+811,    0x1.2016395a12686p-1,   -0x1.01734p-2, INEXACT)
T(RN,  0x1.7f81ff1c68d5ep+811,    0x1.d149e428d1579p-1,  -0x1.b19d8ap-2, INEXACT)
T(RN,  0x1.9ecbffddb4292p+811,    0x1.becf20f48e615p-1,  -0x1.2fa5d8p-2, INEXACT)
T(RN,  0x1.2c66f6c1f3b99p+812,    0x1.82a3ea9049befp-1,   0x1.004deep-3, INEXACT)
T(RN,  0x1.9bae771aa5ca6p+812,     0x1.595a4e375bbep-1,   0x1.a47584p-2, INEXACT)
T(RN,  0x1.9b6b4c18ff64ap+812,   -0x1.0f138b00006c6p-5,   0x1.4a7fdep-3, INEXACT)
T(RN,  0x1.60efee97572a6p+812,   -0x1.9ae2452cadafep-1,   0x1.9ff00ep-3, INEXACT)
T(RN,  0x1.3f4907a58b967p+812,    0x1.e1676cd0971c5p-1,  -0x1.c5a8d4p-3, INEXACT)
T(RN,  0x1.89d51bba29503p+812,    0x1.cbd616fce4145p-1,   0x1.5abeccp-2, INEXACT)
T(RN,  0x1.9304eaad7b631p+812,   -0x1.ae21dbab0b833p-1,  -0x1.408504p-2, INEXACT)
T(RN,  0x1.cf33ba5cbbe84p+812,    0x1.2738f1331ba9dp-3,  -0x1.e5611ep-2, INEXACT)
T(RN,  0x1.a1d153ca9def2p+812,   -0x1.0ec30d9f98c9ap-1,   0x1.cfb116p-2, INEXACT)
T(RN,  0x1.87df303d1ef45p+812,   -0x1.877305d8aa772p-1,   0x1.b0d1e8p-5, INEXACT)
T(RN,  0x1.d525053968e2cp+813,   -0x1.6c2d3eb0507a4p-1,   0x1.5fd46ap-2, INEXACT)
T(RN,   0x1.d7567739ee9dp+813,    0x1.fe16e5c37b65fp-1,  -0x1.7058a6p-2, INEXACT)
T(RN,  0x1.d9daedc21985bp+813,    0x1.f7486325d3aa4p-1,  -0x1.5b9472p-2, INEXACT)
T(RN,  0x1.27a4d2e4a26bfp+813,    -0x1.3765c6952cc9p-1,  -0x1.11e0f4p-3, INEXACT)
T(RN,  0x1.283e753d33589p+813,    0x1.efa91da56638ep-1,   -0x1.72acdp-4, INEXACT)
T(RN,   0x1.9065c72ae756p+813,   -0x1.29a8c7d9b0e97p-1,  -0x1.821facp-2, INEXACT)
T(RN,  0x1.a9d4099582bc7p+813,   -0x1.e132126df8d6dp-2,  -0x1.10abe2p-2, INEXACT)
T(RN,  0x1.88deb2b18b81ep+813,   -0x1.99a982268714ap-2,    0x1.6938ap-2, INEXACT)
T(RN,  0x1.5ed7ca42a4098p+813,   -0x1.f3c40db503494p-1,  -0x1.ef15a8p-3, INEXACT)
T(RN,   0x1.ba423c448f9ap+813,   -0x1.e35636259d91cp-1,  -0x1.02a1b8p-3, INEXACT)
T(RN,  0x1.6af43154a7194p+814,    0x1.f8abeb3d9e862p-7,  -0x1.430f22p-2, INEXACT)
T(RN,  0x1.f9d405e4fa9dap+814,    0x1.2427ff6fdc538p-5,  -0x1.8fa33cp-3, INEXACT)
T(RN,  0x1.9e55e3d22b008p+814,    0x1.9f95e984844d2p-1,  -0x1.3ebb42p-2, INEXACT)
T(RN,   0x1.e0dfa4d78f13p+814,   -0x1.6ed6154452807p-1,   0x1.56c99ep-2, INEXACT)
T(RN,  0x1.026d3ad1187b6p+814,   -0x1.99fc896a9362bp-2,  -0x1.3f522ep-4, INEXACT)
T(RN,   0x1.5829dad692eep+814,    0x1.6dc6f97968931p-1,   0x1.4d312ep-2, INEXACT)
T(RN,  0x1.21ca5a1faa188p+814,   -0x1.cecfbb49cbf36p-3,  -0x1.4f383ap-2, INEXACT)
T(RN,  0x1.cd2c8921ad3b5p+814,    0x1.d90eb6c7113a3p-1,   0x1.5ca03cp-2, INEXACT)
T(RN,  0x1.75cac5e3e88e6p+814,    0x1.3768779206533p-1,   0x1.71532cp-5, INEXACT)
T(RN,  0x1.a6c2495c1e3f6p+814,   -0x1.27dbcd6be8f23p-4,  -0x1.4e2ab8p-4, INEXACT)
T(RN,  0x1.fd9f7dc49e18cp+815,    0x1.e0db35666ee57p-1,  -0x1.b28d6ep-2, INEXACT)
T(RN,  0x1.cc6cde56405f5p+815,   -0x1.c5bc127e8f62cp-6,   0x1.b6ebacp-6, INEXACT)
T(RN,  0x1.4c3e7d33d6cf4p+815,    0x1.d005da9c27d51p-2,  -0x1.c4b222p-2, INEXACT)
T(RN,  0x1.7621b8496d0dfp+815,    0x1.8c18326ae1bffp-1,   0x1.bcee6ep-4, INEXACT)
T(RN,  0x1.f3fd3966c23cfp+815,    0x1.fffdde5edd198p-1,   0x1.70ba92p-2, INEXACT)
T(RN,  0x1.347dc5cd1f438p+815,   -0x1.7a9f041bad68ep-1,  -0x1.ba5c32p-2, INEXACT)
T(RN,   0x1.c46be971aa12p+815,   -0x1.f13451876616fp-1,   0x1.ec1ad4p-6, INEXACT)
T(RN,   0x1.be5e4aeb1f0bp+815,    0x1.c9b19b264180ep-2,  -0x1.5c2858p-3, INEXACT)
T(RN,  0x1.44d1d8199803cp+815,    0x1.f19de6b972805p-1,  -0x1.f4645ap-2, INEXACT)
T(RN,  0x1.f2eea5f98a8c2p+815,   -0x1.5e06e6e0f4ffdp-1,   0x1.22d11ap-2, INEXACT)
T(RN,   0x1.cd7ad87e316ap+816,   -0x1.62650148599ccp-4,  -0x1.9afe5ap-2, INEXACT)
T(RN,  0x1.8be79cc82d94ap+816,   -0x1.7ab9d3ab854bcp-1,  -0x1.551206p-3, INEXACT)
T(RN,  0x1.a5d2cb59ce6d2p+816,    0x1.c22ff123e827bp-1,   0x1.984a9ep-3, INEXACT)
T(RN,  0x1.8fb8bd7641d02p+816,    0x1.e33fcac7e8961p-1,  -0x1.d9412cp-3, INEXACT)
T(RN,  0x1.478dc45ce71bep+816,    0x1.4de1bf1437573p-1,   -0x1.792d9p-7, INEXACT)
T(RN,  0x1.7a6810c30ddfbp+816,    0x1.90bf04222aa62p-2,   0x1.6dc832p-7, INEXACT)
T(RN,  0x1.a6ab24dc07199p+816,   -0x1.248bed69c1a43p-1,  -0x1.77ccf4p-2, INEXACT)
T(RN,  0x1.0e0a03565fcf2p+816,    0x1.f9e874f13aa5ep-1,   0x1.764c56p-3, INEXACT)
T(RN,  0x1.dbc6ed3a924d6p+816,   -0x1.a2d774c1cb33cp-2,  -0x1.5cf91ep-2, INEXACT)
T(RN,  0x1.59fce89b303aep+816,   -0x1.86d2f2dc9192ep-1,   0x1.db237ap-2, INEXACT)
T(RN,  0x1.ee2f7e96af8b4p+817,    -0x1.278fe835197cp-3,   0x1.657f46p-2, INEXACT)
T(RN,  0x1.1e23dd26b5c89p+817,    -0x1.fd326457daedp-1,  -0x1.12e1f4p-3, INEXACT)
T(RN,  0x1.1b5a1790ef7a4p+817,   -0x1.d058e71c7adaap-5,  -0x1.ee981cp-2, INEXACT)
T(RN,   0x1.068847eaf469p+817,     0x1.c4bcc50208d3p-1,  -0x1.1c7b2cp-4, INEXACT)
T(RN,  0x1.efef8aa4c2ac4p+817,    0x1.f53b641c94223p-1,   0x1.9fd5fap-2, INEXACT)
T(RN,  0x1.0a86a00f36ffbp+817,   -0x1.8a8d39a09fe2fp-1,   0x1.e72dcep-2, INEXACT)
T(RN,  0x1.2ac572b4fca62p+817,    0x1.77e7729de90a5p-1,   0x1.4c6428p-3, INEXACT)
T(RN,  0x1.841889d55ea4ap+817,    0x1.deff72a17fb62p-1,  -0x1.29bbfcp-4, INEXACT)
T(RN,  0x1.e36d5b31d978ep+817,   -0x1.cf70f9889b5e1p-1,   0x1.dcf4fep-2, INEXACT)
T(RN,  0x1.af7f569e3f2d4p+817,    0x1.44c302ad3a765p-4,   0x1.2cbe5cp-3, INEXACT)
T(RN,  0x1.ca7e52046b9b4p+818,   -0x1.3b0ca6ab5c853p-1,  -0x1.1ab366p-2, INEXACT)
T(RN,  0x1.726e1abde6a54p+818,   -0x1.2c146c95c623cp-2,     0x1.65b4p-2, INEXACT)
T(RN,  0x1.e42866bb2f432p+818,   -0x1.31730a62f0349p-1,  -0x1.986628p-3, INEXACT)
T(RN,  0x1.a98cb8bc71a9cp+818,    0x1.89999ec077aa5p-3,  -0x1.8e4164p-2, INEXACT)
T(RN,  0x1.3e07b8fa14f85p+818,    0x1.ccef8525d2e15p-1,   0x1.2a1baap-3, INEXACT)
T(RN,  0x1.1fa87ba63542bp+818,   -0x1.f87a8bbc3d514p-1,    0x1.e2871p-2, INEXACT)
T(RN,  0x1.c9738564c9f2bp+818,    -0x1.d5813dce83fbp-2,   0x1.138272p-2, INEXACT)
T(RN,  0x1.037285d691182p+818,    0x1.ab25ad227ead2p-3,    0x1.cf6d4p-3, INEXACT)
T(RN,  0x1.5d9a8527d5a94p+818,   -0x1.ffa886e93892bp-1,   0x1.ae9166p-3, INEXACT)
T(RN,  0x1.5930cedf664e9p+818,    0x1.e0eb2c8054697p-1,   0x1.44fdb8p-3, INEXACT)
T(RN,  0x1.943a1facd7544p+819,    0x1.fa2c049f3e84cp-1,   0x1.391a7ap-3, INEXACT)
T(RN,  0x1.1ee07332bce82p+819,   -0x1.e0e71b0fdb861p-1,    0x1.4c2a4p-6, INEXACT)
T(RN,  0x1.7a9403f775e4cp+819,     0x1.ff5e863c510fp-1,   0x1.d9f41cp-2, INEXACT)
T(RN,   0x1.ec929f0b9496p+819,    0x1.96b4888ffad9fp-1,   0x1.5e3b6cp-2, INEXACT)
T(RN,  0x1.37657414fec91p+819,   -0x1.9664eba276166p-1,  -0x1.8d41c8p-2, INEXACT)
T(RN,  0x1.852f92779955fp+819,    0x1.fb317ee9c8ca6p-1,   0x1.c6597ep-2, INEXACT)
T(RN,  0x1.75cda90b7b432p+819,   -0x1.ffcac3485de9fp-1,   0x1.b37d04p-2, INEXACT)
T(RN,  0x1.645cbf0605028p+819,    0x1.fe18ccb555408p-1,   0x1.8dfa0ap-3, INEXACT)
T(RN,  0x1.260f9abb9208bp+819,   -0x1.02fd9e34b295cp-1,   0x1.730e32p-3, INEXACT)
T(RN,  0x1.3814970212e54p+819,   -0x1.2e28286f59343p-1,  -0x1.ec7f88p-3, INEXACT)
T(RN,  0x1.7146da2dd16b8p+820,    0x1.daebded8a8766p-1,   0x1.ee4736p-3, INEXACT)
T(RN,  0x1.28de886f6e5ebp+820,    0x1.7375cf6616ca2p-1,  -0x1.a8cae2p-4, INEXACT)
T(RN,  0x1.9f7e7079ae934p+820,    0x1.847adba87abccp-2,   -0x1.6b5e3p-3, INEXACT)
T(RN,    0x1.f15f540a392p+820,    0x1.2c3e7ff91ed21p-3,  -0x1.9d2f4ep-4, INEXACT)
T(RN,  0x1.60b5489e0209cp+820,    0x1.fd271fc3c4a29p-1,   0x1.868274p-3, INEXACT)
T(RN,  0x1.343a046611ef1p+820,    0x1.52b19b72409d3p-1,  -0x1.3e8cb6p-2, INEXACT)
T(RN,  0x1.635eb0a745a65p+820,    0x1.6bac656773456p-1,   0x1.364366p-3, INEXACT)
T(RN,  0x1.fbc910cfdf15ap+820,   -0x1.bee57472a791dp-3,   -0x1.4dc82p-2, INEXACT)
T(RN,   0x1.229e2e50a85dp+820,    -0x1.ea79421fa552p-5,  -0x1.a5792ap-2, INEXACT)
T(RN,  0x1.22a5fc96fe25fp+820,    0x1.f581427956153p-1,   0x1.c1cbdcp-2, INEXACT)
T(RN,  0x1.2333dd7395f99p+821,    0x1.88b36a21b99b6p-3,   0x1.e75eeep-3, INEXACT)
T(RN,  0x1.876dcd7688bd3p+821,    0x1.4f9373d79c539p-1,  -0x1.855f64p-3, INEXACT)
T(RN,  0x1.bfd3862b6f654p+821,   -0x1.fbee086e332bep-1,   0x1.398a56p-3, INEXACT)
T(RN,  0x1.008cccf2b28e8p+821,   -0x1.adc4980ae1f5bp-2,  -0x1.7be0e8p-4, INEXACT)
T(RN,  0x1.1d778f37d36d1p+821,   -0x1.68e286b6d5655p-1,   0x1.efd086p-6, INEXACT)
T(RN,  0x1.e9304c4f143d2p+821,    0x1.ed2bff6f490fep-1,   0x1.8d02f4p-3, INEXACT)
T(RN,  0x1.0182cd93e4e6fp+821,    0x1.25dac749d285ap-1,  -0x1.caa984p-2, INEXACT)
T(RN,  0x1.36de51e2a722fp+821,   -0x1.bd842f5056d8ap-1,   0x1.a57cf6p-2, INEXACT)
T(RN,  0x1.dbd07869636a4p+821,    0x1.e63f056625064p-1,  -0x1.9146eap-2, INEXACT)
T(RN,  0x1.cca40c7089003p+821,   -0x1.b39e02e19954fp-1,   0x1.364b9ep-5, INEXACT)
T(RN,  0x1.738f712c68c4cp+822,    0x1.c6dc4b51f3866p-1,   0x1.09ee42p-3, INEXACT)
T(RN,  0x1.1b2402c64f803p+822,    0x1.f060235ccd19ep-3,  -0x1.c7bd04p-3, INEXACT)
T(RN,  0x1.275c10bbc5035p+822,   -0x1.bfca3272ed791p-1,  -0x1.2bade8p-2, INEXACT)
T(RN,  0x1.7ea612fc5008fp+822,    0x1.3f2a4df2f5a16p-1,   0x1.7fe766p-2, INEXACT)
T(RN,  0x1.35ebff182331bp+822,    0x1.5cf7711aff7f8p-2,   0x1.7f14a2p-2, INEXACT)
T(RN,  0x1.b3fed9abda0abp+822,   -0x1.9d46713f9684ep-1,    0x1.0576bp-3, INEXACT)
T(RN,  0x1.26ef057a6b89ep+822,    0x1.8d17a6051065ep-7,   0x1.7cf1aep-2, INEXACT)
T(RN,  0x1.866dbade6efc4p+822,   -0x1.b5e7b16c04c41p-1,   0x1.d37b96p-2, INEXACT)
T(RN,  0x1.1134e57b823f7p+822,   -0x1.587411c8cca75p-1,   0x1.4401c6p-2, INEXACT)
T(RN,  0x1.d94b7dc3044bcp+822,    0x1.e9573a2314d02p-1,   0x1.b02d38p-3, INEXACT)
T(RN,  0x1.5d0386f19b368p+823,    -0x1.f61f2224bb25p-2,  -0x1.023accp-3, INEXACT)
T(RN,  0x1.9e6f474d08abep+823,   -0x1.ed8b582739c4bp-4,   0x1.ac2512p-3, INEXACT)
T(RN,  0x1.64005677d6f2ap+823,    0x1.e3de3d4dd05e4p-1,   0x1.2fc716p-4, INEXACT)
T(RN,  0x1.722dcdea0ad5dp+823,    0x1.28afe1e690b6ep-1,  -0x1.8d60f8p-2, INEXACT)
T(RN,  0x1.6600d42228c99p+823,   -0x1.82147b802ac3ap-1,   0x1.a12fd8p-6, INEXACT)
T(RN,  0x1.e62703409cbbap+823,   -0x1.9fef766cfe909p-1,  -0x1.43ff92p-2, INEXACT)
T(RN,  0x1.a221b106102b3p+823,    0x1.49dc08b5c9d81p-1,    -0x1.ac41p-3, INEXACT)
T(RN,  0x1.24e3e89964a1ep+823,   -0x1.0ca317ec3e2aep-2,   0x1.c63ee8p-3, INEXACT)
T(RN,   0x1.58f8151279aep+823,    0x1.f984c4ad32335p-1,   0x1.f4c90cp-2, INEXACT)
T(RN,  0x1.076eae875ec35p+823,   -0x1.f18796ac217cap-3,   0x1.47219ap-2, INEXACT)
T(RN,  0x1.08ebed9dab5dcp+824,   -0x1.9e7326a2f438ap-3,  -0x1.ce2c78p-4, INEXACT)
T(RN,  0x1.d2e5f2b3ee018p+824,   -0x1.29e97f3ca3e31p-1,  -0x1.af10cep-2, INEXACT)
T(RN,  0x1.560ad7eb06286p+824,   -0x1.2b261ee134012p-2,   0x1.309552p-6, INEXACT)
T(RN,  0x1.d9ad97e140c4ep+824,    0x1.ff23c5c5c4de6p-1,   0x1.2e7e9cp-3, INEXACT)
T(RN,  0x1.86bcf6fe901e4p+824,     0x1.f49f54ddcd1fp-1,  -0x1.af91a4p-3, INEXACT)
T(RN,   0x1.6409dad4f4a5p+824,   -0x1.d8e4d67dab017p-1,    0x1.6e4e3p-2, INEXACT)
T(RN,  0x1.e315406555cedp+824,    0x1.d411a186c4ae8p-1,  -0x1.169894p-2, INEXACT)
T(RN,  0x1.1640e4995c115p+824,    0x1.7989f5d7f92c8p-2,    0x1.bc7c6p-5, INEXACT)
T(RN,  0x1.3e757d5d4f42cp+824,    0x1.f73de07840f3ep-3,   0x1.4c81d6p-2, INEXACT)
T(RN,  0x1.475b32f2d2696p+824,    0x1.39c794b75c2abp-2,   0x1.f1bdeap-2, INEXACT)
T(RN,   0x1.81ed4b8531e8p+825,     0x1.5682866abc64p-3,  -0x1.d39588p-2, INEXACT)
T(RN,  0x1.782ad87ec4bcap+825,    0x1.fd6e170be3968p-1,  -0x1.139a3ep-3, INEXACT)
T(RN,  0x1.9eff73b5d9de8p+825,    0x1.e07e8f9f66d28p-1,   0x1.2dec82p-2, INEXACT)
T(RN,  0x1.5ef3641ea8d06p+825,    0x1.fbbbd0af031c1p-1,  -0x1.814b9cp-2, INEXACT)
T(RN,  0x1.cea31233588b9p+825,    0x1.969857dff3619p-1,  -0x1.72c98cp-2, INEXACT)
T(RN,  0x1.8721a667c9befp+825,   -0x1.21d9b42796d3fp-2,   0x1.5a12b6p-2, INEXACT)
T(RN,  0x1.3765f3ad65c9ep+825,    -0x1.9a9844f0131cp-5,   0x1.7605cap-2, INEXACT)
T(RN,  0x1.a5e88109fd2a8p+825,   -0x1.b78fa0a7bea14p-1,  -0x1.cb2066p-2, INEXACT)
T(RN,  0x1.21475edab0edap+825,    0x1.f5cdc2dd8db99p-1,  -0x1.f2a60ep-2, INEXACT)
T(RN,  0x1.347b8e1c06e4ep+825,   -0x1.e642ac0bfdbecp-1,  -0x1.d86f4ap-3, INEXACT)
T(RN,  0x1.32d59dbabcc72p+826,    0x1.e64763bc4ec42p-1,  -0x1.a44ca4p-3, INEXACT)
T(RN,  0x1.f8c5272b10997p+826,    0x1.347687ea60f7bp-1,   0x1.acffb8p-2, INEXACT)
T(RN,  0x1.240e98cd0da6bp+826,    0x1.dd53f1a7a5f1cp-1,  -0x1.357e2ap-7, INEXACT)
T(RN,  0x1.a2248dbfeb12ap+826,    0x1.8a901053f5001p-1,   0x1.ec5aacp-3, INEXACT)
T(RN,  0x1.e0cd166bf612ep+826,   -0x1.8d18cb2a2df84p-1,   0x1.b55cd2p-2, INEXACT)
T(RN,  0x1.3ff0dbc8b224ep+826,    0x1.b552b02c2b365p-8,  -0x1.3a0e32p-2, INEXACT)
T(RN,  0x1.96104332cf0cap+826,   -0x1.71e6d5df724bfp-1,   0x1.02afb2p-3, INEXACT)
T(RN,  0x1.b5da1b5a57a45p+826,   -0x1.fff03edf9a87bp-1,  -0x1.8a7636p-3, INEXACT)
T(RN,  0x1.0dfe19422e9f2p+826,    0x1.fe46a3a8fc6acp-1,   0x1.39b6f6p-3, INEXACT)
T(RN,  0x1.cd7069c55bbf3p+826,   -0x1.d5d679b8f2ba1p-1,  -0x1.c1010ap-3, INEXACT)
T(RN,  0x1.dedac42881a03p+827,    0x1.96319f9fb6039p-1,   0x1.99b594p-3, INEXACT)
T(RN,  0x1.6e5cc48ef0a78p+827,   -0x1.f9469f3ad17ecp-1,  -0x1.b4bdbap-5, INEXACT)
T(RN,  0x1.ca4123bd876fep+827,    0x1.fa0b4cb8db3e4p-1,   0x1.9b58e4p-2, INEXACT)
T(RN,  0x1.c11140fb13d5cp+827,     0x1.26e669818fb1p-1,  -0x1.9c3bb2p-4, INEXACT)
T(RN,  0x1.7fcdeda9a26f6p+827,   -0x1.dfd755ac5998dp-2,   0x1.ee136ep-4, INEXACT)
T(RN,  0x1.18c70d987797fp+827,    0x1.259e16a22d3fap-1,   0x1.e1c02ep-2, INEXACT)
T(RN,  0x1.fb9fc69597269p+827,   -0x1.cc3f7c816e1c8p-1,  -0x1.a1c98ap-3, INEXACT)
T(RN,  0x1.8b5a71719f198p+827,    0x1.91639f24242eap-5,   0x1.cab6dep-3, INEXACT)
T(RN,   0x1.70264e266e27p+827,   -0x1.fc0b8f1167abcp-1,   0x1.4b78d8p-2, INEXACT)
T(RN,  0x1.25d65f185794cp+827,   -0x1.37b2abc8336b3p-2,   0x1.34a8f8p-3, INEXACT)
T(RN,  0x1.89f1ceb3d8ef6p+828,   -0x1.e8ef62a7b3eaap-2,  -0x1.d701c4p-2, INEXACT)
T(RN,  0x1.ef7dab57a2fa8p+828,    0x1.ff7804f674fbbp-1,   -0x1.92f13p-2, INEXACT)
T(RN,  0x1.d53a81bc19c6cp+828,    0x1.f79ec59048e65p-1,   0x1.a9fd78p-2, INEXACT)
T(RN,  0x1.5a3b3efd16e63p+828,    0x1.04f9cda68fed7p-3,    0x1.49a7dp-4, INEXACT)
T(RN,  0x1.eb7c5d9a9ccdcp+828,   -0x1.804f006f6aa52p-1,   0x1.e9ad7ap-2, INEXACT)
T(RN,  0x1.d81a995b32e85p+828,   -0x1.7df0f541aa119p-3,   0x1.7487dep-5, INEXACT)
T(RN,  0x1.28b4505795dadp+828,   -0x1.fc60c8f5b854cp-1,   0x1.f5f0f8p-4, INEXACT)
T(RN,  0x1.cb3a465b8ad2fp+828,    0x1.9d3232390ac08p-1,  -0x1.a5fa9cp-2, INEXACT)
T(RN,  0x1.a82f9b3f490c4p+828,    0x1.40377c24c2949p-1,  -0x1.e6b812p-5, INEXACT)
T(RN,  0x1.b1da1b1eafefep+828,    0x1.ff833c597fa39p-1,   0x1.906cf4p-2, INEXACT)
T(RN,  0x1.666599426e89bp+829,    0x1.f784c8b932fd6p-1,  -0x1.e4eb12p-2, INEXACT)
T(RN,  0x1.bf14c095f4514p+829,    0x1.ec80b8057fe48p-3,  -0x1.069e42p-2, INEXACT)
T(RN,  0x1.11c8bcd7224ecp+829,    0x1.2cb821a8bd70cp-1,   0x1.a855b8p-2, INEXACT)
T(RN,  0x1.c515f0ee19c5ap+829,   -0x1.5696b8b165883p-4,  -0x1.409a6ap-4, INEXACT)
T(RN,  0x1.5b1dd7ce39bbfp+829,    0x1.f8b913dfa3fd2p-1,   0x1.8ca8fep-5, INEXACT)
T(RN,  0x1.0ab1a935e3a09p+829,    0x1.0f7116305452dp-2,  -0x1.9dcbccp-3, INEXACT)
T(RN,  0x1.34a6c15adac4fp+829,    0x1.cc34154ec1952p-1,   0x1.a38f78p-2, INEXACT)
T(RN,  0x1.4782841942c48p+829,    0x1.ed49ac97afc58p-1,   -0x1.bcc36p-2, INEXACT)
T(RN,  0x1.979e481cbc902p+829,    0x1.f96881c6278e1p-1,  -0x1.d329eep-2, INEXACT)
T(RN,  0x1.cd380e584b383p+829,    0x1.e761adb7a0d1ap-2,   0x1.4f579ep-4, INEXACT)
T(RN,  0x1.6a433a6e1ab6ep+830,   -0x1.ff3ceaac0e777p-1,  -0x1.43e79cp-2, INEXACT)
T(RN,  0x1.95b91ee77af12p+830,   -0x1.e362ced0bba81p-1,  -0x1.bb79eap-2, INEXACT)
T(RN,  0x1.5bd344aeacd13p+830,    0x1.1c5aee0cbafe7p-2,  -0x1.5da628p-2, INEXACT)
T(RN,  0x1.93b53465a0bc1p+830,   -0x1.e630e13a4a0c4p-1,  -0x1.8a684ap-2, INEXACT)
T(RN,  0x1.06f01a84f191dp+830,   -0x1.edcbc5b7c0fafp-1,   0x1.ae963ep-2, INEXACT)
T(RN,  0x1.9152348ba3308p+830,    0x1.fd5062d53be7ep-1,  -0x1.45b74ep-4, INEXACT)
T(RN,  0x1.4e81e9ea706d9p+830,   -0x1.3c17acb2649acp-1,   -0x1.2781ep-2, INEXACT)
T(RN,  0x1.15411ba407534p+830,   -0x1.c46ade6ade4c7p-1,   0x1.0d1e28p-2, INEXACT)
T(RN,  0x1.a2adff48518bep+830,    0x1.f8b022c05c59cp-1,  -0x1.d9d512p-3, INEXACT)
T(RN,  0x1.21de05fabd6ddp+830,   -0x1.feef08ae87785p-1,  -0x1.73eb6ep-2, INEXACT)
T(RN,  0x1.d8dc69f2811dap+831,   -0x1.18a8f22a8dcd9p-1,  -0x1.38744ap-2, INEXACT)
T(RN,  0x1.df40053f572bfp+831,    0x1.8b6d3cc2f8786p-1,   0x1.d2acf2p-2, INEXACT)
T(RN,  0x1.6714fa3ec9ab1p+831,    0x1.edb17e2ad37fcp-1,   0x1.061c12p-2, INEXACT)
T(RN,   0x1.bb16654bd515p+831,    0x1.1fc8719b428e4p-2,  -0x1.c5d19cp-2, INEXACT)
T(RN,  0x1.d6242a0df0eaep+831,   -0x1.2f9d32a3c5502p-3,  -0x1.2b11f2p-4, INEXACT)
T(RN,  0x1.49068fef31614p+831,   -0x1.052a45166cabcp-4,  -0x1.16dcacp-2, INEXACT)
T(RN,   0x1.202636242d59p+831,    0x1.677d270d7cbffp-1,   -0x1.54cdbp-4, INEXACT)
T(RN,  0x1.0944b75282ae1p+831,   -0x1.e16383d2cca45p-1,   -0x1.2bacfp-2, INEXACT)
T(RN,  0x1.990ab61de6ab2p+831,   -0x1.706518344cb3dp-4,   0x1.aae2a2p-2, INEXACT)
T(RN,  0x1.4701a116c2fa4p+831,    0x1.22cbd2f99fb81p-2,   0x1.f7bcecp-5, INEXACT)
T(RN,  0x1.88740145caf45p+832,   -0x1.d4001e1087eefp-1,    0x1.bdff2p-2, INEXACT)
T(RN,  0x1.010282e8b6336p+832,    0x1.70dce0d846f5ap-1,  -0x1.6c1b6ep-2, INEXACT)
T(RN,  0x1.4ec597985b43cp+832,    0x1.ffdb28273a77cp-1,  -0x1.e8c148p-2, INEXACT)
T(RN,  0x1.713f74e6e06dap+832,    0x1.30de07bb79e8fp-1,    0x1.6ad6bp-2, INEXACT)
T(RN,  0x1.433dfec523858p+832,   -0x1.27c234f934721p-6,   0x1.8516c4p-3, INEXACT)
T(RN,  0x1.5cc8da9e8d67fp+832,    0x1.afc138f577e0bp-1,   0x1.c88118p-3, INEXACT)
T(RN,  0x1.91bf57a1f1035p+832,    -0x1.131b6b1658c7p-3,  -0x1.da2d94p-3, INEXACT)
T(RN,  0x1.4cd6dffe6c961p+832,    0x1.9b2a666029427p-1,   -0x1.1b82dp-2, INEXACT)
T(RN,  0x1.8c5587d3b5b7cp+832,   -0x1.fc81459fb1b81p-1,  -0x1.b51f7ep-5, INEXACT)
T(RN,  0x1.d76f763534f5ap+832,   -0x1.fa292de01fe75p-1,   0x1.08d0d4p-2, INEXACT)
T(RN,  0x1.4335aabaac096p+833,    0x1.d69b55b2fe014p-5,   -0x1.6e026p-2, INEXACT)
T(RN,  0x1.39ecea417c772p+833,    0x1.f9f731bce9cfap-1,  -0x1.23b152p-2, INEXACT)
T(RN,  0x1.97d6f4d03c4e6p+833,   -0x1.f59158c3c3c43p-1,   0x1.5b100ap-2, INEXACT)
T(RN,   0x1.56b2b9db91b4p+833,    0x1.19e5735398843p-1,  -0x1.d061dcp-3, INEXACT)
T(RN,  0x1.e972e6fb0fa11p+833,    0x1.128997fcbe353p-2,   0x1.449118p-2, INEXACT)
T(RN,  0x1.16fa42c787de5p+833,   -0x1.8d1d83f502515p-1,  -0x1.d9436ep-2, INEXACT)
T(RN,  0x1.ca5b68c08034cp+833,   -0x1.10e1e4486e35fp-1,  -0x1.44a5e2p-2, INEXACT)
T(RN,  0x1.7e08a1468939cp+833,   -0x1.58c62f82fe98fp-1,  -0x1.c6fa5ep-2, INEXACT)
T(RN,  0x1.d38b477b21132p+833,    0x1.dd078920d38e4p-1,   0x1.294e4cp-5, INEXACT)
T(RN,  0x1.be4356fbd2cccp+833,    0x1.1ec067bf61b8dp-1,  -0x1.06e95cp-3, INEXACT)
T(RN,  0x1.5afe5a71e13a8p+834,    0x1.428269888c572p-1,   0x1.b870b6p-3, INEXACT)
T(RN,  0x1.f6ed601b809e7p+834,    0x1.270dcfd2b24a6p-1,   0x1.f81c52p-2, INEXACT)
T(RN,  0x1.217217a0e440bp+834,    0x1.47bb066b01de7p-1,  -0x1.1ee6d2p-3, INEXACT)
T(RN,  0x1.29bfef060065cp+834,    0x1.df845138a53a2p-1,    0x1.2b395p-4, INEXACT)
T(RN,  0x1.701fde82b6748p+834,   -0x1.014464345c77ep-2,  -0x1.d7454cp-3, INEXACT)
T(RN,  0x1.7f3484748fcc7p+834,    0x1.21cca033aed2bp-3,   0x1.84a598p-2, INEXACT)
T(RN,  0x1.bf3bca4987196p+834,    0x1.4e9a10a337a81p-3,   0x1.3d72cep-2, INEXACT)
T(RN,  0x1.1526f33dcd37ap+834,   -0x1.f6be9dcfed21ap-2,  -0x1.f85cbep-4, INEXACT)
T(RN,  0x1.ed0d15a6385c4p+834,    0x1.42c4855bb6b72p-1,   0x1.d12ab8p-3, INEXACT)
T(RN,  0x1.a0c22f1bc5968p+834,    0x1.578a403a325b5p-3,   -0x1.3a4dcp-4, INEXACT)
T(RN,  0x1.fb9bd753c772fp+835,    0x1.eb16948d7ea66p-1,   0x1.e4265ap-6, INEXACT)
T(RN,  0x1.88fe6d2d358f8p+835,   -0x1.8997399496c99p-2,   0x1.7b000ap-2, INEXACT)
T(RN,  0x1.823dabe680c9ap+835,    0x1.b604ec7e4eb2ep-4,   0x1.b3b866p-4, INEXACT)
T(RN,  0x1.15fe3b9401d44p+835,    0x1.37a6f8275a908p-1,  -0x1.80aa52p-5, INEXACT)
T(RN,  0x1.254ffac7ab695p+835,   -0x1.8966f1b5b5b7dp-1,   0x1.fb6d76p-2, INEXACT)
T(RN,  0x1.115019fff92d1p+835,    0x1.5e023f29fe96cp-3,   0x1.3360f6p-4, INEXACT)
T(RN,  0x1.d3aefc901b73ap+835,    0x1.84b5a460e6506p-2,   0x1.ccf1e6p-4, INEXACT)
T(RN,  0x1.e6eddaa1774bep+835,   -0x1.b7e81e5d65ef3p-1,   -0x1.bdeffp-3, INEXACT)
T(RN,  0x1.a2c4753e10ebep+835,    0x1.51e094c04712ep-1,    0x1.12d33p-3, INEXACT)
T(RN,  0x1.e4b083e0848d6p+835,   -0x1.e88857a2922aep-1,  -0x1.d722c6p-2, INEXACT)
T(RN,  0x1.934739b4c84fdp+836,   -0x1.c690dace699fcp-1,  -0x1.376eeep-5, INEXACT)
T(RN,  0x1.d14506d649c5ep+836,   -0x1.441f1388cf14fp-3,  -0x1.328fc8p-3, INEXACT)
T(RN,  0x1.657c358d94d0dp+836,    0x1.f99ead0242952p-1,  -0x1.e76212p-2, INEXACT)
T(RN,  0x1.e1e20e6562084p+836,   -0x1.e6640689455bep-1,  -0x1.a42eeap-5, INEXACT)
T(RN,  0x1.4ab2346c6d4efp+836,    0x1.bb1766fa2f2a3p-2,   0x1.4a470cp-2, INEXACT)
T(RN,  0x1.d0aa4354685c7p+836,    0x1.ee67da698a4cfp-2,   0x1.2449a4p-3, INEXACT)
T(RN,  0x1.b32189a35e5e6p+836,   -0x1.e2861495f6cdfp-1,   0x1.76249ep-4, INEXACT)
T(RN,  0x1.62bd9c68517f9p+836,    0x1.9993e8ab76f94p-1,  -0x1.2f0308p-2, INEXACT)
T(RN,  0x1.aac47d330c33ep+836,   -0x1.06d7285cc83d7p-1,   0x1.a47ba8p-4, INEXACT)
T(RN,  0x1.35cd4f7ec3d27p+836,    0x1.cbfbfb0c04873p-1,   0x1.72700ep-5, INEXACT)
T(RN,  0x1.d50a869cf7012p+837,   -0x1.ecf05169a6e6fp-1,  -0x1.5e4d02p-3, INEXACT)
T(RN,  0x1.0ba4c6a98387ap+837,   -0x1.0f9ca7d432f6cp-1,   0x1.c24982p-2, INEXACT)
T(RN,  0x1.907184830eed8p+837,    0x1.f26aa4c7b4267p-1,  -0x1.3b862ep-2, INEXACT)
T(RN,  0x1.acb19ff0bdc8ep+837,    0x1.1ce3f1df70734p-2,   -0x1.1039bp-2, INEXACT)
T(RN,  0x1.b2d7fac97bceep+837,   -0x1.f6fa472052706p-1,  -0x1.7aa262p-2, INEXACT)
T(RN,  0x1.84a6c05e344bcp+837,    0x1.29098e997efb3p-1,  -0x1.d0ced8p-4, INEXACT)
T(RN,  0x1.5dab24dd22ac2p+837,    0x1.6a5cc17875249p-1,  -0x1.b74928p-4, INEXACT)
T(RN,  0x1.9cc2f11798acbp+837,   -0x1.fe74371a2e328p-1,   -0x1.deefep-3, INEXACT)
T(RN,  0x1.85dd5a4be79e6p+837,    0x1.0909e2c4e7e81p-2,  -0x1.da327ap-2, INEXACT)
T(RN,  0x1.08e1395de28b6p+837,   -0x1.6e80a7edf490bp-1,    0x1.885fap-3, INEXACT)
T(RN,  0x1.140fb5e7e268ap+838,   -0x1.871d9cdcb957bp-1,  -0x1.b7ebd8p-3, INEXACT)
T(RN,  0x1.4d3401767debep+838,   -0x1.12452264d08e5p-5,  -0x1.e6d13ep-2, INEXACT)
T(RN,  0x1.6fa357ed3c508p+838,    0x1.242bf92bf8f9ap-2,   0x1.bca1e6p-2, INEXACT)
T(RN,  0x1.8e6571c4d1456p+838,   -0x1.d9d7e3fc00c48p-1,   0x1.c6a6f2p-3, INEXACT)
T(RN,  0x1.402e6bef4b1ccp+838,   -0x1.1b6fa8bb10f8fp-2,   0x1.c330d4p-2, INEXACT)
T(RN,  0x1.6086c2cc7ec62p+838,   -0x1.5d13f89b47a33p-1,   -0x1.82f6fp-2, INEXACT)
T(RN,  0x1.455fc7358fd48p+838,   -0x1.dd70e5d630632p-2,    0x1.d1fcfp-3, INEXACT)
T(RN,  0x1.5adb334cacca4p+838,    0x1.e4d19f9340c3bp-1,    0x1.17f85p-4, INEXACT)
T(RN,  0x1.f2a95522033d5p+838,    0x1.2646354636af4p-1,  -0x1.cc9526p-5, INEXACT)
T(RN,  0x1.05fd7e5ba5a22p+838,    0x1.30f4c724f1d5ap-2,   0x1.c2ffa8p-4, INEXACT)
T(RN,  0x1.56afa8320950ap+839,    0x1.0f40e05b21983p-1,  -0x1.2dc4d4p-2, INEXACT)
T(RN,  0x1.1ff655c1de4a8p+839,   -0x1.41c0296f0cae4p-1,  -0x1.9fca56p-3, INEXACT)
T(RN,  0x1.c17e67553cfd4p+839,    0x1.e5e65ef442854p-1,  -0x1.74a3eep-2, INEXACT)
T(RN,  0x1.7ef93fb231f4cp+839,    0x1.3cd483638d429p-1,   0x1.45cca2p-5, INEXACT)
T(RN,  0x1.8b7426aee68bap+839,   -0x1.e1f12b52e0ca3p-1,   0x1.bcc4fap-2, INEXACT)
T(RN,  0x1.083eb275313bep+839,   -0x1.e42d7613aad0cp-1,   0x1.4310bap-3, INEXACT)
T(RN,  0x1.63f101f0028c6p+839,    0x1.af65023fe8318p-1,  -0x1.e877fcp-2, INEXACT)
T(RN,  0x1.838a41fb4b7a4p+839,    0x1.90be7d2121b28p-1,  -0x1.cc1866p-2, INEXACT)
T(RN,  0x1.64c9df82700bdp+839,    0x1.a1c3e48b3f5cbp-2,  -0x1.f602cep-3, INEXACT)
T(RN,  0x1.23b9cbd76e898p+839,   -0x1.33cb8e6119c99p-1,   0x1.13a094p-3, INEXACT)
T(RN,  0x1.e1d172f1e535fp+840,   -0x1.5cbc22b189cc6p-3,   0x1.db61eap-2, INEXACT)
T(RN,  0x1.08378eff5d111p+840,   -0x1.b37413511199bp-1,  -0x1.83eb56p-2, INEXACT)
T(RN,  0x1.8f3180011c538p+840,   -0x1.aedb70bc93b4dp-1,   0x1.9a606cp-3, INEXACT)
T(RN,  0x1.9730eb76f5306p+840,   -0x1.200d09073e81fp-1,  -0x1.12bf94p-3, INEXACT)
T(RN,  0x1.c0201dcf3e002p+840,   -0x1.f0789e3270d42p-1,  -0x1.5d2776p-2, INEXACT)
T(RN,  0x1.a5d9a9a4ab674p+840,    0x1.8988c23423336p-1,  -0x1.322248p-2, INEXACT)
T(RN,  0x1.52bb379a8a7bfp+840,    0x1.315f03b29dfbcp-2,  -0x1.c3d22cp-2, INEXACT)
T(RN,  0x1.6f82e80587c67p+840,    -0x1.4680fe005297p-1,  -0x1.36bac8p-3, INEXACT)
T(RN,  0x1.3c78c7fc82c92p+840,   -0x1.023f7d154bed4p-4,   -0x1.f4083p-2, INEXACT)
T(RN,  0x1.cbb4506ef1751p+840,    0x1.115aba8eb325cp-4,  -0x1.7f7c96p-2, INEXACT)
T(RN,  0x1.f5b733870139ep+841,    0x1.bbc7eff3ff1aap-1,   0x1.d0c2f8p-2, INEXACT)
T(RN,  0x1.9246fe8076a4bp+841,    0x1.177edc352f35fp-2,   0x1.48cae8p-2, INEXACT)
T(RN,  0x1.183c3e0b6c1a3p+841,   -0x1.dafda46ed0476p-1,   0x1.079978p-2, INEXACT)
T(RN,  0x1.60d68eb2513afp+841,    0x1.4dd2a868fcbf5p-1,   0x1.6cca84p-2, INEXACT)
T(RN,  0x1.bd13b88bb4894p+841,    0x1.f6bab5fcbe181p-4,    -0x1.3aafp-2, INEXACT)
T(RN,  0x1.7a47ace8d1f95p+841,    0x1.4c8397362be9ap-1,   0x1.30c1c4p-4, INEXACT)
T(RN,  0x1.57d5c37efc1bep+841,    0x1.1a818ecd8c76cp-2,  -0x1.196fa4p-4, INEXACT)
T(RN,  0x1.900ad98419e1ep+841,    0x1.9a43f5861b03cp-2,   0x1.c77e1ep-2, INEXACT)
T(RN,  0x1.572963d4e0e36p+841,    0x1.d86dc5a34505ap-1,   0x1.c5817cp-2, INEXACT)
T(RN,  0x1.59602e495dccdp+841,    0x1.74f009cb462b7p-3,  -0x1.c94be4p-3, INEXACT)
T(RN,  0x1.bae204d410d7fp+842,    0x1.009b2e6d8b88fp-5,  -0x1.fe35c2p-3, INEXACT)
T(RN,  0x1.66e8d9506331ap+842,   -0x1.c5365f94ad535p-1,   0x1.ba4caap-2, INEXACT)
T(RN,  0x1.6974dd2bbd536p+842,   -0x1.d8bd6e8d38dbcp-1,   0x1.7506eap-4, INEXACT)
T(RN,  0x1.a7194d28df4b1p+842,   -0x1.008da10c6b5d3p-1,  -0x1.f73368p-3, INEXACT)
T(RN,  0x1.4f5c3920a693bp+842,   -0x1.43ad9d06d050dp-3,  -0x1.787574p-3, INEXACT)
T(RN,   0x1.143c5d4a62ddp+842,   -0x1.f3791abb6ce0ap-1, -0x1.3d6e2cp-10, INEXACT)
T(RN,  0x1.c150b9ec3b49fp+842,    0x1.5122dfb0ef6c4p-3,   -0x1.dcfffp-3, INEXACT)
T(RN,  0x1.c79eb793d495ep+842,   -0x1.fb931d667e5cbp-1,  -0x1.88b188p-2, INEXACT)
T(RN,  0x1.c40f81c3722edp+842,    0x1.ff206afdfafbdp-1,   -0x1.feaa3p-3, INEXACT)
T(RN,  0x1.0ac1284dda028p+842,    0x1.9340953055f6ep-1,   0x1.d7c68ep-8, INEXACT)
T(RN,  0x1.2e34a9f0b1ca4p+843,   -0x1.4459f88b756ccp-4,  -0x1.689ca4p-2, INEXACT)
T(RN,  0x1.0895761ec2982p+843,    0x1.01a1121270fa3p-2,  -0x1.131488p-2, INEXACT)
T(RN,  0x1.a52fbca3124ffp+843,    0x1.4c57c96599544p-1,  -0x1.2f1f5cp-2, INEXACT)
T(RN,  0x1.bcc621571c22ep+843,    0x1.c1ba88e064086p-1,   0x1.eeef7cp-2, INEXACT)
T(RN,  0x1.93651aed357b2p+843,   -0x1.5c45125b4e943p-2,    0x1.f3abbp-4, INEXACT)
T(RN,  0x1.7b4c1b27fa0fcp+843,   -0x1.8f307cc8baecep-4,   0x1.abcf16p-2, INEXACT)
T(RN,  0x1.24a80dff99a11p+843,   -0x1.15f14afe05af6p-1,  -0x1.dd11a8p-2, INEXACT)
T(RN,  0x1.feb7c49ee2f02p+843,   -0x1.840ffb129b2a3p-2,   -0x1.ec906p-2, INEXACT)
T(RN,  0x1.b068fd52287a2p+843,    0x1.0da035461d7a4p-1,   -0x1.2b73fp-3, INEXACT)
T(RN,  0x1.b8df7b8cb7995p+843,   -0x1.4686cb1b5c653p-2,  -0x1.babc2ap-5, INEXACT)
T(RN,  0x1.6c9bf70f5a0c8p+844,   -0x1.9239627b58594p-2,   0x1.ed95fep-6, INEXACT)
T(RN,   0x1.ac425d664761p+844,    0x1.e76865572e598p-1,  -0x1.a7d19ep-3, INEXACT)
T(RN,  0x1.292401a1307cdp+844,    0x1.f7564e107b2dap-1,   0x1.5afa6cp-2, INEXACT)
T(RN,   0x1.71604100898bp+844,    0x1.eaa1bc38316d2p-1,   0x1.ce52eap-4, INEXACT)
T(RN,  0x1.accf7c3d62388p+844,   -0x1.93e16486ff4a4p-4,  -0x1.7696d6p-2, INEXACT)
T(RN,  0x1.5b9bfb5396436p+844,    0x1.f7434f9bc4abap-1,   0x1.a11d9ap-3, INEXACT)
T(RN,  0x1.656704dd905f7p+844,   -0x1.8f085d0f0a0dbp-7,  0x1.38b22cp-10, INEXACT)
T(RN,  0x1.727a757326eb2p+844,   -0x1.d55d12a257df3p-1,   0x1.116b76p-2, INEXACT)
T(RN,  0x1.0f6c82af15fccp+844,   -0x1.fbb4f585a31afp-1,   0x1.0ae3aap-6, INEXACT)
T(RN,  0x1.c95b5ada31badp+844,    -0x1.e5a23c53a346p-1,   0x1.30d9acp-2, INEXACT)
T(RN,  0x1.d092fa95e8429p+845,    0x1.4dca6229ab389p-2,   0x1.8eb0a2p-2, INEXACT)
T(RN,  0x1.ba35573f60af8p+845,    0x1.4eadccc0d11b5p-1,    0x1.6c9a9p-2, INEXACT)
T(RN,  0x1.1c42ca3d8d696p+845,   -0x1.bbd64b698ad1ep-1,  -0x1.03290cp-2, INEXACT)
T(RN,  0x1.b6492bf4fee09p+845,    0x1.d76f9a3751b81p-3,  -0x1.59f056p-2, INEXACT)
T(RN,    0x1.8ae39b603f2p+845,    0x1.c45d10d28a004p-1,   0x1.1542e2p-4, INEXACT)
T(RN,  0x1.f4ea26e1df647p+845,   -0x1.fff7825b0939bp-1,  -0x1.cd0584p-4, INEXACT)
T(RN,  0x1.f9faaf72c5362p+845,    0x1.ee882858e74bep-1,  -0x1.494a2cp-2, INEXACT)
T(RN,  0x1.890bc9bf25d66p+845,   -0x1.8a25d1b97c3bep-1,  -0x1.266e42p-2, INEXACT)
T(RN,  0x1.ef97cce829d8ap+845,   -0x1.47b6f94e49b39p-1,   0x1.370fcep-3, INEXACT)
T(RN,  0x1.891ab373a9f8ap+845,    0x1.a6e0aaf6e04bep-1,  -0x1.5dd788p-2, INEXACT)
T(RN,  0x1.c2d6019c4ea16p+846,    0x1.47998746ce0bfp-1,   0x1.39bfaep-4, INEXACT)
T(RN,  0x1.a127143ca3ed4p+846,    0x1.c18717c14784ep-1,  -0x1.641cfcp-2, INEXACT)
T(RN,  0x1.dcbe9bcae8254p+846,    0x1.e5e54cf02bfebp-1,   0x1.51c3b4p-3, INEXACT)
T(RN,  0x1.e1a5da498446bp+846,    0x1.22b59cdb7d23fp-1,  -0x1.a314fap-3, INEXACT)
T(RN,  0x1.d97d795bab91cp+846,   -0x1.7cf5987ac197dp-1,   0x1.24b0e6p-2, INEXACT)
T(RN,   0x1.2f1263c88922p+846,    0x1.59ba2bdd56acbp-2,  -0x1.6bd322p-5, INEXACT)
T(RN,  0x1.e7de5122e04dep+846,   -0x1.70d858db91556p-1,   0x1.321db2p-2, INEXACT)
T(RN,  0x1.5070d0744ff6bp+846,    -0x1.0eea44e03f79p-4,  -0x1.1a34eap-2, INEXACT)
T(RN,  0x1.0634936507c5fp+846,    0x1.2126d4ba393d9p-2,  -0x1.48700cp-3, INEXACT)
T(RN,  0x1.7792f79e7be8ap+846,    0x1.9986d885c65fbp-3,    0x1.a2b56p-3, INEXACT)
T(RN,  0x1.aa1ce18d6b371p+847,    0x1.2155ceda447abp-1,   0x1.7621a2p-3, INEXACT)
T(RN,   0x1.380ee0d2386bp+847,   -0x1.f03be72c6c6dep-1,  -0x1.807d64p-2, INEXACT)
T(RN,  0x1.fa34654aa332cp+847,   -0x1.4d4f605ca3023p-2,   0x1.d3c064p-2, INEXACT)
T(RN,  0x1.5685a7e9be003p+847,   -0x1.23abbe3d884dep-1,  -0x1.d27286p-2, INEXACT)
T(RN,  0x1.5a0246e2e5f89p+847,    0x1.289af5d68dc9dp-2,  -0x1.ef55d8p-3, INEXACT)
T(RN,  0x1.4eb6a9b606106p+847,    0x1.3cad055d38417p-3,  -0x1.dd2fd2p-3, INEXACT)
T(RN,  0x1.9ceee43a017bep+847,    0x1.fa9b10d17f0ffp-1,   0x1.6a1748p-6, INEXACT)
T(RN,  0x1.cbc036f14abc4p+847,    0x1.ffa0b0a36f2c8p-1,  -0x1.84d43cp-2, INEXACT)
T(RN,   0x1.032e959f9181p+847,    0x1.4bc2aad24a01ep-1,   -0x1.b712ap-3, INEXACT)
T(RN,  0x1.f080bb9a25b28p+847,    0x1.4b253af9261acp-2,   0x1.c27ee2p-3, INEXACT)
T(RN,  0x1.484b566fdfc45p+848,    0x1.d6abd9e47e1f6p-1,   0x1.6b3a5cp-3, INEXACT)
T(RN,  0x1.1a4f639e38b1bp+848,   -0x1.3d2d71387da04p-1,   -0x1.c3061p-2, INEXACT)
T(RN,  0x1.9dd578da670bap+848,    0x1.2d306e814d20ap-1,   0x1.2fde5ap-5, INEXACT)
T(RN,  0x1.f07e66b2556bep+848,   -0x1.dcd8adea0aac8p-1,   0x1.b38c4cp-5, INEXACT)
T(RN,  0x1.af2bdcbbbffbfp+848,    0x1.6227b806de414p-1,   0x1.1fc386p-2, INEXACT)
T(RN,  0x1.612b7e646a3a8p+848,    0x1.ff9b2aeb89209p-1,    0x1.7a38dp-2, INEXACT)
T(RN,  0x1.864f573fba4e8p+848,    0x1.701bc44c20e93p-4,  -0x1.a3997ap-3, INEXACT)
T(RN,  0x1.45bcc8490cf69p+848,    0x1.4e99ef143673cp-1,   0x1.51fa16p-2, INEXACT)
T(RN,  0x1.35da582862725p+848,    0x1.a1b23d4900505p-2,   0x1.f795e4p-3, INEXACT)
T(RN,  0x1.2ceb28ef4926ep+848,    0x1.ed0ba990dc847p-1,   0x1.42c0ecp-2, INEXACT)
T(RN,  0x1.84267dbaab699p+849,    0x1.4132baafb3e56p-1,   0x1.efeda4p-3, INEXACT)
T(RN,  0x1.77a198aa3010dp+849,     0x1.768ce9b58f4ap-3,  -0x1.f8aa94p-5, INEXACT)
T(RN,   0x1.6ab8d35364c9p+849,    0x1.5311bb5a2c33dp-2,   0x1.c7a962p-2, INEXACT)
T(RN,  0x1.bf92f240b1f9cp+849,    0x1.51d2914c1893ap-1,   -0x1.a3653p-2, INEXACT)
T(RN,   0x1.701ed08a8e6dp+849,   -0x1.68896549a48d6p-2,   0x1.883296p-2, INEXACT)
T(RN,  0x1.39f865688b719p+849,    0x1.f9b0362e8305bp-1,   0x1.6ecc12p-3, INEXACT)
T(RN,  0x1.89bae5e48617dp+849,     0x1.f067b98c6f14p-1,    0x1.bc1ffp-2, INEXACT)
T(RN,  0x1.d9f1f3ad881d9p+849,   -0x1.9dd23f6bf5616p-1,  -0x1.8b3134p-4, INEXACT)
T(RN,  0x1.0f6dd6263185bp+849,    0x1.78c94b6127a73p-1,   0x1.ede59ap-2, INEXACT)
T(RN,  0x1.207546243e0acp+849,   -0x1.40fae58dd996ap-1,  -0x1.f9e194p-2, INEXACT)
T(RN,   0x1.50c8bf94be1ap+850,   -0x1.749d05924ea73p-4,   0x1.72afd2p-5, INEXACT)
T(RN,   0x1.943fd6b0a882p+850,   -0x1.6f8adccf5d077p-4,  -0x1.f6c7a8p-2, INEXACT)
T(RN,  0x1.961e09661d036p+850,   -0x1.43c78e66a74e5p-2,    0x1.bd2d4p-4, INEXACT)
T(RN,  0x1.3e5658031a59fp+850,   -0x1.f5d012734211fp-1,   0x1.c3071ep-2, INEXACT)
T(RN,  0x1.4a3418e0b7362p+850,   -0x1.39d99fd4e8ef7p-3,   0x1.68150ep-3, INEXACT)
T(RN,  0x1.78007eca65b46p+850,   -0x1.0fe94cd41e152p-2,  -0x1.95b39ap-5, INEXACT)
T(RN,  0x1.c21c9e545c1d5p+850,   -0x1.d4ad9122669dap-1,   0x1.0b8026p-2, INEXACT)
T(RN,  0x1.13f24994546d4p+850,   -0x1.c835cb409d1d3p-1,   0x1.f4f134p-3, INEXACT)
T(RN,  0x1.c1274b1d8e2c8p+850,   -0x1.71627481ad63fp-3,   0x1.531352p-2, INEXACT)
T(RN,  0x1.2704aacf51f9dp+850,   -0x1.fe3b73c3d3a59p-3,  -0x1.2acafcp-2, INEXACT)
T(RN,  0x1.13ca835b06e6cp+851,   -0x1.fcd5f654664cfp-1,   0x1.8c61ccp-2, INEXACT)
T(RN,  0x1.8d70250fba414p+851,    0x1.ffcdee66fdf06p-1,   0x1.c80aeep-2, INEXACT)
T(RN,  0x1.54ebfb3ab698ep+851,    0x1.e3bbb26f1679bp-1,  -0x1.eed548p-9, INEXACT)
T(RN,  0x1.454f26f2490c3p+851,    0x1.e03e06597f37cp-1,  -0x1.7df25cp-8, INEXACT)
T(RN,  0x1.1724a80b65111p+851,   -0x1.12b4c4946071ap-3,   0x1.7ffa48p-2, INEXACT)
T(RN,  0x1.aa3537c618df4p+851,    -0x1.8a1451e43617p-1,  -0x1.c8394cp-3, INEXACT)
T(RN,  0x1.7616e37b11df6p+851,   -0x1.44621a5b31828p-1,   -0x1.d3471p-3, INEXACT)
T(RN,  0x1.2ccd8c6fd82c6p+851,   -0x1.4e4c2b155e567p-2,  -0x1.be59eep-2, INEXACT)
T(RN,  0x1.ebbf361de1abcp+851,   -0x1.5a2676838baddp-1,   0x1.0b109ep-3, INEXACT)
T(RN,  0x1.fd6e0fa7c1d9ap+851,    0x1.ea392121cf239p-2,   0x1.4c0f96p-3, INEXACT)
T(RN,  0x1.1eb1f666d451dp+852,   -0x1.01216ecf3a70fp-1,   0x1.8e90dap-2, INEXACT)
T(RN,  0x1.8e0a15b4dbd18p+852,   -0x1.a391037cfea66p-1,   0x1.f1e7a2p-4, INEXACT)
T(RN,  0x1.d127d1d44e84cp+852,    0x1.d9630aef8fe23p-1,   0x1.2bd164p-3, INEXACT)
T(RN,  0x1.e79f4baca7ea8p+852,    0x1.9dace27d6f606p-3,   0x1.fd7352p-3, INEXACT)
T(RN,  0x1.263d926f51607p+852,   -0x1.ffae76c890d4cp-1,   0x1.ac980ap-2, INEXACT)
T(RN,  0x1.027c9008e5294p+852,    0x1.f9ba9a2624066p-1,  -0x1.869c44p-2, INEXACT)
T(RN,  0x1.46fa879a7ec8ep+852,   -0x1.38a72d2de16a7p-2,   -0x1.07853p-7, INEXACT)
T(RN,  0x1.b6435eb2278a8p+852,    0x1.334c1edfa009bp-1,   0x1.956564p-2, INEXACT)
T(RN,   0x1.0df1817f9c03p+852,    0x1.d04cb70e63b45p-2,  -0x1.e44e12p-5, INEXACT)
T(RN,  0x1.928f52d225a62p+852,    0x1.8f968a239afebp-1,  -0x1.f75f84p-2, INEXACT)
T(RN,  0x1.a59e1b8b85376p+853,    0x1.415b565683ce8p-1,    0x1.4154cp-5, INEXACT)
T(RN,  0x1.0c24b384cfd0cp+853,    0x1.ff82b8ea16966p-1,   0x1.5283d8p-2, INEXACT)
T(RN,  0x1.607b43b39c18ep+853,    -0x1.2398a668e1afp-4,    0x1.c013cp-2, INEXACT)
T(RN,  0x1.5278dc9fc3c79p+853,    0x1.fa00a452a5026p-1,  -0x1.a06b28p-3, INEXACT)
T(RN,  0x1.6a60fdcbd72bap+853,   -0x1.55be3c9e14371p-1,   0x1.376436p-2, INEXACT)
T(RN,  0x1.381832b18d2c4p+853,   -0x1.7297f49feaac6p-1,  -0x1.b9925ep-2, INEXACT)
T(RN,  0x1.5e34324bed594p+853,   -0x1.5916f5a1e6b8bp-3,   0x1.e44a78p-2, INEXACT)
T(RN,  0x1.c41cd8c9a0beap+853,   -0x1.629b86365b005p-1,    0x1.f0e24p-5, INEXACT)
T(RN,  0x1.76af2ef4ad82ap+853,   -0x1.d19286b65b8e5p-2,  -0x1.cdfaa4p-2, INEXACT)
T(RN,  0x1.3d0696a3e719dp+853,    0x1.6641315ebaff6p-1,   0x1.ccc772p-3, INEXACT)
T(RN,  0x1.2b4e184255fcdp+854,    0x1.f1a2cb73304d7p-2,   0x1.d8fa78p-2, INEXACT)
T(RN,   0x1.90ce6faf820bp+854,   -0x1.f7d4bd38d45bbp-2,    0x1.5ad7bp-5, INEXACT)
T(RN,  0x1.8212d189c6aeep+854,   -0x1.bfdd0569da93dp-1,  -0x1.e49ef6p-2, INEXACT)
T(RN,  0x1.181cb93f671c8p+854,   -0x1.083a6c7f07064p-1,   0x1.e904d4p-2, INEXACT)
T(RN,  0x1.4b354b8c2da57p+854,   -0x1.8fa2891cc7049p-1,  -0x1.5ccab2p-4, INEXACT)
T(RN,  0x1.708b313d63634p+854,   -0x1.fffe8ffe24151p-1,   0x1.75fc14p-3, INEXACT)
T(RN,  0x1.06734ae8ab933p+854,   -0x1.6d252f1ea4cfdp-2,  -0x1.34e922p-3, INEXACT)
T(RN,  0x1.8dc8c4aa6a68cp+854,   -0x1.079d25ddcc663p-2,    -0x1.0126p-2, INEXACT)
T(RN,  0x1.1044a3a3c9cb4p+854,    0x1.36ff9db399f0cp-2,   0x1.9c9046p-2, INEXACT)
T(RN,  0x1.392bcdac489f2p+854,   -0x1.4071a62ac6be5p-2,  -0x1.44bb52p-2, INEXACT)
T(RN,  0x1.0f7535f95fbf1p+855,    0x1.24e66df8a8d31p-1,  -0x1.6dddeep-2, INEXACT)
T(RN,  0x1.04afdcd6967dbp+855,   -0x1.fe5cfc2232ebep-1,   0x1.40ddc4p-5, INEXACT)
T(RN,  0x1.c342d20c3cadap+855,    0x1.c956fcf6f22a7p-2,   0x1.8d89d6p-2, INEXACT)
T(RN,  0x1.8a49e176b6de7p+855,   -0x1.2ec736aae047cp-1,  -0x1.91b822p-2, INEXACT)
T(RN,  0x1.86b7a6963e93ap+855,   -0x1.7bbd6bd5dc8ffp-1,   0x1.e33a76p-2, INEXACT)
T(RN,  0x1.071caf7a40f7fp+855,   -0x1.e273aa8831c7ep-2,   0x1.ed7916p-4, INEXACT)
T(RN,  0x1.00c068eb159e9p+855,    0x1.ff41fd70ece41p-1,   0x1.96b38ep-3, INEXACT)
T(RN,  0x1.5a4e59308e0d1p+855,    0x1.68b2ab7b742adp-2,   0x1.7d5772p-2, INEXACT)
T(RN,  0x1.d1d1ab6cc19b8p+855,   -0x1.ebb66477b94f1p-2,   0x1.f319ccp-2, INEXACT)
T(RN,  0x1.789a05b22acf1p+855,   -0x1.ffedef3481894p-1,  -0x1.244cacp-2, INEXACT)
T(RN,  0x1.2345a0861abc3p+856,    0x1.eef575fc35086p-1,  -0x1.77ce24p-2, INEXACT)
T(RN,  0x1.15c3e73f17cb4p+856,   -0x1.36a3b619bed4ap-1,  -0x1.67df3ap-3, INEXACT)
T(RN,  0x1.2f30f8fb11047p+856,   -0x1.af0b56b246ef3p-2,   0x1.ba31cap-3, INEXACT)
T(RN,  0x1.c00d4e647ef6dp+856,   -0x1.f6bffd32c0d1cp-1,  -0x1.a6e7aep-2, INEXACT)
T(RN,   0x1.d2b21b822414p+856,   -0x1.13028ff225865p-1,   0x1.d05e58p-4, INEXACT)
T(RN,  0x1.0a03d861fa677p+856,    0x1.262aae2d6338cp-1,    0x1.ecd32p-3, INEXACT)
T(RN,  0x1.9f446bf3443f8p+856,    0x1.fa4a5a5e96054p-1,  -0x1.dfdc6ap-2, INEXACT)
T(RN,  0x1.0fc30af942264p+856,   -0x1.63e825fad7a83p-2,    0x1.d390fp-7, INEXACT)
T(RN,  0x1.fb6021a05e07cp+856,    0x1.eb5997eec867dp-1,   0x1.fdcb62p-2, INEXACT)
T(RN,  0x1.383fe86394536p+856,    0x1.ec6aa13345583p-2,    0x1.0f636p-5, INEXACT)
T(RN,  0x1.8dae373c9ef1ap+857,   -0x1.fc717cfe1cedap-1,  -0x1.b6f80cp-7, INEXACT)
T(RN,  0x1.40bae6299eaedp+857,    0x1.caec6df3e4bf4p-1,   0x1.5b7adep-2, INEXACT)
T(RN,  0x1.68c78ba03e9d6p+857,     0x1.8f09b8d38eccp-1,  -0x1.89d696p-5, INEXACT)
T(RN,  0x1.32669da35c174p+857,   -0x1.f71fa3eec5d97p-1,   0x1.c40f4ep-2, INEXACT)
T(RN,   0x1.801bbf99a73ap+857,   -0x1.84c3acf65850ep-1,  -0x1.28f406p-4, INEXACT)
T(RN,  0x1.0eb9865d3ca1bp+857,    0x1.633f29ce1fc0fp-1,   -0x1.18583p-2, INEXACT)
T(RN,  0x1.e08371b908e1bp+857,    0x1.fa23084828375p-1,   0x1.9c92cap-2, INEXACT)
T(RN,  0x1.5c3fa375975c1p+857,    0x1.ac75f72dc5ec5p-3,   -0x1.41959p-3, INEXACT)
T(RN,  0x1.5fb1f27a901cap+857,     0x1.80ad66332fe2p-3,  -0x1.7d7518p-2, INEXACT)
T(RN,  0x1.af3d7d39c91afp+857,   -0x1.fadb4f8f79dfbp-1,   0x1.5ddd5ep-2, INEXACT)
T(RN,  0x1.e6981b5279f4ap+858,   -0x1.f7bdff02a7ea7p-1,    0x1.d5f9ap-5, INEXACT)
T(RN,  0x1.a44a9136d4254p+858,   -0x1.e6897a054437fp-2,  -0x1.d54ab2p-2, INEXACT)
T(RN,  0x1.f4a9d09c6da46p+858,   -0x1.df37a2f08d1e3p-1,  -0x1.86064ap-3, INEXACT)
T(RN,  0x1.79671caed87e7p+858,    -0x1.c8f343d3a731p-1,  -0x1.78beeep-2, INEXACT)
T(RN,  0x1.be2dae990ea9ep+858,    0x1.22d6e36fa5d8fp-1,  -0x1.acfca6p-2, INEXACT)
T(RN,  0x1.ccd90e9f350eap+858,    0x1.fcea3b3cac937p-1,  -0x1.065c86p-3, INEXACT)
T(RN,  0x1.0c4eebb0a7741p+858,    0x1.e6cd3de81bc3ep-6,  -0x1.3f0762p-2, INEXACT)
T(RN,  0x1.34c48ea427d06p+858,    0x1.4d3a16c4a520cp-1,   0x1.f263a2p-2, INEXACT)
T(RN,  0x1.ec61a5ab9947ep+858,   -0x1.4a68884d3dac9p-1,  -0x1.b3ae1ep-5, INEXACT)
T(RN,  0x1.a78f6de033fdfp+858,   -0x1.cd9a38638aaf3p-1,   -0x1.77336p-2, INEXACT)
T(RN,  0x1.9c0afb319e9ecp+859,    0x1.2fd0eee8f3bbcp-5,    0x1.31d0dp-4, INEXACT)
T(RN,  0x1.565ccaa2ae788p+859,    -0x1.b07a66bcd894p-4,   0x1.8a0b1ep-6, INEXACT)
T(RN,  0x1.deaf5dffe98bbp+859,    0x1.984d6e9ac219cp-3,   0x1.24afbap-2, INEXACT)
T(RN,  0x1.4ca14ce01c471p+859,    0x1.112bb7c6efa2ep-2,   0x1.409252p-3, INEXACT)
T(RN,  0x1.ce6aa846ead62p+859,    0x1.041e332ee8998p-2,  -0x1.ed635ep-2, INEXACT)
T(RN,  0x1.0ed250eecf9ddp+859,    0x1.09dfa1ef76a84p-1,  -0x1.ea474cp-5, INEXACT)
T(RN,  0x1.3c6d27331a782p+859,   -0x1.c9ecdad4cbd05p-3,   0x1.90edbcp-3, INEXACT)
T(RN,  0x1.d02999c3636ffp+859,    0x1.d8f1c09c18d6ap-2,  -0x1.7c2d3ap-6, INEXACT)
T(RN,  0x1.b2b28c05e1df6p+859,    0x1.d7efdeb1ca089p-1,   0x1.345ceap-2, INEXACT)
T(RN,  0x1.eaab8ab1dee28p+859,    0x1.1e85d6c043042p-1,  -0x1.735f62p-2, INEXACT)
T(RN,  0x1.4800c991220aap+860,    0x1.2ae2d21d56357p-2,   0x1.5281fcp-3, INEXACT)
T(RN,  0x1.fb085c2a1bf6ep+860,   -0x1.5f9f32146abacp-9,  -0x1.7d4854p-2, INEXACT)
T(RN,  0x1.b4d8cdb2104c8p+860,    0x1.86d9209b060b1p-3,   0x1.c33344p-5, INEXACT)
T(RN,  0x1.0e879ad7e0d1ap+860,   -0x1.68be235309c48p-1,   -0x1.3bd83p-2, INEXACT)
T(RN,  0x1.129f323a98093p+860,   -0x1.00df6df41b49dp-5,  -0x1.c33932p-2, INEXACT)
T(RN,  0x1.c7345ca448bc3p+860,   -0x1.54e66866f5058p-5,  -0x1.3dfca8p-2, INEXACT)
T(RN,  0x1.7c682ed191796p+860,    -0x1.838b9a3b8dc7p-1,  -0x1.ddc9fap-2, INEXACT)
T(RN,  0x1.022aa6cad26fep+860,     -0x1.0b6d1b8a196p-2,   0x1.8fdd4ap-4, INEXACT)
T(RN,  0x1.4466cec7b2a32p+860,    0x1.415280b3d23d9p-1,  -0x1.1d8cb2p-2, INEXACT)
T(RN,   0x1.7e8e9824029bp+860,   -0x1.fa91cbf58bdedp-1,   0x1.229f7ap-4, INEXACT)
T(RN,  0x1.302690bcdd2a8p+861,    0x1.f49993764f5dbp-1,   0x1.097fdcp-2, INEXACT)
T(RN,  0x1.be8eee60df3dcp+861,   -0x1.2156f3d6f48dfp-1,   0x1.e59394p-3, INEXACT)
T(RN,  0x1.be941ee696e0fp+861,   -0x1.fe7939b772ad4p-1,  -0x1.827346p-2, INEXACT)
T(RN,  0x1.135f2ef46cbdfp+861,     -0x1.22472cac76ep-1,   0x1.b924acp-2, INEXACT)
T(RN,  0x1.05cedad1702a4p+861,    0x1.d64859ddcda19p-1,   0x1.917214p-2, INEXACT)
T(RN,  0x1.60362246004b9p+861,   -0x1.a36ea97675377p-4,   0x1.fe278ap-4, INEXACT)
T(RN,  0x1.97191ac86bc6ap+861,     0x1.ca39149027aap-2,    0x1.8887ap-2, INEXACT)
T(RN,   0x1.a4574b77e35cp+861,   -0x1.cfe54352f3a7ep-1,   0x1.1e07dep-3, INEXACT)
T(RN,  0x1.386ec04f7d81ap+861,    0x1.c9034e8bafcd7p-1,  -0x1.3c7804p-9, INEXACT)
T(RN,  0x1.9196b78632812p+861,   -0x1.1349c63ed921ap-4,   0x1.49ebd2p-2, INEXACT)
T(RN,  0x1.e133ddefaad54p+862,    0x1.7c99a49c3a3ddp-4,    0x1.09229p-3, INEXACT)
T(RN,   0x1.9cc9672b0816p+862,   -0x1.2aa4142ce2b74p-1,    0x1.1327dp-6, INEXACT)
T(RN,  0x1.2e25c575f2f7bp+862,    0x1.c08825060542dp-1,   0x1.fa623ap-4, INEXACT)
T(RN,  0x1.36ae553395e8ep+862,    0x1.85781c5b65e1bp-1,  -0x1.3352dap-2, INEXACT)
T(RN,  0x1.8cd36fa5b0bbcp+862,   -0x1.58d59abc1234bp-1,   0x1.30a0ccp-4, INEXACT)
T(RN,  0x1.22e08eaf32898p+862,    0x1.ea8d3955a484ap-1,   -0x1.f3565p-2, INEXACT)
T(RN,  0x1.2929bf86b4614p+862,   -0x1.f6d55f4eac218p-1,  -0x1.4553c4p-2, INEXACT)
T(RN,  0x1.ea61a2cfe4386p+862,    0x1.ff6b82b1bf988p-1,  -0x1.57bb86p-2, INEXACT)
T(RN,  0x1.5314cb20873b8p+862,    0x1.6db594c3a90a1p-1,  -0x1.9b99aep-3, INEXACT)
T(RN,  0x1.69696d602ecb6p+862,   -0x1.b6c34eb6769b1p-1,  -0x1.57dd94p-2, INEXACT)
T(RN,   0x1.b81f00626ee8p+863,   -0x1.e7f9335a0c6c5p-1,  -0x1.c1a16ap-2, INEXACT)
T(RN,  0x1.0d9faaacba6e4p+863,   -0x1.064d457034629p-2,   0x1.b89464p-2, INEXACT)
T(RN,  0x1.94b4d566b6317p+863,   -0x1.f4439dfbe1ee4p-1,  -0x1.34423ap-2, INEXACT)
T(RN,  0x1.986d4999e5859p+863,    0x1.c2fb8c5e81a76p-1,   0x1.f6e5bap-2, INEXACT)
T(RN,  0x1.e5f5f021c2924p+863,   -0x1.bf649417f51b1p-1,    0x1.41714p-2, INEXACT)
T(RN,  0x1.0bbca3518675bp+863,   -0x1.ff254d717ba77p-1,   0x1.c04f9ep-3, INEXACT)
T(RN,   0x1.af4c7e734519p+863,    0x1.c1710ca6bcabbp-2,   0x1.b574c6p-4, INEXACT)
T(RN,  0x1.bfde6ab319fc6p+863,    0x1.6b6ef52c2b9fap-1,   0x1.f4132ep-3, INEXACT)
T(RN,  0x1.cbc4c8f5f67fep+863,    0x1.96d7441bf458ap-5,  -0x1.f3e142p-2, INEXACT)
T(RN,  0x1.2f4840e19a97cp+863,   -0x1.b03bf36f44a58p-2,    0x1.a883bp-2, INEXACT)
T(RN,   0x1.b8c21e4e8038p+864,    0x1.27a5d38e60167p-1,  -0x1.d36668p-3, INEXACT)
T(RN,  0x1.e46d829f0942fp+864,   -0x1.ef274c025bae6p-1,   0x1.456234p-2, INEXACT)
T(RN,  0x1.6380e38131b47p+864,   -0x1.bcdaa085ba84ep-1,   0x1.653242p-2, INEXACT)
T(RN,  0x1.c166a14c3c01ap+864,    0x1.f3af5123edcc9p-1,   0x1.85a148p-4, INEXACT)
T(RN,  0x1.65eb66facb6d9p+864,    0x1.fa594a43b7e2bp-1,  -0x1.642c8ep-2, INEXACT)
T(RN,  0x1.673daadfcea33p+864,    0x1.ddea433260451p-1,  -0x1.511f9ep-3, INEXACT)
T(RN,  0x1.2af6052f7b901p+864,   -0x1.da6953ee11fc9p-1,  -0x1.95f3b6p-2, INEXACT)
T(RN,  0x1.f97ff12746952p+864,   -0x1.2fb5627c90a5cp-3,   0x1.e8b6d6p-4, INEXACT)
T(RN,  0x1.0d4c62c809cb6p+864,     0x1.fe57fafa94bcp-1,     -0x1.dd3p-2, INEXACT)
T(RN,  0x1.38340fca9eceep+864,   -0x1.d7e1e98082597p-4,  -0x1.b02b94p-2, INEXACT)
T(RN,  0x1.83d36551e57e2p+865,    0x1.cec4eac676ab5p-1,   0x1.490feep-2, INEXACT)
T(RN,  0x1.274e437cc62d7p+865,    0x1.96bf608fb6891p-3,   -0x1.edff9p-2, INEXACT)
T(RN,  0x1.f45b45ca853a2p+865,   -0x1.e43a37aead198p-1,   -0x1.1cc43p-2, INEXACT)
T(RN,  0x1.540aadc30a71bp+865,   -0x1.f12389bbea3d4p-2,   0x1.cf5814p-2, INEXACT)
T(RN,  0x1.7b1ef46f0fb59p+865,    0x1.2f64f7fc00746p-1,  -0x1.7f7844p-5, INEXACT)
T(RN,  0x1.8fd818ae19c45p+865,    0x1.efc87071cfc38p-1,   0x1.3e54a4p-4, INEXACT)
T(RN,  0x1.5285486a44325p+865,   -0x1.cddfc5d09d897p-1,  -0x1.a5a866p-2, INEXACT)
T(RN,  0x1.99fb694ca6398p+865,    -0x1.fb8d6951a613p-1,   0x1.678bfap-2, INEXACT)
T(RN,  0x1.043d945a141bep+865,    0x1.3029e9dda6883p-2,   0x1.2dc6a6p-2, INEXACT)
T(RN,  0x1.7308485a5b82cp+865,   -0x1.28ec1e8fcf872p-1,  -0x1.36d234p-2, INEXACT)
T(RN,  0x1.7012096c0fb23p+866,   -0x1.4dbc32b2d642bp-1,   0x1.87eb96p-2, INEXACT)
T(RN,   0x1.f2e6d7f1320bp+866,    -0x1.b607ec4594d6p-2,  -0x1.27b486p-2, INEXACT)
T(RN,  0x1.ccfcdd610f14ap+866,   -0x1.5d5ffbf45392dp-1,  -0x1.6b8e8ep-6, INEXACT)
T(RN,  0x1.3b8f13e52fd8ep+866,   -0x1.d87d55a208dcfp-1,   0x1.1ca294p-3, INEXACT)
T(RN,  0x1.d9e42d3a3cf56p+866,   -0x1.5195f89107eebp-3,   0x1.7c2d5cp-2, INEXACT)
T(RN,   0x1.86e13075bbb9p+866,    0x1.fe7b96691195ap-1,   0x1.3e1d18p-4, INEXACT)
T(RN,  0x1.aea7a9087ba9ep+866,   -0x1.e4d470fc8d359p-2,   0x1.5e17dap-2, INEXACT)
T(RN,   0x1.784f77bd7947p+866,   -0x1.f8388076c4dcbp-1,   0x1.a791eep-5, INEXACT)
T(RN,  0x1.03c28b71db6f2p+866,     0x1.fbe943038116p-1,  -0x1.0a5774p-2, INEXACT)
T(RN,  0x1.e41b2f4f9dc34p+866,   -0x1.6babd81c75cd2p-4,   -0x1.66916p-3, INEXACT)
T(RN,  0x1.45b991d321d9ap+867,    0x1.1eed71f68394cp-1,   0x1.d152e6p-7, INEXACT)
T(RN,  0x1.62e2a5f05c5b6p+867,    0x1.b8eaedb4416fdp-2,   -0x1.c95b2p-2, INEXACT)
T(RN,  0x1.2ac989b10e2dap+867,   -0x1.a6bf45e0f8789p-1,  -0x1.6a5016p-2, INEXACT)
T(RN,  0x1.90a4c351884b1p+867,   -0x1.9eb0f5bcd4469p-1,   0x1.63f5a4p-3, INEXACT)
T(RN,  0x1.d1a3ff3bb238cp+867,    0x1.f78ba5a2b5737p-1,  -0x1.b6fb5ap-2, INEXACT)
T(RN,  0x1.c18f7d9956808p+867,    0x1.821ecc0d92753p-5,  -0x1.4d0034p-2, INEXACT)
T(RN,  0x1.e0f2fafe64eebp+867,   -0x1.f9841fffd7326p-1,  -0x1.152d2cp-2, INEXACT)
T(RN,  0x1.f81734d89f8b2p+867,    0x1.ef3afe1e18579p-1,  -0x1.c2f3bcp-2, INEXACT)
T(RN,  0x1.8615495db9132p+867,   -0x1.4f02432a8f097p-1,   0x1.1fa5c8p-3, INEXACT)
T(RN,  0x1.61aee88e85f4dp+867,    0x1.7e2fbc694c4b1p-3,   0x1.64a49ap-3, INEXACT)
T(RN,  0x1.3b7c121ea660ap+868,    0x1.d0b789d3624a4p-1,  -0x1.19339cp-2, INEXACT)
T(RN,  0x1.f9d276d07c9a3p+868,   -0x1.78ced8e433216p-1,   0x1.a46024p-4, INEXACT)
T(RN,  0x1.37fd597515157p+868,   -0x1.090f85a848042p-4,   0x1.f101e4p-3, INEXACT)
T(RN,   0x1.7b39872a9f9cp+868,    -0x1.640148042b43p-1,   0x1.219956p-3, INEXACT)
T(RN,  0x1.60be0ac3a4f17p+868,     0x1.ba7cae232c05p-3,   0x1.ed4906p-2, INEXACT)
T(RN,   0x1.7352ae82cc01p+868,    0x1.2579cfa703954p-2,  -0x1.571cb6p-4, INEXACT)
T(RN,  0x1.85604bbe64844p+868,    0x1.fe082b82f0783p-1,  -0x1.f68eaap-3, INEXACT)
T(RN,  0x1.f5283f0081526p+868,   -0x1.0600caa58a4abp-1,   0x1.fd841cp-2, INEXACT)
T(RN,  0x1.e74fdc20c847cp+868,   -0x1.fcc460928a97ep-2,  -0x1.ff5e36p-3, INEXACT)
T(RN,  0x1.c62d7bd49d772p+868,   -0x1.73745cc1e3e08p-1,  -0x1.e33988p-3, INEXACT)
T(RN,  0x1.0ee676bc8960ep+869,    0x1.f96c329295ad3p-3,   0x1.5de65ep-2, INEXACT)
T(RN,  0x1.676331905bdeap+869,    0x1.bd6098b0048e3p-3,   0x1.36dcdep-3, INEXACT)
T(RN,   0x1.cb08c59b7fe4p+869,    0x1.3695d631fef49p-2,   0x1.e3f458p-2, INEXACT)
T(RN,  0x1.f5a1e168743fbp+869,   -0x1.ffffddd92f9c9p-1,   0x1.e1eebcp-4, INEXACT)
T(RN,  0x1.1a4c85c86a3f3p+869,   -0x1.7851c153b2f25p-1,  -0x1.78a27ep-2, INEXACT)
T(RN,  0x1.e1983e5c5b8aap+869,    0x1.8cc1aa38d86f2p-2,  -0x1.ce7feep-2, INEXACT)
T(RN,  0x1.5be3da8268cd1p+869,    0x1.213c812127108p-4,   0x1.defb4ep-3, INEXACT)
T(RN,  0x1.d4be9ea57373cp+869,   -0x1.d53f3b242c14bp-1,   0x1.76c554p-3, INEXACT)
T(RN,  0x1.935a07d195ff8p+869,   -0x1.109954b890f53p-1,    0x1.b054cp-3, INEXACT)
T(RN,  0x1.a416f0d8a278ep+869,   -0x1.fc2500b55058cp-3,   -0x1.cb118p-2, INEXACT)
T(RN,  0x1.b6b24ec43c274p+870,   -0x1.50c9f9a4e7b2dp-2,  -0x1.8d64c8p-4, INEXACT)
T(RN,  0x1.827f1d4b86d64p+870,   -0x1.42f7cda07d4c3p-2,  -0x1.c8417cp-2, INEXACT)
T(RN,  0x1.df2d84992382cp+870,    0x1.bd9855b588027p-3,   0x1.18985cp-3, INEXACT)
T(RN,  0x1.a820b5b696118p+870,    0x1.ff0681e654ea7p-1,   -0x1.80743p-2, INEXACT)
T(RN,  0x1.dfadbf1b07b78p+870,    0x1.ca08edad2f62fp-1,    -0x1.77a1p-3, INEXACT)
T(RN,  0x1.8c1469270ea79p+870,   -0x1.28e13d3af609bp-5,  -0x1.8c7f96p-2, INEXACT)
T(RN,  0x1.2376f39426dcep+870,    0x1.d9802d5065fbbp-4,   0x1.355242p-2, INEXACT)
T(RN,  0x1.bc8e65ad095bap+870,    -0x1.d86ddf6a2306p-1,    0x1.38f81p-2, INEXACT)
T(RN,  0x1.47c64bd4090a2p+870,   -0x1.f3ab6c5111b7fp-7,   0x1.e565acp-2, INEXACT)
T(RN,  0x1.fa4ae37a0632cp+870,   -0x1.aaf7278d5d4cep-1,   0x1.64b2c2p-4, INEXACT)
T(RN,  0x1.1b7f608e31a76p+871,    0x1.ae87d4529d082p-4,  -0x1.f835fap-2, INEXACT)
T(RN,  0x1.96c84252617fep+871,     -0x1.60848fa791bp-2,  -0x1.e9f672p-2, INEXACT)
T(RN,  0x1.e7b84f47ba542p+871,    0x1.c7443d0675f0ep-4,  -0x1.f5445ap-2, INEXACT)
T(RN,  0x1.90bcabdd05b46p+871,   -0x1.2ab62ae517381p-1,   0x1.2420b6p-2, INEXACT)
T(RN,  0x1.f38b7caa1e5bap+871,   -0x1.150b302f6af28p-3,   0x1.4e98b4p-4, INEXACT)
T(RN,  0x1.081a1dc4062d2p+871,   -0x1.8863a8ca62d8bp-1,   0x1.6d2dcep-3, INEXACT)
T(RN,  0x1.01edf70a6149fp+871,    0x1.d311ef9bd69e1p-4,  -0x1.ce9dfep-2, INEXACT)
T(RN,  0x1.b37ca1ee4cedap+871,   -0x1.2593a1251e841p-4,  -0x1.b03232p-6, INEXACT)
T(RN,  0x1.c057bfa272f98p+871,   -0x1.fe5a718bd0c77p-1,  -0x1.b1f066p-2, INEXACT)
T(RN,  0x1.ead80f41e66b6p+871,     0x1.3b08a234ca3ap-2,   0x1.1b039ep-5, INEXACT)
T(RN,  0x1.b32f5a0639f04p+872,    0x1.412ddb6d05f23p-1,   0x1.320276p-3, INEXACT)
T(RN,  0x1.edcb567186c5ep+872,   -0x1.24bcbd727fd92p-1,   0x1.b14b98p-2, INEXACT)
T(RN,  0x1.6d7849fcf04b2p+872,    0x1.828c37b16d704p-3,  -0x1.c1bf62p-3, INEXACT)
T(RN,  0x1.2f8ad5abd80a6p+872,   -0x1.347cf5fe62274p-5,   0x1.2ac6c8p-4, INEXACT)
T(RN,  0x1.ccb76c04f4f96p+872,    0x1.5fa9242e24254p-1,   0x1.7e2cf2p-2, INEXACT)
T(RN,  0x1.6baf9f67aa3b1p+872,   -0x1.c4dac5c94fc63p-1,  -0x1.462e34p-2, INEXACT)
T(RN,  0x1.0d31df6fcd133p+872,   -0x1.e820dbc153b2bp-1,  -0x1.eb7e96p-2, INEXACT)
T(RN,  0x1.6b405f9f14dbap+872,   -0x1.d51a4d65e38c6p-1,  -0x1.85c07ep-3, INEXACT)
T(RN,  0x1.8427b24b21fd6p+872,    0x1.a390eb6b37ccap-4,   0x1.3eb3b6p-2, INEXACT)
T(RN,  0x1.c6c391031107cp+872,   -0x1.e2791a5240657p-1,    0x1.693d5p-2, INEXACT)
T(RN,  0x1.8dd9c6236d728p+873,   -0x1.e38cd55e06daap-1,   0x1.9fc8b6p-2, INEXACT)
T(RN,  0x1.6ce93dbf7ab95p+873,   -0x1.cdc3270c2915dp-1,  -0x1.54f1cp-10, INEXACT)
T(RN,  0x1.7e7ec691aa846p+873,   -0x1.f4c1352644b8dp-1,  -0x1.ec4fd4p-5, INEXACT)
T(RN,  0x1.2171c782680dcp+873,    0x1.0b941af4ccb3ap-2,  -0x1.8e0a44p-2, INEXACT)
T(RN,  0x1.1533ed9a0c77ap+873,    0x1.98363419fccefp-3,   0x1.6f631cp-3, INEXACT)
T(RN,  0x1.4142be47fb342p+873,   -0x1.adf8ca3fec387p-2,  -0x1.e8c4d4p-3, INEXACT)
T(RN,  0x1.40ce3fe24c735p+873,    -0x1.4f6aa20d086fp-2,  -0x1.5ed70ep-2, INEXACT)
T(RN,  0x1.5f671c370aa7ep+873,   -0x1.589e46cf28204p-1,    0x1.e168ep-2, INEXACT)
T(RN,  0x1.7d2f38ea326f8p+873,    0x1.0a5578e929a3ap-1,  -0x1.f493f8p-2, INEXACT)
T(RN,  0x1.0fcf2a451da9bp+873,    -0x1.5bc2e6686cafp-1,  -0x1.2dccb6p-4, INEXACT)
T(RN,  0x1.1767b93e2d4f3p+874,    0x1.afbe5796a14a8p-1,  -0x1.fcf0e4p-2, INEXACT)
T(RN,  0x1.de1238ecc60f9p+874,   -0x1.f2934039c8842p-1,   0x1.fbe588p-3, INEXACT)
T(RN,  0x1.fde7ded3be05ap+874,    0x1.40db7ccc538bcp-2,   0x1.ec001ep-2, INEXACT)
T(RN,  0x1.5d1e5fb018d42p+874,    0x1.e9f00ce0dfd2cp-1,  -0x1.e638a8p-2, INEXACT)
T(RN,  0x1.8149a3a72dd3cp+874,    0x1.2c156a4efff6dp-1,   0x1.60b22ap-4, INEXACT)
T(RN,  0x1.7df15a79f347ep+874,   -0x1.e1bb3fcc02769p-1,   -0x1.dde9cp-2, INEXACT)
T(RN,  0x1.db1ec65b0cef6p+874,    0x1.dda83cc763289p-1,   0x1.b135ccp-2, INEXACT)
T(RN,  0x1.3889f42dfbb74p+874,   -0x1.627bfe1776b3cp-1,  -0x1.396014p-5, INEXACT)
T(RN,  0x1.8bcfa5e751254p+874,    0x1.813bb146690a7p-2,  -0x1.2b14ccp-3, INEXACT)
T(RN,  0x1.803e4719dc999p+874,   -0x1.5f55933dfb115p-1,  -0x1.3896acp-2, INEXACT)
T(RN,  0x1.ea014d57cc237p+875,   -0x1.adc2e0ea1a613p-1,   0x1.76e08ap-3, INEXACT)
T(RN,  0x1.9d70d2b2c5769p+875,   -0x1.5a24a8e875a86p-2,  -0x1.a2f082p-4, INEXACT)
T(RN,  0x1.1f8d39d8538dbp+875,   -0x1.e69dc01a9bbf1p-2,   0x1.9164fap-4, INEXACT)
T(RN,  0x1.cba7b7966b0a9p+875,    -0x1.42bc73b6a7d4p-1,   0x1.b94226p-3, INEXACT)
T(RN,  0x1.ba8ed45a5934cp+875,    0x1.ed3271b2b0a55p-1, -0x1.231f86p-11, INEXACT)
T(RN,  0x1.106983b5a64cdp+875,    0x1.e9ff8915404dfp-1,   0x1.034e08p-2, INEXACT)
T(RN,  0x1.ae8391b3d0b2cp+875,   -0x1.ac5602c79df6ap-1,  -0x1.963242p-2, INEXACT)
T(RN,  0x1.3672b0b56b3b5p+875,   -0x1.576eae03c5b01p-3,  -0x1.e3ad0ap-4, INEXACT)
T(RN,  0x1.407ea98620b92p+875,    0x1.7e5cf1f65a922p-1,  -0x1.5a6034p-4, INEXACT)
T(RN,  0x1.f562d068bd6e5p+875,    0x1.fd44351a17f4bp-2,  -0x1.71724cp-2, INEXACT)
T(RN,  0x1.ed189d5eba302p+876,    0x1.5202ca0cab42cp-1,  -0x1.9f11a8p-3, INEXACT)
T(RN,   0x1.95df413b343ep+876,     0x1.f60158c52b7cp-2,  -0x1.35a658p-9, INEXACT)
T(RN,  0x1.23db35562ffb6p+876,    0x1.d13969595bb3ap-2,    0x1.d8292p-2, INEXACT)
T(RN,  0x1.73cb8323c5f91p+876,    0x1.fa7f69a1d6ee3p-2,  -0x1.2432ccp-4, INEXACT)
T(RN,  0x1.838bf8ca0b51ap+876,   -0x1.6cbcd0074f736p-3,   -0x1.328d6p-3, INEXACT)
T(RN,  0x1.d5529f1746135p+876,    0x1.0b968713a8aedp-1,    0x1.efb0cp-6, INEXACT)
T(RN,  0x1.89adeb4e49631p+876,    0x1.edb2c9ec909c9p-2,  -0x1.24df26p-7, INEXACT)
T(RN,  0x1.85b8a6761a52ap+876,   -0x1.a9d31a9f24f16p-4,   0x1.7b8ebcp-2, INEXACT)
T(RN,  0x1.9ed655c7a071ap+876,   -0x1.77d5035360a46p-3,    -0x1.9772p-2, INEXACT)
T(RN,  0x1.d30bdc8c21a66p+876,   -0x1.a7035be8db9e2p-1,   0x1.43283ap-2, INEXACT)
T(RN,  0x1.0f96930eac964p+877,     0x1.fe6e0aacbd23p-1,  -0x1.8fbf68p-2, INEXACT)
T(RN,  0x1.936fd308d2f76p+877,    0x1.48fdfa8aa7168p-1,   0x1.0b384ap-2, INEXACT)
T(RN,  0x1.3b2ae7f431b5fp+877,    0x1.e270db71ec268p-1,  -0x1.211d1ep-2, INEXACT)
T(RN,  0x1.284a9984d6e3fp+877,    0x1.e44eff902dfcdp-1,  -0x1.435664p-5, INEXACT)
T(RN,  0x1.ada95238e9decp+877,    0x1.26f7ff0650e29p-2,   0x1.30ecb8p-3, INEXACT)
T(RN,  0x1.3b804163a72b1p+877,   -0x1.687bff7c2df24p-5,   0x1.cdf83ap-2, INEXACT)
T(RN,  0x1.0ca4473a05501p+877,   -0x1.386d1f533408fp-4,  -0x1.61aa2cp-2, INEXACT)
T(RN,  0x1.19a82f420fb62p+877,   -0x1.2eec7c3c947b8p-2,  -0x1.98b11cp-2, INEXACT)
T(RN,   0x1.ba94129376f9p+877,   -0x1.03b8b9abee083p-1,   -0x1.87813p-2, INEXACT)
T(RN,  0x1.68acd620352e6p+877,    0x1.ab65eef5029f8p-1,  -0x1.3e6e7ap-3, INEXACT)
T(RN,  0x1.58961a86da9ebp+878,    0x1.80e4c7c8a9166p-2,   0x1.3c382ep-2, INEXACT)
T(RN,  0x1.e5c2d67da7cecp+878,    0x1.65086f7cc81b3p-2,   0x1.527fb6p-2, INEXACT)
T(RN,  0x1.f0470a16171c6p+878,    0x1.eca5a2f4b0112p-7,   -0x1.bdd8dp-5, INEXACT)
T(RN,  0x1.7bed929a94193p+878,   -0x1.d2b890710ec32p-1,   0x1.ba0c16p-3, INEXACT)
T(RN,  0x1.8f1d756c30d73p+878,    0x1.9ee2c0273a7bap-7,   -0x1.46b92p-2, INEXACT)
T(RN,   0x1.73360f883bcep+878,   -0x1.d438933469d3fp-3,   0x1.265892p-8, INEXACT)
T(RN,  0x1.2e085d7c341f5p+878,   -0x1.f3b730fbae925p-1,  -0x1.5f781cp-3, INEXACT)
T(RN,  0x1.abbf4308ab726p+878,    0x1.fb2e7a976075cp-1,   0x1.d973e6p-4, INEXACT)
T(RN,  0x1.886e419c5ae35p+878,   -0x1.be0f9ccc4069ep-1,  -0x1.acf68ap-2, INEXACT)
T(RN,  0x1.878200b9ab599p+878,    0x1.88ed29e9297a5p-2,  -0x1.a1dd14p-2, INEXACT)
T(RN,  0x1.ee3d27bf43abfp+879,    0x1.43ed88be890fap-1,   0x1.c081c8p-3, INEXACT)
T(RN,  0x1.9f22340791208p+879,    0x1.49bb5fc272bd8p-3,  -0x1.6c2d84p-2, INEXACT)
T(RN,  0x1.48d8a858bd0f2p+879,   -0x1.291389dc66855p-3,   0x1.43fb72p-3, INEXACT)
T(RN,  0x1.59e03045bcc9cp+879,   -0x1.2e4e19c12e2fdp-1,   0x1.8a8bd6p-2, INEXACT)
T(RN,  0x1.9056f25778b62p+879,    0x1.f6a83ee5692fep-2,   0x1.b6b2ecp-3, INEXACT)
T(RN,  0x1.dbf09a2c858f8p+879,   -0x1.dc107f483c956p-1,  -0x1.d6329ap-2, INEXACT)
T(RN,  0x1.0a91adcb12d63p+879,     0x1.ff1c8c2736e2p-1,  -0x1.86941ep-6, INEXACT)
T(RN,  0x1.0099cadec9cddp+879,    0x1.70b07e7ba9731p-1,   -0x1.3ec2ep-4, INEXACT)
T(RN,  0x1.728bd5edfef35p+879,    0x1.28cdea0cbc9bep-2,  -0x1.b04184p-2, INEXACT)
T(RN,  0x1.846e8e1155e4cp+879,    0x1.fecc11cf1c6bdp-1,   0x1.6740e6p-2, INEXACT)
T(RN,  0x1.f39461443e4e4p+880,    0x1.d01ee88a041a6p-1,   0x1.8cb7d6p-5, INEXACT)
T(RN,  0x1.5008d59e16adbp+880,   -0x1.4bb997b65e0cap-1,  -0x1.b09a22p-4, INEXACT)
T(RN,  0x1.5a805eeec35e8p+880,    0x1.2e5016a96776ep-1,  -0x1.17b18ap-3, INEXACT)
T(RN,  0x1.a67aafd43d75fp+880,   -0x1.0f27e136f1589p-1,   0x1.09e59ap-3, INEXACT)
T(RN,  0x1.a024b746438e2p+880,    0x1.fdafc34a2ed7dp-1,   -0x1.82d8ep-5, INEXACT)
T(RN,  0x1.97b44d1370f9ep+880,    0x1.fd58e1462361ap-1,  -0x1.de7bb2p-3, INEXACT)
T(RN,  0x1.731b4eaeb1d62p+880,   -0x1.b60719eecadc5p-1,   0x1.3af302p-4, INEXACT)
T(RN,   0x1.514eb95a16d9p+880,   -0x1.572e72dff6ecdp-4,   0x1.bca3bep-3, INEXACT)
T(RN,  0x1.f18eaa52972b6p+880,   -0x1.caf917b0c483fp-1,   0x1.a5938cp-6, INEXACT)
T(RN,  0x1.8505b0e3f52c2p+880,    0x1.ffd56bfec9c41p-1,   0x1.304a0cp-2, INEXACT)
T(RN,  0x1.b7b980765b066p+881,    0x1.1256cd69b2dabp-1,   0x1.06fa82p-3, INEXACT)
T(RN,  0x1.04ca530d66ad5p+881,    0x1.44da318d7191dp-3,   0x1.32db08p-6, INEXACT)
T(RN,  0x1.8cd874db4ecf1p+881,    0x1.d94e68d4a4b3ap-1,  -0x1.edaca2p-3, INEXACT)
T(RN,  0x1.6c84cc65881dep+881,    0x1.ceb6c2671a423p-1,   0x1.83d2bcp-3, INEXACT)
T(RN,  0x1.bb0d0ab8e20dbp+881,   -0x1.d50400b617a3cp-1,  -0x1.453bcap-2, INEXACT)
T(RN,  0x1.6ff44f49eb8c5p+881,   -0x1.ef4947fd5d223p-2,  -0x1.e5b634p-3, INEXACT)
T(RN,  0x1.52f1264cd64c6p+881,   -0x1.244eca5ff61aep-1,   0x1.ca44c4p-3, INEXACT)
T(RN,   0x1.44ea17f740bep+881,   -0x1.ff85e0c68621cp-1,   0x1.6a0072p-5, INEXACT)
T(RN,  0x1.2b46319b11fe8p+881,    0x1.cc1ad3d88f9b7p-1,   0x1.98ddc4p-2, INEXACT)
T(RN,  0x1.8a000b1bf7592p+881,    -0x1.75251b58274dp-1,  -0x1.29d952p-2, INEXACT)
T(RN,  0x1.964a6d6192739p+882,   -0x1.c4e7e9b52cdb8p-1,  -0x1.a21644p-2, INEXACT)
T(RN,  0x1.a129ee749afdap+882,   -0x1.fef42396ce0a2p-1,   0x1.da2076p-3, INEXACT)
T(RN,  0x1.980e66a18c711p+882,    0x1.f64627b0a2ec5p-1,   0x1.fb6818p-6, INEXACT)
T(RN,  0x1.8f6153220040cp+882,   -0x1.b0b97719db923p-1,    0x1.fe52ep-2, INEXACT)
T(RN,  0x1.db85befa9a29fp+882,   -0x1.392c3f7d917d1p-3,  -0x1.96359ap-2, INEXACT)
T(RN,  0x1.a1fa9ab10b3d4p+882,    0x1.938efd24337cdp-1,  -0x1.d7301cp-2, INEXACT)
T(RN,  0x1.1e4876e5a8153p+882,   -0x1.deb46dc1e170fp-1,  -0x1.cbd54cp-4, INEXACT)
T(RN,  0x1.7ea8ee0a3db65p+882,    0x1.c408b5b2bda7ap-1,  -0x1.29f974p-2, INEXACT)
T(RN,  0x1.f1676e8736f8bp+882,    0x1.f98995fa9b061p-1,   0x1.381d06p-2, INEXACT)
T(RN,  0x1.74cec1ce3f83bp+882,    0x1.ad4fe4612d591p-2,  -0x1.523b6cp-2, INEXACT)
T(RN,  0x1.028378fb4a7b1p+883,    0x1.20ccb60c663bep-3,  -0x1.0382d4p-2, INEXACT)
T(RN,  0x1.0cb87ea6f92a7p+883,    0x1.f5c2af3f15f7fp-1,  -0x1.1f2f46p-2, INEXACT)
T(RN,  0x1.4923263e22f45p+883,     0x1.fb4a571a34acp-1,    0x1.c1918p-3, INEXACT)
T(RN,   0x1.7544e92b498fp+883,   -0x1.baf183aaff7a8p-1,   0x1.76a552p-2, INEXACT)
T(RN,  0x1.50e6a4310532ap+883,   -0x1.fe3cbba24d62bp-1,   0x1.2d3246p-2, INEXACT)
T(RN,  0x1.3f257b7ac5b44p+883,   -0x1.93a93a73fa487p-1,    0x1.92f93p-2, INEXACT)
T(RN,  0x1.6ba8c030d79afp+883,    0x1.d1efc6989ddd3p-2,   -0x1.61495p-4, INEXACT)
T(RN,  0x1.49f2e1ff20027p+883,   -0x1.32e5e7387737dp-2,   0x1.246492p-6, INEXACT)
T(RN,  0x1.bdc7860e60837p+883,   -0x1.79b5c2579bcadp-1,   0x1.d8394ep-8, INEXACT)
T(RN,  0x1.98c5725dcc553p+883,    0x1.6f2e66e54bc84p-3,   0x1.13846cp-2, INEXACT)
T(RN,  0x1.82d4894e2baeep+884,    0x1.ac9f9d63a007fp-1,   0x1.8ea1f4p-2, INEXACT)
T(RN,  0x1.c84aaf5a7e8e6p+884,    0x1.01d65aad33288p-1,   0x1.4f53ecp-5, INEXACT)
T(RN,  0x1.e015a7de0bffap+884,   -0x1.05a8a35cc1c84p-1,  -0x1.67b288p-2, INEXACT)
T(RN,  0x1.3325f2a08c9dap+884,    0x1.f73f59def9d25p-1,  -0x1.da6872p-2, INEXACT)
T(RN,  0x1.93a6b16e9abf1p+884,   -0x1.ffd9c42ad78a8p-1,  -0x1.af0cecp-3, INEXACT)
T(RN,  0x1.4e0b0875905b8p+884,    0x1.ba72f28ec1aecp-1,  -0x1.dcf172p-2, INEXACT)
T(RN,  0x1.971942f0a8c76p+884,   -0x1.c9f2cb54d6608p-2,  -0x1.cfa43ap-4, INEXACT)
T(RN,   0x1.aea3b534df48p+884,    0x1.2ce84a4b50ddbp-1,   0x1.d6c63ap-3, INEXACT)
T(RN,    0x1.74c773644dcp+884,   -0x1.f3a63c0b06847p-1,  -0x1.988b42p-3, INEXACT)
T(RN,  0x1.22bff64944c47p+884,    0x1.f643c1d0035c2p-1,  -0x1.0c5b4ap-2, INEXACT)
T(RN,  0x1.cccf6445c1f84p+885,    0x1.51839568cb005p-2,  -0x1.fbf76cp-2, INEXACT)
T(RN,  0x1.919e6551f50d4p+885,    0x1.d0a60dad0414fp-1,   0x1.a012aap-2, INEXACT)
T(RN,  0x1.d96d6f73cc286p+885,    0x1.5be17d57e92abp-2,    0x1.051d3p-4, INEXACT)
T(RN,  0x1.11eb2366c99eap+885,    0x1.2b49d2b660a2ap-1,   0x1.3b846ep-2, INEXACT)
T(RN,  0x1.97f661834fee2p+885,   -0x1.a4eb84a09de58p-1,   0x1.ad6926p-2, INEXACT)
T(RN,  0x1.6625ef736be52p+885,   -0x1.890607618b7f8p-1,    0x1.37498p-2, INEXACT)
T(RN,  0x1.6abbc14a7e143p+885,    0x1.f47daa2fe9bbap-1,   0x1.b375bap-6, INEXACT)
T(RN,   0x1.7ff326779a61p+885,    0x1.f4c720177b1fdp-2,   0x1.4be72ep-4, INEXACT)
T(RN,  0x1.a4e0774d589bap+885,    0x1.b715b5315355dp-1,   0x1.40ad02p-4, INEXACT)
T(RN,  0x1.67948e49fb64bp+885,    0x1.ffca898f9fe88p-1,  -0x1.201f5ep-2, INEXACT)
T(RN,  0x1.74595dfca1593p+886,   -0x1.ea3dbf69f0381p-1,  -0x1.2b8b88p-2, INEXACT)
T(RN,  0x1.e63b0983b8bb1p+886,   -0x1.0f0a58b74db1dp-1,   0x1.7d93a6p-2, INEXACT)
T(RN,  0x1.c500f5e7baa78p+886,    0x1.95795efc150c9p-3,   0x1.c3351cp-2, INEXACT)
T(RN,  0x1.f96e18e7afa58p+886,    0x1.9df91a55f7435p-3,  -0x1.04a8a8p-2, INEXACT)
T(RN,  0x1.798806fb2e762p+886,   -0x1.3151fe7cfd148p-2,   0x1.a872c6p-2, INEXACT)
T(RN,  0x1.2f88f79cd1052p+886,   -0x1.e9310f7310bd2p-1,   0x1.b0ae9ap-2, INEXACT)
T(RN,  0x1.521dbf6f0c394p+886,   -0x1.8f861767c7575p-1,   0x1.b9a072p-2, INEXACT)
T(RN,  0x1.0b8550a2d8a67p+886,   -0x1.ea5825db56b9ep-1,   0x1.b39716p-3, INEXACT)
T(RN,   0x1.7e99fffbea71p+886,    0x1.617316a627386p-3,  -0x1.07fc9cp-2, INEXACT)
T(RN,  0x1.1d16d03e5c40ep+886,    0x1.ac7651aba2acbp-1,   0x1.02bf54p-2, INEXACT)
T(RN,  0x1.1888e1f0b110cp+887,   -0x1.09b837ae22e16p-2,   0x1.bcc13cp-3, INEXACT)
T(RN,  0x1.095343bf1e6ebp+887,   -0x1.a291c6111f288p-1,  -0x1.8281bep-2, INEXACT)
T(RN,   0x1.545ccee8a951p+887,     -0x1.e4cc2e3c7cdp-1,   0x1.3aaf08p-2, INEXACT)
T(RN,  0x1.8c08efe3ea726p+887,   -0x1.ed0c99152c1fcp-1,   0x1.9d23e6p-3, INEXACT)
T(RN,  0x1.320f1cca17719p+887,    0x1.4269704ff51c7p-3,   0x1.4e26aep-2, INEXACT)
T(RN,  0x1.0e587e42fabefp+887,   -0x1.d6eeae8009fedp-3,  -0x1.89dcacp-8, INEXACT)
T(RN,  0x1.fd0fc4e4bb599p+887,    0x1.2c74e33f26298p-3,  -0x1.e5f396p-6, INEXACT)
T(RN,  0x1.ef1af38e513eep+887,   -0x1.72a0565b06625p-1,   0x1.3bbc9cp-2, INEXACT)
T(RN,  0x1.8311c6ae66478p+887,   -0x1.6b5f19aed6303p-1,   0x1.2b55a6p-3, INEXACT)
T(RN,  0x1.7d86d1966b852p+887,    0x1.cd50b317d5ed4p-1,  -0x1.e501ecp-4, INEXACT)
T(RN,  0x1.87ae8649a7a7ep+888,   -0x1.3b9ec40b597a1p-1,  -0x1.5f4428p-2, INEXACT)
T(RN,  0x1.59b896ec77478p+888,    0x1.ffcb798674f1dp-1,   0x1.3b3588p-2, INEXACT)
T(RN,  0x1.6821f477f509bp+888,    0x1.951f19c29ca4bp-1,  -0x1.90ec8cp-3, INEXACT)
T(RN,  0x1.b91cefec8884fp+888,    0x1.ff2a75cecac5cp-4,  -0x1.a53298p-6, INEXACT)
T(RN,  0x1.2ff2df316c66cp+888,   -0x1.a2fb77a38d12dp-3,   0x1.3f2b28p-4, INEXACT)
T(RN,  0x1.7c2fbaff92e9fp+888,   -0x1.9d302f2fff851p-2,    0x1.88403p-2, INEXACT)
T(RN,  0x1.8746582fae1d1p+888,    0x1.9536688a501cbp-2,   0x1.c9cd4ep-2, INEXACT)
T(RN,  0x1.a0debd7310a48p+888,   -0x1.96456615ae3f6p-2,   0x1.7138d2p-2, INEXACT)
T(RN,  0x1.4ebab11ec684ap+888,    -0x1.3ad57576da9fp-1,  -0x1.0520ccp-2, INEXACT)
T(RN,  0x1.a57c8d0663974p+888,    0x1.375f41b984d7cp-1,  -0x1.c5b508p-3, INEXACT)
T(RN,  0x1.70abddbe6f5a2p+889,   -0x1.8f72356425f4ap-5,   0x1.903da4p-2, INEXACT)
T(RN,   0x1.67ea6beba42fp+889,    0x1.68954efea147cp-1,  -0x1.25eee8p-6, INEXACT)
T(RN,  0x1.7a9a0779ebf9dp+889,    0x1.a679b1d73661fp-2,    0x1.4bfedp-3, INEXACT)
T(RN,  0x1.77797e54932b4p+889,    0x1.fd8c393bdb5fcp-1,  -0x1.4212e6p-2, INEXACT)
T(RN,  0x1.216f9ea6a917ep+889,   -0x1.f60a2c593667cp-1,   0x1.f45a7ep-3, INEXACT)
T(RN,  0x1.8760402abbb1cp+889,   -0x1.d4a41476bc61cp-1,   0x1.24e566p-3, INEXACT)
T(RN,  0x1.45fa6adcd6fcap+889,    0x1.fed253d60931dp-1,   0x1.039dcep-2, INEXACT)
T(RN,  0x1.050a9671ac75bp+889,    0x1.8d64e2417d2abp-1,   0x1.cd25dcp-3, INEXACT)
T(RN,   0x1.089fc52afbfdp+889,    0x1.f113cc9091015p-1,  -0x1.58d1b6p-3, INEXACT)
T(RN,  0x1.4a1d17fb1035fp+889,   -0x1.a26860846fdc2p-1,  -0x1.15d07ap-2, INEXACT)
T(RN,  0x1.918139fb8d317p+890,   -0x1.e00ea241388ecp-1,   0x1.680f62p-3, INEXACT)
T(RN,  0x1.5e169f860f26ep+890,    0x1.f0c1cf808a18cp-1,  -0x1.23ee4ap-4, INEXACT)
T(RN,  0x1.2e3f4219b612bp+890,    0x1.fe24347e9a221p-1,    0x1.9315ap-2, INEXACT)
T(RN,  0x1.c037982990f4ep+890,   -0x1.2140645ddce52p-4,   0x1.6c35dap-5, INEXACT)
T(RN,  0x1.ab7ec938c8d92p+890,   -0x1.85520f47f4845p-1,  -0x1.4c3262p-8, INEXACT)
T(RN,  0x1.feb21e4856772p+890,    0x1.efcbc02d2dc17p-1,  -0x1.6b0684p-4, INEXACT)
T(RN,  0x1.3d7246987d076p+890,   -0x1.7be5545411a93p-2,   0x1.a53006p-3, INEXACT)
T(RN,  0x1.ca6a290cd55fap+890,   -0x1.f8cf68d53c932p-1,   0x1.7deb4ap-4, INEXACT)
T(RN,  0x1.46a85f1732a34p+890,    0x1.65162bffae843p-4,   0x1.8c7a98p-5, INEXACT)
T(RN,   0x1.a375cc22673fp+890,   -0x1.3207f83818981p-1,   -0x1.18d42p-2, INEXACT)
T(RN,  0x1.6174b44c33b85p+891,    0x1.6d59c8202fbfap-1,   0x1.d0f1c8p-4, INEXACT)
T(RN,  0x1.4d96b4fdff76fp+891,   -0x1.a8284c06dd8afp-4,   0x1.d049d8p-2, INEXACT)
T(RN,  0x1.c0b4962fcdaf8p+891,    0x1.f2568d30214ebp-1,   0x1.76dee4p-2, INEXACT)
T(RN,  0x1.baef67dfb8655p+891,    0x1.5a2d9afb626a9p-1,   0x1.94de38p-4, INEXACT)
T(RN,  0x1.d5ec1b4183cd6p+891,   -0x1.fef8ba688c6c6p-1,  -0x1.f8a21cp-3, INEXACT)
T(RN,  0x1.e80a91e3e1628p+891,    0x1.2b0946320e627p-2,   0x1.25eeb8p-4, INEXACT)
T(RN,  0x1.aa3b9438a81c7p+891,   -0x1.fd9633468aa63p-1,  -0x1.a2e906p-2, INEXACT)
T(RN,  0x1.17ccbdc7aae76p+891,   -0x1.6533168d49e12p-4,  -0x1.3111cap-3, INEXACT)
T(RN,  0x1.c7430b136687ep+891,   -0x1.559eae917a8c9p-1,    0x1.812f5p-3, INEXACT)
T(RN,  0x1.40731a43f38cfp+891,    -0x1.1447802af5b6p-1,    0x1.6b915p-2, INEXACT)
T(RN,  0x1.fe56def91e184p+892,   -0x1.1d237c6e72f59p-1,   0x1.7ca626p-2, INEXACT)
T(RN,  0x1.d5cb5e3b3160ap+892,   -0x1.ff6f69f350e8fp-1,   0x1.2e851ep-2, INEXACT)
T(RN,  0x1.8256d30c040c8p+892,    0x1.f2fa423e204ecp-1,   0x1.426618p-4, INEXACT)
T(RN,  0x1.899aaaf87e82ep+892,    0x1.084d13868b069p-5,  -0x1.575c22p-2, INEXACT)
T(RN,  0x1.959bc0fd4b1b2p+892,   -0x1.05da75693f6c2p-2,    0x1.ed0f4p-2, INEXACT)
T(RN,  0x1.d378b5f9aab9cp+892,    0x1.a19190674b60fp-1,   0x1.a5d0ccp-4, INEXACT)
T(RN,   0x1.fafc677c61d2p+892,   -0x1.655e6dbea1a57p-2,   0x1.41fb3ap-3, INEXACT)
T(RN,  0x1.a3ca644e5735ap+892,   -0x1.4ae2667c6fda9p-1,  -0x1.277da8p-4, INEXACT)
T(RN,  0x1.143e2a102c053p+892,    0x1.1fd71302ebabbp-1,  -0x1.1d9b72p-3, INEXACT)
T(RN,  0x1.3786c19efa332p+892,    0x1.719c569b657dfp-1,  -0x1.6efad8p-2, INEXACT)
T(RN,  0x1.0ffe3fb454013p+893,    0x1.803b3a86ef19cp-1,   0x1.cc8c24p-2, INEXACT)
T(RN,  0x1.2b16b0c691ca8p+893,   -0x1.f504620507952p-1,   0x1.f34c12p-3, INEXACT)
T(RN,  0x1.5ac64cbf67be8p+893,    0x1.a6bc0eae682e2p-1,  -0x1.3e9822p-2, INEXACT)
T(RN,   0x1.9644eb736d17p+893,   -0x1.f2f0fce5ce6b6p-1,  -0x1.623c88p-2, INEXACT)
T(RN,  0x1.37897a046d1d9p+893,    0x1.c3bcfce253de1p-1,   -0x1.8c5bdp-3, INEXACT)
T(RN,  0x1.c2964c0fcfd6dp+893,   -0x1.977d015a64b04p-1,  -0x1.6a9652p-8, INEXACT)
T(RN,  0x1.49cb4fcf8a0e7p+893,    0x1.3fb8e45b93466p-1,   0x1.8cbd2ep-4, INEXACT)
T(RN,   0x1.9768c9f380e3p+893,   -0x1.3ad2b33ebcef2p-2,  -0x1.3005c6p-2, INEXACT)
T(RN,  0x1.14b84f825f436p+893,   -0x1.86159003627bap-3,  -0x1.8c2d12p-6, INEXACT)
T(RN,  0x1.8c1346b1ccbacp+893,    0x1.92850632eb091p-1,   0x1.52d9c8p-4, INEXACT)
T(RN,  0x1.d8ee78bfb3606p+894,    0x1.90df2e7216fcfp-1,   0x1.f8aaecp-3, INEXACT)
T(RN,  0x1.8101ebdca0e3ap+894,   -0x1.1ffbb2babd935p-2,   0x1.744e24p-3, INEXACT)
T(RN,  0x1.18b3e8c777a92p+894,    0x1.76f1cec6b2bb1p-2,  -0x1.9a07ecp-2, INEXACT)
T(RN,  0x1.129cc6ddc3f88p+894,   -0x1.2d5cde1477d63p-1,  -0x1.3a9446p-3, INEXACT)
T(RN,  0x1.285dc13db6307p+894,     0x1.7420b83a0b22p-1,  -0x1.981ef2p-2, INEXACT)
T(RN,  0x1.977651838e526p+894,    0x1.ac1aeb212bb9ep-1,  -0x1.754c44p-2, INEXACT)
T(RN,  0x1.8d1901b05bcbcp+894,   -0x1.c0c3e3294d6d4p-3,   0x1.2d6444p-2, INEXACT)
T(RN,  0x1.fb166d4220d0dp+894,   -0x1.fe372b1ae2b6fp-1,   0x1.1df2e2p-2, INEXACT)
T(RN,  0x1.5089f7fdced6cp+894,    -0x1.9f31d095237dp-1,   0x1.6c5b3ap-4, INEXACT)
T(RN,  0x1.79eaa6e58c48ap+894,    0x1.d1002c91700a8p-1,    0x1.e73c9p-2, INEXACT)
T(RN,  0x1.7b92844b356cfp+895,   -0x1.a9c90cf0c5a88p-1,   0x1.c2df0ep-2, INEXACT)
T(RN,   0x1.3412b4d58fc5p+895,   -0x1.c7acdcba8dfaep-1,   0x1.da9c14p-2, INEXACT)
T(RN,  0x1.4e15ce5893185p+895,   -0x1.5fb76bea2467ep-4,   0x1.c3d2f4p-5, INEXACT)
T(RN,  0x1.5a80ad8550c32p+895,   -0x1.c15b0cae6f905p-1,   0x1.663ac4p-6, INEXACT)
T(RN,   0x1.baa22df10877p+895,    0x1.27c34aeb72cf4p-1,  -0x1.dc6b4cp-2, INEXACT)
T(RN,  0x1.07005c805b331p+895,    0x1.8173da320c7bap-2,  -0x1.5fb68cp-6, INEXACT)
T(RN,  0x1.bcdaffc4bc6abp+895,   -0x1.fff69e450a1a3p-1,   0x1.9b829ap-2, INEXACT)
T(RN,  0x1.edb42f218f34ep+895,   -0x1.43863ecb489ffp-2,   0x1.8a96d8p-2, INEXACT)
T(RN,  0x1.7d1ef75ec3e49p+895,    -0x1.d5d0a7901d82p-4,  -0x1.6131d4p-2, INEXACT)
T(RN,  0x1.e457dc402e7dfp+895,   -0x1.de84757f6d04ep-1,   0x1.97341cp-2, INEXACT)
T(RN,  0x1.d5dfe67c99724p+896,   -0x1.f7c2b870b7013p-1,  -0x1.b34626p-5, INEXACT)
T(RN,  0x1.c68c7621f0826p+896,    0x1.f83c44f207d78p-3,   0x1.075372p-2, INEXACT)
T(RN,  0x1.6b76dfa300a03p+896,    0x1.05d622ea79396p-3,    0x1.c48bbp-3, INEXACT)
T(RN,  0x1.7ed3681931629p+896,   -0x1.79e033cca9fcdp-2,   0x1.b5867cp-4, INEXACT)
T(RN,   0x1.d6965ebd51afp+896,    0x1.2d80508f22e2fp-1,   0x1.081fecp-3, INEXACT)
T(RN,  0x1.942d19471f439p+896,   -0x1.e3121b872bb9cp-1,   0x1.5dd20ap-4, INEXACT)
T(RN,  0x1.c79488b631c32p+896,    0x1.ac8fb3db56181p-1,    0x1.b62dfp-4, INEXACT)
T(RN,  0x1.276e33a41577ep+896,   -0x1.3f8ae99452be3p-5,   0x1.67f94ep-4, INEXACT)
T(RN,  0x1.258ff9f4ef4d3p+896,    -0x1.2f50e2e75556p-1,   0x1.b6ae2ap-2, INEXACT)
T(RN,  0x1.7b8db859143bep+896,    0x1.2f35d0caf95c3p-1,  -0x1.1b7b64p-2, INEXACT)
T(RN,  0x1.f912ba41d73b1p+897,   -0x1.2bd70b23a1527p-4,    0x1.04a6cp-4, INEXACT)
T(RN,  0x1.09e2e911dcc1ap+897,    0x1.177f75cda2171p-3,   0x1.f252a8p-3, INEXACT)
T(RN,    0x1.2cab225e584p+897,   -0x1.99f371fad6918p-1,   -0x1.d0b23p-2, INEXACT)
T(RN,  0x1.1803be6df201ep+897,    0x1.6a7c02c836e48p-1,  -0x1.7c67b4p-3, INEXACT)
T(RN,  0x1.e2ebe3fbda196p+897,   -0x1.f9f0fd939244ep-2,   0x1.097408p-3, INEXACT)
T(RN,  0x1.7a534eca2e024p+897,    0x1.ef4b7a21e1e16p-1,   0x1.0bbf98p-4, INEXACT)
T(RN,  0x1.53a845ac39a5cp+897,   -0x1.22b8e55fe458ap-1,   0x1.28e6a6p-2, INEXACT)
T(RN,  0x1.3d66899051ed9p+897,   -0x1.14dbe7fef713dp-7,  -0x1.6f35e4p-2, INEXACT)
T(RN,    0x1.c7a115fb3a3p+897,    0x1.3174dbab6bdb4p-1,   0x1.984264p-2, INEXACT)
T(RN,  0x1.5f9e929c27626p+897,   -0x1.ed7a0386abd1fp-1,  -0x1.4a3368p-4, INEXACT)
T(RN,   0x1.b70a558da092p+898,    0x1.32bea1bcf3646p-1,  -0x1.8b9c32p-3, INEXACT)
T(RN,  0x1.16a6f0f146e82p+898,   -0x1.e772d92836227p-1,   0x1.fe7792p-2, INEXACT)
T(RN,  0x1.6b4dd0ea1c661p+898,      0x1.87e4be437e4p-3,   -0x1.b9453p-6, INEXACT)
T(RN,  0x1.f6d256f322b9ep+898,    0x1.f28b42e619eebp-6,  -0x1.f959aep-4, INEXACT)
T(RN,  0x1.322d44436f9bfp+898,    0x1.3d9a6526f068ap-1,  -0x1.32bd82p-2, INEXACT)
T(RN,  0x1.ca58a7ff6b282p+898,   -0x1.aeb6714d37738p-1,   0x1.5b4be8p-2, INEXACT)
T(RN,  0x1.c940a26049b84p+898,    0x1.b462e73d9b77dp-1,    0x1.2c4d4p-5, INEXACT)
T(RN,  0x1.f5ff14f5ba7fcp+898,   -0x1.163094745d236p-1,  -0x1.1a2a36p-2, INEXACT)
T(RN,  0x1.023d8426f4e21p+898,   -0x1.eb9453a41c73ap-1,  -0x1.2c7eb6p-2, INEXACT)
T(RN,  0x1.1b21bf9fb7d31p+898,    0x1.95b105ef5c22ap-1,  -0x1.ab955ap-2, INEXACT)
T(RN,  0x1.92ca3b728e36ep+899,   -0x1.898ed7a1632eap-6,   0x1.db6784p-7, INEXACT)
T(RN,   0x1.c1c505b82254p+899,   -0x1.2679fa6a394d5p-1,   0x1.4f5fbep-3, INEXACT)
T(RN,   0x1.9c0bcd3867dbp+899,    0x1.8db2c0b13f4c2p-1,  -0x1.ecb72ap-3, INEXACT)
T(RN,  0x1.8c3986283ed04p+899,    0x1.b85c1ac24f8fcp-1,  -0x1.0ec98ep-2, INEXACT)
T(RN,  0x1.a86f3bf8b1b72p+899,   -0x1.2184fc7d85d29p-2,   0x1.db73fap-3, INEXACT)
T(RN,  0x1.03e9ebd3a0b9bp+899,    0x1.7a45a44dceb58p-1,    0x1.fe6eap-2, INEXACT)
T(RN,  0x1.fdb42c2c59b6cp+899,    0x1.00e46bc8cbf84p-1,   0x1.e20b0ep-2, INEXACT)
T(RN,  0x1.1a765a3ca1ca1p+899,   -0x1.78883d40ffbbdp-3,  -0x1.f14814p-2, INEXACT)
T(RN,  0x1.9c4edcdd418e4p+899,   -0x1.69026fbc9b2cep-7,  -0x1.90f6c8p-7, INEXACT)
T(RN,  0x1.bfb07a270a496p+899,   -0x1.f538e5c543509p-1,   0x1.09edd4p-4, INEXACT)
T(RN,  0x1.033dc904da08fp+900,    0x1.c5413175db39ap-1,   0x1.0dfa52p-2, INEXACT)
T(RN,  0x1.d6a4e47c38711p+900,   -0x1.988390eebb8b5p-3,   -0x1.1b5f8p-2, INEXACT)
T(RN,  0x1.4dc8bbcc28da2p+900,    0x1.a111234a93d44p-1,  -0x1.5ed63ap-2, INEXACT)
T(RN,  0x1.95a358f802abdp+900,   -0x1.f74ba3d0f71d1p-1,   0x1.0bde48p-4, INEXACT)
T(RN,  0x1.c619f855c4daap+900,   -0x1.55c9933227029p-1,  -0x1.22b3aap-3, INEXACT)
T(RN,  0x1.0d9054fef2ed5p+900,    0x1.b0455070bf548p-4,   0x1.bb7154p-2, INEXACT)
T(RN,  0x1.a5c5e6fc98241p+900,    0x1.edfac050d76b2p-1,  -0x1.b08db2p-2, INEXACT)
T(RN,  0x1.41326a135e3ccp+900,   -0x1.1ef3895361d4bp-3,    0x1.68686p-2, INEXACT)
T(RN,  0x1.10990b4fda71fp+900,    0x1.817c888d926f5p-2,   0x1.43e348p-4, INEXACT)
T(RN,  0x1.df79edb8fc857p+900,    0x1.d322b8c6e21a6p-2,   0x1.59418cp-4, INEXACT)
T(RN,  0x1.418af39106be2p+901,    0x1.6bd62910264ccp-1,  -0x1.cafdeep-5, INEXACT)
T(RN,   0x1.c63aad3e726dp+901,    0x1.f9fae8cbdf61fp-1,  -0x1.09df16p-2, INEXACT)
T(RN,  0x1.712f41a4d16f8p+901,   -0x1.157ad79e309bbp-5,   0x1.a8ac58p-2, INEXACT)
T(RN,  0x1.1b7bde7997cfep+901,    0x1.8ec024fbb6b13p-2,  -0x1.7fd624p-7, INEXACT)
T(RN,  0x1.b06bf138ff197p+901,   -0x1.ff1ab23c53dc6p-1,  -0x1.da1b06p-3, INEXACT)
T(RN,  0x1.7ac56e3a7d639p+901,    0x1.f91a441590e95p-1,  -0x1.1bd626p-2, INEXACT)
T(RN,  0x1.995bef75b0e27p+901,    0x1.f5137bdc5b874p-2,    0x1.4f29dp-3, INEXACT)
T(RN,  0x1.1c7922473a28cp+901,    -0x1.babe713eb551p-1,   0x1.e23554p-3, INEXACT)
T(RN,  0x1.a6b443839b124p+901,    0x1.105c8880b1d31p-2,  -0x1.d71586p-2, INEXACT)
T(RN,  0x1.64dc046ca9f4bp+901,   -0x1.fd4e04143eb89p-1,   -0x1.f965ap-5, INEXACT)
T(RN,   0x1.cb1c43bc94c5p+902,    0x1.fd7a405c1bb72p-1,  -0x1.21f53ap-3, INEXACT)
T(RN,  0x1.f597b448bddcdp+902,    0x1.b878ab235af1dp-1,  -0x1.999c7ep-7, INEXACT)
T(RN,  0x1.7e1258fd6636fp+902,   -0x1.b6262a834b4c8p-1,  -0x1.a502dcp-2, INEXACT)
T(RN,  0x1.51a93dad83314p+902,   -0x1.2eb1f465c7229p-1,   0x1.61f24cp-3, INEXACT)
T(RN,  0x1.2941a9a020559p+902,    0x1.7623c0cf82333p-1,   0x1.89a492p-2, INEXACT)
T(RN,  0x1.0cba67ff816c4p+902,    0x1.7e74d951f7c8cp-3,   -0x1.2eb2fp-2, INEXACT)
T(RN,  0x1.c6a1d997babc6p+902,   -0x1.ad9bdb21b9fa1p-1,  -0x1.654688p-2, INEXACT)
T(RN,  0x1.e7e3ced135638p+902,    0x1.ed95c54a22cc3p-1,    0x1.85b4bp-5, INEXACT)
T(RN,  0x1.b8fa4b61994f4p+902,    0x1.1532fde7c29fap-1,   0x1.33ead4p-3, INEXACT)
T(RN,  0x1.4d2d326ef5875p+902,    0x1.f88d7ced1348ap-1,   0x1.6068e6p-4, INEXACT)
T(RN,   0x1.b08aeb2f1b53p+903,    0x1.3de6d6824bdcdp-1,  -0x1.d27feep-2, INEXACT)
T(RN,  0x1.6ccbcfbbffb0cp+903,   -0x1.c97ec8c4d4b4bp-2,   0x1.165c94p-3, INEXACT)
T(RN,  0x1.f2034b44c1e98p+903,   -0x1.1d762579548cfp-4,   -0x1.b0496p-2, INEXACT)
T(RN,  0x1.6f4909af708ecp+903,    0x1.78564dc0a52e2p-2,   0x1.466788p-3, INEXACT)
T(RN,  0x1.649c72f2960c4p+903,    0x1.7bf70d706a62fp-1,   0x1.5c5ff2p-2, INEXACT)
T(RN,  0x1.7d00b4769fd1dp+903,   -0x1.aeb9dba70e219p-1,   0x1.546a7cp-2, INEXACT)
T(RN,  0x1.214eab76b6f51p+903,    0x1.fe367f1c58863p-1,    0x1.fab9dp-3, INEXACT)
T(RN,  0x1.13c89a9e77cd4p+903,    -0x1.e86c4b5e84c7p-1,  -0x1.66f546p-2, INEXACT)
T(RN,  0x1.101971b8e7015p+903,   -0x1.f18cf9454759ap-1,  -0x1.63f87cp-5, INEXACT)
T(RN,  0x1.24d61546aa0c1p+903,    0x1.60365a2f335bcp-1,   0x1.26ee22p-2, INEXACT)
T(RN,  0x1.cd1e4e557cbf4p+904,    0x1.f25de5d349d18p-1,  -0x1.403792p-2, INEXACT)
T(RN,  0x1.cf67a7fb89f98p+904,    0x1.d2c87ea038325p-1,   0x1.eee6eap-4, INEXACT)
T(RN,  0x1.f398a27e756a6p+904,    0x1.01d253b22f9e1p-4,   0x1.55d2bep-6, INEXACT)
T(RN,  0x1.676a652f7a886p+904,   -0x1.d90e5d206708ap-1,  -0x1.c9b31cp-2, INEXACT)
T(RN,   0x1.a3ed4e643966p+904,    0x1.f61d725ac3e37p-1,   0x1.36d6ccp-6, INEXACT)
T(RN,  0x1.08d97c28cd145p+904,   -0x1.7e764eccedc1cp-2,  -0x1.e44ff4p-3, INEXACT)
T(RN,  0x1.17e258a107119p+904,   -0x1.8efa97c9a0acep-1,   0x1.895d2cp-2, INEXACT)
T(RN,  0x1.51ef9edd17dc7p+904,   -0x1.f177d393d7b25p-1,   0x1.3986e6p-3, INEXACT)
T(RN,  0x1.36a24331252cdp+904,    0x1.49c1ee8b6f3edp-2,    0x1.c912cp-3, INEXACT)
T(RN,  0x1.743f61a2788e6p+904,   -0x1.97b3ee1c2d8ebp-1,  -0x1.87b674p-2, INEXACT)
T(RN,  0x1.3bf126bfbde7bp+905,   -0x1.52fc6f8bce995p-4,  -0x1.d00aeep-5, INEXACT)
T(RN,  0x1.01cbeb70bc69bp+905,   -0x1.f67603dafb9edp-1,  -0x1.a805a4p-2, INEXACT)
T(RN,  0x1.f7effe7302ba4p+905,   -0x1.507cfa05269fap-1,  -0x1.44b078p-3, INEXACT)
T(RN,  0x1.7740b64646a42p+905,   -0x1.af3a8cb8898c9p-1,   0x1.301e36p-2, INEXACT)
T(RN,  0x1.90f10ce8c373ap+905,    0x1.e1c4266ba2ef3p-5,   -0x1.b4ee6p-2, INEXACT)
T(RN,  0x1.62f7fae2c993fp+905,    0x1.2d7e54fb913ddp-1,   0x1.4ad598p-7, INEXACT)
T(RN,  0x1.a37da6903487cp+905,    0x1.a065027cf6551p-1,  -0x1.b1e9d6p-2, INEXACT)
T(RN,  0x1.6520883f2fcbep+905,    0x1.d9a72611e353ep-1,   0x1.4e5e46p-2, INEXACT)
T(RN,  0x1.5e10d4d51af43p+905,   -0x1.eea664997470fp-1,  -0x1.3c9696p-5, INEXACT)
T(RN,  0x1.b1eaa576ece0ap+905,   -0x1.2395ba0bbde0ep-1,   0x1.75b09ap-2, INEXACT)
T(RN,  0x1.a47d2ab08e4f6p+906,   -0x1.4850d131b8b3fp-2,  -0x1.96a1eap-6, INEXACT)
T(RN,  0x1.ef35d1129942ep+906,   -0x1.ad86bbf7b4772p-1,  -0x1.a30ffap-2, INEXACT)
T(RN,  0x1.672578738eef2p+906,  -0x1.d146862da1c13p-10,  -0x1.92d2a8p-3, INEXACT)
T(RN,  0x1.f6110a340bcc4p+906,   -0x1.6c257719e5e55p-4,  -0x1.35e404p-4, INEXACT)
T(RN,  0x1.9d663cd7a74d2p+906,    0x1.201f4945d54c1p-1,   0x1.f34c2ap-5, INEXACT)
T(RN,  0x1.6877257330d37p+906,    0x1.fd86a0609be4cp-1,  -0x1.778a04p-7, INEXACT)
T(RN,  0x1.9316b72b9659ap+906,    0x1.7fec03fb39c46p-2,   0x1.b2caacp-3, INEXACT)
T(RN,  0x1.5ff44a77786a5p+906,   -0x1.1ee4b00a59a6ep-1,   0x1.6d50cap-3, INEXACT)
T(RN,  0x1.b39afe5f523a1p+906,   -0x1.d14de80e2ba6cp-1,   0x1.7e7094p-2, INEXACT)
T(RN,   0x1.89f8947fc905p+906,    0x1.b4bc2573362aep-1,  -0x1.2afa06p-5, INEXACT)
T(RN,  0x1.ac37f0895cd54p+907,    0x1.a421721d6dfdbp-1,  -0x1.099bc6p-2, INEXACT)
T(RN,  0x1.7c91362ac883bp+907,   -0x1.1cc785f5def7ap-3,  -0x1.06fed2p-2, INEXACT)
T(RN,  0x1.883c62f46e976p+907,    0x1.576f872d333e1p-1,  -0x1.450efcp-2, INEXACT)
T(RN,  0x1.bcdf246634b09p+907,    -0x1.f2a22f58d538p-1,   0x1.b86ecep-4, INEXACT)
T(RN,  0x1.fdc04e9a120cbp+907,    0x1.b57f35a89e6f1p-3,  -0x1.f69b0ap-2, INEXACT)
T(RN,  0x1.37405b699df05p+907,    0x1.feae87eaf54b1p-3,  -0x1.15f6dcp-3, INEXACT)
T(RN,  0x1.0153e7b098933p+907,   -0x1.edd6c2647ba27p-1,  -0x1.697518p-5, INEXACT)
T(RN,  0x1.2f60e50adcec9p+907,   -0x1.7a11e28277548p-1,   0x1.1f705ap-4, INEXACT)
T(RN,  0x1.0ad249417b839p+907,    0x1.ef66992e1e27bp-1,  -0x1.82238ep-2, INEXACT)
T(RN,  0x1.92ebef460cdccp+907,   -0x1.89de6fe592ae2p-2,  -0x1.f3e088p-3, INEXACT)
T(RN,   0x1.66cf173babf8p+908,    0x1.e6a5da9059cbfp-1,   0x1.686ff4p-2, INEXACT)
T(RN,  0x1.ce1164f1697f6p+908,   -0x1.2b2570eb4f01dp-3,   0x1.7a1da4p-2, INEXACT)
T(RN,  0x1.297c6a8a46e57p+908,    -0x1.92ad04f208d8p-1,   0x1.07263ep-2, INEXACT)
T(RN,  0x1.1eb22384d99dep+908,    0x1.9ceb677af75c6p-1,  -0x1.515694p-4, INEXACT)
T(RN,  0x1.999c23a2a18e8p+908,    0x1.f53d1ebc81534p-1,   0x1.d582bep-3, INEXACT)
T(RN,  0x1.944e3e48e1e2ep+908,    0x1.a94167a85d7e3p-1,  -0x1.167f96p-4, INEXACT)
T(RN,  0x1.47fe2eaa63dfdp+908,   -0x1.27b6c5cc6ef7dp-1,   0x1.17784cp-2, INEXACT)
T(RN,  0x1.5000b95b2cbeep+908,    0x1.241a8b6f2ed4bp-1,  -0x1.16d00ep-4, INEXACT)
T(RN,  0x1.45f27cafe7792p+908,   -0x1.9a3947d3f1243p-1,  -0x1.36825ep-5, INEXACT)
T(RN,  0x1.fc431e851cecep+908,    0x1.4c4b9e5a8f126p-4,   0x1.b3be04p-2, INEXACT)
T(RN,  0x1.71143cd042f16p+909,   -0x1.61ce6d74d5fa8p-2,  -0x1.ad0afcp-2, INEXACT)
T(RN,  0x1.2d5325716fa9ep+909,    0x1.bc5d71ceeb265p-1,  -0x1.a3265ap-6, INEXACT)
T(RN,  0x1.304870946d7b1p+909,    0x1.90790a6a9acc1p-2,   0x1.b107f2p-3, INEXACT)
T(RN,  0x1.6ee2bf0841816p+909,   -0x1.cfe252c3e57cfp-1,   0x1.5a268ep-2, INEXACT)
T(RN,  0x1.27c9595e6d23dp+909,    0x1.e3fbab27ec838p-1,    0x1.16b66p-9, INEXACT)
T(RN,  0x1.869c2a8ceadd2p+909,   -0x1.32d7fc342cf79p-2,  -0x1.881cdep-2, INEXACT)
T(RN,  0x1.fa569258d0588p+909,    -0x1.c7ae71ab11edp-1,   0x1.225dccp-2, INEXACT)
T(RN,  0x1.1aa6b50392462p+909,    0x1.f49a1901039e5p-1,   -0x1.92c7ap-4, INEXACT)
T(RN,  0x1.0378917cabc44p+909,    0x1.ca264cd697162p-1,   -0x1.da276p-3, INEXACT)
T(RN,  0x1.ea8c85e23c82bp+909,    0x1.0ec47ffc75edbp-1,   0x1.bd481ep-2, INEXACT)
T(RN,  0x1.533219196a1dcp+910,   -0x1.155e43ff475c9p-2,   0x1.5d0222p-3, INEXACT)
T(RN,  0x1.eda21688caf42p+910,    0x1.f1940e661caa1p-1,   0x1.c24226p-2, INEXACT)
T(RN,  0x1.d8d9fce3c0165p+910,    0x1.541b3fc238abap-4,   0x1.8d353ap-4, INEXACT)
T(RN,   0x1.3ffa219c8e2cp+910,    0x1.cdb35dd1efdd4p-7,   0x1.b6b604p-3, INEXACT)
T(RN,  0x1.f6ee1077c3f38p+910,   -0x1.a21214b1aae6ap-1,  -0x1.0b9ca6p-2, INEXACT)
T(RN,  0x1.4eac90e96b6a7p+910,    0x1.4b779c45bbdd4p-2,  -0x1.eec76ap-2, INEXACT)
T(RN,  0x1.05f64e4a5f0e2p+910,    0x1.7b624507df212p-1,   0x1.582832p-4, INEXACT)
T(RN,  0x1.7eb474ceca3e2p+910,    0x1.42578719ddac4p-2,  -0x1.1ab286p-3, INEXACT)
T(RN,  0x1.e645f0394ad87p+910,    0x1.337dfdd015568p-1,  -0x1.99764ap-2, INEXACT)
T(RN,  0x1.90d3403f6f639p+910,   -0x1.21b6ef62694fdp-2,   0x1.799ca4p-2, INEXACT)
T(RN,  0x1.be36a54a63705p+911,    0x1.ae8df82c3593ep-1,  -0x1.fefe5cp-3, INEXACT)
T(RN,  0x1.1976b29fd68bfp+911,    0x1.f01f9abe4ae9fp-1,   0x1.f4fe8cp-2, INEXACT)
T(RN,  0x1.091fd50cbee99p+911,   -0x1.aecf2d2a87d1ap-1,  -0x1.74bce8p-5, INEXACT)
T(RN,  0x1.23225482845c8p+911,    0x1.73373f2a7f6c4p-1,  -0x1.b64794p-2, INEXACT)
T(RN,  0x1.080b5855eaa51p+911,   -0x1.aea98e6a07943p-1,  -0x1.a57194p-2, INEXACT)
T(RN,  0x1.37fd4cd3a2efap+911,    0x1.25fcf08a22d63p-1,  -0x1.0ad026p-4, INEXACT)
T(RN,  0x1.77fc4bdd8df83p+911,   -0x1.8f8cb38af4f0fp-3,  -0x1.24753cp-2, INEXACT)
T(RN,  0x1.ae66087387906p+911,    -0x1.9ba6ff49b3b1p-1,  -0x1.84c4a6p-2, INEXACT)
T(RN,  0x1.a2fb00697f6aep+911,   -0x1.fd945331cf534p-1,  -0x1.8ca5f6p-2, INEXACT)
T(RN,  0x1.e23888a62bd65p+911,    0x1.e7d959e9fbf21p-1,  -0x1.d9775cp-6, INEXACT)
T(RN,  0x1.791d711a38969p+912,   -0x1.9840085afd05cp-1,  -0x1.812fd8p-4, INEXACT)
T(RN,  0x1.d8b8aaa9f94eep+912,    0x1.7105812b7714cp-1,  -0x1.fcc464p-2, INEXACT)
T(RN,  0x1.b3f7c30f7590ep+912,   -0x1.65cd5cbb0012bp-1,  -0x1.5719bap-2, INEXACT)
T(RN,  0x1.557b1abf53a8ep+912,   -0x1.a35cd303a2766p-2,    0x1.c7ad9p-3, INEXACT)
T(RN,  0x1.fb419fe4fb88ap+912,     0x1.479cc926ba23p-1,   0x1.536442p-2, INEXACT)
T(RN,   0x1.650ede59904cp+912,    0x1.033dbc26d8a13p-1,   0x1.a9c856p-4, INEXACT)
T(RN,  0x1.d62f8d8c099dcp+912,   -0x1.c1a222f231b18p-2,   0x1.3134d8p-2, INEXACT)
T(RN,  0x1.34d92b42ab2ecp+912,   -0x1.f1fc7c24e2f26p-1,  -0x1.f615ecp-2, INEXACT)
T(RN,  0x1.35db70061b53ep+912,    0x1.261cdabd22b5dp-1,   0x1.0336f4p-2, INEXACT)
T(RN,  0x1.74b1068428599p+912,    0x1.cf6cc15af885ap-1,    0x1.cce94p-2, INEXACT)
T(RN,  0x1.6236a6fa03181p+913,    0x1.5098017ed855dp-1,   0x1.9898b4p-2, INEXACT)
T(RN,  0x1.0ceb97f91786bp+913,   -0x1.82f34f46cb35ap-2,    0x1.01695p-2, INEXACT)
T(RN,  0x1.64787e4e657e6p+913,    0x1.2d6932639714ep-2,  -0x1.dc04ecp-3, INEXACT)
T(RN,  0x1.44095da3201a6p+913,   -0x1.f1417fb0561c2p-3,   0x1.cd551ep-2, INEXACT)
T(RN,  0x1.86d201b43f153p+913,   -0x1.015f90795490ep-1,  -0x1.57287ep-2, INEXACT)
T(RN,  0x1.c9b41dc55546ep+913,    -0x1.f78e17373a1ep-1,   0x1.c3eec2p-3, INEXACT)
T(RN,  0x1.94fa19c6c982dp+913,    0x1.963cb4ac0ffb8p-2,   0x1.4d19bep-2, INEXACT)
T(RN,  0x1.5cc367f5bc8a8p+913,    0x1.f5888769861fbp-1,  -0x1.ff40aep-6, INEXACT)
T(RN,  0x1.2c0973e0286a4p+913,    0x1.f8cb1e7f0f018p-1,   0x1.5c7c4ep-2, INEXACT)
T(RN,  0x1.9f6542d0747a1p+913,    0x1.89b2bd70f5444p-1,  -0x1.7808aap-4, INEXACT)
T(RN,  0x1.7c17334d10e91p+914,   -0x1.6adc62e16c135p-2,  -0x1.48e1b2p-4, INEXACT)
T(RN,   0x1.3c8e2022cc0ap+914,    0x1.1dcf17a956b3fp-4,  -0x1.e56722p-2, INEXACT)
T(RN,    0x1.4545e99a0dcp+914,   -0x1.88bb09a5f8a61p-1,    0x1.ea812p-3, INEXACT)
T(RN,  0x1.b8688ca26eadfp+914,   -0x1.a93a59d470fb9p-2,   0x1.308c18p-2, INEXACT)
T(RN,  0x1.eb00872568a09p+914,    -0x1.9bff268f833cp-2,  -0x1.8b7f18p-3, INEXACT)
T(RN,  0x1.1481d81612ff4p+914,    0x1.85e5028daafc6p-1,   0x1.78234ep-3, INEXACT)
T(RN,  0x1.939bab4c698d3p+914,    0x1.e61cb5fcc2ca1p-1,  -0x1.8b38b2p-5, INEXACT)
T(RN,  0x1.7a29a9dde0a81p+914,   -0x1.ee832590e79fep-1,   0x1.3454a8p-2, INEXACT)
T(RN,  0x1.a5222b4b72b59p+914,    0x1.8553cb5a50527p-4,  -0x1.aed36cp-7, INEXACT)
T(RN,  0x1.41e361dbe0b56p+914,   -0x1.6d66293278ecdp-1,  -0x1.baafe6p-2, INEXACT)
T(RN,  0x1.74ede5308a87dp+915,    0x1.f5ba5b35f5c2fp-1,   0x1.4c4522p-2, INEXACT)
T(RN,  0x1.ff1e1d5773ff2p+915,   -0x1.4b9f7e11ed1cep-1,     0x1.0172p-3, INEXACT)
T(RN,  0x1.f0d7ae1fa8cacp+915,    0x1.c794cfc290257p-1,  -0x1.d51228p-2, INEXACT)
T(RN,  0x1.958e7afe5d4d7p+915,    0x1.ce2046f52ab5fp-1,   0x1.8ec748p-2, INEXACT)
T(RN,  0x1.6be8a27f5fbaap+915,    0x1.ffba96e72fa77p-1,    0x1.ecc1ap-2, INEXACT)
T(RN,  0x1.acc91d5eee2d4p+915,    0x1.55b391b27567bp-1,   0x1.5d5abcp-4, INEXACT)
T(RN,  0x1.b947278c664c4p+915,   -0x1.fae5b70f1fdddp-1,   0x1.266a6ap-3, INEXACT)
T(RN,  0x1.04184461205bep+915,    0x1.64a56eb7ac3e1p-1,   0x1.dd4776p-3, INEXACT)
T(RN,  0x1.e0f29d1283beap+915,   -0x1.c47a27d72104ap-2,   0x1.d7f5d6p-2, INEXACT)
T(RN,  0x1.e0010bcb827d4p+915,    0x1.439a77ea9e858p-1,  -0x1.156222p-2, INEXACT)
T(RN,   0x1.e9d00e06e254p+916,   -0x1.a95ba265e752ap-1,  -0x1.3cfd0ep-3, INEXACT)
T(RN,  0x1.fbaaffc38b0f2p+916,    0x1.c271c588ba369p-1,  -0x1.93db2ep-3, INEXACT)
T(RN,  0x1.6c531925b4544p+916,    0x1.ff864c3b5a5eep-1,  -0x1.d6f22ep-3, INEXACT)
T(RN,  0x1.fb8bed867f7c3p+916,    0x1.4852a6a18e8d9p-2,    0x1.5689ep-4, INEXACT)
T(RN,  0x1.7412de985fea2p+916,    0x1.ffec59f41221bp-1,   0x1.08405ep-2, INEXACT)
T(RN,  0x1.d11b5bb841fcap+916,    0x1.454b4aa0190cfp-2,  -0x1.8b61c8p-3, INEXACT)
T(RN,  0x1.b55f7065ffcdep+916,    0x1.e01adda576d7bp-1,  -0x1.5c478ap-4, INEXACT)
T(RN,  0x1.9729366584505p+916,    0x1.f606113d031f9p-1,   0x1.54c18ep-3, INEXACT)
T(RN,  0x1.c6091c931a46fp+916,    0x1.c3464440db848p-2,   0x1.42d106p-2, INEXACT)
T(RN,  0x1.ba8c66b39ed83p+916,    0x1.50b51f1d3836dp-2,    -0x1.a33cp-2, INEXACT)
T(RN,  0x1.70f16c07449c6p+917,   -0x1.ac265dbf31c0bp-1,  -0x1.88cb9cp-3, INEXACT)
T(RN,  0x1.3f34da5c25ddfp+917,    0x1.bc74f9d149c27p-1,   0x1.4b581ap-3, INEXACT)
T(RN,  0x1.5cf3c90666682p+917,    0x1.05e41a32e1507p-1,  -0x1.8ffca8p-3, INEXACT)
T(RN,  0x1.94c4c00ff481ep+917,   -0x1.fe3579b66e3c3p-1,   0x1.2f2b88p-5, INEXACT)
T(RN,  0x1.ad91413932ca2p+917,    0x1.78149b11a9912p-3,  -0x1.6cf298p-3, INEXACT)
T(RN,  0x1.0f38dd7f1a70dp+917,    0x1.d938feb29c1a3p-1,  -0x1.1279aep-5, INEXACT)
T(RN,  0x1.8a276fe58b298p+917,   -0x1.fb6ccaddbee2dp-1,    0x1.57164p-3, INEXACT)
T(RN,   0x1.b104a56602ddp+917,    0x1.7684d9ff3b51bp-1,   0x1.bcb8d4p-3, INEXACT)
T(RN,  0x1.a5d852e7b4a01p+917,    0x1.33b61b75202c6p-2,  -0x1.2b51acp-2, INEXACT)
T(RN,  0x1.faca6d13ad366p+917,   -0x1.f0b2f2ce452f6p-2,   0x1.0a249cp-2, INEXACT)
T(RN,  0x1.d2097a5bfbf78p+918,   -0x1.c8022ee0af40dp-5,  -0x1.e0c988p-3, INEXACT)
T(RN,  0x1.c929f5f4edf78p+918,    -0x1.3546fe163806p-4,   0x1.4e8f72p-2, INEXACT)
T(RN,  0x1.253533a268266p+918,    0x1.5cebb480f2907p-1,   0x1.cb9c4ep-3, INEXACT)
T(RN,  0x1.32f9206bed12ap+918,   -0x1.8800c7923bc21p-1,   0x1.816f3ap-2, INEXACT)
T(RN,  0x1.148eb001d5078p+918,    0x1.de2cb7affb26fp-1,  -0x1.ba62aap-2, INEXACT)
T(RN,   0x1.def1122801cep+918,   -0x1.df30dc84bb2bfp-5,  -0x1.eee02ep-2, INEXACT)
T(RN,  0x1.26fae55f0f1edp+918,    0x1.2a53acbb5aa34p-6,    0x1.81d33p-4, INEXACT)
T(RN,    0x1.92278659e3ap+918,    0x1.fffffd846ecacp-1,  -0x1.c5ad62p-3, INEXACT)
T(RN,  0x1.05d93cc2d559ep+918,    0x1.10dd4b3e36c88p-4,  -0x1.a8e1e2p-2, INEXACT)
T(RN,  0x1.09fc013c08469p+918,    0x1.ea6d20c390a91p-1,    0x1.5e3b2p-2, INEXACT)
T(RN,  0x1.9c6ffa8556ba4p+919,   -0x1.871e665518dacp-4,   -0x1.1d62ep-6, INEXACT)
T(RN,  0x1.3e378f90d208cp+919,    0x1.cf8c45216e001p-2,   0x1.f25eaep-2, INEXACT)
T(RN,  0x1.64e07d2c71832p+919,   -0x1.fffc87fd28f8ep-1,   -0x1.b4deap-5, INEXACT)
T(RN,  0x1.f0baf51c3cfb6p+919,   -0x1.ff44ec9e65e42p-1,   0x1.7d44f4p-2, INEXACT)
T(RN,  0x1.378951323791bp+919,   -0x1.4c2afe4ebdcaap-5,   0x1.9647a6p-2, INEXACT)
T(RN,  0x1.b81e4b566035ap+919,    0x1.cfbb9b487ecb5p-1,   0x1.56d192p-3, INEXACT)
T(RN,  0x1.df26457a85fadp+919,    0x1.cf652a0b76bd2p-1,  -0x1.ec7f6ap-5, INEXACT)
T(RN,  0x1.cc494d8bae6c1p+919,   -0x1.7f95f5e734b47p-1,  -0x1.57c1b8p-4, INEXACT)
T(RN,  0x1.2ce28a9c13effp+919,    0x1.ee84148d19a26p-1,   -0x1.bb05ap-2, INEXACT)
T(RN,  0x1.4e3d9fbd632c4p+919,    0x1.e6c61733de4b2p-2,  -0x1.408352p-2, INEXACT)
T(RN,  0x1.9115291b37c38p+920,   -0x1.8e7d2888b0791p-2,   0x1.547106p-3, INEXACT)
T(RN,   0x1.a6143eb8be48p+920,   -0x1.a40fc99a07c68p-2,  -0x1.8321d8p-5, INEXACT)
T(RN,  0x1.5974ff7992c69p+920,    0x1.f073aa04a86c2p-1,   0x1.41f73ap-4, INEXACT)
T(RN,  0x1.11d71851e3bfap+920,    0x1.31a6a298fa5e6p-6,   0x1.6c8588p-7, INEXACT)
T(RN,  0x1.73dab385305dbp+920,   -0x1.c5bf264cc9cadp-1,   0x1.437ff4p-4, INEXACT)
T(RN,  0x1.68ea2ebf3dca6p+920,   -0x1.ed0b2b8a504e3p-1,  -0x1.8578f2p-3, INEXACT)
T(RN,  0x1.14cef50a0863cp+920,    0x1.3ba202705220fp-1,  -0x1.e7ff5ep-2, INEXACT)
T(RN,  0x1.5b2413ba36432p+920,    0x1.37ac9c3350438p-4,   0x1.6d99fep-5, INEXACT)
T(RN,  0x1.a404e5df4539ep+920,   -0x1.b31ce6a3180b3p-1,   0x1.ab2326p-2, INEXACT)
T(RN,  0x1.15f6eb062819fp+920,   -0x1.ecd0534e13e88p-1,   0x1.d85a22p-3, INEXACT)
T(RN,  0x1.44fff4c3b83d8p+921,    0x1.f84343c36e86ep-2,  -0x1.0141fep-4, INEXACT)
T(RN,  0x1.c6d14a52efbdep+921,    0x1.95e2157bfbc5ep-1,  -0x1.523082p-2, INEXACT)
T(RN,  0x1.1307db2f2dd4ap+921,     0x1.8ca361417c5ap-1,   0x1.a42b0ep-2, INEXACT)
T(RN,  0x1.9f8fdc660616ep+921,   -0x1.0f55ddfdccccdp-1,   -0x1.250c9p-3, INEXACT)
T(RN,  0x1.695be26e47583p+921,   -0x1.f14ced6e1f876p-1,  -0x1.87999ap-2, INEXACT)
T(RN,    0x1.3ee04104431p+921,    0x1.4f228813f936ep-3,   -0x1.4ae0fp-5, INEXACT)
T(RN,  0x1.a9dd66ee569f5p+921,    0x1.3a4150ea4e98bp-1,   0x1.2213e6p-2, INEXACT)
T(RN,  0x1.efc49aa2fba7ep+921,   -0x1.cf2603ed31a59p-1,  -0x1.b624dap-4, INEXACT)
T(RN,  0x1.071816c7e035ap+921,    0x1.9fec383cda5d8p-3,  -0x1.443bd8p-3, INEXACT)
T(RN,  0x1.d2e50cca041ebp+921,   -0x1.eba6945fc4775p-1,   0x1.993accp-2, INEXACT)
T(RN,  0x1.1b1477f0dcf84p+922,   -0x1.fca0956b85c01p-4,    -0x1.e3e8p-6, INEXACT)
T(RN,  0x1.2acb63044a5c5p+922,    0x1.26fc2fb0cadeap-4,   0x1.9cb118p-2, INEXACT)
T(RN,  0x1.0a12e57ef0e0dp+922,    0x1.e51b2c5ed5de6p-1,  -0x1.c0fe06p-2, INEXACT)
T(RN,  0x1.7b973ed21a3ecp+922,    0x1.66937542d985fp-1,  -0x1.8ccf1ep-3, INEXACT)
T(RN,  0x1.6a8fdd8768a03p+922,   -0x1.4f20687772881p-2,  -0x1.e34b38p-2, INEXACT)
T(RN,  0x1.3e01852bbd4b8p+922,   -0x1.dca4a24ff4decp-1,   0x1.44275ep-4, INEXACT)
T(RN,  0x1.885ed69583237p+922,    0x1.fae385ff5eef7p-1,  -0x1.dfeb2ap-4, INEXACT)
T(RN,  0x1.93198815f5e53p+922,    0x1.2f376c8f41177p-2,  -0x1.e1511cp-2, INEXACT)
T(RN,  0x1.18e150378b34fp+922,    0x1.d5170ee978b7cp-1,  -0x1.6e7392p-2, INEXACT)
T(RN,  0x1.b7fa3a876bfe4p+922,   -0x1.b4bb85cc79763p-1,  -0x1.508924p-4, INEXACT)
T(RN,  0x1.9ef5b31361102p+923,   -0x1.9715cdec4fedap-3,  -0x1.da5e94p-2, INEXACT)
T(RN,  0x1.de8bc9a97f6c4p+923,   -0x1.ae1d72405da54p-1,  -0x1.1b5812p-2, INEXACT)
T(RN,   0x1.2c5c882b1c91p+923,    0x1.f995a4b44befbp-1,   0x1.fabb44p-3, INEXACT)
T(RN,  0x1.eeaa564710fa3p+923,   -0x1.6ee9440b45f84p-1,  -0x1.04d0d4p-3, INEXACT)
T(RN,  0x1.a06672840c3f6p+923,   -0x1.4a8e1fd73eefep-1,   0x1.539ad6p-3, INEXACT)
T(RN,  0x1.73df06849fe67p+923,   -0x1.6c32c1f6bd829p-1,  -0x1.d1c4d6p-2, INEXACT)
T(RN,  0x1.84da694c05d26p+923,    0x1.f83600df5cf66p-1,   0x1.d2d064p-3, INEXACT)
T(RN,  0x1.9dd4b3fd09fe2p+923,   -0x1.581ed518f2095p-1,    0x1.dc17cp-2, INEXACT)
T(RN,  0x1.be01c5aa3348dp+923,   -0x1.e4f5bb1192ddap-2,  -0x1.96c186p-2, INEXACT)
T(RN,  0x1.8993f0840f0cap+923,    0x1.cc5666f3e003dp-1,   0x1.9b3d5ap-3, INEXACT)
T(RN,  0x1.dbca1988ef756p+924,    0x1.c67378f78299ep-1,   -0x1.aced7p-2, INEXACT)
T(RN,  0x1.2a59effa6aca3p+924,    0x1.c6c5a1ed22e36p-4,  -0x1.f46626p-2, INEXACT)
T(RN,  0x1.f08a7a52b3ff2p+924,    0x1.48c20669e0d8ep-1,   0x1.3882b2p-4, INEXACT)
T(RN,  0x1.c82a1228c6a65p+924,    0x1.686d0d0c1338bp-1,    0x1.981c5p-2, INEXACT)
T(RN,  0x1.828ba7f2aca68p+924,   -0x1.7bb4691868acap-3,   0x1.22b3f4p-2, INEXACT)
T(RN,   0x1.16bd52a1e9eep+924,    0x1.fa474c3ac0d75p-1,  -0x1.39f6d2p-4, INEXACT)
T(RN,  0x1.28f8c420cfcbcp+924,   -0x1.8a8cede27fe25p-2,   0x1.47ff74p-3, INEXACT)
T(RN,  0x1.5a12051e1744ap+924,   -0x1.12851b425d7f5p-1,   0x1.1f023cp-2, INEXACT)
T(RN,  0x1.5875b43cba172p+924,    0x1.82a86c04db18ep-1,  -0x1.92529ap-6, INEXACT)
T(RN,  0x1.964d75158ab08p+924,   -0x1.bb593d2b88343p-2,  -0x1.425e06p-2, INEXACT)
T(RN,  0x1.6823e17c54106p+925,    0x1.8b87717a83be8p-3,  -0x1.7684d2p-3, INEXACT)
T(RN,  0x1.3797e48086092p+925,   -0x1.7bfdaea1317bdp-2,   0x1.8c1316p-5, INEXACT)
T(RN,  0x1.75342fbd1d6d8p+925,    0x1.305d42c1c11d8p-1,  -0x1.342002p-2, INEXACT)
T(RN,  0x1.06bbc9b87d5a8p+925,   -0x1.1ce5d7086db69p-6,   0x1.9ffd72p-2, INEXACT)
T(RN,   0x1.261b9be0c02bp+925,    0x1.e8784fdc4682ep-1,  -0x1.304e7ep-3, INEXACT)
T(RN,  0x1.4c5576c5d018cp+925,   -0x1.94fd56c5fbc4dp-1,   0x1.cf6e76p-5, INEXACT)
T(RN,  0x1.5abff66693fddp+925,    0x1.ae3747b854fb2p-1,   0x1.a682cep-3, INEXACT)
T(RN,  0x1.f61f948abef92p+925,    0x1.6f2b7cad83328p-2,   0x1.2c25f2p-2, INEXACT)
T(RN,  0x1.582f694a2baadp+925,    0x1.8d8afeeb56037p-1,  -0x1.3539ecp-2, INEXACT)
T(RN,  0x1.8ea0dbe98b424p+925,   -0x1.9dbd487d6ff02p-1,   0x1.43a26ep-3, INEXACT)
T(RN,  0x1.7d8c6c197ccf2p+926,   -0x1.8516a7374227fp-1,  -0x1.6ce2c2p-5, INEXACT)
T(RN,  0x1.f79cd3c709e8ep+926,    0x1.ed08bb502dd09p-1,   -0x1.407fap-3, INEXACT)
T(RN,   0x1.223e67564ffep+926,    0x1.f246c3e3db1fdp-2,  -0x1.0fcf62p-3, INEXACT)
T(RN,   0x1.918ce5de78dap+926,    0x1.e6ea0ca3699c3p-1,   0x1.5130f4p-5, INEXACT)
T(RN,  0x1.5c7a0e2f85e2bp+926,    0x1.1debd1348a6ddp-1,    0x1.4ebf6p-3, INEXACT)
T(RN,  0x1.5b8f3650ffd8fp+926,   -0x1.2c2a247a63726p-2,   0x1.945af2p-3, INEXACT)
T(RN,   0x1.1eeb28307d65p+926,    0x1.39c4d83b5f9dcp-7,    0x1.a8499p-2, INEXACT)
T(RN,  0x1.39a6332bac83cp+926,    0x1.e271df23a076bp-4,  -0x1.3c3234p-2, INEXACT)
T(RN,  0x1.746edd0136145p+926,    0x1.fe9820773d192p-1,  -0x1.2b243cp-3, INEXACT)
T(RN,  0x1.69c46edc1d834p+926,   -0x1.7266bac850841p-2,   0x1.058b1ep-6, INEXACT)
T(RN,  0x1.0feaee3749c64p+927,   -0x1.716b6ea733602p-2,  -0x1.72f6eep-2, INEXACT)
T(RN,  0x1.3693a39d60869p+927,    0x1.ff92defadde12p-1,   -0x1.0ba68p-3, INEXACT)
T(RN,  0x1.b403d8e9bb23cp+927,   -0x1.d0969514d6b34p-1,   0x1.07e73ep-2, INEXACT)
T(RN,  0x1.6f0b7798ed586p+927,    0x1.f5c11136bcf4dp-1,   0x1.0c6f34p-2, INEXACT)
T(RN,  0x1.99a6c55d3a604p+927,    -0x1.3d7b1ab2461dp-1,  -0x1.a78d84p-3, INEXACT)
T(RN,  0x1.4e6fcf9bbf631p+927,   -0x1.d8cdba95ff91ep-2,   0x1.4056ccp-2, INEXACT)
T(RN,  0x1.708bd25c51df6p+927,   -0x1.bd73a288c7d35p-1,   0x1.5e5d92p-3, INEXACT)
T(RN,  0x1.2fc540a3c3d8dp+927,    0x1.070379515108ap-4,   0x1.ff9ae6p-3, INEXACT)
T(RN,   0x1.c8a4959ada34p+927,   -0x1.5a73ea182d9e5p-1,   -0x1.90ec5p-2, INEXACT)
T(RN,  0x1.ef3376e504332p+927,   -0x1.744f5676f1a3cp-2,   0x1.a0e9bap-3, INEXACT)
T(RN,  0x1.ccabd7450578fp+928,    0x1.33cad608e907dp-1,  -0x1.53debcp-3, INEXACT)
T(RN,   0x1.733b2a96e483p+928,   -0x1.7dc2cfefaa117p-1,  -0x1.481e88p-2, INEXACT)
T(RN,  0x1.7d46f77b8748cp+928,    0x1.a166b3a33137bp-1,  -0x1.62dc12p-5, INEXACT)
T(RN,  0x1.26f2c1367de0dp+928,   -0x1.88c3febdd8da2p-1,   0x1.050356p-3, INEXACT)
T(RN,   0x1.7b932dcfc59bp+928,    0x1.ae3ab5ea7130ap-2,   0x1.a5f752p-2, INEXACT)
T(RN,  0x1.5f8bf2eb50585p+928,    0x1.a986e5acf0213p-1,  -0x1.2e5f84p-4, INEXACT)
T(RN,  0x1.f0201d993c3c4p+928,    0x1.fb6b5ef4a5b8fp-1,  -0x1.925edep-6, INEXACT)
T(RN,  0x1.800d4f97cc541p+928,    0x1.7eef496537c6dp-1,  -0x1.62d5d8p-2, INEXACT)
T(RN,  0x1.5ab1122dd2462p+928,    0x1.282d7eadba1d3p-2,   -0x1.26191p-2, INEXACT)
T(RN,  0x1.24549a88d2538p+928,   -0x1.d3f3c078814b7p-1,  -0x1.17345cp-2, INEXACT)
T(RN,   0x1.970a7af4a9efp+929,    0x1.630999a347fcdp-1,  -0x1.0f9f08p-3, INEXACT)
T(RN,  0x1.e40b59b772da6p+929,    0x1.d6ee38c7b9d56p-1,  -0x1.29e452p-2, INEXACT)
T(RN,  0x1.35fcae44c2823p+929,     0x1.fff45f25272ap-1,   0x1.0b7d92p-2, INEXACT)
T(RN,  0x1.fb885ea07599ep+929,    0x1.1d0227fd1409dp-8,   0x1.21df4ap-3, INEXACT)
T(RN,  0x1.8a6d036c258eap+929,    0x1.ff0c4b1e3d7a9p-1,    0x1.af3a8p-2, INEXACT)
T(RN,  0x1.89a72e2ff7d6ep+929,    0x1.42cbadfd7a56ap-1,   -0x1.5092fp-2, INEXACT)
T(RN,  0x1.cb381fc7b23f6p+929,    0x1.fedce50f33159p-1,   0x1.4349dcp-2, INEXACT)
T(RN,  0x1.1afce6cf89d24p+929,   -0x1.350f7244c1a33p-6,  -0x1.699608p-3, INEXACT)
T(RN,  0x1.1f4ee0928d57cp+929,    -0x1.0c5343a4f89fp-2,   0x1.276264p-2, INEXACT)
T(RN,  0x1.cd9d1a29770dcp+929,   -0x1.129b62e1475cbp-5,  -0x1.cb35a2p-2, INEXACT)
T(RN,  0x1.5551ff94fb2dfp+930,   -0x1.1495a8ce46ad5p-1,  -0x1.8a8454p-2, INEXACT)
T(RN,  0x1.701adcd0f0e73p+930,   -0x1.c4b487eca8104p-1,   0x1.539a5ep-2, INEXACT)
T(RN,  0x1.36770bba80abep+930,    0x1.1e375c452ed2ep-1,   0x1.175c74p-2, INEXACT)
T(RN,  0x1.5e7d8ee2046c5p+930,   -0x1.77bf3d9125807p-1,  -0x1.90e1a2p-2, INEXACT)
T(RN,  0x1.954fb3ef68131p+930,    0x1.c0dd933a9d599p-1,   0x1.e1a9a8p-5, INEXACT)
T(RN,  0x1.51b651e4a0123p+930,   -0x1.8f59eac575e73p-2,  -0x1.4747aep-4, INEXACT)
T(RN,  0x1.840d87b50071ep+930,    0x1.0b686daed560bp-2,   0x1.2d1a98p-2, INEXACT)
T(RN,  0x1.109e4af6e8287p+930,    0x1.79e59b776f758p-1,  -0x1.61eeecp-5, INEXACT)
T(RN,  0x1.38265360e2ec9p+930,    0x1.f9ac8011663a2p-1,   0x1.d37dcap-3, INEXACT)
T(RN,  0x1.fdd9b93e9f464p+930,    0x1.ff09a5369032cp-1,  -0x1.83e45ep-2, INEXACT)
T(RN,   0x1.bc2c14353a82p+931,   -0x1.fd2f667132071p-1,    0x1.4781ep-2, INEXACT)
T(RN,  0x1.0fdb022e1ae67p+931,    -0x1.c9fc4c172f13p-2,   0x1.5e419ep-2, INEXACT)
T(RN,  0x1.21156a53ba436p+931,   -0x1.afece83274393p-1,    0x1.1c118p-2, INEXACT)
T(RN,  0x1.643ccba6d9dcbp+931,    0x1.fea91a88bc226p-1,   0x1.e8d6c2p-2, INEXACT)
T(RN,  0x1.f4079e4e062d2p+931,    0x1.8c6a47182be4bp-1,   0x1.83c32ap-2, INEXACT)
T(RN,  0x1.defac61d08fd7p+931,    0x1.ff21719836db5p-1,   0x1.813f0ap-4, INEXACT)
T(RN,   0x1.a416f63c65f1p+931,   -0x1.9aca866a2fb4fp-3,   -0x1.25281p-2, INEXACT)
T(RN,  0x1.b814277a41c7dp+931,   -0x1.8c2ce4de6faf3p-8,   0x1.86b2f8p-2, INEXACT)
T(RN,  0x1.455787f62ed1fp+931,   -0x1.f6bb4a5df7242p-1,   0x1.e20b8ap-5, INEXACT)
T(RN,  0x1.3d5464201de55p+931,   -0x1.09fc5c7ea62bfp-4,  -0x1.28afc8p-2, INEXACT)
T(RN,  0x1.201c422df4fc6p+932,   -0x1.833fd16f56212p-1,  -0x1.c33c52p-3, INEXACT)
T(RN,  0x1.7bb35d984a48bp+932,   -0x1.881bb4e78cabdp-1,  -0x1.bcffecp-2, INEXACT)
T(RN,  0x1.a106dd3470a86p+932,   -0x1.a9ebca24ec4f7p-1,   0x1.852ca4p-2, INEXACT)
T(RN,  0x1.9967cba27e394p+932,    0x1.95612f1e7c223p-1,   0x1.89e804p-3, INEXACT)
T(RN,  0x1.273ed37026d5ep+932,   -0x1.d66ec6f98a507p-1,  -0x1.6b4e2ap-2, INEXACT)
T(RN,   0x1.fea90eb4192fp+932,    0x1.29fd1dac0ba6cp-3,   0x1.338d32p-3, INEXACT)
T(RN,  0x1.ea72c98944e52p+932,    0x1.fa23d2fba8652p-1,   0x1.a82ef6p-2, INEXACT)
T(RN,  0x1.b94709ffb229fp+932,   -0x1.675927f093837p-1,  -0x1.616ecap-2, INEXACT)
T(RN,  0x1.fc79094195376p+932,   -0x1.f642746fcd7d9p-1,   0x1.3759ccp-3, INEXACT)
T(RN,  0x1.45776caffe741p+932,    0x1.95379b85b4bc1p-2,   0x1.d3e7d4p-2, INEXACT)
T(RN,  0x1.6b8f9bd934d9ap+933,    0x1.3f6f1fd475c12p-2,  -0x1.b06156p-3, INEXACT)
T(RN,  0x1.d703524fb5245p+933,    -0x1.e81370f244b4p-1,  -0x1.db2f52p-4, INEXACT)
T(RN,  0x1.865291cb778a1p+933,   -0x1.da3bc26c07cc3p-1,   -0x1.eb93ap-2, INEXACT)
T(RN,  0x1.19c0af16ea0dep+933,    0x1.413e12149e7f3p-1,   0x1.b50658p-4, INEXACT)
T(RN,  0x1.03531c0f5ca93p+933,   -0x1.f871955876e3dp-1,   0x1.332dd6p-2, INEXACT)
T(RN,  0x1.4ee71b19f8955p+933,   -0x1.e3b5017bbcda9p-1,   0x1.f1b1fcp-2, INEXACT)
T(RN,  0x1.09e536c9fdbd7p+933,   -0x1.ac3b4b29dd09cp-2,   0x1.080e3ap-3, INEXACT)
T(RN,  0x1.c3e795dbcbd88p+933,    0x1.893ff97052cbbp-2,   -0x1.194bbp-5, INEXACT)
T(RN,  0x1.cd54ee5e00edap+933,   -0x1.349f57141ee47p-4,    0x1.d5b5ap-2, INEXACT)
T(RN,  0x1.d2496b7bddacep+933,    0x1.af00394d7f47bp-1,  -0x1.3fd766p-2, INEXACT)
T(RN,  0x1.2fd83e3e7c297p+934,   -0x1.f260740ecc49bp-1,  -0x1.d2a3d6p-2, INEXACT)
T(RN,  0x1.a7a473541dfeep+934,    0x1.edd6ee7d2584cp-1,  -0x1.4ae574p-2, INEXACT)
T(RN,  0x1.006757d1601e1p+934,   -0x1.30c53db708e01p-1,   0x1.2f4c94p-2, INEXACT)
T(RN,  0x1.81da668f64d12p+934,    0x1.77644a8c0d953p-1,  -0x1.512a32p-4, INEXACT)
T(RN,  0x1.9f7cee14a2187p+934,    0x1.a75becc026c7cp-1,   0x1.552c38p-7, INEXACT)
T(RN,  0x1.8e479bf3e405cp+934,    0x1.49120122780e4p-1,  -0x1.e430b2p-2, INEXACT)
T(RN,  0x1.99140f9ce5cdap+934,   -0x1.04c1d9cc65262p-2,   0x1.4c295ap-4, INEXACT)
T(RN,  0x1.aceab6e994057p+934,    -0x1.278983a7932fp-2,   0x1.edb354p-3, INEXACT)
T(RN,  0x1.5793947e47826p+934,     0x1.d39bae3777c4p-1,  -0x1.6dd788p-2, INEXACT)
T(RN,  0x1.96301e050deb2p+934,   -0x1.415a3f51df6e7p-1,   0x1.e09d24p-2, INEXACT)
T(RN,  0x1.e18b114256281p+935,    0x1.da550f820f52cp-1,    0x1.126ecp-2, INEXACT)
T(RN,  0x1.faaae8c5a2b1ep+935,   -0x1.5567840e3561bp-4,  -0x1.2e4d1ep-2, INEXACT)
T(RN,  0x1.bc8885fd00f76p+935,   -0x1.ff3f0a75ad74dp-1,  -0x1.c8f3dcp-2, INEXACT)
T(RN,  0x1.c60f38aa7c498p+935,   -0x1.5495a039c14b8p-1,    0x1.885d7p-2, INEXACT)
T(RN,  0x1.4bc11f09d1ce7p+935,   -0x1.f72deee362837p-1,   0x1.6044a4p-2, INEXACT)
T(RN,  0x1.4e094c710b077p+935,    0x1.17eb276f737bcp-1,   0x1.2a1b62p-3, INEXACT)
T(RN,  0x1.253a762355d7cp+935,   -0x1.39b0bbfab2cb4p-4,  -0x1.07a898p-3, INEXACT)
T(RN,  0x1.8c55797a56deap+935,   -0x1.368a78a6d7fbbp-1,   -0x1.165abp-3, INEXACT)
T(RN,  0x1.d3c168d334138p+935,    0x1.8a6a6a1ba0eaep-2,   0x1.699162p-2, INEXACT)
T(RN,   0x1.a0a7a8a5abdfp+935,    0x1.fac49618a0bb2p-1,  -0x1.ff56a6p-2, INEXACT)
T(RN,  0x1.2de6c4298bd25p+936,    0x1.09426d39b3123p-1,  -0x1.5608b2p-2, INEXACT)
T(RN,  0x1.0d8c6c96d64a4p+936,    0x1.f558ed30383a1p-1,  -0x1.dd5752p-4, INEXACT)
T(RN,  0x1.a52ba13332c94p+936,   -0x1.a03f335c3f3e7p-1,   0x1.0dc49ep-2, INEXACT)
T(RN,  0x1.af159901cc722p+936,    0x1.77d2f95d3b808p-2,   0x1.762bdcp-2, INEXACT)
T(RN,  0x1.ab2fb9a8b33dap+936,    0x1.4a505b072bb68p-3,   0x1.1e730ep-3, INEXACT)
T(RN,  0x1.b74acdd394738p+936,    0x1.1f114e3a48eefp-4,  -0x1.c22822p-6, INEXACT)
T(RN,  0x1.9ff2d3149574cp+936,    0x1.f435289019a0dp-6,  -0x1.2a8706p-5, INEXACT)
T(RN,  0x1.cba5d9ad625aap+936,   -0x1.eb8e5e3c4208dp-1,  -0x1.6b540ap-4, INEXACT)
T(RN,  0x1.3ffee62102ca5p+936,    0x1.7416968e7f059p-1,  -0x1.6f5144p-3, INEXACT)
T(RN,   0x1.300659aeaa29p+936,    0x1.9d626fe9efceap-2,   0x1.9ad216p-2, INEXACT)
T(RN,  0x1.7b36945fbc87ap+937,    0x1.984f54f8024adp-1,  -0x1.880168p-2, INEXACT)
T(RN,  0x1.9f20ea2809dd6p+937,   -0x1.b516372d1deffp-1,   0x1.85afd6p-5, INEXACT)
T(RN,   0x1.f4347b962953p+937,    0x1.f084c3bce757bp-1,  -0x1.a11892p-7, INEXACT)
T(RN,  0x1.60f530484dfb6p+937,    0x1.bddbfa0b97766p-1,   0x1.66659ep-2, INEXACT)
T(RN,  0x1.98700b5aef57ap+937,   -0x1.e443e4997b632p-1,  -0x1.3886c8p-7, INEXACT)
T(RN,  0x1.9aff9326ce6fep+937,    0x1.5f4ea50827b2bp-4,   -0x1.465a7p-5, INEXACT)
T(RN,  0x1.bf7a616696c96p+937,    0x1.5362fdd2c166cp-4,  -0x1.a319a4p-2, INEXACT)
T(RN,  0x1.230d91c3ad2e6p+937,    0x1.a985f2e0e20e6p-1,   0x1.1cf0fep-3, INEXACT)
T(RN,  0x1.b4ca799cfbc82p+937,   -0x1.958f9bfe98977p-2,  -0x1.51cb32p-2, INEXACT)
T(RN,  0x1.61a87c7ca62b2p+937,   -0x1.d78a08f3c93f2p-1,   0x1.b1792ap-3, INEXACT)
T(RN,  0x1.95c49370d4394p+938,    0x1.239b2b7fea37ap-1,  -0x1.cdc758p-2, INEXACT)
T(RN,  0x1.4c04d9bf2a512p+938,   -0x1.5e110b73f7e3cp-1,  -0x1.0b940ap-2, INEXACT)
T(RN,  0x1.ad5f08653b325p+938,   -0x1.e219092c7c3e3p-3,  -0x1.cead08p-4, INEXACT)
T(RN,  0x1.2d75ff9205137p+938,   -0x1.92cf49253003fp-4,   0x1.7fcb14p-2, INEXACT)
T(RN,  0x1.20cc11297cc3dp+938,   -0x1.ec293cd50a504p-2,  -0x1.be118cp-4, INEXACT)
T(RN,  0x1.93ea8e1a75d38p+938,   -0x1.a8342b628c44dp-1,  -0x1.e1453cp-3, INEXACT)
T(RN,  0x1.b616835fee5fbp+938,   -0x1.1d0f05a4b65d8p-2,   0x1.e1c27ap-3, INEXACT)
T(RN,  0x1.8c77cf28bbc1ap+938,    0x1.8f9789dcebc3ep-1,   0x1.312fbcp-4, INEXACT)
T(RN,  0x1.a24da4987410cp+938,   -0x1.e99583ffd6c69p-1,  -0x1.29d4a2p-3, INEXACT)
T(RN,  0x1.6ae37d0c41282p+938,    0x1.af7a1cacfb2a7p-2,  -0x1.2b2e18p-3, INEXACT)
T(RN,  0x1.b0fb1e6302e7dp+939,    0x1.7222ff48c571ap-3,  -0x1.073a3ap-2, INEXACT)
T(RN,  0x1.344307c2d86b2p+939,    0x1.b4fafc4ddb01dp-2,    0x1.197b6p-4, INEXACT)
T(RN,  0x1.b330e5c4dd693p+939,   -0x1.b0028e65ca4c9p-1,  -0x1.b20552p-4, INEXACT)
T(RN,  0x1.535421e92e4f6p+939,    0x1.c06a276e461c3p-1,  -0x1.a45c42p-2, INEXACT)
T(RN,  0x1.a877a6462f2eap+939,    0x1.f819667fb9e9dp-3,  -0x1.00ca8cp-4, INEXACT)
T(RN,  0x1.2c7b666e6fddcp+939,   -0x1.ff61c07afdf43p-1,   0x1.5f1944p-2, INEXACT)
T(RN,  0x1.d99641235ddf5p+939,    0x1.d511c03b1a0eap-1,   0x1.2d47c6p-2, INEXACT)
T(RN,  0x1.8a39caeb6565ap+939,    -0x1.dca713d1122ap-1,  -0x1.368c0ap-3, INEXACT)
T(RN,  0x1.6652a79f2fd3cp+939,   -0x1.f6a62be48c8efp-1,  -0x1.c9e27ep-2, INEXACT)
T(RN,   0x1.e326872d4e75p+939,   -0x1.fed8dd56f8d9dp-1,   0x1.067412p-2, INEXACT)
T(RN,  0x1.84abc193ff497p+940,    0x1.c89ad5e190fdbp-2,  -0x1.9d511ap-3, INEXACT)
T(RN,    0x1.a648d21846dp+940,   -0x1.d1169496caa7ep-1,   0x1.9b408ep-3, INEXACT)
T(RN,  0x1.d5be5e3f314a2p+940,    0x1.fe5752b0f73ffp-1,  -0x1.0e536cp-4, INEXACT)
T(RN,  0x1.2cbb29d653084p+940,    0x1.02cb36ed3a0dap-1,   0x1.dd8b34p-2, INEXACT)
T(RN,  0x1.348afec49f64bp+940,   -0x1.114aff97af48ep-2,  -0x1.d21a5cp-8, INEXACT)
T(RN,  0x1.28afd4d3ed5a7p+940,    0x1.f099f685c5bb9p-1,    0x1.45acap-3, INEXACT)
T(RN,  0x1.a4e60b16b56dcp+940,   -0x1.017dfc9b60a94p-2,   0x1.3c37e2p-2, INEXACT)
T(RN,  0x1.d5c951d033021p+940,    0x1.84ef5509d05d1p-7,    0x1.ac204p-2, INEXACT)
T(RN,  0x1.fbce5410c45b2p+940,    0x1.fd11327e4255bp-1,   0x1.8d516cp-3, INEXACT)
T(RN,  0x1.7c2bc2762b6e2p+940,    0x1.9fc38b845fbc3p-2,   0x1.1b8808p-2, INEXACT)
T(RN,  0x1.828918ad6bdc1p+941,    0x1.56af911994f5dp-5,  -0x1.3513a6p-3, INEXACT)
T(RN,  0x1.6ea60c67f0a3ep+941,    0x1.d3f443a3cf26fp-1,  -0x1.83b50ep-2, INEXACT)
T(RN,  0x1.962274ac7be57p+941,   -0x1.2578aadcd0657p-1,     0x1.6517p-3, INEXACT)
T(RN,  0x1.60806b9bb47eep+941,   -0x1.d2d374f16c0b9p-1,   0x1.86322ap-2, INEXACT)
T(RN,  0x1.a5030dd2e548fp+941,   -0x1.781eb44cf09d6p-1,   0x1.fee59ep-2, INEXACT)
T(RN,  0x1.46c1b7848c704p+941,   -0x1.e9828d9988b83p-1,   0x1.6ddc8cp-2, INEXACT)
T(RN,  0x1.23c0d97637fc3p+941,   -0x1.2c7de4054f7e6p-2,   0x1.bc7554p-2, INEXACT)
T(RN,  0x1.b0f71be00b728p+941,   -0x1.f75c40c1b78cap-1,   0x1.0e814ep-2, INEXACT)
T(RN,  0x1.2cf6e8e5535b1p+941,    0x1.1d93e46d8ca24p-3,  -0x1.956618p-2, INEXACT)
T(RN,  0x1.87afdf9e814f2p+941,    0x1.21072faaf2b67p-1,    0x1.e0bcfp-2, INEXACT)
T(RN,  0x1.b2486889e7422p+942,   -0x1.aa59e67bff7e9p-1,  -0x1.76d782p-3, INEXACT)
T(RN,  0x1.b13cbc04182a5p+942,    0x1.f2e9362882db5p-1,   0x1.0e4b86p-5, INEXACT)
T(RN,  0x1.08d5a66bdec74p+942,   -0x1.d165f0fb6bd05p-1,   0x1.79fde8p-3, INEXACT)
T(RN,  0x1.1c11b746b17eep+942,    0x1.41976226aa1c8p-3,   0x1.c3bb32p-5, INEXACT)
T(RN,  0x1.1fee5fe545197p+942,   -0x1.f38b041d8f861p-1,  -0x1.ee222ep-3, INEXACT)
T(RN,  0x1.b6c98c5539ca2p+942,   -0x1.b00a0501a7159p-4,   0x1.a015e2p-2, INEXACT)
T(RN,  0x1.788d76df33d74p+942,   -0x1.d66567292ee7dp-1,   0x1.c8aa34p-3, INEXACT)
T(RN,  0x1.eaa3f9ccd7c0ap+942,    0x1.877677f33ef3ap-1,   -0x1.cc578p-4, INEXACT)
T(RN,  0x1.5730a82743fe8p+942,   -0x1.ab81d0ff2fd8cp-2,    0x1.7fbdfp-3, INEXACT)
T(RN,  0x1.368d206484c19p+942,   -0x1.a128ee4273adcp-2,  -0x1.93f7f4p-2, INEXACT)
T(RN,  0x1.0867946c0c20ep+943,    0x1.f163888123806p-1,   0x1.866c88p-2, INEXACT)
T(RN,  0x1.e06c618a0d8f5p+943,    0x1.fc5c0161c3ea9p-1,  -0x1.4d515ap-3, INEXACT)
T(RN,  0x1.71d4c767de60ap+943,    0x1.4c54ab0056d0bp-1,  -0x1.d057c4p-2, INEXACT)
T(RN,  0x1.90444427447dap+943,   -0x1.532bda65d5686p-3,   0x1.170c4ap-2, INEXACT)
T(RN,  0x1.1159d112dd5bdp+943,   -0x1.103597c1fac85p-2,   0x1.3a4f8ap-2, INEXACT)
T(RN,  0x1.51a2e59ec2a6ep+943,    0x1.d022a6c1ca82bp-1,   0x1.df209ep-2, INEXACT)
T(RN,  0x1.88ac03eac0921p+943,   -0x1.a177f116bff5ep-1,   -0x1.3c3c1p-2, INEXACT)
T(RN,  0x1.5ed5534452986p+943,    0x1.eef6a50ec9cf2p-1,    0x1.30c88p-3, INEXACT)
T(RN,  0x1.187009afb7c6ap+943,   -0x1.a7f84151aae6cp-1,   -0x1.9f975p-4, INEXACT)
T(RN,  0x1.a9e717df7fab6p+943,   -0x1.fd35c65ddae87p-1,   0x1.1995c2p-2, INEXACT)
T(RN,  0x1.6c25f32cc18e2p+944,    0x1.39b37e70a9adfp-1,  -0x1.ffec0ap-4, INEXACT)
T(RN,  0x1.66f86de5683e6p+944,    0x1.4789664172492p-1,  -0x1.288ebap-5, INEXACT)
T(RN,  0x1.68858b0f807cap+944,   -0x1.c2af1597a1d01p-1,   0x1.357b4ap-3, INEXACT)
T(RN,  0x1.44749ac2bfaf4p+944,    0x1.14a0c2478e8c6p-1,   0x1.5d8006p-3, INEXACT)
T(RN,  0x1.0886519ed2c54p+944,   -0x1.f4eb450dcb0f3p-1,  -0x1.3ac248p-2, INEXACT)
T(RN,  0x1.c2dd86e3d835ep+944,    0x1.bac4ad19f6aa5p-1,   0x1.b0de0ep-4, INEXACT)
T(RN,  0x1.8efca508b7e33p+944,   -0x1.07ca63b0f2731p-5,   0x1.d97f6p-10, INEXACT)
T(RN,  0x1.088b0823e497ep+944,    0x1.69a384af21e12p-1,   0x1.bdec6ep-4, INEXACT)
T(RN,  0x1.f8539bd24207ep+944,    0x1.d3fd3d4feed06p-8,  -0x1.08a28ap-4, INEXACT)
T(RN,  0x1.0455820d579f1p+944,   -0x1.f9389fc41424dp-1,   0x1.4fb9a8p-2, INEXACT)
T(RN,  0x1.96423c079560ap+945,   -0x1.ed2ce277f8b79p-1,  -0x1.04292ep-2, INEXACT)
T(RN,  0x1.87336e4c18611p+945,    0x1.fb8060bc2e1bbp-1,   -0x1.86517p-2, INEXACT)
T(RN,  0x1.c6ed3bf91a923p+945,    0x1.6d76c9dd14936p-1,  -0x1.fcf778p-2, INEXACT)
T(RN,   0x1.3dec49a63287p+945,   -0x1.04af00f1839bcp-1,    0x1.9cee7p-2, INEXACT)
T(RN,  0x1.162ff53d8d981p+945,    0x1.7d8ad6093b079p-1,  -0x1.b41904p-2, INEXACT)
T(RN,  0x1.e66ae40e4967ep+945,   -0x1.c85cb9613110cp-1,   0x1.311d6cp-2, INEXACT)
T(RN,  0x1.0b47aed1061dfp+945,   -0x1.f986d7d6552b9p-1,   0x1.f8d8e8p-2, INEXACT)
T(RN,  0x1.af9b8011f74b8p+945,    0x1.3e81aa31b5e26p-3,  -0x1.0ee6a4p-3, INEXACT)
T(RN,  0x1.03bd930bad7d2p+945,    0x1.36b8ac517abc1p-1,  -0x1.25c916p-2, INEXACT)
T(RN,  0x1.9dbff863e28b3p+945,   -0x1.5f060e562680cp-1,  -0x1.e000fap-6, INEXACT)
T(RN,  0x1.6ca15cbebca04p+946,    0x1.6fce01761c49dp-1,   0x1.062a28p-3, INEXACT)
T(RN,  0x1.0eafb009b7706p+946,    0x1.1a9c8c9fb883bp-1,  -0x1.528ab6p-3, INEXACT)
T(RN,  0x1.5a96f7390130cp+946,    0x1.b0721f2171a94p-2,  -0x1.92f25cp-4, INEXACT)
T(RN,  0x1.7226418cd0d28p+946,   -0x1.6bc5b0ac2f557p-1,   0x1.589e22p-2, INEXACT)
T(RN,  0x1.765a2263d8beep+946,   -0x1.ebedd83f8060dp-1,  -0x1.946f7ap-2, INEXACT)
T(RN,  0x1.6c6394f694707p+946,   -0x1.5aa6f8add3e2bp-1,  -0x1.c24b5cp-4, INEXACT)
T(RN,   0x1.35f4e0ae6501p+946,   -0x1.5ab0290b3ef95p-1,   0x1.791444p-2, INEXACT)
T(RN,  0x1.fb279e990a458p+946,    0x1.c65d0e10422a2p-1,   0x1.aaf0f4p-3, INEXACT)
T(RN,  0x1.b975235bf77f4p+946,    0x1.8a11ffbde6991p-1,   -0x1.4b0aep-2, INEXACT)
T(RN,  0x1.cf82c13d3310cp+946,    0x1.36dec93816c4cp-2,   0x1.151b58p-2, INEXACT)
T(RN,  0x1.e6fe6273d0927p+947,    0x1.e7e0cb2082abdp-1,   0x1.91a398p-4, INEXACT)
T(RN,  0x1.e036628679012p+947,   -0x1.ded9ff0cd22dcp-3,   0x1.e77cb8p-2, INEXACT)
T(RN,  0x1.983e4ef782318p+947,   -0x1.b58fbf5974d33p-2,   0x1.31d28ap-3, INEXACT)
T(RN,  0x1.d92675cae7e46p+947,     0x1.15f0cf800666p-3,  -0x1.9eab5ep-3, INEXACT)
T(RN,  0x1.dd650ae3b88cap+947,   -0x1.baac3e28a1b6cp-2,  -0x1.08efd2p-2, INEXACT)
T(RN,  0x1.925078240cc9ap+947,   -0x1.f0f2a189597c7p-1,  -0x1.b17524p-3, INEXACT)
T(RN,   0x1.866396145affp+947,    0x1.970210e01298dp-3,   0x1.1afffep-3, INEXACT)
T(RN,  0x1.771de6c939bf1p+947,   -0x1.c0d26ce760aeap-2,  -0x1.c47e82p-4, INEXACT)
T(RN,  0x1.a327e2ab6aaf2p+947,   -0x1.ffce24f11e9a8p-1,   0x1.701aeap-4, INEXACT)
T(RN,  0x1.65799d92b5d6cp+947,    0x1.6184b8c9c8d93p-6,  -0x1.e18258p-2, INEXACT)
T(RN,  0x1.379a37206fed7p+948,   -0x1.8e76240bcf93cp-6,  -0x1.e6b4ccp-2, INEXACT)
T(RN,  0x1.0dbdeb0afb03cp+948,   -0x1.4496f51a7d338p-2,  -0x1.54b948p-4, INEXACT)
T(RN,  0x1.572296134a324p+948,    0x1.fc544f583563dp-1,  -0x1.3446dcp-3, INEXACT)
T(RN,  0x1.9a9b588a750cap+948,   -0x1.81fb4e71223a5p-1,  -0x1.77b99ep-2, INEXACT)
T(RN,  0x1.0a1db9bd52605p+948,   -0x1.d3435a82cab62p-2,   0x1.cb62a6p-2, INEXACT)
T(RN,  0x1.42ad3a1100b55p+948,    0x1.313a4ad87bcb9p-1,  -0x1.5bac6cp-2, INEXACT)
T(RN,  0x1.3ac7541c8761ep+948,    -0x1.541117cd0bd4p-1,   -0x1.37341p-2, INEXACT)
T(RN,   0x1.9da7720351b7p+948,    -0x1.e43fd17572c3p-1,   0x1.2b5d66p-2, INEXACT)
T(RN,  0x1.223fcf62845edp+948,   -0x1.c0967fc760c0fp-1,  -0x1.ab7fdep-7, INEXACT)
T(RN,  0x1.ede2df2138c0ap+948,    0x1.c21162b5e7d1bp-1,  -0x1.f34618p-2, INEXACT)
T(RN,  0x1.76ca7062936dap+949,   -0x1.2fed47aa7277cp-1,   0x1.6d27bep-2, INEXACT)
T(RN,  0x1.3ab9c6e6b95f6p+949,    0x1.6bc1bbfda7b5ep-2,     0x1.4a3ep-3, INEXACT)
T(RN,  0x1.23d3facf5ede4p+949,   -0x1.69f137f491862p-3,  -0x1.6f7082p-2, INEXACT)
T(RN,  0x1.9921a4e6591adp+949,    0x1.31b5f06d823a6p-1,   -0x1.c12b2p-5, INEXACT)
T(RN,  0x1.28dbaa7fa1103p+949,    0x1.ab321c76d51d2p-1,  -0x1.6d5374p-5, INEXACT)
T(RN,  0x1.e33a8b508250ep+949,    0x1.a87b3abd2a66ap-6,  -0x1.9eb832p-4, INEXACT)
T(RN,   0x1.a6ff89b43782p+949,   -0x1.b22c6a5ea769ap-2,  -0x1.ee0e0ep-2, INEXACT)
T(RN,  0x1.b39e7f3bf9c0fp+949,    0x1.d8b6a85cffbdcp-1,   0x1.483fc6p-3, INEXACT)
T(RN,  0x1.7004e593a25b3p+949,   -0x1.eeee3c1381169p-1,  -0x1.b631ecp-3, INEXACT)
T(RN,  0x1.9418d232db368p+949,    0x1.f9c80ef615139p-1,   0x1.c46474p-2, INEXACT)
T(RN,  0x1.9415e037ef029p+950,   -0x1.090bb62334979p-1,   0x1.fedb94p-4, INEXACT)
T(RN,  0x1.d2ae14f559f96p+950,   -0x1.d90832fa127c5p-5,  -0x1.c5713cp-2, INEXACT)
T(RN,  0x1.01ae98a00feb5p+950,   -0x1.b171cca87a60ep-1,    0x1.a1285p-2, INEXACT)
T(RN,  0x1.7279625538b34p+950,    0x1.bea13e23bd204p-1,   -0x1.b1d83p-3, INEXACT)
T(RN,  0x1.c8d336133225cp+950,   -0x1.d06a327488164p-2,   -0x1.cba93p-2, INEXACT)
T(RN,  0x1.e4e372ea7dc56p+950,   -0x1.ff3b981b2be2bp-1,   0x1.031f18p-3, INEXACT)
T(RN,   0x1.a3c4ab469caap+950,    0x1.bebcf379d13fbp-2,  -0x1.b3c844p-2, INEXACT)
T(RN,  0x1.9c710a7568a66p+950,    0x1.fb77e5ec52056p-1,  -0x1.d914f8p-4, INEXACT)
T(RN,   0x1.83f4e9b978b9p+950,    0x1.c69eea9e99443p-1,  -0x1.416d0cp-5, INEXACT)
T(RN,  0x1.c023c43a3fbe3p+950,    0x1.6ea76c404392ep-1,  -0x1.dcef4ap-2, INEXACT)
T(RN,  0x1.95879f7d6101ep+951,    0x1.3225a22d3d98ap-3,  -0x1.81ac42p-2, INEXACT)
T(RN,  0x1.a99d3c18fd07cp+951,    0x1.23f9d65d4b4c3p-2,   0x1.cdf318p-4, INEXACT)
T(RN,  0x1.7a54d421196a9p+951,    -0x1.8996a28a4bdfp-2,  -0x1.141dc2p-2, INEXACT)
T(RN,  0x1.b781532544a74p+951,    -0x1.e3b3745bb089p-1,   0x1.469f94p-4, INEXACT)
T(RN,  0x1.9bfabd7e04eaap+951,    0x1.30dcc57978f06p-1,  -0x1.6c468ap-3, INEXACT)
T(RN,  0x1.2bed060d7028bp+951,    -0x1.5fb4859dbab2p-2,   0x1.4166aap-3, INEXACT)
T(RN,  0x1.54a883606f3e6p+951,    0x1.c2746618aaf7ap-3,  -0x1.296e3cp-2, INEXACT)
T(RN,  0x1.f7136ca82e7f9p+951,   -0x1.f77e28893ebaep-1,   0x1.a7bb94p-2, INEXACT)
T(RN,  0x1.e3d90ef044da6p+951,   -0x1.c570a834bb6c2p-1,   -0x1.ddfb1p-2, INEXACT)
T(RN,  0x1.4f9f59dec03efp+951,   -0x1.4bd16f6338862p-5,  -0x1.530aa4p-3, INEXACT)
T(RN,  0x1.4c15e1ffe1358p+952,    0x1.6eb2eee72b3d7p-3,    -0x1.2f1dp-4, INEXACT)
T(RN,  0x1.0bcbfe0b154afp+952,   -0x1.bcfc885b45d1fp-1,   0x1.4e1c4cp-3, INEXACT)
T(RN,  0x1.9f86b528d2874p+952,   -0x1.c11e1a0012165p-2,  -0x1.26bbacp-3, INEXACT)
T(RN,  0x1.10564a378e93ap+952,    0x1.fb5246d98d4b6p-1,  -0x1.056c7ap-3, INEXACT)
T(RN,  0x1.c027e76dc811dp+952,    0x1.ac987b7e5ef8dp-1,   0x1.fa7f18p-2, INEXACT)
T(RN,   0x1.a535e651dbaep+952,   -0x1.ccacb354b28bdp-1,   0x1.353d36p-5, INEXACT)
T(RN,  0x1.517728aff91d6p+952,   -0x1.f8d7613322e74p-1,  -0x1.ee7b3ap-5, INEXACT)
T(RN,  0x1.50af9e62f7fe4p+952,    0x1.0f20f14f56e36p-1,  -0x1.235b7ep-3, INEXACT)
T(RN,  0x1.222a2c538467bp+952,     0x1.df012c96e1cep-5,  -0x1.092396p-3, INEXACT)
T(RN,  0x1.61268c5bf4c97p+952,   -0x1.6b2e08b1f3adfp-1,  -0x1.00672cp-2, INEXACT)
T(RN,  0x1.4196135018491p+953,   -0x1.1c2a42959002fp-2,  -0x1.a1b18ep-6, INEXACT)
T(RN,  0x1.a0ad962319406p+953,   -0x1.faca4689666a4p-2,  -0x1.bf9474p-3, INEXACT)
T(RN,  0x1.b31cc45af258ep+953,    0x1.a8e2a9c84f733p-1,  -0x1.d6a07ep-4, INEXACT)
T(RN,  0x1.297e4c23262d5p+953,   -0x1.7abfca497f86ap-4,  -0x1.332b76p-2, INEXACT)
T(RN,   0x1.9a341eefc19cp+953,   -0x1.78510a2f13e57p-8,  -0x1.9a8846p-6, INEXACT)
T(RN,  0x1.8ff7b0174db52p+953,   -0x1.4787b5a996586p-1,   0x1.bbdb92p-3, INEXACT)
T(RN,  0x1.6cec9905c862ep+953,   -0x1.c012468a3e404p-1,   0x1.ed08dcp-3, INEXACT)
T(RN,  0x1.5ae765bfb1335p+953,   -0x1.326fc897909a1p-1,   -0x1.da6fdp-2, INEXACT)
T(RN,  0x1.139a5cadcd498p+953,    -0x1.fbd16f2c5532p-1,   0x1.46d986p-2, INEXACT)
T(RN,  0x1.33ae2f3e8075ap+953,   -0x1.27a64119bae4dp-1,  -0x1.02f3e4p-4, INEXACT)
T(RN,  0x1.85735a585df0ep+954,    0x1.520dce104e622p-1,   -0x1.3a78bp-4, INEXACT)
T(RN,  0x1.d88402c5573b7p+954,    0x1.20a762598db0ep-1,  -0x1.6c5122p-2, INEXACT)
T(RN,  0x1.326b35f9c0e2ap+954,   -0x1.91b3160bf07d9p-3,   0x1.357234p-3, INEXACT)
T(RN,   0x1.add44a2657efp+954,     0x1.fff98b2eda1ap-1,  -0x1.42da9cp-7, INEXACT)
T(RN,  0x1.40f6cacef8defp+954,    0x1.af09669895d75p-1,  -0x1.b10ed2p-2, INEXACT)
T(RN,   0x1.c5901e5ff32fp+954,    0x1.e11e88f553e05p-1,   0x1.833fc2p-2, INEXACT)
T(RN,  0x1.b1b77dd76f248p+954,    0x1.d3e5a7c67fa6ap-2,  -0x1.ae6d3cp-2, INEXACT)
T(RN,  0x1.857cd8efbc778p+954,   -0x1.bbf47e16813d6p-1,   0x1.9d0ddap-2, INEXACT)
T(RN,  0x1.47fbb65021b26p+954,   -0x1.c94dcea0bdb7fp-1,  -0x1.7b23d4p-4, INEXACT)
T(RN,  0x1.adca111327c47p+954,    -0x1.60f2dc35b9edp-1,   0x1.b5f378p-2, INEXACT)
T(RN,  0x1.a1ac0043d2198p+955,   -0x1.fca8accc7bc97p-1,   -0x1.b7c58p-2, INEXACT)
T(RN,  0x1.f4e02f8fccc0ap+955,    0x1.b71ac1d03c096p-1,  -0x1.9cf806p-4, INEXACT)
T(RN,  0x1.6b980cfa65a52p+955,   -0x1.91964a83afe1ep-2,   0x1.b741e8p-2, INEXACT)
T(RN,  0x1.01603c261f073p+955,   -0x1.6e97590e1622cp-7,   0x1.a415d6p-2, INEXACT)
T(RN,  0x1.58ff84a4f70cap+955,   -0x1.cdcb47203a50ap-5,  -0x1.03562ep-2, INEXACT)
T(RN,  0x1.efa7e3857a876p+955,    0x1.afd52fdf152adp-3,  -0x1.9d1fb8p-4, INEXACT)
T(RN,   0x1.a9844ff4e317p+955,    0x1.72050b189c067p-1,  -0x1.67bce2p-3, INEXACT)
T(RN,  0x1.15da3e663128ap+955,     0x1.d2ee027b2736p-1,  -0x1.0fc446p-4, INEXACT)
T(RN,  0x1.ea1ce5ebdf4d7p+955,   -0x1.90eef54229427p-4,   0x1.2bc8a2p-3, INEXACT)
T(RN,   0x1.b17d8e5a1892p+955,   -0x1.fc270e8518adap-3,   0x1.e64fe8p-5, INEXACT)
T(RN,  0x1.a93a5c356dae3p+956,    0x1.c99b24f5ca7fbp-1,  -0x1.ff820ap-2, INEXACT)
T(RN,  0x1.1de34650192c4p+956,    0x1.2f3659b9f991ap-1,   0x1.6b475ap-2, INEXACT)
T(RN,  0x1.8a2c4f9ece3b9p+956,   -0x1.60b634a6230cfp-1,   0x1.3e7e9ep-2, INEXACT)
T(RN,  0x1.f10bdbe1a68b8p+956,   -0x1.07b1eb6e4a052p-2,   0x1.2b101cp-3, INEXACT)
T(RN,  0x1.f7c88fc1de264p+956,    -0x1.ece2db72929ep-1,   0x1.bb9f0cp-2, INEXACT)
T(RN,   0x1.59fc3c70bdcap+956,    0x1.f29411e700fc5p-1,  -0x1.41e846p-2, INEXACT)
T(RN,   0x1.c20867d75dbcp+956,   -0x1.2a54b2b14f9e7p-1,  -0x1.4505e6p-4, INEXACT)
T(RN,  0x1.e4a9a1dbd16b9p+956,   -0x1.16c3a1696e53ap-1,   0x1.8d98aap-2, INEXACT)
T(RN,  0x1.cf5021f5ba14bp+956,   -0x1.5b20ac5e8a2e9p-4,  -0x1.70d98cp-2, INEXACT)
T(RN,  0x1.eaf55b52deb54p+956,   -0x1.5e449a42e68ddp-1,    0x1.f2a6ap-4, INEXACT)
T(RN,  0x1.36f61ced6fe33p+957,   -0x1.7a65b12c1f589p-2,   0x1.f13d16p-2, INEXACT)
T(RN,  0x1.f62709030556cp+957,    0x1.d7cb7b3424af6p-1,  -0x1.bfee04p-2, INEXACT)
T(RN,  0x1.41b562d073d3ep+957,   -0x1.78c44645791adp-1,  -0x1.638a14p-8, INEXACT)
T(RN,  0x1.a8a3dee78b7f4p+957,   -0x1.0a761c8cb764ep-1,   -0x1.3c949p-3, INEXACT)
T(RN,   0x1.8430d4b88b97p+957,   -0x1.dfb5676b9723cp-1,  -0x1.863eaap-2, INEXACT)
T(RN,  0x1.1e987dfee1aacp+957,   -0x1.59f34223dcd24p-1,   0x1.1254b8p-2, INEXACT)
T(RN,  0x1.0596c5b14a1b9p+957,     0x1.05d3d67863d6p-1,  -0x1.31d38ep-2, INEXACT)
T(RN,  0x1.fd9ac1a7cb15ep+957,    -0x1.d5f25028f005p-1,  -0x1.721856p-3, INEXACT)
T(RN,   0x1.95879b5b8f6ap+957,   -0x1.bc593e73cccc2p-1,   0x1.cec502p-7, INEXACT)
T(RN,   0x1.a88df3d1b473p+957,   -0x1.e1f44d40e01a6p-1,  -0x1.a8021ap-2, INEXACT)
T(RN,  0x1.e4f08e474a617p+958,   -0x1.d6953e393b585p-1,  -0x1.ae3a4ap-2, INEXACT)
T(RN,  0x1.0070ff28f4fabp+958,   -0x1.8748413f1c362p-1,  -0x1.bf9d5ap-6, INEXACT)
T(RN,   0x1.fbba42b02531p+958,   -0x1.44bf39f715d7fp-1,  -0x1.a43e88p-2, INEXACT)
T(RN,  0x1.5672bf061d09ap+958,    0x1.78008d367286cp-2,    0x1.07678p-2, INEXACT)
T(RN,  0x1.80526987bc426p+958,   -0x1.786e8ab1bab9cp-1,   0x1.a4088ap-2, INEXACT)
T(RN,  0x1.142508666b2cep+958,    0x1.512852c0ae3cfp-4,    0x1.bd41ap-2, INEXACT)
T(RN,  0x1.c54717ba16f3ep+958,   -0x1.aebbcfb0b1883p-3,   0x1.ee30eep-2, INEXACT)
T(RN,  0x1.f68eb158dd2e6p+958,   -0x1.b2a4e9ef3d6e2p-2,   0x1.8f2cf6p-2, INEXACT)
T(RN,  0x1.d835f23011ffep+958,    0x1.ffa751bf5b272p-1,  -0x1.fda0aep-3, INEXACT)
T(RN,  0x1.2c67ea0b476cbp+958,   -0x1.acee6258b3307p-1,  -0x1.726f4ap-3, INEXACT)
T(RN,  0x1.da12ca30bc4abp+959,    0x1.39e335ad0685ep-8,   0x1.10675ap-2, INEXACT)
T(RN,  0x1.7baaeac72c702p+959,   -0x1.93f43133057b3p-3,  -0x1.fdc898p-2, INEXACT)
T(RN,  0x1.764669035d43ep+959,    0x1.0e0e790391594p-6,  -0x1.b70542p-2, INEXACT)
T(RN,  0x1.5d3c02ad40e84p+959,   -0x1.094b629b4d4cfp-1,  -0x1.cf1062p-4, INEXACT)
T(RN,  0x1.1b5b12c3ea4fbp+959,    0x1.de6054222d571p-1,   -0x1.fc404p-3, INEXACT)
T(RN,  0x1.46f417dcc83a6p+959,    0x1.b75e5e0881bc1p-1,   -0x1.42ac5p-2, INEXACT)
T(RN,  0x1.0fa613fc8e5aap+959,    0x1.50f1b56925318p-4,  -0x1.bff49cp-2, INEXACT)
T(RN,  0x1.8d763eef352ddp+959,    0x1.15e68db593707p-7,   0x1.2c4e84p-2, INEXACT)
T(RN,  0x1.e583d4d344c8ep+959,    0x1.9855f908a98c1p-1,   0x1.1a73d8p-3, INEXACT)
T(RN,  0x1.c70d07360873ep+959,    0x1.4337ec01c0a89p-1,   0x1.a21078p-3, INEXACT)
T(RN,  0x1.659e2b962be6ep+960,    0x1.685962ad5362dp-1,   0x1.893d42p-2, INEXACT)
T(RN,  0x1.97e6cbc058208p+960,   -0x1.ed3378e12330bp-1,    0x1.93ab3p-5, INEXACT)
T(RN,  0x1.66c7d1f353a73p+960,   -0x1.feb572af61e6ep-1,  -0x1.a161a4p-2, INEXACT)
T(RN,   0x1.f0a55f20aa2ap+960,    0x1.fe295a696841cp-1,  -0x1.42449p-10, INEXACT)
T(RN,  0x1.ae1c3a366ce58p+960,   -0x1.dd4a687a8ce56p-1,    0x1.afc6ep-3, INEXACT)
T(RN,  0x1.b4a29966d21e8p+960,   -0x1.6a00743a6591ap-2,  -0x1.865204p-3, INEXACT)
T(RN,  0x1.27472e964e7d6p+960,   -0x1.c2d1292305e8dp-4,   0x1.e219f4p-2, INEXACT)
T(RN,  0x1.2362e4756e589p+960,    0x1.5a3de2cad0c36p-1,  -0x1.e2219cp-2, INEXACT)
T(RN,  0x1.976996ca845f2p+960,    -0x1.cb62992fa39ep-1,   0x1.44f468p-2, INEXACT)
T(RN,  0x1.494087a82b7d3p+960,    0x1.f0a00e50aa7e8p-1,  -0x1.cb589cp-2, INEXACT)
T(RN,  0x1.fe79fbb2c78f2p+961,   -0x1.8d44ba743c9a5p-2,   0x1.22548ap-4, INEXACT)
T(RN,  0x1.d7634ec3b4f1ap+961,   -0x1.9f6b02d60c192p-1,   0x1.a8b11ep-2, INEXACT)
T(RN,  0x1.25226e6336e52p+961,   -0x1.5301d14a0974ep-1,   0x1.93a782p-2, INEXACT)
T(RN,  0x1.626d43b2ac788p+961,   -0x1.fefedac1768efp-3,  -0x1.c23542p-6, INEXACT)
T(RN,  0x1.0ef3ebd36648ep+961,    0x1.fff941d38186ep-1,   0x1.4ea842p-3, INEXACT)
T(RN,  0x1.db07115d4c88ep+961,   -0x1.57b8b5d5145e2p-1,   0x1.da2936p-2, INEXACT)
T(RN,  0x1.23db153398e28p+961,    0x1.4c9fe1062c249p-3,   0x1.fb2dbcp-9, INEXACT)
T(RN,  0x1.6b8dc435e5b82p+961,     0x1.a4fc8bc8d112p-1,  -0x1.57e832p-3, INEXACT)
T(RN,  0x1.5e0f2faf94c3ep+961,    0x1.b914f57209c68p-1,   0x1.8a2ef8p-4, INEXACT)
T(RN,  0x1.45e962ea1cac6p+961,   -0x1.33ef2acc3d44ap-6,   0x1.e79b36p-4, INEXACT)
T(RN,  0x1.a6b1a0cd34a12p+962,    0x1.80c7a1d5d43ecp-1,  -0x1.f93f1ep-2, INEXACT)
T(RN,  0x1.b7c854d3ced33p+962,    0x1.b893da2485565p-1,  -0x1.7f46eap-2, INEXACT)
T(RN,  0x1.d2844636e24dfp+962,   -0x1.302aa987b8fb3p-1,   0x1.c1fb4ep-2, INEXACT)
T(RN,  0x1.486ed9670cfdcp+962,    0x1.ed0baf339d52dp-1,  -0x1.9d11eep-2, INEXACT)
T(RN,  0x1.361fa4bc19a71p+962,    0x1.ca762bb2b4e79p-1,  -0x1.7a7312p-2, INEXACT)
T(RN,  0x1.f35082fe7535cp+962,   -0x1.1aa8160bf2bb9p-1,  -0x1.c2b70ap-4, INEXACT)
T(RN,  0x1.e788ff4116042p+962,    0x1.37be9a76cd87fp-3,  -0x1.bd8572p-2, INEXACT)
T(RN,  0x1.6e07089fcd6a9p+962,   -0x1.4a9cb52ad2005p-2,  -0x1.20787cp-3, INEXACT)
T(RN,  0x1.cca4c99e3c602p+962,    -0x1.508d3287d12ep-1,  -0x1.eabc08p-3, INEXACT)
T(RN,  0x1.a4137487c7e39p+962,   -0x1.dde17a81eb0bcp-1,  -0x1.621c5ap-3, INEXACT)
T(RN,  0x1.d1d073ec6c03ep+963,    0x1.41d2a79452796p-1,  -0x1.7371b4p-2, INEXACT)
T(RN,  0x1.28b73b3ed1898p+963,   -0x1.ff4ad0b657774p-1,  -0x1.7548dcp-3, INEXACT)
T(RN,  0x1.8ad173f421601p+963,    0x1.1e9ad4d36875bp-1,    0x1.689f5p-2, INEXACT)
T(RN,   0x1.4ce311677caap+963,    0x1.fff6a7b2e222fp-1,   0x1.2c6bd8p-4, INEXACT)
T(RN,  0x1.acf7203e30126p+963,   -0x1.090846c5b3751p-1,   -0x1.1ab2fp-3, INEXACT)
T(RN,  0x1.868c761b4ba58p+963,   -0x1.d2aee52ab2377p-1,   0x1.44c6d6p-5, INEXACT)
T(RN,  0x1.f31a186798cf8p+963,    0x1.21579c6defff1p-1,   0x1.85069ep-3, INEXACT)
T(RN,  0x1.f25bf47f05fd2p+963,    0x1.1bc2c9a1aca17p-2,  -0x1.ab5f22p-2, INEXACT)
T(RN,  0x1.2d197dc0f2b7ep+963,    -0x1.ea0ebc794c91p-1,   0x1.28d87ap-3, INEXACT)
T(RN,  0x1.666fcdbdd2496p+963,    0x1.78956f1988ac7p-1,   0x1.eb9b56p-4, INEXACT)
T(RN,  0x1.5d320133a04f8p+964,    0x1.1b252da36000fp-1,   0x1.9ab4b8p-4, INEXACT)
T(RN,  0x1.8a528ad96fdd3p+964,    -0x1.fc75135163a2p-3,  -0x1.9a2deap-3, INEXACT)
T(RN,  0x1.bf76ac283b8c2p+964,   -0x1.cc62323c245ffp-1,   0x1.55b68ep-2, INEXACT)
T(RN,  0x1.2f924652494dcp+964,   -0x1.dbd96cacbe71cp-2,    -0x1.d47dp-2, INEXACT)
T(RN,  0x1.b542a08d946a8p+964,   -0x1.9f9d5ee743729p-1,   0x1.891d6cp-2, INEXACT)
T(RN,  0x1.334912c20fd4ep+964,    0x1.373a2a9c50fe8p-1,  -0x1.921df2p-2, INEXACT)
T(RN,  0x1.961e39000669ep+964,    0x1.cdd7a3f76d061p-1,   0x1.a221e4p-3, INEXACT)
T(RN,  0x1.4a8b79ad63cbep+964,    0x1.38fa25bda727fp-1,   0x1.6b869cp-4, INEXACT)
T(RN,  0x1.e18ba54dd77e8p+964,    0x1.70cdc00f8afedp-1,  -0x1.1870d4p-2, INEXACT)
T(RN,  0x1.20ada2b741ac8p+964,   -0x1.94350d0df92b1p-2,   -0x1.8332ep-3, INEXACT)
T(RN,  0x1.c5ababca83b52p+965,    0x1.53dda2b073da1p-1,   0x1.d11944p-2, INEXACT)
T(RN,  0x1.c2e7673eecc38p+965,   -0x1.e2d96906d5b08p-1,   0x1.2b576ap-8, INEXACT)
T(RN,  0x1.1786d07700ea1p+965,    0x1.a47f05f294f04p-1,  -0x1.8ff608p-2, INEXACT)
T(RN,  0x1.d799a1839d14ep+965,   -0x1.ff12a3d201e64p-1,   0x1.830c46p-2, INEXACT)
T(RN,  0x1.143257e6ee379p+965,   -0x1.6250ea29b944cp-1,  -0x1.4d2bfcp-4, INEXACT)
T(RN,  0x1.2f52803a8450bp+965,   -0x1.82e0a296d114ap-1,  -0x1.f4fcf2p-2, INEXACT)
T(RN,  0x1.59a8b472dd076p+965,   -0x1.c8bfe8ed449a8p-1,   0x1.e34ec8p-2, INEXACT)
T(RN,  0x1.55176c94d0f77p+965,    0x1.aaae137487a82p-2,  -0x1.9e05d8p-2, INEXACT)
T(RN,   0x1.69e97e01e94cp+965,   -0x1.672d8f94a31a2p-2,  -0x1.3b3e0ap-2, INEXACT)
T(RN,  0x1.91557800fc53bp+965,   -0x1.c4f0ace398169p-3,   0x1.0cbe8ep-3, INEXACT)
T(RN,  0x1.24cef1b2d7322p+966,    0x1.00212dd3efedfp-1,    0x1.e8e67p-4, INEXACT)
T(RN,  0x1.f8571b2afa939p+966,    0x1.fe2699e310233p-1,   0x1.c788eap-4, INEXACT)
T(RN,  0x1.e9f31bc933dfep+966,   -0x1.faf3c9cf8ce53p-1,   0x1.830bb2p-3, INEXACT)
T(RN,  0x1.f96c5f9f0b9d2p+966,     0x1.f2e532e676bdp-1,  -0x1.bb76bep-5, INEXACT)
T(RN,  0x1.085cb6f212527p+966,    0x1.62ac4e2adda8cp-1,  -0x1.76c49cp-2, INEXACT)
T(RN,  0x1.170379580f4fdp+966,   -0x1.ee63cbcd67c88p-1,   0x1.0a1e3cp-3, INEXACT)
T(RN,  0x1.275a63389cc74p+966,    0x1.13a76e90eba6dp-3,   0x1.f996fep-2, INEXACT)
T(RN,  0x1.107f9535cde9ep+966,    0x1.cf847227a2f7fp-1,   0x1.6cfd0ap-5, INEXACT)
T(RN,  0x1.579de5f465cbep+966,    0x1.ffc14f2d74037p-1,  -0x1.c19014p-3, INEXACT)
T(RN,  0x1.3bbbef8f65278p+966,   -0x1.9c2c0b74f59d4p-1,  -0x1.90236cp-3, INEXACT)
T(RN,  0x1.5b746ffbb3766p+967,    -0x1.2a66347d5029p-1,   0x1.3c1282p-2, INEXACT)
T(RN,  0x1.40c983f577557p+967,   -0x1.9c429a8e7b62ap-1,  -0x1.45b454p-2, INEXACT)
T(RN,  0x1.288e28022003ep+967,    0x1.d78104b16792dp-1,  -0x1.85c874p-2, INEXACT)
T(RN,  0x1.01b3344c4f413p+967,    0x1.f5a9b2aab96b9p-1,  -0x1.f4c654p-3, INEXACT)
T(RN,  0x1.a10ce660a7239p+967,    0x1.0a7a22c7784ddp-2,    0x1.7085bp-2, INEXACT)
T(RN,  0x1.25c27681ee506p+967,    0x1.87680c2054b3fp-1,   0x1.c5f2b4p-4, INEXACT)
T(RN,  0x1.6eaebedc43c94p+967,    -0x1.8c286fa99e77p-2,  -0x1.296796p-3, INEXACT)
T(RN,  0x1.d134dcddd2798p+967,    0x1.458e87491e151p-3,  -0x1.b552fep-2, INEXACT)
T(RN,   0x1.401bd3c81f6bp+967,   -0x1.aacc238e53deep-1,    0x1.44241p-2, INEXACT)
T(RN,  0x1.9b8b6a284b1eep+967,   -0x1.2b79f28c4f11bp-2,   0x1.d6b8dep-5, INEXACT)
T(RN,  0x1.9ddf419684e17p+968,    0x1.d3ae785443cf2p-3,   -0x1.11859p-4, INEXACT)
T(RN,  0x1.72f9ccc902725p+968,   -0x1.e55b5a77c9366p-1,   -0x1.ada5cp-2, INEXACT)
T(RN,  0x1.b9129b988a6d8p+968,   -0x1.744e86115f9efp-1,  -0x1.b26746p-2, INEXACT)
T(RN,  0x1.89aad916c73a4p+968,   -0x1.25304fc9d427bp-7,   0x1.9c0a66p-3, INEXACT)
T(RN,  0x1.bc0c719a84472p+968,    0x1.8cb0c767dde9cp-1,    0x1.625cfp-2, INEXACT)
T(RN,  0x1.f28997987b7cbp+968,    0x1.c6bd6f2169d62p-1,  -0x1.9216bcp-2, INEXACT)
T(RN,  0x1.e1c3dec86546ep+968,    0x1.e137158573835p-1,   0x1.dbb1a4p-4, INEXACT)
T(RN,  0x1.8c90740bf5edfp+968,   -0x1.ff1afbd032a39p-1,   0x1.294124p-6, INEXACT)
T(RN,  0x1.f4824630807d6p+968,     0x1.ffeca324e1dep-1,  -0x1.da2768p-3, INEXACT)
T(RN,  0x1.55061f1323d96p+968,   -0x1.fff1da4d5d9c6p-1,   -0x1.c0fccp-3, INEXACT)
T(RN,  0x1.f9b9dc76cc166p+969,      -0x1.916ef8f6d2p-1,   -0x1.ef0f1p-3, INEXACT)
T(RN,  0x1.e87148f04f11ep+969,   -0x1.f1434ebb9de0ap-2,  -0x1.7ccbd6p-2, INEXACT)
T(RN,  0x1.02e6535917da4p+969,   -0x1.c7bff54ddb9f8p-2,  -0x1.026c02p-2, INEXACT)
T(RN,  0x1.67bf7bf5dca3fp+969,    0x1.468ed0ceb7cecp-2,  -0x1.785378p-3, INEXACT)
T(RN,  0x1.772e91e406c41p+969,    0x1.eca4bff151144p-1,  -0x1.b21586p-3, INEXACT)
T(RN,  0x1.e9a6399aaa6f5p+969,    0x1.f887dc53875bcp-3,   0x1.011264p-4, INEXACT)
T(RN,  0x1.4101a8fceac83p+969,   -0x1.fffab720286d8p-1,   0x1.53c36ep-2, INEXACT)
T(RN,  0x1.8f326890e8792p+969,   -0x1.ce822441a3618p-5,  -0x1.7c4984p-3, INEXACT)
T(RN,  0x1.d2d5241aaf9c8p+969,    0x1.6870daf93abefp-1,   0x1.32b19cp-2, INEXACT)
T(RN,  0x1.06723eb66fa1dp+969,   -0x1.7f1eaec5412b4p-1,    0x1.2faebp-2, INEXACT)
T(RN,  0x1.49010ead04795p+970,    0x1.1fcc32baeadd8p-1,  -0x1.59922ap-2, INEXACT)
T(RN,   0x1.b6a6a15f616dp+970,   -0x1.ff815b704c18bp-1,   0x1.da59b8p-3, INEXACT)
T(RN,  0x1.83b8b52b9ff78p+970,   -0x1.f25a870f238e2p-1,   0x1.1f1d24p-4, INEXACT)
T(RN,  0x1.4edd08ad1659ep+970,    0x1.ff36654a5bf65p-1,   -0x1.5a593p-2, INEXACT)
T(RN,  0x1.7483dc8562c13p+970,   -0x1.eff0cd8e97a8cp-1,   0x1.a2453cp-3, INEXACT)
T(RN,  0x1.cc8fd26bb245cp+970,   -0x1.c58cba31e86a8p-1,   0x1.8ce3eep-2, INEXACT)
T(RN,  0x1.436a388073779p+970,   -0x1.fae40d561fc16p-2,   0x1.d08d16p-2, INEXACT)
T(RN,  0x1.b4c697b2963eap+970,    0x1.ad8968b0cef9dp-3,   0x1.062f1cp-6, INEXACT)
T(RN,  0x1.62b85e33338e6p+970,    0x1.fc430c6d3e0f9p-1,  -0x1.94ad04p-5, INEXACT)
T(RN,  0x1.52823158f883cp+970,    0x1.e9b031a7f917ap-1,   0x1.c7262ep-4, INEXACT)
T(RN,  0x1.cf10be33a4b72p+971,    0x1.a76d3c63d4fd4p-5,  -0x1.d65af6p-4, INEXACT)
T(RN,  0x1.a89356b5366eap+971,   -0x1.ffee1230aaa0fp-1,   0x1.9fc6e4p-2, INEXACT)
T(RN,  0x1.46a649e496df3p+971,    0x1.837f195b62352p-1,  -0x1.e46e44p-3, INEXACT)
T(RN,  0x1.1ab81e92045e7p+971,   -0x1.f8e3e3b5a3507p-1,   0x1.a150aep-2, INEXACT)
T(RN,  0x1.7ace82c682e08p+971,    0x1.ee5e0c55b4486p-2,  -0x1.34e0b6p-3, INEXACT)
T(RN,  0x1.ed965964a114bp+971,   -0x1.c44bc5b66fe22p-2,    0x1.b1ee4p-2, INEXACT)
T(RN,  0x1.d609bbdec68cap+971,   -0x1.c22dd2c53107ap-2,   0x1.689ea8p-2, INEXACT)
T(RN,  0x1.81801b377883ap+971,    0x1.3db78f7199e8ep-2,  -0x1.df91b4p-2, INEXACT)
T(RN,  0x1.767230f3ab326p+971,    0x1.bd8b47d362ff2p-1,   0x1.d1c8acp-3, INEXACT)
T(RN,  0x1.980af8d00f0a2p+971,    0x1.ff29f96da145ap-1,  -0x1.edb766p-2, INEXACT)
T(RN,  0x1.ae374408c3552p+972,   -0x1.ed3315ade2e63p-1,   0x1.768c28p-5, INEXACT)
T(RN,  0x1.a41303c0ba788p+972,   -0x1.f340114f73503p-1,  -0x1.fa4222p-2, INEXACT)
T(RN,  0x1.b4e457aa78dcap+972,   -0x1.6fc75f77a521ap-1,    0x1.0796bp-4, INEXACT)
T(RN,  0x1.04385e3c9b487p+972,   -0x1.e8f7a974c3954p-1,   0x1.22e502p-2, INEXACT)
T(RN,  0x1.1cd944d98ddc4p+972,    0x1.99e371d1e1a8dp-1,  -0x1.90d64cp-2, INEXACT)
T(RN,  0x1.4f4ab13189a59p+972,    0x1.8418b95a6d20ap-1,  -0x1.e2fe18p-3, INEXACT)
T(RN,  0x1.9510d4f77f5fep+972,     0x1.6d30b804297dp-1,  -0x1.12500ep-4, INEXACT)
T(RN,  0x1.316242815d56cp+972,    0x1.fd1cc3eee043ep-1,   0x1.4406d8p-2, INEXACT)
T(RN,   0x1.b830549dd07ep+972,    0x1.d254a473aa26dp-1,   0x1.e66f88p-3, INEXACT)
T(RN,  0x1.7f7d9b95b2edcp+972,    0x1.f88a9219eb9c2p-1,    0x1.a0f02p-2, INEXACT)
T(RN,  0x1.7e9ea433c9ce2p+973,    0x1.7d17de5ffb462p-2,    0x1.2639fp-2, INEXACT)
T(RN,  0x1.4ddb5b0105549p+973,   -0x1.894d8d2f27fafp-1,    0x1.98284p-3, INEXACT)
T(RN,  0x1.5c6dc56d7c04fp+973,    -0x1.52db64dd8067p-2,  -0x1.bdbe6ep-3, INEXACT)
T(RN,  0x1.34f0cb6f555f1p+973,    0x1.30f148509b85bp-1,  -0x1.aed052p-2, INEXACT)
T(RN,  0x1.4533a3f743529p+973,   -0x1.2ea7f540ee877p-1,   -0x1.b49bap-2, INEXACT)
T(RN,  0x1.08a1dfa55c73ap+973,    0x1.16f01a902ef27p-1,  -0x1.eb784ep-3, INEXACT)
T(RN,   0x1.d435704e1a5dp+973,    0x1.fe6bcf3fd53ecp-1,   0x1.a14486p-2, INEXACT)
T(RN,  0x1.638f9c41db9d6p+973,    0x1.c95f119c84dabp-2,   0x1.5da7a2p-3, INEXACT)
T(RN,  0x1.8816fc847723ep+973,    0x1.36f35c17095b4p-2,   -0x1.4a217p-2, INEXACT)
T(RN,  0x1.2511d423ac905p+973,   -0x1.89e0664077bd6p-4,  -0x1.4080bap-2, INEXACT)
T(RN,  0x1.204197baaa197p+974,   -0x1.a4a233848ded3p-1,   0x1.6a5904p-2, INEXACT)
T(RN,  0x1.0f37305bedfecp+974,   -0x1.d038528889337p-1,  -0x1.68fb9ap-2, INEXACT)
T(RN,   0x1.1c198faa95adp+974,    0x1.fd25fb7a8a08ap-1,   0x1.5cfe02p-7, INEXACT)
T(RN,  0x1.23145b3174793p+974,   -0x1.bd0848e26d388p-2,   0x1.eabcd4p-3, INEXACT)
T(RN,  0x1.727335069809ap+974,    0x1.b4ee2624a36e5p-1,   0x1.3f5262p-3, INEXACT)
T(RN,  0x1.333f7663ffb72p+974,      0x1.f337be03ea6p-1,   0x1.d07e12p-2, INEXACT)
T(RN,  0x1.1f0ee05955354p+974,    0x1.28adb682ab943p-1,  -0x1.63830ap-3, INEXACT)
T(RN,  0x1.631ac4001e0e7p+974,   -0x1.f976aa8b2910cp-1,  -0x1.3072f2p-5, INEXACT)
T(RN,  0x1.8fa45a893680ep+974,    0x1.ab02d114758a2p-1,   0x1.0359fep-3, INEXACT)
T(RN,  0x1.0ceae6dcdc9d9p+974,   -0x1.ffec35e536a9bp-1,  -0x1.0dde46p-2, INEXACT)
T(RN,  0x1.370cc9eec50f8p+975,   -0x1.cf7d738719e84p-1,    0x1.9b3adp-6, INEXACT)
T(RN,  0x1.c7229b19b2c7fp+975,    0x1.bcdc807aa29dfp-2,  -0x1.78f2f6p-2, INEXACT)
T(RN,  0x1.ee7698582b586p+975,    0x1.3035af5a3ea86p-1,   0x1.9b151cp-7, INEXACT)
T(RN,  0x1.5ad9e99523c61p+975,   -0x1.0a53539c71feap-1,  -0x1.c97916p-2, INEXACT)
T(RN,  0x1.9e1aa49d8ec96p+975,    -0x1.ffe162250408p-5,   0x1.bcf086p-3, INEXACT)
T(RN,   0x1.ae849ee001adp+975,   -0x1.84ddbe08461f2p-2,  -0x1.7ca0bp-11, INEXACT)
T(RN,  0x1.7b7a80f8e4bccp+975,   -0x1.ff4ab4f6f3464p-1,   0x1.b609f2p-5, INEXACT)
T(RN,  0x1.0b4d440e529efp+975,    0x1.f79f4d0877bedp-1,    0x1.b7d8cp-3, INEXACT)
T(RN,  0x1.1e3ae0ae3f388p+975,    0x1.cd681c52e1b8cp-1,  -0x1.e53374p-3, INEXACT)
T(RN,  0x1.02862e78de07cp+975,    0x1.6b46a8488caabp-3,   0x1.357e3ap-2, INEXACT)
T(RN,  0x1.be91c608f3145p+976,   -0x1.55006e6921458p-1,  -0x1.a80152p-4, INEXACT)
T(RN,  0x1.793bb52e4f80ap+976,   -0x1.0b7176a13d1c7p-1,   0x1.9a5b64p-3, INEXACT)
T(RN,  0x1.9c1a0260d7ad9p+976,    0x1.e3ab7afd1da9ep-2,  -0x1.711558p-2, INEXACT)
T(RN,  0x1.312a6252e4ad7p+976,    0x1.e36e2236bb27bp-2,   0x1.60ab3ep-3, INEXACT)
T(RN,  0x1.63341547c8206p+976,   -0x1.5b276a161685ep-2,  -0x1.7cd1cep-3, INEXACT)
T(RN,  0x1.0e1a2ca8de638p+976,   -0x1.3f46d5304a476p-5,  -0x1.f72e54p-3, INEXACT)
T(RN,  0x1.0107f92d5e895p+976,    0x1.6f376593556e9p-1,  -0x1.5b99dep-2, INEXACT)
T(RN,  0x1.b56867b94d795p+976,    0x1.c57af4da398aep-2,  -0x1.0d1692p-3, INEXACT)
T(RN,  0x1.e3e529a853c62p+976,    0x1.ad9b64ee2648fp-3,  -0x1.5d1f9ep-2, INEXACT)
T(RN,  0x1.6a6f33864096dp+976,    0x1.dd956fe694f5ap-1,  -0x1.ca86d2p-2, INEXACT)
T(RN,  0x1.dd2343dc743c3p+977,   -0x1.ffc3bd44f9b91p-1,   0x1.018368p-4, INEXACT)
T(RN,   0x1.b31fe5dfc8a7p+977,    0x1.3692c96ce778cp-2,   0x1.a5ab44p-5, INEXACT)
T(RN,  0x1.f70be434c888ep+977,    0x1.ffb4c24fef932p-1,   -0x1.49e63p-2, INEXACT)
T(RN,  0x1.f533499280b05p+977,   -0x1.b0ac5b0aea723p-5,  -0x1.fdac9ep-2, INEXACT)
T(RN,   0x1.bc54830122d4p+977,    0x1.094f4f8ed13a8p-2,   0x1.21a2a6p-2, INEXACT)
T(RN,  0x1.6ecd592c9235ep+977,   -0x1.f9e09db7deeb6p-1,  -0x1.3fc35cp-4, INEXACT)
T(RN,  0x1.aab3bff50ae1cp+977,    0x1.fd5ea60828bfdp-1,  -0x1.bf3c52p-4, INEXACT)
T(RN,  0x1.ea9cf8b781814p+977,    0x1.ffb327963d283p-2,   0x1.f99658p-3, INEXACT)
T(RN,  0x1.8b4213234c3d1p+977,    0x1.1a7ef626bb2acp-4,   0x1.98811ep-2, INEXACT)
T(RN,  0x1.300b866c8c41bp+977,   -0x1.ff488523900c3p-1,  -0x1.215276p-2, INEXACT)
T(RN,  0x1.cefe353fce4e8p+978,    -0x1.36c8341aa2dcp-3,   0x1.4aa59cp-3, INEXACT)
T(RN,    0x1.e77df1353dbp+978,    0x1.2d320a3f62e54p-2,  -0x1.a3bb6ap-3, INEXACT)
T(RN,   0x1.981e2d2c6066p+978,   -0x1.42a41d5604b7fp-1,   0x1.7dc236p-2, INEXACT)
T(RN,  0x1.9b4201e8b7054p+978,   -0x1.320619ab6c575p-2,   0x1.b08696p-3, INEXACT)
T(RN,  0x1.c9aec22181e28p+978,   -0x1.3b8db2f498efbp-1,  -0x1.c9c3a6p-2, INEXACT)
T(RN,  0x1.352b7ea215facp+978,   -0x1.6b9b2b0678e8bp-2,   -0x1.6d85ep-3, INEXACT)
T(RN,  0x1.53a6dbf617f47p+978,    0x1.efe4387cadd67p-1,  -0x1.135b92p-5, INEXACT)
T(RN,  0x1.e0981a99029bdp+978,   -0x1.367eb16afd8b9p-1,  -0x1.53e558p-5, INEXACT)
T(RN,  0x1.a8d2d0f84f0f7p+978,   -0x1.f930748889e2fp-1,   0x1.51b79ep-2, INEXACT)
T(RN,  0x1.8ecdbe7f72d76p+978,   -0x1.42e62b5c5702ap-2,   0x1.641d76p-2, INEXACT)
T(RN,  0x1.00e30ae021ddcp+979,   -0x1.81c5718d6ba9ep-2,   0x1.dcc5d8p-4, INEXACT)
T(RN,  0x1.3c6a478b60765p+979,   -0x1.670abaefc3532p-2,  0x1.2fbc44p-10, INEXACT)
T(RN,  0x1.13801d1e97491p+979,    0x1.ffd5fec671f07p-1,   0x1.8484bep-2, INEXACT)
T(RN,   0x1.781cc1eafd78p+979,    0x1.f0f824d4a8cdbp-1,   0x1.4cb0f6p-2, INEXACT)
T(RN,  0x1.01f183ea81e4ep+979,   -0x1.f5324952af645p-2,  -0x1.ee6bacp-2, INEXACT)
T(RN,  0x1.9c9dab0435c6cp+979,   -0x1.31247cd305e98p-6,  -0x1.f639eap-3, INEXACT)
T(RN,  0x1.f6516d8ceab21p+979,    0x1.1e9ebfd015634p-2,  -0x1.abb5e8p-5, INEXACT)
T(RN,  0x1.215f8097ac036p+979,    0x1.cd28de61bc472p-1,   0x1.ecc454p-6, INEXACT)
T(RN,  0x1.650debbc350d8p+979,   -0x1.f65ee6e033c1fp-1,    0x1.f4acbp-7, INEXACT)
T(RN,  0x1.97f754baa46b6p+979,    0x1.c464d9a7f799dp-4,   0x1.766076p-2, INEXACT)
T(RN,  0x1.a485a4ff5806fp+980,   -0x1.470fd37c7f29cp-3,  -0x1.3744bcp-2, INEXACT)
T(RN,  0x1.1bed4b7bbb1b6p+980,    0x1.1c14a27551f2cp-1,  -0x1.4119dcp-2, INEXACT)
T(RN,  0x1.c85d3bf22c15ap+980,    0x1.139a341190fd7p-1,  -0x1.e83c98p-2, INEXACT)
T(RN,  0x1.a21a06de24bdbp+980,   -0x1.ffe80d8c3cd93p-1,  -0x1.f3fd38p-2, INEXACT)
T(RN,  0x1.2d995095634e2p+980,   -0x1.4478fd77e2f37p-1,  -0x1.784728p-3, INEXACT)
T(RN,  0x1.2fccd4aca7b6ap+980,   -0x1.12b84a3f18f6fp-1,   0x1.6d334cp-2, INEXACT)
T(RN,  0x1.ba42de7572118p+980,    0x1.4711986e0e8e9p-1,    0x1.1cd82p-2, INEXACT)
T(RN,  0x1.948c68b8b6196p+980,    0x1.d85f4340a097p-15,  -0x1.3a70c8p-3, INEXACT)
T(RN,  0x1.3a05ec14a2e13p+980,   -0x1.ba140bca16412p-1,  -0x1.d07ceap-3, INEXACT)
T(RN,   0x1.01ec5c8063f8p+980,   -0x1.b0e7fa0ee254cp-2,  -0x1.b7e52ep-3, INEXACT)
T(RN,  0x1.4a33c8983cdacp+981,   -0x1.4898ee4b50344p-1,   0x1.c93fdcp-4, INEXACT)
T(RN,  0x1.6369b871643f2p+981,   -0x1.484a7f2db561fp-1,  -0x1.3cfbbcp-3, INEXACT)
T(RN,  0x1.d017273a9141ap+981,   -0x1.f10bc17c5c029p-1,  -0x1.e80364p-3, INEXACT)
T(RN,  0x1.f75cf26877425p+981,    0x1.e80678b91f921p-1,   0x1.d585ccp-3, INEXACT)
T(RN,  0x1.bf9a7b3a120fcp+981,    0x1.442e091aabf99p-1,   0x1.65b488p-2, INEXACT)
T(RN,  0x1.5ee6f1d0718f6p+981,   -0x1.9349f051bf5c2p-1,  -0x1.681636p-2, INEXACT)
T(RN,  0x1.9d5cf559ddf58p+981,   -0x1.5230fb434d9f9p-1,   0x1.969ba2p-3, INEXACT)
T(RN,  0x1.072c1d12fbdb4p+981,    0x1.fcd77937a4782p-1,  -0x1.2d2e12p-5, INEXACT)
T(RN,  0x1.f5c65ecca4fdep+981,   -0x1.6281282ad8cc2p-1,   -0x1.e9fe1p-3, INEXACT)
T(RN,  0x1.7655d1e84cf6cp+981,     0x1.f1c80c9ef719p-4,   0x1.079666p-6, INEXACT)
T(RN,  0x1.51187b4746802p+982,    0x1.fcb97eaaeba4cp-1,   0x1.d7e408p-4, INEXACT)
T(RN,  0x1.07d76b5d154bdp+982,    0x1.1fbfad911d3b2p-2,  -0x1.ffb7a6p-2, INEXACT)
T(RN,  0x1.e65553f2749e6p+982,    0x1.f39ba859a1e01p-1,   0x1.31b70ep-2, INEXACT)
T(RN,   0x1.835c3c0a2c0fp+982,   -0x1.e5cb4e8b76716p-2,  -0x1.c5eb38p-6, INEXACT)
T(RN,  0x1.96bb070cfb3fcp+982,   -0x1.a20dbab076f3fp-1,  -0x1.d07b7cp-3, INEXACT)
T(RN,  0x1.82e8563fcb694p+982,   -0x1.4dcf408b73d67p-1,   0x1.f9b5b6p-2, INEXACT)
T(RN,  0x1.dc76df868d797p+982,    0x1.d440da6e5f739p-1,   0x1.2ce224p-2, INEXACT)
T(RN,  0x1.7b428fe529d39p+982,    0x1.82128bee22e82p-3,  -0x1.9ff344p-2, INEXACT)
T(RN,  0x1.b1f08ebe898acp+982,   -0x1.fc68a674c5ea4p-1,   0x1.5e5592p-3, INEXACT)
T(RN,  0x1.28a9fc6193a3dp+982,    0x1.79758989b5296p-2,  -0x1.66c82ep-3, INEXACT)
T(RN,  0x1.2515951d840a1p+983,    0x1.f7620e099875ep-1,  -0x1.2f5e2ep-3, INEXACT)
T(RN,  0x1.16bf250574032p+983,    0x1.ba363e679aa2ep-1,   0x1.b28bdap-2, INEXACT)
T(RN,  0x1.a094491f3f48ap+983,   -0x1.6cf388a701117p-1,   -0x1.ea422p-4, INEXACT)
T(RN,   0x1.35ca2ce7f989p+983,    0x1.5943bcb5c3118p-1,  -0x1.c430bep-2, INEXACT)
T(RN,   0x1.0736ace25debp+983,    0x1.f7866864bfe78p-1,   0x1.472ebap-3, INEXACT)
T(RN,  0x1.ab4f86c78bfb2p+983,    0x1.dfc8c8ca88caep-1,  -0x1.cc8656p-2, INEXACT)
T(RN,  0x1.df7846c58a98dp+983,    0x1.215a347901a79p-7,   0x1.379d0cp-3, INEXACT)
T(RN,  0x1.d508003b5261dp+983,    0x1.5836aa3e38896p-1,   0x1.845f6cp-4, INEXACT)
T(RN,  0x1.65d517915b209p+983,    0x1.fdc20efd91637p-1,   0x1.5152fep-2, INEXACT)
T(RN,  0x1.ae42b7fc2331ap+983,   -0x1.fb7b914f34f37p-1,   0x1.19b596p-4, INEXACT)
T(RN,  0x1.941e22a72c3a6p+984,    0x1.fffddf834dbb7p-1,  -0x1.0f8d78p-3, INEXACT)
T(RN,   0x1.f1061f441444p+984,   -0x1.95ecfeb235a09p-1,  -0x1.1ed094p-2, INEXACT)
T(RN,  0x1.7f1b4839f94eep+984,    0x1.b343efd3126dbp-2,   0x1.3ead06p-2, INEXACT)
T(RN,  0x1.46374043a14c4p+984,    0x1.02309ac041f1ap-3,  -0x1.d2d93ap-3, INEXACT)
T(RN,  0x1.9f9154d9823e7p+984,     0x1.c951431419e2p-1,   0x1.986b18p-3, INEXACT)
T(RN,  0x1.c9e6c84a50063p+984,    0x1.fbde8a86f659ep-1,  -0x1.1c2c28p-2, INEXACT)
T(RN,  0x1.93e513f9f8d3ap+984,    0x1.a6b933d9c6fbap-1,   0x1.81f526p-4, INEXACT)
T(RN,  0x1.4e765dd81f76ap+984,    0x1.7a16aef37dac3p-1,   0x1.223578p-2, INEXACT)
T(RN,  0x1.1f0665569362ep+984,   -0x1.357c8be3ad9a3p-1,  -0x1.3cc1ccp-2, INEXACT)
T(RN,  0x1.36405ccaa3defp+984,   -0x1.f03b5291efb53p-1,  -0x1.60a188p-2, INEXACT)
T(RN,  0x1.57c954f69a7bcp+985,   -0x1.1cd492d1af1ffp-1,   0x1.05a1a4p-2, INEXACT)
T(RN,  0x1.5fbc6df6d66f7p+985,   -0x1.83c945db13a0dp-4,  -0x1.9fe3bep-2, INEXACT)
T(RN,  0x1.5f9048f29dd76p+985,    0x1.f1953f4a3bfe7p-1,   0x1.6b5bd6p-2, INEXACT)
T(RN,  0x1.0ce28c3caf156p+985,     0x1.0a924ae3d3d7p-1,  -0x1.430648p-4, INEXACT)
T(RN,  0x1.12808aaede37fp+985,    0x1.ffab149aaa791p-1,  -0x1.b4cca8p-2, INEXACT)
T(RN,  0x1.ea50c18577c0bp+985,    0x1.08870f461a7aap-3,   0x1.1adbfep-3, INEXACT)
T(RN,  0x1.fea5c90ad8c8ep+985,   -0x1.b899c07bf201ap-3,   0x1.eb9bc8p-3, INEXACT)
T(RN,  0x1.13a05ec6533f6p+985,    -0x1.c18c6ae87bcdp-3,   0x1.b6ba1ep-2, INEXACT)
T(RN,  0x1.be2d01daa2b6cp+985,   -0x1.45fada36166a5p-1,  -0x1.2fd70ep-2, INEXACT)
T(RN,  0x1.a08c04fe151a2p+985,    0x1.f2b1588f6da92p-1,   0x1.7ad5f8p-2, INEXACT)
T(RN,  0x1.1702da5d08ca4p+986,   -0x1.b449e71556eedp-6,   0x1.c697b2p-2, INEXACT)
T(RN,   0x1.fe89b636229dp+986,    0x1.fc02383f6b082p-2,   0x1.df7d48p-2, INEXACT)
T(RN,  0x1.e02e3ef7e101dp+986,   -0x1.f043356f243d1p-1,   0x1.e2456ep-7, INEXACT)
T(RN,   0x1.81d17327eb1cp+986,   -0x1.28c167742d37ep-1,   -0x1.6ed34p-2, INEXACT)
T(RN,  0x1.53c26a7a9c1bfp+986,    0x1.b66ba9eaf8d6ep-1,   0x1.144316p-2, INEXACT)
T(RN,  0x1.f21052ca6d584p+986,   -0x1.fff92ee05cfd9p-1,   0x1.35c55ap-4, INEXACT)
T(RN,  0x1.c6d392355241ap+986,   -0x1.d73271b5b1e47p-1,   0x1.62b4d8p-3, INEXACT)
T(RN,  0x1.a8c53ae0e4cb7p+986,    0x1.171ac7297d41bp-1,  -0x1.a242e2p-2, INEXACT)
T(RN,  0x1.12b33371ecb45p+986,    0x1.b57ca78c61cdep-1,   0x1.593e24p-2, INEXACT)
T(RN,  0x1.e8c8593a83d7ap+986,   -0x1.fed77ff9070e7p-1,   0x1.690a42p-2, INEXACT)
T(RN,  0x1.57cbd4548de23p+987,    0x1.a8ae13254067fp-1,    0x1.fe969p-3, INEXACT)
T(RN,  0x1.03bf99a6ed203p+987,    0x1.c49f34311a98dp-2,  -0x1.867beep-3, INEXACT)
T(RN,  0x1.22caed6c1e652p+987,   -0x1.7d10f257e234fp-2,   0x1.682a4ap-2, INEXACT)
T(RN,  0x1.9cd8250f7845dp+987,    0x1.eeb653231c56cp-1,   0x1.a5ac2ep-2, INEXACT)
T(RN,  0x1.f61c55c33149cp+987,    0x1.a7ca194bd7e45p-2,  -0x1.60388ap-2, INEXACT)
T(RN,  0x1.83158f89e53d6p+987,    0x1.39aef4ca6005cp-3,   0x1.3a4b5cp-5, INEXACT)
T(RN,  0x1.7609ce9bfc5cfp+987,    0x1.d568d71ba3bb3p-1,  -0x1.69e5dap-3, INEXACT)
T(RN,  0x1.d1cb600d7299cp+987,    0x1.640dc492858b1p-2,    0x1.e1732p-4, INEXACT)
T(RN,  0x1.db4532438bdc6p+987,    0x1.ecb6d3e44297ep-1,    0x1.e9ed1p-3, INEXACT)
T(RN,  0x1.1370ab100e7d2p+987,    0x1.78b812586bd31p-1,   0x1.e2a8bep-2, INEXACT)
T(RN,  0x1.81e6bf4ebb1bfp+988,    0x1.f96973bd37686p-1,   0x1.70c836p-2, INEXACT)
T(RN,  0x1.ca35179ad4bbap+988,    0x1.d9c05af085c58p-1,   -0x1.e7b88p-9, INEXACT)
T(RN,  0x1.a9fed72ccc45ap+988,   -0x1.6987ee594d404p-1,  -0x1.060e52p-3, INEXACT)
T(RN,  0x1.8379bea4bfd8ep+988,   -0x1.a53fb3733faa4p-5,  -0x1.e3f11ap-2, INEXACT)
T(RN,  0x1.287e4e342463bp+988,   -0x1.c0d96d6dabf54p-1,  -0x1.a3ef0cp-2, INEXACT)
T(RN,   0x1.f0d6ad0af004p+988,   -0x1.2428719a6d3d8p-1,  -0x1.f34c68p-2, INEXACT)
T(RN,  0x1.53a0838f5b462p+988,    0x1.7dac22e90a39bp-1,   0x1.2dbffcp-4, INEXACT)
T(RN,  0x1.3ff71f125bf28p+988,    0x1.9f2a8a8746937p-7,  -0x1.3d3e06p-4, INEXACT)
T(RN,  0x1.31525190658e6p+988,   -0x1.fbef787a9df01p-1,  -0x1.a5fc18p-5, INEXACT)
T(RN,  0x1.a1700e1d0f96dp+988,    0x1.2c0e0900a02ebp-1,   0x1.2afa16p-2, INEXACT)
T(RN,  0x1.94a0f1e813baap+989,    0x1.cda26e599ac7cp-1,   0x1.f8887ap-2, INEXACT)
T(RN,  0x1.7e7895bf3154bp+989,    0x1.d49dc5cd14f25p-1,  -0x1.d27e08p-2, INEXACT)
T(RN,  0x1.8aec083d9fd16p+989,    0x1.d50d96315f312p-2,  -0x1.d1be04p-2, INEXACT)
T(RN,  0x1.1e2f10a4e98e6p+989,    0x1.9132870518ba3p-1,   0x1.61119ep-2, INEXACT)
T(RN,  0x1.fad22f3c8b0f4p+989,   -0x1.c40a5a2bd0402p-1,   0x1.a0e872p-2, INEXACT)
T(RN,  0x1.cf7bf88b6386ep+989,   -0x1.44e06d9a36b38p-1,  -0x1.64774ap-2, INEXACT)
T(RN,  0x1.2991162a21be7p+989,    0x1.a9fa968b62f59p-1,   0x1.8a9342p-3, INEXACT)
T(RN,  0x1.6bf9d45c434eap+989,    0x1.1cf6a90307716p-4,   -0x1.68888p-4, INEXACT)
T(RN,  0x1.15e1df3e8527cp+989,    0x1.7f1cc19bf00d2p-1,   -0x1.42b47p-3, INEXACT)
T(RN,  0x1.df04359111874p+989,   -0x1.173684168318ep-1,   0x1.1d4072p-2, INEXACT)
T(RN,  0x1.0facd0e4e2452p+990,   -0x1.6ba010ff843aep-1,   0x1.89b2a4p-2, INEXACT)
T(RN,  0x1.47e8ecff1e259p+990,    0x1.674c6e7aa7cbbp-2,   0x1.738bb2p-2, INEXACT)
T(RN,  0x1.dc3306548b5b6p+990,    0x1.4bc4d6b4132f4p-1,  -0x1.8894c2p-7, INEXACT)
T(RN,  0x1.141b498dde47ap+990,   -0x1.d5c77d761b51fp-3,   0x1.eccc42p-2, INEXACT)
T(RN,  0x1.4560277d56866p+990,   -0x1.6b104ea090516p-2,   0x1.5d2856p-6, INEXACT)
T(RN,  0x1.738c3b9274018p+990,    0x1.0f357ea4cddb9p-2,   0x1.df48e2p-3, INEXACT)
T(RN,  0x1.4864b998c1087p+990,     0x1.734ca3284b91p-1,   0x1.189dcap-2, INEXACT)
T(RN,  0x1.9d4fd41353c1fp+990,    0x1.6e13adff8dcedp-1,   0x1.60b14ap-2, INEXACT)
T(RN,  0x1.a8fb94927ef1cp+990,    0x1.3d68f4a03e1b8p-2,   0x1.719e58p-3, INEXACT)
T(RN,  0x1.038b02d38b5e9p+990,    0x1.ca9428aaeedf9p-1,  -0x1.27de96p-2, INEXACT)
T(RN,  0x1.a593a952d6d9ap+991,   -0x1.222c82ba63b75p-1,   0x1.c87ac8p-2, INEXACT)
T(RN,  0x1.5e321c795899ep+991,   -0x1.75199db78ddd8p-1,    0x1.b82c8p-4, INEXACT)
T(RN,  0x1.3b3624a5fe248p+991,    0x1.935c10ef5263bp-2,    0x1.f12edp-2, INEXACT)
T(RN,  0x1.0a2a06353292ap+991,   -0x1.7aa52952e8c28p-1,  -0x1.183c8ep-2, INEXACT)
T(RN,  0x1.6a3f3bfcf58d2p+991,   -0x1.e0f03fb1fbc16p-2,  -0x1.e2ad02p-5, INEXACT)
T(RN,    0x1.8f782e0f51bp+991,   -0x1.6ecacbd4bb876p-2,   0x1.bf9c2cp-2, INEXACT)
T(RN,  0x1.b848310fd5ca6p+991,   -0x1.3119976a9fa0ep-1,   0x1.36feeap-3, INEXACT)
T(RN,  0x1.9e4abce769fdcp+991,    0x1.f945084ca6839p-1,  -0x1.c94edep-2, INEXACT)
T(RN,  0x1.04a1317f55f4cp+991,   -0x1.a00347303450bp-2,   0x1.512a1ap-2, INEXACT)
T(RN,  0x1.000e34f27230fp+991,    0x1.714152433583fp-1,  -0x1.59376cp-2, INEXACT)
T(RN,  0x1.a4d7c8f2d767fp+992,   -0x1.a4bd8f1157222p-5,  -0x1.b52234p-2, INEXACT)
T(RN,  0x1.2d8f613ef7028p+992,    -0x1.796e86c54f94p-1,  -0x1.cb3394p-3, INEXACT)
T(RN,  0x1.a36b1200e07b5p+992,    0x1.b83e3920e183ep-1,  -0x1.6b5a0cp-2, INEXACT)
T(RN,  0x1.a1111569aa8fcp+992,   -0x1.c7f2b04faada9p-1,   0x1.753d54p-2, INEXACT)
T(RN,  0x1.3879a9daefc6dp+992,    -0x1.3ad68dab6346p-1,  -0x1.d19a24p-2, INEXACT)
T(RN,  0x1.5e23294d3eca6p+992,   -0x1.6371d22d2bc41p-2,  -0x1.35a1bep-4, INEXACT)
T(RN,  0x1.658a65ee3a538p+992,   -0x1.d6ea04fdb5a07p-1,  -0x1.df3a06p-2, INEXACT)
T(RN,   0x1.859911dcc6cdp+992,   -0x1.949994c4de752p-1,  -0x1.49470cp-3, INEXACT)
T(RN,  0x1.8527a2c2bb042p+992,    0x1.ffc7b24ae322bp-1,  -0x1.993e0ep-3, INEXACT)
T(RN,   0x1.6cace8691227p+992,   -0x1.e5a77a2219ec6p-2,   0x1.e04036p-3, INEXACT)
T(RN,  0x1.04cfbbaaa85b6p+993,   -0x1.f60fd34fa14c2p-1,  -0x1.36ab16p-2, INEXACT)
T(RN,  0x1.effadbb7aa3a9p+993,    0x1.e6e4806d9ad18p-1,  -0x1.8a3048p-2, INEXACT)
T(RN,  0x1.f194c56204c24p+993,   -0x1.18e3aa3254c5cp-1,  -0x1.87308ap-2, INEXACT)
T(RN,  0x1.15f6b7fa65635p+993,   -0x1.ee04c4519f929p-1,   0x1.3a714ap-4, INEXACT)
T(RN,  0x1.37e8aba752b62p+993,    0x1.cd56e494199dcp-1,   0x1.4cab8cp-3, INEXACT)
T(RN,  0x1.2d62c298147a7p+993,   -0x1.d43ceb6c58826p-2,  -0x1.153fdap-2, INEXACT)
T(RN,  0x1.318baf082411ep+993,   -0x1.366616e7c31abp-1,   0x1.f0742cp-2, INEXACT)
T(RN,  0x1.583fdd956041cp+993,    0x1.e4a56943f9772p-4,   0x1.ccbd76p-5, INEXACT)
T(RN,  0x1.c710bbb86bf04p+993,    0x1.698b480c3ca66p-1,  -0x1.afa7aep-2, INEXACT)
T(RN,  0x1.58e94280f1b3ep+993,    0x1.f211e05479b92p-1,  -0x1.60647p-10, INEXACT)
T(RN,  0x1.3a1f73abeafe6p+994,    0x1.590c1b3f63712p-2,   -0x1.c375bp-3, INEXACT)
T(RN,   0x1.8e449917b565p+994,    0x1.03b63c8aeeb9fp-3,  -0x1.c96d2ap-6, INEXACT)
T(RN,  0x1.d3580f8a5a992p+994,   -0x1.9febab25f3b0bp-2,  -0x1.1b43bep-3, INEXACT)
T(RN,  0x1.9b13bcbc5dbd7p+994,   -0x1.ad0cc2a012eecp-1,    0x1.d5d52p-3, INEXACT)
T(RN,  0x1.eb68a0584cec4p+994,    0x1.9dd1c14b5cc25p-3,  -0x1.3c2742p-3, INEXACT)
T(RN,  0x1.c7f427d249e27p+994,    0x1.e5d6698fc32b7p-2,   0x1.4027e2p-2, INEXACT)
T(RN,  0x1.ae429f7736908p+994,   -0x1.54557fa180bffp-1,  -0x1.03e5a2p-7, INEXACT)
T(RN,  0x1.8dd463dbe49f3p+994,    0x1.bc5dd1f1b9b7ep-3,  -0x1.4c7276p-2, INEXACT)
T(RN,  0x1.0b66bcbe421d8p+994,   -0x1.7c2c9d698718ep-4,  -0x1.e1a3f8p-3, INEXACT)
T(RN,  0x1.a6c0a6da7a685p+994,    0x1.debbdf758b662p-1,  -0x1.bdc144p-5, INEXACT)
T(RN,  0x1.924b90992187cp+995,   -0x1.60ab60b8fa619p-1,   0x1.1e5542p-2, INEXACT)
T(RN,  0x1.445b0a1fdd282p+995,    0x1.f21cfd38e7b25p-1,   0x1.d88798p-3, INEXACT)
T(RN,   0x1.79d101a7912dp+995,    0x1.1665a65a6990fp-2,  -0x1.ebb3a6p-2, INEXACT)
T(RN,  0x1.e79461e9381a2p+995,   -0x1.a6bc2efcaf269p-1,  -0x1.572c28p-2, INEXACT)
T(RN,   0x1.59a2c4c18863p+995,    0x1.2d014e0fcb98dp-1,   0x1.b1c164p-2, INEXACT)
T(RN,  0x1.cf45943640dc1p+995,   -0x1.b5a14424a0cb6p-1,  -0x1.ed5656p-2, INEXACT)
T(RN,  0x1.35fed070cc8ffp+995,    0x1.7a9b42324c47dp-6,  -0x1.31b468p-2, INEXACT)
T(RN,  0x1.87a51281cfb7ap+995,   -0x1.04eb330554e2dp-1,   0x1.8b231cp-2, INEXACT)
T(RN,  0x1.ed06a1eeae74ap+995,   -0x1.fd73102e6f5eep-1,  -0x1.1df5e2p-4, INEXACT)
T(RN,  0x1.f914a32a64668p+995,    0x1.fed5bd12ec5f9p-1,  -0x1.718adep-2, INEXACT)
T(RN,  0x1.8744e49dfb217p+996,    -0x1.0fdb5fd93f6ep-1,  -0x1.1459bep-4, INEXACT)
T(RN,  0x1.41945af569d05p+996,   -0x1.d4845fde3d2adp-1,   0x1.b87104p-3, INEXACT)
T(RN,  0x1.2fbf4cae9f1a6p+996,   -0x1.d8a4a7d8d3638p-1,  -0x1.9f4936p-2, INEXACT)
T(RN,  0x1.41c5f7c239b98p+996,   -0x1.444873e77cbc7p-1,  -0x1.b549c4p-7, INEXACT)
T(RN,  0x1.e97356442dcdap+996,    0x1.476908e526d23p-1,   0x1.36f292p-5, INEXACT)
T(RN,  0x1.33846c2386142p+996,   -0x1.0d714832525ddp-1,  -0x1.5d977ep-4, INEXACT)
T(RN,  0x1.cf2fb595dde3cp+996,    0x1.9e8db804bbef9p-1,   0x1.ec5efcp-2, INEXACT)
T(RN,  0x1.99f07d1751de6p+996,   -0x1.ef3fa20c6ebdbp-1,    -0x1.af8dp-2, INEXACT)
T(RN,  0x1.37024358fb652p+996,    0x1.711bfcb39c86cp-2,   0x1.517d66p-4, INEXACT)
T(RN,  0x1.140251fc44ae9p+996,   -0x1.3e7d007c32cebp-1,   0x1.3ff40ap-7, INEXACT)
T(RN,  0x1.ddec15511b25bp+997,    0x1.5153939e24c34p-1,   0x1.a5ef4cp-3, INEXACT)
T(RN,  0x1.35970e7e145f3p+997,    0x1.ede7c01c95227p-1,   0x1.6cdb84p-3, INEXACT)
T(RN,  0x1.ea87be3beb11ep+997,    0x1.ad4314a3ef061p-2,  -0x1.ccfd02p-3, INEXACT)
T(RN,  0x1.1957665357097p+997,    0x1.f547409ea6f21p-1,   0x1.0d9642p-3, INEXACT)
T(RN,  0x1.01fbcdfaf341dp+997,    0x1.e6fbc93f3ca04p-3,  -0x1.41c672p-2, INEXACT)
T(RN,  0x1.4043d852b111ap+997,    0x1.af3a558facbbcp-1,   0x1.5c9d6cp-3, INEXACT)
T(RN,   0x1.df3dd985b868p+997,   -0x1.cb1a16154f32dp-1,  -0x1.356ebcp-3, INEXACT)
T(RN,   0x1.d885183f2af5p+997,    0x1.a9cee964d171fp-2,   0x1.8620bcp-5, INEXACT)
T(RN,  0x1.79942734ff891p+997,    0x1.04ccc1b285216p-5,  -0x1.fcbde6p-3, INEXACT)
T(RN,  0x1.4bc25b35f2f06p+997,    0x1.01ba3f32bf6bbp-1,  -0x1.786fdcp-2, INEXACT)
T(RN,  0x1.9f1ec1a4470b6p+998,    0x1.f071208361402p-1,  -0x1.89cdc4p-2, INEXACT)
T(RN,  0x1.6682992abe269p+998,   -0x1.fffd71894f89ep-1,  -0x1.8ef578p-3, INEXACT)
T(RN,  0x1.2f53822333cafp+998,    0x1.61cc2ae64a63ep-1,  -0x1.0cac86p-2, INEXACT)
T(RN,   0x1.9bcd07cb604bp+998,    0x1.3a4c42385ca4dp-1,  -0x1.b824bcp-3, INEXACT)
T(RN,  0x1.72726387c8d64p+998,   -0x1.db202072942c2p-2,  -0x1.744b2cp-6, INEXACT)
T(RN,  0x1.fd7a5f757c968p+998,    0x1.e269906ce74a7p-2,   -0x1.abaacp-2, INEXACT)
T(RN,  0x1.471ef1d186e4ep+998,   -0x1.c26ac46605721p-1,   0x1.dd21a4p-2, INEXACT)
T(RN,  0x1.0d6ceba4a60cfp+998,   -0x1.310a6d4ba31b5p-2,  -0x1.2d17d6p-4, INEXACT)
T(RN,  0x1.9087302bae4eap+998,    0x1.13791a820e746p-1,   0x1.8aedc4p-3, INEXACT)
T(RN,  0x1.3badcb003aea4p+998,    0x1.7a7d356a163e5p-1,  -0x1.bd1a0ap-2, INEXACT)
T(RN,  0x1.bac552785a4aap+999,   -0x1.f3c5e17776255p-1,   0x1.475342p-2, INEXACT)
T(RN,  0x1.0a989bf13dbb2p+999,   -0x1.f1fff14cf5cfap-1,    0x1.5fb33p-2, INEXACT)
T(RN,  0x1.c7a211423424ep+999,    -0x1.7449216711b1p-2,  -0x1.50d1dap-3, INEXACT)
T(RN,  0x1.a00f8360632afp+999,    0x1.fb8e92c829571p-1,  -0x1.a6720ap-2, INEXACT)
T(RN,  0x1.2779ef2651acfp+999,    0x1.a82f2eb6a96fdp-1,   0x1.170414p-2, INEXACT)
T(RN,  0x1.27f50cff9f287p+999,   -0x1.324aef3b74538p-1,   0x1.00be82p-3, INEXACT)
T(RN,  0x1.bc35cafe21efcp+999,   -0x1.d93625917964dp-1,  -0x1.92e35cp-3, INEXACT)
T(RN,  0x1.8db0b7328bad3p+999,   -0x1.4f113c0773711p-3,   0x1.32cae8p-6, INEXACT)
T(RN,  0x1.e4d9d0b2af5c8p+999,   -0x1.bfc8d04e328d3p-1,   0x1.fb23c2p-3, INEXACT)
T(RN,  0x1.2b353843b3a24p+999,   -0x1.3927869361cd8p-2,  -0x1.a6ccdcp-2, INEXACT)
T(RN, 0x1.2f7149c2c0704p+1000,   -0x1.8662c594ba119p-3,   0x1.22be58p-3, INEXACT)
T(RN, 0x1.3f43986094a66p+1000,    0x1.f9fcfdaaccdf6p-1,  -0x1.c13344p-2, INEXACT)
T(RN, 0x1.24fdc870cd9f8p+1000,   -0x1.faa12103d5dcbp-1,   0x1.ea607cp-2, INEXACT)
T(RN, 0x1.fbf22bd8390e6p+1000,    0x1.7fd43f7e21d93p-1,  -0x1.c74664p-3, INEXACT)
T(RN, 0x1.adbc39989bda2p+1000,    0x1.61c5d5e084944p-2,  -0x1.40d21cp-2, INEXACT)
T(RN, 0x1.14cca2002325bp+1000,   -0x1.9399161fee3cdp-1,   0x1.becc46p-3, INEXACT)
T(RN, 0x1.c27f2a77980ecp+1000,     0x1.aec55981b5b1p-1,   0x1.7cda22p-2, INEXACT)
T(RN, 0x1.5ae95fc17e56cp+1000,    0x1.1dc424188fd33p-1,   0x1.6639dep-4, INEXACT)
T(RN, 0x1.955ee8f09e88cp+1000,   -0x1.e39a0a68b2206p-1,  -0x1.fd772ap-2, INEXACT)
T(RN,  0x1.38441ee843b5p+1000,    0x1.c8260cfae966ep-1,  -0x1.f99d54p-2, INEXACT)
T(RN, 0x1.a250b2ec21e98p+1001,   -0x1.3f2f8ec72b161p-1,   0x1.bc83e8p-3, INEXACT)
T(RN, 0x1.33904f60041d2p+1001,    0x1.cf7e59f4957cbp-1,    0x1.40c05p-3, INEXACT)
T(RN, 0x1.dbc4fdd84ddb8p+1001,   -0x1.e954ea48dffbep-1,    0x1.0be98p-3, INEXACT)
T(RN, 0x1.dae691864af4ap+1001,    0x1.0121a0dd0d6cep-3,  -0x1.e0944cp-2, INEXACT)
T(RN, 0x1.cdcd092722104p+1001,   -0x1.08fb9ef19ceaap-3,  -0x1.45050ap-4, INEXACT)
T(RN, 0x1.a0cc0eaae316cp+1001,    0x1.01cb7aaf78d2cp-1,  -0x1.2aa18cp-2, INEXACT)
T(RN, 0x1.83f1b3f985a06p+1001,   -0x1.c35f8b581d394p-1,   0x1.e3e966p-2, INEXACT)
T(RN, 0x1.ed5abcb01ef0cp+1001,    0x1.fd2cb07807eb2p-1,   0x1.cc0b5ap-2, INEXACT)
T(RN, 0x1.8bb43e171a4fap+1001,    0x1.c6555ac5ff5a6p-2,   0x1.f28646p-2, INEXACT)
T(RN, 0x1.78b31628acd35p+1001,    0x1.decff74298e53p-1,   0x1.f96f4ap-2, INEXACT)
T(RN, 0x1.9110d46fdb00cp+1002,    0x1.c90efbd06297fp-4,  -0x1.7ab034p-2, INEXACT)
T(RN, 0x1.89b645c87895fp+1002,    -0x1.cf25a5b2fa44p-1,   0x1.815a04p-3, INEXACT)
T(RN, 0x1.aa3b27596ed48p+1002,    0x1.f4279aca84533p-1,   -0x1.c4dbcp-4, INEXACT)
T(RN, 0x1.fbd5d004b6ae2p+1002,   -0x1.5d37036a4ee54p-1,   0x1.a8a1dep-2, INEXACT)
T(RN, 0x1.679d0452f518bp+1002,   -0x1.df383d2ac9c49p-1,   0x1.3468b2p-2, INEXACT)
T(RN, 0x1.9fed1a70d6864p+1002,    0x1.7234835e2263cp-1,    0x1.9f435p-3, INEXACT)
T(RN, 0x1.53fd98c7f629ap+1002,    0x1.f338192c9873cp-1,   0x1.31bf5ap-2, INEXACT)
T(RN, 0x1.2020d4b29b22bp+1002,   -0x1.364eb71f51d06p-1,   0x1.584454p-3, INEXACT)
T(RN, 0x1.a7eddae9b98d7p+1002,    0x1.4abedadfd7842p-4,   0x1.34d63cp-4, INEXACT)
T(RN,  0x1.d46105b0a00ep+1002,   -0x1.dbfb89ac8e931p-2,   0x1.f873e4p-3, INEXACT)
T(RN, 0x1.9167980f6ccd4p+1003,    0x1.9fe74d8ae2d0ep-1,   0x1.b0538ep-2, INEXACT)
T(RN, 0x1.caf27012545dep+1003,    0x1.09e4f188cf1ccp-2,   0x1.3e7d38p-2, INEXACT)
T(RN, 0x1.3b201be17473bp+1003,    0x1.bf9c96a6df05ap-6,  -0x1.a50c1ap-5, INEXACT)
T(RN, 0x1.634d07719e6e2p+1003,    0x1.f964a1658c7abp-1,   0x1.5786a4p-2, INEXACT)
T(RN, 0x1.742024f549986p+1003,    -0x1.d4ca93ff68f8p-1,   -0x1.c2bf7p-4, INEXACT)
T(RN, 0x1.38cec40f2b5f6p+1003,     0x1.3f7d75aab88ap-1,   0x1.43cd7cp-2, INEXACT)
T(RN, 0x1.32458daead0c6p+1003,    -0x1.fc7d74fcd209p-3,    0x1.9498dp-5, INEXACT)
T(RN, 0x1.052361bf3732dp+1003,    0x1.41f9475c33394p-1,  -0x1.e0a6aap-3, INEXACT)
T(RN, 0x1.64ae74925c4d4p+1003,    0x1.b5ec12d5a0d42p-1,  -0x1.ebefeep-2, INEXACT)
T(RN, 0x1.1b617a0600236p+1003,    0x1.fef73825f1845p-1,     0x1.0c66p-3, INEXACT)
T(RN, 0x1.eb64761d138cap+1004,    0x1.31d1d90e3cbe4p-2,  -0x1.2a4d32p-2, INEXACT)
T(RN, 0x1.b6785705424eap+1004,    0x1.e900d2990af64p-1,  -0x1.ef31e2p-2, INEXACT)
T(RN, 0x1.a41e934ae47c3p+1004,    0x1.a72f6f126f25fp-2,  -0x1.d03e38p-2, INEXACT)
T(RN, 0x1.ac02bf42c1ac9p+1004,   -0x1.c78255730cde7p-1,  -0x1.93eb32p-3, INEXACT)
T(RN, 0x1.d7bdef53e4294p+1004,    0x1.1f343fd202964p-1,  -0x1.57b592p-4, INEXACT)
T(RN, 0x1.64080c3540474p+1004,    0x1.438263d826bc8p-1,  -0x1.7a9788p-3, INEXACT)
T(RN, 0x1.6c70e96adfdcep+1004,   -0x1.cf3e98eb1f978p-1,    -0x1.5592p-2, INEXACT)
T(RN, 0x1.a13a2f7e0f3c5p+1004,     -0x1.7fb0d57301ap-1,    0x1.0733fp-5, INEXACT)
T(RN, 0x1.c35924b5887c3p+1004,   -0x1.e4ae25f345685p-1,  -0x1.5cf2a2p-7, INEXACT)
T(RN, 0x1.441a29be7a7b6p+1004,    0x1.fe061eae5f456p-1,   0x1.bd594ap-4, INEXACT)
T(RN, 0x1.d5c703e4144e2p+1005,   -0x1.d18b585789661p-1,   0x1.1ab7f8p-3, INEXACT)
T(RN, 0x1.64848b3d0f3ffp+1005,    0x1.2f9ff783db84fp-1,   0x1.106fc4p-3, INEXACT)
T(RN, 0x1.5b501639f283fp+1005,   -0x1.b94d1b1bfe22bp-1,   -0x1.557f3p-2, INEXACT)
T(RN, 0x1.edd87a95f0c77p+1005,    0x1.20b5833130578p-1,   0x1.3cc5dcp-2, INEXACT)
T(RN, 0x1.cc59cc746bcafp+1005,    0x1.0bcfe3b95c69bp-1,  -0x1.1534aep-2, INEXACT)
T(RN, 0x1.680b56e9f257fp+1005,   -0x1.1efecb1b1f772p-4,  -0x1.59cfe8p-2, INEXACT)
T(RN, 0x1.ec17ba01c9135p+1005,    0x1.2c9c405a6dab5p-1,    0x1.44ea5p-2, INEXACT)
T(RN, 0x1.b1ab3adb24728p+1005,    0x1.75400769da629p-3,  -0x1.7978a4p-3, INEXACT)
T(RN, 0x1.60596797e1d98p+1005,   -0x1.5867ef7f82bafp-2,   0x1.ed33a2p-3, INEXACT)
T(RN,  0x1.a31a2cdb64acp+1005,   -0x1.97a9a53fd3433p-1,   0x1.622854p-3, INEXACT)
T(RN, 0x1.e13146f2c0b72p+1006,    0x1.023fa9e81ffdep-1,   0x1.1413c2p-2, INEXACT)
T(RN, 0x1.f2b776235564ep+1006,   -0x1.04afc69f8e0ccp-1,  -0x1.a901cep-2, INEXACT)
T(RN, 0x1.a5b80be03504ap+1006,    0x1.fe8e4890ba4a6p-1,   0x1.f3ff0ap-3, INEXACT)
T(RN, 0x1.b3595afe7d887p+1006,    0x1.563418e703608p-2,  -0x1.e0f8bcp-3, INEXACT)
T(RN, 0x1.b3ec8625ab972p+1006,    0x1.e448e17910ad3p-1,  -0x1.17758cp-4, INEXACT)
T(RN, 0x1.738d52283b462p+1006,   -0x1.fd4d22cc26fbbp-1,  -0x1.03b5eep-4, INEXACT)
T(RN, 0x1.8fd67ce62a652p+1006,    0x1.0232576983bbbp-1,   0x1.822cccp-3, INEXACT)
T(RN, 0x1.e8dfaa9ca2eb3p+1006,   -0x1.9d3a223f1bd72p-1,  -0x1.465aaep-2, INEXACT)
T(RN, 0x1.52ef34d2a95d1p+1006,    0x1.fcc04196fe0acp-1,  -0x1.dd254ap-5, INEXACT)
T(RN, 0x1.c54a5141df96ep+1006,    0x1.fe49ac7771785p-1,  -0x1.452892p-3, INEXACT)
T(RN, 0x1.ca4fed7772b82p+1007,   -0x1.ee8f802481eafp-1,   0x1.5d60e8p-3, INEXACT)
T(RN,  0x1.8c1bf866284cp+1007,    0x1.bd84ea009750cp-1,   0x1.2391dcp-3, INEXACT)
T(RN, 0x1.13dae07340093p+1007,   -0x1.e2541770c845fp-3,     0x1.e62dp-2, INEXACT)
T(RN, 0x1.bfecf0c3fd25ap+1007,    0x1.126b450c05df7p-1,   0x1.9d91e2p-4, INEXACT)
T(RN, 0x1.8575720cdd8bfp+1007,    0x1.732c0ffaca0aap-2,  -0x1.5e5b7ap-4, INEXACT)
T(RN, 0x1.61f1888445f4dp+1007,    0x1.ffdaffb348454p-1,  -0x1.6e9f42p-3, INEXACT)
T(RN, 0x1.524eb55d2e374p+1007,   -0x1.163ce4eb554b8p-2,   0x1.c57394p-2, INEXACT)
T(RN, 0x1.9a6df4cc38026p+1007,    0x1.89f2c95960347p-3,    0x1.ad14dp-7, INEXACT)
T(RN, 0x1.65a79bf42a2d2p+1007,    -0x1.cb0495eb00ddp-1,  -0x1.37530ap-2, INEXACT)
T(RN, 0x1.03b8a66cfb40dp+1007,    -0x1.f9c7da808be7p-1,    0x1.886e3p-3, INEXACT)
T(RN, 0x1.5a6a1702fef08p+1008,    -0x1.f3e4f5694035p-1,   0x1.3ce1eap-2, INEXACT)
T(RN, 0x1.ef6b888f511eap+1008,   -0x1.7b5974302e317p-1,   0x1.087138p-2, INEXACT)
T(RN, 0x1.2e6409e0a367dp+1008,    -0x1.76801679e78dp-2,   0x1.dc92cap-3, INEXACT)
T(RN,  0x1.2f5fb72e1b14p+1008,   -0x1.5fe5b4f8a02cdp-1,  -0x1.05c74ap-2, INEXACT)
T(RN, 0x1.bd5d166dbd0c4p+1008,   -0x1.c847e957afe44p-1,    0x1.f1477p-2, INEXACT)
T(RN, 0x1.4bcfa8e68a554p+1008,   -0x1.d782aa36618b4p-1,   0x1.d6ef18p-3, INEXACT)
T(RN, 0x1.08b330ace2014p+1008,    0x1.fe4ba7ebfe394p-1,  -0x1.3f59d4p-3, INEXACT)
T(RN, 0x1.454c5a1dbb9f4p+1008,   -0x1.4edd2c1a56a36p-1,  -0x1.837f86p-3, INEXACT)
T(RN, 0x1.5f43d6e12946ep+1008,   -0x1.7a5f26ade59f7p-1,  -0x1.33d786p-2, INEXACT)
T(RN, 0x1.712d2046be58ap+1008,   -0x1.c2932dff6bf24p-3,  -0x1.200b42p-2, INEXACT)
T(RN, 0x1.8f93fca906243p+1009,   -0x1.da4bb2a494b32p-1,  -0x1.4b0e4cp-4, INEXACT)
T(RN, 0x1.da2f98573ab76p+1009,    0x1.fc27dee047b43p-1,  -0x1.2ee14cp-2, INEXACT)
T(RN, 0x1.df1bc62e6a776p+1009,    0x1.523416b9f80adp-1,  -0x1.e871a8p-3, INEXACT)
T(RN, 0x1.1b077ab6bdea3p+1009,   -0x1.d73d2ef1bee8fp-2,  -0x1.7c83f2p-2, INEXACT)
T(RN, 0x1.d5d985d239944p+1009,   -0x1.6b4e3afd9acbbp-1,  -0x1.782da2p-2, INEXACT)
T(RN, 0x1.23ccea0cb8af9p+1009,   -0x1.f38229bff76d9p-1,  -0x1.31c49cp-3, INEXACT)
T(RN, 0x1.c92dd487790cep+1009,    0x1.f88728a173099p-1,    0x1.2dd5dp-2, INEXACT)
T(RN,  0x1.2349d524df6fp+1009,   -0x1.f1fd69e8229b6p-2,   -0x1.d4dc5p-2, INEXACT)
T(RN, 0x1.29e9c55c22cc5p+1009,   -0x1.407084db46b79p-1,  -0x1.20899cp-4, INEXACT)
T(RN, 0x1.2b521405993d9p+1009,   -0x1.8831bb6f15fdap-2,   0x1.c15502p-2, INEXACT)
T(RN, 0x1.965f7abd23ad4p+1010,   -0x1.3af89b9ca60e3p-1,   0x1.855f26p-6, INEXACT)
T(RN, 0x1.078d44a7dc354p+1010,    0x1.5f957d5f172d4p-1,   0x1.f32a08p-6, INEXACT)
T(RN, 0x1.e14cb6da9caa8p+1010,    0x1.fffce7cde6835p-1,    0x1.826a3p-2, INEXACT)
T(RN, 0x1.fc55ef6dcb34cp+1010,    0x1.8937b742bd611p-2,  -0x1.08997ap-2, INEXACT)
T(RN,  0x1.449dbdd8bf36p+1010,    0x1.64e7a10f21409p-5,    0x1.9e6ebp-3, INEXACT)
T(RN, 0x1.95b514d6d8508p+1010,    0x1.a4b91d30d8e28p-2,   0x1.9cd856p-2, INEXACT)
T(RN, 0x1.52973ff07be12p+1010,    0x1.cccb9492992e5p-3,   -0x1.1e1d2p-7, INEXACT)
T(RN, 0x1.35c51afcea307p+1010,   -0x1.bb138a15e9c9cp-1,   0x1.9fe16ep-2, INEXACT)
T(RN, 0x1.ba44d8733f61dp+1010,   -0x1.4f0fd4581b5bcp-1,  -0x1.9f40d4p-2, INEXACT)
T(RN,  0x1.165b29045b81p+1010,   -0x1.23d25e22d4c66p-1,  -0x1.6bd4d2p-6, INEXACT)
T(RN, 0x1.fb3aa99d2bf64p+1011,    0x1.f88ccc3b914f4p-1,  -0x1.47b04ap-3, INEXACT)
T(RN, 0x1.9be5849a5c95ep+1011,   -0x1.813ba23a49486p-5,  -0x1.fed2eep-2, INEXACT)
T(RN, 0x1.ba5fbc35414e1p+1011,   -0x1.d7494a41001ccp-2,  -0x1.dee8ecp-2, INEXACT)
T(RN,  0x1.fbfd5ea87476p+1011,    0x1.f4d83a15f0ce8p-1,  -0x1.bae086p-4, INEXACT)
T(RN, 0x1.8d12ee5097e26p+1011,   -0x1.4c2a8ea418f5ap-1,  -0x1.1430d6p-5, INEXACT)
T(RN, 0x1.6c293e71c2f7ap+1011,   -0x1.48e4e74103e8fp-2,   0x1.ea02bap-2, INEXACT)
T(RN, 0x1.3f4647de6b92ap+1011,   -0x1.c90726aecafbap-1,   0x1.e79156p-4, INEXACT)
T(RN, 0x1.d54d3719fd60ap+1011,    0x1.f3a90da7c2e58p-1,   0x1.10d364p-2, INEXACT)
T(RN, 0x1.26b48b052db12p+1011,   -0x1.7c5a2a11baa76p-1,  -0x1.a9417cp-2, INEXACT)
T(RN, 0x1.8687a4b367c68p+1011,   -0x1.b0acf78c33409p-1,   -0x1.fe6c6p-2, INEXACT)
T(RN, 0x1.b6bee22cffa05p+1012,   -0x1.8984da61487b2p-1,   0x1.a5253cp-2, INEXACT)
T(RN, 0x1.bc429010b7a68p+1012,   -0x1.adcf5ff55c501p-1,   -0x1.23732p-5, INEXACT)
T(RN, 0x1.d430ae218b6d6p+1012,    0x1.a6f8041f9be9dp-4,     0x1.b646p-3, INEXACT)
T(RN, 0x1.2b1c664c73b9ap+1012,   -0x1.ba644bf048537p-1,   0x1.a3ad0ep-2, INEXACT)
T(RN, 0x1.d1a1f00cd2e85p+1012,    -0x1.ddc3d802e98bp-3,   0x1.91d31ep-3, INEXACT)
T(RN, 0x1.3a5caf5238fa2p+1012,   -0x1.5508d9ce6fd24p-1,   -0x1.60964p-2, INEXACT)
T(RN, 0x1.430f65f67584bp+1012,   -0x1.ffd22a5ed0deep-1,  -0x1.12e396p-4, INEXACT)
T(RN, 0x1.690ff26d1e0fcp+1012,    0x1.f497b8d523256p-2,   0x1.213ce8p-3, INEXACT)
T(RN, 0x1.c485d0ccbeab4p+1012,    -0x1.28b8acfb18b6p-4,   0x1.a4fc76p-2, INEXACT)
T(RN, 0x1.6350f1c1a5a99p+1012,   -0x1.ffff2feb1c1bdp-1,  -0x1.3bb2b2p-3, INEXACT)
T(RN, 0x1.75378b996482cp+1013,     0x1.f95f1ebf7317p-1,   -0x1.e5c0fp-2, INEXACT)
T(RN, 0x1.e33fa477406dap+1013,    0x1.6417639a0f072p-1,   0x1.c2568ep-5, INEXACT)
T(RN, 0x1.f5c102d8d51bdp+1013,     0x1.316fdbe965dep-1,   0x1.7dafbap-3, INEXACT)
T(RN, 0x1.1672b379f991ep+1013,     0x1.5a32faa9cf4ep-2,  -0x1.7e2e36p-3, INEXACT)
T(RN, 0x1.050c73aabcddfp+1013,    0x1.69b331b2f5054p-1,  -0x1.034f38p-2, INEXACT)
T(RN, 0x1.8302928f25e82p+1013,    0x1.01c4a6d322403p-2,  -0x1.429992p-2, INEXACT)
T(RN, 0x1.9732f775f84bap+1013,    0x1.fc56fb8dabddbp-1,   0x1.86a6a8p-2, INEXACT)
T(RN, 0x1.468ceb8d7f7aap+1013,   -0x1.9a8bd57ef15bdp-1,  -0x1.035442p-7, INEXACT)
T(RN, 0x1.98e8dca00f087p+1013,   -0x1.bcf28b88bb86bp-1,  -0x1.bd1228p-2, INEXACT)
T(RN, 0x1.984ebcdafeb7ep+1013,   -0x1.43ba1d7a3aa1ep-2,   0x1.c416a2p-5, INEXACT)
T(RN, 0x1.0ffd0ccdcabdfp+1014,    0x1.52b6c9ed44376p-3,   0x1.32825ap-5, INEXACT)
T(RN,  0x1.dc56b8efa18bp+1014,   -0x1.f5af51a659373p-1,  -0x1.bae65ep-6, INEXACT)
T(RN, 0x1.3c233cbf3caa9p+1014,   -0x1.7ebfaff4760b3p-2,   0x1.6d4d5ap-3, INEXACT)
T(RN,  0x1.da94e37b9f5cp+1014,    0x1.284d69f422436p-1,    0x1.b9fbbp-5, INEXACT)
T(RN, 0x1.da67fc0bee413p+1014,    0x1.55c1cb0d4fdfcp-1,   -0x1.536ffp-2, INEXACT)
T(RN, 0x1.55de21a12d157p+1014,   -0x1.b8c879d36578cp-3,  -0x1.54e75ap-3, INEXACT)
T(RN, 0x1.61be69006d299p+1014,   -0x1.839dfd960358ap-1,   0x1.ff1452p-3, INEXACT)
T(RN, 0x1.3562b2861d9a8p+1014,   -0x1.4d7d0ac3f98aep-1,  -0x1.3281cap-6, INEXACT)
T(RN, 0x1.7c73d008f4f74p+1014,   -0x1.f669c2026a0bdp-2,   0x1.bffc14p-3, INEXACT)
T(RN, 0x1.fdc657624ceacp+1014,    0x1.fc230b35432abp-1,    0x1.3b3d1p-4, INEXACT)
T(RN, 0x1.c3762793b6d9ap+1015,    0x1.955efaf2af914p-1,  -0x1.5618bep-2, INEXACT)
T(RN, 0x1.b5100ca59bb41p+1015,    -0x1.3c6a8ebf0cffp-1,   0x1.7016f6p-2, INEXACT)
T(RN, 0x1.3a2ab67f728fap+1015,   -0x1.e76378c081397p-1,   0x1.e00f44p-3, INEXACT)
T(RN, 0x1.71b6964cf260ap+1015,   -0x1.9c3b0037556a2p-1,   0x1.03df2cp-4, INEXACT)
T(RN, 0x1.d1c090e0d82b2p+1015,   -0x1.2a08f0272978dp-2,  -0x1.d265d8p-4, INEXACT)
T(RN, 0x1.158743c21ceabp+1015,   -0x1.020cc11be857cp-4,  -0x1.02564ep-2, INEXACT)
T(RN, 0x1.a16bed2b6de8ep+1015,    0x1.9b22df6917359p-2,   0x1.1def94p-3, INEXACT)
T(RN, 0x1.8586dfa122768p+1015,   -0x1.5d1dbd59c2ba7p-3,   0x1.e74d98p-3, INEXACT)
T(RN, 0x1.da4f9422074bdp+1015,    0x1.ff7d3491b9a0ap-1,  -0x1.396a1ep-3, INEXACT)
T(RN, 0x1.134c94cf576aep+1015,    0x1.fcea2b4d84ccfp-1,   0x1.96ab48p-2, INEXACT)
T(RN, 0x1.4050bd37e1638p+1016,    0x1.fc7009a29febep-1,  -0x1.2206eep-2, INEXACT)
T(RN, 0x1.2df246b247e62p+1016,   -0x1.3ee2fe2b9fa67p-4,  -0x1.6e6582p-2, INEXACT)
T(RN, 0x1.0154fb5680d3ep+1016,   -0x1.ff922a76355cdp-1,   0x1.951b5cp-2, INEXACT)
T(RN, 0x1.7611d63dcdfaap+1016,    0x1.732bb8d117c1ap-1,   0x1.58411ep-4, INEXACT)
T(RN, 0x1.e10ee608d9fa4p+1016,    0x1.4b47a498eedb4p-3,  -0x1.b0fe7cp-2, INEXACT)
T(RN, 0x1.2155052d64e68p+1016,   -0x1.77aaac84c1979p-4,   0x1.4ce8a8p-4, INEXACT)
T(RN, 0x1.b4bfbd8d8aaf8p+1016,    0x1.5a0162025082fp-1,   0x1.3880f6p-2, INEXACT)
T(RN, 0x1.a0c632e6aea8cp+1016,   -0x1.04219596ac22ep-2,  -0x1.20aab2p-3, INEXACT)
T(RN, 0x1.03474b1211b2ep+1016,    0x1.e4ade1955680dp-1,   0x1.2bcec6p-5, INEXACT)
T(RN, 0x1.46ffc6099a2edp+1016,    0x1.d1214cabc72cfp-1,   0x1.f55aa4p-3, INEXACT)
T(RN, 0x1.0e9fc45484e15p+1017,    0x1.4746a20ef5de9p-3,   0x1.a5291ap-2, INEXACT)
T(RN, 0x1.452e47c975fbcp+1017,    0x1.bca10abca5818p-4,   0x1.03d97ep-6, INEXACT)
T(RN, 0x1.a8a4a76ebf682p+1017,   -0x1.a5897c2f74396p-1,   0x1.ff4ca8p-4, INEXACT)
T(RN, 0x1.b79df91986838p+1017,   -0x1.80724c1d7de57p-1,   0x1.c51684p-3, INEXACT)
T(RN, 0x1.f51c9ebf130a4p+1017,   -0x1.a41de3899516fp-1,   0x1.117dfap-3, INEXACT)
T(RN, 0x1.ebe804a596d3ap+1017,    -0x1.c0d60f13d221p-6,   0x1.adb26cp-4, INEXACT)
T(RN, 0x1.74f8c3c477f7cp+1017,    0x1.96689467e44e2p-3,  -0x1.a14dfap-2, INEXACT)
T(RN, 0x1.c8da8eecaeb5fp+1017,   -0x1.fec644f7a83fcp-1,  -0x1.6c7aa8p-5, INEXACT)
T(RN, 0x1.c754169df87d8p+1017,    0x1.5313b7fe32c1bp-3,   0x1.f6b462p-5, INEXACT)
T(RN, 0x1.9facbb1dca72cp+1017,    0x1.d003fd47bdabcp-1,    0x1.cf4aap-3, INEXACT)
T(RN,  0x1.d10c6f5bdbaep+1018,   -0x1.eb0348a9166cap-1,   0x1.c5520cp-2, INEXACT)
T(RN, 0x1.e172dfc00c308p+1018,   -0x1.ef5417ff2e73ep-2,   0x1.243f06p-2, INEXACT)
T(RN, 0x1.c60d2867a9142p+1018,   -0x1.67e1de539c85cp-3,   0x1.327f66p-2, INEXACT)
T(RN, 0x1.c43c5138309aep+1018,    0x1.d8442a9b507adp-1,  -0x1.6a5beap-2, INEXACT)
T(RN, 0x1.8924a665edbccp+1018,    0x1.2a995035af593p-1,   0x1.a9db3ap-2, INEXACT)
T(RN, 0x1.5024b0a73f793p+1018,   -0x1.b32518c56aa44p-1,  -0x1.aa2106p-4, INEXACT)
T(RN, 0x1.7f982f7536054p+1018,    0x1.e83ad4ced4f87p-1,   0x1.02216cp-2, INEXACT)
T(RN, 0x1.4fcf757c76145p+1018,   -0x1.8c1f799eceb14p-1,   0x1.becd4ep-2, INEXACT)
T(RN, 0x1.a301b03c66462p+1018,    0x1.9d54617ac507ap-1,  -0x1.c83374p-2, INEXACT)
T(RN, 0x1.99503d0b0e909p+1018,    0x1.c73644e3d14a5p-1,   0x1.d04b32p-2, INEXACT)
T(RN, 0x1.1c68fbb49cb34p+1019,    0x1.83b9f3d17dd5fp-1,   0x1.6552e8p-2, INEXACT)
T(RN, 0x1.8232f57ed02d8p+1019,     0x1.fff2f557fa06p-1,  -0x1.2662f8p-3, INEXACT)
T(RN, 0x1.568f3a4c3e3afp+1019,    0x1.fed8654650a78p-2,  -0x1.d25e78p-2, INEXACT)
T(RN, 0x1.ce823ce616c57p+1019,   -0x1.216632433b139p-2,  -0x1.e00e4cp-3, INEXACT)
T(RN, 0x1.1b340e841a4c1p+1019,   -0x1.eeff7ff0253a8p-1,  -0x1.5b4ef4p-2, INEXACT)
T(RN, 0x1.44fbd46e0fb7ep+1019,   -0x1.7327727e8fb52p-1,   0x1.ea4b4ap-4, INEXACT)
T(RN, 0x1.b7df380ec301ep+1019,    0x1.4e72c92bb72a3p-4,  -0x1.275ef2p-9, INEXACT)
T(RN, 0x1.b167d943e3136p+1019,   -0x1.ffb0d6c337f79p-1,  -0x1.a96a64p-2, INEXACT)
T(RN, 0x1.17de7224d4d9ep+1019,    0x1.9582fbe783975p-3,  -0x1.8b985ap-2, INEXACT)
T(RN, 0x1.51d3807ee342bp+1019,   -0x1.09113e32d289cp-1,   0x1.9ecc68p-4, INEXACT)
T(RN, 0x1.0045ee30a02a1p+1020,   -0x1.034c53999a13fp-1,  -0x1.60f8b4p-3, INEXACT)
T(RN, 0x1.efd79e916ce9cp+1020,    0x1.1323676d8b0cep-2,   0x1.df0ca4p-2, INEXACT)
T(RN, 0x1.e7ac1c7ab9ddcp+1020,   -0x1.61e713415efd7p-1,  -0x1.91ca3ep-2, INEXACT)
T(RN, 0x1.6fbfcb37b729ap+1020,   -0x1.e261ad36b392fp-1,   0x1.c9a75ap-2, INEXACT)
T(RN, 0x1.da892abd4418ep+1020,   -0x1.09fa9775edb32p-2,   -0x1.e867cp-2, INEXACT)
T(RN, 0x1.d8b872e66b94cp+1020,   -0x1.ea5f33518495bp-3,  -0x1.3ce966p-3, INEXACT)
T(RN, 0x1.a5aabb81bbb6dp+1020,     0x1.ffff7b878344p-1,  -0x1.12cd2ep-2, INEXACT)
T(RN, 0x1.492040c4aa4d9p+1020,    0x1.f6a65fd7a7579p-1,  -0x1.82cdcep-2, INEXACT)
T(RN, 0x1.b71224b1ec9e2p+1020,    0x1.a1306b4370479p-1,   0x1.375358p-2, INEXACT)
T(RN, 0x1.176dbe2093f3bp+1020,   -0x1.29713e1bfae5ap-1,   0x1.8bf294p-3, INEXACT)
T(RN, 0x1.695359e01da38p+1021,   -0x1.d3d932462fae9p-1,  -0x1.1a3538p-6, INEXACT)
T(RN, 0x1.0e8c9e7d90708p+1021,   -0x1.767bedabf92dbp-1,    0x1.055a4p-5, INEXACT)
T(RN, 0x1.5bdcdf80ce4dap+1021,    0x1.509195f6ba037p-2,   0x1.e13ff4p-3, INEXACT)
T(RN,  0x1.0a6a3dc5fd2cp+1021,    0x1.902489035d7b2p-2,  -0x1.899714p-2, INEXACT)
T(RN, 0x1.e2f2e8770a2f9p+1021,    0x1.9e4a35e78367ep-1,   0x1.17535ap-2, INEXACT)
T(RN, 0x1.4720f78ed044dp+1021,    -0x1.bc9ff50738c4p-1,  -0x1.d388acp-4, INEXACT)
T(RN, 0x1.9233b9c0dd553p+1021,   -0x1.7968e6747fbd6p-1,    0x1.243c8p-3, INEXACT)
T(RN, 0x1.26fd9a22aad42p+1021,    0x1.b6cd6d3c49d97p-1,  -0x1.9c46fap-2, INEXACT)
T(RN, 0x1.43dc5716cc68cp+1021,    0x1.86c1f4368efc2p-1,   0x1.cce25cp-2, INEXACT)
T(RN,  0x1.fa425bb9d375p+1021,    0x1.0b841ae84cbd1p-1,   0x1.cf4d98p-3, INEXACT)
T(RN, 0x1.eb55557ef8204p+1022,    0x1.772bb30e2ae05p-2,   0x1.dc91acp-2, INEXACT)
T(RN, 0x1.d52500859db24p+1022,   -0x1.b958265b9f76fp-1,  -0x1.adc104p-2, INEXACT)
T(RN, 0x1.d621bf59157bcp+1022,   -0x1.6124f1009baeep-2,   0x1.5c535ap-2, INEXACT)
T(RN, 0x1.aa4fcda385982p+1022,   -0x1.07fb7e9ef23e6p-2,  -0x1.01a94ap-3, INEXACT)
T(RN, 0x1.47ca79b919452p+1022,    -0x1.632f852186c3p-1,   0x1.360deap-4, INEXACT)
T(RN, 0x1.0cc2723935e9fp+1022,      -0x1.f8b7b4c44cp-1,   0x1.f3ca26p-3, INEXACT)
T(RN, 0x1.d68fa143042bfp+1022,   -0x1.e05d28daad1dap-2,  -0x1.16b9b6p-2, INEXACT)
T(RN, 0x1.d994fb9da5bf4p+1022,    0x1.52b3863379a4bp-3,   0x1.a0f618p-2, INEXACT)
T(RN, 0x1.36be7cf0264c3p+1022,    0x1.a20438f01ee61p-1,   -0x1.265bcp-3, INEXACT)
T(RN, 0x1.b1a126b65583cp+1022,   -0x1.a7e7346fb09c8p-2,  -0x1.3cac02p-5, INEXACT)
T(RN, 0x1.ca873b3e579eep+1023,   -0x1.ff583b19e97f5p-1,  -0x1.6fa5e2p-5, INEXACT)
T(RN,   0x1.bb8c69a6685p+1023,    0x1.fa94f09a26642p-1,   0x1.653cd6p-2, INEXACT)
T(RN, 0x1.1b9819168f327p+1023,   -0x1.fdc32e0f1c74dp-1,   -0x1.9f134p-3, INEXACT)
T(RN, 0x1.ee06a29f9146bp+1023,    0x1.84a792018611cp-4,  -0x1.ce9aecp-6, INEXACT)
T(RN, 0x1.a3271bac2594ap+1023,    0x1.ff98532497dc7p-1,  -0x1.85c29ep-2, INEXACT)
T(RN, 0x1.3270fc80e3d74p+1023,   -0x1.05f2b453edf51p-2,  -0x1.847072p-4, INEXACT)
T(RN, 0x1.29179160e2297p+1023,    0x1.38adcf61d3dacp-1,   0x1.140728p-2, INEXACT)
T(RN, 0x1.40a1035e56da3p+1023,    0x1.4b85738b35fbdp-1,   0x1.0e336ap-2, INEXACT)
T(RN, 0x1.c50061963c632p+1023,    0x1.76e4268ff231dp-2,  -0x1.f9db68p-2, INEXACT)
T(RN, 0x1.d364a6aef4238p+1023,    0x1.d37edfd25c58cp-1,  -0x1.19e754p-2, INEXACT)
