﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
  This header file replaces the 'test.h' in the original musl-libc-test/common
  folder. This file is the only one altered from the original linux version of
  musl-libc-test so that we could redefine 't_status' and 't_error' since the
  Horizon version of the testsuite doesn't use those.

 *----------------------------------------------------------------------------*/

#ifndef REPLACEMENT_TEST_H
#define REPLACEMENT_TEST_H 1

#include "ntd-test-libc.h"
#include "./orig-musl-libc-test/src/common/test.h" // t_vmfill(), t_shuffle(), etc.
#undef t_error // We want to use a custom t_error rather than the default one
               // since we want to use TESTCASE() instead of t_printf()

// This variable isn't used in this Horizon version of the testsuite, but the
// linux version of musl-libc-test uses it, so it's included here to make the
// testsuite compile
#define t_status t_status_not_used
static int t_status_not_used = 0;
//static int t_status = 0;
//#undef t_status

#define t_error(...) (t_error_replacement_func(__FILE__, __LINE__, __VA_ARGS__))

int t_error_replacement_func(const char* file, int line, ...);

#define tmpfile() NTD_TEST_TMPFILE(__func__)
#endif /* REPLACEMENT_TEST_H */
