﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <errno.h>

void rynda_751(int argc, char** argv)
{
    errno = 0; // key routines do not set errno; the spec has it returning error codes or 0

    NTD_TEST_GROUP_START("RYNDA-751", 1);
    {
        {
            pthread_key_t slot;
            int rc;
            void* value;

            rc = pthread_key_create(&slot, NULL);
            TESTCASE_MESSAGE(rc != EAGAIN, "pthread_key_create() returned %d expected 0", rc);
            TESTCASE_MESSAGE(rc == 0, "pthread_key_create() returned %d expected 0", rc);
            value = pthread_getspecific(slot);
            TESTCASE_MESSAGE(value == NULL, "pthread_getspecific() returned unexpected non-zero before pthread_setspecific() called; result = %p", value);
            value = pthread_getspecific((pthread_key_t)((size_t)slot + (size_t)1));
            TESTCASE_MESSAGE(value == NULL, "pthread_getspecific() returned unexpected non-zero before creating key; result = %p", value);
            value = pthread_getspecific((pthread_key_t)((size_t)slot + (size_t)300));
            TESTCASE_MESSAGE(value == NULL, "pthread_getspecific() returned unexpected non-zero for invalid key; result = %p", value);
            rc = pthread_setspecific((pthread_key_t)((size_t)slot + (size_t)1), (void*)1);
            TESTCASE_MESSAGE(rc == EINVAL, "pthread_setspecific() returned unexpected value(%d) before creating key; expected EINVAL(%d)", rc, EINVAL);
            TESTCASE_MESSAGE(rc, "pthread_setspecific() returned unexpected value(%d) before creating key; expected EINVAL(%d)", rc, EINVAL);
            rc = pthread_setspecific((pthread_key_t)((size_t)slot + (size_t)300), (void*)1);
            TESTCASE_MESSAGE(rc == EINVAL, "pthread_setspecific() returned unexpected value(%d) for invalid key; expected EINVAL(%d)", rc, EINVAL);
            TESTCASE_MESSAGE(rc, "pthread_setspecific() returned unexpected value(%d) for invalid key; expected EINVAL(%d)", rc, EINVAL);
            rc = pthread_setspecific(slot, (void*)1);
            TESTCASE_MESSAGE(rc != EINVAL, "pthread_setspecific() returned %d expected 0", rc);
            TESTCASE_MESSAGE(rc == 0, "pthread_setspecific() returned %d expected 0", rc);
            value = pthread_getspecific(slot);
            TESTCASE_MESSAGE((size_t)value == (size_t)1, "pthread_getspecific() returned unexpected value(%p); expected 1", value);
            rc = pthread_key_delete(slot);
            TESTCASE_MESSAGE(rc != EINVAL, "pthread_key_delete() returned %d expected 0", rc);
            TESTCASE_MESSAGE(rc == 0, "pthread_key_delete() returned %d expected 0", rc);
            rc = pthread_key_delete(slot);
            TESTCASE_MESSAGE(rc == EINVAL, "pthread_key_delete() called on already deleted key; returned %d expected EINVAL(%d)", rc, EINVAL);
            TESTCASE_MESSAGE(rc, "pthread_key_delete() called on already deleted key; returned %d expected EINVAL(%d)", rc, EINVAL);
            rc = pthread_key_delete((pthread_key_t)((size_t)slot + (size_t)300));
            TESTCASE_MESSAGE(rc == EINVAL, "pthread_key_delete() called on invalid key; returned %d expected EINVAL(%d)", rc, EINVAL);
            TESTCASE_MESSAGE(rc, "pthread_key_delete() called on invalid key; returned %d expected EINVAL(%d)", rc, EINVAL);
        }
        pthread_key_t slot;
        int rc;
        void* value;

        rc = pthread_key_create(&slot, NULL);
        TESTCASE_MESSAGE(rc != EAGAIN, "pthread_key_delete() returned %d expected 0", rc);
        TESTCASE_MESSAGE(rc == 0, "pthread_key_delete() returned %d expected 0", rc);
        value = pthread_getspecific(slot);
        TESTCASE_MESSAGE((size_t)value != (size_t)1, "pthread_getspecific() returned unexpected value(%p); expected 0", value);
        TESTCASE_MESSAGE(value == NULL, "pthread_getspecific() returned unexpected value(%p); expected 0", value);
        rc = pthread_key_delete(slot);
        TESTCASE_MESSAGE(rc != EINVAL, "pthread_key_delete() returned %d expected 0", rc);
        TESTCASE_MESSAGE(rc == 0, "pthread_key_delete() returned %d expected 0", rc);
    }
    errno = 0;
    NTD_TEST_GROUP_END("RYNDA-751", 1);
}

