﻿/*---------------------------------------------------------------------------*
  Copyright (C) 2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stdio.h>
#include <stdint.h>

uint64_t double_to_uint64(double d)
{
    union double_to_uint {
        double      d;
        uint64_t    u;
    } d2u;

    d2u.d = d;
    return d2u.u;
}

uint32_t float_to_uint32(float f)
{
    union double_to_uint {
        float      f;
        uint32_t    u;
    } f2u;

    f2u.f = f;
    return f2u.u;
}

#ifdef VERBOSE
#define VERBOSE_PRINTF(...) printf(__VA_ARGS__)
#else
#define VERBOSE_PRINTF(...)
#endif
void rynda_183()
{
    NTD_TEST_GROUP_START("RYNDA-183", 1);
    char output[200];
    uint64_t *uint64_ptr;
    uint64_t float_as_uint64;

    VERBOSE_PRINTF("\nTEST1:\n");
    {
        double num1 = 0.0;
        double expect_val = 0.1;
        char *expect = "num1: 0.1000000000000000 1";

        sscanf("0.1", "%lf", &num1);
        TESTCASE(num1 == expect_val);

        VERBOSE_PRINTF("sscanf of 0.1 produced num = %16.16llx\n", double_to_uint64(num1));
        VERBOSE_PRINTF("expected                   = %16.16llx\n", double_to_uint64(expect_val));
        VERBOSE_PRINTF("num1: %.16f %d\n", num1, num1 == 0.1);

        sprintf(output, "num1: %.16f %d", num1, num1 == 0.1);
        if (strcmp(output, expect)) {
            printf("sscanf of 0.1 produced num = %16.16llx\n", double_to_uint64(num1));
            printf("expect                     = %16.16llx\n", double_to_uint64(expect_val));
            printf("sprintf produced '%s'\n", output);
            printf("expected         '%s'\n", expect);
            TESTCASE(strcmp(output,expect) == 0);
        } else {
            TESTCASE(1);
        }
    }
    VERBOSE_PRINTF("\nTEST2:\n");
    {
        float num2 = 0.0;
        float expect_val = 0.1;
        char *expect = "num2: 0.1000000014901161 1";

        sscanf("0.1f", "%f", &num2);

        TESTCASE(num2 == expect_val);

        VERBOSE_PRINTF("sscanf of 0.1 produced num2 = %8.8x\n", float_to_uint32(num2));
        VERBOSE_PRINTF("expected                      %8.8x\n", float_to_uint32(expect_val));
        VERBOSE_PRINTF("num2: %.16f %d\n", num2, num2 == 0.1f);

        sprintf(output, "num2: %.16f %d", num2, num2 == 0.1f);
        if (strcmp(output, expect)) {
            VERBOSE_PRINTF("FAILED\n");
            printf("sscanf of 0.1 produced num2 = %8.8x\n", float_to_uint32(num2));
            printf("expected                      %8.8x\n", float_to_uint32(expect_val));
            printf("sprintf produced '%s'\n", output);
            printf("expected         '%s'\n", expect);
            TESTCASE(strcmp(output,expect) == 0);
        } else {
            TESTCASE(1);
        }
    }
    VERBOSE_PRINTF("\nTEST3:\n");
    {
        float num3 = 0.0;
        float expect_val = 1.5;
        char *expect = "num3: 1.5000000000000000 1";

        sscanf("1.5f", "%f", &num3);

        TESTCASE(num3 == expect_val);

        VERBOSE_PRINTF("sscanf of 1.5 produced num3 = %8.8x\n", float_to_uint32(num3));
        VERBOSE_PRINTF("expected                      %8.8x\n", float_to_uint32(expect_val));
        VERBOSE_PRINTF("num3: %.16f %d\n", num3, num3 == 1.5f);

        sprintf(output, "num3: %.16f %d", num3, num3 == 1.5f);
        if (strcmp(output,expect)) {
            VERBOSE_PRINTF("FAILED\n");
            printf("sscanf of 1.5 produced num3 = %8.8x\n", float_to_uint32(num3));
            printf("expected                      %8.8x\n", float_to_uint32(expect_val));
            printf("sprintf produced '%s'\n", output);
            printf("expected         '%s'\n", expect);
            TESTCASE(strcmp(output,expect) == 0);
        } else {
            TESTCASE(1);
        }
    }
    NTD_TEST_GROUP_END("RYNDA-183", 1);
}
