﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nnt/gtest/detail/gtest-cstring.h>
#include <nnt/gtest/detail/gtest-heap.h>
#include <nnt/gtest/detail/gtest-string.h>

namespace nnt { namespace testing { namespace detail {

String::String(size_t n, char c) NN_NOEXCEPT
{
    auto p = static_cast<char*>(Heap::Allocate(sizeof(char) * (n + 1)));
    NN_SDK_ASSERT_NOT_NULL(p);
    CString::Memset(p, c, n);
    p[n] = '\0';
    this->Initialize(p, n);
    Heap::Free(p);
}

void String::Initialize(const char* str, size_t num) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(str);
    auto p = static_cast<char*>(Heap::Allocate(sizeof(char) * (num + 1)));
    NN_SDK_ASSERT_NOT_NULL(p);
    CString::Strncpy(p, str, num);
    p[num] = '\0';
    this->m_pBuffer = p;
    this->m_Count = num;
}

void String::Finalize() NN_NOEXCEPT
{
    if (this->m_pBuffer)
    {
        Heap::Free(this->m_pBuffer);
        this->m_pBuffer = nullptr;
    }
    this->m_Count = 0;
}

String& String::Append(const char* str, size_t num) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(str);
    size_t n = this->m_Count + num;
    auto p = static_cast<char*>(Heap::Allocate(sizeof(char) * (n + 1)));
    NN_SDK_ASSERT_NOT_NULL(p);
    CString::Strncpy(p, this->m_pBuffer, this->m_Count);
    CString::Strncpy(&p[this->m_Count], str, num);
    p[n] = '\0';
    Heap::Free(this->m_pBuffer);
    this->m_pBuffer = p;
    this->m_Count = n;
    return *this;
}

String& String::Erase(size_t pos, size_t len) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_LESS(pos, this->m_Count);
    NN_SDK_REQUIRES_LESS_EQUAL(pos + len, this->m_Count);
    char* ptr1 = this->m_pBuffer + pos;
    const char* ptr2 = ptr1 + len;
    const char* const tail = this->m_pBuffer + this->m_Count;
    while (ptr2 <= tail) { *(ptr1++) = *(ptr2++); }
    this->m_Count -= len;
    return *this;
}

}}} // namespace nnt::testing::detail
