﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace testing { namespace detail {

class Cctype
{
public:
    static int Isalnum(int ch) NN_NOEXCEPT
    {
        if ('0' <= ch && ch <='9') { return 1; }
        if ('A' <= ch && ch <='Z') { return 1; }
        if ('a' <= ch && ch <='z') { return 1; }
        return 0;
    }

private:
    Cctype();

    NN_DISALLOW_COPY(Cctype);
    NN_DISALLOW_MOVE(Cctype);
};

}}} // namespace nnt::testing::detail
