﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace Util
{
    public class NspInfo
    {
        // <AppletName>_<任意の文字列>.X_Y_Z.nsp
        // filename : <AppletName>_<任意の文字列>
        // name : <AppletName>
        // version : X_Y_Z
        public static readonly Regex FileNameFormat = new Regex(@"(?<filename>.+)\.(?<version>\d_\d_\d)\.nsp");

        // <Name>.<Revision>.X_Y_Z.nsp
        // filename : <Name>.<Revision>
        // name : <Name>
        // version : X_Y_Z
        public static readonly Regex FileNameWithRevisionFormat = new Regex(@"(?<filename>(?<name>.+)\..+)\.(?<version>\d_\d_\d)\.nsp");

        public string Name { get; set; }
        public string Version { get; set; }
        public string FileName { get; set; }
    }
}
