﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        アプレットのパスマッピングを定義する narl ファイルを出力します。

    .DESCRIPTION
        無し
#>

function Get-FirmwareVersion()
{
    $NintendoSdkRoot = Join-Path $Root "..\..\..\"
    $FirmwareVersionXmlPath = Join-Path $NintendoSdkRoot "Common\Versions\NXFirmwareVersion.xml"

    $FirmwareVersionXml = [xml](Get-Content $FirmwareVersionXmlPath)

    return "{0}_{1}_{2}" -f $FirmwareVersionXml.Product.Version.Major, $FirmwareVersionXml.Product.Version.Minor, $FirmwareVersionXml.Product.Version.Micro
}

$ScriptPath = $MyInvocation.MyCommand.Path
$ScriptDir = [System.IO.Path]::GetDirectoryName($ScriptPath)
$Root = Join-Path $ScriptDir "..\"

$CsFileDir = Join-Path $Root "Build\Util"
$CsFiles = Get-ChildItem $CsFileDir "*.cs" | %{ $_.FullName }
Add-Type -Path $CsFiles

$AppletRoot = Join-Path $Root "Applets"

$FirmwareVersion = Get-FirmwareVersion

# SDK ユーザ向けのアプレットをリネーム
Get-ChildItem -Path $AppletRoot -Recurse "*.nsp" | %{
    $newName = [Util.RenameUtil]::GetOceanFileNameForDeveloper($_.FullName)
    if( $_.Name -ne $newName)
    {
        ren $_.FullName $newName
    }
}

# ファイル名にファームウェアバージョンを入れる
Get-ChildItem -Path $Root -Recurse "*.nsp" | %{
    $newName = [Util.RenameUtil]::AddFirmwareVersion($_.FullName, $FirmwareVersion)
    if( $_.Name -ne $newName)
    {
        ren $_.FullName $newName
    }
}

$OutputFilePath = Join-Path $Root "BuiltBinaryPath.narl"

[Util.RuleGenerator]::Generate($Root) | Out-File $OutputFilePath -Encoding utf8
