﻿//==============================================================================
//
//  Main entry for Data Breakpoint Test
//
//==============================================================================

#ifndef __NX__
#else
#include <nn/tma/tma.h>
#endif

void BasicTest1()
{
    int a;
    int hold = 0;                                                                   //DataKey00 //SetDataBP01

    // Test some very simple writes.
    a = 20;                                                                         //DataKey01

    int b = -9823;                                                                  //DataKey02
    a = b;

    int c = 333;                                                                    //DataKey03

    a = b = c;                                                                      //DataKey04

    // Test simple indirect writes.
    int* pA = &a;                                                                   //DataKey05
    *pA = 51;                                                                       //DataKey06

    int& rA = a;                                                                    //DataKey07
    rA = 881;                                                                       //DataKey08

    pA = &rA;                                                                       //DataKey09
    *pA = -787;                                                                     //DataKey10

    // Breakpoint for a should be removed, this should not be hit.
    a = 10000;

    // Note: Initialization does not seem to trigger a data breakpoint.
    int32_t arr[100] = {0};                                                         //DataKey11
    hold = 0;                                                                       //DataKey12

    const int index = 49;

    arr[index] = 100;

    // Overflow high bits into previous index to make value 4, assuming little-endian.
    *((int64_t*) (((int32_t*) arr) + (index - 1))) = ((int64_t)2 << 33);            //DataKey13

    // Breakpoint for arr should be removed, this should not be hit.
    arr[index] = -98237;                                                            //DataKey14
}

struct simple_struct
{
    char c;
};

class overwrite_class
{
public:
    overwrite_class();

    int32_t a;
    int32_t b;
    int32_t c;
};

overwrite_class::overwrite_class()
{
    a = 100;                                                                         //DataKey16
    b = 200;
    c = 300;
}

void BasicTest2()
{
    //Test class members.
    simple_struct a;
    simple_struct b;

    int hold = 0;                                                                   //DataKey15

    b.c = 'q';
    a.c = b.c;

    char* pAc = &a.c;

    *pAc = '7';

    char& rAc = a.c;
    rAc = '$';


    //Test overwriting struct members
    overwrite_class o;

    o.b = 88;

    int64_t* pOa = (int64_t*)&o.a;

    //Write 15 into b, assuming little-endian.
    *pOa = 0x0000000FFFFFFFFF;
    //       ---------^-------- oh no!

    o.b = 55;
}

void SameTest()
{
    int a = -20;

    a = -328;
    a = -328;

    int dummy = 199;
}

#ifndef __NX__
int main(int argc, char** argv)
#else
extern "C" void nnMain()
#endif
{
    SameTest();
    BasicTest1();
    BasicTest2();

#ifndef __NX__
    return 0;
#else
    return;
#endif
}
