﻿/*--------------------------------------------------------------------------------*
Copyright (C)Nintendo All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os/os_SdkThreadApi.h>
#include <nn/time/time_Api.h>
#include <mutex>
#include <map>

struct NroTlsStruct2
{
    int             mInt        = 0x2;
    long long       mLongLong   = 0x20;
    NroTlsStruct2*  mpStruct    = nullptr;
    char            mChar       = '2';
};

extern std::mutex gCoutMutex;

thread_local int    gNroTlsInt2     = 0x22222222;
thread_local float  gNroTlsFloat2   = 2.0f;
//thread_local std::map<float, std::map<int, char*>> gNro2TlsVector;

void NroPrint2()
{
    thread_local int            tlsInt      = 0x20202020;
    thread_local float          tlsFloat    = 20.0f;
    thread_local NroTlsStruct2* tlsStruct   = nullptr;
    tlsStruct = new NroTlsStruct2();

    gCoutMutex.lock();
    NN_LOG( "NroPrint2()\n" );
    NN_LOG( "NroPrint2: gNroTlsInt2: (0x%p): %x, gNroTlsFloat2: (0x%p): %f\n", &gNroTlsInt2, gNroTlsInt2, &gNroTlsFloat2, gNroTlsFloat2 );
    NN_LOG( "NroPrint2: tlsInt:      (0x%p): %x, tlsFloat:      (0x%p): %f\n", &tlsInt, tlsInt, &tlsFloat, tlsFloat );
    NN_LOG( "NroPrint2: tlsStruct:   (0x%p): {%x, %llx, %p, %c}\n", &tlsStruct, tlsStruct->mInt, tlsStruct->mLongLong, tlsStruct->mpStruct, tlsStruct->mChar );
    NN_LOG( "\n" );
    gCoutMutex.unlock();

    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds( 1 ) ); // TLSVariablesTestBP05

    delete tlsStruct;
}
