﻿// The purpose of this test is to validate the expression parser
// can correctly navigate through complex arrays.

#include "stdio.h"

class BaseStructure
{
public:
    BaseStructure() : m_iLoc(-1), m_jLoc(-1), m_kLoc(-1), m_BaseDouble(0.0)
    {
    }
    virtual ~BaseStructure()
    {
    }

public:
    int     m_iLoc;
    int     m_jLoc;
    int     m_kLoc;
    double  m_BaseDouble;
};

class DataStructure : public BaseStructure
{
public:
    DataStructure() : m_DataInt( 0 ), m_DataDouble( 0.0 )
    {
    }
    virtual ~DataStructure()
    {
    }

public:
    static int s_DataCount;
    int        m_DataInt;
    double     m_DataDouble;
};
int DataStructure::s_DataCount = 0;

//==============================================================================

extern "C" void nnMain ( void )
{
    const int iSize = 3;
    const int jSize = 3;
    const int kSize = 3;
    DataStructure DSArray[iSize][jSize][kSize];

    for( int iData = 0; iData < iSize; ++iData )
    {
        for( int jData = 0; jData < jSize; ++jData )
        {
            for( int kData = 0; kData < kSize; ++kData )
            {
                DataStructure DS;
                DS.m_DataInt = iData * 100 + jData * 10 + kData;
                DS.m_DataDouble = (double)DS.m_DataInt;
                DS.m_iLoc = iData;
                DS.m_jLoc = jData;
                DS.m_kLoc = kData;
                DS.m_BaseDouble = (double)DataStructure::s_DataCount;
                DSArray[iData][jData][kData] = DS;

                ++DataStructure::s_DataCount;
            }
        }
    }

    DataStructure* DSpArray[iSize][jSize][kSize];
    for( int iData = 0; iData < iSize; ++iData )
    {
        for( int jData = 0; jData < jSize; ++jData )
        {
            for( int kData = 0; kData < kSize; ++kData )
            {
                DSpArray[iData][jData][kData] = &DSArray[iData][jData][kData];
            }
        }
    }

    // Not really iterating over elements. Testing type resolution of auto
    // variables, and indexing, pointer math, and other operations using
    // auto variables.
    for( auto &i : DSArray )
    {
        for( auto &j : i )
        {
            for( auto &k : j )
            {
                // Another series of auto loops for the DSpArray:
                for( auto &ip : DSpArray )
                {
                    for( auto &jp : ip )
                    {
                        for( auto &kp : jp )
                        {
                            printf( "%d\n", k.m_DataInt );
                            printf( "%d\n", kp->m_DataInt ); // ArrayMathTestBP01
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            }
            break;
        }
        break;
    }

    return;
}
