﻿#include <nn/tma/tma.h>
#include <nn/os/os_MemoryHeap.h>
#include <nn/nn_Abort.h>
#include <nn/nn_log.h>

// The purpose of this test is to verify the scope address range when a lexical
// scope is composed of disjoint address ranges. By having the NN_ABORT call
// in this O1 optimized test code, the lexical scope is split into mutliple
// disjoint address ranges. As a result, the scope of the ScopedVars is split
// over non-adjacent line numbers. This test is meant to verify correct behavior.
// HOWEVER, the generated debugging information will have to be manually verified
// anytime the source changes, the compile settings change, or a new RYNDA or SDK
// is used.
//
// Here is an example of the generated debugging information (Develop, NX32, O1):
//@<1><10f4>: Abbrev Number : 41[3, 482]( DW_TAG_subprogram )
//    <10f5>   DW_AT_low_pc : {DW_FORM_addr} 0x29c
//    <10f9>   DW_AT_high_pc : {DW_FORM_data4} 0xaf4
//    <10fd>   DW_AT_frame_base : {DW_FORM_exprloc} 1 byte block : 5b( DW_OP_reg11( r11 ) )
//    <10ff>   DW_AT_name : {DW_FORM_strp} ( indirect string, offset: 0xf37 ) : nnMain
//... (extra data removed for clarity) ...
//    @<2><116a>: Abbrev Number : 44[3, 490]( DW_TAG_lexical_block )
//        <116b>   DW_AT_ranges : {DW_FORM_sec_offset} {DW_FORM_sec_offset}  80  0x50
//        @<3><116f>: Abbrev Number : 42[3, 491]( DW_TAG_variable )
//            <1170>   DW_AT_location : {DW_FORM_sec_offset} {DW_FORM_sec_offset}  39  0x27 ( location list )
//            <1174>   DW_AT_name : {DW_FORM_strp} ( indirect string, offset: 0xf50 ) : ScopedVar1
//... (extra data removed for clarity) ...
//
// Note the "DW_TAG_lexical_block" in nnMain() with the "DW_AT_ranges" attribute.
// The generated address ranges for the lexical block:
//50:
//000002b0 - 000007e0
//00000cc4 - 00000cf0
//00000000 - 00000000
//
// This specifies the lexical block exists for two address ranges. If the base
// address is added to these ranges, you will have the absolute addresses that
// match the disassembly when stepping through the code. When stepping though
// the addresses between 7e0 and cc4, ScopedVar1 should not exist.
extern "C" void nnMain()
{
    nn::Result result;

    size_t size;
    {
        auto result = nn::os::SetMemoryHeapSize( 32 * 1024 * 1024 );

        int         ScopedVar1 = 11;
        long long   ScopedVar2 = 12;
        int         ScopedVar3 = 13;
        long long   ScopedVar4 = 14;
        int         ScopedVar5 = 15;

        ScopedVar1++;
        ScopedVar2++;
        ScopedVar3++;
        ScopedVar4++;
        ScopedVar5++;

        NN_LOG( "int ScopedVar1 address: 0x%p\n", &ScopedVar1 );
        NN_LOG( "int ScopedVar1 value: %d\n", ScopedVar1 );
        NN_LOG( "long long ScopedVar2 address: 0x%p\n", &ScopedVar2 );
        NN_LOG( "long long ScopedVar2 value: %lld\n", ScopedVar2 );
        NN_LOG( "int ScopedVar3 address: 0x%p\n", &ScopedVar3 );
        NN_LOG( "int ScopedVar3 value: %d\n", ScopedVar3 );
        NN_LOG( "long long ScopedVar4 address: 0x%p\n", &ScopedVar4 );
        NN_LOG( "long long ScopedVar4 value: %lld\n", ScopedVar4 );
        NN_LOG( "int ScopedVar5 address: 0x%p\n", &ScopedVar5 );
        NN_LOG( "int ScopedVar5 value: %d\n", ScopedVar5 );

        if( result.IsSuccess() )
        {
            NN_ABORT( "Aborting...\n" );
        }

        NN_LOG( "int ScopedVar1 address: 0x%p\n", &ScopedVar1 );
        NN_LOG( "int ScopedVar1 value: %d\n", ScopedVar1 );
        NN_LOG( "long long ScopedVar2 address: 0x%p\n", &ScopedVar2 );
        NN_LOG( "long long ScopedVar2 value: %lld\n", ScopedVar2 );
        NN_LOG( "int ScopedVar3 address: 0x%p\n", &ScopedVar3 );
        NN_LOG( "int ScopedVar3 value: %d\n", ScopedVar3 );
        NN_LOG( "long long ScopedVar4 address: 0x%p\n", &ScopedVar4 );
        NN_LOG( "long long ScopedVar4 value: %lld\n", ScopedVar4 );
        NN_LOG( "int ScopedVar5 address: 0x%p\n", &ScopedVar5 );
        NN_LOG( "int ScopedVar5 value: %d\n", ScopedVar5 );
    }

    // Set breakpoints below here and verify the ScopedVars are out of scope.
    // If the error "optimized variable out of address range" is returned,
    // then the ScopedVars are within scope, which is incorrect! The expected
    // error is "identifier "ScopedVarX" is undefined".
    float  Var1 = 1.0;
    double Var2 = 2.0; // AddressRangesTestBP01
    float  Var3 = 3.0;
    double Var4 = 4.0;
    float  Var5 = 5.0;

    NN_LOG( "float Var1 address: 0x%p\n", &Var1 );
    NN_LOG( "float Var1 value: %f\n", Var1 );
    NN_LOG( "double Var2 address: 0x%p\n", &Var2 );
    NN_LOG( "double Var2 value: %f\n", Var2 );
    NN_LOG( "float Var3 address: 0x%p\n", &Var3 );
    NN_LOG( "float Var3 value: %f\n", Var3 );
    NN_LOG( "double Var4 address: 0x%p\n", &Var4 );
    NN_LOG( "double Var4 value: %f\n", Var4 );
    NN_LOG( "float Var5 address: 0x%p\n", &Var5 );
    NN_LOG( "float Var5 value: %f\n", Var5 );

    Var1++;
    Var2++;
    Var3++;
    Var4++;
    Var5++;

    NN_LOG( "float Var1 address: 0x%p\n", &Var1 );
    NN_LOG( "float Var1 value: %f\n", Var1 );
    NN_LOG( "double Var2 address: 0x%p\n", &Var2 );
    NN_LOG( "double Var2 value: %f\n", Var2 );
    NN_LOG( "float Var3 address: 0x%p\n", &Var3 );
    NN_LOG( "float Var3 value: %f\n", Var3 );
    NN_LOG( "double Var4 address: 0x%p\n", &Var4 );
    NN_LOG( "double Var4 value: %f\n", Var4 );
    NN_LOG( "float Var5 address: 0x%p\n", &Var5 );
    NN_LOG( "float Var5 value: %f\n", Var5 );
}
