﻿//==============================================================================
//
//  Main entry for Registers Verification Test
//
//==============================================================================

#include "..\print.h"

extern "C" void nnMain()
{
    asm volatile( // Set breakpoint on line 11 for automated and manual tests, RegValueTest.01
        "movi  v1.16b, #255\n"
        "movi  v2.16b, #255\n"
        "movi  v3.16b, #255\n"
        "movi  v4.16b, #255\n"
    );

    asm volatile(
        "fmov  d1, #1.000000e+000\n"
        "fmov  d2, #2.000000e+000\n"
        "fmov  d3, #3.000000e+000\n"
        "fmov  d4, #4.000000e+000\n"
    );

    asm volatile(
        "fcvt  s1, d1\n"
        "fcvt  s2, d2\n"
        "fcvt  s3, d3\n"
        "fcvt  s4, d4\n"
    );

    asm volatile(
        "fcvt  h1, s1\n"
        "fcvt  h2, s2\n"
        "fcvt  h3, s3\n"
        "fcvt  h4, s4\n"
    );

    asm volatile(
        "fcvt  s1, h1\n"
        "fcvt  s2, h2\n"
        "fcvt  s3, h3\n"
        "fcvt  s4, h4\n"
    );

    asm volatile(
        "fcvt  d1, s1\n"
        "fcvt  d2, s2\n"
        "fcvt  d3, s3\n"
        "fcvt  d4, s4\n"
    );

    float Reg1 = 2313.6874f; // Set breakpoint here for manual test
    float Reg2 = 1.34589569e+08f;

    if( Reg1 > 0 )
    {
        Reg2 = Reg1 / Reg2;
    }
}
