﻿//==============================================================================
//
//  Main entry for NTD Thread Switching Test
//
//==============================================================================

#include "stdafx.h"
#include <nn/os.h>

#include "../print.h"

static const int THREAD_STACK_SIZE = 4096;

static void thread_work_proc(void *)
{
    int x = 0;
}

extern "C" void nnMain()
{
    PRINT( "Running program from " __FILE__ "\n" );

    NN_ALIGNAS( nn::os::StackRegionAlignment ) static char s_CallbackStack[THREAD_STACK_SIZE];
    static nn::os::ThreadType s_CallbackthreadHandle;
    nn::os::CreateThread(&s_CallbackthreadHandle, thread_work_proc, (void *)"work_proc",
        s_CallbackStack, THREAD_STACK_SIZE, nn::os::DefaultThreadPriority, 2 );
    nn::os::StartThread( &s_CallbackthreadHandle );

    while ( 1 );
}
