﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os/os_SdkThreadApi.h>
#include <nn/time/time_Api.h>
#include <mutex>

struct LibTlsStruct1
{
    int             mInt        = 0x1;
    long long       mLongLong   = 0x10;
    LibTlsStruct1*  mpStruct    = nullptr;
    char            mChar       = '1';
};

extern std::mutex gCoutMutex;

thread_local int    gLibTlsInt1     = 0x11111111;
thread_local float  gLibTlsFloat1   = 10.0f;

void LibPrint1()
{
    thread_local int            tlsInt      = 0x10101010;
    thread_local float          tlsFloat    = 100.0f;
    thread_local LibTlsStruct1* tlsStruct   = nullptr;
    tlsStruct = new LibTlsStruct1();

    gCoutMutex.lock();
    NN_LOG( "LibPrint1()\n" );
    NN_LOG( "LibPrint1: gLibTlsInt1:  (0x%p): %x, gLibTlsFloat1: (0x%p): %f\n", &gLibTlsInt1, gLibTlsInt1, &gLibTlsFloat1, gLibTlsFloat1 );
    NN_LOG( "LibPrint1: tlsInt:       (0x%p): %x, tlsFloat:      (0x%p): %f\n", &tlsInt, tlsInt, &tlsFloat, tlsFloat );
    NN_LOG( "LibPrint1: tlsStruct:    (0x%p): {%x, %llx, %p, %c}\n", &tlsStruct, tlsStruct->mInt, tlsStruct->mLongLong, tlsStruct->mpStruct, tlsStruct->mChar );
    NN_LOG( "\n" );
    gCoutMutex.unlock(); // TLSVariablesTestBP01

    nn::os::SleepThread( nn::TimeSpan::FromSeconds( 1 ) );

    delete tlsStruct;
}
