﻿// The purpose of the test is to validate a long string can be read from TM.

#include <stdio.h>
#include <string>

extern "C" void nnMain( void )
{
    // Generate a long string. Each 16 character portion counts the number of
    // printed characters in hex. e.g. "      0x00000010      0x00000020" has
    // 32 characters printed, as indicated by the final hex number 0x00000020.
    std::string LongString;
    for( int iString = 0x10; iString <= 1000000; iString+=0x10 )
    {
        char Buffer[17];
        sprintf( Buffer, "      %#010x", iString );
        LongString += Buffer;
    }
    const char* pLongString = LongString.c_str();

    std::wstring LongWString;
    for( int iString = 0x10; iString <= 1000000; iString+=0x10 )
    {
        wchar_t Buffer[17];
        swprintf( Buffer, 17, L"      %#010x", iString );
        LongWString += Buffer;
    }
    const wchar_t* pLongWString = LongWString.c_str();

    int SetBreakpointHere = 0;
}
