/*--------------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo. All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// MUGEN ֘A̋@\܂B

ERROR_MUGEN_NOT_INSTALLED         = 1000;
ERROR_MUGEN_NDICMD_NOT_FOUND      = 1001;
ERROR_MUGEN_NDICMD_FAILURE        = 1002;
ERROR_MUGEN_NDICMD_INVALID_OUTPUT = 1003;

// ---- |󂪕Kvȉӏ []
ERROR_TEXT_NEED_NEWER_VERSION_NDI = "Please use NDI version 1.4 or later. If there is no improvement in symptoms, please contact SDK support group.";
ERROR_TEXT_NOT_FOUND_NDI          = "NDICmd.exe is not found.";
ERROR_TEXT_FAILED_NDI_EXECUTION   = "Failed to execute NDICmd.exe .";
ERROR_TEXT_FAILED_GET_ENVIRONMENT = "Failed to get \"Installed environment\".";
// ---- [܂]

Mugen = function(){}

Mugen.internal = function(){}
Mugen.internal.getInstallationPathFromRegistory = function() {
    var shell = new ActiveXObject("WScript.Shell");
    var key = "HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{0FEB1F75-291B-4327-85F7-B3876B98D0B1}_is1\\InstallLocation";
    try {
        var path = shell.RegRead(key);
    }catch(e){
        return null;
    }
    return path;
}

// Iɂ NDI  JSON Ԃ悤ɂȂ̂ŕsvɂȂ
Mugen.internal.parseEnvironments = function(envStrings) {
    var ndiResult = eval("t=" + envStrings);
    var results = ndiResult.Result;
    var envs = []
    
    var i;
    var result;
    for(i = 0; i < results.length; ++i) {
        result = results[i];
        envs.push({
            "name": result.Name,
            "path": result.Root + "\\" + result.Name + "\\NintendoSDK"
        });
    }
    return envs;
}

Mugen.internal.runExternalProgram = function(path, arguments, output) {
    var errorOutput = {};
    return ExecuteExternalCommand(path, arguments, output, errorOutput);
}


Mugen.internal.findClickOnceAppCallback = function(fso, path, currentDepth, obj) {
    var m = ("" + path).match(/2.0\\Data/);
    if(m != null) {
        return true;
    }
    m = ("" + path).match(/ndi\.\.\.tion_/);
    if(m != null && m.length > 0) {
        obj.path = path;
        return false;
    }
    
    if(currentDepth >= 4) {
        return true;
    }
    
    var c = Mugen.internal.find(fso, path, currentDepth, Mugen.internal.findClickOnceAppCallback, obj);
    if(!c) {
        return false;
    }
    
    return true;
}

Mugen.internal.find = function(fso, path, currentDepth, callback, obj) {
    if(!fso.FolderExists(path)) {
        return false;
    }
    var dir = fso.getFolder(path);
    var e = new Enumerator(dir.SubFolders);
    for(; !e.atEnd(); e.moveNext()) {
        var c = callback(fso, e.item(), currentDepth + 1, obj);
        if(!c) {
            return false;
        }
    }
    return true;
}

Mugen.internal.findClickOnceAppPath = function() {
    var fso = new ActiveXObject("Scripting.FileSystemObject");
    var shell = new ActiveXObject("WScript.Shell");
    var root = shell.ExpandEnvironmentStrings("%USERPROFILE%") + "\\AppData\\Local\\Apps\\2.0";
    var result = {};
    Mugen.internal.find(fso, root, 0, Mugen.internal.findClickOnceAppCallback, result);
    
    var appPath = result.path == null ? null : result.path + "\\";
    return appPath;
}


// MUGEN ̃CXg[Ԃ܂B
Mugen.getInstallationPath = function() {
    var pathFromRegistory = Mugen.internal.getInstallationPathFromRegistory();
    var pathFromClickOnce = Mugen.internal.findClickOnceAppPath();

    // WXg D
    if(pathFromRegistory != null) {
        return pathFromRegistory;
    }
    if(pathFromClickOnce != null) {
        return pathFromClickOnce;
    }

    // ClickOnce ʏCXg[Ȃꍇ null ԂB
    return null;
}  

Mugen.internal.getEnvironmentsBy1_4Client = function(installationPath) {
    var fso = new ActiveXObject("Scripting.FileSystemObject");
    var ndi = installationPath + "NDICmd.exe";
    if(!fso.FileExists(ndi)) {
        var error = new Error("Path: " + ndi + "\n" + ERROR_TEXT_NOT_FOUND_NDI + ERROR_TEXT_NEED_NEWER_VERSION_NDI);
        error.id = ERROR_MUGEN_NDICMD_NOT_FOUND;
        throw error;
    }
    

    var output = {};
    var cmdline = ndi;
    var arguments = "-j q Environments";
    var retval = Mugen.internal.runExternalProgram(cmdline, arguments, output);
    if(retval != 0) {
        var error = new Error(ERROR_TEXT_FAILED_NDI_EXECUTION + ERROR_TEXT_NEED_NEWER_VERSION_NDI);
        error.id = ERROR_MUGEN_NDICMD_FAILURE;
        throw error;
    }
    
    try {
        var envs = Mugen.internal.parseEnvironments(output.value);
        return envs;
    }catch (e) {
        var error = new Error(ERROR_TEXT_FAILED_GET_ENVIRONMENT + ERROR_TEXT_NEED_NEWER_VERSION_NDI)
        error.id = ERROR_MUGEN_NDICMD_INVALID_OUTPUT;
        throw error;
    }
}

// MUGEN ̊ǗĂԂ܂B͂ MUGEN {̂̃pXB
Mugen.internal.getEnvironmentsBy1_4Client = function(installationPath)
{
    var fso = new ActiveXObject("Scripting.FileSystemObject");
    var ndi = installationPath + "NDICmd.exe";
    if(!fso.FileExists(ndi)) {
        var error = new Error("Path: " + ndi + "\n" + ERROR_TEXT_NOT_FOUND_NDI + ERROR_TEXT_NEED_NEWER_VERSION_NDI);
        error.id = ERROR_MUGEN_NDICMD_NOT_FOUND;
        throw error;
    }
    

    var output = {};
    var cmdline = ndi;
    var arguments = "-j q Environments";
    var retval = Mugen.internal.runExternalProgram(cmdline, arguments, output);
    if(retval != 0) {
        var error = new Error(ERROR_TEXT_FAILED_NDI_EXECUTION + ERROR_TEXT_NEED_NEWER_VERSION_NDI);
        error.id = ERROR_MUGEN_NDICMD_FAILURE;
        throw error;
    }
    
    try {
        var envs = Mugen.internal.parseEnvironments(output.value);
        return envs;
    }catch (e) {
        var error = new Error(ERROR_TEXT_FAILED_GET_ENVIRONMENT + ERROR_TEXT_NEED_NEWER_VERSION_NDI)
        error.id = ERROR_MUGEN_NDICMD_INVALID_OUTPUT;
        throw error;
    }
}

// MUGEN ̊ǗĂԂ܂B͂ MUGEN {̂̃pXB
Mugen.getEnvironments = function(installationPath)
{
    return Mugen.internal.getEnvironmentsBy1_4Client(installationPath);
}
