/*--------------------------------------------------------------------------*
 Project:
 File: sys_WindowManager.h
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_WINDOW_MANAGER_H_
#define _UJI_SYS_WINDOW_MANAGER_H_

#include <nn/gx.h>
#include "sys_Window.h"


namespace uji {
namespace sys {
    
class WindowManager
{
public:
    WindowManager();
    ~WindowManager();
    
    // EChE̐Ej
    bool CreateWindow(Window* window, s32 display, int x, int y);
    bool CreateWindow(Window* window, s32 display, int x, int y, int width, int height)
    {
        window->SetSize(Size(width, height));
        return this->CreateWindow(window, display, x, y); 
    }
    void DestroyWindow( Window* window );

    // EChE̍XV
    void Update();

    // pbh̍XV
    void UpdatePad(const Pad& pad);

    // EChE̕`
    void Draw(s32 display);
    void DrawDisplay0() { this->Draw(NN_GX_DISPLAY0); }
    void DrawDisplay1() { this->Draw(NN_GX_DISPLAY1); }
#if 0    
    // TODO: ANeBuEChE̕ύXɗp\
    void SetWindowControlFlag(bool enable) { m_EnableWindowControl = enable; }
    bool GetWindowControlFlag() const { return m_EnableWindowControl; }
    bool IsPressWindowControlKey( const Pad& pad ) const;    
#endif
    // EChENCAg̈̃At@l
    void SetAlpha(int alpha) { m_MasterAlpha = alpha; }
    float GetAlpha() const { return m_MasterAlpha; }
    
    // EChE`tO̐ݒE擾
    void SetWindowVisibleFlag(bool flag) { m_VisibleFlag = flag; }
    bool GetWindowVisibleFlag() { return m_VisibleFlag; }
    
    // ANeBuEChE̐ݒE擾
    void SetActiveWindow(Window* window);    
    Window* GetActiveWindow() { return m_ActiveWindow; }

    // EChEXg̎擾
    WindowList& GetWindowList() { return m_WindowList; }
    const WindowList& GetWindowList() const { return m_WindowList; }
    
    // EChEI[_[֘A
    WindowZOrderList& detail_GetWindowZOrderList() { return m_WindowDrawList; }
    const WindowZOrderList& detail_GetWindowZOrderList() const { return m_WindowDrawList; }
    void detail_SortWindowList();
    void detail_SortWindowZOrderList();
    
    // }X^[At@lɑ΂ĉ
    void ChangeMasterAlpha(int add);
    
    // EChE}l[W̃pbh̗L/ݒE擾
    void SetManagerPadControlFlag(bool enable) { m_EnableManagerPadControl = enable; }
    bool GetManagerPadControlFlag() const { return m_EnableManagerPadControl; }    
    
private:    
    void UpdateActiveWindow();
    void UpdateOrder();

    Window* GetWindowByIndex(int index);
    int GetWindowIndex(Window* window);

    void OnUpdatePad(const Pad& pad);

#if 0    
    bool    m_EnableWindowControl;
#endif
    bool    m_EnableManagerPadControl;
    
    bool    m_WindowMenuMode;
    bool    m_VisibleFlag;

    Window* m_ActiveWindow;
    bool    m_ActiveWindowToTop;
    
    int     m_MasterAlpha;
    
    WindowList          m_WindowList;
    WindowZOrderList    m_WindowDrawList;  
};

}   // usingnamespace sys
}   // usingnamespace uji
  

/* _UJI_SYS_WINDOW_MANAGER_H_ */
#endif

