/*--------------------------------------------------------------------------*
 Project:
 File: sys_WindowManager.cpp
 

*--------------------------------------------------------------------------*/
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_GraphicsDrawing.h"

#include <nn/gx.h>
#include <nw/ut/ut_Color.h>

    
namespace uji {
namespace sys {


/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
WindowManager::WindowManager()
  : m_EnableManagerPadControl(true),
    m_WindowMenuMode(false),
    m_VisibleFlag(true),    
    m_ActiveWindow(NULL),
    m_ActiveWindowToTop(true),
    m_MasterAlpha(nw::ut::Color8::ALPHA_MAX)
{
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
WindowManager::~WindowManager()
{
    for (WindowList::Iterator itr = m_WindowList.GetBeginIter(); 
         itr != m_WindowList.GetEndIter(); itr++)
    {
        itr->Destroy();
    }        
}

/*---------------------------------------------------------------------------
  Desc: EChE𐶐

  Args: windwo  EChE
        display \LCDiNN_GX_DISPLAY0 / NN_GX_DISPLAY1j
        x       \XW
        y       \YW

  Rtns: trueij/falseisj 
---------------------------------------------------------------------------*/
bool WindowManager::CreateWindow(Window* window, s32 display, int x, int y)
{
    NN_NULL_ASSERT(window);
    
    NW_ASSERTMSG((display == NN_GX_DISPLAY0) || (display == NN_GX_DISPLAY1),
        "Invalid Args :file(%s) line(%d)", __FILE__, __LINE__);
    
    if (!window->Create(display, x, y))
    {
        return false;
    }
    
    m_WindowList.PushBack(window);
    m_WindowDrawList.PushFront(window);
    UpdateOrder();
    
    SetActiveWindow(window);
    
    return true;
}

/*---------------------------------------------------------------------------
  Desc: wEChEj
h---------------------------------------------------------------------------*/
void WindowManager::DestroyWindow(Window* window)
{
    NN_NULL_ASSERT(window);
    if (window == m_ActiveWindow)
    {
        m_ActiveWindow = NULL;
    }
    
    window->Destroy();
    
    m_WindowList.Erase(window);
    m_WindowDrawList.Erase(window);
    UpdateOrder();
    
    UpdateActiveWindow();
}

/*---------------------------------------------------------------------------
  Desc: w肵EChEANeBuɂ
---------------------------------------------------------------------------*/
void WindowManager::SetActiveWindow(Window* window)
{
    m_ActiveWindow = window;
    
    for (WindowZOrderList::Iterator itr = m_WindowDrawList.GetBeginIter();
         itr != m_WindowDrawList.GetEndIter(); itr++)
    {
        itr->SetActiveFlag(&*itr == window);
    }
}

/*---------------------------------------------------------------------------
  Desc: SEChE̍XVs
---------------------------------------------------------------------------*/
void WindowManager::Update()
{
    for (WindowList::Iterator itr = m_WindowList.GetBeginIter();
         itr != m_WindowList.GetEndIter(); itr++)
    {
        itr->Update();   
    }
}

/*---------------------------------------------------------------------------
  Desc: pbh̍XV
        }l[WŗL̏ƃANeBuEChE UpdatePad ֐̎s
---------------------------------------------------------------------------*/
void WindowManager::UpdatePad(const Pad& pad)
{
    // ANeBuEChẼpbh
    if (m_VisibleFlag)
    {
        if (m_ActiveWindow != NULL)
        {
            m_ActiveWindow->UpdatePad(pad);
        }
    }
    
    // }l[W̃pbh
    if (m_EnableManagerPadControl)
    {
        // EChE̕\E\̐ؑ        
        if (pad.IsButtonDown(Pad::BUTTON_L))
        {
            m_VisibleFlag = (!m_VisibleFlag);   
        }
    
        // ANeBuEChE̐ؑ
        if (pad.IsButtonDown(Pad::BUTTON_R))
        {
            int index = 0, max;
            for (WindowList::Iterator itr = m_WindowList.GetBeginIter();
                itr != m_WindowList.GetEndIter(); itr++, index++)
            {
            }
            max = index;
            index = 0;
            for (WindowList::Iterator itr = m_WindowList.GetBeginIter();
                itr != m_WindowList.GetEndIter(); itr++, index++)
            {
                if (&*itr == m_ActiveWindow)
                {
                    if (index == (max-1))
                    {
                        itr = m_WindowList.GetBeginIter();
                    }
                    else
                    {
                        itr++;
                    }
                    Window* window = &*itr;
                    SetActiveWindow(window);
                    break;
                }
            }           
        }
    }
}

/*---------------------------------------------------------------------------
  Desc: EChE`悵܂ 
  
  Args: display - NN_GX_DISPLAY0/NN_GX_DISPLAY1   > for_SDK_0_9
  
  rtns: Ȃ
---------------------------------------------------------------------------*/
void WindowManager::Draw(s32 display)
{
    NW_ASSERTMSG((display == NN_GX_DISPLAY0) || (display == NN_GX_DISPLAY1),
        "Invalid Args :file(%s) line(%d)", __FILE__, __LINE__);
    
    if (m_VisibleFlag)
    {
        for (WindowZOrderList::ReverseIterator itr = m_WindowDrawList.GetBeginReverseIter();
             itr != m_WindowDrawList.GetEndReverseIter(); itr++)
        {
            if (m_ActiveWindowToTop && m_ActiveWindow == &*itr) 
            {
                // ANeBuEChEꎞIɍőOʂֈړ
                continue;
            }
            
            if (itr->GetVisibleFlag() && (itr->GetRenderDisplay() == display))
            {
                itr->Draw(m_MasterAlpha, itr->GetWindowShadeFlag());
            }
        }
        
        if (m_ActiveWindow != NULL && m_ActiveWindowToTop && (m_ActiveWindow->GetRenderDisplay() == display))
        {
            m_ActiveWindow->Draw(m_MasterAlpha, false);
        }
    }
}
    
/*---------------------------------------------------------------------------
  Desc: At@l̕ύX
---------------------------------------------------------------------------*/
void WindowManager::ChangeMasterAlpha(int add)
{
    int alpha = m_MasterAlpha;
    alpha += add;

    alpha = nw::ut::Clamp<int>(alpha, nw::ut::Color8::ALPHA_MIN, nw::ut::Color8::ALPHA_MAX);
    
    m_MasterAlpha = alpha;
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void WindowManager::UpdateActiveWindow()
{
    if (!m_WindowList.IsEmpty())
    {
        WindowList::Iterator itr = m_WindowList.GetBeginIter();
     
        Window* window = &*itr;
        SetActiveWindow(window);
    }   
    else
    {
        SetActiveWindow(NULL);
        m_ActiveWindowToTop = false;
    }
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
Window* WindowManager::GetWindowByIndex(int specifiedIndex)
{
    int index = 0;
    for (WindowList::Iterator itr = m_WindowList.GetBeginIter();
         itr != m_WindowList.GetEndIter(); itr++)
    {
        if (index == specifiedIndex)
        {
            return &*itr;   
        }
        index++;
    }
    return NULL;
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
int WindowManager::GetWindowIndex(Window* window)
{
    int index = 0;
    for (WindowList::Iterator itr = m_WindowList.GetBeginIter();
         itr != m_WindowList.GetEndIter(); itr++)
    {
        if (window == &*itr) 
        {
            return index;
        }
        index++;
    }
    return -1;
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void WindowManager::UpdateOrder()
{
    int index = 0;
    for (WindowZOrderList::Iterator itr = m_WindowDrawList.GetBeginIter();
         itr != m_WindowDrawList.GetEndIter(); itr++, index++)
    {
        itr->detail_SetWindowZOrder(index);
    }
    
    index = 0;
    for (WindowList::Iterator itr = m_WindowList.GetBeginIter();
         itr != m_WindowList.GetEndIter(); itr++, index++)
    {
        itr->detail_SetWindowListOrder(index);
    }
}

}   // usingnamespace sys
}   // usingnamespace uji
