/*--------------------------------------------------------------------------*
 Project:
 File: sys_Window.h
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_WINDOW_H_
#define _UJI_SYS_WINDOW_H_

#include <nn/gx.h>
#include <nw/ut/ut_Color.h>
#include <nw/ut/ut_LinkList.h>

#include "sys_GraphicsDrawing.h"
#include "sys_Pad.h"


namespace uji {
namespace sys {

enum
{
    RECT_RT,
    RECT_LT,
    RECT_LB,
    RECT_RB,

    RECT_NUM
};

class GraphicsDrawing;
class Pad;


struct Point
{
    int x;
    int y;

    Point() : x(0), y(0) {}
    Point( int x_, int y_ ) : x(x_), y(y_) {}
};

struct Size
{
    int width;
    int height;
    
    Size() : width(0), height(0) {}
    Size( int width_, int height_ ) : width(width_), height(height_) {}
};

class Window
{
public:
    static const int TITLE_LEN_MAX = 64;

    // Ej
    Window(const char* title, int width=0, int height=0);
    virtual ~Window();
    
    bool Create(s32 display, int x, int y)
    {
        return this->Create(display, Point(x,y));
    }
    bool Create(s32 display, const Point& pos);
    void Destroy();
    
    // XV
    void Update();

    // pbh̍XV
    void UpdatePad(const Pad& pad);
    
    // ` 
    void Draw()
    {
        this->Draw(255, mWindowShadeFlag);
    }
    void Draw(int alpha, bool shadeFlag);
    
    // EChEʒu̐ݒE擾     
    void SetPosition(const Point& pos) { mPos = pos; }
    const Point GetPosition() const { return mPos; }
    
    // EBhETCY̐ݒE擾
    void SetSize(const Size& size);
    const Size GetSize() const { return mSize; }
    
    // NCAg̈̃TCYݒE擾
    void SetClientSize(const Size& size);
    const Size GetClientSize() const;
    // NCAg̈̈ʒu擾
    const Point GetClientPosition() const;

    void SetMinimumSize(const Size& size) { mMinSize = size; }
    const Size GetMinimumSize() const { return mMinSize; }
    void SetMaximumSize(const Size& size) { mMaxSize = size; }
    const Size GetMaximumSize() const { return mMaxSize; }

    // EBhE^Cg̐ݒE擾
    void SetTitle(const char* title);
    const char* GetTitle() const { return mTitle; }
    int GetTitleBarHeight() const { return TITLE_HEIGHT + FRAME_WIDTH * 2; }
    
    // NCAg̈̃J[̐ݒE擾
    void SetBackColor(const nw::ut::Color8 color) { mBackColor = color; }
    nw::ut::Color8 GetBackColor() const { return mBackColor; }

    // ^CgwiF(rect_pos͔wip4̒_ꂼ 0:E 1: 2: 3:E ̏ɑΉ)
    void SetTitleBackColor(const u32 rect_pos, const nw::ut::Color8 color) { mTitleBackColor[rect_pos] = color; }
    void SetTitleBackColor(const nw::ut::Color8 color0, const nw::ut::Color8 color1,
                           const nw::ut::Color8 color2, const nw::ut::Color8 color3) 
                           { mTitleBackColor[RECT_RT] = color0; mTitleBackColor[RECT_LT] = color1; 
                             mTitleBackColor[RECT_LB] = color2; mTitleBackColor[RECT_RB] = color3; }
    void SetTitleBackColor(const nw::ut::Color8 color) 
                           { mTitleBackColor[RECT_RT] = color; mTitleBackColor[RECT_LT] = color; 
                             mTitleBackColor[RECT_LB] = color; mTitleBackColor[RECT_RB] = color; }
    nw::ut::Color8 GetTitleBackColor(const u32 rect_pos) const { return mTitleBackColor[rect_pos]; }

    // ANeBuipbh삪LȁjEChE̐ݒE擾
    void SetActiveFlag(bool flag) { mActiveFlag = flag; }
    bool GetActiveFlag() const { return mActiveFlag; }
    
    // EChE̕\E\̐ݒ擾    
    void SetVisibleFlag(bool flag) { mWindowVisibleFlag = flag; }
    bool GetVisibleFlag() const { return mWindowVisibleFlag; }
    
    // TODO: ݖgp 
    void SetWindowShadeFlag(bool flag) { mWindowShadeFlag = flag; }
    bool GetWindowShadeFlag() const { return mWindowShadeFlag; }

    // EBhEI[_[
    void detail_SetWindowListOrder(int order) { mWindowOrder = order; }
    int detail_GetWindowListOrder() const { return mWindowOrder; }
    void detail_SetWindowZOrder(int order) { mZOrder = order; }
    int detail_GetWindowZOrder() const { return mZOrder; }

    s32 GetRenderDisplay() { return m_Display; }

#if 0
    //
    // TODO: ̃tHgg
    // 
    void SetFont(const ut::Font* font) { mFont = font; }
    const ut::Font* GetFont() const { return mFont; }
#endif

protected:
    virtual void OnDraw(GraphicsDrawing* gfx);
    virtual void OnUpdatePad(const Pad& pad);
    virtual void OnUpdate();
    virtual bool OnCreate();
    virtual void OnDestroy();

    // t[̕
    static const int FRAME_WIDTH = 1;
    // ^Cg̍ij
    static const int TITLE_HEIGHT = 12;
    // NCAg̈O̕
    static const int CLIENT_OUT_WIDTH = FRAME_WIDTH * 2;
    // NCAg̈O̍
    static const int CLIENT_OUT_HEIGHT = FRAME_WIDTH * 3 + TITLE_HEIGHT;    

    static const int WIDTH_MAX = 400;
    static const int WIDTH_MIN = 50;
    static const int HEIGHT_MAX = 240;
    static const int HEIGHT_MIN = 50;

private:
    
    void OnDrawClient(int alpha);
    
    void DrawFrame(uji::sys::GraphicsDrawing* gfx, int alpha, bool shadeFlag);
    void DrawImpl(int alpha, bool shadeFlag);
    
    bool    mCreateFlag;
    bool    mActiveFlag;
    bool    mWindowShadeFlag;
    bool    mWindowVisibleFlag;
    char    mTitle[ TITLE_LEN_MAX ];
    
    nw::ut::Color8 mBackColor;
    
    //  ^CgwiF(wiplp`4̒_ꂼ 0:E 1: 2: 3:E ̏Ɋi[)
    nw::ut::Color8 mTitleBackColor[RECT_NUM];
    
    s32     m_Display;
    Point   mPos;
    Size    mSize;
    Size    mMinSize;
    Size    mMaxSize;
       
    int     mWindowOrder;
    int     mZOrder;
#if 0    
    const   ut::Font* mFont;
#endif
    
public: 
    // for WindowManager
    nw::ut::LinkListNode mWindowListLink;
    nw::ut::LinkListNode mZOrderLink;  
};

typedef nw::ut::LinkList< Window, offsetof(Window,mWindowListLink)> WindowList;
typedef nw::ut::LinkList< Window, offsetof(Window,mZOrderLink)> WindowZOrderList;

}   // usingnamespace sys
}   // usingnamespace uji
  

/* _UJI_SYS_WINDOW_H_ */
#endif
