/*--------------------------------------------------------------------------*
 Project:
 File: sys_Window.cpp
 

*--------------------------------------------------------------------------*/
#include "sys_Window.h"    
#include "sys_GraphicsDrawing.h"

#include <nn/gx.h>
    
namespace uji {
namespace sys {

/*---------------------------------------------------------------------------
  Desc: RXgN^

  Args: title   EChE^Cg
        width   EChE̕
        height  EChE̍
---------------------------------------------------------------------------*/
Window::Window(const char* title, int width, int height)
  : mCreateFlag(false),
    mActiveFlag(true),
    mWindowShadeFlag(false),
    mWindowVisibleFlag(true),
    m_Display(NN_GX_DISPLAY0),    
    mPos(),
    mSize(width, height),
    mMinSize(WIDTH_MIN, HEIGHT_MIN),
    mMaxSize(WIDTH_MAX, HEIGHT_MAX),
    mWindowOrder( 0 ),
    mZOrder( 0 )
{
    mBackColor = nw::ut::Color8(1, 1, 1, 255);
    SetTitle(title);

    mTitleBackColor[RECT_RT] = nw::ut::Color8(0, 68, 188, 255);
    mTitleBackColor[RECT_LT] = nw::ut::Color8(0, 68, 188, 255);
    mTitleBackColor[RECT_LB] = nw::ut::Color8(0, 98, 208, 255);
    mTitleBackColor[RECT_RB] = nw::ut::Color8(0, 98, 208, 255);    
}

/*---------------------------------------------------------------------------
  Desc: fXgN^
---------------------------------------------------------------------------*/
Window::~Window()
{
   Destroy();
}

/*---------------------------------------------------------------------------
  Desc: EChE

  Args: pos EChE̍W

  Rtns: trueij/falseisj 
---------------------------------------------------------------------------*/
bool Window::Create(s32 display, const Point& pos)
{
    if (mCreateFlag) 
    {
        Destroy();
    }
    
    if (!OnCreate()) 
    {
        return false;
    }
     
    SetPosition(pos);
    m_Display = display;
    
    mCreateFlag = true;
    
    return true;
}

/*---------------------------------------------------------------------------
  Desc: EChEj
---------------------------------------------------------------------------*/
void Window::Destroy()
{
    if (mCreateFlag) 
    {
        OnDestroy();
        mCreateFlag = false;
    }
}

/*---------------------------------------------------------------------------
  Desc: XV
        t[IɍXV
---------------------------------------------------------------------------*/
void Window::Update()
{
    NW_ASSERTMSG(mCreateFlag, "Not Created");
    
    OnUpdate();
}

/*---------------------------------------------------------------------------
  Desc: EChẼpbh
---------------------------------------------------------------------------*/
void Window::UpdatePad(const Pad& pad)
{
    NW_ASSERTMSG(mCreateFlag, "Not Created");
    
    OnUpdatePad(pad);
}

/*---------------------------------------------------------------------------
  Desc: `
---------------------------------------------------------------------------*/
void Window::Draw(int alpha, bool shadeFlag)
{
    NW_ASSERTMSG(mCreateFlag, "Not Created");
    
    DrawImpl(alpha, shadeFlag);
}

/*---------------------------------------------------------------------------
  Desc: ^Cg̐ݒ
---------------------------------------------------------------------------*/
void Window::SetTitle(const char* title)
{
    std::memset(mTitle, 0, sizeof(mTitle));
    
    const char* sp = title;
    char* dp = mTitle;
    char* dpe = mTitle + TITLE_LEN_MAX-1;
    while (dp < dpe) 
    {
        if ( sp == '\0' ) break;
        *dp++ = *sp++;
    }
    *dp = '\0';
}

/*---------------------------------------------------------------------------
  Desc: EChE̕\TCYݒ
---------------------------------------------------------------------------*/
void Window::SetSize(const Size& size)
{
    mSize = size;
    
    mSize.width = nw::ut::Max( mSize.width, mMinSize.width );
    mSize.width = nw::ut::Min( mSize.width, mMaxSize.width );
    
    mSize.height = nw::ut::Max( mSize.height, mMinSize.height );
    mSize.height = nw::ut::Min( mSize.height, mMaxSize.height );
}

/*---------------------------------------------------------------------------
  Desc: NCAg̈igpł̈j̃TCYݒ
---------------------------------------------------------------------------*/
void Window::SetClientSize(const Size& size)
{
    Size windowSize;
    
    windowSize.width = size.width + CLIENT_OUT_WIDTH;
    windowSize.height = size.height + CLIENT_OUT_HEIGHT;
    
    SetSize( windowSize );
}

/*---------------------------------------------------------------------------
  Desc: NCAg̈̃TCY擾
---------------------------------------------------------------------------*/
const Size Window::GetClientSize() const
{
    Size clientSize;
    
    clientSize.width = mSize.width - CLIENT_OUT_WIDTH;
    clientSize.height = mSize.height - CLIENT_OUT_HEIGHT;
    
    return clientSize;
}

/*---------------------------------------------------------------------------
  Desc: NCAg̈̈ʒu擾
---------------------------------------------------------------------------*/
const Point Window::GetClientPosition() const
{
    Point clientPos;
    
    clientPos.x = mPos.x + FRAME_WIDTH;
    clientPos.y = mPos.y + FRAME_WIDTH * 2 + TITLE_HEIGHT;  

    return clientPos;
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/ 
void Window::OnDraw(GraphicsDrawing* gfx)
{
    // do nothing
    (void)gfx;
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void Window::OnDrawClient(int alpha)
{
    // do nothing
    (void)alpha;
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void Window::OnUpdatePad(const Pad& pad)
{
    // do nothing
    (void)pad;
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void Window::OnUpdate()
{
    // do nothing
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
bool Window::OnCreate()
{
    return true;
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
void Window::OnDestroy()
{
    // do nothing
}


/*---------------------------------------------------------------------------
  Desc: EChE`
---------------------------------------------------------------------------*/
void Window::DrawImpl(int alpha, bool shadeFlag)
{
    uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();    
    
    switch (m_Display)
    {
    case NN_GX_DISPLAY0:
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        break;
    case NN_GX_DISPLAY1:
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        break;
    default:
        break;
    }

    /* 
        EChE`
    */
    gfx->BeginDrawingShape();
    DrawFrame(gfx, alpha, shadeFlag);
   
    /*
        ^Cg`
    */        
    gfx->SetFixedWidthFont(TITLE_HEIGHT);
    nn::util::Color8 titleTextColor = nw::ut::Color::WHITE;
    gfx->m_TextWriter.SetTextColor(titleTextColor);
    gfx->m_TextWriter.SetCursor(mPos.x + FRAME_WIDTH + 8, mPos.y + FRAME_WIDTH, 0);
    gfx->BeginDrawingString();        
        (void)gfx->m_TextWriter.Printf(mTitle);
    gfx->EndDrawingString();

    // NCAg̈ւ̕`
    // TODO: shadeFlagɂăNCAg̘̈gɃr[|[gw肵ĕ`
    OnDraw(gfx);
}
  
/*---------------------------------------------------------------------------
  Desc: EChEt[`
---------------------------------------------------------------------------*/
void Window::DrawFrame(uji::sys::GraphicsDrawing* gfx, int alpha, bool shadeFlag)
{    
    nw::ut::Color8 frameColor;
    const int left = mPos.x + FRAME_WIDTH/2;
    const int top = mPos.y + FRAME_WIDTH/2;
    const int width = mSize.width - FRAME_WIDTH;
    const int height = mSize.height - FRAME_WIDTH;
    const int titleHeight = TITLE_HEIGHT;

    // TODO: At@l̐ݒ
    (void)alpha;
    // TODO: VF[htOɂ`
    (void)shadeFlag;
    
    // EChEwi
    gfx->SetColor(nw::ut::Color8(mBackColor.r, mBackColor.g, mBackColor.b, alpha));
    gfx->FillRectangle(left, top+titleHeight, width, height-titleHeight);
    
    // ^Cgwi
    gfx->SetColor( mTitleBackColor[RECT_RT],
                   mTitleBackColor[RECT_LT],
                   mTitleBackColor[RECT_LB],
                   mTitleBackColor[RECT_RB] );    
    gfx->FillRectangle(left, top, width, titleHeight);
    
    // EChEg
    if (mActiveFlag)
    {
        frameColor = nw::ut::Color8::WHITE;
    }
    else
    {
        frameColor = nw::ut::Color8(0, 98, 208, 255);
    }
    gfx->SetColor(frameColor);    
    gfx->DrawWidth1Rectangle(left, top, width, height);
}


}   // usingnamespace sys
}   // usingnamespace uji
