/*--------------------------------------------------------------------------*
 Project:
 File: sys_TextWindow.h
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_TEXT_WINDOW_H_
#define _UJI_SYS_TEXT_WINDOW_H_

#include <nn/gx.h>
#include "sys_Window.h"

namespace uji {
namespace sys {


// eLXgFiColor8̒萔ƑΉj
enum ATTR_TEXT_COLOR
{
    ATTR_COLOR_BLACK,
    ATTR_COLOR_WHITE,
    ATTR_COLOR_RED,
    ATTR_COLOR_GREEN,        
    ATTR_COLOR_BLUE,
    ATTR_COLOR_YELLOW,        
    ATTR_COLOR_MAGENTA,
    ATTR_COLOR_CYAN,
    ATTR_COLOR_MAX
};


class TextWindow : public Window
{
public:
    // RXgN^EfXgN^
    TextWindow(s32 width, s32 height, s32 fontHeight);
    virtual ~TextWindow();
        
    // EChEiobt@ցj̕o
    void PutString(const char* str);
    void Printf(const char* format, ...);
    void VPrintf(const char* format, std::va_list vlist);

    // eLXgJ[
    ATTR_TEXT_COLOR GetTextColor();
    ATTR_TEXT_COLOR SetTextColor(ATTR_TEXT_COLOR attr_color);
    
    // o͈ʒu
    void Gotoxy(s32 x, s32 y);
    Point Getxy();
        
    // eLXg̑
    // TODO: 

    static const int WINDOW_WIDTH_SPACE     = 2;
    static const int WINDOW_HEIGHT_SPACE    = 2;
    
    static const u8 ATTRIBUTE_COLOR_MASK    = 0x0f;
    static const int ATTRIBUTE_COLOR_SHIFT  = 0;

private:
    virtual void OnDraw(uji::sys::GraphicsDrawing* gfx);
    virtual void OnUpdatePad(const uji::sys::Pad& pad);
    virtual bool OnCreate();
    virtual void OnDestroy();
     
    void ClearBuffer(); 
    Size GetWindowSize();
     
    void DrawLine(uji::sys::GraphicsDrawing* gfx, int line, int y); 
    unsigned long PutChar(const char* str, char* dstPtr, u8* pAttr);
     
    void NextLine();    
    char* GetTextPtr(int line, int xPos);
    u8* GetAttributePtr(int line, int xPos);   
    int GetLineCount();

    static const int m_DrawOffsetX = 4;
    static const int m_DrawOffsetY = 1;    
          
    u8      m_Attribute;            // i4bit: Fj
    
    s32     m_BufferWidth;          // ̃obt@
    s32     m_BufferHeight;         // c̃obt@
    u32     m_BufferSize;           // obt@̃TCY
    
    Point   m_CursorXY;             // ݂̃eLXg\ʒu    
    bool    m_CursorVisible;        // J[\̉tO
    
    bool    m_AutoScrollFlag;       // ʎŃXN[邩
    
    char*   m_TextBuffer;           // eLXgobt@̃|C^
    u8*     m_AttributeBuffer;      // obt@̃|C^

    int     mWidth;                 // PC̕
    int     mHeight;    
    int     mLineMax;               // EChEɕ\ł郉C

    int     mRingTop;
    int     mPrintTop;
    int     mPrintXPos;

    int     mY;
    s32     mCyChar;                // tHg̍
};


}   // usingnamespace sys
}   // usingnamespace uji
  

/* _UJI_SYS_TEXT_WINDOW_H_ */
#endif

