/*--------------------------------------------------------------------------*
 Project:
 File: sys_TextWindow.cpp
 

*--------------------------------------------------------------------------*/
#include "sys_TextWindow.h"
#include "sys_Window.h"
#include "sys_GraphicsDrawing.h"

#include <nn/gx.h>
#include <nw/ut/ut_Lock.h>

namespace uji {
namespace sys {
  
    
/*---------------------------------------------------------------------------
  Desc: RXgN^
---------------------------------------------------------------------------*/
TextWindow::TextWindow(s32 width, s32 height, s32 fontHeight)
  : Window("TEXT WINDOW"),
  m_Attribute(ATTR_COLOR_WHITE),
  m_CursorVisible(false),
  mWidth(width),
  mHeight(height),
  mLineMax(height),
  mPrintTop(0),
  mPrintXPos(0),    
  mY(0),     
  mCyChar(fontHeight)    
{
}

/*---------------------------------------------------------------------------
  Desc: fXgN^
---------------------------------------------------------------------------*/
TextWindow::~TextWindow()
{
}

/*---------------------------------------------------------------------------
  Desc: obt@̊mۂƃEChETCY̐ݒ
        EChEɃ}l[WĂ΂܂B
---------------------------------------------------------------------------*/
bool TextWindow::OnCreate()
{
    m_BufferSize = (mWidth + 1) * mLineMax;
    m_TextBuffer = new char[m_BufferSize];
    m_AttributeBuffer = new u8[m_BufferSize];
 
    ClearBuffer();

    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();   
    if (mCyChar == 0)
    {
        mCyChar = static_cast<int>(gfx->m_TextWriter.GetLineHeight());
    }
    Size windowSize;
    windowSize.width = (mCyChar/2)*mWidth + m_DrawOffsetX*2 + CLIENT_OUT_WIDTH;
    windowSize.height = mHeight*mCyChar + CLIENT_OUT_HEIGHT;
    SetSize(windowSize);   
        
    return true; 
}

/*---------------------------------------------------------------------------
  Desc: obt@̊J
        EChEjɃ}l[WĂ΂܂B
---------------------------------------------------------------------------*/
void TextWindow::OnDestroy()
{
    delete[] m_TextBuffer;
    delete[] m_AttributeBuffer;
}

/*---------------------------------------------------------------------------
  Desc: eLXgAyёobt@NA
---------------------------------------------------------------------------*/
void TextWindow::ClearBuffer()
{    
    char* pTextBuffer = m_TextBuffer;
    u8* pAttributeBuffer = m_AttributeBuffer;
    int x, y;
    
    for (y = 0; y < mLineMax; y++)
    {
        for (x = 0; x < mWidth; x++)
        {
            *pTextBuffer++ = ' ';
            *pAttributeBuffer++ = m_Attribute;
        }
        *pTextBuffer++ = '\0';
        *pAttributeBuffer++ = 0x00;        
    }
}

/*---------------------------------------------------------------------------
  Desc: eLXgJ[̎擾
---------------------------------------------------------------------------*/
ATTR_TEXT_COLOR TextWindow::GetTextColor()
{
    return static_cast<ATTR_TEXT_COLOR>((m_Attribute & ATTRIBUTE_COLOR_MASK) >> ATTRIBUTE_COLOR_SHIFT);
}

/*---------------------------------------------------------------------------
  Desc: eLXgJ[̐ݒ
---------------------------------------------------------------------------*/
ATTR_TEXT_COLOR TextWindow::SetTextColor(ATTR_TEXT_COLOR attr_color)
{
    ATTR_TEXT_COLOR oldColor = GetTextColor();
	
    NN_ASSERTMSG((attr_color < ATTR_COLOR_MAX), "Wrong attribute text color.");
	
    u8 attribute = (u8)(m_Attribute & (~ATTRIBUTE_COLOR_MASK));
    m_Attribute = (u8)(attribute | (attr_color << ATTRIBUTE_COLOR_SHIFT));
    
    return oldColor;
}

/*---------------------------------------------------------------------------
  Desc: pbhXV
---------------------------------------------------------------------------*/
void TextWindow::OnUpdatePad(const uji::sys::Pad& pad)
{
    (void)pad;    
}

/*---------------------------------------------------------------------------
  Desc: `
---------------------------------------------------------------------------*/
void TextWindow::OnDraw(uji::sys::GraphicsDrawing* gfx)
{
    Window::OnDraw(gfx);
    
    if (m_TextBuffer == NULL)
    {
        gfx->m_TextWriter.Printf("- not assign buffer -");
    }
    
    const Size clientSize = GetClientSize();
    mY = nw::ut::Clamp(
        mY,
        0,
        nw::ut::Max(0, mCyChar * GetLineCount() - clientSize.height)
    );

    int drawLine = 0;
    
    gfx->SetFixedWidthFont(static_cast<f32>(mCyChar));
    
    gfx->BeginDrawingString();    
        while (drawLine < mLineMax)
        {
            int y = static_cast<int>(drawLine * mCyChar) - mY;
            if ((0 <= y) && (y <= clientSize.height-mCyChar))
            {                        
                // PC`
                DrawLine(gfx, drawLine, y);
            }

            ++drawLine;
        }
    gfx->EndDrawingString();    
}

int TextWindow::GetLineCount()
{
    int lineCount = mPrintTop - mRingTop;
    if (lineCount < 0)  lineCount += mLineMax;
    if (mPrintXPos > 0) lineCount += 1;
    
    return lineCount;
}

/*---------------------------------------------------------------------------
  Desc: 1C̕`
---------------------------------------------------------------------------*/    
void TextWindow::DrawLine(uji::sys::GraphicsDrawing* gfx, int line, int y)
{
    const nn::util::Color8 PalleteColor8[] =
    {
        nn::util::Color8::BLACK,
        nn::util::Color8::WHITE,
        nn::util::Color8::RED,
        nn::util::Color8::GREEN,
        nn::util::Color8::BLUE,
        nn::util::Color8::YELLOW,
        nn::util::Color8::MAGENTA,
        nn::util::Color8::CYAN, 
    };      
    
    int x=0;
    int i=0;
    u8 lastAttribute;    
    char str[mWidth+1];
    char* pText = GetTextPtr(line, 0);
    u8* pAttr = GetAttributePtr(line, 0);
                
    // EChENCAg̈̈ʒu擾
    uji::sys::Point client_pos = this->GetClientPosition();
            
    // \Jnʒu̒p
    const Point PrintOffset = Point(client_pos.x + m_DrawOffsetX, client_pos.y + m_DrawOffsetY);

    while (x < mWidth)
    {
        if (*(pText+x) == ' ')
        {
            x++;
            continue;
        }
        lastAttribute = *(pAttr + x);
        for (i=0; x+i<mWidth; i++)
        {
            if (*(pText+x+i) == ' ')
            {
                break;
            }
            else
            {
                str[i] = *(pText+x+i);
            }
            if (*(pAttr+x+i) != lastAttribute)
            {
                break;
            }
        }
        str[i]='\0';
        gfx->m_TextWriter.SetTextColor(PalleteColor8[lastAttribute]);
        gfx->m_TextWriter.SetCursor(PrintOffset.x + x*(mCyChar/2), PrintOffset.y + y);
        gfx->m_TextWriter.Printf(str);          
        x += i;
    }
}

/*---------------------------------------------------------------------------
  Desc: \J[\ʒu̐ݒ
---------------------------------------------------------------------------*/
void TextWindow::Gotoxy(s32 x, s32 y)
{
    if (x > mWidth)      x = 0;
    if (y >= mLineMax)   y = mLineMax-1;
    
    mPrintXPos = x;
    mPrintTop = y;
}

/*---------------------------------------------------------------------------
  Desc: \J[\ʒu̎擾
---------------------------------------------------------------------------*/
Point TextWindow::Getxy()
{
    return Point(mPrintXPos, mPrintTop);
}

/*---------------------------------------------------------------------------
  Desc: obt@ւ̕o
---------------------------------------------------------------------------*/    
void TextWindow::Printf(const char* format, ...)
{
    if (m_TextBuffer == NULL) return;

    va_list vlist;
    va_start(vlist, format);
    VPrintf(format, vlist);
    va_end(vlist);
}

void TextWindow::VPrintf(const char* format, std::va_list vlist)
{
    if (m_TextBuffer == NULL) return;

    const unsigned long STRING_BUF_SIZE = 1024; // o͕񐶐p̃obt@TCY
    static char sStrBuf[STRING_BUF_SIZE];       // o͕񐶐p̃obt@

    (void)std::vsnprintf(sStrBuf, STRING_BUF_SIZE, format, vlist);
    PutString(sStrBuf);
}

void TextWindow::PutString(const char* str)
{
    NW_NULL_ASSERT(str);

    if (m_TextBuffer == NULL) return;

    const Size clientSize = GetClientSize();
    
    char* pText = GetTextPtr(mPrintTop, mPrintXPos);
    u8*   pAttr = GetAttributePtr(mPrintTop, mPrintXPos);

    // ꕶ[v
    // \[X񂪋ɂȂ܂ŃRs[
    while (*str)
    {
        bool newLineFlag = false;

        if (*str == '\n')
        {
            str++;
            NextLine();
            pText = GetTextPtr(mPrintTop, 0);
            pAttr = GetAttributePtr(mPrintTop, 0);        
        }
        // NA
        else if (*str == '\f')
        {
            ClearBuffer();
            str++;
            mPrintXPos = 0;
            mPrintTop = 0;
            pText = GetTextPtr(0, 0);
            pAttr = GetAttributePtr(0, 0);      
        }
        else
        {
            u32 bytes = PutChar(str, pText, pAttr);

            if (bytes > 0)
            {
                str += bytes;
                pText += bytes;
                pAttr += bytes;
            }
            else
            {
                newLineFlag = true;
            }
        }
        if (mPrintXPos >= mWidth)
        {
            // ʒu[܂ŗĂstO𗧂Ă
            newLineFlag = true;
        }

        if (newLineFlag)
        {
            // sł΂Pǂݔ΂
            if (*str == '\n') ++str;

            NextLine();
            pText = GetTextPtr(mPrintTop, 0);
            pAttr = GetAttributePtr(mPrintTop, 0);
        }
    }
}

unsigned long TextWindow::PutChar(const char* str, char* dstPtr, u8* pAttr)
{
    unsigned long codeWidth = static_cast<unsigned long>(
        ((u8)*str >= 0x81) ? 2 : 1
    );

    if (mPrintXPos + codeWidth > mWidth) return 0;

    mPrintXPos += codeWidth;

    unsigned long cnt = codeWidth;
    while (cnt > 0)
    {
        *dstPtr++ = *str++;
        *pAttr++ = m_Attribute;
        cnt--;
    }
            
    return codeWidth;
}

/*---------------------------------------------------------------------------
  Desc: wʒũeLXgobt@̃AhX擾
---------------------------------------------------------------------------*/    
char* TextWindow::GetTextPtr(int line, int xPos)
{
    return reinterpret_cast<char*>(m_TextBuffer) + ((mWidth + 1) * line + xPos);
}

/*---------------------------------------------------------------------------
  Desc: wʒȗobt@̃AhX擾
---------------------------------------------------------------------------*/    
u8* TextWindow::GetAttributePtr(int line, int xPos)
{
    return reinterpret_cast<u8*>(m_AttributeBuffer) + ((mWidth + 1) * line + xPos);
}

/*---------------------------------------------------------------------------
  Desc: s
---------------------------------------------------------------------------*/    
void TextWindow::NextLine()
{
    // ݂̍sNUL}
    *(GetTextPtr(mPrintTop, mPrintXPos)) = '\0';

    // o͈ʒuύX
    mPrintXPos = 0;
    mPrintTop++;
    
    // XN[
    if (mPrintTop == mLineMax)
    {
        int y;
        for (y=0; y<mLineMax-1; y++)
        {
            char *pText = GetTextPtr(y, 0);
            u8 *pAttr = GetAttributePtr(y, 0);
            
            std::memcpy(pText, pText+(mWidth+1), mWidth);
            std::memcpy(pAttr, pAttr+(mWidth+1), mWidth);
        }
        
        // ŉsNA
        std::memset(GetTextPtr(y, 0), ' ', mWidth);
        std::memset(GetAttributePtr(y, 0), m_Attribute, mWidth);
        
        mPrintTop = mLineMax-1;
    }        
}


}   // usingnamespace sys
}   // usingnamespace uji
