/*--------------------------------------------------------------------------*
 Project:
 File: sys_SoundPlayer.h
 

*--------------------------------------------------------------------------*/
#ifndef SYS_SOUNDPLAYER_H_INCLUDED
#define SYS_SOUNDPLAYER_H_INCLUDED


#include <nn/types.h>
#include <nn/fs.h>

/*---------------------------------------------------------------------------*/
/* constants */

#define MAKE_WAVE_TAG_VALUE(c1, c2, c3, c4) \
    ( c1 | (c2<<8) | (c3<<16) | (c4<<24) )

#define MAKE_WAVE_TAG_STRING(str, val)       \
    {                                        \
        str[3] = (char) ( (val>>24)&0xff ) ; \
        str[2] = (char) ( (val>>16)&0xff ) ; \
        str[1] = (char) ( (val>> 8)&0xff ) ; \
        str[0] = (char) ( (val    )&0xff ) ; \
        str[4] = (char) ( 0 )              ; \
    }

#define MAKE_FMT_CHUNK(ch, s)                              \
    {                                                      \
        ch.tag  = MAKE_WAVE_TAG_VALUE('f', 'm', 't', ' '); \
        ch.size = s;                                       \
    }

#define MAKE_DATA_CHUNK(ch, s)                             \
    {                                                      \
        ch.tag  = MAKE_WAVE_TAG_VALUE('d', 'a', 't', 'a'); \
        ch.size = s;                                       \
    }

#define saturate(v, min, max)          \
    {                                  \
             if ( v < min ) {v = min;} \
        else if ( v > max ) {v = max;} \
    }


/*---------------------------------------------------------------------------*/
/* typedef */
typedef struct _riff
{
    u32 tag;
    u32 size;
    u32 type;
}
WaveRiff;

typedef struct _chunk
{
    u32 tag;
    u32 size;
}
WaveChunk;

typedef struct _fmt
{
    u16 fmt_id;
    u16 channel;
    u32 sample_rate;
    u32 trans_rate;
    u16 block_size;
    u16 quantum_bits;
}
WaveFmt;

typedef struct _data
{
    u32 size;
    u8* buf;
}
WaveData;

/*---------------------------------------------------------------------------*/
/* prototype */

void LoadWaveCore(nn::fs::FileReader&, WaveFmt*, WaveData*, bool);
static inline void LoadWave(nn::fs::FileReader& reader, WaveFmt* fmt, WaveData* data)
{
    LoadWaveCore(reader, fmt, data, false);
}
static inline int GetWaveLength(nn::fs::FileReader& reader)
{
    WaveFmt fmt;
    WaveData data;
    LoadWaveCore(reader, &fmt, &data, true);
    return data.size;
}


namespace uji {
namespace sys {


// 
class SoundPlayer 
{
public:

	enum
	{
	    SOUND_RESULT_OK = 0,
	    SOUND_TRY_INIT_NG,
	    SOUND_ALLOC_NG,
	    SOUND_STRCMP_NG
	};

    //    RXgN^
    SoundPlayer(){}
	
	// fXgN^
	virtual ~SoundPlayer(){}
    
    s32 UjiSoundPlayer();
    s32 UjiSoundPlayer( char* soundFileName, s64 soundSpan );
    s32 DebugUjiSoundPlayer( char* soundFileName, s64 soundSpan );
    s32 UjiSoundPlayer2013( char* soundFileName, s64 soundSpan, float soundVolume );


};  

}
}

#endif

