/*---------------------------------------------------------------------------*
UjiSoundPlayer() ->
      $(SampleDemos)\snd\SimplePlayer\SimplePlayer.cpp ̈ڐA

UjiSoundPlayer( char* soundFileName, s64 soundSpan ) ->
      soundFileNameŎw肵t@C̉ soundSpan mS̊Ԗ炵܂B
      LŎw肵Ă鉹t@C$(CTR_TRIAL)\data\romfiles\SoundPlayerɒuĂ܂B
 *---------------------------------------------------------------------------*/

#include <nn.h>
#include <nn/os.h>
#include <nn/fnd.h>
#include <nn/fs.h>
#include <nn/hid.h>
#include <nn/snd.h>

#include <string.h>
#include "sys_SoundPlayer.h"
#include "sys.h"
#include "../eva/Sound/SoundInitializer.h"
#include "../eva/mcu/TestMcu.h"


#define PCM_BUFFER_OFFSET    16 * 1024 * 1024  // Ä̌딼gp


/*---------------------------------------------------------------------------*
  Name:         LoadWave

  Description:  Wave f[^ǂݍ.

  Arguments:    filepath : t@CpX
                fmt      : Wave f[^ fmt  `Ni[
                data     : Wave f[^ data `Ni[

  Returns:      None.
 *---------------------------------------------------------------------------*/
void LoadWaveCore(nn::fs::FileReader& reader, WaveFmt * fmt, WaveData * data, bool isSizeOnly)
{
    reader.SetPosition(0);

    WaveRiff riff;     // RIFF  wb_
    WaveChunk chunk;   // CHUNK
    u32 readbyte = 0;  // t@Cǂݍ݂̔Ɏgp
    u32 fsize = reader.GetSize();

    // RIFF wb_ǂݍ
    reader.Read((u8*)&riff, sizeof(WaveRiff));

    // TCYώZ
    readbyte += sizeof(WaveRiff);

    // "RIFF" Ƃ̈vmF
    if (riff.tag != MAKE_WAVE_TAG_VALUE('R','I','F','F'))
    {
        NN_PANIC("Not RIFF format.\n");
    }
    // "WAVE" Ƃ̈vmF
    if ( riff.type != MAKE_WAVE_TAG_VALUE('W','A','V','E') )
    {
        NN_PANIC("Not Wave format.\n");
    }

    // t@CTCY傫Ȃ܂œǂݍ
    while(fsize > readbyte)
    {
        // CHUNK ̓ǂݍ
        reader.Read((u8*)&chunk, sizeof(WaveChunk));
        readbyte += sizeof(WaveChunk);

        // "fmt "
        if (chunk.tag == MAKE_WAVE_TAG_VALUE('f','m','t',' '))
        {
            reader.Read((u8*)fmt, sizeof(WaveFmt));
            readbyte += sizeof(WaveFmt);

            // g̈悪Γǂݎ̂
            if (chunk.size > sizeof(WaveFmt))
            {
                u16 ext_size;

                reader.Read((u8*)&ext_size, sizeof(ext_size));
                readbyte += sizeof(ext_size);

                readbyte += chunk.size;
                if (readbyte == fsize) break;

                reader.Seek(ext_size, nn::fs::POSITION_BASE_CURRENT);
            }
        }
        // "data"
        else if (chunk.tag == MAKE_WAVE_TAG_VALUE('d','a','t','a'))
        {
            data->size = chunk.size;

            if (isSizeOnly)
            {
                return;
            }
            else
            {
                reader.Read((u8*)data->buf, data->size);
                // 8-bit wav t@C̏ꍇ unsigned -> signed ̕ϊKv
                if (fmt->quantum_bits == 8)
                {
                    s8* p = (s8*)data->buf;
                    for (int i = 0; i < data->size; i++)
                    {
                        p[i] -= 128;
                    }
                }
            }
            readbyte += chunk.size;
        }
        // ȊO
        else
        {
            readbyte += chunk.size;
            if (readbyte == fsize) break;

            // ǂݔ΂
            reader.Seek(chunk.size, nn::fs::POSITION_BASE_CURRENT);
        }
    }
}


namespace
{


    nn::fnd::ExpHeap expHeap;
    const int nMemorySize = 16 * 1024 * 1024;
    const int nFiles = 4;  // gpł voice ̍ől 24
    const char* apFileNames[nFiles] =
    {
        "rom:/SoundPlayer/yoshi_16bit_fs16kHz_1ch.wav",
        "rom:/SoundPlayer/wihaho_16bit_fs22kHz_1ch.wav",
        "rom:/SoundPlayer/fanfare_16bit_fs32kHz_1ch.wav",
        "rom:/SoundPlayer/L-sin440Hz_R-sin660Hz_8bit_fs44kHz_2ch.wav",
    };

    int currentVoice = 0;
    bool aIsPaused[nFiles];
    f32 aPitch[nFiles];
    const f32 fDeltaPitch = 0.1;

    nn::snd::Voice* apVoice[nFiles];
    nn::snd::WaveBuffer aBuffer[nFiles];

    // TEhXbh֘A
    const int SOUND_THREAD_PRIORITY = 2;
    const int SOUND_THREAD_STACK_SIZE = 4096;
    nn::os::Thread threadSound;
    bool threadSoundFlag;
    void SoundThreadFunc(uptr arg)
    {
        (void)arg;
        threadSoundFlag = true;
        while (threadSoundFlag)
        {
            nn::snd::WaitForDspSync();      // DSP ̃f[^M҂B
            nn::snd::SendParameterToDsp();  // p[^ DSP ɑMB
        }
    }
}


s32 uji::sys::SoundPlayer::UjiSoundPlayer()
{
    nn::Result result;

    // pbh
    nn::hid::PadReader padReader;
    nn::hid::PadStatus padStatus;

    // wav f[^pÄ̏
    expHeap.Initialize(nn::os::GetDeviceMemoryAddress() + PCM_BUFFER_OFFSET, nMemorySize, nn::os::ALLOCATE_OPTION_LINEAR);

    // dsp, snd ̏
    result = nn::dsp::Initialize();
    NN_UTIL_PANIC_IF_FAILED(result);
    result = nn::dsp::LoadDefaultComponent();
    NN_UTIL_PANIC_IF_FAILED(result);
    result = nn::snd::Initialize();
    NN_UTIL_PANIC_IF_FAILED(result);

    // TEhXbhNiDSP 荞݃Cxg҂j
    threadSound.StartUsingAutoStack(
        SoundThreadFunc,
        NULL,
        SOUND_THREAD_STACK_SIZE,
        SOUND_THREAD_PRIORITY
    );


    // }X^[{[ݒ
    nn::snd::SetMasterVolume( 1.0f );

    NN_LOG("Loading wav files...\n");

    u8* apMemory[nFiles];


    // t@CJ
    for (int i = 0; i < nFiles; i++)
    {
        if (apFileNames[i] == NULL) continue;

        nn::snd::Voice* pVoice = NULL;

        nn::fs::FileReader fileReader;
        result = fileReader.TryInitialize(apFileNames[i]);
        if(result.IsFailure())
        {
            fileReader.Finalize();
            // TEhXbh̔j
            threadSoundFlag = false;
            threadSound.Join();
            threadSound.Finalize();
            uji::eva::mcu::NotifyLedRedBlinker();
            SYS_PANIC("UjiSoundPlayer (TryInitialize)");  // \ł镶40܂
            return SOUND_TRY_INIT_NG;
        }

        if (::std::strcmp(::std::strrchr(apFileNames[i], '.'), ".wav") == false)
        {

            // Ä̎擾AmF
            apMemory[i] = reinterpret_cast<u8*>(expHeap.Allocate(GetWaveLength(fileReader), 32));
            if (apMemory[i] == NULL)
            {
                fileReader.Finalize();
                // TEhXbh̔j
                threadSoundFlag = false;
                threadSound.Join();
                threadSound.Finalize();
                uji::eva::mcu::NotifyLedRedBlinker();
                SYS_PANIC("UjiSoundPlayer (AllocDeviceMemory)");  // \ł镶40܂
                return SOUND_ALLOC_NG;
            }

            WaveFmt fmt;
            WaveData data;

            // Wave f[^ǂݍ݁ALbV𖳌
            data.buf = apMemory[i];
            LoadWave(fileReader, &fmt, &data);
            nn::snd::FlushDataCache(reinterpret_cast<uptr>(apMemory[i]), data.size);

            NN_LOG("%s (%1dch, %5dHz, %2d-bit wav file)\n",
                   apFileNames[i], fmt.channel, fmt.sample_rate, fmt.quantum_bits);

            pVoice = apVoice[i] = nn::snd::AllocVoice(128, NULL, NULL);

            NN_TASSERT_(pVoice);

            nn::snd::SampleFormat format = (fmt.quantum_bits == 8) ?
                                                nn::snd::SAMPLE_FORMAT_PCM8 :
                                                nn::snd::SAMPLE_FORMAT_PCM16;
            pVoice->SetChannelCount( fmt.channel );
            pVoice->SetSampleFormat( format );

            nn::snd::InitializeWaveBuffer(&aBuffer[i]);

            aBuffer[i].bufferAddress = apMemory[i];
            aBuffer[i].sampleLength  = nn::snd::GetSampleLength(data.size, format, fmt.channel);
            aBuffer[i].loopFlag      = true;

            fileReader.Finalize();

            // ʂ̐ݒ
            nn::snd::MixParam mix;
            mix.mainBus[nn::snd::CHANNEL_INDEX_FRONT_LEFT ] = 0.5f; // C{[ (L)
            mix.mainBus[nn::snd::CHANNEL_INDEX_FRONT_RIGHT] = 0.5f; // C{[ (R)
            pVoice->SetMixParam(mix);
            pVoice->SetVolume(1.0f);

            // pitch ̐ݒ
            pVoice->SetSampleRate(fmt.sample_rate);
            aPitch[i] = 1.0;
            pVoice->SetPitch(aPitch[i]);

            // obt@̒ǉ
            pVoice->AppendWaveBuffer(&aBuffer[i]);
        }

    }


    // ĐJn
    for (int i = 0; i < nFiles; i++)
    {
        if (apFileNames[i] != NULL)
        {
            apVoice[i]->SetState( nn::snd::Voice::STATE_PLAY );
            aIsPaused[i] = false;
        }
    }

    // -----------------------------------------------------------------------

    // 
    NN_LOG("BUTTON_A          : Play/pause\n");
    NN_LOG("BUTTON_UP,DOWN    : Change pitch\n");
    NN_LOG("BUTTON_LEFT,RIGHT : Change current voice\n");
    NN_LOG("BUTTON_START      : End demo\n");

    while(true)
    {
        int voice = currentVoice;
        bool trig = false;

        // ͎擾
        padReader.ReadLatest(&padStatus);

        if(padStatus.trigger & nn::hid::BUTTON_A)      // voice ̍ĐA~
        {
            aIsPaused[voice] = !aIsPaused[voice];
            apVoice[voice]->SetState( aIsPaused[voice] ? nn::snd::Voice::STATE_PAUSE : nn::snd::Voice::STATE_PLAY );
            trig = true;
        }
        if(padStatus.trigger & nn::hid::BUTTON_LEFT)   // voice ̑I
        {
            voice--;
            if (voice < 0) voice = 0;
            trig = true;
        }
        if(padStatus.trigger & nn::hid::BUTTON_RIGHT)  // voice ̑I
        {
            voice++;
            if (voice >= nFiles) voice = nFiles - 1;
            trig = true;
        }
        if(padStatus.trigger & nn::hid::BUTTON_UP)     // sb`̕ύX
        {
            aPitch[voice] += fDeltaPitch;
            apVoice[voice]->SetPitch(aPitch[voice]);
            trig = true;
        }
        if(padStatus.trigger & nn::hid::BUTTON_DOWN)   // sb`̕ύX
        {
            if (aPitch[voice] - fDeltaPitch > 0)
            {
                aPitch[voice] -= fDeltaPitch;
            }
            apVoice[voice]->SetPitch(aPitch[voice]);
            trig = true;
        }
        if(padStatus.trigger & nn::hid::BUTTON_START)  // f̏I
        {
            break;
        }

        if (trig)  // ύX̂ voice ̏ԕ\
        {
            NN_LOG("[voice%d] %s (pitch = %f)\n",
                   voice, (aIsPaused[voice] ? "pause" : "play "), aPitch[voice]);
        }
        currentVoice = voice;
    }

    // ĐI
    for (int i = 0; i < nFiles; i++)
    {
        if (apFileNames[i] != NULL)
        {
            apVoice[i]->SetState( nn::snd::Voice::STATE_STOP );
            aIsPaused[i] = false;
        }
    }

    // TEhXbh̔j
    threadSoundFlag = false;
    threadSound.Join();
    threadSound.Finalize();

    // SND ̏I
    result = nn::snd::Finalize();
    NN_UTIL_PANIC_IF_FAILED(result);

    // DSP ̏I
    result = nn::dsp::UnloadComponent();
    NN_UTIL_PANIC_IF_FAILED(result);
    nn::dsp::Finalize();

    NN_LOG("Demo End\n");

    return SOUND_RESULT_OK;
}


/*!--------------------------------------------------------------------------*
  Desc      w肵t@C̉炷

  Args      soundFileName  TEhpt@C
            soundSpan      葱鎞(PʂmS)
  Rtns      0:OK     1:TryInitialize֐NG     2:AllocDeviceMemory֐NG    3:t@CȂꍇ
 *---------------------------------------------------------------------------*/
s32 uji::sys::SoundPlayer::UjiSoundPlayer( char* soundFileName, s64 soundSpan )
{

    nn::Result result;
    u8* apMemory;
    int i = 0;
    nn::snd::Voice* pVoice = NULL;

    // -----------------------------------------------------------------------
    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();

    // TEhXbhNiDSP 荞݃Cxg҂j
    threadSound.StartUsingAutoStack(
        SoundThreadFunc,
        NULL,
        SOUND_THREAD_STACK_SIZE,
        SOUND_THREAD_PRIORITY
    );

    // }X^[{[ݒ
    nn::snd::SetMasterVolume( 4.0f );

    nn::fs::FileReader fileReader;
    result = fileReader.TryInitialize( soundFileName );

    if(result.IsFailure())
    {
        fileReader.Finalize();
        threadSoundFlag = false;
        threadSound.Join();
        threadSound.Finalize();
        eva::SoundInitializer().FinalizeSDK();
        uji::eva::mcu::NotifyLedRedBlinker();
        SYS_PANIC("UjiSoundPlayer (TryInitialize)");  // \ł镶40܂
        return SOUND_TRY_INIT_NG;
    }

    if (::std::strcmp(::std::strrchr(soundFileName, '.'), ".wav") == false)
    {

        // Ä̎擾AmF
        apMemory = reinterpret_cast<u8*>(uji::sys::AllocDeviceMemory(GetWaveLength(fileReader), 32));
        if (apMemory == NULL)
        {
            fileReader.Finalize();
            threadSoundFlag = false;
            threadSound.Join();
            threadSound.Finalize();
            eva::SoundInitializer().FinalizeSDK();
            uji::eva::mcu::NotifyLedRedBlinker();
            SYS_PANIC("UjiSoundPlayer (AllocDeviceMemory)");  // \ł镶40܂
            return SOUND_ALLOC_NG;
        }

        WaveFmt fmt;
        WaveData data;
        // Wave f[^ǂݍ݁ALbV𖳌
        data.buf = apMemory;
        LoadWave(fileReader, &fmt, &data);
        nn::snd::FlushDataCache(reinterpret_cast<uptr>(apMemory), data.size);

        pVoice = nn::snd::AllocVoice(128, NULL, NULL);
        NN_TASSERT_(pVoice);

        nn::snd::SampleFormat format = (fmt.quantum_bits == 8) ?
                                                nn::snd::SAMPLE_FORMAT_PCM8 :
                                                nn::snd::SAMPLE_FORMAT_PCM16;
        pVoice->SetChannelCount( fmt.channel );
        pVoice->SetSampleFormat( format );

        nn::snd::InitializeWaveBuffer(&aBuffer[i]);

        aBuffer[i].bufferAddress = apMemory;
        aBuffer[i].sampleLength  = nn::snd::GetSampleLength(data.size, format, fmt.channel);
        aBuffer[i].loopFlag      = true;

        fileReader.Finalize();

        // ʂ̐ݒ
        nn::snd::MixParam mix;
        mix.mainBus[nn::snd::CHANNEL_INDEX_FRONT_LEFT ] = 8.0f; // C{[ (L)
        mix.mainBus[nn::snd::CHANNEL_INDEX_FRONT_RIGHT] = 8.0f; // C{[ (R)
        pVoice->SetMixParam(mix);
        pVoice->SetVolume(1.0f);

        // pitch ̐ݒ
        pVoice->SetSampleRate(fmt.sample_rate);
        aPitch[i] = 1.0;
        pVoice->SetPitch(aPitch[i]);

        // obt@̒ǉ
        pVoice->AppendWaveBuffer(&aBuffer[i]);

    }
    else
    {
        fileReader.Finalize();
        threadSoundFlag = false;
        threadSound.Join();
        threadSound.Finalize();
        eva::SoundInitializer().FinalizeSDK();
        uji::eva::mcu::NotifyLedRedBlinker();
        SYS_PANIC("UjiSoundPlayer (strcmp)");  // \ł镶40܂
        return SOUND_STRCMP_NG;
    }

    // ĐJn
    pVoice->SetState( nn::snd::Voice::STATE_PLAY );
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(soundSpan));

    nn::snd::FreeVoice(pVoice);
    uji::sys::Free(apMemory);

    // TEhXbh̔j
    threadSoundFlag = false;
    threadSound.Join();
    threadSound.Finalize();
    eva::SoundInitializer().FinalizeSDK();

    return SOUND_RESULT_OK;

}


/*!--------------------------------------------------------------------------*
  Desc      w肵t@C̉炷(TEhisx\)

  Args      soundFileName  TEhpt@C
            soundSpan      葱鎞(PʂmS)
            gfx            ʕ\p
  Rtns      0:OK     1:TryInitialize֐NG     2:AllocDeviceMemory֐NG    3:t@CȂꍇ
 *---------------------------------------------------------------------------*/
s32 uji::sys::SoundPlayer::DebugUjiSoundPlayer( char* soundFileName, s64 soundSpan )
{
    nn::Result result;
    u8* apMemory;
    int i = 0;
    nn::snd::Voice* pVoice = NULL;

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();

    // TEhXbhNiDSP 荞݃Cxg҂j
    threadSound.StartUsingAutoStack(
        SoundThreadFunc,
        NULL,
        SOUND_THREAD_STACK_SIZE,
        SOUND_THREAD_PRIORITY
    );

    // }X^[{[ݒ
    nn::snd::SetMasterVolume( 2.0f );

    nn::fs::FileReader fileReader;

    result = fileReader.TryInitialize( soundFileName );

    if(result.IsFailure())
    {
        fileReader.Finalize();
        threadSoundFlag = false;
        threadSound.Join();
        threadSound.Finalize();
        eva::SoundInitializer().FinalizeSDK();
        uji::eva::mcu::NotifyLedRedBlinker();
        SYS_PANIC("UjiSoundPlayer (TryInitialize)");  // \ł镶40܂
        return SOUND_TRY_INIT_NG;
    }

    if (::std::strcmp(::std::strrchr(soundFileName, '.'), ".wav") == false)
    {
        // Ä̎擾AmF
        apMemory = reinterpret_cast<u8*>(uji::sys::AllocDeviceMemory(GetWaveLength(fileReader), 32));
        if (apMemory == NULL)
        {
            fileReader.Finalize();
            threadSoundFlag = false;
            threadSound.Join();
            threadSound.Finalize();
            eva::SoundInitializer().FinalizeSDK();
            uji::eva::mcu::NotifyLedRedBlinker();
            SYS_PANIC("UjiSoundPlayer (AllocDeviceMemory)");  // \ł镶40܂
            return SOUND_ALLOC_NG;
        }

        WaveFmt fmt;
        WaveData data;

        // Wave f[^ǂݍ݁ALbV𖳌
        data.buf = apMemory;
        LoadWave(fileReader, &fmt, &data);

        nn::snd::FlushDataCache(reinterpret_cast<uptr>(apMemory), data.size);

        pVoice = nn::snd::AllocVoice(128, NULL, NULL);
        NN_TASSERT_(pVoice);

        nn::snd::SampleFormat format = (fmt.quantum_bits == 8) ?
                                                nn::snd::SAMPLE_FORMAT_PCM8 :
                                                nn::snd::SAMPLE_FORMAT_PCM16;
        pVoice->SetChannelCount( fmt.channel );

        pVoice->SetSampleFormat( format );

        nn::snd::InitializeWaveBuffer(&aBuffer[i]);

        aBuffer[i].bufferAddress = apMemory;
        aBuffer[i].sampleLength  = nn::snd::GetSampleLength(data.size, format, fmt.channel);
        aBuffer[i].loopFlag      = true;

        fileReader.Finalize();

        // ʂ̐ݒ
        nn::snd::MixParam mix;
        mix.mainBus[nn::snd::CHANNEL_INDEX_FRONT_LEFT ] = 8.0f; // C{[ (L)
        mix.mainBus[nn::snd::CHANNEL_INDEX_FRONT_RIGHT] = 8.0f; // C{[ (R)
        pVoice->SetMixParam(mix);

        pVoice->SetVolume(1.0f);

        // pitch ̐ݒ
        pVoice->SetSampleRate(fmt.sample_rate);

        aPitch[i] = 1.0;
        pVoice->SetPitch(aPitch[i]);

        // obt@̒ǉ
        pVoice->AppendWaveBuffer(&aBuffer[i]);
    }
    else
    {
        fileReader.Finalize();
        threadSoundFlag = false;
        threadSound.Join();
        threadSound.Finalize();
        eva::SoundInitializer().FinalizeSDK();
        uji::eva::mcu::NotifyLedRedBlinker();
        SYS_PANIC("UjiSoundPlayer (strcmp)");  // \ł镶40܂
        return SOUND_STRCMP_NG;
    }

    // ĐJn
    pVoice->SetState( nn::snd::Voice::STATE_PLAY );
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(soundSpan));

    nn::snd::FreeVoice(pVoice);

    uji::sys::Free(apMemory);

    // TEhXbh̔j
    threadSoundFlag = false;
    threadSound.Join();
    threadSound.Finalize();
    eva::SoundInitializer().FinalizeSDK();

    return SOUND_RESULT_OK;
}


/*!--------------------------------------------------------------------------*
  Desc      w肵t@C̉炷

  Args      soundFileName  TEhpt@C
            soundSpan      葱鎞(PʂmS)
            soundVolume    }X^[{[̐ݒl(֐SetMasterVolumë)
  Rtns      0:OK     1:TryInitialize֐NG     2:AllocDeviceMemory֐NG    3:t@CȂꍇ
 *---------------------------------------------------------------------------*/
s32 uji::sys::SoundPlayer::UjiSoundPlayer2013( char* soundFileName, s64 soundSpan, float soundVolume )
{
    nn::Result result;
    u8* apMemory;
    int i = 0;
    nn::snd::Voice* pVoice = NULL;

    // dsp, snd ̏
    uji::eva::SoundInitializer().InitSDK();

    // TEhXbhNiDSP 荞݃Cxg҂j
    threadSound.StartUsingAutoStack(
        SoundThreadFunc,
        NULL,
        SOUND_THREAD_STACK_SIZE,
        SOUND_THREAD_PRIORITY
    );

    // }X^[{[ݒ
    nn::snd::SetMasterVolume( soundVolume );

    nn::fs::FileReader fileReader;
    result = fileReader.TryInitialize( soundFileName );

    if(result.IsFailure())
    {
        fileReader.Finalize();
        threadSoundFlag = false;
        threadSound.Join();
        threadSound.Finalize();
        eva::SoundInitializer().FinalizeSDK();
        uji::eva::mcu::NotifyLedRedBlinker();
        SYS_PANIC("UjiSoundPlayer (TryInitialize)");  // \ł镶40܂
        return SOUND_TRY_INIT_NG;
    }

    if (::std::strcmp(::std::strrchr(soundFileName, '.'), ".wav") == false)
    {

        // Ä̎擾AmF
        apMemory = reinterpret_cast<u8*>(uji::sys::AllocDeviceMemory(GetWaveLength(fileReader), 32));
        if (apMemory == NULL)
        {
            fileReader.Finalize();
            threadSoundFlag = false;
            threadSound.Join();
            threadSound.Finalize();
            eva::SoundInitializer().FinalizeSDK();
            uji::eva::mcu::NotifyLedRedBlinker();
            SYS_PANIC("UjiSoundPlayer (AllocDeviceMemory)");  // \ł镶40܂
            return SOUND_ALLOC_NG;
        }

        WaveFmt fmt;
        WaveData data;
        // Wave f[^ǂݍ݁ALbV𖳌
        data.buf = apMemory;
        LoadWave(fileReader, &fmt, &data);
        nn::snd::FlushDataCache(reinterpret_cast<uptr>(apMemory), data.size);

        pVoice = nn::snd::AllocVoice(128, NULL, NULL);
        NN_TASSERT_(pVoice);

        nn::snd::SampleFormat format = (fmt.quantum_bits == 8) ?
                                                nn::snd::SAMPLE_FORMAT_PCM8 :
                                                nn::snd::SAMPLE_FORMAT_PCM16;
        pVoice->SetChannelCount( fmt.channel );
        pVoice->SetSampleFormat( format );

        nn::snd::InitializeWaveBuffer(&aBuffer[i]);

        aBuffer[i].bufferAddress = apMemory;
        aBuffer[i].sampleLength  = nn::snd::GetSampleLength(data.size, format, fmt.channel);
        aBuffer[i].loopFlag      = true;

        fileReader.Finalize();

        // ʂ̐ݒ
        nn::snd::MixParam mix;
        mix.mainBus[nn::snd::CHANNEL_INDEX_FRONT_LEFT ] = 8.0f; // C{[ (L)
        mix.mainBus[nn::snd::CHANNEL_INDEX_FRONT_RIGHT] = 8.0f; // C{[ (R)
        pVoice->SetMixParam(mix);
        pVoice->SetVolume(1.0f);

        // pitch ̐ݒ
        pVoice->SetSampleRate(fmt.sample_rate);
        aPitch[i] = 1.0;
        pVoice->SetPitch(aPitch[i]);

        // obt@̒ǉ
        pVoice->AppendWaveBuffer(&aBuffer[i]);

    }
    else
    {
        fileReader.Finalize();
        threadSoundFlag = false;
        threadSound.Join();
        threadSound.Finalize();
        eva::SoundInitializer().FinalizeSDK();
        uji::eva::mcu::NotifyLedRedBlinker();
        SYS_PANIC("UjiSoundPlayer (strcmp)");  // \ł镶40܂
        return SOUND_STRCMP_NG;
    }

    // ĐJn
    pVoice->SetState( nn::snd::Voice::STATE_PLAY );
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(soundSpan));

    // TEhXbh̔j
    threadSoundFlag = false;
    threadSound.Join();
    threadSound.Finalize();

    nn::snd::FreeVoice(pVoice);
    uji::sys::Free(apMemory);

    eva::SoundInitializer().FinalizeSDK();

    return SOUND_RESULT_OK;
}




/*---------------------------------------------------------------------------*
  End of file
 *---------------------------------------------------------------------------*/
