/************************************************************************

ۃAvP[VNX

 *************************************************************************/
#include <string.h>
#include <nn.h>
#include "sys.h"
#include "sys_ShowMessage.h"
    
using namespace uji::sys;

const int FONT_SIZE=14;


/**************************************************************************
̗񐔂𐔂
 *************************************************************************/
int ShowMessage::CalcHeight( const char *message )
{

	int height=1;
	
	while( *message != '\0' )
	{
		if( *message == '\n' ) height++;
		message++;
	}
	return height;

}
/**************************************************************************
̍ő啝𐔂
 *************************************************************************/
int ShowMessage::CalcWidth( const char *message )
{
	int maxHeight=0;
	int height=0;
	
	while( *message != '\0' )
	{
		if( *message== '\n' )
		{
			height=0;
		}else{
			height++;
			if(height>maxHeight ) maxHeight = height;
		}
		message++;
	}
	return maxHeight;
}



/************************************************************************
 ************************************************************************/
bool ShowMessage::Open( WindowManager *man, const char *message, ShowMessageType type )
{
	bool retValue;
	ShowMessage *m_Instance = new ShowMessage();
	retValue = m_Instance->Execute( man, message, type );
	delete m_Instance;
	return retValue;
}

/************************************************************************
 ************************************************************************/
bool ShowMessage::Execute( WindowManager *man, const char *message, ShowMessageType type )
{   
	int height;		//\
	int	width;		//\
	int origin_x;	//bZ[Wg̍w
	int origin_y;	//bZ[Wg̍x
	bool retValue;

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

	//߂}
	strcpy( m_Message, message );
	switch( type )
	{
	  case SHM_NO_MESSAGE:
	  	break;
	  case SHM_OK:
	    strcat( m_Message, "\nOK=A" );
	    break;
	  case SHM_OK_CANCEL:
	  	strcat( m_Message, "\nOK=A CANCEL=B" );
	  	break;
	  default:
	  	break;
	}

	//\ɕKvȍEE_vZĕ\
	height = CalcHeight( m_Message )*FONT_SIZE;
	width  = CalcWidth( m_Message )*FONT_SIZE/2;
	origin_x = (uji::sys::GraphicsDrawing::DISPLAY0_WIDTH - width)/2;
	origin_y = (uji::sys::GraphicsDrawing::DISPLAY0_HEIGHT - height - GetTitleBarHeight())/2;
	SetClientSize( Size(width, height) );
	Window *parentWin = man->GetActiveWindow();
	man->CreateWindow(this, NN_GX_DISPLAY0, origin_x, origin_y );


    //j[[v
	do
	{
        //pbhXV
        pad.UpdatePad();

        //EChE
		man->Update();
        man->UpdatePad(pad);        

        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();
        man->DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
        // ʕ`        
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        man->DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

	}
	while( !pad.IsButtonRepeat( Pad::BUTTON_A ) && !pad.IsButtonRepeat( Pad::BUTTON_B ) );

	retValue = pad.IsButtonRepeat( Pad::BUTTON_A )?true:false;
	
    //gKNA            
    pad.ClearTriggerFlag();            

	man->DestroyWindow(this);
	man->SetActiveWindow(parentWin);

	return retValue;
}


// `揈
void ShowMessage::OnDraw(GraphicsDrawing* gfx)
{
	Point pos = this->GetClientPosition();
    
	// tHg̐ݒ
	gfx->SetFixedWidthFont(FONT_SIZE);
	gfx->m_TextWriter.SetCursor(pos.x, pos.y);
    
	gfx->BeginDrawingString();    
	    gfx->m_TextWriter.Printf( m_Message );
    gfx->EndDrawingString();
}

void ShowMessage::OnUpdatePad(const Pad& pad){ NN_UNUSED_VAR(pad); }
void ShowMessage::OnUpdate(){}
