/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     demo_PadButtonImpl.h

  Copyright (C)2009-2010 Nintendo Co., Ltd./HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Revision:$
 *---------------------------------------------------------------------------*/

#ifndef _UJI_SYS_PAD_BUTTON_IMPL_H_
#define _UJI_SYS_PAD_BUTTON_IMPL_H_

#include <nn/types.h>

namespace uji {
namespace sys {
namespace internal {

class PadButtonImpl
{
  public:
    static const int BUTTON_COUNT_MAX = 32;
    static const int REPEAT_START = 25;    // L[s[gJn܂ł̃t[
    static const int REPEAT_SPAN  = 6;     // L[s[g̊Ԋut[

    PadButtonImpl();
    void Update( u32 buttonStatus );
    void ClearTriggerFlag();
    void Reset();

    bool IsButtonPress( u32 buttonBit ) const { return (m_ButtonPress & buttonBit) != 0; }
    bool IsButtonDown( u32 buttonBit ) const { return (m_ButtonDown & buttonBit) != 0; }
    bool IsButtonUp( u32 buttonBit ) const { return (m_ButtonUp & buttonBit) != 0; }
    bool IsButtonRepeat( u32 buttonBit ) const { return (m_ButtonRepeat & buttonBit) != 0; }
    bool IsButtonRepeatFast( u32 buttonBit ) const { return (m_ButtonRepeatFast & buttonBit) != 0; }
    
    u32 GetPress() const { return m_ButtonPress; }
    u32 GetDown() const { return m_ButtonDown; }

  private:
    u32 m_ButtonPress;
    u32 m_ButtonDown;
    u32 m_ButtonUp;
    u32 m_ButtonRepeat;
    u32 m_ButtonRepeatFast;
    u8 m_RepeatCounter[ BUTTON_COUNT_MAX ];
    u8 m_RepeatCounterFast[ BUTTON_COUNT_MAX ];
    bool m_ResetFlag;
    u8 padding[3];
};

} // namespace uji::sys::internal
} // namespace uji::sys
} // namespace uji

#endif /* _UJI_SYS_PAD_BUTTON_IMPL_H_ */

