/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     demo_PadButtonImpl.cpp

  Copyright (C)2009-2010 Nintendo Co., Ltd./HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Revision:$
 *---------------------------------------------------------------------------*/
#include <nn/hid.h>
#include "sys_PadButtonImpl.h"

namespace uji {
namespace sys {
namespace internal {


PadButtonImpl::PadButtonImpl()
{
    Reset();
}

/*!--------------------------------------------------------------------------*
  Name:        PadButtonImpl::Update

  @brief       pbhԂXV܂B
               ȌԂƔrāADownRepeat̃tO𗧂Ă܂B

  @param[in]   buttonStatus  {^ĂԂ\rbgtO

  @return      None.
 *---------------------------------------------------------------------------*/
void PadButtonImpl::Update(u32 buttonStatus)
{
    if ( m_ResetFlag ) {
        m_ButtonDown = m_ButtonUp = m_ButtonRepeat = m_ButtonRepeatFast = 0;
        m_ResetFlag = false;
    }
    else {
        m_ButtonDown        = ( m_ButtonPress^buttonStatus ) & buttonStatus;
        m_ButtonUp          = ( m_ButtonPress^buttonStatus ) & m_ButtonPress;
        m_ButtonRepeat      = m_ButtonDown;
        m_ButtonRepeatFast  = m_ButtonDown;
    }
        
    m_ButtonPress = buttonStatus; // padStatus.hold

    u32 mask = 1;
    for ( int i = 0; i < BUTTON_COUNT_MAX; i++, mask <<= 1 )
    {
        if ( m_ButtonPress & mask )
        {
            --m_RepeatCounter[ i ];
            --m_RepeatCounterFast[ i ];

            if ( m_RepeatCounter[ i ] == 0 )
            {
                m_ButtonRepeat |= mask;
                m_RepeatCounter[ i ] = REPEAT_SPAN;
            }
            if ( m_RepeatCounterFast[ i ] == 0 )
            {
                m_ButtonRepeatFast |= mask;
                m_RepeatCounterFast[ i ] = 1;
            }
        }
        else
        {
            m_RepeatCounter[ i ] = REPEAT_START;
            m_RepeatCounterFast[ i ] = REPEAT_START;
        }
    }
}

/*!--------------------------------------------------------------------------*
  Name:        PadButtonImpl::Reset

  @brief       pbh̏ԂԂɂ܂B
               UpdateɁA{^ĂĂA
               DownRepeat̃tO͗܂B

  @return      None.
 *---------------------------------------------------------------------------*/
void PadButtonImpl::Reset()
{
    m_ResetFlag = true;

    m_ButtonPress = 0;
    m_ButtonDown = 0;
    m_ButtonUp = 0;
    m_ButtonRepeat = 0;
    m_ButtonRepeatFast = 0;

    for( int i = 0 ; i < BUTTON_COUNT_MAX ; i++ ) {
        m_RepeatCounter[i] = REPEAT_START;
        m_RepeatCounterFast[i] = REPEAT_START;
    }
}

/*!--------------------------------------------------------------------------*
  Name:        PadButtonImpl::ClearTriggerFlag

  @brief       ĂԂ͂̂܂܂ɁA
               DownRepeat̃tÔݗƂ܂B

  @return      None.
 *---------------------------------------------------------------------------*/
void PadButtonImpl::ClearTriggerFlag()
{
    m_ButtonDown = 0;
    m_ButtonUp = 0;
    m_ButtonRepeat = 0;
    m_ButtonRepeatFast = 0;
}

} // namespace uji::sys::internal
} // namespace uji::sys
} // namespace uji
