/*--------------------------------------------------------------------------*
 Project:
 File: sys_Pad.h
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_PAD_H_
#define _UJI_SYS_PAD_H_

#include <nn/hid.h>
#include <nn/hid/CTR/hid_PadReaderWithRemote.h>
#include <nn/math.h>    
#include "sys_PadButtonImpl.h"
    
    
namespace uji {
namespace sys {
    
    
class Pad
{
public:
    enum Button
    {
        BUTTON_A               = nn::hid::CTR::BUTTON_A,
        BUTTON_B               = nn::hid::CTR::BUTTON_B,
        BUTTON_START           = nn::hid::CTR::BUTTON_START,
        BUTTON_RIGHT           = nn::hid::CTR::BUTTON_RIGHT,
        BUTTON_LEFT            = nn::hid::CTR::BUTTON_LEFT,
        BUTTON_UP              = nn::hid::CTR::BUTTON_UP,
        BUTTON_DOWN            = nn::hid::CTR::BUTTON_DOWN,
        BUTTON_R               = nn::hid::CTR::BUTTON_R,
        BUTTON_L               = nn::hid::CTR::BUTTON_L,
        BUTTON_X               = nn::hid::CTR::BUTTON_X,
        BUTTON_Y               = nn::hid::CTR::BUTTON_Y,
//        BUTTON_DEBUG           = nn::hid::CTR::BUTTON_DEBUG,
//        BUTTON_HEADPHONE       = nn::hid::CTR::BUTTON_RESERVED,
        BUTTON_HEADPHONE       = nn::hid::CTR::BUTTON_HP,
        BUTTON_EMULATION_RIGHT = nn::hid::CTR::BUTTON_EMULATION_RIGHT,
        BUTTON_EMULATION_LEFT  = nn::hid::CTR::BUTTON_EMULATION_LEFT,
        BUTTON_EMULATION_UP    = nn::hid::CTR::BUTTON_EMULATION_UP,
        BUTTON_EMULATION_DOWN  = nn::hid::CTR::BUTTON_EMULATION_DOWN,
        BUTTON_SELECT          = nn::hid::CTR::PSEUDO_BUTTON_SELECT
    };
    
    Pad(){};

    void UpdatePad();
    void UpdatePad(nn::hid::CTR::PadStatus& padStatus);
    void ResetPad();
    
    void UpdatePadWithRemote();

    bool IsButtonPress(Button button) const { return (m_PadButtonImpl.IsButtonPress(button)) ? true : false; }
    bool IsButtonDown(Button button) const { return (m_PadButtonImpl.IsButtonDown(button)) ? true : false; }
    bool IsButtonUp(Button button) const { return (m_PadButtonImpl.IsButtonUp(button)) ? true : false; }
    bool IsButtonRepeat(Button button) const { return (m_PadButtonImpl.IsButtonRepeat(button)) ? true : false; }
    bool IsButtonRepeatFast(Button button) const { return (m_PadButtonImpl.IsButtonRepeatFast(button)) ? true : false; }

    const nn::math::VEC2 GetStick() const { return m_Stick; }

    void ClearTriggerFlag() { m_PadButtonImpl.ClearTriggerFlag(); }
    bit32 GetHold() const { return m_PadButtonImpl.GetPress(); }
    bit32 GetTrigger() const { return m_PadButtonImpl.GetDown(); }    

    void WaitReleaseKey();
    bit32 WaitAnyKey();

private:

    // ÓIoϐ    
    static internal::PadButtonImpl m_PadButtonImpl;
    static nn::math::VEC2 m_Stick;
    
};    


}   // usingnamespace sys
}   // usingnamespace uji
  

/* _UJI_SYS_PAD_H_ */
#endif

