/*--------------------------------------------------------------------------*
 Project:
 File: sys_Pad.cpp
 

*--------------------------------------------------------------------------*/
#include "sys_Pad.h"
#ifdef EVA_GYRO_M    
#include "../eva/gyro/gyro_UdsMaster.h"
#endif    
#include <nn/gx.h>


namespace uji {
namespace sys {


// ÓIoϐ̎
internal::PadButtonImpl Pad::m_PadButtonImpl;
nn::math::VEC2 Pad::m_Stick(0.0f, 0.0f);


void Pad::UpdatePad()
{
    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;

    // HID̃pbhǂݍ݁B
    padReader.ReadLatest(&padStatus);
    
    m_PadButtonImpl.Update(static_cast<u32>(padStatus.hold));
    
    m_Stick.x = padStatus.stick.x / 72.0f;
    m_Stick.y = padStatus.stick.y / 72.0f;
}

void Pad::UpdatePad(nn::hid::CTR::PadStatus& padStatus)
{
    m_PadButtonImpl.Update(static_cast<u32>(padStatus.hold));
    
    m_Stick.x = padStatus.stick.x / 72.0f;
    m_Stick.y = padStatus.stick.y / 72.0f;
}

void Pad::UpdatePadWithRemote()
{
    nn::hid::CTR::PadReaderWithRemote padReaderWithRemote;
    nn::hid::CTR::PadStatus padStatus;

    // HID̃pbhǂݍ݁B
    padReaderWithRemote.ReadLatest(&padStatus);
    
    m_PadButtonImpl.Update(static_cast<u32>(padStatus.hold));
}

void Pad::ResetPad()
{
    m_Stick.x = m_Stick.y = 0.0f;

    m_PadButtonImpl.Reset();
}

void Pad::WaitReleaseKey()
{
	//SĂ𗣂܂ő҂BiXChpbh̏\{^G~͔ΏۊOj
	do
	{
        UpdatePad();	
    } while (( GetHold()&(~nn::hid::CTR::PLUS_BUTTON_EMULATION_MASK ) ) != 0);		
}

bit32 Pad::WaitAnyKey()
{
	//܂ő҂iXChpbh̏\{^G~͔ΏۊOj
	do
	{
#ifdef EVA_GYRO_M
        if(eva::GyroUdsMaster::GetInstance()->GetController()->GetStatus().STA_BF)
        {
            return BUTTON_A;
        }
#endif           
        UpdatePad();	
	} while (( GetHold()&(~nn::hid::CTR::PLUS_BUTTON_EMULATION_MASK ) ) == 0);		

	return GetHold();
}


}   // usingnamespace sys
}   // usingnamespace uji
