/*--------------------------------------------------------------------------*
 Project:
 File: sys_MessageLogWindow.h
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_MESSAGE_WINDOW_H_
#define _UJI_SYS_MESSAGE_WINDOW_H_

#include <nn/gx.h>
#include "sys_Window.h"


namespace uji {
namespace sys {

class MessageLogWindow : public Window
{
public:
    MessageLogWindow(s32 width, s32 hweght, s32 bufferHeight, s32 fontHeight=0);
    virtual ~MessageLogWindow();
    void PutString(const char* str);
    void Printf(const char* format, ...);
    void VPrintf(const char* format, std::va_list vlist);

#if 0
    // TODO: Ƀf[^i[Ăobt@̃r[AƂĎgpB
    void AssignBuffer(void* buffer, unsigned long bufferSize, int width);
    void ReleaseBuffer();
#endif    

private:

    virtual void OnDraw(uji::sys::GraphicsDrawing* gfx);
    virtual void OnUpdatePad(const uji::sys::Pad& pad);
    virtual bool OnCreate();
    virtual void OnDestroy();
    
    void SetAutoScroll(bool enable) { mAutoScrollFlag = enable; }
    char* GetTextPtr(int line, int xPos);
    unsigned long PutChar(const char* str, char* dstPtr);
    char* NextLine();
    int GetLineCount();

    static const int m_DrawOffsetX = 4;
    static const int m_DrawOffsetY = 1;    

    bool mAutoScrollFlag;

    void*           mBuffer;
    unsigned long   mBufferSize;
    int mWidth;
    int mHeight;
    int mLineMax;

    int mRingTop;
    int mPrintTop;
    int mPrintXPos;

    int mY;
    int mCyChar;
};    

}   // usingnamespace sys
}   // usingnamespace uji
  

/* _UJI_SYS_MESSAGE_WINDOW_H_ */
#endif

