/*--------------------------------------------------------------------------*
 Project:
 File: sys_MessageLogWindow.cpp
 

*--------------------------------------------------------------------------*/
#include "sys_MessageLogWindow.h"
#include "sys_Window.h"
#include "sys_GraphicsDrawing.h"
#include <nn/gx.h>
#include <nw/ut/ut_Lock.h>

namespace uji {
namespace sys {


/*---------------------------------------------------------------------------
  Desc: RXgN^
  
  Args: width           1sɕ\\ȕ
        height          ʕ\\ȃC
        bufferHeight    obt@ɕێ\ȃC
        fontHeight      \镶TCY
---------------------------------------------------------------------------*/
MessageLogWindow::MessageLogWindow(s32 width, s32 height, s32 bufferHeight, s32 fontHeight)
  : Window("MESSAGE LOG"),
  mAutoScrollFlag(true),
  mBuffer(NULL),
  mBufferSize(0),
  mWidth(width),
  mHeight(height),  
  mLineMax(bufferHeight + 1),
  mRingTop(0),
  mPrintTop(0),
  mPrintXPos(0),    
  mY(0),
  mCyChar(fontHeight)
{
}

/*---------------------------------------------------------------------------
  Desc: fXgN^
---------------------------------------------------------------------------*/
MessageLogWindow::~MessageLogWindow()
{
}

/*---------------------------------------------------------------------------
  Desc: obt@̊mۂƃEChETCY̐ݒ
        EChEɃ}l[WĂ΂܂B
---------------------------------------------------------------------------*/
bool MessageLogWindow::OnCreate()
{
    mBufferSize = (mWidth + 1) * mLineMax;
    mBuffer = new char[mBufferSize];
 
    std::memset(mBuffer, ' ', mBufferSize);
 
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();   
    if (mCyChar == 0)
    {
        mCyChar = static_cast<int>(gfx->m_TextWriter.GetLineHeight());
    }
    Size windowSize;
    windowSize.width = (mCyChar/2)*mWidth + m_DrawOffsetX*2 + CLIENT_OUT_WIDTH;
    windowSize.height = mHeight*mCyChar + CLIENT_OUT_HEIGHT;
    SetSize(windowSize);   
    
    return true; 
}

/*---------------------------------------------------------------------------
  Desc: obt@̊J
        EChEjɃ}l[WĂ΂܂B
---------------------------------------------------------------------------*/
void MessageLogWindow::OnDestroy()
{
    delete[] mBuffer;    
}

/*---------------------------------------------------------------------------
  Desc: `揈
---------------------------------------------------------------------------*/
void MessageLogWindow::OnDraw(uji::sys::GraphicsDrawing* gfx)
{
    Window::OnDraw(gfx);
    
    if (mBuffer == NULL)
    {
        gfx->m_TextWriter.Printf("- not assign buffer -");
    }
    
    const Size clientSize = GetClientSize();
    mY = nw::ut::Clamp(
        mY,
        0,
        nw::ut::Max(0, mCyChar * GetLineCount() - clientSize.height)
    );
#if 0 // fobOp
    NN_LOG("Line Height= %d\n", mCyChar);    
    NN_LOG("ClientH= %d mY= %d LineCount= %d LineMax= %d\n", clientSize.height, mY, GetLineCount(), mLineMax);
#endif
    int line = mRingTop;
    int drawLine = 0;

    // EChENCAg̈̈ʒu擾
    uji::sys::Point client_pos = this->GetClientPosition();
    
    // \Jnʒu̒p
    const Point PrintOffset = Point(client_pos.x + m_DrawOffsetX, client_pos.y + m_DrawOffsetY);
    
    // \ݒ
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
    gfx->SetFixedWidthFont(static_cast<f32>(mCyChar));      
      
    gfx->BeginDrawingString();            
        while (line != mPrintTop)
        {
            int y = static_cast<int>( drawLine * mCyChar ) - mY;
#if 0       // fobOp
            NN_LOG("drawLine= %d y= %d\n", drawLine, y);
#endif
            // EChENCAg̈H
            if ((0 <= y) && (y <= clientSize.height-mCyChar))
            {
                gfx->m_TextWriter.SetCursor(PrintOffset.x, PrintOffset.y + y);
                (void)gfx->m_TextWriter.Printf(GetTextPtr(line, 0));
            }

            ++drawLine;
            if (++line == mLineMax) line = 0;
        }

        // ݂̍s̕`
        if ( mPrintXPos > 0 )
        {
            int y = static_cast<int>( drawLine * mCyChar ) - mY;
            if ( ( -mCyChar <= y ) && ( y <= clientSize.height ) )
            {
                gfx->m_TextWriter.SetCursor(PrintOffset.x, PrintOffset.y + y);
                (void)gfx->m_TextWriter.Printf(GetTextPtr(mPrintTop, 0));
            }
        }
    gfx->EndDrawingString();    


    // XN[o[̕\
    {
        gfx->BeginDrawingShape();

        gfx->SetColor(nw::ut::Color8(0x303030FF));        
        gfx->FillRectangle(
            clientSize.width - 8 + client_pos.x,
            0 + client_pos.y,
            8,
            clientSize.height
        );

        int lineCount = GetLineCount();
        if ( lineCount > 0 )
        {
            gfx->SetColor(nw::ut::Color8::GRAY);        
            gfx->FillRectangle(
                clientSize.width - 7 + client_pos.x,
                mY * clientSize.height / (lineCount * mCyChar) + client_pos.y,
                6,
                nw::ut::Min(
                    clientSize.height,
                    clientSize.height * clientSize.height / (lineCount * mCyChar)
                )
            );
#if 0       // fobOp
            static int count_old = 0xfff;
            if (count_old != lineCount)
            {
                NN_LOG("Line: %d Y1(%d) Y2(%d)\n", lineCount, 
                    mY * clientSize.height / (lineCount * mCyChar) + client_pos.y,
                    nw::ut::Min(
                    clientSize.height,
                    clientSize.height * clientSize.height / (lineCount * mCyChar))
                );
            }     
            count_old = lineCount;
#endif            
        }
    }        
}

/*---------------------------------------------------------------------------
  Desc: pbh
---------------------------------------------------------------------------*/
void MessageLogWindow::OnUpdatePad(const uji::sys::Pad& pad)
{
    Window::OnUpdatePad(pad);
    
    if (mBuffer == NULL)
    {
        return;
    }
    
    const Size clientSize = GetClientSize();
    float stickY = pad.GetStick().y;
        
    // XN[
    if ( stickY > 0 || pad.IsButtonRepeatFast( uji::sys::Pad::BUTTON_UP ) )
    {
        mY -= mCyChar;
    }
    if ( stickY < 0 || pad.IsButtonRepeatFast( uji::sys::Pad::BUTTON_DOWN ) )
    {
        mY += mCyChar;
    }
    // 擪ɃWv
    if ( pad.IsButtonDown( uji::sys::Pad::BUTTON_LEFT ) )
    {
        mY = 0;
    }
    // obt@̍ŌɃWv
    if ( pad.IsButtonDown( uji::sys::Pad::BUTTON_RIGHT ) )
    {
        mY = mCyChar * GetLineCount() - clientSize.height;
    }
}
    
/*---------------------------------------------------------------------------
  Desc: obt@ւ̕o
---------------------------------------------------------------------------*/    
void MessageLogWindow::Printf(const char* format, ...)
{
    if (mBuffer == NULL) return;

    va_list vlist;
    va_start( vlist, format );
    VPrintf( format, vlist );
    va_end( vlist );
}

void MessageLogWindow::VPrintf(const char* format, std::va_list vlist)
{
    if (mBuffer == NULL) return;

    const unsigned long STRING_BUF_SIZE = 1024; // o͕񐶐p̃obt@TCY
    static char sStrBuf[ STRING_BUF_SIZE ];     // o͕񐶐p̃obt@

    (void)std::vsnprintf( sStrBuf, STRING_BUF_SIZE, format, vlist );
    PutString( sStrBuf );
}

void MessageLogWindow::PutString( const char* str )
{
    NW_NULL_ASSERT( str );

    if ( mBuffer == NULL ) return;

    const Size clientSize = GetClientSize();
    
    bool canAutoScroll = false;
    if ( mCyChar * GetLineCount() <= clientSize.height ) canAutoScroll = true;
    else if ( mY == mCyChar * GetLineCount() - clientSize.height ) canAutoScroll = true;

    char* ptr = GetTextPtr( mPrintTop, mPrintXPos );

    // ꕶ[v
    // \[X񂪋ɂȂ܂ŃRs[
    while ( *str )
    {
        bool newLineFlag = false;

        if ( *str == '\n' )
        {
            str++;
            ptr = NextLine();
        }
        else
        {
            u32 bytes = PutChar( str, ptr );

            if ( bytes > 0 )
            {
                str += bytes;
                ptr += bytes;
            }
            else
            {
                newLineFlag = true;
            }
        }
        if ( mPrintXPos >= mWidth )
        {
            // ʒu[܂ŗĂstO𗧂Ă
            newLineFlag = true;
        }

        if ( newLineFlag )
        {
            // sł΂Pǂݔ΂
            if ( *str == '\n' ) ++str;

            ptr = NextLine();
        }
    }

    // I[Ƀkt
    if ( *str == '\0' )
    {
        *( GetTextPtr( mPrintTop, mPrintXPos ) ) = '\0';
    }

    // \ʒuXV
    if ( mAutoScrollFlag )
    {
        if ( canAutoScroll )
        {
            mY = nw::ut::Max(0, mCyChar * GetLineCount() - clientSize.height);
        }
    }
}

unsigned long MessageLogWindow::PutChar(const char* str, char* dstPtr)
{
    unsigned long codeWidth = static_cast<unsigned long>(
        ( (u8)*str >= 0x81 ) ? 2 : 1
    );

    if (mPrintXPos + codeWidth > mWidth) return 0;

    mPrintXPos += codeWidth;

    unsigned long cnt = codeWidth;
    while ( cnt > 0 )
    {
        *dstPtr++ = *str++;
        cnt--;
    }
    return codeWidth;
}

/*---------------------------------------------------------------------------
  Desc: wʒũobt@̃AhX擾
---------------------------------------------------------------------------*/    
char* MessageLogWindow::GetTextPtr(int line, int xPos)
{
    return reinterpret_cast<char*>( mBuffer ) + ( (mWidth + 1) * line + xPos );
}

/*---------------------------------------------------------------------------
  Desc: 
---------------------------------------------------------------------------*/
char* MessageLogWindow::NextLine()
{
    // ݂̍sNUL}
    *( GetTextPtr(  mPrintTop, mPrintXPos ) ) = '\0';

    // o͈ʒuύX
    mPrintXPos = 0;
    mPrintTop++;
    if ( mPrintTop == mLineMax ) mPrintTop = 0;

    if ( mPrintTop == mRingTop )
    {
        if ( ++mRingTop == mLineMax ) mRingTop = 0;
    }
    return GetTextPtr( mPrintTop, 0 );
}

/*---------------------------------------------------------------------------
  Desc:
---------------------------------------------------------------------------*/
int MessageLogWindow::GetLineCount()
{
    int lineCount = mPrintTop - mRingTop;
    if ( lineCount < 0 ) lineCount += mLineMax;
    if ( mPrintXPos > 0 ) lineCount += 1;
    return lineCount;
}


#if 0
// TODO: Ƀf[^i[Ăobt@̃r[AƂĂgpB
/*---------------------------------------------------------------------------
  Desc: bZ[Wi[pobt@̊蓖

  Args: buffer      i[pobt@ւ̃|C^
        bufferSize  i[pobt@̃TCY
        width       1C̕
---------------------------------------------------------------------------*/
void MessageLogWindow::AssignBuffer(void* buffer, unsigned long bufferSize, int width)
{
    mBuffer = buffer;
    mBufferSize = bufferSize;
    mWidth = width;
    mLineMax = static_cast<int>(bufferSize) / (width + 1);
}

/*---------------------------------------------------------------------------
  Desc: bZ[Wi[pobt@̉
---------------------------------------------------------------------------*/
void MessageLogWindow::ReleaseBuffer()
{
    mBuffer = NULL;
    mBufferSize = 0;
}
#endif
    

}   // usingnamespace sys
}   // usingnamespace uji
