/**************************************************************************

j[NX


 *************************************************************************/
#include <vector>
#include <string.h>
#include <nn.h>
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_TextWindow.h"
#include "sys_Pad.h"
#include "sys_App.h"
#include "sys_Menu.h"
using namespace uji;
using namespace uji::sys;

int Menu::m_TotalMenuQuantity=0;
int Menu::m_DefaultOriginX=0;
int Menu::m_DefaultOriginY=0;

uji::sys::WindowManager Menu::m_WindowManager;
uji::sys::TextWindow *Menu::m_SubWindow=0;

const nn::util::Color8 CURSOR_COLOR = nn::util::Color8::WHITE;
const int FONT_SIZE = 14;
const int GAP=8;
const int LEFT_GAP=2;

const int SUB_WINDOW_SIZE_X = 40;
const int SUB_WINDOW_SIZE_Y = 10;


Menu::Menu( const char *title, int originX, int originY, int column )
	:uji::sys::Window("",0,0), m_Title(title), m_OriginX(originX), m_OriginY(originY), m_Column(column), m_FrameCount(0)
{
    m_TotalMenuQuantity++;
}

Menu::~Menu(){
    std::vector<MenuCommand*>::iterator it;

    //ej[̃CX^X폜 i`ŃCX^X쐬Ă܂Bj
    for (it = m_MenuCommandArray.begin(); it != m_MenuCommandArray.end(); it++) {
	    delete *it;
    }
    m_TotalMenuQuantity--;
}

/**************************************************************************

J

 *************************************************************************/
void Menu::Open( void )
{
	//j[̎O
	Initialize();

    //j[I[v
    m_SelectedMenu = 0;

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        
    do
    {
        //pbhXV
        pad.UpdatePad();
        
        //j[s
        if( pad.IsButtonDown( Pad::BUTTON_A ) && m_SelectedMenu<m_MenuElementNumber )
        {
 			m_MenuCommandArray[m_SelectedMenu]->Execute();
            m_WindowManager.SetActiveWindow( this );

            //gKNA
            pad.ClearTriggerFlag();            
        }

		//TuEChE̕\
		m_SubWindow->Printf("\f");
        if( m_SelectedMenu < m_MenuElementNumber )
		{
			if( m_MenuCommandArray[m_SelectedMenu]->GetMessage() )
			{
				m_SubWindow->Printf("%s", m_MenuCommandArray[m_SelectedMenu]->GetMessage() );
			}
		}

		//EChE
        m_WindowManager.Update();
        m_WindowManager.UpdatePad(pad);              
       
        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();
        m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        

        // ʕ`        
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

	}
    while( !pad.IsButtonDown(Pad::BUTTON_B) );

    Finalize();
}

/**************************************************************************

j[ɕKvȏ߂ĕۑĂ

 *************************************************************************/
void Menu::Initialize( void )
{
	//j[ƍő啝߂ĕۑĂB
	std::vector<MenuCommand*>::iterator it;

	m_MenuElementNumber=0;
	m_MenuLength=0;	

	for (it = m_MenuCommandArray.begin(); it != m_MenuCommandArray.end(); it++) {
		m_MenuElementNumber++;
		if( strlen( (*it)->GetName() ) > m_MenuLength )  m_MenuLength=strlen( (*it)->GetName() );
	}

	//j[̃EvZĂ
	m_Row = m_MenuElementNumber/m_Column + ( (m_MenuElementNumber%m_Column)?1:0);

    //TuEChE}l[Wɓo^
	if( m_SubWindow==0 )
	{
		m_SubWindow = new TextWindow( SUB_WINDOW_SIZE_X, SUB_WINDOW_SIZE_Y, FONT_SIZE );
		m_SubWindow->SetTitle( "INFORMATION" );
		m_WindowManager.CreateWindow( m_SubWindow, NN_GX_DISPLAY1, 0, 0 );        
	}	
    //EChE}l[Wɓo^
    Size windowSize;
    windowSize.height = m_Row*FONT_SIZE;
    windowSize.width = m_MenuLength*FONT_SIZE/2*m_Column+GAP*(m_Column-1)+LEFT_GAP;
    if( windowSize.width < strlen(m_Title)*FONT_SIZE/2  ) windowSize.width = strlen(m_Title)*FONT_SIZE/2;
    SetClientSize( windowSize );
    SetTitle( m_Title );
    m_WindowManager.CreateWindow(this, NN_GX_DISPLAY0, m_OriginX, m_OriginY );
	m_WindowManager.SetManagerPadControlFlag(false);
}

/**************************************************************************

I
 *************************************************************************/
void Menu::Finalize( void )
{
	
    m_WindowManager.DestroyWindow(this);
   
}

/**************************************************************************

j[ɍڂǉ
 
 *************************************************************************/
void Menu::Add( const char *name, void (*function)(void), Attribute attribute, const char *message )
{
	MenuCommand *cmd;
	cmd = new MenuVariation_Static( name, function, attribute, message );
	m_MenuCommandArray.push_back( cmd );
}

void Menu::Add( const char *name, void (*function)(void), const char *message )
{
	const Attribute attribute=nw::ut::Color8::WHITE;
	MenuCommand *cmd;
	cmd = new MenuVariation_Static( name, function, attribute, message );
	m_MenuCommandArray.push_back( cmd );
}
/**************************************************************************
 *************************************************************************/
// `揈
void Menu::OnDraw(uji::sys::GraphicsDrawing* gfx)
{    
    gfx->m_TextWriter.SetFontSize((f32)FONT_SIZE);
    gfx->m_TextWriter.EnableFixedWidth(true);
    gfx->m_TextWriter.SetFixedWidth(FONT_SIZE/2);
    gfx->BeginDrawingString();

    //j[{̂`悷
    for( int i=0 ; i<m_Row ; i++ )
    {
        for( int j=0 ; j<m_Column ; j++ )
        {
            if( i*m_Column+j < m_MenuElementNumber )
            {
                //`ʒuZo
                int x = GetPosition().x + j*(m_MenuLength*FONT_SIZE/2+ GAP)+LEFT_GAP;
                int y = GetPosition().y+i*FONT_SIZE+GetTitleBarHeight();
                gfx->m_TextWriter.SetCursor( x, y );

                // IJ[\̓_ŏ                
	            if( i*m_Column +j == m_SelectedMenu )
                {           
                    // ܂ł̕`R}hGPUɑ     
                    gfx->EndDrawingString();
                    
                    u8 col = (this->GetActiveFlag() == true)
                        ? ((m_FrameCount/(256/8))%2==0) ? 255-m_FrameCount*8%256 : m_FrameCount*8%256
                        : 80;
                    gfx->BeginDrawingShape();
                    gfx->SetColor(nw::ut::Color8(col/2, col/2, 0, 255));    
                    gfx->FillRectangle(x, y, m_MenuLength*FONT_SIZE/2, FONT_SIZE);
                    
                    // `̐ݒɖ߂
                	gfx->m_TextWriter.SetTextColor( CURSOR_COLOR );                    
                    gfx->BeginDrawingString();
                }else{
                    gfx->m_TextWriter.SetTextColor( m_MenuCommandArray[i*m_Column+j]->GetAttribute() );
                }
                
                //\
                gfx->m_TextWriter.Print( m_MenuCommandArray[i*m_Column+j]->GetName() );
			}
        } 
    }    
    gfx->EndDrawingString();
}

// ͏
void Menu::OnUpdatePad(const uji::sys::Pad& pad)
{
    //sƗɕ
    int CurrentColumn = m_SelectedMenu % m_Column;
    int CurrentRow    = m_SelectedMenu / m_Column;

	//Rg[͂ɑΉ鏈
    if( pad.IsButtonRepeat( pad.BUTTON_RIGHT ) ) CurrentColumn++;
    if( pad.IsButtonRepeat( pad.BUTTON_LEFT  ) ) CurrentColumn--;
    if( pad.IsButtonRepeat( pad.BUTTON_UP    ) ) CurrentRow--;
    if( pad.IsButtonRepeat( pad.BUTTON_DOWN  ) ) CurrentRow++;

    // E
    if( CurrentColumn<0 ) CurrentColumn += m_Column;
    if( CurrentRow   <0 ) CurrentRow    += m_Row;
    CurrentColumn %= m_Column;
    CurrentRow    %= m_Row;

	//ʂč\z
    m_SelectedMenu = m_Column*CurrentRow+CurrentColumn;
}

// t[XV
void Menu::OnUpdate(void)
{
    m_FrameCount++;    
}
