/*--------------------------------------------------------------------------*
 Project:
 File: sys_Memory.h
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_MEMORY_H_
#define _UJI_SYS_MEMORY_H_

#include <nw/types.h>
#include <nw/os/os_Memory.h>


namespace uji {
namespace sys {

//========================================================================================
// NintendoWare\.. \demo\demo_Memory.h Ql
    
namespace internal {
    
    /*!--------------------------------------------------------------------------*
      @brief       C烁̈mۂ܂B

      @param[in]   size      mۂ郁TCYłB

      @return      mۂAhXłB
     *---------------------------------------------------------------------------*/
    void* AllocInternal_(size_t size);

    /*!--------------------------------------------------------------------------*
      @brief       C烁̈܂B

      @param[in]   memory      邷郁̈łB
     *---------------------------------------------------------------------------*/
    void  FreeInternal_(void* memory);

} // namespace internal
    
/*!--------------------------------------------------------------------------*
  @brief       fpɃ܂B
               IɌĂ΂Ȃꍇɂ́ÃAP[gs
               ftHgŎs܂B
  
  @param[in] mainMemorySize  AvP[Vp̊mۂ郁TCYw肵܂B
                             0̏ꍇɂ́Afp̃ftHgTCYݒ肵܂B
 *---------------------------------------------------------------------------*/
void InitializeDemoMemory( size_t mainMemorySize = 0 );
    
/*!--------------------------------------------------------------------------*
  @brief       C烁̈mۂ܂B

  @param[in]   size      mۂ郁TCYłB
  @param[in]   alignment mۂ郁̃ACglłB

  @return      mۂAhXłB
 *---------------------------------------------------------------------------*/
void* Alloc(size_t size, u8 alignment = 4);

#if defined( NW_TARGET_CTR )
/*!--------------------------------------------------------------------------*
  @brief       foCX烁̈mۂ܂B

  @param[in]   size      mۂ郁TCYłB
  @param[in]   alignment mۂ郁̃ACglłB

  @return      mۂAhXłB
 *---------------------------------------------------------------------------*/
void* AllocDeviceMemory(size_t size, u8 alignment = 4);
#endif

/*!--------------------------------------------------------------------------*
  @brief       q[vփ̈܂B

  @param[in]   memory  郁̈łB
 *---------------------------------------------------------------------------*/
void  Free(void* memory);


/*!--------------------------------------------------------------------------*
  @brief   fp̃CAP[^łB
 *---------------------------------------------------------------------------*/
class DemoAllocator : public nw::os::IAllocator
{
public:
    //! @brief C烁mۂ܂B
    //!
    //! param[in] size      mۂ郁TCYłB
    //! param[in] alignment ACgłB
    //!
    //! @return mۂAhXԂ܂B
    virtual void* Alloc(size_t size, u8 alignment) 
    {
        // nw::demo     
        return uji::sys::Alloc(size, alignment);
    }
    
    using nw::os::IAllocator::Alloc;
    
    //! @brief CɃԋp܂B
    //!
    //! param[in] memory    ԋp郁AhXłB
    virtual void Free(void* memory)
    {
        // nw::demo        
        uji::sys::Free(memory);
    }
};

#if defined(NW_TARGET_CTR)

/*!--------------------------------------------------------------------------*
  @brief   CTRfp̃foCXAP[^łB
 *---------------------------------------------------------------------------*/
class DemoDeviceMemoryAllocator : public nw::os::IAllocator
{
public:
    //! @brief foCX烁mۂ܂B
    //!
    //! param[in] size      mۂ郁TCYłB
    //! param[in] alignment ACgłB
    //!
    //! @return mۂAhXԂ܂B
    virtual void* Alloc(size_t size, u8 alignment) 
    { 
        // nw::demo
        return uji::sys::AllocDeviceMemory(size, alignment);
    }
    
    using nw::os::IAllocator::Alloc;
    
    //! @brief foCXɃԋp܂B
    //!
    //! param[in] memory    ԋp郁AhXłB
    virtual void Free(void* memory)
    {
        // nw::demo
        uji::sys::Free(memory);
    }
};

#endif


}   // usingnamespace sys
}   // usingnamespace uji
  

/* _UJI_SYS_APP_H_ */
#endif

