/*--------------------------------------------------------------------------*
 Project:
 File: sys_Memory.cpp
 

*--------------------------------------------------------------------------*/
#include <stdlib.h>
#include <nn/os.h>
#include <nn/fnd.h>
#include <nw/ut/ut_Inlines.h>
#include <nn/init.h>

#include "sys_Memory.h"

    
namespace uji {
namespace sys {

#ifndef EVA_ENABLE_GPUTEST
#define NN_OS_DEVICE_MEMORY_SIZE (32 * 1024 * 1024) // 32MB
#else
#define NN_OS_DEVICE_MEMORY_SIZE (44 * 1024 * 1024) // 44MB
#endif

static nn::os::MemoryBlock  s_MemoryBlock;
static nn::fnd::ExpHeap     s_MainMemoryHeap;
static nn::fnd::ExpHeap     s_DeviceHeap;
static bool                 s_IsInitialized = false;


extern "C" void nninitStartUp()
{
    const size_t assingment   = nn::os::GetAppMemorySize();
    const size_t currentUsing = nn::os::GetUsingMemorySize();
    
    const size_t DEVICE_MEMORY_SIZE = NN_OS_DEVICE_MEMORY_SIZE;
    const size_t available = assingment - currentUsing;
    const size_t heapSize  = available - DEVICE_MEMORY_SIZE;
    
    nn::os::SetupHeapForMemoryBlock(heapSize);
    NN_UTIL_PANIC_IF_FAILED( nn::os::SetDeviceMemorySize( DEVICE_MEMORY_SIZE ) );
    
    nn::init::InitializeAllocator( 8 * 1024 * 1024 );
}
    
namespace
{
    /*!--------------------------------------------------------------------------*
      @brief        AhXfoCXǂ𔻒肵܂B

      @param[in]    memory  AhXłB

      @return       foCXp̃AhX̏ꍇ trueA
                    ȊȌꍇ false Ԃ܂B
     *---------------------------------------------------------------------------*/
    bool IsDeviceMemory(const void* memory)
    {
        if (nn::os::GetDeviceMemoryAddress() <= (uint)memory && 
            (uint)memory <= nn::os::GetDeviceMemoryAddress() + NN_OS_DEVICE_MEMORY_SIZE)
        {
            return true;
        }
        else
        {
            return false;
        }
    }    
}


//--------------------------------------------------------------------------
void InitializeDemoMemory(size_t mainMemorySize /* = 0 */ )
{
    if ( s_IsInitialized )
    {
        return;
    }
    s_IsInitialized = true;
    
#ifndef EVA_ENABLE_GPUTEST
    const size_t DEFAULT_DEMO_MEMORY_SIZE = 0x1000000; // 16MB
#else
    const size_t DEFAULT_DEMO_MEMORY_SIZE = 0x800000; // 8MB
#endif
    
    size_t allocateSize = (mainMemorySize == 0) ? DEFAULT_DEMO_MEMORY_SIZE : mainMemorySize;
    
    s_MemoryBlock.Initialize(allocateSize);
    size_t size = s_MemoryBlock.GetSize();
    uptr address = s_MemoryBlock.GetAddress();
    s_MainMemoryHeap.Initialize(address, size, nn::os::ALLOCATE_OPTION_LINEAR);
    nwosPrintf("################# Main Memory : 0x%x - 0x%x #################\n", (uint)address, ((uint)address + size));    
    
    s_DeviceHeap.Initialize(nn::os::GetDeviceMemoryAddress(), nn::os::GetDeviceMemorySize(), nn::os::ALLOCATE_OPTION_LINEAR);
    nwosPrintf("################# Device Memory : 0x%x - 0x%x #################\n", nn::os::GetDeviceMemoryAddress(), nn::os::GetDeviceMemoryAddress() + nn::os::GetDeviceMemorySize());
}


namespace internal {

//--------------------------------------------------------------------------
void* AllocInternal_(size_t size)
{
    InitializeDemoMemory(); // ̏ꍇɂ̓ftHgݒŏB
    
    void* memory = s_MainMemoryHeap.Allocate(size);
    return memory;
}

//--------------------------------------------------------------------------
void* AllocDeviceMemoryInternal_(size_t size)
{
    InitializeDemoMemory(); // ̏ꍇɂ̓ftHgݒŏB
    
    void* memory = s_DeviceHeap.Allocate(size);
    return memory;
}

//--------------------------------------------------------------------------
void FreeInternal_(void* memory)
{
    if (IsDeviceMemory(memory))
    {
        s_DeviceHeap.Free(memory);
    }
    else
    {
        s_MainMemoryHeap.Free(memory);
    }
}

} // namespace internal


/*!--------------------------------------------------------------------------*
  @brief       mۂ̃ACg𒲐܂B

  @param[in]   memory  mۂꂽ̐擪|C^łB
  @param[in]   align   ACglłB

  @return      ACꂽAhXԂ܂B
 *---------------------------------------------------------------------------*/
static void* AlignMemory_( void* memory, u8 align )
{
    void* top = nw::ut::AddOffsetToPtr( memory, 1 );
    top = nw::ut::RoundUp( top, align );
    
    u8* head = reinterpret_cast<u8*>( nw::ut::AddOffsetToPtr( top, - 1 ) );
    
    size_t offset = nw::ut::GetOffsetFromPtr( memory, top );
    NW_U8_RANGE_ASSERT( offset );
    
    *head = static_cast<u8>( offset );
    return top;
}

/*!--------------------------------------------------------------------------*
  @brief       ACgꂽmۂAhX֖߂܂B

  @param[in]   memory  ACꂽ̃|CgłB

  @return      ACÕAhXԂ܂B
 *---------------------------------------------------------------------------*/
static void* UnAlignMemory_( void* memory )
{
    u8* head = reinterpret_cast<u8*>( nw::ut::AddOffsetToPtr( memory, -1 ) );
    
    u8 offset = *head;
    
    return nw::ut::AddOffsetToPtr( memory, -offset );
}

//--------------------------------------------------------------------------
void* Alloc(size_t size, u8 alignment)
{
    // 2ׂ̂̃`FbN
    NW_ASSERT( (alignment & (alignment - 1)) == 0 );
    
    if ( alignment == 0 ) { alignment = 1; }
    
    void* memory = internal::AllocInternal_( size + alignment );
    return AlignMemory_( memory, alignment );
}

//--------------------------------------------------------------------------
void* AllocDeviceMemory(size_t size, u8 alignment)
{
    // 2ׂ̂̃`FbN
    NW_ASSERT( (alignment & (alignment - 1)) == 0 );
    
    if ( alignment == 0 ) { alignment = 1; }
    
    void* memory = internal::AllocDeviceMemoryInternal_( size + alignment );
    return AlignMemory_( memory, alignment );
}

//--------------------------------------------------------------------------
void Free(void* memory)
{
    memory = UnAlignMemory_( memory );
    internal::FreeInternal_( memory );
}


}   // usingnamespace sys
}   // usingnamespace uji
