/************************************************************************

alot@C[hăeNX`NX

 *************************************************************************/
#include <nn.h>
#include <nn/fs.h>
#include <nn/jpeg.h>

#include "sys.h"
#include "sys_JpegTexture.h"

using namespace uji::sys;


/************************************************************************
 ioft@CI[văeNX`f[^ɂ܂B
 ************************************************************************/
bool JpegTexture::Open( const wchar_t *fileName )
{   
	//t@Cǂݏo
	NN_LOG("\nReading data from ROMFS...\n");
    nn::fs::FileReader file(fileName);
    
    size_t fileSize = file.GetSize();
    NN_LOG("  fileSize = %d (Byte)\n", fileSize);
    if ( fileSize == 0 )
    {
        NN_LOG("Failed to open File.\n");
        NN_ASSERT(0);
        return false;
    }

    u8 *decodeSrcBuffer = (u8*)sysApp->Allocate(fileSize, 32 );

    s32 readSize = file.Read(decodeSrcBuffer, fileSize);        
    NN_LOG("  readSize = %d (Byte)\n", readSize);
    if ( readSize == 0 )
    {
        NN_LOG("Failed to open jpegRomFilename.\n");
        NN_ASSERT(0);
		return false;
    }

	file.Finalize();

	//fR[_
	nn::jpeg::JpegMpDecoder decoder;
	size_t decoderWorkSize = decoder.GetWorkBufferSize();
    void *decoderWork = sysApp->Allocate( decoderWorkSize );
	decoder.Initialize( decoderWork, decoderWorkSize );

	//eNX`WJpm
	const nn::jpeg::PixelFormat dstPixelFormat = nn::jpeg::PIXEL_FORMAT_CTR_RGB565_BLOCK8;
    size_t dstBufferSize = decoder.GetDstBufferSize(MAX_WIDTH, MAX_HEIGHT, dstPixelFormat);
	m_RgbBufferJpeg = (u8*)sysApp->Allocate(dstBufferSize, 64 );

	//fR[h
	size_t decodeResult =decoder.StartJpegDecoder(	m_RgbBufferJpeg,
													dstBufferSize,
													decodeSrcBuffer,
													readSize,
													MAX_WIDTH,
													MAX_HEIGHT,
													dstPixelFormat,
													false);
	m_Width = decoder.GetLastWidth();
	m_Height = decoder.GetLastHeight();

	//fR[hpJ
	decoder.Finalize();
	sysApp->Free( decoderWork );

	//t@C[hpJ
	sysApp->Free( decodeSrcBuffer );

	return (decodeResult!=0)?true:false;
}

// IuWFNgt@CJꍇ
bool JpegTexture::Open(const u8 *decodeSrcBuffer, s32 readSize)
{       
	//fR[_
	nn::jpeg::JpegMpDecoder decoder;
	size_t decoderWorkSize = decoder.GetWorkBufferSize();
    void *decoderWork = sysApp->Allocate( decoderWorkSize );
	decoder.Initialize( decoderWork, decoderWorkSize );

	//eNX`WJpm
	const nn::jpeg::PixelFormat dstPixelFormat = nn::jpeg::PIXEL_FORMAT_CTR_RGB565_BLOCK8;
    size_t dstBufferSize = decoder.GetDstBufferSize(MAX_WIDTH, MAX_HEIGHT, dstPixelFormat);
	m_RgbBufferJpeg = (u8*)sysApp->Allocate(dstBufferSize, 64 );

	//fR[h
	size_t decodeResult =decoder.StartJpegDecoder(	m_RgbBufferJpeg,
													dstBufferSize,
													decodeSrcBuffer,
													readSize,
													MAX_WIDTH,
													MAX_HEIGHT,
													dstPixelFormat,
													false);
	m_Width = decoder.GetLastWidth();
	m_Height = decoder.GetLastHeight();

	//fR[hpJ
	decoder.Finalize();
	sysApp->Free( decoderWork );

	return (decodeResult!=0)?true:false;
}



/************************************************************************
\peNX`ɎgpJ܂B
 ************************************************************************/
void JpegTexture::Close(void)
{
	sysApp->Free( m_RgbBufferJpeg );
}



