/*--------------------------------------------------------------------------*
 Project:
 File: JpegDrawer.h


*--------------------------------------------------------------------------*/
#ifndef __SYS_JPEG_DRAWER_H__
#define __SYS_JPEG_DRAWER_H__

#include <nn/types.h>
#include "sys.h"


namespace uji {
namespace sys {


/*
    Desc: JPEG`悷
*/
class JpegDrawer 
{
public:    
    JpegDrawer() : m_isOpen(false), m_TextureId(0)
    {}
    virtual ~JpegDrawer(){}

    void OpenPicture(wchar_t *file);
    void OpenPicture(const u8 *decodeSrcBuffer, s32 readSize);
    void ClosePicture();
    void DrawPicture(s32 display);

private:
    bool m_isOpen;
	GLuint m_TextureId;    
    sys::JpegTexture m_jt;    
};
        


} // namespace
}

#endif
