/*--------------------------------------------------------------------------*
 Project:
 File: JpegDrawer.cpp

       
*--------------------------------------------------------------------------*/
#include "sys_JpegDrawer.h"
    

namespace uji {
namespace sys {
    
    
//============================================================================
//                      Jpeg摜\֘A
//============================================================================

/*
    Desc: 摜I[v
*/
void JpegDrawer::OpenPicture(wchar_t *file)
{
    if (m_isOpen)
    {
        ClosePicture();
    }
    else if (m_TextureId != 0)
    {
	    sys::GraphicsDrawing::GetInstance()->m_DrawFramework->DeleteTexture(m_TextureId);        
    } 
    m_jt.Open(file);        
	sys::GraphicsDrawing::GetInstance()->m_DrawFramework->GenerateTexture(
        GL_TEXTURE_2D, 
        GL_RGB_NATIVE_DMP,
	    m_jt.GetWidth(),    
        m_jt.GetHeight(),
	    GL_RGB_NATIVE_DMP,
	    GL_UNSIGNED_SHORT_5_6_5,
        m_jt.GetTextureDataPointer(),
        m_TextureId);
    
    m_isOpen = true;
}    
  
// IuWFNgt@CI[v  
void JpegDrawer::OpenPicture(const u8 *decodeSrcBuffer, s32 readSize)
{
    if (m_isOpen)
    {
        ClosePicture();
    }
    else if (m_TextureId != 0)
    {
	    sys::GraphicsDrawing::GetInstance()->m_DrawFramework->DeleteTexture(m_TextureId);        
    } 
	m_jt.Open(decodeSrcBuffer, readSize);            
	sys::GraphicsDrawing::GetInstance()->m_DrawFramework->GenerateTexture(
        GL_TEXTURE_2D, 
        GL_RGB_NATIVE_DMP,
	    m_jt.GetWidth(),    
        m_jt.GetHeight(),
	    GL_RGB_NATIVE_DMP,
	    GL_UNSIGNED_SHORT_5_6_5,
        m_jt.GetTextureDataPointer(),
        m_TextureId);
    
    m_isOpen = true;
}    
  
/*
    Desc: 摜N[Y
*/  
void JpegDrawer::ClosePicture()
{
    if (m_TextureId != 0)
    {
	    sys::GraphicsDrawing::GetInstance()->m_DrawFramework->DeleteTexture(m_TextureId);
	    m_jt.Close();
        m_TextureId = 0;       
        
        m_isOpen = false;
    } 
}
    
/*
    Desc: 摜\
*/
void JpegDrawer::DrawPicture(s32 display)
{
    if (!m_isOpen)
    {
        return;
    }    
    
    u32 display_width;
    u32 display_height;
    
    switch (display)
    {
    case NN_GX_DISPLAY0:
        display_width   = sys::GraphicsDrawing::DISPLAY0_WIDTH;
        display_height  = sys::GraphicsDrawing::DISPLAY0_HEIGHT;        
        break;
        
    case NN_GX_DISPLAY1:
        display_width   = sys::GraphicsDrawing::DISPLAY1_WIDTH;
        display_height  = sys::GraphicsDrawing::DISPLAY1_HEIGHT;            
        break;
        
    default:
        return;
    }
    
	sys::GraphicsDrawing::GetInstance()->SetScreenSize(
        display_width, display_height);
	sys::GraphicsDrawing::GetInstance()->m_DrawFramework->FillTexturedRectangle(
        m_TextureId,
	    0.0f, 0.0f, 
		display_width, display_height, 
		display_width, display_height, 
		m_jt.GetWidth(), m_jt.GetHeight());
}
        
                
} // namespace
}
