/*--------------------------------------------------------------------------*
 Project:
 File: sys_InputTextWindow.h
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_INPUT_TEXT_WINDOW_H_
#define _UJI_SYS_INPUT_TEXT_WINDOW_H_

#include <nn/gx.h>
#include <nw/ut/ut_Color.h>
    
#include "sys_TextWindow.h"
#include "sys_Menu.h"

namespace uji {
namespace sys {


class InputTextWindow : public TextWindow
{
public:
    // RXgN^EfXgN^
    InputTextWindow(s32 width, s32 height, s32 fontHeight, sys::WindowManager& mgr=uji::sys::Menu::m_WindowManager);
    virtual ~InputTextWindow();
        
    //f[^͂܂BF͏l
    u32     InputData(      u32     initialValue=0      );  //PUiW
    u16     InputData16(    u16     initialValue=0      );  //PUiS
    u8      InputData8(     u8      initialValue=0      );  //PUiQ
    u32     InputDecimal(   u32     initialValue=0      );  //POiS
    u32     InputDecimal5(   u32    initialValue=0      );  //POiT
    bool    InputBool(      bool    initialValue=false  );  //annkl
    u32     InputAscii3(    u32     initialValue=0      );  //ASCII 3

private:
    //ėpf[^̓\bh
    u32 GenericInputData( u32 initialValue, int figureValue, int upFigureValue );

    sys::WindowManager& m_WindowManager;
};

}   // usingnamespace sys
}   // usingnamespace uji
  

/* _UJI_SYS_INPUT_TEXT_WINDOW_H_ */
#endif

