/**************************************************************************
l͋@\eLXgEBhE
 *************************************************************************/
#include <nn.h>
#include "sys.h"
#include "sys_InputTextWindow.h"
#include "sys_Menu.h"
using namespace uji::sys;

ATTR_TEXT_COLOR CURSOR_COLOR = ATTR_COLOR_RED;
ATTR_TEXT_COLOR STRING_COLOR = ATTR_COLOR_WHITE;


/************************************************************************
f[^PʂɕEč\zNX
 ************************************************************************/
class BreakUpValue
{
  public:
	//CX^X쐬ɒlAAěオNlLqĂB
	BreakUpValue( u32 value, int numDigits, int carryValue ):m_Value(value), m_NumDigits(numDigits), m_CarryValue(carryValue){
		m_CurrentDigit = m_NumDigits-1;
		m_EachDigit = new int[m_NumDigits];
	}
	~BreakUpValue(){
		delete[] m_EachDigit;
	}
	
	void MoveDigitLeft(void);			//Ώۂ̌ǐjɈړ܂B
	void MoveDigitRight(void);			//Ώۂ̌EǐjɈړ܂B
	void IncrementCurrentDigit(void);	//Ώۂ̌̐lCNg܂B
	void DecrementCurrentDigit(void);	//Ώۂ̌̐lfNg܂B

	//ݕێĂl𕶎񉻂܂iPUi܂Łj
	const char *ToString(void);

	//ݕێĂl擾܂B
	u32 Get(void){	return m_Value; }
	//lύX܂B
    void Set(u32 value ){
        m_Value=value;
        BreakUp();
    }
	//Ώۂ̌擾܂B
	int GetCurrentDigit(void){ return m_CurrentDigit; }

  private:
	static const int MAX_LENGTH = 0x10;

	u32 m_Value;		//ێĂl
  	int m_NumDigits;	//
  	int m_CarryValue;	//オ肷liPOȉꍇ͂POAPUȉꍇ͂PUj
	int m_CurrentDigit;	//ݕύXΏۂ̌
	int *m_EachDigit;		//eɕƂɕێobt@
	char str[10];	//i[pobt@

	//e̗vfɕ܂B
	//̑ɏ߂EachDigitgp\ɂȂ܂B
	void BreakUp(void);

	//BreakUpŕlč\܂B
	void Rebuild(void);

};

void BreakUpValue::MoveDigitLeft(void){
	if(m_CurrentDigit>0 ) m_CurrentDigit--;
}

void BreakUpValue::MoveDigitRight(void){
	if(m_CurrentDigit<m_NumDigits-1 ) m_CurrentDigit++;
}

void BreakUpValue::IncrementCurrentDigit(void){
	BreakUp();
	m_EachDigit[m_CurrentDigit]++;
	if( m_EachDigit[m_CurrentDigit] > m_CarryValue-1 ) m_EachDigit[m_CurrentDigit]=0;
	Rebuild();
}

void BreakUpValue::DecrementCurrentDigit(void){
	BreakUp();
	m_EachDigit[m_CurrentDigit]--;
	if( m_EachDigit[m_CurrentDigit] < 0 ) m_EachDigit[m_CurrentDigit]= m_CarryValue-1;
	Rebuild();
}

const char *BreakUpValue::ToString(void){
//    const char CONVERSION_TABLE[]="0123456789ABCDEF";   //l𕶎ɕϊ邽߂̃e[u
    const char CONVERSION_TABLE[]="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";   //l𕶎ɕϊ邽߂̃e[u

    BreakUp();

	for( int i=0 ; i<m_NumDigits ; i++ )
	{
        str[i]=CONVERSION_TABLE[m_EachDigit[i]];            
    }
    str[m_NumDigits]='\0';
    return str;
}


void BreakUpValue::BreakUp(void){
	u32 Value = m_Value;
	for( int i=0 ; i<m_NumDigits ; i++ ){
    	m_EachDigit[ m_NumDigits-1-i ] = Value%m_CarryValue ;
		Value /= m_CarryValue;
	}
}

void BreakUpValue::Rebuild(void){
	m_Value=0;
	for( int i=0 ; i<m_NumDigits ; i++ ){
    	m_Value *=m_CarryValue;
    	m_Value +=m_EachDigit[i];
	}
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/
InputTextWindow::InputTextWindow(s32 width, s32 height, s32 fontHeight, sys::WindowManager& mgr)
  : TextWindow( width, height, fontHeight ), m_WindowManager(mgr)
{
}

InputTextWindow::~InputTextWindow()
{
}


/************************************************************************
f[^͂܂BPUiW
 ************************************************************************/
u32 InputTextWindow::InputData( u32 initialValue )
{
	return GenericInputData( initialValue, 8, 16 );
}

/************************************************************************
f[^͂܂BPUiS
 ************************************************************************/
u16 InputTextWindow::InputData16( u16 initialValue )
{
	return (u16)GenericInputData( (u32)initialValue, 4, 16 );
}

/************************************************************************
f[^͂܂BPUi  Q
 ************************************************************************/
u8 InputTextWindow::InputData8( u8 initialValue )
{
	return (u8)GenericInputData( (u32)initialValue, 2, 16 );
}

/************************************************************************
f[^͂܂BPOiS
 ************************************************************************/
u32 InputTextWindow::InputDecimal( u32 initialValue )
{
	return GenericInputData( (u32)initialValue, 4, 10 );
}

/************************************************************************
f[^͂܂BPOiT
 ************************************************************************/
u32 InputTextWindow::InputDecimal5( u32 initialValue )
{
	return GenericInputData( (u32)initialValue, 5, 10 );
}

/************************************************************************
f[^͂܂B0-9A-Z 3
 ************************************************************************/
u32 InputTextWindow::InputAscii3( u32 initialValue )
{
	return GenericInputData( (u32)initialValue, 3, 36 );
}

/************************************************************************
f[^͂܂Bėp
 ************************************************************************/
u32 InputTextWindow::GenericInputData( u32 initialValue, int numDigits, int carryValue )
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

	BreakUpValue *breakUpValue= new BreakUpValue( initialValue, numDigits, carryValue );

	const char *str;
	u32 returnValue;

	Point cursor=Getxy();

    //f[^ύXpC[v
    do {
        //pbhXV
        pad.UpdatePad();

		//Rg[͂ɑΉ鏈
		if( pad.IsButtonRepeat( Pad::BUTTON_LEFT ) ){	breakUpValue->MoveDigitLeft();      	}
		if( pad.IsButtonRepeat( Pad::BUTTON_RIGHT) ){ 	breakUpValue->MoveDigitRight();	        }
		if( pad.IsButtonRepeat( Pad::BUTTON_UP   ) ){	breakUpValue->IncrementCurrentDigit();	}
		if( pad.IsButtonRepeat( Pad::BUTTON_DOWN ) ){	breakUpValue->DecrementCurrentDigit();	}

		//f[^\
		str = breakUpValue->ToString();

		Gotoxy(cursor.x,cursor.y);
		for( int i=0 ; i<numDigits ; i++ ){
	    	SetTextColor( ( i == breakUpValue->GetCurrentDigit() )?CURSOR_COLOR:STRING_COLOR );
			Printf( "%c", str[i] );
		}

		//EChE
		this->m_WindowManager.Update();
        this->m_WindowManager.UpdatePad(pad);        

        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();
        this->m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
        // ʕ`        
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        this->m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 

    } while( !pad.IsButtonRepeat( Pad::BUTTON_A ) && !pad.IsButtonRepeat( Pad::BUTTON_B ) );

	//XVELZ̏
	returnValue=( pad.IsButtonRepeat( Pad::BUTTON_A ) )?breakUpValue->Get():initialValue;
    
    //mf[^\
    breakUpValue->Set(returnValue);
	Gotoxy(cursor.x,cursor.y);
	SetTextColor( STRING_COLOR );
 	Printf( "%s", str );

    //gKNA            
    pad.ClearTriggerFlag();            

	delete breakUpValue;
    return returnValue;

}

/************************************************************************
f[^͂܂Bannkl
 ************************************************************************/
bool InputTextWindow::InputBool( bool initialValue ){

    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

	bool value;

	value = initialValue;
	Point cursor=Getxy();

	//f[^ύXpC[v
    do {
        //pbhXV
        pad.UpdatePad();

        //Rg[͂ɑΉ鏈
		if( pad.IsButtonRepeat( Pad::BUTTON_UP ) || pad.IsButtonRepeat( Pad::BUTTON_DOWN )	){
			value = !value;
		}

		//f[^\
		SetTextColor( CURSOR_COLOR );
		Gotoxy( cursor.x,cursor.y);
		Printf("%c", (value)?'O':'X' );

		//EChE
		this->m_WindowManager.Update();
        this->m_WindowManager.UpdatePad(pad);        

        // ʕ`
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);    
        gfx->m_DrawFramework->Clear();
        this->m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
        // ʕ`        
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();
        this->m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);                 
		
    } while( !pad.IsButtonRepeat( Pad::BUTTON_A ) && !pad.IsButtonRepeat( Pad::BUTTON_B ) );

	//XVELZ̏
	value=( pad.IsButtonRepeat( Pad::BUTTON_A ) )?value:initialValue;
    
    //mf[^\
	SetTextColor( STRING_COLOR );
	Gotoxy(cursor.x, cursor.y);
	Printf("%c", (value)?'O':'X' );
    
    //gKNA            
    pad.ClearTriggerFlag();            
    return value;
}









