/************************************************************************

hmht@C[hĂl`oNX
Z[u\B 

 *************************************************************************/
#include <string.h>
#include <map>
#include <nn.h>
#include <nn/fs.h>
#include <nn/Result.h>
#include "sys.h"
#include "sys_IniFile.h"

using namespace uji::sys;
static void Parse( char *src, char *dst );

/************************************************************************
L[w肵Č܂B
}b`Ȃꍇ͍ŌCe[^idmcjԂ܂B
************************************************************************/
std::vector<IniFile::Element>::iterator IniFile::Find( const char *key )
{
	std::vector<IniFile::Element>::iterator it = m_IniVector.begin();
	while( it != m_IniVector.end() )
	{
		if( strncmp( it->m_Key, key, sizeof(it->m_Key) )==0 ) break;
		it++;
	}

	return it;	//Ȃ΁AdmcԂ
}

/************************************************************************
l`oɗvfǉ܂B
łɃL[݂ꍇ͏㏑
************************************************************************/
void IniFile::Add( const char *key, const char *value )
{
	//z̃L[T
	std::vector<IniFile::Element>::iterator it = Find(key);
	if( it != m_IniVector.end() )
	{
		//㏑
		strncpy( it->m_Value, value, sizeof(it->m_Value ) );
	}else{
		//ǉ
		m_IniVector.push_back( IniFile::Element( key, value) );
	}
}
void IniFile::Add( const char *key, int value )
{
	char str[0x10];
	sprintf( str, "%d", value );
	Add( key, str );
}

/************************************************************************
L[w肵Ēl擾܂B
************************************************************************/
void IniFile::Get( const char *key, char *value )
{
	std::vector<IniFile::Element>::iterator it = Find(key);
	
	if( it != m_IniVector.end() )
	{
		strncpy( value, it->m_Value, sizeof(it->m_Value ) );
	}
}

/************************************************************************
L[w肵Ăhmsl擾܂B
ǂݎ莸s͂OԂ܂
************************************************************************/
int IniFile::GetInteger( const char *key )
{

	char *value = new char[IniFile::Element::MAX_VALUE_SIZE];
	int retValue;

	Get( key, value );

	if( sscanf( value, "%d", &retValue )==EOF )
	{
		retValue=0;
	}

	delete[] value;
	return retValue;
}

/************************************************************************
t@CL[ƒl擾܂B
t@Cǂݏos͂OԂ܂

t@C͂hmh`ŁAӂL[AEӂlƂ܂
************************************************************************/
bool IniFile::Load( const wchar_t *fileName )
{
	const char *SEPARATOR="\r\n";

	nn::fs::FileReader file;
	nn::Result result;
	result = file.TryInitialize( fileName );
	if( result.IsFailure()  ) return false;

	size_t size = file.GetSize();
	char *key	= new char[IniFile::Element::MAX_KEY_SIZE];
	char *value = new char[IniFile::Element::MAX_VALUE_SIZE];
	char *loadBuffer   = new char[size+1];
	char *parsedBuffer = new char[size+1];
	file.Read( loadBuffer, size);
	loadBuffer[size]='\0';	//I[t^

	Parse( loadBuffer, parsedBuffer );	//p[X

	char *subString = strtok( parsedBuffer, SEPARATOR );
	while( subString )
	{
		if( sscanf( subString, "%s %s", key, value )!=EOF )
		{
			Add( key, value );
		}
		subString=strtok( NULL, SEPARATOR );
	}

	delete[] parsedBuffer;
	delete[] loadBuffer;
	delete[] value;
	delete[] key;
	file.Finalize();

	return true;
}
/************************************************************************
hmh̃eLXgt@Crrb`meŎ擾ł悤ȃtH[}bgɃp[X܂B
************************************************************************/
static void Parse( char *src, char *dst )
{

	int i;
	const char *SEPARATOR="\n";
	const char COMMENT_LETTER = ';';
	const char COMMENT_LETTER_ALT = '#';

	char *parsedPointer = dst;
	char *subString = strtok( src, SEPARATOR );
	while( subString )
	{
		//sR[h݂̑ȂsI('\n'ŕĂ̂'\r'͎cĂ)
		if( strchr( subString, '\r')==NULL )
		{
			*parsedPointer='\0';
			return;
		}


		//Rg̍폜ƕsvȋ󔒍폜A󔒂ɕϊ
		for( i=0 ; subString[i]!='\r' ;i++ )
		{
			if( subString[i]==COMMENT_LETTER || subString[i]==COMMENT_LETTER_ALT ) break;
			if( subString[i]!=' ' && subString[i]!='\t' )
			{
				if( subString[i]!='=' )
				{
					*parsedPointer++ = subString[i];
				}else{
					*parsedPointer++ = ' ';
				}

			}
		}

		//擪łȂꍇ͉sR[ht^
		if(i!=0)
		{
			*parsedPointer++='\r';
			*parsedPointer++='\n';
		}

		subString=strtok( NULL, SEPARATOR );
	}
	*parsedPointer='\0';

}
/************************************************************************
t@CɃZ[u܂B
t@Cݎs͂OԂ܂

t@C͂hmh`ŁAӂL[AEӂlƂ܂
************************************************************************/
bool IniFile::Save( const wchar_t *fileName )
{

	//t@CI[v
	nn::fs::FileOutputStream file;
	nn::Result result;
	result = file.TryInitialize( fileName, true );
	if( result.IsFailure()  )  return false;

	//[]=[E]\r\n ̃obt@m
	char *buffer = new char[IniFile::Element::MAX_KEY_SIZE+IniFile::Element::MAX_VALUE_SIZE+3];
	size_t length;

	//
	std::vector<IniFile::Element>::iterator it = m_IniVector.begin();
	while( it != m_IniVector.end() )
	{
		sprintf( buffer, "%s=%s\r\n", it->m_Key, it->m_Value );
		length = strlen(buffer);

		if( file.Write( buffer, length )!=length )
		{
			file.Finalize();
			delete[] buffer;
			return false;
		}
		it++;
	}

	file.Finalize();
	delete[] buffer;
	return true;
}
