/*--------------------------------------------------------------------------*
 Project:
 File: sys_Graphics.c
 

*--------------------------------------------------------------------------*/
#ifndef _UJI_SYS_GRAPHICS_H_
#define _UJI_SYS_GRAPHICS_H_

#include <nn/gx.h>
#include <nn/math.h>
#include <nn/font.h>    
#include <nw/ut/ut_Color.h>
#include <nn/fs.h>
#include <nw/demo/demo_Utility.h>
    
#include "demo.h"     
#include "demo_RenderSystemUji.h"
#include "sys_Memory.h"    
#include "sys_App.h"

namespace internal_uji {
  
enum
{
    POS_X,
    POS_Y,
    POS_Z,
    POS_W,

    POS_NUM
};
    
enum 
{
    COLOR_R,
    COLOR_G,
    COLOR_B,
    COLOR_A,

    COLOR_NUM  
};

}   // namespace internal_uji


namespace nw {
namespace font {
class Font;
}   // namespace font
}   // namespace nw


namespace uji { 
namespace sys {

enum
{
    VTXATTR_POSITION  = 0,
    VTXATTR_COLOR,
    VTXATTR_TEXCOORD0
};


class GraphicsDrawing
{
public:
    // ʂ̃TCY̒萔łB
    enum DisplaySize
    {
        DISPLAY0_WIDTH  = 400,  // 0̕łB
        DISPLAY0_HEIGHT = 240,  // 0̍łB
        DISPLAY1_WIDTH  = 320,  // 1̕łB
        DISPLAY1_HEIGHT = 240   // 1̍łB
    };    
    
    static GraphicsDrawing* GetInstance()
    {
        if (m_pInstance == 0)
        {
            m_pInstance = new GraphicsDrawing;
        }
        return m_pInstance;
    }    
    
    int Initialize();
    
    // \[X̔j
    int Finalize();  
    
    void ReInitRenderSystem()
    {
        uji::sys::SysApp* sysApp = uji::sys::SysApp::GetInstance();

        m_DrawFramework->Finalize();
        //uji::sys::Free(reinterpret_cast<void*>(m_FcramAddress));
        sysApp->Free(m_pShapeShader);
        
        //m_FcramAddress = reinterpret_cast<uptr>(uji::sys::AllocDeviceMemory(GRAPHICS_MEMORY_SIZE, 4));
        m_DrawFramework->Initialize(m_FcramAddress, GRAPHICS_MEMORY_SIZE);
        nngxCmdlistStorage(0x200000, 128);
    
        m_ShapePgID = glCreateProgram();
        m_ShapeShID = glCreateShader(GL_VERTEX_SHADER);

        // t@CVXeɂVF[_oCi̓ǂݍ
        nn::fs::FileReader shaderReader(L"rom:/sys/shader.shbin");
        size_t size = shaderReader.GetSize();
        m_pShapeShader = sysApp->AllocateDeviceMemory(size);
        s32 read = shaderReader.Read(m_pShapeShader, size);
        NN_ASSERT(read == size);
        glShaderBinary(1, &m_ShapeShID, GL_PLATFORM_BINARY_DMP, m_pShapeShader, read);

        glAttachShader(m_ShapePgID, m_ShapeShID);
        glAttachShader(m_ShapePgID, GL_DMP_FRAGMENT_SHADER_DMP);

        glBindAttribLocation(m_ShapePgID, 0, "aPosition");
        glBindAttribLocation(m_ShapePgID, 1, "aColor");

        glLinkProgram(m_ShapePgID);
        glValidateProgram(m_ShapePgID); 
        glUseProgram(m_ShapePgID);

        glClearDepthf(1.f);
        m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
            DEFAULT_CLEAR_COLOR_RED, 
            DEFAULT_CLEAR_COLOR_GREEN, 
            DEFAULT_CLEAR_COLOR_BLUE, 
            DEFAULT_CLEAR_COLOR_ALPHA);
        m_DrawFramework->SetClearColor(NN_GX_DISPLAY1,
            DEFAULT_CLEAR_COLOR_RED, 
            DEFAULT_CLEAR_COLOR_GREEN, 
            DEFAULT_CLEAR_COLOR_BLUE, 
            DEFAULT_CLEAR_COLOR_ALPHA);
        
        glDisable(GL_CULL_FACE);
        glDisable(GL_DEPTH_TEST);
        glDisable(GL_STENCIL_TEST);
        
        // tHg̍\z
        //bool bSuccess = InitFont(NW_DEMO_FILE_PATH(L"sys/ipa.bcfnt"));
        //NN_ASSERTMSG(bSuccess, "Fail to load ResFont.");
        InitFontShaders();       

        m_TextWriter.SetFont(&m_Font);    

    }
    
    // XN[TCY̐ݒ
    void SetScreenSize(s32 width, s32 height)
    {
        m_ScreenSize = nn::math::VEC2(static_cast<f32>(width), static_cast<f32>(height));
    }

#ifndef EVA_ENABLE_GPUTEST
    static const size_t GRAPHICS_MEMORY_SIZE = 0x800000; // 8MB
#else
    static const size_t GRAPHICS_MEMORY_SIZE = 0x2900000; // 41MB
#endif
    
    // ftHgNAJ[
    static const f32 DEFAULT_CLEAR_COLOR_RED;
    static const f32 DEFAULT_CLEAR_COLOR_GREEN;
    static const f32 DEFAULT_CLEAR_COLOR_BLUE;
    static const f32 DEFAULT_CLEAR_COLOR_ALPHA;            

public:    
    /* ------------------------------------------------------------------------
            VFCv`
    ------------------------------------------------------------------------ */    
    // VFCv`̏
    void BeginDrawingShape();

    // `̘g`
    void DrawRectangle(s32 posh, s32 posv, s32 sizeh, s32 sizev)
    { 
        this->DrawRectangle( 
            nn::math::VEC2(static_cast<f32>(posh), static_cast<f32>(posv)), 
            nn::math::VEC2(static_cast<f32>(sizeh), static_cast<f32>(sizev))
        );
    }
    void DrawRectangle(const nn::math::VEC2& pos, const nn::math::VEC2& size);

    // 1hbg̒`̘g`
    void DrawWidth1Rectangle(s32 posh, s32 posv, s32 sizeh, s32 sizev)
    { 
        this->DrawWidth1Rectangle( 
            nn::math::VEC2(static_cast<f32>(posh), static_cast<f32>(posv)), 
            nn::math::VEC2(static_cast<f32>(sizeh), static_cast<f32>(sizev))
        ); 
    }
    void DrawWidth1Rectangle(const nn::math::VEC2& pos, const nn::math::VEC2& size);

    // ``
    void FillRectangle(f32 x, f32 y, f32 width, f32 height)
    {
        this->FillRectangle(
            nn::math::VEC2(static_cast<f32>(x), static_cast<f32>(y)), 
            nn::math::VEC2(static_cast<f32>(width), static_cast<f32>(height))
        );
    }
    void FillRectangle(const nn::math::VEC2& pos, const nn::math::VEC2& size);
        
    // C`
    void DrawLine(s32 x1, s32 y1, s32 x2, s32 y2)
    { 
        this->DrawLine( 
            nn::math::VEC2(static_cast<f32>(x1), static_cast<f32>(y1)), 
            nn::math::VEC2(static_cast<f32>(x2), static_cast<f32>(y2))
         );        
    }
    void DrawLine(const nn::math::VEC2& p1, const nn::math::VEC2& p2);
    void SetLineWidth(f32 width) { m_LineWidth = width; }    
    
    // _J[ݒ
    void SetColor(const nw::ut::Color8 color)
    {
        this->SetColor(color, color, color, color);
    }
    void SetColor(const nw::ut::Color8& color1, const nw::ut::Color8& color2,
                  const nw::ut::Color8& color3, const nw::ut::Color8& color4);

    // [xl
    void SetDepth2d(const f32& depth2d);

public:        
    /* ------------------------------------------------------------------------
            tHg`
    ------------------------------------------------------------------------ */
    void* InitFontShaders();
    bool InitFont(const wchar_t* filePath);
    nn::font::DispStringBuffer* AllocDispStringBuffer(int charMax);   
    void BeginDrawingString() { this->BeginDrawingString(m_pDrawStringBuf); }
    void BeginDrawingString(nn::font::DispStringBuffer* pDrawStringBuf);
    
    void EndDrawingString();  
    void CleanupFont(nn::font::ResFont* font);
    void SetFixedWidthFont(f32 height);    
    void InitDrawingString(int width, int height);
    void InitDrawingString() { this->InitDrawingString(m_ScreenSize.x, m_ScreenSize.y); };

    /* ------------------------------------------------------------------------
            MISC
    ------------------------------------------------------------------------ */
    void NN_LOG_CmdBufUsedSize();

    nn::font::ResFont m_Font;
    nn::font::TextWriter m_TextWriter;
    nn::font::RectDrawer m_RectDrawer;
    nn::font::DispStringBuffer* m_pDrawStringBuf;

    demo::RenderSystemUji* m_DrawFramework;

protected:
    f32 m_Depth2d;

private:
    
    void SetupTexEnv();    
    void SendMatrix();
    
    s32 BuildTriangle( const nn::math::VEC4& pt1, const nn::math::VEC4& pt2, const nn::math::VEC4& pt3, nn::math::VEC4 *pVecArray);
    s32 BuildSquare( 
        const nn::math::VEC4& pt1, 
        const nn::math::VEC4& pt2, 
        const nn::math::VEC4& pt3, 
        const nn::math::VEC4& pt4, 
        nn::math::VEC4 *pVecArray );
    s32 BuildLine(const nn::math::VEC4& pt1, const nn::math::VEC4& pt2, nn::math::VEC4 *pVecArray);

    void SendFontMatrix();

    enum 
    {
        VERTEX_STREAM_SIZE = 16
    };

    nn::math::VEC4 m_PositionStream[VERTEX_STREAM_SIZE];
    nw::ut::FloatColor m_ColorStream[VERTEX_STREAM_SIZE];
    
    f32             m_LineWidth;
    nn::math::VEC2  m_ScreenSize;
    
    // program id
    GLuint m_ShapePgID;

    // shader id
    GLuint m_ShapeShID;

    void* m_pShapeShader;

private:
    // RXgN^
    // pꍇGetInstance()͎g܂B
    GraphicsDrawing() 
      : m_Depth2d(0.0f), m_LineWidth(1.0f),
        m_ScreenSize( f32(400), f32(240) )
        
    {
        if (m_pInstance != NULL)
        {
            NN_TPANIC_("uji::sys::GraphicsDrawing instance already exists.");
        }
        m_pInstance = this;
        m_DrawFramework = new demo::RenderSystemUji;   
    }
    
    uptr m_FcramAddress;
    
    //! VOgIuWFNgւ̃|C^łB
    static GraphicsDrawing* m_pInstance;    
};
  
}   // namespace sys
}   // namespace uji


/* _UJI_SYS_GRAPHICS_H_ */
#endif

