/*---------------------------------------------------------------------------*
  Project:  CTR_TRIAL
  File:     sys_GetRegionCode.cpp

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#include "sys_GetRegionCode.h"
#include <nn/cfg/CTR/cfg_ApiInit.h>

using namespace nn::cfg::CTR::detail;
using namespace nn::cfg::CTR::init;

// [WR[hԂ
nn::cfg::CTR::CfgRegionCode  uji::sys::GetRegionCode(void)
{
    nn::Result r;
    nn::cfg::CTR::detail::SecureInfoBody sib;

    r = GetSecureInfoBody(&sib);
    if ( r.IsFailure())
    {
        NN_LOG("GetSecureInfoBody failed.\n");
        nn::dbg::PrintResult(r);
        return nn::cfg::CTR::CFG_REGION_MAX;
    }

    return sib.region;
}

// SerNo2ڂ݂āAY郊[WR[hԂ
nn::cfg::CTR::CfgRegionCode  uji::sys::SerialNumberToRegionCode(u8 arg)
{
    switch(arg)
    {
        case 'A' : return nn::cfg::CTR::CFG_REGION_EUROPE; //B(CFG_REGION_AUSTRALIA͌)
        case 'B' : return nn::cfg::CTR::CFG_REGION_AMERICA;//uW
        case 'C' : return nn::cfg::CTR::CFG_REGION_CHINA;
        case 'E' : return nn::cfg::CTR::CFG_REGION_EUROPE;
        case 'G' : return nn::cfg::CTR::CFG_REGION_AMERICA;//ASI,MDE(FTRp)
        case 'J' : return nn::cfg::CTR::CFG_REGION_JAPAN;
        case 'K' : return nn::cfg::CTR::CFG_REGION_KOREA;
        case 'S' : return nn::cfg::CTR::CFG_REGION_AMERICA;//ASI,LT2,MDE
        case 'T' : return nn::cfg::CTR::CFG_REGION_TAIWAN;
        case 'U' : return nn::cfg::CTR::CFG_REGION_EUROPE; //UKV
        case 'W' : return nn::cfg::CTR::CFG_REGION_AMERICA;
        default  : return nn::cfg::CTR::CFG_REGION_JAPAN;
    }
}

