/*---------------------------------------------------------------------------*
  Project:  CTR_TRIAL
  File:     sys_GetPlatform.cpp

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#include "sys_GetPlatform.h"
#include "sys_Panic.h"

using namespace nn::cfg::CTR;
using namespace uji::sys;

static PlatformType g_PlatformType;

uji::sys::PlatformType uji::sys::GetPlatformType()
{
    return g_PlatformType;
}

void uji::sys::SetPlatformType()
{
#if (NN_VERSION_MAJOR >= 3)
    TargetModel model;
    nn::Result nnr = init::GetRunningTargetModel(&model);
    
    if( nnr.IsFailure())
    {
        #ifndef EVA_START_MENU
        // StartMenu̎̂݁A{̏񂪐擾łȂĂNB
        SYS_PANIC("Get TargetModel Failure");
        return;
        #endif
    }
    switch( model )
    {
    case TARGET_MODEL_CTR:          g_PlatformType = PLATFORM_CTR;       return;
    case TARGET_MODEL_SPR:          g_PlatformType = PLATFORM_SPR;       return;
    case TARGET_MODEL_RESERVE_2:    g_PlatformType = PLATFORM_KTR;       return;
    case TARGET_MODEL_RESERVE_3:    g_PlatformType = PLATFORM_FTR;       return;
    default:                        g_PlatformType = PLATFORM_UNKNOWN;   return;
    }
#else
    g_PlatformType = uji::sys::PLATFORM_CTR;
    return;
#endif

}

