/*--------------------------------------------------------------------------*
}bNAhX擾
*--------------------------------------------------------------------------*/
#include <nn.h>
#include <nn/nwm/CTR/nwm_API.h>
#include <nn/nwm/nwm_Mac.h>
#include "sys.h"
#include "sys_GetMacAddress.h"

/************************************************************************
ʏ̕\
 ************************************************************************/
static bool s_HasRead = false;
static bit8 s_MacAddress[ nn::uds::MAC_ADDRESS_SIZE ];

void uji::sys::GetMacAddress( bit8 mac[nn::uds::MAC_ADDRESS_SIZE] )
{
    if( !TryGetMacAddress( mac ))
    {
        SYS_PANIC( "Fail to Get MAC Address" );
    }
}


bool uji::sys::GetMacAddressStr(char * buff)
{
    if ( NULL == buff )
    {
        return false;
    }
    
    bit8 mac[ nn::uds::MAC_ADDRESS_SIZE ];
    if( !uji::sys::TryGetMacAddress( mac ) )
    {
        return false;
    }

    char         macAddressStr[12+1];
    std::memset(macAddressStr, 0x00, sizeof(macAddressStr));
    std::sprintf(macAddressStr, "%02X%02X%02X%02X%02X%02X", mac[0],
                                                            mac[1],
                                                            mac[2],
                                                            mac[3],
                                                            mac[4],
                                                            mac[5]);


    std::strncpy(buff, macAddressStr, 12+1);
    return true;
}

bool uji::sys::TryGetMacAddress( bit8 mac[nn::uds::MAC_ADDRESS_SIZE] )
{
    nn::Result result;
    nn::nwm::Mac macAddressClass;
    
    if( false == s_HasRead )
    {
        result = nn::nwm::CTR::GetMacAddress( macAddressClass );
        if( result.IsFailure() )
        {
            return false;
        }

        macAddressClass.Get( s_MacAddress );
        s_HasRead = true;
    }
    
    //Rs[
    for( int i=0 ; i<nn::uds::MAC_ADDRESS_SIZE ; i++ )
    {
        mac[i]=s_MacAddress[i];
    }
    return true;
}
