/************************************************************************

alot@C[hăeNX`NX

 *************************************************************************/

/* dCN[h̉ */
#ifndef SYS_LOADBMP_H_INCLUDED
#define SYS_LOADBMP_H_INCLUDED

namespace uji{
namespace sys{

/************************************************************************
 ************************************************************************/
class BmpTexture
{
public:
    BmpTexture():m_BmpDataPointer(0), m_TextureDataPointer(0)
    {
        sysApp = uji::sys::SysApp::GetInstance();
    }
    ~BmpTexture(){}

    bool Open( const wchar_t *fileName );
    void Close(void);

    u32 GetBmpWidth(void) const { return m_BmpWidth; }
    u32 GetBmpHeight(void) const { return m_BmpHeight; }
    u32 GetTextureWidth(void) const { return m_TextureWidth; }
    u32 GetTextureHeight(void) const { return m_TextureHeight; }
    u8 *GetTextureDataPointer(void) const { return m_TextureDataPointer; }

    bool FakeLoad( u8 * bmp_data);

    static const GLenum INTERNAL_FORMAT = GL_RGB_NATIVE_DMP;
    static const GLenum FORMAT = GL_RGB_NATIVE_DMP;
    static const GLenum TYPE = GL_UNSIGNED_BYTE;


    bool Save( const wchar_t *fileName, u32 width, u32 height, u8 *textureData, u8 *yuvData=NULL );
    void ConvertTextureToBmp( u8 *bmpData, u8 *textureData, u32 width, u32 height );
private:
    u32 m_BmpWidth;
    u32 m_BmpHeight;
    u32 m_TextureWidth;
    u32 m_TextureHeight;
    u8 *m_BmpDataPointer;
    u8 *m_TextureDataPointer;
    void GetBmpFileData( u8* rawDataBuffer );
    void GetTextureDataFromBmpFileData( void );

    void SetSize( u32 width, u32 height );
    void SetTextureDataPointer( u8 *ptr ){ m_TextureDataPointer=ptr; }
    void GetBmpFileDataFromTextureData( void );

    uji::sys::SysApp *sysApp;
};

struct BitmapInfoHeader
{
    BitmapInfoHeader(){}
    BitmapInfoHeader( u32 width, u32 height )
    {
        biSize          = 40;
        biWidth         = width;
        biHeight        = height;
        biPlanes        = 1;
        biBitCount      = 24;       //qfaQS
        biCompression   = 0;        //k
        biSizeImage     = width*height*3;
        biXPixPerMeter  = 0;
        biYPixPerMeter  = 0;
        biClrUsed       = 0;
        biClrImportant  = 0;
    }


    u32 biSize;
    s32 biWidth;
    s32 biHeight;
    u16 biPlanes;
    u16 biBitCount;
    u32 biCompression;
    u32 biSizeImage;
    s32 biXPixPerMeter;
    s32 biYPixPerMeter;
    u32 biClrUsed;
    u32 biClrImportant;
};

struct BitmapFileHeader
{
    BitmapFileHeader(){}
    BitmapFileHeader( u32 width, u32 height )
    {
        bfType[0]   =0x42;
        bfType[1]   =0x4d;
        u32 size    =sizeof(BitmapFileHeader) + sizeof(BitmapInfoHeader) + width * height *3;
        bfSize[0]   = size&0xffff;
        bfSize[1]   =(size>>8)&0xffff;
        bfReserved1 =0;
        bfReserved2 =0;
        bfOffBits[0]=sizeof(BitmapFileHeader) + sizeof(BitmapInfoHeader );
        bfOffBits[1]=0;
    }

    u8 bfType[2];
    u16 bfSize[2];  //ACg΍
    u16 bfReserved1;
    u16 bfReserved2;
    u16 bfOffBits[2];
};


u32 GetTextureLength(const u32 imageLength);

} // namespace sys
} // namespace uji

/* dCN[h̉ */
#endif
