/************************************************************************

alot@C[hăeNX`NX

 *************************************************************************/
#include <nn.h>
#include <nn/fs.h>
#include "sys.h"
#include "sys_BmpTexture.h"

using namespace uji::sys;

const GLenum BmpTexture::INTERNAL_FORMAT;
const GLenum BmpTexture::FORMAT;
const GLenum BmpTexture::TYPE;

//alot@ĈQSrbg`
struct Rgb888
{
    u8 b;
    u8 g;
    u8 r;
};

static Rgb888 Rgb565ToRgb888( u16 rgb565 );

/************************************************************************
 alot@CI[văeNX`f[^ɂ܂B
 ************************************************************************/
bool BmpTexture::Open( const wchar_t *fileName )
{
    nn::fs::FileReader file;
    nn::Result nnResult;

    //t@Cǂݏo܂B
    NN_LOG("\nReading data from ROMFS...\n");
    nnResult = file.TryInitialize( fileName );
    if( nnResult.IsFailure() ) return false;

    size_t fileSize = file.GetSize();
    NN_LOG("  fileSize = %d (Byte)\n", fileSize);
    if ( fileSize == 0 )
    {
        NN_LOG("Failed to open File.\n");
        return false;
    }

    void* buf = sysApp->Allocate(fileSize);

    s32 readSize = file.Read(buf, fileSize);
    NN_LOG("  readSize = %d (Byte)\n", readSize);
    if ( readSize == 0 )
    {
        NN_LOG("Failed to open bmpRomFilename.\n");
        return false;
    }

    //alot@CTCYƃf[^擪ԒnvZ
    GetBmpFileData( (u8*)buf );
    NN_LOG("  bmpWidth = %d, bmpHeight = %d\n", m_BmpWidth, m_BmpHeight);
    m_TextureWidth =  GetTextureLength( m_BmpWidth );
    m_TextureHeight = GetTextureLength( m_BmpHeight );
    NN_LOG("  textureWidth = %d, textureHeight = %d\n", m_TextureWidth, m_TextureHeight);

    //m
    m_TextureDataPointer = static_cast<u8*>(sysApp->Allocate(3 * m_TextureWidth * m_TextureHeight ));

    //alot@C̃f[^eNX`f[^ɃRo[g
    GetTextureDataFromBmpFileData();

    sysApp->Free(buf);
    file.Finalize();

    return true;
}

/************************************************************************
 alof[^[hāAoϐɏo^܂
 ************************************************************************/
bool BmpTexture::FakeLoad( u8 * bmp_data)
{
    //alot@CTCYƃf[^擪ԒnvZ
    GetBmpFileData( bmp_data );
    NN_LOG("  bmpWidth = %d, bmpHeight = %d\n", m_BmpWidth, m_BmpHeight);
    m_TextureWidth =  GetTextureLength( m_BmpWidth );
    m_TextureHeight = GetTextureLength( m_BmpHeight );
    NN_LOG("  textureWidth = %d, textureHeight = %d\n", m_TextureWidth, m_TextureHeight);

    return true;
}


/************************************************************************
[hɎgpJ܂B
 ************************************************************************/
void BmpTexture::Close(void)
{
    sysApp->Free( m_TextureDataPointer );
}


/************************************************************************
alot@Co܂
 ************************************************************************/
void BmpTexture::GetBmpFileData( u8* rawDataBuffer )
{
    BitmapInfoHeader* bmp_info_header_ptr = (BitmapInfoHeader*)(rawDataBuffer + sizeof(BitmapFileHeader));
    m_BmpWidth          = bmp_info_header_ptr->biWidth;
    m_BmpHeight         = bmp_info_header_ptr->biHeight;
    m_BmpDataPointer    = rawDataBuffer + sizeof(BitmapFileHeader) + sizeof(BitmapInfoHeader);
    return;
}

/************************************************************************
aloTCYݒ肵܂
 ************************************************************************/
void BmpTexture::SetSize( u32 width, u32 height )
{
    m_BmpWidth = width;
    m_BmpHeight = height;
    m_TextureWidth =  GetTextureLength( m_BmpWidth );
    m_TextureHeight = GetTextureLength( m_BmpHeight );
}

/************************************************************************
alof[^eNX`f[^擾܂
 ************************************************************************/
void BmpTexture::GetTextureDataFromBmpFileData( void )
{
    u8 *textureGLDataBuffer = static_cast<u8*>( sysApp->Allocate( 3 * m_TextureWidth * m_TextureHeight ) );

    // Convert BMP to OpenGL RGB format
    for (u32 y = 0; y < m_TextureHeight; y++ )
    {
        for (u32 x = 0; x < m_TextureWidth; x++)
        {
            if ( x<m_BmpWidth && y<m_BmpHeight )
            {
                u8 *bmpDataPtr     = m_BmpDataPointer    + 3 * (m_BmpWidth    * y + x);
//                u8 *bmpDataPtr     = m_BmpDataPointer    + 3 * (m_BmpWidth    * (m_BmpHeight - y -1) + x);
                u8 *textureDataPtr = textureGLDataBuffer + 3 * (m_TextureWidth* y + x);

                *textureDataPtr     = *(bmpDataPtr + 2);
                *(textureDataPtr+1) = *(bmpDataPtr + 1);
                *(textureDataPtr+2) = *(bmpDataPtr    );
            }
        }
    }

    // Convert OpenGL RGB format to PICA Native RGB format
    bool result = demo::ConvertGLTextureToNative(
        FORMAT, m_TextureWidth, m_TextureHeight,
        textureGLDataBuffer, m_TextureDataPointer );
    if ( result )
    {
        NN_LOG("  Convert to GL_RGB_NATIVE_DMP succeeded.\n");
    }
    else
    {
        NN_LOG("  Convert to GL_RGB_NATIVE_DMP failed.\n");
        NN_ASSERT(0);
    }

    sysApp->Free( textureGLDataBuffer );

}

/************************************************************************
eNX`f[^alo`ŃZ[u܂B

YuvDataɂmtkkȊOw肷ƁAalo̍Ōɂxtuf[^ǉ܂B

FSWriteR}hs(0.9.1CardSPI)
@΍R[hĂ܂II

 ************************************************************************/
bool  BmpTexture::Save( const wchar_t *fileName, u32 width, u32 height, u8 *textureData, u8 *yuvData )
{
    nn::fs::FileOutputStream ofile;
    nn::Result result;
    bool retValue;
    int i;

    //aloꎞۑpm
    SetSize( width, height );
    BitmapFileHeader *bmpFileHeader = new BitmapFileHeader( m_BmpWidth, m_BmpHeight );
    BitmapInfoHeader *bmpInfoHeader = new BitmapInfoHeader( m_BmpWidth, m_BmpHeight );
    m_BmpDataPointer = static_cast<u8*>( sysApp->Allocate( 3 * m_BmpWidth * m_BmpHeight ) );

    //eNX`f[^Ro[g
    ConvertTextureToBmp( m_BmpDataPointer, textureData, m_BmpWidth, m_BmpHeight );

    //t@CC[Wpobt@
    u32 fileSize= 14 + sizeof(BitmapInfoHeader) + ((yuvData)?5:3)*m_BmpWidth*m_BmpHeight;
    u8 *fileImage = static_cast<u8*>( sysApp->Allocate( fileSize ) );
    memcpy( fileImage,                              bmpFileHeader,      14 );
    memcpy( fileImage+14,                           bmpInfoHeader,      sizeof(BitmapInfoHeader) );
    memcpy( fileImage+14+sizeof(BitmapInfoHeader),  m_BmpDataPointer,   m_BmpWidth*m_BmpHeight*3 );
    if( yuvData )
    {
        memcpy( fileImage+14+sizeof(BitmapInfoHeader)+m_BmpWidth*m_BmpHeight*3, yuvData, m_BmpWidth*m_BmpHeight*2 );
    }

    //t@CI[v
    result = ofile.TryInitialize( fileName, true );
    if( result.IsFailure()  )
    {
        retValue=false;
    }else{
        retValue = ( ofile.Write(  fileImage, fileSize ) == fileSize )?true:false;
    }

    //N[Y
    delete bmpFileHeader;
    delete bmpInfoHeader;
    sysApp->Free( fileImage );
    sysApp->Free( m_BmpDataPointer );
    ofile.Finalize();
    return retValue;

}
/************************************************************************
eNX`f[^alo`ŃɃZ[u܂B

alowb_͊܂݂܂B

 ************************************************************************/
void BmpTexture::ConvertTextureToBmp( u8 *bmpData, u8 *textureData, u32 width, u32 height )
{
    m_BmpDataPointer = bmpData;
    SetSize( width, height );
    SetTextureDataPointer( textureData );
    GetBmpFileDataFromTextureData();
}



/************************************************************************
eNX`f[^aloɕϊ܂
 ************************************************************************/
void BmpTexture::GetBmpFileDataFromTextureData( void )
{
    const int BLOCK_SIZE =8;
    const int SUB_BLOCK_QTY = 16;

    const int OFFSET_X[SUB_BLOCK_QTY]={ 0, 2, 0, 2, 4, 6, 4, 6, 0, 2, 0, 2, 4, 6, 4, 6 };
    const int OFFSET_Y[SUB_BLOCK_QTY]={ 0, 0, 2, 2, 0, 0, 2, 2, 4, 4, 6, 6, 4, 4, 6, 6 };

    u16    *src = reinterpret_cast<u16*>(m_TextureDataPointer);
    Rgb888 *dst = reinterpret_cast<Rgb888*>(m_BmpDataPointer);
    u32 offset;

    //܂Aclo|m`shudtH[}bgjAtH[}bgɕϊ
    for( u32 blockY=0 ; blockY<m_TextureHeight ; blockY+=BLOCK_SIZE )
    {
        for( u32 blockX=0 ; blockX<m_TextureWidth ; blockX+=BLOCK_SIZE )
        {

            if( (blockX<m_BmpWidth) && (blockY<m_BmpHeight ) )
            {
                for( int i=0; i<SUB_BLOCK_QTY ; i++ ){
                    dst[ (blockY+OFFSET_Y[i]    ) * m_BmpWidth + blockX+OFFSET_X[i]   ] = Rgb565ToRgb888(*src++);
                    dst[ (blockY+OFFSET_Y[i]    ) * m_BmpWidth + blockX+OFFSET_X[i]+1 ] = Rgb565ToRgb888(*src++);
                    dst[ (blockY+OFFSET_Y[i]+1  ) * m_BmpWidth + blockX+OFFSET_X[i]   ] = Rgb565ToRgb888(*src++);
                    dst[ (blockY+OFFSET_Y[i]+1  ) * m_BmpWidth + blockX+OFFSET_X[i]+1 ] = Rgb565ToRgb888(*src++);
                }

            }else{
                src+=BLOCK_SIZE*BLOCK_SIZE;
            }
        }
    }

    //xtbv
    Rgb888 temp;
    for( int y=0 ; y<m_BmpHeight/2 ; y++ )
    {
        for( int x=0 ; x<m_BmpWidth ; x++ )
        {
            temp = dst[ y*m_BmpWidth + x ];
            dst[ y*m_BmpWidth + x ]      = dst[ (m_BmpHeight-1-y)*m_BmpWidth + x ];
            dst[ (m_BmpHeight-1-y)*m_BmpWidth + x ] = temp;
        }
    }
}

/************************************************************************
C[W̃TCYeNX`̃TCYi8, 16, 32, 64, 128, 256, 512, 1024j擾܂
 ************************************************************************/
u32 uji::sys::GetTextureLength(const u32 imageLength)
{
    u32 textureLength = 8;

    // 8, 16, 32, 64, 128, 256, 512, 1024
    for (u32 i = 0; i < 7; i++)
    {
        if ( imageLength > textureLength )
        {
            textureLength *= 2;
        }
        else
        {
            return textureLength;
        }
    }

    return 1024;
}


/************************************************************************
 qfaTUT̃f[^qfaWWWialot@ĈQSrbg`jɕϊ܂B
 ************************************************************************/
static Rgb888 Rgb565ToRgb888( u16 rgb565 )
{
    Rgb888 ret;

    ret.r = (rgb565>>11 & 0x1f)<<3;
    ret.g = (rgb565>>5  & 0x3f)<<2;
    ret.b = (rgb565     & 0x1f)<<3;

    return ret;
}


